{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gdk.Objects.Display.Display' objects purpose are two fold:
-- 
-- * To manage and provide information about input devices (pointers and keyboards)
-- * To manage and provide information about the available @/GdkScreens/@
-- 
-- 
-- GdkDisplay objects are the GDK representation of an X Display,
-- which can be described as a workstation consisting of
-- a keyboard, a pointing device (such as a mouse) and one or more
-- screens.
-- It is used to open and keep track of various GdkScreen objects
-- currently instantiated by the application. It is also used to
-- access the keyboard(s) and mouse pointer(s) of the display.
-- 
-- Most of the input device handling has been factored out into
-- the separate t'GI.Gdk.Objects.DeviceManager.DeviceManager' object. Every display has a
-- device manager, which you can obtain using
-- 'GI.Gdk.Objects.Display.displayGetDeviceManager'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Display
    ( 

-- * Exported types
    Display(..)                             ,
    IsDisplay                               ,
    toDisplay                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Display#g:method:beep"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gdk.Objects.Display#g:method:close"), [deviceIsGrabbed]("GI.Gdk.Objects.Display#g:method:deviceIsGrabbed"), [flush]("GI.Gdk.Objects.Display#g:method:flush"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gdk.Objects.Display#g:method:hasPending"), [isClosed]("GI.Gdk.Objects.Display#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [keyboardUngrab]("GI.Gdk.Objects.Display#g:method:keyboardUngrab"), [listDevices]("GI.Gdk.Objects.Display#g:method:listDevices"), [listSeats]("GI.Gdk.Objects.Display#g:method:listSeats"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStartupComplete]("GI.Gdk.Objects.Display#g:method:notifyStartupComplete"), [peekEvent]("GI.Gdk.Objects.Display#g:method:peekEvent"), [pointerIsGrabbed]("GI.Gdk.Objects.Display#g:method:pointerIsGrabbed"), [pointerUngrab]("GI.Gdk.Objects.Display#g:method:pointerUngrab"), [putEvent]("GI.Gdk.Objects.Display#g:method:putEvent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [requestSelectionNotification]("GI.Gdk.Objects.Display#g:method:requestSelectionNotification"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [storeClipboard]("GI.Gdk.Objects.Display#g:method:storeClipboard"), [supportsClipboardPersistence]("GI.Gdk.Objects.Display#g:method:supportsClipboardPersistence"), [supportsComposite]("GI.Gdk.Objects.Display#g:method:supportsComposite"), [supportsCursorAlpha]("GI.Gdk.Objects.Display#g:method:supportsCursorAlpha"), [supportsCursorColor]("GI.Gdk.Objects.Display#g:method:supportsCursorColor"), [supportsInputShapes]("GI.Gdk.Objects.Display#g:method:supportsInputShapes"), [supportsSelectionNotification]("GI.Gdk.Objects.Display#g:method:supportsSelectionNotification"), [supportsShapes]("GI.Gdk.Objects.Display#g:method:supportsShapes"), [sync]("GI.Gdk.Objects.Display#g:method:sync"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [warpPointer]("GI.Gdk.Objects.Display#g:method:warpPointer"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAppLaunchContext]("GI.Gdk.Objects.Display#g:method:getAppLaunchContext"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultCursorSize]("GI.Gdk.Objects.Display#g:method:getDefaultCursorSize"), [getDefaultGroup]("GI.Gdk.Objects.Display#g:method:getDefaultGroup"), [getDefaultScreen]("GI.Gdk.Objects.Display#g:method:getDefaultScreen"), [getDefaultSeat]("GI.Gdk.Objects.Display#g:method:getDefaultSeat"), [getDeviceManager]("GI.Gdk.Objects.Display#g:method:getDeviceManager"), [getEvent]("GI.Gdk.Objects.Display#g:method:getEvent"), [getMaximalCursorSize]("GI.Gdk.Objects.Display#g:method:getMaximalCursorSize"), [getMonitor]("GI.Gdk.Objects.Display#g:method:getMonitor"), [getMonitorAtPoint]("GI.Gdk.Objects.Display#g:method:getMonitorAtPoint"), [getMonitorAtWindow]("GI.Gdk.Objects.Display#g:method:getMonitorAtWindow"), [getNMonitors]("GI.Gdk.Objects.Display#g:method:getNMonitors"), [getNScreens]("GI.Gdk.Objects.Display#g:method:getNScreens"), [getName]("GI.Gdk.Objects.Display#g:method:getName"), [getPointer]("GI.Gdk.Objects.Display#g:method:getPointer"), [getPrimaryMonitor]("GI.Gdk.Objects.Display#g:method:getPrimaryMonitor"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScreen]("GI.Gdk.Objects.Display#g:method:getScreen"), [getWindowAtPointer]("GI.Gdk.Objects.Display#g:method:getWindowAtPointer").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDoubleClickDistance]("GI.Gdk.Objects.Display#g:method:setDoubleClickDistance"), [setDoubleClickTime]("GI.Gdk.Objects.Display#g:method:setDoubleClickTime"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDisplayMethod                    ,
#endif

-- ** beep #method:beep#

#if defined(ENABLE_OVERLOADING)
    DisplayBeepMethodInfo                   ,
#endif
    displayBeep                             ,


-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    DisplayCloseMethodInfo                  ,
#endif
    displayClose                            ,


-- ** deviceIsGrabbed #method:deviceIsGrabbed#

#if defined(ENABLE_OVERLOADING)
    DisplayDeviceIsGrabbedMethodInfo        ,
#endif
    displayDeviceIsGrabbed                  ,


-- ** flush #method:flush#

#if defined(ENABLE_OVERLOADING)
    DisplayFlushMethodInfo                  ,
#endif
    displayFlush                            ,


-- ** getAppLaunchContext #method:getAppLaunchContext#

#if defined(ENABLE_OVERLOADING)
    DisplayGetAppLaunchContextMethodInfo    ,
#endif
    displayGetAppLaunchContext              ,


-- ** getDefault #method:getDefault#

    displayGetDefault                       ,


-- ** getDefaultCursorSize #method:getDefaultCursorSize#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDefaultCursorSizeMethodInfo   ,
#endif
    displayGetDefaultCursorSize             ,


-- ** getDefaultGroup #method:getDefaultGroup#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDefaultGroupMethodInfo        ,
#endif
    displayGetDefaultGroup                  ,


-- ** getDefaultScreen #method:getDefaultScreen#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDefaultScreenMethodInfo       ,
#endif
    displayGetDefaultScreen                 ,


-- ** getDefaultSeat #method:getDefaultSeat#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDefaultSeatMethodInfo         ,
#endif
    displayGetDefaultSeat                   ,


-- ** getDeviceManager #method:getDeviceManager#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDeviceManagerMethodInfo       ,
#endif
    displayGetDeviceManager                 ,


-- ** getEvent #method:getEvent#

#if defined(ENABLE_OVERLOADING)
    DisplayGetEventMethodInfo               ,
#endif
    displayGetEvent                         ,


-- ** getMaximalCursorSize #method:getMaximalCursorSize#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMaximalCursorSizeMethodInfo   ,
#endif
    displayGetMaximalCursorSize             ,


-- ** getMonitor #method:getMonitor#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMonitorMethodInfo             ,
#endif
    displayGetMonitor                       ,


-- ** getMonitorAtPoint #method:getMonitorAtPoint#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMonitorAtPointMethodInfo      ,
#endif
    displayGetMonitorAtPoint                ,


-- ** getMonitorAtWindow #method:getMonitorAtWindow#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMonitorAtWindowMethodInfo     ,
#endif
    displayGetMonitorAtWindow               ,


-- ** getNMonitors #method:getNMonitors#

#if defined(ENABLE_OVERLOADING)
    DisplayGetNMonitorsMethodInfo           ,
#endif
    displayGetNMonitors                     ,


-- ** getNScreens #method:getNScreens#

#if defined(ENABLE_OVERLOADING)
    DisplayGetNScreensMethodInfo            ,
#endif
    displayGetNScreens                      ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    DisplayGetNameMethodInfo                ,
#endif
    displayGetName                          ,


-- ** getPointer #method:getPointer#

#if defined(ENABLE_OVERLOADING)
    DisplayGetPointerMethodInfo             ,
#endif
    displayGetPointer                       ,


-- ** getPrimaryMonitor #method:getPrimaryMonitor#

#if defined(ENABLE_OVERLOADING)
    DisplayGetPrimaryMonitorMethodInfo      ,
#endif
    displayGetPrimaryMonitor                ,


-- ** getScreen #method:getScreen#

#if defined(ENABLE_OVERLOADING)
    DisplayGetScreenMethodInfo              ,
#endif
    displayGetScreen                        ,


-- ** getWindowAtPointer #method:getWindowAtPointer#

#if defined(ENABLE_OVERLOADING)
    DisplayGetWindowAtPointerMethodInfo     ,
#endif
    displayGetWindowAtPointer               ,


-- ** hasPending #method:hasPending#

#if defined(ENABLE_OVERLOADING)
    DisplayHasPendingMethodInfo             ,
#endif
    displayHasPending                       ,


-- ** isClosed #method:isClosed#

#if defined(ENABLE_OVERLOADING)
    DisplayIsClosedMethodInfo               ,
#endif
    displayIsClosed                         ,


-- ** keyboardUngrab #method:keyboardUngrab#

#if defined(ENABLE_OVERLOADING)
    DisplayKeyboardUngrabMethodInfo         ,
#endif
    displayKeyboardUngrab                   ,


-- ** listDevices #method:listDevices#

#if defined(ENABLE_OVERLOADING)
    DisplayListDevicesMethodInfo            ,
#endif
    displayListDevices                      ,


-- ** listSeats #method:listSeats#

#if defined(ENABLE_OVERLOADING)
    DisplayListSeatsMethodInfo              ,
#endif
    displayListSeats                        ,


-- ** notifyStartupComplete #method:notifyStartupComplete#

#if defined(ENABLE_OVERLOADING)
    DisplayNotifyStartupCompleteMethodInfo  ,
#endif
    displayNotifyStartupComplete            ,


-- ** open #method:open#

    displayOpen                             ,


-- ** openDefaultLibgtkOnly #method:openDefaultLibgtkOnly#

    displayOpenDefaultLibgtkOnly            ,


-- ** peekEvent #method:peekEvent#

#if defined(ENABLE_OVERLOADING)
    DisplayPeekEventMethodInfo              ,
#endif
    displayPeekEvent                        ,


-- ** pointerIsGrabbed #method:pointerIsGrabbed#

#if defined(ENABLE_OVERLOADING)
    DisplayPointerIsGrabbedMethodInfo       ,
#endif
    displayPointerIsGrabbed                 ,


-- ** pointerUngrab #method:pointerUngrab#

#if defined(ENABLE_OVERLOADING)
    DisplayPointerUngrabMethodInfo          ,
#endif
    displayPointerUngrab                    ,


-- ** putEvent #method:putEvent#

#if defined(ENABLE_OVERLOADING)
    DisplayPutEventMethodInfo               ,
#endif
    displayPutEvent                         ,


-- ** requestSelectionNotification #method:requestSelectionNotification#

#if defined(ENABLE_OVERLOADING)
    DisplayRequestSelectionNotificationMethodInfo,
#endif
    displayRequestSelectionNotification     ,


-- ** setDoubleClickDistance #method:setDoubleClickDistance#

#if defined(ENABLE_OVERLOADING)
    DisplaySetDoubleClickDistanceMethodInfo ,
#endif
    displaySetDoubleClickDistance           ,


-- ** setDoubleClickTime #method:setDoubleClickTime#

#if defined(ENABLE_OVERLOADING)
    DisplaySetDoubleClickTimeMethodInfo     ,
#endif
    displaySetDoubleClickTime               ,


-- ** storeClipboard #method:storeClipboard#

#if defined(ENABLE_OVERLOADING)
    DisplayStoreClipboardMethodInfo         ,
#endif
    displayStoreClipboard                   ,


-- ** supportsClipboardPersistence #method:supportsClipboardPersistence#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsClipboardPersistenceMethodInfo,
#endif
    displaySupportsClipboardPersistence     ,


-- ** supportsComposite #method:supportsComposite#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsCompositeMethodInfo      ,
#endif
    displaySupportsComposite                ,


-- ** supportsCursorAlpha #method:supportsCursorAlpha#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsCursorAlphaMethodInfo    ,
#endif
    displaySupportsCursorAlpha              ,


-- ** supportsCursorColor #method:supportsCursorColor#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsCursorColorMethodInfo    ,
#endif
    displaySupportsCursorColor              ,


-- ** supportsInputShapes #method:supportsInputShapes#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsInputShapesMethodInfo    ,
#endif
    displaySupportsInputShapes              ,


-- ** supportsSelectionNotification #method:supportsSelectionNotification#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsSelectionNotificationMethodInfo,
#endif
    displaySupportsSelectionNotification    ,


-- ** supportsShapes #method:supportsShapes#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsShapesMethodInfo         ,
#endif
    displaySupportsShapes                   ,


-- ** sync #method:sync#

#if defined(ENABLE_OVERLOADING)
    DisplaySyncMethodInfo                   ,
#endif
    displaySync                             ,


-- ** warpPointer #method:warpPointer#

#if defined(ENABLE_OVERLOADING)
    DisplayWarpPointerMethodInfo            ,
#endif
    displayWarpPointer                      ,




 -- * Signals


-- ** closed #signal:closed#

    DisplayClosedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DisplayClosedSignalInfo                 ,
#endif
    afterDisplayClosed                      ,
    onDisplayClosed                         ,


-- ** monitorAdded #signal:monitorAdded#

    DisplayMonitorAddedCallback             ,
#if defined(ENABLE_OVERLOADING)
    DisplayMonitorAddedSignalInfo           ,
#endif
    afterDisplayMonitorAdded                ,
    onDisplayMonitorAdded                   ,


-- ** monitorRemoved #signal:monitorRemoved#

    DisplayMonitorRemovedCallback           ,
#if defined(ENABLE_OVERLOADING)
    DisplayMonitorRemovedSignalInfo         ,
#endif
    afterDisplayMonitorRemoved              ,
    onDisplayMonitorRemoved                 ,


-- ** opened #signal:opened#

    DisplayOpenedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DisplayOpenedSignalInfo                 ,
#endif
    afterDisplayOpened                      ,
    onDisplayOpened                         ,


-- ** seatAdded #signal:seatAdded#

    DisplaySeatAddedCallback                ,
#if defined(ENABLE_OVERLOADING)
    DisplaySeatAddedSignalInfo              ,
#endif
    afterDisplaySeatAdded                   ,
    onDisplaySeatAdded                      ,


-- ** seatRemoved #signal:seatRemoved#

    DisplaySeatRemovedCallback              ,
#if defined(ENABLE_OVERLOADING)
    DisplaySeatRemovedSignalInfo            ,
#endif
    afterDisplaySeatRemoved                 ,
    onDisplaySeatRemoved                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype Display = Display (SP.ManagedPtr Display)
    deriving (Eq)

instance SP.ManagedPtrNewtype Display where
    toManagedPtr (Display p) = p

foreign import ccall "gdk_display_get_type"
    c_gdk_display_get_type :: IO B.Types.GType

instance B.Types.TypedObject Display where
    glibType = c_gdk_display_get_type

instance B.Types.GObject Display

-- | Type class for types which can be safely cast to `Display`, for instance with `toDisplay`.
class (SP.GObject o, O.IsDescendantOf Display o) => IsDisplay o
instance (SP.GObject o, O.IsDescendantOf Display o) => IsDisplay o

instance O.HasParentTypes Display
type instance O.ParentTypes Display = '[GObject.Object.Object]

-- | Cast to `Display`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDisplay :: (MIO.MonadIO m, IsDisplay o) => o -> m Display
toDisplay = MIO.liftIO . B.ManagedPtr.unsafeCastTo Display

-- | Convert 'Display' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Display) where
    gvalueGType_ = c_gdk_display_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Display)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Display)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Display ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDisplayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDisplayMethod "beep" o = DisplayBeepMethodInfo
    ResolveDisplayMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDisplayMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDisplayMethod "close" o = DisplayCloseMethodInfo
    ResolveDisplayMethod "deviceIsGrabbed" o = DisplayDeviceIsGrabbedMethodInfo
    ResolveDisplayMethod "flush" o = DisplayFlushMethodInfo
    ResolveDisplayMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDisplayMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDisplayMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDisplayMethod "hasPending" o = DisplayHasPendingMethodInfo
    ResolveDisplayMethod "isClosed" o = DisplayIsClosedMethodInfo
    ResolveDisplayMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDisplayMethod "keyboardUngrab" o = DisplayKeyboardUngrabMethodInfo
    ResolveDisplayMethod "listDevices" o = DisplayListDevicesMethodInfo
    ResolveDisplayMethod "listSeats" o = DisplayListSeatsMethodInfo
    ResolveDisplayMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDisplayMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDisplayMethod "notifyStartupComplete" o = DisplayNotifyStartupCompleteMethodInfo
    ResolveDisplayMethod "peekEvent" o = DisplayPeekEventMethodInfo
    ResolveDisplayMethod "pointerIsGrabbed" o = DisplayPointerIsGrabbedMethodInfo
    ResolveDisplayMethod "pointerUngrab" o = DisplayPointerUngrabMethodInfo
    ResolveDisplayMethod "putEvent" o = DisplayPutEventMethodInfo
    ResolveDisplayMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDisplayMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDisplayMethod "requestSelectionNotification" o = DisplayRequestSelectionNotificationMethodInfo
    ResolveDisplayMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDisplayMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDisplayMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDisplayMethod "storeClipboard" o = DisplayStoreClipboardMethodInfo
    ResolveDisplayMethod "supportsClipboardPersistence" o = DisplaySupportsClipboardPersistenceMethodInfo
    ResolveDisplayMethod "supportsComposite" o = DisplaySupportsCompositeMethodInfo
    ResolveDisplayMethod "supportsCursorAlpha" o = DisplaySupportsCursorAlphaMethodInfo
    ResolveDisplayMethod "supportsCursorColor" o = DisplaySupportsCursorColorMethodInfo
    ResolveDisplayMethod "supportsInputShapes" o = DisplaySupportsInputShapesMethodInfo
    ResolveDisplayMethod "supportsSelectionNotification" o = DisplaySupportsSelectionNotificationMethodInfo
    ResolveDisplayMethod "supportsShapes" o = DisplaySupportsShapesMethodInfo
    ResolveDisplayMethod "sync" o = DisplaySyncMethodInfo
    ResolveDisplayMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDisplayMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDisplayMethod "warpPointer" o = DisplayWarpPointerMethodInfo
    ResolveDisplayMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDisplayMethod "getAppLaunchContext" o = DisplayGetAppLaunchContextMethodInfo
    ResolveDisplayMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDisplayMethod "getDefaultCursorSize" o = DisplayGetDefaultCursorSizeMethodInfo
    ResolveDisplayMethod "getDefaultGroup" o = DisplayGetDefaultGroupMethodInfo
    ResolveDisplayMethod "getDefaultScreen" o = DisplayGetDefaultScreenMethodInfo
    ResolveDisplayMethod "getDefaultSeat" o = DisplayGetDefaultSeatMethodInfo
    ResolveDisplayMethod "getDeviceManager" o = DisplayGetDeviceManagerMethodInfo
    ResolveDisplayMethod "getEvent" o = DisplayGetEventMethodInfo
    ResolveDisplayMethod "getMaximalCursorSize" o = DisplayGetMaximalCursorSizeMethodInfo
    ResolveDisplayMethod "getMonitor" o = DisplayGetMonitorMethodInfo
    ResolveDisplayMethod "getMonitorAtPoint" o = DisplayGetMonitorAtPointMethodInfo
    ResolveDisplayMethod "getMonitorAtWindow" o = DisplayGetMonitorAtWindowMethodInfo
    ResolveDisplayMethod "getNMonitors" o = DisplayGetNMonitorsMethodInfo
    ResolveDisplayMethod "getNScreens" o = DisplayGetNScreensMethodInfo
    ResolveDisplayMethod "getName" o = DisplayGetNameMethodInfo
    ResolveDisplayMethod "getPointer" o = DisplayGetPointerMethodInfo
    ResolveDisplayMethod "getPrimaryMonitor" o = DisplayGetPrimaryMonitorMethodInfo
    ResolveDisplayMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDisplayMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDisplayMethod "getScreen" o = DisplayGetScreenMethodInfo
    ResolveDisplayMethod "getWindowAtPointer" o = DisplayGetWindowAtPointerMethodInfo
    ResolveDisplayMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDisplayMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDisplayMethod "setDoubleClickDistance" o = DisplaySetDoubleClickDistanceMethodInfo
    ResolveDisplayMethod "setDoubleClickTime" o = DisplaySetDoubleClickTimeMethodInfo
    ResolveDisplayMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDisplayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethod info Display p) => OL.IsLabel t (Display -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethod info Display p, R.HasField t Display p) => R.HasField t Display p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethodInfo info Display) => OL.IsLabel t (O.MethodProxy info Display) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Display::closed
-- | The [closed](#g:signal:closed) signal is emitted when the connection to the windowing
-- system for /@display@/ is closed.
-- 
-- /Since: 2.2/
type DisplayClosedCallback =
    Bool
    -- ^ /@isError@/: 'P.True' if the display was closed due to an error
    -> IO ()

type C_DisplayClosedCallback =
    Ptr Display ->                          -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayClosedCallback`.
foreign import ccall "wrapper"
    mk_DisplayClosedCallback :: C_DisplayClosedCallback -> IO (FunPtr C_DisplayClosedCallback)

wrap_DisplayClosedCallback :: 
    GObject a => (a -> DisplayClosedCallback) ->
    C_DisplayClosedCallback
wrap_DisplayClosedCallback gi'cb gi'selfPtr isError _ = do
    let isError' = (/= 0) isError
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  isError'


-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #closed callback
-- @
-- 
-- 
onDisplayClosed :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayClosedCallback) -> m SignalHandlerId
onDisplayClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayClosedCallback wrapped
    wrapped'' <- mk_DisplayClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #closed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayClosed :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayClosedCallback) -> m SignalHandlerId
afterDisplayClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayClosedCallback wrapped
    wrapped'' <- mk_DisplayClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayClosedSignalInfo
instance SignalInfo DisplayClosedSignalInfo where
    type HaskellCallbackType DisplayClosedSignalInfo = DisplayClosedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayClosedCallback cb
        cb'' <- mk_DisplayClosedCallback cb'
        connectSignalFunPtr obj "closed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::closed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:closed"})

#endif

-- signal Display::monitor-added
-- | The [monitorAdded](#g:signal:monitorAdded) signal is emitted whenever a monitor is
-- added.
-- 
-- /Since: 3.22/
type DisplayMonitorAddedCallback =
    Gdk.Monitor.Monitor
    -- ^ /@monitor@/: the monitor that was just added
    -> IO ()

type C_DisplayMonitorAddedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Monitor.Monitor ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayMonitorAddedCallback`.
foreign import ccall "wrapper"
    mk_DisplayMonitorAddedCallback :: C_DisplayMonitorAddedCallback -> IO (FunPtr C_DisplayMonitorAddedCallback)

wrap_DisplayMonitorAddedCallback :: 
    GObject a => (a -> DisplayMonitorAddedCallback) ->
    C_DisplayMonitorAddedCallback
wrap_DisplayMonitorAddedCallback gi'cb gi'selfPtr monitor _ = do
    monitor' <- (newObject Gdk.Monitor.Monitor) monitor
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  monitor'


-- | Connect a signal handler for the [monitorAdded](#signal:monitorAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #monitorAdded callback
-- @
-- 
-- 
onDisplayMonitorAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayMonitorAddedCallback) -> m SignalHandlerId
onDisplayMonitorAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayMonitorAddedCallback wrapped
    wrapped'' <- mk_DisplayMonitorAddedCallback wrapped'
    connectSignalFunPtr obj "monitor-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [monitorAdded](#signal:monitorAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #monitorAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayMonitorAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayMonitorAddedCallback) -> m SignalHandlerId
afterDisplayMonitorAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayMonitorAddedCallback wrapped
    wrapped'' <- mk_DisplayMonitorAddedCallback wrapped'
    connectSignalFunPtr obj "monitor-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayMonitorAddedSignalInfo
instance SignalInfo DisplayMonitorAddedSignalInfo where
    type HaskellCallbackType DisplayMonitorAddedSignalInfo = DisplayMonitorAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayMonitorAddedCallback cb
        cb'' <- mk_DisplayMonitorAddedCallback cb'
        connectSignalFunPtr obj "monitor-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::monitor-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:monitorAdded"})

#endif

-- signal Display::monitor-removed
-- | The [monitorRemoved](#g:signal:monitorRemoved) signal is emitted whenever a monitor is
-- removed.
-- 
-- /Since: 3.22/
type DisplayMonitorRemovedCallback =
    Gdk.Monitor.Monitor
    -- ^ /@monitor@/: the monitor that was just removed
    -> IO ()

type C_DisplayMonitorRemovedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Monitor.Monitor ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayMonitorRemovedCallback`.
foreign import ccall "wrapper"
    mk_DisplayMonitorRemovedCallback :: C_DisplayMonitorRemovedCallback -> IO (FunPtr C_DisplayMonitorRemovedCallback)

wrap_DisplayMonitorRemovedCallback :: 
    GObject a => (a -> DisplayMonitorRemovedCallback) ->
    C_DisplayMonitorRemovedCallback
wrap_DisplayMonitorRemovedCallback gi'cb gi'selfPtr monitor _ = do
    monitor' <- (newObject Gdk.Monitor.Monitor) monitor
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  monitor'


-- | Connect a signal handler for the [monitorRemoved](#signal:monitorRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #monitorRemoved callback
-- @
-- 
-- 
onDisplayMonitorRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayMonitorRemovedCallback) -> m SignalHandlerId
onDisplayMonitorRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayMonitorRemovedCallback wrapped
    wrapped'' <- mk_DisplayMonitorRemovedCallback wrapped'
    connectSignalFunPtr obj "monitor-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [monitorRemoved](#signal:monitorRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #monitorRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayMonitorRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayMonitorRemovedCallback) -> m SignalHandlerId
afterDisplayMonitorRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayMonitorRemovedCallback wrapped
    wrapped'' <- mk_DisplayMonitorRemovedCallback wrapped'
    connectSignalFunPtr obj "monitor-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayMonitorRemovedSignalInfo
instance SignalInfo DisplayMonitorRemovedSignalInfo where
    type HaskellCallbackType DisplayMonitorRemovedSignalInfo = DisplayMonitorRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayMonitorRemovedCallback cb
        cb'' <- mk_DisplayMonitorRemovedCallback cb'
        connectSignalFunPtr obj "monitor-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::monitor-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:monitorRemoved"})

#endif

-- signal Display::opened
-- | The [opened](#g:signal:opened) signal is emitted when the connection to the windowing
-- system for /@display@/ is opened.
type DisplayOpenedCallback =
    IO ()

type C_DisplayOpenedCallback =
    Ptr Display ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayOpenedCallback`.
foreign import ccall "wrapper"
    mk_DisplayOpenedCallback :: C_DisplayOpenedCallback -> IO (FunPtr C_DisplayOpenedCallback)

wrap_DisplayOpenedCallback :: 
    GObject a => (a -> DisplayOpenedCallback) ->
    C_DisplayOpenedCallback
wrap_DisplayOpenedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [opened](#signal:opened) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #opened callback
-- @
-- 
-- 
onDisplayOpened :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayOpenedCallback) -> m SignalHandlerId
onDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "opened" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [opened](#signal:opened) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #opened callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayOpened :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayOpenedCallback) -> m SignalHandlerId
afterDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "opened" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayOpenedSignalInfo
instance SignalInfo DisplayOpenedSignalInfo where
    type HaskellCallbackType DisplayOpenedSignalInfo = DisplayOpenedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayOpenedCallback cb
        cb'' <- mk_DisplayOpenedCallback cb'
        connectSignalFunPtr obj "opened" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::opened"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:opened"})

#endif

-- signal Display::seat-added
-- | The [seatAdded](#g:signal:seatAdded) signal is emitted whenever a new seat is made
-- known to the windowing system.
-- 
-- /Since: 3.20/
type DisplaySeatAddedCallback =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the seat that was just added
    -> IO ()

type C_DisplaySeatAddedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Seat.Seat ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplaySeatAddedCallback`.
foreign import ccall "wrapper"
    mk_DisplaySeatAddedCallback :: C_DisplaySeatAddedCallback -> IO (FunPtr C_DisplaySeatAddedCallback)

wrap_DisplaySeatAddedCallback :: 
    GObject a => (a -> DisplaySeatAddedCallback) ->
    C_DisplaySeatAddedCallback
wrap_DisplaySeatAddedCallback gi'cb gi'selfPtr seat _ = do
    seat' <- (newObject Gdk.Seat.Seat) seat
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  seat'


-- | Connect a signal handler for the [seatAdded](#signal:seatAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #seatAdded callback
-- @
-- 
-- 
onDisplaySeatAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatAddedCallback) -> m SignalHandlerId
onDisplaySeatAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatAddedCallback wrapped
    wrapped'' <- mk_DisplaySeatAddedCallback wrapped'
    connectSignalFunPtr obj "seat-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [seatAdded](#signal:seatAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #seatAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplaySeatAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatAddedCallback) -> m SignalHandlerId
afterDisplaySeatAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatAddedCallback wrapped
    wrapped'' <- mk_DisplaySeatAddedCallback wrapped'
    connectSignalFunPtr obj "seat-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplaySeatAddedSignalInfo
instance SignalInfo DisplaySeatAddedSignalInfo where
    type HaskellCallbackType DisplaySeatAddedSignalInfo = DisplaySeatAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplaySeatAddedCallback cb
        cb'' <- mk_DisplaySeatAddedCallback cb'
        connectSignalFunPtr obj "seat-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::seat-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:seatAdded"})

#endif

-- signal Display::seat-removed
-- | The [seatRemoved](#g:signal:seatRemoved) signal is emitted whenever a seat is removed
-- by the windowing system.
-- 
-- /Since: 3.20/
type DisplaySeatRemovedCallback =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the seat that was just removed
    -> IO ()

type C_DisplaySeatRemovedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Seat.Seat ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplaySeatRemovedCallback`.
foreign import ccall "wrapper"
    mk_DisplaySeatRemovedCallback :: C_DisplaySeatRemovedCallback -> IO (FunPtr C_DisplaySeatRemovedCallback)

wrap_DisplaySeatRemovedCallback :: 
    GObject a => (a -> DisplaySeatRemovedCallback) ->
    C_DisplaySeatRemovedCallback
wrap_DisplaySeatRemovedCallback gi'cb gi'selfPtr seat _ = do
    seat' <- (newObject Gdk.Seat.Seat) seat
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  seat'


-- | Connect a signal handler for the [seatRemoved](#signal:seatRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #seatRemoved callback
-- @
-- 
-- 
onDisplaySeatRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatRemovedCallback) -> m SignalHandlerId
onDisplaySeatRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatRemovedCallback wrapped
    wrapped'' <- mk_DisplaySeatRemovedCallback wrapped'
    connectSignalFunPtr obj "seat-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [seatRemoved](#signal:seatRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #seatRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplaySeatRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatRemovedCallback) -> m SignalHandlerId
afterDisplaySeatRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatRemovedCallback wrapped
    wrapped'' <- mk_DisplaySeatRemovedCallback wrapped'
    connectSignalFunPtr obj "seat-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplaySeatRemovedSignalInfo
instance SignalInfo DisplaySeatRemovedSignalInfo where
    type HaskellCallbackType DisplaySeatRemovedSignalInfo = DisplaySeatRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplaySeatRemovedCallback cb
        cb'' <- mk_DisplaySeatRemovedCallback cb'
        connectSignalFunPtr obj "seat-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::seat-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#g:signal:seatRemoved"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Display
type instance O.AttributeList Display = DisplayAttributeList
type DisplayAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Display = DisplaySignalList
type DisplaySignalList = ('[ '("closed", DisplayClosedSignalInfo), '("monitorAdded", DisplayMonitorAddedSignalInfo), '("monitorRemoved", DisplayMonitorRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("opened", DisplayOpenedSignalInfo), '("seatAdded", DisplaySeatAddedSignalInfo), '("seatRemoved", DisplaySeatRemovedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Display::beep
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_beep" gdk_display_beep :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Emits a short beep on /@display@/
-- 
-- /Since: 2.2/
displayBeep ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ()
displayBeep display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_beep display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayBeepMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayBeepMethodInfo a signature where
    overloadedMethod = displayBeep

instance O.OverloadedMethodInfo DisplayBeepMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayBeep",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayBeep"
        })


#endif

-- method Display::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_close" gdk_display_close :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Closes the connection to the windowing system for the given display,
-- and cleans up associated resources.
-- 
-- /Since: 2.2/
displayClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ()
displayClose display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_close display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayCloseMethodInfo a signature where
    overloadedMethod = displayClose

instance O.OverloadedMethodInfo DisplayCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayClose"
        })


#endif

-- method Display::device_is_grabbed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_device_is_grabbed" gdk_display_device_is_grabbed :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Returns 'P.True' if there is an ongoing grab on /@device@/ for /@display@/.
displayDeviceIsGrabbed ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> b
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there is a grab in effect for /@device@/.
displayDeviceIsGrabbed display device = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_display_device_is_grabbed display' device'
    let result' = (/= 0) result
    touchManagedPtr display
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayDeviceIsGrabbedMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsDisplay a, Gdk.Device.IsDevice b) => O.OverloadedMethod DisplayDeviceIsGrabbedMethodInfo a signature where
    overloadedMethod = displayDeviceIsGrabbed

instance O.OverloadedMethodInfo DisplayDeviceIsGrabbedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayDeviceIsGrabbed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayDeviceIsGrabbed"
        })


#endif

-- method Display::flush
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_flush" gdk_display_flush :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Flushes any requests queued for the windowing system; this happens automatically
-- when the main loop blocks waiting for new events, but if your application
-- is drawing without returning control to the main loop, you may need
-- to call this function explicitly. A common case where this function
-- needs to be called is when an application is executing drawing commands
-- from a thread other than the thread where the main loop is running.
-- 
-- This is most useful for X11. On windowing systems where requests are
-- handled synchronously, this function will do nothing.
-- 
-- /Since: 2.4/
displayFlush ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ()
displayFlush display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_flush display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayFlushMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayFlushMethodInfo a signature where
    overloadedMethod = displayFlush

instance O.OverloadedMethodInfo DisplayFlushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayFlush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayFlush"
        })


#endif

-- method Display::get_app_launch_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "AppLaunchContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_app_launch_context" gdk_display_get_app_launch_context :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.AppLaunchContext.AppLaunchContext)

-- | Returns a t'GI.Gdk.Objects.AppLaunchContext.AppLaunchContext' suitable for launching
-- applications on the given display.
-- 
-- /Since: 3.0/
displayGetAppLaunchContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Gdk.AppLaunchContext.AppLaunchContext
    -- ^ __Returns:__ a new t'GI.Gdk.Objects.AppLaunchContext.AppLaunchContext' for /@display@/.
    --     Free with 'GI.GObject.Objects.Object.objectUnref' when done
displayGetAppLaunchContext display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_app_launch_context display'
    checkUnexpectedReturnNULL "displayGetAppLaunchContext" result
    result' <- (wrapObject Gdk.AppLaunchContext.AppLaunchContext) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetAppLaunchContextMethodInfo
instance (signature ~ (m Gdk.AppLaunchContext.AppLaunchContext), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetAppLaunchContextMethodInfo a signature where
    overloadedMethod = displayGetAppLaunchContext

instance O.OverloadedMethodInfo DisplayGetAppLaunchContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetAppLaunchContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetAppLaunchContext"
        })


#endif

-- method Display::get_default_cursor_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default_cursor_size" gdk_display_get_default_cursor_size :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO Word32

-- | Returns the default size to use for cursors on /@display@/.
-- 
-- /Since: 2.4/
displayGetDefaultCursorSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Word32
    -- ^ __Returns:__ the default cursor size.
displayGetDefaultCursorSize display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_default_cursor_size display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data DisplayGetDefaultCursorSizeMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDefaultCursorSizeMethodInfo a signature where
    overloadedMethod = displayGetDefaultCursorSize

instance O.OverloadedMethodInfo DisplayGetDefaultCursorSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDefaultCursorSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetDefaultCursorSize"
        })


#endif

-- method Display::get_default_group
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default_group" gdk_display_get_default_group :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Window.Window)

-- | Returns the default group leader window for all toplevel windows
-- on /@display@/. This window is implicitly created by GDK.
-- See 'GI.Gdk.Objects.Window.windowSetGroup'.
-- 
-- /Since: 2.4/
displayGetDefaultGroup ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ The default group leader window
    -- for /@display@/
displayGetDefaultGroup display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_default_group display'
    checkUnexpectedReturnNULL "displayGetDefaultGroup" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetDefaultGroupMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDefaultGroupMethodInfo a signature where
    overloadedMethod = displayGetDefaultGroup

instance O.OverloadedMethodInfo DisplayGetDefaultGroupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDefaultGroup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetDefaultGroup"
        })


#endif

-- method Display::get_default_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default_screen" gdk_display_get_default_screen :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Screen.Screen)

-- | Get the default t'GI.Gdk.Objects.Screen.Screen' for /@display@/.
-- 
-- /Since: 2.2/
displayGetDefaultScreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Gdk.Screen.Screen
    -- ^ __Returns:__ the default t'GI.Gdk.Objects.Screen.Screen' object for /@display@/
displayGetDefaultScreen display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_default_screen display'
    checkUnexpectedReturnNULL "displayGetDefaultScreen" result
    result' <- (newObject Gdk.Screen.Screen) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetDefaultScreenMethodInfo
instance (signature ~ (m Gdk.Screen.Screen), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDefaultScreenMethodInfo a signature where
    overloadedMethod = displayGetDefaultScreen

instance O.OverloadedMethodInfo DisplayGetDefaultScreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDefaultScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetDefaultScreen"
        })


#endif

-- method Display::get_default_seat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Seat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default_seat" gdk_display_get_default_seat :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Seat.Seat)

-- | Returns the default t'GI.Gdk.Objects.Seat.Seat' for this display.
-- 
-- /Since: 3.20/
displayGetDefaultSeat ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Gdk.Seat.Seat
    -- ^ __Returns:__ the default seat.
displayGetDefaultSeat display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_default_seat display'
    checkUnexpectedReturnNULL "displayGetDefaultSeat" result
    result' <- (newObject Gdk.Seat.Seat) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetDefaultSeatMethodInfo
instance (signature ~ (m Gdk.Seat.Seat), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDefaultSeatMethodInfo a signature where
    overloadedMethod = displayGetDefaultSeat

instance O.OverloadedMethodInfo DisplayGetDefaultSeatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDefaultSeat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetDefaultSeat"
        })


#endif

-- method Display::get_device_manager
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DeviceManager" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_device_manager" gdk_display_get_device_manager :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.DeviceManager.DeviceManager)

{-# DEPRECATED displayGetDeviceManager ["(Since version 3.20.)","Use 'GI.Gdk.Objects.Display.displayGetDefaultSeat' and t'GI.Gdk.Objects.Seat.Seat' operations."] #-}
-- | Returns the t'GI.Gdk.Objects.DeviceManager.DeviceManager' associated to /@display@/.
-- 
-- /Since: 3.0/
displayGetDeviceManager ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'.
    -> m (Maybe Gdk.DeviceManager.DeviceManager)
    -- ^ __Returns:__ A t'GI.Gdk.Objects.DeviceManager.DeviceManager', or
    --          'P.Nothing'. This memory is owned by GDK and must not be freed
    --          or unreferenced.
displayGetDeviceManager display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_device_manager display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.DeviceManager.DeviceManager) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetDeviceManagerMethodInfo
instance (signature ~ (m (Maybe Gdk.DeviceManager.DeviceManager)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDeviceManagerMethodInfo a signature where
    overloadedMethod = displayGetDeviceManager

instance O.OverloadedMethodInfo DisplayGetDeviceManagerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDeviceManager",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetDeviceManager"
        })


#endif

-- method Display::get_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_event" gdk_display_get_event :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Event.Event)

-- | Gets the next t'GI.Gdk.Unions.Event.Event' to be processed for /@display@/, fetching events from the
-- windowing system if necessary.
-- 
-- /Since: 2.2/
displayGetEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m (Maybe Gdk.Event.Event)
    -- ^ __Returns:__ the next t'GI.Gdk.Unions.Event.Event' to be processed, or 'P.Nothing'
    -- if no events are pending. The returned t'GI.Gdk.Unions.Event.Event' should be freed
    -- with 'GI.Gdk.Unions.Event.eventFree'.
displayGetEvent display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_event display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gdk.Event.Event) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetEventMethodInfo
instance (signature ~ (m (Maybe Gdk.Event.Event)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetEventMethodInfo a signature where
    overloadedMethod = displayGetEvent

instance O.OverloadedMethodInfo DisplayGetEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetEvent"
        })


#endif

-- method Display::get_maximal_cursor_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the return location for the maximal cursor width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the return location for the maximal cursor height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_maximal_cursor_size" gdk_display_get_maximal_cursor_size :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Word32 ->                           -- width : TBasicType TUInt
    Ptr Word32 ->                           -- height : TBasicType TUInt
    IO ()

-- | Gets the maximal size to use for cursors on /@display@/.
-- 
-- /Since: 2.4/
displayGetMaximalCursorSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ((Word32, Word32))
displayGetMaximalCursorSize display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    width <- allocMem :: IO (Ptr Word32)
    height <- allocMem :: IO (Ptr Word32)
    gdk_display_get_maximal_cursor_size display' width height
    width' <- peek width
    height' <- peek height
    touchManagedPtr display
    freeMem width
    freeMem height
    return (width', height')

#if defined(ENABLE_OVERLOADING)
data DisplayGetMaximalCursorSizeMethodInfo
instance (signature ~ (m ((Word32, Word32))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetMaximalCursorSizeMethodInfo a signature where
    overloadedMethod = displayGetMaximalCursorSize

instance O.OverloadedMethodInfo DisplayGetMaximalCursorSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMaximalCursorSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetMaximalCursorSize"
        })


#endif

-- method Display::get_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of the monitor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_monitor" gdk_display_get_monitor :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets a monitor associated with this display.
-- 
-- /Since: 3.22/
displayGetMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor
    -> m (Maybe Gdk.Monitor.Monitor)
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Monitor.Monitor', or 'P.Nothing' if
    --    /@monitorNum@/ is not a valid monitor number
displayGetMonitor display monitorNum = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_monitor display' monitorNum
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Monitor.Monitor) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetMonitorMethodInfo
instance (signature ~ (Int32 -> m (Maybe Gdk.Monitor.Monitor)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetMonitorMethodInfo a signature where
    overloadedMethod = displayGetMonitor

instance O.OverloadedMethodInfo DisplayGetMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetMonitor"
        })


#endif

-- method Display::get_monitor_at_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the x coordinate of the point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the y coordinate of the point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_monitor_at_point" gdk_display_get_monitor_at_point :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets the monitor in which the point (/@x@/, /@y@/) is located,
-- or a nearby monitor if the point is not in any monitor.
-- 
-- /Since: 3.22/
displayGetMonitorAtPoint ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Int32
    -- ^ /@x@/: the x coordinate of the point
    -> Int32
    -- ^ /@y@/: the y coordinate of the point
    -> m Gdk.Monitor.Monitor
    -- ^ __Returns:__ the monitor containing the point
displayGetMonitorAtPoint display x y = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_monitor_at_point display' x y
    checkUnexpectedReturnNULL "displayGetMonitorAtPoint" result
    result' <- (newObject Gdk.Monitor.Monitor) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetMonitorAtPointMethodInfo
instance (signature ~ (Int32 -> Int32 -> m Gdk.Monitor.Monitor), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetMonitorAtPointMethodInfo a signature where
    overloadedMethod = displayGetMonitorAtPoint

instance O.OverloadedMethodInfo DisplayGetMonitorAtPointMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMonitorAtPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetMonitorAtPoint"
        })


#endif

-- method Display::get_monitor_at_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_monitor_at_window" gdk_display_get_monitor_at_window :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets the monitor in which the largest area of /@window@/
-- resides, or a monitor close to /@window@/ if it is outside
-- of all monitors.
-- 
-- /Since: 3.22/
displayGetMonitorAtWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> b
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Gdk.Monitor.Monitor
    -- ^ __Returns:__ the monitor with the largest overlap with /@window@/
displayGetMonitorAtWindow display window = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_display_get_monitor_at_window display' window'
    checkUnexpectedReturnNULL "displayGetMonitorAtWindow" result
    result' <- (newObject Gdk.Monitor.Monitor) result
    touchManagedPtr display
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetMonitorAtWindowMethodInfo
instance (signature ~ (b -> m Gdk.Monitor.Monitor), MonadIO m, IsDisplay a, Gdk.Window.IsWindow b) => O.OverloadedMethod DisplayGetMonitorAtWindowMethodInfo a signature where
    overloadedMethod = displayGetMonitorAtWindow

instance O.OverloadedMethodInfo DisplayGetMonitorAtWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMonitorAtWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetMonitorAtWindow"
        })


#endif

-- method Display::get_n_monitors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_n_monitors" gdk_display_get_n_monitors :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO Int32

-- | Gets the number of monitors that belong to /@display@/.
-- 
-- The returned number is valid until the next emission of the
-- [Display::monitorAdded]("GI.Gdk.Objects.Display#g:signal:monitorAdded") or [Display::monitorRemoved]("GI.Gdk.Objects.Display#g:signal:monitorRemoved") signal.
-- 
-- /Since: 3.22/
displayGetNMonitors ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Int32
    -- ^ __Returns:__ the number of monitors
displayGetNMonitors display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_n_monitors display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data DisplayGetNMonitorsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetNMonitorsMethodInfo a signature where
    overloadedMethod = displayGetNMonitors

instance O.OverloadedMethodInfo DisplayGetNMonitorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetNMonitors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetNMonitors"
        })


#endif

-- method Display::get_n_screens
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_n_screens" gdk_display_get_n_screens :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO Int32

{-# DEPRECATED displayGetNScreens ["(Since version 3.10)","The number of screens is always 1."] #-}
-- | Gets the number of screen managed by the /@display@/.
-- 
-- /Since: 2.2/
displayGetNScreens ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Int32
    -- ^ __Returns:__ number of screens.
displayGetNScreens display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_n_screens display'
    touchManagedPtr display
    return result

#if defined(ENABLE_OVERLOADING)
data DisplayGetNScreensMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetNScreensMethodInfo a signature where
    overloadedMethod = displayGetNScreens

instance O.OverloadedMethodInfo DisplayGetNScreensMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetNScreens",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetNScreens"
        })


#endif

-- method Display::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_name" gdk_display_get_name :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CString

-- | Gets the name of the display.
-- 
-- /Since: 2.2/
displayGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m T.Text
    -- ^ __Returns:__ a string representing the display name. This string is owned
    -- by GDK and should not be modified or freed.
displayGetName display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_name display'
    checkUnexpectedReturnNULL "displayGetName" result
    result' <- cstringToText result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetNameMethodInfo a signature where
    overloadedMethod = displayGetName

instance O.OverloadedMethodInfo DisplayGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetName"
        })


#endif

-- method Display::get_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the screen that the\n         cursor is on, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window X coordinate of pointer, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window Y coordinate of pointer, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store current modifier mask, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_pointer" gdk_display_get_pointer :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr (Ptr Gdk.Screen.Screen) ->          -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    Ptr CUInt ->                            -- mask : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO ()

{-# DEPRECATED displayGetPointer ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceGetPosition' instead."] #-}
-- | Gets the current location of the pointer and the current modifier
-- mask for a given display.
-- 
-- /Since: 2.2/
displayGetPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ((Gdk.Screen.Screen, Int32, Int32, [Gdk.Flags.ModifierType]))
displayGetPointer display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    screen <- callocMem :: IO (Ptr (Ptr Gdk.Screen.Screen))
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    mask <- allocMem :: IO (Ptr CUInt)
    gdk_display_get_pointer display' screen x y mask
    screen' <- peek screen
    screen'' <- (newObject Gdk.Screen.Screen) screen'
    x' <- peek x
    y' <- peek y
    mask' <- peek mask
    let mask'' = wordToGFlags mask'
    touchManagedPtr display
    freeMem screen
    freeMem x
    freeMem y
    freeMem mask
    return (screen'', x', y', mask'')

#if defined(ENABLE_OVERLOADING)
data DisplayGetPointerMethodInfo
instance (signature ~ (m ((Gdk.Screen.Screen, Int32, Int32, [Gdk.Flags.ModifierType]))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetPointerMethodInfo a signature where
    overloadedMethod = displayGetPointer

instance O.OverloadedMethodInfo DisplayGetPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetPointer"
        })


#endif

-- method Display::get_primary_monitor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_primary_monitor" gdk_display_get_primary_monitor :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets the primary monitor for the display.
-- 
-- The primary monitor is considered the monitor where the “main desktop”
-- lives. While normal application windows typically allow the window
-- manager to place the windows, specialized desktop applications
-- such as panels should place themselves on the primary monitor.
-- 
-- /Since: 3.22/
displayGetPrimaryMonitor ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m (Maybe Gdk.Monitor.Monitor)
    -- ^ __Returns:__ the primary monitor, or 'P.Nothing' if no primary
    --     monitor is configured by the user
displayGetPrimaryMonitor display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_primary_monitor display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Monitor.Monitor) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetPrimaryMonitorMethodInfo
instance (signature ~ (m (Maybe Gdk.Monitor.Monitor)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetPrimaryMonitorMethodInfo a signature where
    overloadedMethod = displayGetPrimaryMonitor

instance O.OverloadedMethodInfo DisplayGetPrimaryMonitorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetPrimaryMonitor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetPrimaryMonitor"
        })


#endif

-- method Display::get_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the screen number" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_screen" gdk_display_get_screen :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Int32 ->                                -- screen_num : TBasicType TInt
    IO (Ptr Gdk.Screen.Screen)

{-# DEPRECATED displayGetScreen ["(Since version 3.20)","There is only one screen; use 'GI.Gdk.Objects.Display.displayGetDefaultScreen' to get it."] #-}
-- | Returns a screen object for one of the screens of the display.
-- 
-- /Since: 2.2/
displayGetScreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Int32
    -- ^ /@screenNum@/: the screen number
    -> m Gdk.Screen.Screen
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Screen.Screen' object
displayGetScreen display screenNum = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_screen display' screenNum
    checkUnexpectedReturnNULL "displayGetScreen" result
    result' <- (newObject Gdk.Screen.Screen) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetScreenMethodInfo
instance (signature ~ (Int32 -> m Gdk.Screen.Screen), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetScreenMethodInfo a signature where
    overloadedMethod = displayGetScreen

instance O.OverloadedMethodInfo DisplayGetScreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetScreen"
        })


#endif

-- method Display::get_window_at_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for x coordinate of the pointer location relative\n   to the window origin, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "win_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for y coordinate of the pointer location relative\n &    to the window origin, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_window_at_pointer" gdk_display_get_window_at_pointer :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Int32 ->                            -- win_x : TBasicType TInt
    Ptr Int32 ->                            -- win_y : TBasicType TInt
    IO (Ptr Gdk.Window.Window)

{-# DEPRECATED displayGetWindowAtPointer ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceGetWindowAtPosition' instead."] #-}
-- | Obtains the window underneath the mouse pointer, returning the location
-- of the pointer in that window in /@winX@/, /@winY@/ for /@screen@/. Returns 'P.Nothing'
-- if the window under the mouse pointer is not known to GDK (for example,
-- belongs to another application).
-- 
-- /Since: 2.2/
displayGetWindowAtPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ((Maybe Gdk.Window.Window, Int32, Int32))
    -- ^ __Returns:__ the window under the mouse
    --   pointer, or 'P.Nothing'
displayGetWindowAtPointer display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    winX <- allocMem :: IO (Ptr Int32)
    winY <- allocMem :: IO (Ptr Int32)
    result <- gdk_display_get_window_at_pointer display' winX winY
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    winX' <- peek winX
    winY' <- peek winY
    touchManagedPtr display
    freeMem winX
    freeMem winY
    return (maybeResult, winX', winY')

#if defined(ENABLE_OVERLOADING)
data DisplayGetWindowAtPointerMethodInfo
instance (signature ~ (m ((Maybe Gdk.Window.Window, Int32, Int32))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetWindowAtPointerMethodInfo a signature where
    overloadedMethod = displayGetWindowAtPointer

instance O.OverloadedMethodInfo DisplayGetWindowAtPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetWindowAtPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayGetWindowAtPointer"
        })


#endif

-- method Display::has_pending
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_has_pending" gdk_display_has_pending :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether the display has events that are waiting
-- to be processed.
-- 
-- /Since: 3.0/
displayHasPending ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there are events ready to be processed.
displayHasPending display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_has_pending display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayHasPendingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayHasPendingMethodInfo a signature where
    overloadedMethod = displayHasPending

instance O.OverloadedMethodInfo DisplayHasPendingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayHasPending",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayHasPending"
        })


#endif

-- method Display::is_closed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_is_closed" gdk_display_is_closed :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Finds out if the display has been closed.
-- 
-- /Since: 2.22/
displayIsClosed ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the display is closed.
displayIsClosed display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_is_closed display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayIsClosedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayIsClosedMethodInfo a signature where
    overloadedMethod = displayIsClosed

instance O.OverloadedMethodInfo DisplayIsClosedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayIsClosed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayIsClosed"
        })


#endif

-- method Display::keyboard_ungrab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestap (e.g #GDK_CURRENT_TIME)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_keyboard_ungrab" gdk_display_keyboard_ungrab :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

{-# DEPRECATED displayKeyboardUngrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceUngrab', together with 'GI.Gdk.Objects.Device.deviceGrab'","            instead."] #-}
-- | Release any keyboard grab
-- 
-- /Since: 2.2/
displayKeyboardUngrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'.
    -> Word32
    -- ^ /@time_@/: a timestap (e.g 'GI.Gdk.Constants.CURRENT_TIME').
    -> m ()
displayKeyboardUngrab display time_ = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_keyboard_ungrab display' time_
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayKeyboardUngrabMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayKeyboardUngrabMethodInfo a signature where
    overloadedMethod = displayKeyboardUngrab

instance O.OverloadedMethodInfo DisplayKeyboardUngrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayKeyboardUngrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayKeyboardUngrab"
        })


#endif

-- method Display::list_devices
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Device" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_list_devices" gdk_display_list_devices :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr (GList (Ptr Gdk.Device.Device)))

{-# DEPRECATED displayListDevices ["(Since version 3.0)","Use 'GI.Gdk.Objects.DeviceManager.deviceManagerListDevices' instead."] #-}
-- | Returns the list of available input devices attached to /@display@/.
-- The list is statically allocated and should not be freed.
-- 
-- /Since: 2.2/
displayListDevices ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m [Gdk.Device.Device]
    -- ^ __Returns:__ 
    --     a list of t'GI.Gdk.Objects.Device.Device'
displayListDevices display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_list_devices display'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Device.Device) result'
    touchManagedPtr display
    return result''

#if defined(ENABLE_OVERLOADING)
data DisplayListDevicesMethodInfo
instance (signature ~ (m [Gdk.Device.Device]), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayListDevicesMethodInfo a signature where
    overloadedMethod = displayListDevices

instance O.OverloadedMethodInfo DisplayListDevicesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayListDevices",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayListDevices"
        })


#endif

-- method Display::list_seats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Seat" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_list_seats" gdk_display_list_seats :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr (GList (Ptr Gdk.Seat.Seat)))

-- | Returns the list of seats known to /@display@/.
-- 
-- /Since: 3.20/
displayListSeats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m [Gdk.Seat.Seat]
    -- ^ __Returns:__ the
    --          list of seats known to the t'GI.Gdk.Objects.Display.Display'
displayListSeats display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_list_seats display'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Seat.Seat) result'
    g_list_free result
    touchManagedPtr display
    return result''

#if defined(ENABLE_OVERLOADING)
data DisplayListSeatsMethodInfo
instance (signature ~ (m [Gdk.Seat.Seat]), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayListSeatsMethodInfo a signature where
    overloadedMethod = displayListSeats

instance O.OverloadedMethodInfo DisplayListSeatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayListSeats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayListSeats"
        })


#endif

-- method Display::notify_startup_complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a startup-notification identifier, for which\n    notification process should be completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_notify_startup_complete" gdk_display_notify_startup_complete :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

-- | Indicates to the GUI environment that the application has
-- finished loading, using a given identifier.
-- 
-- GTK+ will call this function automatically for @/GtkWindow/@
-- with custom startup-notification identifier unless
-- @/gtk_window_set_auto_startup_notification()/@ is called to
-- disable that feature.
-- 
-- /Since: 3.0/
displayNotifyStartupComplete ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> T.Text
    -- ^ /@startupId@/: a startup-notification identifier, for which
    --     notification process should be completed
    -> m ()
displayNotifyStartupComplete display startupId = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    startupId' <- textToCString startupId
    gdk_display_notify_startup_complete display' startupId'
    touchManagedPtr display
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayNotifyStartupCompleteMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayNotifyStartupCompleteMethodInfo a signature where
    overloadedMethod = displayNotifyStartupComplete

instance O.OverloadedMethodInfo DisplayNotifyStartupCompleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayNotifyStartupComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayNotifyStartupComplete"
        })


#endif

-- method Display::peek_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_peek_event" gdk_display_peek_event :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Event.Event)

-- | Gets a copy of the first t'GI.Gdk.Unions.Event.Event' in the /@display@/’s event queue, without
-- removing the event from the queue.  (Note that this function will
-- not get more events from the windowing system.  It only checks the events
-- that have already been moved to the GDK event queue.)
-- 
-- /Since: 2.2/
displayPeekEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m (Maybe Gdk.Event.Event)
    -- ^ __Returns:__ a copy of the first t'GI.Gdk.Unions.Event.Event' on the event
    -- queue, or 'P.Nothing' if no events are in the queue. The returned
    -- t'GI.Gdk.Unions.Event.Event' should be freed with 'GI.Gdk.Unions.Event.eventFree'.
displayPeekEvent display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_peek_event display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gdk.Event.Event) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayPeekEventMethodInfo
instance (signature ~ (m (Maybe Gdk.Event.Event)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayPeekEventMethodInfo a signature where
    overloadedMethod = displayPeekEvent

instance O.OverloadedMethodInfo DisplayPeekEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPeekEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayPeekEvent"
        })


#endif

-- method Display::pointer_is_grabbed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_pointer_is_grabbed" gdk_display_pointer_is_grabbed :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

{-# DEPRECATED displayPointerIsGrabbed ["(Since version 3.0)","Use 'GI.Gdk.Objects.Display.displayDeviceIsGrabbed' instead."] #-}
-- | Test if the pointer is grabbed.
-- 
-- /Since: 2.2/
displayPointerIsGrabbed ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if an active X pointer grab is in effect
displayPointerIsGrabbed display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_pointer_is_grabbed display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayPointerIsGrabbedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayPointerIsGrabbedMethodInfo a signature where
    overloadedMethod = displayPointerIsGrabbed

instance O.OverloadedMethodInfo DisplayPointerIsGrabbedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPointerIsGrabbed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayPointerIsGrabbed"
        })


#endif

-- method Display::pointer_ungrab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestap (e.g. %GDK_CURRENT_TIME)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_pointer_ungrab" gdk_display_pointer_ungrab :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

{-# DEPRECATED displayPointerUngrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceUngrab', together with 'GI.Gdk.Objects.Device.deviceGrab'","            instead."] #-}
-- | Release any pointer grab.
-- 
-- /Since: 2.2/
displayPointerUngrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'.
    -> Word32
    -- ^ /@time_@/: a timestap (e.g. 'GI.Gdk.Constants.CURRENT_TIME').
    -> m ()
displayPointerUngrab display time_ = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_pointer_ungrab display' time_
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayPointerUngrabMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayPointerUngrabMethodInfo a signature where
    overloadedMethod = displayPointerUngrab

instance O.OverloadedMethodInfo DisplayPointerUngrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPointerUngrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayPointerUngrab"
        })


#endif

-- method Display::put_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_put_event" gdk_display_put_event :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

-- | Appends a copy of the given event onto the front of the event
-- queue for /@display@/.
-- 
-- /Since: 2.2/
displayPutEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Gdk.Event.Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'.
    -> m ()
displayPutEvent display event = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    event' <- unsafeManagedPtrGetPtr event
    gdk_display_put_event display' event'
    touchManagedPtr display
    touchManagedPtr event
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayPutEventMethodInfo
instance (signature ~ (Gdk.Event.Event -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayPutEventMethodInfo a signature where
    overloadedMethod = displayPutEvent

instance O.OverloadedMethodInfo DisplayPutEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPutEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayPutEvent"
        })


#endif

-- method Display::request_selection_notification
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GdkAtom naming the selection for which\n            ownership change notification is requested"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_request_selection_notification" gdk_display_request_selection_notification :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO CInt

-- | Request t'GI.Gdk.Structs.EventOwnerChange.EventOwnerChange' events for ownership changes
-- of the selection named by the given atom.
-- 
-- /Since: 2.6/
displayRequestSelectionNotification ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: the t'GI.Gdk.Structs.Atom.Atom' naming the selection for which
    --             ownership change notification is requested
    -> m Bool
    -- ^ __Returns:__ whether t'GI.Gdk.Structs.EventOwnerChange.EventOwnerChange' events will
    --               be sent.
displayRequestSelectionNotification display selection = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    selection' <- unsafeManagedPtrGetPtr selection
    result <- gdk_display_request_selection_notification display' selection'
    let result' = (/= 0) result
    touchManagedPtr display
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayRequestSelectionNotificationMethodInfo
instance (signature ~ (Gdk.Atom.Atom -> m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayRequestSelectionNotificationMethodInfo a signature where
    overloadedMethod = displayRequestSelectionNotification

instance O.OverloadedMethodInfo DisplayRequestSelectionNotificationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayRequestSelectionNotification",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayRequestSelectionNotification"
        })


#endif

-- method Display::set_double_click_distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "distance"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "distance in pixels" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_set_double_click_distance" gdk_display_set_double_click_distance :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- distance : TBasicType TUInt
    IO ()

-- | Sets the double click distance (two clicks within this distance
-- count as a double click and result in a @/GDK_2BUTTON_PRESS/@ event).
-- See also 'GI.Gdk.Objects.Display.displaySetDoubleClickTime'.
-- Applications should not set this, it is a global
-- user-configured setting.
-- 
-- /Since: 2.4/
displaySetDoubleClickDistance ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Word32
    -- ^ /@distance@/: distance in pixels
    -> m ()
displaySetDoubleClickDistance display distance = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_set_double_click_distance display' distance
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplaySetDoubleClickDistanceMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySetDoubleClickDistanceMethodInfo a signature where
    overloadedMethod = displaySetDoubleClickDistance

instance O.OverloadedMethodInfo DisplaySetDoubleClickDistanceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySetDoubleClickDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySetDoubleClickDistance"
        })


#endif

-- method Display::set_double_click_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "msec"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "double click time in milliseconds (thousandths of a second)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_set_double_click_time" gdk_display_set_double_click_time :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- msec : TBasicType TUInt
    IO ()

-- | Sets the double click time (two clicks within this time interval
-- count as a double click and result in a @/GDK_2BUTTON_PRESS/@ event).
-- Applications should not set this, it is a global
-- user-configured setting.
-- 
-- /Since: 2.2/
displaySetDoubleClickTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Word32
    -- ^ /@msec@/: double click time in milliseconds (thousandths of a second)
    -> m ()
displaySetDoubleClickTime display msec = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_set_double_click_time display' msec
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplaySetDoubleClickTimeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySetDoubleClickTimeMethodInfo a signature where
    overloadedMethod = displaySetDoubleClickTime

instance O.OverloadedMethodInfo DisplaySetDoubleClickTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySetDoubleClickTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySetDoubleClickTime"
        })


#endif

-- method Display::store_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "clipboard_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow belonging to the clipboard owner"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "targets"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gdk" , name = "Atom" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an array of targets\n                   that should be saved, or %NULL\n                   if all available targets should be saved."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_targets"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of the @targets array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_targets"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of the @targets array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_store_clipboard" gdk_display_store_clipboard :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Window.Window ->                -- clipboard_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    Ptr (Ptr Gdk.Atom.Atom) ->              -- targets : TCArray False (-1) 4 (TInterface (Name {namespace = "Gdk", name = "Atom"}))
    Int32 ->                                -- n_targets : TBasicType TInt
    IO ()

-- | Issues a request to the clipboard manager to store the
-- clipboard data. On X11, this is a special program that works
-- according to the
-- <http://www.freedesktop.org/Standards/clipboard-manager-spec FreeDesktop Clipboard Specification>.
-- 
-- /Since: 2.6/
displayStoreClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> b
    -- ^ /@clipboardWindow@/: a t'GI.Gdk.Objects.Window.Window' belonging to the clipboard owner
    -> Word32
    -- ^ /@time_@/: a timestamp
    -> Maybe ([Gdk.Atom.Atom])
    -- ^ /@targets@/: an array of targets
    --                    that should be saved, or 'P.Nothing'
    --                    if all available targets should be saved.
    -> m ()
displayStoreClipboard display clipboardWindow time_ targets = liftIO $ do
    let nTargets = case targets of
            Nothing -> 0
            Just jTargets -> fromIntegral $ P.length jTargets
    display' <- unsafeManagedPtrCastPtr display
    clipboardWindow' <- unsafeManagedPtrCastPtr clipboardWindow
    maybeTargets <- case targets of
        Nothing -> return FP.nullPtr
        Just jTargets -> do
            jTargets' <- mapM unsafeManagedPtrGetPtr jTargets
            jTargets'' <- packPtrArray jTargets'
            return jTargets''
    gdk_display_store_clipboard display' clipboardWindow' time_ maybeTargets nTargets
    touchManagedPtr display
    touchManagedPtr clipboardWindow
    whenJust targets (mapM_ touchManagedPtr)
    freeMem maybeTargets
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayStoreClipboardMethodInfo
instance (signature ~ (b -> Word32 -> Maybe ([Gdk.Atom.Atom]) -> m ()), MonadIO m, IsDisplay a, Gdk.Window.IsWindow b) => O.OverloadedMethod DisplayStoreClipboardMethodInfo a signature where
    overloadedMethod = displayStoreClipboard

instance O.OverloadedMethodInfo DisplayStoreClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayStoreClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayStoreClipboard"
        })


#endif

-- method Display::supports_clipboard_persistence
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_clipboard_persistence" gdk_display_supports_clipboard_persistence :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether the speicifed display supports clipboard
-- persistance; i.e. if it’s possible to store the clipboard data after an
-- application has quit. On X11 this checks if a clipboard daemon is
-- running.
-- 
-- /Since: 2.6/
displaySupportsClipboardPersistence ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the display supports clipboard persistance.
displaySupportsClipboardPersistence display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_clipboard_persistence display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsClipboardPersistenceMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsClipboardPersistenceMethodInfo a signature where
    overloadedMethod = displaySupportsClipboardPersistence

instance O.OverloadedMethodInfo DisplaySupportsClipboardPersistenceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsClipboardPersistence",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsClipboardPersistence"
        })


#endif

-- method Display::supports_composite
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_composite" gdk_display_supports_composite :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

{-# DEPRECATED displaySupportsComposite ["(Since version 3.16)","Compositing is an outdated technology that","  only ever worked on X11."] #-}
-- | Returns 'P.True' if 'GI.Gdk.Objects.Window.windowSetComposited' can be used
-- to redirect drawing on the window using compositing.
-- 
-- Currently this only works on X11 with XComposite and
-- XDamage extensions available.
-- 
-- /Since: 2.12/
displaySupportsComposite ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if windows may be composited.
displaySupportsComposite display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_composite display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsCompositeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsCompositeMethodInfo a signature where
    overloadedMethod = displaySupportsComposite

instance O.OverloadedMethodInfo DisplaySupportsCompositeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsComposite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsComposite"
        })


#endif

-- method Display::supports_cursor_alpha
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_cursor_alpha" gdk_display_supports_cursor_alpha :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns 'P.True' if cursors can use an 8bit alpha channel
-- on /@display@/. Otherwise, cursors are restricted to bilevel
-- alpha (i.e. a mask).
-- 
-- /Since: 2.4/
displaySupportsCursorAlpha ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ whether cursors can have alpha channels.
displaySupportsCursorAlpha display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_cursor_alpha display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsCursorAlphaMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsCursorAlphaMethodInfo a signature where
    overloadedMethod = displaySupportsCursorAlpha

instance O.OverloadedMethodInfo DisplaySupportsCursorAlphaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsCursorAlpha",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsCursorAlpha"
        })


#endif

-- method Display::supports_cursor_color
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_cursor_color" gdk_display_supports_cursor_color :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns 'P.True' if multicolored cursors are supported
-- on /@display@/. Otherwise, cursors have only a forground
-- and a background color.
-- 
-- /Since: 2.4/
displaySupportsCursorColor ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ whether cursors can have multiple colors.
displaySupportsCursorColor display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_cursor_color display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsCursorColorMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsCursorColorMethodInfo a signature where
    overloadedMethod = displaySupportsCursorColor

instance O.OverloadedMethodInfo DisplaySupportsCursorColorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsCursorColor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsCursorColor"
        })


#endif

-- method Display::supports_input_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_input_shapes" gdk_display_supports_input_shapes :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns 'P.True' if @/gdk_window_input_shape_combine_mask()/@ can
-- be used to modify the input shape of windows on /@display@/.
-- 
-- /Since: 2.10/
displaySupportsInputShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if windows with modified input shape are supported
displaySupportsInputShapes display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_input_shapes display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsInputShapesMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsInputShapesMethodInfo a signature where
    overloadedMethod = displaySupportsInputShapes

instance O.OverloadedMethodInfo DisplaySupportsInputShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsInputShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsInputShapes"
        })


#endif

-- method Display::supports_selection_notification
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_selection_notification" gdk_display_supports_selection_notification :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether t'GI.Gdk.Structs.EventOwnerChange.EventOwnerChange' events will be
-- sent when the owner of a selection changes.
-- 
-- /Since: 2.6/
displaySupportsSelectionNotification ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ whether t'GI.Gdk.Structs.EventOwnerChange.EventOwnerChange' events will
    --               be sent.
displaySupportsSelectionNotification display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_selection_notification display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsSelectionNotificationMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsSelectionNotificationMethodInfo a signature where
    overloadedMethod = displaySupportsSelectionNotification

instance O.OverloadedMethodInfo DisplaySupportsSelectionNotificationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsSelectionNotification",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsSelectionNotification"
        })


#endif

-- method Display::supports_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_shapes" gdk_display_supports_shapes :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns 'P.True' if @/gdk_window_shape_combine_mask()/@ can
-- be used to create shaped windows on /@display@/.
-- 
-- /Since: 2.10/
displaySupportsShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if shaped windows are supported
displaySupportsShapes display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_shapes display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsShapesMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsShapesMethodInfo a signature where
    overloadedMethod = displaySupportsShapes

instance O.OverloadedMethodInfo DisplaySupportsShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySupportsShapes"
        })


#endif

-- method Display::sync
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_sync" gdk_display_sync :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Flushes any requests queued for the windowing system and waits until all
-- requests have been handled. This is often used for making sure that the
-- display is synchronized with the current state of the program. Calling
-- 'GI.Gdk.Objects.Display.displaySync' before 'GI.Gdk.Functions.errorTrapPop' makes sure that any errors
-- generated from earlier requests are handled before the error trap is
-- removed.
-- 
-- This is most useful for X11. On windowing systems where requests are
-- handled synchronously, this function will do nothing.
-- 
-- /Since: 2.2/
displaySync ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> m ()
displaySync display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_sync display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplaySyncMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySyncMethodInfo a signature where
    overloadedMethod = displaySync

instance O.OverloadedMethodInfo DisplaySyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displaySync"
        })


#endif

-- method Display::warp_pointer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the screen of @display to warp the pointer to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the x coordinate of the destination"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the y coordinate of the destination"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_warp_pointer" gdk_display_warp_pointer :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Screen.Screen ->                -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO ()

{-# DEPRECATED displayWarpPointer ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceWarp' instead."] #-}
-- | Warps the pointer of /@display@/ to the point /@x@/,/@y@/ on
-- the screen /@screen@/, unless the pointer is confined
-- to a window by a grab, in which case it will be moved
-- as far as allowed by the grab. Warping the pointer
-- creates events as if the user had moved the mouse
-- instantaneously to the destination.
-- 
-- Note that the pointer should normally be under the
-- control of the user. This function was added to cover
-- some rare use cases like keyboard navigation support
-- for the color picker in the @/GtkColorSelectionDialog/@.
-- 
-- /Since: 2.8/
displayWarpPointer ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Screen.IsScreen b) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> b
    -- ^ /@screen@/: the screen of /@display@/ to warp the pointer to
    -> Int32
    -- ^ /@x@/: the x coordinate of the destination
    -> Int32
    -- ^ /@y@/: the y coordinate of the destination
    -> m ()
displayWarpPointer display screen x y = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    screen' <- unsafeManagedPtrCastPtr screen
    gdk_display_warp_pointer display' screen' x y
    touchManagedPtr display
    touchManagedPtr screen
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayWarpPointerMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> m ()), MonadIO m, IsDisplay a, Gdk.Screen.IsScreen b) => O.OverloadedMethod DisplayWarpPointerMethodInfo a signature where
    overloadedMethod = displayWarpPointer

instance O.OverloadedMethodInfo DisplayWarpPointerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayWarpPointer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Display.html#v:displayWarpPointer"
        })


#endif

-- method Display::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default" gdk_display_get_default :: 
    IO (Ptr Display)

-- | Gets the default t'GI.Gdk.Objects.Display.Display'. This is a convenience
-- function for:
-- @gdk_display_manager_get_default_display (gdk_display_manager_get ())@.
-- 
-- /Since: 2.2/
displayGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Display)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display', or 'P.Nothing' if
    --   there is no default display.
displayGetDefault  = liftIO $ do
    result <- gdk_display_get_default
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Display) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Display::open
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the display to open"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_open" gdk_display_open :: 
    CString ->                              -- display_name : TBasicType TUTF8
    IO (Ptr Display)

-- | Opens a display.
-- 
-- /Since: 2.2/
displayOpen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@displayName@/: the name of the display to open
    -> m (Maybe Display)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display', or 'P.Nothing' if the
    --     display could not be opened
displayOpen displayName = liftIO $ do
    displayName' <- textToCString displayName
    result <- gdk_display_open displayName'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Display) result'
        return result''
    freeMem displayName'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Display::open_default_libgtk_only
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_open_default_libgtk_only" gdk_display_open_default_libgtk_only :: 
    IO (Ptr Display)

{-# DEPRECATED displayOpenDefaultLibgtkOnly ["(Since version 3.16)","This symbol was never meant to be used outside","  of GTK+"] #-}
-- | Opens the default display specified by command line arguments or
-- environment variables, sets it as the default display, and returns
-- it. 'GI.Gdk.Functions.parseArgs' must have been called first. If the default
-- display has previously been set, simply returns that. An internal
-- function that should not be used by applications.
displayOpenDefaultLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Display)
    -- ^ __Returns:__ the default display, if it
    --   could be opened, otherwise 'P.Nothing'.
displayOpenDefaultLibgtkOnly  = liftIO $ do
    result <- gdk_display_open_default_libgtk_only
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Display) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


