{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Unions.Event.Event' contains a union of all of the event types,
-- and allows access to the data fields in a number of ways.
-- 
-- The event type is always the first field in all of the event types, and
-- can always be accessed with the following code, no matter what type of
-- event it is:
-- 
-- === /C code/
-- >
-- >  GdkEvent *event;
-- >  GdkEventType type;
-- >
-- >  type = event->type;
-- 
-- 
-- To access other fields of the event, the pointer to the event
-- can be cast to the appropriate event type, or the union member
-- name can be used. For example if the event type is 'GI.Gdk.Enums.EventTypeButtonPress'
-- then the x coordinate of the button press can be accessed with:
-- 
-- === /C code/
-- >
-- >  GdkEvent *event;
-- >  gdouble x;
-- >
-- >  x = ((GdkEventButton*)event)->x;
-- 
-- or:
-- 
-- === /C code/
-- >
-- >  GdkEvent *event;
-- >  gdouble x;
-- >
-- >  x = event->button.x;
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Unions.Event
    ( 

-- * Exported types
    Event(..)                               ,
    newZeroEvent                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Gdk.Unions.Event#g:method:copy"), [free]("GI.Gdk.Unions.Event#g:method:free"), [isScrollStopEvent]("GI.Gdk.Unions.Event#g:method:isScrollStopEvent"), [put]("GI.Gdk.Unions.Event#g:method:put"), [triggersContextMenu]("GI.Gdk.Unions.Event#g:method:triggersContextMenu").
-- 
-- ==== Getters
-- [getAxis]("GI.Gdk.Unions.Event#g:method:getAxis"), [getButton]("GI.Gdk.Unions.Event#g:method:getButton"), [getClickCount]("GI.Gdk.Unions.Event#g:method:getClickCount"), [getCoords]("GI.Gdk.Unions.Event#g:method:getCoords"), [getDevice]("GI.Gdk.Unions.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Unions.Event#g:method:getDeviceTool"), [getEventSequence]("GI.Gdk.Unions.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Unions.Event#g:method:getEventType"), [getKeycode]("GI.Gdk.Unions.Event#g:method:getKeycode"), [getKeyval]("GI.Gdk.Unions.Event#g:method:getKeyval"), [getPointerEmulated]("GI.Gdk.Unions.Event#g:method:getPointerEmulated"), [getRootCoords]("GI.Gdk.Unions.Event#g:method:getRootCoords"), [getScancode]("GI.Gdk.Unions.Event#g:method:getScancode"), [getScreen]("GI.Gdk.Unions.Event#g:method:getScreen"), [getScrollDeltas]("GI.Gdk.Unions.Event#g:method:getScrollDeltas"), [getScrollDirection]("GI.Gdk.Unions.Event#g:method:getScrollDirection"), [getSeat]("GI.Gdk.Unions.Event#g:method:getSeat"), [getSourceDevice]("GI.Gdk.Unions.Event#g:method:getSourceDevice"), [getState]("GI.Gdk.Unions.Event#g:method:getState"), [getTime]("GI.Gdk.Unions.Event#g:method:getTime"), [getWindow]("GI.Gdk.Unions.Event#g:method:getWindow").
-- 
-- ==== Setters
-- [setDevice]("GI.Gdk.Unions.Event#g:method:setDevice"), [setDeviceTool]("GI.Gdk.Unions.Event#g:method:setDeviceTool"), [setScreen]("GI.Gdk.Unions.Event#g:method:setScreen"), [setSourceDevice]("GI.Gdk.Unions.Event#g:method:setSourceDevice").

#if defined(ENABLE_OVERLOADING)
    ResolveEventMethod                      ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    EventCopyMethodInfo                     ,
#endif
    eventCopy                               ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    EventFreeMethodInfo                     ,
#endif
    eventFree                               ,


-- ** get #method:get#

    eventGet                                ,


-- ** getAxis #method:getAxis#

#if defined(ENABLE_OVERLOADING)
    EventGetAxisMethodInfo                  ,
#endif
    eventGetAxis                            ,


-- ** getButton #method:getButton#

#if defined(ENABLE_OVERLOADING)
    EventGetButtonMethodInfo                ,
#endif
    eventGetButton                          ,


-- ** getClickCount #method:getClickCount#

#if defined(ENABLE_OVERLOADING)
    EventGetClickCountMethodInfo            ,
#endif
    eventGetClickCount                      ,


-- ** getCoords #method:getCoords#

#if defined(ENABLE_OVERLOADING)
    EventGetCoordsMethodInfo                ,
#endif
    eventGetCoords                          ,


-- ** getDevice #method:getDevice#

#if defined(ENABLE_OVERLOADING)
    EventGetDeviceMethodInfo                ,
#endif
    eventGetDevice                          ,


-- ** getDeviceTool #method:getDeviceTool#

#if defined(ENABLE_OVERLOADING)
    EventGetDeviceToolMethodInfo            ,
#endif
    eventGetDeviceTool                      ,


-- ** getEventSequence #method:getEventSequence#

#if defined(ENABLE_OVERLOADING)
    EventGetEventSequenceMethodInfo         ,
#endif
    eventGetEventSequence                   ,


-- ** getEventType #method:getEventType#

#if defined(ENABLE_OVERLOADING)
    EventGetEventTypeMethodInfo             ,
#endif
    eventGetEventType                       ,


-- ** getKeycode #method:getKeycode#

#if defined(ENABLE_OVERLOADING)
    EventGetKeycodeMethodInfo               ,
#endif
    eventGetKeycode                         ,


-- ** getKeyval #method:getKeyval#

#if defined(ENABLE_OVERLOADING)
    EventGetKeyvalMethodInfo                ,
#endif
    eventGetKeyval                          ,


-- ** getPointerEmulated #method:getPointerEmulated#

#if defined(ENABLE_OVERLOADING)
    EventGetPointerEmulatedMethodInfo       ,
#endif
    eventGetPointerEmulated                 ,


-- ** getRootCoords #method:getRootCoords#

#if defined(ENABLE_OVERLOADING)
    EventGetRootCoordsMethodInfo            ,
#endif
    eventGetRootCoords                      ,


-- ** getScancode #method:getScancode#

#if defined(ENABLE_OVERLOADING)
    EventGetScancodeMethodInfo              ,
#endif
    eventGetScancode                        ,


-- ** getScreen #method:getScreen#

#if defined(ENABLE_OVERLOADING)
    EventGetScreenMethodInfo                ,
#endif
    eventGetScreen                          ,


-- ** getScrollDeltas #method:getScrollDeltas#

#if defined(ENABLE_OVERLOADING)
    EventGetScrollDeltasMethodInfo          ,
#endif
    eventGetScrollDeltas                    ,


-- ** getScrollDirection #method:getScrollDirection#

#if defined(ENABLE_OVERLOADING)
    EventGetScrollDirectionMethodInfo       ,
#endif
    eventGetScrollDirection                 ,


-- ** getSeat #method:getSeat#

#if defined(ENABLE_OVERLOADING)
    EventGetSeatMethodInfo                  ,
#endif
    eventGetSeat                            ,


-- ** getSourceDevice #method:getSourceDevice#

#if defined(ENABLE_OVERLOADING)
    EventGetSourceDeviceMethodInfo          ,
#endif
    eventGetSourceDevice                    ,


-- ** getState #method:getState#

#if defined(ENABLE_OVERLOADING)
    EventGetStateMethodInfo                 ,
#endif
    eventGetState                           ,


-- ** getTime #method:getTime#

#if defined(ENABLE_OVERLOADING)
    EventGetTimeMethodInfo                  ,
#endif
    eventGetTime                            ,


-- ** getWindow #method:getWindow#

#if defined(ENABLE_OVERLOADING)
    EventGetWindowMethodInfo                ,
#endif
    eventGetWindow                          ,


-- ** handlerSet #method:handlerSet#

    eventHandlerSet                         ,


-- ** isScrollStopEvent #method:isScrollStopEvent#

#if defined(ENABLE_OVERLOADING)
    EventIsScrollStopEventMethodInfo        ,
#endif
    eventIsScrollStopEvent                  ,


-- ** new #method:new#

    eventNew                                ,


-- ** peek #method:peek#

    eventPeek                               ,


-- ** put #method:put#

#if defined(ENABLE_OVERLOADING)
    EventPutMethodInfo                      ,
#endif
    eventPut                                ,


-- ** requestMotions #method:requestMotions#

    eventRequestMotions                     ,


-- ** setDevice #method:setDevice#

#if defined(ENABLE_OVERLOADING)
    EventSetDeviceMethodInfo                ,
#endif
    eventSetDevice                          ,


-- ** setDeviceTool #method:setDeviceTool#

#if defined(ENABLE_OVERLOADING)
    EventSetDeviceToolMethodInfo            ,
#endif
    eventSetDeviceTool                      ,


-- ** setScreen #method:setScreen#

#if defined(ENABLE_OVERLOADING)
    EventSetScreenMethodInfo                ,
#endif
    eventSetScreen                          ,


-- ** setSourceDevice #method:setSourceDevice#

#if defined(ENABLE_OVERLOADING)
    EventSetSourceDeviceMethodInfo          ,
#endif
    eventSetSourceDevice                    ,


-- ** triggersContextMenu #method:triggersContextMenu#

#if defined(ENABLE_OVERLOADING)
    EventTriggersContextMenuMethodInfo      ,
#endif
    eventTriggersContextMenu                ,




 -- * Properties


-- ** any #attr:any#
-- | a t'GI.Gdk.Structs.EventAny.EventAny'

#if defined(ENABLE_OVERLOADING)
    event_any                               ,
#endif
    getEventAny                             ,


-- ** button #attr:button#
-- | a t'GI.Gdk.Structs.EventButton.EventButton'

#if defined(ENABLE_OVERLOADING)
    event_button                            ,
#endif
    getEventButton                          ,


-- ** configure #attr:configure#
-- | a t'GI.Gdk.Structs.EventConfigure.EventConfigure'

#if defined(ENABLE_OVERLOADING)
    event_configure                         ,
#endif
    getEventConfigure                       ,


-- ** crossing #attr:crossing#
-- | a t'GI.Gdk.Structs.EventCrossing.EventCrossing'

#if defined(ENABLE_OVERLOADING)
    event_crossing                          ,
#endif
    getEventCrossing                        ,


-- ** dnd #attr:dnd#
-- | a t'GI.Gdk.Structs.EventDND.EventDND'

#if defined(ENABLE_OVERLOADING)
    event_dnd                               ,
#endif
    getEventDnd                             ,


-- ** expose #attr:expose#
-- | a t'GI.Gdk.Structs.EventExpose.EventExpose'

#if defined(ENABLE_OVERLOADING)
    event_expose                            ,
#endif
    getEventExpose                          ,


-- ** focusChange #attr:focusChange#
-- | a t'GI.Gdk.Structs.EventFocus.EventFocus'

#if defined(ENABLE_OVERLOADING)
    event_focusChange                       ,
#endif
    getEventFocusChange                     ,


-- ** grabBroken #attr:grabBroken#
-- | a t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken'

#if defined(ENABLE_OVERLOADING)
    event_grabBroken                        ,
#endif
    getEventGrabBroken                      ,


-- ** key #attr:key#
-- | a t'GI.Gdk.Structs.EventKey.EventKey'

#if defined(ENABLE_OVERLOADING)
    event_key                               ,
#endif
    getEventKey                             ,


-- ** motion #attr:motion#
-- | a t'GI.Gdk.Structs.EventMotion.EventMotion'

#if defined(ENABLE_OVERLOADING)
    event_motion                            ,
#endif
    getEventMotion                          ,


-- ** ownerChange #attr:ownerChange#
-- | a t'GI.Gdk.Structs.EventOwnerChange.EventOwnerChange'

#if defined(ENABLE_OVERLOADING)
    event_ownerChange                       ,
#endif
    getEventOwnerChange                     ,


-- ** padAxis #attr:padAxis#
-- | a t'GI.Gdk.Structs.EventPadAxis.EventPadAxis'

#if defined(ENABLE_OVERLOADING)
    event_padAxis                           ,
#endif
    getEventPadAxis                         ,


-- ** padButton #attr:padButton#
-- | a t'GI.Gdk.Structs.EventPadButton.EventPadButton'

#if defined(ENABLE_OVERLOADING)
    event_padButton                         ,
#endif
    getEventPadButton                       ,


-- ** padGroupMode #attr:padGroupMode#
-- | a t'GI.Gdk.Structs.EventPadGroupMode.EventPadGroupMode'

#if defined(ENABLE_OVERLOADING)
    event_padGroupMode                      ,
#endif
    getEventPadGroupMode                    ,


-- ** property #attr:property#
-- | a t'GI.Gdk.Structs.EventProperty.EventProperty'

#if defined(ENABLE_OVERLOADING)
    event_property                          ,
#endif
    getEventProperty                        ,


-- ** proximity #attr:proximity#
-- | a t'GI.Gdk.Structs.EventProximity.EventProximity'

#if defined(ENABLE_OVERLOADING)
    event_proximity                         ,
#endif
    getEventProximity                       ,


-- ** scroll #attr:scroll#
-- | a t'GI.Gdk.Structs.EventScroll.EventScroll'

#if defined(ENABLE_OVERLOADING)
    event_scroll                            ,
#endif
    getEventScroll                          ,


-- ** selection #attr:selection#
-- | a t'GI.Gdk.Structs.EventSelection.EventSelection'

#if defined(ENABLE_OVERLOADING)
    event_selection                         ,
#endif
    getEventSelection                       ,


-- ** setting #attr:setting#
-- | a t'GI.Gdk.Structs.EventSetting.EventSetting'

#if defined(ENABLE_OVERLOADING)
    event_setting                           ,
#endif
    getEventSetting                         ,


-- ** touch #attr:touch#
-- | a t'GI.Gdk.Structs.EventTouch.EventTouch'

#if defined(ENABLE_OVERLOADING)
    event_touch                             ,
#endif
    getEventTouch                           ,


-- ** touchpadPinch #attr:touchpadPinch#
-- | a t'GI.Gdk.Structs.EventTouchpadPinch.EventTouchpadPinch'

#if defined(ENABLE_OVERLOADING)
    event_touchpadPinch                     ,
#endif
    getEventTouchpadPinch                   ,


-- ** touchpadSwipe #attr:touchpadSwipe#
-- | a t'GI.Gdk.Structs.EventTouchpadSwipe.EventTouchpadSwipe'

#if defined(ENABLE_OVERLOADING)
    event_touchpadSwipe                     ,
#endif
    getEventTouchpadSwipe                   ,


-- ** type #attr:type#
-- | the t'GI.Gdk.Enums.EventType'

#if defined(ENABLE_OVERLOADING)
    event_type                              ,
#endif
    getEventType                            ,
    setEventType                            ,


-- ** visibility #attr:visibility#
-- | a t'GI.Gdk.Structs.EventVisibility.EventVisibility'

#if defined(ENABLE_OVERLOADING)
    event_visibility                        ,
#endif
    getEventVisibility                      ,


-- ** windowState #attr:windowState#
-- | a t'GI.Gdk.Structs.EventWindowState.EventWindowState'

#if defined(ENABLE_OVERLOADING)
    event_windowState                       ,
#endif
    getEventWindowState                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState

#endif

-- | Memory-managed wrapper type.
newtype Event = Event (SP.ManagedPtr Event)
    deriving (Eq)

instance SP.ManagedPtrNewtype Event where
    toManagedPtr (Event p) = p

foreign import ccall "gdk_event_get_type" c_gdk_event_get_type :: 
    IO GType

type instance O.ParentTypes Event = '[]
instance O.HasParentTypes Event

instance B.Types.TypedObject Event where
    glibType = c_gdk_event_get_type

instance B.Types.GBoxed Event

-- | Convert 'Event' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Event) where
    gvalueGType_ = c_gdk_event_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Event)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Event)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Event ptr
        else return P.Nothing
        
    

-- | Construct a `Event` struct initialized to zero.
newZeroEvent :: MonadIO m => m Event
newZeroEvent = liftIO $ callocBoxedBytes 96 >>= wrapBoxed Event

instance tag ~ 'AttrSet => Constructible Event tag where
    new _ attrs = do
        o <- newZeroEvent
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #type
-- @
getEventType :: MonadIO m => Event -> m Gdk.Enums.EventType
getEventType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' event [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventType :: MonadIO m => Event -> Gdk.Enums.EventType -> m ()
setEventType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventTypeFieldInfo
instance AttrInfo EventTypeFieldInfo where
    type AttrBaseTypeConstraint EventTypeFieldInfo = (~) Event
    type AttrAllowedOps EventTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventTypeFieldInfo = "type"
    type AttrOrigin EventTypeFieldInfo = Event
    attrGet = getEventType
    attrSet = setEventType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:type"
        })

event_type :: AttrLabelProxy "type"
event_type = AttrLabelProxy

#endif


-- | Get the value of the “@any@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #any
-- @
getEventAny :: MonadIO m => Event -> m Gdk.EventAny.EventAny
getEventAny s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventAny.EventAny)
    val' <- (newPtr Gdk.EventAny.EventAny) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventAnyFieldInfo
instance AttrInfo EventAnyFieldInfo where
    type AttrBaseTypeConstraint EventAnyFieldInfo = (~) Event
    type AttrAllowedOps EventAnyFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventAnyFieldInfo = (~) (Ptr Gdk.EventAny.EventAny)
    type AttrTransferTypeConstraint EventAnyFieldInfo = (~)(Ptr Gdk.EventAny.EventAny)
    type AttrTransferType EventAnyFieldInfo = (Ptr Gdk.EventAny.EventAny)
    type AttrGetType EventAnyFieldInfo = Gdk.EventAny.EventAny
    type AttrLabel EventAnyFieldInfo = "any"
    type AttrOrigin EventAnyFieldInfo = Event
    attrGet = getEventAny
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.any"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:any"
        })

event_any :: AttrLabelProxy "any"
event_any = AttrLabelProxy

#endif


-- | Get the value of the “@expose@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #expose
-- @
getEventExpose :: MonadIO m => Event -> m Gdk.EventExpose.EventExpose
getEventExpose s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventExpose.EventExpose)
    val' <- (newPtr Gdk.EventExpose.EventExpose) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventExposeFieldInfo
instance AttrInfo EventExposeFieldInfo where
    type AttrBaseTypeConstraint EventExposeFieldInfo = (~) Event
    type AttrAllowedOps EventExposeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventExposeFieldInfo = (~) (Ptr Gdk.EventExpose.EventExpose)
    type AttrTransferTypeConstraint EventExposeFieldInfo = (~)(Ptr Gdk.EventExpose.EventExpose)
    type AttrTransferType EventExposeFieldInfo = (Ptr Gdk.EventExpose.EventExpose)
    type AttrGetType EventExposeFieldInfo = Gdk.EventExpose.EventExpose
    type AttrLabel EventExposeFieldInfo = "expose"
    type AttrOrigin EventExposeFieldInfo = Event
    attrGet = getEventExpose
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.expose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:expose"
        })

event_expose :: AttrLabelProxy "expose"
event_expose = AttrLabelProxy

#endif


-- | Get the value of the “@visibility@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #visibility
-- @
getEventVisibility :: MonadIO m => Event -> m Gdk.EventVisibility.EventVisibility
getEventVisibility s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventVisibility.EventVisibility)
    val' <- (newPtr Gdk.EventVisibility.EventVisibility) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventVisibilityFieldInfo
instance AttrInfo EventVisibilityFieldInfo where
    type AttrBaseTypeConstraint EventVisibilityFieldInfo = (~) Event
    type AttrAllowedOps EventVisibilityFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventVisibilityFieldInfo = (~) (Ptr Gdk.EventVisibility.EventVisibility)
    type AttrTransferTypeConstraint EventVisibilityFieldInfo = (~)(Ptr Gdk.EventVisibility.EventVisibility)
    type AttrTransferType EventVisibilityFieldInfo = (Ptr Gdk.EventVisibility.EventVisibility)
    type AttrGetType EventVisibilityFieldInfo = Gdk.EventVisibility.EventVisibility
    type AttrLabel EventVisibilityFieldInfo = "visibility"
    type AttrOrigin EventVisibilityFieldInfo = Event
    attrGet = getEventVisibility
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.visibility"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:visibility"
        })

event_visibility :: AttrLabelProxy "visibility"
event_visibility = AttrLabelProxy

#endif


-- | Get the value of the “@motion@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #motion
-- @
getEventMotion :: MonadIO m => Event -> m Gdk.EventMotion.EventMotion
getEventMotion s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventMotion.EventMotion)
    val' <- (newPtr Gdk.EventMotion.EventMotion) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventMotionFieldInfo
instance AttrInfo EventMotionFieldInfo where
    type AttrBaseTypeConstraint EventMotionFieldInfo = (~) Event
    type AttrAllowedOps EventMotionFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventMotionFieldInfo = (~) (Ptr Gdk.EventMotion.EventMotion)
    type AttrTransferTypeConstraint EventMotionFieldInfo = (~)(Ptr Gdk.EventMotion.EventMotion)
    type AttrTransferType EventMotionFieldInfo = (Ptr Gdk.EventMotion.EventMotion)
    type AttrGetType EventMotionFieldInfo = Gdk.EventMotion.EventMotion
    type AttrLabel EventMotionFieldInfo = "motion"
    type AttrOrigin EventMotionFieldInfo = Event
    attrGet = getEventMotion
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.motion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:motion"
        })

event_motion :: AttrLabelProxy "motion"
event_motion = AttrLabelProxy

#endif


-- | Get the value of the “@button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #button
-- @
getEventButton :: MonadIO m => Event -> m Gdk.EventButton.EventButton
getEventButton s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventButton.EventButton)
    val' <- (newPtr Gdk.EventButton.EventButton) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventButtonFieldInfo
instance AttrInfo EventButtonFieldInfo where
    type AttrBaseTypeConstraint EventButtonFieldInfo = (~) Event
    type AttrAllowedOps EventButtonFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventButtonFieldInfo = (~) (Ptr Gdk.EventButton.EventButton)
    type AttrTransferTypeConstraint EventButtonFieldInfo = (~)(Ptr Gdk.EventButton.EventButton)
    type AttrTransferType EventButtonFieldInfo = (Ptr Gdk.EventButton.EventButton)
    type AttrGetType EventButtonFieldInfo = Gdk.EventButton.EventButton
    type AttrLabel EventButtonFieldInfo = "button"
    type AttrOrigin EventButtonFieldInfo = Event
    attrGet = getEventButton
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.button"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:button"
        })

event_button :: AttrLabelProxy "button"
event_button = AttrLabelProxy

#endif


-- | Get the value of the “@touch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #touch
-- @
getEventTouch :: MonadIO m => Event -> m Gdk.EventTouch.EventTouch
getEventTouch s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventTouch.EventTouch)
    val' <- (newPtr Gdk.EventTouch.EventTouch) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventTouchFieldInfo
instance AttrInfo EventTouchFieldInfo where
    type AttrBaseTypeConstraint EventTouchFieldInfo = (~) Event
    type AttrAllowedOps EventTouchFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventTouchFieldInfo = (~) (Ptr Gdk.EventTouch.EventTouch)
    type AttrTransferTypeConstraint EventTouchFieldInfo = (~)(Ptr Gdk.EventTouch.EventTouch)
    type AttrTransferType EventTouchFieldInfo = (Ptr Gdk.EventTouch.EventTouch)
    type AttrGetType EventTouchFieldInfo = Gdk.EventTouch.EventTouch
    type AttrLabel EventTouchFieldInfo = "touch"
    type AttrOrigin EventTouchFieldInfo = Event
    attrGet = getEventTouch
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.touch"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:touch"
        })

event_touch :: AttrLabelProxy "touch"
event_touch = AttrLabelProxy

#endif


-- | Get the value of the “@scroll@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #scroll
-- @
getEventScroll :: MonadIO m => Event -> m Gdk.EventScroll.EventScroll
getEventScroll s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventScroll.EventScroll)
    val' <- (newPtr Gdk.EventScroll.EventScroll) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventScrollFieldInfo
instance AttrInfo EventScrollFieldInfo where
    type AttrBaseTypeConstraint EventScrollFieldInfo = (~) Event
    type AttrAllowedOps EventScrollFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventScrollFieldInfo = (~) (Ptr Gdk.EventScroll.EventScroll)
    type AttrTransferTypeConstraint EventScrollFieldInfo = (~)(Ptr Gdk.EventScroll.EventScroll)
    type AttrTransferType EventScrollFieldInfo = (Ptr Gdk.EventScroll.EventScroll)
    type AttrGetType EventScrollFieldInfo = Gdk.EventScroll.EventScroll
    type AttrLabel EventScrollFieldInfo = "scroll"
    type AttrOrigin EventScrollFieldInfo = Event
    attrGet = getEventScroll
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.scroll"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:scroll"
        })

event_scroll :: AttrLabelProxy "scroll"
event_scroll = AttrLabelProxy

#endif


-- | Get the value of the “@key@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #key
-- @
getEventKey :: MonadIO m => Event -> m Gdk.EventKey.EventKey
getEventKey s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventKey.EventKey)
    val' <- (newPtr Gdk.EventKey.EventKey) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventKeyFieldInfo
instance AttrInfo EventKeyFieldInfo where
    type AttrBaseTypeConstraint EventKeyFieldInfo = (~) Event
    type AttrAllowedOps EventKeyFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventKeyFieldInfo = (~) (Ptr Gdk.EventKey.EventKey)
    type AttrTransferTypeConstraint EventKeyFieldInfo = (~)(Ptr Gdk.EventKey.EventKey)
    type AttrTransferType EventKeyFieldInfo = (Ptr Gdk.EventKey.EventKey)
    type AttrGetType EventKeyFieldInfo = Gdk.EventKey.EventKey
    type AttrLabel EventKeyFieldInfo = "key"
    type AttrOrigin EventKeyFieldInfo = Event
    attrGet = getEventKey
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.key"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:key"
        })

event_key :: AttrLabelProxy "key"
event_key = AttrLabelProxy

#endif


-- | Get the value of the “@crossing@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #crossing
-- @
getEventCrossing :: MonadIO m => Event -> m Gdk.EventCrossing.EventCrossing
getEventCrossing s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventCrossing.EventCrossing)
    val' <- (newPtr Gdk.EventCrossing.EventCrossing) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventCrossingFieldInfo
instance AttrInfo EventCrossingFieldInfo where
    type AttrBaseTypeConstraint EventCrossingFieldInfo = (~) Event
    type AttrAllowedOps EventCrossingFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventCrossingFieldInfo = (~) (Ptr Gdk.EventCrossing.EventCrossing)
    type AttrTransferTypeConstraint EventCrossingFieldInfo = (~)(Ptr Gdk.EventCrossing.EventCrossing)
    type AttrTransferType EventCrossingFieldInfo = (Ptr Gdk.EventCrossing.EventCrossing)
    type AttrGetType EventCrossingFieldInfo = Gdk.EventCrossing.EventCrossing
    type AttrLabel EventCrossingFieldInfo = "crossing"
    type AttrOrigin EventCrossingFieldInfo = Event
    attrGet = getEventCrossing
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.crossing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:crossing"
        })

event_crossing :: AttrLabelProxy "crossing"
event_crossing = AttrLabelProxy

#endif


-- | Get the value of the “@focus_change@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #focusChange
-- @
getEventFocusChange :: MonadIO m => Event -> m Gdk.EventFocus.EventFocus
getEventFocusChange s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventFocus.EventFocus)
    val' <- (newPtr Gdk.EventFocus.EventFocus) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventFocusChangeFieldInfo
instance AttrInfo EventFocusChangeFieldInfo where
    type AttrBaseTypeConstraint EventFocusChangeFieldInfo = (~) Event
    type AttrAllowedOps EventFocusChangeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventFocusChangeFieldInfo = (~) (Ptr Gdk.EventFocus.EventFocus)
    type AttrTransferTypeConstraint EventFocusChangeFieldInfo = (~)(Ptr Gdk.EventFocus.EventFocus)
    type AttrTransferType EventFocusChangeFieldInfo = (Ptr Gdk.EventFocus.EventFocus)
    type AttrGetType EventFocusChangeFieldInfo = Gdk.EventFocus.EventFocus
    type AttrLabel EventFocusChangeFieldInfo = "focus_change"
    type AttrOrigin EventFocusChangeFieldInfo = Event
    attrGet = getEventFocusChange
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.focusChange"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:focusChange"
        })

event_focusChange :: AttrLabelProxy "focusChange"
event_focusChange = AttrLabelProxy

#endif


-- | Get the value of the “@configure@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #configure
-- @
getEventConfigure :: MonadIO m => Event -> m Gdk.EventConfigure.EventConfigure
getEventConfigure s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventConfigure.EventConfigure)
    val' <- (newPtr Gdk.EventConfigure.EventConfigure) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventConfigureFieldInfo
instance AttrInfo EventConfigureFieldInfo where
    type AttrBaseTypeConstraint EventConfigureFieldInfo = (~) Event
    type AttrAllowedOps EventConfigureFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventConfigureFieldInfo = (~) (Ptr Gdk.EventConfigure.EventConfigure)
    type AttrTransferTypeConstraint EventConfigureFieldInfo = (~)(Ptr Gdk.EventConfigure.EventConfigure)
    type AttrTransferType EventConfigureFieldInfo = (Ptr Gdk.EventConfigure.EventConfigure)
    type AttrGetType EventConfigureFieldInfo = Gdk.EventConfigure.EventConfigure
    type AttrLabel EventConfigureFieldInfo = "configure"
    type AttrOrigin EventConfigureFieldInfo = Event
    attrGet = getEventConfigure
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.configure"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:configure"
        })

event_configure :: AttrLabelProxy "configure"
event_configure = AttrLabelProxy

#endif


-- | Get the value of the “@property@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #property
-- @
getEventProperty :: MonadIO m => Event -> m Gdk.EventProperty.EventProperty
getEventProperty s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventProperty.EventProperty)
    val' <- (newPtr Gdk.EventProperty.EventProperty) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventPropertyFieldInfo
instance AttrInfo EventPropertyFieldInfo where
    type AttrBaseTypeConstraint EventPropertyFieldInfo = (~) Event
    type AttrAllowedOps EventPropertyFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventPropertyFieldInfo = (~) (Ptr Gdk.EventProperty.EventProperty)
    type AttrTransferTypeConstraint EventPropertyFieldInfo = (~)(Ptr Gdk.EventProperty.EventProperty)
    type AttrTransferType EventPropertyFieldInfo = (Ptr Gdk.EventProperty.EventProperty)
    type AttrGetType EventPropertyFieldInfo = Gdk.EventProperty.EventProperty
    type AttrLabel EventPropertyFieldInfo = "property"
    type AttrOrigin EventPropertyFieldInfo = Event
    attrGet = getEventProperty
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.property"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:property"
        })

event_property :: AttrLabelProxy "property"
event_property = AttrLabelProxy

#endif


-- | Get the value of the “@selection@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #selection
-- @
getEventSelection :: MonadIO m => Event -> m Gdk.EventSelection.EventSelection
getEventSelection s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventSelection.EventSelection)
    val' <- (newPtr Gdk.EventSelection.EventSelection) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventSelectionFieldInfo
instance AttrInfo EventSelectionFieldInfo where
    type AttrBaseTypeConstraint EventSelectionFieldInfo = (~) Event
    type AttrAllowedOps EventSelectionFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventSelectionFieldInfo = (~) (Ptr Gdk.EventSelection.EventSelection)
    type AttrTransferTypeConstraint EventSelectionFieldInfo = (~)(Ptr Gdk.EventSelection.EventSelection)
    type AttrTransferType EventSelectionFieldInfo = (Ptr Gdk.EventSelection.EventSelection)
    type AttrGetType EventSelectionFieldInfo = Gdk.EventSelection.EventSelection
    type AttrLabel EventSelectionFieldInfo = "selection"
    type AttrOrigin EventSelectionFieldInfo = Event
    attrGet = getEventSelection
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.selection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:selection"
        })

event_selection :: AttrLabelProxy "selection"
event_selection = AttrLabelProxy

#endif


-- | Get the value of the “@owner_change@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #ownerChange
-- @
getEventOwnerChange :: MonadIO m => Event -> m Gdk.EventOwnerChange.EventOwnerChange
getEventOwnerChange s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventOwnerChange.EventOwnerChange)
    val' <- (newPtr Gdk.EventOwnerChange.EventOwnerChange) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventOwnerChangeFieldInfo
instance AttrInfo EventOwnerChangeFieldInfo where
    type AttrBaseTypeConstraint EventOwnerChangeFieldInfo = (~) Event
    type AttrAllowedOps EventOwnerChangeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventOwnerChangeFieldInfo = (~) (Ptr Gdk.EventOwnerChange.EventOwnerChange)
    type AttrTransferTypeConstraint EventOwnerChangeFieldInfo = (~)(Ptr Gdk.EventOwnerChange.EventOwnerChange)
    type AttrTransferType EventOwnerChangeFieldInfo = (Ptr Gdk.EventOwnerChange.EventOwnerChange)
    type AttrGetType EventOwnerChangeFieldInfo = Gdk.EventOwnerChange.EventOwnerChange
    type AttrLabel EventOwnerChangeFieldInfo = "owner_change"
    type AttrOrigin EventOwnerChangeFieldInfo = Event
    attrGet = getEventOwnerChange
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.ownerChange"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:ownerChange"
        })

event_ownerChange :: AttrLabelProxy "ownerChange"
event_ownerChange = AttrLabelProxy

#endif


-- | Get the value of the “@proximity@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #proximity
-- @
getEventProximity :: MonadIO m => Event -> m Gdk.EventProximity.EventProximity
getEventProximity s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventProximity.EventProximity)
    val' <- (newPtr Gdk.EventProximity.EventProximity) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventProximityFieldInfo
instance AttrInfo EventProximityFieldInfo where
    type AttrBaseTypeConstraint EventProximityFieldInfo = (~) Event
    type AttrAllowedOps EventProximityFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventProximityFieldInfo = (~) (Ptr Gdk.EventProximity.EventProximity)
    type AttrTransferTypeConstraint EventProximityFieldInfo = (~)(Ptr Gdk.EventProximity.EventProximity)
    type AttrTransferType EventProximityFieldInfo = (Ptr Gdk.EventProximity.EventProximity)
    type AttrGetType EventProximityFieldInfo = Gdk.EventProximity.EventProximity
    type AttrLabel EventProximityFieldInfo = "proximity"
    type AttrOrigin EventProximityFieldInfo = Event
    attrGet = getEventProximity
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.proximity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:proximity"
        })

event_proximity :: AttrLabelProxy "proximity"
event_proximity = AttrLabelProxy

#endif


-- | Get the value of the “@dnd@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #dnd
-- @
getEventDnd :: MonadIO m => Event -> m Gdk.EventDND.EventDND
getEventDnd s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventDND.EventDND)
    val' <- (newPtr Gdk.EventDND.EventDND) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventDndFieldInfo
instance AttrInfo EventDndFieldInfo where
    type AttrBaseTypeConstraint EventDndFieldInfo = (~) Event
    type AttrAllowedOps EventDndFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventDndFieldInfo = (~) (Ptr Gdk.EventDND.EventDND)
    type AttrTransferTypeConstraint EventDndFieldInfo = (~)(Ptr Gdk.EventDND.EventDND)
    type AttrTransferType EventDndFieldInfo = (Ptr Gdk.EventDND.EventDND)
    type AttrGetType EventDndFieldInfo = Gdk.EventDND.EventDND
    type AttrLabel EventDndFieldInfo = "dnd"
    type AttrOrigin EventDndFieldInfo = Event
    attrGet = getEventDnd
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.dnd"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:dnd"
        })

event_dnd :: AttrLabelProxy "dnd"
event_dnd = AttrLabelProxy

#endif


-- | Get the value of the “@window_state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #windowState
-- @
getEventWindowState :: MonadIO m => Event -> m Gdk.EventWindowState.EventWindowState
getEventWindowState s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventWindowState.EventWindowState)
    val' <- (newPtr Gdk.EventWindowState.EventWindowState) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventWindowStateFieldInfo
instance AttrInfo EventWindowStateFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateFieldInfo = (~) Event
    type AttrAllowedOps EventWindowStateFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventWindowStateFieldInfo = (~) (Ptr Gdk.EventWindowState.EventWindowState)
    type AttrTransferTypeConstraint EventWindowStateFieldInfo = (~)(Ptr Gdk.EventWindowState.EventWindowState)
    type AttrTransferType EventWindowStateFieldInfo = (Ptr Gdk.EventWindowState.EventWindowState)
    type AttrGetType EventWindowStateFieldInfo = Gdk.EventWindowState.EventWindowState
    type AttrLabel EventWindowStateFieldInfo = "window_state"
    type AttrOrigin EventWindowStateFieldInfo = Event
    attrGet = getEventWindowState
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.windowState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:windowState"
        })

event_windowState :: AttrLabelProxy "windowState"
event_windowState = AttrLabelProxy

#endif


-- | Get the value of the “@setting@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #setting
-- @
getEventSetting :: MonadIO m => Event -> m Gdk.EventSetting.EventSetting
getEventSetting s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventSetting.EventSetting)
    val' <- (newPtr Gdk.EventSetting.EventSetting) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventSettingFieldInfo
instance AttrInfo EventSettingFieldInfo where
    type AttrBaseTypeConstraint EventSettingFieldInfo = (~) Event
    type AttrAllowedOps EventSettingFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventSettingFieldInfo = (~) (Ptr Gdk.EventSetting.EventSetting)
    type AttrTransferTypeConstraint EventSettingFieldInfo = (~)(Ptr Gdk.EventSetting.EventSetting)
    type AttrTransferType EventSettingFieldInfo = (Ptr Gdk.EventSetting.EventSetting)
    type AttrGetType EventSettingFieldInfo = Gdk.EventSetting.EventSetting
    type AttrLabel EventSettingFieldInfo = "setting"
    type AttrOrigin EventSettingFieldInfo = Event
    attrGet = getEventSetting
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.setting"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:setting"
        })

event_setting :: AttrLabelProxy "setting"
event_setting = AttrLabelProxy

#endif


-- | Get the value of the “@grab_broken@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #grabBroken
-- @
getEventGrabBroken :: MonadIO m => Event -> m Gdk.EventGrabBroken.EventGrabBroken
getEventGrabBroken s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventGrabBroken.EventGrabBroken)
    val' <- (newPtr Gdk.EventGrabBroken.EventGrabBroken) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenFieldInfo
instance AttrInfo EventGrabBrokenFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenFieldInfo = (~) Event
    type AttrAllowedOps EventGrabBrokenFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventGrabBrokenFieldInfo = (~) (Ptr Gdk.EventGrabBroken.EventGrabBroken)
    type AttrTransferTypeConstraint EventGrabBrokenFieldInfo = (~)(Ptr Gdk.EventGrabBroken.EventGrabBroken)
    type AttrTransferType EventGrabBrokenFieldInfo = (Ptr Gdk.EventGrabBroken.EventGrabBroken)
    type AttrGetType EventGrabBrokenFieldInfo = Gdk.EventGrabBroken.EventGrabBroken
    type AttrLabel EventGrabBrokenFieldInfo = "grab_broken"
    type AttrOrigin EventGrabBrokenFieldInfo = Event
    attrGet = getEventGrabBroken
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.grabBroken"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:grabBroken"
        })

event_grabBroken :: AttrLabelProxy "grabBroken"
event_grabBroken = AttrLabelProxy

#endif


-- | Get the value of the “@touchpad_swipe@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #touchpadSwipe
-- @
getEventTouchpadSwipe :: MonadIO m => Event -> m Gdk.EventTouchpadSwipe.EventTouchpadSwipe
getEventTouchpadSwipe s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventTouchpadSwipe.EventTouchpadSwipe)
    val' <- (newPtr Gdk.EventTouchpadSwipe.EventTouchpadSwipe) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeFieldInfo
instance AttrInfo EventTouchpadSwipeFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeFieldInfo = (~) Event
    type AttrAllowedOps EventTouchpadSwipeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeFieldInfo = (~) (Ptr Gdk.EventTouchpadSwipe.EventTouchpadSwipe)
    type AttrTransferTypeConstraint EventTouchpadSwipeFieldInfo = (~)(Ptr Gdk.EventTouchpadSwipe.EventTouchpadSwipe)
    type AttrTransferType EventTouchpadSwipeFieldInfo = (Ptr Gdk.EventTouchpadSwipe.EventTouchpadSwipe)
    type AttrGetType EventTouchpadSwipeFieldInfo = Gdk.EventTouchpadSwipe.EventTouchpadSwipe
    type AttrLabel EventTouchpadSwipeFieldInfo = "touchpad_swipe"
    type AttrOrigin EventTouchpadSwipeFieldInfo = Event
    attrGet = getEventTouchpadSwipe
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.touchpadSwipe"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:touchpadSwipe"
        })

event_touchpadSwipe :: AttrLabelProxy "touchpadSwipe"
event_touchpadSwipe = AttrLabelProxy

#endif


-- | Get the value of the “@touchpad_pinch@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #touchpadPinch
-- @
getEventTouchpadPinch :: MonadIO m => Event -> m Gdk.EventTouchpadPinch.EventTouchpadPinch
getEventTouchpadPinch s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventTouchpadPinch.EventTouchpadPinch)
    val' <- (newPtr Gdk.EventTouchpadPinch.EventTouchpadPinch) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchFieldInfo
instance AttrInfo EventTouchpadPinchFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchFieldInfo = (~) Event
    type AttrAllowedOps EventTouchpadPinchFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchFieldInfo = (~) (Ptr Gdk.EventTouchpadPinch.EventTouchpadPinch)
    type AttrTransferTypeConstraint EventTouchpadPinchFieldInfo = (~)(Ptr Gdk.EventTouchpadPinch.EventTouchpadPinch)
    type AttrTransferType EventTouchpadPinchFieldInfo = (Ptr Gdk.EventTouchpadPinch.EventTouchpadPinch)
    type AttrGetType EventTouchpadPinchFieldInfo = Gdk.EventTouchpadPinch.EventTouchpadPinch
    type AttrLabel EventTouchpadPinchFieldInfo = "touchpad_pinch"
    type AttrOrigin EventTouchpadPinchFieldInfo = Event
    attrGet = getEventTouchpadPinch
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.touchpadPinch"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:touchpadPinch"
        })

event_touchpadPinch :: AttrLabelProxy "touchpadPinch"
event_touchpadPinch = AttrLabelProxy

#endif


-- | Get the value of the “@pad_button@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #padButton
-- @
getEventPadButton :: MonadIO m => Event -> m Gdk.EventPadButton.EventPadButton
getEventPadButton s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventPadButton.EventPadButton)
    val' <- (newPtr Gdk.EventPadButton.EventPadButton) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventPadButtonFieldInfo
instance AttrInfo EventPadButtonFieldInfo where
    type AttrBaseTypeConstraint EventPadButtonFieldInfo = (~) Event
    type AttrAllowedOps EventPadButtonFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventPadButtonFieldInfo = (~) (Ptr Gdk.EventPadButton.EventPadButton)
    type AttrTransferTypeConstraint EventPadButtonFieldInfo = (~)(Ptr Gdk.EventPadButton.EventPadButton)
    type AttrTransferType EventPadButtonFieldInfo = (Ptr Gdk.EventPadButton.EventPadButton)
    type AttrGetType EventPadButtonFieldInfo = Gdk.EventPadButton.EventPadButton
    type AttrLabel EventPadButtonFieldInfo = "pad_button"
    type AttrOrigin EventPadButtonFieldInfo = Event
    attrGet = getEventPadButton
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.padButton"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:padButton"
        })

event_padButton :: AttrLabelProxy "padButton"
event_padButton = AttrLabelProxy

#endif


-- | Get the value of the “@pad_axis@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #padAxis
-- @
getEventPadAxis :: MonadIO m => Event -> m Gdk.EventPadAxis.EventPadAxis
getEventPadAxis s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventPadAxis.EventPadAxis)
    val' <- (newPtr Gdk.EventPadAxis.EventPadAxis) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventPadAxisFieldInfo
instance AttrInfo EventPadAxisFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisFieldInfo = (~) Event
    type AttrAllowedOps EventPadAxisFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisFieldInfo = (~) (Ptr Gdk.EventPadAxis.EventPadAxis)
    type AttrTransferTypeConstraint EventPadAxisFieldInfo = (~)(Ptr Gdk.EventPadAxis.EventPadAxis)
    type AttrTransferType EventPadAxisFieldInfo = (Ptr Gdk.EventPadAxis.EventPadAxis)
    type AttrGetType EventPadAxisFieldInfo = Gdk.EventPadAxis.EventPadAxis
    type AttrLabel EventPadAxisFieldInfo = "pad_axis"
    type AttrOrigin EventPadAxisFieldInfo = Event
    attrGet = getEventPadAxis
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.padAxis"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:padAxis"
        })

event_padAxis :: AttrLabelProxy "padAxis"
event_padAxis = AttrLabelProxy

#endif


-- | Get the value of the “@pad_group_mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' event #padGroupMode
-- @
getEventPadGroupMode :: MonadIO m => Event -> m Gdk.EventPadGroupMode.EventPadGroupMode
getEventPadGroupMode s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Gdk.EventPadGroupMode.EventPadGroupMode)
    val' <- (newPtr Gdk.EventPadGroupMode.EventPadGroupMode) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeFieldInfo
instance AttrInfo EventPadGroupModeFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeFieldInfo = (~) Event
    type AttrAllowedOps EventPadGroupModeFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeFieldInfo = (~) (Ptr Gdk.EventPadGroupMode.EventPadGroupMode)
    type AttrTransferTypeConstraint EventPadGroupModeFieldInfo = (~)(Ptr Gdk.EventPadGroupMode.EventPadGroupMode)
    type AttrTransferType EventPadGroupModeFieldInfo = (Ptr Gdk.EventPadGroupMode.EventPadGroupMode)
    type AttrGetType EventPadGroupModeFieldInfo = Gdk.EventPadGroupMode.EventPadGroupMode
    type AttrLabel EventPadGroupModeFieldInfo = "pad_group_mode"
    type AttrOrigin EventPadGroupModeFieldInfo = Event
    attrGet = getEventPadGroupMode
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.padGroupMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#g:attr:padGroupMode"
        })

event_padGroupMode :: AttrLabelProxy "padGroupMode"
event_padGroupMode = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Event
type instance O.AttributeList Event = EventAttributeList
type EventAttributeList = ('[ '("type", EventTypeFieldInfo), '("any", EventAnyFieldInfo), '("expose", EventExposeFieldInfo), '("visibility", EventVisibilityFieldInfo), '("motion", EventMotionFieldInfo), '("button", EventButtonFieldInfo), '("touch", EventTouchFieldInfo), '("scroll", EventScrollFieldInfo), '("key", EventKeyFieldInfo), '("crossing", EventCrossingFieldInfo), '("focusChange", EventFocusChangeFieldInfo), '("configure", EventConfigureFieldInfo), '("property", EventPropertyFieldInfo), '("selection", EventSelectionFieldInfo), '("ownerChange", EventOwnerChangeFieldInfo), '("proximity", EventProximityFieldInfo), '("dnd", EventDndFieldInfo), '("windowState", EventWindowStateFieldInfo), '("setting", EventSettingFieldInfo), '("grabBroken", EventGrabBrokenFieldInfo), '("touchpadSwipe", EventTouchpadSwipeFieldInfo), '("touchpadPinch", EventTouchpadPinchFieldInfo), '("padButton", EventPadButtonFieldInfo), '("padAxis", EventPadAxisFieldInfo), '("padGroupMode", EventPadGroupModeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Event::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEventType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_new" gdk_event_new :: 
    CInt ->                                 -- type : TInterface (Name {namespace = "Gdk", name = "EventType"})
    IO (Ptr Event)

-- | Creates a new event of the given type. All fields are set to 0.
-- 
-- /Since: 2.2/
eventNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Enums.EventType
    -- ^ /@type@/: a t'GI.Gdk.Enums.EventType'
    -> m Event
    -- ^ __Returns:__ a newly-allocated t'GI.Gdk.Unions.Event.Event'. The returned t'GI.Gdk.Unions.Event.Event'
    -- should be freed with 'GI.Gdk.Unions.Event.eventFree'.
eventNew type_ = liftIO $ do
    let type_' = (fromIntegral . fromEnum) type_
    result <- gdk_event_new type_'
    checkUnexpectedReturnNULL "eventNew" result
    result' <- (wrapBoxed Event) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Event::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_copy" gdk_event_copy :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Event)

-- | Copies a t'GI.Gdk.Unions.Event.Event', copying or incrementing the reference count of the
-- resources associated with it (e.g. t'GI.Gdk.Objects.Window.Window'’s and strings).
eventCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Event
    -- ^ __Returns:__ a copy of /@event@/. The returned t'GI.Gdk.Unions.Event.Event' should be freed with
    -- 'GI.Gdk.Unions.Event.eventFree'.
eventCopy event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_copy event'
    checkUnexpectedReturnNULL "eventCopy" result
    result' <- (wrapBoxed Event) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventCopyMethodInfo
instance (signature ~ (m Event), MonadIO m) => O.OverloadedMethod EventCopyMethodInfo Event signature where
    overloadedMethod = eventCopy

instance O.OverloadedMethodInfo EventCopyMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventCopy"
        })


#endif

-- method Event::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_free" gdk_event_free :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

-- | Frees a t'GI.Gdk.Unions.Event.Event', freeing or decrementing any resources associated with it.
-- Note that this function should only be called with events returned from
-- functions such as 'GI.Gdk.Functions.eventPeek', 'GI.Gdk.Functions.eventGet', 'GI.Gdk.Unions.Event.eventCopy'
-- and 'GI.Gdk.Unions.Event.eventNew'.
eventFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'.
    -> m ()
eventFree event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    gdk_event_free event'
    touchManagedPtr event
    return ()

#if defined(ENABLE_OVERLOADING)
data EventFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod EventFreeMethodInfo Event signature where
    overloadedMethod = eventFree

instance O.OverloadedMethodInfo EventFreeMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventFree"
        })


#endif

-- method Event::get_axis
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "axis_use"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "AxisUse" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the axis use to look for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the value found"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_axis" gdk_event_get_axis :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    CUInt ->                                -- axis_use : TInterface (Name {namespace = "Gdk", name = "AxisUse"})
    Ptr CDouble ->                          -- value : TBasicType TDouble
    IO CInt

-- | Extract the axis value for a particular axis use from
-- an event structure.
eventGetAxis ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> Gdk.Enums.AxisUse
    -- ^ /@axisUse@/: the axis use to look for
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the specified axis was found, otherwise 'P.False'
eventGetAxis event axisUse = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    let axisUse' = (fromIntegral . fromEnum) axisUse
    value <- allocMem :: IO (Ptr CDouble)
    result <- gdk_event_get_axis event' axisUse' value
    let result' = (/= 0) result
    value' <- peek value
    let value'' = realToFrac value'
    touchManagedPtr event
    freeMem value
    return (result', value'')

#if defined(ENABLE_OVERLOADING)
data EventGetAxisMethodInfo
instance (signature ~ (Gdk.Enums.AxisUse -> m ((Bool, Double))), MonadIO m) => O.OverloadedMethod EventGetAxisMethodInfo Event signature where
    overloadedMethod = eventGetAxis

instance O.OverloadedMethodInfo EventGetAxisMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetAxis",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetAxis"
        })


#endif

-- method Event::get_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store mouse button number"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_button" gdk_event_get_button :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Word32 ->                           -- button : TBasicType TUInt
    IO CInt

-- | Extract the button number from an event.
-- 
-- /Since: 3.2/
eventGetButton ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Word32))
    -- ^ __Returns:__ 'P.True' if the event delivered a button number
eventGetButton event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    button <- allocMem :: IO (Ptr Word32)
    result <- gdk_event_get_button event' button
    let result' = (/= 0) result
    button' <- peek button
    touchManagedPtr event
    freeMem button
    return (result', button')

#if defined(ENABLE_OVERLOADING)
data EventGetButtonMethodInfo
instance (signature ~ (m ((Bool, Word32))), MonadIO m) => O.OverloadedMethod EventGetButtonMethodInfo Event signature where
    overloadedMethod = eventGetButton

instance O.OverloadedMethodInfo EventGetButtonMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetButton"
        })


#endif

-- method Event::get_click_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "click_count"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store click count"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_click_count" gdk_event_get_click_count :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Word32 ->                           -- click_count : TBasicType TUInt
    IO CInt

-- | Extracts the click count from an event.
-- 
-- /Since: 3.2/
eventGetClickCount ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Word32))
    -- ^ __Returns:__ 'P.True' if the event delivered a click count
eventGetClickCount event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    clickCount <- allocMem :: IO (Ptr Word32)
    result <- gdk_event_get_click_count event' clickCount
    let result' = (/= 0) result
    clickCount' <- peek clickCount
    touchManagedPtr event
    freeMem clickCount
    return (result', clickCount')

#if defined(ENABLE_OVERLOADING)
data EventGetClickCountMethodInfo
instance (signature ~ (m ((Bool, Word32))), MonadIO m) => O.OverloadedMethod EventGetClickCountMethodInfo Event signature where
    overloadedMethod = eventGetClickCount

instance O.OverloadedMethodInfo EventGetClickCountMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetClickCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetClickCount"
        })


#endif

-- method Event::get_coords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_win"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to put event window x coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_win"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to put event window y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_coords" gdk_event_get_coords :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- x_win : TBasicType TDouble
    Ptr CDouble ->                          -- y_win : TBasicType TDouble
    IO CInt

-- | Extract the event window relative x\/y coordinates from an event.
eventGetCoords ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double, Double))
    -- ^ __Returns:__ 'P.True' if the event delivered event window coordinates
eventGetCoords event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    xWin <- allocMem :: IO (Ptr CDouble)
    yWin <- allocMem :: IO (Ptr CDouble)
    result <- gdk_event_get_coords event' xWin yWin
    let result' = (/= 0) result
    xWin' <- peek xWin
    let xWin'' = realToFrac xWin'
    yWin' <- peek yWin
    let yWin'' = realToFrac yWin'
    touchManagedPtr event
    freeMem xWin
    freeMem yWin
    return (result', xWin'', yWin'')

#if defined(ENABLE_OVERLOADING)
data EventGetCoordsMethodInfo
instance (signature ~ (m ((Bool, Double, Double))), MonadIO m) => O.OverloadedMethod EventGetCoordsMethodInfo Event signature where
    overloadedMethod = eventGetCoords

instance O.OverloadedMethodInfo EventGetCoordsMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetCoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetCoords"
        })


#endif

-- method Event::get_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_device" gdk_event_get_device :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.Device.Device)

-- | If the event contains a “device” field, this function will return
-- it, else it will return 'P.Nothing'.
-- 
-- /Since: 3.0/
eventGetDevice ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'.
    -> m (Maybe Gdk.Device.Device)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Device.Device', or 'P.Nothing'.
eventGetDevice event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_device event'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Device.Device) result'
        return result''
    touchManagedPtr event
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventGetDeviceMethodInfo
instance (signature ~ (m (Maybe Gdk.Device.Device)), MonadIO m) => O.OverloadedMethod EventGetDeviceMethodInfo Event signature where
    overloadedMethod = eventGetDevice

instance O.OverloadedMethodInfo EventGetDeviceMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetDevice"
        })


#endif

-- method Event::get_device_tool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DeviceTool" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_device_tool" gdk_event_get_device_tool :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.DeviceTool.DeviceTool)

-- | If the event was generated by a device that supports
-- different tools (eg. a tablet), this function will
-- return a t'GI.Gdk.Objects.DeviceTool.DeviceTool' representing the tool that
-- caused the event. Otherwise, 'P.Nothing' will be returned.
-- 
-- Note: the t'GI.Gdk.Objects.DeviceTool.DeviceTool's will be constant during
-- the application lifetime, if settings must be stored
-- persistently across runs, see 'GI.Gdk.Objects.DeviceTool.deviceToolGetSerial'
-- 
-- /Since: 3.22/
eventGetDeviceTool ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.DeviceTool.DeviceTool
    -- ^ __Returns:__ The current device tool, or 'P.Nothing'
eventGetDeviceTool event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_device_tool event'
    checkUnexpectedReturnNULL "eventGetDeviceTool" result
    result' <- (newObject Gdk.DeviceTool.DeviceTool) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetDeviceToolMethodInfo
instance (signature ~ (m Gdk.DeviceTool.DeviceTool), MonadIO m) => O.OverloadedMethod EventGetDeviceToolMethodInfo Event signature where
    overloadedMethod = eventGetDeviceTool

instance O.OverloadedMethodInfo EventGetDeviceToolMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetDeviceTool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetDeviceTool"
        })


#endif

-- method Event::get_event_sequence
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "EventSequence" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_event_sequence" gdk_event_get_event_sequence :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.EventSequence.EventSequence)

-- | If /@event@/ if of type 'GI.Gdk.Enums.EventTypeTouchBegin', 'GI.Gdk.Enums.EventTypeTouchUpdate',
-- 'GI.Gdk.Enums.EventTypeTouchEnd' or 'GI.Gdk.Enums.EventTypeTouchCancel', returns the t'GI.Gdk.Structs.EventSequence.EventSequence'
-- to which the event belongs. Otherwise, return 'P.Nothing'.
-- 
-- /Since: 3.4/
eventGetEventSequence ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.EventSequence.EventSequence
    -- ^ __Returns:__ the event sequence that the event belongs to
eventGetEventSequence event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_event_sequence event'
    checkUnexpectedReturnNULL "eventGetEventSequence" result
    result' <- (newBoxed Gdk.EventSequence.EventSequence) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetEventSequenceMethodInfo
instance (signature ~ (m Gdk.EventSequence.EventSequence), MonadIO m) => O.OverloadedMethod EventGetEventSequenceMethodInfo Event signature where
    overloadedMethod = eventGetEventSequence

instance O.OverloadedMethodInfo EventGetEventSequenceMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetEventSequence",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetEventSequence"
        })


#endif

-- method Event::get_event_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "EventType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_event_type" gdk_event_get_event_type :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | Retrieves the type of the event.
-- 
-- /Since: 3.10/
eventGetEventType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.Enums.EventType
    -- ^ __Returns:__ a t'GI.Gdk.Enums.EventType'
eventGetEventType event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_event_type event'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetEventTypeMethodInfo
instance (signature ~ (m Gdk.Enums.EventType), MonadIO m) => O.OverloadedMethod EventGetEventTypeMethodInfo Event signature where
    overloadedMethod = eventGetEventType

instance O.OverloadedMethodInfo EventGetEventTypeMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetEventType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetEventType"
        })


#endif

-- method Event::get_keycode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt16
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the keycode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_keycode" gdk_event_get_keycode :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Word16 ->                           -- keycode : TBasicType TUInt16
    IO CInt

-- | Extracts the hardware keycode from an event.
-- 
-- Also see 'GI.Gdk.Unions.Event.eventGetScancode'.
-- 
-- /Since: 3.2/
eventGetKeycode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Word16))
    -- ^ __Returns:__ 'P.True' if the event delivered a hardware keycode
eventGetKeycode event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    keycode <- allocMem :: IO (Ptr Word16)
    result <- gdk_event_get_keycode event' keycode
    let result' = (/= 0) result
    keycode' <- peek keycode
    touchManagedPtr event
    freeMem keycode
    return (result', keycode')

#if defined(ENABLE_OVERLOADING)
data EventGetKeycodeMethodInfo
instance (signature ~ (m ((Bool, Word16))), MonadIO m) => O.OverloadedMethod EventGetKeycodeMethodInfo Event signature where
    overloadedMethod = eventGetKeycode

instance O.OverloadedMethodInfo EventGetKeycodeMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetKeycode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetKeycode"
        })


#endif

-- method Event::get_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the keyval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_keyval" gdk_event_get_keyval :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Word32 ->                           -- keyval : TBasicType TUInt
    IO CInt

-- | Extracts the keyval from an event.
-- 
-- /Since: 3.2/
eventGetKeyval ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Word32))
    -- ^ __Returns:__ 'P.True' if the event delivered a key symbol
eventGetKeyval event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    keyval <- allocMem :: IO (Ptr Word32)
    result <- gdk_event_get_keyval event' keyval
    let result' = (/= 0) result
    keyval' <- peek keyval
    touchManagedPtr event
    freeMem keyval
    return (result', keyval')

#if defined(ENABLE_OVERLOADING)
data EventGetKeyvalMethodInfo
instance (signature ~ (m ((Bool, Word32))), MonadIO m) => O.OverloadedMethod EventGetKeyvalMethodInfo Event signature where
    overloadedMethod = eventGetKeyval

instance O.OverloadedMethodInfo EventGetKeyvalMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetKeyval"
        })


#endif

-- method Event::get_pointer_emulated
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_pointer_emulated" gdk_event_get_pointer_emulated :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | @/event/@: a t'GI.Gdk.Unions.Event.Event'
-- Returns whether this event is an \'emulated\' pointer event (typically
-- from a touch event), as opposed to a real one.
-- 
-- /Since: 3.22/
eventGetPointerEmulated ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if this event is emulated
eventGetPointerEmulated event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_pointer_emulated event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetPointerEmulatedMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod EventGetPointerEmulatedMethodInfo Event signature where
    overloadedMethod = eventGetPointerEmulated

instance O.OverloadedMethodInfo EventGetPointerEmulatedMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetPointerEmulated",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetPointerEmulated"
        })


#endif

-- method Event::get_root_coords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_root"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to put root window x coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_root"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to put root window y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_root_coords" gdk_event_get_root_coords :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- x_root : TBasicType TDouble
    Ptr CDouble ->                          -- y_root : TBasicType TDouble
    IO CInt

-- | Extract the root window relative x\/y coordinates from an event.
eventGetRootCoords ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double, Double))
    -- ^ __Returns:__ 'P.True' if the event delivered root window coordinates
eventGetRootCoords event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    xRoot <- allocMem :: IO (Ptr CDouble)
    yRoot <- allocMem :: IO (Ptr CDouble)
    result <- gdk_event_get_root_coords event' xRoot yRoot
    let result' = (/= 0) result
    xRoot' <- peek xRoot
    let xRoot'' = realToFrac xRoot'
    yRoot' <- peek yRoot
    let yRoot'' = realToFrac yRoot'
    touchManagedPtr event
    freeMem xRoot
    freeMem yRoot
    return (result', xRoot'', yRoot'')

#if defined(ENABLE_OVERLOADING)
data EventGetRootCoordsMethodInfo
instance (signature ~ (m ((Bool, Double, Double))), MonadIO m) => O.OverloadedMethod EventGetRootCoordsMethodInfo Event signature where
    overloadedMethod = eventGetRootCoords

instance O.OverloadedMethodInfo EventGetRootCoordsMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetRootCoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetRootCoords"
        })


#endif

-- method Event::get_scancode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_scancode" gdk_event_get_scancode :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO Int32

-- | Gets the keyboard low-level scancode of a key event.
-- 
-- This is usually hardware_keycode. On Windows this is the high
-- word of WM_KEY{DOWN,UP} lParam which contains the scancode and
-- some extended flags.
-- 
-- /Since: 3.22/
eventGetScancode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Int32
    -- ^ __Returns:__ The associated keyboard scancode or 0
eventGetScancode event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_scancode event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data EventGetScancodeMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod EventGetScancodeMethodInfo Event signature where
    overloadedMethod = eventGetScancode

instance O.OverloadedMethodInfo EventGetScancodeMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetScancode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetScancode"
        })


#endif

-- method Event::get_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_screen" gdk_event_get_screen :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.Screen.Screen)

-- | Returns the screen for the event. The screen is
-- typically the screen for @event->any.window@, but
-- for events such as mouse events, it is the screen
-- where the pointer was when the event occurs -
-- that is, the screen which has the root window
-- to which @event->motion.x_root@ and
-- @event->motion.y_root@ are relative.
-- 
-- /Since: 2.2/
eventGetScreen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.Screen.Screen
    -- ^ __Returns:__ the screen for the event
eventGetScreen event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_screen event'
    checkUnexpectedReturnNULL "eventGetScreen" result
    result' <- (newObject Gdk.Screen.Screen) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetScreenMethodInfo
instance (signature ~ (m Gdk.Screen.Screen), MonadIO m) => O.OverloadedMethod EventGetScreenMethodInfo Event signature where
    overloadedMethod = eventGetScreen

instance O.OverloadedMethodInfo EventGetScreenMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetScreen"
        })


#endif

-- method Event::get_scroll_deltas
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delta_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for X delta"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "delta_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for Y delta"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_scroll_deltas" gdk_event_get_scroll_deltas :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- delta_x : TBasicType TDouble
    Ptr CDouble ->                          -- delta_y : TBasicType TDouble
    IO CInt

-- | Retrieves the scroll deltas from a t'GI.Gdk.Unions.Event.Event'
-- 
-- See also: 'GI.Gdk.Unions.Event.eventGetScrollDirection'
-- 
-- /Since: 3.4/
eventGetScrollDeltas ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double, Double))
    -- ^ __Returns:__ 'P.True' if the event contains smooth scroll information
    --   and 'P.False' otherwise
eventGetScrollDeltas event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    deltaX <- allocMem :: IO (Ptr CDouble)
    deltaY <- allocMem :: IO (Ptr CDouble)
    result <- gdk_event_get_scroll_deltas event' deltaX deltaY
    let result' = (/= 0) result
    deltaX' <- peek deltaX
    let deltaX'' = realToFrac deltaX'
    deltaY' <- peek deltaY
    let deltaY'' = realToFrac deltaY'
    touchManagedPtr event
    freeMem deltaX
    freeMem deltaY
    return (result', deltaX'', deltaY'')

#if defined(ENABLE_OVERLOADING)
data EventGetScrollDeltasMethodInfo
instance (signature ~ (m ((Bool, Double, Double))), MonadIO m) => O.OverloadedMethod EventGetScrollDeltasMethodInfo Event signature where
    overloadedMethod = eventGetScrollDeltas

instance O.OverloadedMethodInfo EventGetScrollDeltasMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetScrollDeltas",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetScrollDeltas"
        })


#endif

-- method Event::get_scroll_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "direction"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ScrollDirection" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the scroll direction"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_scroll_direction" gdk_event_get_scroll_direction :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CUInt ->                            -- direction : TInterface (Name {namespace = "Gdk", name = "ScrollDirection"})
    IO CInt

-- | Extracts the scroll direction from an event.
-- 
-- If /@event@/ is not of type 'GI.Gdk.Enums.EventTypeScroll', the contents of /@direction@/
-- are undefined.
-- 
-- If you wish to handle both discrete and smooth scrolling, you
-- should check the return value of this function, or of
-- 'GI.Gdk.Unions.Event.eventGetScrollDeltas'; for instance:
-- 
-- 
-- === /C code/
-- >
-- >  GdkScrollDirection direction;
-- >  double vscroll_factor = 0.0;
-- >  double x_scroll, y_scroll;
-- >
-- >  if (gdk_event_get_scroll_direction (event, &direction))
-- >    {
-- >      // Handle discrete scrolling with a known constant delta;
-- >      const double delta = 12.0;
-- >
-- >      switch (direction)
-- >        {
-- >        case GDK_SCROLL_UP:
-- >          vscroll_factor = -delta;
-- >          break;
-- >        case GDK_SCROLL_DOWN:
-- >          vscroll_factor = delta;
-- >          break;
-- >        default:
-- >          // no scrolling
-- >          break;
-- >        }
-- >    }
-- >  else if (gdk_event_get_scroll_deltas (event, &x_scroll, &y_scroll))
-- >    {
-- >      // Handle smooth scrolling directly
-- >      vscroll_factor = y_scroll;
-- >    }
-- 
-- 
-- /Since: 3.2/
eventGetScrollDirection ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Gdk.Enums.ScrollDirection))
    -- ^ __Returns:__ 'P.True' if the event delivered a scroll direction
    --   and 'P.False' otherwise
eventGetScrollDirection event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    direction <- allocMem :: IO (Ptr CUInt)
    result <- gdk_event_get_scroll_direction event' direction
    let result' = (/= 0) result
    direction' <- peek direction
    let direction'' = (toEnum . fromIntegral) direction'
    touchManagedPtr event
    freeMem direction
    return (result', direction'')

#if defined(ENABLE_OVERLOADING)
data EventGetScrollDirectionMethodInfo
instance (signature ~ (m ((Bool, Gdk.Enums.ScrollDirection))), MonadIO m) => O.OverloadedMethod EventGetScrollDirectionMethodInfo Event signature where
    overloadedMethod = eventGetScrollDirection

instance O.OverloadedMethodInfo EventGetScrollDirectionMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetScrollDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetScrollDirection"
        })


#endif

-- method Event::get_seat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Seat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_seat" gdk_event_get_seat :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.Seat.Seat)

-- | Returns the t'GI.Gdk.Objects.Seat.Seat' this event was generated for.
-- 
-- /Since: 3.20/
eventGetSeat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.Seat.Seat
    -- ^ __Returns:__ The t'GI.Gdk.Objects.Seat.Seat' of this event
eventGetSeat event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_seat event'
    checkUnexpectedReturnNULL "eventGetSeat" result
    result' <- (newObject Gdk.Seat.Seat) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetSeatMethodInfo
instance (signature ~ (m Gdk.Seat.Seat), MonadIO m) => O.OverloadedMethod EventGetSeatMethodInfo Event signature where
    overloadedMethod = eventGetSeat

instance O.OverloadedMethodInfo EventGetSeatMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetSeat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetSeat"
        })


#endif

-- method Event::get_source_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_source_device" gdk_event_get_source_device :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.Device.Device)

-- | This function returns the hardware (slave) t'GI.Gdk.Objects.Device.Device' that has
-- triggered the event, falling back to the virtual (master) device
-- (as in 'GI.Gdk.Unions.Event.eventGetDevice') if the event wasn’t caused by
-- interaction with a hardware device. This may happen for example
-- in synthesized crossing events after a t'GI.Gdk.Objects.Window.Window' updates its
-- geometry or a grab is acquired\/released.
-- 
-- If the event does not contain a device field, this function will
-- return 'P.Nothing'.
-- 
-- /Since: 3.0/
eventGetSourceDevice ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m (Maybe Gdk.Device.Device)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Device.Device', or 'P.Nothing'.
eventGetSourceDevice event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_source_device event'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Device.Device) result'
        return result''
    touchManagedPtr event
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data EventGetSourceDeviceMethodInfo
instance (signature ~ (m (Maybe Gdk.Device.Device)), MonadIO m) => O.OverloadedMethod EventGetSourceDeviceMethodInfo Event signature where
    overloadedMethod = eventGetSourceDevice

instance O.OverloadedMethodInfo EventGetSourceDeviceMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetSourceDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetSourceDevice"
        })


#endif

-- method Event::get_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for state"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_state" gdk_event_get_state :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CUInt ->                            -- state : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | If the event contains a “state” field, puts that field in /@state@/. Otherwise
-- stores an empty state (0). Returns 'P.True' if there was a state field
-- in the event. /@event@/ may be 'P.Nothing', in which case it’s treated
-- as if the event had no state field.
eventGetState ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event' or 'P.Nothing'
    -> m ((Bool, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.True' if there was a state field in the event
eventGetState event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    state <- allocMem :: IO (Ptr CUInt)
    result <- gdk_event_get_state event' state
    let result' = (/= 0) result
    state' <- peek state
    let state'' = wordToGFlags state'
    touchManagedPtr event
    freeMem state
    return (result', state'')

#if defined(ENABLE_OVERLOADING)
data EventGetStateMethodInfo
instance (signature ~ (m ((Bool, [Gdk.Flags.ModifierType]))), MonadIO m) => O.OverloadedMethod EventGetStateMethodInfo Event signature where
    overloadedMethod = eventGetState

instance O.OverloadedMethodInfo EventGetStateMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetState"
        })


#endif

-- method Event::get_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_time" gdk_event_get_time :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO Word32

-- | Returns the time stamp from /@event@/, if there is one; otherwise
-- returns 'GI.Gdk.Constants.CURRENT_TIME'. If /@event@/ is 'P.Nothing', returns 'GI.Gdk.Constants.CURRENT_TIME'.
eventGetTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Word32
    -- ^ __Returns:__ time stamp field from /@event@/
eventGetTime event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_time event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data EventGetTimeMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod EventGetTimeMethodInfo Event signature where
    overloadedMethod = eventGetTime

instance O.OverloadedMethodInfo EventGetTimeMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetTime"
        })


#endif

-- method Event::get_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get_window" gdk_event_get_window :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO (Ptr Gdk.Window.Window)

-- | Extracts the t'GI.Gdk.Objects.Window.Window' associated with an event.
-- 
-- /Since: 3.10/
eventGetWindow ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ The t'GI.Gdk.Objects.Window.Window' associated with the event
eventGetWindow event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_get_window event'
    checkUnexpectedReturnNULL "eventGetWindow" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventGetWindowMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m) => O.OverloadedMethod EventGetWindowMethodInfo Event signature where
    overloadedMethod = eventGetWindow

instance O.OverloadedMethodInfo EventGetWindowMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventGetWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventGetWindow"
        })


#endif

-- method Event::is_scroll_stop_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_is_scroll_stop_event" gdk_event_is_scroll_stop_event :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | Check whether a scroll event is a stop scroll event. Scroll sequences
-- with smooth scroll information may provide a stop scroll event once the
-- interaction with the device finishes, e.g. by lifting a finger. This
-- stop scroll event is the signal that a widget may trigger kinetic
-- scrolling based on the current velocity.
-- 
-- Stop scroll events always have a a delta of 0\/0.
-- 
-- /Since: 3.20/
eventIsScrollStopEvent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the event is a scroll stop event
eventIsScrollStopEvent event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_is_scroll_stop_event event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventIsScrollStopEventMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod EventIsScrollStopEventMethodInfo Event signature where
    overloadedMethod = eventIsScrollStopEvent

instance O.OverloadedMethodInfo EventIsScrollStopEventMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventIsScrollStopEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventIsScrollStopEvent"
        })


#endif

-- method Event::put
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_put" gdk_event_put :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

-- | Appends a copy of the given event onto the front of the event
-- queue for event->any.window’s display, or the default event
-- queue if event->any.window is 'P.Nothing'. See 'GI.Gdk.Objects.Display.displayPutEvent'.
eventPut ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'.
    -> m ()
eventPut event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    gdk_event_put event'
    touchManagedPtr event
    return ()

#if defined(ENABLE_OVERLOADING)
data EventPutMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod EventPutMethodInfo Event signature where
    overloadedMethod = eventPut

instance O.OverloadedMethodInfo EventPutMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventPut",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventPut"
        })


#endif

-- method Event::set_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_set_device" gdk_event_set_device :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO ()

-- | Sets the device for /@event@/ to /@device@/. The event must
-- have been allocated by GTK+, for instance, by
-- 'GI.Gdk.Unions.Event.eventCopy'.
-- 
-- /Since: 3.0/
eventSetDevice ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Device.IsDevice a) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m ()
eventSetDevice event device = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    device' <- unsafeManagedPtrCastPtr device
    gdk_event_set_device event' device'
    touchManagedPtr event
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data EventSetDeviceMethodInfo
instance (signature ~ (a -> m ()), MonadIO m, Gdk.Device.IsDevice a) => O.OverloadedMethod EventSetDeviceMethodInfo Event signature where
    overloadedMethod = eventSetDevice

instance O.OverloadedMethodInfo EventSetDeviceMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventSetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventSetDevice"
        })


#endif

-- method Event::set_device_tool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tool"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DeviceTool" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "tool to set on the event, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_set_device_tool" gdk_event_set_device_tool :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.DeviceTool.DeviceTool ->        -- tool : TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
    IO ()

-- | Sets the device tool for this event, should be rarely used.
-- 
-- /Since: 3.22/
eventSetDeviceTool ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DeviceTool.IsDeviceTool a) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> Maybe (a)
    -- ^ /@tool@/: tool to set on the event, or 'P.Nothing'
    -> m ()
eventSetDeviceTool event tool = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    maybeTool <- case tool of
        Nothing -> return nullPtr
        Just jTool -> do
            jTool' <- unsafeManagedPtrCastPtr jTool
            return jTool'
    gdk_event_set_device_tool event' maybeTool
    touchManagedPtr event
    whenJust tool touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data EventSetDeviceToolMethodInfo
instance (signature ~ (Maybe (a) -> m ()), MonadIO m, Gdk.DeviceTool.IsDeviceTool a) => O.OverloadedMethod EventSetDeviceToolMethodInfo Event signature where
    overloadedMethod = eventSetDeviceTool

instance O.OverloadedMethodInfo EventSetDeviceToolMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventSetDeviceTool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventSetDeviceTool"
        })


#endif

-- method Event::set_screen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_set_screen" gdk_event_set_screen :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Screen.Screen ->                -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO ()

-- | Sets the screen for /@event@/ to /@screen@/. The event must
-- have been allocated by GTK+, for instance, by
-- 'GI.Gdk.Unions.Event.eventCopy'.
-- 
-- /Since: 2.2/
eventSetScreen ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Screen.IsScreen a) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m ()
eventSetScreen event screen = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    screen' <- unsafeManagedPtrCastPtr screen
    gdk_event_set_screen event' screen'
    touchManagedPtr event
    touchManagedPtr screen
    return ()

#if defined(ENABLE_OVERLOADING)
data EventSetScreenMethodInfo
instance (signature ~ (a -> m ()), MonadIO m, Gdk.Screen.IsScreen a) => O.OverloadedMethod EventSetScreenMethodInfo Event signature where
    overloadedMethod = eventSetScreen

instance O.OverloadedMethodInfo EventSetScreenMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventSetScreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventSetScreen"
        })


#endif

-- method Event::set_source_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_set_source_device" gdk_event_set_source_device :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO ()

-- | Sets the slave device for /@event@/ to /@device@/.
-- 
-- The event must have been allocated by GTK+,
-- for instance by 'GI.Gdk.Unions.Event.eventCopy'.
-- 
-- /Since: 3.0/
eventSetSourceDevice ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Device.IsDevice a) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event'
    -> a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m ()
eventSetSourceDevice event device = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    device' <- unsafeManagedPtrCastPtr device
    gdk_event_set_source_device event' device'
    touchManagedPtr event
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data EventSetSourceDeviceMethodInfo
instance (signature ~ (a -> m ()), MonadIO m, Gdk.Device.IsDevice a) => O.OverloadedMethod EventSetSourceDeviceMethodInfo Event signature where
    overloadedMethod = eventSetSourceDevice

instance O.OverloadedMethodInfo EventSetSourceDeviceMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventSetSourceDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventSetSourceDevice"
        })


#endif

-- method Event::triggers_context_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkEvent, currently only button events are meaningful values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_triggers_context_menu" gdk_event_triggers_context_menu :: 
    Ptr Event ->                            -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | This function returns whether a t'GI.Gdk.Structs.EventButton.EventButton' should trigger a
-- context menu, according to platform conventions. The right mouse
-- button always triggers context menus. Additionally, if
-- 'GI.Gdk.Objects.Keymap.keymapGetModifierMask' returns a non-0 mask for
-- 'GI.Gdk.Enums.ModifierIntentContextMenu', then the left mouse button will
-- also trigger a context menu if this modifier is pressed.
-- 
-- This function should always be used instead of simply checking for
-- event->button == 'GI.Gdk.Constants.BUTTON_SECONDARY'.
-- 
-- /Since: 3.4/
eventTriggersContextMenu ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Event
    -- ^ /@event@/: a t'GI.Gdk.Unions.Event.Event', currently only button events are meaningful values
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the event should trigger a context menu.
eventTriggersContextMenu event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    result <- gdk_event_triggers_context_menu event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data EventTriggersContextMenuMethodInfo
instance (signature ~ (m Bool), MonadIO m) => O.OverloadedMethod EventTriggersContextMenuMethodInfo Event signature where
    overloadedMethod = eventTriggersContextMenu

instance O.OverloadedMethodInfo EventTriggersContextMenuMethodInfo Event where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Unions.Event.eventTriggersContextMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Unions-Event.html#v:eventTriggersContextMenu"
        })


#endif

-- method Event::get
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_get" gdk_event_get :: 
    IO (Ptr Event)

-- | Checks all open displays for a t'GI.Gdk.Unions.Event.Event' to process,to be processed
-- on, fetching events from the windowing system if necessary.
-- See 'GI.Gdk.Objects.Display.displayGetEvent'.
eventGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Event)
    -- ^ __Returns:__ the next t'GI.Gdk.Unions.Event.Event' to be processed, or 'P.Nothing'
    -- if no events are pending. The returned t'GI.Gdk.Unions.Event.Event' should be freed
    -- with 'GI.Gdk.Unions.Event.eventFree'.
eventGet  = liftIO $ do
    result <- gdk_event_get
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Event) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Event::handler_set
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the function to call to handle events from GDK."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the function to call when the handler function is removed, i.e. when\n         gdk_event_handler_set() is called with another event handler."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_handler_set" gdk_event_handler_set :: 
    FunPtr Gdk.Callbacks.C_EventFunc ->     -- func : TInterface (Name {namespace = "Gdk", name = "EventFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sets the function to call to handle all events from GDK.
-- 
-- Note that GTK+ uses this to install its own event handler, so it is
-- usually not useful for GTK+ applications. (Although an application
-- can call this function then call @/gtk_main_do_event()/@ to pass
-- events to GTK+.)
eventHandlerSet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Callbacks.EventFunc
    -- ^ /@func@/: the function to call to handle events from GDK.
    -> m ()
eventHandlerSet func = liftIO $ do
    func' <- Gdk.Callbacks.mk_EventFunc (Gdk.Callbacks.wrap_EventFunc Nothing (Gdk.Callbacks.drop_closures_EventFunc func))
    let data_ = castFunPtrToPtr func'
    let notify = SP.safeFreeFunPtrPtr
    gdk_event_handler_set func' data_ notify
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Event::peek
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Event" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_peek" gdk_event_peek :: 
    IO (Ptr Event)

-- | If there is an event waiting in the event queue of some open
-- display, returns a copy of it. See 'GI.Gdk.Objects.Display.displayPeekEvent'.
eventPeek ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Event)
    -- ^ __Returns:__ a copy of the first t'GI.Gdk.Unions.Event.Event' on some event
    -- queue, or 'P.Nothing' if no events are in any queues. The returned
    -- t'GI.Gdk.Unions.Event.Event' should be freed with 'GI.Gdk.Unions.Event.eventFree'.
eventPeek  = liftIO $ do
    result <- gdk_event_peek
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Event) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Event::request_motions
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMotion" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_event_request_motions" gdk_event_request_motions :: 
    Ptr Gdk.EventMotion.EventMotion ->      -- event : TInterface (Name {namespace = "Gdk", name = "EventMotion"})
    IO ()

-- | Request more motion notifies if /@event@/ is a motion notify hint event.
-- 
-- This function should be used instead of 'GI.Gdk.Objects.Window.windowGetPointer' to
-- request further motion notifies, because it also works for extension
-- events where motion notifies are provided for devices other than the
-- core pointer. Coordinate extraction, processing and requesting more
-- motion events from a 'GI.Gdk.Enums.EventTypeMotionNotify' event usually works like this:
-- 
-- 
-- === /C code/
-- >
-- >{
-- >  // motion_event handler
-- >  x = motion_event->x;
-- >  y = motion_event->y;
-- >  // handle (x,y) motion
-- >  gdk_event_request_motions (motion_event); // handles is_hint events
-- >}
-- 
-- 
-- /Since: 2.12/
eventRequestMotions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.EventMotion.EventMotion
    -- ^ /@event@/: a valid t'GI.Gdk.Unions.Event.Event'
    -> m ()
eventRequestMotions event = liftIO $ do
    event' <- unsafeManagedPtrGetPtr event
    gdk_event_request_motions event'
    touchManagedPtr event
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventMethod "copy" o = EventCopyMethodInfo
    ResolveEventMethod "free" o = EventFreeMethodInfo
    ResolveEventMethod "isScrollStopEvent" o = EventIsScrollStopEventMethodInfo
    ResolveEventMethod "put" o = EventPutMethodInfo
    ResolveEventMethod "triggersContextMenu" o = EventTriggersContextMenuMethodInfo
    ResolveEventMethod "getAxis" o = EventGetAxisMethodInfo
    ResolveEventMethod "getButton" o = EventGetButtonMethodInfo
    ResolveEventMethod "getClickCount" o = EventGetClickCountMethodInfo
    ResolveEventMethod "getCoords" o = EventGetCoordsMethodInfo
    ResolveEventMethod "getDevice" o = EventGetDeviceMethodInfo
    ResolveEventMethod "getDeviceTool" o = EventGetDeviceToolMethodInfo
    ResolveEventMethod "getEventSequence" o = EventGetEventSequenceMethodInfo
    ResolveEventMethod "getEventType" o = EventGetEventTypeMethodInfo
    ResolveEventMethod "getKeycode" o = EventGetKeycodeMethodInfo
    ResolveEventMethod "getKeyval" o = EventGetKeyvalMethodInfo
    ResolveEventMethod "getPointerEmulated" o = EventGetPointerEmulatedMethodInfo
    ResolveEventMethod "getRootCoords" o = EventGetRootCoordsMethodInfo
    ResolveEventMethod "getScancode" o = EventGetScancodeMethodInfo
    ResolveEventMethod "getScreen" o = EventGetScreenMethodInfo
    ResolveEventMethod "getScrollDeltas" o = EventGetScrollDeltasMethodInfo
    ResolveEventMethod "getScrollDirection" o = EventGetScrollDirectionMethodInfo
    ResolveEventMethod "getSeat" o = EventGetSeatMethodInfo
    ResolveEventMethod "getSourceDevice" o = EventGetSourceDeviceMethodInfo
    ResolveEventMethod "getState" o = EventGetStateMethodInfo
    ResolveEventMethod "getTime" o = EventGetTimeMethodInfo
    ResolveEventMethod "getWindow" o = EventGetWindowMethodInfo
    ResolveEventMethod "setDevice" o = EventSetDeviceMethodInfo
    ResolveEventMethod "setDeviceTool" o = EventSetDeviceToolMethodInfo
    ResolveEventMethod "setScreen" o = EventSetScreenMethodInfo
    ResolveEventMethod "setSourceDevice" o = EventSetSourceDeviceMethodInfo
    ResolveEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventMethod t Event, O.OverloadedMethod info Event p) => OL.IsLabel t (Event -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventMethod t Event, O.OverloadedMethod info Event p, R.HasField t Event p) => R.HasField t Event p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventMethod t Event, O.OverloadedMethodInfo info Event) => OL.IsLabel t (O.MethodProxy info Event) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


