{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Attributes to use for a newly-created window.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.WindowAttr
    ( 

-- * Exported types
    WindowAttr(..)                          ,
    newZeroWindowAttr                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveWindowAttrMethod                 ,
#endif



 -- * Properties


-- ** cursor #attr:cursor#
-- | cursor for the window (see 'GI.Gdk.Objects.Window.windowSetCursor')

    clearWindowAttrCursor                   ,
    getWindowAttrCursor                     ,
    setWindowAttrCursor                     ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_cursor                       ,
#endif


-- ** eventMask #attr:eventMask#
-- | event mask (see 'GI.Gdk.Objects.Window.windowSetEvents')

    getWindowAttrEventMask                  ,
    setWindowAttrEventMask                  ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_eventMask                    ,
#endif


-- ** height #attr:height#
-- | height of window

    getWindowAttrHeight                     ,
    setWindowAttrHeight                     ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_height                       ,
#endif


-- ** overrideRedirect #attr:overrideRedirect#
-- | 'P.True' to bypass the window manager

    getWindowAttrOverrideRedirect           ,
    setWindowAttrOverrideRedirect           ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_overrideRedirect             ,
#endif


-- ** title #attr:title#
-- | title of the window (for toplevel windows)

    clearWindowAttrTitle                    ,
    getWindowAttrTitle                      ,
    setWindowAttrTitle                      ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_title                        ,
#endif


-- ** typeHint #attr:typeHint#
-- | a hint of the function of the window

    getWindowAttrTypeHint                   ,
    setWindowAttrTypeHint                   ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_typeHint                     ,
#endif


-- ** visual #attr:visual#
-- | t'GI.Gdk.Objects.Visual.Visual' for window

    clearWindowAttrVisual                   ,
    getWindowAttrVisual                     ,
    setWindowAttrVisual                     ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_visual                       ,
#endif


-- ** wclass #attr:wclass#
-- | @/GDK_INPUT_OUTPUT/@ (normal window) or @/GDK_INPUT_ONLY/@ (invisible
--  window that receives events)

    getWindowAttrWclass                     ,
    setWindowAttrWclass                     ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_wclass                       ,
#endif


-- ** width #attr:width#
-- | width of window

    getWindowAttrWidth                      ,
    setWindowAttrWidth                      ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_width                        ,
#endif


-- ** windowType #attr:windowType#
-- | type of window

    getWindowAttrWindowType                 ,
    setWindowAttrWindowType                 ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_windowType                   ,
#endif


-- ** wmclassClass #attr:wmclassClass#
-- | don’t use (see @/gtk_window_set_wmclass()/@)

    clearWindowAttrWmclassClass             ,
    getWindowAttrWmclassClass               ,
    setWindowAttrWmclassClass               ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_wmclassClass                 ,
#endif


-- ** wmclassName #attr:wmclassName#
-- | don’t use (see @/gtk_window_set_wmclass()/@)

    clearWindowAttrWmclassName              ,
    getWindowAttrWmclassName                ,
    setWindowAttrWmclassName                ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_wmclassName                  ,
#endif


-- ** x #attr:x#
-- | X coordinate relative to parent window (see 'GI.Gdk.Objects.Window.windowMove')

    getWindowAttrX                          ,
    setWindowAttrX                          ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_x                            ,
#endif


-- ** y #attr:y#
-- | Y coordinate relative to parent window (see 'GI.Gdk.Objects.Window.windowMove')

    getWindowAttrY                          ,
    setWindowAttrY                          ,
#if defined(ENABLE_OVERLOADING)
    windowAttr_y                            ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual

#endif

-- | Memory-managed wrapper type.
newtype WindowAttr = WindowAttr (SP.ManagedPtr WindowAttr)
    deriving (Eq)

instance SP.ManagedPtrNewtype WindowAttr where
    toManagedPtr (WindowAttr p) = p

instance BoxedPtr WindowAttr where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 80 >=> B.ManagedPtr.wrapPtr WindowAttr)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr WindowAttr where
    boxedPtrCalloc = callocBytes 80


-- | Construct a `WindowAttr` struct initialized to zero.
newZeroWindowAttr :: MonadIO m => m WindowAttr
newZeroWindowAttr = liftIO $ boxedPtrCalloc >>= wrapPtr WindowAttr

instance tag ~ 'AttrSet => Constructible WindowAttr tag where
    new _ attrs = do
        o <- newZeroWindowAttr
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@title@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #title
-- @
getWindowAttrTitle :: MonadIO m => WindowAttr -> m (Maybe T.Text)
getWindowAttrTitle s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@title@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrTitle :: MonadIO m => WindowAttr -> CString -> m ()
setWindowAttrTitle s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@title@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #title
-- @
clearWindowAttrTitle :: MonadIO m => WindowAttr -> m ()
clearWindowAttrTitle s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data WindowAttrTitleFieldInfo
instance AttrInfo WindowAttrTitleFieldInfo where
    type AttrBaseTypeConstraint WindowAttrTitleFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrTitleFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowAttrTitleFieldInfo = (~) CString
    type AttrTransferTypeConstraint WindowAttrTitleFieldInfo = (~)CString
    type AttrTransferType WindowAttrTitleFieldInfo = CString
    type AttrGetType WindowAttrTitleFieldInfo = Maybe T.Text
    type AttrLabel WindowAttrTitleFieldInfo = "title"
    type AttrOrigin WindowAttrTitleFieldInfo = WindowAttr
    attrGet = getWindowAttrTitle
    attrSet = setWindowAttrTitle
    attrConstruct = undefined
    attrClear = clearWindowAttrTitle
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:title"
        })

windowAttr_title :: AttrLabelProxy "title"
windowAttr_title = AttrLabelProxy

#endif


-- | Get the value of the “@event_mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #eventMask
-- @
getWindowAttrEventMask :: MonadIO m => WindowAttr -> m Int32
getWindowAttrEventMask s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@event_mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #eventMask 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrEventMask :: MonadIO m => WindowAttr -> Int32 -> m ()
setWindowAttrEventMask s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data WindowAttrEventMaskFieldInfo
instance AttrInfo WindowAttrEventMaskFieldInfo where
    type AttrBaseTypeConstraint WindowAttrEventMaskFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrEventMaskFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrEventMaskFieldInfo = (~) Int32
    type AttrTransferTypeConstraint WindowAttrEventMaskFieldInfo = (~)Int32
    type AttrTransferType WindowAttrEventMaskFieldInfo = Int32
    type AttrGetType WindowAttrEventMaskFieldInfo = Int32
    type AttrLabel WindowAttrEventMaskFieldInfo = "event_mask"
    type AttrOrigin WindowAttrEventMaskFieldInfo = WindowAttr
    attrGet = getWindowAttrEventMask
    attrSet = setWindowAttrEventMask
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.eventMask"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:eventMask"
        })

windowAttr_eventMask :: AttrLabelProxy "eventMask"
windowAttr_eventMask = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #x
-- @
getWindowAttrX :: MonadIO m => WindowAttr -> m Int32
getWindowAttrX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrX :: MonadIO m => WindowAttr -> Int32 -> m ()
setWindowAttrX s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data WindowAttrXFieldInfo
instance AttrInfo WindowAttrXFieldInfo where
    type AttrBaseTypeConstraint WindowAttrXFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrXFieldInfo = (~) Int32
    type AttrTransferTypeConstraint WindowAttrXFieldInfo = (~)Int32
    type AttrTransferType WindowAttrXFieldInfo = Int32
    type AttrGetType WindowAttrXFieldInfo = Int32
    type AttrLabel WindowAttrXFieldInfo = "x"
    type AttrOrigin WindowAttrXFieldInfo = WindowAttr
    attrGet = getWindowAttrX
    attrSet = setWindowAttrX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:x"
        })

windowAttr_x :: AttrLabelProxy "x"
windowAttr_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #y
-- @
getWindowAttrY :: MonadIO m => WindowAttr -> m Int32
getWindowAttrY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrY :: MonadIO m => WindowAttr -> Int32 -> m ()
setWindowAttrY s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data WindowAttrYFieldInfo
instance AttrInfo WindowAttrYFieldInfo where
    type AttrBaseTypeConstraint WindowAttrYFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrYFieldInfo = (~) Int32
    type AttrTransferTypeConstraint WindowAttrYFieldInfo = (~)Int32
    type AttrTransferType WindowAttrYFieldInfo = Int32
    type AttrGetType WindowAttrYFieldInfo = Int32
    type AttrLabel WindowAttrYFieldInfo = "y"
    type AttrOrigin WindowAttrYFieldInfo = WindowAttr
    attrGet = getWindowAttrY
    attrSet = setWindowAttrY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:y"
        })

windowAttr_y :: AttrLabelProxy "y"
windowAttr_y = AttrLabelProxy

#endif


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #width
-- @
getWindowAttrWidth :: MonadIO m => WindowAttr -> m Int32
getWindowAttrWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Int32
    return val

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrWidth :: MonadIO m => WindowAttr -> Int32 -> m ()
setWindowAttrWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data WindowAttrWidthFieldInfo
instance AttrInfo WindowAttrWidthFieldInfo where
    type AttrBaseTypeConstraint WindowAttrWidthFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint WindowAttrWidthFieldInfo = (~)Int32
    type AttrTransferType WindowAttrWidthFieldInfo = Int32
    type AttrGetType WindowAttrWidthFieldInfo = Int32
    type AttrLabel WindowAttrWidthFieldInfo = "width"
    type AttrOrigin WindowAttrWidthFieldInfo = WindowAttr
    attrGet = getWindowAttrWidth
    attrSet = setWindowAttrWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:width"
        })

windowAttr_width :: AttrLabelProxy "width"
windowAttr_width = AttrLabelProxy

#endif


-- | Get the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #height
-- @
getWindowAttrHeight :: MonadIO m => WindowAttr -> m Int32
getWindowAttrHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Int32
    return val

-- | Set the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrHeight :: MonadIO m => WindowAttr -> Int32 -> m ()
setWindowAttrHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data WindowAttrHeightFieldInfo
instance AttrInfo WindowAttrHeightFieldInfo where
    type AttrBaseTypeConstraint WindowAttrHeightFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint WindowAttrHeightFieldInfo = (~)Int32
    type AttrTransferType WindowAttrHeightFieldInfo = Int32
    type AttrGetType WindowAttrHeightFieldInfo = Int32
    type AttrLabel WindowAttrHeightFieldInfo = "height"
    type AttrOrigin WindowAttrHeightFieldInfo = WindowAttr
    attrGet = getWindowAttrHeight
    attrSet = setWindowAttrHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:height"
        })

windowAttr_height :: AttrLabelProxy "height"
windowAttr_height = AttrLabelProxy

#endif


-- | Get the value of the “@wclass@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #wclass
-- @
getWindowAttrWclass :: MonadIO m => WindowAttr -> m Gdk.Enums.WindowWindowClass
getWindowAttrWclass s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@wclass@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #wclass 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrWclass :: MonadIO m => WindowAttr -> Gdk.Enums.WindowWindowClass -> m ()
setWindowAttrWclass s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 28) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data WindowAttrWclassFieldInfo
instance AttrInfo WindowAttrWclassFieldInfo where
    type AttrBaseTypeConstraint WindowAttrWclassFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrWclassFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrWclassFieldInfo = (~) Gdk.Enums.WindowWindowClass
    type AttrTransferTypeConstraint WindowAttrWclassFieldInfo = (~)Gdk.Enums.WindowWindowClass
    type AttrTransferType WindowAttrWclassFieldInfo = Gdk.Enums.WindowWindowClass
    type AttrGetType WindowAttrWclassFieldInfo = Gdk.Enums.WindowWindowClass
    type AttrLabel WindowAttrWclassFieldInfo = "wclass"
    type AttrOrigin WindowAttrWclassFieldInfo = WindowAttr
    attrGet = getWindowAttrWclass
    attrSet = setWindowAttrWclass
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.wclass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:wclass"
        })

windowAttr_wclass :: AttrLabelProxy "wclass"
windowAttr_wclass = AttrLabelProxy

#endif


-- | Get the value of the “@visual@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #visual
-- @
getWindowAttrVisual :: MonadIO m => WindowAttr -> m (Maybe Gdk.Visual.Visual)
getWindowAttrVisual s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr Gdk.Visual.Visual)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Visual.Visual) val'
        return val''
    return result

-- | Set the value of the “@visual@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #visual 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrVisual :: MonadIO m => WindowAttr -> Ptr Gdk.Visual.Visual -> m ()
setWindowAttrVisual s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr Gdk.Visual.Visual)

-- | Set the value of the “@visual@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #visual
-- @
clearWindowAttrVisual :: MonadIO m => WindowAttr -> m ()
clearWindowAttrVisual s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr Gdk.Visual.Visual)

#if defined(ENABLE_OVERLOADING)
data WindowAttrVisualFieldInfo
instance AttrInfo WindowAttrVisualFieldInfo where
    type AttrBaseTypeConstraint WindowAttrVisualFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrVisualFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowAttrVisualFieldInfo = (~) (Ptr Gdk.Visual.Visual)
    type AttrTransferTypeConstraint WindowAttrVisualFieldInfo = (~)(Ptr Gdk.Visual.Visual)
    type AttrTransferType WindowAttrVisualFieldInfo = (Ptr Gdk.Visual.Visual)
    type AttrGetType WindowAttrVisualFieldInfo = Maybe Gdk.Visual.Visual
    type AttrLabel WindowAttrVisualFieldInfo = "visual"
    type AttrOrigin WindowAttrVisualFieldInfo = WindowAttr
    attrGet = getWindowAttrVisual
    attrSet = setWindowAttrVisual
    attrConstruct = undefined
    attrClear = clearWindowAttrVisual
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.visual"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:visual"
        })

windowAttr_visual :: AttrLabelProxy "visual"
windowAttr_visual = AttrLabelProxy

#endif


-- | Get the value of the “@window_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #windowType
-- @
getWindowAttrWindowType :: MonadIO m => WindowAttr -> m Gdk.Enums.WindowType
getWindowAttrWindowType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@window_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #windowType 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrWindowType :: MonadIO m => WindowAttr -> Gdk.Enums.WindowType -> m ()
setWindowAttrWindowType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 40) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data WindowAttrWindowTypeFieldInfo
instance AttrInfo WindowAttrWindowTypeFieldInfo where
    type AttrBaseTypeConstraint WindowAttrWindowTypeFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrWindowTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrWindowTypeFieldInfo = (~) Gdk.Enums.WindowType
    type AttrTransferTypeConstraint WindowAttrWindowTypeFieldInfo = (~)Gdk.Enums.WindowType
    type AttrTransferType WindowAttrWindowTypeFieldInfo = Gdk.Enums.WindowType
    type AttrGetType WindowAttrWindowTypeFieldInfo = Gdk.Enums.WindowType
    type AttrLabel WindowAttrWindowTypeFieldInfo = "window_type"
    type AttrOrigin WindowAttrWindowTypeFieldInfo = WindowAttr
    attrGet = getWindowAttrWindowType
    attrSet = setWindowAttrWindowType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.windowType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:windowType"
        })

windowAttr_windowType :: AttrLabelProxy "windowType"
windowAttr_windowType = AttrLabelProxy

#endif


-- | Get the value of the “@cursor@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #cursor
-- @
getWindowAttrCursor :: MonadIO m => WindowAttr -> m (Maybe Gdk.Cursor.Cursor)
getWindowAttrCursor s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (Ptr Gdk.Cursor.Cursor)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Cursor.Cursor) val'
        return val''
    return result

-- | Set the value of the “@cursor@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #cursor 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrCursor :: MonadIO m => WindowAttr -> Ptr Gdk.Cursor.Cursor -> m ()
setWindowAttrCursor s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Ptr Gdk.Cursor.Cursor)

-- | Set the value of the “@cursor@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #cursor
-- @
clearWindowAttrCursor :: MonadIO m => WindowAttr -> m ()
clearWindowAttrCursor s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullPtr :: Ptr Gdk.Cursor.Cursor)

#if defined(ENABLE_OVERLOADING)
data WindowAttrCursorFieldInfo
instance AttrInfo WindowAttrCursorFieldInfo where
    type AttrBaseTypeConstraint WindowAttrCursorFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrCursorFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowAttrCursorFieldInfo = (~) (Ptr Gdk.Cursor.Cursor)
    type AttrTransferTypeConstraint WindowAttrCursorFieldInfo = (~)(Ptr Gdk.Cursor.Cursor)
    type AttrTransferType WindowAttrCursorFieldInfo = (Ptr Gdk.Cursor.Cursor)
    type AttrGetType WindowAttrCursorFieldInfo = Maybe Gdk.Cursor.Cursor
    type AttrLabel WindowAttrCursorFieldInfo = "cursor"
    type AttrOrigin WindowAttrCursorFieldInfo = WindowAttr
    attrGet = getWindowAttrCursor
    attrSet = setWindowAttrCursor
    attrConstruct = undefined
    attrClear = clearWindowAttrCursor
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:cursor"
        })

windowAttr_cursor :: AttrLabelProxy "cursor"
windowAttr_cursor = AttrLabelProxy

#endif


-- | Get the value of the “@wmclass_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #wmclassName
-- @
getWindowAttrWmclassName :: MonadIO m => WindowAttr -> m (Maybe T.Text)
getWindowAttrWmclassName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@wmclass_name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #wmclassName 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrWmclassName :: MonadIO m => WindowAttr -> CString -> m ()
setWindowAttrWmclassName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: CString)

-- | Set the value of the “@wmclass_name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #wmclassName
-- @
clearWindowAttrWmclassName :: MonadIO m => WindowAttr -> m ()
clearWindowAttrWmclassName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data WindowAttrWmclassNameFieldInfo
instance AttrInfo WindowAttrWmclassNameFieldInfo where
    type AttrBaseTypeConstraint WindowAttrWmclassNameFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrWmclassNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowAttrWmclassNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint WindowAttrWmclassNameFieldInfo = (~)CString
    type AttrTransferType WindowAttrWmclassNameFieldInfo = CString
    type AttrGetType WindowAttrWmclassNameFieldInfo = Maybe T.Text
    type AttrLabel WindowAttrWmclassNameFieldInfo = "wmclass_name"
    type AttrOrigin WindowAttrWmclassNameFieldInfo = WindowAttr
    attrGet = getWindowAttrWmclassName
    attrSet = setWindowAttrWmclassName
    attrConstruct = undefined
    attrClear = clearWindowAttrWmclassName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.wmclassName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:wmclassName"
        })

windowAttr_wmclassName :: AttrLabelProxy "wmclassName"
windowAttr_wmclassName = AttrLabelProxy

#endif


-- | Get the value of the “@wmclass_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #wmclassClass
-- @
getWindowAttrWmclassClass :: MonadIO m => WindowAttr -> m (Maybe T.Text)
getWindowAttrWmclassClass s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@wmclass_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #wmclassClass 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrWmclassClass :: MonadIO m => WindowAttr -> CString -> m ()
setWindowAttrWmclassClass s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (val :: CString)

-- | Set the value of the “@wmclass_class@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #wmclassClass
-- @
clearWindowAttrWmclassClass :: MonadIO m => WindowAttr -> m ()
clearWindowAttrWmclassClass s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 64) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data WindowAttrWmclassClassFieldInfo
instance AttrInfo WindowAttrWmclassClassFieldInfo where
    type AttrBaseTypeConstraint WindowAttrWmclassClassFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrWmclassClassFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WindowAttrWmclassClassFieldInfo = (~) CString
    type AttrTransferTypeConstraint WindowAttrWmclassClassFieldInfo = (~)CString
    type AttrTransferType WindowAttrWmclassClassFieldInfo = CString
    type AttrGetType WindowAttrWmclassClassFieldInfo = Maybe T.Text
    type AttrLabel WindowAttrWmclassClassFieldInfo = "wmclass_class"
    type AttrOrigin WindowAttrWmclassClassFieldInfo = WindowAttr
    attrGet = getWindowAttrWmclassClass
    attrSet = setWindowAttrWmclassClass
    attrConstruct = undefined
    attrClear = clearWindowAttrWmclassClass
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.wmclassClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:wmclassClass"
        })

windowAttr_wmclassClass :: AttrLabelProxy "wmclassClass"
windowAttr_wmclassClass = AttrLabelProxy

#endif


-- | Get the value of the “@override_redirect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #overrideRedirect
-- @
getWindowAttrOverrideRedirect :: MonadIO m => WindowAttr -> m Bool
getWindowAttrOverrideRedirect s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@override_redirect@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #overrideRedirect 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrOverrideRedirect :: MonadIO m => WindowAttr -> Bool -> m ()
setWindowAttrOverrideRedirect s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 72) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data WindowAttrOverrideRedirectFieldInfo
instance AttrInfo WindowAttrOverrideRedirectFieldInfo where
    type AttrBaseTypeConstraint WindowAttrOverrideRedirectFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrOverrideRedirectFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrOverrideRedirectFieldInfo = (~) Bool
    type AttrTransferTypeConstraint WindowAttrOverrideRedirectFieldInfo = (~)Bool
    type AttrTransferType WindowAttrOverrideRedirectFieldInfo = Bool
    type AttrGetType WindowAttrOverrideRedirectFieldInfo = Bool
    type AttrLabel WindowAttrOverrideRedirectFieldInfo = "override_redirect"
    type AttrOrigin WindowAttrOverrideRedirectFieldInfo = WindowAttr
    attrGet = getWindowAttrOverrideRedirect
    attrSet = setWindowAttrOverrideRedirect
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.overrideRedirect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:overrideRedirect"
        })

windowAttr_overrideRedirect :: AttrLabelProxy "overrideRedirect"
windowAttr_overrideRedirect = AttrLabelProxy

#endif


-- | Get the value of the “@type_hint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowAttr #typeHint
-- @
getWindowAttrTypeHint :: MonadIO m => WindowAttr -> m Gdk.Enums.WindowTypeHint
getWindowAttrTypeHint s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 76) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type_hint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowAttr [ #typeHint 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowAttrTypeHint :: MonadIO m => WindowAttr -> Gdk.Enums.WindowTypeHint -> m ()
setWindowAttrTypeHint s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 76) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data WindowAttrTypeHintFieldInfo
instance AttrInfo WindowAttrTypeHintFieldInfo where
    type AttrBaseTypeConstraint WindowAttrTypeHintFieldInfo = (~) WindowAttr
    type AttrAllowedOps WindowAttrTypeHintFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint WindowAttrTypeHintFieldInfo = (~) Gdk.Enums.WindowTypeHint
    type AttrTransferTypeConstraint WindowAttrTypeHintFieldInfo = (~)Gdk.Enums.WindowTypeHint
    type AttrTransferType WindowAttrTypeHintFieldInfo = Gdk.Enums.WindowTypeHint
    type AttrGetType WindowAttrTypeHintFieldInfo = Gdk.Enums.WindowTypeHint
    type AttrLabel WindowAttrTypeHintFieldInfo = "type_hint"
    type AttrOrigin WindowAttrTypeHintFieldInfo = WindowAttr
    attrGet = getWindowAttrTypeHint
    attrSet = setWindowAttrTypeHint
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.WindowAttr.typeHint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-WindowAttr.html#g:attr:typeHint"
        })

windowAttr_typeHint :: AttrLabelProxy "typeHint"
windowAttr_typeHint = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WindowAttr
type instance O.AttributeList WindowAttr = WindowAttrAttributeList
type WindowAttrAttributeList = ('[ '("title", WindowAttrTitleFieldInfo), '("eventMask", WindowAttrEventMaskFieldInfo), '("x", WindowAttrXFieldInfo), '("y", WindowAttrYFieldInfo), '("width", WindowAttrWidthFieldInfo), '("height", WindowAttrHeightFieldInfo), '("wclass", WindowAttrWclassFieldInfo), '("visual", WindowAttrVisualFieldInfo), '("windowType", WindowAttrWindowTypeFieldInfo), '("cursor", WindowAttrCursorFieldInfo), '("wmclassName", WindowAttrWmclassNameFieldInfo), '("wmclassClass", WindowAttrWmclassClassFieldInfo), '("overrideRedirect", WindowAttrOverrideRedirectFieldInfo), '("typeHint", WindowAttrTypeHintFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveWindowAttrMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWindowAttrMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWindowAttrMethod t WindowAttr, O.OverloadedMethod info WindowAttr p) => OL.IsLabel t (WindowAttr -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWindowAttrMethod t WindowAttr, O.OverloadedMethod info WindowAttr p, R.HasField t WindowAttr p) => R.HasField t WindowAttr p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWindowAttrMethod t WindowAttr, O.OverloadedMethodInfo info WindowAttr) => OL.IsLabel t (O.MethodProxy info WindowAttr) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


