{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Structs.TimeCoord.TimeCoord' stores a single event in a motion history.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.TimeCoord
    ( 

-- * Exported types
    TimeCoord(..)                           ,
    newZeroTimeCoord                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveTimeCoordMethod                  ,
#endif



 -- * Properties


-- ** time #attr:time#
-- | The timestamp for this event.

    getTimeCoordTime                        ,
    setTimeCoordTime                        ,
#if defined(ENABLE_OVERLOADING)
    timeCoord_time                          ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype TimeCoord = TimeCoord (SP.ManagedPtr TimeCoord)
    deriving (Eq)

instance SP.ManagedPtrNewtype TimeCoord where
    toManagedPtr (TimeCoord p) = p

instance BoxedPtr TimeCoord where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 1032 >=> B.ManagedPtr.wrapPtr TimeCoord)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr TimeCoord where
    boxedPtrCalloc = callocBytes 1032


-- | Construct a `TimeCoord` struct initialized to zero.
newZeroTimeCoord :: MonadIO m => m TimeCoord
newZeroTimeCoord = liftIO $ boxedPtrCalloc >>= wrapPtr TimeCoord

instance tag ~ 'AttrSet => Constructible TimeCoord tag where
    new _ attrs = do
        o <- newZeroTimeCoord
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' timeCoord #time
-- @
getTimeCoordTime :: MonadIO m => TimeCoord -> m Word32
getTimeCoordTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' timeCoord [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setTimeCoordTime :: MonadIO m => TimeCoord -> Word32 -> m ()
setTimeCoordTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data TimeCoordTimeFieldInfo
instance AttrInfo TimeCoordTimeFieldInfo where
    type AttrBaseTypeConstraint TimeCoordTimeFieldInfo = (~) TimeCoord
    type AttrAllowedOps TimeCoordTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint TimeCoordTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint TimeCoordTimeFieldInfo = (~)Word32
    type AttrTransferType TimeCoordTimeFieldInfo = Word32
    type AttrGetType TimeCoordTimeFieldInfo = Word32
    type AttrLabel TimeCoordTimeFieldInfo = "time"
    type AttrOrigin TimeCoordTimeFieldInfo = TimeCoord
    attrGet = getTimeCoordTime
    attrSet = setTimeCoordTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.TimeCoord.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-TimeCoord.html#g:attr:time"
        })

timeCoord_time :: AttrLabelProxy "time"
timeCoord_time = AttrLabelProxy

#endif


-- XXX Skipped attribute for "TimeCoord:axes"
-- Not implemented: Don't know how to unpack C array of type TCArray False 128 (-1) (TBasicType TDouble)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TimeCoord
type instance O.AttributeList TimeCoord = TimeCoordAttributeList
type TimeCoordAttributeList = ('[ '("time", TimeCoordTimeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTimeCoordMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTimeCoordMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethod info TimeCoord p) => OL.IsLabel t (TimeCoord -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethod info TimeCoord p, R.HasField t TimeCoord p) => R.HasField t TimeCoord p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTimeCoordMethod t TimeCoord, O.OverloadedMethodInfo info TimeCoord) => OL.IsLabel t (O.MethodProxy info TimeCoord) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


