{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when the state of a toplevel window changes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventWindowState
    ( 

-- * Exported types
    EventWindowState(..)                    ,
    newZeroEventWindowState                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventWindowStateMethod           ,
#endif



 -- * Properties


-- ** changedMask #attr:changedMask#
-- | mask specifying what flags have changed.

#if defined(ENABLE_OVERLOADING)
    eventWindowState_changedMask            ,
#endif
    getEventWindowStateChangedMask          ,
    setEventWindowStateChangedMask          ,


-- ** newWindowState #attr:newWindowState#
-- | the new window state, a combination of
--   t'GI.Gdk.Flags.WindowState' bits.

#if defined(ENABLE_OVERLOADING)
    eventWindowState_newWindowState         ,
#endif
    getEventWindowStateNewWindowState       ,
    setEventWindowStateNewWindowState       ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventWindowState_sendEvent              ,
#endif
    getEventWindowStateSendEvent            ,
    setEventWindowStateSendEvent            ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeWindowState').

#if defined(ENABLE_OVERLOADING)
    eventWindowState_type                   ,
#endif
    getEventWindowStateType                 ,
    setEventWindowStateType                 ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventWindowStateWindow             ,
#if defined(ENABLE_OVERLOADING)
    eventWindowState_window                 ,
#endif
    getEventWindowStateWindow               ,
    setEventWindowStateWindow               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventWindowState = EventWindowState (SP.ManagedPtr EventWindowState)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventWindowState where
    toManagedPtr (EventWindowState p) = p

instance BoxedPtr EventWindowState where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr EventWindowState)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventWindowState where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `EventWindowState` struct initialized to zero.
newZeroEventWindowState :: MonadIO m => m EventWindowState
newZeroEventWindowState = liftIO $ boxedPtrCalloc >>= wrapPtr EventWindowState

instance tag ~ 'AttrSet => Constructible EventWindowState tag where
    new _ attrs = do
        o <- newZeroEventWindowState
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventWindowState #type
-- @
getEventWindowStateType :: MonadIO m => EventWindowState -> m Gdk.Enums.EventType
getEventWindowStateType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventWindowState [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventWindowStateType :: MonadIO m => EventWindowState -> Gdk.Enums.EventType -> m ()
setEventWindowStateType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventWindowStateTypeFieldInfo
instance AttrInfo EventWindowStateTypeFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateTypeFieldInfo = (~) EventWindowState
    type AttrAllowedOps EventWindowStateTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventWindowStateTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventWindowStateTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventWindowStateTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventWindowStateTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventWindowStateTypeFieldInfo = "type"
    type AttrOrigin EventWindowStateTypeFieldInfo = EventWindowState
    attrGet = getEventWindowStateType
    attrSet = setEventWindowStateType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventWindowState.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventWindowState.html#g:attr:type"
        })

eventWindowState_type :: AttrLabelProxy "type"
eventWindowState_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventWindowState #window
-- @
getEventWindowStateWindow :: MonadIO m => EventWindowState -> m (Maybe Gdk.Window.Window)
getEventWindowStateWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventWindowState [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventWindowStateWindow :: MonadIO m => EventWindowState -> Ptr Gdk.Window.Window -> m ()
setEventWindowStateWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventWindowStateWindow :: MonadIO m => EventWindowState -> m ()
clearEventWindowStateWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventWindowStateWindowFieldInfo
instance AttrInfo EventWindowStateWindowFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateWindowFieldInfo = (~) EventWindowState
    type AttrAllowedOps EventWindowStateWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventWindowStateWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventWindowStateWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventWindowStateWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventWindowStateWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventWindowStateWindowFieldInfo = "window"
    type AttrOrigin EventWindowStateWindowFieldInfo = EventWindowState
    attrGet = getEventWindowStateWindow
    attrSet = setEventWindowStateWindow
    attrConstruct = undefined
    attrClear = clearEventWindowStateWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventWindowState.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventWindowState.html#g:attr:window"
        })

eventWindowState_window :: AttrLabelProxy "window"
eventWindowState_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventWindowState #sendEvent
-- @
getEventWindowStateSendEvent :: MonadIO m => EventWindowState -> m Int8
getEventWindowStateSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventWindowState [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventWindowStateSendEvent :: MonadIO m => EventWindowState -> Int8 -> m ()
setEventWindowStateSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventWindowStateSendEventFieldInfo
instance AttrInfo EventWindowStateSendEventFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateSendEventFieldInfo = (~) EventWindowState
    type AttrAllowedOps EventWindowStateSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventWindowStateSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventWindowStateSendEventFieldInfo = (~)Int8
    type AttrTransferType EventWindowStateSendEventFieldInfo = Int8
    type AttrGetType EventWindowStateSendEventFieldInfo = Int8
    type AttrLabel EventWindowStateSendEventFieldInfo = "send_event"
    type AttrOrigin EventWindowStateSendEventFieldInfo = EventWindowState
    attrGet = getEventWindowStateSendEvent
    attrSet = setEventWindowStateSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventWindowState.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventWindowState.html#g:attr:sendEvent"
        })

eventWindowState_sendEvent :: AttrLabelProxy "sendEvent"
eventWindowState_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@changed_mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventWindowState #changedMask
-- @
getEventWindowStateChangedMask :: MonadIO m => EventWindowState -> m [Gdk.Flags.WindowState]
getEventWindowStateChangedMask s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@changed_mask@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventWindowState [ #changedMask 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventWindowStateChangedMask :: MonadIO m => EventWindowState -> [Gdk.Flags.WindowState] -> m ()
setEventWindowStateChangedMask s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 20) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventWindowStateChangedMaskFieldInfo
instance AttrInfo EventWindowStateChangedMaskFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateChangedMaskFieldInfo = (~) EventWindowState
    type AttrAllowedOps EventWindowStateChangedMaskFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventWindowStateChangedMaskFieldInfo = (~) [Gdk.Flags.WindowState]
    type AttrTransferTypeConstraint EventWindowStateChangedMaskFieldInfo = (~)[Gdk.Flags.WindowState]
    type AttrTransferType EventWindowStateChangedMaskFieldInfo = [Gdk.Flags.WindowState]
    type AttrGetType EventWindowStateChangedMaskFieldInfo = [Gdk.Flags.WindowState]
    type AttrLabel EventWindowStateChangedMaskFieldInfo = "changed_mask"
    type AttrOrigin EventWindowStateChangedMaskFieldInfo = EventWindowState
    attrGet = getEventWindowStateChangedMask
    attrSet = setEventWindowStateChangedMask
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventWindowState.changedMask"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventWindowState.html#g:attr:changedMask"
        })

eventWindowState_changedMask :: AttrLabelProxy "changedMask"
eventWindowState_changedMask = AttrLabelProxy

#endif


-- | Get the value of the “@new_window_state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventWindowState #newWindowState
-- @
getEventWindowStateNewWindowState :: MonadIO m => EventWindowState -> m [Gdk.Flags.WindowState]
getEventWindowStateNewWindowState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@new_window_state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventWindowState [ #newWindowState 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventWindowStateNewWindowState :: MonadIO m => EventWindowState -> [Gdk.Flags.WindowState] -> m ()
setEventWindowStateNewWindowState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 24) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventWindowStateNewWindowStateFieldInfo
instance AttrInfo EventWindowStateNewWindowStateFieldInfo where
    type AttrBaseTypeConstraint EventWindowStateNewWindowStateFieldInfo = (~) EventWindowState
    type AttrAllowedOps EventWindowStateNewWindowStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventWindowStateNewWindowStateFieldInfo = (~) [Gdk.Flags.WindowState]
    type AttrTransferTypeConstraint EventWindowStateNewWindowStateFieldInfo = (~)[Gdk.Flags.WindowState]
    type AttrTransferType EventWindowStateNewWindowStateFieldInfo = [Gdk.Flags.WindowState]
    type AttrGetType EventWindowStateNewWindowStateFieldInfo = [Gdk.Flags.WindowState]
    type AttrLabel EventWindowStateNewWindowStateFieldInfo = "new_window_state"
    type AttrOrigin EventWindowStateNewWindowStateFieldInfo = EventWindowState
    attrGet = getEventWindowStateNewWindowState
    attrSet = setEventWindowStateNewWindowState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventWindowState.newWindowState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventWindowState.html#g:attr:newWindowState"
        })

eventWindowState_newWindowState :: AttrLabelProxy "newWindowState"
eventWindowState_newWindowState = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventWindowState
type instance O.AttributeList EventWindowState = EventWindowStateAttributeList
type EventWindowStateAttributeList = ('[ '("type", EventWindowStateTypeFieldInfo), '("window", EventWindowStateWindowFieldInfo), '("sendEvent", EventWindowStateSendEventFieldInfo), '("changedMask", EventWindowStateChangedMaskFieldInfo), '("newWindowState", EventWindowStateNewWindowStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventWindowStateMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventWindowStateMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventWindowStateMethod t EventWindowState, O.OverloadedMethod info EventWindowState p) => OL.IsLabel t (EventWindowState -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventWindowStateMethod t EventWindowState, O.OverloadedMethod info EventWindowState p, R.HasField t EventWindowState p) => R.HasField t EventWindowState p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventWindowStateMethod t EventWindowState, O.OverloadedMethodInfo info EventWindowState) => OL.IsLabel t (O.MethodProxy info EventWindowState) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


