{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during touchpad swipe gestures.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventTouchpadSwipe
    ( 

-- * Exported types
    EventTouchpadSwipe(..)                  ,
    newZeroEventTouchpadSwipe               ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventTouchpadSwipeMethod         ,
#endif



 -- * Properties


-- ** dx #attr:dx#
-- | Movement delta in the X axis of the swipe focal point

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_dx                   ,
#endif
    getEventTouchpadSwipeDx                 ,
    setEventTouchpadSwipeDx                 ,


-- ** dy #attr:dy#
-- | Movement delta in the Y axis of the swipe focal point

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_dy                   ,
#endif
    getEventTouchpadSwipeDy                 ,
    setEventTouchpadSwipeDy                 ,


-- ** nFingers #attr:nFingers#
-- | The number of fingers triggering the swipe

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_nFingers             ,
#endif
    getEventTouchpadSwipeNFingers           ,
    setEventTouchpadSwipeNFingers           ,


-- ** phase #attr:phase#
-- | the current phase of the gesture

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_phase                ,
#endif
    getEventTouchpadSwipePhase              ,
    setEventTouchpadSwipePhase              ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_sendEvent            ,
#endif
    getEventTouchpadSwipeSendEvent          ,
    setEventTouchpadSwipeSendEvent          ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_state                ,
#endif
    getEventTouchpadSwipeState              ,
    setEventTouchpadSwipeState              ,


-- ** time #attr:time#
-- | the time of the event in milliseconds

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_time                 ,
#endif
    getEventTouchpadSwipeTime               ,
    setEventTouchpadSwipeTime               ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeTouchpadSwipe')

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_type                 ,
#endif
    getEventTouchpadSwipeType               ,
    setEventTouchpadSwipeType               ,


-- ** window #attr:window#
-- | the window which received the event

    clearEventTouchpadSwipeWindow           ,
#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_window               ,
#endif
    getEventTouchpadSwipeWindow             ,
    setEventTouchpadSwipeWindow             ,


-- ** x #attr:x#
-- | The X coordinate of the pointer

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_x                    ,
#endif
    getEventTouchpadSwipeX                  ,
    setEventTouchpadSwipeX                  ,


-- ** xRoot #attr:xRoot#
-- | The X coordinate of the pointer, relative to the
--   root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_xRoot                ,
#endif
    getEventTouchpadSwipeXRoot              ,
    setEventTouchpadSwipeXRoot              ,


-- ** y #attr:y#
-- | The Y coordinate of the pointer

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_y                    ,
#endif
    getEventTouchpadSwipeY                  ,
    setEventTouchpadSwipeY                  ,


-- ** yRoot #attr:yRoot#
-- | The Y coordinate of the pointer, relative to the
--   root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadSwipe_yRoot                ,
#endif
    getEventTouchpadSwipeYRoot              ,
    setEventTouchpadSwipeYRoot              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventTouchpadSwipe = EventTouchpadSwipe (SP.ManagedPtr EventTouchpadSwipe)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventTouchpadSwipe where
    toManagedPtr (EventTouchpadSwipe p) = p

instance BoxedPtr EventTouchpadSwipe where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 80 >=> B.ManagedPtr.wrapPtr EventTouchpadSwipe)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventTouchpadSwipe where
    boxedPtrCalloc = callocBytes 80


-- | Construct a `EventTouchpadSwipe` struct initialized to zero.
newZeroEventTouchpadSwipe :: MonadIO m => m EventTouchpadSwipe
newZeroEventTouchpadSwipe = liftIO $ boxedPtrCalloc >>= wrapPtr EventTouchpadSwipe

instance tag ~ 'AttrSet => Constructible EventTouchpadSwipe tag where
    new _ attrs = do
        o <- newZeroEventTouchpadSwipe
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #type
-- @
getEventTouchpadSwipeType :: MonadIO m => EventTouchpadSwipe -> m Gdk.Enums.EventType
getEventTouchpadSwipeType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeType :: MonadIO m => EventTouchpadSwipe -> Gdk.Enums.EventType -> m ()
setEventTouchpadSwipeType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeTypeFieldInfo
instance AttrInfo EventTouchpadSwipeTypeFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeTypeFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventTouchpadSwipeTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventTouchpadSwipeTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventTouchpadSwipeTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventTouchpadSwipeTypeFieldInfo = "type"
    type AttrOrigin EventTouchpadSwipeTypeFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeType
    attrSet = setEventTouchpadSwipeType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:type"
        })

eventTouchpadSwipe_type :: AttrLabelProxy "type"
eventTouchpadSwipe_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #window
-- @
getEventTouchpadSwipeWindow :: MonadIO m => EventTouchpadSwipe -> m (Maybe Gdk.Window.Window)
getEventTouchpadSwipeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeWindow :: MonadIO m => EventTouchpadSwipe -> Ptr Gdk.Window.Window -> m ()
setEventTouchpadSwipeWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventTouchpadSwipeWindow :: MonadIO m => EventTouchpadSwipe -> m ()
clearEventTouchpadSwipeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeWindowFieldInfo
instance AttrInfo EventTouchpadSwipeWindowFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeWindowFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventTouchpadSwipeWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventTouchpadSwipeWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventTouchpadSwipeWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventTouchpadSwipeWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventTouchpadSwipeWindowFieldInfo = "window"
    type AttrOrigin EventTouchpadSwipeWindowFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeWindow
    attrSet = setEventTouchpadSwipeWindow
    attrConstruct = undefined
    attrClear = clearEventTouchpadSwipeWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:window"
        })

eventTouchpadSwipe_window :: AttrLabelProxy "window"
eventTouchpadSwipe_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #sendEvent
-- @
getEventTouchpadSwipeSendEvent :: MonadIO m => EventTouchpadSwipe -> m Int8
getEventTouchpadSwipeSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeSendEvent :: MonadIO m => EventTouchpadSwipe -> Int8 -> m ()
setEventTouchpadSwipeSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeSendEventFieldInfo
instance AttrInfo EventTouchpadSwipeSendEventFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeSendEventFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadSwipeSendEventFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadSwipeSendEventFieldInfo = Int8
    type AttrGetType EventTouchpadSwipeSendEventFieldInfo = Int8
    type AttrLabel EventTouchpadSwipeSendEventFieldInfo = "send_event"
    type AttrOrigin EventTouchpadSwipeSendEventFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeSendEvent
    attrSet = setEventTouchpadSwipeSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:sendEvent"
        })

eventTouchpadSwipe_sendEvent :: AttrLabelProxy "sendEvent"
eventTouchpadSwipe_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@phase@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #phase
-- @
getEventTouchpadSwipePhase :: MonadIO m => EventTouchpadSwipe -> m Int8
getEventTouchpadSwipePhase s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 17) :: IO Int8
    return val

-- | Set the value of the “@phase@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #phase 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipePhase :: MonadIO m => EventTouchpadSwipe -> Int8 -> m ()
setEventTouchpadSwipePhase s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 17) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipePhaseFieldInfo
instance AttrInfo EventTouchpadSwipePhaseFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipePhaseFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipePhaseFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipePhaseFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadSwipePhaseFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadSwipePhaseFieldInfo = Int8
    type AttrGetType EventTouchpadSwipePhaseFieldInfo = Int8
    type AttrLabel EventTouchpadSwipePhaseFieldInfo = "phase"
    type AttrOrigin EventTouchpadSwipePhaseFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipePhase
    attrSet = setEventTouchpadSwipePhase
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.phase"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:phase"
        })

eventTouchpadSwipe_phase :: AttrLabelProxy "phase"
eventTouchpadSwipe_phase = AttrLabelProxy

#endif


-- | Get the value of the “@n_fingers@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #nFingers
-- @
getEventTouchpadSwipeNFingers :: MonadIO m => EventTouchpadSwipe -> m Int8
getEventTouchpadSwipeNFingers s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 18) :: IO Int8
    return val

-- | Set the value of the “@n_fingers@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #nFingers 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeNFingers :: MonadIO m => EventTouchpadSwipe -> Int8 -> m ()
setEventTouchpadSwipeNFingers s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 18) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeNFingersFieldInfo
instance AttrInfo EventTouchpadSwipeNFingersFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeNFingersFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeNFingersFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeNFingersFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadSwipeNFingersFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadSwipeNFingersFieldInfo = Int8
    type AttrGetType EventTouchpadSwipeNFingersFieldInfo = Int8
    type AttrLabel EventTouchpadSwipeNFingersFieldInfo = "n_fingers"
    type AttrOrigin EventTouchpadSwipeNFingersFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeNFingers
    attrSet = setEventTouchpadSwipeNFingers
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.nFingers"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:nFingers"
        })

eventTouchpadSwipe_nFingers :: AttrLabelProxy "nFingers"
eventTouchpadSwipe_nFingers = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #time
-- @
getEventTouchpadSwipeTime :: MonadIO m => EventTouchpadSwipe -> m Word32
getEventTouchpadSwipeTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeTime :: MonadIO m => EventTouchpadSwipe -> Word32 -> m ()
setEventTouchpadSwipeTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeTimeFieldInfo
instance AttrInfo EventTouchpadSwipeTimeFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeTimeFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventTouchpadSwipeTimeFieldInfo = (~)Word32
    type AttrTransferType EventTouchpadSwipeTimeFieldInfo = Word32
    type AttrGetType EventTouchpadSwipeTimeFieldInfo = Word32
    type AttrLabel EventTouchpadSwipeTimeFieldInfo = "time"
    type AttrOrigin EventTouchpadSwipeTimeFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeTime
    attrSet = setEventTouchpadSwipeTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:time"
        })

eventTouchpadSwipe_time :: AttrLabelProxy "time"
eventTouchpadSwipe_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #x
-- @
getEventTouchpadSwipeX :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeX :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeXFieldInfo
instance AttrInfo EventTouchpadSwipeXFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeXFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeXFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeXFieldInfo = Double
    type AttrGetType EventTouchpadSwipeXFieldInfo = Double
    type AttrLabel EventTouchpadSwipeXFieldInfo = "x"
    type AttrOrigin EventTouchpadSwipeXFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeX
    attrSet = setEventTouchpadSwipeX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:x"
        })

eventTouchpadSwipe_x :: AttrLabelProxy "x"
eventTouchpadSwipe_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #y
-- @
getEventTouchpadSwipeY :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeY :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeYFieldInfo
instance AttrInfo EventTouchpadSwipeYFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeYFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeYFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeYFieldInfo = Double
    type AttrGetType EventTouchpadSwipeYFieldInfo = Double
    type AttrLabel EventTouchpadSwipeYFieldInfo = "y"
    type AttrOrigin EventTouchpadSwipeYFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeY
    attrSet = setEventTouchpadSwipeY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:y"
        })

eventTouchpadSwipe_y :: AttrLabelProxy "y"
eventTouchpadSwipe_y = AttrLabelProxy

#endif


-- | Get the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #dx
-- @
getEventTouchpadSwipeDx :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeDx s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #dx 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeDx :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeDx s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeDxFieldInfo
instance AttrInfo EventTouchpadSwipeDxFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeDxFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeDxFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeDxFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeDxFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeDxFieldInfo = Double
    type AttrGetType EventTouchpadSwipeDxFieldInfo = Double
    type AttrLabel EventTouchpadSwipeDxFieldInfo = "dx"
    type AttrOrigin EventTouchpadSwipeDxFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeDx
    attrSet = setEventTouchpadSwipeDx
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.dx"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:dx"
        })

eventTouchpadSwipe_dx :: AttrLabelProxy "dx"
eventTouchpadSwipe_dx = AttrLabelProxy

#endif


-- | Get the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #dy
-- @
getEventTouchpadSwipeDy :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeDy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #dy 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeDy :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeDy s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 48) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeDyFieldInfo
instance AttrInfo EventTouchpadSwipeDyFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeDyFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeDyFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeDyFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeDyFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeDyFieldInfo = Double
    type AttrGetType EventTouchpadSwipeDyFieldInfo = Double
    type AttrLabel EventTouchpadSwipeDyFieldInfo = "dy"
    type AttrOrigin EventTouchpadSwipeDyFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeDy
    attrSet = setEventTouchpadSwipeDy
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.dy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:dy"
        })

eventTouchpadSwipe_dy :: AttrLabelProxy "dy"
eventTouchpadSwipe_dy = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #xRoot
-- @
getEventTouchpadSwipeXRoot :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeXRoot :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 56) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeXRootFieldInfo
instance AttrInfo EventTouchpadSwipeXRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeXRootFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeXRootFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeXRootFieldInfo = Double
    type AttrGetType EventTouchpadSwipeXRootFieldInfo = Double
    type AttrLabel EventTouchpadSwipeXRootFieldInfo = "x_root"
    type AttrOrigin EventTouchpadSwipeXRootFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeXRoot
    attrSet = setEventTouchpadSwipeXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:xRoot"
        })

eventTouchpadSwipe_xRoot :: AttrLabelProxy "xRoot"
eventTouchpadSwipe_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #yRoot
-- @
getEventTouchpadSwipeYRoot :: MonadIO m => EventTouchpadSwipe -> m Double
getEventTouchpadSwipeYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeYRoot :: MonadIO m => EventTouchpadSwipe -> Double -> m ()
setEventTouchpadSwipeYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeYRootFieldInfo
instance AttrInfo EventTouchpadSwipeYRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeYRootFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadSwipeYRootFieldInfo = (~)Double
    type AttrTransferType EventTouchpadSwipeYRootFieldInfo = Double
    type AttrGetType EventTouchpadSwipeYRootFieldInfo = Double
    type AttrLabel EventTouchpadSwipeYRootFieldInfo = "y_root"
    type AttrOrigin EventTouchpadSwipeYRootFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeYRoot
    attrSet = setEventTouchpadSwipeYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:yRoot"
        })

eventTouchpadSwipe_yRoot :: AttrLabelProxy "yRoot"
eventTouchpadSwipe_yRoot = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadSwipe #state
-- @
getEventTouchpadSwipeState :: MonadIO m => EventTouchpadSwipe -> m [Gdk.Flags.ModifierType]
getEventTouchpadSwipeState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadSwipe [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadSwipeState :: MonadIO m => EventTouchpadSwipe -> [Gdk.Flags.ModifierType] -> m ()
setEventTouchpadSwipeState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 72) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadSwipeStateFieldInfo
instance AttrInfo EventTouchpadSwipeStateFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadSwipeStateFieldInfo = (~) EventTouchpadSwipe
    type AttrAllowedOps EventTouchpadSwipeStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadSwipeStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventTouchpadSwipeStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventTouchpadSwipeStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventTouchpadSwipeStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventTouchpadSwipeStateFieldInfo = "state"
    type AttrOrigin EventTouchpadSwipeStateFieldInfo = EventTouchpadSwipe
    attrGet = getEventTouchpadSwipeState
    attrSet = setEventTouchpadSwipeState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadSwipe.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouchpadSwipe.html#g:attr:state"
        })

eventTouchpadSwipe_state :: AttrLabelProxy "state"
eventTouchpadSwipe_state = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventTouchpadSwipe
type instance O.AttributeList EventTouchpadSwipe = EventTouchpadSwipeAttributeList
type EventTouchpadSwipeAttributeList = ('[ '("type", EventTouchpadSwipeTypeFieldInfo), '("window", EventTouchpadSwipeWindowFieldInfo), '("sendEvent", EventTouchpadSwipeSendEventFieldInfo), '("phase", EventTouchpadSwipePhaseFieldInfo), '("nFingers", EventTouchpadSwipeNFingersFieldInfo), '("time", EventTouchpadSwipeTimeFieldInfo), '("x", EventTouchpadSwipeXFieldInfo), '("y", EventTouchpadSwipeYFieldInfo), '("dx", EventTouchpadSwipeDxFieldInfo), '("dy", EventTouchpadSwipeDyFieldInfo), '("xRoot", EventTouchpadSwipeXRootFieldInfo), '("yRoot", EventTouchpadSwipeYRootFieldInfo), '("state", EventTouchpadSwipeStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventTouchpadSwipeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventTouchpadSwipeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventTouchpadSwipeMethod t EventTouchpadSwipe, O.OverloadedMethod info EventTouchpadSwipe p) => OL.IsLabel t (EventTouchpadSwipe -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventTouchpadSwipeMethod t EventTouchpadSwipe, O.OverloadedMethod info EventTouchpadSwipe p, R.HasField t EventTouchpadSwipe p) => R.HasField t EventTouchpadSwipe p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventTouchpadSwipeMethod t EventTouchpadSwipe, O.OverloadedMethodInfo info EventTouchpadSwipe) => OL.IsLabel t (O.MethodProxy info EventTouchpadSwipe) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


