{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Used for touch events.
-- /@type@/ field will be one of 'GI.Gdk.Enums.EventTypeTouchBegin', 'GI.Gdk.Enums.EventTypeTouchUpdate',
-- 'GI.Gdk.Enums.EventTypeTouchEnd' or 'GI.Gdk.Enums.EventTypeTouchCancel'.
-- 
-- Touch events are grouped into sequences by means of the /@sequence@/
-- field, which can also be obtained with 'GI.Gdk.Unions.Event.eventGetEventSequence'.
-- Each sequence begins with a 'GI.Gdk.Enums.EventTypeTouchBegin' event, followed by
-- any number of 'GI.Gdk.Enums.EventTypeTouchUpdate' events, and ends with a 'GI.Gdk.Enums.EventTypeTouchEnd'
-- (or 'GI.Gdk.Enums.EventTypeTouchCancel') event. With multitouch devices, there may be
-- several active sequences at the same time.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventTouch
    ( 

-- * Exported types
    EventTouch(..)                          ,
    newZeroEventTouch                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventTouchMethod                 ,
#endif



 -- * Properties


-- ** axes #attr:axes#
-- | /@x@/, /@y@/ translated to the axes of /@device@/, or 'P.Nothing' if /@device@/ is
--   the mouse

#if defined(ENABLE_OVERLOADING)
    eventTouch_axes                         ,
#endif
    getEventTouchAxes                       ,
    setEventTouchAxes                       ,


-- ** device #attr:device#
-- | the master device that the event originated from. Use
-- 'GI.Gdk.Unions.Event.eventGetSourceDevice' to get the slave device.

    clearEventTouchDevice                   ,
#if defined(ENABLE_OVERLOADING)
    eventTouch_device                       ,
#endif
    getEventTouchDevice                     ,
    setEventTouchDevice                     ,


-- ** emulatingPointer #attr:emulatingPointer#
-- | whether the event should be used for emulating
--   pointer event

#if defined(ENABLE_OVERLOADING)
    eventTouch_emulatingPointer             ,
#endif
    getEventTouchEmulatingPointer           ,
    setEventTouchEmulatingPointer           ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventTouch_sendEvent                    ,
#endif
    getEventTouchSendEvent                  ,
    setEventTouchSendEvent                  ,


-- ** sequence #attr:sequence#
-- | the event sequence that the event belongs to

    clearEventTouchSequence                 ,
#if defined(ENABLE_OVERLOADING)
    eventTouch_sequence                     ,
#endif
    getEventTouchSequence                   ,
    setEventTouchSequence                   ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'

#if defined(ENABLE_OVERLOADING)
    eventTouch_state                        ,
#endif
    getEventTouchState                      ,
    setEventTouchState                      ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventTouch_time                         ,
#endif
    getEventTouchTime                       ,
    setEventTouchTime                       ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeTouchBegin', 'GI.Gdk.Enums.EventTypeTouchUpdate',
--   'GI.Gdk.Enums.EventTypeTouchEnd', 'GI.Gdk.Enums.EventTypeTouchCancel')

#if defined(ENABLE_OVERLOADING)
    eventTouch_type                         ,
#endif
    getEventTouchType                       ,
    setEventTouchType                       ,


-- ** window #attr:window#
-- | the window which received the event

    clearEventTouchWindow                   ,
#if defined(ENABLE_OVERLOADING)
    eventTouch_window                       ,
#endif
    getEventTouchWindow                     ,
    setEventTouchWindow                     ,


-- ** x #attr:x#
-- | the x coordinate of the pointer relative to the window

#if defined(ENABLE_OVERLOADING)
    eventTouch_x                            ,
#endif
    getEventTouchX                          ,
    setEventTouchX                          ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the
--   screen

#if defined(ENABLE_OVERLOADING)
    eventTouch_xRoot                        ,
#endif
    getEventTouchXRoot                      ,
    setEventTouchXRoot                      ,


-- ** y #attr:y#
-- | the y coordinate of the pointer relative to the window

#if defined(ENABLE_OVERLOADING)
    eventTouch_y                            ,
#endif
    getEventTouchY                          ,
    setEventTouchY                          ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the
--   screen

#if defined(ENABLE_OVERLOADING)
    eventTouch_yRoot                        ,
#endif
    getEventTouchYRoot                      ,
    setEventTouchYRoot                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence

#endif

-- | Memory-managed wrapper type.
newtype EventTouch = EventTouch (SP.ManagedPtr EventTouch)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventTouch where
    toManagedPtr (EventTouch p) = p

instance BoxedPtr EventTouch where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 96 >=> B.ManagedPtr.wrapPtr EventTouch)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventTouch where
    boxedPtrCalloc = callocBytes 96


-- | Construct a `EventTouch` struct initialized to zero.
newZeroEventTouch :: MonadIO m => m EventTouch
newZeroEventTouch = liftIO $ boxedPtrCalloc >>= wrapPtr EventTouch

instance tag ~ 'AttrSet => Constructible EventTouch tag where
    new _ attrs = do
        o <- newZeroEventTouch
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #type
-- @
getEventTouchType :: MonadIO m => EventTouch -> m Gdk.Enums.EventType
getEventTouchType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchType :: MonadIO m => EventTouch -> Gdk.Enums.EventType -> m ()
setEventTouchType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchTypeFieldInfo
instance AttrInfo EventTouchTypeFieldInfo where
    type AttrBaseTypeConstraint EventTouchTypeFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventTouchTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventTouchTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventTouchTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventTouchTypeFieldInfo = "type"
    type AttrOrigin EventTouchTypeFieldInfo = EventTouch
    attrGet = getEventTouchType
    attrSet = setEventTouchType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:type"
        })

eventTouch_type :: AttrLabelProxy "type"
eventTouch_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #window
-- @
getEventTouchWindow :: MonadIO m => EventTouch -> m (Maybe Gdk.Window.Window)
getEventTouchWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchWindow :: MonadIO m => EventTouch -> Ptr Gdk.Window.Window -> m ()
setEventTouchWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventTouchWindow :: MonadIO m => EventTouch -> m ()
clearEventTouchWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventTouchWindowFieldInfo
instance AttrInfo EventTouchWindowFieldInfo where
    type AttrBaseTypeConstraint EventTouchWindowFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventTouchWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventTouchWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventTouchWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventTouchWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventTouchWindowFieldInfo = "window"
    type AttrOrigin EventTouchWindowFieldInfo = EventTouch
    attrGet = getEventTouchWindow
    attrSet = setEventTouchWindow
    attrConstruct = undefined
    attrClear = clearEventTouchWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:window"
        })

eventTouch_window :: AttrLabelProxy "window"
eventTouch_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #sendEvent
-- @
getEventTouchSendEvent :: MonadIO m => EventTouch -> m Int8
getEventTouchSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchSendEvent :: MonadIO m => EventTouch -> Int8 -> m ()
setEventTouchSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchSendEventFieldInfo
instance AttrInfo EventTouchSendEventFieldInfo where
    type AttrBaseTypeConstraint EventTouchSendEventFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchSendEventFieldInfo = (~)Int8
    type AttrTransferType EventTouchSendEventFieldInfo = Int8
    type AttrGetType EventTouchSendEventFieldInfo = Int8
    type AttrLabel EventTouchSendEventFieldInfo = "send_event"
    type AttrOrigin EventTouchSendEventFieldInfo = EventTouch
    attrGet = getEventTouchSendEvent
    attrSet = setEventTouchSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:sendEvent"
        })

eventTouch_sendEvent :: AttrLabelProxy "sendEvent"
eventTouch_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #time
-- @
getEventTouchTime :: MonadIO m => EventTouch -> m Word32
getEventTouchTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchTime :: MonadIO m => EventTouch -> Word32 -> m ()
setEventTouchTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventTouchTimeFieldInfo
instance AttrInfo EventTouchTimeFieldInfo where
    type AttrBaseTypeConstraint EventTouchTimeFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventTouchTimeFieldInfo = (~)Word32
    type AttrTransferType EventTouchTimeFieldInfo = Word32
    type AttrGetType EventTouchTimeFieldInfo = Word32
    type AttrLabel EventTouchTimeFieldInfo = "time"
    type AttrOrigin EventTouchTimeFieldInfo = EventTouch
    attrGet = getEventTouchTime
    attrSet = setEventTouchTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:time"
        })

eventTouch_time :: AttrLabelProxy "time"
eventTouch_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #x
-- @
getEventTouchX :: MonadIO m => EventTouch -> m Double
getEventTouchX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchX :: MonadIO m => EventTouch -> Double -> m ()
setEventTouchX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchXFieldInfo
instance AttrInfo EventTouchXFieldInfo where
    type AttrBaseTypeConstraint EventTouchXFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchXFieldInfo = (~)Double
    type AttrTransferType EventTouchXFieldInfo = Double
    type AttrGetType EventTouchXFieldInfo = Double
    type AttrLabel EventTouchXFieldInfo = "x"
    type AttrOrigin EventTouchXFieldInfo = EventTouch
    attrGet = getEventTouchX
    attrSet = setEventTouchX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:x"
        })

eventTouch_x :: AttrLabelProxy "x"
eventTouch_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #y
-- @
getEventTouchY :: MonadIO m => EventTouch -> m Double
getEventTouchY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchY :: MonadIO m => EventTouch -> Double -> m ()
setEventTouchY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchYFieldInfo
instance AttrInfo EventTouchYFieldInfo where
    type AttrBaseTypeConstraint EventTouchYFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchYFieldInfo = (~)Double
    type AttrTransferType EventTouchYFieldInfo = Double
    type AttrGetType EventTouchYFieldInfo = Double
    type AttrLabel EventTouchYFieldInfo = "y"
    type AttrOrigin EventTouchYFieldInfo = EventTouch
    attrGet = getEventTouchY
    attrSet = setEventTouchY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:y"
        })

eventTouch_y :: AttrLabelProxy "y"
eventTouch_y = AttrLabelProxy

#endif


-- | Get the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #axes
-- @
getEventTouchAxes :: MonadIO m => EventTouch -> m Double
getEventTouchAxes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #axes 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchAxes :: MonadIO m => EventTouch -> Double -> m ()
setEventTouchAxes s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchAxesFieldInfo
instance AttrInfo EventTouchAxesFieldInfo where
    type AttrBaseTypeConstraint EventTouchAxesFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchAxesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchAxesFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchAxesFieldInfo = (~)Double
    type AttrTransferType EventTouchAxesFieldInfo = Double
    type AttrGetType EventTouchAxesFieldInfo = Double
    type AttrLabel EventTouchAxesFieldInfo = "axes"
    type AttrOrigin EventTouchAxesFieldInfo = EventTouch
    attrGet = getEventTouchAxes
    attrSet = setEventTouchAxes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.axes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:axes"
        })

eventTouch_axes :: AttrLabelProxy "axes"
eventTouch_axes = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #state
-- @
getEventTouchState :: MonadIO m => EventTouch -> m [Gdk.Flags.ModifierType]
getEventTouchState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchState :: MonadIO m => EventTouch -> [Gdk.Flags.ModifierType] -> m ()
setEventTouchState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 48) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchStateFieldInfo
instance AttrInfo EventTouchStateFieldInfo where
    type AttrBaseTypeConstraint EventTouchStateFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventTouchStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventTouchStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventTouchStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventTouchStateFieldInfo = "state"
    type AttrOrigin EventTouchStateFieldInfo = EventTouch
    attrGet = getEventTouchState
    attrSet = setEventTouchState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:state"
        })

eventTouch_state :: AttrLabelProxy "state"
eventTouch_state = AttrLabelProxy

#endif


-- | Get the value of the “@sequence@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #sequence
-- @
getEventTouchSequence :: MonadIO m => EventTouch -> m (Maybe Gdk.EventSequence.EventSequence)
getEventTouchSequence s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (Ptr Gdk.EventSequence.EventSequence)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Gdk.EventSequence.EventSequence) val'
        return val''
    return result

-- | Set the value of the “@sequence@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #sequence 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchSequence :: MonadIO m => EventTouch -> Ptr Gdk.EventSequence.EventSequence -> m ()
setEventTouchSequence s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: Ptr Gdk.EventSequence.EventSequence)

-- | Set the value of the “@sequence@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #sequence
-- @
clearEventTouchSequence :: MonadIO m => EventTouch -> m ()
clearEventTouchSequence s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: Ptr Gdk.EventSequence.EventSequence)

#if defined(ENABLE_OVERLOADING)
data EventTouchSequenceFieldInfo
instance AttrInfo EventTouchSequenceFieldInfo where
    type AttrBaseTypeConstraint EventTouchSequenceFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchSequenceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventTouchSequenceFieldInfo = (~) (Ptr Gdk.EventSequence.EventSequence)
    type AttrTransferTypeConstraint EventTouchSequenceFieldInfo = (~)(Ptr Gdk.EventSequence.EventSequence)
    type AttrTransferType EventTouchSequenceFieldInfo = (Ptr Gdk.EventSequence.EventSequence)
    type AttrGetType EventTouchSequenceFieldInfo = Maybe Gdk.EventSequence.EventSequence
    type AttrLabel EventTouchSequenceFieldInfo = "sequence"
    type AttrOrigin EventTouchSequenceFieldInfo = EventTouch
    attrGet = getEventTouchSequence
    attrSet = setEventTouchSequence
    attrConstruct = undefined
    attrClear = clearEventTouchSequence
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.sequence"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:sequence"
        })

eventTouch_sequence :: AttrLabelProxy "sequence"
eventTouch_sequence = AttrLabelProxy

#endif


-- | Get the value of the “@emulating_pointer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #emulatingPointer
-- @
getEventTouchEmulatingPointer :: MonadIO m => EventTouch -> m Bool
getEventTouchEmulatingPointer s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@emulating_pointer@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #emulatingPointer 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchEmulatingPointer :: MonadIO m => EventTouch -> Bool -> m ()
setEventTouchEmulatingPointer s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 64) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchEmulatingPointerFieldInfo
instance AttrInfo EventTouchEmulatingPointerFieldInfo where
    type AttrBaseTypeConstraint EventTouchEmulatingPointerFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchEmulatingPointerFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchEmulatingPointerFieldInfo = (~) Bool
    type AttrTransferTypeConstraint EventTouchEmulatingPointerFieldInfo = (~)Bool
    type AttrTransferType EventTouchEmulatingPointerFieldInfo = Bool
    type AttrGetType EventTouchEmulatingPointerFieldInfo = Bool
    type AttrLabel EventTouchEmulatingPointerFieldInfo = "emulating_pointer"
    type AttrOrigin EventTouchEmulatingPointerFieldInfo = EventTouch
    attrGet = getEventTouchEmulatingPointer
    attrSet = setEventTouchEmulatingPointer
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.emulatingPointer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:emulatingPointer"
        })

eventTouch_emulatingPointer :: AttrLabelProxy "emulatingPointer"
eventTouch_emulatingPointer = AttrLabelProxy

#endif


-- | Get the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #device
-- @
getEventTouchDevice :: MonadIO m => EventTouch -> m (Maybe Gdk.Device.Device)
getEventTouchDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO (Ptr Gdk.Device.Device)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Device.Device) val'
        return val''
    return result

-- | Set the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #device 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchDevice :: MonadIO m => EventTouch -> Ptr Gdk.Device.Device -> m ()
setEventTouchDevice s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (val :: Ptr Gdk.Device.Device)

-- | Set the value of the “@device@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #device
-- @
clearEventTouchDevice :: MonadIO m => EventTouch -> m ()
clearEventTouchDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 72) (FP.nullPtr :: Ptr Gdk.Device.Device)

#if defined(ENABLE_OVERLOADING)
data EventTouchDeviceFieldInfo
instance AttrInfo EventTouchDeviceFieldInfo where
    type AttrBaseTypeConstraint EventTouchDeviceFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchDeviceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventTouchDeviceFieldInfo = (~) (Ptr Gdk.Device.Device)
    type AttrTransferTypeConstraint EventTouchDeviceFieldInfo = (~)(Ptr Gdk.Device.Device)
    type AttrTransferType EventTouchDeviceFieldInfo = (Ptr Gdk.Device.Device)
    type AttrGetType EventTouchDeviceFieldInfo = Maybe Gdk.Device.Device
    type AttrLabel EventTouchDeviceFieldInfo = "device"
    type AttrOrigin EventTouchDeviceFieldInfo = EventTouch
    attrGet = getEventTouchDevice
    attrSet = setEventTouchDevice
    attrConstruct = undefined
    attrClear = clearEventTouchDevice
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:device"
        })

eventTouch_device :: AttrLabelProxy "device"
eventTouch_device = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #xRoot
-- @
getEventTouchXRoot :: MonadIO m => EventTouch -> m Double
getEventTouchXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 80) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchXRoot :: MonadIO m => EventTouch -> Double -> m ()
setEventTouchXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 80) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchXRootFieldInfo
instance AttrInfo EventTouchXRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchXRootFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchXRootFieldInfo = (~)Double
    type AttrTransferType EventTouchXRootFieldInfo = Double
    type AttrGetType EventTouchXRootFieldInfo = Double
    type AttrLabel EventTouchXRootFieldInfo = "x_root"
    type AttrOrigin EventTouchXRootFieldInfo = EventTouch
    attrGet = getEventTouchXRoot
    attrSet = setEventTouchXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:xRoot"
        })

eventTouch_xRoot :: AttrLabelProxy "xRoot"
eventTouch_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouch #yRoot
-- @
getEventTouchYRoot :: MonadIO m => EventTouch -> m Double
getEventTouchYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 88) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouch [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchYRoot :: MonadIO m => EventTouch -> Double -> m ()
setEventTouchYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 88) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchYRootFieldInfo
instance AttrInfo EventTouchYRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchYRootFieldInfo = (~) EventTouch
    type AttrAllowedOps EventTouchYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchYRootFieldInfo = (~)Double
    type AttrTransferType EventTouchYRootFieldInfo = Double
    type AttrGetType EventTouchYRootFieldInfo = Double
    type AttrLabel EventTouchYRootFieldInfo = "y_root"
    type AttrOrigin EventTouchYRootFieldInfo = EventTouch
    attrGet = getEventTouchYRoot
    attrSet = setEventTouchYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouch.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventTouch.html#g:attr:yRoot"
        })

eventTouch_yRoot :: AttrLabelProxy "yRoot"
eventTouch_yRoot = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventTouch
type instance O.AttributeList EventTouch = EventTouchAttributeList
type EventTouchAttributeList = ('[ '("type", EventTouchTypeFieldInfo), '("window", EventTouchWindowFieldInfo), '("sendEvent", EventTouchSendEventFieldInfo), '("time", EventTouchTimeFieldInfo), '("x", EventTouchXFieldInfo), '("y", EventTouchYFieldInfo), '("axes", EventTouchAxesFieldInfo), '("state", EventTouchStateFieldInfo), '("sequence", EventTouchSequenceFieldInfo), '("emulatingPointer", EventTouchEmulatingPointerFieldInfo), '("device", EventTouchDeviceFieldInfo), '("xRoot", EventTouchXRootFieldInfo), '("yRoot", EventTouchYRootFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventTouchMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventTouchMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventTouchMethod t EventTouch, O.OverloadedMethod info EventTouch p) => OL.IsLabel t (EventTouch -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventTouchMethod t EventTouch, O.OverloadedMethod info EventTouch p, R.HasField t EventTouch p) => R.HasField t EventTouch p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventTouchMethod t EventTouch, O.OverloadedMethodInfo info EventTouch) => OL.IsLabel t (O.MethodProxy info EventTouch) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


