{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when a setting is modified.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventSetting
    ( 

-- * Exported types
    EventSetting(..)                        ,
    newZeroEventSetting                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventSettingMethod               ,
#endif



 -- * Properties


-- ** action #attr:action#
-- | what happened to the setting ('GI.Gdk.Enums.SettingActionNew',
--   'GI.Gdk.Enums.SettingActionChanged' or 'GI.Gdk.Enums.SettingActionDeleted').

#if defined(ENABLE_OVERLOADING)
    eventSetting_action                     ,
#endif
    getEventSettingAction                   ,
    setEventSettingAction                   ,


-- ** name #attr:name#
-- | the name of the setting.

    clearEventSettingName                   ,
#if defined(ENABLE_OVERLOADING)
    eventSetting_name                       ,
#endif
    getEventSettingName                     ,
    setEventSettingName                     ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventSetting_sendEvent                  ,
#endif
    getEventSettingSendEvent                ,
    setEventSettingSendEvent                ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeSetting').

#if defined(ENABLE_OVERLOADING)
    eventSetting_type                       ,
#endif
    getEventSettingType                     ,
    setEventSettingType                     ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventSettingWindow                 ,
#if defined(ENABLE_OVERLOADING)
    eventSetting_window                     ,
#endif
    getEventSettingWindow                   ,
    setEventSettingWindow                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventSetting = EventSetting (SP.ManagedPtr EventSetting)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventSetting where
    toManagedPtr (EventSetting p) = p

instance BoxedPtr EventSetting where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr EventSetting)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventSetting where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `EventSetting` struct initialized to zero.
newZeroEventSetting :: MonadIO m => m EventSetting
newZeroEventSetting = liftIO $ boxedPtrCalloc >>= wrapPtr EventSetting

instance tag ~ 'AttrSet => Constructible EventSetting tag where
    new _ attrs = do
        o <- newZeroEventSetting
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventSetting #type
-- @
getEventSettingType :: MonadIO m => EventSetting -> m Gdk.Enums.EventType
getEventSettingType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventSetting [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventSettingType :: MonadIO m => EventSetting -> Gdk.Enums.EventType -> m ()
setEventSettingType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventSettingTypeFieldInfo
instance AttrInfo EventSettingTypeFieldInfo where
    type AttrBaseTypeConstraint EventSettingTypeFieldInfo = (~) EventSetting
    type AttrAllowedOps EventSettingTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventSettingTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventSettingTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventSettingTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventSettingTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventSettingTypeFieldInfo = "type"
    type AttrOrigin EventSettingTypeFieldInfo = EventSetting
    attrGet = getEventSettingType
    attrSet = setEventSettingType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventSetting.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventSetting.html#g:attr:type"
        })

eventSetting_type :: AttrLabelProxy "type"
eventSetting_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventSetting #window
-- @
getEventSettingWindow :: MonadIO m => EventSetting -> m (Maybe Gdk.Window.Window)
getEventSettingWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventSetting [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventSettingWindow :: MonadIO m => EventSetting -> Ptr Gdk.Window.Window -> m ()
setEventSettingWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventSettingWindow :: MonadIO m => EventSetting -> m ()
clearEventSettingWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventSettingWindowFieldInfo
instance AttrInfo EventSettingWindowFieldInfo where
    type AttrBaseTypeConstraint EventSettingWindowFieldInfo = (~) EventSetting
    type AttrAllowedOps EventSettingWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventSettingWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventSettingWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventSettingWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventSettingWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventSettingWindowFieldInfo = "window"
    type AttrOrigin EventSettingWindowFieldInfo = EventSetting
    attrGet = getEventSettingWindow
    attrSet = setEventSettingWindow
    attrConstruct = undefined
    attrClear = clearEventSettingWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventSetting.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventSetting.html#g:attr:window"
        })

eventSetting_window :: AttrLabelProxy "window"
eventSetting_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventSetting #sendEvent
-- @
getEventSettingSendEvent :: MonadIO m => EventSetting -> m Int8
getEventSettingSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventSetting [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventSettingSendEvent :: MonadIO m => EventSetting -> Int8 -> m ()
setEventSettingSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventSettingSendEventFieldInfo
instance AttrInfo EventSettingSendEventFieldInfo where
    type AttrBaseTypeConstraint EventSettingSendEventFieldInfo = (~) EventSetting
    type AttrAllowedOps EventSettingSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventSettingSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventSettingSendEventFieldInfo = (~)Int8
    type AttrTransferType EventSettingSendEventFieldInfo = Int8
    type AttrGetType EventSettingSendEventFieldInfo = Int8
    type AttrLabel EventSettingSendEventFieldInfo = "send_event"
    type AttrOrigin EventSettingSendEventFieldInfo = EventSetting
    attrGet = getEventSettingSendEvent
    attrSet = setEventSettingSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventSetting.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventSetting.html#g:attr:sendEvent"
        })

eventSetting_sendEvent :: AttrLabelProxy "sendEvent"
eventSetting_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@action@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventSetting #action
-- @
getEventSettingAction :: MonadIO m => EventSetting -> m Gdk.Enums.SettingAction
getEventSettingAction s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@action@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventSetting [ #action 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventSettingAction :: MonadIO m => EventSetting -> Gdk.Enums.SettingAction -> m ()
setEventSettingAction s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 20) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventSettingActionFieldInfo
instance AttrInfo EventSettingActionFieldInfo where
    type AttrBaseTypeConstraint EventSettingActionFieldInfo = (~) EventSetting
    type AttrAllowedOps EventSettingActionFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventSettingActionFieldInfo = (~) Gdk.Enums.SettingAction
    type AttrTransferTypeConstraint EventSettingActionFieldInfo = (~)Gdk.Enums.SettingAction
    type AttrTransferType EventSettingActionFieldInfo = Gdk.Enums.SettingAction
    type AttrGetType EventSettingActionFieldInfo = Gdk.Enums.SettingAction
    type AttrLabel EventSettingActionFieldInfo = "action"
    type AttrOrigin EventSettingActionFieldInfo = EventSetting
    attrGet = getEventSettingAction
    attrSet = setEventSettingAction
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventSetting.action"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventSetting.html#g:attr:action"
        })

eventSetting_action :: AttrLabelProxy "action"
eventSetting_action = AttrLabelProxy

#endif


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventSetting #name
-- @
getEventSettingName :: MonadIO m => EventSetting -> m (Maybe T.Text)
getEventSettingName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventSetting [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventSettingName :: MonadIO m => EventSetting -> CString -> m ()
setEventSettingName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearEventSettingName :: MonadIO m => EventSetting -> m ()
clearEventSettingName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data EventSettingNameFieldInfo
instance AttrInfo EventSettingNameFieldInfo where
    type AttrBaseTypeConstraint EventSettingNameFieldInfo = (~) EventSetting
    type AttrAllowedOps EventSettingNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventSettingNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint EventSettingNameFieldInfo = (~)CString
    type AttrTransferType EventSettingNameFieldInfo = CString
    type AttrGetType EventSettingNameFieldInfo = Maybe T.Text
    type AttrLabel EventSettingNameFieldInfo = "name"
    type AttrOrigin EventSettingNameFieldInfo = EventSetting
    attrGet = getEventSettingName
    attrSet = setEventSettingName
    attrConstruct = undefined
    attrClear = clearEventSettingName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventSetting.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventSetting.html#g:attr:name"
        })

eventSetting_name :: AttrLabelProxy "name"
eventSetting_name = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventSetting
type instance O.AttributeList EventSetting = EventSettingAttributeList
type EventSettingAttributeList = ('[ '("type", EventSettingTypeFieldInfo), '("window", EventSettingWindowFieldInfo), '("sendEvent", EventSettingSendEventFieldInfo), '("action", EventSettingActionFieldInfo), '("name", EventSettingNameFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventSettingMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventSettingMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventSettingMethod t EventSetting, O.OverloadedMethod info EventSetting p) => OL.IsLabel t (EventSetting -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventSettingMethod t EventSetting, O.OverloadedMethod info EventSetting p, R.HasField t EventSetting p) => R.HasField t EventSetting p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventSettingMethod t EventSetting, O.OverloadedMethodInfo info EventSetting) => OL.IsLabel t (O.MethodProxy info EventSetting) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


