{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during 'GI.Gdk.Enums.InputSourceTabletPad' mode switches in a group.
-- 
-- /Since: 3.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventPadGroupMode
    ( 

-- * Exported types
    EventPadGroupMode(..)                   ,
    newZeroEventPadGroupMode                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventPadGroupModeMethod          ,
#endif



 -- * Properties


-- ** group #attr:group#
-- | the pad group that is switching mode. A 'GI.Gdk.Enums.InputSourceTabletPad'
--   device may have one or more groups containing a set of buttons\/rings\/strips
--   each.

#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_group                 ,
#endif
    getEventPadGroupModeGroup               ,
    setEventPadGroupModeGroup               ,


-- ** mode #attr:mode#
-- | The new mode of /@group@/. Different groups in a 'GI.Gdk.Enums.InputSourceTabletPad'
--   device may have different current modes.

#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_mode                  ,
#endif
    getEventPadGroupModeMode                ,
    setEventPadGroupModeMode                ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_sendEvent             ,
#endif
    getEventPadGroupModeSendEvent           ,
    setEventPadGroupModeSendEvent           ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_time                  ,
#endif
    getEventPadGroupModeTime                ,
    setEventPadGroupModeTime                ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypePadGroupMode').

#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_type                  ,
#endif
    getEventPadGroupModeType                ,
    setEventPadGroupModeType                ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventPadGroupModeWindow            ,
#if defined(ENABLE_OVERLOADING)
    eventPadGroupMode_window                ,
#endif
    getEventPadGroupModeWindow              ,
    setEventPadGroupModeWindow              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventPadGroupMode = EventPadGroupMode (SP.ManagedPtr EventPadGroupMode)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventPadGroupMode where
    toManagedPtr (EventPadGroupMode p) = p

instance BoxedPtr EventPadGroupMode where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr EventPadGroupMode)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventPadGroupMode where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `EventPadGroupMode` struct initialized to zero.
newZeroEventPadGroupMode :: MonadIO m => m EventPadGroupMode
newZeroEventPadGroupMode = liftIO $ boxedPtrCalloc >>= wrapPtr EventPadGroupMode

instance tag ~ 'AttrSet => Constructible EventPadGroupMode tag where
    new _ attrs = do
        o <- newZeroEventPadGroupMode
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #type
-- @
getEventPadGroupModeType :: MonadIO m => EventPadGroupMode -> m Gdk.Enums.EventType
getEventPadGroupModeType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeType :: MonadIO m => EventPadGroupMode -> Gdk.Enums.EventType -> m ()
setEventPadGroupModeType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeTypeFieldInfo
instance AttrInfo EventPadGroupModeTypeFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeTypeFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventPadGroupModeTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventPadGroupModeTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventPadGroupModeTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventPadGroupModeTypeFieldInfo = "type"
    type AttrOrigin EventPadGroupModeTypeFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeType
    attrSet = setEventPadGroupModeType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:type"
        })

eventPadGroupMode_type :: AttrLabelProxy "type"
eventPadGroupMode_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #window
-- @
getEventPadGroupModeWindow :: MonadIO m => EventPadGroupMode -> m (Maybe Gdk.Window.Window)
getEventPadGroupModeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeWindow :: MonadIO m => EventPadGroupMode -> Ptr Gdk.Window.Window -> m ()
setEventPadGroupModeWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventPadGroupModeWindow :: MonadIO m => EventPadGroupMode -> m ()
clearEventPadGroupModeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeWindowFieldInfo
instance AttrInfo EventPadGroupModeWindowFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeWindowFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventPadGroupModeWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventPadGroupModeWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventPadGroupModeWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventPadGroupModeWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventPadGroupModeWindowFieldInfo = "window"
    type AttrOrigin EventPadGroupModeWindowFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeWindow
    attrSet = setEventPadGroupModeWindow
    attrConstruct = undefined
    attrClear = clearEventPadGroupModeWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:window"
        })

eventPadGroupMode_window :: AttrLabelProxy "window"
eventPadGroupMode_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #sendEvent
-- @
getEventPadGroupModeSendEvent :: MonadIO m => EventPadGroupMode -> m Int8
getEventPadGroupModeSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeSendEvent :: MonadIO m => EventPadGroupMode -> Int8 -> m ()
setEventPadGroupModeSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeSendEventFieldInfo
instance AttrInfo EventPadGroupModeSendEventFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeSendEventFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventPadGroupModeSendEventFieldInfo = (~)Int8
    type AttrTransferType EventPadGroupModeSendEventFieldInfo = Int8
    type AttrGetType EventPadGroupModeSendEventFieldInfo = Int8
    type AttrLabel EventPadGroupModeSendEventFieldInfo = "send_event"
    type AttrOrigin EventPadGroupModeSendEventFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeSendEvent
    attrSet = setEventPadGroupModeSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:sendEvent"
        })

eventPadGroupMode_sendEvent :: AttrLabelProxy "sendEvent"
eventPadGroupMode_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #time
-- @
getEventPadGroupModeTime :: MonadIO m => EventPadGroupMode -> m Word32
getEventPadGroupModeTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeTime :: MonadIO m => EventPadGroupMode -> Word32 -> m ()
setEventPadGroupModeTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeTimeFieldInfo
instance AttrInfo EventPadGroupModeTimeFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeTimeFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadGroupModeTimeFieldInfo = (~)Word32
    type AttrTransferType EventPadGroupModeTimeFieldInfo = Word32
    type AttrGetType EventPadGroupModeTimeFieldInfo = Word32
    type AttrLabel EventPadGroupModeTimeFieldInfo = "time"
    type AttrOrigin EventPadGroupModeTimeFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeTime
    attrSet = setEventPadGroupModeTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:time"
        })

eventPadGroupMode_time :: AttrLabelProxy "time"
eventPadGroupMode_time = AttrLabelProxy

#endif


-- | Get the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #group
-- @
getEventPadGroupModeGroup :: MonadIO m => EventPadGroupMode -> m Word32
getEventPadGroupModeGroup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word32
    return val

-- | Set the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeGroup :: MonadIO m => EventPadGroupMode -> Word32 -> m ()
setEventPadGroupModeGroup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeGroupFieldInfo
instance AttrInfo EventPadGroupModeGroupFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeGroupFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeGroupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeGroupFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadGroupModeGroupFieldInfo = (~)Word32
    type AttrTransferType EventPadGroupModeGroupFieldInfo = Word32
    type AttrGetType EventPadGroupModeGroupFieldInfo = Word32
    type AttrLabel EventPadGroupModeGroupFieldInfo = "group"
    type AttrOrigin EventPadGroupModeGroupFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeGroup
    attrSet = setEventPadGroupModeGroup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:group"
        })

eventPadGroupMode_group :: AttrLabelProxy "group"
eventPadGroupMode_group = AttrLabelProxy

#endif


-- | Get the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadGroupMode #mode
-- @
getEventPadGroupModeMode :: MonadIO m => EventPadGroupMode -> m Word32
getEventPadGroupModeMode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadGroupMode [ #mode 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadGroupModeMode :: MonadIO m => EventPadGroupMode -> Word32 -> m ()
setEventPadGroupModeMode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadGroupModeModeFieldInfo
instance AttrInfo EventPadGroupModeModeFieldInfo where
    type AttrBaseTypeConstraint EventPadGroupModeModeFieldInfo = (~) EventPadGroupMode
    type AttrAllowedOps EventPadGroupModeModeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadGroupModeModeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadGroupModeModeFieldInfo = (~)Word32
    type AttrTransferType EventPadGroupModeModeFieldInfo = Word32
    type AttrGetType EventPadGroupModeModeFieldInfo = Word32
    type AttrLabel EventPadGroupModeModeFieldInfo = "mode"
    type AttrOrigin EventPadGroupModeModeFieldInfo = EventPadGroupMode
    attrGet = getEventPadGroupModeMode
    attrSet = setEventPadGroupModeMode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadGroupMode.mode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadGroupMode.html#g:attr:mode"
        })

eventPadGroupMode_mode :: AttrLabelProxy "mode"
eventPadGroupMode_mode = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventPadGroupMode
type instance O.AttributeList EventPadGroupMode = EventPadGroupModeAttributeList
type EventPadGroupModeAttributeList = ('[ '("type", EventPadGroupModeTypeFieldInfo), '("window", EventPadGroupModeWindowFieldInfo), '("sendEvent", EventPadGroupModeSendEventFieldInfo), '("time", EventPadGroupModeTimeFieldInfo), '("group", EventPadGroupModeGroupFieldInfo), '("mode", EventPadGroupModeModeFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventPadGroupModeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventPadGroupModeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventPadGroupModeMethod t EventPadGroupMode, O.OverloadedMethod info EventPadGroupMode p) => OL.IsLabel t (EventPadGroupMode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventPadGroupModeMethod t EventPadGroupMode, O.OverloadedMethod info EventPadGroupMode p, R.HasField t EventPadGroupMode p) => R.HasField t EventPadGroupMode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventPadGroupModeMethod t EventPadGroupMode, O.OverloadedMethodInfo info EventPadGroupMode) => OL.IsLabel t (O.MethodProxy info EventPadGroupMode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


