{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during 'GI.Gdk.Enums.InputSourceTabletPad' interaction with tactile sensors.
-- 
-- /Since: 3.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventPadAxis
    ( 

-- * Exported types
    EventPadAxis(..)                        ,
    newZeroEventPadAxis                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventPadAxisMethod               ,
#endif



 -- * Properties


-- ** group #attr:group#
-- | the pad group the ring\/strip belongs to. A 'GI.Gdk.Enums.InputSourceTabletPad'
--   device may have one or more groups containing a set of buttons\/rings\/strips
--   each.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_group                      ,
#endif
    getEventPadAxisGroup                    ,
    setEventPadAxisGroup                    ,


-- ** index #attr:index#
-- | number of strip\/ring that was interacted. This number is 0-indexed.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_index                      ,
#endif
    getEventPadAxisIndex                    ,
    setEventPadAxisIndex                    ,


-- ** mode #attr:mode#
-- | The current mode of /@group@/. Different groups in a 'GI.Gdk.Enums.InputSourceTabletPad'
--   device may have different current modes.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_mode                       ,
#endif
    getEventPadAxisMode                     ,
    setEventPadAxisMode                     ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_sendEvent                  ,
#endif
    getEventPadAxisSendEvent                ,
    setEventPadAxisSendEvent                ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_time                       ,
#endif
    getEventPadAxisTime                     ,
    setEventPadAxisTime                     ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypePadRing' or 'GI.Gdk.Enums.EventTypePadStrip').

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_type                       ,
#endif
    getEventPadAxisType                     ,
    setEventPadAxisType                     ,


-- ** value #attr:value#
-- | The current value for the given axis.

#if defined(ENABLE_OVERLOADING)
    eventPadAxis_value                      ,
#endif
    getEventPadAxisValue                    ,
    setEventPadAxisValue                    ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventPadAxisWindow                 ,
#if defined(ENABLE_OVERLOADING)
    eventPadAxis_window                     ,
#endif
    getEventPadAxisWindow                   ,
    setEventPadAxisWindow                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventPadAxis = EventPadAxis (SP.ManagedPtr EventPadAxis)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventPadAxis where
    toManagedPtr (EventPadAxis p) = p

instance BoxedPtr EventPadAxis where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 48 >=> B.ManagedPtr.wrapPtr EventPadAxis)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventPadAxis where
    boxedPtrCalloc = callocBytes 48


-- | Construct a `EventPadAxis` struct initialized to zero.
newZeroEventPadAxis :: MonadIO m => m EventPadAxis
newZeroEventPadAxis = liftIO $ boxedPtrCalloc >>= wrapPtr EventPadAxis

instance tag ~ 'AttrSet => Constructible EventPadAxis tag where
    new _ attrs = do
        o <- newZeroEventPadAxis
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #type
-- @
getEventPadAxisType :: MonadIO m => EventPadAxis -> m Gdk.Enums.EventType
getEventPadAxisType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisType :: MonadIO m => EventPadAxis -> Gdk.Enums.EventType -> m ()
setEventPadAxisType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisTypeFieldInfo
instance AttrInfo EventPadAxisTypeFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisTypeFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventPadAxisTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventPadAxisTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventPadAxisTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventPadAxisTypeFieldInfo = "type"
    type AttrOrigin EventPadAxisTypeFieldInfo = EventPadAxis
    attrGet = getEventPadAxisType
    attrSet = setEventPadAxisType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:type"
        })

eventPadAxis_type :: AttrLabelProxy "type"
eventPadAxis_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #window
-- @
getEventPadAxisWindow :: MonadIO m => EventPadAxis -> m (Maybe Gdk.Window.Window)
getEventPadAxisWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisWindow :: MonadIO m => EventPadAxis -> Ptr Gdk.Window.Window -> m ()
setEventPadAxisWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventPadAxisWindow :: MonadIO m => EventPadAxis -> m ()
clearEventPadAxisWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisWindowFieldInfo
instance AttrInfo EventPadAxisWindowFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisWindowFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventPadAxisWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventPadAxisWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventPadAxisWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventPadAxisWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventPadAxisWindowFieldInfo = "window"
    type AttrOrigin EventPadAxisWindowFieldInfo = EventPadAxis
    attrGet = getEventPadAxisWindow
    attrSet = setEventPadAxisWindow
    attrConstruct = undefined
    attrClear = clearEventPadAxisWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:window"
        })

eventPadAxis_window :: AttrLabelProxy "window"
eventPadAxis_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #sendEvent
-- @
getEventPadAxisSendEvent :: MonadIO m => EventPadAxis -> m Int8
getEventPadAxisSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisSendEvent :: MonadIO m => EventPadAxis -> Int8 -> m ()
setEventPadAxisSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisSendEventFieldInfo
instance AttrInfo EventPadAxisSendEventFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisSendEventFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventPadAxisSendEventFieldInfo = (~)Int8
    type AttrTransferType EventPadAxisSendEventFieldInfo = Int8
    type AttrGetType EventPadAxisSendEventFieldInfo = Int8
    type AttrLabel EventPadAxisSendEventFieldInfo = "send_event"
    type AttrOrigin EventPadAxisSendEventFieldInfo = EventPadAxis
    attrGet = getEventPadAxisSendEvent
    attrSet = setEventPadAxisSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:sendEvent"
        })

eventPadAxis_sendEvent :: AttrLabelProxy "sendEvent"
eventPadAxis_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #time
-- @
getEventPadAxisTime :: MonadIO m => EventPadAxis -> m Word32
getEventPadAxisTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisTime :: MonadIO m => EventPadAxis -> Word32 -> m ()
setEventPadAxisTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisTimeFieldInfo
instance AttrInfo EventPadAxisTimeFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisTimeFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadAxisTimeFieldInfo = (~)Word32
    type AttrTransferType EventPadAxisTimeFieldInfo = Word32
    type AttrGetType EventPadAxisTimeFieldInfo = Word32
    type AttrLabel EventPadAxisTimeFieldInfo = "time"
    type AttrOrigin EventPadAxisTimeFieldInfo = EventPadAxis
    attrGet = getEventPadAxisTime
    attrSet = setEventPadAxisTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:time"
        })

eventPadAxis_time :: AttrLabelProxy "time"
eventPadAxis_time = AttrLabelProxy

#endif


-- | Get the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #group
-- @
getEventPadAxisGroup :: MonadIO m => EventPadAxis -> m Word32
getEventPadAxisGroup s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO Word32
    return val

-- | Set the value of the “@group@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #group 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisGroup :: MonadIO m => EventPadAxis -> Word32 -> m ()
setEventPadAxisGroup s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisGroupFieldInfo
instance AttrInfo EventPadAxisGroupFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisGroupFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisGroupFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisGroupFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadAxisGroupFieldInfo = (~)Word32
    type AttrTransferType EventPadAxisGroupFieldInfo = Word32
    type AttrGetType EventPadAxisGroupFieldInfo = Word32
    type AttrLabel EventPadAxisGroupFieldInfo = "group"
    type AttrOrigin EventPadAxisGroupFieldInfo = EventPadAxis
    attrGet = getEventPadAxisGroup
    attrSet = setEventPadAxisGroup
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.group"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:group"
        })

eventPadAxis_group :: AttrLabelProxy "group"
eventPadAxis_group = AttrLabelProxy

#endif


-- | Get the value of the “@index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #index
-- @
getEventPadAxisIndex :: MonadIO m => EventPadAxis -> m Word32
getEventPadAxisIndex s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 28) :: IO Word32
    return val

-- | Set the value of the “@index@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #index 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisIndex :: MonadIO m => EventPadAxis -> Word32 -> m ()
setEventPadAxisIndex s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 28) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisIndexFieldInfo
instance AttrInfo EventPadAxisIndexFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisIndexFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisIndexFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisIndexFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadAxisIndexFieldInfo = (~)Word32
    type AttrTransferType EventPadAxisIndexFieldInfo = Word32
    type AttrGetType EventPadAxisIndexFieldInfo = Word32
    type AttrLabel EventPadAxisIndexFieldInfo = "index"
    type AttrOrigin EventPadAxisIndexFieldInfo = EventPadAxis
    attrGet = getEventPadAxisIndex
    attrSet = setEventPadAxisIndex
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.index"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:index"
        })

eventPadAxis_index :: AttrLabelProxy "index"
eventPadAxis_index = AttrLabelProxy

#endif


-- | Get the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #mode
-- @
getEventPadAxisMode :: MonadIO m => EventPadAxis -> m Word32
getEventPadAxisMode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #mode 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisMode :: MonadIO m => EventPadAxis -> Word32 -> m ()
setEventPadAxisMode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisModeFieldInfo
instance AttrInfo EventPadAxisModeFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisModeFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisModeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisModeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventPadAxisModeFieldInfo = (~)Word32
    type AttrTransferType EventPadAxisModeFieldInfo = Word32
    type AttrGetType EventPadAxisModeFieldInfo = Word32
    type AttrLabel EventPadAxisModeFieldInfo = "mode"
    type AttrOrigin EventPadAxisModeFieldInfo = EventPadAxis
    attrGet = getEventPadAxisMode
    attrSet = setEventPadAxisMode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.mode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:mode"
        })

eventPadAxis_mode :: AttrLabelProxy "mode"
eventPadAxis_mode = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventPadAxis #value
-- @
getEventPadAxisValue :: MonadIO m => EventPadAxis -> m Double
getEventPadAxisValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventPadAxis [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventPadAxisValue :: MonadIO m => EventPadAxis -> Double -> m ()
setEventPadAxisValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventPadAxisValueFieldInfo
instance AttrInfo EventPadAxisValueFieldInfo where
    type AttrBaseTypeConstraint EventPadAxisValueFieldInfo = (~) EventPadAxis
    type AttrAllowedOps EventPadAxisValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventPadAxisValueFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventPadAxisValueFieldInfo = (~)Double
    type AttrTransferType EventPadAxisValueFieldInfo = Double
    type AttrGetType EventPadAxisValueFieldInfo = Double
    type AttrLabel EventPadAxisValueFieldInfo = "value"
    type AttrOrigin EventPadAxisValueFieldInfo = EventPadAxis
    attrGet = getEventPadAxisValue
    attrSet = setEventPadAxisValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventPadAxis.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventPadAxis.html#g:attr:value"
        })

eventPadAxis_value :: AttrLabelProxy "value"
eventPadAxis_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventPadAxis
type instance O.AttributeList EventPadAxis = EventPadAxisAttributeList
type EventPadAxisAttributeList = ('[ '("type", EventPadAxisTypeFieldInfo), '("window", EventPadAxisWindowFieldInfo), '("sendEvent", EventPadAxisSendEventFieldInfo), '("time", EventPadAxisTimeFieldInfo), '("group", EventPadAxisGroupFieldInfo), '("index", EventPadAxisIndexFieldInfo), '("mode", EventPadAxisModeFieldInfo), '("value", EventPadAxisValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventPadAxisMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventPadAxisMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventPadAxisMethod t EventPadAxis, O.OverloadedMethod info EventPadAxis p) => OL.IsLabel t (EventPadAxis -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventPadAxisMethod t EventPadAxis, O.OverloadedMethod info EventPadAxis p, R.HasField t EventPadAxis p) => R.HasField t EventPadAxis p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventPadAxisMethod t EventPadAxis, O.OverloadedMethodInfo info EventPadAxis) => OL.IsLabel t (O.MethodProxy info EventPadAxis) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


