{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when all or part of a window becomes visible and needs to be
-- redrawn.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventExpose
    ( 

-- * Exported types
    EventExpose(..)                         ,
    newZeroEventExpose                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventExposeMethod                ,
#endif



 -- * Properties


-- ** area #attr:area#
-- | bounding box of /@region@/.

#if defined(ENABLE_OVERLOADING)
    eventExpose_area                        ,
#endif
    getEventExposeArea                      ,


-- ** count #attr:count#
-- | the number of contiguous 'GI.Gdk.Enums.EventTypeExpose' events following this one.
--   The only use for this is “exposure compression”, i.e. handling all
--   contiguous 'GI.Gdk.Enums.EventTypeExpose' events in one go, though GDK performs some
--   exposure compression so this is not normally needed.

#if defined(ENABLE_OVERLOADING)
    eventExpose_count                       ,
#endif
    getEventExposeCount                     ,
    setEventExposeCount                     ,


-- ** region #attr:region#
-- | the region that needs to be redrawn.

    clearEventExposeRegion                  ,
#if defined(ENABLE_OVERLOADING)
    eventExpose_region                      ,
#endif
    getEventExposeRegion                    ,
    setEventExposeRegion                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventExpose_sendEvent                   ,
#endif
    getEventExposeSendEvent                 ,
    setEventExposeSendEvent                 ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeExpose' or 'GI.Gdk.Enums.EventTypeDamage').

#if defined(ENABLE_OVERLOADING)
    eventExpose_type                        ,
#endif
    getEventExposeType                      ,
    setEventExposeType                      ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventExposeWindow                  ,
#if defined(ENABLE_OVERLOADING)
    eventExpose_window                      ,
#endif
    getEventExposeWindow                    ,
    setEventExposeWindow                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle

#endif

-- | Memory-managed wrapper type.
newtype EventExpose = EventExpose (SP.ManagedPtr EventExpose)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventExpose where
    toManagedPtr (EventExpose p) = p

instance BoxedPtr EventExpose where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 56 >=> B.ManagedPtr.wrapPtr EventExpose)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventExpose where
    boxedPtrCalloc = callocBytes 56


-- | Construct a `EventExpose` struct initialized to zero.
newZeroEventExpose :: MonadIO m => m EventExpose
newZeroEventExpose = liftIO $ boxedPtrCalloc >>= wrapPtr EventExpose

instance tag ~ 'AttrSet => Constructible EventExpose tag where
    new _ attrs = do
        o <- newZeroEventExpose
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #type
-- @
getEventExposeType :: MonadIO m => EventExpose -> m Gdk.Enums.EventType
getEventExposeType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventExpose [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventExposeType :: MonadIO m => EventExpose -> Gdk.Enums.EventType -> m ()
setEventExposeType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventExposeTypeFieldInfo
instance AttrInfo EventExposeTypeFieldInfo where
    type AttrBaseTypeConstraint EventExposeTypeFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventExposeTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventExposeTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventExposeTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventExposeTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventExposeTypeFieldInfo = "type"
    type AttrOrigin EventExposeTypeFieldInfo = EventExpose
    attrGet = getEventExposeType
    attrSet = setEventExposeType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:type"
        })

eventExpose_type :: AttrLabelProxy "type"
eventExpose_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #window
-- @
getEventExposeWindow :: MonadIO m => EventExpose -> m (Maybe Gdk.Window.Window)
getEventExposeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventExpose [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventExposeWindow :: MonadIO m => EventExpose -> Ptr Gdk.Window.Window -> m ()
setEventExposeWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventExposeWindow :: MonadIO m => EventExpose -> m ()
clearEventExposeWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventExposeWindowFieldInfo
instance AttrInfo EventExposeWindowFieldInfo where
    type AttrBaseTypeConstraint EventExposeWindowFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventExposeWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventExposeWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventExposeWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventExposeWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventExposeWindowFieldInfo = "window"
    type AttrOrigin EventExposeWindowFieldInfo = EventExpose
    attrGet = getEventExposeWindow
    attrSet = setEventExposeWindow
    attrConstruct = undefined
    attrClear = clearEventExposeWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:window"
        })

eventExpose_window :: AttrLabelProxy "window"
eventExpose_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #sendEvent
-- @
getEventExposeSendEvent :: MonadIO m => EventExpose -> m Int8
getEventExposeSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventExpose [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventExposeSendEvent :: MonadIO m => EventExpose -> Int8 -> m ()
setEventExposeSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventExposeSendEventFieldInfo
instance AttrInfo EventExposeSendEventFieldInfo where
    type AttrBaseTypeConstraint EventExposeSendEventFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventExposeSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventExposeSendEventFieldInfo = (~)Int8
    type AttrTransferType EventExposeSendEventFieldInfo = Int8
    type AttrGetType EventExposeSendEventFieldInfo = Int8
    type AttrLabel EventExposeSendEventFieldInfo = "send_event"
    type AttrOrigin EventExposeSendEventFieldInfo = EventExpose
    attrGet = getEventExposeSendEvent
    attrSet = setEventExposeSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:sendEvent"
        })

eventExpose_sendEvent :: AttrLabelProxy "sendEvent"
eventExpose_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@area@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #area
-- @
getEventExposeArea :: MonadIO m => EventExpose -> m Gdk.Rectangle.Rectangle
getEventExposeArea s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 20 :: (Ptr Gdk.Rectangle.Rectangle)
    val' <- (newBoxed Gdk.Rectangle.Rectangle) val
    return val'

#if defined(ENABLE_OVERLOADING)
data EventExposeAreaFieldInfo
instance AttrInfo EventExposeAreaFieldInfo where
    type AttrBaseTypeConstraint EventExposeAreaFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeAreaFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint EventExposeAreaFieldInfo = (~) (Ptr Gdk.Rectangle.Rectangle)
    type AttrTransferTypeConstraint EventExposeAreaFieldInfo = (~)(Ptr Gdk.Rectangle.Rectangle)
    type AttrTransferType EventExposeAreaFieldInfo = (Ptr Gdk.Rectangle.Rectangle)
    type AttrGetType EventExposeAreaFieldInfo = Gdk.Rectangle.Rectangle
    type AttrLabel EventExposeAreaFieldInfo = "area"
    type AttrOrigin EventExposeAreaFieldInfo = EventExpose
    attrGet = getEventExposeArea
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.area"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:area"
        })

eventExpose_area :: AttrLabelProxy "area"
eventExpose_area = AttrLabelProxy

#endif


-- | Get the value of the “@region@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #region
-- @
getEventExposeRegion :: MonadIO m => EventExpose -> m (Maybe Cairo.Region.Region)
getEventExposeRegion s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO (Ptr Cairo.Region.Region)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newBoxed Cairo.Region.Region) val'
        return val''
    return result

-- | Set the value of the “@region@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventExpose [ #region 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventExposeRegion :: MonadIO m => EventExpose -> Ptr Cairo.Region.Region -> m ()
setEventExposeRegion s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (val :: Ptr Cairo.Region.Region)

-- | Set the value of the “@region@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #region
-- @
clearEventExposeRegion :: MonadIO m => EventExpose -> m ()
clearEventExposeRegion s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 40) (FP.nullPtr :: Ptr Cairo.Region.Region)

#if defined(ENABLE_OVERLOADING)
data EventExposeRegionFieldInfo
instance AttrInfo EventExposeRegionFieldInfo where
    type AttrBaseTypeConstraint EventExposeRegionFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeRegionFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventExposeRegionFieldInfo = (~) (Ptr Cairo.Region.Region)
    type AttrTransferTypeConstraint EventExposeRegionFieldInfo = (~)(Ptr Cairo.Region.Region)
    type AttrTransferType EventExposeRegionFieldInfo = (Ptr Cairo.Region.Region)
    type AttrGetType EventExposeRegionFieldInfo = Maybe Cairo.Region.Region
    type AttrLabel EventExposeRegionFieldInfo = "region"
    type AttrOrigin EventExposeRegionFieldInfo = EventExpose
    attrGet = getEventExposeRegion
    attrSet = setEventExposeRegion
    attrConstruct = undefined
    attrClear = clearEventExposeRegion
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.region"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:region"
        })

eventExpose_region :: AttrLabelProxy "region"
eventExpose_region = AttrLabelProxy

#endif


-- | Get the value of the “@count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventExpose #count
-- @
getEventExposeCount :: MonadIO m => EventExpose -> m Int32
getEventExposeCount s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO Int32
    return val

-- | Set the value of the “@count@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventExpose [ #count 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventExposeCount :: MonadIO m => EventExpose -> Int32 -> m ()
setEventExposeCount s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data EventExposeCountFieldInfo
instance AttrInfo EventExposeCountFieldInfo where
    type AttrBaseTypeConstraint EventExposeCountFieldInfo = (~) EventExpose
    type AttrAllowedOps EventExposeCountFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventExposeCountFieldInfo = (~) Int32
    type AttrTransferTypeConstraint EventExposeCountFieldInfo = (~)Int32
    type AttrTransferType EventExposeCountFieldInfo = Int32
    type AttrGetType EventExposeCountFieldInfo = Int32
    type AttrLabel EventExposeCountFieldInfo = "count"
    type AttrOrigin EventExposeCountFieldInfo = EventExpose
    attrGet = getEventExposeCount
    attrSet = setEventExposeCount
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventExpose.count"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventExpose.html#g:attr:count"
        })

eventExpose_count :: AttrLabelProxy "count"
eventExpose_count = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventExpose
type instance O.AttributeList EventExpose = EventExposeAttributeList
type EventExposeAttributeList = ('[ '("type", EventExposeTypeFieldInfo), '("window", EventExposeWindowFieldInfo), '("sendEvent", EventExposeSendEventFieldInfo), '("area", EventExposeAreaFieldInfo), '("region", EventExposeRegionFieldInfo), '("count", EventExposeCountFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventExposeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventExposeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventExposeMethod t EventExpose, O.OverloadedMethod info EventExpose p) => OL.IsLabel t (EventExpose -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventExposeMethod t EventExpose, O.OverloadedMethod info EventExpose p, R.HasField t EventExpose p) => R.HasField t EventExpose p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventExposeMethod t EventExpose, O.OverloadedMethodInfo info EventExpose) => OL.IsLabel t (O.MethodProxy info EventExpose) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


