{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gdk.Objects.Keymap.Keymap' defines the translation from keyboard state
-- (including a hardware key, a modifier mask, and active keyboard group)
-- to a keyval. This translation has two phases. The first phase is
-- to determine the effective keyboard group and level for the keyboard
-- state; the second phase is to look up the keycode\/group\/level triplet
-- in the keymap and see what keyval it corresponds to.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Keymap
    ( 

-- * Exported types
    Keymap(..)                              ,
    IsKeymap                                ,
    toKeymap                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addVirtualModifiers]("GI.Gdk.Objects.Keymap#g:method:addVirtualModifiers"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [haveBidiLayouts]("GI.Gdk.Objects.Keymap#g:method:haveBidiLayouts"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lookupKey]("GI.Gdk.Objects.Keymap#g:method:lookupKey"), [mapVirtualModifiers]("GI.Gdk.Objects.Keymap#g:method:mapVirtualModifiers"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateKeyboardState]("GI.Gdk.Objects.Keymap#g:method:translateKeyboardState"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCapsLockState]("GI.Gdk.Objects.Keymap#g:method:getCapsLockState"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gdk.Objects.Keymap#g:method:getDirection"), [getEntriesForKeycode]("GI.Gdk.Objects.Keymap#g:method:getEntriesForKeycode"), [getEntriesForKeyval]("GI.Gdk.Objects.Keymap#g:method:getEntriesForKeyval"), [getModifierMask]("GI.Gdk.Objects.Keymap#g:method:getModifierMask"), [getModifierState]("GI.Gdk.Objects.Keymap#g:method:getModifierState"), [getNumLockState]("GI.Gdk.Objects.Keymap#g:method:getNumLockState"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScrollLockState]("GI.Gdk.Objects.Keymap#g:method:getScrollLockState").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveKeymapMethod                     ,
#endif

-- ** addVirtualModifiers #method:addVirtualModifiers#

#if defined(ENABLE_OVERLOADING)
    KeymapAddVirtualModifiersMethodInfo     ,
#endif
    keymapAddVirtualModifiers               ,


-- ** getCapsLockState #method:getCapsLockState#

#if defined(ENABLE_OVERLOADING)
    KeymapGetCapsLockStateMethodInfo        ,
#endif
    keymapGetCapsLockState                  ,


-- ** getDefault #method:getDefault#

    keymapGetDefault                        ,


-- ** getDirection #method:getDirection#

#if defined(ENABLE_OVERLOADING)
    KeymapGetDirectionMethodInfo            ,
#endif
    keymapGetDirection                      ,


-- ** getEntriesForKeycode #method:getEntriesForKeycode#

#if defined(ENABLE_OVERLOADING)
    KeymapGetEntriesForKeycodeMethodInfo    ,
#endif
    keymapGetEntriesForKeycode              ,


-- ** getEntriesForKeyval #method:getEntriesForKeyval#

#if defined(ENABLE_OVERLOADING)
    KeymapGetEntriesForKeyvalMethodInfo     ,
#endif
    keymapGetEntriesForKeyval               ,


-- ** getForDisplay #method:getForDisplay#

    keymapGetForDisplay                     ,


-- ** getModifierMask #method:getModifierMask#

#if defined(ENABLE_OVERLOADING)
    KeymapGetModifierMaskMethodInfo         ,
#endif
    keymapGetModifierMask                   ,


-- ** getModifierState #method:getModifierState#

#if defined(ENABLE_OVERLOADING)
    KeymapGetModifierStateMethodInfo        ,
#endif
    keymapGetModifierState                  ,


-- ** getNumLockState #method:getNumLockState#

#if defined(ENABLE_OVERLOADING)
    KeymapGetNumLockStateMethodInfo         ,
#endif
    keymapGetNumLockState                   ,


-- ** getScrollLockState #method:getScrollLockState#

#if defined(ENABLE_OVERLOADING)
    KeymapGetScrollLockStateMethodInfo      ,
#endif
    keymapGetScrollLockState                ,


-- ** haveBidiLayouts #method:haveBidiLayouts#

#if defined(ENABLE_OVERLOADING)
    KeymapHaveBidiLayoutsMethodInfo         ,
#endif
    keymapHaveBidiLayouts                   ,


-- ** lookupKey #method:lookupKey#

#if defined(ENABLE_OVERLOADING)
    KeymapLookupKeyMethodInfo               ,
#endif
    keymapLookupKey                         ,


-- ** mapVirtualModifiers #method:mapVirtualModifiers#

#if defined(ENABLE_OVERLOADING)
    KeymapMapVirtualModifiersMethodInfo     ,
#endif
    keymapMapVirtualModifiers               ,


-- ** translateKeyboardState #method:translateKeyboardState#

#if defined(ENABLE_OVERLOADING)
    KeymapTranslateKeyboardStateMethodInfo  ,
#endif
    keymapTranslateKeyboardState            ,




 -- * Signals


-- ** directionChanged #signal:directionChanged#

    KeymapDirectionChangedCallback          ,
#if defined(ENABLE_OVERLOADING)
    KeymapDirectionChangedSignalInfo        ,
#endif
    afterKeymapDirectionChanged             ,
    onKeymapDirectionChanged                ,


-- ** keysChanged #signal:keysChanged#

    KeymapKeysChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    KeymapKeysChangedSignalInfo             ,
#endif
    afterKeymapKeysChanged                  ,
    onKeymapKeysChanged                     ,


-- ** stateChanged #signal:stateChanged#

    KeymapStateChangedCallback              ,
#if defined(ENABLE_OVERLOADING)
    KeymapStateChangedSignalInfo            ,
#endif
    afterKeymapStateChanged                 ,
    onKeymapStateChanged                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype Keymap = Keymap (SP.ManagedPtr Keymap)
    deriving (Eq)

instance SP.ManagedPtrNewtype Keymap where
    toManagedPtr (Keymap p) = p

foreign import ccall "gdk_keymap_get_type"
    c_gdk_keymap_get_type :: IO B.Types.GType

instance B.Types.TypedObject Keymap where
    glibType = c_gdk_keymap_get_type

instance B.Types.GObject Keymap

-- | Type class for types which can be safely cast to `Keymap`, for instance with `toKeymap`.
class (SP.GObject o, O.IsDescendantOf Keymap o) => IsKeymap o
instance (SP.GObject o, O.IsDescendantOf Keymap o) => IsKeymap o

instance O.HasParentTypes Keymap
type instance O.ParentTypes Keymap = '[GObject.Object.Object]

-- | Cast to `Keymap`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toKeymap :: (MIO.MonadIO m, IsKeymap o) => o -> m Keymap
toKeymap = MIO.liftIO . B.ManagedPtr.unsafeCastTo Keymap

-- | Convert 'Keymap' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Keymap) where
    gvalueGType_ = c_gdk_keymap_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Keymap)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Keymap)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Keymap ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveKeymapMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveKeymapMethod "addVirtualModifiers" o = KeymapAddVirtualModifiersMethodInfo
    ResolveKeymapMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveKeymapMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveKeymapMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveKeymapMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveKeymapMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveKeymapMethod "haveBidiLayouts" o = KeymapHaveBidiLayoutsMethodInfo
    ResolveKeymapMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveKeymapMethod "lookupKey" o = KeymapLookupKeyMethodInfo
    ResolveKeymapMethod "mapVirtualModifiers" o = KeymapMapVirtualModifiersMethodInfo
    ResolveKeymapMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveKeymapMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveKeymapMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveKeymapMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveKeymapMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveKeymapMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveKeymapMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveKeymapMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveKeymapMethod "translateKeyboardState" o = KeymapTranslateKeyboardStateMethodInfo
    ResolveKeymapMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveKeymapMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveKeymapMethod "getCapsLockState" o = KeymapGetCapsLockStateMethodInfo
    ResolveKeymapMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveKeymapMethod "getDirection" o = KeymapGetDirectionMethodInfo
    ResolveKeymapMethod "getEntriesForKeycode" o = KeymapGetEntriesForKeycodeMethodInfo
    ResolveKeymapMethod "getEntriesForKeyval" o = KeymapGetEntriesForKeyvalMethodInfo
    ResolveKeymapMethod "getModifierMask" o = KeymapGetModifierMaskMethodInfo
    ResolveKeymapMethod "getModifierState" o = KeymapGetModifierStateMethodInfo
    ResolveKeymapMethod "getNumLockState" o = KeymapGetNumLockStateMethodInfo
    ResolveKeymapMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveKeymapMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveKeymapMethod "getScrollLockState" o = KeymapGetScrollLockStateMethodInfo
    ResolveKeymapMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveKeymapMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveKeymapMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveKeymapMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveKeymapMethod t Keymap, O.OverloadedMethod info Keymap p) => OL.IsLabel t (Keymap -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveKeymapMethod t Keymap, O.OverloadedMethod info Keymap p, R.HasField t Keymap p) => R.HasField t Keymap p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveKeymapMethod t Keymap, O.OverloadedMethodInfo info Keymap) => OL.IsLabel t (O.MethodProxy info Keymap) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Keymap::direction-changed
-- | The [directionChanged](#g:signal:directionChanged) signal gets emitted when the direction of
-- the keymap changes.
-- 
-- /Since: 2.0/
type KeymapDirectionChangedCallback =
    IO ()

type C_KeymapDirectionChangedCallback =
    Ptr Keymap ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_KeymapDirectionChangedCallback`.
foreign import ccall "wrapper"
    mk_KeymapDirectionChangedCallback :: C_KeymapDirectionChangedCallback -> IO (FunPtr C_KeymapDirectionChangedCallback)

wrap_KeymapDirectionChangedCallback :: 
    GObject a => (a -> KeymapDirectionChangedCallback) ->
    C_KeymapDirectionChangedCallback
wrap_KeymapDirectionChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [directionChanged](#signal:directionChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' keymap #directionChanged callback
-- @
-- 
-- 
onKeymapDirectionChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapDirectionChangedCallback) -> m SignalHandlerId
onKeymapDirectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapDirectionChangedCallback wrapped
    wrapped'' <- mk_KeymapDirectionChangedCallback wrapped'
    connectSignalFunPtr obj "direction-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [directionChanged](#signal:directionChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' keymap #directionChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterKeymapDirectionChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapDirectionChangedCallback) -> m SignalHandlerId
afterKeymapDirectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapDirectionChangedCallback wrapped
    wrapped'' <- mk_KeymapDirectionChangedCallback wrapped'
    connectSignalFunPtr obj "direction-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data KeymapDirectionChangedSignalInfo
instance SignalInfo KeymapDirectionChangedSignalInfo where
    type HaskellCallbackType KeymapDirectionChangedSignalInfo = KeymapDirectionChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_KeymapDirectionChangedCallback cb
        cb'' <- mk_KeymapDirectionChangedCallback cb'
        connectSignalFunPtr obj "direction-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap::direction-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#g:signal:directionChanged"})

#endif

-- signal Keymap::keys-changed
-- | The [keysChanged](#g:signal:keysChanged) signal is emitted when the mapping represented by
-- /@keymap@/ changes.
-- 
-- /Since: 2.2/
type KeymapKeysChangedCallback =
    IO ()

type C_KeymapKeysChangedCallback =
    Ptr Keymap ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_KeymapKeysChangedCallback`.
foreign import ccall "wrapper"
    mk_KeymapKeysChangedCallback :: C_KeymapKeysChangedCallback -> IO (FunPtr C_KeymapKeysChangedCallback)

wrap_KeymapKeysChangedCallback :: 
    GObject a => (a -> KeymapKeysChangedCallback) ->
    C_KeymapKeysChangedCallback
wrap_KeymapKeysChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [keysChanged](#signal:keysChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' keymap #keysChanged callback
-- @
-- 
-- 
onKeymapKeysChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapKeysChangedCallback) -> m SignalHandlerId
onKeymapKeysChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapKeysChangedCallback wrapped
    wrapped'' <- mk_KeymapKeysChangedCallback wrapped'
    connectSignalFunPtr obj "keys-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [keysChanged](#signal:keysChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' keymap #keysChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterKeymapKeysChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapKeysChangedCallback) -> m SignalHandlerId
afterKeymapKeysChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapKeysChangedCallback wrapped
    wrapped'' <- mk_KeymapKeysChangedCallback wrapped'
    connectSignalFunPtr obj "keys-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data KeymapKeysChangedSignalInfo
instance SignalInfo KeymapKeysChangedSignalInfo where
    type HaskellCallbackType KeymapKeysChangedSignalInfo = KeymapKeysChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_KeymapKeysChangedCallback cb
        cb'' <- mk_KeymapKeysChangedCallback cb'
        connectSignalFunPtr obj "keys-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap::keys-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#g:signal:keysChanged"})

#endif

-- signal Keymap::state-changed
-- | The [stateChanged](#g:signal:stateChanged) signal is emitted when the state of the
-- keyboard changes, e.g when Caps Lock is turned on or off.
-- See 'GI.Gdk.Objects.Keymap.keymapGetCapsLockState'.
-- 
-- /Since: 2.16/
type KeymapStateChangedCallback =
    IO ()

type C_KeymapStateChangedCallback =
    Ptr Keymap ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_KeymapStateChangedCallback`.
foreign import ccall "wrapper"
    mk_KeymapStateChangedCallback :: C_KeymapStateChangedCallback -> IO (FunPtr C_KeymapStateChangedCallback)

wrap_KeymapStateChangedCallback :: 
    GObject a => (a -> KeymapStateChangedCallback) ->
    C_KeymapStateChangedCallback
wrap_KeymapStateChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [stateChanged](#signal:stateChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' keymap #stateChanged callback
-- @
-- 
-- 
onKeymapStateChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapStateChangedCallback) -> m SignalHandlerId
onKeymapStateChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapStateChangedCallback wrapped
    wrapped'' <- mk_KeymapStateChangedCallback wrapped'
    connectSignalFunPtr obj "state-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [stateChanged](#signal:stateChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' keymap #stateChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterKeymapStateChanged :: (IsKeymap a, MonadIO m) => a -> ((?self :: a) => KeymapStateChangedCallback) -> m SignalHandlerId
afterKeymapStateChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_KeymapStateChangedCallback wrapped
    wrapped'' <- mk_KeymapStateChangedCallback wrapped'
    connectSignalFunPtr obj "state-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data KeymapStateChangedSignalInfo
instance SignalInfo KeymapStateChangedSignalInfo where
    type HaskellCallbackType KeymapStateChangedSignalInfo = KeymapStateChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_KeymapStateChangedCallback cb
        cb'' <- mk_KeymapStateChangedCallback cb'
        connectSignalFunPtr obj "state-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap::state-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#g:signal:stateChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Keymap
type instance O.AttributeList Keymap = KeymapAttributeList
type KeymapAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Keymap = KeymapSignalList
type KeymapSignalList = ('[ '("directionChanged", KeymapDirectionChangedSignalInfo), '("keysChanged", KeymapKeysChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("stateChanged", KeymapStateChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Keymap::add_virtual_modifiers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to the modifier mask to change"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_add_virtual_modifiers" gdk_keymap_add_virtual_modifiers :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Ptr CUInt ->                            -- state : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO ()

-- | Maps the non-virtual modifiers (i.e Mod2, Mod3, ...) which are set
-- in /@state@/ to the virtual modifiers (i.e. Super, Hyper and Meta) and
-- set the corresponding bits in /@state@/.
-- 
-- GDK already does this before delivering key events, but for
-- compatibility reasons, it only sets the first virtual modifier
-- it finds, whereas this function sets all matching virtual modifiers.
-- 
-- This function is useful when matching key events against
-- accelerators.
-- 
-- /Since: 2.20/
keymapAddVirtualModifiers ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: pointer to the modifier mask to change
    -> m ([Gdk.Flags.ModifierType])
keymapAddVirtualModifiers keymap state = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    let state' = gflagsToWord state
    state'' <- allocMem :: IO (Ptr CUInt)
    poke state'' state'
    gdk_keymap_add_virtual_modifiers keymap' state''
    state''' <- peek state''
    let state'''' = wordToGFlags state'''
    touchManagedPtr keymap
    freeMem state''
    return state''''

#if defined(ENABLE_OVERLOADING)
data KeymapAddVirtualModifiersMethodInfo
instance (signature ~ ([Gdk.Flags.ModifierType] -> m ([Gdk.Flags.ModifierType])), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapAddVirtualModifiersMethodInfo a signature where
    overloadedMethod = keymapAddVirtualModifiers

instance O.OverloadedMethodInfo KeymapAddVirtualModifiersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapAddVirtualModifiers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapAddVirtualModifiers"
        })


#endif

-- method Keymap::get_caps_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_caps_lock_state" gdk_keymap_get_caps_lock_state :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO CInt

-- | Returns whether the Caps Lock modifer is locked.
-- 
-- /Since: 2.16/
keymapGetCapsLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Caps Lock is on
keymapGetCapsLockState keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_get_caps_lock_state keymap'
    let result' = (/= 0) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapGetCapsLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetCapsLockStateMethodInfo a signature where
    overloadedMethod = keymapGetCapsLockState

instance O.OverloadedMethodInfo KeymapGetCapsLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetCapsLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetCapsLockState"
        })


#endif

-- method Keymap::get_direction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Direction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_direction" gdk_keymap_get_direction :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO CUInt

-- | Returns the direction of effective layout of the keymap.
keymapGetDirection ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Pango.Enums.Direction
    -- ^ __Returns:__ 'GI.Pango.Enums.DirectionLtr' or 'GI.Pango.Enums.DirectionRtl'
    --   if it can determine the direction. 'GI.Pango.Enums.DirectionNeutral'
    --   otherwise.
keymapGetDirection keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_get_direction keymap'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapGetDirectionMethodInfo
instance (signature ~ (m Pango.Enums.Direction), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetDirectionMethodInfo a signature where
    overloadedMethod = keymapGetDirection

instance O.OverloadedMethodInfo KeymapGetDirectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetDirection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetDirection"
        })


#endif

-- method Keymap::get_entries_for_keycode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hardware_keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keycode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keys"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gdk" , name = "KeymapKey" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return\n    location for array of #GdkKeymapKey, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "keyvals"
--           , argType = TCArray False (-1) 4 (TBasicType TUInt)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return\n    location for array of keyvals, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_entries"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @keys and @keyvals"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_entries"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of @keys and @keyvals"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          , Arg
--              { argCName = "n_entries"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of @keys and @keyvals"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_entries_for_keycode" gdk_keymap_get_entries_for_keycode :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Word32 ->                               -- hardware_keycode : TBasicType TUInt
    Ptr (Ptr Gdk.KeymapKey.KeymapKey) ->    -- keys : TCArray False (-1) 4 (TInterface (Name {namespace = "Gdk", name = "KeymapKey"}))
    Ptr (Ptr Word32) ->                     -- keyvals : TCArray False (-1) 4 (TBasicType TUInt)
    Ptr Int32 ->                            -- n_entries : TBasicType TInt
    IO CInt

-- | Returns the keyvals bound to /@hardwareKeycode@/.
-- The Nth t'GI.Gdk.Structs.KeymapKey.KeymapKey' in /@keys@/ is bound to the Nth
-- keyval in /@keyvals@/. Free the returned arrays with 'GI.GLib.Functions.free'.
-- When a keycode is pressed by the user, the keyval from
-- this list of entries is selected by considering the effective
-- keyboard group and level. See 'GI.Gdk.Objects.Keymap.keymapTranslateKeyboardState'.
keymapGetEntriesForKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> Word32
    -- ^ /@hardwareKeycode@/: a keycode
    -> m ((Bool, [Gdk.KeymapKey.KeymapKey], [Word32]))
    -- ^ __Returns:__ 'P.True' if there were any entries
keymapGetEntriesForKeycode keymap hardwareKeycode = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    keys <- callocMem :: IO (Ptr (Ptr Gdk.KeymapKey.KeymapKey))
    keyvals <- callocMem :: IO (Ptr (Ptr Word32))
    nEntries <- allocMem :: IO (Ptr Int32)
    result <- gdk_keymap_get_entries_for_keycode keymap' hardwareKeycode keys keyvals nEntries
    nEntries' <- peek nEntries
    let result' = (/= 0) result
    keys' <- peek keys
    keys'' <- (unpackBlockArrayWithLength 12 nEntries') keys'
    keys''' <- mapM (wrapPtr Gdk.KeymapKey.KeymapKey) keys''
    freeMem keys'
    keyvals' <- peek keyvals
    keyvals'' <- (unpackStorableArrayWithLength nEntries') keyvals'
    freeMem keyvals'
    touchManagedPtr keymap
    freeMem keys
    freeMem keyvals
    freeMem nEntries
    return (result', keys''', keyvals'')

#if defined(ENABLE_OVERLOADING)
data KeymapGetEntriesForKeycodeMethodInfo
instance (signature ~ (Word32 -> m ((Bool, [Gdk.KeymapKey.KeymapKey], [Word32]))), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetEntriesForKeycodeMethodInfo a signature where
    overloadedMethod = keymapGetEntriesForKeycode

instance O.OverloadedMethodInfo KeymapGetEntriesForKeycodeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetEntriesForKeycode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetEntriesForKeycode"
        })


#endif

-- method Keymap::get_entries_for_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a keyval, such as %GDK_KEY_a, %GDK_KEY_Up, %GDK_KEY_Return, etc."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keys"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 3
--                 (TInterface Name { namespace = "Gdk" , name = "KeymapKey" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location\n    for an array of #GdkKeymapKey"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_keys"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for number of elements in returned array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_keys"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "return location for number of elements in returned array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_entries_for_keyval" gdk_keymap_get_entries_for_keyval :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Word32 ->                               -- keyval : TBasicType TUInt
    Ptr (Ptr Gdk.KeymapKey.KeymapKey) ->    -- keys : TCArray False (-1) 3 (TInterface (Name {namespace = "Gdk", name = "KeymapKey"}))
    Ptr Int32 ->                            -- n_keys : TBasicType TInt
    IO CInt

-- | Obtains a list of keycode\/group\/level combinations that will
-- generate /@keyval@/. Groups and levels are two kinds of keyboard mode;
-- in general, the level determines whether the top or bottom symbol
-- on a key is used, and the group determines whether the left or
-- right symbol is used. On US keyboards, the shift key changes the
-- keyboard level, and there are no groups. A group switch key might
-- convert a keyboard between Hebrew to English modes, for example.
-- t'GI.Gdk.Structs.EventKey.EventKey' contains a @/group/@ field that indicates the active
-- keyboard group. The level is computed from the modifier mask.
-- The returned array should be freed
-- with 'GI.GLib.Functions.free'.
keymapGetEntriesForKeyval ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> Word32
    -- ^ /@keyval@/: a keyval, such as 'GI.Gdk.Constants.KEY_a', 'GI.Gdk.Constants.KEY_Up', 'GI.Gdk.Constants.KEY_Return', etc.
    -> m ((Bool, [Gdk.KeymapKey.KeymapKey]))
    -- ^ __Returns:__ 'P.True' if keys were found and returned
keymapGetEntriesForKeyval keymap keyval = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    keys <- callocMem :: IO (Ptr (Ptr Gdk.KeymapKey.KeymapKey))
    nKeys <- allocMem :: IO (Ptr Int32)
    result <- gdk_keymap_get_entries_for_keyval keymap' keyval keys nKeys
    nKeys' <- peek nKeys
    let result' = (/= 0) result
    keys' <- peek keys
    keys'' <- (unpackBlockArrayWithLength 12 nKeys') keys'
    keys''' <- mapM (wrapPtr Gdk.KeymapKey.KeymapKey) keys''
    freeMem keys'
    touchManagedPtr keymap
    freeMem keys
    freeMem nKeys
    return (result', keys''')

#if defined(ENABLE_OVERLOADING)
data KeymapGetEntriesForKeyvalMethodInfo
instance (signature ~ (Word32 -> m ((Bool, [Gdk.KeymapKey.KeymapKey]))), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetEntriesForKeyvalMethodInfo a signature where
    overloadedMethod = keymapGetEntriesForKeyval

instance O.OverloadedMethodInfo KeymapGetEntriesForKeyvalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetEntriesForKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetEntriesForKeyval"
        })


#endif

-- method Keymap::get_modifier_mask
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "intent"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierIntent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the use case for the modifier mask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_modifier_mask" gdk_keymap_get_modifier_mask :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    CUInt ->                                -- intent : TInterface (Name {namespace = "Gdk", name = "ModifierIntent"})
    IO CUInt

-- | Returns the modifier mask the /@keymap@/’s windowing system backend
-- uses for a particular purpose.
-- 
-- Note that this function always returns real hardware modifiers, not
-- virtual ones (e.g. it will return @/GDK_MOD1_MASK/@ rather than
-- @/GDK_META_MASK/@ if the backend maps MOD1 to META), so there are use
-- cases where the return value of this function has to be transformed
-- by 'GI.Gdk.Objects.Keymap.keymapAddVirtualModifiers' in order to contain the
-- expected result.
-- 
-- /Since: 3.4/
keymapGetModifierMask ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> Gdk.Enums.ModifierIntent
    -- ^ /@intent@/: the use case for the modifier mask
    -> m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ the modifier mask used for /@intent@/.
keymapGetModifierMask keymap intent = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    let intent' = (fromIntegral . fromEnum) intent
    result <- gdk_keymap_get_modifier_mask keymap' intent'
    let result' = wordToGFlags result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapGetModifierMaskMethodInfo
instance (signature ~ (Gdk.Enums.ModifierIntent -> m [Gdk.Flags.ModifierType]), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetModifierMaskMethodInfo a signature where
    overloadedMethod = keymapGetModifierMask

instance O.OverloadedMethodInfo KeymapGetModifierMaskMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetModifierMask",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetModifierMask"
        })


#endif

-- method Keymap::get_modifier_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_modifier_state" gdk_keymap_get_modifier_state :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO Word32

-- | Returns the current modifier state.
-- 
-- /Since: 3.4/
keymapGetModifierState ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Word32
    -- ^ __Returns:__ the current modifier state.
keymapGetModifierState keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_get_modifier_state keymap'
    touchManagedPtr keymap
    return result

#if defined(ENABLE_OVERLOADING)
data KeymapGetModifierStateMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetModifierStateMethodInfo a signature where
    overloadedMethod = keymapGetModifierState

instance O.OverloadedMethodInfo KeymapGetModifierStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetModifierState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetModifierState"
        })


#endif

-- method Keymap::get_num_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_num_lock_state" gdk_keymap_get_num_lock_state :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO CInt

-- | Returns whether the Num Lock modifer is locked.
-- 
-- /Since: 3.0/
keymapGetNumLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Num Lock is on
keymapGetNumLockState keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_get_num_lock_state keymap'
    let result' = (/= 0) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapGetNumLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetNumLockStateMethodInfo a signature where
    overloadedMethod = keymapGetNumLockState

instance O.OverloadedMethodInfo KeymapGetNumLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetNumLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetNumLockState"
        })


#endif

-- method Keymap::get_scroll_lock_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_scroll_lock_state" gdk_keymap_get_scroll_lock_state :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO CInt

-- | Returns whether the Scroll Lock modifer is locked.
-- 
-- /Since: 3.18/
keymapGetScrollLockState ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if Scroll Lock is on
keymapGetScrollLockState keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_get_scroll_lock_state keymap'
    let result' = (/= 0) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapGetScrollLockStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapGetScrollLockStateMethodInfo a signature where
    overloadedMethod = keymapGetScrollLockState

instance O.OverloadedMethodInfo KeymapGetScrollLockStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapGetScrollLockState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapGetScrollLockState"
        })


#endif

-- method Keymap::have_bidi_layouts
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_have_bidi_layouts" gdk_keymap_have_bidi_layouts :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    IO CInt

-- | Determines if keyboard layouts for both right-to-left and left-to-right
-- languages are in use.
-- 
-- /Since: 2.12/
keymapHaveBidiLayouts ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there are layouts in both directions, 'P.False' otherwise
keymapHaveBidiLayouts keymap = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_keymap_have_bidi_layouts keymap'
    let result' = (/= 0) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data KeymapHaveBidiLayoutsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapHaveBidiLayoutsMethodInfo a signature where
    overloadedMethod = keymapHaveBidiLayouts

instance O.OverloadedMethodInfo KeymapHaveBidiLayoutsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapHaveBidiLayouts",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapHaveBidiLayouts"
        })


#endif

-- method Keymap::lookup_key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeymapKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkKeymapKey with keycode, group, and level initialized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_lookup_key" gdk_keymap_lookup_key :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Ptr Gdk.KeymapKey.KeymapKey ->          -- key : TInterface (Name {namespace = "Gdk", name = "KeymapKey"})
    IO Word32

-- | Looks up the keyval mapped to a keycode\/group\/level triplet.
-- If no keyval is bound to /@key@/, returns 0. For normal user input,
-- you want to use 'GI.Gdk.Objects.Keymap.keymapTranslateKeyboardState' instead of
-- this function, since the effective group\/level may not be
-- the same as the current keyboard state.
keymapLookupKey ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> Gdk.KeymapKey.KeymapKey
    -- ^ /@key@/: a t'GI.Gdk.Structs.KeymapKey.KeymapKey' with keycode, group, and level initialized
    -> m Word32
    -- ^ __Returns:__ a keyval, or 0 if none was mapped to the given /@key@/
keymapLookupKey keymap key = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    key' <- unsafeManagedPtrGetPtr key
    result <- gdk_keymap_lookup_key keymap' key'
    touchManagedPtr keymap
    touchManagedPtr key
    return result

#if defined(ENABLE_OVERLOADING)
data KeymapLookupKeyMethodInfo
instance (signature ~ (Gdk.KeymapKey.KeymapKey -> m Word32), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapLookupKeyMethodInfo a signature where
    overloadedMethod = keymapLookupKey

instance O.OverloadedMethodInfo KeymapLookupKeyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapLookupKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapLookupKey"
        })


#endif

-- method Keymap::map_virtual_modifiers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to the modifier state to map"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_map_virtual_modifiers" gdk_keymap_map_virtual_modifiers :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Ptr CUInt ->                            -- state : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Maps the virtual modifiers (i.e. Super, Hyper and Meta) which
-- are set in /@state@/ to their non-virtual counterparts (i.e. Mod2,
-- Mod3,...) and set the corresponding bits in /@state@/.
-- 
-- This function is useful when matching key events against
-- accelerators.
-- 
-- /Since: 2.20/
keymapMapVirtualModifiers ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: pointer to the modifier state to map
    -> m ((Bool, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.False' if two virtual modifiers were mapped to the
    --     same non-virtual modifier. Note that 'P.False' is also returned
    --     if a virtual modifier is mapped to a non-virtual modifier that
    --     was already set in /@state@/.
keymapMapVirtualModifiers keymap state = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    let state' = gflagsToWord state
    state'' <- allocMem :: IO (Ptr CUInt)
    poke state'' state'
    result <- gdk_keymap_map_virtual_modifiers keymap' state''
    let result' = (/= 0) result
    state''' <- peek state''
    let state'''' = wordToGFlags state'''
    touchManagedPtr keymap
    freeMem state''
    return (result', state'''')

#if defined(ENABLE_OVERLOADING)
data KeymapMapVirtualModifiersMethodInfo
instance (signature ~ ([Gdk.Flags.ModifierType] -> m ((Bool, [Gdk.Flags.ModifierType]))), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapMapVirtualModifiersMethodInfo a signature where
    overloadedMethod = keymapMapVirtualModifiers

instance O.OverloadedMethodInfo KeymapMapVirtualModifiersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapMapVirtualModifiers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapMapVirtualModifiers"
        })


#endif

-- method Keymap::translate_keyboard_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkKeymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hardware_keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keycode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a modifier state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "active keyboard group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for keyval, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "effective_group"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for effective\n    group, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "level"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for level, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "consumed_modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for modifiers\n    that were used to determine the group or level, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_translate_keyboard_state" gdk_keymap_translate_keyboard_state :: 
    Ptr Keymap ->                           -- keymap : TInterface (Name {namespace = "Gdk", name = "Keymap"})
    Word32 ->                               -- hardware_keycode : TBasicType TUInt
    CUInt ->                                -- state : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    Int32 ->                                -- group : TBasicType TInt
    Ptr Word32 ->                           -- keyval : TBasicType TUInt
    Ptr Int32 ->                            -- effective_group : TBasicType TInt
    Ptr Int32 ->                            -- level : TBasicType TInt
    Ptr CUInt ->                            -- consumed_modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Translates the contents of a t'GI.Gdk.Structs.EventKey.EventKey' into a keyval, effective
-- group, and level. Modifiers that affected the translation and
-- are thus unavailable for application use are returned in
-- /@consumedModifiers@/.
-- See [Groups][key-group-explanation] for an explanation of
-- groups and levels. The /@effectiveGroup@/ is the group that was
-- actually used for the translation; some keys such as Enter are not
-- affected by the active keyboard group. The /@level@/ is derived from
-- /@state@/. For convenience, t'GI.Gdk.Structs.EventKey.EventKey' already contains the translated
-- keyval, so this function isn’t as useful as you might think.
-- 
-- /@consumedModifiers@/ gives modifiers that should be masked outfrom /@state@/
-- when comparing this key press to a hot key. For instance, on a US keyboard,
-- the @plus@ symbol is shifted, so when comparing a key press to a
-- @\<Control>plus@ accelerator @\<Shift>@ should be masked out.
-- 
-- 
-- === /C code/
-- >
-- >// We want to ignore irrelevant modifiers like ScrollLock
-- >#define ALL_ACCELS_MASK (GDK_CONTROL_MASK | GDK_SHIFT_MASK | GDK_MOD1_MASK)
-- >gdk_keymap_translate_keyboard_state (keymap, event->hardware_keycode,
-- >                                     event->state, event->group,
-- >                                     &keyval, NULL, NULL, &consumed);
-- >if (keyval == GDK_PLUS &&
-- >    (event->state & ~consumed & ALL_ACCELS_MASK) == GDK_CONTROL_MASK)
-- >  // Control was pressed
-- 
-- 
-- An older interpretation /@consumedModifiers@/ was that it contained
-- all modifiers that might affect the translation of the key;
-- this allowed accelerators to be stored with irrelevant consumed
-- modifiers, by doing:
-- 
-- === /C code/
-- >
-- >// XXX Don’t do this XXX
-- >if (keyval == accel_keyval &&
-- >    (event->state & ~consumed & ALL_ACCELS_MASK) == (accel_mods & ~consumed))
-- >  // Accelerator was pressed
-- 
-- 
-- However, this did not work if multi-modifier combinations were
-- used in the keymap, since, for instance, @\<Control>@ would be
-- masked out even if only @\<Control>\<Alt>@ was used in the keymap.
-- To support this usage as well as well as possible, all single
-- modifier combinations that could affect the key for any combination
-- of modifiers will be returned in /@consumedModifiers@/; multi-modifier
-- combinations are returned only when actually found in /@state@/. When
-- you store accelerators, you should always store them with consumed
-- modifiers removed. Store @\<Control>plus@, not @\<Control>\<Shift>plus@,
keymapTranslateKeyboardState ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.Gdk.Objects.Keymap.Keymap'
    -> Word32
    -- ^ /@hardwareKeycode@/: a keycode
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: a modifier state
    -> Int32
    -- ^ /@group@/: active keyboard group
    -> m ((Bool, Word32, Int32, Int32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.True' if there was a keyval bound to the keycode\/state\/group
keymapTranslateKeyboardState keymap hardwareKeycode state group = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    let state' = gflagsToWord state
    keyval <- allocMem :: IO (Ptr Word32)
    effectiveGroup <- allocMem :: IO (Ptr Int32)
    level <- allocMem :: IO (Ptr Int32)
    consumedModifiers <- allocMem :: IO (Ptr CUInt)
    result <- gdk_keymap_translate_keyboard_state keymap' hardwareKeycode state' group keyval effectiveGroup level consumedModifiers
    let result' = (/= 0) result
    keyval' <- peek keyval
    effectiveGroup' <- peek effectiveGroup
    level' <- peek level
    consumedModifiers' <- peek consumedModifiers
    let consumedModifiers'' = wordToGFlags consumedModifiers'
    touchManagedPtr keymap
    freeMem keyval
    freeMem effectiveGroup
    freeMem level
    freeMem consumedModifiers
    return (result', keyval', effectiveGroup', level', consumedModifiers'')

#if defined(ENABLE_OVERLOADING)
data KeymapTranslateKeyboardStateMethodInfo
instance (signature ~ (Word32 -> [Gdk.Flags.ModifierType] -> Int32 -> m ((Bool, Word32, Int32, Int32, [Gdk.Flags.ModifierType]))), MonadIO m, IsKeymap a) => O.OverloadedMethod KeymapTranslateKeyboardStateMethodInfo a signature where
    overloadedMethod = keymapTranslateKeyboardState

instance O.OverloadedMethodInfo KeymapTranslateKeyboardStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Keymap.keymapTranslateKeyboardState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-Keymap.html#v:keymapTranslateKeyboardState"
        })


#endif

-- method Keymap::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Keymap" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_default" gdk_keymap_get_default :: 
    IO (Ptr Keymap)

{-# DEPRECATED keymapGetDefault ["(Since version 3.22)","Use 'GI.Gdk.Objects.Keymap.keymapGetForDisplay' instead"] #-}
-- | Returns the t'GI.Gdk.Objects.Keymap.Keymap' attached to the default display.
keymapGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Keymap
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Keymap.Keymap' attached to the default display.
keymapGetDefault  = liftIO $ do
    result <- gdk_keymap_get_default
    checkUnexpectedReturnNULL "keymapGetDefault" result
    result' <- (newObject Keymap) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Keymap::get_for_display
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkDisplay." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Keymap" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keymap_get_for_display" gdk_keymap_get_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Keymap)

-- | Returns the t'GI.Gdk.Objects.Keymap.Keymap' attached to /@display@/.
-- 
-- /Since: 2.2/
keymapGetForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display'.
    -> m Keymap
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Keymap.Keymap' attached to /@display@/.
keymapGetForDisplay display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_keymap_get_for_display display'
    checkUnexpectedReturnNULL "keymapGetForDisplay" result
    result' <- (newObject Keymap) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


