{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gdk.Objects.GLContext.GLContext' is an object representing the platform-specific
-- OpenGL drawing context.
-- 
-- @/GdkGLContexts/@ are created for a t'GI.Gdk.Objects.Window.Window' using
-- 'GI.Gdk.Objects.Window.windowCreateGlContext', and the context will match
-- the t'GI.Gdk.Objects.Visual.Visual' of the window.
-- 
-- A t'GI.Gdk.Objects.GLContext.GLContext' is not tied to any particular normal framebuffer.
-- For instance, it cannot draw to the t'GI.Gdk.Objects.Window.Window' back buffer. The GDK
-- repaint system is in full control of the painting to that. Instead,
-- you can create render buffers or textures and use 'GI.Gdk.Functions.cairoDrawFromGl'
-- in the draw function of your widget to draw them. Then GDK will handle
-- the integration of your rendering with that of other widgets.
-- 
-- Support for t'GI.Gdk.Objects.GLContext.GLContext' is platform-specific, context creation
-- can fail, returning 'P.Nothing' context.
-- 
-- A t'GI.Gdk.Objects.GLContext.GLContext' has to be made \"current\" in order to start using
-- it, otherwise any OpenGL call will be ignored.
-- 
-- == Creating a new OpenGL context 
-- 
-- In order to create a new t'GI.Gdk.Objects.GLContext.GLContext' instance you need a
-- t'GI.Gdk.Objects.Window.Window', which you typically get during the realize call
-- of a widget.
-- 
-- A t'GI.Gdk.Objects.GLContext.GLContext' is not realized until either 'GI.Gdk.Objects.GLContext.gLContextMakeCurrent',
-- or until it is realized using 'GI.Gdk.Objects.GLContext.gLContextRealize'. It is possible to
-- specify details of the GL context like the OpenGL version to be used, or
-- whether the GL context should have extra state validation enabled after
-- calling 'GI.Gdk.Objects.Window.windowCreateGlContext' by calling 'GI.Gdk.Objects.GLContext.gLContextRealize'.
-- If the realization fails you have the option to change the settings of the
-- t'GI.Gdk.Objects.GLContext.GLContext' and try again.
-- 
-- == Using a GdkGLContext 
-- 
-- You will need to make the t'GI.Gdk.Objects.GLContext.GLContext' the current context
-- before issuing OpenGL calls; the system sends OpenGL commands to
-- whichever context is current. It is possible to have multiple
-- contexts, so you always need to ensure that the one which you
-- want to draw with is the current one before issuing commands:
-- 
-- 
-- === /C code/
-- >
-- >  gdk_gl_context_make_current (context);
-- 
-- 
-- You can now perform your drawing using OpenGL commands.
-- 
-- You can check which t'GI.Gdk.Objects.GLContext.GLContext' is the current one by using
-- 'GI.Gdk.Objects.GLContext.gLContextGetCurrent'; you can also unset any t'GI.Gdk.Objects.GLContext.GLContext'
-- that is currently set by calling 'GI.Gdk.Objects.GLContext.gLContextClearCurrent'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.GLContext
    ( 

-- * Exported types
    GLContext(..)                           ,
    IsGLContext                             ,
    toGLContext                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isLegacy]("GI.Gdk.Objects.GLContext#g:method:isLegacy"), [makeCurrent]("GI.Gdk.Objects.GLContext#g:method:makeCurrent"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gdk.Objects.GLContext#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDebugEnabled]("GI.Gdk.Objects.GLContext#g:method:getDebugEnabled"), [getDisplay]("GI.Gdk.Objects.GLContext#g:method:getDisplay"), [getForwardCompatible]("GI.Gdk.Objects.GLContext#g:method:getForwardCompatible"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequiredVersion]("GI.Gdk.Objects.GLContext#g:method:getRequiredVersion"), [getSharedContext]("GI.Gdk.Objects.GLContext#g:method:getSharedContext"), [getUseEs]("GI.Gdk.Objects.GLContext#g:method:getUseEs"), [getVersion]("GI.Gdk.Objects.GLContext#g:method:getVersion"), [getWindow]("GI.Gdk.Objects.GLContext#g:method:getWindow").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDebugEnabled]("GI.Gdk.Objects.GLContext#g:method:setDebugEnabled"), [setForwardCompatible]("GI.Gdk.Objects.GLContext#g:method:setForwardCompatible"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRequiredVersion]("GI.Gdk.Objects.GLContext#g:method:setRequiredVersion"), [setUseEs]("GI.Gdk.Objects.GLContext#g:method:setUseEs").

#if defined(ENABLE_OVERLOADING)
    ResolveGLContextMethod                  ,
#endif

-- ** clearCurrent #method:clearCurrent#

    gLContextClearCurrent                   ,


-- ** getCurrent #method:getCurrent#

    gLContextGetCurrent                     ,


-- ** getDebugEnabled #method:getDebugEnabled#

#if defined(ENABLE_OVERLOADING)
    GLContextGetDebugEnabledMethodInfo      ,
#endif
    gLContextGetDebugEnabled                ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    GLContextGetDisplayMethodInfo           ,
#endif
    gLContextGetDisplay                     ,


-- ** getForwardCompatible #method:getForwardCompatible#

#if defined(ENABLE_OVERLOADING)
    GLContextGetForwardCompatibleMethodInfo ,
#endif
    gLContextGetForwardCompatible           ,


-- ** getRequiredVersion #method:getRequiredVersion#

#if defined(ENABLE_OVERLOADING)
    GLContextGetRequiredVersionMethodInfo   ,
#endif
    gLContextGetRequiredVersion             ,


-- ** getSharedContext #method:getSharedContext#

#if defined(ENABLE_OVERLOADING)
    GLContextGetSharedContextMethodInfo     ,
#endif
    gLContextGetSharedContext               ,


-- ** getUseEs #method:getUseEs#

#if defined(ENABLE_OVERLOADING)
    GLContextGetUseEsMethodInfo             ,
#endif
    gLContextGetUseEs                       ,


-- ** getVersion #method:getVersion#

#if defined(ENABLE_OVERLOADING)
    GLContextGetVersionMethodInfo           ,
#endif
    gLContextGetVersion                     ,


-- ** getWindow #method:getWindow#

#if defined(ENABLE_OVERLOADING)
    GLContextGetWindowMethodInfo            ,
#endif
    gLContextGetWindow                      ,


-- ** isLegacy #method:isLegacy#

#if defined(ENABLE_OVERLOADING)
    GLContextIsLegacyMethodInfo             ,
#endif
    gLContextIsLegacy                       ,


-- ** makeCurrent #method:makeCurrent#

#if defined(ENABLE_OVERLOADING)
    GLContextMakeCurrentMethodInfo          ,
#endif
    gLContextMakeCurrent                    ,


-- ** realize #method:realize#

#if defined(ENABLE_OVERLOADING)
    GLContextRealizeMethodInfo              ,
#endif
    gLContextRealize                        ,


-- ** setDebugEnabled #method:setDebugEnabled#

#if defined(ENABLE_OVERLOADING)
    GLContextSetDebugEnabledMethodInfo      ,
#endif
    gLContextSetDebugEnabled                ,


-- ** setForwardCompatible #method:setForwardCompatible#

#if defined(ENABLE_OVERLOADING)
    GLContextSetForwardCompatibleMethodInfo ,
#endif
    gLContextSetForwardCompatible           ,


-- ** setRequiredVersion #method:setRequiredVersion#

#if defined(ENABLE_OVERLOADING)
    GLContextSetRequiredVersionMethodInfo   ,
#endif
    gLContextSetRequiredVersion             ,


-- ** setUseEs #method:setUseEs#

#if defined(ENABLE_OVERLOADING)
    GLContextSetUseEsMethodInfo             ,
#endif
    gLContextSetUseEs                       ,




 -- * Properties


-- ** display #attr:display#
-- | The t'GI.Gdk.Objects.Display.Display' used to create the t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- /Since: 3.16/

#if defined(ENABLE_OVERLOADING)
    GLContextDisplayPropertyInfo            ,
#endif
    constructGLContextDisplay               ,
#if defined(ENABLE_OVERLOADING)
    gLContextDisplay                        ,
#endif
    getGLContextDisplay                     ,


-- ** sharedContext #attr:sharedContext#
-- | The t'GI.Gdk.Objects.GLContext.GLContext' that this context is sharing data with, or 'P.Nothing'
-- 
-- /Since: 3.16/

#if defined(ENABLE_OVERLOADING)
    GLContextSharedContextPropertyInfo      ,
#endif
    constructGLContextSharedContext         ,
#if defined(ENABLE_OVERLOADING)
    gLContextSharedContext                  ,
#endif
    getGLContextSharedContext               ,


-- ** window #attr:window#
-- | The t'GI.Gdk.Objects.Window.Window' the gl context is bound to.
-- 
-- /Since: 3.16/

#if defined(ENABLE_OVERLOADING)
    GLContextWindowPropertyInfo             ,
#endif
    constructGLContextWindow                ,
#if defined(ENABLE_OVERLOADING)
    gLContextWindow                         ,
#endif
    getGLContextWindow                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype GLContext = GLContext (SP.ManagedPtr GLContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype GLContext where
    toManagedPtr (GLContext p) = p

foreign import ccall "gdk_gl_context_get_type"
    c_gdk_gl_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject GLContext where
    glibType = c_gdk_gl_context_get_type

instance B.Types.GObject GLContext

-- | Type class for types which can be safely cast to `GLContext`, for instance with `toGLContext`.
class (SP.GObject o, O.IsDescendantOf GLContext o) => IsGLContext o
instance (SP.GObject o, O.IsDescendantOf GLContext o) => IsGLContext o

instance O.HasParentTypes GLContext
type instance O.ParentTypes GLContext = '[GObject.Object.Object]

-- | Cast to `GLContext`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGLContext :: (MIO.MonadIO m, IsGLContext o) => o -> m GLContext
toGLContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo GLContext

-- | Convert 'GLContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GLContext) where
    gvalueGType_ = c_gdk_gl_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GLContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GLContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GLContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGLContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGLContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGLContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGLContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGLContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGLContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGLContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGLContextMethod "isLegacy" o = GLContextIsLegacyMethodInfo
    ResolveGLContextMethod "makeCurrent" o = GLContextMakeCurrentMethodInfo
    ResolveGLContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGLContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGLContextMethod "realize" o = GLContextRealizeMethodInfo
    ResolveGLContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGLContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGLContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGLContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGLContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGLContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGLContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGLContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGLContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGLContextMethod "getDebugEnabled" o = GLContextGetDebugEnabledMethodInfo
    ResolveGLContextMethod "getDisplay" o = GLContextGetDisplayMethodInfo
    ResolveGLContextMethod "getForwardCompatible" o = GLContextGetForwardCompatibleMethodInfo
    ResolveGLContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGLContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGLContextMethod "getRequiredVersion" o = GLContextGetRequiredVersionMethodInfo
    ResolveGLContextMethod "getSharedContext" o = GLContextGetSharedContextMethodInfo
    ResolveGLContextMethod "getUseEs" o = GLContextGetUseEsMethodInfo
    ResolveGLContextMethod "getVersion" o = GLContextGetVersionMethodInfo
    ResolveGLContextMethod "getWindow" o = GLContextGetWindowMethodInfo
    ResolveGLContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGLContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGLContextMethod "setDebugEnabled" o = GLContextSetDebugEnabledMethodInfo
    ResolveGLContextMethod "setForwardCompatible" o = GLContextSetForwardCompatibleMethodInfo
    ResolveGLContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGLContextMethod "setRequiredVersion" o = GLContextSetRequiredVersionMethodInfo
    ResolveGLContextMethod "setUseEs" o = GLContextSetUseEsMethodInfo
    ResolveGLContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGLContextMethod t GLContext, O.OverloadedMethod info GLContext p) => OL.IsLabel t (GLContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGLContextMethod t GLContext, O.OverloadedMethod info GLContext p, R.HasField t GLContext p) => R.HasField t GLContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGLContextMethod t GLContext, O.OverloadedMethodInfo info GLContext) => OL.IsLabel t (O.MethodProxy info GLContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLContext #display
-- @
getGLContextDisplay :: (MonadIO m, IsGLContext o) => o -> m (Maybe Gdk.Display.Display)
getGLContextDisplay obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a `GValueConstruct` with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLContextDisplay :: (IsGLContext o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructGLContextDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data GLContextDisplayPropertyInfo
instance AttrInfo GLContextDisplayPropertyInfo where
    type AttrAllowedOps GLContextDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLContextDisplayPropertyInfo = IsGLContext
    type AttrSetTypeConstraint GLContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint GLContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType GLContextDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType GLContextDisplayPropertyInfo = (Maybe Gdk.Display.Display)
    type AttrLabel GLContextDisplayPropertyInfo = "display"
    type AttrOrigin GLContextDisplayPropertyInfo = GLContext
    attrGet = getGLContextDisplay
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructGLContextDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#g:attr:display"
        })
#endif

-- VVV Prop "shared-context"
   -- Type: TInterface (Name {namespace = "Gdk", name = "GLContext"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@shared-context@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLContext #sharedContext
-- @
getGLContextSharedContext :: (MonadIO m, IsGLContext o) => o -> m (Maybe GLContext)
getGLContextSharedContext obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "shared-context" GLContext

-- | Construct a `GValueConstruct` with valid value for the “@shared-context@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLContextSharedContext :: (IsGLContext o, MIO.MonadIO m, IsGLContext a) => a -> m (GValueConstruct o)
constructGLContextSharedContext val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "shared-context" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data GLContextSharedContextPropertyInfo
instance AttrInfo GLContextSharedContextPropertyInfo where
    type AttrAllowedOps GLContextSharedContextPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLContextSharedContextPropertyInfo = IsGLContext
    type AttrSetTypeConstraint GLContextSharedContextPropertyInfo = IsGLContext
    type AttrTransferTypeConstraint GLContextSharedContextPropertyInfo = IsGLContext
    type AttrTransferType GLContextSharedContextPropertyInfo = GLContext
    type AttrGetType GLContextSharedContextPropertyInfo = (Maybe GLContext)
    type AttrLabel GLContextSharedContextPropertyInfo = "shared-context"
    type AttrOrigin GLContextSharedContextPropertyInfo = GLContext
    attrGet = getGLContextSharedContext
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo GLContext v
    attrConstruct = constructGLContextSharedContext
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.sharedContext"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#g:attr:sharedContext"
        })
#endif

-- VVV Prop "window"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Window"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@window@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gLContext #window
-- @
getGLContextWindow :: (MonadIO m, IsGLContext o) => o -> m (Maybe Gdk.Window.Window)
getGLContextWindow obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "window" Gdk.Window.Window

-- | Construct a `GValueConstruct` with valid value for the “@window@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGLContextWindow :: (IsGLContext o, MIO.MonadIO m, Gdk.Window.IsWindow a) => a -> m (GValueConstruct o)
constructGLContextWindow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "window" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data GLContextWindowPropertyInfo
instance AttrInfo GLContextWindowPropertyInfo where
    type AttrAllowedOps GLContextWindowPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint GLContextWindowPropertyInfo = IsGLContext
    type AttrSetTypeConstraint GLContextWindowPropertyInfo = Gdk.Window.IsWindow
    type AttrTransferTypeConstraint GLContextWindowPropertyInfo = Gdk.Window.IsWindow
    type AttrTransferType GLContextWindowPropertyInfo = Gdk.Window.Window
    type AttrGetType GLContextWindowPropertyInfo = (Maybe Gdk.Window.Window)
    type AttrLabel GLContextWindowPropertyInfo = "window"
    type AttrOrigin GLContextWindowPropertyInfo = GLContext
    attrGet = getGLContextWindow
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Window.Window v
    attrConstruct = constructGLContextWindow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#g:attr:window"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GLContext
type instance O.AttributeList GLContext = GLContextAttributeList
type GLContextAttributeList = ('[ '("display", GLContextDisplayPropertyInfo), '("sharedContext", GLContextSharedContextPropertyInfo), '("window", GLContextWindowPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gLContextDisplay :: AttrLabelProxy "display"
gLContextDisplay = AttrLabelProxy

gLContextSharedContext :: AttrLabelProxy "sharedContext"
gLContextSharedContext = AttrLabelProxy

gLContextWindow :: AttrLabelProxy "window"
gLContextWindow = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GLContext = GLContextSignalList
type GLContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GLContext::get_debug_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_debug_enabled" gdk_gl_context_get_debug_enabled :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO CInt

-- | Retrieves the value set using 'GI.Gdk.Objects.GLContext.gLContextSetDebugEnabled'.
-- 
-- /Since: 3.16/
gLContextGetDebugEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if debugging is enabled
gLContextGetDebugEnabled context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_debug_enabled context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data GLContextGetDebugEnabledMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetDebugEnabledMethodInfo a signature where
    overloadedMethod = gLContextGetDebugEnabled

instance O.OverloadedMethodInfo GLContextGetDebugEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetDebugEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetDebugEnabled"
        })


#endif

-- method GLContext::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_display" gdk_gl_context_get_display :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO (Ptr Gdk.Display.Display)

-- | Retrieves the t'GI.Gdk.Objects.Display.Display' the /@context@/ is created for
-- 
-- /Since: 3.16/
gLContextGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display' or 'P.Nothing'
gLContextGetDisplay context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_display context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Display.Display) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLContextGetDisplayMethodInfo
instance (signature ~ (m (Maybe Gdk.Display.Display)), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetDisplayMethodInfo a signature where
    overloadedMethod = gLContextGetDisplay

instance O.OverloadedMethodInfo GLContextGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetDisplay"
        })


#endif

-- method GLContext::get_forward_compatible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_forward_compatible" gdk_gl_context_get_forward_compatible :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO CInt

-- | Retrieves the value set using 'GI.Gdk.Objects.GLContext.gLContextSetForwardCompatible'.
-- 
-- /Since: 3.16/
gLContextGetForwardCompatible ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the context should be forward compatible
gLContextGetForwardCompatible context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_forward_compatible context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data GLContextGetForwardCompatibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetForwardCompatibleMethodInfo a signature where
    overloadedMethod = gLContextGetForwardCompatible

instance O.OverloadedMethodInfo GLContextGetForwardCompatibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetForwardCompatible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetForwardCompatible"
        })


#endif

-- method GLContext::get_required_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "major"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the major version to request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minor"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the minor version to request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_required_version" gdk_gl_context_get_required_version :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Ptr Int32 ->                            -- major : TBasicType TInt
    Ptr Int32 ->                            -- minor : TBasicType TInt
    IO ()

-- | Retrieves the major and minor version requested by calling
-- 'GI.Gdk.Objects.GLContext.gLContextSetRequiredVersion'.
-- 
-- /Since: 3.16/
gLContextGetRequiredVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m ((Int32, Int32))
gLContextGetRequiredVersion context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    major <- allocMem :: IO (Ptr Int32)
    minor <- allocMem :: IO (Ptr Int32)
    gdk_gl_context_get_required_version context' major minor
    major' <- peek major
    minor' <- peek minor
    touchManagedPtr context
    freeMem major
    freeMem minor
    return (major', minor')

#if defined(ENABLE_OVERLOADING)
data GLContextGetRequiredVersionMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetRequiredVersionMethodInfo a signature where
    overloadedMethod = gLContextGetRequiredVersion

instance O.OverloadedMethodInfo GLContextGetRequiredVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetRequiredVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetRequiredVersion"
        })


#endif

-- method GLContext::get_shared_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_shared_context" gdk_gl_context_get_shared_context :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO (Ptr GLContext)

-- | Retrieves the t'GI.Gdk.Objects.GLContext.GLContext' that this /@context@/ share data with.
-- 
-- /Since: 3.16/
gLContextGetSharedContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m (Maybe GLContext)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.GLContext.GLContext' or 'P.Nothing'
gLContextGetSharedContext context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_shared_context context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GLContext) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLContextGetSharedContextMethodInfo
instance (signature ~ (m (Maybe GLContext)), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetSharedContextMethodInfo a signature where
    overloadedMethod = gLContextGetSharedContext

instance O.OverloadedMethodInfo GLContextGetSharedContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetSharedContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetSharedContext"
        })


#endif

-- method GLContext::get_use_es
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_use_es" gdk_gl_context_get_use_es :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO CInt

-- | Checks whether the /@context@/ is using an OpenGL or OpenGL ES profile.
-- 
-- /Since: 3.22/
gLContextGetUseEs ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the t'GI.Gdk.Objects.GLContext.GLContext' is using an OpenGL ES profile
gLContextGetUseEs context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_use_es context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data GLContextGetUseEsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetUseEsMethodInfo a signature where
    overloadedMethod = gLContextGetUseEs

instance O.OverloadedMethodInfo GLContextGetUseEsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetUseEs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetUseEs"
        })


#endif

-- method GLContext::get_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "major"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the major version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "minor"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the minor version"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_version" gdk_gl_context_get_version :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Ptr Int32 ->                            -- major : TBasicType TInt
    Ptr Int32 ->                            -- minor : TBasicType TInt
    IO ()

-- | Retrieves the OpenGL version of the /@context@/.
-- 
-- The /@context@/ must be realized prior to calling this function.
-- 
-- /Since: 3.16/
gLContextGetVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m ((Int32, Int32))
gLContextGetVersion context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    major <- allocMem :: IO (Ptr Int32)
    minor <- allocMem :: IO (Ptr Int32)
    gdk_gl_context_get_version context' major minor
    major' <- peek major
    minor' <- peek minor
    touchManagedPtr context
    freeMem major
    freeMem minor
    return (major', minor')

#if defined(ENABLE_OVERLOADING)
data GLContextGetVersionMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetVersionMethodInfo a signature where
    overloadedMethod = gLContextGetVersion

instance O.OverloadedMethodInfo GLContextGetVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetVersion"
        })


#endif

-- method GLContext::get_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_window" gdk_gl_context_get_window :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO (Ptr Gdk.Window.Window)

-- | Retrieves the t'GI.Gdk.Objects.Window.Window' used by the /@context@/.
-- 
-- /Since: 3.16/
gLContextGetWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Window.Window' or 'P.Nothing'
gLContextGetWindow context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_get_window context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data GLContextGetWindowMethodInfo
instance (signature ~ (m (Maybe Gdk.Window.Window)), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextGetWindowMethodInfo a signature where
    overloadedMethod = gLContextGetWindow

instance O.OverloadedMethodInfo GLContextGetWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextGetWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextGetWindow"
        })


#endif

-- method GLContext::is_legacy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_is_legacy" gdk_gl_context_is_legacy :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO CInt

-- | Whether the t'GI.Gdk.Objects.GLContext.GLContext' is in legacy mode or not.
-- 
-- The t'GI.Gdk.Objects.GLContext.GLContext' must be realized before calling this function.
-- 
-- When realizing a GL context, GDK will try to use the OpenGL 3.2 core
-- profile; this profile removes all the OpenGL API that was deprecated
-- prior to the 3.2 version of the specification. If the realization is
-- successful, this function will return 'P.False'.
-- 
-- If the underlying OpenGL implementation does not support core profiles,
-- GDK will fall back to a pre-3.2 compatibility profile, and this function
-- will return 'P.True'.
-- 
-- You can use the value returned by this function to decide which kind
-- of OpenGL API to use, or whether to do extension discovery, or what
-- kind of shader programs to load.
-- 
-- /Since: 3.20/
gLContextIsLegacy ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the GL context is in legacy mode
gLContextIsLegacy context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_gl_context_is_legacy context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data GLContextIsLegacyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextIsLegacyMethodInfo a signature where
    overloadedMethod = gLContextIsLegacy

instance O.OverloadedMethodInfo GLContextIsLegacyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextIsLegacy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextIsLegacy"
        })


#endif

-- method GLContext::make_current
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_make_current" gdk_gl_context_make_current :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    IO ()

-- | Makes the /@context@/ the current one.
-- 
-- /Since: 3.16/
gLContextMakeCurrent ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m ()
gLContextMakeCurrent context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_gl_context_make_current context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data GLContextMakeCurrentMethodInfo
instance (signature ~ (m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextMakeCurrentMethodInfo a signature where
    overloadedMethod = gLContextMakeCurrent

instance O.OverloadedMethodInfo GLContextMakeCurrentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextMakeCurrent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextMakeCurrent"
        })


#endif

-- method GLContext::realize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_gl_context_realize" gdk_gl_context_realize :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Realizes the given t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- It is safe to call this function on a realized t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- /Since: 3.16/
gLContextRealize ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
gLContextRealize context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    onException (do
        _ <- propagateGError $ gdk_gl_context_realize context'
        touchManagedPtr context
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data GLContextRealizeMethodInfo
instance (signature ~ (m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextRealizeMethodInfo a signature where
    overloadedMethod = gLContextRealize

instance O.OverloadedMethodInfo GLContextRealizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextRealize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextRealize"
        })


#endif

-- method GLContext::set_debug_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable debugging in the context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_set_debug_enabled" gdk_gl_context_set_debug_enabled :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()

-- | Sets whether the t'GI.Gdk.Objects.GLContext.GLContext' should perform extra validations and
-- run time checking. This is useful during development, but has
-- additional overhead.
-- 
-- The t'GI.Gdk.Objects.GLContext.GLContext' must not be realized or made current prior to
-- calling this function.
-- 
-- /Since: 3.16/
gLContextSetDebugEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> Bool
    -- ^ /@enabled@/: whether to enable debugging in the context
    -> m ()
gLContextSetDebugEnabled context enabled = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let enabled' = (P.fromIntegral . P.fromEnum) enabled
    gdk_gl_context_set_debug_enabled context' enabled'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data GLContextSetDebugEnabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextSetDebugEnabledMethodInfo a signature where
    overloadedMethod = gLContextSetDebugEnabled

instance O.OverloadedMethodInfo GLContextSetDebugEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextSetDebugEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextSetDebugEnabled"
        })


#endif

-- method GLContext::set_forward_compatible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "compatible"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the context should be forward compatible"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_set_forward_compatible" gdk_gl_context_set_forward_compatible :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    CInt ->                                 -- compatible : TBasicType TBoolean
    IO ()

-- | Sets whether the t'GI.Gdk.Objects.GLContext.GLContext' should be forward compatible.
-- 
-- Forward compatibile contexts must not support OpenGL functionality that
-- has been marked as deprecated in the requested version; non-forward
-- compatible contexts, on the other hand, must support both deprecated and
-- non deprecated functionality.
-- 
-- The t'GI.Gdk.Objects.GLContext.GLContext' must not be realized or made current prior to calling
-- this function.
-- 
-- /Since: 3.16/
gLContextSetForwardCompatible ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> Bool
    -- ^ /@compatible@/: whether the context should be forward compatible
    -> m ()
gLContextSetForwardCompatible context compatible = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let compatible' = (P.fromIntegral . P.fromEnum) compatible
    gdk_gl_context_set_forward_compatible context' compatible'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data GLContextSetForwardCompatibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextSetForwardCompatibleMethodInfo a signature where
    overloadedMethod = gLContextSetForwardCompatible

instance O.OverloadedMethodInfo GLContextSetForwardCompatibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextSetForwardCompatible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextSetForwardCompatible"
        })


#endif

-- method GLContext::set_required_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "major"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the major version to request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "minor"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minor version to request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_set_required_version" gdk_gl_context_set_required_version :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Int32 ->                                -- major : TBasicType TInt
    Int32 ->                                -- minor : TBasicType TInt
    IO ()

-- | Sets the major and minor version of OpenGL to request.
-- 
-- Setting /@major@/ and /@minor@/ to zero will use the default values.
-- 
-- The t'GI.Gdk.Objects.GLContext.GLContext' must not be realized or made current prior to calling
-- this function.
-- 
-- /Since: 3.16/
gLContextSetRequiredVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext'
    -> Int32
    -- ^ /@major@/: the major version to request
    -> Int32
    -- ^ /@minor@/: the minor version to request
    -> m ()
gLContextSetRequiredVersion context major minor = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_gl_context_set_required_version context' major minor
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data GLContextSetRequiredVersionMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextSetRequiredVersionMethodInfo a signature where
    overloadedMethod = gLContextSetRequiredVersion

instance O.OverloadedMethodInfo GLContextSetRequiredVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextSetRequiredVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextSetRequiredVersion"
        })


#endif

-- method GLContext::set_use_es
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GLContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkGLContext:" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_es"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether the context should use OpenGL ES instead of OpenGL,\n  or -1 to allow auto-detection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_set_use_es" gdk_gl_context_set_use_es :: 
    Ptr GLContext ->                        -- context : TInterface (Name {namespace = "Gdk", name = "GLContext"})
    Int32 ->                                -- use_es : TBasicType TInt
    IO ()

-- | Requests that GDK create a OpenGL ES context instead of an OpenGL one,
-- if the platform and windowing system allows it.
-- 
-- The /@context@/ must not have been realized.
-- 
-- By default, GDK will attempt to automatically detect whether the
-- underlying GL implementation is OpenGL or OpenGL ES once the /@context@/
-- is realized.
-- 
-- You should check the return value of 'GI.Gdk.Objects.GLContext.gLContextGetUseEs' after
-- calling 'GI.Gdk.Objects.GLContext.gLContextRealize' to decide whether to use the OpenGL or
-- OpenGL ES API, extensions, or shaders.
-- 
-- /Since: 3.22/
gLContextSetUseEs ::
    (B.CallStack.HasCallStack, MonadIO m, IsGLContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.GLContext.GLContext':
    -> Int32
    -- ^ /@useEs@/: whether the context should use OpenGL ES instead of OpenGL,
    --   or -1 to allow auto-detection
    -> m ()
gLContextSetUseEs context useEs = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_gl_context_set_use_es context' useEs
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data GLContextSetUseEsMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGLContext a) => O.OverloadedMethod GLContextSetUseEsMethodInfo a signature where
    overloadedMethod = gLContextSetUseEs

instance O.OverloadedMethodInfo GLContextSetUseEsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.GLContext.gLContextSetUseEs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-GLContext.html#v:gLContextSetUseEs"
        })


#endif

-- method GLContext::clear_current
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_clear_current" gdk_gl_context_clear_current :: 
    IO ()

-- | Clears the current t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- Any OpenGL call after this function returns will be ignored
-- until 'GI.Gdk.Objects.GLContext.gLContextMakeCurrent' is called.
-- 
-- /Since: 3.16/
gLContextClearCurrent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
gLContextClearCurrent  = liftIO $ do
    gdk_gl_context_clear_current
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method GLContext::get_current
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_gl_context_get_current" gdk_gl_context_get_current :: 
    IO (Ptr GLContext)

-- | Retrieves the current t'GI.Gdk.Objects.GLContext.GLContext'.
-- 
-- /Since: 3.16/
gLContextGetCurrent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe GLContext)
    -- ^ __Returns:__ the current t'GI.Gdk.Objects.GLContext.GLContext', or 'P.Nothing'
gLContextGetCurrent  = liftIO $ do
    result <- gdk_gl_context_get_current
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GLContext) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


