

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Functions
    ( 

 -- * Methods


-- ** addOptionEntriesLibgtkOnly #method:addOptionEntriesLibgtkOnly#

    addOptionEntriesLibgtkOnly              ,


-- ** beep #method:beep#

    beep                                    ,


-- ** cairoCreate #method:cairoCreate#

    cairoCreate                             ,


-- ** cairoDrawFromGl #method:cairoDrawFromGl#

    cairoDrawFromGl                         ,


-- ** cairoGetClipRectangle #method:cairoGetClipRectangle#

    cairoGetClipRectangle                   ,


-- ** cairoGetDrawingContext #method:cairoGetDrawingContext#

    cairoGetDrawingContext                  ,


-- ** cairoRectangle #method:cairoRectangle#

    cairoRectangle                          ,


-- ** cairoRegion #method:cairoRegion#

    cairoRegion                             ,


-- ** cairoRegionCreateFromSurface #method:cairoRegionCreateFromSurface#

    cairoRegionCreateFromSurface            ,


-- ** cairoSetSourceColor #method:cairoSetSourceColor#

    cairoSetSourceColor                     ,


-- ** cairoSetSourcePixbuf #method:cairoSetSourcePixbuf#

    cairoSetSourcePixbuf                    ,


-- ** cairoSetSourceRgba #method:cairoSetSourceRgba#

    cairoSetSourceRgba                      ,


-- ** cairoSetSourceWindow #method:cairoSetSourceWindow#

    cairoSetSourceWindow                    ,


-- ** cairoSurfaceCreateFromPixbuf #method:cairoSurfaceCreateFromPixbuf#

    cairoSurfaceCreateFromPixbuf            ,


-- ** disableMultidevice #method:disableMultidevice#

    disableMultidevice                      ,


-- ** dragAbort #method:dragAbort#

    dragAbort                               ,


-- ** dragBegin #method:dragBegin#

    dragBegin                               ,


-- ** dragBeginForDevice #method:dragBeginForDevice#

    dragBeginForDevice                      ,


-- ** dragBeginFromPoint #method:dragBeginFromPoint#

    dragBeginFromPoint                      ,


-- ** dragDrop #method:dragDrop#

    dragDrop                                ,


-- ** dragDropDone #method:dragDropDone#

    dragDropDone                            ,


-- ** dragDropSucceeded #method:dragDropSucceeded#

    dragDropSucceeded                       ,


-- ** dragFindWindowForScreen #method:dragFindWindowForScreen#

    dragFindWindowForScreen                 ,


-- ** dragGetSelection #method:dragGetSelection#

    dragGetSelection                        ,


-- ** dragMotion #method:dragMotion#

    dragMotion                              ,


-- ** dragStatus #method:dragStatus#

    dragStatus                              ,


-- ** dropFinish #method:dropFinish#

    dropFinish                              ,


-- ** dropReply #method:dropReply#

    dropReply                               ,


-- ** errorTrapPop #method:errorTrapPop#

    errorTrapPop                            ,


-- ** errorTrapPopIgnored #method:errorTrapPopIgnored#

    errorTrapPopIgnored                     ,


-- ** errorTrapPush #method:errorTrapPush#

    errorTrapPush                           ,


-- ** eventsGetAngle #method:eventsGetAngle#

    eventsGetAngle                          ,


-- ** eventsGetCenter #method:eventsGetCenter#

    eventsGetCenter                         ,


-- ** eventsGetDistance #method:eventsGetDistance#

    eventsGetDistance                       ,


-- ** eventsPending #method:eventsPending#

    eventsPending                           ,


-- ** flush #method:flush#

    flush                                   ,


-- ** getDefaultRootWindow #method:getDefaultRootWindow#

    getDefaultRootWindow                    ,


-- ** getDisplay #method:getDisplay#

    getDisplay                              ,


-- ** getDisplayArgName #method:getDisplayArgName#

    getDisplayArgName                       ,


-- ** getProgramClass #method:getProgramClass#

    getProgramClass                         ,


-- ** getShowEvents #method:getShowEvents#

    getShowEvents                           ,


-- ** init #method:init#

    init                                    ,


-- ** initCheck #method:initCheck#

    initCheck                               ,


-- ** keyboardGrab #method:keyboardGrab#

    keyboardGrab                            ,


-- ** keyboardUngrab #method:keyboardUngrab#

    keyboardUngrab                          ,


-- ** keyvalConvertCase #method:keyvalConvertCase#

    keyvalConvertCase                       ,


-- ** keyvalFromName #method:keyvalFromName#

    keyvalFromName                          ,


-- ** keyvalIsLower #method:keyvalIsLower#

    keyvalIsLower                           ,


-- ** keyvalIsUpper #method:keyvalIsUpper#

    keyvalIsUpper                           ,


-- ** keyvalName #method:keyvalName#

    keyvalName                              ,


-- ** keyvalToLower #method:keyvalToLower#

    keyvalToLower                           ,


-- ** keyvalToUnicode #method:keyvalToUnicode#

    keyvalToUnicode                         ,


-- ** keyvalToUpper #method:keyvalToUpper#

    keyvalToUpper                           ,


-- ** listVisuals #method:listVisuals#

    listVisuals                             ,


-- ** notifyStartupComplete #method:notifyStartupComplete#

    notifyStartupComplete                   ,


-- ** notifyStartupCompleteWithId #method:notifyStartupCompleteWithId#

    notifyStartupCompleteWithId             ,


-- ** offscreenWindowGetEmbedder #method:offscreenWindowGetEmbedder#

    offscreenWindowGetEmbedder              ,


-- ** offscreenWindowGetSurface #method:offscreenWindowGetSurface#

    offscreenWindowGetSurface               ,


-- ** offscreenWindowSetEmbedder #method:offscreenWindowSetEmbedder#

    offscreenWindowSetEmbedder              ,


-- ** pangoContextGet #method:pangoContextGet#

    pangoContextGet                         ,


-- ** pangoContextGetForDisplay #method:pangoContextGetForDisplay#

    pangoContextGetForDisplay               ,


-- ** pangoContextGetForScreen #method:pangoContextGetForScreen#

    pangoContextGetForScreen                ,


-- ** parseArgs #method:parseArgs#

    parseArgs                               ,


-- ** pixbufGetFromSurface #method:pixbufGetFromSurface#

    pixbufGetFromSurface                    ,


-- ** pixbufGetFromWindow #method:pixbufGetFromWindow#

    pixbufGetFromWindow                     ,


-- ** pointerGrab #method:pointerGrab#

    pointerGrab                             ,


-- ** pointerIsGrabbed #method:pointerIsGrabbed#

    pointerIsGrabbed                        ,


-- ** pointerUngrab #method:pointerUngrab#

    pointerUngrab                           ,


-- ** preParseLibgtkOnly #method:preParseLibgtkOnly#

    preParseLibgtkOnly                      ,


-- ** propertyDelete #method:propertyDelete#

    propertyDelete                          ,


-- ** queryDepths #method:queryDepths#

    queryDepths                             ,


-- ** queryVisualTypes #method:queryVisualTypes#

    queryVisualTypes                        ,


-- ** selectionConvert #method:selectionConvert#

    selectionConvert                        ,


-- ** selectionOwnerGet #method:selectionOwnerGet#

    selectionOwnerGet                       ,


-- ** selectionOwnerGetForDisplay #method:selectionOwnerGetForDisplay#

    selectionOwnerGetForDisplay             ,


-- ** selectionOwnerSet #method:selectionOwnerSet#

    selectionOwnerSet                       ,


-- ** selectionOwnerSetForDisplay #method:selectionOwnerSetForDisplay#

    selectionOwnerSetForDisplay             ,


-- ** selectionSendNotify #method:selectionSendNotify#

    selectionSendNotify                     ,


-- ** selectionSendNotifyForDisplay #method:selectionSendNotifyForDisplay#

    selectionSendNotifyForDisplay           ,


-- ** setAllowedBackends #method:setAllowedBackends#

    setAllowedBackends                      ,


-- ** setDoubleClickTime #method:setDoubleClickTime#

    setDoubleClickTime                      ,


-- ** setProgramClass #method:setProgramClass#

    setProgramClass                         ,


-- ** setShowEvents #method:setShowEvents#

    setShowEvents                           ,


-- ** settingGet #method:settingGet#

    settingGet                              ,


-- ** synthesizeWindowState #method:synthesizeWindowState#

    synthesizeWindowState                   ,


-- ** testRenderSync #method:testRenderSync#

    testRenderSync                          ,


-- ** testSimulateButton #method:testSimulateButton#

    testSimulateButton                      ,


-- ** testSimulateKey #method:testSimulateKey#

    testSimulateKey                         ,


-- ** textPropertyToUtf8ListForDisplay #method:textPropertyToUtf8ListForDisplay#

    textPropertyToUtf8ListForDisplay        ,


-- ** threadsAddIdle #method:threadsAddIdle#

    threadsAddIdle                          ,


-- ** threadsAddTimeout #method:threadsAddTimeout#

    threadsAddTimeout                       ,


-- ** threadsAddTimeoutSeconds #method:threadsAddTimeoutSeconds#

    threadsAddTimeoutSeconds                ,


-- ** threadsEnter #method:threadsEnter#

    threadsEnter                            ,


-- ** threadsInit #method:threadsInit#

    threadsInit                             ,


-- ** threadsLeave #method:threadsLeave#

    threadsLeave                            ,


-- ** unicodeToKeyval #method:unicodeToKeyval#

    unicodeToKeyval                         ,


-- ** utf8ToStringTarget #method:utf8ToStringTarget#

    utf8ToStringTarget                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Pango.Objects.Context as Pango.Context

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Pango.Objects.Context as Pango.Context

#endif

-- function utf8_to_string_target
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_utf8_to_string_target" gdk_utf8_to_string_target :: 
    CString ->                              -- str : TBasicType TUTF8
    IO CString

-- | Converts an UTF-8 string into the best possible representation
-- as a STRING. The representation of characters not in STRING
-- is not specified; it may be as pseudo-escape sequences
-- \\x{ABCD}, or it may be in some other form of approximation.
utf8ToStringTarget ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: a UTF-8 string
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the newly-allocated string, or 'P.Nothing' if the
    --          conversion failed. (It should not fail for any properly
    --          formed UTF-8 string unless system limits like memory or
    --          file descriptors are exceeded.)
utf8ToStringTarget str = liftIO $ do
    str' <- textToCString str
    result <- gdk_utf8_to_string_target str'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem str'
    return maybeResult


-- function unicode_to_keyval
-- Args: [ Arg
--           { argCName = "wc"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a ISO10646 encoded character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_unicode_to_keyval" gdk_unicode_to_keyval :: 
    Word32 ->                               -- wc : TBasicType TUInt32
    IO Word32

-- | Convert from a ISO10646 character to a key symbol.
unicodeToKeyval ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@wc@/: a ISO10646 encoded character
    -> m Word32
    -- ^ __Returns:__ the corresponding GDK key symbol, if one exists.
    --               or, if there is no corresponding symbol,
    --               wc | 0x01000000
unicodeToKeyval wc = liftIO $ do
    result <- gdk_unicode_to_keyval wc
    return result


-- function threads_leave
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_leave" gdk_threads_leave :: 
    IO ()

{-# DEPRECATED threadsLeave ["(Since version 3.6)","All GDK and GTK+ calls should be made from the main","    thread"] #-}
-- | Leaves a critical region begun with 'GI.Gdk.Functions.threadsEnter'.
threadsLeave ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
threadsLeave  = liftIO $ do
    gdk_threads_leave
    return ()


-- function threads_init
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_init" gdk_threads_init :: 
    IO ()

{-# DEPRECATED threadsInit ["(Since version 3.6)","All GDK and GTK+ calls should be made from the main","    thread"] #-}
-- | Initializes GDK so that it can be used from multiple threads
-- in conjunction with 'GI.Gdk.Functions.threadsEnter' and 'GI.Gdk.Functions.threadsLeave'.
-- 
-- This call must be made before any use of the main loop from
-- GTK+; to be safe, call it before @/gtk_init()/@.
threadsInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
threadsInit  = liftIO $ do
    gdk_threads_init
    return ()


-- function threads_enter
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_enter" gdk_threads_enter :: 
    IO ()

{-# DEPRECATED threadsEnter ["(Since version 3.6)","All GDK and GTK+ calls should be made from the main","    thread"] #-}
-- | This function marks the beginning of a critical section in which
-- GDK and GTK+ functions can be called safely and without causing race
-- conditions. Only one thread at a time can be in such a critial
-- section.
threadsEnter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
threadsEnter  = liftIO $ do
    gdk_threads_enter
    return ()


-- function threads_add_timeout_seconds
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the timeout source. Typically this will be in the\n           range between #G_PRIORITY_DEFAULT_IDLE and #G_PRIORITY_HIGH_IDLE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the time between calls to the function, in seconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to call when the timeout is removed, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_add_timeout_seconds_full" gdk_threads_add_timeout_seconds_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Word32 ->                               -- interval : TBasicType TUInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | A variant of 'GI.Gdk.Functions.threadsAddTimeout' with second-granularity.
-- See 'GI.GLib.Functions.timeoutAddSeconds' for a discussion of why it is
-- a good idea to use this function if you don’t need finer granularity.
-- 
-- /Since: 2.14/
threadsAddTimeoutSeconds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the timeout source. Typically this will be in the
    --            range between 'GI.GLib.Constants.PRIORITY_DEFAULT_IDLE' and 'GI.GLib.Constants.PRIORITY_HIGH_IDLE'.
    -> Word32
    -- ^ /@interval@/: the time between calls to the function, in seconds
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source.
threadsAddTimeoutSeconds priority interval function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- gdk_threads_add_timeout_seconds_full priority interval function' data_ notify
    return result


-- function threads_add_timeout
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the timeout source. Typically this will be in the\n           range between #G_PRIORITY_DEFAULT_IDLE and #G_PRIORITY_HIGH_IDLE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the time between calls to the function, in milliseconds\n            (1/1000ths of a second)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 3
--           , argDestroy = 4
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to call when the timeout is removed, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_add_timeout_full" gdk_threads_add_timeout_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    Word32 ->                               -- interval : TBasicType TUInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Sets a function to be called at regular intervals holding the GDK lock,
-- with the given priority.  The function is called repeatedly until it
-- returns 'P.False', at which point the timeout is automatically destroyed
-- and the function will not be called again.  The /@notify@/ function is
-- called when the timeout is destroyed.  The first call to the
-- function will be at the end of the first /@interval@/.
-- 
-- Note that timeout functions may be delayed, due to the processing of other
-- event sources. Thus they should not be relied on for precise timing.
-- After each call to the timeout function, the time of the next
-- timeout is recalculated based on the current time and the given interval
-- (it does not try to “catch up” time lost in delays).
-- 
-- This variant of 'GI.GLib.Functions.timeoutAdd' can be thought of a MT-safe version
-- for GTK+ widgets for the following use case:
-- 
-- 
-- === /C code/
-- >
-- >static gboolean timeout_callback (gpointer data)
-- >{
-- >   SomeWidget *self = data;
-- >   
-- >   // do stuff with self
-- >   
-- >   self->timeout_id = 0;
-- >   
-- >   return G_SOURCE_REMOVE;
-- >}
-- > 
-- >static void some_widget_do_stuff_later (SomeWidget *self)
-- >{
-- >   self->timeout_id = g_timeout_add (timeout_callback, self)
-- >}
-- > 
-- >static void some_widget_finalize (GObject *object)
-- >{
-- >   SomeWidget *self = SOME_WIDGET (object);
-- >   
-- >   if (self->timeout_id)
-- >     g_source_remove (self->timeout_id);
-- >   
-- >   G_OBJECT_CLASS (parent_class)->finalize (object);
-- >}
-- 
-- 
-- /Since: 2.12/
threadsAddTimeout ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the timeout source. Typically this will be in the
    --            range between 'GI.GLib.Constants.PRIORITY_DEFAULT_IDLE' and 'GI.GLib.Constants.PRIORITY_HIGH_IDLE'.
    -> Word32
    -- ^ /@interval@/: the time between calls to the function, in milliseconds
    --             (1\/1000ths of a second)
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source.
threadsAddTimeout priority interval function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- gdk_threads_add_timeout_full priority interval function' data_ notify
    return result


-- function threads_add_idle
-- Args: [ Arg
--           { argCName = "priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the priority of the idle source. Typically this will be in the\n           range between #G_PRIORITY_DEFAULT_IDLE and #G_PRIORITY_HIGH_IDLE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "function"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SourceFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to call" , sinceVersion = Nothing }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function to call when the idle is removed, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_threads_add_idle_full" gdk_threads_add_idle_full :: 
    Int32 ->                                -- priority : TBasicType TInt
    FunPtr GLib.Callbacks.C_SourceFunc ->   -- function : TInterface (Name {namespace = "GLib", name = "SourceFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO Word32

-- | Adds a function to be called whenever there are no higher priority
-- events pending.  If the function returns 'P.False' it is automatically
-- removed from the list of event sources and will not be called again.
-- 
-- This variant of 'GI.GLib.Functions.idleAdd' calls /@function@/ with the GDK lock
-- held. It can be thought of a MT-safe version for GTK+ widgets for the
-- following use case, where you have to worry about @/idle_callback()/@
-- running in thread A and accessing /@self@/ after it has been finalized
-- in thread B:
-- 
-- 
-- === /C code/
-- >
-- >static gboolean
-- >idle_callback (gpointer data)
-- >{
-- >   // gdk_threads_enter(); would be needed for g_idle_add()
-- >
-- >   SomeWidget *self = data;
-- >   // do stuff with self
-- >
-- >   self->idle_id = 0;
-- >
-- >   // gdk_threads_leave(); would be needed for g_idle_add()
-- >   return FALSE;
-- >}
-- >
-- >static void
-- >some_widget_do_stuff_later (SomeWidget *self)
-- >{
-- >   self->idle_id = gdk_threads_add_idle (idle_callback, self)
-- >   // using g_idle_add() here would require thread protection in the callback
-- >}
-- >
-- >static void
-- >some_widget_finalize (GObject *object)
-- >{
-- >   SomeWidget *self = SOME_WIDGET (object);
-- >   if (self->idle_id)
-- >     g_source_remove (self->idle_id);
-- >   G_OBJECT_CLASS (parent_class)->finalize (object);
-- >}
-- 
-- 
-- /Since: 2.12/
threadsAddIdle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@priority@/: the priority of the idle source. Typically this will be in the
    --            range between 'GI.GLib.Constants.PRIORITY_DEFAULT_IDLE' and 'GI.GLib.Constants.PRIORITY_HIGH_IDLE'
    -> GLib.Callbacks.SourceFunc
    -- ^ /@function@/: function to call
    -> m Word32
    -- ^ __Returns:__ the ID (greater than 0) of the event source.
threadsAddIdle priority function = liftIO $ do
    function' <- GLib.Callbacks.mk_SourceFunc (GLib.Callbacks.wrap_SourceFunc Nothing (GLib.Callbacks.drop_closures_SourceFunc function))
    let data_ = castFunPtrToPtr function'
    let notify = SP.safeFreeFunPtrPtr
    result <- gdk_threads_add_idle_full priority function' data_ notify
    return result


-- function text_property_to_utf8_list_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "encoding"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an atom representing the encoding of the text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "format"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the format of the property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TCArray False (-1) 4 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the text to convert"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of @text, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "list"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the list\n           of strings or %NULL. The list should be freed with\n           g_strfreev()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of @text, in bytes"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_text_property_to_utf8_list_for_display" gdk_text_property_to_utf8_list_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Atom.Atom ->                    -- encoding : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Int32 ->                                -- format : TBasicType TInt
    Ptr Word8 ->                            -- text : TCArray False (-1) 4 (TBasicType TUInt8)
    Int32 ->                                -- length : TBasicType TInt
    Ptr (Ptr CString) ->                    -- list : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO Int32

-- | Converts a text property in the given encoding to
-- a list of UTF-8 strings.
-- 
-- /Since: 2.2/
textPropertyToUtf8ListForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Gdk.Atom.Atom
    -- ^ /@encoding@/: an atom representing the encoding of the text
    -> Int32
    -- ^ /@format@/: the format of the property
    -> ByteString
    -- ^ /@text@/: the text to convert
    -> m ((Int32, [T.Text]))
    -- ^ __Returns:__ the number of strings in the resulting list
textPropertyToUtf8ListForDisplay display encoding format text = liftIO $ do
    let length_ = fromIntegral $ B.length text
    display' <- unsafeManagedPtrCastPtr display
    encoding' <- unsafeManagedPtrGetPtr encoding
    text' <- packByteString text
    list <- callocMem :: IO (Ptr (Ptr CString))
    result <- gdk_text_property_to_utf8_list_for_display display' encoding' format text' length_ list
    list' <- peek list
    list'' <- unpackZeroTerminatedUTF8CArray list'
    mapZeroTerminatedCArray freeMem list'
    freeMem list'
    touchManagedPtr display
    touchManagedPtr encoding
    freeMem text'
    freeMem list
    return (result, list'')


-- function test_simulate_key
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow to simulate a key event for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "x coordinate within @window for the key event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "y coordinate within @window for the key event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A GDK keyboard value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Keyboard modifiers the event is setup with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key_pressrelease"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "either %GDK_KEY_PRESS or %GDK_KEY_RELEASE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_test_simulate_key" gdk_test_simulate_key :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Word32 ->                               -- keyval : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    CInt ->                                 -- key_pressrelease : TInterface (Name {namespace = "Gdk", name = "EventType"})
    IO CInt

-- | This function is intended to be used in GTK+ test programs.
-- If (/@x@/,/@y@/) are > (-1,-1), it will warp the mouse pointer to
-- the given (/@x@/,/@y@/) coordinates within /@window@/ and simulate a
-- key press or release event.
-- 
-- When the mouse pointer is warped to the target location, use
-- of this function outside of test programs that run in their
-- own virtual windowing system (e.g. Xvfb) is not recommended.
-- If (/@x@/,/@y@/) are passed as (-1,-1), the mouse pointer will not
-- be warped and /@window@/ origin will be used as mouse pointer
-- location for the event.
-- 
-- Also, 'GI.Gdk.Functions.testSimulateKey' is a fairly low level function,
-- for most testing purposes, @/gtk_test_widget_send_key()/@ is the
-- right function to call which will generate a key press event
-- followed by its accompanying key release event.
-- 
-- /Since: 2.14/
testSimulateKey ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window' to simulate a key event for
    -> Int32
    -- ^ /@x@/: x coordinate within /@window@/ for the key event
    -> Int32
    -- ^ /@y@/: y coordinate within /@window@/ for the key event
    -> Word32
    -- ^ /@keyval@/: A GDK keyboard value
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: Keyboard modifiers the event is setup with
    -> Gdk.Enums.EventType
    -- ^ /@keyPressrelease@/: either 'GI.Gdk.Enums.EventTypeKeyPress' or 'GI.Gdk.Enums.EventTypeKeyRelease'
    -> m Bool
    -- ^ __Returns:__ whether all actions necessary for a key event simulation
    --     were carried out successfully
testSimulateKey window x y keyval modifiers keyPressrelease = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let modifiers' = gflagsToWord modifiers
    let keyPressrelease' = (fromIntegral . fromEnum) keyPressrelease
    result <- gdk_test_simulate_key window' x y keyval modifiers' keyPressrelease'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'


-- function test_simulate_button
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow to simulate a button event for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "x coordinate within @window for the button event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "y coordinate within @window for the button event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Number of the pointer button for the event, usually 1, 2 or 3"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Keyboard modifiers the event is setup with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "button_pressrelease"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "either %GDK_BUTTON_PRESS or %GDK_BUTTON_RELEASE"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_test_simulate_button" gdk_test_simulate_button :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Word32 ->                               -- button : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    CInt ->                                 -- button_pressrelease : TInterface (Name {namespace = "Gdk", name = "EventType"})
    IO CInt

-- | This function is intended to be used in GTK+ test programs.
-- It will warp the mouse pointer to the given (/@x@/,/@y@/) coordinates
-- within /@window@/ and simulate a button press or release event.
-- Because the mouse pointer needs to be warped to the target
-- location, use of this function outside of test programs that
-- run in their own virtual windowing system (e.g. Xvfb) is not
-- recommended.
-- 
-- Also, 'GI.Gdk.Functions.testSimulateButton' is a fairly low level function,
-- for most testing purposes, @/gtk_test_widget_click()/@ is the right
-- function to call which will generate a button press event followed
-- by its accompanying button release event.
-- 
-- /Since: 2.14/
testSimulateButton ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window' to simulate a button event for
    -> Int32
    -- ^ /@x@/: x coordinate within /@window@/ for the button event
    -> Int32
    -- ^ /@y@/: y coordinate within /@window@/ for the button event
    -> Word32
    -- ^ /@button@/: Number of the pointer button for the event, usually 1, 2 or 3
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: Keyboard modifiers the event is setup with
    -> Gdk.Enums.EventType
    -- ^ /@buttonPressrelease@/: either 'GI.Gdk.Enums.EventTypeButtonPress' or 'GI.Gdk.Enums.EventTypeButtonRelease'
    -> m Bool
    -- ^ __Returns:__ whether all actions necessary for a button event simulation
    --     were carried out successfully
testSimulateButton window x y button modifiers buttonPressrelease = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let modifiers' = gflagsToWord modifiers
    let buttonPressrelease' = (fromIntegral . fromEnum) buttonPressrelease
    result <- gdk_test_simulate_button window' x y button modifiers' buttonPressrelease'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'


-- function test_render_sync
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mapped #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_test_render_sync" gdk_test_render_sync :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Retrieves a pixel from /@window@/ to force the windowing
-- system to carry out any pending rendering commands.
-- 
-- This function is intended to be used to synchronize with rendering
-- pipelines, to benchmark windowing system rendering operations.
-- 
-- /Since: 2.14/
testRenderSync ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a mapped t'GI.Gdk.Objects.Window.Window'
    -> m ()
testRenderSync window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_test_render_sync window'
    touchManagedPtr window
    return ()


-- function synthesize_window_state
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "unset_flags"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "set_flags"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "WindowState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_synthesize_window_state" gdk_synthesize_window_state :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- unset_flags : TInterface (Name {namespace = "Gdk", name = "WindowState"})
    CUInt ->                                -- set_flags : TInterface (Name {namespace = "Gdk", name = "WindowState"})
    IO ()

-- | /No description available in the introspection data./
synthesizeWindowState ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -> [Gdk.Flags.WindowState]
    -> [Gdk.Flags.WindowState]
    -> m ()
synthesizeWindowState window unsetFlags setFlags = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let unsetFlags' = gflagsToWord unsetFlags
    let setFlags' = gflagsToWord setFlags
    gdk_synthesize_window_state window' unsetFlags' setFlags'
    touchManagedPtr window
    return ()


-- function setting_get
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the setting."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the value of the setting."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_setting_get" gdk_setting_get :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Obtains a desktop-wide setting, such as the double-click time,
-- for the default screen. See 'GI.Gdk.Objects.Screen.screenGetSetting'.
settingGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the setting.
    -> GValue
    -- ^ /@value@/: location to store the value of the setting.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the setting existed and a value was stored
    --   in /@value@/, 'P.False' otherwise.
settingGet name value = liftIO $ do
    name' <- textToCString name
    value' <- unsafeManagedPtrGetPtr value
    result <- gdk_setting_get name' value'
    let result' = (/= 0) result
    touchManagedPtr value
    freeMem name'
    return result'


-- function set_show_events
-- Args: [ Arg
--           { argCName = "show_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to output event debugging information."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_set_show_events" gdk_set_show_events :: 
    CInt ->                                 -- show_events : TBasicType TBoolean
    IO ()

-- | Sets whether a trace of received events is output.
-- Note that GTK+ must be compiled with debugging (that is,
-- configured using the @--enable-debug@ option)
-- to use this option.
setShowEvents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@showEvents@/: 'P.True' to output event debugging information.
    -> m ()
setShowEvents showEvents = liftIO $ do
    let showEvents' = (P.fromIntegral . P.fromEnum) showEvents
    gdk_set_show_events showEvents'
    return ()


-- function set_program_class
-- Args: [ Arg
--           { argCName = "program_class"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_set_program_class" gdk_set_program_class :: 
    CString ->                              -- program_class : TBasicType TUTF8
    IO ()

-- | Sets the program class. The X11 backend uses the program class to set
-- the class name part of the @WM_CLASS@ property on
-- toplevel windows; see the ICCCM.
-- 
-- The program class can still be overridden with the --class command
-- line option.
setProgramClass ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@programClass@/: a string.
    -> m ()
setProgramClass programClass = liftIO $ do
    programClass' <- textToCString programClass
    gdk_set_program_class programClass'
    freeMem programClass'
    return ()


-- function set_double_click_time
-- Args: [ Arg
--           { argCName = "msec"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "double click time in milliseconds (thousandths of a second)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_set_double_click_time" gdk_set_double_click_time :: 
    Word32 ->                               -- msec : TBasicType TUInt
    IO ()

-- | Set the double click time for the default display. See
-- 'GI.Gdk.Objects.Display.displaySetDoubleClickTime'.
-- See also 'GI.Gdk.Objects.Display.displaySetDoubleClickDistance'.
-- Applications should not set this, it is a
-- global user-configured setting.
setDoubleClickTime ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@msec@/: double click time in milliseconds (thousandths of a second)
    -> m ()
setDoubleClickTime msec = liftIO $ do
    gdk_set_double_click_time msec
    return ()


-- function set_allowed_backends
-- Args: [ Arg
--           { argCName = "backends"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a comma-separated list of backends"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_set_allowed_backends" gdk_set_allowed_backends :: 
    CString ->                              -- backends : TBasicType TUTF8
    IO ()

-- | Sets a list of backends that GDK should try to use.
-- 
-- This can be be useful if your application does not
-- work with certain GDK backends.
-- 
-- By default, GDK tries all included backends.
-- 
-- For example,
-- 
-- === /C code/
-- >
-- >gdk_set_allowed_backends ("wayland,quartz,*");
-- 
-- instructs GDK to try the Wayland backend first,
-- followed by the Quartz backend, and then all
-- others.
-- 
-- If the @GDK_BACKEND@ environment variable
-- is set, it determines what backends are tried in what
-- order, while still respecting the set of allowed backends
-- that are specified by this function.
-- 
-- The possible backend names are x11, win32, quartz,
-- broadway, wayland. You can also include a * in the
-- list to try all remaining backends.
-- 
-- This call must happen prior to 'GI.Gdk.Objects.Display.displayOpen',
-- @/gtk_init()/@, @/gtk_init_with_args()/@ or @/gtk_init_check()/@
-- in order to take effect.
-- 
-- /Since: 3.10/
setAllowedBackends ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@backends@/: a comma-separated list of backends
    -> m ()
setAllowedBackends backends = liftIO $ do
    backends' <- textToCString backends
    gdk_set_allowed_backends backends'
    freeMem backends'
    return ()


-- function selection_send_notify_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkDisplay where @requestor is realized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "requestor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window to which to deliver response"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "selection that was requested"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "target that was selected"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "property in which the selection owner stored the data,\n           or %GDK_NONE to indicate that the request was rejected"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_send_notify_for_display" gdk_selection_send_notify_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Window.Window ->                -- requestor : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Ptr Gdk.Atom.Atom ->                    -- target : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Ptr Gdk.Atom.Atom ->                    -- property : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Send a response to SelectionRequest event.
-- 
-- /Since: 2.2/
selectionSendNotifyForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' where /@requestor@/ is realized
    -> b
    -- ^ /@requestor@/: window to which to deliver response
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: selection that was requested
    -> Gdk.Atom.Atom
    -- ^ /@target@/: target that was selected
    -> Gdk.Atom.Atom
    -- ^ /@property@/: property in which the selection owner stored the data,
    --            or @/GDK_NONE/@ to indicate that the request was rejected
    -> Word32
    -- ^ /@time_@/: timestamp
    -> m ()
selectionSendNotifyForDisplay display requestor selection target property time_ = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    requestor' <- unsafeManagedPtrCastPtr requestor
    selection' <- unsafeManagedPtrGetPtr selection
    target' <- unsafeManagedPtrGetPtr target
    property' <- unsafeManagedPtrGetPtr property
    gdk_selection_send_notify_for_display display' requestor' selection' target' property' time_
    touchManagedPtr display
    touchManagedPtr requestor
    touchManagedPtr selection
    touchManagedPtr target
    touchManagedPtr property
    return ()


-- function selection_send_notify
-- Args: [ Arg
--           { argCName = "requestor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window to which to deliver response."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "selection that was requested."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "target that was selected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "property in which the selection owner stored the\n  data, or %GDK_NONE to indicate that the request\n  was rejected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "timestamp." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_send_notify" gdk_selection_send_notify :: 
    Ptr Gdk.Window.Window ->                -- requestor : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Ptr Gdk.Atom.Atom ->                    -- target : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Ptr Gdk.Atom.Atom ->                    -- property : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Sends a response to SelectionRequest event.
selectionSendNotify ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@requestor@/: window to which to deliver response.
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: selection that was requested.
    -> Gdk.Atom.Atom
    -- ^ /@target@/: target that was selected.
    -> Gdk.Atom.Atom
    -- ^ /@property@/: property in which the selection owner stored the
    --   data, or @/GDK_NONE/@ to indicate that the request
    --   was rejected.
    -> Word32
    -- ^ /@time_@/: timestamp.
    -> m ()
selectionSendNotify requestor selection target property time_ = liftIO $ do
    requestor' <- unsafeManagedPtrCastPtr requestor
    selection' <- unsafeManagedPtrGetPtr selection
    target' <- unsafeManagedPtrGetPtr target
    property' <- unsafeManagedPtrGetPtr property
    gdk_selection_send_notify requestor' selection' target' property' time_
    touchManagedPtr requestor
    touchManagedPtr selection
    touchManagedPtr target
    touchManagedPtr property
    return ()


-- function selection_owner_set_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkWindow or %NULL to indicate that the owner for\n        the given should be unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an atom identifying a selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp to use when setting the selection\n        If this is older than the timestamp given last time the owner was\n        set for the given selection, the request will be ignored"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "send_event"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %TRUE, and the new owner is different from the current\n             owner, the current owner will be sent a SelectionClear event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_owner_set_for_display" gdk_selection_owner_set_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Window.Window ->                -- owner : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    CInt ->                                 -- send_event : TBasicType TBoolean
    IO CInt

-- | Sets the t'GI.Gdk.Objects.Window.Window' /@owner@/ as the current owner of the selection /@selection@/.
-- 
-- /Since: 2.2/
selectionOwnerSetForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display'
    -> Maybe (b)
    -- ^ /@owner@/: a t'GI.Gdk.Objects.Window.Window' or 'P.Nothing' to indicate that the owner for
    --         the given should be unset
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: an atom identifying a selection
    -> Word32
    -- ^ /@time_@/: timestamp to use when setting the selection
    --         If this is older than the timestamp given last time the owner was
    --         set for the given selection, the request will be ignored
    -> Bool
    -- ^ /@sendEvent@/: if 'P.True', and the new owner is different from the current
    --              owner, the current owner will be sent a SelectionClear event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the selection owner was successfully changed to owner,
    --    otherwise 'P.False'.
selectionOwnerSetForDisplay display owner selection time_ sendEvent = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    maybeOwner <- case owner of
        Nothing -> return nullPtr
        Just jOwner -> do
            jOwner' <- unsafeManagedPtrCastPtr jOwner
            return jOwner'
    selection' <- unsafeManagedPtrGetPtr selection
    let sendEvent' = (P.fromIntegral . P.fromEnum) sendEvent
    result <- gdk_selection_owner_set_for_display display' maybeOwner selection' time_ sendEvent'
    let result' = (/= 0) result
    touchManagedPtr display
    whenJust owner touchManagedPtr
    touchManagedPtr selection
    return result'


-- function selection_owner_set
-- Args: [ Arg
--           { argCName = "owner"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkWindow or %NULL to indicate that the\n  the owner for the given should be unset."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an atom identifying a selection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "timestamp to use when setting the selection.\n  If this is older than the timestamp given last\n  time the owner was set for the given selection, the\n  request will be ignored."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "send_event"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %TRUE, and the new owner is different\n  from the current owner, the current owner\n  will be sent a SelectionClear event."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_owner_set" gdk_selection_owner_set :: 
    Ptr Gdk.Window.Window ->                -- owner : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    CInt ->                                 -- send_event : TBasicType TBoolean
    IO CInt

-- | Sets the owner of the given selection.
selectionOwnerSet ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    Maybe (a)
    -- ^ /@owner@/: a t'GI.Gdk.Objects.Window.Window' or 'P.Nothing' to indicate that the
    --   the owner for the given should be unset.
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: an atom identifying a selection.
    -> Word32
    -- ^ /@time_@/: timestamp to use when setting the selection.
    --   If this is older than the timestamp given last
    --   time the owner was set for the given selection, the
    --   request will be ignored.
    -> Bool
    -- ^ /@sendEvent@/: if 'P.True', and the new owner is different
    --   from the current owner, the current owner
    --   will be sent a SelectionClear event.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the selection owner was successfully
    --   changed to /@owner@/, otherwise 'P.False'.
selectionOwnerSet owner selection time_ sendEvent = liftIO $ do
    maybeOwner <- case owner of
        Nothing -> return nullPtr
        Just jOwner -> do
            jOwner' <- unsafeManagedPtrCastPtr jOwner
            return jOwner'
    selection' <- unsafeManagedPtrGetPtr selection
    let sendEvent' = (P.fromIntegral . P.fromEnum) sendEvent
    result <- gdk_selection_owner_set maybeOwner selection' time_ sendEvent'
    let result' = (/= 0) result
    whenJust owner touchManagedPtr
    touchManagedPtr selection
    return result'


-- function selection_owner_get_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDisplay" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an atom indentifying a selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_owner_get_for_display" gdk_selection_owner_get_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO (Ptr Gdk.Window.Window)

-- | Determine the owner of the given selection.
-- 
-- Note that the return value may be owned by a different
-- process if a foreign window was previously created for that
-- window, but a new foreign window will never be created by this call.
-- 
-- /Since: 2.2/
selectionOwnerGetForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: a t'GI.Gdk.Objects.Display.Display'
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: an atom indentifying a selection
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ if there is a selection owner
    --    for this window, and it is a window known to the current
    --    process, the t'GI.Gdk.Objects.Window.Window' that owns the selection, otherwise
    --    'P.Nothing'.
selectionOwnerGetForDisplay display selection = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    selection' <- unsafeManagedPtrGetPtr selection
    result <- gdk_selection_owner_get_for_display display' selection'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr display
    touchManagedPtr selection
    return maybeResult


-- function selection_owner_get
-- Args: [ Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an atom indentifying a selection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_owner_get" gdk_selection_owner_get :: 
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO (Ptr Gdk.Window.Window)

-- | Determines the owner of the given selection.
selectionOwnerGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Atom.Atom
    -- ^ /@selection@/: an atom indentifying a selection.
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ if there is a selection owner
    --   for this window, and it is a window known to the current process,
    --   the t'GI.Gdk.Objects.Window.Window' that owns the selection, otherwise 'P.Nothing'. Note
    --   that the return value may be owned by a different process if a
    --   foreign window was previously created for that window, but a new
    --   foreign window will never be created by this call.
selectionOwnerGet selection = liftIO $ do
    selection' <- unsafeManagedPtrGetPtr selection
    result <- gdk_selection_owner_get selection'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr selection
    return maybeResult


-- function selection_convert
-- Args: [ Arg
--           { argCName = "requestor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selection"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "an atom identifying the selection to get the\n  contents of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the form in which to retrieve the selection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the timestamp to use when retrieving the\n  selection. The selection owner may refuse the\n  request if it did not own the selection at\n  the time indicated by the timestamp."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_selection_convert" gdk_selection_convert :: 
    Ptr Gdk.Window.Window ->                -- requestor : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- selection : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Ptr Gdk.Atom.Atom ->                    -- target : TInterface (Name {namespace = "Gdk", name = "Atom"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Retrieves the contents of a selection in a given
-- form.
selectionConvert ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@requestor@/: a t'GI.Gdk.Objects.Window.Window'.
    -> Gdk.Atom.Atom
    -- ^ /@selection@/: an atom identifying the selection to get the
    --   contents of.
    -> Gdk.Atom.Atom
    -- ^ /@target@/: the form in which to retrieve the selection.
    -> Word32
    -- ^ /@time_@/: the timestamp to use when retrieving the
    --   selection. The selection owner may refuse the
    --   request if it did not own the selection at
    --   the time indicated by the timestamp.
    -> m ()
selectionConvert requestor selection target time_ = liftIO $ do
    requestor' <- unsafeManagedPtrCastPtr requestor
    selection' <- unsafeManagedPtrGetPtr selection
    target' <- unsafeManagedPtrGetPtr target
    gdk_selection_convert requestor' selection' target' time_
    touchManagedPtr requestor
    touchManagedPtr selection
    touchManagedPtr target
    return ()


-- function query_visual_types
-- Args: [ Arg
--           { argCName = "visual_types"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 1
--                 (TInterface Name { namespace = "Gdk" , name = "VisualType" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return\n    location for the available visual types"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the number of available visual types"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "return location for the number of available visual types"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_query_visual_types" gdk_query_visual_types :: 
    Ptr (Ptr CUInt) ->                      -- visual_types : TCArray False (-1) 1 (TInterface (Name {namespace = "Gdk", name = "VisualType"}))
    Ptr Int32 ->                            -- count : TBasicType TInt
    IO ()

{-# DEPRECATED queryVisualTypes ["(Since version 3.22)","Visual selection should be done using","    'GI.Gdk.Objects.Screen.screenGetSystemVisual' and 'GI.Gdk.Objects.Screen.screenGetRgbaVisual'"] #-}
-- | This function returns the available visual types for the default
-- screen. It’s equivalent to listing the visuals
-- ('GI.Gdk.Functions.listVisuals') and then looking at the type field in each
-- visual, removing duplicates.
-- 
-- The array returned by this function should not be freed.
queryVisualTypes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ([Gdk.Enums.VisualType])
queryVisualTypes  = liftIO $ do
    visualTypes <- callocMem :: IO (Ptr (Ptr CUInt))
    count <- allocMem :: IO (Ptr Int32)
    gdk_query_visual_types visualTypes count
    count' <- peek count
    visualTypes' <- peek visualTypes
    visualTypes'' <- (unpackStorableArrayWithLength count') visualTypes'
    let visualTypes''' = map (toEnum . fromIntegral) visualTypes''
    freeMem visualTypes
    freeMem count
    return visualTypes'''


-- function query_depths
-- Args: [ Arg
--           { argCName = "depths"
--           , argType = TCArray False (-1) 1 (TBasicType TInt)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return\n    location for available depths"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for number of available depths"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "return location for number of available depths"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_query_depths" gdk_query_depths :: 
    Ptr (Ptr Int32) ->                      -- depths : TCArray False (-1) 1 (TBasicType TInt)
    Ptr Int32 ->                            -- count : TBasicType TInt
    IO ()

{-# DEPRECATED queryDepths ["(Since version 3.22)","Visual selection should be done using","    'GI.Gdk.Objects.Screen.screenGetSystemVisual' and 'GI.Gdk.Objects.Screen.screenGetRgbaVisual'"] #-}
-- | This function returns the available bit depths for the default
-- screen. It’s equivalent to listing the visuals
-- ('GI.Gdk.Functions.listVisuals') and then looking at the depth field in each
-- visual, removing duplicates.
-- 
-- The array returned by this function should not be freed.
queryDepths ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ([Int32])
queryDepths  = liftIO $ do
    depths <- callocMem :: IO (Ptr (Ptr Int32))
    count <- allocMem :: IO (Ptr Int32)
    gdk_query_depths depths count
    count' <- peek count
    depths' <- peek depths
    depths'' <- (unpackStorableArrayWithLength count') depths'
    freeMem depths
    freeMem count
    return depths''


-- function property_get
-- XXX Could not generate function property_get

-- Not implemented: Don't know how to allocate "actual_property_type" of type TInterface (Name {namespace = "Gdk", name = "Atom"})

-- function property_delete
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the property to delete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_property_delete" gdk_property_delete :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Atom.Atom ->                    -- property : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO ()

-- | Deletes a property from a window.
propertyDelete ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Gdk.Atom.Atom
    -- ^ /@property@/: the property to delete
    -> m ()
propertyDelete window property = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    property' <- unsafeManagedPtrGetPtr property
    gdk_property_delete window' property'
    touchManagedPtr window
    touchManagedPtr property
    return ()


-- function pre_parse_libgtk_only
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pre_parse_libgtk_only" gdk_pre_parse_libgtk_only :: 
    IO ()

{-# DEPRECATED preParseLibgtkOnly ["(Since version 3.16)","This symbol was never meant to be used outside","  of GTK+"] #-}
-- | Prepare for parsing command line arguments for GDK. This is not
-- public API and should not be used in application code.
preParseLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
preParseLibgtkOnly  = liftIO $ do
    gdk_pre_parse_libgtk_only
    return ()


-- function pointer_ungrab
-- Args: [ Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a timestamp from a #GdkEvent, or %GDK_CURRENT_TIME if no\n timestamp is available."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pointer_ungrab" gdk_pointer_ungrab :: 
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

{-# DEPRECATED pointerUngrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceUngrab', together with 'GI.Gdk.Objects.Device.deviceGrab'","            instead."] #-}
-- | Ungrabs the pointer on the default display, if it is grabbed by this
-- application.
pointerUngrab ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@time_@/: a timestamp from a t'GI.Gdk.Unions.Event.Event', or 'GI.Gdk.Constants.CURRENT_TIME' if no
    --  timestamp is available.
    -> m ()
pointerUngrab time_ = liftIO $ do
    gdk_pointer_ungrab time_
    return ()


-- function pointer_is_grabbed
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pointer_is_grabbed" gdk_pointer_is_grabbed :: 
    IO CInt

{-# DEPRECATED pointerIsGrabbed ["(Since version 3.0)","Use 'GI.Gdk.Objects.Display.displayDeviceIsGrabbed' instead."] #-}
-- | Returns 'P.True' if the pointer on the default display is currently
-- grabbed by this application.
-- 
-- Note that this does not take the inmplicit pointer grab on button
-- presses into account.
pointerIsGrabbed ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ 'P.True' if the pointer is currently grabbed by this application.
pointerIsGrabbed  = liftIO $ do
    result <- gdk_pointer_is_grabbed
    let result' = (/= 0) result
    return result'


-- function pointer_grab
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkWindow which will own the grab (the grab window)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %FALSE then all pointer events are reported with respect to\n               @window and are only reported if selected by @event_mask. If %TRUE then pointer\n               events for this application are reported as normal, but pointer events outside\n               this application are reported with respect to @window and only if selected by\n               @event_mask. In either mode, unreported events are discarded."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "specifies the event mask, which is used in accordance with\n             @owner_events. Note that only pointer events (i.e. button and motion events)\n             may be selected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "confine_to"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "If non-%NULL, the pointer will be confined to this\n             window during the grab. If the pointer is outside @confine_to, it will\n             automatically be moved to the closest edge of @confine_to and enter\n             and leave events will be generated as necessary."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the cursor to display while the grab is active. If this is %NULL then\n         the normal cursors are used for @window and its descendants, and the cursor\n         for @window is used for all other windows."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the timestamp of the event which led to this pointer grab. This usually\n        comes from a #GdkEventButton struct, though %GDK_CURRENT_TIME can be used if\n        the time isn\8217t known."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GrabStatus" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pointer_grab" gdk_pointer_grab :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- owner_events : TBasicType TBoolean
    CUInt ->                                -- event_mask : TInterface (Name {namespace = "Gdk", name = "EventMask"})
    Ptr Gdk.Window.Window ->                -- confine_to : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO CUInt

{-# DEPRECATED pointerGrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceGrab' instead."] #-}
-- | Grabs the pointer (usually a mouse) so that all events are passed to this
-- application until the pointer is ungrabbed with 'GI.Gdk.Functions.pointerUngrab', or
-- the grab window becomes unviewable.
-- This overrides any previous pointer grab by this client.
-- 
-- Pointer grabs are used for operations which need complete control over mouse
-- events, even if the mouse leaves the application.
-- For example in GTK+ it is used for Drag and Drop, for dragging the handle in
-- the @/GtkHPaned/@ and @/GtkVPaned/@ widgets.
-- 
-- Note that if the event mask of an X window has selected both button press and
-- button release events, then a button press event will cause an automatic
-- pointer grab until the button is released.
-- X does this automatically since most applications expect to receive button
-- press and release events in pairs.
-- It is equivalent to a pointer grab on the window with /@ownerEvents@/ set to
-- 'P.True'.
-- 
-- If you set up anything at the time you take the grab that needs to be cleaned
-- up when the grab ends, you should handle the t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken' events that
-- are emitted when the grab ends unvoluntarily.
pointerGrab ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a, Gdk.Window.IsWindow b, Gdk.Cursor.IsCursor c) =>
    a
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' which will own the grab (the grab window).
    -> Bool
    -- ^ /@ownerEvents@/: if 'P.False' then all pointer events are reported with respect to
    --                /@window@/ and are only reported if selected by /@eventMask@/. If 'P.True' then pointer
    --                events for this application are reported as normal, but pointer events outside
    --                this application are reported with respect to /@window@/ and only if selected by
    --                /@eventMask@/. In either mode, unreported events are discarded.
    -> [Gdk.Flags.EventMask]
    -- ^ /@eventMask@/: specifies the event mask, which is used in accordance with
    --              /@ownerEvents@/. Note that only pointer events (i.e. button and motion events)
    --              may be selected.
    -> Maybe (b)
    -- ^ /@confineTo@/: If non-'P.Nothing', the pointer will be confined to this
    --              window during the grab. If the pointer is outside /@confineTo@/, it will
    --              automatically be moved to the closest edge of /@confineTo@/ and enter
    --              and leave events will be generated as necessary.
    -> Maybe (c)
    -- ^ /@cursor@/: the cursor to display while the grab is active. If this is 'P.Nothing' then
    --          the normal cursors are used for /@window@/ and its descendants, and the cursor
    --          for /@window@/ is used for all other windows.
    -> Word32
    -- ^ /@time_@/: the timestamp of the event which led to this pointer grab. This usually
    --         comes from a t'GI.Gdk.Structs.EventButton.EventButton' struct, though 'GI.Gdk.Constants.CURRENT_TIME' can be used if
    --         the time isn’t known.
    -> m Gdk.Enums.GrabStatus
    -- ^ __Returns:__ 'GI.Gdk.Enums.GrabStatusSuccess' if the grab was successful.
pointerGrab window ownerEvents eventMask confineTo cursor time_ = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let ownerEvents' = (P.fromIntegral . P.fromEnum) ownerEvents
    let eventMask' = gflagsToWord eventMask
    maybeConfineTo <- case confineTo of
        Nothing -> return nullPtr
        Just jConfineTo -> do
            jConfineTo' <- unsafeManagedPtrCastPtr jConfineTo
            return jConfineTo'
    maybeCursor <- case cursor of
        Nothing -> return nullPtr
        Just jCursor -> do
            jCursor' <- unsafeManagedPtrCastPtr jCursor
            return jCursor'
    result <- gdk_pointer_grab window' ownerEvents' eventMask' maybeConfineTo maybeCursor time_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    whenJust confineTo touchManagedPtr
    whenJust cursor touchManagedPtr
    return result'


-- function pixbuf_get_from_window
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source X coordinate within @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source Y coordinate within @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Width in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Height in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_get_from_window" gdk_pixbuf_get_from_window :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- src_x : TBasicType TInt
    Int32 ->                                -- src_y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- | Transfers image data from a t'GI.Gdk.Objects.Window.Window' and converts it to an RGB(A)
-- representation inside a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'.
-- 
-- In other words, copies image data from a server-side drawable to a
-- client-side RGB(A) buffer. This allows you to efficiently read
-- individual pixels on the client side.
-- 
-- This function will create an RGB pixbuf with 8 bits per channel with
-- the size specified by the /@width@/ and /@height@/ arguments scaled by the
-- scale factor of /@window@/. The pixbuf will contain an alpha channel if
-- the /@window@/ contains one.
-- 
-- If the window is off the screen, then there is no image data in the
-- obscured\/offscreen regions to be placed in the pixbuf. The contents of
-- portions of the pixbuf corresponding to the offscreen region are
-- undefined.
-- 
-- If the window you’re obtaining data from is partially obscured by
-- other windows, then the contents of the pixbuf areas corresponding
-- to the obscured regions are undefined.
-- 
-- If the window is not mapped (typically because it’s iconified\/minimized
-- or not on the current workspace), then 'P.Nothing' will be returned.
-- 
-- If memory can’t be allocated for the return value, 'P.Nothing' will be returned
-- instead.
-- 
-- In short, there are several ways this function can fail, and if it fails
-- it returns 'P.Nothing'; so check the return value.
-- 
-- You should rarely, if ever, need to call this function.
pixbufGetFromWindow ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: Source window
    -> Int32
    -- ^ /@srcX@/: Source X coordinate within /@window@/
    -> Int32
    -- ^ /@srcY@/: Source Y coordinate within /@window@/
    -> Int32
    -- ^ /@width@/: Width in pixels of region to get
    -> Int32
    -- ^ /@height@/: Height in pixels of region to get
    -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    -- ^ __Returns:__ A newly-created pixbuf with a
    --   reference count of 1, or 'P.Nothing' on error
pixbufGetFromWindow window srcX srcY width height = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_pixbuf_get_from_window window' srcX srcY width height
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result'
        return result''
    touchManagedPtr window
    return maybeResult


-- function pixbuf_get_from_surface
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "surface to copy from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source X coordinate within @surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Source Y coordinate within @surface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Width in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Height in pixels of region to get"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_get_from_surface" gdk_pixbuf_get_from_surface :: 
    Ptr Cairo.Surface.Surface ->            -- surface : TInterface (Name {namespace = "cairo", name = "Surface"})
    Int32 ->                                -- src_x : TBasicType TInt
    Int32 ->                                -- src_y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO (Ptr GdkPixbuf.Pixbuf.Pixbuf)

-- | Transfers image data from a t'GI.Cairo.Structs.Surface.Surface' and converts it to an RGB(A)
-- representation inside a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'. This allows you to efficiently read
-- individual pixels from cairo surfaces. For @/GdkWindows/@, use
-- 'GI.Gdk.Functions.pixbufGetFromWindow' instead.
-- 
-- This function will create an RGB pixbuf with 8 bits per channel.
-- The pixbuf will contain an alpha channel if the /@surface@/ contains one.
pixbufGetFromSurface ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Surface.Surface
    -- ^ /@surface@/: surface to copy from
    -> Int32
    -- ^ /@srcX@/: Source X coordinate within /@surface@/
    -> Int32
    -- ^ /@srcY@/: Source Y coordinate within /@surface@/
    -> Int32
    -- ^ /@width@/: Width in pixels of region to get
    -> Int32
    -- ^ /@height@/: Height in pixels of region to get
    -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    -- ^ __Returns:__ A newly-created pixbuf with a
    --     reference count of 1, or 'P.Nothing' on error
pixbufGetFromSurface surface srcX srcY width height = liftIO $ do
    surface' <- unsafeManagedPtrGetPtr surface
    result <- gdk_pixbuf_get_from_surface surface' srcX srcY width height
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GdkPixbuf.Pixbuf.Pixbuf) result'
        return result''
    touchManagedPtr surface
    return maybeResult


-- function parse_args
-- Args: [ Arg
--           { argCName = "argc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray False (-1) 0 (TBasicType TUTF8)
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the array of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "argc"
--              , argType = TBasicType TInt
--              , direction = DirectionInout
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of command line arguments."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_parse_args" gdk_parse_args :: 
    Ptr Int32 ->                            -- argc : TBasicType TInt
    Ptr (Ptr CString) ->                    -- argv : TCArray False (-1) 0 (TBasicType TUTF8)
    IO ()

-- | Parse command line arguments, and store for future
-- use by calls to 'GI.Gdk.Objects.Display.displayOpen'.
-- 
-- Any arguments used by GDK are removed from the array and /@argc@/ and /@argv@/ are
-- updated accordingly.
-- 
-- You shouldn’t call this function explicitly if you are using
-- @/gtk_init()/@, @/gtk_init_check()/@, 'GI.Gdk.Functions.init', or 'GI.Gdk.Functions.initCheck'.
-- 
-- /Since: 2.2/
parseArgs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@argv@/: the array of command line arguments.
    -> m ([T.Text])
parseArgs argv = liftIO $ do
    let argc = fromIntegral $ P.length argv
    argc' <- allocMem :: IO (Ptr Int32)
    poke argc' argc
    argv' <- packUTF8CArray argv
    argv'' <- allocMem :: IO (Ptr (Ptr CString))
    poke argv'' argv'
    gdk_parse_args argc' argv''
    argc'' <- peek argc'
    argv''' <- peek argv''
    argv'''' <- (unpackUTF8CArrayWithLength argc'') argv'''
    (mapCArrayWithLength argc'') freeMem argv'''
    freeMem argv'''
    freeMem argc'
    freeMem argv''
    return argv''''


-- function pango_context_get_for_screen
-- Args: [ Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkScreen for which the context is to be created."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pango_context_get_for_screen" gdk_pango_context_get_for_screen :: 
    Ptr Gdk.Screen.Screen ->                -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    IO (Ptr Pango.Context.Context)

-- | Creates a t'GI.Pango.Objects.Context.Context' for /@screen@/.
-- 
-- The context must be freed when you’re finished with it.
-- 
-- When using GTK+, normally you should use @/gtk_widget_get_pango_context()/@
-- instead of this function, to get the appropriate context for
-- the widget you intend to render text onto.
-- 
-- The newly created context will have the default font options
-- (see t'GI.Cairo.Structs.FontOptions.FontOptions') for the screen; if these options
-- change it will not be updated. Using @/gtk_widget_get_pango_context()/@
-- is more convenient if you want to keep a context around and track
-- changes to the screen’s font rendering settings.
-- 
-- /Since: 2.2/
pangoContextGetForScreen ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Screen.IsScreen a) =>
    a
    -- ^ /@screen@/: the t'GI.Gdk.Objects.Screen.Screen' for which the context is to be created.
    -> m Pango.Context.Context
    -- ^ __Returns:__ a new t'GI.Pango.Objects.Context.Context' for /@screen@/
pangoContextGetForScreen screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_pango_context_get_for_screen screen'
    checkUnexpectedReturnNULL "pangoContextGetForScreen" result
    result' <- (wrapObject Pango.Context.Context) result
    touchManagedPtr screen
    return result'


-- function pango_context_get_for_display
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay for which the context is to be created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pango_context_get_for_display" gdk_pango_context_get_for_display :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Pango.Context.Context)

-- | Creates a t'GI.Pango.Objects.Context.Context' for /@display@/.
-- 
-- The context must be freed when you’re finished with it.
-- 
-- When using GTK+, normally you should use @/gtk_widget_get_pango_context()/@
-- instead of this function, to get the appropriate context for
-- the widget you intend to render text onto.
-- 
-- The newly created context will have the default font options
-- (see t'GI.Cairo.Structs.FontOptions.FontOptions') for the display; if these options
-- change it will not be updated. Using @/gtk_widget_get_pango_context()/@
-- is more convenient if you want to keep a context around and track
-- changes to the font rendering settings.
-- 
-- /Since: 3.22/
pangoContextGetForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' for which the context is to be created
    -> m Pango.Context.Context
    -- ^ __Returns:__ a new t'GI.Pango.Objects.Context.Context' for /@display@/
pangoContextGetForDisplay display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_pango_context_get_for_display display'
    checkUnexpectedReturnNULL "pangoContextGetForDisplay" result
    result' <- (wrapObject Pango.Context.Context) result
    touchManagedPtr display
    return result'


-- function pango_context_get
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pango_context_get" gdk_pango_context_get :: 
    IO (Ptr Pango.Context.Context)

-- | Creates a t'GI.Pango.Objects.Context.Context' for the default GDK screen.
-- 
-- The context must be freed when you’re finished with it.
-- 
-- When using GTK+, normally you should use @/gtk_widget_get_pango_context()/@
-- instead of this function, to get the appropriate context for
-- the widget you intend to render text onto.
-- 
-- The newly created context will have the default font options (see
-- t'GI.Cairo.Structs.FontOptions.FontOptions') for the default screen; if these options
-- change it will not be updated. Using @/gtk_widget_get_pango_context()/@
-- is more convenient if you want to keep a context around and track
-- changes to the screen’s font rendering settings.
pangoContextGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Pango.Context.Context
    -- ^ __Returns:__ a new t'GI.Pango.Objects.Context.Context' for the default display
pangoContextGet  = liftIO $ do
    result <- gdk_pango_context_get
    checkUnexpectedReturnNULL "pangoContextGet" result
    result' <- (wrapObject Pango.Context.Context) result
    return result'


-- function offscreen_window_set_embedder
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "embedder"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GdkWindow that @window gets embedded in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_offscreen_window_set_embedder" gdk_offscreen_window_set_embedder :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Window.Window ->                -- embedder : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Sets /@window@/ to be embedded in /@embedder@/.
-- 
-- To fully embed an offscreen window, in addition to calling this
-- function, it is also necessary to handle the [Window::pickEmbeddedChild]("GI.Gdk.Objects.Window#g:signal:pickEmbeddedChild")
-- signal on the /@embedder@/ and the [Window::toEmbedder]("GI.Gdk.Objects.Window#g:signal:toEmbedder") and
-- [Window::fromEmbedder]("GI.Gdk.Objects.Window#g:signal:fromEmbedder") signals on /@window@/.
-- 
-- /Since: 2.18/
offscreenWindowSetEmbedder ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> b
    -- ^ /@embedder@/: the t'GI.Gdk.Objects.Window.Window' that /@window@/ gets embedded in
    -> m ()
offscreenWindowSetEmbedder window embedder = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    embedder' <- unsafeManagedPtrCastPtr embedder
    gdk_offscreen_window_set_embedder window' embedder'
    touchManagedPtr window
    touchManagedPtr embedder
    return ()


-- function offscreen_window_get_surface
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_offscreen_window_get_surface" gdk_offscreen_window_get_surface :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Surface.Surface)

-- | Gets the offscreen surface that an offscreen window renders into.
-- If you need to keep this around over window resizes, you need to
-- add a reference to it.
offscreenWindowGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m (Maybe Cairo.Surface.Surface)
    -- ^ __Returns:__ The offscreen surface, or
    --   'P.Nothing' if not offscreen
offscreenWindowGetSurface window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_offscreen_window_get_surface window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.Surface.Surface) result'
        return result''
    touchManagedPtr window
    return maybeResult


-- function offscreen_window_get_embedder
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_offscreen_window_get_embedder" gdk_offscreen_window_get_embedder :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Gdk.Window.Window)

-- | Gets the window that /@window@/ is embedded in.
-- 
-- /Since: 2.18/
offscreenWindowGetEmbedder ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ the embedding t'GI.Gdk.Objects.Window.Window', or
    --     'P.Nothing' if /@window@/ is not an mbedded offscreen window
offscreenWindowGetEmbedder window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_offscreen_window_get_embedder window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr window
    return maybeResult


-- function notify_startup_complete_with_id
-- Args: [ Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a startup-notification identifier, for which\n    notification process should be completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_notify_startup_complete_with_id" gdk_notify_startup_complete_with_id :: 
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

-- | Indicates to the GUI environment that the application has
-- finished loading, using a given identifier.
-- 
-- GTK+ will call this function automatically for @/GtkWindow/@
-- with custom startup-notification identifier unless
-- @/gtk_window_set_auto_startup_notification()/@ is called to
-- disable that feature.
-- 
-- /Since: 2.12/
notifyStartupCompleteWithId ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@startupId@/: a startup-notification identifier, for which
    --     notification process should be completed
    -> m ()
notifyStartupCompleteWithId startupId = liftIO $ do
    startupId' <- textToCString startupId
    gdk_notify_startup_complete_with_id startupId'
    freeMem startupId'
    return ()


-- function notify_startup_complete
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_notify_startup_complete" gdk_notify_startup_complete :: 
    IO ()

-- | Indicates to the GUI environment that the application has finished
-- loading. If the applications opens windows, this function is
-- normally called after opening the application’s initial set of
-- windows.
-- 
-- GTK+ will call this function automatically after opening the first
-- @/GtkWindow/@ unless @/gtk_window_set_auto_startup_notification()/@ is called
-- to disable that feature.
-- 
-- /Since: 2.2/
notifyStartupComplete ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
notifyStartupComplete  = liftIO $ do
    gdk_notify_startup_complete
    return ()


-- function list_visuals
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Visual" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_list_visuals" gdk_list_visuals :: 
    IO (Ptr (GList (Ptr Gdk.Visual.Visual)))

{-# DEPRECATED listVisuals ["(Since version 3.22)","Use gdk_screen_list_visuals (gdk_screen_get_default ())."] #-}
-- | Lists the available visuals for the default screen.
-- (See 'GI.Gdk.Objects.Screen.screenListVisuals')
-- A visual describes a hardware image data format.
-- For example, a visual might support 24-bit color, or 8-bit color,
-- and might expect pixels to be in a certain format.
-- 
-- Call @/g_list_free()/@ on the return value when you’re finished with it.
listVisuals ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [Gdk.Visual.Visual]
    -- ^ __Returns:__ 
    --     a list of visuals; the list must be freed, but not its contents
listVisuals  = liftIO $ do
    result <- gdk_list_visuals
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Visual.Visual) result'
    g_list_free result
    return result''


-- function keyval_to_upper
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_upper" gdk_keyval_to_upper :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Converts a key value to upper case, if applicable.
keyvalToUpper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Word32
    -- ^ __Returns:__ the upper case form of /@keyval@/, or /@keyval@/ itself if it is already
    --   in upper case or it is not subject to case conversion.
keyvalToUpper keyval = liftIO $ do
    result <- gdk_keyval_to_upper keyval
    return result


-- function keyval_to_unicode
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a GDK key symbol" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_unicode" gdk_keyval_to_unicode :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Convert from a GDK key symbol to the corresponding ISO10646 (Unicode)
-- character.
keyvalToUnicode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a GDK key symbol
    -> m Word32
    -- ^ __Returns:__ the corresponding unicode character, or 0 if there
    --               is no corresponding character.
keyvalToUnicode keyval = liftIO $ do
    result <- gdk_keyval_to_unicode keyval
    return result


-- function keyval_to_lower
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_to_lower" gdk_keyval_to_lower :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO Word32

-- | Converts a key value to lower case, if applicable.
keyvalToLower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Word32
    -- ^ __Returns:__ the lower case form of /@keyval@/, or /@keyval@/ itself if it is already
    --  in lower case or it is not subject to case conversion.
keyvalToLower keyval = liftIO $ do
    result <- gdk_keyval_to_lower keyval
    return result


-- function keyval_name
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_name" gdk_keyval_name :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CString

-- | Converts a key value into a symbolic name.
-- 
-- The names are the same as those in the
-- @gdk\/gdkkeysyms.h@ header file
-- but without the leading “GDK_KEY_”.
keyvalName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing the name
    --     of the key, or 'P.Nothing' if /@keyval@/ is not a valid key. The string
    --     should not be modified.
keyvalName keyval = liftIO $ do
    result <- gdk_keyval_name keyval
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function keyval_is_upper
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_is_upper" gdk_keyval_is_upper :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CInt

-- | Returns 'P.True' if the given key value is in upper case.
keyvalIsUpper ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@keyval@/ is in upper case, or if /@keyval@/ is not subject to
    --  case conversion.
keyvalIsUpper keyval = liftIO $ do
    result <- gdk_keyval_is_upper keyval
    let result' = (/= 0) result
    return result'


-- function keyval_is_lower
-- Args: [ Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key value." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_is_lower" gdk_keyval_is_lower :: 
    Word32 ->                               -- keyval : TBasicType TUInt
    IO CInt

-- | Returns 'P.True' if the given key value is in lower case.
keyvalIsLower ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@keyval@/: a key value.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@keyval@/ is in lower case, or if /@keyval@/ is not
    --   subject to case conversion.
keyvalIsLower keyval = liftIO $ do
    result <- gdk_keyval_is_lower keyval
    let result' = (/= 0) result
    return result'


-- function keyval_from_name
-- Args: [ Arg
--           { argCName = "keyval_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_from_name" gdk_keyval_from_name :: 
    CString ->                              -- keyval_name : TBasicType TUTF8
    IO Word32

-- | Converts a key name to a key value.
-- 
-- The names are the same as those in the
-- @gdk\/gdkkeysyms.h@ header file
-- but without the leading “GDK_KEY_”.
keyvalFromName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@keyvalName@/: a key name
    -> m Word32
    -- ^ __Returns:__ the corresponding key value, or 'GI.Gdk.Constants.KEY_VoidSymbol'
    --     if the key name is not a valid key
keyvalFromName keyvalName = liftIO $ do
    keyvalName' <- textToCString keyvalName
    result <- gdk_keyval_from_name keyvalName'
    freeMem keyvalName'
    return result


-- function keyval_convert_case
-- Args: [ Arg
--           { argCName = "symbol"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keyval" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lower"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for lowercase version of @symbol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "upper"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for uppercase version of @symbol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyval_convert_case" gdk_keyval_convert_case :: 
    Word32 ->                               -- symbol : TBasicType TUInt
    Ptr Word32 ->                           -- lower : TBasicType TUInt
    Ptr Word32 ->                           -- upper : TBasicType TUInt
    IO ()

-- | Obtains the upper- and lower-case versions of the keyval /@symbol@/.
-- Examples of keyvals are 'GI.Gdk.Constants.KEY_a', @/GDK_KEY_Enter/@, 'GI.Gdk.Constants.KEY_F1', etc.
keyvalConvertCase ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@symbol@/: a keyval
    -> m ((Word32, Word32))
keyvalConvertCase symbol = liftIO $ do
    lower <- allocMem :: IO (Ptr Word32)
    upper <- allocMem :: IO (Ptr Word32)
    gdk_keyval_convert_case symbol lower upper
    lower' <- peek lower
    upper' <- peek upper
    freeMem lower
    freeMem upper
    return (lower', upper')


-- function keyboard_ungrab
-- Args: [ Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a timestamp from a #GdkEvent, or %GDK_CURRENT_TIME if no\n       timestamp is available."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyboard_ungrab" gdk_keyboard_ungrab :: 
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

{-# DEPRECATED keyboardUngrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceUngrab', together with 'GI.Gdk.Objects.Device.deviceGrab'","            instead."] #-}
-- | Ungrabs the keyboard on the default display, if it is grabbed by this
-- application.
keyboardUngrab ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@time_@/: a timestamp from a t'GI.Gdk.Unions.Event.Event', or 'GI.Gdk.Constants.CURRENT_TIME' if no
    --        timestamp is available.
    -> m ()
keyboardUngrab time_ = liftIO $ do
    gdk_keyboard_ungrab time_
    return ()


-- function keyboard_grab
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkWindow which will own the grab (the grab window)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %FALSE then all keyboard events are reported with respect to\n  @window. If %TRUE then keyboard events for this application are\n  reported as normal, but keyboard events outside this application\n  are reported with respect to @window. Both key press and key\n  release events are always reported, independant of the event mask\n  set by the application."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a timestamp from a #GdkEvent, or %GDK_CURRENT_TIME if no timestamp is\n  available."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GrabStatus" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_keyboard_grab" gdk_keyboard_grab :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CInt ->                                 -- owner_events : TBasicType TBoolean
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO CUInt

{-# DEPRECATED keyboardGrab ["(Since version 3.0)","Use 'GI.Gdk.Objects.Device.deviceGrab' instead."] #-}
-- | Grabs the keyboard so that all events are passed to this
-- application until the keyboard is ungrabbed with 'GI.Gdk.Functions.keyboardUngrab'.
-- This overrides any previous keyboard grab by this client.
-- 
-- If you set up anything at the time you take the grab that needs to be cleaned
-- up when the grab ends, you should handle the t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken' events that
-- are emitted when the grab ends unvoluntarily.
keyboardGrab ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' which will own the grab (the grab window).
    -> Bool
    -- ^ /@ownerEvents@/: if 'P.False' then all keyboard events are reported with respect to
    --   /@window@/. If 'P.True' then keyboard events for this application are
    --   reported as normal, but keyboard events outside this application
    --   are reported with respect to /@window@/. Both key press and key
    --   release events are always reported, independant of the event mask
    --   set by the application.
    -> Word32
    -- ^ /@time_@/: a timestamp from a t'GI.Gdk.Unions.Event.Event', or 'GI.Gdk.Constants.CURRENT_TIME' if no timestamp is
    --   available.
    -> m Gdk.Enums.GrabStatus
    -- ^ __Returns:__ 'GI.Gdk.Enums.GrabStatusSuccess' if the grab was successful.
keyboardGrab window ownerEvents time_ = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let ownerEvents' = (P.fromIntegral . P.fromEnum) ownerEvents
    result <- gdk_keyboard_grab window' ownerEvents' time_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr window
    return result'


-- function init_check
-- Args: [ Arg
--           { argCName = "argc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray False (-1) 0 (TBasicType TUTF8)
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the array of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "argc"
--              , argType = TBasicType TInt
--              , direction = DirectionInout
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of command line arguments."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_init_check" gdk_init_check :: 
    Ptr Int32 ->                            -- argc : TBasicType TInt
    Ptr (Ptr CString) ->                    -- argv : TCArray False (-1) 0 (TBasicType TUTF8)
    IO CInt

-- | Initializes the GDK library and connects to the windowing system,
-- returning 'P.True' on success.
-- 
-- Any arguments used by GDK are removed from the array and /@argc@/ and /@argv@/
-- are updated accordingly.
-- 
-- GTK+ initializes GDK in @/gtk_init()/@ and so this function is not usually
-- needed by GTK+ applications.
initCheck ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@argv@/: the array of command line arguments.
    -> m ((Bool, [T.Text]))
    -- ^ __Returns:__ 'P.True' if initialization succeeded.
initCheck argv = liftIO $ do
    let argc = fromIntegral $ P.length argv
    argc' <- allocMem :: IO (Ptr Int32)
    poke argc' argc
    argv' <- packUTF8CArray argv
    argv'' <- allocMem :: IO (Ptr (Ptr CString))
    poke argv'' argv'
    result <- gdk_init_check argc' argv''
    argc'' <- peek argc'
    let result' = (/= 0) result
    argv''' <- peek argv''
    argv'''' <- (unpackUTF8CArrayWithLength argc'') argv'''
    (mapCArrayWithLength argc'') freeMem argv'''
    freeMem argv'''
    freeMem argc'
    freeMem argv''
    return (result', argv'''')


-- function init
-- Args: [ Arg
--           { argCName = "argc"
--           , argType = TBasicType TInt
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "argv"
--           , argType = TCArray False (-1) 0 (TBasicType TUTF8)
--           , direction = DirectionInout
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the array of command line arguments."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "argc"
--              , argType = TBasicType TInt
--              , direction = DirectionInout
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of command line arguments."
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_init" gdk_init :: 
    Ptr Int32 ->                            -- argc : TBasicType TInt
    Ptr (Ptr CString) ->                    -- argv : TCArray False (-1) 0 (TBasicType TUTF8)
    IO ()

-- | Initializes the GDK library and connects to the windowing system.
-- If initialization fails, a warning message is output and the application
-- terminates with a call to @exit(1)@.
-- 
-- Any arguments used by GDK are removed from the array and /@argc@/ and /@argv@/
-- are updated accordingly.
-- 
-- GTK+ initializes GDK in @/gtk_init()/@ and so this function is not usually
-- needed by GTK+ applications.
init ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [T.Text]
    -- ^ /@argv@/: the array of command line arguments.
    -> m ([T.Text])
init argv = liftIO $ do
    let argc = fromIntegral $ P.length argv
    argc' <- allocMem :: IO (Ptr Int32)
    poke argc' argc
    argv' <- packUTF8CArray argv
    argv'' <- allocMem :: IO (Ptr (Ptr CString))
    poke argv'' argv'
    gdk_init argc' argv''
    argc'' <- peek argc'
    argv''' <- peek argv''
    argv'''' <- (unpackUTF8CArrayWithLength argc'') argv'''
    (mapCArrayWithLength argc'') freeMem argv'''
    freeMem argv'''
    freeMem argc'
    freeMem argv''
    return argv''''


-- function get_show_events
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_get_show_events" gdk_get_show_events :: 
    IO CInt

-- | Gets whether event debugging output is enabled.
getShowEvents ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ 'P.True' if event debugging output is enabled.
getShowEvents  = liftIO $ do
    result <- gdk_get_show_events
    let result' = (/= 0) result
    return result'


-- function get_program_class
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_get_program_class" gdk_get_program_class :: 
    IO CString

-- | Gets the program class. Unless the program class has explicitly
-- been set with 'GI.Gdk.Functions.setProgramClass' or with the @--class@
-- commandline option, the default value is the program name (determined
-- with 'GI.GLib.Functions.getPrgname') with the first character converted to uppercase.
getProgramClass ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ the program class.
getProgramClass  = liftIO $ do
    result <- gdk_get_program_class
    checkUnexpectedReturnNULL "getProgramClass" result
    result' <- cstringToText result
    return result'


-- function get_display_arg_name
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_get_display_arg_name" gdk_get_display_arg_name :: 
    IO CString

-- | Gets the display name specified in the command line arguments passed
-- to 'GI.Gdk.Functions.init' or 'GI.Gdk.Functions.parseArgs', if any.
-- 
-- /Since: 2.2/
getDisplayArgName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe T.Text)
    -- ^ __Returns:__ the display name, if specified explicitly,
    --   otherwise 'P.Nothing' this string is owned by GTK+ and must not be
    --   modified or freed.
getDisplayArgName  = liftIO $ do
    result <- gdk_get_display_arg_name
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    return maybeResult


-- function get_display
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_get_display" gdk_get_display :: 
    IO CString

{-# DEPRECATED getDisplay ["(Since version 3.8)","Call gdk_display_get_name (gdk_display_get_default ()))","   instead."] #-}
-- | Gets the name of the display, which usually comes from the
-- @DISPLAY@ environment variable or the
-- @--display@ command line option.
getDisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ the name of the display.
getDisplay  = liftIO $ do
    result <- gdk_get_display
    checkUnexpectedReturnNULL "getDisplay" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function get_default_root_window
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_get_default_root_window" gdk_get_default_root_window :: 
    IO (Ptr Gdk.Window.Window)

-- | Obtains the root window (parent all other windows are inside)
-- for the default display and screen.
getDefaultRootWindow ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Gdk.Window.Window
    -- ^ __Returns:__ the default root window
getDefaultRootWindow  = liftIO $ do
    result <- gdk_get_default_root_window
    checkUnexpectedReturnNULL "getDefaultRootWindow" result
    result' <- (newObject Gdk.Window.Window) result
    return result'


-- function flush
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_flush" gdk_flush :: 
    IO ()

-- | Flushes the output buffers of all display connections and waits
-- until all requests have been processed.
-- This is rarely needed by applications.
flush ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
flush  = liftIO $ do
    gdk_flush
    return ()


-- function events_pending
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_pending" gdk_events_pending :: 
    IO CInt

-- | Checks if any events are ready to be processed for any display.
eventsPending ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ 'P.True' if any events are pending.
eventsPending  = liftIO $ do
    result <- gdk_events_pending
    let result' = (/= 0) result
    return result'


-- function events_get_distance
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "distance"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the distance"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_distance" gdk_events_get_distance :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- distance : TBasicType TDouble
    IO CInt

-- | If both events have X\/Y information, the distance between both coordinates
-- (as in a straight line going from /@event1@/ to /@event2@/) will be returned.
-- 
-- /Since: 3.0/
eventsGetDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Event.Event
    -- ^ /@event1@/: first t'GI.Gdk.Unions.Event.Event'
    -> Gdk.Event.Event
    -- ^ /@event2@/: second t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the distance could be calculated.
eventsGetDistance event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrGetPtr event1
    event2' <- unsafeManagedPtrGetPtr event2
    distance <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_distance event1' event2' distance
    let result' = (/= 0) result
    distance' <- peek distance
    let distance'' = realToFrac distance'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem distance
    return (result', distance'')


-- function events_get_center
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the X coordinate of the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the Y coordinate of the center"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_center" gdk_events_get_center :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO CInt

-- | If both events contain X\/Y information, the center of both coordinates
-- will be returned in /@x@/ and /@y@/.
-- 
-- /Since: 3.0/
eventsGetCenter ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Event.Event
    -- ^ /@event1@/: first t'GI.Gdk.Unions.Event.Event'
    -> Gdk.Event.Event
    -- ^ /@event2@/: second t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double, Double))
    -- ^ __Returns:__ 'P.True' if the center could be calculated.
eventsGetCenter event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrGetPtr event1
    event2' <- unsafeManagedPtrGetPtr event2
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_center event1' event2' x y
    let result' = (/= 0) result
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem x
    freeMem y
    return (result', x'', y'')


-- function events_get_angle
-- Args: [ Arg
--           { argCName = "event1"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event2"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second #GdkEvent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "angle"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the relative angle between both events"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_events_get_angle" gdk_events_get_angle :: 
    Ptr Gdk.Event.Event ->                  -- event1 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr Gdk.Event.Event ->                  -- event2 : TInterface (Name {namespace = "Gdk", name = "Event"})
    Ptr CDouble ->                          -- angle : TBasicType TDouble
    IO CInt

-- | If both events contain X\/Y information, this function will return 'P.True'
-- and return in /@angle@/ the relative angle from /@event1@/ to /@event2@/. The rotation
-- direction for positive angles is from the positive X axis towards the positive
-- Y axis.
-- 
-- /Since: 3.0/
eventsGetAngle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.Event.Event
    -- ^ /@event1@/: first t'GI.Gdk.Unions.Event.Event'
    -> Gdk.Event.Event
    -- ^ /@event2@/: second t'GI.Gdk.Unions.Event.Event'
    -> m ((Bool, Double))
    -- ^ __Returns:__ 'P.True' if the angle could be calculated.
eventsGetAngle event1 event2 = liftIO $ do
    event1' <- unsafeManagedPtrGetPtr event1
    event2' <- unsafeManagedPtrGetPtr event2
    angle <- allocMem :: IO (Ptr CDouble)
    result <- gdk_events_get_angle event1' event2' angle
    let result' = (/= 0) result
    angle' <- peek angle
    let angle'' = realToFrac angle'
    touchManagedPtr event1
    touchManagedPtr event2
    freeMem angle
    return (result', angle'')


-- function error_trap_push
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_error_trap_push" gdk_error_trap_push :: 
    IO ()

-- | This function allows X errors to be trapped instead of the normal
-- behavior of exiting the application. It should only be used if it
-- is not possible to avoid the X error in any other way. Errors are
-- ignored on all t'GI.Gdk.Objects.Display.Display' currently known to the
-- t'GI.Gdk.Objects.DisplayManager.DisplayManager'. If you don’t care which error happens and just
-- want to ignore everything, pop with 'GI.Gdk.Functions.errorTrapPopIgnored'.
-- If you need the error code, use 'GI.Gdk.Functions.errorTrapPop' which may have
-- to block and wait for the error to arrive from the X server.
-- 
-- This API exists on all platforms but only does anything on X.
-- 
-- You can use @/gdk_x11_display_error_trap_push()/@ to ignore errors
-- on only a single display.
-- 
-- == Trapping an X error
-- 
-- 
-- === /C code/
-- >
-- >gdk_error_trap_push ();
-- >
-- > // ... Call the X function which may cause an error here ...
-- >
-- >
-- >if (gdk_error_trap_pop ())
-- > {
-- >   // ... Handle the error here ...
-- > }
errorTrapPush ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
errorTrapPush  = liftIO $ do
    gdk_error_trap_push
    return ()


-- function error_trap_pop_ignored
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_error_trap_pop_ignored" gdk_error_trap_pop_ignored :: 
    IO ()

-- | Removes an error trap pushed with 'GI.Gdk.Functions.errorTrapPush', but
-- without bothering to wait and see whether an error occurred.  If an
-- error arrives later asynchronously that was triggered while the
-- trap was pushed, that error will be ignored.
-- 
-- /Since: 3.0/
errorTrapPopIgnored ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
errorTrapPopIgnored  = liftIO $ do
    gdk_error_trap_pop_ignored
    return ()


-- function error_trap_pop
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_error_trap_pop" gdk_error_trap_pop :: 
    IO Int32

-- | Removes an error trap pushed with 'GI.Gdk.Functions.errorTrapPush'.
-- May block until an error has been definitively received
-- or not received from the X server. 'GI.Gdk.Functions.errorTrapPopIgnored'
-- is preferred if you don’t need to know whether an error
-- occurred, because it never has to block. If you don\'t
-- need the return value of 'GI.Gdk.Functions.errorTrapPop', use
-- 'GI.Gdk.Functions.errorTrapPopIgnored'.
-- 
-- Prior to GDK 3.0, this function would not automatically
-- sync for you, so you had to 'GI.Gdk.Functions.flush' if your last
-- call to Xlib was not a blocking round trip.
errorTrapPop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Int32
    -- ^ __Returns:__ X error code or 0 on success
errorTrapPop  = liftIO $ do
    result <- gdk_error_trap_pop
    return result


-- function drop_reply
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accepted"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the drop is accepted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_reply" gdk_drop_reply :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    CInt ->                                 -- accepted : TBasicType TBoolean
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Accepts or rejects a drop.
-- 
-- This function is called by the drag destination in response
-- to a drop initiated by the drag source.
dropReply ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Bool
    -- ^ /@accepted@/: 'P.True' if the drop is accepted
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m ()
dropReply context accepted time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let accepted' = (P.fromIntegral . P.fromEnum) accepted
    gdk_drop_reply context' accepted' time_
    touchManagedPtr context
    return ()


-- function drop_finish
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "success"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the data was successfully received"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_finish" gdk_drop_finish :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    CInt ->                                 -- success : TBasicType TBoolean
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Ends the drag operation after a drop.
-- 
-- This function is called by the drag destination.
dropFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Bool
    -- ^ /@success@/: 'P.True' if the data was successfully received
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m ()
dropFinish context success time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let success' = (P.fromIntegral . P.fromEnum) success
    gdk_drop_finish context' success' time_
    touchManagedPtr context
    return ()


-- function drag_status
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the selected action which will be taken when a drop happens,\n   or 0 to indicate that a drop will not be accepted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_status" gdk_drag_status :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    CUInt ->                                -- action : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Selects one of the actions offered by the drag source.
-- 
-- This function is called by the drag destination in response to
-- 'GI.Gdk.Functions.dragMotion' called by the drag source.
dragStatus ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> [Gdk.Flags.DragAction]
    -- ^ /@action@/: the selected action which will be taken when a drop happens,
    --    or 0 to indicate that a drop will not be accepted
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m ()
dragStatus context action time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let action' = gflagsToWord action
    gdk_drag_status context' action' time_
    touchManagedPtr context
    return ()


-- function drag_motion
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new destination window, obtained by\n    gdk_drag_find_window()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragProtocol" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the DND protocol in use, obtained by gdk_drag_find_window()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the x position of the pointer in root coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the y position of the pointer in root coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "suggested_action"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the suggested action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "possible_actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the possible actions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_motion" gdk_drag_motion :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Ptr Gdk.Window.Window ->                -- dest_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- protocol : TInterface (Name {namespace = "Gdk", name = "DragProtocol"})
    Int32 ->                                -- x_root : TBasicType TInt
    Int32 ->                                -- y_root : TBasicType TInt
    CUInt ->                                -- suggested_action : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    CUInt ->                                -- possible_actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO CInt

-- | Updates the drag context when the pointer moves or the
-- set of actions changes.
-- 
-- This function is called by the drag source.
-- 
-- This function does not need to be called in managed drag and drop
-- operations. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd' for more information.
dragMotion ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> b
    -- ^ /@destWindow@/: the new destination window, obtained by
    --     @/gdk_drag_find_window()/@
    -> Gdk.Enums.DragProtocol
    -- ^ /@protocol@/: the DND protocol in use, obtained by @/gdk_drag_find_window()/@
    -> Int32
    -- ^ /@xRoot@/: the x position of the pointer in root coordinates
    -> Int32
    -- ^ /@yRoot@/: the y position of the pointer in root coordinates
    -> [Gdk.Flags.DragAction]
    -- ^ /@suggestedAction@/: the suggested action
    -> [Gdk.Flags.DragAction]
    -- ^ /@possibleActions@/: the possible actions
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m Bool
dragMotion context destWindow protocol xRoot yRoot suggestedAction possibleActions time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    destWindow' <- unsafeManagedPtrCastPtr destWindow
    let protocol' = (fromIntegral . fromEnum) protocol
    let suggestedAction' = gflagsToWord suggestedAction
    let possibleActions' = gflagsToWord possibleActions
    result <- gdk_drag_motion context' destWindow' protocol' xRoot yRoot suggestedAction' possibleActions' time_
    let result' = (/= 0) result
    touchManagedPtr context
    touchManagedPtr destWindow
    return result'


-- function drag_get_selection
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Atom" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_get_selection" gdk_drag_get_selection :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr Gdk.Atom.Atom)

-- | Returns the selection atom for the current source window.
dragGetSelection ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'.
    -> m Gdk.Atom.Atom
    -- ^ __Returns:__ the selection atom, or @/GDK_NONE/@
dragGetSelection context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_get_selection context'
    checkUnexpectedReturnNULL "dragGetSelection" result
    result' <- (newPtr Gdk.Atom.Atom) result
    touchManagedPtr context
    return result'


-- function drag_find_window_for_screen
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "drag_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a window which may be at the pointer position, but\n    should be ignored, since it is put up by the drag source as an icon"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the screen where the destination window is sought"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the x position of the pointer in root coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the y position of the pointer in root coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the destination window in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragProtocol" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the DND protocol in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_find_window_for_screen" gdk_drag_find_window_for_screen :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Ptr Gdk.Window.Window ->                -- drag_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Screen.Screen ->                -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- x_root : TBasicType TInt
    Int32 ->                                -- y_root : TBasicType TInt
    Ptr (Ptr Gdk.Window.Window) ->          -- dest_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr CUInt ->                            -- protocol : TInterface (Name {namespace = "Gdk", name = "DragProtocol"})
    IO ()

-- | Finds the destination window and DND protocol to use at the
-- given pointer position.
-- 
-- This function is called by the drag source to obtain the
-- /@destWindow@/ and /@protocol@/ parameters for 'GI.Gdk.Functions.dragMotion'.
-- 
-- /Since: 2.2/
dragFindWindowForScreen ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a, Gdk.Window.IsWindow b, Gdk.Screen.IsScreen c) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> b
    -- ^ /@dragWindow@/: a window which may be at the pointer position, but
    --     should be ignored, since it is put up by the drag source as an icon
    -> c
    -- ^ /@screen@/: the screen where the destination window is sought
    -> Int32
    -- ^ /@xRoot@/: the x position of the pointer in root coordinates
    -> Int32
    -- ^ /@yRoot@/: the y position of the pointer in root coordinates
    -> m ((Gdk.Window.Window, Gdk.Enums.DragProtocol))
dragFindWindowForScreen context dragWindow screen xRoot yRoot = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    dragWindow' <- unsafeManagedPtrCastPtr dragWindow
    screen' <- unsafeManagedPtrCastPtr screen
    destWindow <- callocMem :: IO (Ptr (Ptr Gdk.Window.Window))
    protocol <- allocMem :: IO (Ptr CUInt)
    gdk_drag_find_window_for_screen context' dragWindow' screen' xRoot yRoot destWindow protocol
    destWindow' <- peek destWindow
    destWindow'' <- (wrapObject Gdk.Window.Window) destWindow'
    protocol' <- peek protocol
    let protocol'' = (toEnum . fromIntegral) protocol'
    touchManagedPtr context
    touchManagedPtr dragWindow
    touchManagedPtr screen
    freeMem destWindow
    freeMem protocol
    return (destWindow'', protocol'')


-- function drag_drop_succeeded
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_drop_succeeded" gdk_drag_drop_succeeded :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO CInt

-- | Returns whether the dropped data has been successfully
-- transferred. This function is intended to be used while
-- handling a 'GI.Gdk.Enums.EventTypeDropFinished' event, its return value is
-- meaningless at other times.
-- 
-- /Since: 2.6/
dragDropSucceeded ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the drop was successful.
dragDropSucceeded context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_drop_succeeded context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'


-- function drag_drop_done
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "success"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the drag was ultimatively successful"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_drop_done" gdk_drag_drop_done :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    CInt ->                                 -- success : TBasicType TBoolean
    IO ()

-- | Inform GDK if the drop ended successfully. Passing 'P.False'
-- for /@success@/ may trigger a drag cancellation animation.
-- 
-- This function is called by the drag source, and should
-- be the last call before dropping the reference to the
-- /@context@/.
-- 
-- The t'GI.Gdk.Objects.DragContext.DragContext' will only take the first 'GI.Gdk.Functions.dragDropDone'
-- call as effective, if this function is called multiple times,
-- all subsequent calls will be ignored.
-- 
-- /Since: 3.20/
dragDropDone ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Bool
    -- ^ /@success@/: whether the drag was ultimatively successful
    -> m ()
dragDropDone context success = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let success' = (P.fromIntegral . P.fromEnum) success
    gdk_drag_drop_done context' success'
    touchManagedPtr context
    return ()


-- function drag_drop
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_drop" gdk_drag_drop :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Drops on the current destination.
-- 
-- This function is called by the drag source.
-- 
-- This function does not need to be called in managed drag and drop
-- operations. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd' for more information.
dragDrop ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m ()
dragDrop context time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_drag_drop context' time_
    touchManagedPtr context
    return ()


-- function drag_begin_from_point
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source window for this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device that controls this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "targets"
--           , argType =
--               TGList (TInterface Name { namespace = "Gdk" , name = "Atom" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the offered targets,\n    as list of #GdkAtoms"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the x coordinate where the drag nominally started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y_root"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the y coordinate where the drag nominally started"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_begin_from_point" gdk_drag_begin_from_point :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr (GList (Ptr Gdk.Atom.Atom)) ->      -- targets : TGList (TInterface (Name {namespace = "Gdk", name = "Atom"}))
    Int32 ->                                -- x_root : TBasicType TInt
    Int32 ->                                -- y_root : TBasicType TInt
    IO (Ptr Gdk.DragContext.DragContext)

-- | Starts a drag and creates a new drag context for it.
-- 
-- This function is called by the drag source.
-- 
-- /Since: 3.20/
dragBeginFromPoint ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: the source window for this drag
    -> b
    -- ^ /@device@/: the device that controls this drag
    -> [Gdk.Atom.Atom]
    -- ^ /@targets@/: the offered targets,
    --     as list of @/GdkAtoms/@
    -> Int32
    -- ^ /@xRoot@/: the x coordinate where the drag nominally started
    -> Int32
    -- ^ /@yRoot@/: the y coordinate where the drag nominally started
    -> m Gdk.DragContext.DragContext
    -- ^ __Returns:__ a newly created t'GI.Gdk.Objects.DragContext.DragContext'
dragBeginFromPoint window device targets xRoot yRoot = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    targets' <- mapM unsafeManagedPtrGetPtr targets
    targets'' <- packGList targets'
    result <- gdk_drag_begin_from_point window' device' targets'' xRoot yRoot
    checkUnexpectedReturnNULL "dragBeginFromPoint" result
    result' <- (wrapObject Gdk.DragContext.DragContext) result
    touchManagedPtr window
    touchManagedPtr device
    mapM_ touchManagedPtr targets
    g_list_free targets''
    return result'


-- function drag_begin_for_device
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source window for this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device that controls this drag"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "targets"
--           , argType =
--               TGList (TInterface Name { namespace = "Gdk" , name = "Atom" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the offered targets,\n    as list of #GdkAtoms"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_begin_for_device" gdk_drag_begin_for_device :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr (GList (Ptr Gdk.Atom.Atom)) ->      -- targets : TGList (TInterface (Name {namespace = "Gdk", name = "Atom"}))
    IO (Ptr Gdk.DragContext.DragContext)

-- | Starts a drag and creates a new drag context for it.
-- 
-- This function is called by the drag source.
dragBeginForDevice ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@window@/: the source window for this drag
    -> b
    -- ^ /@device@/: the device that controls this drag
    -> [Gdk.Atom.Atom]
    -- ^ /@targets@/: the offered targets,
    --     as list of @/GdkAtoms/@
    -> m Gdk.DragContext.DragContext
    -- ^ __Returns:__ a newly created t'GI.Gdk.Objects.DragContext.DragContext'
dragBeginForDevice window device targets = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    device' <- unsafeManagedPtrCastPtr device
    targets' <- mapM unsafeManagedPtrGetPtr targets
    targets'' <- packGList targets'
    result <- gdk_drag_begin_for_device window' device' targets''
    checkUnexpectedReturnNULL "dragBeginForDevice" result
    result' <- (wrapObject Gdk.DragContext.DragContext) result
    touchManagedPtr window
    touchManagedPtr device
    mapM_ touchManagedPtr targets
    g_list_free targets''
    return result'


-- function drag_begin
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the source window for this drag."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "targets"
--           , argType =
--               TGList (TInterface Name { namespace = "Gdk" , name = "Atom" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the offered targets,\n    as list of #GdkAtoms"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_begin" gdk_drag_begin :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr (GList (Ptr Gdk.Atom.Atom)) ->      -- targets : TGList (TInterface (Name {namespace = "Gdk", name = "Atom"}))
    IO (Ptr Gdk.DragContext.DragContext)

-- | Starts a drag and creates a new drag context for it.
-- This function assumes that the drag is controlled by the
-- client pointer device, use 'GI.Gdk.Functions.dragBeginForDevice' to
-- begin a drag with a different device.
-- 
-- This function is called by the drag source.
dragBegin ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: the source window for this drag.
    -> [Gdk.Atom.Atom]
    -- ^ /@targets@/: the offered targets,
    --     as list of @/GdkAtoms/@
    -> m Gdk.DragContext.DragContext
    -- ^ __Returns:__ a newly created t'GI.Gdk.Objects.DragContext.DragContext'
dragBegin window targets = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    targets' <- mapM unsafeManagedPtrGetPtr targets
    targets'' <- packGList targets'
    result <- gdk_drag_begin window' targets''
    checkUnexpectedReturnNULL "dragBegin" result
    result' <- (wrapObject Gdk.DragContext.DragContext) result
    touchManagedPtr window
    mapM_ touchManagedPtr targets
    g_list_free targets''
    return result'


-- function drag_abort
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timestamp for this operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_abort" gdk_drag_abort :: 
    Ptr Gdk.DragContext.DragContext ->      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

-- | Aborts a drag without dropping.
-- 
-- This function is called by the drag source.
-- 
-- This function does not need to be called in managed drag and drop
-- operations. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd' for more information.
dragAbort ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.DragContext.IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Word32
    -- ^ /@time_@/: the timestamp for this operation
    -> m ()
dragAbort context time_ = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_drag_abort context' time_
    touchManagedPtr context
    return ()


-- function disable_multidevice
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_disable_multidevice" gdk_disable_multidevice :: 
    IO ()

-- | Disables multidevice support in GDK. This call must happen prior
-- to 'GI.Gdk.Objects.Display.displayOpen', @/gtk_init()/@, @/gtk_init_with_args()/@ or
-- @/gtk_init_check()/@ in order to take effect.
-- 
-- Most common GTK+ applications won’t ever need to call this. Only
-- applications that do mixed GDK\/Xlib calls could want to disable
-- multidevice support if such Xlib code deals with input devices in
-- any way and doesn’t observe the presence of XInput 2.
-- 
-- /Since: 3.0/
disableMultidevice ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
disableMultidevice  = liftIO $ do
    gdk_disable_multidevice
    return ()


-- function cairo_surface_create_from_pixbuf
-- Args: [ Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbuf" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the scale of the new surface, or 0 to use same as @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "for_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The window this will be drawn to, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_surface_create_from_pixbuf" gdk_cairo_surface_create_from_pixbuf :: 
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    Int32 ->                                -- scale : TBasicType TInt
    Ptr Gdk.Window.Window ->                -- for_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Surface.Surface)

-- | Creates an image surface with the same contents as
-- the pixbuf.
-- 
-- /Since: 3.10/
cairoSurfaceCreateFromPixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@pixbuf@/: a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'
    -> Int32
    -- ^ /@scale@/: the scale of the new surface, or 0 to use same as /@window@/
    -> Maybe (b)
    -- ^ /@forWindow@/: The window this will be drawn to, or 'P.Nothing'
    -> m Cairo.Surface.Surface
    -- ^ __Returns:__ a new cairo surface, must be freed with @/cairo_surface_destroy()/@
cairoSurfaceCreateFromPixbuf pixbuf scale forWindow = liftIO $ do
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    maybeForWindow <- case forWindow of
        Nothing -> return nullPtr
        Just jForWindow -> do
            jForWindow' <- unsafeManagedPtrCastPtr jForWindow
            return jForWindow'
    result <- gdk_cairo_surface_create_from_pixbuf pixbuf' scale maybeForWindow
    checkUnexpectedReturnNULL "cairoSurfaceCreateFromPixbuf" result
    result' <- (wrapBoxed Cairo.Surface.Surface) result
    touchManagedPtr pixbuf
    whenJust forWindow touchManagedPtr
    return result'


-- function cairo_set_source_window
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "X coordinate of location to place upper left corner of @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Y coordinate of location to place upper left corner of @window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_window" gdk_cairo_set_source_window :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CDouble ->                              -- x : TBasicType TDouble
    CDouble ->                              -- y : TBasicType TDouble
    IO ()

-- | Sets the given window as the source pattern for /@cr@/.
-- 
-- The pattern has an extend mode of 'GI.Cairo.Enums.ExtendNone' and is aligned
-- so that the origin of /@window@/ is /@x@/, /@y@/. The window contains all its
-- subwindows when rendering.
-- 
-- Note that the contents of /@window@/ are undefined outside of the
-- visible part of /@window@/, so use this function with care.
-- 
-- /Since: 2.24/
cairoSetSourceWindow ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Double
    -- ^ /@x@/: X coordinate of location to place upper left corner of /@window@/
    -> Double
    -- ^ /@y@/: Y coordinate of location to place upper left corner of /@window@/
    -> m ()
cairoSetSourceWindow cr window x y = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    window' <- unsafeManagedPtrCastPtr window
    let x' = realToFrac x
    let y' = realToFrac y
    gdk_cairo_set_source_window cr' window' x' y'
    touchManagedPtr cr
    touchManagedPtr window
    return ()


-- function cairo_set_source_rgba
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rgba"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkRGBA" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_rgba" gdk_cairo_set_source_rgba :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.RGBA.RGBA ->                    -- rgba : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO ()

-- | Sets the specified t'GI.Gdk.Structs.RGBA.RGBA' as the source color of /@cr@/.
-- 
-- /Since: 3.0/
cairoSetSourceRgba ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Gdk.RGBA.RGBA
    -- ^ /@rgba@/: a t'GI.Gdk.Structs.RGBA.RGBA'
    -> m ()
cairoSetSourceRgba cr rgba = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    rgba' <- unsafeManagedPtrGetPtr rgba
    gdk_cairo_set_source_rgba cr' rgba'
    touchManagedPtr cr
    touchManagedPtr rgba
    return ()


-- function cairo_set_source_pixbuf
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbuf" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "X coordinate of location to place upper left corner of @pixbuf"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Y coordinate of location to place upper left corner of @pixbuf"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_pixbuf" gdk_cairo_set_source_pixbuf :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    CDouble ->                              -- pixbuf_x : TBasicType TDouble
    CDouble ->                              -- pixbuf_y : TBasicType TDouble
    IO ()

-- | Sets the given pixbuf as the source pattern for /@cr@/.
-- 
-- The pattern has an extend mode of 'GI.Cairo.Enums.ExtendNone' and is aligned
-- so that the origin of /@pixbuf@/ is /@pixbufX@/, /@pixbufY@/.
-- 
-- /Since: 2.8/
cairoSetSourcePixbuf ::
    (B.CallStack.HasCallStack, MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> a
    -- ^ /@pixbuf@/: a t'GI.GdkPixbuf.Objects.Pixbuf.Pixbuf'
    -> Double
    -- ^ /@pixbufX@/: X coordinate of location to place upper left corner of /@pixbuf@/
    -> Double
    -- ^ /@pixbufY@/: Y coordinate of location to place upper left corner of /@pixbuf@/
    -> m ()
cairoSetSourcePixbuf cr pixbuf pixbufX pixbufY = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    let pixbufX' = realToFrac pixbufX
    let pixbufY' = realToFrac pixbufY
    gdk_cairo_set_source_pixbuf cr' pixbuf' pixbufX' pixbufY'
    touchManagedPtr cr
    touchManagedPtr pixbuf
    return ()


-- function cairo_set_source_color
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Color" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkColor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_set_source_color" gdk_cairo_set_source_color :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Color.Color ->                  -- color : TInterface (Name {namespace = "Gdk", name = "Color"})
    IO ()

{-# DEPRECATED cairoSetSourceColor ["(Since version 3.4)","Use 'GI.Gdk.Functions.cairoSetSourceRgba' instead"] #-}
-- | Sets the specified t'GI.Gdk.Structs.Color.Color' as the source color of /@cr@/.
-- 
-- /Since: 2.8/
cairoSetSourceColor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Gdk.Color.Color
    -- ^ /@color@/: a t'GI.Gdk.Structs.Color.Color'
    -> m ()
cairoSetSourceColor cr color = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    color' <- unsafeManagedPtrGetPtr color
    gdk_cairo_set_source_color cr' color'
    touchManagedPtr cr
    touchManagedPtr color
    return ()


-- function cairo_region_create_from_surface
-- Args: [ Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo surface" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_region_create_from_surface" gdk_cairo_region_create_from_surface :: 
    Ptr Cairo.Surface.Surface ->            -- surface : TInterface (Name {namespace = "cairo", name = "Surface"})
    IO (Ptr Cairo.Region.Region)

-- | Creates region that describes covers the area where the given
-- /@surface@/ is more than 50% opaque.
-- 
-- This function takes into account device offsets that might be
-- set with @/cairo_surface_set_device_offset()/@.
cairoRegionCreateFromSurface ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Surface.Surface
    -- ^ /@surface@/: a cairo surface
    -> m Cairo.Region.Region
    -- ^ __Returns:__ A t'GI.Cairo.Structs.Region.Region'; must be freed with @/cairo_region_destroy()/@
cairoRegionCreateFromSurface surface = liftIO $ do
    surface' <- unsafeManagedPtrGetPtr surface
    result <- gdk_cairo_region_create_from_surface surface'
    checkUnexpectedReturnNULL "cairoRegionCreateFromSurface" result
    result' <- (wrapBoxed Cairo.Region.Region) result
    touchManagedPtr surface
    return result'


-- function cairo_region
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #cairo_region_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_region" gdk_cairo_region :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

-- | Adds the given region to the current path of /@cr@/.
-- 
-- /Since: 2.8/
cairoRegion ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Cairo.Region.Region
    -- ^ /@region@/: a t'GI.Cairo.Structs.Region.Region'
    -> m ()
cairoRegion cr region = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    region' <- unsafeManagedPtrGetPtr region
    gdk_cairo_region cr' region'
    touchManagedPtr cr
    touchManagedPtr region
    return ()


-- function cairo_rectangle
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rectangle"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkRectangle" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_rectangle" gdk_cairo_rectangle :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rectangle : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Adds the given rectangle to the current path of /@cr@/.
-- 
-- /Since: 2.8/
cairoRectangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> Gdk.Rectangle.Rectangle
    -- ^ /@rectangle@/: a t'GI.Gdk.Structs.Rectangle.Rectangle'
    -> m ()
cairoRectangle cr rectangle = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    rectangle' <- unsafeManagedPtrGetPtr rectangle
    gdk_cairo_rectangle cr' rectangle'
    touchManagedPtr cr
    touchManagedPtr rectangle
    return ()


-- function cairo_get_drawing_context
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a Cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DrawingContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_get_drawing_context" gdk_cairo_get_drawing_context :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    IO (Ptr Gdk.DrawingContext.DrawingContext)

-- | Retrieves the t'GI.Gdk.Objects.DrawingContext.DrawingContext' that created the Cairo
-- context /@cr@/.
-- 
-- /Since: 3.22/
cairoGetDrawingContext ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a Cairo context
    -> m (Maybe Gdk.DrawingContext.DrawingContext)
    -- ^ __Returns:__ a t'GI.Gdk.Objects.DrawingContext.DrawingContext', if any is set
cairoGetDrawingContext cr = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    result <- gdk_cairo_get_drawing_context cr'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.DrawingContext.DrawingContext) result'
        return result''
    touchManagedPtr cr
    return maybeResult


-- function cairo_get_clip_rectangle
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the clip, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_get_clip_rectangle" gdk_cairo_get_clip_rectangle :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO CInt

-- | This is a convenience function around @/cairo_clip_extents()/@.
-- It rounds the clip extents to integer coordinates and returns
-- a boolean indicating if a clip area exists.
cairoGetClipRectangle ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> m ((Bool, Gdk.Rectangle.Rectangle))
    -- ^ __Returns:__ 'P.True' if a clip rectangle exists, 'P.False' if all of /@cr@/ is
    --     clipped and all drawing can be skipped
cairoGetClipRectangle cr = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    rect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    result <- gdk_cairo_get_clip_rectangle cr' rect
    let result' = (/= 0) result
    rect' <- (wrapBoxed Gdk.Rectangle.Rectangle) rect
    touchManagedPtr cr
    return (result', rect')


-- function cairo_draw_from_gl
-- Args: [ Arg
--           { argCName = "cr"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Context" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cairo context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The window we're rendering for (not necessarily into)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The GL ID of the source buffer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_type"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of the @source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer_scale"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The scale-factor that the @source buffer is allocated for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The source x position in @source to start copying from in GL coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The source y position in @source to start copying from in GL coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The width of the region to draw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The height of the region to draw"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_draw_from_gl" gdk_cairo_draw_from_gl :: 
    Ptr Cairo.Context.Context ->            -- cr : TInterface (Name {namespace = "cairo", name = "Context"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Int32 ->                                -- source : TBasicType TInt
    Int32 ->                                -- source_type : TBasicType TInt
    Int32 ->                                -- buffer_scale : TBasicType TInt
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | This is the main way to draw GL content in GTK+. It takes a render buffer ID
-- (/@sourceType@/ == @/GL_RENDERBUFFER/@) or a texture id (/@sourceType@/ == @/GL_TEXTURE/@)
-- and draws it onto /@cr@/ with an OVER operation, respecting the current clip.
-- The top left corner of the rectangle specified by /@x@/, /@y@/, /@width@/ and /@height@/
-- will be drawn at the current (0,0) position of the cairo_t.
-- 
-- This will work for *all* cairo_t, as long as /@window@/ is realized, but the
-- fallback implementation that reads back the pixels from the buffer may be
-- used in the general case. In the case of direct drawing to a window with
-- no special effects applied to /@cr@/ it will however use a more efficient
-- approach.
-- 
-- For @/GL_RENDERBUFFER/@ the code will always fall back to software for buffers
-- with alpha components, so make sure you use @/GL_TEXTURE/@ if using alpha.
-- 
-- Calling this may change the current GL context.
-- 
-- /Since: 3.16/
cairoDrawFromGl ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    Cairo.Context.Context
    -- ^ /@cr@/: a cairo context
    -> a
    -- ^ /@window@/: The window we\'re rendering for (not necessarily into)
    -> Int32
    -- ^ /@source@/: The GL ID of the source buffer
    -> Int32
    -- ^ /@sourceType@/: The type of the /@source@/
    -> Int32
    -- ^ /@bufferScale@/: The scale-factor that the /@source@/ buffer is allocated for
    -> Int32
    -- ^ /@x@/: The source x position in /@source@/ to start copying from in GL coordinates
    -> Int32
    -- ^ /@y@/: The source y position in /@source@/ to start copying from in GL coordinates
    -> Int32
    -- ^ /@width@/: The width of the region to draw
    -> Int32
    -- ^ /@height@/: The height of the region to draw
    -> m ()
cairoDrawFromGl cr window source sourceType bufferScale x y width height = liftIO $ do
    cr' <- unsafeManagedPtrGetPtr cr
    window' <- unsafeManagedPtrCastPtr window
    gdk_cairo_draw_from_gl cr' window' source sourceType bufferScale x y width height
    touchManagedPtr cr
    touchManagedPtr window
    return ()


-- function cairo_create
-- Args: [ Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_create" gdk_cairo_create :: 
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO (Ptr Cairo.Context.Context)

{-# DEPRECATED cairoCreate ["(Since version 3.22)","Use 'GI.Gdk.Objects.Window.windowBeginDrawFrame' and","  'GI.Gdk.Objects.DrawingContext.drawingContextGetCairoContext' instead"] #-}
-- | Creates a Cairo context for drawing to /@window@/.
-- 
-- Note that calling @/cairo_reset_clip()/@ on the resulting t'GI.Cairo.Structs.Context.Context' will
-- produce undefined results, so avoid it at all costs.
-- 
-- Typically, this function is used to draw on a t'GI.Gdk.Objects.Window.Window' out of the paint
-- cycle of the toolkit; this should be avoided, as it breaks various assumptions
-- and optimizations.
-- 
-- If you are drawing on a native t'GI.Gdk.Objects.Window.Window' in response to a 'GI.Gdk.Enums.EventTypeExpose' event
-- you should use 'GI.Gdk.Objects.Window.windowBeginDrawFrame' and 'GI.Gdk.Objects.DrawingContext.drawingContextGetCairoContext'
-- instead. GTK will automatically do this for you when drawing a widget.
-- 
-- /Since: 2.8/
cairoCreate ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Window.IsWindow a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Cairo.Context.Context
    -- ^ __Returns:__ A newly created Cairo context. Free with
    --  @/cairo_destroy()/@ when you are done drawing.
cairoCreate window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_cairo_create window'
    checkUnexpectedReturnNULL "cairoCreate" result
    result' <- (wrapBoxed Cairo.Context.Context) result
    touchManagedPtr window
    return result'


-- function beep
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_beep" gdk_beep :: 
    IO ()

-- | Emits a short beep on the default display.
beep ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
beep  = liftIO $ do
    gdk_beep
    return ()


-- function add_option_entries_libgtk_only
-- Args: [ Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An option group." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_add_option_entries_libgtk_only" gdk_add_option_entries_libgtk_only :: 
    Ptr GLib.OptionGroup.OptionGroup ->     -- group : TInterface (Name {namespace = "GLib", name = "OptionGroup"})
    IO ()

{-# DEPRECATED addOptionEntriesLibgtkOnly ["(Since version 3.16)","This symbol was never meant to be used outside","  of GTK+"] #-}
-- | Appends gdk option entries to the passed in option group. This is
-- not public API and must not be used by applications.
addOptionEntriesLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: An option group.
    -> m ()
addOptionEntriesLibgtkOnly group = liftIO $ do
    group' <- unsafeManagedPtrGetPtr group
    gdk_add_option_entries_libgtk_only group'
    touchManagedPtr group
    return ()



