{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This is the t'GI.GObject.Objects.Object.Object' based object that represents a menu
-- item.  It gets created the same on both the client and
-- the server side and libdbusmenu-glib does the work of making
-- this object model appear on both sides of DBus.  Simple
-- really, though through updates and people coming on and off
-- the bus it can lead to lots of fun complex scenarios.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Dbusmenu.Objects.Menuitem
    ( 

-- * Exported types
    Menuitem(..)                            ,
    IsMenuitem                              ,
    toMenuitem                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childAddPosition]("GI.Dbusmenu.Objects.Menuitem#g:method:childAddPosition"), [childAppend]("GI.Dbusmenu.Objects.Menuitem#g:method:childAppend"), [childDelete]("GI.Dbusmenu.Objects.Menuitem#g:method:childDelete"), [childFind]("GI.Dbusmenu.Objects.Menuitem#g:method:childFind"), [childPrepend]("GI.Dbusmenu.Objects.Menuitem#g:method:childPrepend"), [childReorder]("GI.Dbusmenu.Objects.Menuitem#g:method:childReorder"), [findId]("GI.Dbusmenu.Objects.Menuitem#g:method:findId"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [foreach]("GI.Dbusmenu.Objects.Menuitem#g:method:foreach"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [handleEvent]("GI.Dbusmenu.Objects.Menuitem#g:method:handleEvent"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [propertiesCopy]("GI.Dbusmenu.Objects.Menuitem#g:method:propertiesCopy"), [propertiesList]("GI.Dbusmenu.Objects.Menuitem#g:method:propertiesList"), [propertyExist]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyExist"), [propertyGet]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyGet"), [propertyGetBool]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyGetBool"), [propertyGetByteArray]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyGetByteArray"), [propertyGetInt]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyGetInt"), [propertyGetVariant]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyGetVariant"), [propertyRemove]("GI.Dbusmenu.Objects.Menuitem#g:method:propertyRemove"), [propertySet]("GI.Dbusmenu.Objects.Menuitem#g:method:propertySet"), [propertySetBool]("GI.Dbusmenu.Objects.Menuitem#g:method:propertySetBool"), [propertySetByteArray]("GI.Dbusmenu.Objects.Menuitem#g:method:propertySetByteArray"), [propertySetInt]("GI.Dbusmenu.Objects.Menuitem#g:method:propertySetInt"), [propertySetVariant]("GI.Dbusmenu.Objects.Menuitem#g:method:propertySetVariant"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sendAboutToShow]("GI.Dbusmenu.Objects.Menuitem#g:method:sendAboutToShow"), [showToUser]("GI.Dbusmenu.Objects.Menuitem#g:method:showToUser"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [takeChildren]("GI.Dbusmenu.Objects.Menuitem#g:method:takeChildren"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unparent]("GI.Dbusmenu.Objects.Menuitem#g:method:unparent"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChildren]("GI.Dbusmenu.Objects.Menuitem#g:method:getChildren"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getId]("GI.Dbusmenu.Objects.Menuitem#g:method:getId"), [getParent]("GI.Dbusmenu.Objects.Menuitem#g:method:getParent"), [getPosition]("GI.Dbusmenu.Objects.Menuitem#g:method:getPosition"), [getPositionRealized]("GI.Dbusmenu.Objects.Menuitem#g:method:getPositionRealized"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRoot]("GI.Dbusmenu.Objects.Menuitem#g:method:getRoot").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setParent]("GI.Dbusmenu.Objects.Menuitem#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRoot]("GI.Dbusmenu.Objects.Menuitem#g:method:setRoot").

#if defined(ENABLE_OVERLOADING)
    ResolveMenuitemMethod                   ,
#endif

-- ** childAddPosition #method:childAddPosition#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildAddPositionMethodInfo      ,
#endif
    menuitemChildAddPosition                ,


-- ** childAppend #method:childAppend#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildAppendMethodInfo           ,
#endif
    menuitemChildAppend                     ,


-- ** childDelete #method:childDelete#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildDeleteMethodInfo           ,
#endif
    menuitemChildDelete                     ,


-- ** childFind #method:childFind#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildFindMethodInfo             ,
#endif
    menuitemChildFind                       ,


-- ** childPrepend #method:childPrepend#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildPrependMethodInfo          ,
#endif
    menuitemChildPrepend                    ,


-- ** childReorder #method:childReorder#

#if defined(ENABLE_OVERLOADING)
    MenuitemChildReorderMethodInfo          ,
#endif
    menuitemChildReorder                    ,


-- ** findId #method:findId#

#if defined(ENABLE_OVERLOADING)
    MenuitemFindIdMethodInfo                ,
#endif
    menuitemFindId                          ,


-- ** foreach #method:foreach#

#if defined(ENABLE_OVERLOADING)
    MenuitemForeachMethodInfo               ,
#endif
    menuitemForeach                         ,


-- ** getChildren #method:getChildren#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetChildrenMethodInfo           ,
#endif
    menuitemGetChildren                     ,


-- ** getId #method:getId#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetIdMethodInfo                 ,
#endif
    menuitemGetId                           ,


-- ** getParent #method:getParent#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetParentMethodInfo             ,
#endif
    menuitemGetParent                       ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetPositionMethodInfo           ,
#endif
    menuitemGetPosition                     ,


-- ** getPositionRealized #method:getPositionRealized#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetPositionRealizedMethodInfo   ,
#endif
    menuitemGetPositionRealized             ,


-- ** getRoot #method:getRoot#

#if defined(ENABLE_OVERLOADING)
    MenuitemGetRootMethodInfo               ,
#endif
    menuitemGetRoot                         ,


-- ** handleEvent #method:handleEvent#

#if defined(ENABLE_OVERLOADING)
    MenuitemHandleEventMethodInfo           ,
#endif
    menuitemHandleEvent                     ,


-- ** new #method:new#

    menuitemNew                             ,


-- ** newWithId #method:newWithId#

    menuitemNewWithId                       ,


-- ** propertiesCopy #method:propertiesCopy#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertiesCopyMethodInfo        ,
#endif
    menuitemPropertiesCopy                  ,


-- ** propertiesList #method:propertiesList#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertiesListMethodInfo        ,
#endif
    menuitemPropertiesList                  ,


-- ** propertyExist #method:propertyExist#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyExistMethodInfo         ,
#endif
    menuitemPropertyExist                   ,


-- ** propertyGet #method:propertyGet#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyGetMethodInfo           ,
#endif
    menuitemPropertyGet                     ,


-- ** propertyGetBool #method:propertyGetBool#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyGetBoolMethodInfo       ,
#endif
    menuitemPropertyGetBool                 ,


-- ** propertyGetByteArray #method:propertyGetByteArray#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyGetByteArrayMethodInfo  ,
#endif
    menuitemPropertyGetByteArray            ,


-- ** propertyGetInt #method:propertyGetInt#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyGetIntMethodInfo        ,
#endif
    menuitemPropertyGetInt                  ,


-- ** propertyGetVariant #method:propertyGetVariant#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyGetVariantMethodInfo    ,
#endif
    menuitemPropertyGetVariant              ,


-- ** propertyRemove #method:propertyRemove#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyRemoveMethodInfo        ,
#endif
    menuitemPropertyRemove                  ,


-- ** propertySet #method:propertySet#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertySetMethodInfo           ,
#endif
    menuitemPropertySet                     ,


-- ** propertySetBool #method:propertySetBool#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertySetBoolMethodInfo       ,
#endif
    menuitemPropertySetBool                 ,


-- ** propertySetByteArray #method:propertySetByteArray#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertySetByteArrayMethodInfo  ,
#endif
    menuitemPropertySetByteArray            ,


-- ** propertySetInt #method:propertySetInt#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertySetIntMethodInfo        ,
#endif
    menuitemPropertySetInt                  ,


-- ** propertySetVariant #method:propertySetVariant#

#if defined(ENABLE_OVERLOADING)
    MenuitemPropertySetVariantMethodInfo    ,
#endif
    menuitemPropertySetVariant              ,


-- ** sendAboutToShow #method:sendAboutToShow#

#if defined(ENABLE_OVERLOADING)
    MenuitemSendAboutToShowMethodInfo       ,
#endif
    menuitemSendAboutToShow                 ,


-- ** setParent #method:setParent#

#if defined(ENABLE_OVERLOADING)
    MenuitemSetParentMethodInfo             ,
#endif
    menuitemSetParent                       ,


-- ** setRoot #method:setRoot#

#if defined(ENABLE_OVERLOADING)
    MenuitemSetRootMethodInfo               ,
#endif
    menuitemSetRoot                         ,


-- ** showToUser #method:showToUser#

#if defined(ENABLE_OVERLOADING)
    MenuitemShowToUserMethodInfo            ,
#endif
    menuitemShowToUser                      ,


-- ** takeChildren #method:takeChildren#

#if defined(ENABLE_OVERLOADING)
    MenuitemTakeChildrenMethodInfo          ,
#endif
    menuitemTakeChildren                    ,


-- ** unparent #method:unparent#

#if defined(ENABLE_OVERLOADING)
    MenuitemUnparentMethodInfo              ,
#endif
    menuitemUnparent                        ,




 -- * Properties


-- ** id #attr:id#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    MenuitemIdPropertyInfo                  ,
#endif
    constructMenuitemId                     ,
    getMenuitemId                           ,
#if defined(ENABLE_OVERLOADING)
    menuitemId                              ,
#endif




 -- * Signals


-- ** aboutToShow #signal:aboutToShow#

    MenuitemAboutToShowCallback             ,
#if defined(ENABLE_OVERLOADING)
    MenuitemAboutToShowSignalInfo           ,
#endif
    afterMenuitemAboutToShow                ,
    onMenuitemAboutToShow                   ,


-- ** childAdded #signal:childAdded#

    MenuitemChildAddedCallback              ,
#if defined(ENABLE_OVERLOADING)
    MenuitemChildAddedSignalInfo            ,
#endif
    afterMenuitemChildAdded                 ,
    onMenuitemChildAdded                    ,


-- ** childMoved #signal:childMoved#

    MenuitemChildMovedCallback              ,
#if defined(ENABLE_OVERLOADING)
    MenuitemChildMovedSignalInfo            ,
#endif
    afterMenuitemChildMoved                 ,
    onMenuitemChildMoved                    ,


-- ** childRemoved #signal:childRemoved#

    MenuitemChildRemovedCallback            ,
#if defined(ENABLE_OVERLOADING)
    MenuitemChildRemovedSignalInfo          ,
#endif
    afterMenuitemChildRemoved               ,
    onMenuitemChildRemoved                  ,


-- ** event #signal:event#

    MenuitemEventCallback                   ,
#if defined(ENABLE_OVERLOADING)
    MenuitemEventSignalInfo                 ,
#endif
    afterMenuitemEvent                      ,
    onMenuitemEvent                         ,


-- ** itemActivated #signal:itemActivated#

    MenuitemItemActivatedCallback           ,
#if defined(ENABLE_OVERLOADING)
    MenuitemItemActivatedSignalInfo         ,
#endif
    afterMenuitemItemActivated              ,
    onMenuitemItemActivated                 ,


-- ** propertyChanged #signal:propertyChanged#

    MenuitemPropertyChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    MenuitemPropertyChangedSignalInfo       ,
#endif
    afterMenuitemPropertyChanged            ,
    onMenuitemPropertyChanged               ,


-- ** realized #signal:realized#

    MenuitemRealizedCallback                ,
#if defined(ENABLE_OVERLOADING)
    MenuitemRealizedSignalInfo              ,
#endif
    afterMenuitemRealized                   ,
    onMenuitemRealized                      ,


-- ** showToUser #signal:showToUser#

    MenuitemShowToUserCallback              ,
#if defined(ENABLE_OVERLOADING)
    MenuitemShowToUserSignalInfo            ,
#endif
    afterMenuitemShowToUser                 ,
    onMenuitemShowToUser                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Menuitem = Menuitem (SP.ManagedPtr Menuitem)
    deriving (Eq)

instance SP.ManagedPtrNewtype Menuitem where
    toManagedPtr (Menuitem p) = p

foreign import ccall "dbusmenu_menuitem_get_type"
    c_dbusmenu_menuitem_get_type :: IO B.Types.GType

instance B.Types.TypedObject Menuitem where
    glibType = c_dbusmenu_menuitem_get_type

instance B.Types.GObject Menuitem

-- | Type class for types which can be safely cast to `Menuitem`, for instance with `toMenuitem`.
class (SP.GObject o, O.IsDescendantOf Menuitem o) => IsMenuitem o
instance (SP.GObject o, O.IsDescendantOf Menuitem o) => IsMenuitem o

instance O.HasParentTypes Menuitem
type instance O.ParentTypes Menuitem = '[GObject.Object.Object]

-- | Cast to `Menuitem`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMenuitem :: (MIO.MonadIO m, IsMenuitem o) => o -> m Menuitem
toMenuitem = MIO.liftIO . B.ManagedPtr.unsafeCastTo Menuitem

-- | Convert 'Menuitem' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Menuitem) where
    gvalueGType_ = c_dbusmenu_menuitem_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Menuitem)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Menuitem)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Menuitem ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMenuitemMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMenuitemMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMenuitemMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMenuitemMethod "childAddPosition" o = MenuitemChildAddPositionMethodInfo
    ResolveMenuitemMethod "childAppend" o = MenuitemChildAppendMethodInfo
    ResolveMenuitemMethod "childDelete" o = MenuitemChildDeleteMethodInfo
    ResolveMenuitemMethod "childFind" o = MenuitemChildFindMethodInfo
    ResolveMenuitemMethod "childPrepend" o = MenuitemChildPrependMethodInfo
    ResolveMenuitemMethod "childReorder" o = MenuitemChildReorderMethodInfo
    ResolveMenuitemMethod "findId" o = MenuitemFindIdMethodInfo
    ResolveMenuitemMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMenuitemMethod "foreach" o = MenuitemForeachMethodInfo
    ResolveMenuitemMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMenuitemMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMenuitemMethod "handleEvent" o = MenuitemHandleEventMethodInfo
    ResolveMenuitemMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMenuitemMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMenuitemMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMenuitemMethod "propertiesCopy" o = MenuitemPropertiesCopyMethodInfo
    ResolveMenuitemMethod "propertiesList" o = MenuitemPropertiesListMethodInfo
    ResolveMenuitemMethod "propertyExist" o = MenuitemPropertyExistMethodInfo
    ResolveMenuitemMethod "propertyGet" o = MenuitemPropertyGetMethodInfo
    ResolveMenuitemMethod "propertyGetBool" o = MenuitemPropertyGetBoolMethodInfo
    ResolveMenuitemMethod "propertyGetByteArray" o = MenuitemPropertyGetByteArrayMethodInfo
    ResolveMenuitemMethod "propertyGetInt" o = MenuitemPropertyGetIntMethodInfo
    ResolveMenuitemMethod "propertyGetVariant" o = MenuitemPropertyGetVariantMethodInfo
    ResolveMenuitemMethod "propertyRemove" o = MenuitemPropertyRemoveMethodInfo
    ResolveMenuitemMethod "propertySet" o = MenuitemPropertySetMethodInfo
    ResolveMenuitemMethod "propertySetBool" o = MenuitemPropertySetBoolMethodInfo
    ResolveMenuitemMethod "propertySetByteArray" o = MenuitemPropertySetByteArrayMethodInfo
    ResolveMenuitemMethod "propertySetInt" o = MenuitemPropertySetIntMethodInfo
    ResolveMenuitemMethod "propertySetVariant" o = MenuitemPropertySetVariantMethodInfo
    ResolveMenuitemMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMenuitemMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMenuitemMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMenuitemMethod "sendAboutToShow" o = MenuitemSendAboutToShowMethodInfo
    ResolveMenuitemMethod "showToUser" o = MenuitemShowToUserMethodInfo
    ResolveMenuitemMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMenuitemMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMenuitemMethod "takeChildren" o = MenuitemTakeChildrenMethodInfo
    ResolveMenuitemMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMenuitemMethod "unparent" o = MenuitemUnparentMethodInfo
    ResolveMenuitemMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMenuitemMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMenuitemMethod "getChildren" o = MenuitemGetChildrenMethodInfo
    ResolveMenuitemMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMenuitemMethod "getId" o = MenuitemGetIdMethodInfo
    ResolveMenuitemMethod "getParent" o = MenuitemGetParentMethodInfo
    ResolveMenuitemMethod "getPosition" o = MenuitemGetPositionMethodInfo
    ResolveMenuitemMethod "getPositionRealized" o = MenuitemGetPositionRealizedMethodInfo
    ResolveMenuitemMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMenuitemMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMenuitemMethod "getRoot" o = MenuitemGetRootMethodInfo
    ResolveMenuitemMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMenuitemMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMenuitemMethod "setParent" o = MenuitemSetParentMethodInfo
    ResolveMenuitemMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMenuitemMethod "setRoot" o = MenuitemSetRootMethodInfo
    ResolveMenuitemMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMenuitemMethod t Menuitem, O.OverloadedMethod info Menuitem p) => OL.IsLabel t (Menuitem -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMenuitemMethod t Menuitem, O.OverloadedMethod info Menuitem p, R.HasField t Menuitem p) => R.HasField t Menuitem p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMenuitemMethod t Menuitem, O.OverloadedMethodInfo info Menuitem) => OL.IsLabel t (O.MethodProxy info Menuitem) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Menuitem::about-to-show
-- | Emitted when the submenu for this item
-- 		is about to be shown
type MenuitemAboutToShowCallback =
    IO Bool

type C_MenuitemAboutToShowCallback =
    Ptr Menuitem ->                         -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_MenuitemAboutToShowCallback`.
foreign import ccall "wrapper"
    mk_MenuitemAboutToShowCallback :: C_MenuitemAboutToShowCallback -> IO (FunPtr C_MenuitemAboutToShowCallback)

wrap_MenuitemAboutToShowCallback :: 
    GObject a => (a -> MenuitemAboutToShowCallback) ->
    C_MenuitemAboutToShowCallback
wrap_MenuitemAboutToShowCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [aboutToShow](#signal:aboutToShow) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #aboutToShow callback
-- @
-- 
-- 
onMenuitemAboutToShow :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemAboutToShowCallback) -> m SignalHandlerId
onMenuitemAboutToShow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemAboutToShowCallback wrapped
    wrapped'' <- mk_MenuitemAboutToShowCallback wrapped'
    connectSignalFunPtr obj "about-to-show" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [aboutToShow](#signal:aboutToShow) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #aboutToShow callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemAboutToShow :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemAboutToShowCallback) -> m SignalHandlerId
afterMenuitemAboutToShow obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemAboutToShowCallback wrapped
    wrapped'' <- mk_MenuitemAboutToShowCallback wrapped'
    connectSignalFunPtr obj "about-to-show" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemAboutToShowSignalInfo
instance SignalInfo MenuitemAboutToShowSignalInfo where
    type HaskellCallbackType MenuitemAboutToShowSignalInfo = MenuitemAboutToShowCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemAboutToShowCallback cb
        cb'' <- mk_MenuitemAboutToShowCallback cb'
        connectSignalFunPtr obj "about-to-show" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::about-to-show"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:aboutToShow"})

#endif

-- signal Menuitem::child-added
-- | Signaled when the child menuitem has been added to
-- 		the parent.
type MenuitemChildAddedCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which is the child.
    -> Word32
    -- ^ /@arg2@/: The position that the child is being added in.
    -> IO ()

type C_MenuitemChildAddedCallback =
    Ptr Menuitem ->                         -- object
    Ptr GObject.Object.Object ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemChildAddedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemChildAddedCallback :: C_MenuitemChildAddedCallback -> IO (FunPtr C_MenuitemChildAddedCallback)

wrap_MenuitemChildAddedCallback :: 
    GObject a => (a -> MenuitemChildAddedCallback) ->
    C_MenuitemChildAddedCallback
wrap_MenuitemChildAddedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2


-- | Connect a signal handler for the [childAdded](#signal:childAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #childAdded callback
-- @
-- 
-- 
onMenuitemChildAdded :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildAddedCallback) -> m SignalHandlerId
onMenuitemChildAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildAddedCallback wrapped
    wrapped'' <- mk_MenuitemChildAddedCallback wrapped'
    connectSignalFunPtr obj "child-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [childAdded](#signal:childAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #childAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemChildAdded :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildAddedCallback) -> m SignalHandlerId
afterMenuitemChildAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildAddedCallback wrapped
    wrapped'' <- mk_MenuitemChildAddedCallback wrapped'
    connectSignalFunPtr obj "child-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemChildAddedSignalInfo
instance SignalInfo MenuitemChildAddedSignalInfo where
    type HaskellCallbackType MenuitemChildAddedSignalInfo = MenuitemChildAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemChildAddedCallback cb
        cb'' <- mk_MenuitemChildAddedCallback cb'
        connectSignalFunPtr obj "child-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::child-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:childAdded"})

#endif

-- signal Menuitem::child-moved
-- | Signaled when the child menuitem has had its location
-- 		in the list change.
type MenuitemChildMovedCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which is the child.
    -> Word32
    -- ^ /@arg2@/: The position that the child is being moved to.
    -> Word32
    -- ^ /@arg3@/: The position that the child is was in.
    -> IO ()

type C_MenuitemChildMovedCallback =
    Ptr Menuitem ->                         -- object
    Ptr GObject.Object.Object ->
    Word32 ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemChildMovedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemChildMovedCallback :: C_MenuitemChildMovedCallback -> IO (FunPtr C_MenuitemChildMovedCallback)

wrap_MenuitemChildMovedCallback :: 
    GObject a => (a -> MenuitemChildMovedCallback) ->
    C_MenuitemChildMovedCallback
wrap_MenuitemChildMovedCallback gi'cb gi'selfPtr arg1 arg2 arg3 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2 arg3


-- | Connect a signal handler for the [childMoved](#signal:childMoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #childMoved callback
-- @
-- 
-- 
onMenuitemChildMoved :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildMovedCallback) -> m SignalHandlerId
onMenuitemChildMoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildMovedCallback wrapped
    wrapped'' <- mk_MenuitemChildMovedCallback wrapped'
    connectSignalFunPtr obj "child-moved" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [childMoved](#signal:childMoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #childMoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemChildMoved :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildMovedCallback) -> m SignalHandlerId
afterMenuitemChildMoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildMovedCallback wrapped
    wrapped'' <- mk_MenuitemChildMovedCallback wrapped'
    connectSignalFunPtr obj "child-moved" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemChildMovedSignalInfo
instance SignalInfo MenuitemChildMovedSignalInfo where
    type HaskellCallbackType MenuitemChildMovedSignalInfo = MenuitemChildMovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemChildMovedCallback cb
        cb'' <- mk_MenuitemChildMovedCallback cb'
        connectSignalFunPtr obj "child-moved" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::child-moved"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:childMoved"})

#endif

-- signal Menuitem::child-removed
-- | Signaled when the child menuitem has been requested to
-- 		be removed from the parent.  This signal is called when
-- 		it has been removed from the list but not yet had
-- 		@/g_object_unref/@ called on it.
type MenuitemChildRemovedCallback =
    GObject.Object.Object
    -- ^ /@arg1@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which was the child.
    -> IO ()

type C_MenuitemChildRemovedCallback =
    Ptr Menuitem ->                         -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemChildRemovedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemChildRemovedCallback :: C_MenuitemChildRemovedCallback -> IO (FunPtr C_MenuitemChildRemovedCallback)

wrap_MenuitemChildRemovedCallback :: 
    GObject a => (a -> MenuitemChildRemovedCallback) ->
    C_MenuitemChildRemovedCallback
wrap_MenuitemChildRemovedCallback gi'cb gi'selfPtr arg1 _ = do
    arg1' <- (newObject GObject.Object.Object) arg1
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1'


-- | Connect a signal handler for the [childRemoved](#signal:childRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #childRemoved callback
-- @
-- 
-- 
onMenuitemChildRemoved :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildRemovedCallback) -> m SignalHandlerId
onMenuitemChildRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildRemovedCallback wrapped
    wrapped'' <- mk_MenuitemChildRemovedCallback wrapped'
    connectSignalFunPtr obj "child-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [childRemoved](#signal:childRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #childRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemChildRemoved :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemChildRemovedCallback) -> m SignalHandlerId
afterMenuitemChildRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemChildRemovedCallback wrapped
    wrapped'' <- mk_MenuitemChildRemovedCallback wrapped'
    connectSignalFunPtr obj "child-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemChildRemovedSignalInfo
instance SignalInfo MenuitemChildRemovedSignalInfo where
    type HaskellCallbackType MenuitemChildRemovedSignalInfo = MenuitemChildRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemChildRemovedCallback cb
        cb'' <- mk_MenuitemChildRemovedCallback cb'
        connectSignalFunPtr obj "child-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::child-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:childRemoved"})

#endif

-- signal Menuitem::event
-- | Emitted when an event is passed through.  The event is signalled
-- 		after handle_event is called.
type MenuitemEventCallback =
    T.Text
    -- ^ /@arg1@/: Name of the event
    -> GVariant
    -- ^ /@arg2@/: Information passed along with the event
    -> Word32
    -- ^ /@arg3@/: X11 timestamp of when the event happened
    -> IO Bool

type C_MenuitemEventCallback =
    Ptr Menuitem ->                         -- object
    CString ->
    Ptr GVariant ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_MenuitemEventCallback`.
foreign import ccall "wrapper"
    mk_MenuitemEventCallback :: C_MenuitemEventCallback -> IO (FunPtr C_MenuitemEventCallback)

wrap_MenuitemEventCallback :: 
    GObject a => (a -> MenuitemEventCallback) ->
    C_MenuitemEventCallback
wrap_MenuitemEventCallback gi'cb gi'selfPtr arg1 arg2 arg3 _ = do
    arg1' <- cstringToText arg1
    arg2' <- B.GVariant.newGVariantFromPtr arg2
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2' arg3
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [event](#signal:event) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #event callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@event::detail@” instead.
-- 
onMenuitemEvent :: (IsMenuitem a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => MenuitemEventCallback) -> m SignalHandlerId
onMenuitemEvent obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemEventCallback wrapped
    wrapped'' <- mk_MenuitemEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectBefore detail

-- | Connect a signal handler for the [event](#signal:event) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #event callback
-- @
-- 
-- This signal admits a optional parameter @detail@.
-- If it's not @Nothing@, we will connect to “@event::detail@” instead.
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemEvent :: (IsMenuitem a, MonadIO m) => a -> P.Maybe T.Text -> ((?self :: a) => MenuitemEventCallback) -> m SignalHandlerId
afterMenuitemEvent obj detail cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemEventCallback wrapped
    wrapped'' <- mk_MenuitemEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectAfter detail


#if defined(ENABLE_OVERLOADING)
data MenuitemEventSignalInfo
instance SignalInfo MenuitemEventSignalInfo where
    type HaskellCallbackType MenuitemEventSignalInfo = MenuitemEventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemEventCallback cb
        cb'' <- mk_MenuitemEventCallback cb'
        connectSignalFunPtr obj "event" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::event"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:event"})

#endif

-- signal Menuitem::item-activated
-- | Emitted on the objects on the server side when
-- 		they are signaled on the client side.
type MenuitemItemActivatedCallback =
    Word32
    -- ^ /@arg1@/: The timestamp of when it was activated
    -> IO ()

type C_MenuitemItemActivatedCallback =
    Ptr Menuitem ->                         -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemItemActivatedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemItemActivatedCallback :: C_MenuitemItemActivatedCallback -> IO (FunPtr C_MenuitemItemActivatedCallback)

wrap_MenuitemItemActivatedCallback :: 
    GObject a => (a -> MenuitemItemActivatedCallback) ->
    C_MenuitemItemActivatedCallback
wrap_MenuitemItemActivatedCallback gi'cb gi'selfPtr arg1 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1


-- | Connect a signal handler for the [itemActivated](#signal:itemActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #itemActivated callback
-- @
-- 
-- 
onMenuitemItemActivated :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemItemActivatedCallback) -> m SignalHandlerId
onMenuitemItemActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemItemActivatedCallback wrapped
    wrapped'' <- mk_MenuitemItemActivatedCallback wrapped'
    connectSignalFunPtr obj "item-activated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [itemActivated](#signal:itemActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #itemActivated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemItemActivated :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemItemActivatedCallback) -> m SignalHandlerId
afterMenuitemItemActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemItemActivatedCallback wrapped
    wrapped'' <- mk_MenuitemItemActivatedCallback wrapped'
    connectSignalFunPtr obj "item-activated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemItemActivatedSignalInfo
instance SignalInfo MenuitemItemActivatedSignalInfo where
    type HaskellCallbackType MenuitemItemActivatedSignalInfo = MenuitemItemActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemItemActivatedCallback cb
        cb'' <- mk_MenuitemItemActivatedCallback cb'
        connectSignalFunPtr obj "item-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::item-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:itemActivated"})

#endif

-- signal Menuitem::property-changed
-- | Emitted everytime a property on a menuitem is either
-- 		updated or added.
type MenuitemPropertyChangedCallback =
    T.Text
    -- ^ /@arg1@/: The name of the property that changed
    -> GVariant
    -- ^ /@arg2@/: The new value of the property
    -> IO ()

type C_MenuitemPropertyChangedCallback =
    Ptr Menuitem ->                         -- object
    CString ->
    Ptr GVariant ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemPropertyChangedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemPropertyChangedCallback :: C_MenuitemPropertyChangedCallback -> IO (FunPtr C_MenuitemPropertyChangedCallback)

wrap_MenuitemPropertyChangedCallback :: 
    GObject a => (a -> MenuitemPropertyChangedCallback) ->
    C_MenuitemPropertyChangedCallback
wrap_MenuitemPropertyChangedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- cstringToText arg1
    arg2' <- B.GVariant.newGVariantFromPtr arg2
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2'


-- | Connect a signal handler for the [propertyChanged](#signal:propertyChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #propertyChanged callback
-- @
-- 
-- 
onMenuitemPropertyChanged :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemPropertyChangedCallback) -> m SignalHandlerId
onMenuitemPropertyChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemPropertyChangedCallback wrapped
    wrapped'' <- mk_MenuitemPropertyChangedCallback wrapped'
    connectSignalFunPtr obj "property-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [propertyChanged](#signal:propertyChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #propertyChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemPropertyChanged :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemPropertyChangedCallback) -> m SignalHandlerId
afterMenuitemPropertyChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemPropertyChangedCallback wrapped
    wrapped'' <- mk_MenuitemPropertyChangedCallback wrapped'
    connectSignalFunPtr obj "property-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyChangedSignalInfo
instance SignalInfo MenuitemPropertyChangedSignalInfo where
    type HaskellCallbackType MenuitemPropertyChangedSignalInfo = MenuitemPropertyChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemPropertyChangedCallback cb
        cb'' <- mk_MenuitemPropertyChangedCallback cb'
        connectSignalFunPtr obj "property-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::property-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:propertyChanged"})

#endif

-- signal Menuitem::realized
-- | Emitted when the initial request for properties
-- 		is complete on the item.  If there is a type
-- 		handler configured for the \"type\" parameter
-- 		that will be executed before this is signaled.
type MenuitemRealizedCallback =
    IO ()

type C_MenuitemRealizedCallback =
    Ptr Menuitem ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemRealizedCallback`.
foreign import ccall "wrapper"
    mk_MenuitemRealizedCallback :: C_MenuitemRealizedCallback -> IO (FunPtr C_MenuitemRealizedCallback)

wrap_MenuitemRealizedCallback :: 
    GObject a => (a -> MenuitemRealizedCallback) ->
    C_MenuitemRealizedCallback
wrap_MenuitemRealizedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [realized](#signal:realized) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #realized callback
-- @
-- 
-- 
onMenuitemRealized :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemRealizedCallback) -> m SignalHandlerId
onMenuitemRealized obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemRealizedCallback wrapped
    wrapped'' <- mk_MenuitemRealizedCallback wrapped'
    connectSignalFunPtr obj "realized" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [realized](#signal:realized) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #realized callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemRealized :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemRealizedCallback) -> m SignalHandlerId
afterMenuitemRealized obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemRealizedCallback wrapped
    wrapped'' <- mk_MenuitemRealizedCallback wrapped'
    connectSignalFunPtr obj "realized" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemRealizedSignalInfo
instance SignalInfo MenuitemRealizedSignalInfo where
    type HaskellCallbackType MenuitemRealizedSignalInfo = MenuitemRealizedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemRealizedCallback cb
        cb'' <- mk_MenuitemRealizedCallback cb'
        connectSignalFunPtr obj "realized" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::realized"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:realized"})

#endif

-- signal Menuitem::show-to-user
-- | Signaled when the application would like the visualization
-- 		of this menu item shown to the user.  This usually requires
-- 		going over the bus to get it done.
type MenuitemShowToUserCallback =
    Word32
    -- ^ /@arg1@/: Timestamp the event happened at
    -> IO ()

type C_MenuitemShowToUserCallback =
    Ptr Menuitem ->                         -- object
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MenuitemShowToUserCallback`.
foreign import ccall "wrapper"
    mk_MenuitemShowToUserCallback :: C_MenuitemShowToUserCallback -> IO (FunPtr C_MenuitemShowToUserCallback)

wrap_MenuitemShowToUserCallback :: 
    GObject a => (a -> MenuitemShowToUserCallback) ->
    C_MenuitemShowToUserCallback
wrap_MenuitemShowToUserCallback gi'cb gi'selfPtr arg1 _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1


-- | Connect a signal handler for the [showToUser](#signal:showToUser) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' menuitem #showToUser callback
-- @
-- 
-- 
onMenuitemShowToUser :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemShowToUserCallback) -> m SignalHandlerId
onMenuitemShowToUser obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemShowToUserCallback wrapped
    wrapped'' <- mk_MenuitemShowToUserCallback wrapped'
    connectSignalFunPtr obj "show-to-user" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [showToUser](#signal:showToUser) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' menuitem #showToUser callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMenuitemShowToUser :: (IsMenuitem a, MonadIO m) => a -> ((?self :: a) => MenuitemShowToUserCallback) -> m SignalHandlerId
afterMenuitemShowToUser obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MenuitemShowToUserCallback wrapped
    wrapped'' <- mk_MenuitemShowToUserCallback wrapped'
    connectSignalFunPtr obj "show-to-user" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MenuitemShowToUserSignalInfo
instance SignalInfo MenuitemShowToUserSignalInfo where
    type HaskellCallbackType MenuitemShowToUserSignalInfo = MenuitemShowToUserCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MenuitemShowToUserCallback cb
        cb'' <- mk_MenuitemShowToUserCallback cb'
        connectSignalFunPtr obj "show-to-user" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem::show-to-user"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:signal:showToUser"})

#endif

-- VVV Prop "id"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' menuitem #id
-- @
getMenuitemId :: (MonadIO m, IsMenuitem o) => o -> m Int32
getMenuitemId obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "id"

-- | Construct a `GValueConstruct` with valid value for the “@id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMenuitemId :: (IsMenuitem o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructMenuitemId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "id" val

#if defined(ENABLE_OVERLOADING)
data MenuitemIdPropertyInfo
instance AttrInfo MenuitemIdPropertyInfo where
    type AttrAllowedOps MenuitemIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MenuitemIdPropertyInfo = IsMenuitem
    type AttrSetTypeConstraint MenuitemIdPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint MenuitemIdPropertyInfo = (~) Int32
    type AttrTransferType MenuitemIdPropertyInfo = Int32
    type AttrGetType MenuitemIdPropertyInfo = Int32
    type AttrLabel MenuitemIdPropertyInfo = "id"
    type AttrOrigin MenuitemIdPropertyInfo = Menuitem
    attrGet = getMenuitemId
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMenuitemId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.id"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#g:attr:id"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Menuitem
type instance O.AttributeList Menuitem = MenuitemAttributeList
type MenuitemAttributeList = ('[ '("id", MenuitemIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
menuitemId :: AttrLabelProxy "id"
menuitemId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Menuitem = MenuitemSignalList
type MenuitemSignalList = ('[ '("aboutToShow", MenuitemAboutToShowSignalInfo), '("childAdded", MenuitemChildAddedSignalInfo), '("childMoved", MenuitemChildMovedSignalInfo), '("childRemoved", MenuitemChildRemovedSignalInfo), '("event", MenuitemEventSignalInfo), '("itemActivated", MenuitemItemActivatedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("propertyChanged", MenuitemPropertyChangedSignalInfo), '("realized", MenuitemRealizedSignalInfo), '("showToUser", MenuitemShowToUserSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Menuitem::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_new" dbusmenu_menuitem_new :: 
    IO (Ptr Menuitem)

-- | Create a new t'GI.Dbusmenu.Objects.Menuitem.Menuitem' with all default values.
menuitemNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Menuitem
    -- ^ __Returns:__ A newly allocated t'GI.Dbusmenu.Objects.Menuitem.Menuitem'.
menuitemNew  = liftIO $ do
    result <- dbusmenu_menuitem_new
    checkUnexpectedReturnNULL "menuitemNew" result
    result' <- (wrapObject Menuitem) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Menuitem::new_with_id
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "ID to use for this menuitem"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_new_with_id" dbusmenu_menuitem_new_with_id :: 
    Int32 ->                                -- id : TBasicType TInt
    IO (Ptr Menuitem)

-- | This creates a blank t'GI.Dbusmenu.Objects.Menuitem.Menuitem' with a specific ID.
menuitemNewWithId ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@id@/: ID to use for this menuitem
    -> m Menuitem
    -- ^ __Returns:__ A newly allocated t'GI.Dbusmenu.Objects.Menuitem.Menuitem'.
menuitemNewWithId id = liftIO $ do
    result <- dbusmenu_menuitem_new_with_id id
    checkUnexpectedReturnNULL "menuitemNewWithId" result
    result' <- (wrapObject Menuitem) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Menuitem::child_add_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem that we're adding the child @child to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to make a child of @mi."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Where in @mi object's list of chidren @child should be placed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_add_position" dbusmenu_menuitem_child_add_position :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- child : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Word32 ->                               -- position : TBasicType TUInt
    IO CInt

-- | Puts /@child@/ in the list of children for /@mi@/ at the location
-- specified in /@position@/.  If there is not enough entires available
-- then /@child@/ will be placed at the end of the list.
menuitemChildAddPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' that we\'re adding the child /@child@/ to.
    -> b
    -- ^ /@child@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to make a child of /@mi@/.
    -> Word32
    -- ^ /@position@/: Where in /@mi@/ object\'s list of chidren /@child@/ should be placed.
    -> m Bool
    -- ^ __Returns:__ Whether /@child@/ was added successfully.
menuitemChildAddPosition mi child position = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    child' <- unsafeManagedPtrCastPtr child
    result <- dbusmenu_menuitem_child_add_position mi' child' position
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemChildAddPositionMethodInfo
instance (signature ~ (b -> Word32 -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemChildAddPositionMethodInfo a signature where
    overloadedMethod = menuitemChildAddPosition

instance O.OverloadedMethodInfo MenuitemChildAddPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildAddPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildAddPosition"
        })


#endif

-- method Menuitem::child_append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem which will become a new parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenMenuitem that will be a child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_append" dbusmenu_menuitem_child_append :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- child : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | This function adds /@child@/ to the list of children on /@mi@/ at
-- the end of that list.
menuitemChildAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which will become a new parent
    -> b
    -- ^ /@child@/: The @/DbusmenMenuitem/@ that will be a child
    -> m Bool
    -- ^ __Returns:__ Whether the child has been added successfully.
menuitemChildAppend mi child = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    child' <- unsafeManagedPtrCastPtr child
    result <- dbusmenu_menuitem_child_append mi' child'
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemChildAppendMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemChildAppendMethodInfo a signature where
    overloadedMethod = menuitemChildAppend

instance O.OverloadedMethodInfo MenuitemChildAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildAppend"
        })


#endif

-- method Menuitem::child_delete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem which has @child as a child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The child #DbusmenuMenuitem that you want to no longer\n    be a child of @mi."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_delete" dbusmenu_menuitem_child_delete :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- child : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | This function removes /@child@/ from the children list of /@mi@/.  It does
-- not call @/g_object_unref/@ on /@child@/.
menuitemChildDelete ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which has /@child@/ as a child
    -> b
    -- ^ /@child@/: The child t'GI.Dbusmenu.Objects.Menuitem.Menuitem' that you want to no longer
    --     be a child of /@mi@/.
    -> m Bool
    -- ^ __Returns:__ If we were able to delete /@child@/.
menuitemChildDelete mi child = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    child' <- unsafeManagedPtrCastPtr child
    result <- dbusmenu_menuitem_child_delete mi' child'
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemChildDeleteMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemChildDeleteMethodInfo a signature where
    overloadedMethod = menuitemChildDelete

instance O.OverloadedMethodInfo MenuitemChildDeleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildDelete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildDelete"
        })


#endif

-- method Menuitem::child_find
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem who's children to look on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The ID of the child that we're looking for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_find" dbusmenu_menuitem_child_find :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Int32 ->                                -- id : TBasicType TInt
    IO (Ptr Menuitem)

-- | Search the children of /@mi@/ to find one with the ID of /@id@/.
-- If it doesn\'t exist then we return @/NULL/@.
menuitemChildFind ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' who\'s children to look on
    -> Int32
    -- ^ /@id@/: The ID of the child that we\'re looking for.
    -> m (Maybe Menuitem)
    -- ^ __Returns:__ The menu item with the ID /@id@/ or @/NULL/@ if it
    --    can\'t be found.
menuitemChildFind mi id = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_child_find mi' id
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Menuitem) result'
        return result''
    touchManagedPtr mi
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuitemChildFindMethodInfo
instance (signature ~ (Int32 -> m (Maybe Menuitem)), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemChildFindMethodInfo a signature where
    overloadedMethod = menuitemChildFind

instance O.OverloadedMethodInfo MenuitemChildFindMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildFind",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildFind"
        })


#endif

-- method Menuitem::child_prepend
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem which will become a new parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenMenuitem that will be a child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_prepend" dbusmenu_menuitem_child_prepend :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- child : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | This function adds /@child@/ to the list of children on /@mi@/ at
-- the beginning of that list.
menuitemChildPrepend ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' which will become a new parent
    -> b
    -- ^ /@child@/: The @/DbusmenMenuitem/@ that will be a child
    -> m Bool
    -- ^ __Returns:__ Whether the child has been added successfully.
menuitemChildPrepend mi child = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    child' <- unsafeManagedPtrCastPtr child
    result <- dbusmenu_menuitem_child_prepend mi' child'
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemChildPrependMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemChildPrependMethodInfo a signature where
    overloadedMethod = menuitemChildPrepend

instance O.OverloadedMethodInfo MenuitemChildPrependMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildPrepend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildPrepend"
        })


#endif

-- method Menuitem::child_reorder
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem that has children needing realignment"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem that is a child needing to be moved"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The position in the list to place it in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_child_reorder" dbusmenu_menuitem_child_reorder :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- child : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Word32 ->                               -- position : TBasicType TUInt
    IO CInt

-- | This function moves a child on the list of children.  It is
-- for a child that is already in the list, but simply needs a
-- new location.
menuitemChildReorder ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' that has children needing realignment
    -> b
    -- ^ /@child@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' that is a child needing to be moved
    -> Word32
    -- ^ /@position@/: The position in the list to place it in
    -> m Bool
    -- ^ __Returns:__ Whether the move was successful.
menuitemChildReorder mi child position = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    child' <- unsafeManagedPtrCastPtr child
    result <- dbusmenu_menuitem_child_reorder mi' child' position
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemChildReorderMethodInfo
instance (signature ~ (b -> Word32 -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemChildReorderMethodInfo a signature where
    overloadedMethod = menuitemChildReorder

instance O.OverloadedMethodInfo MenuitemChildReorderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemChildReorder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemChildReorder"
        })


#endif

-- method Menuitem::find_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#DbusmenuMenuitem at the top of the tree to search"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "ID of the #DbusmenuMenuitem to search for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_find_id" dbusmenu_menuitem_find_id :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Int32 ->                                -- id : TBasicType TInt
    IO (Ptr Menuitem)

-- | This function searchs the whole tree of children that
-- are attached to /@mi@/.  This could be quite a few nodes, all
-- the way down the tree.  It is a depth first search.
menuitemFindId ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' at the top of the tree to search
    -> Int32
    -- ^ /@id@/: ID of the t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to search for
    -> m (Maybe Menuitem)
    -- ^ __Returns:__ The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' with the ID of /@id@/
    -- 	or @/NULL/@ if there isn\'t such a menu item in the tree
    -- 	represented by /@mi@/.
menuitemFindId mi id = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_find_id mi' id
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Menuitem) result'
        return result''
    touchManagedPtr mi
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuitemFindIdMethodInfo
instance (signature ~ (Int32 -> m (Maybe Menuitem)), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemFindIdMethodInfo a signature where
    overloadedMethod = menuitemFindId

instance O.OverloadedMethodInfo MenuitemFindIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemFindId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemFindId"
        })


#endif

-- method Menuitem::foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenItem to start from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Function to call on every node in the tree"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_foreach" dbusmenu_menuitem_foreach :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr () ->                               -- func : TBasicType TPtr
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | This calls the function /@func@/ on this menu item and all
-- of the children of this item.  And their children.  And
-- their children.  And... you get the point.  It will get
-- called on the whole tree.
menuitemForeach ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The @/DbusmenItem/@ to start from
    -> Ptr ()
    -- ^ /@func@/: Function to call on every node in the tree
    -> Ptr ()
    -- ^ /@data@/: User data to pass to the function
    -> m ()
menuitemForeach mi func data_ = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    dbusmenu_menuitem_foreach mi' func data_
    touchManagedPtr mi
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemForeachMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemForeachMethodInfo a signature where
    overloadedMethod = menuitemForeach

instance O.OverloadedMethodInfo MenuitemForeachMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemForeach"
        })


#endif

-- method Menuitem::get_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to query."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_children" dbusmenu_menuitem_get_children :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr (GList (Ptr Menuitem)))

-- | Returns simply the list of children that this menu item
-- has.  The list is valid until another child related function
-- is called, where it might be changed.
menuitemGetChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to query.
    -> m [Menuitem]
    -- ^ __Returns:__ A t'GI.GLib.Structs.List.List' of pointers to t'GI.Dbusmenu.Objects.Menuitem.Menuitem' objects.
menuitemGetChildren mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_get_children mi'
    result' <- unpackGList result
    result'' <- mapM (newObject Menuitem) result'
    touchManagedPtr mi
    return result''

#if defined(ENABLE_OVERLOADING)
data MenuitemGetChildrenMethodInfo
instance (signature ~ (m [Menuitem]), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemGetChildrenMethodInfo a signature where
    overloadedMethod = menuitemGetChildren

instance O.OverloadedMethodInfo MenuitemGetChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetChildren"
        })


#endif

-- method Menuitem::get_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to query."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_id" dbusmenu_menuitem_get_id :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO Int32

-- | Gets the unique ID for /@mi@/.
menuitemGetId ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to query.
    -> m Int32
    -- ^ __Returns:__ The ID of the /@mi@/.
menuitemGetId mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_get_id mi'
    touchManagedPtr mi
    return result

#if defined(ENABLE_OVERLOADING)
data MenuitemGetIdMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemGetIdMethodInfo a signature where
    overloadedMethod = menuitemGetId

instance O.OverloadedMethodInfo MenuitemGetIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetId"
        })


#endif

-- method Menuitem::get_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem for which to inspect the parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" })
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_parent" dbusmenu_menuitem_get_parent :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr Menuitem)

-- | This function looks up the parent of /@mi@/
menuitemGetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' for which to inspect the parent
    -> m Menuitem
    -- ^ __Returns:__ The parent of this menu item
menuitemGetParent mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_get_parent mi'
    checkUnexpectedReturnNULL "menuitemGetParent" result
    result' <- (newObject Menuitem) result
    touchManagedPtr mi
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemGetParentMethodInfo
instance (signature ~ (m Menuitem), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemGetParentMethodInfo a signature where
    overloadedMethod = menuitemGetParent

instance O.OverloadedMethodInfo MenuitemGetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetParent"
        })


#endif

-- method Menuitem::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to find the position of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem who's children contain @mi"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_position" dbusmenu_menuitem_get_position :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- parent : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO Word32

-- | This function returns the position of the menu item /@mi@/
-- in the children of /@parent@/.  It will return zero if the
-- menu item can\'t be found.
menuitemGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to find the position of
    -> b
    -- ^ /@parent@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' who\'s children contain /@mi@/
    -> m Word32
    -- ^ __Returns:__ The position of /@mi@/ in the children of /@parent@/.
menuitemGetPosition mi parent = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    parent' <- unsafeManagedPtrCastPtr parent
    result <- dbusmenu_menuitem_get_position mi' parent'
    touchManagedPtr mi
    touchManagedPtr parent
    return result

#if defined(ENABLE_OVERLOADING)
data MenuitemGetPositionMethodInfo
instance (signature ~ (b -> m Word32), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemGetPositionMethodInfo a signature where
    overloadedMethod = menuitemGetPosition

instance O.OverloadedMethodInfo MenuitemGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetPosition"
        })


#endif

-- method Menuitem::get_position_realized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to find the position of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem who's children contain @mi"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_position_realized" dbusmenu_menuitem_get_position_realized :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- parent : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO Word32

-- | This function is very similar to @/dbusmenu_menuitem_get_position/@
-- except that it only counts in the children that have been realized.
menuitemGetPositionRealized ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to find the position of
    -> b
    -- ^ /@parent@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' who\'s children contain /@mi@/
    -> m Word32
    -- ^ __Returns:__ The position of /@mi@/ in the realized children of /@parent@/.
menuitemGetPositionRealized mi parent = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    parent' <- unsafeManagedPtrCastPtr parent
    result <- dbusmenu_menuitem_get_position_realized mi' parent'
    touchManagedPtr mi
    touchManagedPtr parent
    return result

#if defined(ENABLE_OVERLOADING)
data MenuitemGetPositionRealizedMethodInfo
instance (signature ~ (b -> m Word32), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemGetPositionRealizedMethodInfo a signature where
    overloadedMethod = menuitemGetPositionRealized

instance O.OverloadedMethodInfo MenuitemGetPositionRealizedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetPositionRealized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetPositionRealized"
        })


#endif

-- method Menuitem::get_root
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#DbusmenuMenuitem to see whether it's root"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_get_root" dbusmenu_menuitem_get_root :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | This function returns the internal value of whether this is a
-- root node or not.
menuitemGetRoot ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to see whether it\'s root
    -> m Bool
    -- ^ __Returns:__ @/TRUE/@ if this is a root node
menuitemGetRoot mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_get_root mi'
    let result' = (/= 0) result
    touchManagedPtr mi
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemGetRootMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemGetRootMethodInfo a signature where
    overloadedMethod = menuitemGetRoot

instance O.OverloadedMethodInfo MenuitemGetRootMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemGetRoot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemGetRoot"
        })


#endif

-- method Menuitem::handle_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to send the signal on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the signal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variant"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A value that could be set for the event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The timestamp of when the event happened"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_handle_event" dbusmenu_menuitem_handle_event :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr GVariant ->                         -- variant : TVariant
    Word32 ->                               -- timestamp : TBasicType TUInt
    IO ()

-- | This function is called to create an event.  It is likely
-- to be overrided by subclasses.  The default menu item
-- will respond to the activate signal and do:
-- 
-- Emits the t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/item-activate/@ signal on this
-- menu item.  Called by server objects when they get the
-- appropriate DBus signals from the client.
-- 
-- If you subclass this function you should really think
-- about calling the parent function unless you have a good
-- reason not to.
menuitemHandleEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to send the signal on.
    -> T.Text
    -- ^ /@name@/: The name of the signal
    -> GVariant
    -- ^ /@variant@/: A value that could be set for the event
    -> Word32
    -- ^ /@timestamp@/: The timestamp of when the event happened
    -> m ()
menuitemHandleEvent mi name variant timestamp = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    name' <- textToCString name
    variant' <- unsafeManagedPtrGetPtr variant
    dbusmenu_menuitem_handle_event mi' name' variant' timestamp
    touchManagedPtr mi
    touchManagedPtr variant
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemHandleEventMethodInfo
instance (signature ~ (T.Text -> GVariant -> Word32 -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemHandleEventMethodInfo a signature where
    overloadedMethod = menuitemHandleEvent

instance O.OverloadedMethodInfo MenuitemHandleEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemHandleEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemHandleEvent"
        })


#endif

-- method Menuitem::properties_copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#DbusmenuMenuitem that we're interested in the properties of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGHash (TBasicType TPtr) (TBasicType TPtr))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_properties_copy" dbusmenu_menuitem_properties_copy :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr (GHashTable (Ptr ()) (Ptr ())))

-- | This function takes the properties of a t'GI.Dbusmenu.Objects.Menuitem.Menuitem'
-- and puts them into a t'GI.GLib.Structs.HashTable.HashTable' that is referenced by the
-- key of a string and has the value of a string.  The hash
-- table may not have any entries if there aren\'t any or there
-- is an error in processing.  It is the caller\'s responsibility
-- to destroy the created t'GI.GLib.Structs.HashTable.HashTable'.
menuitemPropertiesCopy ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' that we\'re interested in the properties of
    -> m (Map.Map (Ptr ()) (Ptr ()))
    -- ^ __Returns:__ A brand new t'GI.GLib.Structs.HashTable.HashTable' that contains all of
    --    theroperties that are on this t'GI.Dbusmenu.Objects.Menuitem.Menuitem' /@mi@/.
menuitemPropertiesCopy mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_properties_copy mi'
    checkUnexpectedReturnNULL "menuitemPropertiesCopy" result
    result' <- unpackGHashTable result
    let result'' = mapFirst B.GHT.ptrUnpackPtr result'
    let result''' = mapSecond B.GHT.ptrUnpackPtr result''
    let result'''' = Map.fromList result'''
    unrefGHashTable result
    touchManagedPtr mi
    return result''''

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertiesCopyMethodInfo
instance (signature ~ (m (Map.Map (Ptr ()) (Ptr ()))), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertiesCopyMethodInfo a signature where
    overloadedMethod = menuitemPropertiesCopy

instance O.OverloadedMethodInfo MenuitemPropertiesCopyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertiesCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertiesCopy"
        })


#endif

-- method Menuitem::properties_list
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#DbusmenuMenuitem to list the properties on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGList (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_properties_list" dbusmenu_menuitem_properties_list :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr (GList CString))

-- | This functiong gets a list of the names of all the properties
-- that are set on this menu item.  This data on the list is owned
-- by the menuitem but the list is not and should be freed using
-- @/g_list_free()/@ when the calling function is done with it.
menuitemPropertiesList ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to list the properties on
    -> m [T.Text]
    -- ^ __Returns:__ A list of
    -- strings or NULL if there are none.
menuitemPropertiesList mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_properties_list mi'
    result' <- unpackGList result
    result'' <- mapM cstringToText result'
    g_list_free result
    touchManagedPtr mi
    return result''

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertiesListMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertiesListMethodInfo a signature where
    overloadedMethod = menuitemPropertiesList

instance O.OverloadedMethodInfo MenuitemPropertiesListMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertiesList",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertiesList"
        })


#endif

-- method Menuitem::property_exist
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to look for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_exist" dbusmenu_menuitem_property_exist :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO CInt

-- | Checkes to see if a particular property exists on /@mi@/ and
-- returns @/TRUE/@ if so.
menuitemPropertyExist ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to look for.
    -> m Bool
    -- ^ __Returns:__ A boolean checking to see if the property is available
menuitemPropertyExist mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_exist mi' property'
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyExistMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyExistMethodInfo a signature where
    overloadedMethod = menuitemPropertyExist

instance O.OverloadedMethodInfo MenuitemPropertyExistMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyExist",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyExist"
        })


#endif

-- method Menuitem::property_get
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to grab."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get" dbusmenu_menuitem_property_get :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO CString

-- | Look up a property on /@mi@/ and return the value of it if
-- it exits.  @/NULL/@ will be returned if the property doesn\'t
-- exist.
menuitemPropertyGet ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to grab.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ A string with the value of the property
    -- 	that shouldn\'t be free\'d.  Or @/NULL/@ if the property
    -- 	is not set or is not a string.
menuitemPropertyGet mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_get mi' property'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr mi
    freeMem property'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyGetMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyGetMethodInfo a signature where
    overloadedMethod = menuitemPropertyGet

instance O.OverloadedMethodInfo MenuitemPropertyGetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyGet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyGet"
        })


#endif

-- method Menuitem::property_get_bool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to grab."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_bool" dbusmenu_menuitem_property_get_bool :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO CInt

-- | Look up a property on /@mi@/ and return the value of it if
-- it exits.  Returns @/FALSE/@ if the property doesn\'t exist.
menuitemPropertyGetBool ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to grab.
    -> m Bool
    -- ^ __Returns:__ The value of the property or @/FALSE/@.
menuitemPropertyGetBool mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_get_bool mi' property'
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyGetBoolMethodInfo
instance (signature ~ (T.Text -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyGetBoolMethodInfo a signature where
    overloadedMethod = menuitemPropertyGetBool

instance O.OverloadedMethodInfo MenuitemPropertyGetBoolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyGetBool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyGetBool"
        })


#endif

-- method Menuitem::property_get_byte_array
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to grab."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nelements"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A pointer to the location to store the number of items (out)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "nelements"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "A pointer to the location to store the number of items (out)"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 2 (TBasicType TUInt8))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_byte_array" dbusmenu_menuitem_property_get_byte_array :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    Ptr FCT.CSize ->                        -- nelements : TBasicType TSize
    IO (Ptr Word8)

-- | Look up a property on /@mi@/ and return the value of it if
-- it exits.  @/NULL/@ will be returned if the property doesn\'t
-- exist.
menuitemPropertyGetByteArray ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to grab.
    -> m (Maybe ByteString)
    -- ^ __Returns:__ A byte array with the
    -- 	value of the property that shouldn\'t be free\'d.  Or @/NULL/@ if the property
    -- 	is not set or is not a byte array.
menuitemPropertyGetByteArray mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    nelements <- allocMem :: IO (Ptr FCT.CSize)
    result <- dbusmenu_menuitem_property_get_byte_array mi' property' nelements
    nelements' <- peek nelements
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (unpackByteStringWithLength nelements') result'
        return result''
    touchManagedPtr mi
    freeMem property'
    freeMem nelements
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyGetByteArrayMethodInfo
instance (signature ~ (T.Text -> m (Maybe ByteString)), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyGetByteArrayMethodInfo a signature where
    overloadedMethod = menuitemPropertyGetByteArray

instance O.OverloadedMethodInfo MenuitemPropertyGetByteArrayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyGetByteArray",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyGetByteArray"
        })


#endif

-- method Menuitem::property_get_int
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to grab."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_int" dbusmenu_menuitem_property_get_int :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO Int32

-- | Look up a property on /@mi@/ and return the value of it if
-- it exits.  Returns zero if the property doesn\'t exist.
menuitemPropertyGetInt ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to grab.
    -> m Int32
    -- ^ __Returns:__ The value of the property or zero.
menuitemPropertyGetInt mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_get_int mi' property'
    touchManagedPtr mi
    freeMem property'
    return result

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyGetIntMethodInfo
instance (signature ~ (T.Text -> m Int32), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyGetIntMethodInfo a signature where
    overloadedMethod = menuitemPropertyGetInt

instance O.OverloadedMethodInfo MenuitemPropertyGetIntMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyGetInt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyGetInt"
        })


#endif

-- method Menuitem::property_get_variant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to look for the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to grab."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_get_variant" dbusmenu_menuitem_property_get_variant :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO (Ptr GVariant)

-- | Look up a property on /@mi@/ and return the value of it if
-- it exits.  @/NULL/@ will be returned if the property doesn\'t
-- exist.
menuitemPropertyGetVariant ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to look for the property on.
    -> T.Text
    -- ^ /@property@/: The property to grab.
    -> m (Maybe GVariant)
    -- ^ __Returns:__ A GVariant for the property.
menuitemPropertyGetVariant mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_get_variant mi' property'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GVariant.newGVariantFromPtr result'
        return result''
    touchManagedPtr mi
    freeMem property'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyGetVariantMethodInfo
instance (signature ~ (T.Text -> m (Maybe GVariant)), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyGetVariantMethodInfo a signature where
    overloadedMethod = menuitemPropertyGetVariant

instance O.OverloadedMethodInfo MenuitemPropertyGetVariantMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyGetVariant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyGetVariant"
        })


#endif

-- method Menuitem::property_remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem to remove the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The property to look for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_remove" dbusmenu_menuitem_property_remove :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    IO ()

-- | Removes a property from the menuitem.
menuitemPropertyRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to remove the property on.
    -> T.Text
    -- ^ /@property@/: The property to look for.
    -> m ()
menuitemPropertyRemove mi property = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    dbusmenu_menuitem_property_remove mi' property'
    touchManagedPtr mi
    freeMem property'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertyRemoveMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertyRemoveMethodInfo a signature where
    overloadedMethod = menuitemPropertyRemove

instance O.OverloadedMethodInfo MenuitemPropertyRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertyRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertyRemove"
        })


#endif

-- method Menuitem::property_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value of the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set" dbusmenu_menuitem_property_set :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    CString ->                              -- value : TBasicType TUTF8
    IO CInt

-- | Takes the pair of /@property@/ and /@value@/ and places them as a
-- property on /@mi@/.  If a property already exists by that name,
-- then the value is set to the new value.  If not, the property
-- is added.  If the value is changed or the property was previously
-- unset then the signal t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/prop-changed/@ will be
-- emitted by this function.
menuitemPropertySet ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> T.Text
    -- ^ /@value@/: The value of the property.
    -> m Bool
    -- ^ __Returns:__ A boolean representing if the property value was set.
menuitemPropertySet mi property value = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    value' <- textToCString value
    result <- dbusmenu_menuitem_property_set mi' property' value'
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    freeMem value'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertySetMethodInfo
instance (signature ~ (T.Text -> T.Text -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertySetMethodInfo a signature where
    overloadedMethod = menuitemPropertySet

instance O.OverloadedMethodInfo MenuitemPropertySetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertySet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertySet"
        })


#endif

-- method Menuitem::property_set_bool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value of the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_bool" dbusmenu_menuitem_property_set_bool :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    CInt ->                                 -- value : TBasicType TBoolean
    IO CInt

-- | Takes a boolean /@value@/ and sets it on /@property@/ as a
-- property on /@mi@/.  If a property already exists by that name,
-- then the value is set to the new value.  If not, the property
-- is added.  If the value is changed or the property was previously
-- unset then the signal t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/prop-changed/@ will be
-- emitted by this function.
menuitemPropertySetBool ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> Bool
    -- ^ /@value@/: The value of the property.
    -> m Bool
    -- ^ __Returns:__ A boolean representing if the property value was set.
menuitemPropertySetBool mi property value = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    let value' = (P.fromIntegral . P.fromEnum) value
    result <- dbusmenu_menuitem_property_set_bool mi' property' value'
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertySetBoolMethodInfo
instance (signature ~ (T.Text -> Bool -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertySetBoolMethodInfo a signature where
    overloadedMethod = menuitemPropertySetBool

instance O.OverloadedMethodInfo MenuitemPropertySetBoolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertySetBool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertySetBool"
        })


#endif

-- method Menuitem::property_set_byte_array
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The byte array." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nelements"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The number of elements in the byte array."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_byte_array" dbusmenu_menuitem_property_set_byte_array :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    Word8 ->                                -- value : TBasicType TUInt8
    FCT.CSize ->                            -- nelements : TBasicType TSize
    IO CInt

-- | Takes a byte array /@value@/ and sets it on /@property@/ as a
-- property on /@mi@/.  If a property already exists by that name,
-- then the value is set to the new value.  If not, the property
-- is added.  If the value is changed or the property was previously
-- unset then the signal t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/prop-changed/@ will be
-- emitted by this function.
menuitemPropertySetByteArray ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> Word8
    -- ^ /@value@/: The byte array.
    -> FCT.CSize
    -- ^ /@nelements@/: The number of elements in the byte array.
    -> m Bool
    -- ^ __Returns:__ A boolean representing if the property value was set.
menuitemPropertySetByteArray mi property value nelements = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_set_byte_array mi' property' value nelements
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertySetByteArrayMethodInfo
instance (signature ~ (T.Text -> Word8 -> FCT.CSize -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertySetByteArrayMethodInfo a signature where
    overloadedMethod = menuitemPropertySetByteArray

instance O.OverloadedMethodInfo MenuitemPropertySetByteArrayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertySetByteArray",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertySetByteArray"
        })


#endif

-- method Menuitem::property_set_int
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value of the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_int" dbusmenu_menuitem_property_set_int :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    Int32 ->                                -- value : TBasicType TInt
    IO CInt

-- | Takes a boolean /@value@/ and sets it on /@property@/ as a
-- property on /@mi@/.  If a property already exists by that name,
-- then the value is set to the new value.  If not, the property
-- is added.  If the value is changed or the property was previously
-- unset then the signal t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/prop-changed/@ will be
-- emitted by this function.
menuitemPropertySetInt ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> Int32
    -- ^ /@value@/: The value of the property.
    -> m Bool
    -- ^ __Returns:__ A boolean representing if the property value was set.
menuitemPropertySetInt mi property value = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    result <- dbusmenu_menuitem_property_set_int mi' property' value
    let result' = (/= 0) result
    touchManagedPtr mi
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertySetIntMethodInfo
instance (signature ~ (T.Text -> Int32 -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertySetIntMethodInfo a signature where
    overloadedMethod = menuitemPropertySetInt

instance O.OverloadedMethodInfo MenuitemPropertySetIntMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertySetInt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertySetInt"
        })


#endif

-- method Menuitem::property_set_variant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to set the property on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Name of the property to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value of the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_property_set_variant" dbusmenu_menuitem_property_set_variant :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CString ->                              -- property : TBasicType TUTF8
    Ptr GVariant ->                         -- value : TVariant
    IO CInt

-- | Takes the pair of /@property@/ and /@value@/ and places them as a
-- property on /@mi@/.  If a property already exists by that name,
-- then the value is set to the new value.  If not, the property
-- is added.  If the value is changed or the property was previously
-- unset then the signal t'GI.Dbusmenu.Objects.Menuitem.Menuitem'::@/prop-changed/@ will be
-- emitted by this function.
menuitemPropertySetVariant ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set the property on.
    -> T.Text
    -- ^ /@property@/: Name of the property to set.
    -> GVariant
    -- ^ /@value@/: The value of the property.
    -> m Bool
    -- ^ __Returns:__ A boolean representing if the property value was set.
menuitemPropertySetVariant mi property value = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    property' <- textToCString property
    value' <- unsafeManagedPtrGetPtr value
    result <- dbusmenu_menuitem_property_set_variant mi' property' value'
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr value
    freeMem property'
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemPropertySetVariantMethodInfo
instance (signature ~ (T.Text -> GVariant -> m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemPropertySetVariantMethodInfo a signature where
    overloadedMethod = menuitemPropertySetVariant

instance O.OverloadedMethodInfo MenuitemPropertySetVariantMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemPropertySetVariant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemPropertySetVariant"
        })


#endif

-- method Menuitem::send_about_to_show
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to send the signal on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cb"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Callback to call when the call has returned."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cb_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Data to pass to the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_send_about_to_show" dbusmenu_menuitem_send_about_to_show :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr () ->                               -- cb : TBasicType TPtr
    Ptr () ->                               -- cb_data : TBasicType TPtr
    IO ()

-- | This function is used to send the even that the submenu
-- of this item is about to be shown.  Callers to this event
-- should delay showing the menu until their callback is
-- called if possible.
menuitemSendAboutToShow ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to send the signal on.
    -> Ptr ()
    -- ^ /@cb@/: Callback to call when the call has returned.
    -> Ptr ()
    -- ^ /@cbData@/: Data to pass to the callback.
    -> m ()
menuitemSendAboutToShow mi cb cbData = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    dbusmenu_menuitem_send_about_to_show mi' cb cbData
    touchManagedPtr mi
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemSendAboutToShowMethodInfo
instance (signature ~ (Ptr () -> Ptr () -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemSendAboutToShowMethodInfo a signature where
    overloadedMethod = menuitemSendAboutToShow

instance O.OverloadedMethodInfo MenuitemSendAboutToShowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemSendAboutToShow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemSendAboutToShow"
        })


#endif

-- method Menuitem::set_parent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenuMenuitem for which to set the parent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The new parent #DbusmenuMenuitem"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_set_parent" dbusmenu_menuitem_set_parent :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Ptr Menuitem ->                         -- parent : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | Sets the parent of /@mi@/ to /@parent@/. If /@mi@/ already
-- has a parent, then this call will fail. The parent will
-- be set automatically when using the usual methods to add a
-- child menuitem, so this function should not normally be
-- called directly
menuitemSetParent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a, IsMenuitem b) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' for which to set the parent
    -> b
    -- ^ /@parent@/: The new parent t'GI.Dbusmenu.Objects.Menuitem.Menuitem'
    -> m Bool
    -- ^ __Returns:__ Whether the parent was set successfully
menuitemSetParent mi parent = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    parent' <- unsafeManagedPtrCastPtr parent
    result <- dbusmenu_menuitem_set_parent mi' parent'
    let result' = (/= 0) result
    touchManagedPtr mi
    touchManagedPtr parent
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemSetParentMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsMenuitem a, IsMenuitem b) => O.OverloadedMethod MenuitemSetParentMethodInfo a signature where
    overloadedMethod = menuitemSetParent

instance O.OverloadedMethodInfo MenuitemSetParentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemSetParent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemSetParent"
        })


#endif

-- method Menuitem::set_root
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#DbusmenuMenuitem to set whether it's root"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Whether @mi is a root node or not"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_set_root" dbusmenu_menuitem_set_root :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    CInt ->                                 -- root : TBasicType TBoolean
    IO ()

-- | This function sets the internal value of whether this is a
-- root node or not.
menuitemSetRoot ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to set whether it\'s root
    -> Bool
    -- ^ /@root@/: Whether /@mi@/ is a root node or not
    -> m ()
menuitemSetRoot mi root = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    let root' = (P.fromIntegral . P.fromEnum) root
    dbusmenu_menuitem_set_root mi' root'
    touchManagedPtr mi
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemSetRootMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemSetRootMethodInfo a signature where
    overloadedMethod = menuitemSetRoot

instance O.OverloadedMethodInfo MenuitemSetRootMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemSetRoot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemSetRoot"
        })


#endif

-- method Menuitem::show_to_user
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#DbusmenuMenuitem to show"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The time that the user requested it to be shown"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_show_to_user" dbusmenu_menuitem_show_to_user :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    Word32 ->                               -- timestamp : TBasicType TUInt
    IO ()

-- | Signals that this menu item should be shown to the user.  If this is
-- server side the server will then take it and send it over the
-- bus.
menuitemShowToUser ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to show
    -> Word32
    -- ^ /@timestamp@/: The time that the user requested it to be shown
    -> m ()
menuitemShowToUser mi timestamp = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    dbusmenu_menuitem_show_to_user mi' timestamp
    touchManagedPtr mi
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuitemShowToUserMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemShowToUserMethodInfo a signature where
    overloadedMethod = menuitemShowToUser

instance O.OverloadedMethodInfo MenuitemShowToUserMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemShowToUser",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemShowToUser"
        })


#endif

-- method Menuitem::take_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #DbusmenMenuitem to take the children from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }))
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_take_children" dbusmenu_menuitem_take_children :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO (Ptr (GList (Ptr Menuitem)))

-- | While the name sounds devious that\'s exactly what this function
-- does.  It takes the list of children from the /@mi@/ and clears the
-- internal list.  The calling function is now in charge of the ref\'s
-- on the children it has taken.  A lot of responsibility involved
-- in taking children.
menuitemTakeChildren ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The @/DbusmenMenuitem/@ to take the children from.
    -> m [Menuitem]
    -- ^ __Returns:__ 
    --    A t'GI.GLib.Structs.List.List' of pointers to t'GI.Dbusmenu.Objects.Menuitem.Menuitem' objects.
menuitemTakeChildren mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_take_children mi'
    result' <- unpackGList result
    result'' <- mapM (wrapObject Menuitem) result'
    g_list_free result
    touchManagedPtr mi
    return result''

#if defined(ENABLE_OVERLOADING)
data MenuitemTakeChildrenMethodInfo
instance (signature ~ (m [Menuitem]), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemTakeChildrenMethodInfo a signature where
    overloadedMethod = menuitemTakeChildren

instance O.OverloadedMethodInfo MenuitemTakeChildrenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemTakeChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemTakeChildren"
        })


#endif

-- method Menuitem::unparent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mi"
--           , argType =
--               TInterface Name { namespace = "Dbusmenu" , name = "Menuitem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #DbusmenuMenuitem to unparent"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dbusmenu_menuitem_unparent" dbusmenu_menuitem_unparent :: 
    Ptr Menuitem ->                         -- mi : TInterface (Name {namespace = "Dbusmenu", name = "Menuitem"})
    IO CInt

-- | Unparents the menu item /@mi@/. If /@mi@/ doesn\'t have a
-- parent, then this call will fail. The menuitem will
-- be unparented automatically when using the usual methods
-- to delete a child menuitem, so this function should not
-- normally be called directly
menuitemUnparent ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuitem a) =>
    a
    -- ^ /@mi@/: The t'GI.Dbusmenu.Objects.Menuitem.Menuitem' to unparent
    -> m Bool
    -- ^ __Returns:__ Whether the menu item was unparented successfully
menuitemUnparent mi = liftIO $ do
    mi' <- unsafeManagedPtrCastPtr mi
    result <- dbusmenu_menuitem_unparent mi'
    let result' = (/= 0) result
    touchManagedPtr mi
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuitemUnparentMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuitem a) => O.OverloadedMethod MenuitemUnparentMethodInfo a signature where
    overloadedMethod = menuitemUnparent

instance O.OverloadedMethodInfo MenuitemUnparentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Dbusmenu.Objects.Menuitem.menuitemUnparent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-dbusmenu-0.4.13/docs/GI-Dbusmenu-Objects-Menuitem.html#v:menuitemUnparent"
        })


#endif


