{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A given range or subrange, to be used with t'GI.Atk.Interfaces.Value.Value'
-- 
-- t'GI.Atk.Structs.Range.Range' are used on t'GI.Atk.Interfaces.Value.Value', in order to represent the full
-- range of a given component (for example an slider or a range
-- control), or to define each individual subrange this full range is
-- splitted if available. See t'GI.Atk.Interfaces.Value.Value' documentation for further
-- details.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.Range
    ( 

-- * Exported types
    Range(..)                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [copy]("GI.Atk.Structs.Range#g:method:copy"), [free]("GI.Atk.Structs.Range#g:method:free").
-- 
-- ==== Getters
-- [getDescription]("GI.Atk.Structs.Range#g:method:getDescription"), [getLowerLimit]("GI.Atk.Structs.Range#g:method:getLowerLimit"), [getUpperLimit]("GI.Atk.Structs.Range#g:method:getUpperLimit").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveRangeMethod                      ,
#endif

-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    RangeCopyMethodInfo                     ,
#endif
    rangeCopy                               ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    RangeFreeMethodInfo                     ,
#endif
    rangeFree                               ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    RangeGetDescriptionMethodInfo           ,
#endif
    rangeGetDescription                     ,


-- ** getLowerLimit #method:getLowerLimit#

#if defined(ENABLE_OVERLOADING)
    RangeGetLowerLimitMethodInfo            ,
#endif
    rangeGetLowerLimit                      ,


-- ** getUpperLimit #method:getUpperLimit#

#if defined(ENABLE_OVERLOADING)
    RangeGetUpperLimitMethodInfo            ,
#endif
    rangeGetUpperLimit                      ,


-- ** new #method:new#

    rangeNew                                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Range = Range (SP.ManagedPtr Range)
    deriving (Eq)

instance SP.ManagedPtrNewtype Range where
    toManagedPtr (Range p) = p

foreign import ccall "atk_range_get_type" c_atk_range_get_type :: 
    IO GType

type instance O.ParentTypes Range = '[]
instance O.HasParentTypes Range

instance B.Types.TypedObject Range where
    glibType = c_atk_range_get_type

instance B.Types.GBoxed Range

-- | Convert 'Range' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Range) where
    gvalueGType_ = c_atk_range_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Range)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Range)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Range ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Range
type instance O.AttributeList Range = RangeAttributeList
type RangeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Range::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "lower_limit"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "inferior limit for this range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "upper_limit"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "superior limit for this range"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "human readable description of this range."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Range" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_new" atk_range_new :: 
    CDouble ->                              -- lower_limit : TBasicType TDouble
    CDouble ->                              -- upper_limit : TBasicType TDouble
    CString ->                              -- description : TBasicType TUTF8
    IO (Ptr Range)

-- | Creates a new t'GI.Atk.Structs.Range.Range'.
-- 
-- /Since: 2.12/
rangeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@lowerLimit@/: inferior limit for this range
    -> Double
    -- ^ /@upperLimit@/: superior limit for this range
    -> T.Text
    -- ^ /@description@/: human readable description of this range.
    -> m Range
    -- ^ __Returns:__ a new t'GI.Atk.Structs.Range.Range'
rangeNew lowerLimit upperLimit description = liftIO $ do
    let lowerLimit' = realToFrac lowerLimit
    let upperLimit' = realToFrac upperLimit
    description' <- textToCString description
    result <- atk_range_new lowerLimit' upperLimit' description'
    checkUnexpectedReturnNULL "rangeNew" result
    result' <- (wrapBoxed Range) result
    freeMem description'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Range::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "src"
--           , argType = TInterface Name { namespace = "Atk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#AtkRange to copy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Range" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_copy" atk_range_copy :: 
    Ptr Range ->                            -- src : TInterface (Name {namespace = "Atk", name = "Range"})
    IO (Ptr Range)

-- | Returns a new t'GI.Atk.Structs.Range.Range' that is a exact copy of /@src@/
-- 
-- /Since: 2.12/
rangeCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Range
    -- ^ /@src@/: t'GI.Atk.Structs.Range.Range' to copy
    -> m Range
    -- ^ __Returns:__ a new t'GI.Atk.Structs.Range.Range' copy of /@src@/
rangeCopy src = liftIO $ do
    src' <- unsafeManagedPtrGetPtr src
    result <- atk_range_copy src'
    checkUnexpectedReturnNULL "rangeCopy" result
    result' <- (wrapBoxed Range) result
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeCopyMethodInfo
instance (signature ~ (m Range), MonadIO m) => O.OverloadedMethod RangeCopyMethodInfo Range signature where
    overloadedMethod = rangeCopy

instance O.OverloadedMethodInfo RangeCopyMethodInfo Range where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Range.rangeCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Range.html#v:rangeCopy"
        })


#endif

-- method Range::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Atk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#AtkRange to free" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_free" atk_range_free :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Atk", name = "Range"})
    IO ()

-- | Free /@range@/
-- 
-- /Since: 2.12/
rangeFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Range
    -- ^ /@range@/: t'GI.Atk.Structs.Range.Range' to free
    -> m ()
rangeFree range = liftIO $ do
    range' <- unsafeManagedPtrGetPtr range
    atk_range_free range'
    touchManagedPtr range
    return ()

#if defined(ENABLE_OVERLOADING)
data RangeFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod RangeFreeMethodInfo Range signature where
    overloadedMethod = rangeFree

instance O.OverloadedMethodInfo RangeFreeMethodInfo Range where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Range.rangeFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Range.html#v:rangeFree"
        })


#endif

-- method Range::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Atk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkRange" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_get_description" atk_range_get_description :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Atk", name = "Range"})
    IO CString

-- | Returns the human readable description of /@range@/
-- 
-- /Since: 2.12/
rangeGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Range
    -- ^ /@range@/: an t'GI.Atk.Structs.Range.Range'
    -> m T.Text
    -- ^ __Returns:__ the human-readable description of /@range@/
rangeGetDescription range = liftIO $ do
    range' <- unsafeManagedPtrGetPtr range
    result <- atk_range_get_description range'
    checkUnexpectedReturnNULL "rangeGetDescription" result
    result' <- cstringToText result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetDescriptionMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod RangeGetDescriptionMethodInfo Range signature where
    overloadedMethod = rangeGetDescription

instance O.OverloadedMethodInfo RangeGetDescriptionMethodInfo Range where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Range.rangeGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Range.html#v:rangeGetDescription"
        })


#endif

-- method Range::get_lower_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Atk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkRange" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_get_lower_limit" atk_range_get_lower_limit :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Atk", name = "Range"})
    IO CDouble

-- | Returns the lower limit of /@range@/
-- 
-- /Since: 2.12/
rangeGetLowerLimit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Range
    -- ^ /@range@/: an t'GI.Atk.Structs.Range.Range'
    -> m Double
    -- ^ __Returns:__ the lower limit of /@range@/
rangeGetLowerLimit range = liftIO $ do
    range' <- unsafeManagedPtrGetPtr range
    result <- atk_range_get_lower_limit range'
    let result' = realToFrac result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetLowerLimitMethodInfo
instance (signature ~ (m Double), MonadIO m) => O.OverloadedMethod RangeGetLowerLimitMethodInfo Range signature where
    overloadedMethod = rangeGetLowerLimit

instance O.OverloadedMethodInfo RangeGetLowerLimitMethodInfo Range where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Range.rangeGetLowerLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Range.html#v:rangeGetLowerLimit"
        })


#endif

-- method Range::get_upper_limit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "range"
--           , argType = TInterface Name { namespace = "Atk" , name = "Range" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkRange" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "atk_range_get_upper_limit" atk_range_get_upper_limit :: 
    Ptr Range ->                            -- range : TInterface (Name {namespace = "Atk", name = "Range"})
    IO CDouble

-- | Returns the upper limit of /@range@/
-- 
-- /Since: 2.12/
rangeGetUpperLimit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Range
    -- ^ /@range@/: an t'GI.Atk.Structs.Range.Range'
    -> m Double
    -- ^ __Returns:__ the upper limit of /@range@/
rangeGetUpperLimit range = liftIO $ do
    range' <- unsafeManagedPtrGetPtr range
    result <- atk_range_get_upper_limit range'
    let result' = realToFrac result
    touchManagedPtr range
    return result'

#if defined(ENABLE_OVERLOADING)
data RangeGetUpperLimitMethodInfo
instance (signature ~ (m Double), MonadIO m) => O.OverloadedMethod RangeGetUpperLimitMethodInfo Range signature where
    overloadedMethod = rangeGetUpperLimit

instance O.OverloadedMethodInfo RangeGetUpperLimitMethodInfo Range where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Range.rangeGetUpperLimit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Range.html#v:rangeGetUpperLimit"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRangeMethod "copy" o = RangeCopyMethodInfo
    ResolveRangeMethod "free" o = RangeFreeMethodInfo
    ResolveRangeMethod "getDescription" o = RangeGetDescriptionMethodInfo
    ResolveRangeMethod "getLowerLimit" o = RangeGetLowerLimitMethodInfo
    ResolveRangeMethod "getUpperLimit" o = RangeGetUpperLimitMethodInfo
    ResolveRangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethod info Range p) => OL.IsLabel t (Range -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethod info Range p, R.HasField t Range p) => R.HasField t Range p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRangeMethod t Range, O.OverloadedMethodInfo info Range) => OL.IsLabel t (O.MethodProxy info Range) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


