{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- AtkAttribute is a string name\/value pair representing a generic
-- attribute. This can be used to expose additional information from
-- an accessible object as a whole (see 'GI.Atk.Objects.Object.objectGetAttributes')
-- or an document (see 'GI.Atk.Interfaces.Document.documentGetAttributes'). In the case of
-- text attributes (see 'GI.Atk.Interfaces.Text.textGetDefaultAttributes'),
-- t'GI.Atk.Enums.TextAttribute' enum defines all the possible text attribute
-- names. You can use 'GI.Atk.Functions.textAttributeGetName' to get the string
-- name from the enum value. See also 'GI.Atk.Functions.textAttributeForName'
-- and 'GI.Atk.Functions.textAttributeGetValue' for more information.
-- 
-- A string name\/value pair representing a generic attribute.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.Attribute
    ( 

-- * Exported types
    Attribute(..)                           ,
    newZeroAttribute                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttributeMethod                  ,
#endif

-- ** setFree #method:setFree#

    attributeSetFree                        ,




 -- * Properties


-- ** name #attr:name#
-- | The attribute name.

#if defined(ENABLE_OVERLOADING)
    attribute_name                          ,
#endif
    clearAttributeName                      ,
    getAttributeName                        ,
    setAttributeName                        ,


-- ** value #attr:value#
-- | the value of the attribute, represented as a string.

#if defined(ENABLE_OVERLOADING)
    attribute_value                         ,
#endif
    clearAttributeValue                     ,
    getAttributeValue                       ,
    setAttributeValue                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Attribute = Attribute (SP.ManagedPtr Attribute)
    deriving (Eq)

instance SP.ManagedPtrNewtype Attribute where
    toManagedPtr (Attribute p) = p

instance BoxedPtr Attribute where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr Attribute)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Attribute where
    boxedPtrCalloc = callocBytes 16


-- | Construct a `Attribute` struct initialized to zero.
newZeroAttribute :: MonadIO m => m Attribute
newZeroAttribute = liftIO $ boxedPtrCalloc >>= wrapPtr Attribute

instance tag ~ 'AttrSet => Constructible Attribute tag where
    new _ attrs = do
        o <- newZeroAttribute
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attribute #name
-- @
getAttributeName :: MonadIO m => Attribute -> m (Maybe T.Text)
getAttributeName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attribute [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttributeName :: MonadIO m => Attribute -> CString -> m ()
setAttributeName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearAttributeName :: MonadIO m => Attribute -> m ()
clearAttributeName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data AttributeNameFieldInfo
instance AttrInfo AttributeNameFieldInfo where
    type AttrBaseTypeConstraint AttributeNameFieldInfo = (~) Attribute
    type AttrAllowedOps AttributeNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttributeNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint AttributeNameFieldInfo = (~)CString
    type AttrTransferType AttributeNameFieldInfo = CString
    type AttrGetType AttributeNameFieldInfo = Maybe T.Text
    type AttrLabel AttributeNameFieldInfo = "name"
    type AttrOrigin AttributeNameFieldInfo = Attribute
    attrGet = getAttributeName
    attrSet = setAttributeName
    attrConstruct = undefined
    attrClear = clearAttributeName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Attribute.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Attribute.html#g:attr:name"
        })

attribute_name :: AttrLabelProxy "name"
attribute_name = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attribute #value
-- @
getAttributeValue :: MonadIO m => Attribute -> m (Maybe T.Text)
getAttributeValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attribute [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttributeValue :: MonadIO m => Attribute -> CString -> m ()
setAttributeValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: CString)

-- | Set the value of the “@value@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #value
-- @
clearAttributeValue :: MonadIO m => Attribute -> m ()
clearAttributeValue s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data AttributeValueFieldInfo
instance AttrInfo AttributeValueFieldInfo where
    type AttrBaseTypeConstraint AttributeValueFieldInfo = (~) Attribute
    type AttrAllowedOps AttributeValueFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint AttributeValueFieldInfo = (~) CString
    type AttrTransferTypeConstraint AttributeValueFieldInfo = (~)CString
    type AttrTransferType AttributeValueFieldInfo = CString
    type AttrGetType AttributeValueFieldInfo = Maybe T.Text
    type AttrLabel AttributeValueFieldInfo = "value"
    type AttrOrigin AttributeValueFieldInfo = Attribute
    attrGet = getAttributeValue
    attrSet = setAttributeValue
    attrConstruct = undefined
    attrClear = clearAttributeValue
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Attribute.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Structs-Attribute.html#g:attr:value"
        })

attribute_value :: AttrLabelProxy "value"
attribute_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Attribute
type instance O.AttributeList Attribute = AttributeAttributeList
type AttributeAttributeList = ('[ '("name", AttributeNameFieldInfo), '("value", AttributeValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Attribute::set_free
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "attrib_set"
--           , argType = TGSList (TBasicType TPtr)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #AtkAttributeSet to free"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_attribute_set_free" atk_attribute_set_free :: 
    Ptr (GSList (Ptr ())) ->                -- attrib_set : TGSList (TBasicType TPtr)
    IO ()

-- | Frees the memory used by an @/AtkAttributeSet/@, including all its
-- @/AtkAttributes/@.
attributeSetFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Ptr ()]
    -- ^ /@attribSet@/: The @/AtkAttributeSet/@ to free
    -> m ()
attributeSetFree attribSet = liftIO $ do
    attribSet' <- packGSList attribSet
    atk_attribute_set_free attribSet'
    g_slist_free attribSet'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttributeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttributeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethod info Attribute p) => OL.IsLabel t (Attribute -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethod info Attribute p, R.HasField t Attribute p) => R.HasField t Attribute p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttributeMethod t Attribute, O.OverloadedMethodInfo info Attribute) => OL.IsLabel t (O.MethodProxy info Attribute) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


