{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The AtkObjectFactory which creates an AtkNoOpObject.
-- 
-- The AtkObjectFactory which creates an AtkNoOpObject. An instance of
-- this is created by an AtkRegistry if no factory type has not been
-- specified to create an accessible object of a particular type.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.NoOpObjectFactory
    ( 

-- * Exported types
    NoOpObjectFactory(..)                   ,
    IsNoOpObjectFactory                     ,
    toNoOpObjectFactory                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [createAccessible]("GI.Atk.Objects.ObjectFactory#g:method:createAccessible"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [invalidate]("GI.Atk.Objects.ObjectFactory#g:method:invalidate"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleType]("GI.Atk.Objects.ObjectFactory#g:method:getAccessibleType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNoOpObjectFactoryMethod          ,
#endif

-- ** new #method:new#

    noOpObjectFactoryNew                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.ObjectFactory as Atk.ObjectFactory
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.ObjectFactory as Atk.ObjectFactory
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype NoOpObjectFactory = NoOpObjectFactory (SP.ManagedPtr NoOpObjectFactory)
    deriving (Eq)

instance SP.ManagedPtrNewtype NoOpObjectFactory where
    toManagedPtr (NoOpObjectFactory p) = p

foreign import ccall "atk_no_op_object_factory_get_type"
    c_atk_no_op_object_factory_get_type :: IO B.Types.GType

instance B.Types.TypedObject NoOpObjectFactory where
    glibType = c_atk_no_op_object_factory_get_type

instance B.Types.GObject NoOpObjectFactory

-- | Type class for types which can be safely cast to `NoOpObjectFactory`, for instance with `toNoOpObjectFactory`.
class (SP.GObject o, O.IsDescendantOf NoOpObjectFactory o) => IsNoOpObjectFactory o
instance (SP.GObject o, O.IsDescendantOf NoOpObjectFactory o) => IsNoOpObjectFactory o

instance O.HasParentTypes NoOpObjectFactory
type instance O.ParentTypes NoOpObjectFactory = '[Atk.ObjectFactory.ObjectFactory, GObject.Object.Object]

-- | Cast to `NoOpObjectFactory`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toNoOpObjectFactory :: (MIO.MonadIO m, IsNoOpObjectFactory o) => o -> m NoOpObjectFactory
toNoOpObjectFactory = MIO.liftIO . B.ManagedPtr.unsafeCastTo NoOpObjectFactory

-- | Convert 'NoOpObjectFactory' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NoOpObjectFactory) where
    gvalueGType_ = c_atk_no_op_object_factory_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NoOpObjectFactory)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NoOpObjectFactory)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NoOpObjectFactory ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNoOpObjectFactoryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNoOpObjectFactoryMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNoOpObjectFactoryMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNoOpObjectFactoryMethod "createAccessible" o = Atk.ObjectFactory.ObjectFactoryCreateAccessibleMethodInfo
    ResolveNoOpObjectFactoryMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNoOpObjectFactoryMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNoOpObjectFactoryMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNoOpObjectFactoryMethod "invalidate" o = Atk.ObjectFactory.ObjectFactoryInvalidateMethodInfo
    ResolveNoOpObjectFactoryMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNoOpObjectFactoryMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNoOpObjectFactoryMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNoOpObjectFactoryMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNoOpObjectFactoryMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNoOpObjectFactoryMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNoOpObjectFactoryMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNoOpObjectFactoryMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNoOpObjectFactoryMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNoOpObjectFactoryMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNoOpObjectFactoryMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNoOpObjectFactoryMethod "getAccessibleType" o = Atk.ObjectFactory.ObjectFactoryGetAccessibleTypeMethodInfo
    ResolveNoOpObjectFactoryMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNoOpObjectFactoryMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNoOpObjectFactoryMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNoOpObjectFactoryMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNoOpObjectFactoryMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNoOpObjectFactoryMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNoOpObjectFactoryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNoOpObjectFactoryMethod t NoOpObjectFactory, O.OverloadedMethod info NoOpObjectFactory p) => OL.IsLabel t (NoOpObjectFactory -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNoOpObjectFactoryMethod t NoOpObjectFactory, O.OverloadedMethod info NoOpObjectFactory p, R.HasField t NoOpObjectFactory p) => R.HasField t NoOpObjectFactory p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNoOpObjectFactoryMethod t NoOpObjectFactory, O.OverloadedMethodInfo info NoOpObjectFactory) => OL.IsLabel t (O.MethodProxy info NoOpObjectFactory) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NoOpObjectFactory
type instance O.AttributeList NoOpObjectFactory = NoOpObjectFactoryAttributeList
type NoOpObjectFactoryAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NoOpObjectFactory = NoOpObjectFactorySignalList
type NoOpObjectFactorySignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NoOpObjectFactory::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Atk" , name = "NoOpObjectFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_no_op_object_factory_new" atk_no_op_object_factory_new :: 
    IO (Ptr NoOpObjectFactory)

-- | Creates an instance of an t'GI.Atk.Objects.ObjectFactory.ObjectFactory' which generates primitive
-- (non-functioning) @/AtkObjects/@.
noOpObjectFactoryNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m NoOpObjectFactory
    -- ^ __Returns:__ an instance of an t'GI.Atk.Objects.ObjectFactory.ObjectFactory'
noOpObjectFactoryNew  = liftIO $ do
    result <- atk_no_op_object_factory_new
    checkUnexpectedReturnNULL "noOpObjectFactoryNew" result
    result' <- (wrapObject NoOpObjectFactory) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


