{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A set of ATK utility functions for thread locking
-- 
-- A set of utility functions for thread locking. This interface and
-- all his related methods are deprecated since 2.12.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.Misc
    ( 

-- * Exported types
    Misc(..)                                ,
    IsMisc                                  ,
    toMisc                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [threadsEnter]("GI.Atk.Objects.Misc#g:method:threadsEnter"), [threadsLeave]("GI.Atk.Objects.Misc#g:method:threadsLeave"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMiscMethod                       ,
#endif

-- ** getInstance #method:getInstance#

    miscGetInstance                         ,


-- ** threadsEnter #method:threadsEnter#

#if defined(ENABLE_OVERLOADING)
    MiscThreadsEnterMethodInfo              ,
#endif
    miscThreadsEnter                        ,


-- ** threadsLeave #method:threadsLeave#

#if defined(ENABLE_OVERLOADING)
    MiscThreadsLeaveMethodInfo              ,
#endif
    miscThreadsLeave                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Misc = Misc (SP.ManagedPtr Misc)
    deriving (Eq)

instance SP.ManagedPtrNewtype Misc where
    toManagedPtr (Misc p) = p

foreign import ccall "atk_misc_get_type"
    c_atk_misc_get_type :: IO B.Types.GType

instance B.Types.TypedObject Misc where
    glibType = c_atk_misc_get_type

instance B.Types.GObject Misc

-- | Type class for types which can be safely cast to `Misc`, for instance with `toMisc`.
class (SP.GObject o, O.IsDescendantOf Misc o) => IsMisc o
instance (SP.GObject o, O.IsDescendantOf Misc o) => IsMisc o

instance O.HasParentTypes Misc
type instance O.ParentTypes Misc = '[GObject.Object.Object]

-- | Cast to `Misc`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMisc :: (MIO.MonadIO m, IsMisc o) => o -> m Misc
toMisc = MIO.liftIO . B.ManagedPtr.unsafeCastTo Misc

-- | Convert 'Misc' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Misc) where
    gvalueGType_ = c_atk_misc_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Misc)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Misc)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Misc ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMiscMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMiscMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMiscMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMiscMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMiscMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMiscMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMiscMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMiscMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMiscMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMiscMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMiscMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMiscMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMiscMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMiscMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMiscMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMiscMethod "threadsEnter" o = MiscThreadsEnterMethodInfo
    ResolveMiscMethod "threadsLeave" o = MiscThreadsLeaveMethodInfo
    ResolveMiscMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMiscMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMiscMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMiscMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMiscMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMiscMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMiscMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMiscMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMiscMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMiscMethod t Misc, O.OverloadedMethod info Misc p) => OL.IsLabel t (Misc -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMiscMethod t Misc, O.OverloadedMethod info Misc p, R.HasField t Misc p) => R.HasField t Misc p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMiscMethod t Misc, O.OverloadedMethodInfo info Misc) => OL.IsLabel t (O.MethodProxy info Misc) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Misc
type instance O.AttributeList Misc = MiscAttributeList
type MiscAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Misc = MiscSignalList
type MiscSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Misc::threads_enter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "misc"
--           , argType = TInterface Name { namespace = "Atk" , name = "Misc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an AtkMisc instance for this application."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_misc_threads_enter" atk_misc_threads_enter :: 
    Ptr Misc ->                             -- misc : TInterface (Name {namespace = "Atk", name = "Misc"})
    IO ()

{-# DEPRECATED miscThreadsEnter ["Since 2.12."] #-}
-- | Take the thread mutex for the GUI toolkit,
-- if one exists.
-- (This method is implemented by the toolkit ATK implementation layer;
--  for instance, for GTK+, GAIL implements this via GDK_THREADS_ENTER).
-- 
-- /Since: 1.13/
miscThreadsEnter ::
    (B.CallStack.HasCallStack, MonadIO m, IsMisc a) =>
    a
    -- ^ /@misc@/: an AtkMisc instance for this application.
    -> m ()
miscThreadsEnter misc = liftIO $ do
    misc' <- unsafeManagedPtrCastPtr misc
    atk_misc_threads_enter misc'
    touchManagedPtr misc
    return ()

#if defined(ENABLE_OVERLOADING)
data MiscThreadsEnterMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMisc a) => O.OverloadedMethod MiscThreadsEnterMethodInfo a signature where
    overloadedMethod = miscThreadsEnter

instance O.OverloadedMethodInfo MiscThreadsEnterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Misc.miscThreadsEnter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Misc.html#v:miscThreadsEnter"
        })


#endif

-- method Misc::threads_leave
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "misc"
--           , argType = TInterface Name { namespace = "Atk" , name = "Misc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an AtkMisc instance for this application."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "atk_misc_threads_leave" atk_misc_threads_leave :: 
    Ptr Misc ->                             -- misc : TInterface (Name {namespace = "Atk", name = "Misc"})
    IO ()

{-# DEPRECATED miscThreadsLeave ["Since 2.12."] #-}
-- | Release the thread mutex for the GUI toolkit,
-- if one exists. This method, and atk_misc_threads_enter,
-- are needed in some situations by threaded application code which
-- services ATK requests, since fulfilling ATK requests often
-- requires calling into the GUI toolkit.  If a long-running or
-- potentially blocking call takes place inside such a block, it should
-- be bracketed by atk_misc_threads_leave\/atk_misc_threads_enter calls.
-- (This method is implemented by the toolkit ATK implementation layer;
--  for instance, for GTK+, GAIL implements this via GDK_THREADS_LEAVE).
-- 
-- /Since: 1.13/
miscThreadsLeave ::
    (B.CallStack.HasCallStack, MonadIO m, IsMisc a) =>
    a
    -- ^ /@misc@/: an AtkMisc instance for this application.
    -> m ()
miscThreadsLeave misc = liftIO $ do
    misc' <- unsafeManagedPtrCastPtr misc
    atk_misc_threads_leave misc'
    touchManagedPtr misc
    return ()

#if defined(ENABLE_OVERLOADING)
data MiscThreadsLeaveMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMisc a) => O.OverloadedMethod MiscThreadsLeaveMethodInfo a signature where
    overloadedMethod = miscThreadsLeave

instance O.OverloadedMethodInfo MiscThreadsLeaveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Misc.miscThreadsLeave",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Misc.html#v:miscThreadsLeave"
        })


#endif

-- method Misc::get_instance
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Misc" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_misc_get_instance" atk_misc_get_instance :: 
    IO (Ptr Misc)

{-# DEPRECATED miscGetInstance ["Since 2.12."] #-}
-- | Obtain the singleton instance of AtkMisc for this application.
-- 
-- /Since: 1.13/
miscGetInstance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Misc
    -- ^ __Returns:__ The singleton instance of AtkMisc for this application.
miscGetInstance  = liftIO $ do
    result <- atk_misc_get_instance
    checkUnexpectedReturnNULL "miscGetInstance" result
    result' <- (newObject Misc) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


