{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An ATK object which encapsulates a link or set of links in a hypertext document.
-- 
-- An ATK object which encapsulates a link or set of links (for
-- instance in the case of client-side image maps) in a hypertext
-- document.  It may implement the AtkAction interface.  AtkHyperlink
-- may also be used to refer to inline embedded content, since it
-- allows specification of a start and end offset within the host
-- AtkHypertext object.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.Hyperlink
    ( 

-- * Exported types
    Hyperlink(..)                           ,
    IsHyperlink                             ,
    toHyperlink                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [doAction]("GI.Atk.Interfaces.Action#g:method:doAction"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInline]("GI.Atk.Objects.Hyperlink#g:method:isInline"), [isSelectedLink]("GI.Atk.Objects.Hyperlink#g:method:isSelectedLink"), [isValid]("GI.Atk.Objects.Hyperlink#g:method:isValid"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Atk.Interfaces.Action#g:method:getDescription"), [getEndIndex]("GI.Atk.Objects.Hyperlink#g:method:getEndIndex"), [getKeybinding]("GI.Atk.Interfaces.Action#g:method:getKeybinding"), [getLocalizedName]("GI.Atk.Interfaces.Action#g:method:getLocalizedName"), [getNActions]("GI.Atk.Interfaces.Action#g:method:getNActions"), [getNAnchors]("GI.Atk.Objects.Hyperlink#g:method:getNAnchors"), [getName]("GI.Atk.Interfaces.Action#g:method:getName"), [getObject]("GI.Atk.Objects.Hyperlink#g:method:getObject"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStartIndex]("GI.Atk.Objects.Hyperlink#g:method:getStartIndex"), [getUri]("GI.Atk.Objects.Hyperlink#g:method:getUri").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Interfaces.Action#g:method:setDescription"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveHyperlinkMethod                  ,
#endif

-- ** getEndIndex #method:getEndIndex#

#if defined(ENABLE_OVERLOADING)
    HyperlinkGetEndIndexMethodInfo          ,
#endif
    hyperlinkGetEndIndex                    ,


-- ** getNAnchors #method:getNAnchors#

#if defined(ENABLE_OVERLOADING)
    HyperlinkGetNAnchorsMethodInfo          ,
#endif
    hyperlinkGetNAnchors                    ,


-- ** getObject #method:getObject#

#if defined(ENABLE_OVERLOADING)
    HyperlinkGetObjectMethodInfo            ,
#endif
    hyperlinkGetObject                      ,


-- ** getStartIndex #method:getStartIndex#

#if defined(ENABLE_OVERLOADING)
    HyperlinkGetStartIndexMethodInfo        ,
#endif
    hyperlinkGetStartIndex                  ,


-- ** getUri #method:getUri#

#if defined(ENABLE_OVERLOADING)
    HyperlinkGetUriMethodInfo               ,
#endif
    hyperlinkGetUri                         ,


-- ** isInline #method:isInline#

#if defined(ENABLE_OVERLOADING)
    HyperlinkIsInlineMethodInfo             ,
#endif
    hyperlinkIsInline                       ,


-- ** isSelectedLink #method:isSelectedLink#

#if defined(ENABLE_OVERLOADING)
    HyperlinkIsSelectedLinkMethodInfo       ,
#endif
    hyperlinkIsSelectedLink                 ,


-- ** isValid #method:isValid#

#if defined(ENABLE_OVERLOADING)
    HyperlinkIsValidMethodInfo              ,
#endif
    hyperlinkIsValid                        ,




 -- * Properties


-- ** endIndex #attr:endIndex#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    HyperlinkEndIndexPropertyInfo           ,
#endif
    getHyperlinkEndIndex                    ,
#if defined(ENABLE_OVERLOADING)
    hyperlinkEndIndex                       ,
#endif


-- ** numberOfAnchors #attr:numberOfAnchors#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    HyperlinkNumberOfAnchorsPropertyInfo    ,
#endif
    getHyperlinkNumberOfAnchors             ,
#if defined(ENABLE_OVERLOADING)
    hyperlinkNumberOfAnchors                ,
#endif


-- ** selectedLink #attr:selectedLink#
-- | Selected link

#if defined(ENABLE_OVERLOADING)
    HyperlinkSelectedLinkPropertyInfo       ,
#endif
    getHyperlinkSelectedLink                ,
#if defined(ENABLE_OVERLOADING)
    hyperlinkSelectedLink                   ,
#endif


-- ** startIndex #attr:startIndex#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    HyperlinkStartIndexPropertyInfo         ,
#endif
    getHyperlinkStartIndex                  ,
#if defined(ENABLE_OVERLOADING)
    hyperlinkStartIndex                     ,
#endif




 -- * Signals


-- ** linkActivated #signal:linkActivated#

    HyperlinkLinkActivatedCallback          ,
#if defined(ENABLE_OVERLOADING)
    HyperlinkLinkActivatedSignalInfo        ,
#endif
    afterHyperlinkLinkActivated             ,
    onHyperlinkLinkActivated                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype Hyperlink = Hyperlink (SP.ManagedPtr Hyperlink)
    deriving (Eq)

instance SP.ManagedPtrNewtype Hyperlink where
    toManagedPtr (Hyperlink p) = p

foreign import ccall "atk_hyperlink_get_type"
    c_atk_hyperlink_get_type :: IO B.Types.GType

instance B.Types.TypedObject Hyperlink where
    glibType = c_atk_hyperlink_get_type

instance B.Types.GObject Hyperlink

-- | Type class for types which can be safely cast to `Hyperlink`, for instance with `toHyperlink`.
class (SP.GObject o, O.IsDescendantOf Hyperlink o) => IsHyperlink o
instance (SP.GObject o, O.IsDescendantOf Hyperlink o) => IsHyperlink o

instance O.HasParentTypes Hyperlink
type instance O.ParentTypes Hyperlink = '[GObject.Object.Object, Atk.Action.Action]

-- | Cast to `Hyperlink`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toHyperlink :: (MIO.MonadIO m, IsHyperlink o) => o -> m Hyperlink
toHyperlink = MIO.liftIO . B.ManagedPtr.unsafeCastTo Hyperlink

-- | Convert 'Hyperlink' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Hyperlink) where
    gvalueGType_ = c_atk_hyperlink_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Hyperlink)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Hyperlink)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Hyperlink ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveHyperlinkMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveHyperlinkMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveHyperlinkMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveHyperlinkMethod "doAction" o = Atk.Action.ActionDoActionMethodInfo
    ResolveHyperlinkMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveHyperlinkMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveHyperlinkMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveHyperlinkMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveHyperlinkMethod "isInline" o = HyperlinkIsInlineMethodInfo
    ResolveHyperlinkMethod "isSelectedLink" o = HyperlinkIsSelectedLinkMethodInfo
    ResolveHyperlinkMethod "isValid" o = HyperlinkIsValidMethodInfo
    ResolveHyperlinkMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveHyperlinkMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveHyperlinkMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveHyperlinkMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveHyperlinkMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveHyperlinkMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveHyperlinkMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveHyperlinkMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveHyperlinkMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveHyperlinkMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveHyperlinkMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveHyperlinkMethod "getDescription" o = Atk.Action.ActionGetDescriptionMethodInfo
    ResolveHyperlinkMethod "getEndIndex" o = HyperlinkGetEndIndexMethodInfo
    ResolveHyperlinkMethod "getKeybinding" o = Atk.Action.ActionGetKeybindingMethodInfo
    ResolveHyperlinkMethod "getLocalizedName" o = Atk.Action.ActionGetLocalizedNameMethodInfo
    ResolveHyperlinkMethod "getNActions" o = Atk.Action.ActionGetNActionsMethodInfo
    ResolveHyperlinkMethod "getNAnchors" o = HyperlinkGetNAnchorsMethodInfo
    ResolveHyperlinkMethod "getName" o = Atk.Action.ActionGetNameMethodInfo
    ResolveHyperlinkMethod "getObject" o = HyperlinkGetObjectMethodInfo
    ResolveHyperlinkMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveHyperlinkMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveHyperlinkMethod "getStartIndex" o = HyperlinkGetStartIndexMethodInfo
    ResolveHyperlinkMethod "getUri" o = HyperlinkGetUriMethodInfo
    ResolveHyperlinkMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveHyperlinkMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveHyperlinkMethod "setDescription" o = Atk.Action.ActionSetDescriptionMethodInfo
    ResolveHyperlinkMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveHyperlinkMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveHyperlinkMethod t Hyperlink, O.OverloadedMethod info Hyperlink p) => OL.IsLabel t (Hyperlink -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveHyperlinkMethod t Hyperlink, O.OverloadedMethod info Hyperlink p, R.HasField t Hyperlink p) => R.HasField t Hyperlink p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveHyperlinkMethod t Hyperlink, O.OverloadedMethodInfo info Hyperlink) => OL.IsLabel t (O.MethodProxy info Hyperlink) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Hyperlink::link-activated
-- | The signal link-activated is emitted when a link is activated.
type HyperlinkLinkActivatedCallback =
    IO ()

type C_HyperlinkLinkActivatedCallback =
    Ptr Hyperlink ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_HyperlinkLinkActivatedCallback`.
foreign import ccall "wrapper"
    mk_HyperlinkLinkActivatedCallback :: C_HyperlinkLinkActivatedCallback -> IO (FunPtr C_HyperlinkLinkActivatedCallback)

wrap_HyperlinkLinkActivatedCallback :: 
    GObject a => (a -> HyperlinkLinkActivatedCallback) ->
    C_HyperlinkLinkActivatedCallback
wrap_HyperlinkLinkActivatedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [linkActivated](#signal:linkActivated) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' hyperlink #linkActivated callback
-- @
-- 
-- 
onHyperlinkLinkActivated :: (IsHyperlink a, MonadIO m) => a -> ((?self :: a) => HyperlinkLinkActivatedCallback) -> m SignalHandlerId
onHyperlinkLinkActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_HyperlinkLinkActivatedCallback wrapped
    wrapped'' <- mk_HyperlinkLinkActivatedCallback wrapped'
    connectSignalFunPtr obj "link-activated" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [linkActivated](#signal:linkActivated) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' hyperlink #linkActivated callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterHyperlinkLinkActivated :: (IsHyperlink a, MonadIO m) => a -> ((?self :: a) => HyperlinkLinkActivatedCallback) -> m SignalHandlerId
afterHyperlinkLinkActivated obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_HyperlinkLinkActivatedCallback wrapped
    wrapped'' <- mk_HyperlinkLinkActivatedCallback wrapped'
    connectSignalFunPtr obj "link-activated" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data HyperlinkLinkActivatedSignalInfo
instance SignalInfo HyperlinkLinkActivatedSignalInfo where
    type HaskellCallbackType HyperlinkLinkActivatedSignalInfo = HyperlinkLinkActivatedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_HyperlinkLinkActivatedCallback cb
        cb'' <- mk_HyperlinkLinkActivatedCallback cb'
        connectSignalFunPtr obj "link-activated" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink::link-activated"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#g:signal:linkActivated"})

#endif

-- VVV Prop "end-index"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@end-index@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hyperlink #endIndex
-- @
getHyperlinkEndIndex :: (MonadIO m, IsHyperlink o) => o -> m Int32
getHyperlinkEndIndex obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "end-index"

#if defined(ENABLE_OVERLOADING)
data HyperlinkEndIndexPropertyInfo
instance AttrInfo HyperlinkEndIndexPropertyInfo where
    type AttrAllowedOps HyperlinkEndIndexPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint HyperlinkEndIndexPropertyInfo = IsHyperlink
    type AttrSetTypeConstraint HyperlinkEndIndexPropertyInfo = (~) ()
    type AttrTransferTypeConstraint HyperlinkEndIndexPropertyInfo = (~) ()
    type AttrTransferType HyperlinkEndIndexPropertyInfo = ()
    type AttrGetType HyperlinkEndIndexPropertyInfo = Int32
    type AttrLabel HyperlinkEndIndexPropertyInfo = "end-index"
    type AttrOrigin HyperlinkEndIndexPropertyInfo = Hyperlink
    attrGet = getHyperlinkEndIndex
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.endIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#g:attr:endIndex"
        })
#endif

-- VVV Prop "number-of-anchors"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@number-of-anchors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hyperlink #numberOfAnchors
-- @
getHyperlinkNumberOfAnchors :: (MonadIO m, IsHyperlink o) => o -> m Int32
getHyperlinkNumberOfAnchors obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "number-of-anchors"

#if defined(ENABLE_OVERLOADING)
data HyperlinkNumberOfAnchorsPropertyInfo
instance AttrInfo HyperlinkNumberOfAnchorsPropertyInfo where
    type AttrAllowedOps HyperlinkNumberOfAnchorsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint HyperlinkNumberOfAnchorsPropertyInfo = IsHyperlink
    type AttrSetTypeConstraint HyperlinkNumberOfAnchorsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint HyperlinkNumberOfAnchorsPropertyInfo = (~) ()
    type AttrTransferType HyperlinkNumberOfAnchorsPropertyInfo = ()
    type AttrGetType HyperlinkNumberOfAnchorsPropertyInfo = Int32
    type AttrLabel HyperlinkNumberOfAnchorsPropertyInfo = "number-of-anchors"
    type AttrOrigin HyperlinkNumberOfAnchorsPropertyInfo = Hyperlink
    attrGet = getHyperlinkNumberOfAnchors
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.numberOfAnchors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#g:attr:numberOfAnchors"
        })
#endif

-- VVV Prop "selected-link"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@selected-link@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hyperlink #selectedLink
-- @
getHyperlinkSelectedLink :: (MonadIO m, IsHyperlink o) => o -> m Bool
getHyperlinkSelectedLink obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "selected-link"

#if defined(ENABLE_OVERLOADING)
data HyperlinkSelectedLinkPropertyInfo
instance AttrInfo HyperlinkSelectedLinkPropertyInfo where
    type AttrAllowedOps HyperlinkSelectedLinkPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint HyperlinkSelectedLinkPropertyInfo = IsHyperlink
    type AttrSetTypeConstraint HyperlinkSelectedLinkPropertyInfo = (~) ()
    type AttrTransferTypeConstraint HyperlinkSelectedLinkPropertyInfo = (~) ()
    type AttrTransferType HyperlinkSelectedLinkPropertyInfo = ()
    type AttrGetType HyperlinkSelectedLinkPropertyInfo = Bool
    type AttrLabel HyperlinkSelectedLinkPropertyInfo = "selected-link"
    type AttrOrigin HyperlinkSelectedLinkPropertyInfo = Hyperlink
    attrGet = getHyperlinkSelectedLink
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.selectedLink"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#g:attr:selectedLink"
        })
#endif

-- VVV Prop "start-index"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@start-index@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' hyperlink #startIndex
-- @
getHyperlinkStartIndex :: (MonadIO m, IsHyperlink o) => o -> m Int32
getHyperlinkStartIndex obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "start-index"

#if defined(ENABLE_OVERLOADING)
data HyperlinkStartIndexPropertyInfo
instance AttrInfo HyperlinkStartIndexPropertyInfo where
    type AttrAllowedOps HyperlinkStartIndexPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint HyperlinkStartIndexPropertyInfo = IsHyperlink
    type AttrSetTypeConstraint HyperlinkStartIndexPropertyInfo = (~) ()
    type AttrTransferTypeConstraint HyperlinkStartIndexPropertyInfo = (~) ()
    type AttrTransferType HyperlinkStartIndexPropertyInfo = ()
    type AttrGetType HyperlinkStartIndexPropertyInfo = Int32
    type AttrLabel HyperlinkStartIndexPropertyInfo = "start-index"
    type AttrOrigin HyperlinkStartIndexPropertyInfo = Hyperlink
    attrGet = getHyperlinkStartIndex
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.startIndex"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#g:attr:startIndex"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Hyperlink
type instance O.AttributeList Hyperlink = HyperlinkAttributeList
type HyperlinkAttributeList = ('[ '("endIndex", HyperlinkEndIndexPropertyInfo), '("numberOfAnchors", HyperlinkNumberOfAnchorsPropertyInfo), '("selectedLink", HyperlinkSelectedLinkPropertyInfo), '("startIndex", HyperlinkStartIndexPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
hyperlinkEndIndex :: AttrLabelProxy "endIndex"
hyperlinkEndIndex = AttrLabelProxy

hyperlinkNumberOfAnchors :: AttrLabelProxy "numberOfAnchors"
hyperlinkNumberOfAnchors = AttrLabelProxy

hyperlinkSelectedLink :: AttrLabelProxy "selectedLink"
hyperlinkSelectedLink = AttrLabelProxy

hyperlinkStartIndex :: AttrLabelProxy "startIndex"
hyperlinkStartIndex = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Hyperlink = HyperlinkSignalList
type HyperlinkSignalList = ('[ '("linkActivated", HyperlinkLinkActivatedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Hyperlink::get_end_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_get_end_index" atk_hyperlink_get_end_index :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO Int32

-- | Gets the index with the hypertext document at which this link ends.
hyperlinkGetEndIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Int32
    -- ^ __Returns:__ the index with the hypertext document at which this link ends
hyperlinkGetEndIndex link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_get_end_index link_'
    touchManagedPtr link_
    return result

#if defined(ENABLE_OVERLOADING)
data HyperlinkGetEndIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkGetEndIndexMethodInfo a signature where
    overloadedMethod = hyperlinkGetEndIndex

instance O.OverloadedMethodInfo HyperlinkGetEndIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkGetEndIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkGetEndIndex"
        })


#endif

-- method Hyperlink::get_n_anchors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_get_n_anchors" atk_hyperlink_get_n_anchors :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO Int32

-- | Gets the number of anchors associated with this hyperlink.
hyperlinkGetNAnchors ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Int32
    -- ^ __Returns:__ the number of anchors associated with this hyperlink
hyperlinkGetNAnchors link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_get_n_anchors link_'
    touchManagedPtr link_
    return result

#if defined(ENABLE_OVERLOADING)
data HyperlinkGetNAnchorsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkGetNAnchorsMethodInfo a signature where
    overloadedMethod = hyperlinkGetNAnchors

instance O.OverloadedMethodInfo HyperlinkGetNAnchorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkGetNAnchors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkGetNAnchors"
        })


#endif

-- method Hyperlink::get_object
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a (zero-index) integer specifying the desired anchor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_get_object" atk_hyperlink_get_object :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    Int32 ->                                -- i : TBasicType TInt
    IO (Ptr Atk.Object.Object)

-- | Returns the item associated with this hyperlinks nth anchor.
-- For instance, the returned t'GI.Atk.Objects.Object.Object' will implement t'GI.Atk.Interfaces.Text.Text'
-- if /@link_@/ is a text hyperlink, t'GI.Atk.Interfaces.Image.Image' if /@link_@/ is an image
-- hyperlink etc.
-- 
-- Multiple anchors are primarily used by client-side image maps.
hyperlinkGetObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> Int32
    -- ^ /@i@/: a (zero-index) integer specifying the desired anchor
    -> m Atk.Object.Object
    -- ^ __Returns:__ an t'GI.Atk.Objects.Object.Object' associated with this hyperlinks
    -- i-th anchor
hyperlinkGetObject link_ i = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_get_object link_' i
    checkUnexpectedReturnNULL "hyperlinkGetObject" result
    result' <- (newObject Atk.Object.Object) result
    touchManagedPtr link_
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkGetObjectMethodInfo
instance (signature ~ (Int32 -> m Atk.Object.Object), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkGetObjectMethodInfo a signature where
    overloadedMethod = hyperlinkGetObject

instance O.OverloadedMethodInfo HyperlinkGetObjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkGetObject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkGetObject"
        })


#endif

-- method Hyperlink::get_start_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_get_start_index" atk_hyperlink_get_start_index :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO Int32

-- | Gets the index with the hypertext document at which this link begins.
hyperlinkGetStartIndex ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Int32
    -- ^ __Returns:__ the index with the hypertext document at which this link begins
hyperlinkGetStartIndex link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_get_start_index link_'
    touchManagedPtr link_
    return result

#if defined(ENABLE_OVERLOADING)
data HyperlinkGetStartIndexMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkGetStartIndexMethodInfo a signature where
    overloadedMethod = hyperlinkGetStartIndex

instance O.OverloadedMethodInfo HyperlinkGetStartIndexMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkGetStartIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkGetStartIndex"
        })


#endif

-- method Hyperlink::get_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a (zero-index) integer specifying the desired anchor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_get_uri" atk_hyperlink_get_uri :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    Int32 ->                                -- i : TBasicType TInt
    IO CString

-- | Get a the URI associated with the anchor specified
-- by /@i@/ of /@link_@/.
-- 
-- Multiple anchors are primarily used by client-side image maps.
hyperlinkGetUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> Int32
    -- ^ /@i@/: a (zero-index) integer specifying the desired anchor
    -> m T.Text
    -- ^ __Returns:__ a string specifying the URI
hyperlinkGetUri link_ i = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_get_uri link_' i
    checkUnexpectedReturnNULL "hyperlinkGetUri" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr link_
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkGetUriMethodInfo
instance (signature ~ (Int32 -> m T.Text), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkGetUriMethodInfo a signature where
    overloadedMethod = hyperlinkGetUri

instance O.OverloadedMethodInfo HyperlinkGetUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkGetUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkGetUri"
        })


#endif

-- method Hyperlink::is_inline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_is_inline" atk_hyperlink_is_inline :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO CInt

-- | Indicates whether the link currently displays some or all of its
--           content inline.  Ordinary HTML links will usually return
--           'P.False', but an inline &lt;src&gt; HTML element will return
--           'P.True'.
hyperlinkIsInline ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Bool
    -- ^ __Returns:__ whether or not this link displays its content inline.
hyperlinkIsInline link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_is_inline link_'
    let result' = (/= 0) result
    touchManagedPtr link_
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkIsInlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkIsInlineMethodInfo a signature where
    overloadedMethod = hyperlinkIsInline

instance O.OverloadedMethodInfo HyperlinkIsInlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkIsInline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkIsInline"
        })


#endif

-- method Hyperlink::is_selected_link
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_is_selected_link" atk_hyperlink_is_selected_link :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO CInt

{-# DEPRECATED hyperlinkIsSelectedLink ["(Since version 1.8)","Please use ATK_STATE_FOCUSABLE for all links,","and ATK_STATE_FOCUSED for focused links."] #-}
-- | Determines whether this AtkHyperlink is selected
-- 
-- /Since: 1.4/
hyperlinkIsSelectedLink ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Bool
    -- ^ __Returns:__ True if the AtkHyperlink is selected, False otherwise
hyperlinkIsSelectedLink link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_is_selected_link link_'
    let result' = (/= 0) result
    touchManagedPtr link_
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkIsSelectedLinkMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkIsSelectedLinkMethodInfo a signature where
    overloadedMethod = hyperlinkIsSelectedLink

instance O.OverloadedMethodInfo HyperlinkIsSelectedLinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkIsSelectedLink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkIsSelectedLink"
        })


#endif

-- method Hyperlink::is_valid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "link_"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Hyperlink" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkHyperlink" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_hyperlink_is_valid" atk_hyperlink_is_valid :: 
    Ptr Hyperlink ->                        -- link_ : TInterface (Name {namespace = "Atk", name = "Hyperlink"})
    IO CInt

-- | Since the document that a link is associated with may have changed
-- this method returns 'P.True' if the link is still valid (with
-- respect to the document it references) and 'P.False' otherwise.
hyperlinkIsValid ::
    (B.CallStack.HasCallStack, MonadIO m, IsHyperlink a) =>
    a
    -- ^ /@link_@/: an t'GI.Atk.Objects.Hyperlink.Hyperlink'
    -> m Bool
    -- ^ __Returns:__ whether or not this link is still valid
hyperlinkIsValid link_ = liftIO $ do
    link_' <- unsafeManagedPtrCastPtr link_
    result <- atk_hyperlink_is_valid link_'
    let result' = (/= 0) result
    touchManagedPtr link_
    return result'

#if defined(ENABLE_OVERLOADING)
data HyperlinkIsValidMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsHyperlink a) => O.OverloadedMethod HyperlinkIsValidMethodInfo a signature where
    overloadedMethod = hyperlinkIsValid

instance O.OverloadedMethodInfo HyperlinkIsValidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.Hyperlink.hyperlinkIsValid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-Hyperlink.html#v:hyperlinkIsValid"
        })


#endif


