{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This object class is derived from AtkObject and can be used as a basis implementing accessible objects.
-- 
-- This object class is derived from AtkObject. It can be used as a
-- basis for implementing accessible objects for GObjects which are
-- not derived from GtkWidget. One example of its use is in providing
-- an accessible object for GnomeCanvasItem in the GAIL library.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.GObjectAccessible
    ( 

-- * Exported types
    GObjectAccessible(..)                   ,
    IsGObjectAccessible                     ,
    toGObjectAccessible                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addRelationship]("GI.Atk.Objects.Object#g:method:addRelationship"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [initialize]("GI.Atk.Objects.Object#g:method:initialize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStateChange]("GI.Atk.Objects.Object#g:method:notifyStateChange"), [peekParent]("GI.Atk.Objects.Object#g:method:peekParent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refAccessibleChild]("GI.Atk.Objects.Object#g:method:refAccessibleChild"), [refRelationSet]("GI.Atk.Objects.Object#g:method:refRelationSet"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStateSet]("GI.Atk.Objects.Object#g:method:refStateSet"), [removePropertyChangeHandler]("GI.Atk.Objects.Object#g:method:removePropertyChangeHandler"), [removeRelationship]("GI.Atk.Objects.Object#g:method:removeRelationship"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleId]("GI.Atk.Objects.Object#g:method:getAccessibleId"), [getAttributes]("GI.Atk.Objects.Object#g:method:getAttributes"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Atk.Objects.Object#g:method:getDescription"), [getHelpText]("GI.Atk.Objects.Object#g:method:getHelpText"), [getIndexInParent]("GI.Atk.Objects.Object#g:method:getIndexInParent"), [getLayer]("GI.Atk.Objects.Object#g:method:getLayer"), [getMdiZorder]("GI.Atk.Objects.Object#g:method:getMdiZorder"), [getNAccessibleChildren]("GI.Atk.Objects.Object#g:method:getNAccessibleChildren"), [getName]("GI.Atk.Objects.Object#g:method:getName"), [getObject]("GI.Atk.Objects.GObjectAccessible#g:method:getObject"), [getObjectLocale]("GI.Atk.Objects.Object#g:method:getObjectLocale"), [getParent]("GI.Atk.Objects.Object#g:method:getParent"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRole]("GI.Atk.Objects.Object#g:method:getRole").
-- 
-- ==== Setters
-- [setAccessibleId]("GI.Atk.Objects.Object#g:method:setAccessibleId"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Objects.Object#g:method:setDescription"), [setHelpText]("GI.Atk.Objects.Object#g:method:setHelpText"), [setName]("GI.Atk.Objects.Object#g:method:setName"), [setParent]("GI.Atk.Objects.Object#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Atk.Objects.Object#g:method:setRole").

#if defined(ENABLE_OVERLOADING)
    ResolveGObjectAccessibleMethod          ,
#endif

-- ** forObject #method:forObject#

    gObjectAccessibleForObject              ,


-- ** getObject #method:getObject#

#if defined(ENABLE_OVERLOADING)
    GObjectAccessibleGetObjectMethodInfo    ,
#endif
    gObjectAccessibleGetObject              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype GObjectAccessible = GObjectAccessible (SP.ManagedPtr GObjectAccessible)
    deriving (Eq)

instance SP.ManagedPtrNewtype GObjectAccessible where
    toManagedPtr (GObjectAccessible p) = p

foreign import ccall "atk_gobject_accessible_get_type"
    c_atk_gobject_accessible_get_type :: IO B.Types.GType

instance B.Types.TypedObject GObjectAccessible where
    glibType = c_atk_gobject_accessible_get_type

instance B.Types.GObject GObjectAccessible

-- | Type class for types which can be safely cast to `GObjectAccessible`, for instance with `toGObjectAccessible`.
class (SP.GObject o, O.IsDescendantOf GObjectAccessible o) => IsGObjectAccessible o
instance (SP.GObject o, O.IsDescendantOf GObjectAccessible o) => IsGObjectAccessible o

instance O.HasParentTypes GObjectAccessible
type instance O.ParentTypes GObjectAccessible = '[Atk.Object.Object, GObject.Object.Object]

-- | Cast to `GObjectAccessible`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toGObjectAccessible :: (MIO.MonadIO m, IsGObjectAccessible o) => o -> m GObjectAccessible
toGObjectAccessible = MIO.liftIO . B.ManagedPtr.unsafeCastTo GObjectAccessible

-- | Convert 'GObjectAccessible' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GObjectAccessible) where
    gvalueGType_ = c_atk_gobject_accessible_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GObjectAccessible)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GObjectAccessible)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GObjectAccessible ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGObjectAccessibleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGObjectAccessibleMethod "addRelationship" o = Atk.Object.ObjectAddRelationshipMethodInfo
    ResolveGObjectAccessibleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGObjectAccessibleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGObjectAccessibleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGObjectAccessibleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGObjectAccessibleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGObjectAccessibleMethod "initialize" o = Atk.Object.ObjectInitializeMethodInfo
    ResolveGObjectAccessibleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGObjectAccessibleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGObjectAccessibleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGObjectAccessibleMethod "notifyStateChange" o = Atk.Object.ObjectNotifyStateChangeMethodInfo
    ResolveGObjectAccessibleMethod "peekParent" o = Atk.Object.ObjectPeekParentMethodInfo
    ResolveGObjectAccessibleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGObjectAccessibleMethod "refAccessibleChild" o = Atk.Object.ObjectRefAccessibleChildMethodInfo
    ResolveGObjectAccessibleMethod "refRelationSet" o = Atk.Object.ObjectRefRelationSetMethodInfo
    ResolveGObjectAccessibleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGObjectAccessibleMethod "refStateSet" o = Atk.Object.ObjectRefStateSetMethodInfo
    ResolveGObjectAccessibleMethod "removePropertyChangeHandler" o = Atk.Object.ObjectRemovePropertyChangeHandlerMethodInfo
    ResolveGObjectAccessibleMethod "removeRelationship" o = Atk.Object.ObjectRemoveRelationshipMethodInfo
    ResolveGObjectAccessibleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGObjectAccessibleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGObjectAccessibleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGObjectAccessibleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGObjectAccessibleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGObjectAccessibleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGObjectAccessibleMethod "getAccessibleId" o = Atk.Object.ObjectGetAccessibleIdMethodInfo
    ResolveGObjectAccessibleMethod "getAttributes" o = Atk.Object.ObjectGetAttributesMethodInfo
    ResolveGObjectAccessibleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGObjectAccessibleMethod "getDescription" o = Atk.Object.ObjectGetDescriptionMethodInfo
    ResolveGObjectAccessibleMethod "getHelpText" o = Atk.Object.ObjectGetHelpTextMethodInfo
    ResolveGObjectAccessibleMethod "getIndexInParent" o = Atk.Object.ObjectGetIndexInParentMethodInfo
    ResolveGObjectAccessibleMethod "getLayer" o = Atk.Object.ObjectGetLayerMethodInfo
    ResolveGObjectAccessibleMethod "getMdiZorder" o = Atk.Object.ObjectGetMdiZorderMethodInfo
    ResolveGObjectAccessibleMethod "getNAccessibleChildren" o = Atk.Object.ObjectGetNAccessibleChildrenMethodInfo
    ResolveGObjectAccessibleMethod "getName" o = Atk.Object.ObjectGetNameMethodInfo
    ResolveGObjectAccessibleMethod "getObject" o = GObjectAccessibleGetObjectMethodInfo
    ResolveGObjectAccessibleMethod "getObjectLocale" o = Atk.Object.ObjectGetObjectLocaleMethodInfo
    ResolveGObjectAccessibleMethod "getParent" o = Atk.Object.ObjectGetParentMethodInfo
    ResolveGObjectAccessibleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGObjectAccessibleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGObjectAccessibleMethod "getRole" o = Atk.Object.ObjectGetRoleMethodInfo
    ResolveGObjectAccessibleMethod "setAccessibleId" o = Atk.Object.ObjectSetAccessibleIdMethodInfo
    ResolveGObjectAccessibleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGObjectAccessibleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGObjectAccessibleMethod "setDescription" o = Atk.Object.ObjectSetDescriptionMethodInfo
    ResolveGObjectAccessibleMethod "setHelpText" o = Atk.Object.ObjectSetHelpTextMethodInfo
    ResolveGObjectAccessibleMethod "setName" o = Atk.Object.ObjectSetNameMethodInfo
    ResolveGObjectAccessibleMethod "setParent" o = Atk.Object.ObjectSetParentMethodInfo
    ResolveGObjectAccessibleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGObjectAccessibleMethod "setRole" o = Atk.Object.ObjectSetRoleMethodInfo
    ResolveGObjectAccessibleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGObjectAccessibleMethod t GObjectAccessible, O.OverloadedMethod info GObjectAccessible p) => OL.IsLabel t (GObjectAccessible -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGObjectAccessibleMethod t GObjectAccessible, O.OverloadedMethod info GObjectAccessible p, R.HasField t GObjectAccessible p) => R.HasField t GObjectAccessible p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGObjectAccessibleMethod t GObjectAccessible, O.OverloadedMethodInfo info GObjectAccessible) => OL.IsLabel t (O.MethodProxy info GObjectAccessible) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GObjectAccessible
type instance O.AttributeList GObjectAccessible = GObjectAccessibleAttributeList
type GObjectAccessibleAttributeList = ('[ '("accessibleComponentLayer", Atk.Object.ObjectAccessibleComponentLayerPropertyInfo), '("accessibleComponentMdiZorder", Atk.Object.ObjectAccessibleComponentMdiZorderPropertyInfo), '("accessibleDescription", Atk.Object.ObjectAccessibleDescriptionPropertyInfo), '("accessibleHelpText", Atk.Object.ObjectAccessibleHelpTextPropertyInfo), '("accessibleHypertextNlinks", Atk.Object.ObjectAccessibleHypertextNlinksPropertyInfo), '("accessibleId", Atk.Object.ObjectAccessibleIdPropertyInfo), '("accessibleName", Atk.Object.ObjectAccessibleNamePropertyInfo), '("accessibleParent", Atk.Object.ObjectAccessibleParentPropertyInfo), '("accessibleRole", Atk.Object.ObjectAccessibleRolePropertyInfo), '("accessibleTableCaption", Atk.Object.ObjectAccessibleTableCaptionPropertyInfo), '("accessibleTableCaptionObject", Atk.Object.ObjectAccessibleTableCaptionObjectPropertyInfo), '("accessibleTableColumnDescription", Atk.Object.ObjectAccessibleTableColumnDescriptionPropertyInfo), '("accessibleTableColumnHeader", Atk.Object.ObjectAccessibleTableColumnHeaderPropertyInfo), '("accessibleTableRowDescription", Atk.Object.ObjectAccessibleTableRowDescriptionPropertyInfo), '("accessibleTableRowHeader", Atk.Object.ObjectAccessibleTableRowHeaderPropertyInfo), '("accessibleTableSummary", Atk.Object.ObjectAccessibleTableSummaryPropertyInfo), '("accessibleValue", Atk.Object.ObjectAccessibleValuePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GObjectAccessible = GObjectAccessibleSignalList
type GObjectAccessibleSignalList = ('[ '("activeDescendantChanged", Atk.Object.ObjectActiveDescendantChangedSignalInfo), '("announcement", Atk.Object.ObjectAnnouncementSignalInfo), '("attributeChanged", Atk.Object.ObjectAttributeChangedSignalInfo), '("childrenChanged", Atk.Object.ObjectChildrenChangedSignalInfo), '("focusEvent", Atk.Object.ObjectFocusEventSignalInfo), '("notification", Atk.Object.ObjectNotificationSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("propertyChange", Atk.Object.ObjectPropertyChangeSignalInfo), '("stateChange", Atk.Object.ObjectStateChangeSignalInfo), '("visibleDataChanged", Atk.Object.ObjectVisibleDataChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GObjectAccessible::get_object
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "obj"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "GObjectAccessible" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #AtkGObjectAccessible"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_gobject_accessible_get_object" atk_gobject_accessible_get_object :: 
    Ptr GObjectAccessible ->                -- obj : TInterface (Name {namespace = "Atk", name = "GObjectAccessible"})
    IO (Ptr GObject.Object.Object)

-- | Gets the GObject for which /@obj@/ is the accessible object.
gObjectAccessibleGetObject ::
    (B.CallStack.HasCallStack, MonadIO m, IsGObjectAccessible a) =>
    a
    -- ^ /@obj@/: a t'GI.Atk.Objects.GObjectAccessible.GObjectAccessible'
    -> m GObject.Object.Object
    -- ^ __Returns:__ a t'GI.GObject.Objects.Object.Object' which is the object for which /@obj@/ is
    -- the accessible object
gObjectAccessibleGetObject obj = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    result <- atk_gobject_accessible_get_object obj'
    checkUnexpectedReturnNULL "gObjectAccessibleGetObject" result
    result' <- (newObject GObject.Object.Object) result
    touchManagedPtr obj
    return result'

#if defined(ENABLE_OVERLOADING)
data GObjectAccessibleGetObjectMethodInfo
instance (signature ~ (m GObject.Object.Object), MonadIO m, IsGObjectAccessible a) => O.OverloadedMethod GObjectAccessibleGetObjectMethodInfo a signature where
    overloadedMethod = gObjectAccessibleGetObject

instance O.OverloadedMethodInfo GObjectAccessibleGetObjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Objects.GObjectAccessible.gObjectAccessibleGetObject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Objects-GObjectAccessible.html#v:gObjectAccessibleGetObject"
        })


#endif

-- method GObjectAccessible::for_object
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "obj"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_gobject_accessible_for_object" atk_gobject_accessible_for_object :: 
    Ptr GObject.Object.Object ->            -- obj : TInterface (Name {namespace = "GObject", name = "Object"})
    IO (Ptr Atk.Object.Object)

-- | Gets the accessible object for the specified /@obj@/.
gObjectAccessibleForObject ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@obj@/: a t'GI.GObject.Objects.Object.Object'
    -> m Atk.Object.Object
    -- ^ __Returns:__ a t'GI.Atk.Objects.Object.Object' which is the accessible object for
    -- the /@obj@/
gObjectAccessibleForObject obj = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    result <- atk_gobject_accessible_for_object obj'
    checkUnexpectedReturnNULL "gObjectAccessibleForObject" result
    result' <- (newObject Atk.Object.Object) result
    touchManagedPtr obj
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


