{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK interface implemented by container objects whose t'GI.Atk.Objects.Object.Object' children can be selected.
-- 
-- t'GI.Atk.Interfaces.Selection.Selection' should be implemented by UI components with children
-- which are exposed by @/atk_object_ref_child/@ and
-- @/atk_object_get_n_children/@, if the use of the parent UI component
-- ordinarily involves selection of one or more of the objects
-- corresponding to those t'GI.Atk.Objects.Object.Object' children - for example,
-- selectable lists.
-- 
-- Note that other types of \"selection\" (for instance text selection)
-- are accomplished a other ATK interfaces - t'GI.Atk.Interfaces.Selection.Selection' is limited
-- to the selection\/deselection of children.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.Selection
    ( 

-- * Exported types
    Selection(..)                           ,
    IsSelection                             ,
    toSelection                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addSelection]("GI.Atk.Interfaces.Selection#g:method:addSelection"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearSelection]("GI.Atk.Interfaces.Selection#g:method:clearSelection"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isChildSelected]("GI.Atk.Interfaces.Selection#g:method:isChildSelected"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSelection]("GI.Atk.Interfaces.Selection#g:method:refSelection"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeSelection]("GI.Atk.Interfaces.Selection#g:method:removeSelection"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectAllSelection]("GI.Atk.Interfaces.Selection#g:method:selectAllSelection"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectionCount]("GI.Atk.Interfaces.Selection#g:method:getSelectionCount").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSelectionMethod                  ,
#endif

-- ** addSelection #method:addSelection#

#if defined(ENABLE_OVERLOADING)
    SelectionAddSelectionMethodInfo         ,
#endif
    selectionAddSelection                   ,


-- ** clearSelection #method:clearSelection#

#if defined(ENABLE_OVERLOADING)
    SelectionClearSelectionMethodInfo       ,
#endif
    selectionClearSelection                 ,


-- ** getSelectionCount #method:getSelectionCount#

#if defined(ENABLE_OVERLOADING)
    SelectionGetSelectionCountMethodInfo    ,
#endif
    selectionGetSelectionCount              ,


-- ** isChildSelected #method:isChildSelected#

#if defined(ENABLE_OVERLOADING)
    SelectionIsChildSelectedMethodInfo      ,
#endif
    selectionIsChildSelected                ,


-- ** refSelection #method:refSelection#

#if defined(ENABLE_OVERLOADING)
    SelectionRefSelectionMethodInfo         ,
#endif
    selectionRefSelection                   ,


-- ** removeSelection #method:removeSelection#

#if defined(ENABLE_OVERLOADING)
    SelectionRemoveSelectionMethodInfo      ,
#endif
    selectionRemoveSelection                ,


-- ** selectAllSelection #method:selectAllSelection#

#if defined(ENABLE_OVERLOADING)
    SelectionSelectAllSelectionMethodInfo   ,
#endif
    selectionSelectAllSelection             ,




 -- * Signals


-- ** selectionChanged #signal:selectionChanged#

    SelectionSelectionChangedCallback       ,
#if defined(ENABLE_OVERLOADING)
    SelectionSelectionChangedSignalInfo     ,
#endif
    afterSelectionSelectionChanged          ,
    onSelectionSelectionChanged             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface Selection 
-- | Memory-managed wrapper type.
newtype Selection = Selection (SP.ManagedPtr Selection)
    deriving (Eq)

instance SP.ManagedPtrNewtype Selection where
    toManagedPtr (Selection p) = p

foreign import ccall "atk_selection_get_type"
    c_atk_selection_get_type :: IO B.Types.GType

instance B.Types.TypedObject Selection where
    glibType = c_atk_selection_get_type

instance B.Types.GObject Selection

-- | Type class for types which can be safely cast to `Selection`, for instance with `toSelection`.
class (SP.GObject o, O.IsDescendantOf Selection o) => IsSelection o
instance (SP.GObject o, O.IsDescendantOf Selection o) => IsSelection o

instance O.HasParentTypes Selection
type instance O.ParentTypes Selection = '[GObject.Object.Object]

-- | Cast to `Selection`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSelection :: (MIO.MonadIO m, IsSelection o) => o -> m Selection
toSelection = MIO.liftIO . B.ManagedPtr.unsafeCastTo Selection

-- | Convert 'Selection' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Selection) where
    gvalueGType_ = c_atk_selection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Selection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Selection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Selection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Selection
type instance O.AttributeList Selection = SelectionAttributeList
type SelectionAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSelectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSelectionMethod "addSelection" o = SelectionAddSelectionMethodInfo
    ResolveSelectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSelectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSelectionMethod "clearSelection" o = SelectionClearSelectionMethodInfo
    ResolveSelectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSelectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSelectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSelectionMethod "isChildSelected" o = SelectionIsChildSelectedMethodInfo
    ResolveSelectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSelectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSelectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSelectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSelectionMethod "refSelection" o = SelectionRefSelectionMethodInfo
    ResolveSelectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSelectionMethod "removeSelection" o = SelectionRemoveSelectionMethodInfo
    ResolveSelectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSelectionMethod "selectAllSelection" o = SelectionSelectAllSelectionMethodInfo
    ResolveSelectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSelectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSelectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSelectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSelectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSelectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSelectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSelectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSelectionMethod "getSelectionCount" o = SelectionGetSelectionCountMethodInfo
    ResolveSelectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSelectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSelectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSelectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSelectionMethod t Selection, O.OverloadedMethod info Selection p) => OL.IsLabel t (Selection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSelectionMethod t Selection, O.OverloadedMethod info Selection p, R.HasField t Selection p) => R.HasField t Selection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSelectionMethod t Selection, O.OverloadedMethodInfo info Selection) => OL.IsLabel t (O.MethodProxy info Selection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Selection::add_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gint specifying the child index."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_add_selection" atk_selection_add_selection :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    Int32 ->                                -- i : TBasicType TInt
    IO CInt

-- | Adds the specified accessible child of the object to the
-- object\'s selection.
selectionAddSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> Int32
    -- ^ /@i@/: a @/gint/@ specifying the child index.
    -> m Bool
    -- ^ __Returns:__ TRUE if success, FALSE otherwise.
selectionAddSelection selection i = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_add_selection selection' i
    let result' = (/= 0) result
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data SelectionAddSelectionMethodInfo
instance (signature ~ (Int32 -> m Bool), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionAddSelectionMethodInfo a signature where
    overloadedMethod = selectionAddSelection

instance O.OverloadedMethodInfo SelectionAddSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionAddSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionAddSelection"
        })


#endif

-- method Selection::clear_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_clear_selection" atk_selection_clear_selection :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    IO CInt

-- | Clears the selection in the object so that no children in the object
-- are selected.
selectionClearSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> m Bool
    -- ^ __Returns:__ TRUE if success, FALSE otherwise.
selectionClearSelection selection = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_clear_selection selection'
    let result' = (/= 0) result
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data SelectionClearSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionClearSelectionMethodInfo a signature where
    overloadedMethod = selectionClearSelection

instance O.OverloadedMethodInfo SelectionClearSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionClearSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionClearSelection"
        })


#endif

-- method Selection::get_selection_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_get_selection_count" atk_selection_get_selection_count :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    IO Int32

-- | Gets the number of accessible children currently selected.
-- Note: callers should not rely on 'P.Nothing' or on a zero value for
-- indication of whether AtkSelectionIface is implemented, they should
-- use type checking\/interface checking macros or the
-- @/atk_get_accessible_value()/@ convenience method.
selectionGetSelectionCount ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> m Int32
    -- ^ __Returns:__ a gint representing the number of items selected, or 0
    -- if /@selection@/ does not implement this interface.
selectionGetSelectionCount selection = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_get_selection_count selection'
    touchManagedPtr selection
    return result

#if defined(ENABLE_OVERLOADING)
data SelectionGetSelectionCountMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionGetSelectionCountMethodInfo a signature where
    overloadedMethod = selectionGetSelectionCount

instance O.OverloadedMethodInfo SelectionGetSelectionCountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionGetSelectionCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionGetSelectionCount"
        })


#endif

-- method Selection::is_child_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gint specifying the child index."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_is_child_selected" atk_selection_is_child_selected :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    Int32 ->                                -- i : TBasicType TInt
    IO CInt

-- | Determines if the current child of this object is selected
-- Note: callers should not rely on 'P.Nothing' or on a zero value for
-- indication of whether AtkSelectionIface is implemented, they should
-- use type checking\/interface checking macros or the
-- @/atk_get_accessible_value()/@ convenience method.
selectionIsChildSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> Int32
    -- ^ /@i@/: a @/gint/@ specifying the child index.
    -> m Bool
    -- ^ __Returns:__ a gboolean representing the specified child is selected, or 0
    -- if /@selection@/ does not implement this interface.
selectionIsChildSelected selection i = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_is_child_selected selection' i
    let result' = (/= 0) result
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data SelectionIsChildSelectedMethodInfo
instance (signature ~ (Int32 -> m Bool), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionIsChildSelectedMethodInfo a signature where
    overloadedMethod = selectionIsChildSelected

instance O.OverloadedMethodInfo SelectionIsChildSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionIsChildSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionIsChildSelected"
        })


#endif

-- method Selection::ref_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #gint specifying the index in the selection set.  (e.g. the\nith selection as opposed to the ith child)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_ref_selection" atk_selection_ref_selection :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    Int32 ->                                -- i : TBasicType TInt
    IO (Ptr Atk.Object.Object)

-- | Gets a reference to the accessible object representing the specified
-- selected child of the object.
-- Note: callers should not rely on 'P.Nothing' or on a zero value for
-- indication of whether AtkSelectionIface is implemented, they should
-- use type checking\/interface checking macros or the
-- @/atk_get_accessible_value()/@ convenience method.
selectionRefSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> Int32
    -- ^ /@i@/: a @/gint/@ specifying the index in the selection set.  (e.g. the
    -- ith selection as opposed to the ith child).
    -> m (Maybe Atk.Object.Object)
    -- ^ __Returns:__ an t'GI.Atk.Objects.Object.Object' representing the
    -- selected accessible, or 'P.Nothing' if /@selection@/ does not implement this
    -- interface.
selectionRefSelection selection i = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_ref_selection selection' i
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Atk.Object.Object) result'
        return result''
    touchManagedPtr selection
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SelectionRefSelectionMethodInfo
instance (signature ~ (Int32 -> m (Maybe Atk.Object.Object)), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionRefSelectionMethodInfo a signature where
    overloadedMethod = selectionRefSelection

instance O.OverloadedMethodInfo SelectionRefSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionRefSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionRefSelection"
        })


#endif

-- method Selection::remove_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "i"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #gint specifying the index in the selection set.  (e.g. the\nith selection as opposed to the ith child)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_remove_selection" atk_selection_remove_selection :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    Int32 ->                                -- i : TBasicType TInt
    IO CInt

-- | Removes the specified child of the object from the object\'s selection.
selectionRemoveSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> Int32
    -- ^ /@i@/: a @/gint/@ specifying the index in the selection set.  (e.g. the
    -- ith selection as opposed to the ith child).
    -> m Bool
    -- ^ __Returns:__ TRUE if success, FALSE otherwise.
selectionRemoveSelection selection i = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_remove_selection selection' i
    let result' = (/= 0) result
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data SelectionRemoveSelectionMethodInfo
instance (signature ~ (Int32 -> m Bool), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionRemoveSelectionMethodInfo a signature where
    overloadedMethod = selectionRemoveSelection

instance O.OverloadedMethodInfo SelectionRemoveSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionRemoveSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionRemoveSelection"
        })


#endif

-- method Selection::select_all_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "selection"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Selection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkSelectionIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_selection_select_all_selection" atk_selection_select_all_selection :: 
    Ptr Selection ->                        -- selection : TInterface (Name {namespace = "Atk", name = "Selection"})
    IO CInt

-- | Causes every child of the object to be selected if the object
-- supports multiple selections.
selectionSelectAllSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSelection a) =>
    a
    -- ^ /@selection@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkSelectionIface
    -> m Bool
    -- ^ __Returns:__ TRUE if success, FALSE otherwise.
selectionSelectAllSelection selection = liftIO $ do
    selection' <- unsafeManagedPtrCastPtr selection
    result <- atk_selection_select_all_selection selection'
    let result' = (/= 0) result
    touchManagedPtr selection
    return result'

#if defined(ENABLE_OVERLOADING)
data SelectionSelectAllSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSelection a) => O.OverloadedMethod SelectionSelectAllSelectionMethodInfo a signature where
    overloadedMethod = selectionSelectAllSelection

instance O.OverloadedMethodInfo SelectionSelectAllSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection.selectionSelectAllSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#v:selectionSelectAllSelection"
        })


#endif

-- signal Selection::selection-changed
-- | The \"selection-changed\" signal is emitted by an object which
-- implements AtkSelection interface when the selection changes.
type SelectionSelectionChangedCallback =
    IO ()

type C_SelectionSelectionChangedCallback =
    Ptr Selection ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SelectionSelectionChangedCallback`.
foreign import ccall "wrapper"
    mk_SelectionSelectionChangedCallback :: C_SelectionSelectionChangedCallback -> IO (FunPtr C_SelectionSelectionChangedCallback)

wrap_SelectionSelectionChangedCallback :: 
    GObject a => (a -> SelectionSelectionChangedCallback) ->
    C_SelectionSelectionChangedCallback
wrap_SelectionSelectionChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [selectionChanged](#signal:selectionChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' selection #selectionChanged callback
-- @
-- 
-- 
onSelectionSelectionChanged :: (IsSelection a, MonadIO m) => a -> ((?self :: a) => SelectionSelectionChangedCallback) -> m SignalHandlerId
onSelectionSelectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SelectionSelectionChangedCallback wrapped
    wrapped'' <- mk_SelectionSelectionChangedCallback wrapped'
    connectSignalFunPtr obj "selection-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectionChanged](#signal:selectionChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' selection #selectionChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSelectionSelectionChanged :: (IsSelection a, MonadIO m) => a -> ((?self :: a) => SelectionSelectionChangedCallback) -> m SignalHandlerId
afterSelectionSelectionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SelectionSelectionChangedCallback wrapped
    wrapped'' <- mk_SelectionSelectionChangedCallback wrapped'
    connectSignalFunPtr obj "selection-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SelectionSelectionChangedSignalInfo
instance SignalInfo SelectionSelectionChangedSignalInfo where
    type HaskellCallbackType SelectionSelectionChangedSignalInfo = SelectionSelectionChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SelectionSelectionChangedCallback cb
        cb'' <- mk_SelectionSelectionChangedCallback cb'
        connectSignalFunPtr obj "selection-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Selection::selection-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Selection.html#g:signal:selectionChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Selection = SelectionSignalList
type SelectionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo), '("selectionChanged", SelectionSelectionChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


