{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK interface which represents the toplevel
--  container for document content.
-- 
-- The AtkDocument interface should be supported by any object whose
-- content is a representation or view of a document.  The AtkDocument
-- interface should appear on the toplevel container for the document
-- content; however AtkDocument instances may be nested (i.e. an
-- AtkDocument may be a descendant of another AtkDocument) in those
-- cases where one document contains \"embedded content\" which can
-- reasonably be considered a document in its own right.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.Document
    ( 

-- * Exported types
    Document(..)                            ,
    IsDocument                              ,
    toDocument                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAttributeValue]("GI.Atk.Interfaces.Document#g:method:getAttributeValue"), [getAttributes]("GI.Atk.Interfaces.Document#g:method:getAttributes"), [getCurrentPageNumber]("GI.Atk.Interfaces.Document#g:method:getCurrentPageNumber"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDocument]("GI.Atk.Interfaces.Document#g:method:getDocument"), [getDocumentType]("GI.Atk.Interfaces.Document#g:method:getDocumentType"), [getLocale]("GI.Atk.Interfaces.Document#g:method:getLocale"), [getPageCount]("GI.Atk.Interfaces.Document#g:method:getPageCount"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTextSelections]("GI.Atk.Interfaces.Document#g:method:getTextSelections").
-- 
-- ==== Setters
-- [setAttributeValue]("GI.Atk.Interfaces.Document#g:method:setAttributeValue"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTextSelections]("GI.Atk.Interfaces.Document#g:method:setTextSelections").

#if defined(ENABLE_OVERLOADING)
    ResolveDocumentMethod                   ,
#endif

-- ** getAttributeValue #method:getAttributeValue#

#if defined(ENABLE_OVERLOADING)
    DocumentGetAttributeValueMethodInfo     ,
#endif
    documentGetAttributeValue               ,


-- ** getAttributes #method:getAttributes#

#if defined(ENABLE_OVERLOADING)
    DocumentGetAttributesMethodInfo         ,
#endif
    documentGetAttributes                   ,


-- ** getCurrentPageNumber #method:getCurrentPageNumber#

#if defined(ENABLE_OVERLOADING)
    DocumentGetCurrentPageNumberMethodInfo  ,
#endif
    documentGetCurrentPageNumber            ,


-- ** getDocument #method:getDocument#

#if defined(ENABLE_OVERLOADING)
    DocumentGetDocumentMethodInfo           ,
#endif
    documentGetDocument                     ,


-- ** getDocumentType #method:getDocumentType#

#if defined(ENABLE_OVERLOADING)
    DocumentGetDocumentTypeMethodInfo       ,
#endif
    documentGetDocumentType                 ,


-- ** getLocale #method:getLocale#

#if defined(ENABLE_OVERLOADING)
    DocumentGetLocaleMethodInfo             ,
#endif
    documentGetLocale                       ,


-- ** getPageCount #method:getPageCount#

#if defined(ENABLE_OVERLOADING)
    DocumentGetPageCountMethodInfo          ,
#endif
    documentGetPageCount                    ,


-- ** getTextSelections #method:getTextSelections#

#if defined(ENABLE_OVERLOADING)
    DocumentGetTextSelectionsMethodInfo     ,
#endif
    documentGetTextSelections               ,


-- ** setAttributeValue #method:setAttributeValue#

#if defined(ENABLE_OVERLOADING)
    DocumentSetAttributeValueMethodInfo     ,
#endif
    documentSetAttributeValue               ,


-- ** setTextSelections #method:setTextSelections#

#if defined(ENABLE_OVERLOADING)
    DocumentSetTextSelectionsMethodInfo     ,
#endif
    documentSetTextSelections               ,




 -- * Signals


-- ** documentAttributeChanged #signal:documentAttributeChanged#

    DocumentDocumentAttributeChangedCallback,
#if defined(ENABLE_OVERLOADING)
    DocumentDocumentAttributeChangedSignalInfo,
#endif
    afterDocumentDocumentAttributeChanged   ,
    onDocumentDocumentAttributeChanged      ,


-- ** loadComplete #signal:loadComplete#

    DocumentLoadCompleteCallback            ,
#if defined(ENABLE_OVERLOADING)
    DocumentLoadCompleteSignalInfo          ,
#endif
    afterDocumentLoadComplete               ,
    onDocumentLoadComplete                  ,


-- ** loadStopped #signal:loadStopped#

    DocumentLoadStoppedCallback             ,
#if defined(ENABLE_OVERLOADING)
    DocumentLoadStoppedSignalInfo           ,
#endif
    afterDocumentLoadStopped                ,
    onDocumentLoadStopped                   ,


-- ** pageChanged #signal:pageChanged#

    DocumentPageChangedCallback             ,
#if defined(ENABLE_OVERLOADING)
    DocumentPageChangedSignalInfo           ,
#endif
    afterDocumentPageChanged                ,
    onDocumentPageChanged                   ,


-- ** reload #signal:reload#

    DocumentReloadCallback                  ,
#if defined(ENABLE_OVERLOADING)
    DocumentReloadSignalInfo                ,
#endif
    afterDocumentReload                     ,
    onDocumentReload                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import {-# SOURCE #-} qualified GI.Atk.Structs.TextSelection as Atk.TextSelection
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Structs.TextSelection as Atk.TextSelection
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface Document 
-- | Memory-managed wrapper type.
newtype Document = Document (SP.ManagedPtr Document)
    deriving (Eq)

instance SP.ManagedPtrNewtype Document where
    toManagedPtr (Document p) = p

foreign import ccall "atk_document_get_type"
    c_atk_document_get_type :: IO B.Types.GType

instance B.Types.TypedObject Document where
    glibType = c_atk_document_get_type

instance B.Types.GObject Document

-- | Type class for types which can be safely cast to `Document`, for instance with `toDocument`.
class (SP.GObject o, O.IsDescendantOf Document o) => IsDocument o
instance (SP.GObject o, O.IsDescendantOf Document o) => IsDocument o

instance O.HasParentTypes Document
type instance O.ParentTypes Document = '[GObject.Object.Object]

-- | Cast to `Document`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDocument :: (MIO.MonadIO m, IsDocument o) => o -> m Document
toDocument = MIO.liftIO . B.ManagedPtr.unsafeCastTo Document

-- | Convert 'Document' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Document) where
    gvalueGType_ = c_atk_document_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Document)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Document)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Document ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Document
type instance O.AttributeList Document = DocumentAttributeList
type DocumentAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDocumentMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDocumentMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDocumentMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDocumentMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDocumentMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDocumentMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDocumentMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDocumentMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDocumentMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDocumentMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDocumentMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDocumentMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDocumentMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDocumentMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDocumentMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDocumentMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDocumentMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDocumentMethod "getAttributeValue" o = DocumentGetAttributeValueMethodInfo
    ResolveDocumentMethod "getAttributes" o = DocumentGetAttributesMethodInfo
    ResolveDocumentMethod "getCurrentPageNumber" o = DocumentGetCurrentPageNumberMethodInfo
    ResolveDocumentMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDocumentMethod "getDocument" o = DocumentGetDocumentMethodInfo
    ResolveDocumentMethod "getDocumentType" o = DocumentGetDocumentTypeMethodInfo
    ResolveDocumentMethod "getLocale" o = DocumentGetLocaleMethodInfo
    ResolveDocumentMethod "getPageCount" o = DocumentGetPageCountMethodInfo
    ResolveDocumentMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDocumentMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDocumentMethod "getTextSelections" o = DocumentGetTextSelectionsMethodInfo
    ResolveDocumentMethod "setAttributeValue" o = DocumentSetAttributeValueMethodInfo
    ResolveDocumentMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDocumentMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDocumentMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDocumentMethod "setTextSelections" o = DocumentSetTextSelectionsMethodInfo
    ResolveDocumentMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDocumentMethod t Document, O.OverloadedMethod info Document p) => OL.IsLabel t (Document -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDocumentMethod t Document, O.OverloadedMethod info Document p, R.HasField t Document p) => R.HasField t Document p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDocumentMethod t Document, O.OverloadedMethodInfo info Document) => OL.IsLabel t (O.MethodProxy info Document) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Document::get_attribute_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a character string representing the name of the attribute\n  whose value is being queried."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_attribute_value" atk_document_get_attribute_value :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    CString ->                              -- attribute_name : TBasicType TUTF8
    IO CString

-- | Retrieves the value of the given /@attributeName@/ inside /@document@/.
-- 
-- /Since: 1.12/
documentGetAttributeValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkDocumentIface
    -> T.Text
    -- ^ /@attributeName@/: a character string representing the name of the attribute
    --   whose value is being queried.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string value associated with the named
    --    attribute for this document, or 'P.Nothing' if a value for
    --    /@attributeName@/ has not been specified for this document.
documentGetAttributeValue document attributeName = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    attributeName' <- textToCString attributeName
    result <- atk_document_get_attribute_value document' attributeName'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr document
    freeMem attributeName'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DocumentGetAttributeValueMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetAttributeValueMethodInfo a signature where
    overloadedMethod = documentGetAttributeValue

instance O.OverloadedMethodInfo DocumentGetAttributeValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetAttributeValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetAttributeValue"
        })


#endif

-- method Document::get_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGSList (TBasicType TPtr))
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_attributes" atk_document_get_attributes :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO (Ptr (GSList (Ptr ())))

-- | Gets an AtkAttributeSet which describes document-wide
--          attributes as name-value pairs.
-- 
-- /Since: 1.12/
documentGetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkDocumentIface
    -> m ([Ptr ()])
    -- ^ __Returns:__ An AtkAttributeSet containing the explicitly
    --          set name-value-pair attributes associated with this document
    --          as a whole.
documentGetAttributes document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_attributes document'
    result' <- unpackGSList result
    touchManagedPtr document
    return result'

#if defined(ENABLE_OVERLOADING)
data DocumentGetAttributesMethodInfo
instance (signature ~ (m ([Ptr ()])), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetAttributesMethodInfo a signature where
    overloadedMethod = documentGetAttributes

instance O.OverloadedMethodInfo DocumentGetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetAttributes"
        })


#endif

-- method Document::get_current_page_number
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #AtkDocument" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_current_page_number" atk_document_get_current_page_number :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO Int32

-- | Retrieves the current page number inside /@document@/.
-- 
-- /Since: 2.12/
documentGetCurrentPageNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: the t'GI.Atk.Interfaces.Document.Document'
    -> m Int32
    -- ^ __Returns:__ the current page number inside /@document@/, or -1 if
    --   not implemented, not know by the implementor, or irrelevant.
documentGetCurrentPageNumber document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_current_page_number document'
    touchManagedPtr document
    return result

#if defined(ENABLE_OVERLOADING)
data DocumentGetCurrentPageNumberMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetCurrentPageNumberMethodInfo a signature where
    overloadedMethod = documentGetCurrentPageNumber

instance O.OverloadedMethodInfo DocumentGetCurrentPageNumberMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetCurrentPageNumber",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetCurrentPageNumber"
        })


#endif

-- method Document::get_document
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_document" atk_document_get_document :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO (Ptr ())

{-# DEPRECATED documentGetDocument ["Since 2.12. /@document@/ is already a representation of","the document. Use it directly, or one of its children, as an","instance of the DOM."] #-}
-- | Gets a @/gpointer/@ that points to an instance of the DOM.  It is
-- up to the caller to check atk_document_get_type to determine
-- how to cast this pointer.
documentGetDocument ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkDocumentIface
    -> m (Ptr ())
    -- ^ __Returns:__ a @/gpointer/@ that points to an instance of the DOM.
documentGetDocument document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_document document'
    touchManagedPtr document
    return result

#if defined(ENABLE_OVERLOADING)
data DocumentGetDocumentMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetDocumentMethodInfo a signature where
    overloadedMethod = documentGetDocument

instance O.OverloadedMethodInfo DocumentGetDocumentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetDocument",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetDocument"
        })


#endif

-- method Document::get_document_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_document_type" atk_document_get_document_type :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO CString

{-# DEPRECATED documentGetDocumentType ["Since 2.12. Please use 'GI.Atk.Interfaces.Document.documentGetAttributes' to","ask for the document type if it applies."] #-}
-- | Gets a string indicating the document type.
documentGetDocumentType ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkDocumentIface
    -> m T.Text
    -- ^ __Returns:__ a string indicating the document type
documentGetDocumentType document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_document_type document'
    checkUnexpectedReturnNULL "documentGetDocumentType" result
    result' <- cstringToText result
    touchManagedPtr document
    return result'

#if defined(ENABLE_OVERLOADING)
data DocumentGetDocumentTypeMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetDocumentTypeMethodInfo a signature where
    overloadedMethod = documentGetDocumentType

instance O.OverloadedMethodInfo DocumentGetDocumentTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetDocumentType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetDocumentType"
        })


#endif

-- method Document::get_locale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_locale" atk_document_get_locale :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO CString

{-# DEPRECATED documentGetLocale ["(Since version 2.7.90)","Please use 'GI.Atk.Objects.Object.objectGetObjectLocale' instead."] #-}
-- | Gets a UTF-8 string indicating the POSIX-style LC_MESSAGES locale
--          of the content of this document instance.  Individual
--          text substrings or images within this document may have
--          a different locale, see atk_text_get_attributes and
--          atk_image_get_image_locale.
documentGetLocale ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements AtkDocumentIface
    -> m T.Text
    -- ^ __Returns:__ a UTF-8 string indicating the POSIX-style LC_MESSAGES
    --          locale of the document content as a whole, or NULL if
    --          the document content does not specify a locale.
documentGetLocale document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_locale document'
    checkUnexpectedReturnNULL "documentGetLocale" result
    result' <- cstringToText result
    touchManagedPtr document
    return result'

#if defined(ENABLE_OVERLOADING)
data DocumentGetLocaleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetLocaleMethodInfo a signature where
    overloadedMethod = documentGetLocale

instance O.OverloadedMethodInfo DocumentGetLocaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetLocale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetLocale"
        })


#endif

-- method Document::get_page_count
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #AtkDocument" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_page_count" atk_document_get_page_count :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO Int32

-- | Retrieves the total number of pages inside /@document@/.
-- 
-- /Since: 2.12/
documentGetPageCount ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: the t'GI.Atk.Interfaces.Document.Document'
    -> m Int32
    -- ^ __Returns:__ total page count of /@document@/, or -1 if not implemented,
    --   not know by the implementor or irrelevant.
documentGetPageCount document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_page_count document'
    touchManagedPtr document
    return result

#if defined(ENABLE_OVERLOADING)
data DocumentGetPageCountMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetPageCountMethodInfo a signature where
    overloadedMethod = documentGetPageCount

instance O.OverloadedMethodInfo DocumentGetPageCountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetPageCount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetPageCount"
        })


#endif

-- method Document::get_text_selections
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkDocument" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGArray
--                  (TInterface Name { namespace = "Atk" , name = "TextSelection" }))
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_get_text_selections" atk_document_get_text_selections :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    IO (Ptr (GArray (Ptr Atk.TextSelection.TextSelection)))

-- | Returns an array of AtkTextSelections within this document.
-- 
-- /Since: 2.52/
documentGetTextSelections ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: an t'GI.Atk.Interfaces.Document.Document'
    -> m [Atk.TextSelection.TextSelection]
    -- ^ __Returns:__ a GArray of
    -- AtkTextSelection structures representing the selection.
documentGetTextSelections document = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    result <- atk_document_get_text_selections document'
    checkUnexpectedReturnNULL "documentGetTextSelections" result
    result' <- unpackGArray result
    result'' <- mapM (wrapPtr Atk.TextSelection.TextSelection) result'
    unrefGArray result
    touchManagedPtr document
    return result''

#if defined(ENABLE_OVERLOADING)
data DocumentGetTextSelectionsMethodInfo
instance (signature ~ (m [Atk.TextSelection.TextSelection]), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentGetTextSelectionsMethodInfo a signature where
    overloadedMethod = documentGetTextSelections

instance O.OverloadedMethodInfo DocumentGetTextSelectionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentGetTextSelections",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentGetTextSelections"
        })


#endif

-- method Document::set_attribute_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GObject instance that implements #AtkDocumentIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a character string representing the name of the attribute\n  whose value is being set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string value to be associated with @attribute_name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_set_attribute_value" atk_document_set_attribute_value :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    CString ->                              -- attribute_name : TBasicType TUTF8
    CString ->                              -- attribute_value : TBasicType TUTF8
    IO CInt

-- | Sets the value for the given /@attributeName@/ inside /@document@/.
-- 
-- /Since: 1.12/
documentSetAttributeValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: a t'GI.GObject.Objects.Object.Object' instance that implements t'GI.Atk.Structs.DocumentIface.DocumentIface'
    -> T.Text
    -- ^ /@attributeName@/: a character string representing the name of the attribute
    --   whose value is being set.
    -> T.Text
    -- ^ /@attributeValue@/: a string value to be associated with /@attributeName@/.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@attributeValue@/ is successfully associated
    --   with /@attributeName@/ for this /@document@/, and 'P.False' if if the
    --   document does not allow the attribute to be modified
documentSetAttributeValue document attributeName attributeValue = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    attributeName' <- textToCString attributeName
    attributeValue' <- textToCString attributeValue
    result <- atk_document_set_attribute_value document' attributeName' attributeValue'
    let result' = (/= 0) result
    touchManagedPtr document
    freeMem attributeName'
    freeMem attributeValue'
    return result'

#if defined(ENABLE_OVERLOADING)
data DocumentSetAttributeValueMethodInfo
instance (signature ~ (T.Text -> T.Text -> m Bool), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentSetAttributeValueMethodInfo a signature where
    overloadedMethod = documentSetAttributeValue

instance O.OverloadedMethodInfo DocumentSetAttributeValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentSetAttributeValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentSetAttributeValue"
        })


#endif

-- method Document::set_text_selections
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "document"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Document" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an #AtkDocument." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "selections"
--           , argType =
--               TGArray
--                 (TInterface Name { namespace = "Atk" , name = "TextSelection" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GArray of AtkTextSelections\n             to be selected."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_document_set_text_selections" atk_document_set_text_selections :: 
    Ptr Document ->                         -- document : TInterface (Name {namespace = "Atk", name = "Document"})
    Ptr (GArray (Ptr Atk.TextSelection.TextSelection)) -> -- selections : TGArray (TInterface (Name {namespace = "Atk", name = "TextSelection"}))
    IO CInt

-- | Makes 1 or more selections within this document denoted by the given
-- array of AtkTextSelections. Any existing physical selection (inside or
-- outside this document) is replaced by the new selections. All objects within
-- the given selection ranges must be descendants of this document. Otherwise
-- FALSE will be returned.
-- 
-- /Since: 2.52/
documentSetTextSelections ::
    (B.CallStack.HasCallStack, MonadIO m, IsDocument a) =>
    a
    -- ^ /@document@/: an t'GI.Atk.Interfaces.Document.Document'.
    -> [Atk.TextSelection.TextSelection]
    -- ^ /@selections@/: a GArray of AtkTextSelections
    --              to be selected.
    -> m Bool
    -- ^ __Returns:__ TRUE if the selection was made successfully; FALSE otherwise.
documentSetTextSelections document selections = liftIO $ do
    document' <- unsafeManagedPtrCastPtr document
    selections' <- mapM unsafeManagedPtrGetPtr selections
    selections'' <- packGArray selections'
    result <- atk_document_set_text_selections document' selections''
    let result' = (/= 0) result
    touchManagedPtr document
    mapM_ touchManagedPtr selections
    unrefGArray selections''
    return result'

#if defined(ENABLE_OVERLOADING)
data DocumentSetTextSelectionsMethodInfo
instance (signature ~ ([Atk.TextSelection.TextSelection] -> m Bool), MonadIO m, IsDocument a) => O.OverloadedMethod DocumentSetTextSelectionsMethodInfo a signature where
    overloadedMethod = documentSetTextSelections

instance O.OverloadedMethodInfo DocumentSetTextSelectionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document.documentSetTextSelections",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#v:documentSetTextSelections"
        })


#endif

-- signal Document::document-attribute-changed
-- | The \"document-attribute-changed\" signal should be emitted when there is a
-- change to one of the document attributes returned by
-- atk_document_get_attributes.
-- 
-- /Since: 2.52/
type DocumentDocumentAttributeChangedCallback =
    T.Text
    -- ^ /@arg1@/: the name of the attribute being modified, or 'P.Nothing' if not
    --          available.
    -> T.Text
    -- ^ /@arg2@/: the attribute\'s new value, or @/null/@ if not available.
    -> IO ()

type C_DocumentDocumentAttributeChangedCallback =
    Ptr Document ->                         -- object
    CString ->
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DocumentDocumentAttributeChangedCallback`.
foreign import ccall "wrapper"
    mk_DocumentDocumentAttributeChangedCallback :: C_DocumentDocumentAttributeChangedCallback -> IO (FunPtr C_DocumentDocumentAttributeChangedCallback)

wrap_DocumentDocumentAttributeChangedCallback :: 
    GObject a => (a -> DocumentDocumentAttributeChangedCallback) ->
    C_DocumentDocumentAttributeChangedCallback
wrap_DocumentDocumentAttributeChangedCallback gi'cb gi'selfPtr arg1 arg2 _ = do
    arg1' <- cstringToText arg1
    arg2' <- cstringToText arg2
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  arg1' arg2'


-- | Connect a signal handler for the [documentAttributeChanged](#signal:documentAttributeChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' document #documentAttributeChanged callback
-- @
-- 
-- 
onDocumentDocumentAttributeChanged :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentDocumentAttributeChangedCallback) -> m SignalHandlerId
onDocumentDocumentAttributeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentDocumentAttributeChangedCallback wrapped
    wrapped'' <- mk_DocumentDocumentAttributeChangedCallback wrapped'
    connectSignalFunPtr obj "document-attribute-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [documentAttributeChanged](#signal:documentAttributeChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' document #documentAttributeChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDocumentDocumentAttributeChanged :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentDocumentAttributeChangedCallback) -> m SignalHandlerId
afterDocumentDocumentAttributeChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentDocumentAttributeChangedCallback wrapped
    wrapped'' <- mk_DocumentDocumentAttributeChangedCallback wrapped'
    connectSignalFunPtr obj "document-attribute-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DocumentDocumentAttributeChangedSignalInfo
instance SignalInfo DocumentDocumentAttributeChangedSignalInfo where
    type HaskellCallbackType DocumentDocumentAttributeChangedSignalInfo = DocumentDocumentAttributeChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DocumentDocumentAttributeChangedCallback cb
        cb'' <- mk_DocumentDocumentAttributeChangedCallback cb'
        connectSignalFunPtr obj "document-attribute-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document::document-attribute-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#g:signal:documentAttributeChanged"})

#endif

-- signal Document::load-complete
-- | The \'load-complete\' signal is emitted when a pending load of
-- a static document has completed.  This signal is to be
-- expected by ATK clients if and when AtkDocument implementors
-- expose ATK_STATE_BUSY.  If the state of an AtkObject which
-- implements AtkDocument does not include ATK_STATE_BUSY, it
-- should be safe for clients to assume that the AtkDocument\'s
-- static contents are fully loaded into the container.
-- (Dynamic document contents should be exposed via other
-- signals.)
type DocumentLoadCompleteCallback =
    IO ()

type C_DocumentLoadCompleteCallback =
    Ptr Document ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DocumentLoadCompleteCallback`.
foreign import ccall "wrapper"
    mk_DocumentLoadCompleteCallback :: C_DocumentLoadCompleteCallback -> IO (FunPtr C_DocumentLoadCompleteCallback)

wrap_DocumentLoadCompleteCallback :: 
    GObject a => (a -> DocumentLoadCompleteCallback) ->
    C_DocumentLoadCompleteCallback
wrap_DocumentLoadCompleteCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [loadComplete](#signal:loadComplete) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' document #loadComplete callback
-- @
-- 
-- 
onDocumentLoadComplete :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentLoadCompleteCallback) -> m SignalHandlerId
onDocumentLoadComplete obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentLoadCompleteCallback wrapped
    wrapped'' <- mk_DocumentLoadCompleteCallback wrapped'
    connectSignalFunPtr obj "load-complete" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [loadComplete](#signal:loadComplete) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' document #loadComplete callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDocumentLoadComplete :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentLoadCompleteCallback) -> m SignalHandlerId
afterDocumentLoadComplete obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentLoadCompleteCallback wrapped
    wrapped'' <- mk_DocumentLoadCompleteCallback wrapped'
    connectSignalFunPtr obj "load-complete" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DocumentLoadCompleteSignalInfo
instance SignalInfo DocumentLoadCompleteSignalInfo where
    type HaskellCallbackType DocumentLoadCompleteSignalInfo = DocumentLoadCompleteCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DocumentLoadCompleteCallback cb
        cb'' <- mk_DocumentLoadCompleteCallback cb'
        connectSignalFunPtr obj "load-complete" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document::load-complete"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#g:signal:loadComplete"})

#endif

-- signal Document::load-stopped
-- | The \'load-stopped\' signal is emitted when a pending load of
-- document contents is cancelled, paused, or otherwise
-- interrupted by the user or application logic.  It should not
-- however be emitted while waiting for a resource (for instance
-- while blocking on a file or network read) unless a
-- user-significant timeout has occurred.
type DocumentLoadStoppedCallback =
    IO ()

type C_DocumentLoadStoppedCallback =
    Ptr Document ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DocumentLoadStoppedCallback`.
foreign import ccall "wrapper"
    mk_DocumentLoadStoppedCallback :: C_DocumentLoadStoppedCallback -> IO (FunPtr C_DocumentLoadStoppedCallback)

wrap_DocumentLoadStoppedCallback :: 
    GObject a => (a -> DocumentLoadStoppedCallback) ->
    C_DocumentLoadStoppedCallback
wrap_DocumentLoadStoppedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [loadStopped](#signal:loadStopped) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' document #loadStopped callback
-- @
-- 
-- 
onDocumentLoadStopped :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentLoadStoppedCallback) -> m SignalHandlerId
onDocumentLoadStopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentLoadStoppedCallback wrapped
    wrapped'' <- mk_DocumentLoadStoppedCallback wrapped'
    connectSignalFunPtr obj "load-stopped" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [loadStopped](#signal:loadStopped) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' document #loadStopped callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDocumentLoadStopped :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentLoadStoppedCallback) -> m SignalHandlerId
afterDocumentLoadStopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentLoadStoppedCallback wrapped
    wrapped'' <- mk_DocumentLoadStoppedCallback wrapped'
    connectSignalFunPtr obj "load-stopped" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DocumentLoadStoppedSignalInfo
instance SignalInfo DocumentLoadStoppedSignalInfo where
    type HaskellCallbackType DocumentLoadStoppedSignalInfo = DocumentLoadStoppedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DocumentLoadStoppedCallback cb
        cb'' <- mk_DocumentLoadStoppedCallback cb'
        connectSignalFunPtr obj "load-stopped" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document::load-stopped"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#g:signal:loadStopped"})

#endif

-- signal Document::page-changed
-- | The \'page-changed\' signal is emitted when the current page of
-- a document changes, e.g. pressing page up\/down in a document
-- viewer.
-- 
-- /Since: 2.12/
type DocumentPageChangedCallback =
    Int32
    -- ^ /@pageNumber@/: the new page number. If this value is unknown
    -- or not applicable, -1 should be provided.
    -> IO ()

type C_DocumentPageChangedCallback =
    Ptr Document ->                         -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DocumentPageChangedCallback`.
foreign import ccall "wrapper"
    mk_DocumentPageChangedCallback :: C_DocumentPageChangedCallback -> IO (FunPtr C_DocumentPageChangedCallback)

wrap_DocumentPageChangedCallback :: 
    GObject a => (a -> DocumentPageChangedCallback) ->
    C_DocumentPageChangedCallback
wrap_DocumentPageChangedCallback gi'cb gi'selfPtr pageNumber _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  pageNumber


-- | Connect a signal handler for the [pageChanged](#signal:pageChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' document #pageChanged callback
-- @
-- 
-- 
onDocumentPageChanged :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentPageChangedCallback) -> m SignalHandlerId
onDocumentPageChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentPageChangedCallback wrapped
    wrapped'' <- mk_DocumentPageChangedCallback wrapped'
    connectSignalFunPtr obj "page-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pageChanged](#signal:pageChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' document #pageChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDocumentPageChanged :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentPageChangedCallback) -> m SignalHandlerId
afterDocumentPageChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentPageChangedCallback wrapped
    wrapped'' <- mk_DocumentPageChangedCallback wrapped'
    connectSignalFunPtr obj "page-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DocumentPageChangedSignalInfo
instance SignalInfo DocumentPageChangedSignalInfo where
    type HaskellCallbackType DocumentPageChangedSignalInfo = DocumentPageChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DocumentPageChangedCallback cb
        cb'' <- mk_DocumentPageChangedCallback cb'
        connectSignalFunPtr obj "page-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document::page-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#g:signal:pageChanged"})

#endif

-- signal Document::reload
-- | The \'reload\' signal is emitted when the contents of a
-- document is refreshed from its source.  Once \'reload\' has
-- been emitted, a matching \'load-complete\' or \'load-stopped\'
-- signal should follow, which clients may await before
-- interrogating ATK for the latest document content.
type DocumentReloadCallback =
    IO ()

type C_DocumentReloadCallback =
    Ptr Document ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DocumentReloadCallback`.
foreign import ccall "wrapper"
    mk_DocumentReloadCallback :: C_DocumentReloadCallback -> IO (FunPtr C_DocumentReloadCallback)

wrap_DocumentReloadCallback :: 
    GObject a => (a -> DocumentReloadCallback) ->
    C_DocumentReloadCallback
wrap_DocumentReloadCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [reload](#signal:reload) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' document #reload callback
-- @
-- 
-- 
onDocumentReload :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentReloadCallback) -> m SignalHandlerId
onDocumentReload obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentReloadCallback wrapped
    wrapped'' <- mk_DocumentReloadCallback wrapped'
    connectSignalFunPtr obj "reload" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [reload](#signal:reload) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' document #reload callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDocumentReload :: (IsDocument a, MonadIO m) => a -> ((?self :: a) => DocumentReloadCallback) -> m SignalHandlerId
afterDocumentReload obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DocumentReloadCallback wrapped
    wrapped'' <- mk_DocumentReloadCallback wrapped'
    connectSignalFunPtr obj "reload" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DocumentReloadSignalInfo
instance SignalInfo DocumentReloadSignalInfo where
    type HaskellCallbackType DocumentReloadSignalInfo = DocumentReloadCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DocumentReloadCallback cb
        cb'' <- mk_DocumentReloadCallback cb'
        connectSignalFunPtr obj "reload" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.Document::reload"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.27/docs/GI-Atk-Interfaces-Document.html#g:signal:reload"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Document = DocumentSignalList
type DocumentSignalList = ('[ '("documentAttributeChanged", DocumentDocumentAttributeChangedSignalInfo), '("loadComplete", DocumentLoadCompleteSignalInfo), '("loadStopped", DocumentLoadStoppedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pageChanged", DocumentPageChangedSignalInfo), '("reload", DocumentReloadSignalInfo)] :: [(Symbol, DK.Type)])

#endif


