

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Enums
    ( 

 -- * Enumerations


-- ** CoordType #enum:CoordType#

    CoordType(..)                           ,


-- ** KeyEventType #enum:KeyEventType#

    KeyEventType(..)                        ,


-- ** Layer #enum:Layer#

    Layer(..)                               ,


-- ** Live #enum:Live#

    Live(..)                                ,


-- ** RelationType #enum:RelationType#

    RelationType(..)                        ,


-- ** Role #enum:Role#

    Role(..)                                ,


-- ** ScrollType #enum:ScrollType#

    ScrollType(..)                          ,


-- ** StateType #enum:StateType#

    StateType(..)                           ,


-- ** TextAttribute #enum:TextAttribute#

    TextAttribute(..)                       ,


-- ** TextBoundary #enum:TextBoundary#

    TextBoundary(..)                        ,


-- ** TextClipType #enum:TextClipType#

    TextClipType(..)                        ,


-- ** TextGranularity #enum:TextGranularity#

    TextGranularity(..)                     ,


-- ** ValueType #enum:ValueType#

    ValueType(..)                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Enum ValueType
-- | Default types for a given value. Those are defined in order to
-- easily get localized strings to describe a given value or a given
-- subrange, using 'GI.Atk.Functions.valueTypeGetLocalizedName'.
data ValueType = 
      ValueTypeVeryWeak
    -- ^ /No description available in the introspection data./
    | ValueTypeWeak
    -- ^ /No description available in the introspection data./
    | ValueTypeAcceptable
    -- ^ /No description available in the introspection data./
    | ValueTypeStrong
    -- ^ /No description available in the introspection data./
    | ValueTypeVeryStrong
    -- ^ /No description available in the introspection data./
    | ValueTypeVeryLow
    -- ^ /No description available in the introspection data./
    | ValueTypeLow
    -- ^ /No description available in the introspection data./
    | ValueTypeMedium
    -- ^ /No description available in the introspection data./
    | ValueTypeHigh
    -- ^ /No description available in the introspection data./
    | ValueTypeVeryHigh
    -- ^ /No description available in the introspection data./
    | ValueTypeVeryBad
    -- ^ /No description available in the introspection data./
    | ValueTypeBad
    -- ^ /No description available in the introspection data./
    | ValueTypeGood
    -- ^ /No description available in the introspection data./
    | ValueTypeVeryGood
    -- ^ /No description available in the introspection data./
    | ValueTypeBest
    -- ^ /No description available in the introspection data./
    | ValueTypeLastDefined
    -- ^ /No description available in the introspection data./
    | AnotherValueType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ValueType where
    fromEnum ValueTypeVeryWeak = 0
    fromEnum ValueTypeWeak = 1
    fromEnum ValueTypeAcceptable = 2
    fromEnum ValueTypeStrong = 3
    fromEnum ValueTypeVeryStrong = 4
    fromEnum ValueTypeVeryLow = 5
    fromEnum ValueTypeLow = 6
    fromEnum ValueTypeMedium = 7
    fromEnum ValueTypeHigh = 8
    fromEnum ValueTypeVeryHigh = 9
    fromEnum ValueTypeVeryBad = 10
    fromEnum ValueTypeBad = 11
    fromEnum ValueTypeGood = 12
    fromEnum ValueTypeVeryGood = 13
    fromEnum ValueTypeBest = 14
    fromEnum ValueTypeLastDefined = 15
    fromEnum (AnotherValueType k) = k

    toEnum 0 = ValueTypeVeryWeak
    toEnum 1 = ValueTypeWeak
    toEnum 2 = ValueTypeAcceptable
    toEnum 3 = ValueTypeStrong
    toEnum 4 = ValueTypeVeryStrong
    toEnum 5 = ValueTypeVeryLow
    toEnum 6 = ValueTypeLow
    toEnum 7 = ValueTypeMedium
    toEnum 8 = ValueTypeHigh
    toEnum 9 = ValueTypeVeryHigh
    toEnum 10 = ValueTypeVeryBad
    toEnum 11 = ValueTypeBad
    toEnum 12 = ValueTypeGood
    toEnum 13 = ValueTypeVeryGood
    toEnum 14 = ValueTypeBest
    toEnum 15 = ValueTypeLastDefined
    toEnum k = AnotherValueType k

instance P.Ord ValueType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ValueType = '[]
instance O.HasParentTypes ValueType

foreign import ccall "atk_value_type_get_type" c_atk_value_type_get_type :: 
    IO GType

instance B.Types.TypedObject ValueType where
    glibType = c_atk_value_type_get_type

instance B.Types.BoxedEnum ValueType

-- Enum TextGranularity
-- | Text granularity types used for specifying the granularity of the region of
-- text we are interested in.
data TextGranularity = 
      TextGranularityChar
    -- ^ Granularity is defined by the boundaries between characters
    -- (including non-printing characters)
    | TextGranularityWord
    -- ^ Granularity is defined by the boundaries of a word,
    -- starting at the beginning of the current word and finishing at the beginning of
    -- the following one, if present.
    | TextGranularitySentence
    -- ^ Granularity is defined by the boundaries of a sentence,
    -- starting at the beginning of the current sentence and finishing at the beginning of
    -- the following one, if present.
    | TextGranularityLine
    -- ^ Granularity is defined by the boundaries of a line,
    -- starting at the beginning of the current line and finishing at the beginning of
    -- the following one, if present.
    | TextGranularityParagraph
    -- ^ Granularity is defined by the boundaries of a paragraph,
    -- starting at the beginning of the current paragraph and finishing at the beginning of
    -- the following one, if present.
    | AnotherTextGranularity Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextGranularity where
    fromEnum TextGranularityChar = 0
    fromEnum TextGranularityWord = 1
    fromEnum TextGranularitySentence = 2
    fromEnum TextGranularityLine = 3
    fromEnum TextGranularityParagraph = 4
    fromEnum (AnotherTextGranularity k) = k

    toEnum 0 = TextGranularityChar
    toEnum 1 = TextGranularityWord
    toEnum 2 = TextGranularitySentence
    toEnum 3 = TextGranularityLine
    toEnum 4 = TextGranularityParagraph
    toEnum k = AnotherTextGranularity k

instance P.Ord TextGranularity where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextGranularity = '[]
instance O.HasParentTypes TextGranularity

foreign import ccall "atk_text_granularity_get_type" c_atk_text_granularity_get_type :: 
    IO GType

instance B.Types.TypedObject TextGranularity where
    glibType = c_atk_text_granularity_get_type

instance B.Types.BoxedEnum TextGranularity

-- Enum TextClipType
-- | Describes the type of clipping required.
data TextClipType = 
      TextClipTypeNone
    -- ^ No clipping to be done
    | TextClipTypeMin
    -- ^ Text clipped by min coordinate is omitted
    | TextClipTypeMax
    -- ^ Text clipped by max coordinate is omitted
    | TextClipTypeBoth
    -- ^ Only text fully within mix\/max bound is retained
    | AnotherTextClipType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextClipType where
    fromEnum TextClipTypeNone = 0
    fromEnum TextClipTypeMin = 1
    fromEnum TextClipTypeMax = 2
    fromEnum TextClipTypeBoth = 3
    fromEnum (AnotherTextClipType k) = k

    toEnum 0 = TextClipTypeNone
    toEnum 1 = TextClipTypeMin
    toEnum 2 = TextClipTypeMax
    toEnum 3 = TextClipTypeBoth
    toEnum k = AnotherTextClipType k

instance P.Ord TextClipType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextClipType = '[]
instance O.HasParentTypes TextClipType

foreign import ccall "atk_text_clip_type_get_type" c_atk_text_clip_type_get_type :: 
    IO GType

instance B.Types.TypedObject TextClipType where
    glibType = c_atk_text_clip_type_get_type

instance B.Types.BoxedEnum TextClipType

-- Enum TextBoundary
-- | Text boundary types used for specifying boundaries for regions of text.
-- This enumeration is deprecated since 2.9.4 and should not be used. Use
-- AtkTextGranularity with @/atk_text_get_string_at_offset/@ instead.
data TextBoundary = 
      TextBoundaryChar
    -- ^ Boundary is the boundary between characters
    -- (including non-printing characters)
    | TextBoundaryWordStart
    -- ^ Boundary is the start (i.e. first character) of a word.
    | TextBoundaryWordEnd
    -- ^ Boundary is the end (i.e. last
    -- character) of a word.
    | TextBoundarySentenceStart
    -- ^ Boundary is the first character in a sentence.
    | TextBoundarySentenceEnd
    -- ^ Boundary is the last (terminal)
    -- character in a sentence; in languages which use \"sentence stop\"
    -- punctuation such as English, the boundary is thus the \'.\', \'?\', or
    -- similar terminal punctuation character.
    | TextBoundaryLineStart
    -- ^ Boundary is the initial character of the content or a
    -- character immediately following a newline, linefeed, or return character.
    | TextBoundaryLineEnd
    -- ^ Boundary is the linefeed, or return
    -- character.
    | AnotherTextBoundary Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextBoundary where
    fromEnum TextBoundaryChar = 0
    fromEnum TextBoundaryWordStart = 1
    fromEnum TextBoundaryWordEnd = 2
    fromEnum TextBoundarySentenceStart = 3
    fromEnum TextBoundarySentenceEnd = 4
    fromEnum TextBoundaryLineStart = 5
    fromEnum TextBoundaryLineEnd = 6
    fromEnum (AnotherTextBoundary k) = k

    toEnum 0 = TextBoundaryChar
    toEnum 1 = TextBoundaryWordStart
    toEnum 2 = TextBoundaryWordEnd
    toEnum 3 = TextBoundarySentenceStart
    toEnum 4 = TextBoundarySentenceEnd
    toEnum 5 = TextBoundaryLineStart
    toEnum 6 = TextBoundaryLineEnd
    toEnum k = AnotherTextBoundary k

instance P.Ord TextBoundary where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextBoundary = '[]
instance O.HasParentTypes TextBoundary

foreign import ccall "atk_text_boundary_get_type" c_atk_text_boundary_get_type :: 
    IO GType

instance B.Types.TypedObject TextBoundary where
    glibType = c_atk_text_boundary_get_type

instance B.Types.BoxedEnum TextBoundary

-- Enum TextAttribute
-- | Describes the text attributes supported
data TextAttribute = 
      TextAttributeInvalid
    -- ^ Invalid attribute, like bad spelling or grammar.
    | TextAttributeLeftMargin
    -- ^ The pixel width of the left margin
    | TextAttributeRightMargin
    -- ^ The pixel width of the right margin
    | TextAttributeIndent
    -- ^ The number of pixels that the text is indented
    | TextAttributeInvisible
    -- ^ Either \"true\" or \"false\" indicating whether text is visible or not
    | TextAttributeEditable
    -- ^ Either \"true\" or \"false\" indicating whether text is editable or not
    | TextAttributePixelsAboveLines
    -- ^ Pixels of blank space to leave above each newline-terminated line.
    | TextAttributePixelsBelowLines
    -- ^ Pixels of blank space to leave below each newline-terminated line.
    | TextAttributePixelsInsideWrap
    -- ^ Pixels of blank space to leave between wrapped lines inside the same newline-terminated line (paragraph).
    | TextAttributeBgFullHeight
    -- ^ \"true\" or \"false\" whether to make the background color for each character the height of the highest font used on the current line, or the height of the font used for the current character.
    | TextAttributeRise
    -- ^ Number of pixels that the characters are risen above the baseline. See also ATK_TEXT_ATTR_TEXT_POSITION.
    | TextAttributeUnderline
    -- ^ \"none\", \"single\", \"double\", \"low\", or \"error\"
    | TextAttributeStrikethrough
    -- ^ \"true\" or \"false\" whether the text is strikethrough
    | TextAttributeSize
    -- ^ The size of the characters in points. eg: 10
    | TextAttributeScale
    -- ^ The scale of the characters. The value is a string representation of a double
    | TextAttributeWeight
    -- ^ The weight of the characters.
    | TextAttributeLanguage
    -- ^ The language used
    | TextAttributeFamilyName
    -- ^ The font family name
    | TextAttributeBgColor
    -- ^ The background color. The value is an RGB value of the format \"@/u/@,@/u/@,@/u/@\"
    | TextAttributeFgColor
    -- ^ The foreground color. The value is an RGB value of the format \"@/u/@,@/u/@,@/u/@\"
    | TextAttributeBgStipple
    -- ^ \"true\" if a @/GdkBitmap/@ is set for stippling the background color.
    | TextAttributeFgStipple
    -- ^ \"true\" if a @/GdkBitmap/@ is set for stippling the foreground color.
    | TextAttributeWrapMode
    -- ^ The wrap mode of the text, if any. Values are \"none\", \"char\", \"word\", or \"word_char\".
    | TextAttributeDirection
    -- ^ The direction of the text, if set. Values are \"none\", \"ltr\" or \"rtl\"
    | TextAttributeJustification
    -- ^ The justification of the text, if set. Values are \"left\", \"right\", \"center\" or \"fill\"
    | TextAttributeStretch
    -- ^ The stretch of the text, if set. Values are \"ultra_condensed\", \"extra_condensed\", \"condensed\", \"semi_condensed\", \"normal\", \"semi_expanded\", \"expanded\", \"extra_expanded\" or \"ultra_expanded\"
    | TextAttributeVariant
    -- ^ The capitalization variant of the text, if set. Values are \"normal\" or \"small_caps\"
    | TextAttributeStyle
    -- ^ The slant style of the text, if set. Values are \"normal\", \"oblique\" or \"italic\"
    | TextAttributeTextPosition
    -- ^ The vertical position with respect to the baseline. Values are \"baseline\", \"super\", or \"sub\". Note that a super or sub text attribute refers to position with respect to the baseline of the prior character.
    | TextAttributeLastDefined
    -- ^ not a valid text attribute, used for finding end of enumeration
    | AnotherTextAttribute Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TextAttribute where
    fromEnum TextAttributeInvalid = 0
    fromEnum TextAttributeLeftMargin = 1
    fromEnum TextAttributeRightMargin = 2
    fromEnum TextAttributeIndent = 3
    fromEnum TextAttributeInvisible = 4
    fromEnum TextAttributeEditable = 5
    fromEnum TextAttributePixelsAboveLines = 6
    fromEnum TextAttributePixelsBelowLines = 7
    fromEnum TextAttributePixelsInsideWrap = 8
    fromEnum TextAttributeBgFullHeight = 9
    fromEnum TextAttributeRise = 10
    fromEnum TextAttributeUnderline = 11
    fromEnum TextAttributeStrikethrough = 12
    fromEnum TextAttributeSize = 13
    fromEnum TextAttributeScale = 14
    fromEnum TextAttributeWeight = 15
    fromEnum TextAttributeLanguage = 16
    fromEnum TextAttributeFamilyName = 17
    fromEnum TextAttributeBgColor = 18
    fromEnum TextAttributeFgColor = 19
    fromEnum TextAttributeBgStipple = 20
    fromEnum TextAttributeFgStipple = 21
    fromEnum TextAttributeWrapMode = 22
    fromEnum TextAttributeDirection = 23
    fromEnum TextAttributeJustification = 24
    fromEnum TextAttributeStretch = 25
    fromEnum TextAttributeVariant = 26
    fromEnum TextAttributeStyle = 27
    fromEnum TextAttributeTextPosition = 28
    fromEnum TextAttributeLastDefined = 29
    fromEnum (AnotherTextAttribute k) = k

    toEnum 0 = TextAttributeInvalid
    toEnum 1 = TextAttributeLeftMargin
    toEnum 2 = TextAttributeRightMargin
    toEnum 3 = TextAttributeIndent
    toEnum 4 = TextAttributeInvisible
    toEnum 5 = TextAttributeEditable
    toEnum 6 = TextAttributePixelsAboveLines
    toEnum 7 = TextAttributePixelsBelowLines
    toEnum 8 = TextAttributePixelsInsideWrap
    toEnum 9 = TextAttributeBgFullHeight
    toEnum 10 = TextAttributeRise
    toEnum 11 = TextAttributeUnderline
    toEnum 12 = TextAttributeStrikethrough
    toEnum 13 = TextAttributeSize
    toEnum 14 = TextAttributeScale
    toEnum 15 = TextAttributeWeight
    toEnum 16 = TextAttributeLanguage
    toEnum 17 = TextAttributeFamilyName
    toEnum 18 = TextAttributeBgColor
    toEnum 19 = TextAttributeFgColor
    toEnum 20 = TextAttributeBgStipple
    toEnum 21 = TextAttributeFgStipple
    toEnum 22 = TextAttributeWrapMode
    toEnum 23 = TextAttributeDirection
    toEnum 24 = TextAttributeJustification
    toEnum 25 = TextAttributeStretch
    toEnum 26 = TextAttributeVariant
    toEnum 27 = TextAttributeStyle
    toEnum 28 = TextAttributeTextPosition
    toEnum 29 = TextAttributeLastDefined
    toEnum k = AnotherTextAttribute k

instance P.Ord TextAttribute where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TextAttribute = '[]
instance O.HasParentTypes TextAttribute

foreign import ccall "atk_text_attribute_get_type" c_atk_text_attribute_get_type :: 
    IO GType

instance B.Types.TypedObject TextAttribute where
    glibType = c_atk_text_attribute_get_type

instance B.Types.BoxedEnum TextAttribute

-- Enum StateType
-- | The possible types of states of an object
data StateType = 
      StateTypeInvalid
    -- ^ Indicates an invalid state - probably an error condition.
    | StateTypeActive
    -- ^ Indicates a window is currently the active window, or an object is the active subelement within a container or table. ATK_STATE_ACTIVE should not be used for objects which have ATK_STATE_FOCUSABLE or ATK_STATE_SELECTABLE: Those objects should use ATK_STATE_FOCUSED and ATK_STATE_SELECTED respectively. ATK_STATE_ACTIVE is a means to indicate that an object which is not focusable and not selectable is the currently-active item within its parent container.
    | StateTypeArmed
    -- ^ Indicates that the object is \'armed\', i.e. will be activated by if a pointer button-release event occurs within its bounds.  Buttons often enter this state when a pointer click occurs within their bounds, as a precursor to activation. ATK_STATE_ARMED has been deprecated since ATK-2.16 and should not be used in newly-written code.
    | StateTypeBusy
    -- ^ Indicates the current object is busy, i.e. onscreen representation is in the process of changing, or the object is temporarily unavailable for interaction due to activity already in progress.  This state may be used by implementors of Document to indicate that content loading is underway.  It also may indicate other \'pending\' conditions; clients may wish to interrogate this object when the ATK_STATE_BUSY flag is removed.
    | StateTypeChecked
    -- ^ Indicates this object is currently checked, for instance a checkbox is \'non-empty\'.
    | StateTypeDefunct
    -- ^ Indicates that this object no longer has a valid backing widget (for instance, if its peer object has been destroyed)
    | StateTypeEditable
    -- ^ Indicates that this object can contain text, and that the
    -- user can change the textual contents of this object by editing those contents
    -- directly. For an object which is expected to be editable due to its type, but
    -- which cannot be edited due to the application or platform preventing the user
    -- from doing so, that object\'s t'GI.Atk.Objects.StateSet.StateSet' should lack ATK_STATE_EDITABLE and
    -- should contain ATK_STATE_READ_ONLY.
    | StateTypeEnabled
    -- ^ Indicates that this object is enabled, i.e. that it currently reflects some application state. Objects that are \"greyed out\" may lack this state, and may lack the STATE_SENSITIVE if direct user interaction cannot cause them to acquire STATE_ENABLED. See also: ATK_STATE_SENSITIVE
    | StateTypeExpandable
    -- ^ Indicates this object allows progressive disclosure of its children
    | StateTypeExpanded
    -- ^ Indicates this object its expanded - see ATK_STATE_EXPANDABLE above
    | StateTypeFocusable
    -- ^ Indicates this object can accept keyboard focus, which means all events resulting from typing on the keyboard will normally be passed to it when it has focus
    | StateTypeFocused
    -- ^ Indicates this object currently has the keyboard focus
    | StateTypeHorizontal
    -- ^ Indicates the orientation of this object is horizontal; used, for instance, by objects of ATK_ROLE_SCROLL_BAR.  For objects where vertical\/horizontal orientation is especially meaningful.
    | StateTypeIconified
    -- ^ Indicates this object is minimized and is represented only by an icon
    | StateTypeModal
    -- ^ Indicates something must be done with this object before the user can interact with an object in a different window
    | StateTypeMultiLine
    -- ^ Indicates this (text) object can contain multiple lines of text
    | StateTypeMultiselectable
    -- ^ Indicates this object allows more than one of its children to be selected at the same time, or in the case of text objects, that the object supports non-contiguous text selections.
    | StateTypeOpaque
    -- ^ Indicates this object paints every pixel within its rectangular region.
    | StateTypePressed
    -- ^ Indicates this object is currently pressed.
    | StateTypeResizable
    -- ^ Indicates the size of this object is not fixed
    | StateTypeSelectable
    -- ^ Indicates this object is the child of an object that allows its children to be selected and that this child is one of those children that can be selected
    | StateTypeSelected
    -- ^ Indicates this object is the child of an object that allows its children to be selected and that this child is one of those children that has been selected
    | StateTypeSensitive
    -- ^ Indicates this object is sensitive, e.g. to user interaction.
    -- STATE_SENSITIVE usually accompanies STATE_ENABLED for user-actionable controls,
    -- but may be found in the absence of STATE_ENABLED if the current visible state of the
    -- control is \"disconnected\" from the application state.  In such cases, direct user interaction
    -- can often result in the object gaining STATE_SENSITIVE, for instance if a user makes
    -- an explicit selection using an object whose current state is ambiguous or undefined.
    -- /@see@/ STATE_ENABLED, STATE_INDETERMINATE.
    | StateTypeShowing
    -- ^ Indicates this object, the object\'s parent, the object\'s parent\'s parent, and so on,
    -- are all \'shown\' to the end-user, i.e. subject to \"exposure\" if blocking or obscuring objects do not interpose
    -- between this object and the top of the window stack.
    | StateTypeSingleLine
    -- ^ Indicates this (text) object can contain only a single line of text
    | StateTypeStale
    -- ^ Indicates that the information returned for this object may no longer be
    -- synchronized with the application state.  This is implied if the object has STATE_TRANSIENT,
    -- and can also occur towards the end of the object peer\'s lifecycle. It can also be used to indicate that
    -- the index associated with this object has changed since the user accessed the object (in lieu of
    -- \"index-in-parent-changed\" events).
    | StateTypeTransient
    -- ^ Indicates this object is transient, i.e. a snapshot which may not emit events when its
    -- state changes.  Data from objects with ATK_STATE_TRANSIENT should not be cached, since there may be no
    -- notification given when the cached data becomes obsolete.
    | StateTypeVertical
    -- ^ Indicates the orientation of this object is vertical
    | StateTypeVisible
    -- ^ Indicates this object is visible, e.g. has been explicitly marked for exposure to the user.
    -- **note**: 'GI.Atk.Enums.StateTypeVisible' is no guarantee that the object is actually unobscured on the screen, only
    -- that it is \'potentially\' visible, barring obstruction, being scrolled or clipped out of the
    -- field of view, or having an ancestor container that has not yet made visible.
    -- A widget is potentially onscreen if it has both 'GI.Atk.Enums.StateTypeVisible' and 'GI.Atk.Enums.StateTypeShowing'.
    -- The absence of 'GI.Atk.Enums.StateTypeVisible' and 'GI.Atk.Enums.StateTypeShowing' is semantically equivalent to saying
    -- that an object is \'hidden\'.  See also 'GI.Atk.Enums.StateTypeTruncated', which applies if an object with
    -- 'GI.Atk.Enums.StateTypeVisible' and 'GI.Atk.Enums.StateTypeShowing' set lies within a viewport which means that its
    -- contents are clipped, e.g. a truncated spreadsheet cell or
    -- an image within a scrolling viewport.  Mostly useful for screen-review and magnification
    -- algorithms.
    | StateTypeManagesDescendants
    -- ^ Indicates that \"active-descendant-changed\" event
    -- is sent when children become \'active\' (i.e. are selected or navigated to onscreen).
    -- Used to prevent need to enumerate all children in very large containers, like tables.
    -- The presence of STATE_MANAGES_DESCENDANTS is an indication to the client.
    -- that the children should not, and need not, be enumerated by the client.
    -- Objects implementing this state are expected to provide relevant state
    -- notifications to listening clients, for instance notifications of visibility
    -- changes and activation of their contained child objects, without the client
    -- having previously requested references to those children.
    | StateTypeIndeterminate
    -- ^ Indicates that the value, or some other quantifiable
    -- property, of this AtkObject cannot be fully determined. In the case of a large
    -- data set in which the total number of items in that set is unknown (e.g. 1 of
    -- 999+), implementors should expose the currently-known set size (999) along
    -- with this state. In the case of a check box, this state should be used to
    -- indicate that the check box is a tri-state check box which is currently
    -- neither checked nor unchecked.
    | StateTypeTruncated
    -- ^ Indicates that an object is truncated, e.g. a text value in a speradsheet cell.
    | StateTypeRequired
    -- ^ Indicates that explicit user interaction with an object is required by the user interface, e.g. a required field in a \"web-form\" interface.
    | StateTypeInvalidEntry
    -- ^ Indicates that the object has encountered an error condition due to failure of input validation. For instance, a form control may acquire this state in response to invalid or malformed user input.
    | StateTypeSupportsAutocompletion
    -- ^ Indicates that the object in question implements some form of ¨typeahead¨ or
    -- pre-selection behavior whereby entering the first character of one or more sub-elements
    -- causes those elements to scroll into view or become selected.  Subsequent character input
    -- may narrow the selection further as long as one or more sub-elements match the string.
    -- This state is normally only useful and encountered on objects that implement Selection.
    -- In some cases the typeahead behavior may result in full or partial ¨completion¨ of
    -- the data in the input field, in which case these input events may trigger text-changed
    -- events from the AtkText interface.  This state supplants /@aTKROLEAUTOCOMPLETE@/.
    | StateTypeSelectableText
    -- ^ Indicates that the object in question supports text selection. It should only be exposed on objects which implement the Text interface, in order to distinguish this state from /@aTKSTATESELECTABLE@/, which infers that the object in question is a selectable child of an object which implements Selection. While similar, text selection and subelement selection are distinct operations.
    | StateTypeDefault
    -- ^ Indicates that the object is the \"default\" active component, i.e. the object which is activated by an end-user press of the \"Enter\" or \"Return\" key.  Typically a \"close\" or \"submit\" button.
    | StateTypeAnimated
    -- ^ Indicates that the object changes its appearance dynamically as an inherent part of its presentation.  This state may come and go if an object is only temporarily animated on the way to a \'final\' onscreen presentation.
    -- **note**: some applications, notably content viewers, may not be able to detect
    -- all kinds of animated content.  Therefore the absence of this state should not
    -- be taken as definitive evidence that the object\'s visual representation is
    -- static; this state is advisory.
    | StateTypeVisited
    -- ^ Indicates that the object (typically a hyperlink) has already been \'activated\', and\/or its backing data has already been downloaded, rendered, or otherwise \"visited\".
    | StateTypeCheckable
    -- ^ Indicates this object has the potential to be
    --  checked, such as a checkbox or toggle-able table cell. /@since@/:
    --  ATK-2.12
    | StateTypeHasPopup
    -- ^ Indicates that the object has a popup context
    -- menu or sub-level menu which may or may not be showing. This means
    -- that activation renders conditional content.  Note that ordinary
    -- tooltips are not considered popups in this context. /@since@/: ATK-2.12
    | StateTypeHasTooltip
    -- ^ Indicates this object has a tooltip. /@since@/: ATK-2.16
    | StateTypeReadOnly
    -- ^ Indicates that a widget which is ENABLED and SENSITIVE
    -- has a value which can be read, but not modified, by the user. Note that this
    -- state should only be applied to widget types whose value is normally directly
    -- user modifiable, such as check boxes, radio buttons, spin buttons, text input
    -- fields, and combo boxes, as a means to convey that the expected interaction
    -- with that widget is not possible. When the expected interaction with a
    -- widget does not include modification by the user, as is the case with
    -- labels and containers, ATK_STATE_READ_ONLY should not be applied. See also
    -- ATK_STATE_EDITABLE. /@since@/: ATK-2-16
    | StateTypeCollapsed
    -- ^ Indicates this object is collapsed. /@since@/: ATK-2.38
    | StateTypeLastDefined
    -- ^ Not a valid state, used for finding end of enumeration
    | AnotherStateType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum StateType where
    fromEnum StateTypeInvalid = 0
    fromEnum StateTypeActive = 1
    fromEnum StateTypeArmed = 2
    fromEnum StateTypeBusy = 3
    fromEnum StateTypeChecked = 4
    fromEnum StateTypeDefunct = 5
    fromEnum StateTypeEditable = 6
    fromEnum StateTypeEnabled = 7
    fromEnum StateTypeExpandable = 8
    fromEnum StateTypeExpanded = 9
    fromEnum StateTypeFocusable = 10
    fromEnum StateTypeFocused = 11
    fromEnum StateTypeHorizontal = 12
    fromEnum StateTypeIconified = 13
    fromEnum StateTypeModal = 14
    fromEnum StateTypeMultiLine = 15
    fromEnum StateTypeMultiselectable = 16
    fromEnum StateTypeOpaque = 17
    fromEnum StateTypePressed = 18
    fromEnum StateTypeResizable = 19
    fromEnum StateTypeSelectable = 20
    fromEnum StateTypeSelected = 21
    fromEnum StateTypeSensitive = 22
    fromEnum StateTypeShowing = 23
    fromEnum StateTypeSingleLine = 24
    fromEnum StateTypeStale = 25
    fromEnum StateTypeTransient = 26
    fromEnum StateTypeVertical = 27
    fromEnum StateTypeVisible = 28
    fromEnum StateTypeManagesDescendants = 29
    fromEnum StateTypeIndeterminate = 30
    fromEnum StateTypeTruncated = 31
    fromEnum StateTypeRequired = 32
    fromEnum StateTypeInvalidEntry = 33
    fromEnum StateTypeSupportsAutocompletion = 34
    fromEnum StateTypeSelectableText = 35
    fromEnum StateTypeDefault = 36
    fromEnum StateTypeAnimated = 37
    fromEnum StateTypeVisited = 38
    fromEnum StateTypeCheckable = 39
    fromEnum StateTypeHasPopup = 40
    fromEnum StateTypeHasTooltip = 41
    fromEnum StateTypeReadOnly = 42
    fromEnum StateTypeCollapsed = 43
    fromEnum StateTypeLastDefined = 44
    fromEnum (AnotherStateType k) = k

    toEnum 0 = StateTypeInvalid
    toEnum 1 = StateTypeActive
    toEnum 2 = StateTypeArmed
    toEnum 3 = StateTypeBusy
    toEnum 4 = StateTypeChecked
    toEnum 5 = StateTypeDefunct
    toEnum 6 = StateTypeEditable
    toEnum 7 = StateTypeEnabled
    toEnum 8 = StateTypeExpandable
    toEnum 9 = StateTypeExpanded
    toEnum 10 = StateTypeFocusable
    toEnum 11 = StateTypeFocused
    toEnum 12 = StateTypeHorizontal
    toEnum 13 = StateTypeIconified
    toEnum 14 = StateTypeModal
    toEnum 15 = StateTypeMultiLine
    toEnum 16 = StateTypeMultiselectable
    toEnum 17 = StateTypeOpaque
    toEnum 18 = StateTypePressed
    toEnum 19 = StateTypeResizable
    toEnum 20 = StateTypeSelectable
    toEnum 21 = StateTypeSelected
    toEnum 22 = StateTypeSensitive
    toEnum 23 = StateTypeShowing
    toEnum 24 = StateTypeSingleLine
    toEnum 25 = StateTypeStale
    toEnum 26 = StateTypeTransient
    toEnum 27 = StateTypeVertical
    toEnum 28 = StateTypeVisible
    toEnum 29 = StateTypeManagesDescendants
    toEnum 30 = StateTypeIndeterminate
    toEnum 31 = StateTypeTruncated
    toEnum 32 = StateTypeRequired
    toEnum 33 = StateTypeInvalidEntry
    toEnum 34 = StateTypeSupportsAutocompletion
    toEnum 35 = StateTypeSelectableText
    toEnum 36 = StateTypeDefault
    toEnum 37 = StateTypeAnimated
    toEnum 38 = StateTypeVisited
    toEnum 39 = StateTypeCheckable
    toEnum 40 = StateTypeHasPopup
    toEnum 41 = StateTypeHasTooltip
    toEnum 42 = StateTypeReadOnly
    toEnum 43 = StateTypeCollapsed
    toEnum 44 = StateTypeLastDefined
    toEnum k = AnotherStateType k

instance P.Ord StateType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes StateType = '[]
instance O.HasParentTypes StateType

foreign import ccall "atk_state_type_get_type" c_atk_state_type_get_type :: 
    IO GType

instance B.Types.TypedObject StateType where
    glibType = c_atk_state_type_get_type

instance B.Types.BoxedEnum StateType

-- Enum ScrollType
-- | Specifies where an object should be placed on the screen when using scroll_to.
-- 
-- /Since: 2.30/
data ScrollType = 
      ScrollTypeTopLeft
    -- ^ Scroll the object vertically and horizontally to bring
    --   its top left corner to the top left corner of the window.
    | ScrollTypeBottomRight
    -- ^ Scroll the object vertically and horizontally to
    --   bring its bottom right corner to the bottom right corner of the window.
    | ScrollTypeTopEdge
    -- ^ Scroll the object vertically to bring its top edge to
    --   the top edge of the window.
    | ScrollTypeBottomEdge
    -- ^ Scroll the object vertically to bring its bottom
    --   edge to the bottom edge of the window.
    | ScrollTypeLeftEdge
    -- ^ Scroll the object vertically and horizontally to bring
    --   its left edge to the left edge of the window.
    | ScrollTypeRightEdge
    -- ^ Scroll the object vertically and horizontally to
    --   bring its right edge to the right edge of the window.
    | ScrollTypeAnywhere
    -- ^ Scroll the object vertically and horizontally so that
    --   as much as possible of the object becomes visible. The exact placement is
    --   determined by the application.
    | AnotherScrollType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ScrollType where
    fromEnum ScrollTypeTopLeft = 0
    fromEnum ScrollTypeBottomRight = 1
    fromEnum ScrollTypeTopEdge = 2
    fromEnum ScrollTypeBottomEdge = 3
    fromEnum ScrollTypeLeftEdge = 4
    fromEnum ScrollTypeRightEdge = 5
    fromEnum ScrollTypeAnywhere = 6
    fromEnum (AnotherScrollType k) = k

    toEnum 0 = ScrollTypeTopLeft
    toEnum 1 = ScrollTypeBottomRight
    toEnum 2 = ScrollTypeTopEdge
    toEnum 3 = ScrollTypeBottomEdge
    toEnum 4 = ScrollTypeLeftEdge
    toEnum 5 = ScrollTypeRightEdge
    toEnum 6 = ScrollTypeAnywhere
    toEnum k = AnotherScrollType k

instance P.Ord ScrollType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ScrollType = '[]
instance O.HasParentTypes ScrollType

foreign import ccall "atk_scroll_type_get_type" c_atk_scroll_type_get_type :: 
    IO GType

instance B.Types.TypedObject ScrollType where
    glibType = c_atk_scroll_type_get_type

instance B.Types.BoxedEnum ScrollType

-- Enum Role
-- | Describes the role of an object
-- 
-- These are the built-in enumerated roles that UI components can have
-- in ATK.  Other roles may be added at runtime, so an AtkRole >=
-- 'GI.Atk.Enums.RoleLastDefined' is not necessarily an error.
data Role = 
      RoleInvalid
    -- ^ Invalid role
    | RoleAcceleratorLabel
    -- ^ A label which represents an accelerator
    | RoleAlert
    -- ^ An object which is an alert to the user. Assistive Technologies typically respond to ATK_ROLE_ALERT by reading the entire onscreen contents of containers advertising this role.  Should be used for warning dialogs, etc.
    | RoleAnimation
    -- ^ An object which is an animated image
    | RoleArrow
    -- ^ An arrow in one of the four cardinal directions
    | RoleCalendar
    -- ^ An object that displays a calendar and allows the user to select a date
    | RoleCanvas
    -- ^ An object that can be drawn into and is used to trap events
    | RoleCheckBox
    -- ^ A choice that can be checked or unchecked and provides a separate indicator for the current state
    | RoleCheckMenuItem
    -- ^ A menu item with a check box
    | RoleColorChooser
    -- ^ A specialized dialog that lets the user choose a color
    | RoleColumnHeader
    -- ^ The header for a column of data
    | RoleComboBox
    -- ^ A collapsible list of choices the user can select from
    | RoleDateEditor
    -- ^ An object whose purpose is to allow a user to edit a date
    | RoleDesktopIcon
    -- ^ An inconifed internal frame within a DESKTOP_PANE
    | RoleDesktopFrame
    -- ^ A pane that supports internal frames and iconified versions of those internal frames
    | RoleDial
    -- ^ An object whose purpose is to allow a user to set a value
    | RoleDialog
    -- ^ A top level window with title bar and a border
    | RoleDirectoryPane
    -- ^ A pane that allows the user to navigate through and select the contents of a directory
    | RoleDrawingArea
    -- ^ An object used for drawing custom user interface elements
    | RoleFileChooser
    -- ^ A specialized dialog that lets the user choose a file
    | RoleFiller
    -- ^ A object that fills up space in a user interface
    | RoleFontChooser
    -- ^ A specialized dialog that lets the user choose a font
    | RoleFrame
    -- ^ A top level window with a title bar, border, menubar, etc.
    | RoleGlassPane
    -- ^ A pane that is guaranteed to be painted on top of all panes beneath it
    | RoleHtmlContainer
    -- ^ A document container for HTML, whose children represent the document content
    | RoleIcon
    -- ^ A small fixed size picture, typically used to decorate components
    | RoleImage
    -- ^ An object whose primary purpose is to display an image
    | RoleInternalFrame
    -- ^ A frame-like object that is clipped by a desktop pane
    | RoleLabel
    -- ^ An object used to present an icon or short string in an interface
    | RoleLayeredPane
    -- ^ A specialized pane that allows its children to be drawn in layers, providing a form of stacking order
    | RoleList
    -- ^ An object that presents a list of objects to the user and allows the user to select one or more of them
    | RoleListItem
    -- ^ An object that represents an element of a list
    | RoleMenu
    -- ^ An object usually found inside a menu bar that contains a list of actions the user can choose from
    | RoleMenuBar
    -- ^ An object usually drawn at the top of the primary dialog box of an application that contains a list of menus the user can choose from
    | RoleMenuItem
    -- ^ An object usually contained in a menu that presents an action the user can choose
    | RoleOptionPane
    -- ^ A specialized pane whose primary use is inside a DIALOG
    | RolePageTab
    -- ^ An object that is a child of a page tab list
    | RolePageTabList
    -- ^ An object that presents a series of panels (or page tabs), one at a time, through some mechanism provided by the object
    | RolePanel
    -- ^ A generic container that is often used to group objects
    | RolePasswordText
    -- ^ A text object uses for passwords, or other places where the text content is not shown visibly to the user
    | RolePopupMenu
    -- ^ A temporary window that is usually used to offer the user a list of choices, and then hides when the user selects one of those choices
    | RoleProgressBar
    -- ^ An object used to indicate how much of a task has been completed
    | RoleButton
    -- ^ An object the user can manipulate to tell the application to do something
    | RoleRadioButton
    -- ^ A specialized check box that will cause other radio buttons in the same group to become unchecked when this one is checked
    | RoleRadioMenuItem
    -- ^ A check menu item which belongs to a group. At each instant exactly one of the radio menu items from a group is selected
    | RoleRootPane
    -- ^ A specialized pane that has a glass pane and a layered pane as its children
    | RoleRowHeader
    -- ^ The header for a row of data
    | RoleScrollBar
    -- ^ An object usually used to allow a user to incrementally view a large amount of data.
    | RoleScrollPane
    -- ^ An object that allows a user to incrementally view a large amount of information
    | RoleSeparator
    -- ^ An object usually contained in a menu to provide a visible and logical separation of the contents in a menu
    | RoleSlider
    -- ^ An object that allows the user to select from a bounded range
    | RoleSplitPane
    -- ^ A specialized panel that presents two other panels at the same time
    | RoleSpinButton
    -- ^ An object used to get an integer or floating point number from the user
    | RoleStatusbar
    -- ^ An object which reports messages of minor importance to the user
    | RoleTable
    -- ^ An object used to represent information in terms of rows and columns
    | RoleTableCell
    -- ^ A cell in a table
    | RoleTableColumnHeader
    -- ^ The header for a column of a table
    | RoleTableRowHeader
    -- ^ The header for a row of a table
    | RoleTearOffMenuItem
    -- ^ A menu item used to tear off and reattach its menu
    | RoleTerminal
    -- ^ An object that represents an accessible terminal.  (Since: 0.6)
    | RoleText
    -- ^ An interactive widget that supports multiple lines of text and
    -- optionally accepts user input, but whose purpose is not to solicit user input.
    -- Thus ATK_ROLE_TEXT is appropriate for the text view in a plain text editor
    -- but inappropriate for an input field in a dialog box or web form. For widgets
    -- whose purpose is to solicit input from the user, see ATK_ROLE_ENTRY and
    -- ATK_ROLE_PASSWORD_TEXT. For generic objects which display a brief amount of
    -- textual information, see ATK_ROLE_STATIC.
    | RoleToggleButton
    -- ^ A specialized push button that can be checked or unchecked, but does not provide a separate indicator for the current state
    | RoleToolBar
    -- ^ A bar or palette usually composed of push buttons or toggle buttons
    | RoleToolTip
    -- ^ An object that provides information about another object
    | RoleTree
    -- ^ An object used to represent hierarchical information to the user
    | RoleTreeTable
    -- ^ An object capable of expanding and collapsing rows as well as showing multiple columns of data.   (Since: 0.7)
    | RoleUnknown
    -- ^ The object contains some Accessible information, but its role is not known
    | RoleViewport
    -- ^ An object usually used in a scroll pane
    | RoleWindow
    -- ^ A top level window with no title or border.
    | RoleHeader
    -- ^ An object that serves as a document header. (Since: 1.1.1)
    | RoleFooter
    -- ^ An object that serves as a document footer.  (Since: 1.1.1)
    | RoleParagraph
    -- ^ An object which is contains a paragraph of text content.   (Since: 1.1.1)
    | RoleRuler
    -- ^ An object which describes margins and tab stops, etc. for text objects which it controls (should have CONTROLLER_FOR relation to such).   (Since: 1.1.1)
    | RoleApplication
    -- ^ The object is an application object, which may contain /@aTKROLEFRAME@/ objects or other types of accessibles.  The root accessible of any application\'s ATK hierarchy should have ATK_ROLE_APPLICATION.   (Since: 1.1.4)
    | RoleAutocomplete
    -- ^ The object is a dialog or list containing items for insertion into an entry widget, for instance a list of words for completion of a text entry.   (Since: 1.3)
    | RoleEditBar
    -- ^ The object is an editable text object in a toolbar.  (Since: 1.5)
    | RoleEmbedded
    -- ^ The object is an embedded container within a document or panel.  This role is a grouping \"hint\" indicating that the contained objects share a context.  (Since: 1.7.2)
    | RoleEntry
    -- ^ The object is a component whose textual content may be entered or modified by the user, provided /@aTKSTATEEDITABLE@/ is present.   (Since: 1.11)
    | RoleChart
    -- ^ The object is a graphical depiction of quantitative data. It may contain multiple subelements whose attributes and\/or description may be queried to obtain both the quantitative data and information about how the data is being presented. The LABELLED_BY relation is particularly important in interpreting objects of this type, as is the accessible-description property.  (Since: 1.11)
    | RoleCaption
    -- ^ The object contains descriptive information, usually textual, about another user interface element such as a table, chart, or image.  (Since: 1.11)
    | RoleDocumentFrame
    -- ^ The object is a visual frame or container which contains a view of document content. Document frames may occur within another Document instance, in which case the second document may be said to be embedded in the containing instance. HTML frames are often ROLE_DOCUMENT_FRAME. Either this object, or a singleton descendant, should implement the Document interface.  (Since: 1.11)
    | RoleHeading
    -- ^ The object serves as a heading for content which follows it in a document. The \'heading level\' of the heading, if availabe, may be obtained by querying the object\'s attributes.
    | RolePage
    -- ^ The object is a containing instance which encapsulates a page of information. /@aTKROLEPAGE@/ is used in documents and content which support a paginated navigation model.  (Since: 1.11)
    | RoleSection
    -- ^ The object is a containing instance of document content which constitutes a particular \'logical\' section of the document. The type of content within a section, and the nature of the section division itself, may be obtained by querying the object\'s attributes. Sections may be nested. (Since: 1.11)
    | RoleRedundantObject
    -- ^ The object is redundant with another object in the hierarchy, and is exposed for purely technical reasons.  Objects of this role should normally be ignored by clients. (Since: 1.11)
    | RoleForm
    -- ^ The object is a container for form controls, for instance as part of a
    -- web form or user-input form within a document.  This role is primarily a tag\/convenience for
    -- clients when navigating complex documents, it is not expected that ordinary GUI containers will
    -- always have ATK_ROLE_FORM. (Since: 1.12.0)
    | RoleLink
    -- ^ The object is a hypertext anchor, i.e. a \"link\" in a
    -- hypertext document.  Such objects are distinct from \'inline\'
    -- content which may also use the Hypertext\/Hyperlink interfaces
    -- to indicate the range\/location within a text object where
    -- an inline or embedded object lies.  (Since: 1.12.1)
    | RoleInputMethodWindow
    -- ^ The object is a window or similar viewport
    -- which is used to allow composition or input of a \'complex character\',
    -- in other words it is an \"input method window.\" (Since: 1.12.1)
    | RoleTableRow
    -- ^ A row in a table.  (Since: 2.1.0)
    | RoleTreeItem
    -- ^ An object that represents an element of a tree.  (Since: 2.1.0)
    | RoleDocumentSpreadsheet
    -- ^ A document frame which contains a spreadsheet.  (Since: 2.1.0)
    | RoleDocumentPresentation
    -- ^ A document frame which contains a presentation or slide content.  (Since: 2.1.0)
    | RoleDocumentText
    -- ^ A document frame which contains textual content, such as found in a word processing application.  (Since: 2.1.0)
    | RoleDocumentWeb
    -- ^ A document frame which contains HTML or other markup suitable for display in a web browser.  (Since: 2.1.0)
    | RoleDocumentEmail
    -- ^ A document frame which contains email content to be displayed or composed either in plain text or HTML.  (Since: 2.1.0)
    | RoleComment
    -- ^ An object found within a document and designed to present a comment, note, or other annotation. In some cases, this object might not be visible until activated.  (Since: 2.1.0)
    | RoleListBox
    -- ^ A non-collapsible list of choices the user can select from. (Since: 2.1.0)
    | RoleGrouping
    -- ^ A group of related widgets. This group typically has a label. (Since: 2.1.0)
    | RoleImageMap
    -- ^ An image map object. Usually a graphic with multiple hotspots, where each hotspot can be activated resulting in the loading of another document or section of a document. (Since: 2.1.0)
    | RoleNotification
    -- ^ A transitory object designed to present a message to the user, typically at the desktop level rather than inside a particular application.  (Since: 2.1.0)
    | RoleInfoBar
    -- ^ An object designed to present a message to the user within an existing window. (Since: 2.1.0)
    | RoleLevelBar
    -- ^ A bar that serves as a level indicator to, for instance, show the strength of a password or the state of a battery.  (Since: 2.7.3)
    | RoleTitleBar
    -- ^ A bar that serves as the title of a window or a
    -- dialog. (Since: 2.12)
    | RoleBlockQuote
    -- ^ An object which contains a text section
    -- that is quoted from another source. (Since: 2.12)
    | RoleAudio
    -- ^ An object which represents an audio element. (Since: 2.12)
    | RoleVideo
    -- ^ An object which represents a video element. (Since: 2.12)
    | RoleDefinition
    -- ^ A definition of a term or concept. (Since: 2.12)
    | RoleArticle
    -- ^ A section of a page that consists of a
    -- composition that forms an independent part of a document, page, or
    -- site. Examples: A blog entry, a news story, a forum post. (Since: 2.12)
    | RoleLandmark
    -- ^ A region of a web page intended as a
    -- navigational landmark. This is designed to allow Assistive
    -- Technologies to provide quick navigation among key regions within a
    -- document. (Since: 2.12)
    | RoleLog
    -- ^ A text widget or container holding log content, such
    -- as chat history and error logs. In this role there is a
    -- relationship between the arrival of new items in the log and the
    -- reading order. The log contains a meaningful sequence and new
    -- information is added only to the end of the log, not at arbitrary
    -- points. (Since: 2.12)
    | RoleMarquee
    -- ^ A container where non-essential information
    -- changes frequently. Common usages of marquee include stock tickers
    -- and ad banners. The primary difference between a marquee and a log
    -- is that logs usually have a meaningful order or sequence of
    -- important content changes. (Since: 2.12)
    | RoleMath
    -- ^ A text widget or container that holds a mathematical
    -- expression. (Since: 2.12)
    | RoleRating
    -- ^ A widget whose purpose is to display a rating,
    -- such as the number of stars associated with a song in a media
    -- player. Objects of this role should also implement
    -- AtkValue. (Since: 2.12)
    | RoleTimer
    -- ^ An object containing a numerical counter which
    -- indicates an amount of elapsed time from a start point, or the time
    -- remaining until an end point. (Since: 2.12)
    | RoleDescriptionList
    -- ^ An object that represents a list of
    -- term-value groups. A term-value group represents a individual
    -- description and consist of one or more names
    -- (ATK_ROLE_DESCRIPTION_TERM) followed by one or more values
    -- (ATK_ROLE_DESCRIPTION_VALUE). For each list, there should not be
    -- more than one group with the same term name. (Since: 2.12)
    | RoleDescriptionTerm
    -- ^ An object that represents a term or phrase
    -- with a corresponding definition. (Since: 2.12)
    | RoleDescriptionValue
    -- ^ An object that represents the
    -- description, definition or value of a term. (Since: 2.12)
    | RoleStatic
    -- ^ A generic non-container object whose purpose is to display a
    -- brief amount of information to the user and whose role is known by the
    -- implementor but lacks semantic value for the user. Examples in which
    -- 'GI.Atk.Enums.RoleStatic' is appropriate include the message displayed in a message box
    -- and an image used as an alternative means to display text. 'GI.Atk.Enums.RoleStatic'
    -- should not be applied to widgets which are traditionally interactive, objects
    -- which display a significant amount of content, or any object which has an
    -- accessible relation pointing to another object. Implementors should expose the
    -- displayed information through the accessible name of the object. If doing so seems
    -- inappropriate, it may indicate that a different role should be used. For
    -- labels which describe another widget, see 'GI.Atk.Enums.RoleLabel'. For text views, see
    -- 'GI.Atk.Enums.RoleText'. For generic containers, see 'GI.Atk.Enums.RolePanel'. For objects whose
    -- role is not known by the implementor, see 'GI.Atk.Enums.RoleUnknown'. (Since: 2.16)
    | RoleMathFraction
    -- ^ An object that represents a mathematical fraction.
    -- (Since: 2.16)
    | RoleMathRoot
    -- ^ An object that represents a mathematical expression
    -- displayed with a radical. (Since: 2.16)
    | RoleSubscript
    -- ^ An object that contains text that is displayed as a
    -- subscript. (Since: 2.16)
    | RoleSuperscript
    -- ^ An object that contains text that is displayed as a
    -- superscript. (Since: 2.16)
    | RoleFootnote
    -- ^ An object that contains the text of a footnote. (Since: 2.26)
    | RoleContentDeletion
    -- ^ Content previously deleted or proposed to be
    -- deleted, e.g. in revision history or a content view providing suggestions
    -- from reviewers. (Since: 2.34)
    | RoleContentInsertion
    -- ^ Content previously inserted or proposed to be
    -- inserted, e.g. in revision history or a content view providing suggestions
    -- from reviewers. (Since: 2.34)
    | RoleMark
    -- ^ A run of content that is marked or highlighted, such as for
    -- reference purposes, or to call it out as having a special purpose. If the
    -- marked content has an associated section in the document elaborating on the
    -- reason for the mark, then 'GI.Atk.Enums.RelationTypeDetails' should be used on the mark
    -- to point to that associated section. In addition, the reciprocal relation
    -- 'GI.Atk.Enums.RelationTypeDetailsFor' should be used on the associated content section
    -- to point back to the mark. (Since: 2.36)
    | RoleSuggestion
    -- ^ A container for content that is called out as a proposed
    -- change from the current version of the document, such as by a reviewer of the
    -- content. This role should include either 'GI.Atk.Enums.RoleContentDeletion' and\/or
    -- 'GI.Atk.Enums.RoleContentInsertion' children, in any order, to indicate what the
    -- actual change is. (Since: 2.36)
    | RolePushButtonMenu
    -- ^ A specialized push button to open a menu.
    -- (Since: 2.46)
    | RoleSwitch
    -- ^ A switch that can be toggled on\/off.
    -- (Since: 2.56)
    | RoleLastDefined
    -- ^ not a valid role, used for finding end of the enumeration
    | RolePushButton
    -- ^ /No description available in the introspection data./
    | AnotherRole Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Role where
    fromEnum RoleInvalid = 0
    fromEnum RoleAcceleratorLabel = 1
    fromEnum RoleAlert = 2
    fromEnum RoleAnimation = 3
    fromEnum RoleArrow = 4
    fromEnum RoleCalendar = 5
    fromEnum RoleCanvas = 6
    fromEnum RoleCheckBox = 7
    fromEnum RoleCheckMenuItem = 8
    fromEnum RoleColorChooser = 9
    fromEnum RoleColumnHeader = 10
    fromEnum RoleComboBox = 11
    fromEnum RoleDateEditor = 12
    fromEnum RoleDesktopIcon = 13
    fromEnum RoleDesktopFrame = 14
    fromEnum RoleDial = 15
    fromEnum RoleDialog = 16
    fromEnum RoleDirectoryPane = 17
    fromEnum RoleDrawingArea = 18
    fromEnum RoleFileChooser = 19
    fromEnum RoleFiller = 20
    fromEnum RoleFontChooser = 21
    fromEnum RoleFrame = 22
    fromEnum RoleGlassPane = 23
    fromEnum RoleHtmlContainer = 24
    fromEnum RoleIcon = 25
    fromEnum RoleImage = 26
    fromEnum RoleInternalFrame = 27
    fromEnum RoleLabel = 28
    fromEnum RoleLayeredPane = 29
    fromEnum RoleList = 30
    fromEnum RoleListItem = 31
    fromEnum RoleMenu = 32
    fromEnum RoleMenuBar = 33
    fromEnum RoleMenuItem = 34
    fromEnum RoleOptionPane = 35
    fromEnum RolePageTab = 36
    fromEnum RolePageTabList = 37
    fromEnum RolePanel = 38
    fromEnum RolePasswordText = 39
    fromEnum RolePopupMenu = 40
    fromEnum RoleProgressBar = 41
    fromEnum RoleButton = 42
    fromEnum RoleRadioButton = 43
    fromEnum RoleRadioMenuItem = 44
    fromEnum RoleRootPane = 45
    fromEnum RoleRowHeader = 46
    fromEnum RoleScrollBar = 47
    fromEnum RoleScrollPane = 48
    fromEnum RoleSeparator = 49
    fromEnum RoleSlider = 50
    fromEnum RoleSplitPane = 51
    fromEnum RoleSpinButton = 52
    fromEnum RoleStatusbar = 53
    fromEnum RoleTable = 54
    fromEnum RoleTableCell = 55
    fromEnum RoleTableColumnHeader = 56
    fromEnum RoleTableRowHeader = 57
    fromEnum RoleTearOffMenuItem = 58
    fromEnum RoleTerminal = 59
    fromEnum RoleText = 60
    fromEnum RoleToggleButton = 61
    fromEnum RoleToolBar = 62
    fromEnum RoleToolTip = 63
    fromEnum RoleTree = 64
    fromEnum RoleTreeTable = 65
    fromEnum RoleUnknown = 66
    fromEnum RoleViewport = 67
    fromEnum RoleWindow = 68
    fromEnum RoleHeader = 69
    fromEnum RoleFooter = 70
    fromEnum RoleParagraph = 71
    fromEnum RoleRuler = 72
    fromEnum RoleApplication = 73
    fromEnum RoleAutocomplete = 74
    fromEnum RoleEditBar = 75
    fromEnum RoleEmbedded = 76
    fromEnum RoleEntry = 77
    fromEnum RoleChart = 78
    fromEnum RoleCaption = 79
    fromEnum RoleDocumentFrame = 80
    fromEnum RoleHeading = 81
    fromEnum RolePage = 82
    fromEnum RoleSection = 83
    fromEnum RoleRedundantObject = 84
    fromEnum RoleForm = 85
    fromEnum RoleLink = 86
    fromEnum RoleInputMethodWindow = 87
    fromEnum RoleTableRow = 88
    fromEnum RoleTreeItem = 89
    fromEnum RoleDocumentSpreadsheet = 90
    fromEnum RoleDocumentPresentation = 91
    fromEnum RoleDocumentText = 92
    fromEnum RoleDocumentWeb = 93
    fromEnum RoleDocumentEmail = 94
    fromEnum RoleComment = 95
    fromEnum RoleListBox = 96
    fromEnum RoleGrouping = 97
    fromEnum RoleImageMap = 98
    fromEnum RoleNotification = 99
    fromEnum RoleInfoBar = 100
    fromEnum RoleLevelBar = 101
    fromEnum RoleTitleBar = 102
    fromEnum RoleBlockQuote = 103
    fromEnum RoleAudio = 104
    fromEnum RoleVideo = 105
    fromEnum RoleDefinition = 106
    fromEnum RoleArticle = 107
    fromEnum RoleLandmark = 108
    fromEnum RoleLog = 109
    fromEnum RoleMarquee = 110
    fromEnum RoleMath = 111
    fromEnum RoleRating = 112
    fromEnum RoleTimer = 113
    fromEnum RoleDescriptionList = 114
    fromEnum RoleDescriptionTerm = 115
    fromEnum RoleDescriptionValue = 116
    fromEnum RoleStatic = 117
    fromEnum RoleMathFraction = 118
    fromEnum RoleMathRoot = 119
    fromEnum RoleSubscript = 120
    fromEnum RoleSuperscript = 121
    fromEnum RoleFootnote = 122
    fromEnum RoleContentDeletion = 123
    fromEnum RoleContentInsertion = 124
    fromEnum RoleMark = 125
    fromEnum RoleSuggestion = 126
    fromEnum RolePushButtonMenu = 127
    fromEnum RoleSwitch = 128
    fromEnum RoleLastDefined = 129
    fromEnum RolePushButton = 42
    fromEnum (AnotherRole k) = k

    toEnum 0 = RoleInvalid
    toEnum 1 = RoleAcceleratorLabel
    toEnum 2 = RoleAlert
    toEnum 3 = RoleAnimation
    toEnum 4 = RoleArrow
    toEnum 5 = RoleCalendar
    toEnum 6 = RoleCanvas
    toEnum 7 = RoleCheckBox
    toEnum 8 = RoleCheckMenuItem
    toEnum 9 = RoleColorChooser
    toEnum 10 = RoleColumnHeader
    toEnum 11 = RoleComboBox
    toEnum 12 = RoleDateEditor
    toEnum 13 = RoleDesktopIcon
    toEnum 14 = RoleDesktopFrame
    toEnum 15 = RoleDial
    toEnum 16 = RoleDialog
    toEnum 17 = RoleDirectoryPane
    toEnum 18 = RoleDrawingArea
    toEnum 19 = RoleFileChooser
    toEnum 20 = RoleFiller
    toEnum 21 = RoleFontChooser
    toEnum 22 = RoleFrame
    toEnum 23 = RoleGlassPane
    toEnum 24 = RoleHtmlContainer
    toEnum 25 = RoleIcon
    toEnum 26 = RoleImage
    toEnum 27 = RoleInternalFrame
    toEnum 28 = RoleLabel
    toEnum 29 = RoleLayeredPane
    toEnum 30 = RoleList
    toEnum 31 = RoleListItem
    toEnum 32 = RoleMenu
    toEnum 33 = RoleMenuBar
    toEnum 34 = RoleMenuItem
    toEnum 35 = RoleOptionPane
    toEnum 36 = RolePageTab
    toEnum 37 = RolePageTabList
    toEnum 38 = RolePanel
    toEnum 39 = RolePasswordText
    toEnum 40 = RolePopupMenu
    toEnum 41 = RoleProgressBar
    toEnum 42 = RoleButton
    toEnum 43 = RoleRadioButton
    toEnum 44 = RoleRadioMenuItem
    toEnum 45 = RoleRootPane
    toEnum 46 = RoleRowHeader
    toEnum 47 = RoleScrollBar
    toEnum 48 = RoleScrollPane
    toEnum 49 = RoleSeparator
    toEnum 50 = RoleSlider
    toEnum 51 = RoleSplitPane
    toEnum 52 = RoleSpinButton
    toEnum 53 = RoleStatusbar
    toEnum 54 = RoleTable
    toEnum 55 = RoleTableCell
    toEnum 56 = RoleTableColumnHeader
    toEnum 57 = RoleTableRowHeader
    toEnum 58 = RoleTearOffMenuItem
    toEnum 59 = RoleTerminal
    toEnum 60 = RoleText
    toEnum 61 = RoleToggleButton
    toEnum 62 = RoleToolBar
    toEnum 63 = RoleToolTip
    toEnum 64 = RoleTree
    toEnum 65 = RoleTreeTable
    toEnum 66 = RoleUnknown
    toEnum 67 = RoleViewport
    toEnum 68 = RoleWindow
    toEnum 69 = RoleHeader
    toEnum 70 = RoleFooter
    toEnum 71 = RoleParagraph
    toEnum 72 = RoleRuler
    toEnum 73 = RoleApplication
    toEnum 74 = RoleAutocomplete
    toEnum 75 = RoleEditBar
    toEnum 76 = RoleEmbedded
    toEnum 77 = RoleEntry
    toEnum 78 = RoleChart
    toEnum 79 = RoleCaption
    toEnum 80 = RoleDocumentFrame
    toEnum 81 = RoleHeading
    toEnum 82 = RolePage
    toEnum 83 = RoleSection
    toEnum 84 = RoleRedundantObject
    toEnum 85 = RoleForm
    toEnum 86 = RoleLink
    toEnum 87 = RoleInputMethodWindow
    toEnum 88 = RoleTableRow
    toEnum 89 = RoleTreeItem
    toEnum 90 = RoleDocumentSpreadsheet
    toEnum 91 = RoleDocumentPresentation
    toEnum 92 = RoleDocumentText
    toEnum 93 = RoleDocumentWeb
    toEnum 94 = RoleDocumentEmail
    toEnum 95 = RoleComment
    toEnum 96 = RoleListBox
    toEnum 97 = RoleGrouping
    toEnum 98 = RoleImageMap
    toEnum 99 = RoleNotification
    toEnum 100 = RoleInfoBar
    toEnum 101 = RoleLevelBar
    toEnum 102 = RoleTitleBar
    toEnum 103 = RoleBlockQuote
    toEnum 104 = RoleAudio
    toEnum 105 = RoleVideo
    toEnum 106 = RoleDefinition
    toEnum 107 = RoleArticle
    toEnum 108 = RoleLandmark
    toEnum 109 = RoleLog
    toEnum 110 = RoleMarquee
    toEnum 111 = RoleMath
    toEnum 112 = RoleRating
    toEnum 113 = RoleTimer
    toEnum 114 = RoleDescriptionList
    toEnum 115 = RoleDescriptionTerm
    toEnum 116 = RoleDescriptionValue
    toEnum 117 = RoleStatic
    toEnum 118 = RoleMathFraction
    toEnum 119 = RoleMathRoot
    toEnum 120 = RoleSubscript
    toEnum 121 = RoleSuperscript
    toEnum 122 = RoleFootnote
    toEnum 123 = RoleContentDeletion
    toEnum 124 = RoleContentInsertion
    toEnum 125 = RoleMark
    toEnum 126 = RoleSuggestion
    toEnum 127 = RolePushButtonMenu
    toEnum 128 = RoleSwitch
    toEnum 129 = RoleLastDefined
    toEnum k = AnotherRole k

instance P.Ord Role where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Role = '[]
instance O.HasParentTypes Role

foreign import ccall "atk_role_get_type" c_atk_role_get_type :: 
    IO GType

instance B.Types.TypedObject Role where
    glibType = c_atk_role_get_type

instance B.Types.BoxedEnum Role

-- Enum RelationType
-- | Describes the type of the relation
data RelationType = 
      RelationTypeNull
    -- ^ Not used, represens \"no relationship\" or an error condition.
    | RelationTypeControlledBy
    -- ^ Indicates an object controlled by one or more target objects.
    | RelationTypeControllerFor
    -- ^ Indicates an object is an controller for one or more target objects.
    | RelationTypeLabelFor
    -- ^ Indicates an object is a label for one or more target objects.
    | RelationTypeLabelledBy
    -- ^ Indicates an object is labelled by one or more target objects.
    | RelationTypeMemberOf
    -- ^ Indicates an object is a member of a group of one or more target objects.
    | RelationTypeNodeChildOf
    -- ^ Indicates an object is a cell in a treetable which is displayed because a cell in the same column is expanded and identifies that cell.
    | RelationTypeFlowsTo
    -- ^ Indicates that the object has content that flows logically to another
    --  AtkObject in a sequential way, (for instance text-flow).
    | RelationTypeFlowsFrom
    -- ^ Indicates that the object has content that flows logically from
    --  another AtkObject in a sequential way, (for instance text-flow).
    | RelationTypeSubwindowOf
    -- ^ Indicates a subwindow attached to a component but otherwise has no connection in  the UI heirarchy to that component.
    | RelationTypeEmbeds
    -- ^ Indicates that the object visually embeds
    --  another object\'s content, i.e. this object\'s content flows around
    --  another\'s content.
    | RelationTypeEmbeddedBy
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeEmbeds', indicates that
    --  this object\'s content is visualy embedded in another object.
    | RelationTypePopupFor
    -- ^ Indicates that an object is a popup for another object.
    | RelationTypeParentWindowOf
    -- ^ Indicates that an object is a parent window of another object.
    | RelationTypeDescribedBy
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeDescriptionFor'. Indicates that one
    -- or more target objects provide descriptive information about this object. This relation
    -- type is most appropriate for information that is not essential as its presentation may
    -- be user-configurable and\/or limited to an on-demand mechanism such as an assistive
    -- technology command. For brief, essential information such as can be found in a widget\'s
    -- on-screen label, use 'GI.Atk.Enums.RelationTypeLabelledBy'. For an on-screen error message, use
    -- 'GI.Atk.Enums.RelationTypeErrorMessage'. For lengthy extended descriptive information contained in
    -- an on-screen object, consider using 'GI.Atk.Enums.RelationTypeDetails' as assistive technologies may
    -- provide a means for the user to navigate to objects containing detailed descriptions so
    -- that their content can be more closely reviewed.
    | RelationTypeDescriptionFor
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeDescribedBy'. Indicates that this
    -- object provides descriptive information about the target object(s). See also
    -- 'GI.Atk.Enums.RelationTypeDetailsFor' and 'GI.Atk.Enums.RelationTypeErrorFor'.
    | RelationTypeNodeParentOf
    -- ^ Indicates an object is a cell in a treetable and is expanded to display other cells in the same column.
    | RelationTypeDetails
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeDetailsFor'. Indicates that this object
    -- has a detailed or extended description, the contents of which can be found in the target
    -- object(s). This relation type is most appropriate for information that is sufficiently
    -- lengthy as to make navigation to the container of that information desirable. For less
    -- verbose information suitable for announcement only, see 'GI.Atk.Enums.RelationTypeDescribedBy'. If
    -- the detailed information describes an error condition, 'GI.Atk.Enums.RelationTypeErrorFor' should be
    -- used instead. /@since@/: ATK-2.26.
    | RelationTypeDetailsFor
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeDetails'. Indicates that this object
    -- provides a detailed or extended description about the target object(s). See also
    -- 'GI.Atk.Enums.RelationTypeDescriptionFor' and 'GI.Atk.Enums.RelationTypeErrorFor'. /@since@/: ATK-2.26.
    | RelationTypeErrorMessage
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeErrorFor'. Indicates that this object
    -- has one or more errors, the nature of which is described in the contents of the target
    -- object(s). Objects that have this relation type should also contain 'GI.Atk.Enums.StateTypeInvalidEntry'
    -- in their t'GI.Atk.Objects.StateSet.StateSet'. /@since@/: ATK-2.26.
    | RelationTypeErrorFor
    -- ^ Reciprocal of 'GI.Atk.Enums.RelationTypeErrorMessage'. Indicates that this object
    -- contains an error message describing an invalid condition in the target object(s). /@since@/:
    -- ATK_2.26.
    | RelationTypeLastDefined
    -- ^ Not used, this value indicates the end of the enumeration.
    | AnotherRelationType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum RelationType where
    fromEnum RelationTypeNull = 0
    fromEnum RelationTypeControlledBy = 1
    fromEnum RelationTypeControllerFor = 2
    fromEnum RelationTypeLabelFor = 3
    fromEnum RelationTypeLabelledBy = 4
    fromEnum RelationTypeMemberOf = 5
    fromEnum RelationTypeNodeChildOf = 6
    fromEnum RelationTypeFlowsTo = 7
    fromEnum RelationTypeFlowsFrom = 8
    fromEnum RelationTypeSubwindowOf = 9
    fromEnum RelationTypeEmbeds = 10
    fromEnum RelationTypeEmbeddedBy = 11
    fromEnum RelationTypePopupFor = 12
    fromEnum RelationTypeParentWindowOf = 13
    fromEnum RelationTypeDescribedBy = 14
    fromEnum RelationTypeDescriptionFor = 15
    fromEnum RelationTypeNodeParentOf = 16
    fromEnum RelationTypeDetails = 17
    fromEnum RelationTypeDetailsFor = 18
    fromEnum RelationTypeErrorMessage = 19
    fromEnum RelationTypeErrorFor = 20
    fromEnum RelationTypeLastDefined = 21
    fromEnum (AnotherRelationType k) = k

    toEnum 0 = RelationTypeNull
    toEnum 1 = RelationTypeControlledBy
    toEnum 2 = RelationTypeControllerFor
    toEnum 3 = RelationTypeLabelFor
    toEnum 4 = RelationTypeLabelledBy
    toEnum 5 = RelationTypeMemberOf
    toEnum 6 = RelationTypeNodeChildOf
    toEnum 7 = RelationTypeFlowsTo
    toEnum 8 = RelationTypeFlowsFrom
    toEnum 9 = RelationTypeSubwindowOf
    toEnum 10 = RelationTypeEmbeds
    toEnum 11 = RelationTypeEmbeddedBy
    toEnum 12 = RelationTypePopupFor
    toEnum 13 = RelationTypeParentWindowOf
    toEnum 14 = RelationTypeDescribedBy
    toEnum 15 = RelationTypeDescriptionFor
    toEnum 16 = RelationTypeNodeParentOf
    toEnum 17 = RelationTypeDetails
    toEnum 18 = RelationTypeDetailsFor
    toEnum 19 = RelationTypeErrorMessage
    toEnum 20 = RelationTypeErrorFor
    toEnum 21 = RelationTypeLastDefined
    toEnum k = AnotherRelationType k

instance P.Ord RelationType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes RelationType = '[]
instance O.HasParentTypes RelationType

foreign import ccall "atk_relation_type_get_type" c_atk_relation_type_get_type :: 
    IO GType

instance B.Types.TypedObject RelationType where
    glibType = c_atk_relation_type_get_type

instance B.Types.BoxedEnum RelationType

-- Enum Live
-- | Enumeration used to indicate a type of live region and how assertive it
-- should be in terms of speaking notifications. Currently, this is only used
-- for \"notification\" events, but it may be used for additional purposes
-- in the future.
-- 
-- /Since: 2.50/
data Live = 
      LiveNone
    -- ^ No live region.
    | LivePolite
    -- ^ This live region should be considered polite.
    | LiveAssertive
    -- ^ This live region should be considered assertive.
    | AnotherLive Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Live where
    fromEnum LiveNone = 0
    fromEnum LivePolite = 1
    fromEnum LiveAssertive = 2
    fromEnum (AnotherLive k) = k

    toEnum 0 = LiveNone
    toEnum 1 = LivePolite
    toEnum 2 = LiveAssertive
    toEnum k = AnotherLive k

instance P.Ord Live where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Live = '[]
instance O.HasParentTypes Live

foreign import ccall "atk_live_get_type" c_atk_live_get_type :: 
    IO GType

instance B.Types.TypedObject Live where
    glibType = c_atk_live_get_type

instance B.Types.BoxedEnum Live

-- Enum Layer
-- | Describes the layer of a component
-- 
-- These enumerated \"layer values\" are used when determining which UI
-- rendering layer a component is drawn into, which can help in making
-- determinations of when components occlude one another.
data Layer = 
      LayerInvalid
    -- ^ The object does not have a layer
    | LayerBackground
    -- ^ This layer is reserved for the desktop background
    | LayerCanvas
    -- ^ This layer is used for Canvas components
    | LayerWidget
    -- ^ This layer is normally used for components
    | LayerMdi
    -- ^ This layer is used for layered components
    | LayerPopup
    -- ^ This layer is used for popup components, such as menus
    | LayerOverlay
    -- ^ This layer is reserved for future use.
    | LayerWindow
    -- ^ This layer is used for toplevel windows.
    | AnotherLayer Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum Layer where
    fromEnum LayerInvalid = 0
    fromEnum LayerBackground = 1
    fromEnum LayerCanvas = 2
    fromEnum LayerWidget = 3
    fromEnum LayerMdi = 4
    fromEnum LayerPopup = 5
    fromEnum LayerOverlay = 6
    fromEnum LayerWindow = 7
    fromEnum (AnotherLayer k) = k

    toEnum 0 = LayerInvalid
    toEnum 1 = LayerBackground
    toEnum 2 = LayerCanvas
    toEnum 3 = LayerWidget
    toEnum 4 = LayerMdi
    toEnum 5 = LayerPopup
    toEnum 6 = LayerOverlay
    toEnum 7 = LayerWindow
    toEnum k = AnotherLayer k

instance P.Ord Layer where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes Layer = '[]
instance O.HasParentTypes Layer

foreign import ccall "atk_layer_get_type" c_atk_layer_get_type :: 
    IO GType

instance B.Types.TypedObject Layer where
    glibType = c_atk_layer_get_type

instance B.Types.BoxedEnum Layer

-- Enum KeyEventType
-- | Specifies the type of a keyboard evemt.
data KeyEventType = 
      KeyEventTypePress
    -- ^ specifies a key press event
    | KeyEventTypeRelease
    -- ^ specifies a key release event
    | KeyEventTypeLastDefined
    -- ^ Not a valid value; specifies end of enumeration
    | AnotherKeyEventType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum KeyEventType where
    fromEnum KeyEventTypePress = 0
    fromEnum KeyEventTypeRelease = 1
    fromEnum KeyEventTypeLastDefined = 2
    fromEnum (AnotherKeyEventType k) = k

    toEnum 0 = KeyEventTypePress
    toEnum 1 = KeyEventTypeRelease
    toEnum 2 = KeyEventTypeLastDefined
    toEnum k = AnotherKeyEventType k

instance P.Ord KeyEventType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes KeyEventType = '[]
instance O.HasParentTypes KeyEventType

foreign import ccall "atk_key_event_type_get_type" c_atk_key_event_type_get_type :: 
    IO GType

instance B.Types.TypedObject KeyEventType where
    glibType = c_atk_key_event_type_get_type

instance B.Types.BoxedEnum KeyEventType

-- Enum CoordType
-- | Specifies how xy coordinates are to be interpreted. Used by functions such
-- as 'GI.Atk.Interfaces.Component.componentGetPosition' and 'GI.Atk.Interfaces.Text.textGetCharacterExtents'
data CoordType = 
      CoordTypeScreen
    -- ^ specifies xy coordinates relative to the screen
    | CoordTypeWindow
    -- ^ specifies xy coordinates relative to the widget\'s
    -- top-level window
    | CoordTypeParent
    -- ^ specifies xy coordinates relative to the widget\'s
    -- immediate parent. Since: 2.30
    | AnotherCoordType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum CoordType where
    fromEnum CoordTypeScreen = 0
    fromEnum CoordTypeWindow = 1
    fromEnum CoordTypeParent = 2
    fromEnum (AnotherCoordType k) = k

    toEnum 0 = CoordTypeScreen
    toEnum 1 = CoordTypeWindow
    toEnum 2 = CoordTypeParent
    toEnum k = AnotherCoordType k

instance P.Ord CoordType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes CoordType = '[]
instance O.HasParentTypes CoordType

foreign import ccall "atk_coord_type_get_type" c_atk_coord_type_get_type :: 
    IO GType

instance B.Types.TypedObject CoordType where
    glibType = c_atk_coord_type_get_type

instance B.Types.BoxedEnum CoordType


