﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amp/model/UpdateScraperRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::PrometheusService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateScraperRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_aliasHasBeenSet)
  {
   payload.WithString("alias", m_alias);

  }

  if(m_clientTokenHasBeenSet)
  {
   payload.WithString("clientToken", m_clientToken);

  }

  if(m_destinationHasBeenSet)
  {
   payload.WithObject("destination", m_destination.Jsonize());

  }

  if(m_roleConfigurationHasBeenSet)
  {
   payload.WithObject("roleConfiguration", m_roleConfiguration.Jsonize());

  }

  if(m_scrapeConfigurationHasBeenSet)
  {
   payload.WithObject("scrapeConfiguration", m_scrapeConfiguration.Jsonize());

  }

  return payload.View().WriteReadable();
}




