/*
 * Copyright Mesa3D Contributors
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#include "compiler/nir/nir.h"
#include "compiler/nir/nir_builder.h"

#include "util/u_printf.h"

#ifdef __cplusplus
extern "C" {
#endif
nir_def *
libagx_map_vertex_in_tri_strip(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_map_vertex_in_tri_strip(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    1      %2 = @load_param (param_idx=2)
    32     %3 = load_const (0x00000002)
    32     %4 = load_const (0x00000000)
    32     %5 = bcsel %2, %4 (0x0), %3 (0x2)
    32     %6 = load_const (0x00000001)
    32     %7 = iand %0, %6 (0x1)
    1      %8 = ieq %7, %4 (0x0)
    1      %9 = ieq %1, %5
    1     %10 = ior %8, %9
    32    %11 = load_const (0x00000003)
    32    %12 = bcsel %2, %11 (0x3), %6 (0x1)
    32    %13 = ineg %1
    32    %14 = iadd %12, %13
    32    %15 = bcsel %10, %1, %14
                @bindgen_return (%15)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[61] = {
    0x00000012, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000011, 0xc40017e4,
    0xc40117e4, 0x240217e4, 0x00005605, 0x00000e05,
    0xc4239800, 0x00000000, 0x00060004, 0x00000005,
    0x00003605, 0xc429a800, 0x00000000, 0x00080002,
    0x2469d000, 0x00000000, 0x00060009, 0x00000000,
    0x00070003, 0x242b0800, 0x00000000, 0x000b000a,
    0x00007605, 0xc4239800, 0x00000000, 0x000d0004,
    0x00000008, 0xc42ae000, 0x00000000, 0x00000003,
    0xc4299000, 0x00000000, 0x000f000e, 0xc4239800,
    0x00000000, 0x0003000c, 0x00000010, 0x00000304,
    0x00000044,
};
   nir_def *args[3] = { prim, vert, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_xfb_vertex_copy_in_strip(nir_builder *b, nir_def *n, nir_def *id, nir_def *length, nir_def *copy);

nir_def *
libagx_xfb_vertex_copy_in_strip(nir_builder *b, nir_def *n, nir_def *id, nir_def *length, nir_def *copy)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = load_const (0xffffffff = -1 = 4294967295)
    32     %5 = iadd %0, %4 (0xffffffff)
    32     %6 = usub_sat %1, %5
    32     %7 = iadd %6, %3
    32     %8 = ineg %5
    32     %9 = iadd %2, %8
    32    %10 = load_const (0x00000000)
    1     %11 = ieq %3, %10 (0x0)
    1     %12 = ult %7, %9
    1     %13 = uge %1, %3
    1     %14 = iand %13, %12
    1     %15 = ult %3, %9
    1     %16 = iand %14, %15
    1     %17 = ior %11, %16
                @bindgen_return (%17)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[71] = {
    0x00000014, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000013, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xfffff605,
    0xc4299000, 0x00000000, 0x00060002, 0xc42f1000,
    0x00000000, 0x00070003, 0xc4299000, 0x00000000,
    0x00050008, 0xc42ae000, 0x00000000, 0x00000007,
    0xc4299000, 0x00000000, 0x000a0004, 0x00000e05,
    0x2429d000, 0x00000000, 0x000c0005, 0x242dc800,
    0x00000000, 0x000b0009, 0x242d9800, 0x00000000,
    0x00050003, 0x2429a800, 0x00000000, 0x000e000f,
    0x242dc800, 0x00000000, 0x000b0005, 0x2429a800,
    0x00000000, 0x00110010, 0x242b0800, 0x00000000,
    0x0012000d, 0x00000304, 0x0000004c,
};
   nir_def *args[4] = { n, id, length, copy };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_xfb_vertex_offset(nir_builder *b, nir_def *n, nir_def *invocation_base_prim, nir_def *strip_base_prim, nir_def *id_in_strip, nir_def *copy, nir_def *flatshade_first);

nir_def *
libagx_xfb_vertex_offset(nir_builder *b, nir_def *n, nir_def *invocation_base_prim, nir_def *strip_base_prim, nir_def *id_in_strip, nir_def *copy, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = @load_param (param_idx=4)
    1      %5 = @load_param (param_idx=5)
    32     %6 = load_const (0x00000001)
    32     %7 = load_const (0xffffffff = -1 = 4294967295)
    32     %8 = iadd %0, %7 (0xffffffff)
    32     %9 = usub_sat %3, %8
    32    %10 = iadd %9, %4
    32    %11 = umin %3, %8
    32    %12 = ineg %4
    32    %13 = iadd %11, %12
    32    %14 = load_const (0x00000003)
    1     %15 = ieq %0, %14 (0x3)
    32    %16 = load_const (0x00000002)
    32    %17 = load_const (0x00000000)
    32    %18 = bcsel %5, %17 (0x0), %16 (0x2)
    32    %19 = iand %10, %6 (0x1)
    1     %20 = ieq %19, %17 (0x0)
    1     %21 = ieq %13, %18
    1     %22 = ior %20, %21
    32    %23 = bcsel %5, %14 (0x3), %6 (0x1)
    32    %24 = ineg %13
    32    %25 = iadd %23, %24
    1     %26 = inot %22
    1     %27 = iand %15, %26
    32    %28 = bcsel %27, %25, %13
    32    %29 = iadd %1, %2
    32    %30 = iadd %29, %10
    32    %31 = imul %0, %30
    32    %32 = iadd %31, %28
                @bindgen_return (%32)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[115] = {
    0x00000023, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000006, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000022, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xc40417e4,
    0x240517e4, 0x00003605, 0xfffff605, 0xc4299000,
    0x00000000, 0x00090002, 0xc42f1000, 0x00000000,
    0x000a0005, 0xc4299000, 0x00000000, 0x0006000b,
    0xc42e0800, 0x00000000, 0x000a0005, 0xc42ae000,
    0x00000000, 0x00000006, 0xc4299000, 0x00000000,
    0x000e000d, 0x00007605, 0x2429d000, 0x00000000,
    0x00100002, 0x00005605, 0x00000e05, 0xc4239800,
    0x00000000, 0x00130007, 0x00000012, 0xc429a800,
    0x00000000, 0x0008000c, 0x2469d000, 0x00000000,
    0x00130015, 0x00000000, 0x0014000f, 0x242b0800,
    0x00000000, 0x00170016, 0xc4239800, 0x00000000,
    0x00100007, 0x00000008, 0xc42ae000, 0x00000000,
    0x0000000f, 0xc4299000, 0x00000000, 0x001a0019,
    0x242ae800, 0x00000000, 0x00000018, 0x2429a800,
    0x00000000, 0x001c0011, 0xc4239800, 0x00000000,
    0x001b001d, 0x0000000f, 0xc4699000, 0x00000000,
    0x00040003, 0x00000000, 0x000c001f, 0xc42a9000,
    0x00000000, 0x00200002, 0xc4299000, 0x00000000,
    0x001e0021, 0x00000304, 0x00000088,
};
   nir_def *args[6] = { n, invocation_base_prim, strip_base_prim, id_in_strip, copy, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_xfb_vertex_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *buffer, nir_def *stride, nir_def *output_offset);

nir_def *
libagx_xfb_vertex_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *buffer, nir_def *stride, nir_def *output_offset)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = @load_param (param_idx=4)
    32     %5 = imul %1, %3
    32     %6 = iadd %5, %4
    64     %7 = load_const (0x00000000000000c0 = 192)
    64     %8 = iadd %0, %7 (0xc0)
    32     %9 = load_const (0x00000003)
    32    %10 = ishl %2, %9 (0x3)
    64    %11 = u2u64 %10
    64    %12 = iadd %8, %11
    64    %13 = @load_global_constant (%12) (access=none, align_mul=4, align_offset=0)
    64    %14 = u2u64 %6
    64    %15 = iadd %13, %14
                @bindgen_return (%15)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[67] = {
    0x00000012, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000005, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000011, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xc40417e4,
    0xc42a9000, 0x00000000, 0x00050003, 0xc4299000,
    0x00000000, 0x00060007, 0x00181705, 0xe4299000,
    0x00000000, 0x00090002, 0x00007605, 0xc42b2000,
    0x00000000, 0x000b0004, 0xe42d1000, 0x00000000,
    0x0000000c, 0xe4299000, 0x00000000, 0x000d000a,
    0xe4005434, 0x00000038, 0x00000400, 0xe42d1000,
    0x00000000, 0x00000008, 0xe4299000, 0x00000000,
    0x0010000f, 0x00000304, 0x00000044,
};
   nir_def *args[5] = { p, index, buffer, stride, output_offset };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_line_loop(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims);

nir_def *
libagx_vertex_id_for_line_loop(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = load_const (0x00000001)
    32     %4 = load_const (0xffffffff = -1 = 4294967295)
    32     %5 = iadd %2, %4 (0xffffffff)
    1      %6 = ieq %0, %5
    32     %7 = load_const (0x00000000)
    1      %8 = ieq %1, %3 (0x1)
    1      %9 = iand %8, %6
    32    %10 = iadd %0, %1
    32    %11 = bcsel %9, %7 (0x0), %10
                @bindgen_return (%11)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[50] = {
    0x0000000e, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000d, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0x00003605, 0xfffff605,
    0xc4299000, 0x00000000, 0x00060004, 0x2429d000,
    0x00000000, 0x00070002, 0x00000e05, 0x2429d000,
    0x00000000, 0x00050003, 0x2429a800, 0x00000000,
    0x0008000a, 0xc4299000, 0x00000000, 0x00030002,
    0xc4239800, 0x00000000, 0x0009000b, 0x0000000c,
    0x00000304, 0x00000034,
};
   nir_def *args[3] = { prim, vert, num_prims };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_line_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *num_prims);

nir_def *
libagx_vertex_id_for_line_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *num_prims)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = load_const (0x00000002)
    1      %5 = ieq %0, %4 (0x2)
    32     %6 = load_const (0x00000000)
    32     %7 = load_const (0x00000001)
    32     %8 = load_const (0xffffffff = -1 = 4294967295)
    32     %9 = iadd %3, %8 (0xffffffff)
    1     %10 = ieq %1, %9
    1     %11 = ieq %2, %7 (0x1)
    1     %12 = iand %11, %10
    1     %13 = iand %12, %5
    1     %14 = ieq %0, %7 (0x1)
    32    %15 = ishl %1, %7 (0x1)
    32    %16 = bcsel %14, %15, %1
    32    %17 = iadd %16, %2
    32    %18 = bcsel %13, %6 (0x0), %17
                @bindgen_return (%18)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[70] = {
    0x00000015, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000014, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x00005605,
    0x2429d000, 0x00000000, 0x00060002, 0x00000e05,
    0x00003605, 0xfffff605, 0xc4299000, 0x00000000,
    0x000a0005, 0x2469d000, 0x00000000, 0x000b0003,
    0x00000000, 0x00090004, 0x2469a800, 0x00000000,
    0x000c000d, 0x00000000, 0x0007000e, 0x2429d000,
    0x00000000, 0x00090002, 0xc42b2000, 0x00000000,
    0x00090003, 0xc4239800, 0x00000000, 0x00110010,
    0x00000003, 0xc4299000, 0x00000000, 0x00040012,
    0xc4239800, 0x00000000, 0x0008000f, 0x00000013,
    0x00000304, 0x00000050,
};
   nir_def *args[4] = { mode, prim, vert, num_prims };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_tri_fan(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_fan(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    1      %2 = @load_param (param_idx=2)
    32     %3 = load_const (0x00000002)
    1      %4 = ieq %1, %3 (0x2)
    32     %5 = load_const (0x00000001)
    32     %6 = iadd %1, %5 (0x1)
    32     %7 = load_const (0x00000000)
    32     %8 = bcsel %4, %7 (0x0), %6
    32     %9 = bcsel %2, %8, %1
    1     %10 = ieq %9, %7 (0x0)
    32    %11 = iadd %0, %9
    32    %12 = bcsel %10, %7 (0x0), %11
                @bindgen_return (%12)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[54] = {
    0x0000000f, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000e, 0xc40017e4,
    0xc40117e4, 0x240217e4, 0x00005605, 0x2429d000,
    0x00000000, 0x00050003, 0x00003605, 0xc4299000,
    0x00000000, 0x00070003, 0x00000e05, 0xc4639800,
    0x00000000, 0x00090006, 0x00000008, 0x00000000,
    0x000a0004, 0x00000003, 0x2429d000, 0x00000000,
    0x0009000b, 0xc4299000, 0x00000000, 0x000b0002,
    0xc4239800, 0x00000000, 0x0009000c, 0x0000000d,
    0x00000304, 0x00000038,
};
   nir_def *args[3] = { prim, vert, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_tri_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    1      %3 = @load_param (param_idx=3)
    32     %4 = load_const (0x00000006)
    1      %5 = ieq %0, %4 (0x6)
    1      %6 = iand %5, %3
    32     %7 = load_const (0x00000001)
    32     %8 = iadd %2, %7 (0x1)
    32     %9 = load_const (0x00000003)
    1     %10 = ieq %8, %9 (0x3)
    32    %11 = load_const (0x00000000)
    32    %12 = bcsel %10, %11 (0x0), %8
    32    %13 = bcsel %6, %12, %2
    1     %14 = ieq %13, %11 (0x0)
    1     %15 = iand %14, %5
    32    %16 = load_const (0x00000004)
    1     %17 = ieq %0, %16 (0x4)
    32    %18 = imul %1, %9 (0x3)
    32    %19 = bcsel %17, %18, %1
    32    %20 = load_const (0x00000005)
    1     %21 = ieq %0, %20 (0x5)
    32    %22 = load_const (0x00000002)
    32    %23 = bcsel %3, %11 (0x0), %22 (0x2)
    32    %24 = iand %19, %7 (0x1)
    1     %25 = ieq %24, %11 (0x0)
    1     %26 = ieq %13, %23
    1     %27 = ior %25, %26
    32    %28 = bcsel %3, %9 (0x3), %7 (0x1)
    32    %29 = ineg %13
    32    %30 = iadd %28, %29
    1     %31 = inot %27
    1     %32 = iand %21, %31
    32    %33 = bcsel %32, %30, %13
    32    %34 = iadd %19, %33
    32    %35 = bcsel %15, %11 (0x0), %34
                @bindgen_return (%35)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[120] = {
    0x00000026, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000025, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0x240317e4, 0x0000d605,
    0x2429d000, 0x00000000, 0x00060002, 0x2429a800,
    0x00000000, 0x00050007, 0x00003605, 0xc4299000,
    0x00000000, 0x00090004, 0x00007605, 0x2429d000,
    0x00000000, 0x000b000a, 0x00000e05, 0xc4639800,
    0x00000000, 0x000d000c, 0x0000000a, 0x00000000,
    0x000e0008, 0x00000004, 0x2429d000, 0x00000000,
    0x000d000f, 0x2429a800, 0x00000000, 0x00070010,
    0x00009605, 0x2429d000, 0x00000000, 0x00120002,
    0xc42a9000, 0x00000000, 0x000b0003, 0xc4239800,
    0x00000000, 0x00140013, 0x00000003, 0x0000b605,
    0x2429d000, 0x00000000, 0x00160002, 0x00005605,
    0xc4239800, 0x00000000, 0x000d0005, 0x00000018,
    0xc429a800, 0x00000000, 0x00090015, 0x2469d000,
    0x00000000, 0x000d001a, 0x00000000, 0x0019000f,
    0x242b0800, 0x00000000, 0x001c001b, 0xc4239800,
    0x00000000, 0x000b0005, 0x00000009, 0xc42ae000,
    0x00000000, 0x0000000f, 0xc4299000, 0x00000000,
    0x001f001e, 0x242ae800, 0x00000000, 0x0000001d,
    0x2429a800, 0x00000000, 0x00210017, 0xc4239800,
    0x00000000, 0x00200022, 0x0000000f, 0xc4299000,
    0x00000000, 0x00230015, 0xc4239800, 0x00000000,
    0x000d0011, 0x00000024, 0x00000304, 0x00000094,
};
   nir_def *args[4] = { mode, prim, vert, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_line_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert);

nir_def *
libagx_vertex_id_for_line_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert)
{
   /*
    block b0:  // preds:
    32    %0 = @load_param (param_idx=0)
    32    %1 = @load_param (param_idx=1)
    32    %2 = @load_param (param_idx=2)
    32    %3 = load_const (0x0000000a = 10)
    1     %4 = ieq %0, %3 (0xa)
    32    %5 = load_const (0x00000002)
    32    %6 = ishl %1, %5 (0x2)
    32    %7 = bcsel %4, %6, %1
    32    %8 = iadd %7, %2
               @bindgen_return (%8)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[43] = {
    0x0000000b, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000a, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0x00015605, 0x2429d000,
    0x00000000, 0x00050002, 0x00005605, 0xc42b2000,
    0x00000000, 0x00070003, 0xc4239800, 0x00000000,
    0x00080006, 0x00000003, 0xc4299000, 0x00000000,
    0x00040009, 0x00000304, 0x00000028,
};
   nir_def *args[3] = { mode, prim, vert };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_tri_strip_adj(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_strip_adj(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    1      %3 = @load_param (param_idx=3)
    32     %4 = load_const (0x00000001)
    32     %5 = load_const (0xffffffff = -1 = 4294967295)
    32     %6 = iadd %2, %5 (0xffffffff)
    1      %7 = ieq %0, %6
    32     %8 = load_const (0x00000000)
    1      %9 = ieq %0, %8 (0x0)
    32    %10 = iand %0, %4 (0x1)
    1     %11 = ieq %10, %8 (0x0)
    32    %12 = umin %10, %0
    1     %13 = ieq %12, %8 (0x0)
    1     %14 = ior %13, %3
    32    %15 = load_const (0x00000004)
    32    %16 = iadd %1, %15 (0x4)
    32    %17 = load_const (0x00000006)
    32    %18 = umod %16, %17 (0x6)
    32    %19 = bcsel %14, %1, %18
    32    %20 = load_const (0x00000003)
    32    %21 = load_const (0xfffffffe = -2 = 4294967294)
    32    %22 = bcsel %11, %21 (0xfffffffe), %20 (0x3)
    32    %23 = bcsel %9, %4 (0x1), %22
    32    %24 = load_const (0x00000002)
    32    %25 = bcsel %13, %24 (0x2), %15 (0x4)
    32    %26 = load_const (0x00000005)
    32    %27 = bcsel %7, %26 (0x5), %17 (0x6)
    32    %28 = bcsel %13, %15 (0x4), %24 (0x2)
    32    %29 = bcsel %13, %20 (0x3), %21 (0xfffffffe)
    1     %30 = ieq %4 (0x1), %19
                // succs: b1 b2
    if %30 {
        block b1:  // preds: b0, succs: b3
    } else {
        block b2:  // preds: b0, succs: b3
    }
    block b3:   // preds: b1 b2
    32    %31 = phi b1: %23, b2: %8 (0x0)
    1     %32 = ieq %24 (0x2), %19
                // succs: b4 b5
    if %32 {
        block b4:  // preds: b3, succs: b6
    } else {
        block b5:  // preds: b3, succs: b6
    }
    block b6:   // preds: b4 b5
    32    %33 = phi b4: %25, b5: %31
    1     %34 = ieq %20 (0x3), %19
                // succs: b7 b8
    if %34 {
        block b7:  // preds: b6, succs: b9
    } else {
        block b8:  // preds: b6, succs: b9
    }
    block b9:   // preds: b7 b8
    32    %35 = phi b7: %27, b8: %33
    1     %36 = ieq %15 (0x4), %19
                // succs: b10 b11
    if %36 {
        block b10:  // preds: b9, succs: b12
    } else {
        block b11:  // preds: b9, succs: b12
    }
    block b12:  // preds: b10 b11
    32    %37 = phi b10: %28, b11: %35
    1     %38 = ieq %26 (0x5), %19
                // succs: b13 b14
    if %38 {
        block b13:  // preds: b12, succs: b15
    } else {
        block b14:  // preds: b12, succs: b15
    }
    block b15:  // preds: b13 b14
    32    %39 = phi b13: %29, b14: %37
    32    %40 = ishl %0, %4 (0x1)
    32    %41 = iadd %40, %39
                @bindgen_return (%41)
                // succs: b16
    block b16:
   */
   static const uint32_t impl_0_nir[198] = {
    0x0000003b, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x0000000b, 0x00000000, 0x0000001f, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0x240317e4, 0x00003605,
    0xfffff605, 0xc4299000, 0x00000000, 0x00070004,
    0x2429d000, 0x00000000, 0x00080002, 0x00000e05,
    0x2429d000, 0x00000000, 0x000a0002, 0xc429a800,
    0x00000000, 0x00060002, 0x2429d000, 0x00000000,
    0x000a000c, 0xc42e0800, 0x00000000, 0x0002000c,
    0x2429d000, 0x00000000, 0x000a000e, 0x242b0800,
    0x00000000, 0x0005000f, 0x00009605, 0xc4299000,
    0x00000000, 0x00110003, 0x0000d605, 0xc42e1800,
    0x00000000, 0x00130012, 0xc4239800, 0x00000000,
    0x00030010, 0x00000014, 0x00007605, 0xffffd605,
    0xc4639800, 0x00000000, 0x0017000d, 0x00000016,
    0x00000000, 0x0006000b, 0x00000018, 0x00005605,
    0xc4239800, 0x00000000, 0x001a000f, 0x00000011,
    0x0000b605, 0xc4a39800, 0x00000000, 0x001c0009,
    0x00000013, 0x00000000, 0x0011000f, 0x0000001a,
    0x00000000, 0x0016000f, 0x00000017, 0x2429d000,
    0x00000000, 0x00150006, 0x00000001, 0x00000080,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000002, 0xc4000028, 0x00000019, 0x00000021,
    0x0000000a, 0x00000022, 0x2429d000, 0x00000000,
    0x0015001a, 0x00000001, 0x00000094, 0x00000000,
    0x00000001, 0x00000000, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0xc4000028, 0x0000001b, 0x00000026, 0x00000024,
    0x00000027, 0x2429d000, 0x00000000, 0x00150016,
    0x00000001, 0x000000a8, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000002, 0xc4000028,
    0x0000001d, 0x0000002b, 0x00000029, 0x0000002c,
    0x2429d000, 0x00000000, 0x00150011, 0x00000001,
    0x000000bc, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0xc4000028, 0x0000001e,
    0x00000030, 0x0000002e, 0x00000031, 0x2429d000,
    0x00000000, 0x0015001c, 0x00000001, 0x000000d0,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000004, 0xc4000028, 0x0000001f, 0x00000035,
    0x00000033, 0x00000036, 0xc42b2000, 0x00000000,
    0x00060002, 0xc4299000, 0x00000000, 0x00380039,
    0x00000304, 0x000000e8,
};
   nir_def *args[4] = { prim, vert, num_prims, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_id_for_tri_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *nr, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *nr, nir_def *flatshade_first)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    1      %4 = @load_param (param_idx=4)
    32     %5 = load_const (0x0000000d = 13)
    1      %6 = ine %0, %5 (0xd)
                // succs: b1 b2
    if %6 {
        block b1:   // preds: b0
        32     %7 = load_const (0x00000006)
        32     %8 = imul %7 (0x6), %1
        32     %9 = iadd %8, %2
                    // succs: b18
    } else {
        block b2:   // preds: b0
        32    %10 = load_const (0x00000001)
        32    %11 = load_const (0xffffffff = -1 = 4294967295)
        32    %12 = iadd %3, %11 (0xffffffff)
        1     %13 = ieq %1, %12
        32    %14 = load_const (0x00000000)
        1     %15 = ieq %1, %14 (0x0)
        32    %16 = iand %1, %10 (0x1)
        1     %17 = ieq %16, %14 (0x0)
        32    %18 = umin %16, %1
        1     %19 = ieq %18, %14 (0x0)
        1     %20 = ior %19, %4
        32    %21 = load_const (0x00000004)
        32    %22 = iadd %2, %21 (0x4)
        32    %23 = load_const (0x00000006)
        32    %24 = umod %22, %23 (0x6)
        32    %25 = bcsel %20, %2, %24
        32    %26 = load_const (0x00000003)
        32    %27 = load_const (0xfffffffe = -2 = 4294967294)
        32    %28 = bcsel %17, %27 (0xfffffffe), %26 (0x3)
        32    %29 = bcsel %15, %10 (0x1), %28
        32    %30 = load_const (0x00000002)
        32    %31 = bcsel %19, %30 (0x2), %21 (0x4)
        32    %32 = load_const (0x00000005)
        32    %33 = bcsel %13, %32 (0x5), %23 (0x6)
        32    %34 = bcsel %19, %21 (0x4), %30 (0x2)
        32    %35 = bcsel %19, %26 (0x3), %27 (0xfffffffe)
        1     %36 = ieq %10 (0x1), %25
                    // succs: b3 b4
        if %36 {
            block b3:  // preds: b2, succs: b5
        } else {
            block b4:  // preds: b2, succs: b5
        }
        block b5:   // preds: b3 b4
        32    %37 = phi b3: %29, b4: %14 (0x0)
        1     %38 = ieq %30 (0x2), %25
                    // succs: b6 b7
        if %38 {
            block b6:  // preds: b5, succs: b8
        } else {
            block b7:  // preds: b5, succs: b8
        }
        block b8:   // preds: b6 b7
        32    %39 = phi b6: %31, b7: %37
        1     %40 = ieq %26 (0x3), %25
                    // succs: b9 b10
        if %40 {
            block b9:  // preds: b8, succs: b11
        } else {
            block b10:  // preds: b8, succs: b11
        }
        block b11:  // preds: b9 b10
        32    %41 = phi b9: %33, b10: %39
        1     %42 = ieq %21 (0x4), %25
                    // succs: b12 b13
        if %42 {
            block b12:  // preds: b11, succs: b14
        } else {
            block b13:  // preds: b11, succs: b14
        }
        block b14:  // preds: b12 b13
        32    %43 = phi b12: %34, b13: %41
        1     %44 = ieq %32 (0x5), %25
                    // succs: b15 b16
        if %44 {
            block b15:  // preds: b14, succs: b17
        } else {
            block b16:  // preds: b14, succs: b17
        }
        block b17:  // preds: b15 b16
        32    %45 = phi b15: %35, b16: %43
        32    %46 = ishl %1, %10 (0x1)
        32    %47 = iadd %46, %45
                    // succs: b18
    }
    block b18:  // preds: b1 b17
    32    %48 = phi b1: %9, b17: %47
                @bindgen_return (%48)
                // succs: b19
    block b19:
   */
   static const uint32_t impl_0_nir[230] = {
    0x00000045, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000005, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000003, 0x00000000, 0x00000007, 0xc40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x240417e4,
    0x0001b605, 0x242ac000, 0x00000000, 0x00070002,
    0x00000001, 0x00000020, 0x00000000, 0x00000001,
    0x00000000, 0x00000003, 0x0000d605, 0xc42a9000,
    0x00000000, 0x0003000a, 0xc4299000, 0x00000000,
    0x0004000b, 0x0000000b, 0x00000000, 0x0000001b,
    0x00003605, 0xfffff605, 0xc4299000, 0x00000000,
    0x000f0005, 0x2429d000, 0x00000000, 0x00100003,
    0x00000e05, 0x2429d000, 0x00000000, 0x00120003,
    0xc429a800, 0x00000000, 0x000e0003, 0x2429d000,
    0x00000000, 0x00120014, 0xc42e0800, 0x00000000,
    0x00030014, 0x2429d000, 0x00000000, 0x00120016,
    0x242b0800, 0x00000000, 0x00060017, 0x00009605,
    0xc4299000, 0x00000000, 0x00190004, 0x0000d605,
    0xc42e1800, 0x00000000, 0x001b001a, 0xc4239800,
    0x00000000, 0x00040018, 0x0000001c, 0x00007605,
    0xffffd605, 0xc4639800, 0x00000000, 0x001f0015,
    0x0000001e, 0x00000000, 0x000e0013, 0x00000020,
    0x00005605, 0xc4239800, 0x00000000, 0x00220017,
    0x00000019, 0x0000b605, 0xc4a39800, 0x00000000,
    0x00240011, 0x0000001b, 0x00000000, 0x00190017,
    0x00000022, 0x00000000, 0x001e0017, 0x0000001f,
    0x2429d000, 0x00000000, 0x001d000e, 0x00000001,
    0x000000a0, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0xc4000028, 0x00000021,
    0x00000029, 0x00000012, 0x0000002a, 0x2429d000,
    0x00000000, 0x001d0022, 0x00000001, 0x000000b4,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000002, 0xc4000028, 0x00000023, 0x0000002e,
    0x0000002c, 0x0000002f, 0x2429d000, 0x00000000,
    0x001d001e, 0x00000001, 0x000000c8, 0x00000000,
    0x00000001, 0x00000000, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000002,
    0xc4000028, 0x00000025, 0x00000033, 0x00000031,
    0x00000034, 0x2429d000, 0x00000000, 0x001d0019,
    0x00000001, 0x000000dc, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000002, 0xc4000028,
    0x00000026, 0x00000038, 0x00000036, 0x00000039,
    0x2429d000, 0x00000000, 0x001d0024, 0x00000001,
    0x000000f0, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0xc4000028, 0x00000027,
    0x0000003d, 0x0000003b, 0x0000003e, 0xc42b2000,
    0x00000000, 0x000e0003, 0xc4299000, 0x00000000,
    0x00400041, 0x00000000, 0x00000002, 0xc4000028,
    0x0000000c, 0x00000009, 0x00000042, 0x0000003f,
    0x00000304, 0x00000110,
};
   nir_def *args[5] = { mode, prim, vert, nr, flatshade_first };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_map_to_line_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_map_to_line_adj(nir_builder *b, nir_def *id)
{
   /*
    block b0:  // preds:
    32    %0 = @load_param (param_idx=0)
    32    %1 = load_const (0xfffffffe = -2 = 4294967294)
    32    %2 = iand %0, %1 (0xfffffffe)
    32    %3 = load_const (0x00000001)
    32    %4 = ishl %2, %3 (0x1)
    32    %5 = iand %0, %3 (0x1)
    32    %6 = iadd %4, %3 (0x1)
    32    %7 = iadd %6, %5
               @bindgen_return (%7)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[34] = {
    0x0000000a, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000009, 0xc40017e4,
    0xffffd605, 0xc429a800, 0x00000000, 0x00030002,
    0x00003605, 0xc42b2000, 0x00000000, 0x00050004,
    0xc429a800, 0x00000000, 0x00050002, 0xc4699000,
    0x00000000, 0x00050006, 0x00000000, 0x00070008,
    0x00000304, 0x00000024,
};
   nir_def *args[1] = { id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_map_to_line_strip_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_map_to_line_strip_adj(nir_builder *b, nir_def *id)
{
   /*
    block b0:  // preds:
    32    %0 = @load_param (param_idx=0)
    32    %1 = load_const (0x00000001)
    32    %2 = ushr %0, %1 (0x1)
    32    %3 = iand %0, %1 (0x1)
    32    %4 = iadd %2, %1 (0x1)
    32    %5 = iadd %4, %3
               @bindgen_return (%5)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[30] = {
    0x00000008, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000007, 0xc40017e4,
    0x00003605, 0xc42ef800, 0x00000000, 0x00030002,
    0xc429a800, 0x00000000, 0x00030002, 0xc4699000,
    0x00000000, 0x00030004, 0x00000000, 0x00050006,
    0x00000304, 0x0000001c,
};
   nir_def *args[1] = { id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_map_to_tri_strip_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_map_to_tri_strip_adj(nir_builder *b, nir_def *id)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = load_const (0x00000003)
    32     %2 = udiv %0, %1 (0x3)
    32     %3 = umod %0, %1 (0x3)
    32     %4 = load_const (0x00000002)
    32     %5 = load_const (0x00000001)
    32     %6 = iand %2, %5 (0x1)
    32     %7 = load_const (0x00000000)
    1      %8 = ine %6, %7 (0x0)
    1      %9 = ieq %3, %5 (0x1)
    1     %10 = ieq %3, %4 (0x2)
    32    %11 = bcsel %10, %5 (0x1), %3
    32    %12 = bcsel %9, %4 (0x2), %11
    32    %13 = bcsel %8, %12, %3
    32    %14 = iadd %2, %13
    32    %15 = ishl %14, %5 (0x1)
                @bindgen_return (%15)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[55] = {
    0x00000012, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000011, 0xc40017e4,
    0x00007605, 0xc42d5800, 0x00000000, 0x00030002,
    0xc42e1800, 0x00000000, 0x00030002, 0x00005605,
    0x00003605, 0xc429a800, 0x00000000, 0x00070004,
    0x00000e05, 0x242ac000, 0x00000000, 0x00090008,
    0x2469d000, 0x00000000, 0x00070005, 0x00000000,
    0x00060005, 0xc4a39800, 0x00000000, 0x0007000c,
    0x00000005, 0x00000000, 0x0006000b, 0x0000000d,
    0x00000000, 0x000e000a, 0x00000005, 0xc4299000,
    0x00000000, 0x000f0004, 0xc42b2000, 0x00000000,
    0x00070010, 0x00000304, 0x00000044,
};
   nir_def *args[1] = { id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_load_index_buffer(nir_builder *b, nir_def *p, nir_def *id, nir_def *index_size);

nir_def *
libagx_load_index_buffer(nir_builder *b, nir_def *p, nir_def *id, nir_def *index_size)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    64     %3 = @load_global_constant (%0) (access=none, align_mul=4, align_offset=0)
    64     %4 = load_const (0x0000000000000008)
    64     %5 = iadd %0, %4 (0x8)
    32     %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    1      %7 = uge %1, %6
    32     %8 = load_const (0x00000000)
    32     %9 = bcsel %7, %8 (0x0), %1
    32    %10 = load_const (0x00000001)
    1     %11 = ine %2, %10 (0x1)
                // succs: b1 b5
    if %11 {
        block b1:   // preds: b0
        32    %12 = load_const (0x00000002)
        1     %13 = ine %2, %12 (0x2)
                    // succs: b2 b3
        if %13 {
            block b2:   // preds: b1
            64    %14 = u2u64 %9
            64    %15 = ishl %14, %12 (0x2)
            64    %16 = iadd %3, %15
            32    %17 = @load_global_constant (%16) (access=none, align_mul=4, align_offset=0)
                        // succs: b4
        } else {
            block b3:   // preds: b1
            64    %18 = u2u64 %9
            64    %19 = ishl %18, %10 (0x1)
            64    %20 = iadd %3, %19
            16    %21 = @load_global_constant (%20) (access=none, align_mul=2, align_offset=0)
            32    %22 = u2u32 %21
                        // succs: b4
        }
        block b4:   // preds: b2 b3
        32    %23 = phi b2: %17, b3: %22
                    // succs: b6
    } else {
        block b5:   // preds: b0
        64    %24 = u2u64 %9
        64    %25 = iadd %3, %24
        8     %26 = @load_global_constant (%25) (access=none, align_mul=1, align_offset=0)
        32    %27 = u2u32 %26
                    // succs: b6
    }
    block b6:   // preds: b4 b5
    32    %28 = phi b4: %23, b5: %27
    32    %29 = bcsel %7, %8 (0x0), %28
                @bindgen_return (%29)
                // succs: b7
    block b7:
   */
   static const uint32_t impl_0_nir[127] = {
    0x00000026, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000003, 0x00000000, 0x0000000c, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xe4005434, 0x00000008,
    0x00000400, 0x00011705, 0xe4299000, 0x00000000,
    0x00060002, 0xc4005434, 0x0000001c, 0x00000400,
    0x242d9800, 0x00000000, 0x00080003, 0x00000e05,
    0xc4239800, 0x00000000, 0x000a0009, 0x00000003,
    0x00003605, 0x242ac000, 0x00000000, 0x000c0004,
    0x00000001, 0x00000034, 0x00000000, 0x00000003,
    0x00000000, 0x00000002, 0x00005605, 0x242ac000,
    0x00000000, 0x000f0004, 0x00000001, 0x00000040,
    0x00000000, 0x00000001, 0x00000000, 0x00000004,
    0xe42d1000, 0x00000000, 0x0000000b, 0xe42b2000,
    0x00000000, 0x000f0012, 0xe4299000, 0x00000000,
    0x00130005, 0xc4005434, 0x00000050, 0x00000400,
    0x00000001, 0x00000000, 0x00000005, 0xe42d1000,
    0x00000000, 0x0000000b, 0xe42b2000, 0x00000000,
    0x000c0017, 0xe4299000, 0x00000000, 0x00180005,
    0xa4081434, 0x00000064, 0xc42d0800, 0x00000000,
    0x0000001a, 0x00000000, 0x00000001, 0xc4000028,
    0x00000015, 0x00000011, 0x0000001b, 0x00000016,
    0x00000001, 0x00000000, 0x00000004, 0xe42d1000,
    0x00000000, 0x0000000b, 0xe4299000, 0x00000000,
    0x001f0005, 0x84041434, 0x00000080, 0xc42d0800,
    0x00000000, 0x00000021, 0x00000000, 0x00000003,
    0xc4000028, 0x0000001d, 0x0000001c, 0x00000022,
    0x0000001e, 0xc4239800, 0x00000000, 0x000a0009,
    0x00000024, 0x00000304, 0x00000094,
};
   nir_def *args[3] = { p, id, index_size };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_setup_xfb_buffer(nir_builder *b, nir_def *p, nir_def *i, nir_def *stride, nir_def *max_output_end, nir_def *vertices_per_prim);

nir_def *
libagx_setup_xfb_buffer(nir_builder *b, nir_def *p, nir_def *i, nir_def *stride, nir_def *max_output_end, nir_def *vertices_per_prim)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = @load_param (param_idx=4)
    64     %5 = load_const (0x0000000000000078 = 120)
    64     %6 = iadd %0, %5 (0x78)
    32     %7 = load_const (0x00000003)
    32     %8 = ishl %1, %7 (0x3)
    64     %9 = u2u64 %8
    64    %10 = iadd %6, %9
    64    %11 = @load_global (%10) (access=none, align_mul=4, align_offset=0)
    32    %12 = @load_global (%11) (access=none, align_mul=4, align_offset=0)
    64    %13 = load_const (0x00000000000000a0 = 160)
    64    %14 = iadd %0, %13 (0xa0)
    64    %15 = iadd %14, %9
    64    %16 = @load_global (%15) (access=none, align_mul=4, align_offset=0)
    64    %17 = u2u64 %12
    64    %18 = iadd %16, %17
    64    %19 = load_const (0x00000000000000c0 = 192)
    64    %20 = iadd %0, %19 (0xc0)
    64    %21 = iadd %20, %9
                @store_global (%18, %21) (wrmask=x, access=none, align_mul=4, align_offset=0)
    64    %22 = load_const (0x00000000000000f8 = 248)
    64    %23 = iadd %0, %22 (0xf8)
    32    %24 = load_const (0x00000002)
    32    %25 = ishl %1, %24 (0x2)
    64    %26 = u2u64 %25
    64    %27 = iadd %23, %26
    32    %28 = @load_global (%27) (access=none, align_mul=4, align_offset=0)
    32    %29 = ineg %3
    32    %30 = iadd %2, %29
    32    %31 = iadd %28, %30
    32    %32 = ineg %12
    32    %33 = iadd %31, %32
    32    %34 = load_const (0x00000000)
    32    %35 = imax %33, %34 (0x0)
    32    %36 = imul %2, %4
    32    %37 = udiv %35, %36
                @bindgen_return (%37)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[124] = {
    0x00000028, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000005, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000028, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xc40417e4,
    0x000f1705, 0xe4299000, 0x00000000, 0x00070002,
    0x00007605, 0xc42b2000, 0x00000000, 0x00090003,
    0xe42d1000, 0x00000000, 0x0000000a, 0xe4299000,
    0x00000000, 0x000b0008, 0xe40053d4, 0x00000030,
    0x00000400, 0xc40053d4, 0x00000034, 0x00000400,
    0x00141705, 0xe4699000, 0x00000000, 0x000f0002,
    0x00000000, 0x000b0010, 0xe40053d4, 0x00000044,
    0x00000400, 0xe42d1000, 0x00000000, 0x0000000e,
    0xe4299000, 0x00000000, 0x00130012, 0x00181705,
    0xe4699000, 0x00000000, 0x00150002, 0x00000000,
    0x000b0016, 0x000069d4, 0x00000050, 0x0000005c,
    0x00040001, 0x001f1705, 0xe4299000, 0x00000000,
    0x00180002, 0x00005605, 0xc42b2000, 0x00000000,
    0x001a0003, 0xe42d1000, 0x00000000, 0x0000001b,
    0xe4299000, 0x00000000, 0x001c0019, 0xc40053d4,
    0x00000074, 0x00000400, 0xc42ae000, 0x00000000,
    0x00000005, 0xc4699000, 0x00000000, 0x001f0004,
    0x00000000, 0x0020001e, 0xc42ae000, 0x00000000,
    0x0000000e, 0xc4299000, 0x00000000, 0x00220021,
    0x00000e05, 0xc42a7000, 0x00000000, 0x00240023,
    0xc42a9000, 0x00000000, 0x00060004, 0xc42d5800,
    0x00000000, 0x00260025, 0x00000304, 0x0000009c,
};
   nir_def *args[5] = { p, i, stride, max_output_end, vertices_per_prim };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

void
libagx_write_strip(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *prim_index_offset, nir_def *vertex_offset, nir_def *verts_in_prim, nir_def *info);

void
libagx_write_strip(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *prim_index_offset, nir_def *vertex_offset, nir_def *verts_in_prim, nir_def *info)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = @load_param (param_idx=4)
    32x3   %5 = @load_param (param_idx=5)
    32     %6 = iadd %1, %2
    32     %7 = load_const (0x00000001)
    1      %8 = ult %7 (0x1), %5.z
    1      %9 = uge %4, %5.z
                // succs: b1 b10
    if %9 {
        block b1:   // preds: b0
        64    %10 = u2u64 %6
        32    %11 = load_const (0x00000000)
                    // succs: b2
        loop {
            block b2:   // preds: b1 b5
            32    %12 = phi b1: %11 (0x0), b5: %22
            1     %13 = uge %12, %4
                        // succs: b3 b4
            if %13 {
                block b3:// preds: b2
                break
                // succs: b6
            } else {
                block b4:  // preds: b2, succs: b5
            }
            block b5:   // preds: b4
            32    %14 = iadd %3, %12
            32    %15 = imul %14, %5.y
            32    %16 = iadd %15, %5.x
            64    %17 = u2u64 %12
            64    %18 = iadd %10, %17
            32    %19 = load_const (0x00000002)
            64    %20 = ishl %18, %19 (0x2)
            64    %21 = iadd %0, %20
                        @store_global (%16, %21) (wrmask=x, access=none, align_mul=4, align_offset=0)
            32    %22 = iadd %12, %7 (0x1)
                        // succs: b2
        }
        block b6:  // preds: b3, succs: b7 b8
        if %8 {
            block b7:   // preds: b6
            64    %23 = u2u64 %4
            64    %24 = iadd %10, %23
            32    %25 = load_const (0x00000002)
            64    %26 = ishl %24, %25 (0x2)
            64    %27 = iadd %0, %26
            32    %28 = load_const (0xffffffff = -nan = -1 = 4294967295)
                        @store_global (%28 (0xffffffff), %27) (wrmask=x, access=none, align_mul=4, align_offset=0)
                        // succs: b9
        } else {
            block b8:  // preds: b6, succs: b9
        }
        block b9:  // preds: b7 b8, succs: b11
    } else {
        block b10:  // preds: b0, succs: b11
    }
    block b11:  // preds: b9 b10, succs: b12
    block b12:
   */
   static const uint32_t impl_0_nir[151] = {
    0x0000002a, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000006, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002003, 0x000002c0,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000003, 0x00000000, 0x0000000a, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xc40417e4,
    0xcc0517e4, 0xc4299000, 0x00000000, 0x00040003,
    0x00003605, 0x242dcc00, 0x00000000, 0x00070009,
    0x242d9c00, 0x00000000, 0x00070006, 0x00000001,
    0x0000002c, 0x00000000, 0x00000005, 0x00000000,
    0x00000002, 0xe42d1000, 0x00000000, 0x00000008,
    0x00000e05, 0x00000002, 0x00000000, 0x00000003,
    0x00000000, 0x00000002, 0xc4000028, 0x0000000e,
    0x0000000c, 0x0000001d, 0x00000014, 0x242d9800,
    0x00000000, 0x00060010, 0x00000001, 0x00000044,
    0x00000000, 0x00000001, 0x00000000, 0x00000001,
    0x00000026, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x0000000a, 0xc4299000, 0x00000000,
    0x00100005, 0xc42a9200, 0x00000000, 0x00070015,
    0xc4299000, 0x00000000, 0x00070016, 0xe42d1000,
    0x00000000, 0x00000010, 0xe4299000, 0x00000000,
    0x0018000d, 0x00005605, 0xe42b2000, 0x00000000,
    0x001a0019, 0xe4299000, 0x00000000, 0x001b0002,
    0x000069d4, 0x0000005c, 0x00000070, 0x00040001,
    0xc4299000, 0x00000000, 0x00090010, 0x00000000,
    0x00000000, 0x00000001, 0x00000028, 0x00000000,
    0x00000001, 0x00000000, 0x00000007, 0xe42d1000,
    0x00000000, 0x00000006, 0xe4299000, 0x00000000,
    0x0020000d, 0x00005605, 0xe42b2000, 0x00000000,
    0x00220021, 0xe4299000, 0x00000000, 0x00230002,
    0xfffff605, 0x000069d4, 0x00000094, 0x00000090,
    0x00040001, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000000,
};
   nir_def *args[6] = { index_buffer, inv_index_offset, prim_index_offset, vertex_offset, verts_in_prim, info };
   nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

void
libagx_pad_index_gs(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *nr_indices, nir_def *alloc);

void
libagx_pad_index_gs(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *nr_indices, nir_def *alloc)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
                // succs: b1
    loop {
        block b1:   // preds: b0 b4
        32     %4 = phi b0: %2, b4: %13
        1      %5 = uge %4, %3
                    // succs: b2 b3
        if %5 {
            block b2:// preds: b1
            break
            // succs: b5
        } else {
            block b3:  // preds: b1, succs: b4
        }
        block b4:   // preds: b3
        32     %6 = iadd %1, %4
        64     %7 = u2u64 %6
        32     %8 = load_const (0x00000002)
        64     %9 = ishl %7, %8 (0x2)
        64    %10 = iadd %0, %9
        32    %11 = load_const (0xffffffff = -nan = -1 = 4294967295)
                    @store_global (%11 (0xffffffff), %10) (wrmask=x, access=none, align_mul=4, align_offset=0)
        32    %12 = load_const (0x00000001)
        32    %13 = iadd %4, %12 (0x1)
                    // succs: b1
    }
    block b5:  // preds: b2, succs: b6
    block b6:
   */
   static const uint32_t impl_0_nir[80] = {
    0x00000015, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000003, 0x00000000, 0x00000004, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x00000002,
    0x00000000, 0x00000003, 0x00000000, 0x00000002,
    0xc4000028, 0x00000004, 0x00000001, 0x00000013,
    0x0000000b, 0x242d9800, 0x00000000, 0x00050007,
    0x00000001, 0x00000020, 0x00000000, 0x00000001,
    0x00000000, 0x00000001, 0x00000026, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000009,
    0xc4299000, 0x00000000, 0x00070003, 0xe42d1000,
    0x00000000, 0x0000000c, 0x00005605, 0xe42b2000,
    0x00000000, 0x000e000d, 0xe4299000, 0x00000000,
    0x000f0002, 0xfffff605, 0x000069d4, 0x00000044,
    0x00000040, 0x00040001, 0x00003605, 0xc4299000,
    0x00000000, 0x00120007, 0x00000000, 0x00000000,
};
   nir_def *args[4] = { index_buffer, inv_index_offset, nr_indices, alloc };
   nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_vertex_output_address(nir_builder *b, nir_def *buffer, nir_def *mask, nir_def *vtx, nir_def *location);

nir_def *
libagx_vertex_output_address(nir_builder *b, nir_def *buffer, nir_def *mask, nir_def *vtx, nir_def *location)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    64     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = bit_count %1
    32     %5 = imul %2, %4
    64     %6 = load_const (0x0000000000000001)
    64     %7 = ishl %6 (0x1), %3
    64     %8 = load_const (0xffffffffffffffff = -1 = 18446744073709551615)
    64     %9 = iadd %7, %8 (0xffffffffffffffff)
    64    %10 = iand %1, %9
    32    %11 = bit_count %10
    32    %12 = iadd %5, %11
    64    %13 = u2u64 %12
    32    %14 = load_const (0x00000004)
    64    %15 = ishl %13, %14 (0x4)
    64    %16 = iadd %0, %15
                @bindgen_return (%16)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[66] = {
    0x00000013, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000012, 0xe40017e4,
    0xe40117e4, 0xc40217e4, 0xc40317e4, 0xc4240000,
    0x00000000, 0x00000003, 0xc42a9000, 0x00000000,
    0x00060004, 0x00003705, 0xe42b2000, 0x00000000,
    0x00050008, 0xfffff705, 0xe4299000, 0x00000000,
    0x000a0009, 0xe429a800, 0x00000000, 0x000b0003,
    0xc4240000, 0x00000000, 0x0000000c, 0xc4299000,
    0x00000000, 0x000d0007, 0xe42d1000, 0x00000000,
    0x0000000e, 0x00009605, 0xe42b2000, 0x00000000,
    0x0010000f, 0xe4299000, 0x00000000, 0x00110002,
    0x00000304, 0x00000048,
};
   nir_def *args[4] = { buffer, mask, vtx, location };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_geometry_input_address(nir_builder *b, nir_def *p, nir_def *vtx, nir_def *location);

nir_def *
libagx_geometry_input_address(nir_builder *b, nir_def *p, nir_def *vtx, nir_def *location)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    64     %3 = load_const (0x00000000000000e0 = 224)
    64     %4 = iadd %0, %3 (0xe0)
    64     %5 = @load_global_constant (%4) (access=none, align_mul=4, align_offset=0)
    64     %6 = load_const (0x00000000000000e8 = 232)
    64     %7 = iadd %0, %6 (0xe8)
    64     %8 = @load_global_constant (%7) (access=none, align_mul=4, align_offset=0)
    32     %9 = bit_count %8
    32    %10 = imul %1, %9
    64    %11 = load_const (0x0000000000000001)
    64    %12 = ishl %11 (0x1), %2
    64    %13 = load_const (0xffffffffffffffff = -1 = 18446744073709551615)
    64    %14 = iadd %12, %13 (0xffffffffffffffff)
    64    %15 = iand %8, %14
    32    %16 = bit_count %15
    32    %17 = iadd %10, %16
    64    %18 = u2u64 %17
    32    %19 = load_const (0x00000004)
    64    %20 = ishl %18, %19 (0x4)
    64    %21 = iadd %5, %20
                @bindgen_return (%21)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[75] = {
    0x00000018, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000017, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0x001c1705, 0xe4299000,
    0x00000000, 0x00050002, 0xe4005434, 0x00000018,
    0x00000400, 0x001d1705, 0xe4299000, 0x00000000,
    0x00080002, 0xe4005434, 0x00000024, 0x00000400,
    0xc4240000, 0x00000000, 0x0000000a, 0xc42a9000,
    0x00000000, 0x000b0003, 0x00003705, 0xe42b2000,
    0x00000000, 0x0004000d, 0xfffff705, 0xe4299000,
    0x00000000, 0x000f000e, 0xe429a800, 0x00000000,
    0x0010000a, 0xc4240000, 0x00000000, 0x00000011,
    0xc4299000, 0x00000000, 0x0012000c, 0xe42d1000,
    0x00000000, 0x00000013, 0x00009605, 0xe42b2000,
    0x00000000, 0x00150014, 0xe4299000, 0x00000000,
    0x00160007, 0x00000304, 0x0000005c,
};
   nir_def *args[3] = { p, vtx, location };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_input_vertices(nir_builder *b, nir_def *ia);

nir_def *
libagx_input_vertices(nir_builder *b, nir_def *ia)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    64    %1 = load_const (0x000000000000000c = 12)
    64    %2 = iadd %0, %1 (0xc)
    32    %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
               @bindgen_return (%3)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[25] = {
    0x00000006, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000005, 0xe40017e4,
    0x00019705, 0xe4299000, 0x00000000, 0x00030002,
    0xc4005434, 0x00000010, 0x00000400, 0x00000304,
    0x00000014,
};
   nir_def *args[1] = { ia };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_load_xfb_count_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *count_words, nir_def *unrolled_id);

nir_def *
libagx_load_xfb_count_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *count_words, nir_def *unrolled_id)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    64     %4 = load_const (0x0000000000000008)
    64     %5 = iadd %0, %4 (0x8)
    64     %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    32     %7 = imul %3, %2
    32     %8 = iadd %7, %1
    64     %9 = u2u64 %8
    32    %10 = load_const (0x00000002)
    64    %11 = ishl %9, %10 (0x2)
    64    %12 = iadd %6, %11
                @bindgen_return (%12)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[56] = {
    0x0000000f, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000e, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x00011705,
    0xe4299000, 0x00000000, 0x00060002, 0xe4005434,
    0x0000001c, 0x00000400, 0xc42a9000, 0x00000000,
    0x00040005, 0xc4299000, 0x00000000, 0x00030009,
    0xe42d1000, 0x00000000, 0x0000000a, 0x00005605,
    0xe42b2000, 0x00000000, 0x000c000b, 0xe4299000,
    0x00000000, 0x000d0008, 0x00000304, 0x00000038,
};
   nir_def *args[4] = { p, index, count_words, unrolled_id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_previous_xfb_primitives(nir_builder *b, nir_def *p, nir_def *static_count, nir_def *count_index, nir_def *count_words, nir_def *prefix_sum, nir_def *unrolled_id);

nir_def *
libagx_previous_xfb_primitives(nir_builder *b, nir_def *p, nir_def *static_count, nir_def *count_index, nir_def *count_words, nir_def *prefix_sum, nir_def *unrolled_id)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    1      %4 = @load_param (param_idx=4)
    32     %5 = @load_param (param_idx=5)
    32     %6 = load_const (0x00000000)
    1      %7 = ilt %1, %6 (0x0)
                // succs: b1 b2
    if %7 {
        block b1:   // preds: b0
        32     %8 = load_const (0x00000001)
        32     %9 = usub_sat %5, %8 (0x1)
        32    %10 = bcsel %4, %9, %6 (0x0)
        64    %11 = load_const (0x0000000000000008)
        64    %12 = iadd %0, %11 (0x8)
        64    %13 = @load_global (%12) (access=none, align_mul=4, align_offset=0)
        32    %14 = imul %10, %3
        32    %15 = iadd %14, %2
        64    %16 = u2u64 %15
        32    %17 = load_const (0x00000002)
        64    %18 = ishl %16, %17 (0x2)
        64    %19 = iadd %13, %18
        32    %20 = @load_global (%19) (access=none, align_mul=4, align_offset=0)
        1     %21 = ieq %5, %6 (0x0)
        32    %22 = bcsel %21, %6 (0x0), %20
                    // succs: b3
    } else {
        block b2:   // preds: b0
        32    %23 = imul %5, %1
                    // succs: b3
    }
    block b3:   // preds: b1 b2
    32    %24 = phi b1: %22, b2: %23
                @bindgen_return (%24)
                // succs: b4
    block b4:
   */
   static const uint32_t impl_0_nir[107] = {
    0x0000001e, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000006, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000003, 0x00000000, 0x00000008, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x240417e4,
    0xc40517e4, 0x00000e05, 0x242a3000, 0x00000000,
    0x00080003, 0x00000001, 0x00000024, 0x00000000,
    0x00000001, 0x00000000, 0x0000000f, 0x00003605,
    0xc42f1000, 0x00000000, 0x000b0007, 0xc4239800,
    0x00000000, 0x000c0006, 0x00000008, 0x00011705,
    0xe4299000, 0x00000000, 0x000e0002, 0xe40053d4,
    0x0000003c, 0x00000400, 0xc42a9000, 0x00000000,
    0x0005000d, 0xc4299000, 0x00000000, 0x00040011,
    0xe42d1000, 0x00000000, 0x00000012, 0x00005605,
    0xe42b2000, 0x00000000, 0x00140013, 0xe4299000,
    0x00000000, 0x00150010, 0xc40053d4, 0x00000058,
    0x00000400, 0x2429d000, 0x00000000, 0x00080007,
    0xc4239800, 0x00000000, 0x00080018, 0x00000017,
    0x00000001, 0x00000000, 0x00000001, 0xc42a9000,
    0x00000000, 0x00030007, 0x00000000, 0x00000002,
    0xc4000028, 0x00000019, 0x0000000a, 0x0000001b,
    0x0000001a, 0x00000304, 0x00000074,
};
   nir_def *args[6] = { p, static_count, count_index, count_words, prefix_sum, unrolled_id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

void
libagx_pre_gs(nir_builder *b, nir_def *p, nir_def *streams, nir_def *buffers_written, nir_def *buffer_to_stream, nir_def *count_index, nir_def *stride, nir_def *output_end, nir_def *static_count, nir_def *invocations, nir_def *vertices_per_prim, nir_def *gs_invocations, nir_def *gs_primitives, nir_def *c_primitives, nir_def *c_invocations);

void
libagx_pre_gs(nir_builder *b, nir_def *p, nir_def *streams, nir_def *buffers_written, nir_def *buffer_to_stream, nir_def *count_index, nir_def *stride, nir_def *output_end, nir_def *static_count, nir_def *invocations, nir_def *vertices_per_prim, nir_def *gs_invocations, nir_def *gs_primitives, nir_def *c_primitives, nir_def *c_invocations)
{
   /*
    block b0:    // preds:
    64      %0 = @load_param (param_idx=0)
    32      %1 = @load_param (param_idx=1)
    32      %2 = @load_param (param_idx=2)
    32x4    %3 = @load_param (param_idx=3)
    32x4    %4 = @load_param (param_idx=4)
    32x4    %5 = @load_param (param_idx=5)
    32x4    %6 = @load_param (param_idx=6)
    32x4    %7 = @load_param (param_idx=7)
    32      %8 = @load_param (param_idx=8)
    32      %9 = @load_param (param_idx=9)
    64     %10 = @load_param (param_idx=10)
    64     %11 = @load_param (param_idx=11)
    64     %12 = @load_param (param_idx=12)
    64     %13 = @load_param (param_idx=13)
    32     %14 = load_const (0x00000000)
    1      %15 = ige %4.x, %14 (0x0)
    32     %16 = load_const (0x00000001)
    32     %17 = b2i32 %15
    1      %18 = ige %4.y, %14 (0x0)
    32     %19 = b2i32 %18
    32     %20 = iadd.nsw %17, %19
    1      %21 = ige %4.z, %14 (0x0)
    32     %22 = b2i32 %21
    32     %23 = iadd.nsw %20, %22
    1      %24 = ige %4.w, %14 (0x0)
    32     %25 = b2i32 %24
    32     %26 = iadd.nsw %23, %25
    64     %27 = load_const (0x0000000100004000 = 4294983680)
    1      %28 = load_const (false)
    1      %29 = ine %2, %14 (0x0)
    32     %30 = umin %26, %2
    1      %31 = ine %30, %14 (0x0)
    64     %32 = load_const (0x0000000000000148 = 328)
    64     %33 = iadd %0, %32 (0x148)
    32     %34 = @load_global (%33) (access=none, align_mul=4, align_offset=0)
    32     %35 = iand %1, %16 (0x1)
    1      %36 = ine %35, %14 (0x0)
                 // succs: b1 b5
    if %36 {
        block b1:    // preds: b0
        1      %37 = ilt %7.x, %14 (0x0)
                     // succs: b2 b3
        if %37 {
            block b2:    // preds: b1
            32     %38 = usub_sat %34, %16 (0x1)
            32     %39 = bcsel %31, %38, %14 (0x0)
            64     %40 = load_const (0x0000000000000008)
            64     %41 = iadd %0, %40 (0x8)
            64     %42 = @load_global (%41) (access=none, align_mul=4, align_offset=0)
            32     %43 = imul %39, %26
            32     %44 = iadd %43, %4.x
            64     %45 = u2u64 %44
            32     %46 = load_const (0x00000002)
            64     %47 = ishl %45, %46 (0x2)
            64     %48 = iadd %42, %47
            32     %49 = @load_global (%48) (access=none, align_mul=4, align_offset=0)
            1      %50 = ieq %34, %14 (0x0)
            32     %51 = bcsel %50, %14 (0x0), %49
                         // succs: b4
        } else {
            block b3:    // preds: b1
            32     %52 = imul %34, %7.x
                         // succs: b4
        }
        block b4:    // preds: b2 b3
        32     %53 = phi b2: %51, b3: %52
        1x2    %54 = load_const (true, false)
        32x4   %55 = bcsel %54 (true, false).xyyy, %53.xxxx, %14 (0x0).xxxx
        64     %56 = load_const (0x0000000000000010 = 16)
        64     %57 = iadd %0, %56 (0x10)
        64     %58 = @load_global (%57) (access=none, align_mul=4, align_offset=0)
        32     %59 = @load_global (%58) (access=none, align_mul=4, align_offset=0)
        32     %60 = iadd %59, %55.x
                     @store_global (%60, %58) (wrmask=x, access=none, align_mul=4, align_offset=0)
        32     %61 = mov %55.x
        32     %62 = mov %55.y
        32     %63 = mov %55.z
        32     %64 = mov %55.w
                     // succs: b6
    } else {
        block b5:  // preds: b0, succs: b6
    }
    block b6:    // preds: b4 b5
    32     %65 = phi b4: %61, b5: %14 (0x0)
    32     %66 = phi b4: %62, b5: %14 (0x0)
    32     %67 = phi b4: %63, b5: %14 (0x0)
    32     %68 = phi b4: %64, b5: %14 (0x0)
    32x4   %69 = vec4 %65, %66, %67, %68
    32     %70 = load_const (0x00000002)
    32     %71 = iand %1, %70 (0x2)
    1      %72 = ine %71, %14 (0x0)
                 // succs: b7 b11
    if %72 {
        block b7:    // preds: b6
        1      %73 = ilt %7.y, %14 (0x0)
                     // succs: b8 b9
        if %73 {
            block b8:    // preds: b7
            32     %74 = usub_sat %34, %16 (0x1)
            32     %75 = bcsel %31, %74, %14 (0x0)
            64     %76 = load_const (0x0000000000000008)
            64     %77 = iadd %0, %76 (0x8)
            64     %78 = @load_global (%77) (access=none, align_mul=4, align_offset=0)
            32     %79 = imul %75, %26
            32     %80 = iadd %79, %4.y
            64     %81 = u2u64 %80
            64     %82 = ishl %81, %70 (0x2)
            64     %83 = iadd %78, %82
            32     %84 = @load_global (%83) (access=none, align_mul=4, align_offset=0)
            1      %85 = ieq %34, %14 (0x0)
            32     %86 = bcsel %85, %14 (0x0), %84
                         // succs: b10
        } else {
            block b9:    // preds: b7
            32     %87 = imul %34, %7.y
                         // succs: b10
        }
        block b10:   // preds: b8 b9
        32     %88 = phi b8: %86, b9: %87
        1x2    %89 = load_const (false, true)
        32x4   %90 = bcsel %89 (false, true).xyxx, %88.xxxx, %69
        64     %91 = load_const (0x0000000000000018 = 24)
        64     %92 = iadd %91 (0x18), %0
        64     %93 = @load_global (%92) (access=none, align_mul=4, align_offset=0)
        32     %94 = @load_global (%93) (access=none, align_mul=4, align_offset=0)
        32     %95 = iadd %94, %90.y
                     @store_global (%95, %93) (wrmask=x, access=none, align_mul=4, align_offset=0)
        32     %96 = mov %90.x
        32     %97 = mov %90.y
        32     %98 = mov %90.z
        32     %99 = mov %90.w
                     // succs: b12
    } else {
        block b11:  // preds: b6, succs: b12
    }
    block b12:   // preds: b10 b11
    32    %100 = phi b10: %96, b11: %65
    32    %101 = phi b10: %97, b11: %66
    32    %102 = phi b10: %98, b11: %67
    32    %103 = phi b10: %99, b11: %68
    32x4  %104 = vec4 %100, %101, %102, %103
    32    %105 = load_const (0x00000004)
    32    %106 = iand %1, %105 (0x4)
    1     %107 = ine %106, %14 (0x0)
                 // succs: b13 b17
    if %107 {
        block b13:   // preds: b12
        1     %108 = ilt %7.z, %14 (0x0)
                     // succs: b14 b15
        if %108 {
            block b14:   // preds: b13
            32    %109 = usub_sat %34, %16 (0x1)
            32    %110 = bcsel %31, %109, %14 (0x0)
            64    %111 = load_const (0x0000000000000008)
            64    %112 = iadd %0, %111 (0x8)
            64    %113 = @load_global (%112) (access=none, align_mul=4, align_offset=0)
            32    %114 = imul %110, %26
            32    %115 = iadd %114, %4.z
            64    %116 = u2u64 %115
            64    %117 = ishl %116, %70 (0x2)
            64    %118 = iadd %113, %117
            32    %119 = @load_global (%118) (access=none, align_mul=4, align_offset=0)
            1     %120 = ieq %34, %14 (0x0)
            32    %121 = bcsel %120, %14 (0x0), %119
                         // succs: b16
        } else {
            block b15:   // preds: b13
            32    %122 = imul %34, %7.z
                         // succs: b16
        }
        block b16:   // preds: b14 b15
        32    %123 = phi b14: %121, b15: %122
        1x2   %124 = load_const (false, true)
        32x4  %125 = bcsel %124 (false, true).xxyx, %123.xxxx, %104
        64    %126 = load_const (0x0000000000000020 = 32)
        64    %127 = iadd %126 (0x20), %0
        64    %128 = @load_global (%127) (access=none, align_mul=4, align_offset=0)
        32    %129 = @load_global (%128) (access=none, align_mul=4, align_offset=0)
        32    %130 = iadd %129, %125.z
                     @store_global (%130, %128) (wrmask=x, access=none, align_mul=4, align_offset=0)
        32    %131 = mov %125.x
        32    %132 = mov %125.y
        32    %133 = mov %125.z
        32    %134 = mov %125.w
                     // succs: b18
    } else {
        block b17:  // preds: b12, succs: b18
    }
    block b18:   // preds: b16 b17
    32    %135 = phi b16: %131, b17: %100
    32    %136 = phi b16: %132, b17: %101
    32    %137 = phi b16: %133, b17: %102
    32    %138 = phi b16: %134, b17: %103
    32x4  %139 = vec4 %135, %136, %137, %138
    32    %140 = load_const (0x00000008)
    32    %141 = iand %1, %140 (0x8)
    1     %142 = ine %141, %14 (0x0)
                 // succs: b19 b23
    if %142 {
        block b19:   // preds: b18
        1     %143 = ilt %7.w, %14 (0x0)
                     // succs: b20 b21
        if %143 {
            block b20:   // preds: b19
            32    %144 = usub_sat %34, %16 (0x1)
            32    %145 = bcsel %31, %144, %14 (0x0)
            64    %146 = load_const (0x0000000000000008)
            64    %147 = iadd %0, %146 (0x8)
            64    %148 = @load_global (%147) (access=none, align_mul=4, align_offset=0)
            32    %149 = imul %145, %26
            32    %150 = iadd %149, %4.w
            64    %151 = u2u64 %150
            64    %152 = ishl %151, %70 (0x2)
            64    %153 = iadd %148, %152
            32    %154 = @load_global (%153) (access=none, align_mul=4, align_offset=0)
            1     %155 = ieq %34, %14 (0x0)
            32    %156 = bcsel %155, %14 (0x0), %154
                         // succs: b22
        } else {
            block b21:   // preds: b19
            32    %157 = imul %34, %7.w
                         // succs: b22
        }
        block b22:   // preds: b20 b21
        32    %158 = phi b20: %156, b21: %157
        1x2   %159 = load_const (false, true)
        32x4  %160 = bcsel %159 (false, true).xxxy, %158.xxxx, %139
        64    %161 = load_const (0x0000000000000028 = 40)
        64    %162 = iadd %161 (0x28), %0
        64    %163 = @load_global (%162) (access=none, align_mul=4, align_offset=0)
        32    %164 = @load_global (%163) (access=none, align_mul=4, align_offset=0)
        32    %165 = iadd %164, %160.w
                     @store_global (%165, %163) (wrmask=x, access=none, align_mul=4, align_offset=0)
        32    %166 = mov %160.x
        32    %167 = mov %160.y
        32    %168 = mov %160.z
        32    %169 = mov %160.w
                     // succs: b24
    } else {
        block b23:  // preds: b18, succs: b24
    }
    block b24:   // preds: b22 b23
    32    %170 = phi b22: %166, b23: %135
    32    %171 = phi b22: %167, b23: %136
    32    %172 = phi b22: %168, b23: %137
    32    %173 = phi b22: %169, b23: %138
    32x4  %174 = vec4 %170, %171, %172, %173
    32    %175 = iadd %170, %171
    32    %176 = iadd %175, %172
    32    %177 = iadd %176, %173
                 // succs: b25 b62
    if %29 {
        block b25:   // preds: b24
        32    %178 = iand %2, %16 (0x1)
        1     %179 = ine %178, %14 (0x0)
                     // succs: b26 b27
        if %179 {
            block b26:   // preds: b25
            32    %180 = load_const (0x00000003)
            64    %181 = load_const (0x0000000000000078 = 120)
            64    %182 = iadd %0, %181 (0x78)
            64    %183 = @load_global (%182) (access=none, align_mul=4, align_offset=0)
            32    %184 = @load_global (%183) (access=none, align_mul=4, align_offset=0)
            64    %185 = load_const (0x00000000000000a0 = 160)
            64    %186 = iadd %0, %185 (0xa0)
            64    %187 = @load_global (%186) (access=none, align_mul=4, align_offset=0)
            64    %188 = u2u64 %184
            64    %189 = iadd %187, %188
            64    %190 = load_const (0x00000000000000c0 = 192)
            64    %191 = iadd %0, %190 (0xc0)
                         @store_global (%189, %191) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %192 = load_const (0x00000000000000f8 = 248)
            64    %193 = iadd %0, %192 (0xf8)
            32    %194 = @load_global (%193) (access=none, align_mul=4, align_offset=0)
            32    %195 = ineg %6.x
            32    %196 = iadd %5.x, %195
            32    %197 = iadd %194, %196
            32    %198 = ineg %184
            32    %199 = iadd %197, %198
            32    %200 = imax %199, %14 (0x0)
            32    %201 = imul %5.x, %9
            32    %202 = udiv %200, %201
            1     %203 = ilt %3.x, %180 (0x3)
            32    %204 = bcsel %203, %172, %173
            1     %205 = ilt %3.x, %16 (0x1)
            32    %206 = bcsel %205, %170, %171
            1     %207 = ilt %3.x, %70 (0x2)
            32    %208 = bcsel %207, %206, %204
            32    %209 = umin %208, %202
            32x4  %210 = load_const (0x00000000, 0x00000001, 0x00000002, 0x00000003)
            1x4   %211 = ieq %3.xxxx, %210 (0x0, 0x1, 0x2, 0x3)
            32x4  %212 = bcsel %211, %209.xxxx, %174
            32    %213 = mov %212.x
            32    %214 = mov %212.y
            32    %215 = mov %212.z
            32    %216 = mov %212.w
                         // succs: b28
        } else {
            block b27:  // preds: b25, succs: b28
        }
        block b28:   // preds: b26 b27
        32    %217 = phi b26: %213, b27: %170
        32    %218 = phi b26: %214, b27: %171
        32    %219 = phi b26: %215, b27: %172
        32    %220 = phi b26: %216, b27: %173
        32x4  %221 = vec4 %217, %218, %219, %220
        32    %222 = iand %2, %70 (0x2)
        1     %223 = ine %222, %14 (0x0)
                     // succs: b29 b30
        if %223 {
            block b29:   // preds: b28
            32    %224 = load_const (0x00000003)
            64    %225 = load_const (0x0000000000000080 = 128)
            64    %226 = iadd %225 (0x80), %0
            64    %227 = @load_global (%226) (access=none, align_mul=4, align_offset=0)
            32    %228 = @load_global (%227) (access=none, align_mul=4, align_offset=0)
            64    %229 = load_const (0x00000000000000a8 = 168)
            64    %230 = iadd %229 (0xa8), %0
            64    %231 = @load_global (%230) (access=none, align_mul=4, align_offset=0)
            64    %232 = u2u64 %228
            64    %233 = iadd %231, %232
            64    %234 = load_const (0x00000000000000c8 = 200)
            64    %235 = iadd %234 (0xc8), %0
                         @store_global (%233, %235) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %236 = load_const (0x00000000000000fc = 252)
            64    %237 = iadd %236 (0xfc), %0
            32    %238 = @load_global (%237) (access=none, align_mul=4, align_offset=0)
            32    %239 = ineg %6.y
            32    %240 = iadd %5.y, %239
            32    %241 = iadd %238, %240
            32    %242 = ineg %228
            32    %243 = iadd %241, %242
            32    %244 = imax %243, %14 (0x0)
            32    %245 = imul %5.y, %9
            32    %246 = udiv %244, %245
            1     %247 = ilt %3.y, %224 (0x3)
            32    %248 = bcsel %247, %219, %220
            1     %249 = ilt %3.y, %16 (0x1)
            32    %250 = bcsel %249, %217, %218
            1     %251 = ilt %3.y, %70 (0x2)
            32    %252 = bcsel %251, %250, %248
            32    %253 = umin %252, %246
            32x4  %254 = load_const (0x00000000, 0x00000001, 0x00000002, 0x00000003)
            1x4   %255 = ieq %3.yyyy, %254 (0x0, 0x1, 0x2, 0x3)
            32x4  %256 = bcsel %255, %253.xxxx, %221
            32    %257 = mov %256.x
            32    %258 = mov %256.y
            32    %259 = mov %256.z
            32    %260 = mov %256.w
                         // succs: b31
        } else {
            block b30:  // preds: b28, succs: b31
        }
        block b31:   // preds: b29 b30
        32    %261 = phi b29: %257, b30: %217
        32    %262 = phi b29: %258, b30: %218
        32    %263 = phi b29: %259, b30: %219
        32    %264 = phi b29: %260, b30: %220
        32x4  %265 = vec4 %261, %262, %263, %264
        32    %266 = iand %2, %105 (0x4)
        1     %267 = ine %266, %14 (0x0)
                     // succs: b32 b33
        if %267 {
            block b32:   // preds: b31
            32    %268 = load_const (0x00000003)
            64    %269 = load_const (0x0000000000000088 = 136)
            64    %270 = iadd %269 (0x88), %0
            64    %271 = @load_global (%270) (access=none, align_mul=4, align_offset=0)
            32    %272 = @load_global (%271) (access=none, align_mul=4, align_offset=0)
            64    %273 = load_const (0x00000000000000b0 = 176)
            64    %274 = iadd %273 (0xb0), %0
            64    %275 = @load_global (%274) (access=none, align_mul=4, align_offset=0)
            64    %276 = u2u64 %272
            64    %277 = iadd %275, %276
            64    %278 = load_const (0x00000000000000d0 = 208)
            64    %279 = iadd %278 (0xd0), %0
                         @store_global (%277, %279) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %280 = load_const (0x0000000000000100 = 256)
            64    %281 = iadd %280 (0x100), %0
            32    %282 = @load_global (%281) (access=none, align_mul=4, align_offset=0)
            32    %283 = ineg %6.z
            32    %284 = iadd %5.z, %283
            32    %285 = iadd %282, %284
            32    %286 = ineg %272
            32    %287 = iadd %285, %286
            32    %288 = imax %287, %14 (0x0)
            32    %289 = imul %5.z, %9
            32    %290 = udiv %288, %289
            1     %291 = ilt %3.z, %268 (0x3)
            32    %292 = bcsel %291, %263, %264
            1     %293 = ilt %3.z, %16 (0x1)
            32    %294 = bcsel %293, %261, %262
            1     %295 = ilt %3.z, %70 (0x2)
            32    %296 = bcsel %295, %294, %292
            32    %297 = umin %296, %290
            32x4  %298 = load_const (0x00000000, 0x00000001, 0x00000002, 0x00000003)
            1x4   %299 = ieq %3.zzzz, %298 (0x0, 0x1, 0x2, 0x3)
            32x4  %300 = bcsel %299, %297.xxxx, %265
            32    %301 = mov %300.x
            32    %302 = mov %300.y
            32    %303 = mov %300.z
            32    %304 = mov %300.w
                         // succs: b34
        } else {
            block b33:  // preds: b31, succs: b34
        }
        block b34:   // preds: b32 b33
        32    %305 = phi b32: %301, b33: %261
        32    %306 = phi b32: %302, b33: %262
        32    %307 = phi b32: %303, b33: %263
        32    %308 = phi b32: %304, b33: %264
        32x4  %309 = vec4 %305, %306, %307, %308
        32    %310 = iand %2, %140 (0x8)
        1     %311 = ine %310, %14 (0x0)
                     // succs: b35 b36
        if %311 {
            block b35:   // preds: b34
            32    %312 = load_const (0x00000003)
            64    %313 = load_const (0x0000000000000090 = 144)
            64    %314 = iadd %313 (0x90), %0
            64    %315 = @load_global (%314) (access=none, align_mul=4, align_offset=0)
            32    %316 = @load_global (%315) (access=none, align_mul=4, align_offset=0)
            64    %317 = load_const (0x00000000000000b8 = 184)
            64    %318 = iadd %317 (0xb8), %0
            64    %319 = @load_global (%318) (access=none, align_mul=4, align_offset=0)
            64    %320 = u2u64 %316
            64    %321 = iadd %319, %320
            64    %322 = load_const (0x00000000000000d8 = 216)
            64    %323 = iadd %322 (0xd8), %0
                         @store_global (%321, %323) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %324 = load_const (0x0000000000000104 = 260)
            64    %325 = iadd %324 (0x104), %0
            32    %326 = @load_global (%325) (access=none, align_mul=4, align_offset=0)
            32    %327 = ineg %6.w
            32    %328 = iadd %5.w, %327
            32    %329 = iadd %326, %328
            32    %330 = ineg %316
            32    %331 = iadd %329, %330
            32    %332 = imax %331, %14 (0x0)
            32    %333 = imul %5.w, %9
            32    %334 = udiv %332, %333
            1     %335 = ilt %3.w, %312 (0x3)
            32    %336 = bcsel %335, %307, %308
            1     %337 = ilt %3.w, %16 (0x1)
            32    %338 = bcsel %337, %305, %306
            1     %339 = ilt %3.w, %70 (0x2)
            32    %340 = bcsel %339, %338, %336
            32    %341 = umin %340, %334
            32x4  %342 = load_const (0x00000000, 0x00000001, 0x00000002, 0x00000003)
            1x4   %343 = ieq %3.wwww, %342 (0x0, 0x1, 0x2, 0x3)
            32x4  %344 = bcsel %343, %341.xxxx, %309
            32    %345 = mov %344.x
            32    %346 = mov %344.y
            32    %347 = mov %344.z
            32    %348 = mov %344.w
                         // succs: b37
        } else {
            block b36:  // preds: b34, succs: b37
        }
        block b37:   // preds: b35 b36
        32    %349 = phi b35: %345, b36: %305
        32    %350 = phi b35: %346, b36: %306
        32    %351 = phi b35: %347, b36: %307
        32    %352 = phi b35: %348, b36: %308
        32x4  %353 = vec4 %349, %350, %351, %352
        1x4   %354 = ult %353, %174
                     // succs: b38 b39
        if %36 {
            block b38:   // preds: b37
            32    %355 = imul %349, %9
            64    %356 = load_const (0x0000000000000108 = 264)
            64    %357 = iadd %0, %356 (0x108)
                         @store_global (%355, %357) (wrmask=x, access=none, align_mul=4, align_offset=0)
            32    %358 = b2i32 %354.x
            64    %359 = load_const (0x0000000000000050 = 80)
            64    %360 = iadd %0, %359 (0x50)
            64    %361 = @load_global (%360) (access=none, align_mul=4, align_offset=0)
            32    %362 = @load_global (%361) (access=none, align_mul=4, align_offset=0)
            32    %363 = iadd %362, %358
                         @store_global (%363, %361) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %364 = load_const (0x0000000000000030 = 48)
            64    %365 = iadd %0, %364 (0x30)
            64    %366 = @load_global (%365) (access=none, align_mul=4, align_offset=0)
            32    %367 = @load_global (%366) (access=none, align_mul=4, align_offset=0)
            32    %368 = iadd %367, %349
                         @store_global (%368, %366) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b40
        } else {
            block b39:  // preds: b37, succs: b40
        }
        block b40:  // preds: b38 b39, succs: b41 b42
        if %72 {
            block b41:   // preds: b40
            32    %369 = imul %350, %9
            64    %370 = load_const (0x000000000000010c = 268)
            64    %371 = iadd %370 (0x10c), %0
                         @store_global (%369, %371) (wrmask=x, access=none, align_mul=4, align_offset=0)
            32    %372 = b2i32 %354.y
            64    %373 = load_const (0x0000000000000058 = 88)
            64    %374 = iadd %373 (0x58), %0
            64    %375 = @load_global (%374) (access=none, align_mul=4, align_offset=0)
            32    %376 = @load_global (%375) (access=none, align_mul=4, align_offset=0)
            32    %377 = iadd %376, %372
                         @store_global (%377, %375) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %378 = load_const (0x0000000000000038 = 56)
            64    %379 = iadd %378 (0x38), %0
            64    %380 = @load_global (%379) (access=none, align_mul=4, align_offset=0)
            32    %381 = @load_global (%380) (access=none, align_mul=4, align_offset=0)
            32    %382 = iadd %381, %350
                         @store_global (%382, %380) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b43
        } else {
            block b42:  // preds: b40, succs: b43
        }
        block b43:  // preds: b41 b42, succs: b44 b45
        if %107 {
            block b44:   // preds: b43
            32    %383 = imul %351, %9
            64    %384 = load_const (0x0000000000000110 = 272)
            64    %385 = iadd %384 (0x110), %0
                         @store_global (%383, %385) (wrmask=x, access=none, align_mul=4, align_offset=0)
            32    %386 = b2i32 %354.z
            64    %387 = load_const (0x0000000000000060 = 96)
            64    %388 = iadd %387 (0x60), %0
            64    %389 = @load_global (%388) (access=none, align_mul=4, align_offset=0)
            32    %390 = @load_global (%389) (access=none, align_mul=4, align_offset=0)
            32    %391 = iadd %390, %386
                         @store_global (%391, %389) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %392 = load_const (0x0000000000000040 = 64)
            64    %393 = iadd %392 (0x40), %0
            64    %394 = @load_global (%393) (access=none, align_mul=4, align_offset=0)
            32    %395 = @load_global (%394) (access=none, align_mul=4, align_offset=0)
            32    %396 = iadd %395, %351
                         @store_global (%396, %394) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b46
        } else {
            block b45:  // preds: b43, succs: b46
        }
        block b46:  // preds: b44 b45, succs: b47 b48
        if %142 {
            block b47:   // preds: b46
            32    %397 = imul %352, %9
            64    %398 = load_const (0x0000000000000114 = 276)
            64    %399 = iadd %398 (0x114), %0
                         @store_global (%397, %399) (wrmask=x, access=none, align_mul=4, align_offset=0)
            32    %400 = b2i32 %354.w
            64    %401 = load_const (0x0000000000000068 = 104)
            64    %402 = iadd %401 (0x68), %0
            64    %403 = @load_global (%402) (access=none, align_mul=4, align_offset=0)
            32    %404 = @load_global (%403) (access=none, align_mul=4, align_offset=0)
            32    %405 = iadd %404, %400
                         @store_global (%405, %403) (wrmask=x, access=none, align_mul=4, align_offset=0)
            64    %406 = load_const (0x0000000000000048 = 72)
            64    %407 = iadd %406 (0x48), %0
            64    %408 = @load_global (%407) (access=none, align_mul=4, align_offset=0)
            32    %409 = @load_global (%408) (access=none, align_mul=4, align_offset=0)
            32    %410 = iadd %409, %352
                         @store_global (%410, %408) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b49
        } else {
            block b48:  // preds: b46, succs: b49
        }
        block b49:   // preds: b47 b48
        1     %411 = bany_inequal4 %354, %28 (false).xxxx
        32    %412 = b2i32 %411
        64    %413 = load_const (0x0000000000000070 = 112)
        64    %414 = iadd %0, %413 (0x70)
        64    %415 = @load_global (%414) (access=none, align_mul=4, align_offset=0)
        32    %416 = @load_global (%415) (access=none, align_mul=4, align_offset=0)
        32    %417 = iadd %416, %412
                     @store_global (%417, %415) (wrmask=x, access=none, align_mul=4, align_offset=0)
                     // succs: b50 b51
        if %179 {
            block b50:   // preds: b49
            32    %418 = load_const (0x00000003)
            32    %419 = imul %5.x, %9
            64    %420 = load_const (0x0000000000000078 = 120)
            64    %421 = iadd %0, %420 (0x78)
            64    %422 = @load_global (%421) (access=none, align_mul=4, align_offset=0)
            64    %423 = load_const (0x0000000100000000 = 4294967296)
            1     %424 = ieq %422, %423 (0x100000000)
            64    %425 = bcsel %424, %27 (0x100004000), %422
            1     %426 = ilt %3.x, %418 (0x3)
            32    %427 = bcsel %426, %351, %352
            1     %428 = ilt %3.x, %16 (0x1)
            32    %429 = bcsel %428, %349, %350
            1     %430 = ilt %3.x, %70 (0x2)
            32    %431 = bcsel %430, %429, %427
            32    %432 = imul %431, %419
            32    %433 = @load_global (%425) (access=none, align_mul=4, align_offset=0)
            32    %434 = iadd %433, %432
                         @store_global (%434, %425) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b52
        } else {
            block b51:  // preds: b49, succs: b52
        }
        block b52:  // preds: b50 b51, succs: b53 b54
        if %223 {
            block b53:   // preds: b52
            32    %435 = load_const (0x00000003)
            32    %436 = imul %5.y, %9
            64    %437 = load_const (0x0000000000000080 = 128)
            64    %438 = iadd %437 (0x80), %0
            64    %439 = @load_global (%438) (access=none, align_mul=4, align_offset=0)
            64    %440 = load_const (0x0000000100000000 = 4294967296)
            1     %441 = ieq %439, %440 (0x100000000)
            64    %442 = bcsel %441, %27 (0x100004000), %439
            1     %443 = ilt %3.y, %435 (0x3)
            32    %444 = bcsel %443, %351, %352
            1     %445 = ilt %3.y, %16 (0x1)
            32    %446 = bcsel %445, %349, %350
            1     %447 = ilt %3.y, %70 (0x2)
            32    %448 = bcsel %447, %446, %444
            32    %449 = imul %448, %436
            32    %450 = @load_global (%442) (access=none, align_mul=4, align_offset=0)
            32    %451 = iadd %450, %449
                         @store_global (%451, %442) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b55
        } else {
            block b54:  // preds: b52, succs: b55
        }
        block b55:  // preds: b53 b54, succs: b56 b57
        if %267 {
            block b56:   // preds: b55
            32    %452 = load_const (0x00000003)
            32    %453 = imul %5.z, %9
            64    %454 = load_const (0x0000000000000088 = 136)
            64    %455 = iadd %454 (0x88), %0
            64    %456 = @load_global (%455) (access=none, align_mul=4, align_offset=0)
            64    %457 = load_const (0x0000000100000000 = 4294967296)
            1     %458 = ieq %456, %457 (0x100000000)
            64    %459 = bcsel %458, %27 (0x100004000), %456
            1     %460 = ilt %3.z, %452 (0x3)
            32    %461 = bcsel %460, %351, %352
            1     %462 = ilt %3.z, %16 (0x1)
            32    %463 = bcsel %462, %349, %350
            1     %464 = ilt %3.z, %70 (0x2)
            32    %465 = bcsel %464, %463, %461
            32    %466 = imul %465, %453
            32    %467 = @load_global (%459) (access=none, align_mul=4, align_offset=0)
            32    %468 = iadd %467, %466
                         @store_global (%468, %459) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b58
        } else {
            block b57:  // preds: b55, succs: b58
        }
        block b58:  // preds: b56 b57, succs: b59 b60
        if %311 {
            block b59:   // preds: b58
            32    %469 = load_const (0x00000003)
            32    %470 = imul %5.w, %9
            64    %471 = load_const (0x0000000000000090 = 144)
            64    %472 = iadd %471 (0x90), %0
            64    %473 = @load_global (%472) (access=none, align_mul=4, align_offset=0)
            64    %474 = load_const (0x0000000100000000 = 4294967296)
            1     %475 = ieq %473, %474 (0x100000000)
            64    %476 = bcsel %475, %27 (0x100004000), %473
            1     %477 = ilt %3.w, %469 (0x3)
            32    %478 = bcsel %477, %351, %352
            1     %479 = ilt %3.w, %16 (0x1)
            32    %480 = bcsel %479, %349, %350
            1     %481 = ilt %3.w, %70 (0x2)
            32    %482 = bcsel %481, %480, %478
            32    %483 = imul %482, %470
            32    %484 = @load_global (%476) (access=none, align_mul=4, align_offset=0)
            32    %485 = iadd %484, %483
                         @store_global (%485, %476) (wrmask=x, access=none, align_mul=4, align_offset=0)
                         // succs: b61
        } else {
            block b60:  // preds: b58, succs: b61
        }
        block b61:  // preds: b59 b60, succs: b63
    } else {
        block b62:  // preds: b24, succs: b63
    }
    block b63:   // preds: b61 b62
    32    %486 = imul %34, %8
    32    %487 = @load_global (%10) (access=none, align_mul=4, align_offset=0)
    32    %488 = iadd %487, %486
                 @store_global (%488, %10) (wrmask=x, access=none, align_mul=4, align_offset=0)
    32    %489 = @load_global (%11) (access=none, align_mul=4, align_offset=0)
    32    %490 = iadd %489, %177
                 @store_global (%490, %11) (wrmask=x, access=none, align_mul=4, align_offset=0)
    32    %491 = @load_global (%12) (access=none, align_mul=4, align_offset=0)
    32    %492 = iadd %491, %177
                 @store_global (%492, %12) (wrmask=x, access=none, align_mul=4, align_offset=0)
    32    %493 = @load_global (%13) (access=none, align_mul=4, align_offset=0)
    32    %494 = iadd %493, %177
                 @store_global (%494, %13) (wrmask=x, access=none, align_mul=4, align_offset=0)
                 // succs: b64
    block b64:
   */
   static const uint32_t impl_0_nir[1895] = {
    0x00000230, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x0000000e, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x0000000b, 0x00000000, 0x00000025, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xd00317e4, 0xd00417e4,
    0xd00517e4, 0xd00617e4, 0xd00717e4, 0xc40817e4,
    0xc40917e4, 0xe40a17e4, 0xe40b17e4, 0xe40c17e4,
    0xe40d17e4, 0x00000e05, 0x242a0000, 0x00000000,
    0x00100006, 0x00003605, 0xc4212800, 0x00000000,
    0x00000011, 0x242a0080, 0x00000000, 0x00100006,
    0xc4212800, 0x00000000, 0x00000014, 0xc4299020,
    0x00000000, 0x00150013, 0x242a0100, 0x00000000,
    0x00100006, 0xc4212800, 0x00000000, 0x00000017,
    0xc4299020, 0x00000000, 0x00180016, 0x242a0180,
    0x00000000, 0x00100006, 0xc4212800, 0x00000000,
    0x0000001a, 0xc4299020, 0x00000000, 0x001b0019,
    0x00000705, 0x00004000, 0x00000001, 0x00001105,
    0x242ac000, 0x00000000, 0x00100004, 0xc42e0800,
    0x00000000, 0x0004001c, 0x242ac000, 0x00000000,
    0x00100020, 0x00291705, 0xe4299000, 0x00000000,
    0x00220002, 0xc40053d4, 0x0000008c, 0x00000400,
    0xc429a800, 0x00000000, 0x00120003, 0x242ac000,
    0x00000000, 0x00100025, 0x00000001, 0x00000098,
    0x00000000, 0x00000003, 0x00000000, 0x00000001,
    0x242a3000, 0x00000000, 0x00100009, 0x00000001,
    0x000000a0, 0x00000000, 0x00000001, 0x00000000,
    0x0000000e, 0xc42f1000, 0x00000000, 0x00120024,
    0xc4239800, 0x00000000, 0x002a0021, 0x00000010,
    0x00011705, 0xe4299000, 0x00000000, 0x002c0002,
    0xe40053d4, 0x000000b4, 0x00000400, 0xc42a9000,
    0x00000000, 0x001c002b, 0xc4299000, 0x00000000,
    0x0006002f, 0xe42d1000, 0x00000000, 0x00000030,
    0x00005605, 0xe42b2000, 0x00000000, 0x00320031,
    0xe4299000, 0x00000000, 0x0033002e, 0xc40053d4,
    0x000000d0, 0x00000400, 0x2429d000, 0x00000000,
    0x00100024, 0xc4239800, 0x00000000, 0x00100036,
    0x00000035, 0x00000001, 0x00000000, 0x00000001,
    0xc42a9000, 0x00000000, 0x00090024, 0x00000000,
    0x0000000d, 0xc4000028, 0x00000037, 0x00000029,
    0x00000039, 0x00000038, 0x00000115, 0x00000001,
    0xd0039800, 0x00000000, 0x540000f0, 0x000000ec,
    0x00000040, 0x00021705, 0xe4299000, 0x00000000,
    0x003e0002, 0xe40053d4, 0x000000fc, 0x00000400,
    0xc40053d4, 0x00000100, 0x00000400, 0xc4299000,
    0x00000000, 0x003d0041, 0x000069d4, 0x00000108,
    0x00000100, 0x00040001, 0xc42b6800, 0x00000000,
    0x0000003d, 0xc42b6880, 0x00000000, 0x0000003d,
    0xc42b6900, 0x00000000, 0x0000003d, 0xc42b6980,
    0x00000000, 0x0000003d, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000008, 0xc4000028,
    0x00000043, 0x0000003a, 0x00000010, 0x00000047,
    0xc4000028, 0x00000044, 0x0000003a, 0x00000010,
    0x00000047, 0xc4000028, 0x00000045, 0x0000003a,
    0x00000010, 0x00000047, 0xc4000028, 0x00000046,
    0x0000003a, 0x00000010, 0x00000047, 0xd02f3000,
    0x00000000, 0x004a0049, 0x004c004b, 0x00005605,
    0xc429a800, 0x00000000, 0x004e0003, 0x242ac000,
    0x00000000, 0x0010004f, 0x00000001, 0x00000140,
    0x00000000, 0x00000003, 0x00000000, 0x00000001,
    0x242a3080, 0x00000000, 0x00100009, 0x00000001,
    0x00000148, 0x00000000, 0x00000001, 0x00000000,
    0x0000000d, 0xc42f1000, 0x00000000, 0x00120024,
    0xc4239800, 0x00000000, 0x00540021, 0x00000010,
    0x00011705, 0xe4299000, 0x00000000, 0x00560002,
    0xe40053d4, 0x0000015c, 0x00000400, 0xc42a9000,
    0x00000000, 0x001c0055, 0xc4299200, 0x00000000,
    0x00060059, 0xe42d1000, 0x00000000, 0x0000005a,
    0xe42b2000, 0x00000000, 0x004e005b, 0xe4299000,
    0x00000000, 0x005c0058, 0xc40053d4, 0x00000174,
    0x00000400, 0x2429d000, 0x00000000, 0x00100024,
    0xc4239800, 0x00000000, 0x0010005f, 0x0000005e,
    0x00000001, 0x00000000, 0x00000001, 0xc42a9200,
    0x00000000, 0x00090024, 0x00000000, 0x0000000d,
    0xc4000028, 0x00000060, 0x00000053, 0x00000062,
    0x00000061, 0x00000115, 0x00000100, 0xd0039800,
    0x00000000, 0x04000194, 0x00000190, 0xe4000134,
    0x00031705, 0xe4299000, 0x00000000, 0x00020067,
    0xe40053d4, 0x000001a0, 0x00000400, 0xc40053d4,
    0x000001a4, 0x00000400, 0xc4299200, 0x00000000,
    0x0066006a, 0x000069d4, 0x000001ac, 0x000001a4,
    0x00040001, 0xc42b6800, 0x00000000, 0x00000066,
    0xc42b6880, 0x00000000, 0x00000066, 0xc42b6900,
    0x00000000, 0x00000066, 0xc42b6980, 0x00000000,
    0x00000066, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000008, 0xc4000028, 0x0000006c,
    0x00000063, 0x00000049, 0x00000070, 0xc4000028,
    0x0000006d, 0x00000063, 0x0000004a, 0x00000070,
    0xc4000028, 0x0000006e, 0x00000063, 0x0000004b,
    0x00000070, 0xc4000028, 0x0000006f, 0x00000063,
    0x0000004c, 0x00000070, 0xd02f3000, 0x00000000,
    0x00730072, 0x00750074, 0x00009605, 0xc429a800,
    0x00000000, 0x00770003, 0x242ac000, 0x00000000,
    0x00100078, 0x00000001, 0x000001e4, 0x00000000,
    0x00000003, 0x00000000, 0x00000001, 0x242a3100,
    0x00000000, 0x00100009, 0x00000001, 0x000001ec,
    0x00000000, 0x00000001, 0x00000000, 0x0000000d,
    0xc42f1000, 0x00000000, 0x00120024, 0xc4239800,
    0x00000000, 0x007d0021, 0x00000010, 0x00011705,
    0xe4299000, 0x00000000, 0x007f0002, 0xe40053d4,
    0x00000200, 0x00000400, 0xc42a9000, 0x00000000,
    0x001c007e, 0xc4299400, 0x00000000, 0x00060082,
    0xe42d1000, 0x00000000, 0x00000083, 0xe42b2000,
    0x00000000, 0x004e0084, 0xe4299000, 0x00000000,
    0x00850081, 0xc40053d4, 0x00000218, 0x00000400,
    0x2429d000, 0x00000000, 0x00100024, 0xc4239800,
    0x00000000, 0x00100088, 0x00000087, 0x00000001,
    0x00000000, 0x00000001, 0xc42a9400, 0x00000000,
    0x00090024, 0x00000000, 0x0000000d, 0xc4000028,
    0x00000089, 0x0000007c, 0x0000008b, 0x0000008a,
    0x00000115, 0x00000100, 0xd0039800, 0x00000000,
    0x10000238, 0x00000234, 0xe40001d8, 0x00041705,
    0xe4299000, 0x00000000, 0x00020090, 0xe40053d4,
    0x00000244, 0x00000400, 0xc40053d4, 0x00000248,
    0x00000400, 0xc4299400, 0x00000000, 0x008f0093,
    0x000069d4, 0x00000250, 0x00000248, 0x00040001,
    0xc42b6800, 0x00000000, 0x0000008f, 0xc42b6880,
    0x00000000, 0x0000008f, 0xc42b6900, 0x00000000,
    0x0000008f, 0xc42b6980, 0x00000000, 0x0000008f,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000008, 0xc4000028, 0x00000095, 0x0000008c,
    0x00000072, 0x00000099, 0xc4000028, 0x00000096,
    0x0000008c, 0x00000073, 0x00000099, 0xc4000028,
    0x00000097, 0x0000008c, 0x00000074, 0x00000099,
    0xc4000028, 0x00000098, 0x0000008c, 0x00000075,
    0x00000099, 0xd02f3000, 0x00000000, 0x009c009b,
    0x009e009d, 0x00011605, 0xc429a800, 0x00000000,
    0x00a00003, 0x242ac000, 0x00000000, 0x001000a1,
    0x00000001, 0x00000288, 0x00000000, 0x00000003,
    0x00000000, 0x00000001, 0x242a3180, 0x00000000,
    0x00100009, 0x00000001, 0x00000290, 0x00000000,
    0x00000001, 0x00000000, 0x0000000d, 0xc42f1000,
    0x00000000, 0x00120024, 0xc4239800, 0x00000000,
    0x00a60021, 0x00000010, 0x00011705, 0xe4299000,
    0x00000000, 0x00a80002, 0xe40053d4, 0x000002a4,
    0x00000400, 0xc42a9000, 0x00000000, 0x001c00a7,
    0xc4299600, 0x00000000, 0x000600ab, 0xe42d1000,
    0x00000000, 0x000000ac, 0xe42b2000, 0x00000000,
    0x004e00ad, 0xe4299000, 0x00000000, 0x00ae00aa,
    0xc40053d4, 0x000002bc, 0x00000400, 0x2429d000,
    0x00000000, 0x00100024, 0xc4239800, 0x00000000,
    0x001000b1, 0x000000b0, 0x00000001, 0x00000000,
    0x00000001, 0xc42a9600, 0x00000000, 0x00090024,
    0x00000000, 0x0000000d, 0xc4000028, 0x000000b2,
    0x000000a5, 0x000000b4, 0x000000b3, 0x00000115,
    0x00000100, 0xd0039800, 0x00000000, 0x400002dc,
    0x000002d8, 0xe400027c, 0x00051705, 0xe4299000,
    0x00000000, 0x000200b9, 0xe40053d4, 0x000002e8,
    0x00000400, 0xc40053d4, 0x000002ec, 0x00000400,
    0xc4299600, 0x00000000, 0x00b800bc, 0x000069d4,
    0x000002f4, 0x000002ec, 0x00040001, 0xc42b6800,
    0x00000000, 0x000000b8, 0xc42b6880, 0x00000000,
    0x000000b8, 0xc42b6900, 0x00000000, 0x000000b8,
    0xc42b6980, 0x00000000, 0x000000b8, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000008,
    0xc4000028, 0x000000be, 0x000000b5, 0x0000009b,
    0x000000c2, 0xc4000028, 0x000000bf, 0x000000b5,
    0x0000009c, 0x000000c2, 0xc4000028, 0x000000c0,
    0x000000b5, 0x0000009d, 0x000000c2, 0xc4000028,
    0x000000c1, 0x000000b5, 0x0000009e, 0x000000c2,
    0xd02f3000, 0x00000000, 0x00c500c4, 0x00c700c6,
    0xc4a99000, 0x00000000, 0x00c500c4, 0x00000000,
    0x00c600c9, 0x00000000, 0x00c700ca, 0x00000001,
    0x0000007c, 0x00000000, 0x00000019, 0x00000000,
    0x00000002, 0xc429a800, 0x00000000, 0x00120004,
    0x242ac000, 0x00000000, 0x001000cd, 0x00000001,
    0x00000338, 0x00000000, 0x00000001, 0x00000000,
    0x00000026, 0x00007605, 0x000f1705, 0xe4299000,
    0x00000000, 0x00d10002, 0xe40053d4, 0x00000348,
    0x00000400, 0xc40053d4, 0x0000034c, 0x00000400,
    0x00141705, 0xe4299000, 0x00000000, 0x00d50002,
    0xe40053d4, 0x00000358, 0x00000400, 0xe42d1000,
    0x00000000, 0x000000d4, 0xe4299000, 0x00000000,
    0x00d800d7, 0x00181705, 0xe4299000, 0x00000000,
    0x00da0002, 0x000069d4, 0x00000364, 0x0000036c,
    0x00040001, 0x001f1705, 0xe4299000, 0x00000000,
    0x00dc0002, 0xc40053d4, 0x00000374, 0x00000400,
    0xc42ae000, 0x00000000, 0x00000008, 0xc4699000,
    0x00000000, 0x00df0007, 0x00000000, 0x00e000de,
    0xc42ae000, 0x00000000, 0x000000d4, 0xc4299000,
    0x00000000, 0x00e200e1, 0xc42a7000, 0x00000000,
    0x001000e3, 0xc42a9000, 0x00000000, 0x000b0007,
    0xc42d5800, 0x00000000, 0x00e500e4, 0x242a3000,
    0x00000000, 0x00d00005, 0xc4239800, 0x00000000,
    0x00c600e7, 0x000000c7, 0x242a3000, 0x00000000,
    0x00120005, 0xc4239800, 0x00000000, 0x00c400e9,
    0x000000c5, 0x242a3000, 0x00000000, 0x004e0005,
    0xc4239800, 0x00000000, 0x00ea00eb, 0x000000e8,
    0xc42e0800, 0x00000000, 0x00e600ec, 0x00000635,
    0x00000000, 0x00000001, 0x00000002, 0x00000003,
    0x3009d000, 0x00000000, 0x00000014, 0xe40003b8,
    0xd0039800, 0x00000000, 0xe40003bc, 0x000003b4,
    0xe4000320, 0xc42b6800, 0x00000000, 0x000000f0,
    0xc42b6880, 0x00000000, 0x000000f0, 0xc42b6900,
    0x00000000, 0x000000f0, 0xc42b6980, 0x00000000,
    0x000000f0, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000007, 0xc4000028, 0x000000f1,
    0x000000cf, 0x000000c4, 0x000000f5, 0xc4000028,
    0x000000f2, 0x000000cf, 0x000000c5, 0x000000f5,
    0xc4000028, 0x000000f3, 0x000000cf, 0x000000c6,
    0x000000f5, 0xc4000028, 0x000000f4, 0x000000cf,
    0x000000c7, 0x000000f5, 0xd02f3000, 0x00000000,
    0x00f800f7, 0x00fa00f9, 0xc429a800, 0x00000000,
    0x004e0004, 0x242ac000, 0x00000000, 0x001000fc,
    0x00000001, 0x000003f4, 0x00000000, 0x00000001,
    0x00000000, 0x00000026, 0x00007605, 0x00101705,
    0xe4299000, 0x00000000, 0x00020100, 0xe40053d4,
    0x00000404, 0x00000400, 0xc40053d4, 0x00000408,
    0x00000400, 0x00151705, 0xe4299000, 0x00000000,
    0x00020104, 0xe40053d4, 0x00000414, 0x00000400,
    0xe42d1000, 0x00000000, 0x00000103, 0xe4299000,
    0x00000000, 0x01070106, 0x00191705, 0xe4299000,
    0x00000000, 0x00020109, 0x000069d4, 0x00000420,
    0x00000428, 0x00040001, 0x001f9705, 0xe4299000,
    0x00000000, 0x0002010b, 0xc40053d4, 0x00000430,
    0x00000400, 0xc42ae080, 0x00000000, 0x00000008,
    0xc4299080, 0x00000000, 0x010e0007, 0xc4299000,
    0x00000000, 0x010f010d, 0xc42ae000, 0x00000000,
    0x00000103, 0xc4299000, 0x00000000, 0x01110110,
    0xc42a7000, 0x00000000, 0x00100112, 0xc42a9080,
    0x00000000, 0x000b0007, 0xc42d5800, 0x00000000,
    0x01140113, 0x242a3080, 0x00000000, 0x00ff0005,
    0xc4239800, 0x00000000, 0x00f90116, 0x000000fa,
    0x242a3080, 0x00000000, 0x00120005, 0xc4239800,
    0x00000000, 0x00f70118, 0x000000f8, 0x242a3080,
    0x00000000, 0x004e0005, 0xc4239800, 0x00000000,
    0x0119011a, 0x00000117, 0xc42e0800, 0x00000000,
    0x0115011b, 0x00000635, 0x00000000, 0x00000001,
    0x00000002, 0x00000003, 0x3009d000, 0x00000000,
    0x55000014, 0xe4000474, 0xd0039800, 0x00000000,
    0xe4000478, 0x00000470, 0xe40003ec, 0xc42b6800,
    0x00000000, 0x0000011f, 0xc42b6880, 0x00000000,
    0x0000011f, 0xc42b6900, 0x00000000, 0x0000011f,
    0xc42b6980, 0x00000000, 0x0000011f, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000007,
    0xc4000028, 0x00000120, 0x000000fe, 0x000000f7,
    0x00000124, 0xc4000028, 0x00000121, 0x000000fe,
    0x000000f8, 0x00000124, 0xc4000028, 0x00000122,
    0x000000fe, 0x000000f9, 0x00000124, 0xc4000028,
    0x00000123, 0x000000fe, 0x000000fa, 0x00000124,
    0xd02f3000, 0x00000000, 0x01270126, 0x01290128,
    0xc429a800, 0x00000000, 0x00770004, 0x242ac000,
    0x00000000, 0x0010012b, 0x00000001, 0x000004b0,
    0x00000000, 0x00000001, 0x00000000, 0x00000026,
    0x00007605, 0x00111705, 0xe4299000, 0x00000000,
    0x0002012f, 0xe40053d4, 0x000004c0, 0x00000400,
    0xc40053d4, 0x000004c4, 0x00000400, 0x00161705,
    0xe4299000, 0x00000000, 0x00020133, 0xe40053d4,
    0x000004d0, 0x00000400, 0xe42d1000, 0x00000000,
    0x00000132, 0xe4299000, 0x00000000, 0x01360135,
    0x001a1705, 0xe4299000, 0x00000000, 0x00020138,
    0x000069d4, 0x000004dc, 0x000004e4, 0x00040001,
    0x00201705, 0xe4299000, 0x00000000, 0x0002013a,
    0xc40053d4, 0x000004ec, 0x00000400, 0xc42ae100,
    0x00000000, 0x00000008, 0xc4299100, 0x00000000,
    0x013d0007, 0xc4299000, 0x00000000, 0x013e013c,
    0xc42ae000, 0x00000000, 0x00000132, 0xc4299000,
    0x00000000, 0x0140013f, 0xc42a7000, 0x00000000,
    0x00100141, 0xc42a9100, 0x00000000, 0x000b0007,
    0xc42d5800, 0x00000000, 0x01430142, 0x242a3100,
    0x00000000, 0x012e0005, 0xc4239800, 0x00000000,
    0x01280145, 0x00000129, 0x242a3100, 0x00000000,
    0x00120005, 0xc4239800, 0x00000000, 0x01260147,
    0x00000127, 0x242a3100, 0x00000000, 0x004e0005,
    0xc4239800, 0x00000000, 0x01480149, 0x00000146,
    0xc42e0800, 0x00000000, 0x0144014a, 0x00000635,
    0x00000000, 0x00000001, 0x00000002, 0x00000003,
    0x3009d000, 0x00000000, 0xaa000014, 0xe4000530,
    0xd0039800, 0x00000000, 0xe4000534, 0x0000052c,
    0xe40004a8, 0xc42b6800, 0x00000000, 0x0000014e,
    0xc42b6880, 0x00000000, 0x0000014e, 0xc42b6900,
    0x00000000, 0x0000014e, 0xc42b6980, 0x00000000,
    0x0000014e, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000007, 0xc4000028, 0x0000014f,
    0x0000012d, 0x00000126, 0x00000153, 0xc4000028,
    0x00000150, 0x0000012d, 0x00000127, 0x00000153,
    0xc4000028, 0x00000151, 0x0000012d, 0x00000128,
    0x00000153, 0xc4000028, 0x00000152, 0x0000012d,
    0x00000129, 0x00000153, 0xd02f3000, 0x00000000,
    0x01560155, 0x01580157, 0xc429a800, 0x00000000,
    0x00a00004, 0x242ac000, 0x00000000, 0x0010015a,
    0x00000001, 0x0000056c, 0x00000000, 0x00000001,
    0x00000000, 0x00000026, 0x00007605, 0x00121705,
    0xe4299000, 0x00000000, 0x0002015e, 0xe40053d4,
    0x0000057c, 0x00000400, 0xc40053d4, 0x00000580,
    0x00000400, 0x00171705, 0xe4299000, 0x00000000,
    0x00020162, 0xe40053d4, 0x0000058c, 0x00000400,
    0xe42d1000, 0x00000000, 0x00000161, 0xe4299000,
    0x00000000, 0x01650164, 0x001b1705, 0xe4299000,
    0x00000000, 0x00020167, 0x000069d4, 0x00000598,
    0x000005a0, 0x00040001, 0x00209705, 0xe4299000,
    0x00000000, 0x00020169, 0xc40053d4, 0x000005a8,
    0x00000400, 0xc42ae180, 0x00000000, 0x00000008,
    0xc4299180, 0x00000000, 0x016c0007, 0xc4299000,
    0x00000000, 0x016d016b, 0xc42ae000, 0x00000000,
    0x00000161, 0xc4299000, 0x00000000, 0x016f016e,
    0xc42a7000, 0x00000000, 0x00100170, 0xc42a9180,
    0x00000000, 0x000b0007, 0xc42d5800, 0x00000000,
    0x01720171, 0x242a3180, 0x00000000, 0x015d0005,
    0xc4239800, 0x00000000, 0x01570174, 0x00000158,
    0x242a3180, 0x00000000, 0x00120005, 0xc4239800,
    0x00000000, 0x01550176, 0x00000156, 0x242a3180,
    0x00000000, 0x004e0005, 0xc4239800, 0x00000000,
    0x01770178, 0x00000175, 0xc42e0800, 0x00000000,
    0x01730179, 0x00000635, 0x00000000, 0x00000001,
    0x00000002, 0x00000003, 0x3009d000, 0x00000000,
    0xff000014, 0xe40005ec, 0xd0039800, 0x00000000,
    0xe40005f0, 0x000005e8, 0xe4000564, 0xc42b6800,
    0x00000000, 0x0000017d, 0xc42b6880, 0x00000000,
    0x0000017d, 0xc42b6900, 0x00000000, 0x0000017d,
    0xc42b6980, 0x00000000, 0x0000017d, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000006,
    0xc4000028, 0x0000017e, 0x0000015c, 0x00000155,
    0x00000182, 0xc4000028, 0x0000017f, 0x0000015c,
    0x00000156, 0x00000182, 0xc4000028, 0x00000180,
    0x0000015c, 0x00000157, 0x00000182, 0xc4000028,
    0x00000181, 0x0000015c, 0x00000158, 0x00000182,
    0xd02f3000, 0x00000000, 0x01850184, 0x01870186,
    0x302dc800, 0x00000000, 0x00c80188, 0x00000001,
    0x00000098, 0x00000000, 0x00000001, 0x00000000,
    0x00000011, 0xc42a9000, 0x00000000, 0x000b0184,
    0x00211705, 0xe4299000, 0x00000000, 0x018c0002,
    0x000069d4, 0x0000062c, 0x00000634, 0x00040001,
    0xc4212800, 0x00000000, 0x00000189, 0x000a1705,
    0xe4299000, 0x00000000, 0x018f0002, 0xe40053d4,
    0x00000640, 0x00000400, 0xc40053d4, 0x00000644,
    0x00000400, 0xc4299000, 0x00000000, 0x018e0192,
    0x000069d4, 0x0000064c, 0x00000644, 0x00040001,
    0x00061705, 0xe4299000, 0x00000000, 0x01940002,
    0xe40053d4, 0x00000654, 0x00000400, 0xc40053d4,
    0x00000658, 0x00000400, 0xc4299000, 0x00000000,
    0x01840197, 0x000069d4, 0x00000660, 0x00000658,
    0x00040001, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000140,
    0x00000000, 0x00000001, 0x00000000, 0x00000011,
    0xc42a9000, 0x00000000, 0x000b0185, 0x00219705,
    0xe4299000, 0x00000000, 0x0002019d, 0x000069d4,
    0x00000670, 0x00000678, 0x00040001, 0xc4212880,
    0x00000000, 0x00000189, 0x000b1705, 0xe4299000,
    0x00000000, 0x000201a0, 0xe40053d4, 0x00000684,
    0x00000400, 0xc40053d4, 0x00000688, 0x00000400,
    0xc4299000, 0x00000000, 0x019f01a3, 0x000069d4,
    0x00000690, 0x00000688, 0x00040001, 0x00071705,
    0xe4299000, 0x00000000, 0x000201a5, 0xe40053d4,
    0x00000698, 0x00000400, 0xc40053d4, 0x0000069c,
    0x00000400, 0xc4299000, 0x00000000, 0x018501a8,
    0x000069d4, 0x000006a4, 0x0000069c, 0x00040001,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x000001e4, 0x00000000,
    0x00000001, 0x00000000, 0x00000011, 0xc42a9000,
    0x00000000, 0x000b0186, 0x00221705, 0xe4299000,
    0x00000000, 0x000201ae, 0x000069d4, 0x000006b4,
    0x000006bc, 0x00040001, 0xc4212900, 0x00000000,
    0x00000189, 0x000c1705, 0xe4299000, 0x00000000,
    0x000201b1, 0xe40053d4, 0x000006c8, 0x00000400,
    0xc40053d4, 0x000006cc, 0x00000400, 0xc4299000,
    0x00000000, 0x01b001b4, 0x000069d4, 0x000006d4,
    0x000006cc, 0x00040001, 0x00081705, 0xe4299000,
    0x00000000, 0x000201b6, 0xe40053d4, 0x000006dc,
    0x00000400, 0xc40053d4, 0x000006e0, 0x00000400,
    0xc4299000, 0x00000000, 0x018601b9, 0x000069d4,
    0x000006e8, 0x000006e0, 0x00040001, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000001, 0x00000288, 0x00000000, 0x00000001,
    0x00000000, 0x00000011, 0xc42a9000, 0x00000000,
    0x000b0187, 0x00229705, 0xe4299000, 0x00000000,
    0x000201bf, 0x000069d4, 0x000006f8, 0x00000700,
    0x00040001, 0xc4212980, 0x00000000, 0x00000189,
    0x000d1705, 0xe4299000, 0x00000000, 0x000201c2,
    0xe40053d4, 0x0000070c, 0x00000400, 0xc40053d4,
    0x00000710, 0x00000400, 0xc4299000, 0x00000000,
    0x01c101c5, 0x000069d4, 0x00000718, 0x00000710,
    0x00040001, 0x00091705, 0xe4299000, 0x00000000,
    0x000201c7, 0xe40053d4, 0x00000720, 0x00000400,
    0xc40053d4, 0x00000724, 0x00000400, 0xc4299000,
    0x00000000, 0x018701ca, 0x000069d4, 0x0000072c,
    0x00000724, 0x00040001, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000008, 0x24038000,
    0x00000000, 0xe4000624, 0x00000078, 0xc4212800,
    0x00000000, 0x000001ce, 0x000e1705, 0xe4299000,
    0x00000000, 0x01d00002, 0xe40053d4, 0x00000744,
    0x00000400, 0xc40053d4, 0x00000748, 0x00000400,
    0xc4299000, 0x00000000, 0x01cf01d3, 0x000069d4,
    0x00000750, 0x00000748, 0x00040001, 0x00000001,
    0x00000338, 0x00000000, 0x00000001, 0x00000000,
    0x00000012, 0x00007605, 0xc42a9000, 0x00000000,
    0x000b0007, 0x000f1705, 0xe4299000, 0x00000000,
    0x01d80002, 0xe40053d4, 0x00000764, 0x00000400,
    0x00000705, 0x00000000, 0x00000001, 0x2429d000,
    0x00000000, 0x01db01da, 0xe4239800, 0x00000000,
    0x001d01dc, 0x000001da, 0x242a3000, 0x00000000,
    0x01d60005, 0xc4239800, 0x00000000, 0x018601de,
    0x00000187, 0x242a3000, 0x00000000, 0x00120005,
    0xc4239800, 0x00000000, 0x018401e0, 0x00000185,
    0x242a3000, 0x00000000, 0x004e0005, 0xc4239800,
    0x00000000, 0x01e101e2, 0x000001df, 0xc42a9000,
    0x00000000, 0x01d701e3, 0xc40053d4, 0x00000774,
    0x00000400, 0xc4299000, 0x00000000, 0x01e401e5,
    0x000069d4, 0x00000798, 0x00000774, 0x00040001,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x000003f4, 0x00000000,
    0x00000001, 0x00000000, 0x00000012, 0x00007605,
    0xc42a9080, 0x00000000, 0x000b0007, 0x00101705,
    0xe4299000, 0x00000000, 0x000201ec, 0xe40053d4,
    0x000007b4, 0x00000400, 0x00000705, 0x00000000,
    0x00000001, 0x2429d000, 0x00000000, 0x01ef01ee,
    0xe4239800, 0x00000000, 0x001d01f0, 0x000001ee,
    0x242a3080, 0x00000000, 0x01ea0005, 0xc4239800,
    0x00000000, 0x018601f2, 0x00000187, 0x242a3080,
    0x00000000, 0x00120005, 0xc4239800, 0x00000000,
    0x018401f4, 0x00000185, 0x242a3080, 0x00000000,
    0x004e0005, 0xc4239800, 0x00000000, 0x01f501f6,
    0x000001f3, 0xc42a9000, 0x00000000, 0x01eb01f7,
    0xc40053d4, 0x000007c4, 0x00000400, 0xc4299000,
    0x00000000, 0x01f801f9, 0x000069d4, 0x000007e8,
    0x000007c4, 0x00040001, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000001,
    0x000004b0, 0x00000000, 0x00000001, 0x00000000,
    0x00000012, 0x00007605, 0xc42a9100, 0x00000000,
    0x000b0007, 0x00111705, 0xe4299000, 0x00000000,
    0x00020200, 0xe40053d4, 0x00000804, 0x00000400,
    0x00000705, 0x00000000, 0x00000001, 0x2429d000,
    0x00000000, 0x02030202, 0xe4239800, 0x00000000,
    0x001d0204, 0x00000202, 0x242a3100, 0x00000000,
    0x01fe0005, 0xc4239800, 0x00000000, 0x01860206,
    0x00000187, 0x242a3100, 0x00000000, 0x00120005,
    0xc4239800, 0x00000000, 0x01840208, 0x00000185,
    0x242a3100, 0x00000000, 0x004e0005, 0xc4239800,
    0x00000000, 0x0209020a, 0x00000207, 0xc42a9000,
    0x00000000, 0x01ff020b, 0xc40053d4, 0x00000814,
    0x00000400, 0xc4299000, 0x00000000, 0x020c020d,
    0x000069d4, 0x00000838, 0x00000814, 0x00040001,
    0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x0000056c, 0x00000000,
    0x00000001, 0x00000000, 0x00000012, 0x00007605,
    0xc42a9180, 0x00000000, 0x000b0007, 0x00121705,
    0xe4299000, 0x00000000, 0x00020214, 0xe40053d4,
    0x00000854, 0x00000400, 0x00000705, 0x00000000,
    0x00000001, 0x2429d000, 0x00000000, 0x02170216,
    0xe4239800, 0x00000000, 0x001d0218, 0x00000216,
    0x242a3180, 0x00000000, 0x02120005, 0xc4239800,
    0x00000000, 0x0186021a, 0x00000187, 0x242a3180,
    0x00000000, 0x00120005, 0xc4239800, 0x00000000,
    0x0184021c, 0x00000185, 0x242a3180, 0x00000000,
    0x004e0005, 0xc4239800, 0x00000000, 0x021d021e,
    0x0000021b, 0xc42a9000, 0x00000000, 0x0213021f,
    0xc40053d4, 0x00000864, 0x00000400, 0xc4299000,
    0x00000000, 0x02200221, 0x000069d4, 0x00000888,
    0x00000864, 0x00040001, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x0000000d,
    0xc42a9000, 0x00000000, 0x000a0024, 0xc40053d4,
    0x00000030, 0x00000400, 0xc4299000, 0x00000000,
    0x02270228, 0x000069d4, 0x000008a4, 0x00000030,
    0x00040001, 0xc40053d4, 0x00000034, 0x00000400,
    0xc4299000, 0x00000000, 0x00cb022a, 0x000069d4,
    0x000008ac, 0x00000034, 0x00040001, 0xc40053d4,
    0x00000038, 0x00000400, 0xc4299000, 0x00000000,
    0x00cb022c, 0x000069d4, 0x000008b4, 0x00000038,
    0x00040001, 0xc40053d4, 0x0000003c, 0x00000400,
    0xc4299000, 0x00000000, 0x00cb022e, 0x000069d4,
    0x000008bc, 0x0000003c, 0x00040001,
};
   nir_def *args[14] = { p, streams, buffers_written, buffer_to_stream, count_index, stride, output_end, static_count, invocations, vertices_per_prim, gs_invocations, gs_primitives, c_primitives, c_invocations };
   nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tcs_patch_vertices_in(nir_builder *b, nir_def *p);

nir_def *
libagx_tcs_patch_vertices_in(nir_builder *b, nir_def *p)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    64    %1 = load_const (0x0000000000000068 = 104)
    64    %2 = iadd %0, %1 (0x68)
    32    %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
               @bindgen_return (%3)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[25] = {
    0x00000006, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000005, 0xe40017e4,
    0x000d1705, 0xe4299000, 0x00000000, 0x00030002,
    0xc4005434, 0x00000010, 0x00000400, 0x00000304,
    0x00000014,
};
   nir_def *args[1] = { p };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tes_patch_vertices_in(nir_builder *b, nir_def *p);

nir_def *
libagx_tes_patch_vertices_in(nir_builder *b, nir_def *p)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    64    %1 = load_const (0x000000000000006c = 108)
    64    %2 = iadd %0, %1 (0x6c)
    32    %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
               @bindgen_return (%3)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[25] = {
    0x00000006, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000005, 0xe40017e4,
    0x000d9705, 0xe4299000, 0x00000000, 0x00030002,
    0xc4005434, 0x00000010, 0x00000400, 0x00000304,
    0x00000014,
};
   nir_def *args[1] = { p };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tcs_unrolled_id(nir_builder *b, nir_def *p, nir_def *wg_id);

nir_def *
libagx_tcs_unrolled_id(nir_builder *b, nir_def *p, nir_def *wg_id)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    32x3  %1 = @load_param (param_idx=1)
    64    %2 = load_const (0x0000000000000074 = 116)
    64    %3 = iadd %0, %2 (0x74)
    32    %4 = @load_global_constant (%3) (access=none, align_mul=4, align_offset=0)
    32    %5 = imul %1.y, %4
    32    %6 = iadd %5, %1.x
               @bindgen_return (%6)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[36] = {
    0x00000009, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002003, 0x000002c0,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000008, 0xe40017e4,
    0xcc0117e4, 0x000e9705, 0xe4299000, 0x00000000,
    0x00040002, 0xc4005434, 0x00000014, 0x00000400,
    0xc42a9080, 0x00000000, 0x00060003, 0xc4299000,
    0x00000000, 0x00030007, 0x00000304, 0x00000020,
};
   nir_def *args[2] = { p, wg_id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tes_buffer(nir_builder *b, nir_def *p);

nir_def *
libagx_tes_buffer(nir_builder *b, nir_def *p)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    64    %1 = load_const (0x0000000000000040 = 64)
    64    %2 = iadd %0, %1 (0x40)
    64    %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
               @bindgen_return (%3)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[25] = {
    0x00000006, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000005, 0xe40017e4,
    0x00081705, 0xe4299000, 0x00000000, 0x00030002,
    0xe4005434, 0x00000010, 0x00000400, 0x00000304,
    0x00000014,
};
   nir_def *args[1] = { p };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_load_tes_index(nir_builder *b, nir_def *p, nir_def *index);

nir_def *
libagx_load_tes_index(nir_builder *b, nir_def *p, nir_def *index)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    64     %2 = load_const (0x000000000000008c = 140)
    64     %3 = iadd %0, %2 (0x8c)
    32     %4 = @load_global_constant (%3) (access=none, align_mul=4, align_offset=0)
    32     %5 = load_const (0x00000000)
    1      %6 = ine %4, %5 (0x0)
    32     %7 = load_const (0x00000003)
    32     %8 = umod %1, %7 (0x3)
    32     %9 = load_const (0x00000001)
    1     %10 = ieq %8, %9 (0x1)
    32    %11 = load_const (0x00000002)
    1     %12 = ieq %8, %11 (0x2)
    32    %13 = load_const (0xffffffff = -1 = 4294967295)
    32    %14 = iadd %1, %13 (0xffffffff)
    32    %15 = bcsel %12, %14, %1
    32    %16 = iadd %1, %9 (0x1)
    32    %17 = bcsel %10, %16, %15
    32    %18 = bcsel %6, %17, %1
    64    %19 = load_const (0x0000000000000030 = 48)
    64    %20 = iadd %0, %19 (0x30)
    64    %21 = @load_global_constant (%20) (access=none, align_mul=4, align_offset=0)
    64    %22 = u2u64 %18
    64    %23 = ishl %22, %11 (0x2)
    64    %24 = iadd %21, %23
    32    %25 = @load_global (%24) (access=none, align_mul=4, align_offset=0)
                @bindgen_return (%25)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[83] = {
    0x0000001c, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000001b, 0xe40017e4,
    0xc40117e4, 0x00119705, 0xe4299000, 0x00000000,
    0x00040002, 0xc4005434, 0x00000014, 0x00000400,
    0x00000e05, 0x242ac000, 0x00000000, 0x00070006,
    0x00007605, 0xc42e1800, 0x00000000, 0x00090003,
    0x00003605, 0x2429d000, 0x00000000, 0x000b000a,
    0x00005605, 0x2429d000, 0x00000000, 0x000d000a,
    0xfffff605, 0xc4299000, 0x00000000, 0x000f0003,
    0xc4239800, 0x00000000, 0x0010000e, 0x00000003,
    0xc4299000, 0x00000000, 0x000b0003, 0xc4639800,
    0x00000000, 0x0012000c, 0x00000011, 0x00000000,
    0x00130008, 0x00000003, 0x00061705, 0xe4299000,
    0x00000000, 0x00150002, 0xe4005434, 0x00000058,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000014,
    0xe42b2000, 0x00000000, 0x000d0018, 0xe4299000,
    0x00000000, 0x00190017, 0xc40053d4, 0x00000068,
    0x00000400, 0x00000304, 0x0000006c,
};
   nir_def *args[2] = { p, index };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tcs_in_offset(nir_builder *b, nir_def *vtx, nir_def *location, nir_def *crosslane_vs_out_mask);

nir_def *
libagx_tcs_in_offset(nir_builder *b, nir_def *vtx, nir_def *location, nir_def *crosslane_vs_out_mask)
{
   /*
    block b0:   // preds:
    32     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    64     %2 = @load_param (param_idx=2)
    32     %3 = bit_count %2
    32     %4 = imul %0, %3
    64     %5 = load_const (0x0000000000000001)
    64     %6 = ishl %5 (0x1), %1
    64     %7 = load_const (0xffffffffffffffff = -1 = 18446744073709551615)
    64     %8 = iadd %6, %7 (0xffffffffffffffff)
    64     %9 = iand %2, %8
    32    %10 = bit_count %9
    32    %11 = iadd %4, %10
    32    %12 = load_const (0x00000004)
    32    %13 = ishl %11, %12 (0x4)
    16    %14 = u2u16 %13
                @bindgen_return (%14)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[58] = {
    0x00000011, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000010, 0xc40017e4,
    0xc40117e4, 0xe40217e4, 0xc4240000, 0x00000000,
    0x00000004, 0xc42a9000, 0x00000000, 0x00050002,
    0x00003705, 0xe42b2000, 0x00000000, 0x00030007,
    0xfffff705, 0xe4299000, 0x00000000, 0x00090008,
    0xe429a800, 0x00000000, 0x000a0004, 0xc4240000,
    0x00000000, 0x0000000b, 0xc4299000, 0x00000000,
    0x000c0006, 0x00009605, 0xc42b2000, 0x00000000,
    0x000e000d, 0xa42d0000, 0x00000000, 0x0000000f,
    0x00000304, 0x00000040,
};
   nir_def *args[3] = { vtx, location, crosslane_vs_out_mask };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tcs_out_address(nir_builder *b, nir_def *p, nir_def *patch_id, nir_def *vtx_id, nir_def *location, nir_def *nr_patch_out, nir_def *out_patch_size, nir_def *vtx_out_mask);

nir_def *
libagx_tcs_out_address(nir_builder *b, nir_def *p, nir_def *patch_id, nir_def *vtx_id, nir_def *location, nir_def *nr_patch_out, nir_def *out_patch_size, nir_def *vtx_out_mask)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = @load_param (param_idx=4)
    32     %5 = @load_param (param_idx=5)
    64     %6 = @load_param (param_idx=6)
    32     %7 = load_const (0x00000000)
    32     %8 = load_const (0x0000001a = 26)
    32     %9 = load_const (0x00000006)
    32    %10 = load_const (0x00000002)
    32    %11 = ishl %4, %10 (0x2)
    32    %12 = iadd %9 (0x6), %11
    32    %13 = ishl %5, %10 (0x2)
    32    %14 = bit_count %6
    32    %15 = imul %13, %14
    32    %16 = iadd %12, %15
    1     %17 = ieq %3, %8 (0x1a)
    32    %18 = load_const (0x00000004)
    32    %19 = load_const (0x0000001b = 27)
    1     %20 = ieq %3, %19 (0x1b)
    32    %21 = load_const (0x00000040 = 64)
    1     %22 = uge %3, %21 (0x40)
    32    %23 = ishl %2, %10 (0x2)
    32    %24 = imul %23, %14
    32    %25 = iadd %12, %24
    64    %26 = load_const (0x0000000000000001)
    64    %27 = ishl %26 (0x1), %3
    64    %28 = load_const (0xffffffffffffffff = -1 = 18446744073709551615)
    64    %29 = iadd %27, %28 (0xffffffffffffffff)
    64    %30 = iand %6, %29
    32    %31 = bit_count %30
    32    %32 = ishl %31, %10 (0x2)
    32    %33 = iadd %25, %32
    32    %34 = ishl %3, %10 (0x2)
    32    %35 = load_const (0xffffff06 = -250 = 4294967046)
    32    %36 = iadd %35 (0xffffff06), %34
    32    %37 = bcsel %22, %36, %33
    32    %38 = bcsel %20, %18 (0x4), %37
    32    %39 = bcsel %17, %7 (0x0), %38
    32    %40 = imul %1, %16
    32    %41 = iadd %39, %40
    64    %42 = load_const (0x0000000000000020 = 32)
    64    %43 = iadd %0, %42 (0x20)
    64    %44 = @load_global_constant (%43) (access=none, align_mul=4, align_offset=0)
    64    %45 = u2u64 %41
    64    %46 = ishl %45, %10 (0x2)
    64    %47 = iadd %44, %46
                @bindgen_return (%47)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[150] = {
    0x00000032, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000007, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000031, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0xc40417e4,
    0xc40517e4, 0xe40617e4, 0x00000e05, 0x00035605,
    0x0000d605, 0x00005605, 0xc42b2000, 0x00000000,
    0x000c0006, 0xc4299000, 0x00000000, 0x000d000b,
    0xc42b2000, 0x00000000, 0x000c0007, 0xc4240000,
    0x00000000, 0x00000008, 0xc42a9000, 0x00000000,
    0x0010000f, 0xc4299000, 0x00000000, 0x0011000e,
    0x2429d000, 0x00000000, 0x000a0005, 0x00009605,
    0x00037605, 0x2429d000, 0x00000000, 0x00150005,
    0x00081605, 0x242d9800, 0x00000000, 0x00170005,
    0xc42b2000, 0x00000000, 0x000c0004, 0xc42a9000,
    0x00000000, 0x00100019, 0xc4299000, 0x00000000,
    0x001a000e, 0x00003705, 0xe42b2000, 0x00000000,
    0x0005001c, 0xfffff705, 0xe4299000, 0x00000000,
    0x001e001d, 0xe429a800, 0x00000000, 0x001f0008,
    0xc4240000, 0x00000000, 0x00000020, 0xc42b2000,
    0x00000000, 0x000c0021, 0xc4299000, 0x00000000,
    0x0022001b, 0xc42b2000, 0x00000000, 0x000c0005,
    0xffe0d605, 0xc4299000, 0x00000000, 0x00240025,
    0xc4a39800, 0x00000000, 0x00260018, 0x00000023,
    0x00000000, 0x00140016, 0x00000027, 0x00000000,
    0x00090013, 0x00000028, 0xc42a9000, 0x00000000,
    0x00120003, 0xc4299000, 0x00000000, 0x002a0029,
    0x00041705, 0xe4299000, 0x00000000, 0x002c0002,
    0xe4005434, 0x000000b4, 0x00000400, 0xe42d1000,
    0x00000000, 0x0000002b, 0xe42b2000, 0x00000000,
    0x000c002f, 0xe4299000, 0x00000000, 0x0030002e,
    0x00000304, 0x000000c4,
};
   nir_def *args[7] = { p, patch_id, vtx_id, location, nr_patch_out, out_patch_size, vtx_out_mask };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tes_patch_id(nir_builder *b, nir_def *p, nir_def *raw_id);

nir_def *
libagx_tes_patch_id(nir_builder *b, nir_def *p, nir_def *raw_id)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    32    %1 = @load_param (param_idx=1)
    32    %2 = load_const (0x0000000d = 13)
    32    %3 = ushr %1, %2 (0xd)
    64    %4 = load_const (0x0000000000000074 = 116)
    64    %5 = iadd %0, %4 (0x74)
    32    %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    32    %7 = umod %3, %6
               @bindgen_return (%7)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[37] = {
    0x0000000a, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000009, 0xe40017e4,
    0xc40117e4, 0x0001b605, 0xc42ef800, 0x00000000,
    0x00040003, 0x000e9705, 0xe4299000, 0x00000000,
    0x00060002, 0xc4005434, 0x0000001c, 0x00000400,
    0xc42e1800, 0x00000000, 0x00080005, 0x00000304,
    0x00000024,
};
   nir_def *args[2] = { p, raw_id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_load_tess_coord(nir_builder *b, nir_def *p, nir_def *raw_id);

nir_def *
libagx_load_tess_coord(nir_builder *b, nir_def *p, nir_def *raw_id)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = load_const (0x0000000d = 13)
    32     %3 = ushr %1, %2 (0xd)
    32     %4 = load_const (0x00001fff = 8191)
    32     %5 = iand %1, %4 (0x1fff)
    64     %6 = load_const (0x0000000000000008)
    64     %7 = iadd %0, %6 (0x8)
    64     %8 = @load_global_constant (%7) (access=none, align_mul=4, align_offset=0)
    64     %9 = load_const (0x0000000000000010 = 16)
    64    %10 = iadd %0, %9 (0x10)
    64    %11 = @load_global_constant (%10) (access=none, align_mul=4, align_offset=0)
    64    %12 = u2u64 %3
    32    %13 = load_const (0x00000002)
    64    %14 = ishl %12, %13 (0x2)
    64    %15 = iadd %11, %14
    32    %16 = @load_global (%15) (access=none, align_mul=4, align_offset=0)
    32    %17 = iadd %16, %5
    64    %18 = u2u64 %17
    32    %19 = load_const (0x00000003)
    64    %20 = ishl %18, %19 (0x3)
    64    %21 = iadd %8, %20
    32x2  %22 = @load_global (%21) (access=none, align_mul=8, align_offset=0)
    32x2  %23 = u2f32 %22
    32    %24 = load_const (0x47800000 = 65536.000000)
    32x2  %25 = fdiv %23, %24 (65536.000000).xx
                @bindgen_return (%25)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[82] = {
    0x0000001c, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000001b, 0xe40017e4,
    0xc40117e4, 0x0001b605, 0xc42ef800, 0x00000000,
    0x00040003, 0x03fff605, 0xc429a800, 0x00000000,
    0x00060003, 0x00011705, 0xe4299000, 0x00000000,
    0x00080002, 0xe4005434, 0x00000024, 0x00000400,
    0x00021705, 0xe4299000, 0x00000000, 0x000b0002,
    0xe4005434, 0x00000030, 0x00000400, 0xe42d1000,
    0x00000000, 0x00000005, 0x00005605, 0xe42b2000,
    0x00000000, 0x000f000e, 0xe4299000, 0x00000000,
    0x0010000d, 0xc40053d4, 0x00000044, 0x00000400,
    0xc4299000, 0x00000000, 0x00070012, 0xe42d1000,
    0x00000000, 0x00000013, 0x00007605, 0xe42b2000,
    0x00000000, 0x00150014, 0xe4299000, 0x00000000,
    0x0016000a, 0xc80053d4, 0x0000005c, 0x00000800,
    0xc82ce000, 0x00000000, 0x00000018, 0x47800e05,
    0xc8063000, 0x00000000, 0x54000064, 0x00000068,
    0x00000304, 0x0000006c,
};
   nir_def *args[2] = { p, raw_id };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tes_in_address(nir_builder *b, nir_def *p, nir_def *raw_id, nir_def *vtx_id, nir_def *location);

nir_def *
libagx_tes_in_address(nir_builder *b, nir_def *p, nir_def *raw_id, nir_def *vtx_id, nir_def *location)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = load_const (0x0000000d = 13)
    32     %5 = ushr %1, %4 (0xd)
    64     %6 = load_const (0x0000000000000070 = 112)
    64     %7 = iadd %0, %6 (0x70)
    32     %8 = @load_global_constant (%7) (access=none, align_mul=4, align_offset=0)
    64     %9 = load_const (0x000000000000006c = 108)
    64    %10 = iadd %0, %9 (0x6c)
    32    %11 = @load_global_constant (%10) (access=none, align_mul=4, align_offset=0)
    64    %12 = load_const (0x0000000000000048 = 72)
    64    %13 = iadd %0, %12 (0x48)
    64    %14 = @load_global_constant (%13) (access=none, align_mul=4, align_offset=0)
    32    %15 = load_const (0x00000000)
    32    %16 = load_const (0x0000001a = 26)
    32    %17 = load_const (0x00000006)
    32    %18 = load_const (0x00000002)
    32    %19 = ishl %8, %18 (0x2)
    32    %20 = iadd %17 (0x6), %19
    32    %21 = ishl %11, %18 (0x2)
    32    %22 = bit_count %14
    32    %23 = imul %21, %22
    32    %24 = iadd %20, %23
    1     %25 = ieq %3, %16 (0x1a)
    32    %26 = load_const (0x00000004)
    32    %27 = load_const (0x0000001b = 27)
    1     %28 = ieq %3, %27 (0x1b)
    32    %29 = load_const (0x00000040 = 64)
    1     %30 = uge %3, %29 (0x40)
    32    %31 = ishl %2, %18 (0x2)
    32    %32 = imul %31, %22
    32    %33 = iadd %20, %32
    64    %34 = load_const (0x0000000000000001)
    64    %35 = ishl %34 (0x1), %3
    64    %36 = load_const (0xffffffffffffffff = -1 = 18446744073709551615)
    64    %37 = iadd %35, %36 (0xffffffffffffffff)
    64    %38 = iand %14, %37
    32    %39 = bit_count %38
    32    %40 = ishl %39, %18 (0x2)
    32    %41 = iadd %33, %40
    32    %42 = ishl %3, %18 (0x2)
    32    %43 = load_const (0xffffff06 = -250 = 4294967046)
    32    %44 = iadd %43 (0xffffff06), %42
    32    %45 = bcsel %30, %44, %41
    32    %46 = bcsel %28, %26 (0x4), %45
    32    %47 = bcsel %25, %15 (0x0), %46
    32    %48 = imul %5, %24
    32    %49 = iadd %47, %48
    64    %50 = load_const (0x0000000000000020 = 32)
    64    %51 = iadd %0, %50 (0x20)
    64    %52 = @load_global_constant (%51) (access=none, align_mul=4, align_offset=0)
    64    %53 = u2u64 %49
    64    %54 = ishl %53, %18 (0x2)
    64    %55 = iadd %52, %54
                @bindgen_return (%55)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[160] = {
    0x0000003a, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000039, 0xe40017e4,
    0xc40117e4, 0xc40217e4, 0xc40317e4, 0x0001b605,
    0xc42ef800, 0x00000000, 0x00060003, 0x000e1705,
    0xe4299000, 0x00000000, 0x00080002, 0xc4005434,
    0x00000024, 0x00000400, 0x000d9705, 0xe4299000,
    0x00000000, 0x000b0002, 0xc4005434, 0x00000030,
    0x00000400, 0x00091705, 0xe4299000, 0x00000000,
    0x000e0002, 0xe4005434, 0x0000003c, 0x00000400,
    0x00000e05, 0x00035605, 0x0000d605, 0x00005605,
    0xc42b2000, 0x00000000, 0x0014000a, 0xc4299000,
    0x00000000, 0x00150013, 0xc42b2000, 0x00000000,
    0x0014000d, 0xc4240000, 0x00000000, 0x00000010,
    0xc42a9000, 0x00000000, 0x00180017, 0xc4299000,
    0x00000000, 0x00190016, 0x2429d000, 0x00000000,
    0x00120005, 0x00009605, 0x00037605, 0x2429d000,
    0x00000000, 0x001d0005, 0x00081605, 0x242d9800,
    0x00000000, 0x001f0005, 0xc42b2000, 0x00000000,
    0x00140004, 0xc42a9000, 0x00000000, 0x00180021,
    0xc4299000, 0x00000000, 0x00220016, 0x00003705,
    0xe42b2000, 0x00000000, 0x00050024, 0xfffff705,
    0xe4299000, 0x00000000, 0x00260025, 0xe429a800,
    0x00000000, 0x00270010, 0xc4240000, 0x00000000,
    0x00000028, 0xc42b2000, 0x00000000, 0x00140029,
    0xc4299000, 0x00000000, 0x002a0023, 0xc42b2000,
    0x00000000, 0x00140005, 0xffe0d605, 0xc4299000,
    0x00000000, 0x002c002d, 0xc4a39800, 0x00000000,
    0x002e0020, 0x0000002b, 0x00000000, 0x001c001e,
    0x0000002f, 0x00000000, 0x0011001b, 0x00000030,
    0xc42a9000, 0x00000000, 0x001a0007, 0xc4299000,
    0x00000000, 0x00320031, 0x00041705, 0xe4299000,
    0x00000000, 0x00340002, 0xe4005434, 0x000000d4,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000033,
    0xe42b2000, 0x00000000, 0x00140037, 0xe4299000,
    0x00000000, 0x00380036, 0x00000304, 0x000000e4,
};
   nir_def *args[4] = { p, raw_id, vtx_id, location };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tess_level_outer_default(nir_builder *b, nir_def *p);

nir_def *
libagx_tess_level_outer_default(nir_builder *b, nir_def *p)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    64     %1 = load_const (0x0000000000000050 = 80)
    64     %2 = iadd %0, %1 (0x50)
    32     %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
    64     %4 = load_const (0x0000000000000054 = 84)
    64     %5 = iadd %4 (0x54), %0
    32     %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    64     %7 = load_const (0x0000000000000058 = 88)
    64     %8 = iadd %7 (0x58), %0
    32     %9 = @load_global_constant (%8) (access=none, align_mul=4, align_offset=0)
    64    %10 = load_const (0x000000000000005c = 92)
    64    %11 = iadd %10 (0x5c), %0
    32    %12 = @load_global_constant (%11) (access=none, align_mul=4, align_offset=0)
    32x4  %13 = vec4 %3, %6, %9, %12
                @bindgen_return (%13)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[50] = {
    0x00000010, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000f, 0xe40017e4,
    0x000a1705, 0xe4299000, 0x00000000, 0x00030002,
    0xc4005434, 0x00000010, 0x00000400, 0x000a9705,
    0xe4299000, 0x00000000, 0x00020006, 0xc4005434,
    0x0000001c, 0x00000400, 0x000b1705, 0xe4299000,
    0x00000000, 0x00020009, 0xc4005434, 0x00000028,
    0x00000400, 0x000b9705, 0xe4299000, 0x00000000,
    0x0002000c, 0xc4005434, 0x00000034, 0x00000400,
    0xd02f3000, 0x00000000, 0x00080005, 0x000e000b,
    0x00000304, 0x0000003c,
};
   nir_def *args[1] = { p };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_tess_level_inner_default(nir_builder *b, nir_def *p);

nir_def *
libagx_tess_level_inner_default(nir_builder *b, nir_def *p)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    64    %1 = load_const (0x0000000000000060 = 96)
    64    %2 = iadd %0, %1 (0x60)
    32    %3 = @load_global_constant (%2) (access=none, align_mul=4, align_offset=0)
    64    %4 = load_const (0x0000000000000064 = 100)
    64    %5 = iadd %4 (0x64), %0
    32    %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    32x2  %7 = vec2 %3, %6
               @bindgen_return (%7)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[35] = {
    0x0000000a, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000009, 0xe40017e4,
    0x000c1705, 0xe4299000, 0x00000000, 0x00030002,
    0xc4005434, 0x00000010, 0x00000400, 0x000c9705,
    0xe4299000, 0x00000000, 0x00020006, 0xc4005434,
    0x0000001c, 0x00000400, 0xc82f2000, 0x00000000,
    0x00080005, 0x00000304, 0x00000024,
};
   nir_def *args[1] = { p };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_txs(nir_builder *b, nir_def *ptr, nir_def *lod, nir_def *nr_comps, nir_def *is_buffer, nir_def *is_1d, nir_def *is_2d, nir_def *is_cube, nir_def *is_array);

nir_def *
libagx_txs(nir_builder *b, nir_def *ptr, nir_def *lod, nir_def *nr_comps, nir_def *is_buffer, nir_def *is_1d, nir_def *is_2d, nir_def *is_cube, nir_def *is_array)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    16     %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    1      %3 = @load_param (param_idx=3)
    1      %4 = @load_param (param_idx=4)
    1      %5 = @load_param (param_idx=5)
    1      %6 = @load_param (param_idx=6)
    1      %7 = @load_param (param_idx=7)
    32     %8 = load_const (0x00000000)
    32     %9 = load_const (0x00000003)
    32    %10 = load_const (0x00000001)
    32    %11 = load_const (0x00000002)
    32    %12 = @load_global_constant (%0) (access=none, align_mul=4, align_offset=0)
    64    %13 = u2u64 %12
    32    %14 = load_const (0x00000004)
    64    %15 = ushr %13, %14 (0x4)
    32    %16 = unpack_64_2x32_split_x %15
    32    %17 = iand %16, %9 (0x3)
    64    %18 = load_const (0x0000000000000004)
    64    %19 = iadd %0, %18 (0x4)
    32    %20 = @load_global_constant (%19) (access=none, align_mul=4, align_offset=0)
    64    %21 = u2u64 %20
    32    %22 = load_const (0x00000020 = 32)
    64    %23 = ishl %21, %22 (0x20)
    64    %24 = ior %13, %23
    32    %25 = load_const (0x0000001c = 28)
    64    %26 = ushr %24, %25 (0x1c)
    32    %27 = unpack_64_2x32_split_x %26
    32    %28 = load_const (0x00003fff = 16383)
    32    %29 = iand %27, %28 (0x3fff)
    32    %30 = iadd %29, %10 (0x1)
    32    %31 = load_const (0x0000000a = 10)
    64    %32 = ushr %21, %31 (0xa)
    32    %33 = unpack_64_2x32_split_x %32
    32    %34 = iand %33, %28 (0x3fff)
    32    %35 = load_const (0x00000018 = 24)
    64    %36 = ushr %21, %35 (0x18)
    32    %37 = unpack_64_2x32_split_x %36
    32    %38 = load_const (0x0000000f = 15)
    32    %39 = iand %37, %38 (0xf)
    64    %40 = load_const (0x0000000000000008)
    64    %41 = iadd %0, %40 (0x8)
    32    %42 = @load_global_constant (%41) (access=none, align_mul=4, align_offset=0)
    64    %43 = u2u64 %42
    64    %44 = load_const (0x000000000000000c = 12)
    64    %45 = iadd %0, %44 (0xc)
    32    %46 = @load_global_constant (%45) (access=none, align_mul=4, align_offset=0)
    64    %47 = u2u64 %46
    64    %48 = ishl %47, %22 (0x20)
    64    %49 = ior %43, %48
    64    %50 = ushr %49, %11 (0x2)
    32    %51 = unpack_64_2x32_split_x %50
    32    %52 = unpack_64_2x32_split_y %50
    32    %53 = iand %52, %38 (0xf)
    64    %54 = pack_64_2x32_split %51, %53
    64    %55 = ishl %54, %14 (0x4)
    32    %56 = load_const (0x0000000e = 14)
    64    %57 = ushr %47, %56 (0xe)
    32    %58 = unpack_64_2x32_split_x %57
    32    %59 = iand %58, %28 (0x3fff)
    64    %60 = load_const (0x0000000000000010 = 16)
    64    %61 = iadd %0, %60 (0x10)
    32    %62 = @load_global_constant (%61) (access=none, align_mul=4, align_offset=0)
    32    %63 = load_const (0x000007ff = 2047)
    32    %64 = iand %62, %63 (0x7ff)
    64    %65 = load_const (0x0000000100000000 = 4294967296)
    1     %66 = ine %55, %65 (0x100000000)
    32    %67 = u2u32 %1
    32    %68 = iadd %67, %39
    1     %69 = iand %7, %5
    1     %70 = ieq %17, %8 (0x0)
    1     %71 = iand %69, %70
    32    %72 = bcsel %71, %64, %59
    32    %73 = iadd %10 (0x1), %72
    1     %74 = iand %4, %7
    32    %75 = bcsel %74, %72, %34
    32    %76 = iadd %10 (0x1), %75
    32    %77 = ushr %30, %68
    32    %78 = umax %77, %10 (0x1)
    32    %79 = b2i32 %7
    32    %80 = ineg %79
    32    %81 = iadd %2, %80
    1     %82 = uge %81, %11 (0x2)
    32    %83 = ushr %76, %68
    32    %84 = umax %83, %10 (0x1)
    32    %85 = bcsel %82, %84, %76
    1     %86 = uge %81, %9 (0x3)
    32    %87 = ushr %73, %68
    32    %88 = umax %87, %10 (0x1)
    32    %89 = bcsel %86, %88, %73
    32    %90 = bcsel %6, %78, %85
    32    %91 = bcsel %3, %62, %78
    32    %92 = bcsel %3, %62, %90
    32    %93 = bcsel %3, %62, %89
    32    %94 = bcsel %66, %91, %8 (0x0)
    32    %95 = bcsel %66, %92, %8 (0x0)
    32    %96 = bcsel %66, %93, %8 (0x0)
    32x3  %97 = vec3 %94, %95, %96
                @bindgen_return (%97)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[295] = {
    0x00000064, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000008, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00001001, 0x0000024a,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000063, 0xe40017e4,
    0xa40117e4, 0xc40217e4, 0x240317e4, 0x240417e4,
    0x240517e4, 0x240617e4, 0x240717e4, 0x00000e05,
    0x00007605, 0x00003605, 0x00005605, 0xc4005434,
    0x00000008, 0x00000400, 0xe42d1000, 0x00000000,
    0x0000000e, 0x00009605, 0xe42ef800, 0x00000000,
    0x0010000f, 0xc42e8000, 0x00000000, 0x00000011,
    0xc429a800, 0x00000000, 0x000b0012, 0x00009705,
    0xe4299000, 0x00000000, 0x00140002, 0xc4005434,
    0x00000054, 0x00000400, 0xe42d1000, 0x00000000,
    0x00000016, 0x00041605, 0xe42b2000, 0x00000000,
    0x00180017, 0xe42b0800, 0x00000000, 0x0019000f,
    0x00039605, 0xe42ef800, 0x00000000, 0x001b001a,
    0xc42e8000, 0x00000000, 0x0000001c, 0x07fff605,
    0xc429a800, 0x00000000, 0x001e001d, 0xc4299000,
    0x00000000, 0x000c001f, 0x00015605, 0xe42ef800,
    0x00000000, 0x00210017, 0xc42e8000, 0x00000000,
    0x00000022, 0xc429a800, 0x00000000, 0x001e0023,
    0x00031605, 0xe42ef800, 0x00000000, 0x00250017,
    0xc42e8000, 0x00000000, 0x00000026, 0x0001f605,
    0xc429a800, 0x00000000, 0x00280027, 0x00011705,
    0xe4299000, 0x00000000, 0x002a0002, 0xc4005434,
    0x000000ac, 0x00000400, 0xe42d1000, 0x00000000,
    0x0000002c, 0x00019705, 0xe4299000, 0x00000000,
    0x002e0002, 0xc4005434, 0x000000bc, 0x00000400,
    0xe42d1000, 0x00000000, 0x00000030, 0xe42b2000,
    0x00000000, 0x00180031, 0xe42b0800, 0x00000000,
    0x0032002d, 0xe42ef800, 0x00000000, 0x000d0033,
    0xc42e8000, 0x00000000, 0x00000034, 0xc42e8800,
    0x00000000, 0x00000034, 0xc429a800, 0x00000000,
    0x00280036, 0xe42be000, 0x00000000, 0x00370035,
    0xe42b2000, 0x00000000, 0x00100038, 0x0001d605,
    0xe42ef800, 0x00000000, 0x003a0031, 0xc42e8000,
    0x00000000, 0x0000003b, 0xc429a800, 0x00000000,
    0x001e003c, 0x00021705, 0xe4299000, 0x00000000,
    0x003e0002, 0xc4005434, 0x000000fc, 0x00000400,
    0x00fff605, 0xc429a800, 0x00000000, 0x00410040,
    0x00000705, 0x00000000, 0x00000001, 0x242ac000,
    0x00000000, 0x00430039, 0xc42d0800, 0x00000000,
    0x00000003, 0xc4299000, 0x00000000, 0x00290045,
    0x2429a800, 0x00000000, 0x00070009, 0x2429d000,
    0x00000000, 0x000a0013, 0x2429a800, 0x00000000,
    0x00480047, 0xc4239800, 0x00000000, 0x00420049,
    0x0000003d, 0xc4299000, 0x00000000, 0x004a000c,
    0x2429a800, 0x00000000, 0x00090006, 0xc4239800,
    0x00000000, 0x004a004c, 0x00000024, 0xc4299000,
    0x00000000, 0x004d000c, 0xc42ef800, 0x00000000,
    0x00460020, 0xc42df800, 0x00000000, 0x000c004f,
    0xc4212800, 0x00000000, 0x00000009, 0xc42ae000,
    0x00000000, 0x00000051, 0xc4299000, 0x00000000,
    0x00520004, 0x242d9800, 0x00000000, 0x000d0053,
    0xc42ef800, 0x00000000, 0x0046004e, 0xc42df800,
    0x00000000, 0x000c0055, 0xc4239800, 0x00000000,
    0x00560054, 0x0000004e, 0x242d9800, 0x00000000,
    0x000b0053, 0xc42ef800, 0x00000000, 0x0046004b,
    0xc42df800, 0x00000000, 0x000c0059, 0xc4e39800,
    0x00000000, 0x005a0058, 0x0000004b, 0x00000000,
    0x00500008, 0x00000057, 0x00000000, 0x00400005,
    0x00000050, 0x00000000, 0x00400005, 0x0000005c,
    0xc4e39800, 0x00000000, 0x00400005, 0x0000005b,
    0x00000000, 0x005d0044, 0x0000000a, 0x00000000,
    0x005e0044, 0x0000000a, 0x00000000, 0x005f0044,
    0x0000000a, 0xcc2f2800, 0x00000000, 0x00610060,
    0x00000062, 0x00000304, 0x0000018c,
};
   nir_def *args[8] = { ptr, lod, nr_comps, is_buffer, is_1d, is_2d, is_cube, is_array };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_texture_samples(nir_builder *b, nir_def *ptr);

nir_def *
libagx_texture_samples(nir_builder *b, nir_def *ptr)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = load_const (0x00000000)
    32     %2 = load_const (0x00000001)
    32     %3 = load_const (0x00000004)
    32     %4 = load_const (0x00000002)
    64     %5 = load_const (0x0000000000000008)
    64     %6 = iadd %0, %5 (0x8)
    32     %7 = @load_global_constant (%6) (access=none, align_mul=4, align_offset=0)
    32     %8 = iand %7, %2 (0x1)
    64     %9 = u2u64 %7
    64    %10 = load_const (0x000000000000000c = 12)
    64    %11 = iadd %0, %10 (0xc)
    32    %12 = @load_global_constant (%11) (access=none, align_mul=4, align_offset=0)
    64    %13 = u2u64 %12
    32    %14 = load_const (0x00000020 = 32)
    64    %15 = ishl %13, %14 (0x20)
    64    %16 = ior %9, %15
    64    %17 = ushr %16, %4 (0x2)
    32    %18 = unpack_64_2x32_split_x %17
    32    %19 = unpack_64_2x32_split_y %17
    32    %20 = load_const (0x0000000f = 15)
    32    %21 = iand %19, %20 (0xf)
    64    %22 = pack_64_2x32_split %18, %21
    64    %23 = ishl %22, %3 (0x4)
    64    %24 = load_const (0x0000000100000000 = 4294967296)
    1     %25 = ine %23, %24 (0x100000000)
    1     %26 = ieq %8, %1 (0x0)
    32    %27 = bcsel %26, %4 (0x2), %3 (0x4)
    32    %28 = bcsel %25, %27, %1 (0x0)
                @bindgen_return (%28)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[87] = {
    0x0000001f, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000001e, 0xe40017e4,
    0x00000e05, 0x00003605, 0x00009605, 0x00005605,
    0x00011705, 0xe4299000, 0x00000000, 0x00070002,
    0xc4005434, 0x00000020, 0x00000400, 0xc429a800,
    0x00000000, 0x00040009, 0xe42d1000, 0x00000000,
    0x00000009, 0x00019705, 0xe4299000, 0x00000000,
    0x000c0002, 0xc4005434, 0x00000034, 0x00000400,
    0xe42d1000, 0x00000000, 0x0000000e, 0x00041605,
    0xe42b2000, 0x00000000, 0x0010000f, 0xe42b0800,
    0x00000000, 0x0011000b, 0xe42ef800, 0x00000000,
    0x00060012, 0xc42e8000, 0x00000000, 0x00000013,
    0xc42e8800, 0x00000000, 0x00000013, 0x0001f605,
    0xc429a800, 0x00000000, 0x00160015, 0xe42be000,
    0x00000000, 0x00170014, 0xe42b2000, 0x00000000,
    0x00050018, 0x00000705, 0x00000000, 0x00000001,
    0x242ac000, 0x00000000, 0x001a0019, 0x2429d000,
    0x00000000, 0x0003000a, 0xc4639800, 0x00000000,
    0x0006001c, 0x00000005, 0x00000000, 0x001d001b,
    0x00000003, 0x00000304, 0x00000078,
};
   nir_def *args[1] = { ptr };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_texture_levels(nir_builder *b, nir_def *ptr);

nir_def *
libagx_texture_levels(nir_builder *b, nir_def *ptr)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = load_const (0x00000000)
    32     %2 = load_const (0x00000001)
    32     %3 = load_const (0x00000002)
    64     %4 = load_const (0x0000000000000004)
    64     %5 = iadd %0, %4 (0x4)
    32     %6 = @load_global_constant (%5) (access=none, align_mul=4, align_offset=0)
    64     %7 = u2u64 %6
    32     %8 = load_const (0x00000018 = 24)
    64     %9 = ushr %7, %8 (0x18)
    32    %10 = unpack_64_2x32_split_x %9
    32    %11 = load_const (0x0000000f = 15)
    32    %12 = iand %10, %11 (0xf)
    32    %13 = load_const (0x0000001c = 28)
    64    %14 = ushr %7, %13 (0x1c)
    32    %15 = unpack_64_2x32_split_x %14
    32    %16 = iand %15, %11 (0xf)
    64    %17 = load_const (0x0000000000000008)
    64    %18 = iadd %0, %17 (0x8)
    32    %19 = @load_global_constant (%18) (access=none, align_mul=4, align_offset=0)
    64    %20 = u2u64 %19
    64    %21 = load_const (0x000000000000000c = 12)
    64    %22 = iadd %0, %21 (0xc)
    32    %23 = @load_global_constant (%22) (access=none, align_mul=4, align_offset=0)
    64    %24 = u2u64 %23
    32    %25 = load_const (0x00000020 = 32)
    64    %26 = ishl %24, %25 (0x20)
    64    %27 = ior %20, %26
    32    %28 = load_const (0x00000004)
    64    %29 = ushr %27, %3 (0x2)
    32    %30 = unpack_64_2x32_split_x %29
    32    %31 = unpack_64_2x32_split_y %29
    32    %32 = iand %31, %11 (0xf)
    64    %33 = pack_64_2x32_split %30, %32
    64    %34 = ishl %33, %28 (0x4)
    64    %35 = load_const (0x0000000100000000 = 4294967296)
    1     %36 = ine %34, %35 (0x100000000)
    32    %37 = ineg %12
    32    %38 = iadd %16, %2 (0x1)
    32    %39 = iadd %38, %37
    32    %40 = bcsel %36, %39, %1 (0x0)
                @bindgen_return (%40)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[116] = {
    0x0000002b, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000002a, 0xe40017e4,
    0x00000e05, 0x00003605, 0x00005605, 0x00009705,
    0xe4299000, 0x00000000, 0x00060002, 0xc4005434,
    0x0000001c, 0x00000400, 0xe42d1000, 0x00000000,
    0x00000008, 0x00031605, 0xe42ef800, 0x00000000,
    0x000a0009, 0xc42e8000, 0x00000000, 0x0000000b,
    0x0001f605, 0xc429a800, 0x00000000, 0x000d000c,
    0x00039605, 0xe42ef800, 0x00000000, 0x000f0009,
    0xc42e8000, 0x00000000, 0x00000010, 0xc429a800,
    0x00000000, 0x000d0011, 0x00011705, 0xe4299000,
    0x00000000, 0x00130002, 0xc4005434, 0x00000050,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000015,
    0x00019705, 0xe4299000, 0x00000000, 0x00170002,
    0xc4005434, 0x00000060, 0x00000400, 0xe42d1000,
    0x00000000, 0x00000019, 0x00041605, 0xe42b2000,
    0x00000000, 0x001b001a, 0xe42b0800, 0x00000000,
    0x001c0016, 0x00009605, 0xe42ef800, 0x00000000,
    0x0005001d, 0xc42e8000, 0x00000000, 0x0000001f,
    0xc42e8800, 0x00000000, 0x0000001f, 0xc429a800,
    0x00000000, 0x000d0021, 0xe42be000, 0x00000000,
    0x00220020, 0xe42b2000, 0x00000000, 0x001e0023,
    0x00000705, 0x00000000, 0x00000001, 0x242ac000,
    0x00000000, 0x00250024, 0xc42ae000, 0x00000000,
    0x0000000e, 0xc4699000, 0x00000000, 0x00040012,
    0x00000000, 0x00270028, 0xc4239800, 0x00000000,
    0x00290026, 0x00000003, 0x00000304, 0x000000a8,
};
   nir_def *args[1] = { ptr };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_lower_txf_robustness(nir_builder *b, nir_def *ptr, nir_def *check_lod, nir_def *lod, nir_def *check_min_lod, nir_def *min_lod, nir_def *check_layer, nir_def *layer, nir_def *x);

nir_def *
libagx_lower_txf_robustness(nir_builder *b, nir_def *ptr, nir_def *check_lod, nir_def *lod, nir_def *check_min_lod, nir_def *min_lod, nir_def *check_layer, nir_def *layer, nir_def *x)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    1      %1 = @load_param (param_idx=1)
    16     %2 = @load_param (param_idx=2)
    1      %3 = @load_param (param_idx=3)
    16     %4 = @load_param (param_idx=4)
    1      %5 = @load_param (param_idx=5)
    32     %6 = @load_param (param_idx=6)
    32     %7 = @load_param (param_idx=7)
    32     %8 = load_const (0x00000000)
    32     %9 = load_const (0x00000001)
    32    %10 = @load_global_constant (%0) (access=none, align_mul=4, align_offset=0)
    64    %11 = u2u64 %10
    32    %12 = load_const (0x00000004)
    64    %13 = ushr %11, %12 (0x4)
    32    %14 = unpack_64_2x32_split_x %13
    32    %15 = load_const (0x00000003)
    32    %16 = iand %14, %15 (0x3)
    64    %17 = load_const (0x0000000000000004)
    64    %18 = iadd %0, %17 (0x4)
    32    %19 = @load_global_constant (%18) (access=none, align_mul=4, align_offset=0)
    64    %20 = u2u64 %19
    32    %21 = load_const (0x00000018 = 24)
    64    %22 = ushr %20, %21 (0x18)
    32    %23 = unpack_64_2x32_split_x %22
    32    %24 = load_const (0x0000000f = 15)
    32    %25 = iand %23, %24 (0xf)
    32    %26 = load_const (0x0000001c = 28)
    64    %27 = ushr %20, %26 (0x1c)
    32    %28 = unpack_64_2x32_split_x %27
    32    %29 = iand %28, %24 (0xf)
    32    %30 = load_const (0x0000000e = 14)
    64    %31 = load_const (0x000000000000000c = 12)
    64    %32 = iadd %0, %31 (0xc)
    32    %33 = @load_global_constant (%32) (access=none, align_mul=4, align_offset=0)
    64    %34 = u2u64 %33
    64    %35 = ushr %34, %30 (0xe)
    32    %36 = unpack_64_2x32_split_x %35
    32    %37 = load_const (0x00003fff = 16383)
    32    %38 = iand %36, %37 (0x3fff)
    64    %39 = load_const (0x0000000000000010 = 16)
    64    %40 = iadd %0, %39 (0x10)
    32    %41 = @load_global_constant (%40) (access=none, align_mul=4, align_offset=0)
    32    %42 = load_const (0x000007ff = 2047)
    32    %43 = iand %41, %42 (0x7ff)
    32    %44 = u2u32 %2
    32    %45 = ineg %25
    32    %46 = iadd %29, %45
    1     %47 = uge %46, %44
    1     %48 = inot %1
    1     %49 = ior %48, %47
    32    %50 = u2u32 %4
    1     %51 = ige %44, %50
    1     %52 = iand %49, %51
    1     %53 = bcsel %3, %52, %49
    1     %54 = ieq %16, %8 (0x0)
    32    %55 = bcsel %54, %43, %38
    32    %56 = iadd %9 (0x1), %55
    1     %57 = ult %6, %56
    1     %58 = iand %53, %57
    1     %59 = bcsel %5, %58, %53
    32    %60 = load_const (0x0000fff0 = 0.000000 = 65520)
    32    %61 = bcsel %59, %7, %60 (0xfff0)
                @bindgen_return (%61)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[191] = {
    0x00000040, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000008, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00001001, 0x0000024a,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00001001, 0x0000024a,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000003f, 0xe40017e4,
    0x240117e4, 0xa40217e4, 0x240317e4, 0xa40417e4,
    0x240517e4, 0xc40617e4, 0xc40717e4, 0x00000e05,
    0x00003605, 0xc4005434, 0x00000008, 0x00000400,
    0xe42d1000, 0x00000000, 0x0000000c, 0x00009605,
    0xe42ef800, 0x00000000, 0x000e000d, 0xc42e8000,
    0x00000000, 0x0000000f, 0x00007605, 0xc429a800,
    0x00000000, 0x00110010, 0x00009705, 0xe4299000,
    0x00000000, 0x00130002, 0xc4005434, 0x00000050,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000015,
    0x00031605, 0xe42ef800, 0x00000000, 0x00170016,
    0xc42e8000, 0x00000000, 0x00000018, 0x0001f605,
    0xc429a800, 0x00000000, 0x001a0019, 0x00039605,
    0xe42ef800, 0x00000000, 0x001c0016, 0xc42e8000,
    0x00000000, 0x0000001d, 0xc429a800, 0x00000000,
    0x001a001e, 0x0001d605, 0x00019705, 0xe4299000,
    0x00000000, 0x00210002, 0xc4005434, 0x00000088,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000023,
    0xe42ef800, 0x00000000, 0x00200024, 0xc42e8000,
    0x00000000, 0x00000025, 0x07fff605, 0xc429a800,
    0x00000000, 0x00270026, 0x00021705, 0xe4299000,
    0x00000000, 0x00290002, 0xc4005434, 0x000000a8,
    0x00000400, 0x00fff605, 0xc429a800, 0x00000000,
    0x002c002b, 0xc42d0800, 0x00000000, 0x00000004,
    0xc42ae000, 0x00000000, 0x0000001b, 0xc4299000,
    0x00000000, 0x002f001f, 0x242d9800, 0x00000000,
    0x002e0030, 0x242ae800, 0x00000000, 0x00000003,
    0x242b0800, 0x00000000, 0x00310032, 0xc42d0800,
    0x00000000, 0x00000006, 0x242a0000, 0x00000000,
    0x0034002e, 0x2429a800, 0x00000000, 0x00350033,
    0x24239800, 0x00000000, 0x00360005, 0x00000033,
    0x2429d000, 0x00000000, 0x000a0012, 0xc4239800,
    0x00000000, 0x002d0038, 0x00000028, 0xc4299000,
    0x00000000, 0x0039000b, 0x242dc800, 0x00000000,
    0x003a0008, 0x2429a800, 0x00000000, 0x003b0037,
    0x24239800, 0x00000000, 0x003c0007, 0x00000037,
    0x1ffe1605, 0xc4239800, 0x00000000, 0x0009003d,
    0x0000003e, 0x00000304, 0x000000fc,
};
   nir_def *args[8] = { ptr, check_lod, lod, check_min_lod, min_lod, check_layer, layer, x };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_twiddle_coordinates(nir_builder *b, nir_def *coord, nir_def *tile_w_px, nir_def *tile_h_px, nir_def *aligned_width_px);

nir_def *
libagx_twiddle_coordinates(nir_builder *b, nir_def *coord, nir_def *tile_w_px, nir_def *tile_h_px, nir_def *aligned_width_px)
{
   /*
    block b0:   // preds:
    16x2   %0 = @load_param (param_idx=0)
    16     %1 = @load_param (param_idx=1)
    16     %2 = @load_param (param_idx=2)
    32     %3 = @load_param (param_idx=3)
    32     %4 = u2u32 %1
    32     %5 = load_const (0xffffffff = -1 = 4294967295)
    32     %6 = iadd %4, %5 (0xffffffff)
    16     %7 = u2u16 %6
    32     %8 = u2u32 %2
    32     %9 = iadd %8, %5 (0xffffffff)
    16    %10 = u2u16 %9
    16x2  %11 = vec2 %7, %10
    32    %12 = pack_32_2x16 %11
    32    %13 = pack_32_2x16 %0
    32    %14 = iand %13, %12
    16x2  %15 = unpack_32_2x16 %14
    32    %16 = interleave_agx %15.x, %15.y
    32    %17 = inot %12
    32    %18 = iand %13, %17
    16x2  %19 = unpack_32_2x16 %18
    32    %20 = u2u32 %19.y
    32    %21 = imul %20, %3
    32    %22 = u2u32 %19.x
    32    %23 = imul.nsw %22, %8
    32    %24 = iadd %21, %23
    32    %25 = iadd %24, %16
                @bindgen_return (%25)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[95] = {
    0x0000001c, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000004, 0x00001002, 0x0000028a,
    0x00000020, 0x00000000, 0x00001001, 0x0000024a,
    0x00000020, 0x00000000, 0x00001001, 0x0000024a,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000001b, 0xa80017e4,
    0xa40117e4, 0xa40217e4, 0xc40317e4, 0xc42d0800,
    0x00000000, 0x00000003, 0xfffff605, 0xc4299000,
    0x00000000, 0x00070006, 0xa42d0000, 0x00000000,
    0x00000008, 0xc42d0800, 0x00000000, 0x00000004,
    0xc4299000, 0x00000000, 0x0007000a, 0xa42d0000,
    0x00000000, 0x0000000b, 0xa82f2000, 0x00000000,
    0x000c0009, 0xc46ba800, 0x00000000, 0x0000000d,
    0x00000000, 0x00000002, 0xc429a800, 0x00000000,
    0x000e000f, 0xa82e5800, 0x00000000, 0x00000010,
    0xc42b0200, 0x00000000, 0x00110011, 0xc42ae800,
    0x00000000, 0x0000000e, 0xc429a800, 0x00000000,
    0x0013000f, 0xa82e5800, 0x00000000, 0x00000014,
    0xc42d0880, 0x00000000, 0x00000015, 0xc42a9000,
    0x00000000, 0x00050016, 0xc42d0800, 0x00000000,
    0x00000015, 0xc42a9020, 0x00000000, 0x000a0018,
    0xc4699000, 0x00000000, 0x00190017, 0x00000000,
    0x0012001a, 0x00000304, 0x0000006c,
};
   nir_def *args[4] = { coord, tile_w_px, tile_h_px, aligned_width_px };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_image_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *sample_idx, nir_def *bytes_per_sample_B, nir_def *is_1d, nir_def *is_msaa, nir_def *is_layered, nir_def *return_index);

nir_def *
libagx_image_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *sample_idx, nir_def *bytes_per_sample_B, nir_def *is_1d, nir_def *is_msaa, nir_def *is_layered, nir_def *return_index)
{
   /*
    block b0:    // preds:
    64      %0 = @load_param (param_idx=0)
    32x4    %1 = @load_param (param_idx=1)
    32      %2 = @load_param (param_idx=2)
    32      %3 = @load_param (param_idx=3)
    1       %4 = @load_param (param_idx=4)
    1       %5 = @load_param (param_idx=5)
    1       %6 = @load_param (param_idx=6)
    1       %7 = @load_param (param_idx=7)
    32      %8 = load_const (0x00000000)
    32      %9 = load_const (0x00000001)
    32     %10 = @load_global_constant (%0) (access=none, align_mul=4, align_offset=0)
    64     %11 = u2u64 %10
    64     %12 = load_const (0x0000000000000004)
    64     %13 = iadd %0, %12 (0x4)
    32     %14 = @load_global_constant (%13) (access=none, align_mul=4, align_offset=0)
    64     %15 = u2u64 %14
    32     %16 = load_const (0x00000020 = 32)
    64     %17 = ishl %15, %16 (0x20)
    64     %18 = ior %11, %17
    32     %19 = load_const (0x00000018 = 24)
    64     %20 = ushr %18, %19 (0x18)
    32     %21 = unpack_64_2x32_split_x %20
    32     %22 = load_const (0x00003fff = 16383)
    32     %23 = iand %21, %22 (0x3fff)
    32     %24 = iadd %23, %9 (0x1)
    32     %25 = load_const (0x00000004)
    64     %26 = load_const (0x0000000000000008)
    64     %27 = iadd %0, %26 (0x8)
    32     %28 = @load_global_constant (%27) (access=none, align_mul=4, align_offset=0)
    64     %29 = u2u64 %28
    64     %30 = load_const (0x000000000000000c = 12)
    64     %31 = iadd %0, %30 (0xc)
    32     %32 = @load_global_constant (%31) (access=none, align_mul=4, align_offset=0)
    64     %33 = u2u64 %32
    64     %34 = ishl %33, %16 (0x20)
    64     %35 = ior %29, %34
    32     %36 = unpack_64_2x32_split_x %35
    32     %37 = unpack_64_2x32_split_y %35
    32     %38 = load_const (0x0000000f = 15)
    32     %39 = iand %37, %38 (0xf)
    64     %40 = pack_64_2x32_split %36, %39
    64     %41 = ishl %40, %25 (0x4)
    32     %42 = load_const (0x00000003)
    64     %43 = ushr %33, %25 (0x4)
    32     %44 = unpack_64_2x32_split_x %43
    32     %45 = iand %44, %38 (0xf)
    32     %46 = load_const (0x00000007)
    64     %47 = load_const (0x0000000000000010 = 16)
    64     %48 = iadd %0, %47 (0x10)
    32     %49 = @load_global_constant (%48) (access=none, align_mul=4, align_offset=0)
    32     %50 = load_const (0x07ffffff = 134217727)
    32     %51 = iand %49, %50 (0x7ffffff)
    64     %52 = pack_64_2x32_split %51, %8 (0x0)
    64     %53 = ishl %52, %46 (0x7)
    32     %54 = u2u32 %53
    32     %55 = load_const (0x00007fff = 32767)
    32     %56 = iand %49, %55 (0x7fff)
    64     %57 = u2u64 %49
    64     %58 = ushr %57, %38 (0xf)
    32     %59 = unpack_64_2x32_split_x %58
    32     %60 = iand %59, %42 (0x3)
    32     %61 = load_const (0x0000001b = 27)
    64     %62 = ushr %57, %61 (0x1b)
    32     %63 = unpack_64_2x32_split_x %62
    32     %64 = iand %63, %38 (0xf)
    32     %65 = ishl %9 (0x1), %64
    64     %66 = load_const (0x0000000000000014 = 20)
    64     %67 = iadd %0, %66 (0x14)
    32     %68 = @load_global_constant (%67) (access=none, align_mul=4, align_offset=0)
    64     %69 = u2u64 %68
    64     %70 = ishl %69, %16 (0x20)
    64     %71 = ior %57, %70
    32     %72 = load_const (0x0000001f = 31)
    64     %73 = ushr %71, %72 (0x1f)
    32     %74 = unpack_64_2x32_split_x %73
    32     %75 = iand %74, %38 (0xf)
    32     %76 = ishl %9 (0x1), %75
    64     %77 = ushr %69, %42 (0x3)
    32     %78 = unpack_64_2x32_split_x %77
    32     %79 = iand %78, %50 (0x7ffffff)
    64     %80 = pack_64_2x32_split %79, %8 (0x0)
    64     %81 = ishl %80, %46 (0x7)
    32     %82 = u2u32 %81
    32     %83 = ushr %24, %45
    32     %84 = umax %83, %9 (0x1)
    32     %85 = load_const (0xffffffff = -1 = 4294967295)
    32     %86 = iadd %84, %85 (0xffffffff)
    32     %87 = iadd %86, %65
    32     %88 = iadd %65, %85 (0xffffffff)
    32     %89 = inot %88
    32     %90 = iand %87, %89
    32     %91 = bcsel %5, %56, %90
    16x2   %92 = u2u16 %1.xy
    16     %93 = u2u16 %76
    16     %94 = u2u16 %88
    32     %95 = u2u32 %93
    32     %96 = iadd %76, %85 (0xffffffff)
    16     %97 = u2u16 %96
    16x2   %98 = vec2 %94, %97
    32     %99 = pack_32_2x16 %98
    32    %100 = pack_32_2x16 %92
    32    %101 = iand %100, %99
    16x2  %102 = unpack_32_2x16 %101
    32    %103 = interleave_agx %102.x, %102.y
    32    %104 = inot %99
    32    %105 = iand %100, %104
    16x2  %106 = unpack_32_2x16 %105
    32    %107 = u2u32 %106.y
    32    %108 = imul %107, %91
    32    %109 = u2u32 %106.x
    32    %110 = imul.nsw %109, %95
    32    %111 = iadd %108, %110
    32    %112 = iadd %111, %103
    32    %113 = bcsel %4, %1.x, %112
    32    %114 = bcsel %5, %60, %8 (0x0)
    32    %115 = bcsel %4, %1.y, %1.z
    32    %116 = udiv %82, %3
    32    %117 = ushr %116, %114
    32    %118 = imul %115, %117
    32    %119 = iadd %113, %118
    32    %120 = bcsel %6, %119, %113
    32    %121 = ishl %120, %114
    32    %122 = iadd %121, %2
    32    %123 = bcsel %5, %8 (0x0), %54
    64    %124 = u2u64 %123
    64    %125 = iadd %41, %124
    64    %126 = u2u64 %122
    64    %127 = u2u64 %3
    64    %128 = imul %126, %127
    64    %129 = iadd %125, %128
    64    %130 = bcsel %7, %126, %129
                 @bindgen_return (%130)
                 // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[386] = {
    0x00000085, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000008, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000084, 0xe40017e4,
    0xd00117e4, 0xc40217e4, 0xc40317e4, 0x240417e4,
    0x240517e4, 0x240617e4, 0x240717e4, 0x00000e05,
    0x00003605, 0xc4005434, 0x00000008, 0x00000400,
    0xe42d1000, 0x00000000, 0x0000000c, 0x00009705,
    0xe4299000, 0x00000000, 0x000e0002, 0xc4005434,
    0x0000003c, 0x00000400, 0xe42d1000, 0x00000000,
    0x00000010, 0x00041605, 0xe42b2000, 0x00000000,
    0x00120011, 0xe42b0800, 0x00000000, 0x0013000d,
    0x00031605, 0xe42ef800, 0x00000000, 0x00150014,
    0xc42e8000, 0x00000000, 0x00000016, 0x07fff605,
    0xc429a800, 0x00000000, 0x00180017, 0xc4299000,
    0x00000000, 0x000b0019, 0x00009605, 0x00011705,
    0xe4299000, 0x00000000, 0x001c0002, 0xc4005434,
    0x00000074, 0x00000400, 0xe42d1000, 0x00000000,
    0x0000001e, 0x00019705, 0xe4299000, 0x00000000,
    0x00200002, 0xc4005434, 0x00000084, 0x00000400,
    0xe42d1000, 0x00000000, 0x00000022, 0xe42b2000,
    0x00000000, 0x00120023, 0xe42b0800, 0x00000000,
    0x0024001f, 0xc42e8000, 0x00000000, 0x00000025,
    0xc42e8800, 0x00000000, 0x00000025, 0x0001f605,
    0xc429a800, 0x00000000, 0x00280027, 0xe42be000,
    0x00000000, 0x00290026, 0xe42b2000, 0x00000000,
    0x001b002a, 0x00007605, 0xe42ef800, 0x00000000,
    0x001b0023, 0xc42e8000, 0x00000000, 0x0000002d,
    0xc429a800, 0x00000000, 0x0028002e, 0x0000f605,
    0x00021705, 0xe4299000, 0x00000000, 0x00310002,
    0xc4005434, 0x000000c8, 0x00000400, 0x00000605,
    0x07ffffff, 0xc429a800, 0x00000000, 0x00340033,
    0xe42be000, 0x00000000, 0x000a0035, 0xe42b2000,
    0x00000000, 0x00300036, 0xc42d0800, 0x00000000,
    0x00000037, 0x0ffff605, 0xc429a800, 0x00000000,
    0x00390033, 0xe42d1000, 0x00000000, 0x00000033,
    0xe42ef800, 0x00000000, 0x0028003b, 0xc42e8000,
    0x00000000, 0x0000003c, 0xc429a800, 0x00000000,
    0x002c003d, 0x00037605, 0xe42ef800, 0x00000000,
    0x003f003b, 0xc42e8000, 0x00000000, 0x00000040,
    0xc429a800, 0x00000000, 0x00280041, 0xc42b2000,
    0x00000000, 0x0042000b, 0x00029705, 0xe4299000,
    0x00000000, 0x00440002, 0xc4005434, 0x00000114,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000046,
    0xe42b2000, 0x00000000, 0x00120047, 0xe42b0800,
    0x00000000, 0x0048003b, 0x0003f605, 0xe42ef800,
    0x00000000, 0x004a0049, 0xc42e8000, 0x00000000,
    0x0000004b, 0xc429a800, 0x00000000, 0x0028004c,
    0xc42b2000, 0x00000000, 0x004d000b, 0xe42ef800,
    0x00000000, 0x002c0047, 0xc42e8000, 0x00000000,
    0x0000004f, 0xc429a800, 0x00000000, 0x00340050,
    0xe42be000, 0x00000000, 0x000a0051, 0xe42b2000,
    0x00000000, 0x00300052, 0xc42d0800, 0x00000000,
    0x00000053, 0xc42ef800, 0x00000000, 0x002f001a,
    0xc42df800, 0x00000000, 0x000b0055, 0xfffff605,
    0xc4a99000, 0x00000000, 0x00570056, 0x00000000,
    0x00430058, 0x00000000, 0x00570043, 0xc42ae800,
    0x00000000, 0x0000005a, 0xc429a800, 0x00000000,
    0x005b0059, 0xc4239800, 0x00000000, 0x003a0007,
    0x0000005c, 0xa82d0000, 0x00000000, 0x00000003,
    0xa46d0000, 0x00000000, 0x0000004e, 0x00000000,
    0x0000005a, 0xc42d0800, 0x00000000, 0x0000005f,
    0xc4299000, 0x00000000, 0x0057004e, 0xa42d0000,
    0x00000000, 0x00000062, 0xa82f2000, 0x00000000,
    0x00630060, 0xc46ba800, 0x00000000, 0x00000064,
    0x00000000, 0x0000005e, 0xc429a800, 0x00000000,
    0x00650066, 0xa82e5800, 0x00000000, 0x00000067,
    0xc42b0200, 0x00000000, 0x00680068, 0xc42ae800,
    0x00000000, 0x00000065, 0xc429a800, 0x00000000,
    0x006a0066, 0xa82e5800, 0x00000000, 0x0000006b,
    0xc42d0880, 0x00000000, 0x0000006c, 0xc42a9000,
    0x00000000, 0x005d006d, 0xc42d0800, 0x00000000,
    0x0000006c, 0xc42a9020, 0x00000000, 0x0061006f,
    0xc4699000, 0x00000000, 0x0070006e, 0x00000000,
    0x00690071, 0xc4639800, 0x00000000, 0x00030006,
    0x00000072, 0x00000000, 0x003e0007, 0x0000000a,
    0xc4039800, 0x00000000, 0x00000018, 0x0100000c,
    0x0200000c, 0xc42d5800, 0x00000000, 0x00050054,
    0xc42ef800, 0x00000000, 0x00740076, 0xc42a9000,
    0x00000000, 0x00770075, 0xc4299000, 0x00000000,
    0x00780073, 0xc4239800, 0x00000000, 0x00790008,
    0x00000073, 0xc42b2000, 0x00000000, 0x0074007a,
    0xc4299000, 0x00000000, 0x0004007b, 0xc4239800,
    0x00000000, 0x000a0007, 0x00000038, 0xe42d1000,
    0x00000000, 0x0000007d, 0xe4299000, 0x00000000,
    0x007e002b, 0xe46d1000, 0x00000000, 0x0000007c,
    0x00000000, 0x00000005, 0xe42a9000, 0x00000000,
    0x00810080, 0xe4299000, 0x00000000, 0x0082007f,
    0xe4239800, 0x00000000, 0x00800009, 0x00000083,
    0x00000304, 0x00000210,
};
   nir_def *args[8] = { ptr, coord, sample_idx, bytes_per_sample_B, is_1d, is_msaa, is_layered, return_index };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_buffer_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *bytes_per_pixel_B);

nir_def *
libagx_buffer_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *bytes_per_pixel_B)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32x4   %1 = @load_param (param_idx=1)
    32     %2 = @load_param (param_idx=2)
    64     %3 = load_const (0x0000000000000008)
    64     %4 = iadd %0, %3 (0x8)
    32     %5 = @load_global_constant (%4) (access=none, align_mul=4, align_offset=0)
    64     %6 = u2u64 %5
    64     %7 = load_const (0x000000000000000c = 12)
    64     %8 = iadd %0, %7 (0xc)
    32     %9 = @load_global_constant (%8) (access=none, align_mul=4, align_offset=0)
    64    %10 = u2u64 %9
    32    %11 = load_const (0x00000020 = 32)
    64    %12 = ishl %10, %11 (0x20)
    64    %13 = ior %6, %12
    32    %14 = load_const (0x00000004)
    32    %15 = unpack_64_2x32_split_x %13
    32    %16 = unpack_64_2x32_split_y %13
    32    %17 = load_const (0x0000000f = 15)
    32    %18 = iand %16, %17 (0xf)
    64    %19 = pack_64_2x32_split %15, %18
    64    %20 = ishl %19, %14 (0x4)
    64    %21 = load_const (0x0000000000000010 = 16)
    64    %22 = iadd %0, %21 (0x10)
    32    %23 = @load_global_constant (%22) (access=none, align_mul=4, align_offset=0)
    32    %24 = iadd %23, %1.x
    32    %25 = imul %24, %2
    64    %26 = u2u64 %25
    64    %27 = iadd %20, %26
                @bindgen_return (%27)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[91] = {
    0x0000001e, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002004, 0x00000300,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000001d, 0xe40017e4,
    0xd00117e4, 0xc40217e4, 0x00011705, 0xe4299000,
    0x00000000, 0x00050002, 0xc4005434, 0x00000018,
    0x00000400, 0xe42d1000, 0x00000000, 0x00000007,
    0x00019705, 0xe4299000, 0x00000000, 0x00090002,
    0xc4005434, 0x00000028, 0x00000400, 0xe42d1000,
    0x00000000, 0x0000000b, 0x00041605, 0xe42b2000,
    0x00000000, 0x000d000c, 0xe42b0800, 0x00000000,
    0x000e0008, 0x00009605, 0xc42e8000, 0x00000000,
    0x0000000f, 0xc42e8800, 0x00000000, 0x0000000f,
    0x0001f605, 0xc429a800, 0x00000000, 0x00130012,
    0xe42be000, 0x00000000, 0x00140011, 0xe42b2000,
    0x00000000, 0x00100015, 0x00021705, 0xe4299000,
    0x00000000, 0x00170002, 0xc4005434, 0x00000060,
    0x00000400, 0xc4299000, 0x00000000, 0x00030019,
    0xc42a9000, 0x00000000, 0x0004001a, 0xe42d1000,
    0x00000000, 0x0000001b, 0xe4299000, 0x00000000,
    0x001c0016, 0x00000304, 0x00000074,
};
   nir_def *args[3] = { ptr, coord, bytes_per_pixel_B };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_texture_is_rgb32(nir_builder *b, nir_def *ptr);

nir_def *
libagx_texture_is_rgb32(nir_builder *b, nir_def *ptr)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_global_constant (%0) (access=none, align_mul=4, align_offset=0)
    64     %2 = u2u64 %1
    32     %3 = load_const (0x00000006)
    64     %4 = ushr %2, %3 (0x6)
    32     %5 = unpack_64_2x32_split_x %4
    32     %6 = load_const (0x0000007f = 127)
    32     %7 = iand %5, %6 (0x7f)
    32     %8 = load_const (0x00000036 = 54)
    1      %9 = ieq %7, %8 (0x36)
                @bindgen_return (%9)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[39] = {
    0x0000000c, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x0000000b, 0xe40017e4,
    0xc4005434, 0x00000008, 0x00000400, 0xe42d1000,
    0x00000000, 0x00000003, 0x0000d605, 0xe42ef800,
    0x00000000, 0x00050004, 0xc42e8000, 0x00000000,
    0x00000006, 0x000ff605, 0xc429a800, 0x00000000,
    0x00080007, 0x0006d605, 0x2429d000, 0x00000000,
    0x000a0009, 0x00000304, 0x0000002c,
};
   nir_def *args[1] = { ptr };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_texture_load_rgb32(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *is_float);

nir_def *
libagx_texture_load_rgb32(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *is_float)
{
   /*
    block b0:   // preds:
    64     %0 = @load_param (param_idx=0)
    32     %1 = @load_param (param_idx=1)
    1      %2 = @load_param (param_idx=2)
    32     %3 = load_const (0x00000003)
    32     %4 = load_const (0x00000001 = 0.000000)
    32     %5 = load_const (0x00000002)
    64     %6 = load_const (0x0000000000000008)
    64     %7 = iadd %0, %6 (0x8)
    32     %8 = @load_global_constant (%7) (access=none, align_mul=4, align_offset=0)
    64     %9 = u2u64 %8
    64    %10 = load_const (0x000000000000000c = 12)
    64    %11 = iadd %0, %10 (0xc)
    32    %12 = @load_global_constant (%11) (access=none, align_mul=4, align_offset=0)
    64    %13 = u2u64 %12
    32    %14 = load_const (0x00000020 = 32)
    64    %15 = ishl %13, %14 (0x20)
    64    %16 = ior %9, %15
    32    %17 = load_const (0x00000004)
    64    %18 = ushr %16, %5 (0x2)
    32    %19 = unpack_64_2x32_split_x %18
    32    %20 = unpack_64_2x32_split_y %18
    32    %21 = load_const (0x0000000f = 15)
    32    %22 = iand %20, %21 (0xf)
    64    %23 = pack_64_2x32_split %19, %22
    64    %24 = ishl %23, %17 (0x4)
    32    %25 = imul %1, %3 (0x3)
    64    %26 = u2u64 %25
    64    %27 = ishl %26, %5 (0x2)
    64    %28 = iadd %24, %27
    32x3  %29 = @load_global_constant (%28) (access=none, align_mul=16, align_offset=0)
    32    %30 = load_const (0x3f800000 = 1.000000 = 1065353216)
    32    %31 = bcsel %2, %30 (0x3f800000), %4 (0x1)
    32x4  %32 = vec4 %29.x, %29.y, %29.z, %31
                @bindgen_return (%32)
                // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[104] = {
    0x00000023, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000003, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000101, 0x0000024e,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000022, 0xe40017e4,
    0xc40117e4, 0x240217e4, 0x00007605, 0x00003605,
    0x00005605, 0x00011705, 0xe4299000, 0x00000000,
    0x00080002, 0xc4005434, 0x00000024, 0x00000400,
    0xe42d1000, 0x00000000, 0x0000000a, 0x00019705,
    0xe4299000, 0x00000000, 0x000c0002, 0xc4005434,
    0x00000034, 0x00000400, 0xe42d1000, 0x00000000,
    0x0000000e, 0x00041605, 0xe42b2000, 0x00000000,
    0x0010000f, 0xe42b0800, 0x00000000, 0x0011000b,
    0x00009605, 0xe42ef800, 0x00000000, 0x00070012,
    0xc42e8000, 0x00000000, 0x00000014, 0xc42e8800,
    0x00000000, 0x00000014, 0x0001f605, 0xc429a800,
    0x00000000, 0x00170016, 0xe42be000, 0x00000000,
    0x00180015, 0xe42b2000, 0x00000000, 0x00130019,
    0xc42a9000, 0x00000000, 0x00050003, 0xe42d1000,
    0x00000000, 0x0000001b, 0xe42b2000, 0x00000000,
    0x0007001c, 0xe4299000, 0x00000000, 0x001d001a,
    0xcc005434, 0x00000078, 0x00001000, 0x3f800e05,
    0xc4239800, 0x00000000, 0x00200004, 0x00000006,
    0xd00f3000, 0x00000000, 0xe400007c, 0xe500007c,
    0xe600007c, 0x00000084, 0x00000304, 0x00000088,
};
   nir_def *args[3] = { ptr, coord, is_float };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_buffer_texture_offset(nir_builder *b, nir_def *ptr, nir_def *x);

nir_def *
libagx_buffer_texture_offset(nir_builder *b, nir_def *ptr, nir_def *x)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    32    %1 = @load_param (param_idx=1)
    64    %2 = load_const (0x0000000000000014 = 20)
    64    %3 = iadd %0, %2 (0x14)
    32    %4 = @load_global_constant (%3) (access=none, align_mul=4, align_offset=0)
    32    %5 = iadd %1, %4
               @bindgen_return (%5)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[33] = {
    0x00000008, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000007, 0xe40017e4,
    0xc40117e4, 0x00029705, 0xe4299000, 0x00000000,
    0x00040002, 0xc4005434, 0x00000014, 0x00000400,
    0xc4299000, 0x00000000, 0x00060003, 0x00000304,
    0x0000001c,
};
   nir_def *args[2] = { ptr, x };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

nir_def *
libagx_buffer_image_offset(nir_builder *b, nir_def *ptr, nir_def *x);

nir_def *
libagx_buffer_image_offset(nir_builder *b, nir_def *ptr, nir_def *x)
{
   /*
    block b0:  // preds:
    64    %0 = @load_param (param_idx=0)
    32    %1 = @load_param (param_idx=1)
    64    %2 = load_const (0x0000000000000010 = 16)
    64    %3 = iadd %0, %2 (0x10)
    32    %4 = @load_global_constant (%3) (access=none, align_mul=4, align_offset=0)
    32    %5 = iadd %1, %4
               @bindgen_return (%5)
               // succs: b1
    block b1:
   */
   static const uint32_t impl_0_nir[33] = {
    0x00000008, 0x00000028, 0x00000000, 0x00000000,
    0x00000000, 0x00000002, 0x00004001, 0x0000024c,
    0x00000020, 0x00000000, 0x00002001, 0x00000240,
    0x00000020, 0x00000000, 0x00000001, 0x00000000,
    0x00000001, 0x00000000, 0x00000007, 0xe40017e4,
    0xc40117e4, 0x00021705, 0xe4299000, 0x00000000,
    0x00040002, 0xc4005434, 0x00000014, 0x00000400,
    0xc4299000, 0x00000000, 0x00060003, 0x00000304,
    0x0000001c,
};
   nir_def *args[2] = { ptr, x };
   return nir_call_serialized(b, impl_0_nir, sizeof(impl_0_nir), args);
}

#ifdef __cplusplus
} /* extern C */
#endif
namespace {
   struct vtn_bindgen_dummy {
      vtn_bindgen_dummy() {
         /* Format strings:
          *
          * FATAL: GPU heap overflow, allocating size %u, at offset %u, heap size %u!
          * FATAL: GPU heap overflow, allocating size %u, at offset %u, heap size %u!
          * FATAL: GPU heap overflow, allocating size %u, at offset %u, heap size %u!
          * FATAL: GPU heap overflow, allocating size %u, at offset %u, heap size %u!
          */
const uint32_t printf_0_blob[97] = {
    0x00000004, 0x00000003, 0x0000004a, 0x00000004,
    0x00000004, 0x00000004, 0x41544146, 0x47203a4c,
    0x68205550, 0x20706165, 0x7265766f, 0x776f6c66,
    0x6c61202c, 0x61636f6c, 0x676e6974, 0x7a697320,
    0x75252065, 0x7461202c, 0x66666f20, 0x20746573,
    0x202c7525, 0x70616568, 0x7a697320, 0x75252065,
    0x00000021, 0x00000003, 0x0000004a, 0x00000004,
    0x00000004, 0x00000004, 0x41544146, 0x47203a4c,
    0x68205550, 0x20706165, 0x7265766f, 0x776f6c66,
    0x6c61202c, 0x61636f6c, 0x676e6974, 0x7a697320,
    0x75252065, 0x7461202c, 0x66666f20, 0x20746573,
    0x202c7525, 0x70616568, 0x7a697320, 0x75252065,
    0x00000021, 0x00000003, 0x0000004a, 0x00000004,
    0x00000004, 0x00000004, 0x41544146, 0x47203a4c,
    0x68205550, 0x20706165, 0x7265766f, 0x776f6c66,
    0x6c61202c, 0x61636f6c, 0x676e6974, 0x7a697320,
    0x75252065, 0x7461202c, 0x66666f20, 0x20746573,
    0x202c7525, 0x70616568, 0x7a697320, 0x75252065,
    0x00000021, 0x00000003, 0x0000004a, 0x00000004,
    0x00000004, 0x00000004, 0x41544146, 0x47203a4c,
    0x68205550, 0x20706165, 0x7265766f, 0x776f6c66,
    0x6c61202c, 0x61636f6c, 0x676e6974, 0x7a697320,
    0x75252065, 0x7461202c, 0x66666f20, 0x20746573,
    0x202c7525, 0x70616568, 0x7a697320, 0x75252065, 0x00000021,
};
         u_printf_singleton_init_or_ref();
         u_printf_singleton_add_serialized((const void*)printf_0_blob, sizeof(printf_0_blob));
      }

      ~vtn_bindgen_dummy() {
         u_printf_singleton_decref();
      }
   };

   static vtn_bindgen_dummy vtn_bindgen_dummy_instance;
}
