/* Copyright 2024 Collabora Ltd.
 * SPDX-License-Identifier: MIT
 */

#ifndef NIL_FORMAT_TABLE_H
#define NIL_FORMAT_TABLE_H

#include "util/format/u_format.h"

enum nil_format_support_flags {
   NIL_FORMAT_SUPPORTS_TEXTURE_BIT        = BITFIELD_BIT(0),
   NIL_FORMAT_SUPPORTS_BUFFER_BIT         = BITFIELD_BIT(1),
   NIL_FORMAT_SUPPORTS_STORAGE_BIT        = BITFIELD_BIT(2),
   NIL_FORMAT_SUPPORTS_RENDER_BIT         = BITFIELD_BIT(3),
   NIL_FORMAT_SUPPORTS_ALPHA_BLEND_BIT    = BITFIELD_BIT(4),
   NIL_FORMAT_SUPPORTS_DEPTH_STENCIL_BIT  = BITFIELD_BIT(5),
   NIL_FORMAT_SUPPORTS_SCANOUT_BIT        = BITFIELD_BIT(6),
};

struct nil_tic_format {
   unsigned comp_sizes:8;
   unsigned type_r:3;
   unsigned type_g:3;
   unsigned type_b:3;
   unsigned type_a:3;
   unsigned src_x:3;
   unsigned src_y:3;
   unsigned src_z:3;
   unsigned src_w:3;
};

struct nil_format_info {
   unsigned czt:8;
   unsigned support:24;
   struct nil_tic_format tic;
};

extern const struct nil_format_info nil_format_table[PIPE_FORMAT_COUNT];

#endif /* NIL_FORMAT_TABLE_H */
