#ifndef NIL_H
#define NIL_H

/* Warning, this file is autogenerated by cbindgen. Don't modify this manually. */

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include "nouveau/headers/nv_device_info.h"
#include "util/format/u_format.h"
#include "drm-uapi/drm_fourcc.h"

#define NIL_MAX_LEVELS 16

#define NIL_MAX_DRM_FORMAT_MODS 7

#define nil_DRM_FORMAT_MOD_LINEAR 0

#define nil_DRM_FORMAT_MOD_INVALID 72057594037927935

enum nil_gob_type {
  NIL_GOB_TYPE_LINEAR,
  NIL_GOB_TYPE_FERMI8,
};
typedef uint8_t nil_gob_type;

enum nil_image_dim {
  NIL_IMAGE_DIM_1D = 1,
  NIL_IMAGE_DIM_2D = 2,
  NIL_IMAGE_DIM_3D = 3,
};
typedef uint8_t nil_image_dim;

enum nil_sample_layout {
  NIL_SAMPLE_LAYOUT_1X1,
  NIL_SAMPLE_LAYOUT_2X1,
  NIL_SAMPLE_LAYOUT_2X1_D3D,
  NIL_SAMPLE_LAYOUT_2X2,
  NIL_SAMPLE_LAYOUT_4X2,
  NIL_SAMPLE_LAYOUT_4X2_D3D,
  NIL_SAMPLE_LAYOUT_4X4,
  NIL_SAMPLE_LAYOUT_INVALID,
};
typedef uint8_t nil_sample_layout;

enum nil_view_type {
  NIL_VIEW_TYPE_1D,
  NIL_VIEW_TYPE_2D,
  NIL_VIEW_TYPE_3D,
  NIL_VIEW_TYPE_3D_SLICED,
  NIL_VIEW_TYPE_CUBE,
  NIL_VIEW_TYPE_1D_ARRAY,
  NIL_VIEW_TYPE_2D_ARRAY,
  NIL_VIEW_TYPE_CUBE_ARRAY,
};
typedef uint8_t nil_view_type;

struct nil_Extent4D_Bytes {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Offset4D_Bytes {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_tiling {
  /**
   * GOB type
   */
  nil_gob_type gob_type;
  /**
   * log2 of the X tile dimension in GOBs
   */
  uint8_t x_log2;
  /**
   * log2 of the Y tile dimension in GOBs
   */
  uint8_t y_log2;
  /**
   * log2 of the z tile dimension in GOBs
   */
  uint8_t z_log2;
};

struct nil_Extent4D_Elements {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Extent4D_Pixels {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_format {
  enum pipe_format p_format;
};

struct nil_Extent4D_Tiles {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_Offset4D_Elements {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Offset4D_Pixels {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Offset4D_Tiles {
  uint32_t x;
  uint32_t y;
  uint32_t z;
  uint32_t a;
};

struct nil_Extent4D_Samples {
  uint32_t width;
  uint32_t height;
  uint32_t depth;
  uint32_t array_len;
};

struct nil_sample_offset {
  uint8_t x;
  uint8_t y;
};

/**
 * Represents the data layout of a single slice (level + lod) of an image.
 */
struct nil_image_level {
  uint64_t offset_B;
  struct nil_tiling tiling;
  uint32_t row_stride_B;
};

struct nil_image {
  nil_image_dim dim;
  struct nil_format format;
  struct nil_Extent4D_Pixels extent_px;
  nil_sample_layout sample_layout;
  uint32_t num_levels;
  uint32_t mip_tail_first_lod;
  struct nil_image_level levels[NIL_MAX_LEVELS];
  uint64_t array_stride_B;
  uint32_t align_B;
  uint64_t size_B;
  bool compressed;
  uint16_t tile_mode;
  uint8_t pte_kind;
};

typedef uint8_t nil_image_usage_flags;

struct nil_image_init_info {
  nil_image_dim dim;
  struct nil_format format;
  struct nil_Extent4D_Pixels extent_px;
  uint32_t levels;
  uint32_t samples;
  nil_image_usage_flags usage;
  uint64_t modifier;
  uint32_t explicit_row_stride_B;
};

struct nil_view {
  nil_view_type view_type;
  /**
   * The format to use in the view
   *
   * This may differ from the format of the actual isl_surf but must have the
   * same block size.
   */
  struct nil_format format;
  uint32_t base_level;
  uint32_t num_levels;
  /**
   * Base array layer
   *
   * For cube maps, both base_array_layer and array_len should be specified in
   * terms of 2-D layers and must be a multiple of 6.
   */
  uint32_t base_array_layer;
  /**
   * Array Length
   *
   * Indicates the number of array elements starting at  Base Array Layer.
   */
  uint32_t array_len;
  enum pipe_swizzle swizzle[4];
  float min_lod_clamp;
};

#define NIL_IMAGE_USAGE_2D_VIEW_BIT (1 << 0)

#define NIL_IMAGE_USAGE_LINEAR_BIT (1 << 1)

#define NIL_IMAGE_USAGE_SPARSE_RESIDENCY_BIT (1 << 2)

void nil_copy_linear_to_tiled(void *tiled_dst,
                              struct nil_Extent4D_Bytes level_extent_B,
                              const void *linear_src,
                              size_t linear_row_stride_B,
                              size_t linear_plane_stride_B,
                              struct nil_Offset4D_Bytes offset_B,
                              struct nil_Extent4D_Bytes extent_B,
                              const struct nil_tiling *tiling);

void nil_copy_tiled_to_linear(void *linear_dst,
                              size_t linear_row_stride_B,
                              size_t linear_plane_stride_B,
                              const void *tiled_src,
                              struct nil_Extent4D_Bytes level_extent_B,
                              struct nil_Offset4D_Bytes offset_B,
                              struct nil_Extent4D_Bytes extent_B,
                              const struct nil_tiling *tiling);

struct nil_Extent4D_Elements nil_extent4d_px_to_el(struct nil_Extent4D_Pixels extent_px,
                                                   struct nil_format format,
                                                   nil_sample_layout sample_layout);

struct nil_Extent4D_Tiles nil_extent4d_px_to_tl(struct nil_Extent4D_Pixels extent_px,
                                                const struct nil_tiling *tiling,
                                                struct nil_format format,
                                                nil_sample_layout sample_layout);

struct nil_Extent4D_Bytes nil_extent4d_px_to_B(struct nil_Extent4D_Pixels extent_px,
                                               struct nil_format format,
                                               nil_sample_layout sample_layout);

struct nil_Offset4D_Elements nil_offset4d_px_to_el(struct nil_Offset4D_Pixels offset,
                                                   struct nil_format format,
                                                   nil_sample_layout sample_layout);

struct nil_Offset4D_Tiles nil_offset4d_px_to_tl(struct nil_Offset4D_Pixels offset,
                                                const struct nil_tiling *tiling,
                                                struct nil_format format,
                                                nil_sample_layout sample_layout);

struct nil_Offset4D_Bytes nil_offset4d_px_to_B(struct nil_Offset4D_Pixels offset,
                                               struct nil_format format,
                                               nil_sample_layout sample_layout);

bool nil_format_supports_texturing(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_filtering(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_buffer(const struct nv_device_info *_dev, enum pipe_format p_format);

bool nil_format_supports_storage(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_color_targets(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_blending(const struct nv_device_info *dev, enum pipe_format p_format);

bool nil_format_supports_depth_stencil(const struct nv_device_info *dev, enum pipe_format p_format);

uint32_t nil_format_to_color_target(enum pipe_format p_format);

uint32_t nil_format_to_depth_stencil(enum pipe_format p_format);

struct nil_format nil_format(enum pipe_format p_format);

nil_sample_layout nil_choose_sample_layout(uint32_t samples);

uint32_t nil_sample_layout_samples(nil_sample_layout self);

struct nil_Extent4D_Samples nil_px_extent_sa(nil_sample_layout self);

struct nil_sample_offset nil_sample_offset(nil_sample_layout self, uint8_t s);

struct nil_image nil_image_new(const struct nv_device_info *dev,
                               const struct nil_image_init_info *info);

struct nil_Extent4D_Pixels nil_image_level_extent_px(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_layer_offset_B(const struct nil_image *self,
                                        uint32_t level,
                                        uint32_t layer);

uint64_t nil_image_mip_tail_offset_B(const struct nil_image *self);

uint32_t nil_image_mip_tail_size_B(const struct nil_image *self);

struct nil_Extent4D_Samples nil_image_level_extent_sa(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_layer_size_B(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_size_B(const struct nil_image *self, uint32_t level);

uint64_t nil_image_level_depth_stride_B(const struct nil_image *self, uint32_t level);

struct nil_image nil_image_for_level(const struct nil_image *self,
                                     uint32_t level,
                                     uint64_t *offset_in_bytes_out);

struct nil_image nil_image_level_as_uncompressed(const struct nil_image *self,
                                                 uint32_t level,
                                                 uint64_t *offset_in_bytes_out);

struct nil_image nil_image_3d_level_as_2d_array(const struct nil_image *self,
                                                uint32_t level,
                                                uint64_t *offset_in_bytes_out);

struct nil_image nil_msaa_image_as_sa(const struct nil_image *self);

uint64_t nil_image_level_z_offset_B(const struct nil_image *self, uint32_t level, uint32_t z);

void nil_drm_format_mods_for_format(const struct nv_device_info *dev,
                                    struct nil_format format,
                                    size_t *mod_count,
                                    uint64_t (*mods)[NIL_MAX_DRM_FORMAT_MODS]);

uint64_t nil_select_best_drm_format_mod(const struct nv_device_info *dev,
                                        struct nil_format format,
                                        size_t modifier_count,
                                        const uint64_t *modifiers);

void nil_image_fill_tic(const struct nil_image *self,
                        const struct nv_device_info *dev,
                        const struct nil_view *view,
                        uint64_t base_address,
                        uint32_t (*desc_out)[8]);

void nil_buffer_fill_tic(const struct nv_device_info *dev,
                         uint64_t base_address,
                         struct nil_format format,
                         uint32_t num_elements,
                         uint32_t (*desc_out)[8]);

void nil_fill_null_tic(const struct nv_device_info *dev,
                       uint64_t zero_page_address,
                       uint32_t (*desc_out)[8]);

uint32_t nil_gob_type_height(nil_gob_type self);

uint32_t nil_tiling_size_B(const struct nil_tiling *self);

struct nil_Extent4D_Pixels nil_sparse_block_extent_px(struct nil_format format,
                                                      nil_image_dim dim,
                                                      nil_sample_layout sample_layout);

#endif  /* NIL_H */
