#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const TURING_COMPUTE_A: u32 = 0xC5C0;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const PM_TRIGGER_WFI: u32 = 0x0144;
pub const PM_TRIGGER_WFI_V: Range<u32> = 0..32;
pub const FE_ATOMIC_SEQUENCE_BEGIN: u32 = 0x0148;
pub const FE_ATOMIC_SEQUENCE_BEGIN_V: Range<u32> = 0..32;
pub const FE_ATOMIC_SEQUENCE_END: u32 = 0x014c;
pub const FE_ATOMIC_SEQUENCE_END_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const LINE_LENGTH_IN: u32 = 0x0180;
pub const LINE_LENGTH_IN_VALUE: Range<u32> = 0..32;
pub const LINE_COUNT: u32 = 0x0184;
pub const LINE_COUNT_VALUE: Range<u32> = 0..32;
pub const OFFSET_OUT_UPPER: u32 = 0x0188;
pub const OFFSET_OUT_UPPER_VALUE: Range<u32> = 0..17;
pub const OFFSET_OUT: u32 = 0x018c;
pub const OFFSET_OUT_VALUE: Range<u32> = 0..32;
pub const PITCH_OUT: u32 = 0x0190;
pub const PITCH_OUT_VALUE: Range<u32> = 0..32;
pub const SET_DST_BLOCK_SIZE: u32 = 0x0194;
pub const SET_DST_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_WIDTH: u32 = 0x0198;
pub const SET_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_DST_HEIGHT: u32 = 0x019c;
pub const SET_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_DST_DEPTH: u32 = 0x01a0;
pub const SET_DST_DEPTH_V: Range<u32> = 0..32;
pub const SET_DST_LAYER: u32 = 0x01a4;
pub const SET_DST_LAYER_V: Range<u32> = 0..32;
pub const SET_DST_ORIGIN_BYTES_X: u32 = 0x01a8;
pub const SET_DST_ORIGIN_BYTES_X_V: Range<u32> = 0..21;
pub const SET_DST_ORIGIN_SAMPLES_Y: u32 = 0x01ac;
pub const SET_DST_ORIGIN_SAMPLES_Y_V: Range<u32> = 0..17;
pub const LAUNCH_DMA: u32 = 0x01b0;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT: Range<u32> = 0..1;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE: Range<u32> = 4..6;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE: u32 = 0x00000000;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE: u32 = 0x00000002;
pub const LAUNCH_DMA_INTERRUPT_TYPE: Range<u32> = 8..10;
pub const LAUNCH_DMA_INTERRUPT_TYPE_NONE: u32 = 0x00000000;
pub const LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT: u32 = 0x00000001;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE: Range<u32> = 12..13;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_ENABLE: Range<u32> = 1..2;
pub const LAUNCH_DMA_REDUCTION_ENABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_ENABLE_TRUE: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP: Range<u32> = 13..16;
pub const LAUNCH_DMA_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const LAUNCH_DMA_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const LAUNCH_DMA_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const LAUNCH_DMA_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const LAUNCH_DMA_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const LAUNCH_DMA_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const LAUNCH_DMA_REDUCTION_FORMAT: Range<u32> = 2..4;
pub const LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32: u32 = 0x00000001;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE: Range<u32> = 6..7;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE: u32 = 0x00000001;
pub const LOAD_INLINE_DATA: u32 = 0x01b4;
pub const LOAD_INLINE_DATA_V: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_A: u32 = 0x01dc;
pub const SET_I2M_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_I2M_SEMAPHORE_B: u32 = 0x01e0;
pub const SET_I2M_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_C: u32 = 0x01e4;
pub const SET_I2M_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_SM_SCG_CONTROL: u32 = 0x01e8;
pub const SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS: Range<u32> = 0..1;
pub const SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE: u32 = 0x00000000;
pub const SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE: u32 = 0x00000001;
pub const SET_I2M_SPARE_NOOP00: u32 = 0x01f0;
pub const SET_I2M_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP01: u32 = 0x01f4;
pub const SET_I2M_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP02: u32 = 0x01f8;
pub const SET_I2M_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP03: u32 = 0x01fc;
pub const SET_I2M_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_VALID_SPAN_OVERFLOW_AREA_A: u32 = 0x0200;
pub const SET_VALID_SPAN_OVERFLOW_AREA_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_VALID_SPAN_OVERFLOW_AREA_B: u32 = 0x0204;
pub const SET_VALID_SPAN_OVERFLOW_AREA_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_VALID_SPAN_OVERFLOW_AREA_C: u32 = 0x0208;
pub const SET_VALID_SPAN_OVERFLOW_AREA_C_SIZE: Range<u32> = 0..32;
pub const PERFMON_TRANSFER: u32 = 0x0210;
pub const PERFMON_TRANSFER_V: Range<u32> = 0..32;
pub const SET_QMD_VIRTUALIZATION_BASE_A: u32 = 0x0214;
pub const SET_QMD_VIRTUALIZATION_BASE_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_QMD_VIRTUALIZATION_BASE_B: u32 = 0x0218;
pub const SET_QMD_VIRTUALIZATION_BASE_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const INVALIDATE_SHADER_CACHES: u32 = 0x021c;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_LOCKS: Range<u32> = 1..2;
pub const INVALIDATE_SHADER_CACHES_LOCKS_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_LOCKS_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA: Range<u32> = 2..3;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE: u32 = 0x00000001;
pub const SET_RESERVED_SW_METHOD00: u32 = 0x0220;
pub const SET_RESERVED_SW_METHOD00_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD01: u32 = 0x0224;
pub const SET_RESERVED_SW_METHOD01_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD02: u32 = 0x0228;
pub const SET_RESERVED_SW_METHOD02_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD03: u32 = 0x022c;
pub const SET_RESERVED_SW_METHOD03_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD04: u32 = 0x0230;
pub const SET_RESERVED_SW_METHOD04_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD05: u32 = 0x0234;
pub const SET_RESERVED_SW_METHOD05_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD06: u32 = 0x0238;
pub const SET_RESERVED_SW_METHOD06_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD07: u32 = 0x023c;
pub const SET_RESERVED_SW_METHOD07_V: Range<u32> = 0..32;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI: u32 = 0x0244;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const SET_CWD_REF_COUNTER: u32 = 0x0248;
pub const SET_CWD_REF_COUNTER_SELECT: Range<u32> = 0..6;
pub const SET_CWD_REF_COUNTER_VALUE: Range<u32> = 8..24;
pub const SET_RESERVED_SW_METHOD08: u32 = 0x024c;
pub const SET_RESERVED_SW_METHOD08_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD09: u32 = 0x0250;
pub const SET_RESERVED_SW_METHOD09_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD10: u32 = 0x0254;
pub const SET_RESERVED_SW_METHOD10_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD11: u32 = 0x0258;
pub const SET_RESERVED_SW_METHOD11_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD12: u32 = 0x025c;
pub const SET_RESERVED_SW_METHOD12_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD13: u32 = 0x0260;
pub const SET_RESERVED_SW_METHOD13_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD14: u32 = 0x0264;
pub const SET_RESERVED_SW_METHOD14_V: Range<u32> = 0..32;
pub const SET_RESERVED_SW_METHOD15: u32 = 0x0268;
pub const SET_RESERVED_SW_METHOD15_V: Range<u32> = 0..32;
pub const SET_SCG_CONTROL: u32 = 0x0270;
pub const SET_SCG_CONTROL_COMPUTE1_MAX_SM_COUNT: Range<u32> = 0..9;
pub const SET_SCG_CONTROL_COMPUTE1_MIN_SM_COUNT: Range<u32> = 12..21;
pub const SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE: Range<u32> = 24..25;
pub const SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE: u32 = 0x00000000;
pub const SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE: u32 = 0x00000001;
pub const SET_COMPUTE_CLASS_VERSION: u32 = 0x0280;
pub const SET_COMPUTE_CLASS_VERSION_CURRENT: Range<u32> = 0..16;
pub const SET_COMPUTE_CLASS_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const CHECK_COMPUTE_CLASS_VERSION: u32 = 0x0284;
pub const CHECK_COMPUTE_CLASS_VERSION_CURRENT: Range<u32> = 0..16;
pub const CHECK_COMPUTE_CLASS_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const SET_QMD_VERSION: u32 = 0x0288;
pub const SET_QMD_VERSION_CURRENT: Range<u32> = 0..16;
pub const SET_QMD_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const CHECK_QMD_VERSION: u32 = 0x0290;
pub const CHECK_QMD_VERSION_CURRENT: Range<u32> = 0..16;
pub const CHECK_QMD_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const INVALIDATE_SKED_CACHES: u32 = 0x0298;
pub const INVALIDATE_SKED_CACHES_V: Range<u32> = 0..1;
pub const SET_QMD_VIRTUALIZATION_CONTROL: u32 = 0x029c;
pub const SET_QMD_VIRTUALIZATION_CONTROL_CONSTANT_BUFFER_MASK: Range<u32> = 0..8;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE: Range<u32> = 8..9;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE: Range<u32> = 12..13;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE: Range<u32> = 16..17;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE: Range<u32> = 20..21;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE: Range<u32> = 24..25;
pub const SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SHADER_SHARED_MEMORY_WINDOW_A: u32 = 0x02a0;
pub const SET_SHADER_SHARED_MEMORY_WINDOW_A_BASE_ADDRESS_UPPER: Range<u32> = 0..17;
pub const SET_SHADER_SHARED_MEMORY_WINDOW_B: u32 = 0x02a4;
pub const SET_SHADER_SHARED_MEMORY_WINDOW_B_BASE_ADDRESS: Range<u32> = 0..32;
pub const SCG_HYSTERESIS_CONTROL: u32 = 0x02a8;
pub const SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE: Range<u32> = 0..1;
pub const SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE: u32 = 0x00000000;
pub const SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE: u32 = 0x00000001;
pub const SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE: Range<u32> = 1..2;
pub const SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE: u32 = 0x00000000;
pub const SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE: u32 = 0x00000001;
pub const SET_CWD_SLOT_COUNT: u32 = 0x02b0;
pub const SET_CWD_SLOT_COUNT_V: Range<u32> = 0..8;
pub const SEND_PCAS_A: u32 = 0x02b4;
pub const SEND_PCAS_A_QMD_ADDRESS_SHIFTED8: Range<u32> = 0..32;
pub const SEND_PCAS_B: u32 = 0x02b8;
pub const SEND_PCAS_B_FROM: Range<u32> = 0..24;
pub const SEND_PCAS_B_DELTA: Range<u32> = 24..32;
pub const SEND_SIGNALING_PCAS_B: u32 = 0x02bc;
pub const SEND_SIGNALING_PCAS_B_INVALIDATE: Range<u32> = 0..1;
pub const SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE: u32 = 0x00000000;
pub const SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE: u32 = 0x00000001;
pub const SEND_SIGNALING_PCAS_B_SCHEDULE: Range<u32> = 1..2;
pub const SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE: u32 = 0x00000000;
pub const SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE: u32 = 0x00000001;
pub const SET_SKED_CACHE_CONTROL: u32 = 0x02cc;
pub const SET_SKED_CACHE_CONTROL_IGNORE_VEID: Range<u32> = 0..1;
pub const SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE: u32 = 0x00000000;
pub const SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE: u32 = 0x00000001;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A: u32 = 0x02e4;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A_SIZE_UPPER: Range<u32> = 0..8;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B: u32 = 0x02e8;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B_SIZE_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C: u32 = 0x02ec;
pub const SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C_MAX_SM_COUNT: Range<u32> = 0..9;
pub const SET_SPA_VERSION: u32 = 0x0310;
pub const SET_SPA_VERSION_MINOR: Range<u32> = 0..8;
pub const SET_SPA_VERSION_MAJOR: Range<u32> = 8..16;
pub const SET_INLINE_QMD_ADDRESS_A: u32 = 0x0318;
pub const SET_INLINE_QMD_ADDRESS_A_QMD_ADDRESS_SHIFTED8_UPPER: Range<u32> = 0..32;
pub const SET_INLINE_QMD_ADDRESS_B: u32 = 0x031c;
pub const SET_INLINE_QMD_ADDRESS_B_QMD_ADDRESS_SHIFTED8_LOWER: Range<u32> = 0..32;
#[inline]
pub fn load_inline_qmd_data  (i: u32) -> u32 { 0x0320+i*4 } 
pub const LOAD_INLINE_QMD_DATA_V: Range<u32> = 0..32;
pub const SET_FALCON00: u32 = 0x0500;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x0504;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x0508;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x050c;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x0510;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x0514;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x0518;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x051c;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x0520;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x0524;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x0528;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x052c;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x0530;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x0534;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x0538;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x053c;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x0540;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x0544;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x0548;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x054c;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x0550;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x0554;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x0558;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x055c;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x0560;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x0564;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x0568;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x056c;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x0570;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x0574;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x0578;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x057c;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_A: u32 = 0x0790;
pub const SET_SHADER_LOCAL_MEMORY_A_ADDRESS_UPPER: Range<u32> = 0..17;
pub const SET_SHADER_LOCAL_MEMORY_B: u32 = 0x0794;
pub const SET_SHADER_LOCAL_MEMORY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_A: u32 = 0x07b0;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_A_BASE_ADDRESS_UPPER: Range<u32> = 0..17;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_B: u32 = 0x07b4;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_B_BASE_ADDRESS: Range<u32> = 0..32;
pub const SET_SHADER_CACHE_CONTROL: u32 = 0x0d94;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_scg_compute_scheduling_parameters  (i: u32) -> u32 { 0x0da0+i*4 } 
pub const SET_SCG_COMPUTE_SCHEDULING_PARAMETERS_V: Range<u32> = 0..32;
pub const SET_SM_TIMEOUT_INTERVAL: u32 = 0x0de4;
pub const SET_SM_TIMEOUT_INTERVAL_COUNTER_BIT: Range<u32> = 0..6;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI: u32 = 0x1288;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT: u32 = 0x12a8;
pub const ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL: Range<u32> = 0..1;
pub const ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE: u32 = 0x00000000;
pub const ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE: u32 = 0x1330;
pub const INVALIDATE_SAMPLER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_HEADER_CACHE: u32 = 0x1334;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_DATA_CACHE: u32 = 0x1338;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI: u32 = 0x1424;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const SET_SHADER_EXCEPTIONS: u32 = 0x1528;
pub const SET_SHADER_EXCEPTIONS_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_EXCEPTIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_EXCEPTIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_A: u32 = 0x1550;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x1554;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x1558;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_TEX_SAMPLER_POOL_A: u32 = 0x155c;
pub const SET_TEX_SAMPLER_POOL_A_OFFSET_UPPER: Range<u32> = 0..17;
pub const SET_TEX_SAMPLER_POOL_B: u32 = 0x1560;
pub const SET_TEX_SAMPLER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_SAMPLER_POOL_C: u32 = 0x1564;
pub const SET_TEX_SAMPLER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..20;
pub const SET_TEX_HEADER_POOL_A: u32 = 0x1574;
pub const SET_TEX_HEADER_POOL_A_OFFSET_UPPER: Range<u32> = 0..17;
pub const SET_TEX_HEADER_POOL_B: u32 = 0x1578;
pub const SET_TEX_HEADER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_HEADER_POOL_C: u32 = 0x157c;
pub const SET_TEX_HEADER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..22;
pub const INVALIDATE_SHADER_CACHES_NO_WFI: u32 = 0x1698;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x1944;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
pub const PIPE_NOP: u32 = 0x1a2c;
pub const PIPE_NOP_V: Range<u32> = 0..32;
pub const SET_SPARE00: u32 = 0x1a30;
pub const SET_SPARE00_V: Range<u32> = 0..32;
pub const SET_SPARE01: u32 = 0x1a34;
pub const SET_SPARE01_V: Range<u32> = 0..32;
pub const SET_SPARE02: u32 = 0x1a38;
pub const SET_SPARE02_V: Range<u32> = 0..32;
pub const SET_SPARE03: u32 = 0x1a3c;
pub const SET_SPARE03_V: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_A: u32 = 0x1b00;
pub const SET_REPORT_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_REPORT_SEMAPHORE_B: u32 = 0x1b04;
pub const SET_REPORT_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_C: u32 = 0x1b08;
pub const SET_REPORT_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_D: u32 = 0x1b0c;
pub const SET_REPORT_SEMAPHORE_D_OPERATION: Range<u32> = 0..2;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_TRAP: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE: Range<u32> = 20..21;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE: Range<u32> = 28..29;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE: Range<u32> = 2..3;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE: Range<u32> = 3..4;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP: Range<u32> = 9..12;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT: Range<u32> = 17..19;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP: Range<u32> = 19..20;
pub const SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE: u32 = 0x00000001;
pub const SET_TRAP_HANDLER_A: u32 = 0x25f8;
pub const SET_TRAP_HANDLER_A_ADDRESS_UPPER: Range<u32> = 0..17;
pub const SET_TRAP_HANDLER_B: u32 = 0x25fc;
pub const SET_TRAP_HANDLER_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_BINDLESS_TEXTURE: u32 = 0x2608;
pub const SET_BINDLESS_TEXTURE_CONSTANT_BUFFER_SLOT_SELECT: Range<u32> = 0..3;
#[inline]
pub fn set_shader_performance_snapshot_counter_value  (i: u32) -> u32 { 0x32f4+i*4 } 
pub const SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_V: Range<u32> = 0..32;
#[inline]
pub fn set_shader_performance_snapshot_counter_value_upper  (i: u32) -> u32 { 0x3314+i*4 } 
pub const SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER_V: Range<u32> = 0..32;
pub const ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER: u32 = 0x3334;
pub const ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_V: Range<u32> = 0..1;
pub const DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER: u32 = 0x3338;
pub const DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_V: Range<u32> = 0..1;
#[inline]
pub fn set_shader_performance_counter_value_upper  (i: u32) -> u32 { 0x333c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER_V: Range<u32> = 0..32;
#[inline]
pub fn set_shader_performance_counter_value  (i: u32) -> u32 { 0x335c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_VALUE_V: Range<u32> = 0..32;
#[inline]
pub fn set_shader_performance_counter_event  (i: u32) -> u32 { 0x337c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_EVENT_EVENT: Range<u32> = 0..8;
#[inline]
pub fn set_shader_performance_counter_control_a  (i: u32) -> u32 { 0x339c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT0: Range<u32> = 0..2;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT0: Range<u32> = 2..5;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT1: Range<u32> = 5..7;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT1: Range<u32> = 7..10;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT2: Range<u32> = 10..12;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT2: Range<u32> = 12..15;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT3: Range<u32> = 15..17;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT3: Range<u32> = 17..20;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT4: Range<u32> = 20..22;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT4: Range<u32> = 22..25;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT5: Range<u32> = 25..27;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT5: Range<u32> = 27..30;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_SPARE: Range<u32> = 30..32;
#[inline]
pub fn set_shader_performance_counter_control_b  (i: u32) -> u32 { 0x33bc+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_EDGE: Range<u32> = 0..1;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_MODE: Range<u32> = 1..3;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_WINDOWED: Range<u32> = 3..4;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_FUNC: Range<u32> = 4..20;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL: u32 = 0x33dc;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL_MASK: Range<u32> = 0..8;
pub const START_SHADER_PERFORMANCE_COUNTER: u32 = 0x33e0;
pub const START_SHADER_PERFORMANCE_COUNTER_COUNTER_MASK: Range<u32> = 0..8;
pub const STOP_SHADER_PERFORMANCE_COUNTER: u32 = 0x33e4;
pub const STOP_SHADER_PERFORMANCE_COUNTER_COUNTER_MASK: Range<u32> = 0..8;
pub const SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER: u32 = 0x33e8;
pub const SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER_V: Range<u32> = 0..32;
pub const SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER: u32 = 0x33ec;
pub const SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER_V: Range<u32> = 0..32;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;

// parsed class NVC5C0




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceBegin {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceBegin {
    const ADDR: u16 = 0x0148;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceEnd {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceEnd {
    const ADDR: u16 = 0x014c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.value < (1 << 17));
        val |= self.value << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 21));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;
            
        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;
            
        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;
            
        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;
            
        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;
            
        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmScgControl {
    pub compute_in_graphics: bool,
}

impl Mthd for SetSmScgControl {
    const ADDR: u16 = 0x01e8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.compute_in_graphics as u32) < (1 << 1));
        val |= (self.compute_in_graphics as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaA {
    pub address_upper: u32,
}

impl Mthd for SetValidSpanOverflowAreaA {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaB {
    pub address_lower: u32,
}

impl Mthd for SetValidSpanOverflowAreaB {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaC {
    pub size: u32,
}

impl Mthd for SetValidSpanOverflowAreaC {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.size;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PerfmonTransfer {
    pub v: u32,
}

impl Mthd for PerfmonTransfer {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationBaseA {
    pub address_upper: u32,
}

impl Mthd for SetQmdVirtualizationBaseA {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationBaseB {
    pub address_lower: u32,
}

impl Mthd for SetQmdVirtualizationBaseB {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;
            
        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;
            
        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod00 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod00 {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod01 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod01 {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod02 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod02 {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod03 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod03 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod04 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod04 {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod05 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod05 {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod06 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod06 {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod07 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod07 {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheNoWfi {
    pub lines: InvalidateTextureHeaderCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCacheNoWfi {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCwdRefCounter {
    pub select: u32,
    pub value: u32,
}

impl Mthd for SetCwdRefCounter {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.select < (1 << 6));
        val |= self.select << 0;
            
        assert!(self.value < (1 << 16));
        val |= self.value << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod08 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod08 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod09 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod09 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod10 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod10 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod11 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod11 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod12 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod12 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod13 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod13 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod14 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod14 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod15 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod15 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgControl {
    pub compute1_max_sm_count: u32,
    pub compute1_min_sm_count: u32,
    pub disable_compute1_limit_in_all_compute: bool,
}

impl Mthd for SetScgControl {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.compute1_max_sm_count < (1 << 9));
        val |= self.compute1_max_sm_count << 0;
            
        assert!(self.compute1_min_sm_count < (1 << 9));
        val |= self.compute1_min_sm_count << 12;
            
        assert!((self.disable_compute1_limit_in_all_compute as u32) < (1 << 1));
        val |= (self.disable_compute1_limit_in_all_compute as u32) << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetComputeClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetComputeClassVersion {
    const ADDR: u16 = 0x0280;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckComputeClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckComputeClassVersion {
    const ADDR: u16 = 0x0284;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetQmdVersion {
    const ADDR: u16 = 0x0288;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckQmdVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckQmdVersion {
    const ADDR: u16 = 0x0290;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSkedCaches {
    pub v: u32,
}

impl Mthd for InvalidateSkedCaches {
    const ADDR: u16 = 0x0298;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationControl {
    pub constant_buffer_mask: u32,
    pub i2m_addr_enable: bool,
    pub i2m_constant_buffer_enable: bool,
    pub iq2m_addr_enable: bool,
    pub iq2m_constant_buffer_enable: bool,
    pub send_pcas_enable: bool,
}

impl Mthd for SetQmdVirtualizationControl {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.constant_buffer_mask < (1 << 8));
        val |= self.constant_buffer_mask << 0;
            
        assert!((self.i2m_addr_enable as u32) < (1 << 1));
        val |= (self.i2m_addr_enable as u32) << 8;
            
        assert!((self.i2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.i2m_constant_buffer_enable as u32) << 12;
            
        assert!((self.iq2m_addr_enable as u32) < (1 << 1));
        val |= (self.iq2m_addr_enable as u32) << 16;
            
        assert!((self.iq2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.iq2m_constant_buffer_enable as u32) << 20;
            
        assert!((self.send_pcas_enable as u32) < (1 << 1));
        val |= (self.send_pcas_enable as u32) << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindowA {
    pub base_address_upper: u32,
}

impl Mthd for SetShaderSharedMemoryWindowA {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.base_address_upper < (1 << 17));
        val |= self.base_address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindowB {
    pub base_address: u32,
}

impl Mthd for SetShaderSharedMemoryWindowB {
    const ADDR: u16 = 0x02a4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.base_address;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ScgHysteresisControl {
    pub use_timeout_once: bool,
    pub use_null_timeout_once: bool,
}

impl Mthd for ScgHysteresisControl {
    const ADDR: u16 = 0x02a8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.use_timeout_once as u32) < (1 << 1));
        val |= (self.use_timeout_once as u32) << 0;
            
        assert!((self.use_null_timeout_once as u32) < (1 << 1));
        val |= (self.use_null_timeout_once as u32) << 1;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCwdSlotCount {
    pub v: u32,
}

impl Mthd for SetCwdSlotCount {
    const ADDR: u16 = 0x02b0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendPcasA {
    pub qmd_address_shifted8: u32,
}

impl Mthd for SendPcasA {
    const ADDR: u16 = 0x02b4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.qmd_address_shifted8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendPcasB {
    pub from: u32,
    pub delta: u32,
}

impl Mthd for SendPcasB {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.from < (1 << 24));
        val |= self.from << 0;
            
        assert!(self.delta < (1 << 8));
        val |= self.delta << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendSignalingPcasB {
    pub invalidate: bool,
    pub schedule: bool,
}

impl Mthd for SendSignalingPcasB {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.invalidate as u32) < (1 << 1));
        val |= (self.invalidate as u32) << 0;
            
        assert!((self.schedule as u32) < (1 << 1));
        val |= (self.schedule as u32) << 1;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSkedCacheControl {
    pub ignore_veid: bool,
}

impl Mthd for SetSkedCacheControl {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.ignore_veid as u32) < (1 << 1));
        val |= (self.ignore_veid as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledA {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledA {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size_upper < (1 << 8));
        val |= self.size_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledB {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledB {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.size_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledC {
    pub max_sm_count: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledC {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.max_sm_count < (1 << 9));
        val |= self.max_sm_count << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpaVersion {
    pub minor: u32,
    pub major: u32,
}

impl Mthd for SetSpaVersion {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.minor < (1 << 8));
        val |= self.minor << 0;
            
        assert!(self.major < (1 << 8));
        val |= self.major << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineQmdAddressA {
    pub qmd_address_shifted8_upper: u32,
}

impl Mthd for SetInlineQmdAddressA {
    const ADDR: u16 = 0x0318;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.qmd_address_shifted8_upper;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineQmdAddressB {
    pub qmd_address_shifted8_lower: u32,
}

impl Mthd for SetInlineQmdAddressB {
    const ADDR: u16 = 0x031c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.qmd_address_shifted8_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineQmdData {
    pub v: u32,
}

impl ArrayMthd for LoadInlineQmdData {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x0320+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x0500;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0504;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0508;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x050c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x0510;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0514;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0518;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x051c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0520;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0524;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0528;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x052c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0530;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0534;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0538;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x053c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0540;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0544;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0548;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x054c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0578;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x057c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryB {
    pub address_lower: u32,
}

impl Mthd for SetShaderLocalMemoryB {
    const ADDR: u16 = 0x0794;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindowA {
    pub base_address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryWindowA {
    const ADDR: u16 = 0x07b0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.base_address_upper < (1 << 17));
        val |= self.base_address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindowB {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindowB {
    const ADDR: u16 = 0x07b4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.base_address;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderCacheControl {
    pub icache_prefetch_enable: bool,
}

impl Mthd for SetShaderCacheControl {
    const ADDR: u16 = 0x0d94;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.icache_prefetch_enable as u32) < (1 << 1));
        val |= (self.icache_prefetch_enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgComputeSchedulingParameters {
    pub v: u32,
}

impl ArrayMthd for SetScgComputeSchedulingParameters {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x0da0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmTimeoutInterval {
    pub counter_bit: u32,
}

impl Mthd for SetSmTimeoutInterval {
    const ADDR: u16 = 0x0de4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.counter_bit < (1 << 6));
        val |= self.counter_bit << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCacheNoWfi {
    pub lines: InvalidateTextureDataCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCacheNoWfi {
    const ADDR: u16 = 0x1288;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ActivatePerfSettingsForComputeContext {
    pub all: bool,
}

impl Mthd for ActivatePerfSettingsForComputeContext {
    const ADDR: u16 = 0x12a8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.all as u32) < (1 << 1));
        val |= (self.all as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCache {
    pub lines: InvalidateSamplerCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCache {
    const ADDR: u16 = 0x1330;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCache {
    pub lines: InvalidateTextureHeaderCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCache {
    const ADDR: u16 = 0x1334;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheNoWfi {
    pub lines: InvalidateSamplerCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCacheNoWfi {
    const ADDR: u16 = 0x1424;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderExceptions {
    pub enable: bool,
}

impl Mthd for SetShaderExceptions {
    const ADDR: u16 = 0x1528;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 17));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexSamplerPoolB {
    const ADDR: u16 = 0x1560;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexSamplerPoolC {
    const ADDR: u16 = 0x1564;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 20));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 17));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexHeaderPoolB {
    const ADDR: u16 = 0x1578;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexHeaderPoolC {
    const ADDR: u16 = 0x157c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 22));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x1698;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipeNop {
    pub v: u32,
}

impl Mthd for PipeNop {
    const ADDR: u16 = 0x1a2c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare00 {
    pub v: u32,
}

impl Mthd for SetSpare00 {
    const ADDR: u16 = 0x1a30;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare01 {
    pub v: u32,
}

impl Mthd for SetSpare01 {
    const ADDR: u16 = 0x1a34;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare02 {
    pub v: u32,
}

impl Mthd for SetSpare02 {
    const ADDR: u16 = 0x1a38;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare03 {
    pub v: u32,
}

impl Mthd for SetSpare03 {
    const ADDR: u16 = 0x1a3c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetReportSemaphoreA {
    const ADDR: u16 = 0x1b00;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetReportSemaphoreB {
    const ADDR: u16 = 0x1b04;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetReportSemaphoreC {
    const ADDR: u16 = 0x1b08;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub awaken_enable: bool,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
    pub conditional_trap: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;
            
        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;
            
        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;
            
        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;
            
        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;
            
        assert!((self.conditional_trap as u32) < (1 << 1));
        val |= (self.conditional_trap as u32) << 19;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerA {
    pub address_upper: u32,
}

impl Mthd for SetTrapHandlerA {
    const ADDR: u16 = 0x25f8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerB {
    pub address_lower: u32,
}

impl Mthd for SetTrapHandlerB {
    const ADDR: u16 = 0x25fc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindlessTexture {
    pub constant_buffer_slot_select: u32,
}

impl Mthd for SetBindlessTexture {
    const ADDR: u16 = 0x2608;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.constant_buffer_slot_select < (1 << 3));
        val |= self.constant_buffer_slot_select << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValue {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x32f4+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValueUpper {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x3314+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct EnableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for EnableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3334;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DisableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for DisableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3338;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValueUpper {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x333c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValue {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x335c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterEvent {
    pub event: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterEvent {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x337c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event < (1 << 8));
        val |= self.event << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
    pub event4: u32,
    pub bit_select4: u32,
    pub event5: u32,
    pub bit_select5: u32,
    pub spare: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x339c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event0 < (1 << 2));
        val |= self.event0 << 0;
            
        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 2;
            
        assert!(self.event1 < (1 << 2));
        val |= self.event1 << 5;
            
        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 7;
            
        assert!(self.event2 < (1 << 2));
        val |= self.event2 << 10;
            
        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 12;
            
        assert!(self.event3 < (1 << 2));
        val |= self.event3 << 15;
            
        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 17;
            
        assert!(self.event4 < (1 << 2));
        val |= self.event4 << 20;
            
        assert!(self.bit_select4 < (1 << 3));
        val |= self.bit_select4 << 22;
            
        assert!(self.event5 < (1 << 2));
        val |= self.event5 << 25;
            
        assert!(self.bit_select5 < (1 << 3));
        val |= self.bit_select5 << 27;
            
        assert!(self.spare < (1 << 2));
        val |= self.spare << 30;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub mode: u32,
    pub windowed: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x33bc+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;
            
        assert!(self.mode < (1 << 2));
        val |= self.mode << 1;
            
        assert!(self.windowed < (1 << 1));
        val |= self.windowed << 3;
            
        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterTrapControl {
    pub mask: u32,
}

impl Mthd for SetShaderPerformanceCounterTrapControl {
    const ADDR: u16 = 0x33dc;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.mask < (1 << 8));
        val |= self.mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StartShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StartShaderPerformanceCounter {
    const ADDR: u16 = 0x33e0;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StopShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StopShaderPerformanceCounter {
    const ADDR: u16 = 0x33e4;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterSctlFilter {
    pub v: u32,
}

impl Mthd for SetShaderPerformanceCounterSctlFilter {
    const ADDR: u16 = 0x33e8;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterCoreMioFilter {
    pub v: u32,
}

impl Mthd for SetShaderPerformanceCounterCoreMioFilter {
    const ADDR: u16 = 0x33ec;
    const CLASS: u16 = 0xc5c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
