#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const KEPLER_INLINE_TO_MEMORY_B: u32 = 0xA140;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..25;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const PM_TRIGGER_WFI: u32 = 0x0144;
pub const PM_TRIGGER_WFI_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const LINE_LENGTH_IN: u32 = 0x0180;
pub const LINE_LENGTH_IN_VALUE: Range<u32> = 0..32;
pub const LINE_COUNT: u32 = 0x0184;
pub const LINE_COUNT_VALUE: Range<u32> = 0..32;
pub const OFFSET_OUT_UPPER: u32 = 0x0188;
pub const OFFSET_OUT_UPPER_VALUE: Range<u32> = 0..25;
pub const OFFSET_OUT: u32 = 0x018c;
pub const OFFSET_OUT_VALUE: Range<u32> = 0..32;
pub const PITCH_OUT: u32 = 0x0190;
pub const PITCH_OUT_VALUE: Range<u32> = 0..32;
pub const SET_DST_BLOCK_SIZE: u32 = 0x0194;
pub const SET_DST_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_WIDTH: u32 = 0x0198;
pub const SET_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_DST_HEIGHT: u32 = 0x019c;
pub const SET_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_DST_DEPTH: u32 = 0x01a0;
pub const SET_DST_DEPTH_V: Range<u32> = 0..32;
pub const SET_DST_LAYER: u32 = 0x01a4;
pub const SET_DST_LAYER_V: Range<u32> = 0..32;
pub const SET_DST_ORIGIN_BYTES_X: u32 = 0x01a8;
pub const SET_DST_ORIGIN_BYTES_X_V: Range<u32> = 0..21;
pub const SET_DST_ORIGIN_SAMPLES_Y: u32 = 0x01ac;
pub const SET_DST_ORIGIN_SAMPLES_Y_V: Range<u32> = 0..17;
pub const LAUNCH_DMA: u32 = 0x01b0;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT: Range<u32> = 0..1;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE: Range<u32> = 4..6;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE: u32 = 0x00000000;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE: u32 = 0x00000002;
pub const LAUNCH_DMA_INTERRUPT_TYPE: Range<u32> = 8..10;
pub const LAUNCH_DMA_INTERRUPT_TYPE_NONE: u32 = 0x00000000;
pub const LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT: u32 = 0x00000001;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE: Range<u32> = 12..13;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_ENABLE: Range<u32> = 1..2;
pub const LAUNCH_DMA_REDUCTION_ENABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_ENABLE_TRUE: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP: Range<u32> = 13..16;
pub const LAUNCH_DMA_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const LAUNCH_DMA_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const LAUNCH_DMA_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const LAUNCH_DMA_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const LAUNCH_DMA_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const LAUNCH_DMA_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const LAUNCH_DMA_REDUCTION_FORMAT: Range<u32> = 2..4;
pub const LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32: u32 = 0x00000001;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE: Range<u32> = 6..7;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE: u32 = 0x00000001;
pub const LOAD_INLINE_DATA: u32 = 0x01b4;
pub const LOAD_INLINE_DATA_V: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_A: u32 = 0x01dc;
pub const SET_I2M_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..25;
pub const SET_I2M_SEMAPHORE_B: u32 = 0x01e0;
pub const SET_I2M_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_C: u32 = 0x01e4;
pub const SET_I2M_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP00: u32 = 0x01f0;
pub const SET_I2M_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP01: u32 = 0x01f4;
pub const SET_I2M_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP02: u32 = 0x01f8;
pub const SET_I2M_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP03: u32 = 0x01fc;
pub const SET_I2M_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_FALCON00: u32 = 0x0200;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x0204;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x0208;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x020c;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x0210;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x0214;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x0218;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x021c;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x0220;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x0224;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x0228;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x022c;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x0230;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x0234;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x0238;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x023c;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x0240;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x0244;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x0248;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x024c;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x0250;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x0254;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x0258;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x025c;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x0260;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x0264;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x0268;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x026c;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x0270;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x0274;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x0278;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x027c;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_A: u32 = 0x1550;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x1554;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x1558;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x1944;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;

// parsed class NVA140




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 25));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.value < (1 << 25));
        val |= self.value << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 21));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;
            
        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;
            
        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;
            
        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;
            
        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;
            
        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 25));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0xa140;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0xa140;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
