#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const KEPLER_A: u32 = 0xA097;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER: u32 = 0x0114;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM: u32 = 0x0118;
pub const LOAD_MME_INSTRUCTION_RAM_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER: u32 = 0x011c;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM: u32 = 0x0120;
pub const LOAD_MME_START_ADDRESS_RAM_V: Range<u32> = 0..32;
pub const SET_MME_SHADOW_RAM_CONTROL: u32 = 0x0124;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE: Range<u32> = 0..2;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK: u32 = 0x00000000;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER: u32 = 0x00000001;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH: u32 = 0x00000002;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY: u32 = 0x00000003;
pub const PEER_SEMAPHORE_RELEASE_OFFSET_UPPER: u32 = 0x0128;
pub const PEER_SEMAPHORE_RELEASE_OFFSET_UPPER_V: Range<u32> = 0..8;
pub const PEER_SEMAPHORE_RELEASE_OFFSET: u32 = 0x012c;
pub const PEER_SEMAPHORE_RELEASE_OFFSET_V: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const PM_TRIGGER_WFI: u32 = 0x0144;
pub const PM_TRIGGER_WFI_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const LINE_LENGTH_IN: u32 = 0x0180;
pub const LINE_LENGTH_IN_VALUE: Range<u32> = 0..32;
pub const LINE_COUNT: u32 = 0x0184;
pub const LINE_COUNT_VALUE: Range<u32> = 0..32;
pub const OFFSET_OUT_UPPER: u32 = 0x0188;
pub const OFFSET_OUT_UPPER_VALUE: Range<u32> = 0..8;
pub const OFFSET_OUT: u32 = 0x018c;
pub const OFFSET_OUT_VALUE: Range<u32> = 0..32;
pub const PITCH_OUT: u32 = 0x0190;
pub const PITCH_OUT_VALUE: Range<u32> = 0..32;
pub const SET_DST_BLOCK_SIZE: u32 = 0x0194;
pub const SET_DST_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_WIDTH: u32 = 0x0198;
pub const SET_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_DST_HEIGHT: u32 = 0x019c;
pub const SET_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_DST_DEPTH: u32 = 0x01a0;
pub const SET_DST_DEPTH_V: Range<u32> = 0..32;
pub const SET_DST_LAYER: u32 = 0x01a4;
pub const SET_DST_LAYER_V: Range<u32> = 0..32;
pub const SET_DST_ORIGIN_BYTES_X: u32 = 0x01a8;
pub const SET_DST_ORIGIN_BYTES_X_V: Range<u32> = 0..20;
pub const SET_DST_ORIGIN_SAMPLES_Y: u32 = 0x01ac;
pub const SET_DST_ORIGIN_SAMPLES_Y_V: Range<u32> = 0..16;
pub const LAUNCH_DMA: u32 = 0x01b0;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT: Range<u32> = 0..1;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE: Range<u32> = 4..6;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE: u32 = 0x00000000;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE: u32 = 0x00000002;
pub const LAUNCH_DMA_INTERRUPT_TYPE: Range<u32> = 8..10;
pub const LAUNCH_DMA_INTERRUPT_TYPE_NONE: u32 = 0x00000000;
pub const LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT: u32 = 0x00000001;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE: Range<u32> = 12..13;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_ENABLE: Range<u32> = 1..2;
pub const LAUNCH_DMA_REDUCTION_ENABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_ENABLE_TRUE: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP: Range<u32> = 13..16;
pub const LAUNCH_DMA_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const LAUNCH_DMA_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const LAUNCH_DMA_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const LAUNCH_DMA_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const LAUNCH_DMA_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const LAUNCH_DMA_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const LAUNCH_DMA_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const LAUNCH_DMA_REDUCTION_FORMAT: Range<u32> = 2..4;
pub const LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32: u32 = 0x00000000;
pub const LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32: u32 = 0x00000001;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE: Range<u32> = 6..7;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE: u32 = 0x00000001;
pub const LOAD_INLINE_DATA: u32 = 0x01b4;
pub const LOAD_INLINE_DATA_V: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_A: u32 = 0x01dc;
pub const SET_I2M_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_I2M_SEMAPHORE_B: u32 = 0x01e0;
pub const SET_I2M_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_I2M_SEMAPHORE_C: u32 = 0x01e4;
pub const SET_I2M_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP00: u32 = 0x01f0;
pub const SET_I2M_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP01: u32 = 0x01f4;
pub const SET_I2M_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP02: u32 = 0x01f8;
pub const SET_I2M_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_I2M_SPARE_NOOP03: u32 = 0x01fc;
pub const SET_I2M_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const RUN_DS_NOW: u32 = 0x0200;
pub const RUN_DS_NOW_V: Range<u32> = 0..32;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS: u32 = 0x0204;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD: Range<u32> = 0..5;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS: u32 = 0x00000000;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16: u32 = 0x00000001;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32: u32 = 0x00000002;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__64: u32 = 0x00000003;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__128: u32 = 0x00000004;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__256: u32 = 0x00000005;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__512: u32 = 0x00000006;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1024: u32 = 0x00000007;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2048: u32 = 0x00000008;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4096: u32 = 0x00000009;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__8192: u32 = 0x0000000A;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16384: u32 = 0x0000000B;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32768: u32 = 0x0000000C;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__65536: u32 = 0x0000000D;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__131072: u32 = 0x0000000E;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__262144: u32 = 0x0000000F;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__524288: u32 = 0x00000010;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1048576: u32 = 0x00000011;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2097152: u32 = 0x00000012;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4194304: u32 = 0x00000013;
pub const SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS: u32 = 0x0000001F;
pub const SET_RASTER_PIPE_SYNC_CONTROL: u32 = 0x0208;
pub const SET_RASTER_PIPE_SYNC_CONTROL_PRIM_AREA_THRESHOLD: Range<u32> = 0..22;
pub const SET_RASTER_PIPE_SYNC_CONTROL_ENABLE: Range<u32> = 24..25;
pub const SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ALIASED_LINE_WIDTH_ENABLE: u32 = 0x020c;
pub const SET_ALIASED_LINE_WIDTH_ENABLE_V: Range<u32> = 0..1;
pub const SET_ALIASED_LINE_WIDTH_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_ALIASED_LINE_WIDTH_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_API_MANDATED_EARLY_Z: u32 = 0x0210;
pub const SET_API_MANDATED_EARLY_Z_ENABLE: Range<u32> = 0..1;
pub const SET_API_MANDATED_EARLY_Z_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_API_MANDATED_EARLY_Z_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_GS_DM_FIFO: u32 = 0x0214;
pub const SET_GS_DM_FIFO_SIZE_RASTER_ON: Range<u32> = 0..13;
pub const SET_GS_DM_FIFO_SIZE_RASTER_OFF: Range<u32> = 16..29;
pub const SET_GS_DM_FIFO_SPILL_ENABLED: Range<u32> = 31..32;
pub const SET_GS_DM_FIFO_SPILL_ENABLED_FALSE: u32 = 0x00000000;
pub const SET_GS_DM_FIFO_SPILL_ENABLED_TRUE: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS: u32 = 0x0218;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const INVALIDATE_SHADER_CACHES: u32 = 0x021c;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_LOCKS: Range<u32> = 1..2;
pub const INVALIDATE_SHADER_CACHES_LOCKS_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_LOCKS_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA: Range<u32> = 2..3;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_vab_vertex3f  (i: u32) -> u32 { 0x0220+i*4 } 
pub const SET_VAB_VERTEX3F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_vertex4f  (i: u32) -> u32 { 0x0230+i*4 } 
pub const SET_VAB_VERTEX4F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_normal3f  (i: u32) -> u32 { 0x0240+i*4 } 
pub const SET_VAB_NORMAL3F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_color3f  (i: u32) -> u32 { 0x0250+i*4 } 
pub const SET_VAB_COLOR3F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_color4f  (i: u32) -> u32 { 0x0260+i*4 } 
pub const SET_VAB_COLOR4F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_color4ub  (i: u32) -> u32 { 0x0270+i*4 } 
pub const SET_VAB_COLOR4UB_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_tex_coord1f  (i: u32) -> u32 { 0x0280+i*4 } 
pub const SET_VAB_TEX_COORD1F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_tex_coord2f  (i: u32) -> u32 { 0x0290+i*4 } 
pub const SET_VAB_TEX_COORD2F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_tex_coord3f  (i: u32) -> u32 { 0x02a0+i*4 } 
pub const SET_VAB_TEX_COORD3F_V: Range<u32> = 0..32;
#[inline]
pub fn set_vab_tex_coord4f  (i: u32) -> u32 { 0x02b0+i*4 } 
pub const SET_VAB_TEX_COORD4F_V: Range<u32> = 0..32;
pub const SET_TASK_CIRCULAR_BUFFER_THROTTLE: u32 = 0x02cc;
pub const SET_TASK_CIRCULAR_BUFFER_THROTTLE_TASK_COUNT: Range<u32> = 0..22;
pub const SET_PRIM_CIRCULAR_BUFFER_THROTTLE: u32 = 0x02d0;
pub const SET_PRIM_CIRCULAR_BUFFER_THROTTLE_PRIM_AREA: Range<u32> = 0..22;
pub const FLUSH_AND_INVALIDATE_ROP_MINI_CACHE: u32 = 0x02d4;
pub const FLUSH_AND_INVALIDATE_ROP_MINI_CACHE_V: Range<u32> = 0..1;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE: u32 = 0x02d8;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_ALPHA_CIRCULAR_BUFFER_SIZE: u32 = 0x02dc;
pub const SET_ALPHA_CIRCULAR_BUFFER_SIZE_CACHE_LINES_PER_SM: Range<u32> = 0..10;
pub const SET_ZCULL_ROP_BYPASS: u32 = 0x02e4;
pub const SET_ZCULL_ROP_BYPASS_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_ROP_BYPASS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_ROP_BYPASS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_ROP_BYPASS_NO_STALL: Range<u32> = 4..5;
pub const SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING: Range<u32> = 8..9;
pub const SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_ROP_BYPASS_THRESHOLD: Range<u32> = 12..16;
pub const SET_ZCULL_SUBREGION: u32 = 0x02e8;
pub const SET_ZCULL_SUBREGION_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_SUBREGION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_SUBREGION_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_SUBREGION_NORMALIZED_ALIQUOTS: Range<u32> = 4..28;
pub const SET_RASTER_BOUNDING_BOX: u32 = 0x02ec;
pub const SET_RASTER_BOUNDING_BOX_MODE: Range<u32> = 0..1;
pub const SET_RASTER_BOUNDING_BOX_MODE_BOUNDING_BOX: u32 = 0x00000000;
pub const SET_RASTER_BOUNDING_BOX_MODE_FULL_VIEWPORT: u32 = 0x00000001;
pub const SET_RASTER_BOUNDING_BOX_PAD: Range<u32> = 4..12;
pub const PEER_SEMAPHORE_RELEASE: u32 = 0x02f0;
pub const PEER_SEMAPHORE_RELEASE_V: Range<u32> = 0..32;
pub const SET_ZCULL_SUBREGION_ALLOCATION: u32 = 0x02f8;
pub const SET_ZCULL_SUBREGION_ALLOCATION_SUBREGION_ID: Range<u32> = 0..8;
pub const SET_ZCULL_SUBREGION_ALLOCATION_ALIQUOTS: Range<u32> = 8..24;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT: Range<u32> = 24..28;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4: u32 = 0x00000000;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4: u32 = 0x00000001;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2: u32 = 0x00000002;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4: u32 = 0x00000003;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4: u32 = 0x00000004;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2: u32 = 0x00000005;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4: u32 = 0x00000006;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8: u32 = 0x00000007;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2: u32 = 0x00000008;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2: u32 = 0x00000009;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4: u32 = 0x0000000A;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2: u32 = 0x0000000B;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1: u32 = 0x0000000C;
pub const SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE: u32 = 0x0000000F;
pub const ASSIGN_ZCULL_SUBREGIONS: u32 = 0x02fc;
pub const ASSIGN_ZCULL_SUBREGIONS_ALGORITHM: Range<u32> = 0..2;
pub const ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static: u32 = 0x00000000;
pub const ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive: u32 = 0x00000001;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE: u32 = 0x0300;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE: Range<u32> = 0..1;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE: Range<u32> = 1..2;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE: u32 = 0x00000000;
pub const SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE: u32 = 0x00000001;
pub const DRAW_ZERO_INDEX: u32 = 0x0304;
pub const DRAW_ZERO_INDEX_COUNT: Range<u32> = 0..32;
pub const SET_L1_CONFIGURATION: u32 = 0x0308;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY: Range<u32> = 0..3;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB: u32 = 0x00000001;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_CONTROL: u32 = 0x030c;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER: Range<u32> = 0..1;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE: u32 = 0x00000001;
pub const SET_SPA_VERSION: u32 = 0x0310;
pub const SET_SPA_VERSION_MINOR: Range<u32> = 0..8;
pub const SET_SPA_VERSION_MAJOR: Range<u32> = 8..16;
pub const SET_IEEE_CLEAN_UPDATE: u32 = 0x0314;
pub const SET_IEEE_CLEAN_UPDATE_ENABLE: Range<u32> = 0..1;
pub const SET_IEEE_CLEAN_UPDATE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_IEEE_CLEAN_UPDATE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SNAP_GRID_LINE: u32 = 0x0318;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL: Range<u32> = 0..4;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__2X2: u32 = 0x00000001;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__4X4: u32 = 0x00000002;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__8X8: u32 = 0x00000003;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__16X16: u32 = 0x00000004;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__32X32: u32 = 0x00000005;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__64X64: u32 = 0x00000006;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__128X128: u32 = 0x00000007;
pub const SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__256X256: u32 = 0x00000008;
pub const SET_SNAP_GRID_LINE_ROUNDING_MODE: Range<u32> = 8..9;
pub const SET_SNAP_GRID_LINE_ROUNDING_MODE_RTNE: u32 = 0x00000000;
pub const SET_SNAP_GRID_LINE_ROUNDING_MODE_TESLA: u32 = 0x00000001;
pub const SET_SNAP_GRID_NON_LINE: u32 = 0x031c;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL: Range<u32> = 0..4;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__2X2: u32 = 0x00000001;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__4X4: u32 = 0x00000002;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__8X8: u32 = 0x00000003;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__16X16: u32 = 0x00000004;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__32X32: u32 = 0x00000005;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__64X64: u32 = 0x00000006;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__128X128: u32 = 0x00000007;
pub const SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__256X256: u32 = 0x00000008;
pub const SET_SNAP_GRID_NON_LINE_ROUNDING_MODE: Range<u32> = 8..9;
pub const SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_RTNE: u32 = 0x00000000;
pub const SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_TESLA: u32 = 0x00000001;
pub const SET_TESSELLATION_PARAMETERS: u32 = 0x0320;
pub const SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE: Range<u32> = 0..2;
pub const SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_ISOLINE: u32 = 0x00000000;
pub const SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_TRIANGLE: u32 = 0x00000001;
pub const SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_QUAD: u32 = 0x00000002;
pub const SET_TESSELLATION_PARAMETERS_SPACING: Range<u32> = 4..6;
pub const SET_TESSELLATION_PARAMETERS_SPACING_INTEGER: u32 = 0x00000000;
pub const SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_ODD: u32 = 0x00000001;
pub const SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_EVEN: u32 = 0x00000002;
pub const SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES: Range<u32> = 8..10;
pub const SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_POINTS: u32 = 0x00000000;
pub const SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_LINES: u32 = 0x00000001;
pub const SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CW: u32 = 0x00000002;
pub const SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CCW: u32 = 0x00000003;
pub const SET_TESSELLATION_LOD_U0_OR_DENSITY: u32 = 0x0324;
pub const SET_TESSELLATION_LOD_U0_OR_DENSITY_V: Range<u32> = 0..32;
pub const SET_TESSELLATION_LOD_V0_OR_DETAIL: u32 = 0x0328;
pub const SET_TESSELLATION_LOD_V0_OR_DETAIL_V: Range<u32> = 0..32;
pub const SET_TESSELLATION_LOD_U1_OR_W0: u32 = 0x032c;
pub const SET_TESSELLATION_LOD_U1_OR_W0_V: Range<u32> = 0..32;
pub const SET_TESSELLATION_LOD_V1: u32 = 0x0330;
pub const SET_TESSELLATION_LOD_V1_V: Range<u32> = 0..32;
pub const SET_TG_LOD_INTERIOR_U: u32 = 0x0334;
pub const SET_TG_LOD_INTERIOR_U_V: Range<u32> = 0..32;
pub const SET_TG_LOD_INTERIOR_V: u32 = 0x0338;
pub const SET_TG_LOD_INTERIOR_V_V: Range<u32> = 0..32;
pub const RESERVED_TG07: u32 = 0x033c;
pub const RESERVED_TG07_V: Range<u32> = 0..1;
pub const RESERVED_TG08: u32 = 0x0340;
pub const RESERVED_TG08_V: Range<u32> = 0..1;
pub const RESERVED_TG09: u32 = 0x0344;
pub const RESERVED_TG09_V: Range<u32> = 0..1;
pub const RESERVED_TG10: u32 = 0x0348;
pub const RESERVED_TG10_V: Range<u32> = 0..1;
pub const RESERVED_TG11: u32 = 0x034c;
pub const RESERVED_TG11_V: Range<u32> = 0..1;
pub const RESERVED_TG12: u32 = 0x0350;
pub const RESERVED_TG12_V: Range<u32> = 0..1;
pub const RESERVED_TG13: u32 = 0x0354;
pub const RESERVED_TG13_V: Range<u32> = 0..1;
pub const RESERVED_TG14: u32 = 0x0358;
pub const RESERVED_TG14_V: Range<u32> = 0..1;
pub const RESERVED_TG15: u32 = 0x035c;
pub const RESERVED_TG15_V: Range<u32> = 0..1;
pub const SET_SUBTILING_PERF_KNOB_A: u32 = 0x0360;
pub const SET_SUBTILING_PERF_KNOB_A_FRACTION_OF_SPM_REGISTER_FILE_PER_SUBTILE: Range<u32> = 0..8;
pub const SET_SUBTILING_PERF_KNOB_A_FRACTION_OF_SPM_PIXEL_OUTPUT_BUFFER_PER_SUBTILE: Range<u32> = 8..16;
pub const SET_SUBTILING_PERF_KNOB_A_FRACTION_OF_SPM_TRIANGLE_RAM_PER_SUBTILE: Range<u32> = 16..24;
pub const SET_SUBTILING_PERF_KNOB_A_FRACTION_OF_MAX_QUADS_PER_SUBTILE: Range<u32> = 24..32;
pub const SET_SUBTILING_PERF_KNOB_B: u32 = 0x0364;
pub const SET_SUBTILING_PERF_KNOB_B_FRACTION_OF_MAX_PRIMITIVES_PER_SUBTILE: Range<u32> = 0..8;
pub const SET_SUBTILING_PERF_KNOB_C: u32 = 0x0368;
pub const SET_SUBTILING_PERF_KNOB_C_RESERVED: Range<u32> = 0..1;
pub const SET_ZCULL_SUBREGION_TO_REPORT: u32 = 0x036c;
pub const SET_ZCULL_SUBREGION_TO_REPORT_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_SUBREGION_TO_REPORT_SUBREGION_ID: Range<u32> = 4..12;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE: u32 = 0x0370;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE: Range<u32> = 4..7;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST: u32 = 0x00000000;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT: u32 = 0x00000001;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z: u32 = 0x00000002;
pub const SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST: u32 = 0x00000003;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD: u32 = 0x0374;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE: Range<u32> = 0..1;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE: u32 = 0x00000000;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE: u32 = 0x00000001;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE: Range<u32> = 4..5;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE: u32 = 0x00000000;
pub const SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE: u32 = 0x00000001;
pub const SET_MAX_PATCHES_PER_BATCH: u32 = 0x0378;
pub const SET_MAX_PATCHES_PER_BATCH_V: Range<u32> = 0..6;
pub const SET_RASTER_ENABLE: u32 = 0x037c;
pub const SET_RASTER_ENABLE_V: Range<u32> = 0..1;
pub const SET_RASTER_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_RASTER_ENABLE_V_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_stream_out_buffer_enable  (j: u32) -> u32 { 0x0380+j*32 } 
pub const SET_STREAM_OUT_BUFFER_ENABLE_V: Range<u32> = 0..1;
pub const SET_STREAM_OUT_BUFFER_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_STREAM_OUT_BUFFER_ENABLE_V_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_stream_out_buffer_address_a  (j: u32) -> u32 { 0x0384+j*32 } 
pub const SET_STREAM_OUT_BUFFER_ADDRESS_A_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_stream_out_buffer_address_b  (j: u32) -> u32 { 0x0388+j*32 } 
pub const SET_STREAM_OUT_BUFFER_ADDRESS_B_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_stream_out_buffer_size  (j: u32) -> u32 { 0x038c+j*32 } 
pub const SET_STREAM_OUT_BUFFER_SIZE_BYTES: Range<u32> = 0..32;
#[inline]
pub fn set_stream_out_buffer_load_write_pointer  (j: u32) -> u32 { 0x0390+j*32 } 
pub const SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER_START_OFFSET: Range<u32> = 0..32;
#[inline]
pub fn set_vab_data_typeless  (i: u32) -> u32 { 0x0400+i*4 } 
pub const SET_VAB_DATA_TYPELESS_V: Range<u32> = 0..32;
#[inline]
pub fn set_stream_out_control_stream  (j: u32) -> u32 { 0x0700+j*16 } 
pub const SET_STREAM_OUT_CONTROL_STREAM_SELECT: Range<u32> = 0..2;
#[inline]
pub fn set_stream_out_control_component_count  (j: u32) -> u32 { 0x0704+j*16 } 
pub const SET_STREAM_OUT_CONTROL_COMPONENT_COUNT_MAX: Range<u32> = 0..8;
#[inline]
pub fn set_stream_out_control_stride  (j: u32) -> u32 { 0x0708+j*16 } 
pub const SET_STREAM_OUT_CONTROL_STRIDE_BYTES: Range<u32> = 0..32;
pub const SET_RASTER_INPUT: u32 = 0x0740;
pub const SET_RASTER_INPUT_STREAM_SELECT: Range<u32> = 0..2;
pub const SET_STREAM_OUTPUT: u32 = 0x0744;
pub const SET_STREAM_OUTPUT_ENABLE: Range<u32> = 0..1;
pub const SET_STREAM_OUTPUT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STREAM_OUTPUT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE: u32 = 0x0748;
pub const SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE: Range<u32> = 0..1;
pub const SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ALPHA_FRACTION: u32 = 0x074c;
pub const SET_ALPHA_FRACTION_V: Range<u32> = 0..8;
pub const SET_HYBRID_ANTI_ALIAS_CONTROL: u32 = 0x0754;
pub const SET_HYBRID_ANTI_ALIAS_CONTROL_PASSES: Range<u32> = 0..4;
pub const SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID: Range<u32> = 4..5;
pub const SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT: u32 = 0x00000000;
pub const SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS: u32 = 0x00000001;
pub const SET_MAX_TI_WARPS_PER_BATCH: u32 = 0x075c;
pub const SET_MAX_TI_WARPS_PER_BATCH_V: Range<u32> = 0..6;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW: u32 = 0x077c;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_BASE_ADDRESS: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_A: u32 = 0x0790;
pub const SET_SHADER_LOCAL_MEMORY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_SHADER_LOCAL_MEMORY_B: u32 = 0x0794;
pub const SET_SHADER_LOCAL_MEMORY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_C: u32 = 0x0798;
pub const SET_SHADER_LOCAL_MEMORY_C_SIZE_UPPER: Range<u32> = 0..6;
pub const SET_SHADER_LOCAL_MEMORY_D: u32 = 0x079c;
pub const SET_SHADER_LOCAL_MEMORY_D_SIZE_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_E: u32 = 0x07a0;
pub const SET_SHADER_LOCAL_MEMORY_E_DEFAULT_SIZE_PER_WARP: Range<u32> = 0..26;
pub const SET_COLOR_ZERO_BANDWIDTH_CLEAR: u32 = 0x07a4;
pub const SET_COLOR_ZERO_BANDWIDTH_CLEAR_SLOT_DISABLE_MASK: Range<u32> = 0..15;
pub const SET_Z_ZERO_BANDWIDTH_CLEAR: u32 = 0x07a8;
pub const SET_Z_ZERO_BANDWIDTH_CLEAR_SLOT_DISABLE_MASK: Range<u32> = 0..15;
pub const SET_ISBE_SAVE_RESTORE_PROGRAM: u32 = 0x07ac;
pub const SET_ISBE_SAVE_RESTORE_PROGRAM_OFFSET: Range<u32> = 0..32;
#[inline]
pub fn set_vab_vertex2f  (i: u32) -> u32 { 0x07b0+i*4 } 
pub const SET_VAB_VERTEX2F_V: Range<u32> = 0..32;
pub const SET_ZCULL_REGION_SIZE_A: u32 = 0x07c0;
pub const SET_ZCULL_REGION_SIZE_A_WIDTH: Range<u32> = 0..16;
pub const SET_ZCULL_REGION_SIZE_B: u32 = 0x07c4;
pub const SET_ZCULL_REGION_SIZE_B_HEIGHT: Range<u32> = 0..16;
pub const SET_ZCULL_REGION_SIZE_C: u32 = 0x07c8;
pub const SET_ZCULL_REGION_SIZE_C_DEPTH: Range<u32> = 0..16;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_C: u32 = 0x07cc;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_C_DEPTH: Range<u32> = 0..16;
pub const SET_CULL_BEFORE_FETCH: u32 = 0x07dc;
pub const SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE: Range<u32> = 0..1;
pub const SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_FALSE: u32 = 0x00000000;
pub const SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_REGION_LOCATION: u32 = 0x07e0;
pub const SET_ZCULL_REGION_LOCATION_START_ALIQUOT: Range<u32> = 0..16;
pub const SET_ZCULL_REGION_LOCATION_ALIQUOT_COUNT: Range<u32> = 16..32;
pub const SET_ZCULL_REGION_ALIQUOTS: u32 = 0x07e4;
pub const SET_ZCULL_REGION_ALIQUOTS_PER_LAYER: Range<u32> = 0..16;
pub const SET_ZCULL_STORAGE_A: u32 = 0x07e8;
pub const SET_ZCULL_STORAGE_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_ZCULL_STORAGE_B: u32 = 0x07ec;
pub const SET_ZCULL_STORAGE_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_ZCULL_STORAGE_C: u32 = 0x07f0;
pub const SET_ZCULL_STORAGE_C_LIMIT_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_ZCULL_STORAGE_D: u32 = 0x07f4;
pub const SET_ZCULL_STORAGE_D_LIMIT_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_ZT_READ_ONLY: u32 = 0x07f8;
pub const SET_ZT_READ_ONLY_ENABLE_Z: Range<u32> = 0..1;
pub const SET_ZT_READ_ONLY_ENABLE_Z_FALSE: u32 = 0x00000000;
pub const SET_ZT_READ_ONLY_ENABLE_Z_TRUE: u32 = 0x00000001;
pub const SET_ZT_READ_ONLY_ENABLE_STENCIL: Range<u32> = 4..5;
pub const SET_ZT_READ_ONLY_ENABLE_STENCIL_FALSE: u32 = 0x00000000;
pub const SET_ZT_READ_ONLY_ENABLE_STENCIL_TRUE: u32 = 0x00000001;
pub const SET_TEXTURE_INSTRUCTION_OPERAND: u32 = 0x07fc;
pub const SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING: Range<u32> = 0..1;
pub const SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_FERMI_ORDER: u32 = 0x00000000;
pub const SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_KEPLER_ORDER: u32 = 0x00000001;
#[inline]
pub fn set_color_target_a  (j: u32) -> u32 { 0x0800+j*64 } 
pub const SET_COLOR_TARGET_A_OFFSET_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_color_target_b  (j: u32) -> u32 { 0x0804+j*64 } 
pub const SET_COLOR_TARGET_B_OFFSET_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_color_target_width  (j: u32) -> u32 { 0x0808+j*64 } 
pub const SET_COLOR_TARGET_WIDTH_V: Range<u32> = 0..28;
#[inline]
pub fn set_color_target_height  (j: u32) -> u32 { 0x080c+j*64 } 
pub const SET_COLOR_TARGET_HEIGHT_V: Range<u32> = 0..17;
#[inline]
pub fn set_color_target_format  (j: u32) -> u32 { 0x0810+j*64 } 
pub const SET_COLOR_TARGET_FORMAT_V: Range<u32> = 0..8;
pub const SET_COLOR_TARGET_FORMAT_V_DISABLED: u32 = 0x00000000;
pub const SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32: u32 = 0x000000C0;
pub const SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32: u32 = 0x000000C1;
pub const SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32: u32 = 0x000000C2;
pub const SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32: u32 = 0x000000C3;
pub const SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32: u32 = 0x000000C4;
pub const SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32: u32 = 0x000000C5;
pub const SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16: u32 = 0x000000C6;
pub const SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16: u32 = 0x000000C7;
pub const SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16: u32 = 0x000000C8;
pub const SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16: u32 = 0x000000C9;
pub const SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16: u32 = 0x000000CA;
pub const SET_COLOR_TARGET_FORMAT_V_RF32_GF32: u32 = 0x000000CB;
pub const SET_COLOR_TARGET_FORMAT_V_RS32_GS32: u32 = 0x000000CC;
pub const SET_COLOR_TARGET_FORMAT_V_RU32_GU32: u32 = 0x000000CD;
pub const SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16: u32 = 0x000000CE;
pub const SET_COLOR_TARGET_FORMAT_V_A8R8G8B8: u32 = 0x000000CF;
pub const SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8: u32 = 0x000000D0;
pub const SET_COLOR_TARGET_FORMAT_V_A2B10G10R10: u32 = 0x000000D1;
pub const SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10: u32 = 0x000000D2;
pub const SET_COLOR_TARGET_FORMAT_V_A8B8G8R8: u32 = 0x000000D5;
pub const SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8: u32 = 0x000000D6;
pub const SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8: u32 = 0x000000D7;
pub const SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8: u32 = 0x000000D8;
pub const SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8: u32 = 0x000000D9;
pub const SET_COLOR_TARGET_FORMAT_V_R16_G16: u32 = 0x000000DA;
pub const SET_COLOR_TARGET_FORMAT_V_RN16_GN16: u32 = 0x000000DB;
pub const SET_COLOR_TARGET_FORMAT_V_RS16_GS16: u32 = 0x000000DC;
pub const SET_COLOR_TARGET_FORMAT_V_RU16_GU16: u32 = 0x000000DD;
pub const SET_COLOR_TARGET_FORMAT_V_RF16_GF16: u32 = 0x000000DE;
pub const SET_COLOR_TARGET_FORMAT_V_A2R10G10B10: u32 = 0x000000DF;
pub const SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11: u32 = 0x000000E0;
pub const SET_COLOR_TARGET_FORMAT_V_RS32: u32 = 0x000000E3;
pub const SET_COLOR_TARGET_FORMAT_V_RU32: u32 = 0x000000E4;
pub const SET_COLOR_TARGET_FORMAT_V_RF32: u32 = 0x000000E5;
pub const SET_COLOR_TARGET_FORMAT_V_X8R8G8B8: u32 = 0x000000E6;
pub const SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8: u32 = 0x000000E7;
pub const SET_COLOR_TARGET_FORMAT_V_R5G6B5: u32 = 0x000000E8;
pub const SET_COLOR_TARGET_FORMAT_V_A1R5G5B5: u32 = 0x000000E9;
pub const SET_COLOR_TARGET_FORMAT_V_G8R8: u32 = 0x000000EA;
pub const SET_COLOR_TARGET_FORMAT_V_GN8RN8: u32 = 0x000000EB;
pub const SET_COLOR_TARGET_FORMAT_V_GS8RS8: u32 = 0x000000EC;
pub const SET_COLOR_TARGET_FORMAT_V_GU8RU8: u32 = 0x000000ED;
pub const SET_COLOR_TARGET_FORMAT_V_R16: u32 = 0x000000EE;
pub const SET_COLOR_TARGET_FORMAT_V_RN16: u32 = 0x000000EF;
pub const SET_COLOR_TARGET_FORMAT_V_RS16: u32 = 0x000000F0;
pub const SET_COLOR_TARGET_FORMAT_V_RU16: u32 = 0x000000F1;
pub const SET_COLOR_TARGET_FORMAT_V_RF16: u32 = 0x000000F2;
pub const SET_COLOR_TARGET_FORMAT_V_R8: u32 = 0x000000F3;
pub const SET_COLOR_TARGET_FORMAT_V_RN8: u32 = 0x000000F4;
pub const SET_COLOR_TARGET_FORMAT_V_RS8: u32 = 0x000000F5;
pub const SET_COLOR_TARGET_FORMAT_V_RU8: u32 = 0x000000F6;
pub const SET_COLOR_TARGET_FORMAT_V_A8: u32 = 0x000000F7;
pub const SET_COLOR_TARGET_FORMAT_V_X1R5G5B5: u32 = 0x000000F8;
pub const SET_COLOR_TARGET_FORMAT_V_X8B8G8R8: u32 = 0x000000F9;
pub const SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8: u32 = 0x000000FA;
pub const SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_COLOR_TARGET_FORMAT_V_O1R5G5B5: u32 = 0x000000FC;
pub const SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_COLOR_TARGET_FORMAT_V_O8R8G8B8: u32 = 0x000000FE;
pub const SET_COLOR_TARGET_FORMAT_V_R32: u32 = 0x000000FF;
pub const SET_COLOR_TARGET_FORMAT_V_A16: u32 = 0x00000040;
pub const SET_COLOR_TARGET_FORMAT_V_AF16: u32 = 0x00000041;
pub const SET_COLOR_TARGET_FORMAT_V_AF32: u32 = 0x00000042;
pub const SET_COLOR_TARGET_FORMAT_V_A8R8: u32 = 0x00000043;
pub const SET_COLOR_TARGET_FORMAT_V_R16_A16: u32 = 0x00000044;
pub const SET_COLOR_TARGET_FORMAT_V_RF16_AF16: u32 = 0x00000045;
pub const SET_COLOR_TARGET_FORMAT_V_RF32_AF32: u32 = 0x00000046;
pub const SET_COLOR_TARGET_FORMAT_V_B8G8R8A8: u32 = 0x00000047;
#[inline]
pub fn set_color_target_memory  (j: u32) -> u32 { 0x0814+j*64 } 
pub const SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH: Range<u32> = 0..4;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT: Range<u32> = 4..8;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH: Range<u32> = 8..12;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_COLOR_TARGET_MEMORY_LAYOUT: Range<u32> = 12..13;
pub const SET_COLOR_TARGET_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL: Range<u32> = 16..17;
pub const SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE: u32 = 0x00000001;
#[inline]
pub fn set_color_target_third_dimension  (j: u32) -> u32 { 0x0818+j*64 } 
pub const SET_COLOR_TARGET_THIRD_DIMENSION_V: Range<u32> = 0..28;
#[inline]
pub fn set_color_target_array_pitch  (j: u32) -> u32 { 0x081c+j*64 } 
pub const SET_COLOR_TARGET_ARRAY_PITCH_V: Range<u32> = 0..32;
#[inline]
pub fn set_color_target_layer  (j: u32) -> u32 { 0x0820+j*64 } 
pub const SET_COLOR_TARGET_LAYER_OFFSET: Range<u32> = 0..16;
#[inline]
pub fn set_color_target_mark  (j: u32) -> u32 { 0x0824+j*64 } 
pub const SET_COLOR_TARGET_MARK_IEEE_CLEAN: Range<u32> = 0..1;
pub const SET_COLOR_TARGET_MARK_IEEE_CLEAN_FALSE: u32 = 0x00000000;
pub const SET_COLOR_TARGET_MARK_IEEE_CLEAN_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_viewport_scale_x  (j: u32) -> u32 { 0x0a00+j*32 } 
pub const SET_VIEWPORT_SCALE_X_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_scale_y  (j: u32) -> u32 { 0x0a04+j*32 } 
pub const SET_VIEWPORT_SCALE_Y_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_scale_z  (j: u32) -> u32 { 0x0a08+j*32 } 
pub const SET_VIEWPORT_SCALE_Z_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_offset_x  (j: u32) -> u32 { 0x0a0c+j*32 } 
pub const SET_VIEWPORT_OFFSET_X_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_offset_y  (j: u32) -> u32 { 0x0a10+j*32 } 
pub const SET_VIEWPORT_OFFSET_Y_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_offset_z  (j: u32) -> u32 { 0x0a14+j*32 } 
pub const SET_VIEWPORT_OFFSET_Z_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_clip_horizontal  (j: u32) -> u32 { 0x0c00+j*16 } 
pub const SET_VIEWPORT_CLIP_HORIZONTAL_X0: Range<u32> = 0..16;
pub const SET_VIEWPORT_CLIP_HORIZONTAL_WIDTH: Range<u32> = 16..32;
#[inline]
pub fn set_viewport_clip_vertical  (j: u32) -> u32 { 0x0c04+j*16 } 
pub const SET_VIEWPORT_CLIP_VERTICAL_Y0: Range<u32> = 0..16;
pub const SET_VIEWPORT_CLIP_VERTICAL_HEIGHT: Range<u32> = 16..32;
#[inline]
pub fn set_viewport_clip_min_z  (j: u32) -> u32 { 0x0c08+j*16 } 
pub const SET_VIEWPORT_CLIP_MIN_Z_V: Range<u32> = 0..32;
#[inline]
pub fn set_viewport_clip_max_z  (j: u32) -> u32 { 0x0c0c+j*16 } 
pub const SET_VIEWPORT_CLIP_MAX_Z_V: Range<u32> = 0..32;
#[inline]
pub fn set_window_clip_horizontal  (j: u32) -> u32 { 0x0d00+j*8 } 
pub const SET_WINDOW_CLIP_HORIZONTAL_XMIN: Range<u32> = 0..16;
pub const SET_WINDOW_CLIP_HORIZONTAL_XMAX: Range<u32> = 16..32;
#[inline]
pub fn set_window_clip_vertical  (j: u32) -> u32 { 0x0d04+j*8 } 
pub const SET_WINDOW_CLIP_VERTICAL_YMIN: Range<u32> = 0..16;
pub const SET_WINDOW_CLIP_VERTICAL_YMAX: Range<u32> = 16..32;
#[inline]
pub fn set_clip_id_extent_x  (j: u32) -> u32 { 0x0d40+j*8 } 
pub const SET_CLIP_ID_EXTENT_X_MINX: Range<u32> = 0..16;
pub const SET_CLIP_ID_EXTENT_X_WIDTH: Range<u32> = 16..32;
#[inline]
pub fn set_clip_id_extent_y  (j: u32) -> u32 { 0x0d44+j*8 } 
pub const SET_CLIP_ID_EXTENT_Y_MINY: Range<u32> = 0..16;
pub const SET_CLIP_ID_EXTENT_Y_HEIGHT: Range<u32> = 16..32;
pub const SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK: u32 = 0x0d60;
pub const SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK_V: Range<u32> = 0..11;
pub const SET_API_VISIBLE_CALL_LIMIT: u32 = 0x0d64;
pub const SET_API_VISIBLE_CALL_LIMIT_V: Range<u32> = 0..4;
pub const SET_API_VISIBLE_CALL_LIMIT_V__0: u32 = 0x00000000;
pub const SET_API_VISIBLE_CALL_LIMIT_V__1: u32 = 0x00000001;
pub const SET_API_VISIBLE_CALL_LIMIT_V__2: u32 = 0x00000002;
pub const SET_API_VISIBLE_CALL_LIMIT_V__4: u32 = 0x00000003;
pub const SET_API_VISIBLE_CALL_LIMIT_V__8: u32 = 0x00000004;
pub const SET_API_VISIBLE_CALL_LIMIT_V__16: u32 = 0x00000005;
pub const SET_API_VISIBLE_CALL_LIMIT_V__32: u32 = 0x00000006;
pub const SET_API_VISIBLE_CALL_LIMIT_V__64: u32 = 0x00000007;
pub const SET_API_VISIBLE_CALL_LIMIT_V__128: u32 = 0x00000008;
pub const SET_API_VISIBLE_CALL_LIMIT_V_NO_CHECK: u32 = 0x0000000F;
pub const SET_STATISTICS_COUNTER: u32 = 0x0d68;
pub const SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE: Range<u32> = 0..1;
pub const SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE: Range<u32> = 1..2;
pub const SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE: Range<u32> = 2..3;
pub const SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE: Range<u32> = 3..4;
pub const SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE: Range<u32> = 4..5;
pub const SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE: Range<u32> = 5..6;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE: Range<u32> = 6..7;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE: Range<u32> = 7..8;
pub const SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE: Range<u32> = 8..9;
pub const SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE: Range<u32> = 9..10;
pub const SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE: Range<u32> = 11..12;
pub const SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE: Range<u32> = 12..13;
pub const SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE: Range<u32> = 13..14;
pub const SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE: Range<u32> = 14..15;
pub const SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE: Range<u32> = 10..11;
pub const SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE: Range<u32> = 15..16;
pub const SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_CLEAR_RECT_HORIZONTAL: u32 = 0x0d6c;
pub const SET_CLEAR_RECT_HORIZONTAL_XMIN: Range<u32> = 0..16;
pub const SET_CLEAR_RECT_HORIZONTAL_XMAX: Range<u32> = 16..32;
pub const SET_CLEAR_RECT_VERTICAL: u32 = 0x0d70;
pub const SET_CLEAR_RECT_VERTICAL_YMIN: Range<u32> = 0..16;
pub const SET_CLEAR_RECT_VERTICAL_YMAX: Range<u32> = 16..32;
pub const SET_VERTEX_ARRAY_START: u32 = 0x0d74;
pub const SET_VERTEX_ARRAY_START_V: Range<u32> = 0..32;
pub const DRAW_VERTEX_ARRAY: u32 = 0x0d78;
pub const DRAW_VERTEX_ARRAY_COUNT: Range<u32> = 0..32;
pub const SET_VIEWPORT_Z_CLIP: u32 = 0x0d7c;
pub const SET_VIEWPORT_Z_CLIP_RANGE: Range<u32> = 0..1;
pub const SET_VIEWPORT_Z_CLIP_RANGE_NEGATIVE_W_TO_POSITIVE_W: u32 = 0x00000000;
pub const SET_VIEWPORT_Z_CLIP_RANGE_ZERO_TO_POSITIVE_W: u32 = 0x00000001;
#[inline]
pub fn set_color_clear_value  (i: u32) -> u32 { 0x0d80+i*4 } 
pub const SET_COLOR_CLEAR_VALUE_V: Range<u32> = 0..32;
pub const SET_Z_CLEAR_VALUE: u32 = 0x0d90;
pub const SET_Z_CLEAR_VALUE_V: Range<u32> = 0..32;
pub const SET_SHADER_CACHE_CONTROL: u32 = 0x0d94;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE: u32 = 0x00000001;
pub const FORCE_TRANSITION_TO_BETA: u32 = 0x0d98;
pub const FORCE_TRANSITION_TO_BETA_V: Range<u32> = 0..1;
pub const SET_REDUCE_COLOR_THRESHOLDS_ENABLE: u32 = 0x0d9c;
pub const SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V: Range<u32> = 0..1;
pub const SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_STENCIL_CLEAR_VALUE: u32 = 0x0da0;
pub const SET_STENCIL_CLEAR_VALUE_V: Range<u32> = 0..8;
pub const INVALIDATE_SHADER_CACHES_NO_WFI: u32 = 0x0da4;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE: u32 = 0x00000001;
pub const SET_FRONT_POLYGON_MODE: u32 = 0x0dac;
pub const SET_FRONT_POLYGON_MODE_V: Range<u32> = 0..32;
pub const SET_FRONT_POLYGON_MODE_V_POINT: u32 = 0x00001B00;
pub const SET_FRONT_POLYGON_MODE_V_LINE: u32 = 0x00001B01;
pub const SET_FRONT_POLYGON_MODE_V_FILL: u32 = 0x00001B02;
pub const SET_BACK_POLYGON_MODE: u32 = 0x0db0;
pub const SET_BACK_POLYGON_MODE_V: Range<u32> = 0..32;
pub const SET_BACK_POLYGON_MODE_V_POINT: u32 = 0x00001B00;
pub const SET_BACK_POLYGON_MODE_V_LINE: u32 = 0x00001B01;
pub const SET_BACK_POLYGON_MODE_V_FILL: u32 = 0x00001B02;
pub const SET_POLY_SMOOTH: u32 = 0x0db4;
pub const SET_POLY_SMOOTH_ENABLE: Range<u32> = 0..1;
pub const SET_POLY_SMOOTH_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POLY_SMOOTH_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZT_MARK: u32 = 0x0db8;
pub const SET_ZT_MARK_IEEE_CLEAN: Range<u32> = 0..1;
pub const SET_ZT_MARK_IEEE_CLEAN_FALSE: u32 = 0x00000000;
pub const SET_ZT_MARK_IEEE_CLEAN_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_DIR_FORMAT: u32 = 0x0dbc;
pub const SET_ZCULL_DIR_FORMAT_ZDIR: Range<u32> = 0..16;
pub const SET_ZCULL_DIR_FORMAT_ZDIR_LESS: u32 = 0x00000000;
pub const SET_ZCULL_DIR_FORMAT_ZDIR_GREATER: u32 = 0x00000001;
pub const SET_ZCULL_DIR_FORMAT_ZFORMAT: Range<u32> = 16..32;
pub const SET_ZCULL_DIR_FORMAT_ZFORMAT_MSB: u32 = 0x00000000;
pub const SET_ZCULL_DIR_FORMAT_ZFORMAT_FP: u32 = 0x00000001;
pub const SET_ZCULL_DIR_FORMAT_ZFORMAT_ZTRICK: u32 = 0x00000002;
pub const SET_ZCULL_DIR_FORMAT_ZFORMAT_ZF32_1: u32 = 0x00000003;
pub const SET_POLY_OFFSET_POINT: u32 = 0x0dc0;
pub const SET_POLY_OFFSET_POINT_ENABLE: Range<u32> = 0..1;
pub const SET_POLY_OFFSET_POINT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POLY_OFFSET_POINT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POLY_OFFSET_LINE: u32 = 0x0dc4;
pub const SET_POLY_OFFSET_LINE_ENABLE: Range<u32> = 0..1;
pub const SET_POLY_OFFSET_LINE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POLY_OFFSET_LINE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POLY_OFFSET_FILL: u32 = 0x0dc8;
pub const SET_POLY_OFFSET_FILL_ENABLE: Range<u32> = 0..1;
pub const SET_POLY_OFFSET_FILL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POLY_OFFSET_FILL_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_PATCH: u32 = 0x0dcc;
pub const SET_PATCH_SIZE: Range<u32> = 0..8;
pub const SET_ZCULL_CRITERION: u32 = 0x0dd8;
pub const SET_ZCULL_CRITERION_SFUNC: Range<u32> = 0..8;
pub const SET_ZCULL_CRITERION_SFUNC_NEVER: u32 = 0x00000000;
pub const SET_ZCULL_CRITERION_SFUNC_LESS: u32 = 0x00000001;
pub const SET_ZCULL_CRITERION_SFUNC_EQUAL: u32 = 0x00000002;
pub const SET_ZCULL_CRITERION_SFUNC_LEQUAL: u32 = 0x00000003;
pub const SET_ZCULL_CRITERION_SFUNC_GREATER: u32 = 0x00000004;
pub const SET_ZCULL_CRITERION_SFUNC_NOTEQUAL: u32 = 0x00000005;
pub const SET_ZCULL_CRITERION_SFUNC_GEQUAL: u32 = 0x00000006;
pub const SET_ZCULL_CRITERION_SFUNC_ALWAYS: u32 = 0x00000007;
pub const SET_ZCULL_CRITERION_NO_INVALIDATE: Range<u32> = 8..9;
pub const SET_ZCULL_CRITERION_NO_INVALIDATE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_CRITERION_NO_INVALIDATE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_CRITERION_FORCE_MATCH: Range<u32> = 9..10;
pub const SET_ZCULL_CRITERION_FORCE_MATCH_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_CRITERION_FORCE_MATCH_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_CRITERION_SREF: Range<u32> = 16..24;
pub const SET_ZCULL_CRITERION_SMASK: Range<u32> = 24..32;
pub const SET_SM_TIMEOUT_INTERVAL: u32 = 0x0de4;
pub const SET_SM_TIMEOUT_INTERVAL_COUNTER_BIT: Range<u32> = 0..6;
pub const SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY: u32 = 0x0de8;
pub const SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE: Range<u32> = 0..1;
pub const SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_DRAW_INLINE_VERTEX_VAB_UPDATE: u32 = 0x0dec;
pub const SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE: Range<u32> = 0..1;
pub const SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_WINDOW_OFFSET_X: u32 = 0x0df8;
pub const SET_WINDOW_OFFSET_X_V: Range<u32> = 0..17;
pub const SET_WINDOW_OFFSET_Y: u32 = 0x0dfc;
pub const SET_WINDOW_OFFSET_Y_V: Range<u32> = 0..18;
#[inline]
pub fn set_scissor_enable  (j: u32) -> u32 { 0x0e00+j*16 } 
pub const SET_SCISSOR_ENABLE_V: Range<u32> = 0..1;
pub const SET_SCISSOR_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_SCISSOR_ENABLE_V_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_scissor_horizontal  (j: u32) -> u32 { 0x0e04+j*16 } 
pub const SET_SCISSOR_HORIZONTAL_XMIN: Range<u32> = 0..16;
pub const SET_SCISSOR_HORIZONTAL_XMAX: Range<u32> = 16..32;
#[inline]
pub fn set_scissor_vertical  (j: u32) -> u32 { 0x0e08+j*16 } 
pub const SET_SCISSOR_VERTICAL_YMIN: Range<u32> = 0..16;
pub const SET_SCISSOR_VERTICAL_YMAX: Range<u32> = 16..32;
#[inline]
pub fn set_vab_normal3s  (i: u32) -> u32 { 0x0f00+i*4 } 
pub const SET_VAB_NORMAL3S_V: Range<u32> = 0..32;
pub const SET_BACK_STENCIL_FUNC_REF: u32 = 0x0f54;
pub const SET_BACK_STENCIL_FUNC_REF_V: Range<u32> = 0..8;
pub const SET_BACK_STENCIL_MASK: u32 = 0x0f58;
pub const SET_BACK_STENCIL_MASK_V: Range<u32> = 0..8;
pub const SET_BACK_STENCIL_FUNC_MASK: u32 = 0x0f5c;
pub const SET_BACK_STENCIL_FUNC_MASK_V: Range<u32> = 0..8;
pub const SET_VERTEX_STREAM_SUBSTITUTE_A: u32 = 0x0f84;
pub const SET_VERTEX_STREAM_SUBSTITUTE_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_VERTEX_STREAM_SUBSTITUTE_B: u32 = 0x0f88;
pub const SET_VERTEX_STREAM_SUBSTITUTE_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_LINE_MODE_POLYGON_CLIP: u32 = 0x0f8c;
pub const SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE: Range<u32> = 0..1;
pub const SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DRAW_LINE: u32 = 0x00000000;
pub const SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DO_NOT_DRAW_LINE: u32 = 0x00000001;
pub const SET_SINGLE_CT_WRITE_CONTROL: u32 = 0x0f90;
pub const SET_SINGLE_CT_WRITE_CONTROL_ENABLE: Range<u32> = 0..1;
pub const SET_SINGLE_CT_WRITE_CONTROL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SINGLE_CT_WRITE_CONTROL_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_VTG_WARP_WATERMARKS: u32 = 0x0f98;
pub const SET_VTG_WARP_WATERMARKS_LOW: Range<u32> = 0..16;
pub const SET_VTG_WARP_WATERMARKS_HIGH: Range<u32> = 16..32;
pub const SET_DEPTH_BOUNDS_MIN: u32 = 0x0f9c;
pub const SET_DEPTH_BOUNDS_MIN_V: Range<u32> = 0..32;
pub const SET_DEPTH_BOUNDS_MAX: u32 = 0x0fa0;
pub const SET_DEPTH_BOUNDS_MAX_V: Range<u32> = 0..32;
pub const SET_CT_MRT_ENABLE: u32 = 0x0fac;
pub const SET_CT_MRT_ENABLE_V: Range<u32> = 0..1;
pub const SET_CT_MRT_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_CT_MRT_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_NONMULTISAMPLED_Z: u32 = 0x0fb0;
pub const SET_NONMULTISAMPLED_Z_V: Range<u32> = 0..1;
pub const SET_NONMULTISAMPLED_Z_V_PER_SAMPLE: u32 = 0x00000000;
pub const SET_NONMULTISAMPLED_Z_V_AT_PIXEL_CENTER: u32 = 0x00000001;
pub const SET_SAMPLE_MASK_X0_Y0: u32 = 0x0fbc;
pub const SET_SAMPLE_MASK_X0_Y0_V: Range<u32> = 0..16;
pub const SET_SAMPLE_MASK_X1_Y0: u32 = 0x0fc0;
pub const SET_SAMPLE_MASK_X1_Y0_V: Range<u32> = 0..16;
pub const SET_SAMPLE_MASK_X0_Y1: u32 = 0x0fc4;
pub const SET_SAMPLE_MASK_X0_Y1_V: Range<u32> = 0..16;
pub const SET_SAMPLE_MASK_X1_Y1: u32 = 0x0fc8;
pub const SET_SAMPLE_MASK_X1_Y1_V: Range<u32> = 0..16;
pub const SET_SURFACE_CLIP_ID_MEMORY_A: u32 = 0x0fcc;
pub const SET_SURFACE_CLIP_ID_MEMORY_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_SURFACE_CLIP_ID_MEMORY_B: u32 = 0x0fd0;
pub const SET_SURFACE_CLIP_ID_MEMORY_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_BLEND_OPT_CONTROL: u32 = 0x0fdc;
pub const SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS: Range<u32> = 0..1;
pub const SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_FALSE: u32 = 0x00000000;
pub const SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_TRUE: u32 = 0x00000001;
pub const SET_ZT_A: u32 = 0x0fe0;
pub const SET_ZT_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_ZT_B: u32 = 0x0fe4;
pub const SET_ZT_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_ZT_FORMAT: u32 = 0x0fe8;
pub const SET_ZT_FORMAT_V: Range<u32> = 0..5;
pub const SET_ZT_FORMAT_V_Z16: u32 = 0x00000013;
pub const SET_ZT_FORMAT_V_Z24S8: u32 = 0x00000014;
pub const SET_ZT_FORMAT_V_X8Z24: u32 = 0x00000015;
pub const SET_ZT_FORMAT_V_S8Z24: u32 = 0x00000016;
pub const SET_ZT_FORMAT_V_V8Z24: u32 = 0x00000018;
pub const SET_ZT_FORMAT_V_ZF32: u32 = 0x0000000A;
pub const SET_ZT_FORMAT_V_ZF32_X24S8: u32 = 0x00000019;
pub const SET_ZT_FORMAT_V_X8Z24_X16V8S8: u32 = 0x0000001D;
pub const SET_ZT_FORMAT_V_ZF32_X16V8X8: u32 = 0x0000001E;
pub const SET_ZT_FORMAT_V_ZF32_X16V8S8: u32 = 0x0000001F;
pub const SET_ZT_BLOCK_SIZE: u32 = 0x0fec;
pub const SET_ZT_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_ZT_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_ZT_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_ZT_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_ZT_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_ZT_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_ZT_ARRAY_PITCH: u32 = 0x0ff0;
pub const SET_ZT_ARRAY_PITCH_V: Range<u32> = 0..32;
pub const SET_SURFACE_CLIP_HORIZONTAL: u32 = 0x0ff4;
pub const SET_SURFACE_CLIP_HORIZONTAL_X: Range<u32> = 0..16;
pub const SET_SURFACE_CLIP_HORIZONTAL_WIDTH: Range<u32> = 16..32;
pub const SET_SURFACE_CLIP_VERTICAL: u32 = 0x0ff8;
pub const SET_SURFACE_CLIP_VERTICAL_Y: Range<u32> = 0..16;
pub const SET_SURFACE_CLIP_VERTICAL_HEIGHT: Range<u32> = 16..32;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS: u32 = 0x1000;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE: Range<u32> = 0..1;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_FALSE: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_TRUE: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const SET_TESSELLATION_CUT_HEIGHT: u32 = 0x1008;
pub const SET_TESSELLATION_CUT_HEIGHT_V: Range<u32> = 0..5;
pub const SET_MAX_GS_INSTANCES_PER_TASK: u32 = 0x100c;
pub const SET_MAX_GS_INSTANCES_PER_TASK_V: Range<u32> = 0..11;
pub const SET_MAX_GS_OUTPUT_VERTICES_PER_TASK: u32 = 0x1010;
pub const SET_MAX_GS_OUTPUT_VERTICES_PER_TASK_V: Range<u32> = 0..16;
pub const SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER: u32 = 0x1018;
pub const SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER_V: Range<u32> = 0..10;
pub const SET_BETA_CB_STORAGE_CONSTRAINT: u32 = 0x101c;
pub const SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE: Range<u32> = 0..1;
pub const SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER: u32 = 0x1020;
pub const SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER_V: Range<u32> = 0..10;
pub const SET_ALPHA_CB_STORAGE_CONSTRAINT: u32 = 0x1024;
pub const SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE: Range<u32> = 0..1;
pub const SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SPARE_NOOP00: u32 = 0x1040;
pub const SET_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP01: u32 = 0x1044;
pub const SET_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP02: u32 = 0x1048;
pub const SET_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP03: u32 = 0x104c;
pub const SET_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP04: u32 = 0x1050;
pub const SET_SPARE_NOOP04_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP05: u32 = 0x1054;
pub const SET_SPARE_NOOP05_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP06: u32 = 0x1058;
pub const SET_SPARE_NOOP06_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP07: u32 = 0x105c;
pub const SET_SPARE_NOOP07_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP08: u32 = 0x1060;
pub const SET_SPARE_NOOP08_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP09: u32 = 0x1064;
pub const SET_SPARE_NOOP09_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP10: u32 = 0x1068;
pub const SET_SPARE_NOOP10_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP11: u32 = 0x106c;
pub const SET_SPARE_NOOP11_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP12: u32 = 0x1070;
pub const SET_SPARE_NOOP12_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP13: u32 = 0x1074;
pub const SET_SPARE_NOOP13_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP14: u32 = 0x1078;
pub const SET_SPARE_NOOP14_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP15: u32 = 0x107c;
pub const SET_SPARE_NOOP15_V: Range<u32> = 0..32;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM8: u32 = 0x10cc;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM8_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..8;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM8_ALL_COVERED: Range<u32> = 16..24;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM10: u32 = 0x10e0;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM10_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..8;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM10_ALL_COVERED: Range<u32> = 16..24;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM16: u32 = 0x10e4;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM16_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..8;
pub const SET_REDUCE_COLOR_THRESHOLDS_UNORM16_ALL_COVERED: Range<u32> = 16..24;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP11: u32 = 0x10e8;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP11_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..6;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP11_ALL_COVERED: Range<u32> = 16..22;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP16: u32 = 0x10ec;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP16_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..8;
pub const SET_REDUCE_COLOR_THRESHOLDS_FP16_ALL_COVERED: Range<u32> = 16..24;
pub const SET_REDUCE_COLOR_THRESHOLDS_SRGB8: u32 = 0x10f0;
pub const SET_REDUCE_COLOR_THRESHOLDS_SRGB8_ALL_COVERED_ALL_HIT_ONCE: Range<u32> = 0..8;
pub const SET_REDUCE_COLOR_THRESHOLDS_SRGB8_ALL_COVERED: Range<u32> = 16..24;
pub const UNBIND_ALL: u32 = 0x10f4;
pub const UNBIND_ALL_CONSTANT_BUFFERS: Range<u32> = 8..9;
pub const UNBIND_ALL_CONSTANT_BUFFERS_FALSE: u32 = 0x00000000;
pub const UNBIND_ALL_CONSTANT_BUFFERS_TRUE: u32 = 0x00000001;
pub const SET_CLEAR_SURFACE_CONTROL: u32 = 0x10f8;
pub const SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK: Range<u32> = 0..1;
pub const SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_FALSE: u32 = 0x00000000;
pub const SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_TRUE: u32 = 0x00000001;
pub const SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT: Range<u32> = 4..5;
pub const SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_FALSE: u32 = 0x00000000;
pub const SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_TRUE: u32 = 0x00000001;
pub const SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0: Range<u32> = 8..9;
pub const SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_FALSE: u32 = 0x00000000;
pub const SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_TRUE: u32 = 0x00000001;
pub const SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0: Range<u32> = 12..13;
pub const SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_FALSE: u32 = 0x00000000;
pub const SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_TRUE: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS: u32 = 0x10fc;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const NO_OPERATION_DATA_HI: u32 = 0x110c;
pub const NO_OPERATION_DATA_HI_V: Range<u32> = 0..32;
pub const SET_DEPTH_BIAS_CONTROL: u32 = 0x1110;
pub const SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT: Range<u32> = 0..1;
pub const SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_FALSE: u32 = 0x00000000;
pub const SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_TRUE: u32 = 0x00000001;
pub const PM_TRIGGER_END: u32 = 0x1114;
pub const PM_TRIGGER_END_V: Range<u32> = 0..32;
pub const SET_VERTEX_ID_BASE: u32 = 0x1118;
pub const SET_VERTEX_ID_BASE_V: Range<u32> = 0..32;
#[inline]
pub fn set_da_output_attribute_skip_mask_a  (i: u32) -> u32 { 0x1120+i*4 } 
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0: Range<u32> = 0..1;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1: Range<u32> = 1..2;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2: Range<u32> = 2..3;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3: Range<u32> = 3..4;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0: Range<u32> = 4..5;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1: Range<u32> = 5..6;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2: Range<u32> = 6..7;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3: Range<u32> = 7..8;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0: Range<u32> = 8..9;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1: Range<u32> = 9..10;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2: Range<u32> = 10..11;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3: Range<u32> = 11..12;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0: Range<u32> = 12..13;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1: Range<u32> = 13..14;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2: Range<u32> = 14..15;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3: Range<u32> = 15..16;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0: Range<u32> = 16..17;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1: Range<u32> = 17..18;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2: Range<u32> = 18..19;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3: Range<u32> = 19..20;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0: Range<u32> = 20..21;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1: Range<u32> = 21..22;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2: Range<u32> = 22..23;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3: Range<u32> = 23..24;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0: Range<u32> = 24..25;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1: Range<u32> = 25..26;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2: Range<u32> = 26..27;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3: Range<u32> = 27..28;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0: Range<u32> = 28..29;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1: Range<u32> = 29..30;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2: Range<u32> = 30..31;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3: Range<u32> = 31..32;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_da_output_attribute_skip_mask_b  (i: u32) -> u32 { 0x1128+i*4 } 
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0: Range<u32> = 0..1;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1: Range<u32> = 1..2;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2: Range<u32> = 2..3;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3: Range<u32> = 3..4;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0: Range<u32> = 4..5;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1: Range<u32> = 5..6;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2: Range<u32> = 6..7;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3: Range<u32> = 7..8;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0: Range<u32> = 8..9;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1: Range<u32> = 9..10;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2: Range<u32> = 10..11;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3: Range<u32> = 11..12;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0: Range<u32> = 12..13;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1: Range<u32> = 13..14;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2: Range<u32> = 14..15;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3: Range<u32> = 15..16;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0: Range<u32> = 16..17;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1: Range<u32> = 17..18;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2: Range<u32> = 18..19;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3: Range<u32> = 19..20;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0: Range<u32> = 20..21;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1: Range<u32> = 21..22;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2: Range<u32> = 22..23;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3: Range<u32> = 23..24;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0: Range<u32> = 24..25;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1: Range<u32> = 25..26;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2: Range<u32> = 26..27;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3: Range<u32> = 27..28;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0: Range<u32> = 28..29;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1: Range<u32> = 29..30;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2: Range<u32> = 30..31;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_TRUE: u32 = 0x00000001;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3: Range<u32> = 31..32;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_TRUE: u32 = 0x00000001;
pub const SET_BLEND_PER_FORMAT_ENABLE: u32 = 0x1140;
pub const SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16: Range<u32> = 4..5;
pub const SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_FALSE: u32 = 0x00000000;
pub const SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_TRUE: u32 = 0x00000001;
pub const FLUSH_PENDING_WRITES: u32 = 0x1144;
pub const FLUSH_PENDING_WRITES_SM_DOES_GLOBAL_STORE: Range<u32> = 0..1;
pub const SET_VAB_DATA_CONTROL: u32 = 0x114c;
pub const SET_VAB_DATA_CONTROL_VAB_INDEX: Range<u32> = 0..8;
pub const SET_VAB_DATA_CONTROL_COMPONENT_COUNT: Range<u32> = 8..11;
pub const SET_VAB_DATA_CONTROL_COMPONENT_BYTE_WIDTH: Range<u32> = 12..15;
pub const SET_VAB_DATA_CONTROL_FORMAT: Range<u32> = 16..19;
pub const SET_VAB_DATA_CONTROL_FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY: u32 = 0x00000000;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_SNORM: u32 = 0x00000001;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_UNORM: u32 = 0x00000002;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_SINT: u32 = 0x00000003;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_UINT: u32 = 0x00000004;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_USCALED: u32 = 0x00000005;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_SSCALED: u32 = 0x00000006;
pub const SET_VAB_DATA_CONTROL_FORMAT_NUM_FLOAT: u32 = 0x00000007;
#[inline]
pub fn set_vab_data  (i: u32) -> u32 { 0x1150+i*4 } 
pub const SET_VAB_DATA_V: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_attribute_a  (i: u32) -> u32 { 0x1160+i*4 } 
pub const SET_VERTEX_ATTRIBUTE_A_STREAM: Range<u32> = 0..5;
pub const SET_VERTEX_ATTRIBUTE_A_SOURCE: Range<u32> = 6..7;
pub const SET_VERTEX_ATTRIBUTE_A_SOURCE_ACTIVE: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_A_SOURCE_INACTIVE: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_A_OFFSET: Range<u32> = 7..21;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS: Range<u32> = 21..27;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32: u32 = 0x00000002;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16: u32 = 0x00000003;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32: u32 = 0x00000004;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16: u32 = 0x00000005;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8B8G8R8: u32 = 0x0000002F;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8: u32 = 0x0000000A;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_X8B8G8R8: u32 = 0x00000033;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A2B10G10R10: u32 = 0x00000030;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_B10G11R11: u32 = 0x00000031;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16: u32 = 0x0000000F;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32: u32 = 0x00000012;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8: u32 = 0x00000013;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_G8R8: u32 = 0x00000032;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8: u32 = 0x00000018;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16: u32 = 0x0000001B;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8: u32 = 0x0000001D;
pub const SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8: u32 = 0x00000034;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE: Range<u32> = 27..30;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SNORM: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UNORM: u32 = 0x00000002;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SINT: u32 = 0x00000003;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UINT: u32 = 0x00000004;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_USCALED: u32 = 0x00000005;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SSCALED: u32 = 0x00000006;
pub const SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_FLOAT: u32 = 0x00000007;
pub const SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B: Range<u32> = 31..32;
pub const SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_vertex_attribute_b  (i: u32) -> u32 { 0x11a0+i*4 } 
pub const SET_VERTEX_ATTRIBUTE_B_STREAM: Range<u32> = 0..5;
pub const SET_VERTEX_ATTRIBUTE_B_SOURCE: Range<u32> = 6..7;
pub const SET_VERTEX_ATTRIBUTE_B_SOURCE_ACTIVE: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_B_SOURCE_INACTIVE: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_B_OFFSET: Range<u32> = 7..21;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS: Range<u32> = 21..27;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32: u32 = 0x00000002;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16: u32 = 0x00000003;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32: u32 = 0x00000004;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16: u32 = 0x00000005;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8B8G8R8: u32 = 0x0000002F;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8: u32 = 0x0000000A;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_X8B8G8R8: u32 = 0x00000033;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A2B10G10R10: u32 = 0x00000030;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_B10G11R11: u32 = 0x00000031;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16: u32 = 0x0000000F;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32: u32 = 0x00000012;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8: u32 = 0x00000013;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_G8R8: u32 = 0x00000032;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8: u32 = 0x00000018;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16: u32 = 0x0000001B;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8: u32 = 0x0000001D;
pub const SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8: u32 = 0x00000034;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE: Range<u32> = 27..30;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SNORM: u32 = 0x00000001;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UNORM: u32 = 0x00000002;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SINT: u32 = 0x00000003;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UINT: u32 = 0x00000004;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_USCALED: u32 = 0x00000005;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SSCALED: u32 = 0x00000006;
pub const SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_FLOAT: u32 = 0x00000007;
pub const SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B: Range<u32> = 31..32;
pub const SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_TRUE: u32 = 0x00000001;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST: u32 = 0x1214;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_START_INDEX: Range<u32> = 0..16;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_COUNT: Range<u32> = 16..28;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT: u32 = 0x1218;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_START_INDEX: Range<u32> = 0..16;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_COUNT: Range<u32> = 16..28;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const SET_CT_SELECT: u32 = 0x121c;
pub const SET_CT_SELECT_TARGET_COUNT: Range<u32> = 0..4;
pub const SET_CT_SELECT_TARGET0: Range<u32> = 4..7;
pub const SET_CT_SELECT_TARGET1: Range<u32> = 7..10;
pub const SET_CT_SELECT_TARGET2: Range<u32> = 10..13;
pub const SET_CT_SELECT_TARGET3: Range<u32> = 13..16;
pub const SET_CT_SELECT_TARGET4: Range<u32> = 16..19;
pub const SET_CT_SELECT_TARGET5: Range<u32> = 19..22;
pub const SET_CT_SELECT_TARGET6: Range<u32> = 22..25;
pub const SET_CT_SELECT_TARGET7: Range<u32> = 25..28;
pub const SET_COMPRESSION_THRESHOLD: u32 = 0x1220;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES: Range<u32> = 0..4;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__0: u32 = 0x00000000;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__1: u32 = 0x00000001;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__2: u32 = 0x00000002;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__4: u32 = 0x00000003;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__8: u32 = 0x00000004;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__16: u32 = 0x00000005;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__32: u32 = 0x00000006;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__64: u32 = 0x00000007;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__128: u32 = 0x00000008;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__256: u32 = 0x00000009;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__512: u32 = 0x0000000A;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__1024: u32 = 0x0000000B;
pub const SET_COMPRESSION_THRESHOLD_SAMPLES__2048: u32 = 0x0000000C;
pub const SET_ZT_SIZE_A: u32 = 0x1228;
pub const SET_ZT_SIZE_A_WIDTH: Range<u32> = 0..28;
pub const SET_ZT_SIZE_B: u32 = 0x122c;
pub const SET_ZT_SIZE_B_HEIGHT: Range<u32> = 0..17;
pub const SET_ZT_SIZE_C: u32 = 0x1230;
pub const SET_ZT_SIZE_C_THIRD_DIMENSION: Range<u32> = 0..16;
pub const SET_ZT_SIZE_C_CONTROL: Range<u32> = 16..17;
pub const SET_ZT_SIZE_C_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE: u32 = 0x00000000;
pub const SET_ZT_SIZE_C_CONTROL_ARRAY_SIZE_IS_ONE: u32 = 0x00000001;
pub const SET_SAMPLER_BINDING: u32 = 0x1234;
pub const SET_SAMPLER_BINDING_V: Range<u32> = 0..1;
pub const SET_SAMPLER_BINDING_V_INDEPENDENTLY: u32 = 0x00000000;
pub const SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING: u32 = 0x00000001;
pub const DRAW_AUTO: u32 = 0x123c;
pub const DRAW_AUTO_BYTE_COUNT: Range<u32> = 0..32;
pub const SET_CIRCULAR_BUFFER_SIZE: u32 = 0x1280;
pub const SET_CIRCULAR_BUFFER_SIZE_CACHE_LINES_PER_SM: Range<u32> = 0..10;
pub const SET_VTG_REGISTER_WATERMARKS: u32 = 0x1284;
pub const SET_VTG_REGISTER_WATERMARKS_LOW: Range<u32> = 0..16;
pub const SET_VTG_REGISTER_WATERMARKS_HIGH: Range<u32> = 16..32;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI: u32 = 0x1288;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS: u32 = 0x1290;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE: u32 = 0x12a4;
pub const SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE_V: Range<u32> = 0..32;
pub const SET_SHADER_SCHEDULING: u32 = 0x12ac;
pub const SET_SHADER_SCHEDULING_MODE: Range<u32> = 0..1;
pub const SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST: u32 = 0x00000000;
pub const SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN: u32 = 0x00000001;
pub const CLEAR_ZCULL_REGION: u32 = 0x12c8;
pub const CLEAR_ZCULL_REGION_Z_ENABLE: Range<u32> = 0..1;
pub const CLEAR_ZCULL_REGION_Z_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_ZCULL_REGION_Z_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_ZCULL_REGION_STENCIL_ENABLE: Range<u32> = 4..5;
pub const CLEAR_ZCULL_REGION_STENCIL_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_ZCULL_REGION_STENCIL_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_ZCULL_REGION_USE_CLEAR_RECT: Range<u32> = 1..2;
pub const CLEAR_ZCULL_REGION_USE_CLEAR_RECT_FALSE: u32 = 0x00000000;
pub const CLEAR_ZCULL_REGION_USE_CLEAR_RECT_TRUE: u32 = 0x00000001;
pub const CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX: Range<u32> = 2..3;
pub const CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_FALSE: u32 = 0x00000000;
pub const CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_TRUE: u32 = 0x00000001;
pub const CLEAR_ZCULL_REGION_RT_ARRAY_INDEX: Range<u32> = 5..21;
pub const CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE: Range<u32> = 3..4;
pub const CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_FALSE: u32 = 0x00000000;
pub const CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_TRUE: u32 = 0x00000001;
pub const SET_DEPTH_TEST: u32 = 0x12cc;
pub const SET_DEPTH_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_DEPTH_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DEPTH_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_FILL_MODE: u32 = 0x12d0;
pub const SET_FILL_MODE_V: Range<u32> = 0..32;
pub const SET_FILL_MODE_V_POINT: u32 = 0x00000001;
pub const SET_FILL_MODE_V_WIREFRAME: u32 = 0x00000002;
pub const SET_FILL_MODE_V_SOLID: u32 = 0x00000003;
pub const SET_SHADE_MODE: u32 = 0x12d4;
pub const SET_SHADE_MODE_V: Range<u32> = 0..32;
pub const SET_SHADE_MODE_V_FLAT: u32 = 0x00000001;
pub const SET_SHADE_MODE_V_GOURAUD: u32 = 0x00000002;
pub const SET_SHADE_MODE_V_OGL_FLAT: u32 = 0x00001D00;
pub const SET_SHADE_MODE_V_OGL_SMOOTH: u32 = 0x00001D01;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS: u32 = 0x12d8;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS: u32 = 0x12dc;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY: Range<u32> = 4..6;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST: u32 = 0x00000000;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL: u32 = 0x00000001;
pub const SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST: u32 = 0x00000002;
pub const SET_ALPHA_TO_COVERAGE_DITHER_CONTROL: u32 = 0x12e0;
pub const SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT: Range<u32> = 0..4;
pub const SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1: u32 = 0x00000000;
pub const SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_2X2: u32 = 0x00000001;
pub const SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES: u32 = 0x00000002;
pub const SET_BLEND_STATE_PER_TARGET: u32 = 0x12e4;
pub const SET_BLEND_STATE_PER_TARGET_ENABLE: Range<u32> = 0..1;
pub const SET_BLEND_STATE_PER_TARGET_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_BLEND_STATE_PER_TARGET_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_DEPTH_WRITE: u32 = 0x12e8;
pub const SET_DEPTH_WRITE_ENABLE: Range<u32> = 0..1;
pub const SET_DEPTH_WRITE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DEPTH_WRITE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ALPHA_TEST: u32 = 0x12ec;
pub const SET_ALPHA_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_ALPHA_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ALPHA_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_INLINE_INDEX4X8_ALIGN: u32 = 0x1300;
pub const SET_INLINE_INDEX4X8_ALIGN_COUNT: Range<u32> = 0..30;
pub const SET_INLINE_INDEX4X8_ALIGN_START: Range<u32> = 30..32;
pub const DRAW_INLINE_INDEX4X8: u32 = 0x1304;
pub const DRAW_INLINE_INDEX4X8_INDEX0: Range<u32> = 0..8;
pub const DRAW_INLINE_INDEX4X8_INDEX1: Range<u32> = 8..16;
pub const DRAW_INLINE_INDEX4X8_INDEX2: Range<u32> = 16..24;
pub const DRAW_INLINE_INDEX4X8_INDEX3: Range<u32> = 24..32;
pub const D3D_SET_CULL_MODE: u32 = 0x1308;
pub const D3D_SET_CULL_MODE_V: Range<u32> = 0..32;
pub const D3D_SET_CULL_MODE_V_NONE: u32 = 0x00000001;
pub const D3D_SET_CULL_MODE_V_CW: u32 = 0x00000002;
pub const D3D_SET_CULL_MODE_V_CCW: u32 = 0x00000003;
pub const SET_DEPTH_FUNC: u32 = 0x130c;
pub const SET_DEPTH_FUNC_V: Range<u32> = 0..32;
pub const SET_DEPTH_FUNC_V_OGL_NEVER: u32 = 0x00000200;
pub const SET_DEPTH_FUNC_V_OGL_LESS: u32 = 0x00000201;
pub const SET_DEPTH_FUNC_V_OGL_EQUAL: u32 = 0x00000202;
pub const SET_DEPTH_FUNC_V_OGL_LEQUAL: u32 = 0x00000203;
pub const SET_DEPTH_FUNC_V_OGL_GREATER: u32 = 0x00000204;
pub const SET_DEPTH_FUNC_V_OGL_NOTEQUAL: u32 = 0x00000205;
pub const SET_DEPTH_FUNC_V_OGL_GEQUAL: u32 = 0x00000206;
pub const SET_DEPTH_FUNC_V_OGL_ALWAYS: u32 = 0x00000207;
pub const SET_DEPTH_FUNC_V_D3D_NEVER: u32 = 0x00000001;
pub const SET_DEPTH_FUNC_V_D3D_LESS: u32 = 0x00000002;
pub const SET_DEPTH_FUNC_V_D3D_EQUAL: u32 = 0x00000003;
pub const SET_DEPTH_FUNC_V_D3D_LESSEQUAL: u32 = 0x00000004;
pub const SET_DEPTH_FUNC_V_D3D_GREATER: u32 = 0x00000005;
pub const SET_DEPTH_FUNC_V_D3D_NOTEQUAL: u32 = 0x00000006;
pub const SET_DEPTH_FUNC_V_D3D_GREATEREQUAL: u32 = 0x00000007;
pub const SET_DEPTH_FUNC_V_D3D_ALWAYS: u32 = 0x00000008;
pub const SET_ALPHA_REF: u32 = 0x1310;
pub const SET_ALPHA_REF_V: Range<u32> = 0..32;
pub const SET_ALPHA_FUNC: u32 = 0x1314;
pub const SET_ALPHA_FUNC_V: Range<u32> = 0..32;
pub const SET_ALPHA_FUNC_V_OGL_NEVER: u32 = 0x00000200;
pub const SET_ALPHA_FUNC_V_OGL_LESS: u32 = 0x00000201;
pub const SET_ALPHA_FUNC_V_OGL_EQUAL: u32 = 0x00000202;
pub const SET_ALPHA_FUNC_V_OGL_LEQUAL: u32 = 0x00000203;
pub const SET_ALPHA_FUNC_V_OGL_GREATER: u32 = 0x00000204;
pub const SET_ALPHA_FUNC_V_OGL_NOTEQUAL: u32 = 0x00000205;
pub const SET_ALPHA_FUNC_V_OGL_GEQUAL: u32 = 0x00000206;
pub const SET_ALPHA_FUNC_V_OGL_ALWAYS: u32 = 0x00000207;
pub const SET_ALPHA_FUNC_V_D3D_NEVER: u32 = 0x00000001;
pub const SET_ALPHA_FUNC_V_D3D_LESS: u32 = 0x00000002;
pub const SET_ALPHA_FUNC_V_D3D_EQUAL: u32 = 0x00000003;
pub const SET_ALPHA_FUNC_V_D3D_LESSEQUAL: u32 = 0x00000004;
pub const SET_ALPHA_FUNC_V_D3D_GREATER: u32 = 0x00000005;
pub const SET_ALPHA_FUNC_V_D3D_NOTEQUAL: u32 = 0x00000006;
pub const SET_ALPHA_FUNC_V_D3D_GREATEREQUAL: u32 = 0x00000007;
pub const SET_ALPHA_FUNC_V_D3D_ALWAYS: u32 = 0x00000008;
pub const SET_DRAW_AUTO_STRIDE: u32 = 0x1318;
pub const SET_DRAW_AUTO_STRIDE_V: Range<u32> = 0..12;
pub const SET_BLEND_CONST_RED: u32 = 0x131c;
pub const SET_BLEND_CONST_RED_V: Range<u32> = 0..32;
pub const SET_BLEND_CONST_GREEN: u32 = 0x1320;
pub const SET_BLEND_CONST_GREEN_V: Range<u32> = 0..32;
pub const SET_BLEND_CONST_BLUE: u32 = 0x1324;
pub const SET_BLEND_CONST_BLUE_V: Range<u32> = 0..32;
pub const SET_BLEND_CONST_ALPHA: u32 = 0x1328;
pub const SET_BLEND_CONST_ALPHA_V: Range<u32> = 0..32;
pub const INVALIDATE_SAMPLER_CACHE: u32 = 0x1330;
pub const INVALIDATE_SAMPLER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_HEADER_CACHE: u32 = 0x1334;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_DATA_CACHE: u32 = 0x1338;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_TAG: Range<u32> = 4..26;
pub const SET_BLEND_SEPARATE_FOR_ALPHA: u32 = 0x133c;
pub const SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE: Range<u32> = 0..1;
pub const SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_BLEND_COLOR_OP: u32 = 0x1340;
pub const SET_BLEND_COLOR_OP_V: Range<u32> = 0..32;
pub const SET_BLEND_COLOR_OP_V_OGL_FUNC_SUBTRACT: u32 = 0x0000800A;
pub const SET_BLEND_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT: u32 = 0x0000800B;
pub const SET_BLEND_COLOR_OP_V_OGL_FUNC_ADD: u32 = 0x00008006;
pub const SET_BLEND_COLOR_OP_V_OGL_MIN: u32 = 0x00008007;
pub const SET_BLEND_COLOR_OP_V_OGL_MAX: u32 = 0x00008008;
pub const SET_BLEND_COLOR_OP_V_D3D_ADD: u32 = 0x00000001;
pub const SET_BLEND_COLOR_OP_V_D3D_SUBTRACT: u32 = 0x00000002;
pub const SET_BLEND_COLOR_OP_V_D3D_REVSUBTRACT: u32 = 0x00000003;
pub const SET_BLEND_COLOR_OP_V_D3D_MIN: u32 = 0x00000004;
pub const SET_BLEND_COLOR_OP_V_D3D_MAX: u32 = 0x00000005;
pub const SET_BLEND_COLOR_SOURCE_COEFF: u32 = 0x1344;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA: u32 = 0x0000000C;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA: u32 = 0x0000000D;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
pub const SET_BLEND_COLOR_DEST_COEFF: u32 = 0x1348;
pub const SET_BLEND_COLOR_DEST_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
pub const SET_BLEND_ALPHA_OP: u32 = 0x134c;
pub const SET_BLEND_ALPHA_OP_V: Range<u32> = 0..32;
pub const SET_BLEND_ALPHA_OP_V_OGL_FUNC_SUBTRACT: u32 = 0x0000800A;
pub const SET_BLEND_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT: u32 = 0x0000800B;
pub const SET_BLEND_ALPHA_OP_V_OGL_FUNC_ADD: u32 = 0x00008006;
pub const SET_BLEND_ALPHA_OP_V_OGL_MIN: u32 = 0x00008007;
pub const SET_BLEND_ALPHA_OP_V_OGL_MAX: u32 = 0x00008008;
pub const SET_BLEND_ALPHA_OP_V_D3D_ADD: u32 = 0x00000001;
pub const SET_BLEND_ALPHA_OP_V_D3D_SUBTRACT: u32 = 0x00000002;
pub const SET_BLEND_ALPHA_OP_V_D3D_REVSUBTRACT: u32 = 0x00000003;
pub const SET_BLEND_ALPHA_OP_V_D3D_MIN: u32 = 0x00000004;
pub const SET_BLEND_ALPHA_OP_V_D3D_MAX: u32 = 0x00000005;
pub const SET_BLEND_ALPHA_SOURCE_COEFF: u32 = 0x1350;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA: u32 = 0x0000000C;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA: u32 = 0x0000000D;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
pub const SET_GLOBAL_COLOR_KEY: u32 = 0x1354;
pub const SET_GLOBAL_COLOR_KEY_ENABLE: Range<u32> = 0..1;
pub const SET_GLOBAL_COLOR_KEY_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_COLOR_KEY_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_BLEND_ALPHA_DEST_COEFF: u32 = 0x1358;
pub const SET_BLEND_ALPHA_DEST_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
pub const SET_SINGLE_ROP_CONTROL: u32 = 0x135c;
pub const SET_SINGLE_ROP_CONTROL_ENABLE: Range<u32> = 0..1;
pub const SET_SINGLE_ROP_CONTROL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SINGLE_ROP_CONTROL_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_blend  (i: u32) -> u32 { 0x1360+i*4 } 
pub const SET_BLEND_ENABLE: Range<u32> = 0..1;
pub const SET_BLEND_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_BLEND_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STENCIL_TEST: u32 = 0x1380;
pub const SET_STENCIL_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_STENCIL_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_STENCIL_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_STENCIL_OP_FAIL: u32 = 0x1384;
pub const SET_STENCIL_OP_FAIL_V: Range<u32> = 0..32;
pub const SET_STENCIL_OP_FAIL_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_STENCIL_OP_FAIL_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_STENCIL_OP_FAIL_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_STENCIL_OP_FAIL_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_STENCIL_OP_FAIL_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_STENCIL_OP_FAIL_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_STENCIL_OP_FAIL_V_OGL_INCR: u32 = 0x00008507;
pub const SET_STENCIL_OP_FAIL_V_OGL_DECR: u32 = 0x00008508;
pub const SET_STENCIL_OP_FAIL_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_STENCIL_OP_FAIL_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_STENCIL_OP_FAIL_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_STENCIL_OP_FAIL_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_STENCIL_OP_FAIL_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_STENCIL_OP_FAIL_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_STENCIL_OP_FAIL_V_D3D_INCR: u32 = 0x00000007;
pub const SET_STENCIL_OP_FAIL_V_D3D_DECR: u32 = 0x00000008;
pub const SET_STENCIL_OP_ZFAIL: u32 = 0x1388;
pub const SET_STENCIL_OP_ZFAIL_V: Range<u32> = 0..32;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_INCR: u32 = 0x00008507;
pub const SET_STENCIL_OP_ZFAIL_V_OGL_DECR: u32 = 0x00008508;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_INCR: u32 = 0x00000007;
pub const SET_STENCIL_OP_ZFAIL_V_D3D_DECR: u32 = 0x00000008;
pub const SET_STENCIL_OP_ZPASS: u32 = 0x138c;
pub const SET_STENCIL_OP_ZPASS_V: Range<u32> = 0..32;
pub const SET_STENCIL_OP_ZPASS_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_STENCIL_OP_ZPASS_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_STENCIL_OP_ZPASS_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_STENCIL_OP_ZPASS_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_STENCIL_OP_ZPASS_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_STENCIL_OP_ZPASS_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_STENCIL_OP_ZPASS_V_OGL_INCR: u32 = 0x00008507;
pub const SET_STENCIL_OP_ZPASS_V_OGL_DECR: u32 = 0x00008508;
pub const SET_STENCIL_OP_ZPASS_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_STENCIL_OP_ZPASS_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_STENCIL_OP_ZPASS_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_STENCIL_OP_ZPASS_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_STENCIL_OP_ZPASS_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_STENCIL_OP_ZPASS_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_STENCIL_OP_ZPASS_V_D3D_INCR: u32 = 0x00000007;
pub const SET_STENCIL_OP_ZPASS_V_D3D_DECR: u32 = 0x00000008;
pub const SET_STENCIL_FUNC: u32 = 0x1390;
pub const SET_STENCIL_FUNC_V: Range<u32> = 0..32;
pub const SET_STENCIL_FUNC_V_OGL_NEVER: u32 = 0x00000200;
pub const SET_STENCIL_FUNC_V_OGL_LESS: u32 = 0x00000201;
pub const SET_STENCIL_FUNC_V_OGL_EQUAL: u32 = 0x00000202;
pub const SET_STENCIL_FUNC_V_OGL_LEQUAL: u32 = 0x00000203;
pub const SET_STENCIL_FUNC_V_OGL_GREATER: u32 = 0x00000204;
pub const SET_STENCIL_FUNC_V_OGL_NOTEQUAL: u32 = 0x00000205;
pub const SET_STENCIL_FUNC_V_OGL_GEQUAL: u32 = 0x00000206;
pub const SET_STENCIL_FUNC_V_OGL_ALWAYS: u32 = 0x00000207;
pub const SET_STENCIL_FUNC_V_D3D_NEVER: u32 = 0x00000001;
pub const SET_STENCIL_FUNC_V_D3D_LESS: u32 = 0x00000002;
pub const SET_STENCIL_FUNC_V_D3D_EQUAL: u32 = 0x00000003;
pub const SET_STENCIL_FUNC_V_D3D_LESSEQUAL: u32 = 0x00000004;
pub const SET_STENCIL_FUNC_V_D3D_GREATER: u32 = 0x00000005;
pub const SET_STENCIL_FUNC_V_D3D_NOTEQUAL: u32 = 0x00000006;
pub const SET_STENCIL_FUNC_V_D3D_GREATEREQUAL: u32 = 0x00000007;
pub const SET_STENCIL_FUNC_V_D3D_ALWAYS: u32 = 0x00000008;
pub const SET_STENCIL_FUNC_REF: u32 = 0x1394;
pub const SET_STENCIL_FUNC_REF_V: Range<u32> = 0..8;
pub const SET_STENCIL_FUNC_MASK: u32 = 0x1398;
pub const SET_STENCIL_FUNC_MASK_V: Range<u32> = 0..8;
pub const SET_STENCIL_MASK: u32 = 0x139c;
pub const SET_STENCIL_MASK_V: Range<u32> = 0..8;
pub const SET_DRAW_AUTO_START: u32 = 0x13a4;
pub const SET_DRAW_AUTO_START_BYTE_COUNT: Range<u32> = 0..32;
pub const SET_PS_SATURATE: u32 = 0x13a8;
pub const SET_PS_SATURATE_OUTPUT0: Range<u32> = 0..1;
pub const SET_PS_SATURATE_OUTPUT0_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT0_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT1: Range<u32> = 4..5;
pub const SET_PS_SATURATE_OUTPUT1_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT1_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT2: Range<u32> = 8..9;
pub const SET_PS_SATURATE_OUTPUT2_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT2_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT3: Range<u32> = 12..13;
pub const SET_PS_SATURATE_OUTPUT3_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT3_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT4: Range<u32> = 16..17;
pub const SET_PS_SATURATE_OUTPUT4_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT4_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT5: Range<u32> = 20..21;
pub const SET_PS_SATURATE_OUTPUT5_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT5_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT6: Range<u32> = 24..25;
pub const SET_PS_SATURATE_OUTPUT6_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT6_TRUE: u32 = 0x00000001;
pub const SET_PS_SATURATE_OUTPUT7: Range<u32> = 28..29;
pub const SET_PS_SATURATE_OUTPUT7_FALSE: u32 = 0x00000000;
pub const SET_PS_SATURATE_OUTPUT7_TRUE: u32 = 0x00000001;
pub const SET_WINDOW_ORIGIN: u32 = 0x13ac;
pub const SET_WINDOW_ORIGIN_MODE: Range<u32> = 0..1;
pub const SET_WINDOW_ORIGIN_MODE_UPPER_LEFT: u32 = 0x00000000;
pub const SET_WINDOW_ORIGIN_MODE_LOWER_LEFT: u32 = 0x00000001;
pub const SET_WINDOW_ORIGIN_FLIP_Y: Range<u32> = 4..5;
pub const SET_WINDOW_ORIGIN_FLIP_Y_FALSE: u32 = 0x00000000;
pub const SET_WINDOW_ORIGIN_FLIP_Y_TRUE: u32 = 0x00000001;
pub const SET_LINE_WIDTH_FLOAT: u32 = 0x13b0;
pub const SET_LINE_WIDTH_FLOAT_V: Range<u32> = 0..32;
pub const SET_ALIASED_LINE_WIDTH_FLOAT: u32 = 0x13b4;
pub const SET_ALIASED_LINE_WIDTH_FLOAT_V: Range<u32> = 0..32;
pub const SET_LINE_MULTISAMPLE_OVERRIDE: u32 = 0x1418;
pub const SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE: Range<u32> = 0..1;
pub const SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ALPHA_HYSTERESIS: u32 = 0x1420;
pub const SET_ALPHA_HYSTERESIS_ROUNDS_OF_ALPHA: Range<u32> = 0..8;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI: u32 = 0x1424;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI: u32 = 0x1428;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const INVALIDATE_DA_DMA_CACHE: u32 = 0x142c;
pub const INVALIDATE_DA_DMA_CACHE_V: Range<u32> = 0..1;
pub const SET_GLOBAL_BASE_VERTEX_INDEX: u32 = 0x1434;
pub const SET_GLOBAL_BASE_VERTEX_INDEX_V: Range<u32> = 0..32;
pub const SET_GLOBAL_BASE_INSTANCE_INDEX: u32 = 0x1438;
pub const SET_GLOBAL_BASE_INSTANCE_INDEX_V: Range<u32> = 0..32;
pub const SET_PS_WARP_WATERMARKS: u32 = 0x1450;
pub const SET_PS_WARP_WATERMARKS_LOW: Range<u32> = 0..16;
pub const SET_PS_WARP_WATERMARKS_HIGH: Range<u32> = 16..32;
pub const SET_PS_REGISTER_WATERMARKS: u32 = 0x1454;
pub const SET_PS_REGISTER_WATERMARKS_LOW: Range<u32> = 0..16;
pub const SET_PS_REGISTER_WATERMARKS_HIGH: Range<u32> = 16..32;
pub const STORE_ZCULL: u32 = 0x1464;
pub const STORE_ZCULL_V: Range<u32> = 0..1;
pub const LOAD_ZCULL: u32 = 0x1500;
pub const LOAD_ZCULL_V: Range<u32> = 0..1;
pub const SET_SURFACE_CLIP_ID_HEIGHT: u32 = 0x1504;
pub const SET_SURFACE_CLIP_ID_HEIGHT_V: Range<u32> = 0..32;
pub const SET_CLIP_ID_CLEAR_RECT_HORIZONTAL: u32 = 0x1508;
pub const SET_CLIP_ID_CLEAR_RECT_HORIZONTAL_XMIN: Range<u32> = 0..16;
pub const SET_CLIP_ID_CLEAR_RECT_HORIZONTAL_XMAX: Range<u32> = 16..32;
pub const SET_CLIP_ID_CLEAR_RECT_VERTICAL: u32 = 0x150c;
pub const SET_CLIP_ID_CLEAR_RECT_VERTICAL_YMIN: Range<u32> = 0..16;
pub const SET_CLIP_ID_CLEAR_RECT_VERTICAL_YMAX: Range<u32> = 16..32;
pub const SET_USER_CLIP_ENABLE: u32 = 0x1510;
pub const SET_USER_CLIP_ENABLE_PLANE0: Range<u32> = 0..1;
pub const SET_USER_CLIP_ENABLE_PLANE0_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE0_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE1: Range<u32> = 1..2;
pub const SET_USER_CLIP_ENABLE_PLANE1_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE1_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE2: Range<u32> = 2..3;
pub const SET_USER_CLIP_ENABLE_PLANE2_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE2_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE3: Range<u32> = 3..4;
pub const SET_USER_CLIP_ENABLE_PLANE3_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE3_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE4: Range<u32> = 4..5;
pub const SET_USER_CLIP_ENABLE_PLANE4_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE4_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE5: Range<u32> = 5..6;
pub const SET_USER_CLIP_ENABLE_PLANE5_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE5_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE6: Range<u32> = 6..7;
pub const SET_USER_CLIP_ENABLE_PLANE6_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE6_TRUE: u32 = 0x00000001;
pub const SET_USER_CLIP_ENABLE_PLANE7: Range<u32> = 7..8;
pub const SET_USER_CLIP_ENABLE_PLANE7_FALSE: u32 = 0x00000000;
pub const SET_USER_CLIP_ENABLE_PLANE7_TRUE: u32 = 0x00000001;
pub const SET_ZPASS_PIXEL_COUNT: u32 = 0x1514;
pub const SET_ZPASS_PIXEL_COUNT_ENABLE: Range<u32> = 0..1;
pub const SET_ZPASS_PIXEL_COUNT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZPASS_PIXEL_COUNT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POINT_SIZE: u32 = 0x1518;
pub const SET_POINT_SIZE_V: Range<u32> = 0..32;
pub const SET_ZCULL_STATS: u32 = 0x151c;
pub const SET_ZCULL_STATS_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_STATS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_STATS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POINT_SPRITE: u32 = 0x1520;
pub const SET_POINT_SPRITE_ENABLE: Range<u32> = 0..1;
pub const SET_POINT_SPRITE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POINT_SPRITE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SHADER_EXCEPTIONS: u32 = 0x1528;
pub const SET_SHADER_EXCEPTIONS_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_EXCEPTIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_EXCEPTIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_REPORT_VALUE: u32 = 0x1530;
pub const CLEAR_REPORT_VALUE_TYPE: Range<u32> = 0..5;
pub const CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED: u32 = 0x00000012;
pub const CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED: u32 = 0x00000013;
pub const CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS: u32 = 0x00000015;
pub const CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS: u32 = 0x00000016;
pub const CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS: u32 = 0x00000017;
pub const CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED: u32 = 0x00000018;
pub const CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS: u32 = 0x0000001A;
pub const CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED: u32 = 0x0000001B;
pub const CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT: u32 = 0x0000001F;
pub const CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED: u32 = 0x00000010;
pub const CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED: u32 = 0x00000011;
pub const CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED: u32 = 0x00000003;
pub const CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS: u32 = 0x0000001C;
pub const CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED: u32 = 0x0000001D;
pub const CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS: u32 = 0x00000002;
pub const CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS: u32 = 0x0000001E;
pub const CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT: u32 = 0x00000001;
pub const CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS: u32 = 0x00000004;
pub const SET_ANTI_ALIAS_ENABLE: u32 = 0x1534;
pub const SET_ANTI_ALIAS_ENABLE_V: Range<u32> = 0..1;
pub const SET_ANTI_ALIAS_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_ANTI_ALIAS_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_ZT_SELECT: u32 = 0x1538;
pub const SET_ZT_SELECT_TARGET_COUNT: Range<u32> = 0..1;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL: u32 = 0x153c;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE: Range<u32> = 0..1;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_DISABLE: u32 = 0x00000000;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_ENABLE: u32 = 0x00000001;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE: Range<u32> = 4..5;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_DISABLE: u32 = 0x00000000;
pub const SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_ENABLE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_A: u32 = 0x1550;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x1554;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x1558;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_TEX_SAMPLER_POOL_A: u32 = 0x155c;
pub const SET_TEX_SAMPLER_POOL_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_TEX_SAMPLER_POOL_B: u32 = 0x1560;
pub const SET_TEX_SAMPLER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_SAMPLER_POOL_C: u32 = 0x1564;
pub const SET_TEX_SAMPLER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..20;
pub const SET_SLOPE_SCALE_DEPTH_BIAS: u32 = 0x156c;
pub const SET_SLOPE_SCALE_DEPTH_BIAS_V: Range<u32> = 0..32;
pub const SET_ANTI_ALIASED_LINE: u32 = 0x1570;
pub const SET_ANTI_ALIASED_LINE_ENABLE: Range<u32> = 0..1;
pub const SET_ANTI_ALIASED_LINE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ANTI_ALIASED_LINE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_TEX_HEADER_POOL_A: u32 = 0x1574;
pub const SET_TEX_HEADER_POOL_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_TEX_HEADER_POOL_B: u32 = 0x1578;
pub const SET_TEX_HEADER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_HEADER_POOL_C: u32 = 0x157c;
pub const SET_TEX_HEADER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..22;
pub const SET_ACTIVE_ZCULL_REGION: u32 = 0x1590;
pub const SET_ACTIVE_ZCULL_REGION_ID: Range<u32> = 0..6;
pub const SET_TWO_SIDED_STENCIL_TEST: u32 = 0x1594;
pub const SET_TWO_SIDED_STENCIL_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_TWO_SIDED_STENCIL_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_TWO_SIDED_STENCIL_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_BACK_STENCIL_OP_FAIL: u32 = 0x1598;
pub const SET_BACK_STENCIL_OP_FAIL_V: Range<u32> = 0..32;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_INCR: u32 = 0x00008507;
pub const SET_BACK_STENCIL_OP_FAIL_V_OGL_DECR: u32 = 0x00008508;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_INCR: u32 = 0x00000007;
pub const SET_BACK_STENCIL_OP_FAIL_V_D3D_DECR: u32 = 0x00000008;
pub const SET_BACK_STENCIL_OP_ZFAIL: u32 = 0x159c;
pub const SET_BACK_STENCIL_OP_ZFAIL_V: Range<u32> = 0..32;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCR: u32 = 0x00008507;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECR: u32 = 0x00008508;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCR: u32 = 0x00000007;
pub const SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECR: u32 = 0x00000008;
pub const SET_BACK_STENCIL_OP_ZPASS: u32 = 0x15a0;
pub const SET_BACK_STENCIL_OP_ZPASS_V: Range<u32> = 0..32;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_KEEP: u32 = 0x00001E00;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_ZERO: u32 = 0x00000000;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_REPLACE: u32 = 0x00001E01;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCRSAT: u32 = 0x00001E02;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECRSAT: u32 = 0x00001E03;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_INVERT: u32 = 0x0000150A;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCR: u32 = 0x00008507;
pub const SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECR: u32 = 0x00008508;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_KEEP: u32 = 0x00000001;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_ZERO: u32 = 0x00000002;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_REPLACE: u32 = 0x00000003;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCRSAT: u32 = 0x00000004;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECRSAT: u32 = 0x00000005;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_INVERT: u32 = 0x00000006;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCR: u32 = 0x00000007;
pub const SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECR: u32 = 0x00000008;
pub const SET_BACK_STENCIL_FUNC: u32 = 0x15a4;
pub const SET_BACK_STENCIL_FUNC_V: Range<u32> = 0..32;
pub const SET_BACK_STENCIL_FUNC_V_OGL_NEVER: u32 = 0x00000200;
pub const SET_BACK_STENCIL_FUNC_V_OGL_LESS: u32 = 0x00000201;
pub const SET_BACK_STENCIL_FUNC_V_OGL_EQUAL: u32 = 0x00000202;
pub const SET_BACK_STENCIL_FUNC_V_OGL_LEQUAL: u32 = 0x00000203;
pub const SET_BACK_STENCIL_FUNC_V_OGL_GREATER: u32 = 0x00000204;
pub const SET_BACK_STENCIL_FUNC_V_OGL_NOTEQUAL: u32 = 0x00000205;
pub const SET_BACK_STENCIL_FUNC_V_OGL_GEQUAL: u32 = 0x00000206;
pub const SET_BACK_STENCIL_FUNC_V_OGL_ALWAYS: u32 = 0x00000207;
pub const SET_BACK_STENCIL_FUNC_V_D3D_NEVER: u32 = 0x00000001;
pub const SET_BACK_STENCIL_FUNC_V_D3D_LESS: u32 = 0x00000002;
pub const SET_BACK_STENCIL_FUNC_V_D3D_EQUAL: u32 = 0x00000003;
pub const SET_BACK_STENCIL_FUNC_V_D3D_LESSEQUAL: u32 = 0x00000004;
pub const SET_BACK_STENCIL_FUNC_V_D3D_GREATER: u32 = 0x00000005;
pub const SET_BACK_STENCIL_FUNC_V_D3D_NOTEQUAL: u32 = 0x00000006;
pub const SET_BACK_STENCIL_FUNC_V_D3D_GREATEREQUAL: u32 = 0x00000007;
pub const SET_BACK_STENCIL_FUNC_V_D3D_ALWAYS: u32 = 0x00000008;
pub const SET_SRGB_WRITE: u32 = 0x15b8;
pub const SET_SRGB_WRITE_ENABLE: Range<u32> = 0..1;
pub const SET_SRGB_WRITE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SRGB_WRITE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_DEPTH_BIAS: u32 = 0x15bc;
pub const SET_DEPTH_BIAS_V: Range<u32> = 0..32;
pub const SET_ZCULL_REGION_FORMAT: u32 = 0x15c8;
pub const SET_ZCULL_REGION_FORMAT_TYPE: Range<u32> = 0..4;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4: u32 = 0x00000000;
pub const SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4: u32 = 0x00000001;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2: u32 = 0x00000002;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4: u32 = 0x00000003;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4: u32 = 0x00000004;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2: u32 = 0x00000005;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4: u32 = 0x00000006;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8: u32 = 0x00000007;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2: u32 = 0x00000008;
pub const SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2: u32 = 0x00000009;
pub const SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4: u32 = 0x0000000A;
pub const SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2: u32 = 0x0000000B;
pub const SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1: u32 = 0x0000000C;
pub const SET_RT_LAYER: u32 = 0x15cc;
pub const SET_RT_LAYER_V: Range<u32> = 0..16;
pub const SET_RT_LAYER_CONTROL: Range<u32> = 16..17;
pub const SET_RT_LAYER_CONTROL_V_SELECTS_LAYER: u32 = 0x00000000;
pub const SET_RT_LAYER_CONTROL_GEOMETRY_SHADER_SELECTS_LAYER: u32 = 0x00000001;
pub const SET_ANTI_ALIAS: u32 = 0x15d0;
pub const SET_ANTI_ALIAS_SAMPLES: Range<u32> = 0..4;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_1X1: u32 = 0x00000000;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_2X1: u32 = 0x00000001;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_2X2: u32 = 0x00000002;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_4X2: u32 = 0x00000003;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_4X2_D3D: u32 = 0x00000004;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_2X1_D3D: u32 = 0x00000005;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_4X4: u32 = 0x00000006;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_4: u32 = 0x00000008;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_12: u32 = 0x00000009;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_8: u32 = 0x0000000A;
pub const SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_24: u32 = 0x0000000B;
pub const SET_EDGE_FLAG: u32 = 0x15e4;
pub const SET_EDGE_FLAG_V: Range<u32> = 0..1;
pub const SET_EDGE_FLAG_V_FALSE: u32 = 0x00000000;
pub const SET_EDGE_FLAG_V_TRUE: u32 = 0x00000001;
pub const DRAW_INLINE_INDEX: u32 = 0x15e8;
pub const DRAW_INLINE_INDEX_V: Range<u32> = 0..32;
pub const SET_INLINE_INDEX2X16_ALIGN: u32 = 0x15ec;
pub const SET_INLINE_INDEX2X16_ALIGN_COUNT: Range<u32> = 0..31;
pub const SET_INLINE_INDEX2X16_ALIGN_START_ODD: Range<u32> = 31..32;
pub const SET_INLINE_INDEX2X16_ALIGN_START_ODD_FALSE: u32 = 0x00000000;
pub const SET_INLINE_INDEX2X16_ALIGN_START_ODD_TRUE: u32 = 0x00000001;
pub const DRAW_INLINE_INDEX2X16: u32 = 0x15f0;
pub const DRAW_INLINE_INDEX2X16_EVEN: Range<u32> = 0..16;
pub const DRAW_INLINE_INDEX2X16_ODD: Range<u32> = 16..32;
pub const SET_VERTEX_GLOBAL_BASE_OFFSET_A: u32 = 0x15f4;
pub const SET_VERTEX_GLOBAL_BASE_OFFSET_A_UPPER: Range<u32> = 0..8;
pub const SET_VERTEX_GLOBAL_BASE_OFFSET_B: u32 = 0x15f8;
pub const SET_VERTEX_GLOBAL_BASE_OFFSET_B_LOWER: Range<u32> = 0..32;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_A: u32 = 0x15fc;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_A_WIDTH: Range<u32> = 0..16;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_B: u32 = 0x1600;
pub const SET_ZCULL_REGION_PIXEL_OFFSET_B_HEIGHT: Range<u32> = 0..16;
pub const SET_POINT_SPRITE_SELECT: u32 = 0x1604;
pub const SET_POINT_SPRITE_SELECT_RMODE: Range<u32> = 0..2;
pub const SET_POINT_SPRITE_SELECT_RMODE_ZERO: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_RMODE_FROM_R: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_RMODE_FROM_S: u32 = 0x00000002;
pub const SET_POINT_SPRITE_SELECT_ORIGIN: Range<u32> = 2..3;
pub const SET_POINT_SPRITE_SELECT_ORIGIN_BOTTOM: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_ORIGIN_TOP: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE0: Range<u32> = 3..4;
pub const SET_POINT_SPRITE_SELECT_TEXTURE0_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE0_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE1: Range<u32> = 4..5;
pub const SET_POINT_SPRITE_SELECT_TEXTURE1_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE1_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE2: Range<u32> = 5..6;
pub const SET_POINT_SPRITE_SELECT_TEXTURE2_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE2_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE3: Range<u32> = 6..7;
pub const SET_POINT_SPRITE_SELECT_TEXTURE3_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE3_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE4: Range<u32> = 7..8;
pub const SET_POINT_SPRITE_SELECT_TEXTURE4_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE4_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE5: Range<u32> = 8..9;
pub const SET_POINT_SPRITE_SELECT_TEXTURE5_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE5_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE6: Range<u32> = 9..10;
pub const SET_POINT_SPRITE_SELECT_TEXTURE6_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE6_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE7: Range<u32> = 10..11;
pub const SET_POINT_SPRITE_SELECT_TEXTURE7_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE7_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE8: Range<u32> = 11..12;
pub const SET_POINT_SPRITE_SELECT_TEXTURE8_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE8_GENERATE: u32 = 0x00000001;
pub const SET_POINT_SPRITE_SELECT_TEXTURE9: Range<u32> = 12..13;
pub const SET_POINT_SPRITE_SELECT_TEXTURE9_PASSTHROUGH: u32 = 0x00000000;
pub const SET_POINT_SPRITE_SELECT_TEXTURE9_GENERATE: u32 = 0x00000001;
pub const SET_PROGRAM_REGION_A: u32 = 0x1608;
pub const SET_PROGRAM_REGION_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_PROGRAM_REGION_B: u32 = 0x160c;
pub const SET_PROGRAM_REGION_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_ATTRIBUTE_DEFAULT: u32 = 0x1610;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE: Range<u32> = 0..1;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_0001: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_1111: u32 = 0x00000001;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR: Range<u32> = 1..2;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0000: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0001: u32 = 0x00000001;
pub const SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR: Range<u32> = 2..3;
pub const SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0000: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0001: u32 = 0x00000001;
pub const SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE: Range<u32> = 3..4;
pub const SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0000: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0001: u32 = 0x00000001;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR0: Range<u32> = 4..5;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_0001: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_1111: u32 = 0x00000001;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15: Range<u32> = 5..6;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0000: u32 = 0x00000000;
pub const SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0001: u32 = 0x00000001;
pub const END: u32 = 0x1614;
pub const END_V: Range<u32> = 0..1;
pub const BEGIN: u32 = 0x1618;
pub const BEGIN_OP: Range<u32> = 0..16;
pub const BEGIN_OP_POINTS: u32 = 0x00000000;
pub const BEGIN_OP_LINES: u32 = 0x00000001;
pub const BEGIN_OP_LINE_LOOP: u32 = 0x00000002;
pub const BEGIN_OP_LINE_STRIP: u32 = 0x00000003;
pub const BEGIN_OP_TRIANGLES: u32 = 0x00000004;
pub const BEGIN_OP_TRIANGLE_STRIP: u32 = 0x00000005;
pub const BEGIN_OP_TRIANGLE_FAN: u32 = 0x00000006;
pub const BEGIN_OP_QUADS: u32 = 0x00000007;
pub const BEGIN_OP_QUAD_STRIP: u32 = 0x00000008;
pub const BEGIN_OP_POLYGON: u32 = 0x00000009;
pub const BEGIN_OP_LINELIST_ADJCY: u32 = 0x0000000A;
pub const BEGIN_OP_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const BEGIN_OP_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const BEGIN_OP_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const BEGIN_OP_PATCH: u32 = 0x0000000E;
pub const BEGIN_PRIMITIVE_ID: Range<u32> = 24..25;
pub const BEGIN_PRIMITIVE_ID_FIRST: u32 = 0x00000000;
pub const BEGIN_PRIMITIVE_ID_UNCHANGED: u32 = 0x00000001;
pub const BEGIN_INSTANCE_ID: Range<u32> = 26..28;
pub const BEGIN_INSTANCE_ID_FIRST: u32 = 0x00000000;
pub const BEGIN_INSTANCE_ID_SUBSEQUENT: u32 = 0x00000001;
pub const BEGIN_INSTANCE_ID_UNCHANGED: u32 = 0x00000002;
pub const BEGIN_SPLIT_MODE: Range<u32> = 29..31;
pub const BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END: u32 = 0x00000000;
pub const BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END: u32 = 0x00000001;
pub const BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END: u32 = 0x00000002;
pub const BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END: u32 = 0x00000003;
pub const SET_VERTEX_ID_COPY: u32 = 0x161c;
pub const SET_VERTEX_ID_COPY_ENABLE: Range<u32> = 0..1;
pub const SET_VERTEX_ID_COPY_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_ID_COPY_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_VERTEX_ID_COPY_ATTRIBUTE_SLOT: Range<u32> = 4..12;
pub const ADD_TO_PRIMITIVE_ID: u32 = 0x1620;
pub const ADD_TO_PRIMITIVE_ID_V: Range<u32> = 0..32;
pub const LOAD_PRIMITIVE_ID: u32 = 0x1624;
pub const LOAD_PRIMITIVE_ID_V: Range<u32> = 0..32;
pub const SET_SHADER_BASED_CULL: u32 = 0x162c;
pub const SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE: Range<u32> = 1..2;
pub const SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_CLASS_VERSION: u32 = 0x1638;
pub const SET_CLASS_VERSION_CURRENT: Range<u32> = 0..16;
pub const SET_CLASS_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const SET_VAB_PAGE: u32 = 0x163c;
pub const SET_VAB_PAGE_READ_SELECT: Range<u32> = 0..1;
pub const SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_1: u32 = 0x00000000;
pub const SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_2: u32 = 0x00000001;
pub const DRAW_INLINE_VERTEX: u32 = 0x1640;
pub const DRAW_INLINE_VERTEX_V: Range<u32> = 0..32;
pub const SET_DA_PRIMITIVE_RESTART: u32 = 0x1644;
pub const SET_DA_PRIMITIVE_RESTART_ENABLE: Range<u32> = 0..1;
pub const SET_DA_PRIMITIVE_RESTART_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DA_PRIMITIVE_RESTART_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_DA_PRIMITIVE_RESTART_INDEX: u32 = 0x1648;
pub const SET_DA_PRIMITIVE_RESTART_INDEX_V: Range<u32> = 0..32;
pub const SET_DA_OUTPUT: u32 = 0x164c;
pub const SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START: Range<u32> = 12..13;
pub const SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_FALSE: u32 = 0x00000000;
pub const SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_TRUE: u32 = 0x00000001;
pub const SET_ANTI_ALIASED_POINT: u32 = 0x1658;
pub const SET_ANTI_ALIASED_POINT_ENABLE: Range<u32> = 0..1;
pub const SET_ANTI_ALIASED_POINT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ANTI_ALIASED_POINT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POINT_CENTER_MODE: u32 = 0x165c;
pub const SET_POINT_CENTER_MODE_V: Range<u32> = 0..32;
pub const SET_POINT_CENTER_MODE_V_OGL: u32 = 0x00000000;
pub const SET_POINT_CENTER_MODE_V_D3D: u32 = 0x00000001;
pub const SET_LINE_SMOOTH_PARAMETERS: u32 = 0x1668;
pub const SET_LINE_SMOOTH_PARAMETERS_FALLOFF: Range<u32> = 0..32;
pub const SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_00: u32 = 0x00000000;
pub const SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_33: u32 = 0x00000001;
pub const SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_60: u32 = 0x00000002;
pub const SET_LINE_STIPPLE: u32 = 0x166c;
pub const SET_LINE_STIPPLE_ENABLE: Range<u32> = 0..1;
pub const SET_LINE_STIPPLE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_LINE_STIPPLE_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_line_smooth_edge_table  (i: u32) -> u32 { 0x1670+i*4 } 
pub const SET_LINE_SMOOTH_EDGE_TABLE_V0: Range<u32> = 0..8;
pub const SET_LINE_SMOOTH_EDGE_TABLE_V1: Range<u32> = 8..16;
pub const SET_LINE_SMOOTH_EDGE_TABLE_V2: Range<u32> = 16..24;
pub const SET_LINE_SMOOTH_EDGE_TABLE_V3: Range<u32> = 24..32;
pub const SET_LINE_STIPPLE_PARAMETERS: u32 = 0x1680;
pub const SET_LINE_STIPPLE_PARAMETERS_FACTOR: Range<u32> = 0..8;
pub const SET_LINE_STIPPLE_PARAMETERS_PATTERN: Range<u32> = 8..24;
pub const SET_PROVOKING_VERTEX: u32 = 0x1684;
pub const SET_PROVOKING_VERTEX_V: Range<u32> = 0..1;
pub const SET_PROVOKING_VERTEX_V_FIRST: u32 = 0x00000000;
pub const SET_PROVOKING_VERTEX_V_LAST: u32 = 0x00000001;
pub const SET_TWO_SIDED_LIGHT: u32 = 0x1688;
pub const SET_TWO_SIDED_LIGHT_ENABLE: Range<u32> = 0..1;
pub const SET_TWO_SIDED_LIGHT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_TWO_SIDED_LIGHT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_POLYGON_STIPPLE: u32 = 0x168c;
pub const SET_POLYGON_STIPPLE_ENABLE: Range<u32> = 0..1;
pub const SET_POLYGON_STIPPLE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_POLYGON_STIPPLE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SHADER_CONTROL: u32 = 0x1690;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL: Range<u32> = 0..1;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO: u32 = 0x00000000;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY: u32 = 0x00000001;
pub const SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR: Range<u32> = 1..2;
pub const SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY: u32 = 0x00000000;
pub const SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE: u32 = 0x00000001;
pub const SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR: Range<u32> = 2..3;
pub const SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO: u32 = 0x00000000;
pub const SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE: u32 = 0x00000001;
pub const LAUNCH_VERTEX: u32 = 0x169c;
pub const LAUNCH_VERTEX_V: Range<u32> = 0..1;
pub const CHECK_CLASS_VERSION: u32 = 0x16a0;
pub const CHECK_CLASS_VERSION_CURRENT: Range<u32> = 0..16;
pub const CHECK_CLASS_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const SET_SPH_VERSION: u32 = 0x16a4;
pub const SET_SPH_VERSION_CURRENT: Range<u32> = 0..16;
pub const SET_SPH_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const CHECK_SPH_VERSION: u32 = 0x16a8;
pub const CHECK_SPH_VERSION_CURRENT: Range<u32> = 0..16;
pub const CHECK_SPH_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE: u32 = 0x16b4;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE: Range<u32> = 0..1;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE: u32 = 0x00000000;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE: u32 = 0x00000001;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT: Range<u32> = 1..2;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE: u32 = 0x00000000;
pub const SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE: u32 = 0x00000001;
#[inline]
pub fn set_polygon_stipple_pattern  (i: u32) -> u32 { 0x1700+i*4 } 
pub const SET_POLYGON_STIPPLE_PATTERN_V: Range<u32> = 0..32;
pub const SET_AAM_VERSION: u32 = 0x1790;
pub const SET_AAM_VERSION_CURRENT: Range<u32> = 0..16;
pub const SET_AAM_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const CHECK_AAM_VERSION: u32 = 0x1794;
pub const CHECK_AAM_VERSION_CURRENT: Range<u32> = 0..16;
pub const CHECK_AAM_VERSION_OLDEST_SUPPORTED: Range<u32> = 16..32;
pub const SET_ZT_LAYER: u32 = 0x179c;
pub const SET_ZT_LAYER_OFFSET: Range<u32> = 0..16;
pub const SET_VAB_MEMORY_AREA_A: u32 = 0x17bc;
pub const SET_VAB_MEMORY_AREA_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_VAB_MEMORY_AREA_B: u32 = 0x17c0;
pub const SET_VAB_MEMORY_AREA_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_VAB_MEMORY_AREA_C: u32 = 0x17c4;
pub const SET_VAB_MEMORY_AREA_C_SIZE: Range<u32> = 0..2;
pub const SET_VAB_MEMORY_AREA_C_SIZE_BYTES_64K: u32 = 0x00000001;
pub const SET_VAB_MEMORY_AREA_C_SIZE_BYTES_128K: u32 = 0x00000002;
pub const SET_VAB_MEMORY_AREA_C_SIZE_BYTES_256K: u32 = 0x00000003;
pub const SET_INDEX_BUFFER_A: u32 = 0x17c8;
pub const SET_INDEX_BUFFER_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_INDEX_BUFFER_B: u32 = 0x17cc;
pub const SET_INDEX_BUFFER_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_INDEX_BUFFER_C: u32 = 0x17d0;
pub const SET_INDEX_BUFFER_C_LIMIT_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_INDEX_BUFFER_D: u32 = 0x17d4;
pub const SET_INDEX_BUFFER_D_LIMIT_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_INDEX_BUFFER_E: u32 = 0x17d8;
pub const SET_INDEX_BUFFER_E_INDEX_SIZE: Range<u32> = 0..2;
pub const SET_INDEX_BUFFER_E_INDEX_SIZE_ONE_BYTE: u32 = 0x00000000;
pub const SET_INDEX_BUFFER_E_INDEX_SIZE_TWO_BYTES: u32 = 0x00000001;
pub const SET_INDEX_BUFFER_E_INDEX_SIZE_FOUR_BYTES: u32 = 0x00000002;
pub const SET_INDEX_BUFFER_F: u32 = 0x17dc;
pub const SET_INDEX_BUFFER_F_FIRST: Range<u32> = 0..32;
pub const DRAW_INDEX_BUFFER: u32 = 0x17e0;
pub const DRAW_INDEX_BUFFER_COUNT: Range<u32> = 0..32;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST: u32 = 0x17e4;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST: u32 = 0x17e8;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST: u32 = 0x17ec;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT: u32 = 0x17f0;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT: u32 = 0x17f4;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT: u32 = 0x17f8;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_FIRST: Range<u32> = 0..16;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_COUNT: Range<u32> = 16..28;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY: Range<u32> = 28..32;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS: u32 = 0x00000000;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES: u32 = 0x00000001;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP: u32 = 0x00000002;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP: u32 = 0x00000003;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES: u32 = 0x00000004;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP: u32 = 0x00000005;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN: u32 = 0x00000006;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS: u32 = 0x00000007;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP: u32 = 0x00000008;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON: u32 = 0x00000009;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY: u32 = 0x0000000A;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH: u32 = 0x0000000E;
pub const SET_DEPTH_BIAS_CLAMP: u32 = 0x187c;
pub const SET_DEPTH_BIAS_CLAMP_V: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_stream_instance_a  (i: u32) -> u32 { 0x1880+i*4 } 
pub const SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED: Range<u32> = 0..1;
pub const SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_vertex_stream_instance_b  (i: u32) -> u32 { 0x18c0+i*4 } 
pub const SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED: Range<u32> = 0..1;
pub const SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_TRUE: u32 = 0x00000001;
pub const SET_ATTRIBUTE_POINT_SIZE: u32 = 0x1910;
pub const SET_ATTRIBUTE_POINT_SIZE_ENABLE: Range<u32> = 0..1;
pub const SET_ATTRIBUTE_POINT_SIZE_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ATTRIBUTE_POINT_SIZE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ATTRIBUTE_POINT_SIZE_SLOT: Range<u32> = 4..12;
pub const OGL_SET_CULL: u32 = 0x1918;
pub const OGL_SET_CULL_ENABLE: Range<u32> = 0..1;
pub const OGL_SET_CULL_ENABLE_FALSE: u32 = 0x00000000;
pub const OGL_SET_CULL_ENABLE_TRUE: u32 = 0x00000001;
pub const OGL_SET_FRONT_FACE: u32 = 0x191c;
pub const OGL_SET_FRONT_FACE_V: Range<u32> = 0..32;
pub const OGL_SET_FRONT_FACE_V_CW: u32 = 0x00000900;
pub const OGL_SET_FRONT_FACE_V_CCW: u32 = 0x00000901;
pub const OGL_SET_CULL_FACE: u32 = 0x1920;
pub const OGL_SET_CULL_FACE_V: Range<u32> = 0..32;
pub const OGL_SET_CULL_FACE_V_FRONT: u32 = 0x00000404;
pub const OGL_SET_CULL_FACE_V_BACK: u32 = 0x00000405;
pub const OGL_SET_CULL_FACE_V_FRONT_AND_BACK: u32 = 0x00000408;
pub const SET_VIEWPORT_PIXEL: u32 = 0x1924;
pub const SET_VIEWPORT_PIXEL_CENTER: Range<u32> = 0..1;
pub const SET_VIEWPORT_PIXEL_CENTER_AT_HALF_INTEGERS: u32 = 0x00000000;
pub const SET_VIEWPORT_PIXEL_CENTER_AT_INTEGERS: u32 = 0x00000001;
pub const SET_VIEWPORT_SCALE_OFFSET: u32 = 0x192c;
pub const SET_VIEWPORT_SCALE_OFFSET_ENABLE: Range<u32> = 0..1;
pub const SET_VIEWPORT_SCALE_OFFSET_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_VIEWPORT_SCALE_OFFSET_ENABLE_TRUE: u32 = 0x00000001;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE: u32 = 0x1930;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2: Range<u32> = 0..1;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE: u32 = 0x00000000;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL: u32 = 0x193c;
pub const SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE: Range<u32> = 0..1;
pub const SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z: Range<u32> = 3..4;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z: Range<u32> = 4..5;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND: Range<u32> = 7..8;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND: Range<u32> = 10..11;
pub const SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP: Range<u32> = 11..14;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP: u32 = 0x00000002;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP: u32 = 0x00000003;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL: u32 = 0x00000004;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP: u32 = 0x00000005;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z: Range<u32> = 1..3;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND: u32 = 0x00000000;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256: u32 = 0x00000001;
pub const SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1: u32 = 0x00000002;
pub const SET_USER_CLIP_OP: u32 = 0x1940;
pub const SET_USER_CLIP_OP_PLANE0: Range<u32> = 0..1;
pub const SET_USER_CLIP_OP_PLANE0_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE0_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE1: Range<u32> = 4..5;
pub const SET_USER_CLIP_OP_PLANE1_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE1_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE2: Range<u32> = 8..9;
pub const SET_USER_CLIP_OP_PLANE2_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE2_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE3: Range<u32> = 12..13;
pub const SET_USER_CLIP_OP_PLANE3_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE3_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE4: Range<u32> = 16..17;
pub const SET_USER_CLIP_OP_PLANE4_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE4_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE5: Range<u32> = 20..21;
pub const SET_USER_CLIP_OP_PLANE5_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE5_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE6: Range<u32> = 24..25;
pub const SET_USER_CLIP_OP_PLANE6_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE6_CULL: u32 = 0x00000001;
pub const SET_USER_CLIP_OP_PLANE7: Range<u32> = 28..29;
pub const SET_USER_CLIP_OP_PLANE7_CLIP: u32 = 0x00000000;
pub const SET_USER_CLIP_OP_PLANE7_CULL: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x1944;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
pub const SET_PRIMITIVE_TOPOLOGY_CONTROL: u32 = 0x1948;
pub const SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE: Range<u32> = 0..1;
pub const SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS: u32 = 0x00000000;
pub const SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE: u32 = 0x00000001;
pub const SET_WINDOW_CLIP_ENABLE: u32 = 0x194c;
pub const SET_WINDOW_CLIP_ENABLE_V: Range<u32> = 0..1;
pub const SET_WINDOW_CLIP_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_WINDOW_CLIP_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_WINDOW_CLIP_TYPE: u32 = 0x1950;
pub const SET_WINDOW_CLIP_TYPE_V: Range<u32> = 0..2;
pub const SET_WINDOW_CLIP_TYPE_V_INCLUSIVE: u32 = 0x00000000;
pub const SET_WINDOW_CLIP_TYPE_V_EXCLUSIVE: u32 = 0x00000001;
pub const SET_WINDOW_CLIP_TYPE_V_CLIPALL: u32 = 0x00000002;
pub const INVALIDATE_ZCULL: u32 = 0x1958;
pub const INVALIDATE_ZCULL_V: Range<u32> = 0..32;
pub const INVALIDATE_ZCULL_V_INVALIDATE: u32 = 0x00000000;
pub const SET_ZCULL: u32 = 0x1968;
pub const SET_ZCULL_Z_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_Z_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_Z_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_STENCIL_ENABLE: Range<u32> = 4..5;
pub const SET_ZCULL_STENCIL_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_STENCIL_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_BOUNDS: u32 = 0x196c;
pub const SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE: Range<u32> = 0..1;
pub const SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE: Range<u32> = 4..5;
pub const SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_PRIMITIVE_TOPOLOGY: u32 = 0x1970;
pub const SET_PRIMITIVE_TOPOLOGY_V: Range<u32> = 0..16;
pub const SET_PRIMITIVE_TOPOLOGY_V_POINTLIST: u32 = 0x00000001;
pub const SET_PRIMITIVE_TOPOLOGY_V_LINELIST: u32 = 0x00000002;
pub const SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP: u32 = 0x00000003;
pub const SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST: u32 = 0x00000004;
pub const SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP: u32 = 0x00000005;
pub const SET_PRIMITIVE_TOPOLOGY_V_LINELIST_ADJCY: u32 = 0x0000000A;
pub const SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP_ADJCY: u32 = 0x0000000B;
pub const SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST_ADJCY: u32 = 0x0000000C;
pub const SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP_ADJCY: u32 = 0x0000000D;
pub const SET_PRIMITIVE_TOPOLOGY_V_PATCHLIST: u32 = 0x0000000E;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_POINTS: u32 = 0x00001001;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST: u32 = 0x00001002;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST: u32 = 0x00001003;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST: u32 = 0x0000100F;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINESTRIP: u32 = 0x00001010;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINESTRIP: u32 = 0x00001011;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLELIST: u32 = 0x00001012;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLESTRIP: u32 = 0x00001013;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLESTRIP: u32 = 0x00001014;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN: u32 = 0x00001015;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLEFAN: u32 = 0x00001016;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN_IMM: u32 = 0x00001017;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST_IMM: u32 = 0x00001018;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST2: u32 = 0x0000101A;
pub const SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST2: u32 = 0x0000101B;
pub const ZCULL_SYNC: u32 = 0x1978;
pub const ZCULL_SYNC_V: Range<u32> = 0..32;
pub const SET_CLIP_ID_TEST: u32 = 0x197c;
pub const SET_CLIP_ID_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_CLIP_ID_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_CLIP_ID_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SURFACE_CLIP_ID_WIDTH: u32 = 0x1980;
pub const SET_SURFACE_CLIP_ID_WIDTH_V: Range<u32> = 0..32;
pub const SET_CLIP_ID: u32 = 0x1984;
pub const SET_CLIP_ID_V: Range<u32> = 0..32;
pub const SET_DEPTH_BOUNDS_TEST: u32 = 0x19bc;
pub const SET_DEPTH_BOUNDS_TEST_ENABLE: Range<u32> = 0..1;
pub const SET_DEPTH_BOUNDS_TEST_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_DEPTH_BOUNDS_TEST_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_BLEND_FLOAT_OPTION: u32 = 0x19c0;
pub const SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO: Range<u32> = 0..1;
pub const SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE: u32 = 0x00000000;
pub const SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE: u32 = 0x00000001;
pub const SET_LOGIC_OP: u32 = 0x19c4;
pub const SET_LOGIC_OP_ENABLE: Range<u32> = 0..1;
pub const SET_LOGIC_OP_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_LOGIC_OP_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_LOGIC_OP_FUNC: u32 = 0x19c8;
pub const SET_LOGIC_OP_FUNC_V: Range<u32> = 0..32;
pub const SET_LOGIC_OP_FUNC_V_CLEAR: u32 = 0x00001500;
pub const SET_LOGIC_OP_FUNC_V_AND: u32 = 0x00001501;
pub const SET_LOGIC_OP_FUNC_V_AND_REVERSE: u32 = 0x00001502;
pub const SET_LOGIC_OP_FUNC_V_COPY: u32 = 0x00001503;
pub const SET_LOGIC_OP_FUNC_V_AND_INVERTED: u32 = 0x00001504;
pub const SET_LOGIC_OP_FUNC_V_NOOP: u32 = 0x00001505;
pub const SET_LOGIC_OP_FUNC_V_XOR: u32 = 0x00001506;
pub const SET_LOGIC_OP_FUNC_V_OR: u32 = 0x00001507;
pub const SET_LOGIC_OP_FUNC_V_NOR: u32 = 0x00001508;
pub const SET_LOGIC_OP_FUNC_V_EQUIV: u32 = 0x00001509;
pub const SET_LOGIC_OP_FUNC_V_INVERT: u32 = 0x0000150A;
pub const SET_LOGIC_OP_FUNC_V_OR_REVERSE: u32 = 0x0000150B;
pub const SET_LOGIC_OP_FUNC_V_COPY_INVERTED: u32 = 0x0000150C;
pub const SET_LOGIC_OP_FUNC_V_OR_INVERTED: u32 = 0x0000150D;
pub const SET_LOGIC_OP_FUNC_V_NAND: u32 = 0x0000150E;
pub const SET_LOGIC_OP_FUNC_V_SET: u32 = 0x0000150F;
pub const SET_Z_COMPRESSION: u32 = 0x19cc;
pub const SET_Z_COMPRESSION_ENABLE: Range<u32> = 0..1;
pub const SET_Z_COMPRESSION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_Z_COMPRESSION_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE: u32 = 0x19d0;
pub const CLEAR_SURFACE_Z_ENABLE: Range<u32> = 0..1;
pub const CLEAR_SURFACE_Z_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_Z_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_STENCIL_ENABLE: Range<u32> = 1..2;
pub const CLEAR_SURFACE_STENCIL_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_STENCIL_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_R_ENABLE: Range<u32> = 2..3;
pub const CLEAR_SURFACE_R_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_R_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_G_ENABLE: Range<u32> = 3..4;
pub const CLEAR_SURFACE_G_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_G_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_B_ENABLE: Range<u32> = 4..5;
pub const CLEAR_SURFACE_B_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_B_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_A_ENABLE: Range<u32> = 5..6;
pub const CLEAR_SURFACE_A_ENABLE_FALSE: u32 = 0x00000000;
pub const CLEAR_SURFACE_A_ENABLE_TRUE: u32 = 0x00000001;
pub const CLEAR_SURFACE_MRT_SELECT: Range<u32> = 6..10;
pub const CLEAR_SURFACE_RT_ARRAY_INDEX: Range<u32> = 10..26;
pub const CLEAR_CLIP_ID_SURFACE: u32 = 0x19d4;
pub const CLEAR_CLIP_ID_SURFACE_V: Range<u32> = 0..32;
#[inline]
pub fn set_color_compression  (i: u32) -> u32 { 0x19e0+i*4 } 
pub const SET_COLOR_COMPRESSION_ENABLE: Range<u32> = 0..1;
pub const SET_COLOR_COMPRESSION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_COLOR_COMPRESSION_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_ct_write  (i: u32) -> u32 { 0x1a00+i*4 } 
pub const SET_CT_WRITE_R_ENABLE: Range<u32> = 0..1;
pub const SET_CT_WRITE_R_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_CT_WRITE_R_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_CT_WRITE_G_ENABLE: Range<u32> = 4..5;
pub const SET_CT_WRITE_G_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_CT_WRITE_G_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_CT_WRITE_B_ENABLE: Range<u32> = 8..9;
pub const SET_CT_WRITE_B_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_CT_WRITE_B_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_CT_WRITE_A_ENABLE: Range<u32> = 12..13;
pub const SET_CT_WRITE_A_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_CT_WRITE_A_ENABLE_TRUE: u32 = 0x00000001;
pub const PIPE_NOP: u32 = 0x1a2c;
pub const PIPE_NOP_V: Range<u32> = 0..32;
pub const SET_SPARE00: u32 = 0x1a30;
pub const SET_SPARE00_V: Range<u32> = 0..32;
pub const SET_SPARE01: u32 = 0x1a34;
pub const SET_SPARE01_V: Range<u32> = 0..32;
pub const SET_SPARE02: u32 = 0x1a38;
pub const SET_SPARE02_V: Range<u32> = 0..32;
pub const SET_SPARE03: u32 = 0x1a3c;
pub const SET_SPARE03_V: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_A: u32 = 0x1b00;
pub const SET_REPORT_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_REPORT_SEMAPHORE_B: u32 = 0x1b04;
pub const SET_REPORT_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_C: u32 = 0x1b08;
pub const SET_REPORT_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_D: u32 = 0x1b0c;
pub const SET_REPORT_SEMAPHORE_D_OPERATION: Range<u32> = 0..2;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY: u32 = 0x00000002;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_TRAP: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_RELEASE: Range<u32> = 4..5;
pub const SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_ACQUIRE: Range<u32> = 8..9;
pub const SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION: Range<u32> = 12..16;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER: u32 = 0x00000002;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER: u32 = 0x00000008;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER: u32 = 0x00000009;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER: u32 = 0x00000006;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT: u32 = 0x00000005;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC: u32 = 0x00000004;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL: u32 = 0x00000007;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER: u32 = 0x0000000A;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST: u32 = 0x0000000C;
pub const SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL: u32 = 0x0000000F;
pub const SET_REPORT_SEMAPHORE_D_COMPARISON: Range<u32> = 16..17;
pub const SET_REPORT_SEMAPHORE_D_COMPARISON_EQ: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_COMPARISON_GE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE: Range<u32> = 20..21;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REPORT: Range<u32> = 23..28;
pub const SET_REPORT_SEMAPHORE_D_REPORT_NONE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS: u32 = 0x00000005;
pub const SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS: u32 = 0x0000001B;
pub const SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS: u32 = 0x0000001D;
pub const SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED: u32 = 0x0000001F;
pub const SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS: u32 = 0x00000007;
pub const SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED: u32 = 0x00000009;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS: u32 = 0x00000004;
pub const SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT: u32 = 0x00000012;
pub const SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED: u32 = 0x0000001E;
pub const SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED: u32 = 0x0000000B;
pub const SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED: u32 = 0x0000000D;
pub const SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED: u32 = 0x00000006;
pub const SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT: u32 = 0x0000001A;
pub const SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS: u32 = 0x0000000F;
pub const SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED: u32 = 0x00000011;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0: u32 = 0x0000000A;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1: u32 = 0x0000000C;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2: u32 = 0x0000000E;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3: u32 = 0x00000010;
pub const SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS: u32 = 0x00000013;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT: u32 = 0x00000002;
pub const SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64: u32 = 0x00000015;
pub const SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET: u32 = 0x00000018;
pub const SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET: u32 = 0x00000019;
pub const SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE: u32 = 0x0000001C;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE: Range<u32> = 28..29;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_SUB_REPORT: Range<u32> = 5..8;
pub const SET_REPORT_SEMAPHORE_D_REPORT_DWORD_NUMBER: Range<u32> = 21..22;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE: Range<u32> = 2..3;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE: Range<u32> = 3..4;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP: Range<u32> = 9..12;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT: Range<u32> = 17..19;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32: u32 = 0x00000001;
#[inline]
pub fn set_vertex_stream_a_format  (j: u32) -> u32 { 0x1c00+j*16 } 
pub const SET_VERTEX_STREAM_A_FORMAT_STRIDE: Range<u32> = 0..12;
pub const SET_VERTEX_STREAM_A_FORMAT_ENABLE: Range<u32> = 12..13;
pub const SET_VERTEX_STREAM_A_FORMAT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_STREAM_A_FORMAT_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_vertex_stream_a_location_a  (j: u32) -> u32 { 0x1c04+j*16 } 
pub const SET_VERTEX_STREAM_A_LOCATION_A_OFFSET_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_vertex_stream_a_location_b  (j: u32) -> u32 { 0x1c08+j*16 } 
pub const SET_VERTEX_STREAM_A_LOCATION_B_OFFSET_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_stream_a_frequency  (j: u32) -> u32 { 0x1c0c+j*16 } 
pub const SET_VERTEX_STREAM_A_FREQUENCY_V: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_stream_b_format  (j: u32) -> u32 { 0x1d00+j*16 } 
pub const SET_VERTEX_STREAM_B_FORMAT_STRIDE: Range<u32> = 0..12;
pub const SET_VERTEX_STREAM_B_FORMAT_ENABLE: Range<u32> = 12..13;
pub const SET_VERTEX_STREAM_B_FORMAT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_VERTEX_STREAM_B_FORMAT_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_vertex_stream_b_location_a  (j: u32) -> u32 { 0x1d04+j*16 } 
pub const SET_VERTEX_STREAM_B_LOCATION_A_OFFSET_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_vertex_stream_b_location_b  (j: u32) -> u32 { 0x1d08+j*16 } 
pub const SET_VERTEX_STREAM_B_LOCATION_B_OFFSET_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_stream_b_frequency  (j: u32) -> u32 { 0x1d0c+j*16 } 
pub const SET_VERTEX_STREAM_B_FREQUENCY_V: Range<u32> = 0..32;
#[inline]
pub fn set_blend_per_target_separate_for_alpha  (j: u32) -> u32 { 0x1e00+j*32 } 
pub const SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE: Range<u32> = 0..1;
pub const SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_TRUE: u32 = 0x00000001;
#[inline]
pub fn set_blend_per_target_color_op  (j: u32) -> u32 { 0x1e04+j*32 } 
pub const SET_BLEND_PER_TARGET_COLOR_OP_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_SUBTRACT: u32 = 0x0000800A;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT: u32 = 0x0000800B;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_ADD: u32 = 0x00008006;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MIN: u32 = 0x00008007;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MAX: u32 = 0x00008008;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_ADD: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_SUBTRACT: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_REVSUBTRACT: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MIN: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MAX: u32 = 0x00000005;
#[inline]
pub fn set_blend_per_target_color_source_coeff  (j: u32) -> u32 { 0x1e08+j*32 } 
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA: u32 = 0x0000000C;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA: u32 = 0x0000000D;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
#[inline]
pub fn set_blend_per_target_color_dest_coeff  (j: u32) -> u32 { 0x1e0c+j*32 } 
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
#[inline]
pub fn set_blend_per_target_alpha_op  (j: u32) -> u32 { 0x1e10+j*32 } 
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_SUBTRACT: u32 = 0x0000800A;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT: u32 = 0x0000800B;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_ADD: u32 = 0x00008006;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MIN: u32 = 0x00008007;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MAX: u32 = 0x00008008;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_ADD: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_SUBTRACT: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_REVSUBTRACT: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MIN: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MAX: u32 = 0x00000005;
#[inline]
pub fn set_blend_per_target_alpha_source_coeff  (j: u32) -> u32 { 0x1e14+j*32 } 
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA: u32 = 0x0000000C;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA: u32 = 0x0000000D;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
#[inline]
pub fn set_blend_per_target_alpha_dest_coeff  (j: u32) -> u32 { 0x1e18+j*32 } 
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V: Range<u32> = 0..32;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ZERO: u32 = 0x00004000;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE: u32 = 0x00004001;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR: u32 = 0x00004300;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR: u32 = 0x00004301;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA: u32 = 0x00004302;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA: u32 = 0x00004303;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA: u32 = 0x00004304;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA: u32 = 0x00004305;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_COLOR: u32 = 0x00004306;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR: u32 = 0x00004307;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE: u32 = 0x00004308;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR: u32 = 0x0000C001;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR: u32 = 0x0000C002;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA: u32 = 0x0000C003;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA: u32 = 0x0000C004;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR: u32 = 0x0000C900;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR: u32 = 0x0000C901;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA: u32 = 0x0000C902;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA: u32 = 0x0000C903;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ZERO: u32 = 0x00000001;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ONE: u32 = 0x00000002;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR: u32 = 0x00000003;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR: u32 = 0x00000004;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHA: u32 = 0x00000005;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA: u32 = 0x00000006;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTALPHA: u32 = 0x00000007;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA: u32 = 0x00000008;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR: u32 = 0x00000009;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR: u32 = 0x0000000A;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT: u32 = 0x0000000B;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR: u32 = 0x0000000E;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR: u32 = 0x0000000F;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR: u32 = 0x00000010;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR: u32 = 0x00000011;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA: u32 = 0x00000012;
pub const SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA: u32 = 0x00000013;
#[inline]
pub fn set_vertex_stream_limit_a_a  (j: u32) -> u32 { 0x1f00+j*8 } 
pub const SET_VERTEX_STREAM_LIMIT_A_A_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_vertex_stream_limit_a_b  (j: u32) -> u32 { 0x1f04+j*8 } 
pub const SET_VERTEX_STREAM_LIMIT_A_B_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_vertex_stream_limit_b_a  (j: u32) -> u32 { 0x1f80+j*8 } 
pub const SET_VERTEX_STREAM_LIMIT_B_A_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_vertex_stream_limit_b_b  (j: u32) -> u32 { 0x1f84+j*8 } 
pub const SET_VERTEX_STREAM_LIMIT_B_B_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_pipeline_shader  (j: u32) -> u32 { 0x2000+j*64 } 
pub const SET_PIPELINE_SHADER_ENABLE: Range<u32> = 0..1;
pub const SET_PIPELINE_SHADER_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_PIPELINE_SHADER_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_PIPELINE_SHADER_TYPE: Range<u32> = 4..8;
pub const SET_PIPELINE_SHADER_TYPE_VERTEX_CULL_BEFORE_FETCH: u32 = 0x00000000;
pub const SET_PIPELINE_SHADER_TYPE_VERTEX: u32 = 0x00000001;
pub const SET_PIPELINE_SHADER_TYPE_TESSELLATION_INIT: u32 = 0x00000002;
pub const SET_PIPELINE_SHADER_TYPE_TESSELLATION: u32 = 0x00000003;
pub const SET_PIPELINE_SHADER_TYPE_GEOMETRY: u32 = 0x00000004;
pub const SET_PIPELINE_SHADER_TYPE_PIXEL: u32 = 0x00000005;
#[inline]
pub fn set_pipeline_program  (j: u32) -> u32 { 0x2004+j*64 } 
pub const SET_PIPELINE_PROGRAM_OFFSET: Range<u32> = 0..32;
#[inline]
pub fn set_pipeline_reserved_a  (j: u32) -> u32 { 0x2008+j*64 } 
pub const SET_PIPELINE_RESERVED_A_V: Range<u32> = 0..1;
#[inline]
pub fn set_pipeline_register_count  (j: u32) -> u32 { 0x200c+j*64 } 
pub const SET_PIPELINE_REGISTER_COUNT_V: Range<u32> = 0..8;
#[inline]
pub fn set_pipeline_binding  (j: u32) -> u32 { 0x2010+j*64 } 
pub const SET_PIPELINE_BINDING_GROUP: Range<u32> = 0..3;
#[inline]
pub fn set_pipeline_reserved_b  (j: u32) -> u32 { 0x2014+j*64 } 
pub const SET_PIPELINE_RESERVED_B_V: Range<u32> = 0..1;
#[inline]
pub fn set_pipeline_reserved_c  (j: u32) -> u32 { 0x2018+j*64 } 
pub const SET_PIPELINE_RESERVED_C_V: Range<u32> = 0..1;
#[inline]
pub fn set_pipeline_reserved_d  (j: u32) -> u32 { 0x201c+j*64 } 
pub const SET_PIPELINE_RESERVED_D_V: Range<u32> = 0..1;
#[inline]
pub fn set_pipeline_reserved_e  (j: u32) -> u32 { 0x2020+j*64 } 
pub const SET_PIPELINE_RESERVED_E_V: Range<u32> = 0..1;
pub const SET_FALCON00: u32 = 0x2300;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x2304;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x2308;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x230c;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x2310;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x2314;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x2318;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x231c;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x2320;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x2324;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x2328;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x232c;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x2330;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x2334;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x2338;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x233c;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x2340;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x2344;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x2348;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x234c;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x2350;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x2354;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x2358;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x235c;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x2360;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x2364;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x2368;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x236c;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x2370;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x2374;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x2378;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x237c;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const SET_CONSTANT_BUFFER_SELECTOR_A: u32 = 0x2380;
pub const SET_CONSTANT_BUFFER_SELECTOR_A_SIZE: Range<u32> = 0..17;
pub const SET_CONSTANT_BUFFER_SELECTOR_B: u32 = 0x2384;
pub const SET_CONSTANT_BUFFER_SELECTOR_B_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_CONSTANT_BUFFER_SELECTOR_C: u32 = 0x2388;
pub const SET_CONSTANT_BUFFER_SELECTOR_C_ADDRESS_LOWER: Range<u32> = 0..32;
pub const LOAD_CONSTANT_BUFFER_OFFSET: u32 = 0x238c;
pub const LOAD_CONSTANT_BUFFER_OFFSET_V: Range<u32> = 0..16;
#[inline]
pub fn load_constant_buffer  (i: u32) -> u32 { 0x2390+i*4 } 
pub const LOAD_CONSTANT_BUFFER_V: Range<u32> = 0..32;
#[inline]
pub fn bind_group_reserved_a  (j: u32) -> u32 { 0x2400+j*32 } 
pub const BIND_GROUP_RESERVED_A_V: Range<u32> = 0..1;
#[inline]
pub fn bind_group_reserved_b  (j: u32) -> u32 { 0x2404+j*32 } 
pub const BIND_GROUP_RESERVED_B_V: Range<u32> = 0..1;
#[inline]
pub fn bind_group_reserved_c  (j: u32) -> u32 { 0x2408+j*32 } 
pub const BIND_GROUP_RESERVED_C_V: Range<u32> = 0..1;
#[inline]
pub fn bind_group_reserved_d  (j: u32) -> u32 { 0x240c+j*32 } 
pub const BIND_GROUP_RESERVED_D_V: Range<u32> = 0..1;
#[inline]
pub fn bind_group_constant_buffer  (j: u32) -> u32 { 0x2410+j*32 } 
pub const BIND_GROUP_CONSTANT_BUFFER_VALID: Range<u32> = 0..1;
pub const BIND_GROUP_CONSTANT_BUFFER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_GROUP_CONSTANT_BUFFER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_GROUP_CONSTANT_BUFFER_SHADER_SLOT: Range<u32> = 4..9;
pub const SET_COLOR_CLAMP: u32 = 0x2600;
pub const SET_COLOR_CLAMP_ENABLE: Range<u32> = 0..1;
pub const SET_COLOR_CLAMP_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_COLOR_CLAMP_ENABLE_TRUE: u32 = 0x00000001;
pub const NOOP_X_X_X_SET_VALVE: u32 = 0x2604;
pub const NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY: Range<u32> = 0..1;
pub const NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_COMPUTE: u32 = 0x00000000;
pub const NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_GRAPHICS: u32 = 0x00000001;
pub const SET_BINDLESS_TEXTURE: u32 = 0x2608;
pub const SET_BINDLESS_TEXTURE_CONSTANT_BUFFER_SLOT_SELECT: Range<u32> = 0..5;
pub const SET_TRAP_HANDLER: u32 = 0x260c;
pub const SET_TRAP_HANDLER_OFFSET: Range<u32> = 0..32;
pub const SET_STREAM_OUT_LAYOUT_SELECT_ATTRIBUTE_NUMBER00: Range<u32> = 0..8;
pub const SET_STREAM_OUT_LAYOUT_SELECT_ATTRIBUTE_NUMBER01: Range<u32> = 8..16;
pub const SET_STREAM_OUT_LAYOUT_SELECT_ATTRIBUTE_NUMBER02: Range<u32> = 16..24;
pub const SET_STREAM_OUT_LAYOUT_SELECT_ATTRIBUTE_NUMBER03: Range<u32> = 24..32;
#[inline]
pub fn set_shader_performance_counter_value  (i: u32) -> u32 { 0x335c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_VALUE_V: Range<u32> = 0..32;
#[inline]
pub fn set_shader_performance_counter_event  (i: u32) -> u32 { 0x337c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_EVENT_EVENT: Range<u32> = 0..8;
#[inline]
pub fn set_shader_performance_counter_control_a  (i: u32) -> u32 { 0x339c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT0: Range<u32> = 0..2;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT0: Range<u32> = 2..5;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT1: Range<u32> = 5..7;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT1: Range<u32> = 7..10;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT2: Range<u32> = 10..12;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT2: Range<u32> = 12..15;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT3: Range<u32> = 15..17;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT3: Range<u32> = 17..20;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT4: Range<u32> = 20..22;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT4: Range<u32> = 22..25;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT5: Range<u32> = 25..27;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT5: Range<u32> = 27..30;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_SPARE: Range<u32> = 30..32;
#[inline]
pub fn set_shader_performance_counter_control_b  (i: u32) -> u32 { 0x33bc+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_EDGE: Range<u32> = 0..1;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_MODE: Range<u32> = 1..3;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_WINDOWED: Range<u32> = 3..4;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_FUNC: Range<u32> = 4..20;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL: u32 = 0x33dc;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL_MASK: Range<u32> = 0..8;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_macro  (j: u32) -> u32 { 0x3800+j*8 } 
pub const CALL_MME_MACRO_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_data  (j: u32) -> u32 { 0x3804+j*8 } 
pub const CALL_MME_DATA_V: Range<u32> = 0..32;

// parsed class NVA097




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreReleaseOffsetUpper {
    pub v: u32,
}

impl Mthd for PeerSemaphoreReleaseOffsetUpper {
    const ADDR: u16 = 0x0128;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreReleaseOffset {
    pub v: u32,
}

impl Mthd for PeerSemaphoreReleaseOffset {
    const ADDR: u16 = 0x012c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;
            
        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;
            
        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;
            
        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;
            
        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;
            
        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RunDsNow {
    pub v: u32,
}

impl Mthd for RunDsNow {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold {
    Instantaneous = 0x00000000,
    _16 = 0x00000001,
    _32 = 0x00000002,
    _64 = 0x00000003,
    _128 = 0x00000004,
    _256 = 0x00000005,
    _512 = 0x00000006,
    _1024 = 0x00000007,
    _2048 = 0x00000008,
    _4096 = 0x00000009,
    _8192 = 0x0000000a,
    _16384 = 0x0000000b,
    _32768 = 0x0000000c,
    _65536 = 0x0000000d,
    _131072 = 0x0000000e,
    _262144 = 0x0000000f,
    _524288 = 0x00000010,
    _1048576 = 0x00000011,
    _2097152 = 0x00000012,
    _4194304 = 0x00000013,
    LatezAlways = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetOpportunisticEarlyZHysteresis {
    pub accumulated_prim_area_threshold: SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold,
}

impl Mthd for SetOpportunisticEarlyZHysteresis {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.accumulated_prim_area_threshold as u32) < (1 << 5));
        val |= (self.accumulated_prim_area_threshold as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterPipeSyncControl {
    pub prim_area_threshold: u32,
    pub enable: bool,
}

impl Mthd for SetRasterPipeSyncControl {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.prim_area_threshold < (1 << 22));
        val |= self.prim_area_threshold << 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAliasedLineWidthEnable {
    pub v: bool,
}

impl Mthd for SetAliasedLineWidthEnable {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiMandatedEarlyZ {
    pub enable: bool,
}

impl Mthd for SetApiMandatedEarlyZ {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGsDmFifo {
    pub size_raster_on: u32,
    pub size_raster_off: u32,
    pub spill_enabled: bool,
}

impl Mthd for SetGsDmFifo {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size_raster_on < (1 << 13));
        val |= self.size_raster_on << 0;
            
        assert!(self.size_raster_off < (1 << 13));
        val |= self.size_raster_off << 16;
            
        assert!((self.spill_enabled as u32) < (1 << 1));
        val |= (self.spill_enabled as u32) << 31;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopPrefetchReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopPrefetchReadRequests {
    pub policy: SetL2CacheControlForRopPrefetchReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopPrefetchReadRequests {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;
            
        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;
            
        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex3F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex3F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0220+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex4F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex4F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0230+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabNormal3F {
    pub v: u32,
}

impl ArrayMthd for SetVabNormal3F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0240+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor3F {
    pub v: u32,
}

impl ArrayMthd for SetVabColor3F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0250+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor4F {
    pub v: u32,
}

impl ArrayMthd for SetVabColor4F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0260+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabColor4Ub {
    pub v: u32,
}

impl ArrayMthd for SetVabColor4Ub {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0270+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord1F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord1F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0280+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord2F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord2F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0290+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord3F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord3F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x02a0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabTexCoord4F {
    pub v: u32,
}

impl ArrayMthd for SetVabTexCoord4F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x02b0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTaskCircularBufferThrottle {
    pub task_count: u32,
}

impl Mthd for SetTaskCircularBufferThrottle {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.task_count < (1 << 22));
        val |= self.task_count << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimCircularBufferThrottle {
    pub prim_area: u32,
}

impl Mthd for SetPrimCircularBufferThrottle {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.prim_area < (1 << 22));
        val |= self.prim_area << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushAndInvalidateRopMiniCache {
    pub v: u32,
}

impl Mthd for FlushAndInvalidateRopMiniCache {
    const ADDR: u16 = 0x02d4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSurfaceClipIdBlockSizeDepth {
    OneGob = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdBlockSize {
    pub width: SetSurfaceClipIdBlockSizeWidth,
    pub height: SetSurfaceClipIdBlockSizeHeight,
    pub depth: SetSurfaceClipIdBlockSizeDepth,
}

impl Mthd for SetSurfaceClipIdBlockSize {
    const ADDR: u16 = 0x02d8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetAlphaCircularBufferSize {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.cache_lines_per_sm < (1 << 10));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRopBypass {
    pub enable: bool,
    pub no_stall: bool,
    pub cull_everything: bool,
    pub threshold: u32,
}

impl Mthd for SetZcullRopBypass {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!((self.no_stall as u32) < (1 << 1));
        val |= (self.no_stall as u32) << 4;
            
        assert!((self.cull_everything as u32) < (1 << 1));
        val |= (self.cull_everything as u32) << 8;
            
        assert!(self.threshold < (1 << 4));
        val |= self.threshold << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregion {
    pub enable: bool,
    pub normalized_aliquots: u32,
}

impl Mthd for SetZcullSubregion {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!(self.normalized_aliquots < (1 << 24));
        val |= self.normalized_aliquots << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRasterBoundingBoxMode {
    BoundingBox = 0x00000000,
    FullViewport = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterBoundingBox {
    pub mode: SetRasterBoundingBoxMode,
    pub pad: u32,
}

impl Mthd for SetRasterBoundingBox {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;
            
        assert!(self.pad < (1 << 8));
        val |= self.pad << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PeerSemaphoreRelease {
    pub v: u32,
}

impl Mthd for PeerSemaphoreRelease {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullSubregionAllocationFormat {
    Z16X16X24X4 = 0x00000000,
    Zs16X164X4 = 0x00000001,
    Z16X164X2 = 0x00000002,
    Z16X162X4 = 0x00000003,
    Z16X84X4 = 0x00000004,
    Z8X84X2 = 0x00000005,
    Z8X82X4 = 0x00000006,
    Z16X164X8 = 0x00000007,
    Z4X82X2 = 0x00000008,
    Zs16X84X2 = 0x00000009,
    Zs16X82X4 = 0x0000000a,
    Zs8X82X2 = 0x0000000b,
    Z4X81X1 = 0x0000000c,
    None = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionAllocation {
    pub subregion_id: u32,
    pub aliquots: u32,
    pub format: SetZcullSubregionAllocationFormat,
}

impl Mthd for SetZcullSubregionAllocation {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.subregion_id < (1 << 8));
        val |= self.subregion_id << 0;
            
        assert!(self.aliquots < (1 << 16));
        val |= self.aliquots << 8;
            
        assert!((self.format as u32) < (1 << 4));
        val |= (self.format as u32) << 24;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum AssignZcullSubregionsAlgorithm {
    Static = 0x00000000,
    Adaptive = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct AssignZcullSubregions {
    pub algorithm: AssignZcullSubregionsAlgorithm,
}

impl Mthd for AssignZcullSubregions {
    const ADDR: u16 = 0x02fc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.algorithm as u32) < (1 << 2));
        val |= (self.algorithm as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsOutputSampleMaskUsage {
    pub enable: bool,
    pub qualify_by_anti_alias_enable: SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable,
}

impl Mthd for SetPsOutputSampleMaskUsage {
    const ADDR: u16 = 0x0300;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!((self.qualify_by_anti_alias_enable as u32) < (1 << 1));
        val |= (self.qualify_by_anti_alias_enable as u32) << 1;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawZeroIndex {
    pub count: u32,
}

impl Mthd for DrawZeroIndex {
    const ADDR: u16 = 0x0304;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.count;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL1ConfigurationDirectlyAddressableMemory {
    Size16Kb = 0x00000001,
    Size48Kb = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL1Configuration {
    pub directly_addressable_memory: SetL1ConfigurationDirectlyAddressableMemory,
}

impl Mthd for SetL1Configuration {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.directly_addressable_memory as u32) < (1 << 3));
        val |= (self.directly_addressable_memory as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableControl {
    pub conditional_load_constant_buffer: bool,
}

impl Mthd for SetRenderEnableControl {
    const ADDR: u16 = 0x030c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.conditional_load_constant_buffer as u32) < (1 << 1));
        val |= (self.conditional_load_constant_buffer as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpaVersion {
    pub minor: u32,
    pub major: u32,
}

impl Mthd for SetSpaVersion {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.minor < (1 << 8));
        val |= self.minor << 0;
            
        assert!(self.major < (1 << 8));
        val |= self.major << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIeeeCleanUpdate {
    pub enable: bool,
}

impl Mthd for SetIeeeCleanUpdate {
    const ADDR: u16 = 0x0314;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridLineLocationsPerPixel {
    _2X2 = 0x00000001,
    _4X4 = 0x00000002,
    _8X8 = 0x00000003,
    _16X16 = 0x00000004,
    _32X32 = 0x00000005,
    _64X64 = 0x00000006,
    _128X128 = 0x00000007,
    _256X256 = 0x00000008,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridLineRoundingMode {
    Rtne = 0x00000000,
    Tesla = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSnapGridLine {
    pub locations_per_pixel: SetSnapGridLineLocationsPerPixel,
    pub rounding_mode: SetSnapGridLineRoundingMode,
}

impl Mthd for SetSnapGridLine {
    const ADDR: u16 = 0x0318;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.locations_per_pixel as u32) < (1 << 4));
        val |= (self.locations_per_pixel as u32) << 0;
            
        assert!((self.rounding_mode as u32) < (1 << 1));
        val |= (self.rounding_mode as u32) << 8;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridNonLineLocationsPerPixel {
    _2X2 = 0x00000001,
    _4X4 = 0x00000002,
    _8X8 = 0x00000003,
    _16X16 = 0x00000004,
    _32X32 = 0x00000005,
    _64X64 = 0x00000006,
    _128X128 = 0x00000007,
    _256X256 = 0x00000008,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSnapGridNonLineRoundingMode {
    Rtne = 0x00000000,
    Tesla = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSnapGridNonLine {
    pub locations_per_pixel: SetSnapGridNonLineLocationsPerPixel,
    pub rounding_mode: SetSnapGridNonLineRoundingMode,
}

impl Mthd for SetSnapGridNonLine {
    const ADDR: u16 = 0x031c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.locations_per_pixel as u32) < (1 << 4));
        val |= (self.locations_per_pixel as u32) << 0;
            
        assert!((self.rounding_mode as u32) < (1 << 1));
        val |= (self.rounding_mode as u32) << 8;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersDomainType {
    Isoline = 0x00000000,
    Triangle = 0x00000001,
    Quad = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersSpacing {
    Integer = 0x00000000,
    FractionalOdd = 0x00000001,
    FractionalEven = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTessellationParametersOutputPrimitives {
    Points = 0x00000000,
    Lines = 0x00000001,
    TrianglesCw = 0x00000002,
    TrianglesCcw = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationParameters {
    pub domain_type: SetTessellationParametersDomainType,
    pub spacing: SetTessellationParametersSpacing,
    pub output_primitives: SetTessellationParametersOutputPrimitives,
}

impl Mthd for SetTessellationParameters {
    const ADDR: u16 = 0x0320;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.domain_type as u32) < (1 << 2));
        val |= (self.domain_type as u32) << 0;
            
        assert!((self.spacing as u32) < (1 << 2));
        val |= (self.spacing as u32) << 4;
            
        assert!((self.output_primitives as u32) < (1 << 2));
        val |= (self.output_primitives as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodU0OrDensity {
    pub v: u32,
}

impl Mthd for SetTessellationLodU0OrDensity {
    const ADDR: u16 = 0x0324;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodV0OrDetail {
    pub v: u32,
}

impl Mthd for SetTessellationLodV0OrDetail {
    const ADDR: u16 = 0x0328;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodU1OrW0 {
    pub v: u32,
}

impl Mthd for SetTessellationLodU1OrW0 {
    const ADDR: u16 = 0x032c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationLodV1 {
    pub v: u32,
}

impl Mthd for SetTessellationLodV1 {
    const ADDR: u16 = 0x0330;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTgLodInteriorU {
    pub v: u32,
}

impl Mthd for SetTgLodInteriorU {
    const ADDR: u16 = 0x0334;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTgLodInteriorV {
    pub v: u32,
}

impl Mthd for SetTgLodInteriorV {
    const ADDR: u16 = 0x0338;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg07 {
    pub v: u32,
}

impl Mthd for ReservedTg07 {
    const ADDR: u16 = 0x033c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg08 {
    pub v: u32,
}

impl Mthd for ReservedTg08 {
    const ADDR: u16 = 0x0340;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg09 {
    pub v: u32,
}

impl Mthd for ReservedTg09 {
    const ADDR: u16 = 0x0344;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg10 {
    pub v: u32,
}

impl Mthd for ReservedTg10 {
    const ADDR: u16 = 0x0348;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg11 {
    pub v: u32,
}

impl Mthd for ReservedTg11 {
    const ADDR: u16 = 0x034c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg12 {
    pub v: u32,
}

impl Mthd for ReservedTg12 {
    const ADDR: u16 = 0x0350;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg13 {
    pub v: u32,
}

impl Mthd for ReservedTg13 {
    const ADDR: u16 = 0x0354;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg14 {
    pub v: u32,
}

impl Mthd for ReservedTg14 {
    const ADDR: u16 = 0x0358;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReservedTg15 {
    pub v: u32,
}

impl Mthd for ReservedTg15 {
    const ADDR: u16 = 0x035c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobA {
    pub fraction_of_spm_register_file_per_subtile: u32,
    pub fraction_of_spm_pixel_output_buffer_per_subtile: u32,
    pub fraction_of_spm_triangle_ram_per_subtile: u32,
    pub fraction_of_max_quads_per_subtile: u32,
}

impl Mthd for SetSubtilingPerfKnobA {
    const ADDR: u16 = 0x0360;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.fraction_of_spm_register_file_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_register_file_per_subtile << 0;
            
        assert!(self.fraction_of_spm_pixel_output_buffer_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_pixel_output_buffer_per_subtile << 8;
            
        assert!(self.fraction_of_spm_triangle_ram_per_subtile < (1 << 8));
        val |= self.fraction_of_spm_triangle_ram_per_subtile << 16;
            
        assert!(self.fraction_of_max_quads_per_subtile < (1 << 8));
        val |= self.fraction_of_max_quads_per_subtile << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobB {
    pub fraction_of_max_primitives_per_subtile: u32,
}

impl Mthd for SetSubtilingPerfKnobB {
    const ADDR: u16 = 0x0364;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.fraction_of_max_primitives_per_subtile < (1 << 8));
        val |= self.fraction_of_max_primitives_per_subtile << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSubtilingPerfKnobC {
    pub reserved: u32,
}

impl Mthd for SetSubtilingPerfKnobC {
    const ADDR: u16 = 0x0368;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.reserved < (1 << 1));
        val |= self.reserved << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionToReport {
    pub enable: bool,
    pub subregion_id: u32,
}

impl Mthd for SetZcullSubregionToReport {
    const ADDR: u16 = 0x036c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!(self.subregion_id < (1 << 8));
        val |= self.subregion_id << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullSubregionReportTypeType {
    DepthTest = 0x00000000,
    DepthTestNoAccept = 0x00000001,
    DepthTestLateZ = 0x00000002,
    StencilTest = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionReportType {
    pub enable: bool,
    pub type_: SetZcullSubregionReportTypeType,
}

impl Mthd for SetZcullSubregionReportType {
    const ADDR: u16 = 0x0370;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!((self.type_ as u32) < (1 << 3));
        val |= (self.type_ as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBalancedPrimitiveWorkload {
    pub in_unpartitioned_mode: bool,
    pub in_timesliced_mode: bool,
}

impl Mthd for SetBalancedPrimitiveWorkload {
    const ADDR: u16 = 0x0374;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.in_unpartitioned_mode as u32) < (1 << 1));
        val |= (self.in_unpartitioned_mode as u32) << 0;
            
        assert!((self.in_timesliced_mode as u32) < (1 << 1));
        val |= (self.in_timesliced_mode as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxPatchesPerBatch {
    pub v: u32,
}

impl Mthd for SetMaxPatchesPerBatch {
    const ADDR: u16 = 0x0378;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 6));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterEnable {
    pub v: bool,
}

impl Mthd for SetRasterEnable {
    const ADDR: u16 = 0x037c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferEnable {
    pub v: bool,
}

impl ArrayMthd for SetStreamOutBufferEnable {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0380+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferAddressA {
    pub upper: u32,
}

impl ArrayMthd for SetStreamOutBufferAddressA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0384+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferAddressB {
    pub lower: u32,
}

impl ArrayMthd for SetStreamOutBufferAddressB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0388+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferSize {
    pub bytes: u32,
}

impl ArrayMthd for SetStreamOutBufferSize {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x038c+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.bytes;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutBufferLoadWritePointer {
    pub start_offset: u32,
}

impl ArrayMthd for SetStreamOutBufferLoadWritePointer {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0390+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.start_offset;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabDataTypeless {
    pub v: u32,
}

impl ArrayMthd for SetVabDataTypeless {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlStream {
    pub select: u32,
}

impl ArrayMthd for SetStreamOutControlStream {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0700+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.select < (1 << 2));
        val |= self.select << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlComponentCount {
    pub max: u32,
}

impl ArrayMthd for SetStreamOutControlComponentCount {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0704+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.max < (1 << 8));
        val |= self.max << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutControlStride {
    pub bytes: u32,
}

impl ArrayMthd for SetStreamOutControlStride {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0708+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.bytes;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRasterInput {
    pub stream_select: u32,
}

impl Mthd for SetRasterInput {
    const ADDR: u16 = 0x0740;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.stream_select < (1 << 2));
        val |= self.stream_select << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStreamOutput {
    pub enable: bool,
}

impl Mthd for SetStreamOutput {
    const ADDR: u16 = 0x0744;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartTopologyChange {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestartTopologyChange {
    const ADDR: u16 = 0x0748;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaFraction {
    pub v: u32,
}

impl Mthd for SetAlphaFraction {
    const ADDR: u16 = 0x074c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetHybridAntiAliasControlCentroid {
    PerFragment = 0x00000000,
    PerPass = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetHybridAntiAliasControl {
    pub passes: u32,
    pub centroid: SetHybridAntiAliasControlCentroid,
}

impl Mthd for SetHybridAntiAliasControl {
    const ADDR: u16 = 0x0754;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.passes < (1 << 4));
        val |= self.passes << 0;
            
        assert!((self.centroid as u32) < (1 << 1));
        val |= (self.centroid as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxTiWarpsPerBatch {
    pub v: u32,
}

impl Mthd for SetMaxTiWarpsPerBatch {
    const ADDR: u16 = 0x075c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 6));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindow {
    const ADDR: u16 = 0x077c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.base_address;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryB {
    pub address_lower: u32,
}

impl Mthd for SetShaderLocalMemoryB {
    const ADDR: u16 = 0x0794;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryC {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryC {
    const ADDR: u16 = 0x0798;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size_upper < (1 << 6));
        val |= self.size_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryD {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryD {
    const ADDR: u16 = 0x079c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.size_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryE {
    pub default_size_per_warp: u32,
}

impl Mthd for SetShaderLocalMemoryE {
    const ADDR: u16 = 0x07a0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.default_size_per_warp < (1 << 26));
        val |= self.default_size_per_warp << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorZeroBandwidthClear {
    pub slot_disable_mask: u32,
}

impl Mthd for SetColorZeroBandwidthClear {
    const ADDR: u16 = 0x07a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.slot_disable_mask < (1 << 15));
        val |= self.slot_disable_mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZZeroBandwidthClear {
    pub slot_disable_mask: u32,
}

impl Mthd for SetZZeroBandwidthClear {
    const ADDR: u16 = 0x07a8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.slot_disable_mask < (1 << 15));
        val |= self.slot_disable_mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIsbeSaveRestoreProgram {
    pub offset: u32,
}

impl Mthd for SetIsbeSaveRestoreProgram {
    const ADDR: u16 = 0x07ac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabVertex2F {
    pub v: u32,
}

impl ArrayMthd for SetVabVertex2F {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x07b0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeA {
    pub width: u32,
}

impl Mthd for SetZcullRegionSizeA {
    const ADDR: u16 = 0x07c0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeB {
    pub height: u32,
}

impl Mthd for SetZcullRegionSizeB {
    const ADDR: u16 = 0x07c4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionSizeC {
    pub depth: u32,
}

impl Mthd for SetZcullRegionSizeC {
    const ADDR: u16 = 0x07c8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetC {
    pub depth: u32,
}

impl Mthd for SetZcullRegionPixelOffsetC {
    const ADDR: u16 = 0x07cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCullBeforeFetch {
    pub fetch_streams_once: bool,
}

impl Mthd for SetCullBeforeFetch {
    const ADDR: u16 = 0x07dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.fetch_streams_once as u32) < (1 << 1));
        val |= (self.fetch_streams_once as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionLocation {
    pub start_aliquot: u32,
    pub aliquot_count: u32,
}

impl Mthd for SetZcullRegionLocation {
    const ADDR: u16 = 0x07e0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.start_aliquot < (1 << 16));
        val |= self.start_aliquot << 0;
            
        assert!(self.aliquot_count < (1 << 16));
        val |= self.aliquot_count << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionAliquots {
    pub per_layer: u32,
}

impl Mthd for SetZcullRegionAliquots {
    const ADDR: u16 = 0x07e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.per_layer < (1 << 16));
        val |= self.per_layer << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageA {
    pub address_upper: u32,
}

impl Mthd for SetZcullStorageA {
    const ADDR: u16 = 0x07e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageB {
    pub address_lower: u32,
}

impl Mthd for SetZcullStorageB {
    const ADDR: u16 = 0x07ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageC {
    pub limit_address_upper: u32,
}

impl Mthd for SetZcullStorageC {
    const ADDR: u16 = 0x07f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.limit_address_upper < (1 << 8));
        val |= self.limit_address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStorageD {
    pub limit_address_lower: u32,
}

impl Mthd for SetZcullStorageD {
    const ADDR: u16 = 0x07f4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.limit_address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtReadOnly {
    pub enable_z: bool,
    pub enable_stencil: bool,
}

impl Mthd for SetZtReadOnly {
    const ADDR: u16 = 0x07f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable_z as u32) < (1 << 1));
        val |= (self.enable_z as u32) << 0;
            
        assert!((self.enable_stencil as u32) < (1 << 1));
        val |= (self.enable_stencil as u32) << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTextureInstructionOperandOrdering {
    FermiOrder = 0x00000000,
    KeplerOrder = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTextureInstructionOperand {
    pub ordering: SetTextureInstructionOperandOrdering,
}

impl Mthd for SetTextureInstructionOperand {
    const ADDR: u16 = 0x07fc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.ordering as u32) < (1 << 1));
        val |= (self.ordering as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetColorTargetA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0800+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetColorTargetB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0804+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetWidth {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetWidth {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0808+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 28));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetHeight {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetHeight {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x080c+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetFormatV {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
    B8G8R8A8 = 0x00000047,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetFormat {
    pub v: SetColorTargetFormatV,
}

impl ArrayMthd for SetColorTargetFormat {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0810+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryBlockDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetMemoryThirdDimensionControl {
    ThirdDimensionDefinesArraySize = 0x00000000,
    ThirdDimensionDefinesDepthSize = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetMemory {
    pub block_width: SetColorTargetMemoryBlockWidth,
    pub block_height: SetColorTargetMemoryBlockHeight,
    pub block_depth: SetColorTargetMemoryBlockDepth,
    pub layout: SetColorTargetMemoryLayout,
    pub third_dimension_control: SetColorTargetMemoryThirdDimensionControl,
}

impl ArrayMthd for SetColorTargetMemory {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0814+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.block_width as u32) < (1 << 4));
        val |= (self.block_width as u32) << 0;
            
        assert!((self.block_height as u32) < (1 << 4));
        val |= (self.block_height as u32) << 4;
            
        assert!((self.block_depth as u32) < (1 << 4));
        val |= (self.block_depth as u32) << 8;
            
        assert!((self.layout as u32) < (1 << 1));
        val |= (self.layout as u32) << 12;
            
        assert!((self.third_dimension_control as u32) < (1 << 1));
        val |= (self.third_dimension_control as u32) << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetThirdDimension {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetThirdDimension {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0818+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 28));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetArrayPitch {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetArrayPitch {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x081c+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetLayer {
    pub offset: u32,
}

impl ArrayMthd for SetColorTargetLayer {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0820+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset < (1 << 16));
        val |= self.offset << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetMark {
    pub ieee_clean: bool,
}

impl ArrayMthd for SetColorTargetMark {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0824+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.ieee_clean as u32) < (1 << 1));
        val |= (self.ieee_clean as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleX {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleX {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a00+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleY {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleY {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a04+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportScaleZ {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a08+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetX {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetX {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a0c+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetY {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetY {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a10+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportOffsetZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportOffsetZ {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0a14+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipHorizontal {
    pub x0: u32,
    pub width: u32,
}

impl ArrayMthd for SetViewportClipHorizontal {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0c00+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.x0 < (1 << 16));
        val |= self.x0 << 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipVertical {
    pub y0: u32,
    pub height: u32,
}

impl ArrayMthd for SetViewportClipVertical {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0c04+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.y0 < (1 << 16));
        val |= self.y0 << 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipMinZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportClipMinZ {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0c08+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipMaxZ {
    pub v: f32,
}

impl ArrayMthd for SetViewportClipMaxZ {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0c0c+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl ArrayMthd for SetWindowClipHorizontal {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0d00+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;
            
        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl ArrayMthd for SetWindowClipVertical {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0d04+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;
            
        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdExtentX {
    pub minx: u32,
    pub width: u32,
}

impl ArrayMthd for SetClipIdExtentX {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0d40+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.minx < (1 << 16));
        val |= self.minx << 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdExtentY {
    pub miny: u32,
    pub height: u32,
}

impl ArrayMthd for SetClipIdExtentY {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0d44+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.miny < (1 << 16));
        val |= self.miny << 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxStreamOutputGsInstancesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxStreamOutputGsInstancesPerTask {
    const ADDR: u16 = 0x0d60;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 11));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetApiVisibleCallLimitV {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    NoCheck = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiVisibleCallLimit {
    pub v: SetApiVisibleCallLimitV,
}

impl Mthd for SetApiVisibleCallLimit {
    const ADDR: u16 = 0x0d64;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 4));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStatisticsCounter {
    pub da_vertices_generated_enable: bool,
    pub da_primitives_generated_enable: bool,
    pub vs_invocations_enable: bool,
    pub gs_invocations_enable: bool,
    pub gs_primitives_generated_enable: bool,
    pub streaming_primitives_succeeded_enable: bool,
    pub streaming_primitives_needed_enable: bool,
    pub clipper_invocations_enable: bool,
    pub clipper_primitives_generated_enable: bool,
    pub ps_invocations_enable: bool,
    pub ti_invocations_enable: bool,
    pub ts_invocations_enable: bool,
    pub ts_primitives_generated_enable: bool,
    pub total_streaming_primitives_needed_succeeded_enable: bool,
    pub vtg_primitives_out_enable: bool,
    pub alpha_beta_clocks_enable: bool,
}

impl Mthd for SetStatisticsCounter {
    const ADDR: u16 = 0x0d68;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.da_vertices_generated_enable as u32) < (1 << 1));
        val |= (self.da_vertices_generated_enable as u32) << 0;
            
        assert!((self.da_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.da_primitives_generated_enable as u32) << 1;
            
        assert!((self.vs_invocations_enable as u32) < (1 << 1));
        val |= (self.vs_invocations_enable as u32) << 2;
            
        assert!((self.gs_invocations_enable as u32) < (1 << 1));
        val |= (self.gs_invocations_enable as u32) << 3;
            
        assert!((self.gs_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.gs_primitives_generated_enable as u32) << 4;
            
        assert!((self.streaming_primitives_succeeded_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_succeeded_enable as u32) << 5;
            
        assert!((self.streaming_primitives_needed_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_needed_enable as u32) << 6;
            
        assert!((self.clipper_invocations_enable as u32) < (1 << 1));
        val |= (self.clipper_invocations_enable as u32) << 7;
            
        assert!((self.clipper_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.clipper_primitives_generated_enable as u32) << 8;
            
        assert!((self.ps_invocations_enable as u32) < (1 << 1));
        val |= (self.ps_invocations_enable as u32) << 9;
            
        assert!((self.ti_invocations_enable as u32) < (1 << 1));
        val |= (self.ti_invocations_enable as u32) << 11;
            
        assert!((self.ts_invocations_enable as u32) < (1 << 1));
        val |= (self.ts_invocations_enable as u32) << 12;
            
        assert!((self.ts_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.ts_primitives_generated_enable as u32) << 13;
            
        assert!((self.total_streaming_primitives_needed_succeeded_enable as u32) < (1 << 1));
        val |= (self.total_streaming_primitives_needed_succeeded_enable as u32) << 14;
            
        assert!((self.vtg_primitives_out_enable as u32) < (1 << 1));
        val |= (self.vtg_primitives_out_enable as u32) << 10;
            
        assert!((self.alpha_beta_clocks_enable as u32) < (1 << 1));
        val |= (self.alpha_beta_clocks_enable as u32) << 15;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearRectHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl Mthd for SetClearRectHorizontal {
    const ADDR: u16 = 0x0d6c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;
            
        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearRectVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl Mthd for SetClearRectVertical {
    const ADDR: u16 = 0x0d70;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;
            
        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexArrayStart {
    pub v: u32,
}

impl Mthd for SetVertexArrayStart {
    const ADDR: u16 = 0x0d74;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArray {
    pub count: u32,
}

impl Mthd for DrawVertexArray {
    const ADDR: u16 = 0x0d78;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.count;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportZClipRange {
    NegativeWToPositiveW = 0x00000000,
    ZeroToPositiveW = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportZClip {
    pub range: SetViewportZClipRange,
}

impl Mthd for SetViewportZClip {
    const ADDR: u16 = 0x0d7c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.range as u32) < (1 << 1));
        val |= (self.range as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorClearValue {
    pub v: u32,
}

impl ArrayMthd for SetColorClearValue {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0d80+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZClearValue {
    pub v: f32,
}

impl Mthd for SetZClearValue {
    const ADDR: u16 = 0x0d90;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderCacheControl {
    pub icache_prefetch_enable: bool,
}

impl Mthd for SetShaderCacheControl {
    const ADDR: u16 = 0x0d94;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.icache_prefetch_enable as u32) < (1 << 1));
        val |= (self.icache_prefetch_enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ForceTransitionToBeta {
    pub v: u32,
}

impl Mthd for ForceTransitionToBeta {
    const ADDR: u16 = 0x0d98;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsEnable {
    pub v: bool,
}

impl Mthd for SetReduceColorThresholdsEnable {
    const ADDR: u16 = 0x0d9c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilClearValue {
    pub v: u32,
}

impl Mthd for SetStencilClearValue {
    const ADDR: u16 = 0x0da0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x0da4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetFrontPolygonModeV {
    Point = 0x00001b00,
    Line = 0x00001b01,
    Fill = 0x00001b02,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFrontPolygonMode {
    pub v: SetFrontPolygonModeV,
}

impl Mthd for SetFrontPolygonMode {
    const ADDR: u16 = 0x0dac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackPolygonModeV {
    Point = 0x00001b00,
    Line = 0x00001b01,
    Fill = 0x00001b02,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackPolygonMode {
    pub v: SetBackPolygonModeV,
}

impl Mthd for SetBackPolygonMode {
    const ADDR: u16 = 0x0db0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolySmooth {
    pub enable: bool,
}

impl Mthd for SetPolySmooth {
    const ADDR: u16 = 0x0db4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtMark {
    pub ieee_clean: bool,
}

impl Mthd for SetZtMark {
    const ADDR: u16 = 0x0db8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.ieee_clean as u32) < (1 << 1));
        val |= (self.ieee_clean as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullDirFormatZdir {
    Less = 0x00000000,
    Greater = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullDirFormatZformat {
    Msb = 0x00000000,
    Fp = 0x00000001,
    Ztrick = 0x00000002,
    Zf321 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullDirFormat {
    pub zdir: SetZcullDirFormatZdir,
    pub zformat: SetZcullDirFormatZformat,
}

impl Mthd for SetZcullDirFormat {
    const ADDR: u16 = 0x0dbc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.zdir as u32) < (1 << 16));
        val |= (self.zdir as u32) << 0;
            
        assert!((self.zformat as u32) < (1 << 16));
        val |= (self.zformat as u32) << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetPoint {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetPoint {
    const ADDR: u16 = 0x0dc0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetLine {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetLine {
    const ADDR: u16 = 0x0dc4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolyOffsetFill {
    pub enable: bool,
}

impl Mthd for SetPolyOffsetFill {
    const ADDR: u16 = 0x0dc8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatch {
    pub size: u32,
}

impl Mthd for SetPatch {
    const ADDR: u16 = 0x0dcc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size < (1 << 8));
        val |= self.size << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullCriterionSfunc {
    Never = 0x00000000,
    Less = 0x00000001,
    Equal = 0x00000002,
    Lequal = 0x00000003,
    Greater = 0x00000004,
    Notequal = 0x00000005,
    Gequal = 0x00000006,
    Always = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullCriterion {
    pub sfunc: SetZcullCriterionSfunc,
    pub no_invalidate: bool,
    pub force_match: bool,
    pub sref: u32,
    pub smask: u32,
}

impl Mthd for SetZcullCriterion {
    const ADDR: u16 = 0x0dd8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.sfunc as u32) < (1 << 8));
        val |= (self.sfunc as u32) << 0;
            
        assert!((self.no_invalidate as u32) < (1 << 1));
        val |= (self.no_invalidate as u32) << 8;
            
        assert!((self.force_match as u32) < (1 << 1));
        val |= (self.force_match as u32) << 9;
            
        assert!(self.sref < (1 << 8));
        val |= self.sref << 16;
            
        assert!(self.smask < (1 << 8));
        val |= self.smask << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmTimeoutInterval {
    pub counter_bit: u32,
}

impl Mthd for SetSmTimeoutInterval {
    const ADDR: u16 = 0x0de4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.counter_bit < (1 << 6));
        val |= self.counter_bit << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartVertexArray {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestartVertexArray {
    const ADDR: u16 = 0x0de8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawInlineVertexVabUpdate {
    pub enable: bool,
}

impl Mthd for SetDrawInlineVertexVabUpdate {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOffsetX {
    pub v: u32,
}

impl Mthd for SetWindowOffsetX {
    const ADDR: u16 = 0x0df8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOffsetY {
    pub v: u32,
}

impl Mthd for SetWindowOffsetY {
    const ADDR: u16 = 0x0dfc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 18));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorEnable {
    pub v: bool,
}

impl ArrayMthd for SetScissorEnable {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0e00+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl ArrayMthd for SetScissorHorizontal {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0e04+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;
            
        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScissorVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl ArrayMthd for SetScissorVertical {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0e08+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;
            
        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabNormal3S {
    pub v: u32,
}

impl ArrayMthd for SetVabNormal3S {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x0f00+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFuncRef {
    pub v: u32,
}

impl Mthd for SetBackStencilFuncRef {
    const ADDR: u16 = 0x0f54;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilMask {
    pub v: u32,
}

impl Mthd for SetBackStencilMask {
    const ADDR: u16 = 0x0f58;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFuncMask {
    pub v: u32,
}

impl Mthd for SetBackStencilFuncMask {
    const ADDR: u16 = 0x0f5c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSubstituteA {
    pub address_upper: u32,
}

impl Mthd for SetVertexStreamSubstituteA {
    const ADDR: u16 = 0x0f84;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSubstituteB {
    pub address_lower: u32,
}

impl Mthd for SetVertexStreamSubstituteB {
    const ADDR: u16 = 0x0f88;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLineModePolygonClipGeneratedEdge {
    DrawLine = 0x00000000,
    DoNotDrawLine = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineModePolygonClip {
    pub generated_edge: SetLineModePolygonClipGeneratedEdge,
}

impl Mthd for SetLineModePolygonClip {
    const ADDR: u16 = 0x0f8c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.generated_edge as u32) < (1 << 1));
        val |= (self.generated_edge as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSingleCtWriteControl {
    pub enable: bool,
}

impl Mthd for SetSingleCtWriteControl {
    const ADDR: u16 = 0x0f90;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVtgWarpWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetVtgWarpWatermarks {
    const ADDR: u16 = 0x0f98;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.low < (1 << 16));
        val |= self.low << 0;
            
        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsMin {
    pub v: f32,
}

impl Mthd for SetDepthBoundsMin {
    const ADDR: u16 = 0x0f9c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsMax {
    pub v: f32,
}

impl Mthd for SetDepthBoundsMax {
    const ADDR: u16 = 0x0fa0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtMrtEnable {
    pub v: bool,
}

impl Mthd for SetCtMrtEnable {
    const ADDR: u16 = 0x0fac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetNonmultisampledZV {
    PerSample = 0x00000000,
    AtPixelCenter = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNonmultisampledZ {
    pub v: SetNonmultisampledZV,
}

impl Mthd for SetNonmultisampledZ {
    const ADDR: u16 = 0x0fb0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX0Y0 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX0Y0 {
    const ADDR: u16 = 0x0fbc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX1Y0 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX1Y0 {
    const ADDR: u16 = 0x0fc0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX0Y1 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX0Y1 {
    const ADDR: u16 = 0x0fc4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMaskX1Y1 {
    pub v: u32,
}

impl Mthd for SetSampleMaskX1Y1 {
    const ADDR: u16 = 0x0fc8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdMemoryA {
    pub offset_upper: u32,
}

impl Mthd for SetSurfaceClipIdMemoryA {
    const ADDR: u16 = 0x0fcc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdMemoryB {
    pub offset_lower: u32,
}

impl Mthd for SetSurfaceClipIdMemoryB {
    const ADDR: u16 = 0x0fd0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendOptControl {
    pub allow_float_pixel_kills: bool,
}

impl Mthd for SetBlendOptControl {
    const ADDR: u16 = 0x0fdc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.allow_float_pixel_kills as u32) < (1 << 1));
        val |= (self.allow_float_pixel_kills as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtA {
    pub offset_upper: u32,
}

impl Mthd for SetZtA {
    const ADDR: u16 = 0x0fe0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtB {
    pub offset_lower: u32,
}

impl Mthd for SetZtB {
    const ADDR: u16 = 0x0fe4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtFormatV {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtFormat {
    pub v: SetZtFormatV,
}

impl Mthd for SetZtFormat {
    const ADDR: u16 = 0x0fe8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 5));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtBlockSizeDepth {
    OneGob = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtBlockSize {
    pub width: SetZtBlockSizeWidth,
    pub height: SetZtBlockSizeHeight,
    pub depth: SetZtBlockSizeDepth,
}

impl Mthd for SetZtBlockSize {
    const ADDR: u16 = 0x0fec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtArrayPitch {
    pub v: u32,
}

impl Mthd for SetZtArrayPitch {
    const ADDR: u16 = 0x0ff0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipHorizontal {
    pub x: u32,
    pub width: u32,
}

impl Mthd for SetSurfaceClipHorizontal {
    const ADDR: u16 = 0x0ff4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.x < (1 << 16));
        val |= self.x << 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipVertical {
    pub y: u32,
    pub height: u32,
}

impl Mthd for SetSurfaceClipVertical {
    const ADDR: u16 = 0x0ff8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.y < (1 << 16));
        val |= self.y << 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForVafRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForVafRequests {
    pub system_memory_volatile: bool,
    pub policy: SetL2CacheControlForVafRequestsPolicy,
}

impl Mthd for SetL2CacheControlForVafRequests {
    const ADDR: u16 = 0x1000;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.system_memory_volatile as u32) < (1 << 1));
        val |= (self.system_memory_volatile as u32) << 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTessellationCutHeight {
    pub v: u32,
}

impl Mthd for SetTessellationCutHeight {
    const ADDR: u16 = 0x1008;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 5));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxGsInstancesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxGsInstancesPerTask {
    const ADDR: u16 = 0x100c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 11));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxGsOutputVerticesPerTask {
    pub v: u32,
}

impl Mthd for SetMaxGsOutputVerticesPerTask {
    const ADDR: u16 = 0x1010;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGsOutputCbStorageMultiplier {
    pub v: u32,
}

impl Mthd for SetGsOutputCbStorageMultiplier {
    const ADDR: u16 = 0x1018;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBetaCbStorageConstraint {
    pub enable: bool,
}

impl Mthd for SetBetaCbStorageConstraint {
    const ADDR: u16 = 0x101c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTiOutputCbStorageMultiplier {
    pub v: u32,
}

impl Mthd for SetTiOutputCbStorageMultiplier {
    const ADDR: u16 = 0x1020;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCbStorageConstraint {
    pub enable: bool,
}

impl Mthd for SetAlphaCbStorageConstraint {
    const ADDR: u16 = 0x1024;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetSpareNoop00 {
    const ADDR: u16 = 0x1040;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x1044;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x1048;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x104c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x1050;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop05 {
    pub v: u32,
}

impl Mthd for SetSpareNoop05 {
    const ADDR: u16 = 0x1054;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x1058;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x105c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x1060;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x1064;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x1068;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x106c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x1070;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x1074;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x1078;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x107c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm8 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm8 {
    const ADDR: u16 = 0x10cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm10 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm10 {
    const ADDR: u16 = 0x10e0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsUnorm16 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsUnorm16 {
    const ADDR: u16 = 0x10e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsFp11 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsFp11 {
    const ADDR: u16 = 0x10e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 6));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 6));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsFp16 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsFp16 {
    const ADDR: u16 = 0x10ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReduceColorThresholdsSrgb8 {
    pub all_covered_all_hit_once: u32,
    pub all_covered: u32,
}

impl Mthd for SetReduceColorThresholdsSrgb8 {
    const ADDR: u16 = 0x10f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.all_covered_all_hit_once < (1 << 8));
        val |= self.all_covered_all_hit_once << 0;
            
        assert!(self.all_covered < (1 << 8));
        val |= self.all_covered << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct UnbindAll {
    pub constant_buffers: bool,
}

impl Mthd for UnbindAll {
    const ADDR: u16 = 0x10f4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.constant_buffers as u32) < (1 << 1));
        val |= (self.constant_buffers as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClearSurfaceControl {
    pub respect_stencil_mask: bool,
    pub use_clear_rect: bool,
    pub use_scissor0: bool,
    pub use_viewport_clip0: bool,
}

impl Mthd for SetClearSurfaceControl {
    const ADDR: u16 = 0x10f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.respect_stencil_mask as u32) < (1 << 1));
        val |= (self.respect_stencil_mask as u32) << 0;
            
        assert!((self.use_clear_rect as u32) < (1 << 1));
        val |= (self.use_clear_rect as u32) << 4;
            
        assert!((self.use_scissor0 as u32) < (1 << 1));
        val |= (self.use_scissor0 as u32) << 8;
            
        assert!((self.use_viewport_clip0 as u32) < (1 << 1));
        val |= (self.use_viewport_clip0 as u32) << 12;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopNoninterlockedReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopNoninterlockedReadRequests {
    pub policy: SetL2CacheControlForRopNoninterlockedReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopNoninterlockedReadRequests {
    const ADDR: u16 = 0x10fc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperationDataHi {
    pub v: u32,
}

impl Mthd for NoOperationDataHi {
    const ADDR: u16 = 0x110c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBiasControl {
    pub depth_format_dependent: bool,
}

impl Mthd for SetDepthBiasControl {
    const ADDR: u16 = 0x1110;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.depth_format_dependent as u32) < (1 << 1));
        val |= (self.depth_format_dependent as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerEnd {
    pub v: u32,
}

impl Mthd for PmTriggerEnd {
    const ADDR: u16 = 0x1114;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexIdBase {
    pub v: u32,
}

impl Mthd for SetVertexIdBase {
    const ADDR: u16 = 0x1118;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutputAttributeSkipMaskA {
    pub attribute0_comp0: bool,
    pub attribute0_comp1: bool,
    pub attribute0_comp2: bool,
    pub attribute0_comp3: bool,
    pub attribute1_comp0: bool,
    pub attribute1_comp1: bool,
    pub attribute1_comp2: bool,
    pub attribute1_comp3: bool,
    pub attribute2_comp0: bool,
    pub attribute2_comp1: bool,
    pub attribute2_comp2: bool,
    pub attribute2_comp3: bool,
    pub attribute3_comp0: bool,
    pub attribute3_comp1: bool,
    pub attribute3_comp2: bool,
    pub attribute3_comp3: bool,
    pub attribute4_comp0: bool,
    pub attribute4_comp1: bool,
    pub attribute4_comp2: bool,
    pub attribute4_comp3: bool,
    pub attribute5_comp0: bool,
    pub attribute5_comp1: bool,
    pub attribute5_comp2: bool,
    pub attribute5_comp3: bool,
    pub attribute6_comp0: bool,
    pub attribute6_comp1: bool,
    pub attribute6_comp2: bool,
    pub attribute6_comp3: bool,
    pub attribute7_comp0: bool,
    pub attribute7_comp1: bool,
    pub attribute7_comp2: bool,
    pub attribute7_comp3: bool,
}

impl ArrayMthd for SetDaOutputAttributeSkipMaskA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1120+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.attribute0_comp0 as u32) < (1 << 1));
        val |= (self.attribute0_comp0 as u32) << 0;
            
        assert!((self.attribute0_comp1 as u32) < (1 << 1));
        val |= (self.attribute0_comp1 as u32) << 1;
            
        assert!((self.attribute0_comp2 as u32) < (1 << 1));
        val |= (self.attribute0_comp2 as u32) << 2;
            
        assert!((self.attribute0_comp3 as u32) < (1 << 1));
        val |= (self.attribute0_comp3 as u32) << 3;
            
        assert!((self.attribute1_comp0 as u32) < (1 << 1));
        val |= (self.attribute1_comp0 as u32) << 4;
            
        assert!((self.attribute1_comp1 as u32) < (1 << 1));
        val |= (self.attribute1_comp1 as u32) << 5;
            
        assert!((self.attribute1_comp2 as u32) < (1 << 1));
        val |= (self.attribute1_comp2 as u32) << 6;
            
        assert!((self.attribute1_comp3 as u32) < (1 << 1));
        val |= (self.attribute1_comp3 as u32) << 7;
            
        assert!((self.attribute2_comp0 as u32) < (1 << 1));
        val |= (self.attribute2_comp0 as u32) << 8;
            
        assert!((self.attribute2_comp1 as u32) < (1 << 1));
        val |= (self.attribute2_comp1 as u32) << 9;
            
        assert!((self.attribute2_comp2 as u32) < (1 << 1));
        val |= (self.attribute2_comp2 as u32) << 10;
            
        assert!((self.attribute2_comp3 as u32) < (1 << 1));
        val |= (self.attribute2_comp3 as u32) << 11;
            
        assert!((self.attribute3_comp0 as u32) < (1 << 1));
        val |= (self.attribute3_comp0 as u32) << 12;
            
        assert!((self.attribute3_comp1 as u32) < (1 << 1));
        val |= (self.attribute3_comp1 as u32) << 13;
            
        assert!((self.attribute3_comp2 as u32) < (1 << 1));
        val |= (self.attribute3_comp2 as u32) << 14;
            
        assert!((self.attribute3_comp3 as u32) < (1 << 1));
        val |= (self.attribute3_comp3 as u32) << 15;
            
        assert!((self.attribute4_comp0 as u32) < (1 << 1));
        val |= (self.attribute4_comp0 as u32) << 16;
            
        assert!((self.attribute4_comp1 as u32) < (1 << 1));
        val |= (self.attribute4_comp1 as u32) << 17;
            
        assert!((self.attribute4_comp2 as u32) < (1 << 1));
        val |= (self.attribute4_comp2 as u32) << 18;
            
        assert!((self.attribute4_comp3 as u32) < (1 << 1));
        val |= (self.attribute4_comp3 as u32) << 19;
            
        assert!((self.attribute5_comp0 as u32) < (1 << 1));
        val |= (self.attribute5_comp0 as u32) << 20;
            
        assert!((self.attribute5_comp1 as u32) < (1 << 1));
        val |= (self.attribute5_comp1 as u32) << 21;
            
        assert!((self.attribute5_comp2 as u32) < (1 << 1));
        val |= (self.attribute5_comp2 as u32) << 22;
            
        assert!((self.attribute5_comp3 as u32) < (1 << 1));
        val |= (self.attribute5_comp3 as u32) << 23;
            
        assert!((self.attribute6_comp0 as u32) < (1 << 1));
        val |= (self.attribute6_comp0 as u32) << 24;
            
        assert!((self.attribute6_comp1 as u32) < (1 << 1));
        val |= (self.attribute6_comp1 as u32) << 25;
            
        assert!((self.attribute6_comp2 as u32) < (1 << 1));
        val |= (self.attribute6_comp2 as u32) << 26;
            
        assert!((self.attribute6_comp3 as u32) < (1 << 1));
        val |= (self.attribute6_comp3 as u32) << 27;
            
        assert!((self.attribute7_comp0 as u32) < (1 << 1));
        val |= (self.attribute7_comp0 as u32) << 28;
            
        assert!((self.attribute7_comp1 as u32) < (1 << 1));
        val |= (self.attribute7_comp1 as u32) << 29;
            
        assert!((self.attribute7_comp2 as u32) < (1 << 1));
        val |= (self.attribute7_comp2 as u32) << 30;
            
        assert!((self.attribute7_comp3 as u32) < (1 << 1));
        val |= (self.attribute7_comp3 as u32) << 31;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutputAttributeSkipMaskB {
    pub attribute0_comp0: bool,
    pub attribute0_comp1: bool,
    pub attribute0_comp2: bool,
    pub attribute0_comp3: bool,
    pub attribute1_comp0: bool,
    pub attribute1_comp1: bool,
    pub attribute1_comp2: bool,
    pub attribute1_comp3: bool,
    pub attribute2_comp0: bool,
    pub attribute2_comp1: bool,
    pub attribute2_comp2: bool,
    pub attribute2_comp3: bool,
    pub attribute3_comp0: bool,
    pub attribute3_comp1: bool,
    pub attribute3_comp2: bool,
    pub attribute3_comp3: bool,
    pub attribute4_comp0: bool,
    pub attribute4_comp1: bool,
    pub attribute4_comp2: bool,
    pub attribute4_comp3: bool,
    pub attribute5_comp0: bool,
    pub attribute5_comp1: bool,
    pub attribute5_comp2: bool,
    pub attribute5_comp3: bool,
    pub attribute6_comp0: bool,
    pub attribute6_comp1: bool,
    pub attribute6_comp2: bool,
    pub attribute6_comp3: bool,
    pub attribute7_comp0: bool,
    pub attribute7_comp1: bool,
    pub attribute7_comp2: bool,
    pub attribute7_comp3: bool,
}

impl ArrayMthd for SetDaOutputAttributeSkipMaskB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1128+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.attribute0_comp0 as u32) < (1 << 1));
        val |= (self.attribute0_comp0 as u32) << 0;
            
        assert!((self.attribute0_comp1 as u32) < (1 << 1));
        val |= (self.attribute0_comp1 as u32) << 1;
            
        assert!((self.attribute0_comp2 as u32) < (1 << 1));
        val |= (self.attribute0_comp2 as u32) << 2;
            
        assert!((self.attribute0_comp3 as u32) < (1 << 1));
        val |= (self.attribute0_comp3 as u32) << 3;
            
        assert!((self.attribute1_comp0 as u32) < (1 << 1));
        val |= (self.attribute1_comp0 as u32) << 4;
            
        assert!((self.attribute1_comp1 as u32) < (1 << 1));
        val |= (self.attribute1_comp1 as u32) << 5;
            
        assert!((self.attribute1_comp2 as u32) < (1 << 1));
        val |= (self.attribute1_comp2 as u32) << 6;
            
        assert!((self.attribute1_comp3 as u32) < (1 << 1));
        val |= (self.attribute1_comp3 as u32) << 7;
            
        assert!((self.attribute2_comp0 as u32) < (1 << 1));
        val |= (self.attribute2_comp0 as u32) << 8;
            
        assert!((self.attribute2_comp1 as u32) < (1 << 1));
        val |= (self.attribute2_comp1 as u32) << 9;
            
        assert!((self.attribute2_comp2 as u32) < (1 << 1));
        val |= (self.attribute2_comp2 as u32) << 10;
            
        assert!((self.attribute2_comp3 as u32) < (1 << 1));
        val |= (self.attribute2_comp3 as u32) << 11;
            
        assert!((self.attribute3_comp0 as u32) < (1 << 1));
        val |= (self.attribute3_comp0 as u32) << 12;
            
        assert!((self.attribute3_comp1 as u32) < (1 << 1));
        val |= (self.attribute3_comp1 as u32) << 13;
            
        assert!((self.attribute3_comp2 as u32) < (1 << 1));
        val |= (self.attribute3_comp2 as u32) << 14;
            
        assert!((self.attribute3_comp3 as u32) < (1 << 1));
        val |= (self.attribute3_comp3 as u32) << 15;
            
        assert!((self.attribute4_comp0 as u32) < (1 << 1));
        val |= (self.attribute4_comp0 as u32) << 16;
            
        assert!((self.attribute4_comp1 as u32) < (1 << 1));
        val |= (self.attribute4_comp1 as u32) << 17;
            
        assert!((self.attribute4_comp2 as u32) < (1 << 1));
        val |= (self.attribute4_comp2 as u32) << 18;
            
        assert!((self.attribute4_comp3 as u32) < (1 << 1));
        val |= (self.attribute4_comp3 as u32) << 19;
            
        assert!((self.attribute5_comp0 as u32) < (1 << 1));
        val |= (self.attribute5_comp0 as u32) << 20;
            
        assert!((self.attribute5_comp1 as u32) < (1 << 1));
        val |= (self.attribute5_comp1 as u32) << 21;
            
        assert!((self.attribute5_comp2 as u32) < (1 << 1));
        val |= (self.attribute5_comp2 as u32) << 22;
            
        assert!((self.attribute5_comp3 as u32) < (1 << 1));
        val |= (self.attribute5_comp3 as u32) << 23;
            
        assert!((self.attribute6_comp0 as u32) < (1 << 1));
        val |= (self.attribute6_comp0 as u32) << 24;
            
        assert!((self.attribute6_comp1 as u32) < (1 << 1));
        val |= (self.attribute6_comp1 as u32) << 25;
            
        assert!((self.attribute6_comp2 as u32) < (1 << 1));
        val |= (self.attribute6_comp2 as u32) << 26;
            
        assert!((self.attribute6_comp3 as u32) < (1 << 1));
        val |= (self.attribute6_comp3 as u32) << 27;
            
        assert!((self.attribute7_comp0 as u32) < (1 << 1));
        val |= (self.attribute7_comp0 as u32) << 28;
            
        assert!((self.attribute7_comp1 as u32) < (1 << 1));
        val |= (self.attribute7_comp1 as u32) << 29;
            
        assert!((self.attribute7_comp2 as u32) < (1 << 1));
        val |= (self.attribute7_comp2 as u32) << 30;
            
        assert!((self.attribute7_comp3 as u32) < (1 << 1));
        val |= (self.attribute7_comp3 as u32) << 31;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerFormatEnable {
    pub snorm8_unorm16_snorm16: bool,
}

impl Mthd for SetBlendPerFormatEnable {
    const ADDR: u16 = 0x1140;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.snorm8_unorm16_snorm16 as u32) < (1 << 1));
        val |= (self.snorm8_unorm16_snorm16 as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushPendingWrites {
    pub sm_does_global_store: u32,
}

impl Mthd for FlushPendingWrites {
    const ADDR: u16 = 0x1144;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.sm_does_global_store < (1 << 1));
        val |= self.sm_does_global_store << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabDataControlFormat {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabDataControl {
    pub vab_index: u32,
    pub component_count: u32,
    pub component_byte_width: u32,
    pub format: SetVabDataControlFormat,
}

impl Mthd for SetVabDataControl {
    const ADDR: u16 = 0x114c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.vab_index < (1 << 8));
        val |= self.vab_index << 0;
            
        assert!(self.component_count < (1 << 3));
        val |= self.component_count << 8;
            
        assert!(self.component_byte_width < (1 << 3));
        val |= self.component_byte_width << 12;
            
        assert!((self.format as u32) < (1 << 3));
        val |= (self.format as u32) << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabData {
    pub v: u32,
}

impl ArrayMthd for SetVabData {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1150+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeASource {
    Active = 0x00000000,
    Inactive = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeAComponentBitWidths {
    R32G32B32A32 = 0x00000001,
    R32G32B32 = 0x00000002,
    R16G16B16A16 = 0x00000003,
    R32G32 = 0x00000004,
    R16G16B16 = 0x00000005,
    A8B8G8R8 = 0x0000002f,
    R8G8B8A8 = 0x0000000a,
    X8B8G8R8 = 0x00000033,
    A2B10G10R10 = 0x00000030,
    B10G11R11 = 0x00000031,
    R16G16 = 0x0000000f,
    R32 = 0x00000012,
    R8G8B8 = 0x00000013,
    G8R8 = 0x00000032,
    R8G8 = 0x00000018,
    R16 = 0x0000001b,
    R8 = 0x0000001d,
    A8 = 0x00000034,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeANumericalType {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexAttributeA {
    pub stream: u32,
    pub source: SetVertexAttributeASource,
    pub offset: u32,
    pub component_bit_widths: SetVertexAttributeAComponentBitWidths,
    pub numerical_type: SetVertexAttributeANumericalType,
    pub swap_r_and_b: bool,
}

impl ArrayMthd for SetVertexAttributeA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1160+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.stream < (1 << 5));
        val |= self.stream << 0;
            
        assert!((self.source as u32) < (1 << 1));
        val |= (self.source as u32) << 6;
            
        assert!(self.offset < (1 << 14));
        val |= self.offset << 7;
            
        assert!((self.component_bit_widths as u32) < (1 << 6));
        val |= (self.component_bit_widths as u32) << 21;
            
        assert!((self.numerical_type as u32) < (1 << 3));
        val |= (self.numerical_type as u32) << 27;
            
        assert!((self.swap_r_and_b as u32) < (1 << 1));
        val |= (self.swap_r_and_b as u32) << 31;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBSource {
    Active = 0x00000000,
    Inactive = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBComponentBitWidths {
    R32G32B32A32 = 0x00000001,
    R32G32B32 = 0x00000002,
    R16G16B16A16 = 0x00000003,
    R32G32 = 0x00000004,
    R16G16B16 = 0x00000005,
    A8B8G8R8 = 0x0000002f,
    R8G8B8A8 = 0x0000000a,
    X8B8G8R8 = 0x00000033,
    A2B10G10R10 = 0x00000030,
    B10G11R11 = 0x00000031,
    R16G16 = 0x0000000f,
    R32 = 0x00000012,
    R8G8B8 = 0x00000013,
    G8R8 = 0x00000032,
    R8G8 = 0x00000018,
    R16 = 0x0000001b,
    R8 = 0x0000001d,
    A8 = 0x00000034,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVertexAttributeBNumericalType {
    UnusedEnumDoNotUseBecauseItWillGoAway = 0x00000000,
    NumSnorm = 0x00000001,
    NumUnorm = 0x00000002,
    NumSint = 0x00000003,
    NumUint = 0x00000004,
    NumUscaled = 0x00000005,
    NumSscaled = 0x00000006,
    NumFloat = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexAttributeB {
    pub stream: u32,
    pub source: SetVertexAttributeBSource,
    pub offset: u32,
    pub component_bit_widths: SetVertexAttributeBComponentBitWidths,
    pub numerical_type: SetVertexAttributeBNumericalType,
    pub swap_r_and_b: bool,
}

impl ArrayMthd for SetVertexAttributeB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x11a0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.stream < (1 << 5));
        val |= self.stream << 0;
            
        assert!((self.source as u32) < (1 << 1));
        val |= (self.source as u32) << 6;
            
        assert!(self.offset < (1 << 14));
        val |= self.offset << 7;
            
        assert!((self.component_bit_widths as u32) < (1 << 6));
        val |= (self.component_bit_widths as u32) << 21;
            
        assert!((self.numerical_type as u32) < (1 << 3));
        val |= (self.numerical_type as u32) << 27;
            
        assert!((self.swap_r_and_b as u32) < (1 << 1));
        val |= (self.swap_r_and_b as u32) << 31;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawVertexArrayBeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndInstanceFirst {
    pub start_index: u32,
    pub count: u32,
    pub topology: DrawVertexArrayBeginEndInstanceFirstTopology,
}

impl Mthd for DrawVertexArrayBeginEndInstanceFirst {
    const ADDR: u16 = 0x1214;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.start_index < (1 << 16));
        val |= self.start_index << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawVertexArrayBeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndInstanceSubsequent {
    pub start_index: u32,
    pub count: u32,
    pub topology: DrawVertexArrayBeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawVertexArrayBeginEndInstanceSubsequent {
    const ADDR: u16 = 0x1218;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.start_index < (1 << 16));
        val |= self.start_index << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtSelect {
    pub target_count: u32,
    pub target0: u32,
    pub target1: u32,
    pub target2: u32,
    pub target3: u32,
    pub target4: u32,
    pub target5: u32,
    pub target6: u32,
    pub target7: u32,
}

impl Mthd for SetCtSelect {
    const ADDR: u16 = 0x121c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.target_count < (1 << 4));
        val |= self.target_count << 0;
            
        assert!(self.target0 < (1 << 3));
        val |= self.target0 << 4;
            
        assert!(self.target1 < (1 << 3));
        val |= self.target1 << 7;
            
        assert!(self.target2 < (1 << 3));
        val |= self.target2 << 10;
            
        assert!(self.target3 < (1 << 3));
        val |= self.target3 << 13;
            
        assert!(self.target4 < (1 << 3));
        val |= self.target4 << 16;
            
        assert!(self.target5 < (1 << 3));
        val |= self.target5 << 19;
            
        assert!(self.target6 < (1 << 3));
        val |= self.target6 << 22;
            
        assert!(self.target7 < (1 << 3));
        val |= self.target7 << 25;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCompressionThresholdSamples {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    _256 = 0x00000009,
    _512 = 0x0000000a,
    _1024 = 0x0000000b,
    _2048 = 0x0000000c,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCompressionThreshold {
    pub samples: SetCompressionThresholdSamples,
}

impl Mthd for SetCompressionThreshold {
    const ADDR: u16 = 0x1220;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.samples as u32) < (1 << 4));
        val |= (self.samples as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeA {
    pub width: u32,
}

impl Mthd for SetZtSizeA {
    const ADDR: u16 = 0x1228;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.width < (1 << 28));
        val |= self.width << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeB {
    pub height: u32,
}

impl Mthd for SetZtSizeB {
    const ADDR: u16 = 0x122c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.height < (1 << 17));
        val |= self.height << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtSizeCControl {
    ThirdDimensionDefinesArraySize = 0x00000000,
    ArraySizeIsOne = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSizeC {
    pub third_dimension: u32,
    pub control: SetZtSizeCControl,
}

impl Mthd for SetZtSizeC {
    const ADDR: u16 = 0x1230;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.third_dimension < (1 << 16));
        val |= self.third_dimension << 0;
            
        assert!((self.control as u32) < (1 << 1));
        val |= (self.control as u32) << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSamplerBindingV {
    Independently = 0x00000000,
    ViaHeaderBinding = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSamplerBinding {
    pub v: SetSamplerBindingV,
}

impl Mthd for SetSamplerBinding {
    const ADDR: u16 = 0x1234;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawAuto {
    pub byte_count: u32,
}

impl Mthd for DrawAuto {
    const ADDR: u16 = 0x123c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.byte_count;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetCircularBufferSize {
    const ADDR: u16 = 0x1280;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.cache_lines_per_sm < (1 << 10));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVtgRegisterWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetVtgRegisterWatermarks {
    const ADDR: u16 = 0x1284;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.low < (1 << 16));
        val |= self.low << 0;
            
        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCacheNoWfi {
    pub lines: InvalidateTextureDataCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCacheNoWfi {
    const ADDR: u16 = 0x1288;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopInterlockedReadRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopInterlockedReadRequests {
    pub policy: SetL2CacheControlForRopInterlockedReadRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopInterlockedReadRequests {
    const ADDR: u16 = 0x1290;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartIndexTopologyChange {
    pub v: u32,
}

impl Mthd for SetDaPrimitiveRestartIndexTopologyChange {
    const ADDR: u16 = 0x12a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderSchedulingMode {
    OldestThreadFirst = 0x00000000,
    RoundRobin = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderScheduling {
    pub mode: SetShaderSchedulingMode,
}

impl Mthd for SetShaderScheduling {
    const ADDR: u16 = 0x12ac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearZcullRegion {
    pub z_enable: bool,
    pub stencil_enable: bool,
    pub use_clear_rect: bool,
    pub use_rt_array_index: bool,
    pub rt_array_index: u32,
    pub make_conservative: bool,
}

impl Mthd for ClearZcullRegion {
    const ADDR: u16 = 0x12c8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;
            
        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 4;
            
        assert!((self.use_clear_rect as u32) < (1 << 1));
        val |= (self.use_clear_rect as u32) << 1;
            
        assert!((self.use_rt_array_index as u32) < (1 << 1));
        val |= (self.use_rt_array_index as u32) << 2;
            
        assert!(self.rt_array_index < (1 << 16));
        val |= self.rt_array_index << 5;
            
        assert!((self.make_conservative as u32) < (1 << 1));
        val |= (self.make_conservative as u32) << 3;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthTest {
    pub enable: bool,
}

impl Mthd for SetDepthTest {
    const ADDR: u16 = 0x12cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetFillModeV {
    Point = 0x00000001,
    Wireframe = 0x00000002,
    Solid = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFillMode {
    pub v: SetFillModeV,
}

impl Mthd for SetFillMode {
    const ADDR: u16 = 0x12d0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShadeModeV {
    Flat = 0x00000001,
    Gouraud = 0x00000002,
    OglFlat = 0x00001d00,
    OglSmooth = 0x00001d01,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadeMode {
    pub v: SetShadeModeV,
}

impl Mthd for SetShadeMode {
    const ADDR: u16 = 0x12d4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopNoninterlockedWriteRequests {
    pub policy: SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopNoninterlockedWriteRequests {
    const ADDR: u16 = 0x12d8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL2CacheControlForRopInterlockedWriteRequestsPolicy {
    EvictFirst = 0x00000000,
    EvictNormal = 0x00000001,
    EvictLast = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL2CacheControlForRopInterlockedWriteRequests {
    pub policy: SetL2CacheControlForRopInterlockedWriteRequestsPolicy,
}

impl Mthd for SetL2CacheControlForRopInterlockedWriteRequests {
    const ADDR: u16 = 0x12dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.policy as u32) < (1 << 2));
        val |= (self.policy as u32) << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageDitherControlDitherFootprint {
    Pixels1X1 = 0x00000000,
    Pixels2X2 = 0x00000001,
    Pixels1X1VirtualSamples = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaToCoverageDitherControl {
    pub dither_footprint: SetAlphaToCoverageDitherControlDitherFootprint,
}

impl Mthd for SetAlphaToCoverageDitherControl {
    const ADDR: u16 = 0x12e0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.dither_footprint as u32) < (1 << 4));
        val |= (self.dither_footprint as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendStatePerTarget {
    pub enable: bool,
}

impl Mthd for SetBlendStatePerTarget {
    const ADDR: u16 = 0x12e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthWrite {
    pub enable: bool,
}

impl Mthd for SetDepthWrite {
    const ADDR: u16 = 0x12e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaTest {
    pub enable: bool,
}

impl Mthd for SetAlphaTest {
    const ADDR: u16 = 0x12ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineIndex4X8Align {
    pub count: u32,
    pub start: u32,
}

impl Mthd for SetInlineIndex4X8Align {
    const ADDR: u16 = 0x1300;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.count < (1 << 30));
        val |= self.count << 0;
            
        assert!(self.start < (1 << 2));
        val |= self.start << 30;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex4X8 {
    pub index0: u32,
    pub index1: u32,
    pub index2: u32,
    pub index3: u32,
}

impl Mthd for DrawInlineIndex4X8 {
    const ADDR: u16 = 0x1304;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.index0 < (1 << 8));
        val |= self.index0 << 0;
            
        assert!(self.index1 < (1 << 8));
        val |= self.index1 << 8;
            
        assert!(self.index2 < (1 << 8));
        val |= self.index2 << 16;
            
        assert!(self.index3 < (1 << 8));
        val |= self.index3 << 24;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum D3DSetCullModeV {
    None = 0x00000001,
    Cw = 0x00000002,
    Ccw = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct D3DSetCullMode {
    pub v: D3DSetCullModeV,
}

impl Mthd for D3DSetCullMode {
    const ADDR: u16 = 0x1308;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDepthFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthFunc {
    pub v: SetDepthFuncV,
}

impl Mthd for SetDepthFunc {
    const ADDR: u16 = 0x130c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaRef {
    pub v: u32,
}

impl Mthd for SetAlphaRef {
    const ADDR: u16 = 0x1310;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaFunc {
    pub v: SetAlphaFuncV,
}

impl Mthd for SetAlphaFunc {
    const ADDR: u16 = 0x1314;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawAutoStride {
    pub v: u32,
}

impl Mthd for SetDrawAutoStride {
    const ADDR: u16 = 0x1318;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 12));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstRed {
    pub v: f32,
}

impl Mthd for SetBlendConstRed {
    const ADDR: u16 = 0x131c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstGreen {
    pub v: f32,
}

impl Mthd for SetBlendConstGreen {
    const ADDR: u16 = 0x1320;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstBlue {
    pub v: f32,
}

impl Mthd for SetBlendConstBlue {
    const ADDR: u16 = 0x1324;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendConstAlpha {
    pub v: f32,
}

impl Mthd for SetBlendConstAlpha {
    const ADDR: u16 = 0x1328;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCache {
    pub lines: InvalidateSamplerCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCache {
    const ADDR: u16 = 0x1330;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCache {
    pub lines: InvalidateTextureHeaderCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCache {
    const ADDR: u16 = 0x1334;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendSeparateForAlpha {
    pub enable: bool,
}

impl Mthd for SetBlendSeparateForAlpha {
    const ADDR: u16 = 0x133c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorOp {
    pub v: SetBlendColorOpV,
}

impl Mthd for SetBlendColorOp {
    const ADDR: u16 = 0x1340;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorSourceCoeff {
    pub v: SetBlendColorSourceCoeffV,
}

impl Mthd for SetBlendColorSourceCoeff {
    const ADDR: u16 = 0x1344;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendColorDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendColorDestCoeff {
    pub v: SetBlendColorDestCoeffV,
}

impl Mthd for SetBlendColorDestCoeff {
    const ADDR: u16 = 0x1348;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaOp {
    pub v: SetBlendAlphaOpV,
}

impl Mthd for SetBlendAlphaOp {
    const ADDR: u16 = 0x134c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaSourceCoeff {
    pub v: SetBlendAlphaSourceCoeffV,
}

impl Mthd for SetBlendAlphaSourceCoeff {
    const ADDR: u16 = 0x1350;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalColorKey {
    pub enable: bool,
}

impl Mthd for SetGlobalColorKey {
    const ADDR: u16 = 0x1354;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendAlphaDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendAlphaDestCoeff {
    pub v: SetBlendAlphaDestCoeffV,
}

impl Mthd for SetBlendAlphaDestCoeff {
    const ADDR: u16 = 0x1358;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSingleRopControl {
    pub enable: bool,
}

impl Mthd for SetSingleRopControl {
    const ADDR: u16 = 0x135c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlend {
    pub enable: bool,
}

impl ArrayMthd for SetBlend {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1360+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilTest {
    pub enable: bool,
}

impl Mthd for SetStencilTest {
    const ADDR: u16 = 0x1380;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpFailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpFail {
    pub v: SetStencilOpFailV,
}

impl Mthd for SetStencilOpFail {
    const ADDR: u16 = 0x1384;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpZfailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpZfail {
    pub v: SetStencilOpZfailV,
}

impl Mthd for SetStencilOpZfail {
    const ADDR: u16 = 0x1388;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilOpZpassV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilOpZpass {
    pub v: SetStencilOpZpassV,
}

impl Mthd for SetStencilOpZpass {
    const ADDR: u16 = 0x138c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetStencilFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFunc {
    pub v: SetStencilFuncV,
}

impl Mthd for SetStencilFunc {
    const ADDR: u16 = 0x1390;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFuncRef {
    pub v: u32,
}

impl Mthd for SetStencilFuncRef {
    const ADDR: u16 = 0x1394;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilFuncMask {
    pub v: u32,
}

impl Mthd for SetStencilFuncMask {
    const ADDR: u16 = 0x1398;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilMask {
    pub v: u32,
}

impl Mthd for SetStencilMask {
    const ADDR: u16 = 0x139c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawAutoStart {
    pub byte_count: u32,
}

impl Mthd for SetDrawAutoStart {
    const ADDR: u16 = 0x13a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.byte_count;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsSaturate {
    pub output0: bool,
    pub output1: bool,
    pub output2: bool,
    pub output3: bool,
    pub output4: bool,
    pub output5: bool,
    pub output6: bool,
    pub output7: bool,
}

impl Mthd for SetPsSaturate {
    const ADDR: u16 = 0x13a8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.output0 as u32) < (1 << 1));
        val |= (self.output0 as u32) << 0;
            
        assert!((self.output1 as u32) < (1 << 1));
        val |= (self.output1 as u32) << 4;
            
        assert!((self.output2 as u32) < (1 << 1));
        val |= (self.output2 as u32) << 8;
            
        assert!((self.output3 as u32) < (1 << 1));
        val |= (self.output3 as u32) << 12;
            
        assert!((self.output4 as u32) < (1 << 1));
        val |= (self.output4 as u32) << 16;
            
        assert!((self.output5 as u32) < (1 << 1));
        val |= (self.output5 as u32) << 20;
            
        assert!((self.output6 as u32) < (1 << 1));
        val |= (self.output6 as u32) << 24;
            
        assert!((self.output7 as u32) < (1 << 1));
        val |= (self.output7 as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetWindowOriginMode {
    UpperLeft = 0x00000000,
    LowerLeft = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowOrigin {
    pub mode: SetWindowOriginMode,
    pub flip_y: bool,
}

impl Mthd for SetWindowOrigin {
    const ADDR: u16 = 0x13ac;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;
            
        assert!((self.flip_y as u32) < (1 << 1));
        val |= (self.flip_y as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineWidthFloat {
    pub v: f32,
}

impl Mthd for SetLineWidthFloat {
    const ADDR: u16 = 0x13b0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAliasedLineWidthFloat {
    pub v: f32,
}

impl Mthd for SetAliasedLineWidthFloat {
    const ADDR: u16 = 0x13b4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineMultisampleOverride {
    pub enable: bool,
}

impl Mthd for SetLineMultisampleOverride {
    const ADDR: u16 = 0x1418;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaHysteresis {
    pub rounds_of_alpha: u32,
}

impl Mthd for SetAlphaHysteresis {
    const ADDR: u16 = 0x1420;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.rounds_of_alpha < (1 << 8));
        val |= self.rounds_of_alpha << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheNoWfi {
    pub lines: InvalidateSamplerCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCacheNoWfi {
    const ADDR: u16 = 0x1424;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheNoWfi {
    pub lines: InvalidateTextureHeaderCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCacheNoWfi {
    const ADDR: u16 = 0x1428;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateDaDmaCache {
    pub v: u32,
}

impl Mthd for InvalidateDaDmaCache {
    const ADDR: u16 = 0x142c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalBaseVertexIndex {
    pub v: u32,
}

impl Mthd for SetGlobalBaseVertexIndex {
    const ADDR: u16 = 0x1434;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalBaseInstanceIndex {
    pub v: u32,
}

impl Mthd for SetGlobalBaseInstanceIndex {
    const ADDR: u16 = 0x1438;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsWarpWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetPsWarpWatermarks {
    const ADDR: u16 = 0x1450;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.low < (1 << 16));
        val |= self.low << 0;
            
        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsRegisterWatermarks {
    pub low: u32,
    pub high: u32,
}

impl Mthd for SetPsRegisterWatermarks {
    const ADDR: u16 = 0x1454;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.low < (1 << 16));
        val |= self.low << 0;
            
        assert!(self.high < (1 << 16));
        val |= self.high << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StoreZcull {
    pub v: u32,
}

impl Mthd for StoreZcull {
    const ADDR: u16 = 0x1464;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadZcull {
    pub v: u32,
}

impl Mthd for LoadZcull {
    const ADDR: u16 = 0x1500;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdHeight {
    pub v: u32,
}

impl Mthd for SetSurfaceClipIdHeight {
    const ADDR: u16 = 0x1504;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdClearRectHorizontal {
    pub xmin: u32,
    pub xmax: u32,
}

impl Mthd for SetClipIdClearRectHorizontal {
    const ADDR: u16 = 0x1508;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.xmin < (1 << 16));
        val |= self.xmin << 0;
            
        assert!(self.xmax < (1 << 16));
        val |= self.xmax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdClearRectVertical {
    pub ymin: u32,
    pub ymax: u32,
}

impl Mthd for SetClipIdClearRectVertical {
    const ADDR: u16 = 0x150c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ymin < (1 << 16));
        val |= self.ymin << 0;
            
        assert!(self.ymax < (1 << 16));
        val |= self.ymax << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetUserClipEnable {
    pub plane0: bool,
    pub plane1: bool,
    pub plane2: bool,
    pub plane3: bool,
    pub plane4: bool,
    pub plane5: bool,
    pub plane6: bool,
    pub plane7: bool,
}

impl Mthd for SetUserClipEnable {
    const ADDR: u16 = 0x1510;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.plane0 as u32) < (1 << 1));
        val |= (self.plane0 as u32) << 0;
            
        assert!((self.plane1 as u32) < (1 << 1));
        val |= (self.plane1 as u32) << 1;
            
        assert!((self.plane2 as u32) < (1 << 1));
        val |= (self.plane2 as u32) << 2;
            
        assert!((self.plane3 as u32) < (1 << 1));
        val |= (self.plane3 as u32) << 3;
            
        assert!((self.plane4 as u32) < (1 << 1));
        val |= (self.plane4 as u32) << 4;
            
        assert!((self.plane5 as u32) < (1 << 1));
        val |= (self.plane5 as u32) << 5;
            
        assert!((self.plane6 as u32) < (1 << 1));
        val |= (self.plane6 as u32) << 6;
            
        assert!((self.plane7 as u32) < (1 << 1));
        val |= (self.plane7 as u32) << 7;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZpassPixelCount {
    pub enable: bool,
}

impl Mthd for SetZpassPixelCount {
    const ADDR: u16 = 0x1514;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSize {
    pub v: u32,
}

impl Mthd for SetPointSize {
    const ADDR: u16 = 0x1518;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullStats {
    pub enable: bool,
}

impl Mthd for SetZcullStats {
    const ADDR: u16 = 0x151c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSprite {
    pub enable: bool,
}

impl Mthd for SetPointSprite {
    const ADDR: u16 = 0x1520;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderExceptions {
    pub enable: bool,
}

impl Mthd for SetShaderExceptions {
    const ADDR: u16 = 0x1528;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ClearReportValueType {
    DaVerticesGenerated = 0x00000012,
    DaPrimitivesGenerated = 0x00000013,
    VsInvocations = 0x00000015,
    TiInvocations = 0x00000016,
    TsInvocations = 0x00000017,
    TsPrimitivesGenerated = 0x00000018,
    GsInvocations = 0x0000001a,
    GsPrimitivesGenerated = 0x0000001b,
    VtgPrimitivesOut = 0x0000001f,
    StreamingPrimitivesSucceeded = 0x00000010,
    StreamingPrimitivesNeeded = 0x00000011,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x00000003,
    ClipperInvocations = 0x0000001c,
    ClipperPrimitivesGenerated = 0x0000001d,
    ZcullStats = 0x00000002,
    PsInvocations = 0x0000001e,
    ZpassPixelCnt = 0x00000001,
    AlphaBetaClocks = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearReportValue {
    pub type_: ClearReportValueType,
}

impl Mthd for ClearReportValue {
    const ADDR: u16 = 0x1530;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.type_ as u32) < (1 << 5));
        val |= (self.type_ as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasEnable {
    pub v: bool,
}

impl Mthd for SetAntiAliasEnable {
    const ADDR: u16 = 0x1534;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSelect {
    pub target_count: u32,
}

impl Mthd for SetZtSelect {
    const ADDR: u16 = 0x1538;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.target_count < (1 << 1));
        val |= self.target_count << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasAlphaControlAlphaToCoverage {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasAlphaControlAlphaToOne {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasAlphaControl {
    pub alpha_to_coverage: SetAntiAliasAlphaControlAlphaToCoverage,
    pub alpha_to_one: SetAntiAliasAlphaControlAlphaToOne,
}

impl Mthd for SetAntiAliasAlphaControl {
    const ADDR: u16 = 0x153c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.alpha_to_coverage as u32) < (1 << 1));
        val |= (self.alpha_to_coverage as u32) << 0;
            
        assert!((self.alpha_to_one as u32) < (1 << 1));
        val |= (self.alpha_to_one as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexSamplerPoolB {
    const ADDR: u16 = 0x1560;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexSamplerPoolC {
    const ADDR: u16 = 0x1564;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 20));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSlopeScaleDepthBias {
    pub v: f32,
}

impl Mthd for SetSlopeScaleDepthBias {
    const ADDR: u16 = 0x156c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasedLine {
    pub enable: bool,
}

impl Mthd for SetAntiAliasedLine {
    const ADDR: u16 = 0x1570;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexHeaderPoolB {
    const ADDR: u16 = 0x1578;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexHeaderPoolC {
    const ADDR: u16 = 0x157c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 22));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetActiveZcullRegion {
    pub id: u32,
}

impl Mthd for SetActiveZcullRegion {
    const ADDR: u16 = 0x1590;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.id < (1 << 6));
        val |= self.id << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTwoSidedStencilTest {
    pub enable: bool,
}

impl Mthd for SetTwoSidedStencilTest {
    const ADDR: u16 = 0x1594;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpFailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpFail {
    pub v: SetBackStencilOpFailV,
}

impl Mthd for SetBackStencilOpFail {
    const ADDR: u16 = 0x1598;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpZfailV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpZfail {
    pub v: SetBackStencilOpZfailV,
}

impl Mthd for SetBackStencilOpZfail {
    const ADDR: u16 = 0x159c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilOpZpassV {
    OglKeep = 0x00001e00,
    OglZero = 0x00000000,
    OglReplace = 0x00001e01,
    OglIncrsat = 0x00001e02,
    OglDecrsat = 0x00001e03,
    OglInvert = 0x0000150a,
    OglIncr = 0x00008507,
    OglDecr = 0x00008508,
    D3DKeep = 0x00000001,
    D3DZero = 0x00000002,
    D3DReplace = 0x00000003,
    D3DIncrsat = 0x00000004,
    D3DDecrsat = 0x00000005,
    D3DInvert = 0x00000006,
    D3DIncr = 0x00000007,
    D3DDecr = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilOpZpass {
    pub v: SetBackStencilOpZpassV,
}

impl Mthd for SetBackStencilOpZpass {
    const ADDR: u16 = 0x15a0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBackStencilFuncV {
    OglNever = 0x00000200,
    OglLess = 0x00000201,
    OglEqual = 0x00000202,
    OglLequal = 0x00000203,
    OglGreater = 0x00000204,
    OglNotequal = 0x00000205,
    OglGequal = 0x00000206,
    OglAlways = 0x00000207,
    D3DNever = 0x00000001,
    D3DLess = 0x00000002,
    D3DEqual = 0x00000003,
    D3DLessequal = 0x00000004,
    D3DGreater = 0x00000005,
    D3DNotequal = 0x00000006,
    D3DGreaterequal = 0x00000007,
    D3DAlways = 0x00000008,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBackStencilFunc {
    pub v: SetBackStencilFuncV,
}

impl Mthd for SetBackStencilFunc {
    const ADDR: u16 = 0x15a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrgbWrite {
    pub enable: bool,
}

impl Mthd for SetSrgbWrite {
    const ADDR: u16 = 0x15b8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBias {
    pub v: f32,
}

impl Mthd for SetDepthBias {
    const ADDR: u16 = 0x15bc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullRegionFormatType {
    Z4X4 = 0x00000000,
    Zs4X4 = 0x00000001,
    Z4X2 = 0x00000002,
    Z2X4 = 0x00000003,
    Z16X84X4 = 0x00000004,
    Z8X84X2 = 0x00000005,
    Z8X82X4 = 0x00000006,
    Z16X164X8 = 0x00000007,
    Z4X82X2 = 0x00000008,
    Zs16X84X2 = 0x00000009,
    Zs16X82X4 = 0x0000000a,
    Zs8X82X2 = 0x0000000b,
    Z4X81X1 = 0x0000000c,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionFormat {
    pub type_: SetZcullRegionFormatType,
}

impl Mthd for SetZcullRegionFormat {
    const ADDR: u16 = 0x15c8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.type_ as u32) < (1 << 4));
        val |= (self.type_ as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRtLayerControl {
    VSelectsLayer = 0x00000000,
    GeometryShaderSelectsLayer = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRtLayer {
    pub v: u32,
    pub control: SetRtLayerControl,
}

impl Mthd for SetRtLayer {
    const ADDR: u16 = 0x15cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;
            
        assert!((self.control as u32) < (1 << 1));
        val |= (self.control as u32) << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasSamples {
    Mode1X1 = 0x00000000,
    Mode2X1 = 0x00000001,
    Mode2X2 = 0x00000002,
    Mode4X2 = 0x00000003,
    Mode4X2D3D = 0x00000004,
    Mode2X1D3D = 0x00000005,
    Mode4X4 = 0x00000006,
    Mode2X2Vc4 = 0x00000008,
    Mode2X2Vc12 = 0x00000009,
    Mode4X2Vc8 = 0x0000000a,
    Mode4X2Vc24 = 0x0000000b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAlias {
    pub samples: SetAntiAliasSamples,
}

impl Mthd for SetAntiAlias {
    const ADDR: u16 = 0x15d0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.samples as u32) < (1 << 4));
        val |= (self.samples as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetEdgeFlag {
    pub v: bool,
}

impl Mthd for SetEdgeFlag {
    const ADDR: u16 = 0x15e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex {
    pub v: u32,
}

impl Mthd for DrawInlineIndex {
    const ADDR: u16 = 0x15e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineIndex2X16Align {
    pub count: u32,
    pub start_odd: bool,
}

impl Mthd for SetInlineIndex2X16Align {
    const ADDR: u16 = 0x15ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.count < (1 << 31));
        val |= self.count << 0;
            
        assert!((self.start_odd as u32) < (1 << 1));
        val |= (self.start_odd as u32) << 31;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineIndex2X16 {
    pub even: u32,
    pub odd: u32,
}

impl Mthd for DrawInlineIndex2X16 {
    const ADDR: u16 = 0x15f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.even < (1 << 16));
        val |= self.even << 0;
            
        assert!(self.odd < (1 << 16));
        val |= self.odd << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexGlobalBaseOffsetA {
    pub upper: u32,
}

impl Mthd for SetVertexGlobalBaseOffsetA {
    const ADDR: u16 = 0x15f4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexGlobalBaseOffsetB {
    pub lower: u32,
}

impl Mthd for SetVertexGlobalBaseOffsetB {
    const ADDR: u16 = 0x15f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetA {
    pub width: u32,
}

impl Mthd for SetZcullRegionPixelOffsetA {
    const ADDR: u16 = 0x15fc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionPixelOffsetB {
    pub height: u32,
}

impl Mthd for SetZcullRegionPixelOffsetB {
    const ADDR: u16 = 0x1600;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectRmode {
    Zero = 0x00000000,
    FromR = 0x00000001,
    FromS = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectOrigin {
    Bottom = 0x00000000,
    Top = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture0 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture1 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture2 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture3 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture4 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture5 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture6 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture7 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture8 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointSpriteSelectTexture9 {
    Passthrough = 0x00000000,
    Generate = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointSpriteSelect {
    pub rmode: SetPointSpriteSelectRmode,
    pub origin: SetPointSpriteSelectOrigin,
    pub texture0: SetPointSpriteSelectTexture0,
    pub texture1: SetPointSpriteSelectTexture1,
    pub texture2: SetPointSpriteSelectTexture2,
    pub texture3: SetPointSpriteSelectTexture3,
    pub texture4: SetPointSpriteSelectTexture4,
    pub texture5: SetPointSpriteSelectTexture5,
    pub texture6: SetPointSpriteSelectTexture6,
    pub texture7: SetPointSpriteSelectTexture7,
    pub texture8: SetPointSpriteSelectTexture8,
    pub texture9: SetPointSpriteSelectTexture9,
}

impl Mthd for SetPointSpriteSelect {
    const ADDR: u16 = 0x1604;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.rmode as u32) < (1 << 2));
        val |= (self.rmode as u32) << 0;
            
        assert!((self.origin as u32) < (1 << 1));
        val |= (self.origin as u32) << 2;
            
        assert!((self.texture0 as u32) < (1 << 1));
        val |= (self.texture0 as u32) << 3;
            
        assert!((self.texture1 as u32) < (1 << 1));
        val |= (self.texture1 as u32) << 4;
            
        assert!((self.texture2 as u32) < (1 << 1));
        val |= (self.texture2 as u32) << 5;
            
        assert!((self.texture3 as u32) < (1 << 1));
        val |= (self.texture3 as u32) << 6;
            
        assert!((self.texture4 as u32) < (1 << 1));
        val |= (self.texture4 as u32) << 7;
            
        assert!((self.texture5 as u32) < (1 << 1));
        val |= (self.texture5 as u32) << 8;
            
        assert!((self.texture6 as u32) < (1 << 1));
        val |= (self.texture6 as u32) << 9;
            
        assert!((self.texture7 as u32) < (1 << 1));
        val |= (self.texture7 as u32) << 10;
            
        assert!((self.texture8 as u32) < (1 << 1));
        val |= (self.texture8 as u32) << 11;
            
        assert!((self.texture9 as u32) < (1 << 1));
        val |= (self.texture9 as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionA {
    pub address_upper: u32,
}

impl Mthd for SetProgramRegionA {
    const ADDR: u16 = 0x1608;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionB {
    pub address_lower: u32,
}

impl Mthd for SetProgramRegionB {
    const ADDR: u16 = 0x160c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultColorFrontDiffuse {
    Vector0001 = 0x00000000,
    Vector1111 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultColorFrontSpecular {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultGenericVector {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultFixedFncTexture {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultDx9Color0 {
    Vector0001 = 0x00000000,
    Vector1111 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAttributeDefaultDx9Color1ToColor15 {
    Vector0000 = 0x00000000,
    Vector0001 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAttributeDefault {
    pub color_front_diffuse: SetAttributeDefaultColorFrontDiffuse,
    pub color_front_specular: SetAttributeDefaultColorFrontSpecular,
    pub generic_vector: SetAttributeDefaultGenericVector,
    pub fixed_fnc_texture: SetAttributeDefaultFixedFncTexture,
    pub dx9_color0: SetAttributeDefaultDx9Color0,
    pub dx9_color1_to_color15: SetAttributeDefaultDx9Color1ToColor15,
}

impl Mthd for SetAttributeDefault {
    const ADDR: u16 = 0x1610;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.color_front_diffuse as u32) < (1 << 1));
        val |= (self.color_front_diffuse as u32) << 0;
            
        assert!((self.color_front_specular as u32) < (1 << 1));
        val |= (self.color_front_specular as u32) << 1;
            
        assert!((self.generic_vector as u32) < (1 << 1));
        val |= (self.generic_vector as u32) << 2;
            
        assert!((self.fixed_fnc_texture as u32) < (1 << 1));
        val |= (self.fixed_fnc_texture as u32) << 3;
            
        assert!((self.dx9_color0 as u32) < (1 << 1));
        val |= (self.dx9_color0 as u32) << 4;
            
        assert!((self.dx9_color1_to_color15 as u32) < (1 << 1));
        val |= (self.dx9_color1_to_color15 as u32) << 5;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct End {
    pub v: u32,
}

impl Mthd for End {
    const ADDR: u16 = 0x1614;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginOp {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginPrimitiveId {
    First = 0x00000000,
    Unchanged = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginInstanceId {
    First = 0x00000000,
    Subsequent = 0x00000001,
    Unchanged = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginSplitMode {
    NormalBeginNormalEnd = 0x00000000,
    NormalBeginOpenEnd = 0x00000001,
    OpenBeginOpenEnd = 0x00000002,
    OpenBeginNormalEnd = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Begin {
    pub op: BeginOp,
    pub primitive_id: BeginPrimitiveId,
    pub instance_id: BeginInstanceId,
    pub split_mode: BeginSplitMode,
}

impl Mthd for Begin {
    const ADDR: u16 = 0x1618;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.op as u32) < (1 << 16));
        val |= (self.op as u32) << 0;
            
        assert!((self.primitive_id as u32) < (1 << 1));
        val |= (self.primitive_id as u32) << 24;
            
        assert!((self.instance_id as u32) < (1 << 2));
        val |= (self.instance_id as u32) << 26;
            
        assert!((self.split_mode as u32) < (1 << 2));
        val |= (self.split_mode as u32) << 29;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexIdCopy {
    pub enable: bool,
    pub attribute_slot: u32,
}

impl Mthd for SetVertexIdCopy {
    const ADDR: u16 = 0x161c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!(self.attribute_slot < (1 << 8));
        val |= self.attribute_slot << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct AddToPrimitiveId {
    pub v: u32,
}

impl Mthd for AddToPrimitiveId {
    const ADDR: u16 = 0x1620;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadPrimitiveId {
    pub v: u32,
}

impl Mthd for LoadPrimitiveId {
    const ADDR: u16 = 0x1624;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderBasedCull {
    pub batch_cull_enable: bool,
    pub before_fetch_enable: bool,
}

impl Mthd for SetShaderBasedCull {
    const ADDR: u16 = 0x162c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.batch_cull_enable as u32) < (1 << 1));
        val |= (self.batch_cull_enable as u32) << 1;
            
        assert!((self.before_fetch_enable as u32) < (1 << 1));
        val |= (self.before_fetch_enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetClassVersion {
    const ADDR: u16 = 0x1638;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabPageReadSelect {
    Pages0And1 = 0x00000000,
    Pages0And2 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabPage {
    pub read_select: SetVabPageReadSelect,
}

impl Mthd for SetVabPage {
    const ADDR: u16 = 0x163c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.read_select as u32) < (1 << 1));
        val |= (self.read_select as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawInlineVertex {
    pub v: u32,
}

impl Mthd for DrawInlineVertex {
    const ADDR: u16 = 0x1640;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestart {
    pub enable: bool,
}

impl Mthd for SetDaPrimitiveRestart {
    const ADDR: u16 = 0x1644;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaPrimitiveRestartIndex {
    pub v: u32,
}

impl Mthd for SetDaPrimitiveRestartIndex {
    const ADDR: u16 = 0x1648;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDaOutput {
    pub vertex_id_uses_array_start: bool,
}

impl Mthd for SetDaOutput {
    const ADDR: u16 = 0x164c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.vertex_id_uses_array_start as u32) < (1 << 1));
        val |= (self.vertex_id_uses_array_start as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasedPoint {
    pub enable: bool,
}

impl Mthd for SetAntiAliasedPoint {
    const ADDR: u16 = 0x1658;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPointCenterModeV {
    Ogl = 0x00000000,
    D3D = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPointCenterMode {
    pub v: SetPointCenterModeV,
}

impl Mthd for SetPointCenterMode {
    const ADDR: u16 = 0x165c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLineSmoothParametersFalloff {
    _100 = 0x00000000,
    _133 = 0x00000001,
    _160 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineSmoothParameters {
    pub falloff: SetLineSmoothParametersFalloff,
}

impl Mthd for SetLineSmoothParameters {
    const ADDR: u16 = 0x1668;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.falloff as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineStipple {
    pub enable: bool,
}

impl Mthd for SetLineStipple {
    const ADDR: u16 = 0x166c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineSmoothEdgeTable {
    pub v0: u32,
    pub v1: u32,
    pub v2: u32,
    pub v3: u32,
}

impl ArrayMthd for SetLineSmoothEdgeTable {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1670+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v0 < (1 << 8));
        val |= self.v0 << 0;
            
        assert!(self.v1 < (1 << 8));
        val |= self.v1 << 8;
            
        assert!(self.v2 < (1 << 8));
        val |= self.v2 << 16;
            
        assert!(self.v3 < (1 << 8));
        val |= self.v3 << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLineStippleParameters {
    pub factor: u32,
    pub pattern: u32,
}

impl Mthd for SetLineStippleParameters {
    const ADDR: u16 = 0x1680;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.factor < (1 << 8));
        val |= self.factor << 0;
            
        assert!(self.pattern < (1 << 16));
        val |= self.pattern << 8;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetProvokingVertexV {
    First = 0x00000000,
    Last = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProvokingVertex {
    pub v: SetProvokingVertexV,
}

impl Mthd for SetProvokingVertex {
    const ADDR: u16 = 0x1684;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTwoSidedLight {
    pub enable: bool,
}

impl Mthd for SetTwoSidedLight {
    const ADDR: u16 = 0x1688;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolygonStipple {
    pub enable: bool,
}

impl Mthd for SetPolygonStipple {
    const ADDR: u16 = 0x168c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlDefaultPartial {
    Zero = 0x00000000,
    Infinity = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlFp32NanBehavior {
    Legacy = 0x00000000,
    Fp64Compatible = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlFp32F2INanBehavior {
    PassZero = 0x00000000,
    PassIndefinite = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderControl {
    pub default_partial: SetShaderControlDefaultPartial,
    pub fp32_nan_behavior: SetShaderControlFp32NanBehavior,
    pub fp32_f2i_nan_behavior: SetShaderControlFp32F2INanBehavior,
}

impl Mthd for SetShaderControl {
    const ADDR: u16 = 0x1690;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.default_partial as u32) < (1 << 1));
        val |= (self.default_partial as u32) << 0;
            
        assert!((self.fp32_nan_behavior as u32) < (1 << 1));
        val |= (self.fp32_nan_behavior as u32) << 1;
            
        assert!((self.fp32_f2i_nan_behavior as u32) < (1 << 1));
        val |= (self.fp32_f2i_nan_behavior as u32) << 2;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchVertex {
    pub v: u32,
}

impl Mthd for LaunchVertex {
    const ADDR: u16 = 0x169c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckClassVersion {
    const ADDR: u16 = 0x16a0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSphVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetSphVersion {
    const ADDR: u16 = 0x16a4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckSphVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckSphVersion {
    const ADDR: u16 = 0x16a8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageOverrideQualifyByAntiAliasEnable {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaToCoverageOverride {
    pub qualify_by_anti_alias_enable: SetAlphaToCoverageOverrideQualifyByAntiAliasEnable,
    pub qualify_by_ps_sample_mask_output: SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput,
}

impl Mthd for SetAlphaToCoverageOverride {
    const ADDR: u16 = 0x16b4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.qualify_by_anti_alias_enable as u32) < (1 << 1));
        val |= (self.qualify_by_anti_alias_enable as u32) << 0;
            
        assert!((self.qualify_by_ps_sample_mask_output as u32) < (1 << 1));
        val |= (self.qualify_by_ps_sample_mask_output as u32) << 1;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPolygonStipplePattern {
    pub v: u32,
}

impl ArrayMthd for SetPolygonStipplePattern {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1700+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAamVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetAamVersion {
    const ADDR: u16 = 0x1790;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckAamVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckAamVersion {
    const ADDR: u16 = 0x1794;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.current < (1 << 16));
        val |= self.current << 0;
            
        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtLayer {
    pub offset: u32,
}

impl Mthd for SetZtLayer {
    const ADDR: u16 = 0x179c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset < (1 << 16));
        val |= self.offset << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaA {
    pub offset_upper: u32,
}

impl Mthd for SetVabMemoryAreaA {
    const ADDR: u16 = 0x17bc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaB {
    pub offset_lower: u32,
}

impl Mthd for SetVabMemoryAreaB {
    const ADDR: u16 = 0x17c0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVabMemoryAreaCSize {
    Bytes64K = 0x00000001,
    Bytes128K = 0x00000002,
    Bytes256K = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVabMemoryAreaC {
    pub size: SetVabMemoryAreaCSize,
}

impl Mthd for SetVabMemoryAreaC {
    const ADDR: u16 = 0x17c4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.size as u32) < (1 << 2));
        val |= (self.size as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferA {
    pub address_upper: u32,
}

impl Mthd for SetIndexBufferA {
    const ADDR: u16 = 0x17c8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferB {
    pub address_lower: u32,
}

impl Mthd for SetIndexBufferB {
    const ADDR: u16 = 0x17cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferC {
    pub limit_address_upper: u32,
}

impl Mthd for SetIndexBufferC {
    const ADDR: u16 = 0x17d0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.limit_address_upper < (1 << 8));
        val |= self.limit_address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferD {
    pub limit_address_lower: u32,
}

impl Mthd for SetIndexBufferD {
    const ADDR: u16 = 0x17d4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.limit_address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetIndexBufferEIndexSize {
    OneByte = 0x00000000,
    TwoBytes = 0x00000001,
    FourBytes = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferE {
    pub index_size: SetIndexBufferEIndexSize,
}

impl Mthd for SetIndexBufferE {
    const ADDR: u16 = 0x17d8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.index_size as u32) < (1 << 2));
        val |= (self.index_size as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferF {
    pub first: u32,
}

impl Mthd for SetIndexBufferF {
    const ADDR: u16 = 0x17dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.first;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer {
    pub count: u32,
}

impl Mthd for DrawIndexBuffer {
    const ADDR: u16 = 0x17e0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.count;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer32BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer32BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer32BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer32BeginEndInstanceFirst {
    const ADDR: u16 = 0x17e4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer16BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer16BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer16BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer16BeginEndInstanceFirst {
    const ADDR: u16 = 0x17e8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer8BeginEndInstanceFirstTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer8BeginEndInstanceFirst {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer8BeginEndInstanceFirstTopology,
}

impl Mthd for DrawIndexBuffer8BeginEndInstanceFirst {
    const ADDR: u16 = 0x17ec;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer32BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer32BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer32BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer32BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer16BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer16BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer16BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer16BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum DrawIndexBuffer8BeginEndInstanceSubsequentTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBuffer8BeginEndInstanceSubsequent {
    pub first: u32,
    pub count: u32,
    pub topology: DrawIndexBuffer8BeginEndInstanceSubsequentTopology,
}

impl Mthd for DrawIndexBuffer8BeginEndInstanceSubsequent {
    const ADDR: u16 = 0x17f8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.first < (1 << 16));
        val |= self.first << 0;
            
        assert!(self.count < (1 << 12));
        val |= self.count << 16;
            
        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 28;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBiasClamp {
    pub v: f32,
}

impl Mthd for SetDepthBiasClamp {
    const ADDR: u16 = 0x187c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamInstanceA {
    pub is_instanced: bool,
}

impl ArrayMthd for SetVertexStreamInstanceA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1880+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.is_instanced as u32) < (1 << 1));
        val |= (self.is_instanced as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamInstanceB {
    pub is_instanced: bool,
}

impl ArrayMthd for SetVertexStreamInstanceB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x18c0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.is_instanced as u32) < (1 << 1));
        val |= (self.is_instanced as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAttributePointSize {
    pub enable: bool,
    pub slot: u32,
}

impl Mthd for SetAttributePointSize {
    const ADDR: u16 = 0x1910;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!(self.slot < (1 << 8));
        val |= self.slot << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetCull {
    pub enable: bool,
}

impl Mthd for OglSetCull {
    const ADDR: u16 = 0x1918;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum OglSetFrontFaceV {
    Cw = 0x00000900,
    Ccw = 0x00000901,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetFrontFace {
    pub v: OglSetFrontFaceV,
}

impl Mthd for OglSetFrontFace {
    const ADDR: u16 = 0x191c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum OglSetCullFaceV {
    Front = 0x00000404,
    Back = 0x00000405,
    FrontAndBack = 0x00000408,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OglSetCullFace {
    pub v: OglSetCullFaceV,
}

impl Mthd for OglSetCullFace {
    const ADDR: u16 = 0x1920;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportPixelCenter {
    AtHalfIntegers = 0x00000000,
    AtIntegers = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportPixel {
    pub center: SetViewportPixelCenter,
}

impl Mthd for SetViewportPixel {
    const ADDR: u16 = 0x1924;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.center as u32) < (1 << 1));
        val |= (self.center as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportScaleOffset {
    pub enable: bool,
}

impl Mthd for SetViewportScaleOffset {
    const ADDR: u16 = 0x192c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCache {
    pub thru_l2: bool,
}

impl Mthd for InvalidateConstantBufferCache {
    const ADDR: u16 = 0x1930;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.thru_l2 as u32) < (1 << 1));
        val |= (self.thru_l2 as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMinZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMaxZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlLinePointCullGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryClip {
    WzeroClip = 0x00000000,
    Passthru = 0x00000001,
    FrustumXyClip = 0x00000002,
    FrustumXyzClip = 0x00000003,
    WzeroClipNoZCull = 0x00000004,
    FrustumZClip = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardbandZ {
    SameAsXyGuardband = 0x00000000,
    Scale256 = 0x00000001,
    Scale1 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipControl {
    pub min_z_zero_max_z_one: bool,
    pub pixel_min_z: SetViewportClipControlPixelMinZ,
    pub pixel_max_z: SetViewportClipControlPixelMaxZ,
    pub geometry_guardband: SetViewportClipControlGeometryGuardband,
    pub line_point_cull_guardband: SetViewportClipControlLinePointCullGuardband,
    pub geometry_clip: SetViewportClipControlGeometryClip,
    pub geometry_guardband_z: SetViewportClipControlGeometryGuardbandZ,
}

impl Mthd for SetViewportClipControl {
    const ADDR: u16 = 0x193c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.min_z_zero_max_z_one as u32) < (1 << 1));
        val |= (self.min_z_zero_max_z_one as u32) << 0;
            
        assert!((self.pixel_min_z as u32) < (1 << 1));
        val |= (self.pixel_min_z as u32) << 3;
            
        assert!((self.pixel_max_z as u32) < (1 << 1));
        val |= (self.pixel_max_z as u32) << 4;
            
        assert!((self.geometry_guardband as u32) < (1 << 1));
        val |= (self.geometry_guardband as u32) << 7;
            
        assert!((self.line_point_cull_guardband as u32) < (1 << 1));
        val |= (self.line_point_cull_guardband as u32) << 10;
            
        assert!((self.geometry_clip as u32) < (1 << 3));
        val |= (self.geometry_clip as u32) << 11;
            
        assert!((self.geometry_guardband_z as u32) < (1 << 2));
        val |= (self.geometry_guardband_z as u32) << 1;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane0 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane1 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane2 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane3 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane4 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane5 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane6 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetUserClipOpPlane7 {
    Clip = 0x00000000,
    Cull = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetUserClipOp {
    pub plane0: SetUserClipOpPlane0,
    pub plane1: SetUserClipOpPlane1,
    pub plane2: SetUserClipOpPlane2,
    pub plane3: SetUserClipOpPlane3,
    pub plane4: SetUserClipOpPlane4,
    pub plane5: SetUserClipOpPlane5,
    pub plane6: SetUserClipOpPlane6,
    pub plane7: SetUserClipOpPlane7,
}

impl Mthd for SetUserClipOp {
    const ADDR: u16 = 0x1940;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.plane0 as u32) < (1 << 1));
        val |= (self.plane0 as u32) << 0;
            
        assert!((self.plane1 as u32) < (1 << 1));
        val |= (self.plane1 as u32) << 4;
            
        assert!((self.plane2 as u32) < (1 << 1));
        val |= (self.plane2 as u32) << 8;
            
        assert!((self.plane3 as u32) < (1 << 1));
        val |= (self.plane3 as u32) << 12;
            
        assert!((self.plane4 as u32) < (1 << 1));
        val |= (self.plane4 as u32) << 16;
            
        assert!((self.plane5 as u32) < (1 << 1));
        val |= (self.plane5 as u32) << 20;
            
        assert!((self.plane6 as u32) < (1 << 1));
        val |= (self.plane6 as u32) << 24;
            
        assert!((self.plane7 as u32) < (1 << 1));
        val |= (self.plane7 as u32) << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPrimitiveTopologyControlOverride {
    UseTopologyInBeginMethods = 0x00000000,
    UseSeparateTopologyState = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimitiveTopologyControl {
    pub override_: SetPrimitiveTopologyControlOverride,
}

impl Mthd for SetPrimitiveTopologyControl {
    const ADDR: u16 = 0x1948;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.override_ as u32) < (1 << 1));
        val |= (self.override_ as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipEnable {
    pub v: bool,
}

impl Mthd for SetWindowClipEnable {
    const ADDR: u16 = 0x194c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetWindowClipTypeV {
    Inclusive = 0x00000000,
    Exclusive = 0x00000001,
    Clipall = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWindowClipType {
    pub v: SetWindowClipTypeV,
}

impl Mthd for SetWindowClipType {
    const ADDR: u16 = 0x1950;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateZcullV {
    Invalidate = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateZcull {
    pub v: InvalidateZcullV,
}

impl Mthd for InvalidateZcull {
    const ADDR: u16 = 0x1958;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcull {
    pub z_enable: bool,
    pub stencil_enable: bool,
}

impl Mthd for SetZcull {
    const ADDR: u16 = 0x1968;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;
            
        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullBounds {
    pub z_min_unbounded_enable: bool,
    pub z_max_unbounded_enable: bool,
}

impl Mthd for SetZcullBounds {
    const ADDR: u16 = 0x196c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.z_min_unbounded_enable as u32) < (1 << 1));
        val |= (self.z_min_unbounded_enable as u32) << 0;
            
        assert!((self.z_max_unbounded_enable as u32) < (1 << 1));
        val |= (self.z_max_unbounded_enable as u32) << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPrimitiveTopologyV {
    Pointlist = 0x00000001,
    Linelist = 0x00000002,
    Linestrip = 0x00000003,
    Trianglelist = 0x00000004,
    Trianglestrip = 0x00000005,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patchlist = 0x0000000e,
    LegacyPoints = 0x00001001,
    LegacyIndexedlinelist = 0x00001002,
    LegacyIndexedtrianglelist = 0x00001003,
    LegacyLinelist = 0x0000100f,
    LegacyLinestrip = 0x00001010,
    LegacyIndexedlinestrip = 0x00001011,
    LegacyTrianglelist = 0x00001012,
    LegacyTrianglestrip = 0x00001013,
    LegacyIndexedtrianglestrip = 0x00001014,
    LegacyTrianglefan = 0x00001015,
    LegacyIndexedtrianglefan = 0x00001016,
    LegacyTrianglefanImm = 0x00001017,
    LegacyLinelistImm = 0x00001018,
    LegacyIndexedtrianglelist2 = 0x0000101a,
    LegacyIndexedlinelist2 = 0x0000101b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPrimitiveTopology {
    pub v: SetPrimitiveTopologyV,
}

impl Mthd for SetPrimitiveTopology {
    const ADDR: u16 = 0x1970;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 16));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ZcullSync {
    pub v: u32,
}

impl Mthd for ZcullSync {
    const ADDR: u16 = 0x1978;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipIdTest {
    pub enable: bool,
}

impl Mthd for SetClipIdTest {
    const ADDR: u16 = 0x197c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSurfaceClipIdWidth {
    pub v: u32,
}

impl Mthd for SetSurfaceClipIdWidth {
    const ADDR: u16 = 0x1980;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipId {
    pub v: u32,
}

impl Mthd for SetClipId {
    const ADDR: u16 = 0x1984;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDepthBoundsTest {
    pub enable: bool,
}

impl Mthd for SetDepthBoundsTest {
    const ADDR: u16 = 0x19bc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendFloatOption {
    pub zero_times_anything_is_zero: bool,
}

impl Mthd for SetBlendFloatOption {
    const ADDR: u16 = 0x19c0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.zero_times_anything_is_zero as u32) < (1 << 1));
        val |= (self.zero_times_anything_is_zero as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLogicOp {
    pub enable: bool,
}

impl Mthd for SetLogicOp {
    const ADDR: u16 = 0x19c4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetLogicOpFuncV {
    Clear = 0x00001500,
    And = 0x00001501,
    AndReverse = 0x00001502,
    Copy = 0x00001503,
    AndInverted = 0x00001504,
    Noop = 0x00001505,
    Xor = 0x00001506,
    Or = 0x00001507,
    Nor = 0x00001508,
    Equiv = 0x00001509,
    Invert = 0x0000150a,
    OrReverse = 0x0000150b,
    CopyInverted = 0x0000150c,
    OrInverted = 0x0000150d,
    Nand = 0x0000150e,
    Set = 0x0000150f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLogicOpFunc {
    pub v: SetLogicOpFuncV,
}

impl Mthd for SetLogicOpFunc {
    const ADDR: u16 = 0x19c8;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZCompression {
    pub enable: bool,
}

impl Mthd for SetZCompression {
    const ADDR: u16 = 0x19cc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearSurface {
    pub z_enable: bool,
    pub stencil_enable: bool,
    pub r_enable: bool,
    pub g_enable: bool,
    pub b_enable: bool,
    pub a_enable: bool,
    pub mrt_select: u32,
    pub rt_array_index: u32,
}

impl Mthd for ClearSurface {
    const ADDR: u16 = 0x19d0;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;
            
        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 1;
            
        assert!((self.r_enable as u32) < (1 << 1));
        val |= (self.r_enable as u32) << 2;
            
        assert!((self.g_enable as u32) < (1 << 1));
        val |= (self.g_enable as u32) << 3;
            
        assert!((self.b_enable as u32) < (1 << 1));
        val |= (self.b_enable as u32) << 4;
            
        assert!((self.a_enable as u32) < (1 << 1));
        val |= (self.a_enable as u32) << 5;
            
        assert!(self.mrt_select < (1 << 4));
        val |= self.mrt_select << 6;
            
        assert!(self.rt_array_index < (1 << 16));
        val |= self.rt_array_index << 10;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearClipIdSurface {
    pub v: u32,
}

impl Mthd for ClearClipIdSurface {
    const ADDR: u16 = 0x19d4;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorCompression {
    pub enable: bool,
}

impl ArrayMthd for SetColorCompression {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x19e0+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtWrite {
    pub r_enable: bool,
    pub g_enable: bool,
    pub b_enable: bool,
    pub a_enable: bool,
}

impl ArrayMthd for SetCtWrite {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1a00+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.r_enable as u32) < (1 << 1));
        val |= (self.r_enable as u32) << 0;
            
        assert!((self.g_enable as u32) < (1 << 1));
        val |= (self.g_enable as u32) << 4;
            
        assert!((self.b_enable as u32) < (1 << 1));
        val |= (self.b_enable as u32) << 8;
            
        assert!((self.a_enable as u32) < (1 << 1));
        val |= (self.a_enable as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipeNop {
    pub v: u32,
}

impl Mthd for PipeNop {
    const ADDR: u16 = 0x1a2c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare00 {
    pub v: u32,
}

impl Mthd for SetSpare00 {
    const ADDR: u16 = 0x1a30;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare01 {
    pub v: u32,
}

impl Mthd for SetSpare01 {
    const ADDR: u16 = 0x1a34;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare02 {
    pub v: u32,
}

impl Mthd for SetSpare02 {
    const ADDR: u16 = 0x1a38;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare03 {
    pub v: u32,
}

impl Mthd for SetSpare03 {
    const ADDR: u16 = 0x1a3c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetReportSemaphoreA {
    const ADDR: u16 = 0x1b00;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetReportSemaphoreB {
    const ADDR: u16 = 0x1b04;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetReportSemaphoreC {
    const ADDR: u16 = 0x1b08;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;
            
        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;
            
        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;
            
        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;
            
        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;
            
        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;
            
        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;
            
        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;
            
        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;
            
        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;
            
        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;
            
        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamAFormat {
    pub stride: u32,
    pub enable: bool,
}

impl ArrayMthd for SetVertexStreamAFormat {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1c00+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.stride < (1 << 12));
        val |= self.stride << 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamALocationA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetVertexStreamALocationA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1c04+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamALocationB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetVertexStreamALocationB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1c08+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamAFrequency {
    pub v: u32,
}

impl ArrayMthd for SetVertexStreamAFrequency {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1c0c+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBFormat {
    pub stride: u32,
    pub enable: bool,
}

impl ArrayMthd for SetVertexStreamBFormat {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1d00+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.stride < (1 << 12));
        val |= self.stride << 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBLocationA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetVertexStreamBLocationA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1d04+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBLocationB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetVertexStreamBLocationB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1d08+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamBFrequency {
    pub v: u32,
}

impl ArrayMthd for SetVertexStreamBFrequency {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1d0c+i*16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetSeparateForAlpha {
    pub enable: bool,
}

impl ArrayMthd for SetBlendPerTargetSeparateForAlpha {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e00+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorOp {
    pub v: SetBlendPerTargetColorOpV,
}

impl ArrayMthd for SetBlendPerTargetColorOp {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e04+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorSourceCoeff {
    pub v: SetBlendPerTargetColorSourceCoeffV,
}

impl ArrayMthd for SetBlendPerTargetColorSourceCoeff {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e08+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetColorDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetColorDestCoeff {
    pub v: SetBlendPerTargetColorDestCoeffV,
}

impl ArrayMthd for SetBlendPerTargetColorDestCoeff {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e0c+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaOpV {
    OglFuncSubtract = 0x0000800a,
    OglFuncReverseSubtract = 0x0000800b,
    OglFuncAdd = 0x00008006,
    OglMin = 0x00008007,
    OglMax = 0x00008008,
    D3DAdd = 0x00000001,
    D3DSubtract = 0x00000002,
    D3DRevsubtract = 0x00000003,
    D3DMin = 0x00000004,
    D3DMax = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaOp {
    pub v: SetBlendPerTargetAlphaOpV,
}

impl ArrayMthd for SetBlendPerTargetAlphaOp {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e10+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaSourceCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBothsrcalpha = 0x0000000c,
    D3DBothinvsrcalpha = 0x0000000d,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaSourceCoeff {
    pub v: SetBlendPerTargetAlphaSourceCoeffV,
}

impl ArrayMthd for SetBlendPerTargetAlphaSourceCoeff {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e14+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBlendPerTargetAlphaDestCoeffV {
    OglZero = 0x00004000,
    OglOne = 0x00004001,
    OglSrcColor = 0x00004300,
    OglOneMinusSrcColor = 0x00004301,
    OglSrcAlpha = 0x00004302,
    OglOneMinusSrcAlpha = 0x00004303,
    OglDstAlpha = 0x00004304,
    OglOneMinusDstAlpha = 0x00004305,
    OglDstColor = 0x00004306,
    OglOneMinusDstColor = 0x00004307,
    OglSrcAlphaSaturate = 0x00004308,
    OglConstantColor = 0x0000c001,
    OglOneMinusConstantColor = 0x0000c002,
    OglConstantAlpha = 0x0000c003,
    OglOneMinusConstantAlpha = 0x0000c004,
    OglSrc1Color = 0x0000c900,
    OglInvsrc1Color = 0x0000c901,
    OglSrc1Alpha = 0x0000c902,
    OglInvsrc1Alpha = 0x0000c903,
    D3DZero = 0x00000001,
    D3DOne = 0x00000002,
    D3DSrccolor = 0x00000003,
    D3DInvsrccolor = 0x00000004,
    D3DSrcalpha = 0x00000005,
    D3DInvsrcalpha = 0x00000006,
    D3DDestalpha = 0x00000007,
    D3DInvdestalpha = 0x00000008,
    D3DDestcolor = 0x00000009,
    D3DInvdestcolor = 0x0000000a,
    D3DSrcalphasat = 0x0000000b,
    D3DBlendfactor = 0x0000000e,
    D3DInvblendfactor = 0x0000000f,
    D3DSrc1Color = 0x00000010,
    D3DInvsrc1Color = 0x00000011,
    D3DSrc1Alpha = 0x00000012,
    D3DInvsrc1Alpha = 0x00000013,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBlendPerTargetAlphaDestCoeff {
    pub v: SetBlendPerTargetAlphaDestCoeffV,
}

impl ArrayMthd for SetBlendPerTargetAlphaDestCoeff {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1e18+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitAA {
    pub upper: u32,
}

impl ArrayMthd for SetVertexStreamLimitAA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1f00+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitAB {
    pub lower: u32,
}

impl ArrayMthd for SetVertexStreamLimitAB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1f04+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitBA {
    pub upper: u32,
}

impl ArrayMthd for SetVertexStreamLimitBA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1f80+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamLimitBB {
    pub lower: u32,
}

impl ArrayMthd for SetVertexStreamLimitBB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x1f84+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPipelineShaderType {
    VertexCullBeforeFetch = 0x00000000,
    Vertex = 0x00000001,
    TessellationInit = 0x00000002,
    Tessellation = 0x00000003,
    Geometry = 0x00000004,
    Pixel = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineShader {
    pub enable: bool,
    pub type_: SetPipelineShaderType,
}

impl ArrayMthd for SetPipelineShader {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2000+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;
            
        assert!((self.type_ as u32) < (1 << 4));
        val |= (self.type_ as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineProgram {
    pub offset: u32,
}

impl ArrayMthd for SetPipelineProgram {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2004+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedA {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2008+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineRegisterCount {
    pub v: u32,
}

impl ArrayMthd for SetPipelineRegisterCount {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x200c+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineBinding {
    pub group: u32,
}

impl ArrayMthd for SetPipelineBinding {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2010+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.group < (1 << 3));
        val |= self.group << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedB {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2014+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedC {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedC {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2018+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedD {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedD {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x201c+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedE {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedE {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2020+i*64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x2300;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x2304;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x2308;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x230c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x2310;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x2314;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x2318;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x231c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x2320;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x2324;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x2328;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x232c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x2330;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x2334;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x2338;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x233c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x2340;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x2344;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x2348;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x234c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x2350;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x2354;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x2358;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x235c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x2360;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x2364;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x2368;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x236c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x2370;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x2374;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x2378;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x237c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorA {
    pub size: u32,
}

impl Mthd for SetConstantBufferSelectorA {
    const ADDR: u16 = 0x2380;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size < (1 << 17));
        val |= self.size << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorB {
    pub address_upper: u32,
}

impl Mthd for SetConstantBufferSelectorB {
    const ADDR: u16 = 0x2384;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorC {
    pub address_lower: u32,
}

impl Mthd for SetConstantBufferSelectorC {
    const ADDR: u16 = 0x2388;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBufferOffset {
    pub v: u32,
}

impl Mthd for LoadConstantBufferOffset {
    const ADDR: u16 = 0x238c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBuffer {
    pub v: u32,
}

impl ArrayMthd for LoadConstantBuffer {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2390+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedA {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2400+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedB {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2404+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedC {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedC {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2408+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedD {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedD {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x240c+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupConstantBuffer {
    pub valid: bool,
    pub shader_slot: u32,
}

impl ArrayMthd for BindGroupConstantBuffer {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x2410+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.shader_slot < (1 << 5));
        val |= self.shader_slot << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorClamp {
    pub enable: bool,
}

impl Mthd for SetColorClamp {
    const ADDR: u16 = 0x2600;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NoopXXXSetValveHigherPriority {
    Compute = 0x00000000,
    Graphics = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoopXXXSetValve {
    pub higher_priority: NoopXXXSetValveHigherPriority,
}

impl Mthd for NoopXXXSetValve {
    const ADDR: u16 = 0x2604;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.higher_priority as u32) < (1 << 1));
        val |= (self.higher_priority as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindlessTexture {
    pub constant_buffer_slot_select: u32,
}

impl Mthd for SetBindlessTexture {
    const ADDR: u16 = 0x2608;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.constant_buffer_slot_select < (1 << 5));
        val |= self.constant_buffer_slot_select << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandler {
    pub offset: u32,
}

impl Mthd for SetTrapHandler {
    const ADDR: u16 = 0x260c;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValue {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x335c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterEvent {
    pub event: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterEvent {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x337c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event < (1 << 8));
        val |= self.event << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
    pub event4: u32,
    pub bit_select4: u32,
    pub event5: u32,
    pub bit_select5: u32,
    pub spare: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x339c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event0 < (1 << 2));
        val |= self.event0 << 0;
            
        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 2;
            
        assert!(self.event1 < (1 << 2));
        val |= self.event1 << 5;
            
        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 7;
            
        assert!(self.event2 < (1 << 2));
        val |= self.event2 << 10;
            
        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 12;
            
        assert!(self.event3 < (1 << 2));
        val |= self.event3 << 15;
            
        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 17;
            
        assert!(self.event4 < (1 << 2));
        val |= self.event4 << 20;
            
        assert!(self.bit_select4 < (1 << 3));
        val |= self.bit_select4 << 22;
            
        assert!(self.event5 < (1 << 2));
        val |= self.event5 << 25;
            
        assert!(self.bit_select5 < (1 << 3));
        val |= self.bit_select5 << 27;
            
        assert!(self.spare < (1 << 2));
        val |= self.spare << 30;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub mode: u32,
    pub windowed: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x33bc+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;
            
        assert!(self.mode < (1 << 2));
        val |= self.mode << 1;
            
        assert!(self.windowed < (1 << 1));
        val |= self.windowed << 3;
            
        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterTrapControl {
    pub mask: u32,
}

impl Mthd for SetShaderPerformanceCounterTrapControl {
    const ADDR: u16 = 0x33dc;
    const CLASS: u16 = 0xa097;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.mask < (1 << 8));
        val |= self.mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x3800+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        
        (0x3804+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
