#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const FERMI_COMPUTE_A: u32 = 0x90C0;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER: u32 = 0x0114;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM: u32 = 0x0118;
pub const LOAD_MME_INSTRUCTION_RAM_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER: u32 = 0x011c;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM: u32 = 0x0120;
pub const LOAD_MME_START_ADDRESS_RAM_V: Range<u32> = 0..32;
pub const SET_MME_SHADOW_RAM_CONTROL: u32 = 0x0124;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE: Range<u32> = 0..2;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK: u32 = 0x00000000;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER: u32 = 0x00000001;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH: u32 = 0x00000002;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_LOW_SIZE: u32 = 0x0204;
pub const SET_SHADER_LOCAL_MEMORY_LOW_SIZE_V: Range<u32> = 0..24;
pub const SET_SHADER_LOCAL_MEMORY_HIGH_SIZE: u32 = 0x0208;
pub const SET_SHADER_LOCAL_MEMORY_HIGH_SIZE_V: Range<u32> = 0..24;
pub const SET_SHADER_LOCAL_MEMORY_CRS_SIZE: u32 = 0x020c;
pub const SET_SHADER_LOCAL_MEMORY_CRS_SIZE_V: Range<u32> = 0..21;
pub const SET_BINDING_CONTROL_TEXTURE: u32 = 0x0210;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS: Range<u32> = 0..4;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__1: u32 = 0x00000000;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__2: u32 = 0x00000001;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__4: u32 = 0x00000002;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__8: u32 = 0x00000003;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_SAMPLERS__16: u32 = 0x00000004;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS: Range<u32> = 4..8;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__1: u32 = 0x00000000;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__2: u32 = 0x00000001;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__4: u32 = 0x00000002;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__8: u32 = 0x00000003;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__16: u32 = 0x00000004;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__32: u32 = 0x00000005;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__64: u32 = 0x00000006;
pub const SET_BINDING_CONTROL_TEXTURE_MAX_ACTIVE_HEADERS__128: u32 = 0x00000007;
pub const SET_SHADER_SHARED_MEMORY_WINDOW: u32 = 0x0214;
pub const SET_SHADER_SHARED_MEMORY_WINDOW_BASE_ADDRESS: Range<u32> = 0..32;
pub const INVALIDATE_SHADER_CACHES: u32 = 0x021c;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_UNIFORM: Range<u32> = 8..9;
pub const INVALIDATE_SHADER_CACHES_UNIFORM_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_UNIFORM_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_CONSTANT_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_LOCKS: Range<u32> = 1..2;
pub const INVALIDATE_SHADER_CACHES_LOCKS_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_LOCKS_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA: Range<u32> = 2..3;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE: u32 = 0x00000001;
pub const BIND_TEXTURE_SAMPLER: u32 = 0x0228;
pub const BIND_TEXTURE_SAMPLER_VALID: Range<u32> = 0..1;
pub const BIND_TEXTURE_SAMPLER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_TEXTURE_SAMPLER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_TEXTURE_SAMPLER_SAMPLER_SLOT: Range<u32> = 4..12;
pub const BIND_TEXTURE_SAMPLER_INDEX: Range<u32> = 12..25;
pub const BIND_TEXTURE_HEADER: u32 = 0x022c;
pub const BIND_TEXTURE_HEADER_VALID: Range<u32> = 0..1;
pub const BIND_TEXTURE_HEADER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_TEXTURE_HEADER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_TEXTURE_HEADER_TEXTURE_SLOT: Range<u32> = 1..9;
pub const BIND_TEXTURE_HEADER_INDEX: Range<u32> = 9..31;
pub const BIND_EXTRA_TEXTURE_SAMPLER: u32 = 0x0230;
pub const BIND_EXTRA_TEXTURE_SAMPLER_VALID: Range<u32> = 0..1;
pub const BIND_EXTRA_TEXTURE_SAMPLER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_EXTRA_TEXTURE_SAMPLER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_EXTRA_TEXTURE_SAMPLER_SAMPLER_SLOT: Range<u32> = 4..12;
pub const BIND_EXTRA_TEXTURE_SAMPLER_INDEX: Range<u32> = 12..25;
pub const BIND_EXTRA_TEXTURE_HEADER: u32 = 0x0234;
pub const BIND_EXTRA_TEXTURE_HEADER_VALID: Range<u32> = 0..1;
pub const BIND_EXTRA_TEXTURE_HEADER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_EXTRA_TEXTURE_HEADER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_EXTRA_TEXTURE_HEADER_TEXTURE_SLOT: Range<u32> = 1..9;
pub const BIND_EXTRA_TEXTURE_HEADER_INDEX: Range<u32> = 9..31;
pub const SET_CTA_RASTER_SIZE_A: u32 = 0x0238;
pub const SET_CTA_RASTER_SIZE_A_WIDTH: Range<u32> = 0..16;
pub const SET_CTA_RASTER_SIZE_A_HEIGHT: Range<u32> = 16..32;
pub const SET_CTA_RASTER_SIZE_B: u32 = 0x023c;
pub const SET_CTA_RASTER_SIZE_B_DEPTH: Range<u32> = 0..16;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI: u32 = 0x0244;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const SET_SHADER_SHARED_MEMORY_SIZE: u32 = 0x024c;
pub const SET_SHADER_SHARED_MEMORY_SIZE_V: Range<u32> = 0..18;
pub const SET_CTA_THREAD_COUNT: u32 = 0x0250;
pub const SET_CTA_THREAD_COUNT_V: Range<u32> = 0..16;
pub const SET_CTA_BARRIER_COUNT: u32 = 0x0254;
pub const SET_CTA_BARRIER_COUNT_V: Range<u32> = 0..8;
pub const TEST_FOR_COMPUTE: u32 = 0x028c;
pub const TEST_FOR_COMPUTE_V: Range<u32> = 0..32;
pub const BEGIN_GRID: u32 = 0x029c;
pub const BEGIN_GRID_V: Range<u32> = 0..1;
pub const SET_WORK_DISTRIBUTION: u32 = 0x02a0;
pub const SET_WORK_DISTRIBUTION_MAX_BATCH_SIZE: Range<u32> = 13..17;
pub const SET_WORK_DISTRIBUTION_FIXED_MODE: Range<u32> = 4..5;
pub const SET_WORK_DISTRIBUTION_FIXED_MODE_FALSE: u32 = 0x00000000;
pub const SET_WORK_DISTRIBUTION_FIXED_MODE_TRUE: u32 = 0x00000001;
pub const SET_WORK_DISTRIBUTION_MAX_STANDBY_CTAS: Range<u32> = 5..13;
pub const SET_CTA_REGISTER_COUNT: u32 = 0x02c0;
pub const SET_CTA_REGISTER_COUNT_V: Range<u32> = 0..8;
pub const SET_GA_TO_VA_MAPPING_MODE: u32 = 0x02c4;
pub const SET_GA_TO_VA_MAPPING_MODE_V: Range<u32> = 0..1;
pub const SET_GA_TO_VA_MAPPING_MODE_V_DISABLE: u32 = 0x00000000;
pub const SET_GA_TO_VA_MAPPING_MODE_V_ENABLE: u32 = 0x00000001;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY: u32 = 0x02c8;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_VIRTUAL_ADDRESS_UPPER: Range<u32> = 0..8;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_GENERIC_ADDRESS_UPPER: Range<u32> = 16..24;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE: Range<u32> = 30..31;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_FALSE: u32 = 0x00000000;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_READ_ENABLE_TRUE: u32 = 0x00000001;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE: Range<u32> = 31..32;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_FALSE: u32 = 0x00000000;
pub const LOAD_GA_TO_VA_MAPPING_ENTRY_WRITE_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_L1_CONFIGURATION: u32 = 0x0308;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY: Range<u32> = 0..3;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB: u32 = 0x00000001;
pub const SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_CONTROL: u32 = 0x030c;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER: Range<u32> = 0..1;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE: u32 = 0x00000001;
pub const WAIT_REF_COUNT: u32 = 0x0360;
pub const WAIT_REF_COUNT_REF_CNT: Range<u32> = 8..10;
pub const WAIT_REF_COUNT_FLUSH_SYS_MEM: Range<u32> = 0..1;
pub const WAIT_REF_COUNT_FLUSH_SYS_MEM_FALSE: u32 = 0x00000000;
pub const WAIT_REF_COUNT_FLUSH_SYS_MEM_TRUE: u32 = 0x00000001;
pub const LAUNCH: u32 = 0x0368;
pub const LAUNCHCTA_PARAM: Range<u32> = 0..32;
pub const SET_LAUNCH_ID: u32 = 0x036c;
pub const SET_LAUNCH_ID_REF_CNT: Range<u32> = 0..2;
pub const SET_CTA_THREAD_DIMENSION_A: u32 = 0x03ac;
pub const SET_CTA_THREAD_DIMENSION_A_D0: Range<u32> = 0..16;
pub const SET_CTA_THREAD_DIMENSION_A_D1: Range<u32> = 16..32;
pub const SET_CTA_THREAD_DIMENSION_B: u32 = 0x03b0;
pub const SET_CTA_THREAD_DIMENSION_B_D2: Range<u32> = 0..16;
pub const SET_CTA_PROGRAM_START: u32 = 0x03b4;
pub const SET_CTA_PROGRAM_START_OFFSET: Range<u32> = 0..32;
pub const SET_FALCON00: u32 = 0x0500;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x0504;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x0508;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x050c;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x0510;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x0514;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x0518;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x051c;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x0520;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x0524;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x0528;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x052c;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x0530;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x0534;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x0538;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x053c;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x0540;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x0544;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x0548;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x054c;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x0550;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x0554;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x0558;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x055c;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x0560;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x0564;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x0568;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x056c;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x0570;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x0574;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x0578;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x057c;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const SET_MAX_SM_COUNT: u32 = 0x0758;
pub const SET_MAX_SM_COUNT_V: Range<u32> = 0..9;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW: u32 = 0x077c;
pub const SET_SHADER_LOCAL_MEMORY_WINDOW_BASE_ADDRESS: Range<u32> = 0..32;
pub const SET_GRID_PARAM: u32 = 0x0780;
pub const SET_GRID_PARAM_V: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_A: u32 = 0x0790;
pub const SET_SHADER_LOCAL_MEMORY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_SHADER_LOCAL_MEMORY_B: u32 = 0x0794;
pub const SET_SHADER_LOCAL_MEMORY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_C: u32 = 0x0798;
pub const SET_SHADER_LOCAL_MEMORY_C_SIZE_UPPER: Range<u32> = 0..6;
pub const SET_SHADER_LOCAL_MEMORY_D: u32 = 0x079c;
pub const SET_SHADER_LOCAL_MEMORY_D_SIZE_LOWER: Range<u32> = 0..32;
pub const SET_SHADER_LOCAL_MEMORY_E: u32 = 0x07a0;
pub const SET_SHADER_LOCAL_MEMORY_E_DEFAULT_SIZE_PER_WARP: Range<u32> = 0..26;
pub const END_GRID: u32 = 0x0a04;
pub const END_GRID_V: Range<u32> = 0..1;
pub const SET_LAUNCH_SIZE: u32 = 0x0a08;
pub const SET_LAUNCH_SIZE_V: Range<u32> = 0..32;
pub const SET_API_VISIBLE_CALL_LIMIT: u32 = 0x0d64;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA: Range<u32> = 0..4;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__0: u32 = 0x00000000;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__1: u32 = 0x00000001;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__2: u32 = 0x00000002;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__4: u32 = 0x00000003;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__8: u32 = 0x00000004;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__16: u32 = 0x00000005;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__32: u32 = 0x00000006;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__64: u32 = 0x00000007;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA__128: u32 = 0x00000008;
pub const SET_API_VISIBLE_CALL_LIMIT_CTA_NO_CHECK: u32 = 0x0000000F;
pub const SET_SHADER_CACHE_CONTROL: u32 = 0x0d94;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SM_TIMEOUT_INTERVAL: u32 = 0x0de4;
pub const SET_SM_TIMEOUT_INTERVAL_COUNTER_BIT: Range<u32> = 0..6;
pub const SET_SPARE_NOOP12: u32 = 0x0f44;
pub const SET_SPARE_NOOP12_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP13: u32 = 0x0f48;
pub const SET_SPARE_NOOP13_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP14: u32 = 0x0f4c;
pub const SET_SPARE_NOOP14_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP15: u32 = 0x0f50;
pub const SET_SPARE_NOOP15_V: Range<u32> = 0..32;
pub const SET_FORCE_ONE_TEXTURE_UNIT: u32 = 0x1004;
pub const SET_FORCE_ONE_TEXTURE_UNIT_ENABLE: Range<u32> = 0..1;
pub const SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_FORCE_ONE_TEXTURE_UNIT_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SPARE_NOOP00: u32 = 0x1040;
pub const SET_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP01: u32 = 0x1044;
pub const SET_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP02: u32 = 0x1048;
pub const SET_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP03: u32 = 0x104c;
pub const SET_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP04: u32 = 0x1050;
pub const SET_SPARE_NOOP04_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP05: u32 = 0x1054;
pub const SET_SPARE_NOOP05_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP06: u32 = 0x1058;
pub const SET_SPARE_NOOP06_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP07: u32 = 0x105c;
pub const SET_SPARE_NOOP07_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP08: u32 = 0x1060;
pub const SET_SPARE_NOOP08_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP09: u32 = 0x1064;
pub const SET_SPARE_NOOP09_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP10: u32 = 0x1068;
pub const SET_SPARE_NOOP10_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP11: u32 = 0x106c;
pub const SET_SPARE_NOOP11_V: Range<u32> = 0..32;
pub const UNBIND_ALL: u32 = 0x10f4;
pub const UNBIND_ALL_TEXTURE_HEADERS: Range<u32> = 0..1;
pub const UNBIND_ALL_TEXTURE_HEADERS_FALSE: u32 = 0x00000000;
pub const UNBIND_ALL_TEXTURE_HEADERS_TRUE: u32 = 0x00000001;
pub const UNBIND_ALL_TEXTURE_SAMPLERS: Range<u32> = 4..5;
pub const UNBIND_ALL_TEXTURE_SAMPLERS_FALSE: u32 = 0x00000000;
pub const UNBIND_ALL_TEXTURE_SAMPLERS_TRUE: u32 = 0x00000001;
pub const UNBIND_ALL_CONSTANT_BUFFERS: Range<u32> = 8..9;
pub const UNBIND_ALL_CONSTANT_BUFFERS_FALSE: u32 = 0x00000000;
pub const UNBIND_ALL_CONSTANT_BUFFERS_TRUE: u32 = 0x00000001;
pub const SET_SAMPLER_BINDING: u32 = 0x1234;
pub const SET_SAMPLER_BINDING_V: Range<u32> = 0..1;
pub const SET_SAMPLER_BINDING_V_INDEPENDENTLY: u32 = 0x00000000;
pub const SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI: u32 = 0x1288;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const SET_SHADER_SCHEDULING: u32 = 0x12ac;
pub const SET_SHADER_SCHEDULING_MODE: Range<u32> = 0..1;
pub const SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST: u32 = 0x00000000;
pub const SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE: u32 = 0x1330;
pub const INVALIDATE_SAMPLER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_HEADER_CACHE: u32 = 0x1334;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_HEADER_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_DATA_CACHE: u32 = 0x1338;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES: Range<u32> = 0..1;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_TEXTURE_DATA_CACHE_TAG: Range<u32> = 4..26;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LEVELS: Range<u32> = 1..3;
pub const INVALIDATE_TEXTURE_DATA_CACHE_LEVELS_L1_ONLY: u32 = 0x00000000;
pub const SET_GLOBAL_COLOR_KEY: u32 = 0x1354;
pub const SET_GLOBAL_COLOR_KEY_ENABLE: Range<u32> = 0..1;
pub const SET_GLOBAL_COLOR_KEY_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_COLOR_KEY_ENABLE_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI: u32 = 0x1424;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES: Range<u32> = 0..1;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL: u32 = 0x00000000;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE: u32 = 0x00000001;
pub const INVALIDATE_SAMPLER_CACHE_NO_WFI_TAG: Range<u32> = 4..26;
pub const PERFMON_TRANSFER: u32 = 0x1524;
pub const PERFMON_TRANSFER_V: Range<u32> = 0..32;
pub const SET_SHADER_EXCEPTIONS: u32 = 0x1528;
pub const SET_SHADER_EXCEPTIONS_ENABLE: Range<u32> = 0..1;
pub const SET_SHADER_EXCEPTIONS_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_SHADER_EXCEPTIONS_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_A: u32 = 0x1550;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x1554;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x1558;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_TEX_SAMPLER_POOL_A: u32 = 0x155c;
pub const SET_TEX_SAMPLER_POOL_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_TEX_SAMPLER_POOL_B: u32 = 0x1560;
pub const SET_TEX_SAMPLER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_SAMPLER_POOL_C: u32 = 0x1564;
pub const SET_TEX_SAMPLER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..20;
pub const SET_TEX_HEADER_POOL_A: u32 = 0x1574;
pub const SET_TEX_HEADER_POOL_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_TEX_HEADER_POOL_B: u32 = 0x1578;
pub const SET_TEX_HEADER_POOL_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_TEX_HEADER_POOL_C: u32 = 0x157c;
pub const SET_TEX_HEADER_POOL_C_MAXIMUM_INDEX: Range<u32> = 0..22;
pub const SET_PROGRAM_REGION_A: u32 = 0x1608;
pub const SET_PROGRAM_REGION_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_PROGRAM_REGION_B: u32 = 0x160c;
pub const SET_PROGRAM_REGION_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const SET_CUBEMAP_INTER_FACE_FILTERING: u32 = 0x1664;
pub const SET_CUBEMAP_INTER_FACE_FILTERING_MODE: Range<u32> = 0..2;
pub const SET_CUBEMAP_INTER_FACE_FILTERING_MODE_USE_WRAP: u32 = 0x00000000;
pub const SET_CUBEMAP_INTER_FACE_FILTERING_MODE_OVERRIDE_WRAP: u32 = 0x00000001;
pub const SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_SPAN_SEAM: u32 = 0x00000002;
pub const SET_CUBEMAP_INTER_FACE_FILTERING_MODE_AUTO_CROSS_SEAM: u32 = 0x00000003;
pub const SET_SHADER_CONTROL: u32 = 0x1690;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL: Range<u32> = 0..1;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO: u32 = 0x00000000;
pub const SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY: u32 = 0x00000001;
pub const SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO: Range<u32> = 16..17;
pub const SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE: u32 = 0x00000000;
pub const SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE: u32 = 0x00000001;
pub const BIND_CONSTANT_BUFFER: u32 = 0x1694;
pub const BIND_CONSTANT_BUFFER_VALID: Range<u32> = 0..1;
pub const BIND_CONSTANT_BUFFER_VALID_FALSE: u32 = 0x00000000;
pub const BIND_CONSTANT_BUFFER_VALID_TRUE: u32 = 0x00000001;
pub const BIND_CONSTANT_BUFFER_SHADER_SLOT: Range<u32> = 8..13;
pub const INVALIDATE_SHADER_CACHES_NO_WFI: u32 = 0x1698;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION: Range<u32> = 0..1;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA: Range<u32> = 4..5;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM: Range<u32> = 8..9;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_UNIFORM_TRUE: u32 = 0x00000001;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT: Range<u32> = 12..13;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE: u32 = 0x00000000;
pub const INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE: u32 = 0x00000001;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE: u32 = 0x1930;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2: Range<u32> = 0..1;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE: u32 = 0x00000000;
pub const INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x1944;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
pub const PIPE_NOP: u32 = 0x1a2c;
pub const PIPE_NOP_V: Range<u32> = 0..32;
pub const SET_SPARE00: u32 = 0x1a30;
pub const SET_SPARE00_V: Range<u32> = 0..32;
pub const SET_SPARE01: u32 = 0x1a34;
pub const SET_SPARE01_V: Range<u32> = 0..32;
pub const SET_SPARE02: u32 = 0x1a38;
pub const SET_SPARE02_V: Range<u32> = 0..32;
pub const SET_SPARE03: u32 = 0x1a3c;
pub const SET_SPARE03_V: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_A: u32 = 0x1b00;
pub const SET_REPORT_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_REPORT_SEMAPHORE_B: u32 = 0x1b04;
pub const SET_REPORT_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_C: u32 = 0x1b08;
pub const SET_REPORT_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_REPORT_SEMAPHORE_D: u32 = 0x1b0c;
pub const SET_REPORT_SEMAPHORE_D_OPERATION: Range<u32> = 0..2;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_OPERATION_TRAP: u32 = 0x00000003;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE: Range<u32> = 20..21;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE: Range<u32> = 28..29;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD: u32 = 0x00000001;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE: Range<u32> = 2..3;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE: u32 = 0x00000000;
pub const SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE: u32 = 0x00000001;
pub const SET_CONSTANT_BUFFER_SELECTOR_A: u32 = 0x2380;
pub const SET_CONSTANT_BUFFER_SELECTOR_A_SIZE: Range<u32> = 0..17;
pub const SET_CONSTANT_BUFFER_SELECTOR_B: u32 = 0x2384;
pub const SET_CONSTANT_BUFFER_SELECTOR_B_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_CONSTANT_BUFFER_SELECTOR_C: u32 = 0x2388;
pub const SET_CONSTANT_BUFFER_SELECTOR_C_ADDRESS_LOWER: Range<u32> = 0..32;
pub const LOAD_CONSTANT_BUFFER_OFFSET: u32 = 0x238c;
pub const LOAD_CONSTANT_BUFFER_OFFSET_V: Range<u32> = 0..16;
#[inline]
pub fn load_constant_buffer  (i: u32) -> u32 { 0x2390+i*4 } 
pub const LOAD_CONSTANT_BUFFER_V: Range<u32> = 0..32;
#[inline]
pub fn set_su_ld_st_target_a  (j: u32) -> u32 { 0x2700+j*32 } 
pub const SET_SU_LD_ST_TARGET_A_OFFSET_UPPER: Range<u32> = 0..8;
#[inline]
pub fn set_su_ld_st_target_b  (j: u32) -> u32 { 0x2704+j*32 } 
pub const SET_SU_LD_ST_TARGET_B_OFFSET_LOWER: Range<u32> = 0..32;
#[inline]
pub fn set_su_ld_st_target_c  (j: u32) -> u32 { 0x2708+j*32 } 
pub const SET_SU_LD_ST_TARGET_C_WIDTH: Range<u32> = 0..32;
#[inline]
pub fn set_su_ld_st_target_d  (j: u32) -> u32 { 0x270c+j*32 } 
pub const SET_SU_LD_ST_TARGET_D_HEIGHT: Range<u32> = 0..17;
pub const SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY: Range<u32> = 20..21;
pub const SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_BLOCKLINEAR: u32 = 0x00000000;
pub const SET_SU_LD_ST_TARGET_D_LAYOUT_IN_MEMORY_PITCH: u32 = 0x00000001;
#[inline]
pub fn set_su_ld_st_target_format  (j: u32) -> u32 { 0x2710+j*32 } 
pub const SET_SU_LD_ST_TARGET_FORMAT_TYPE: Range<u32> = 0..1;
pub const SET_SU_LD_ST_TARGET_FORMAT_TYPE_COLOR: u32 = 0x00000000;
pub const SET_SU_LD_ST_TARGET_FORMAT_TYPE_ZETA: u32 = 0x00000001;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR: Range<u32> = 4..12;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_DISABLED: u32 = 0x00000000;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_AF32: u32 = 0x000000C0;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_AS32: u32 = 0x000000C1;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_AU32: u32 = 0x000000C2;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32_BF32_X32: u32 = 0x000000C3;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32_BS32_X32: u32 = 0x000000C4;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32_BU32_X32: u32 = 0x000000C5;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16_B16_A16: u32 = 0x000000C6;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16_BN16_AN16: u32 = 0x000000C7;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16_BS16_AS16: u32 = 0x000000C8;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16_BU16_AU16: u32 = 0x000000C9;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_AF16: u32 = 0x000000CA;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_GF32: u32 = 0x000000CB;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32_GS32: u32 = 0x000000CC;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32_GU32: u32 = 0x000000CD;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16_BF16_X16: u32 = 0x000000CE;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8G8B8: u32 = 0x000000CF;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8RL8GL8BL8: u32 = 0x000000D0;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2B10G10R10: u32 = 0x000000D1;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU2BU10GU10RU10: u32 = 0x000000D2;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8B8G8R8: u32 = 0x000000D5;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8BL8GL8RL8: u32 = 0x000000D6;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AN8BN8GN8RN8: u32 = 0x000000D7;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AS8BS8GS8RS8: u32 = 0x000000D8;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AU8BU8GU8RU8: u32 = 0x000000D9;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_G16: u32 = 0x000000DA;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16_GN16: u32 = 0x000000DB;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16_GS16: u32 = 0x000000DC;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16_GU16: u32 = 0x000000DD;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_GF16: u32 = 0x000000DE;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A2R10G10B10: u32 = 0x000000DF;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_BF10GF11RF11: u32 = 0x000000E0;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS32: u32 = 0x000000E3;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU32: u32 = 0x000000E4;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32: u32 = 0x000000E5;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8R8G8B8: u32 = 0x000000E6;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8RL8GL8BL8: u32 = 0x000000E7;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R5G6B5: u32 = 0x000000E8;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A1R5G5B5: u32 = 0x000000E9;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_G8R8: u32 = 0x000000EA;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_GN8RN8: u32 = 0x000000EB;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_GS8RS8: u32 = 0x000000EC;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_GU8RU8: u32 = 0x000000ED;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16: u32 = 0x000000EE;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN16: u32 = 0x000000EF;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS16: u32 = 0x000000F0;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU16: u32 = 0x000000F1;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16: u32 = 0x000000F2;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R8: u32 = 0x000000F3;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RN8: u32 = 0x000000F4;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RS8: u32 = 0x000000F5;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RU8: u32 = 0x000000F6;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8: u32 = 0x000000F7;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_X1R5G5B5: u32 = 0x000000F8;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8B8G8R8: u32 = 0x000000F9;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_X8BL8GL8RL8: u32 = 0x000000FA;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_O1R5G5B5: u32 = 0x000000FC;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_O8R8G8B8: u32 = 0x000000FE;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R32: u32 = 0x000000FF;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A16: u32 = 0x00000040;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF16: u32 = 0x00000041;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_AF32: u32 = 0x00000042;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_A8R8: u32 = 0x00000043;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_R16_A16: u32 = 0x00000044;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF16_AF16: u32 = 0x00000045;
pub const SET_SU_LD_ST_TARGET_FORMAT_COLOR_RF32_AF32: u32 = 0x00000046;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA: Range<u32> = 12..17;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z16: u32 = 0x00000013;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_Z24S8: u32 = 0x00000014;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24: u32 = 0x00000015;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_S8Z24: u32 = 0x00000016;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_V8Z24: u32 = 0x00000018;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32: u32 = 0x0000000A;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X24S8: u32 = 0x00000019;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_X8Z24_X16V8S8: u32 = 0x0000001D;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8X8: u32 = 0x0000001E;
pub const SET_SU_LD_ST_TARGET_FORMAT_ZETA_ZF32_X16V8S8: u32 = 0x0000001F;
pub const SET_SU_LD_ST_TARGET_FORMAT_SUQ_PIXFMT: Range<u32> = 17..26;
#[inline]
pub fn set_su_ld_st_target_block_size  (j: u32) -> u32 { 0x2714+j*32 } 
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SU_LD_ST_TARGET_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
#[inline]
pub fn set_shader_performance_counter_value  (i: u32) -> u32 { 0x335c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_VALUE_V: Range<u32> = 0..32;
#[inline]
pub fn set_shader_performance_counter_event  (i: u32) -> u32 { 0x337c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_EVENT_EVENT: Range<u32> = 0..8;
#[inline]
pub fn set_shader_performance_counter_control_a  (i: u32) -> u32 { 0x339c+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT0: Range<u32> = 0..3;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT0: Range<u32> = 4..7;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT1: Range<u32> = 8..11;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT1: Range<u32> = 12..15;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT2: Range<u32> = 16..19;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT2: Range<u32> = 20..23;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT3: Range<u32> = 24..27;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT3: Range<u32> = 28..31;
#[inline]
pub fn set_shader_performance_counter_control_b  (i: u32) -> u32 { 0x33bc+i*4 } 
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_EDGE: Range<u32> = 0..1;
pub const SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_FUNC: Range<u32> = 4..20;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL: u32 = 0x33dc;
pub const SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL_MASK: Range<u32> = 0..8;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_macro  (j: u32) -> u32 { 0x3800+j*8 } 
pub const CALL_MME_MACRO_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_data  (j: u32) -> u32 { 0x3804+j*8 } 
pub const CALL_MME_DATA_V: Range<u32> = 0..32;

// parsed class NV90C0




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryLowSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryLowSize {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 24));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryHighSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryHighSize {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 24));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryCrsSize {
    pub v: u32,
}

impl Mthd for SetShaderLocalMemoryCrsSize {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 21));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveSamplers {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetBindingControlTextureMaxActiveHeaders {
    _1 = 0x00000000,
    _2 = 0x00000001,
    _4 = 0x00000002,
    _8 = 0x00000003,
    _16 = 0x00000004,
    _32 = 0x00000005,
    _64 = 0x00000006,
    _128 = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindingControlTexture {
    pub max_active_samplers: SetBindingControlTextureMaxActiveSamplers,
    pub max_active_headers: SetBindingControlTextureMaxActiveHeaders,
}

impl Mthd for SetBindingControlTexture {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.max_active_samplers as u32) < (1 << 4));
        val |= (self.max_active_samplers as u32) << 0;
            
        assert!((self.max_active_headers as u32) < (1 << 4));
        val |= (self.max_active_headers as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderSharedMemoryWindow {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.base_address;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub uniform: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;
            
        assert!((self.uniform as u32) < (1 << 1));
        val |= (self.uniform as u32) << 8;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;
            
        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;
            
        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl Mthd for BindTextureSampler {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;
            
        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl Mthd for BindTextureHeader {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;
            
        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindExtraTextureSampler {
    pub valid: bool,
    pub sampler_slot: u32,
    pub index: u32,
}

impl Mthd for BindExtraTextureSampler {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.sampler_slot < (1 << 8));
        val |= self.sampler_slot << 4;
            
        assert!(self.index < (1 << 13));
        val |= self.index << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindExtraTextureHeader {
    pub valid: bool,
    pub texture_slot: u32,
    pub index: u32,
}

impl Mthd for BindExtraTextureHeader {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.texture_slot < (1 << 8));
        val |= self.texture_slot << 1;
            
        assert!(self.index < (1 << 22));
        val |= self.index << 9;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRasterSizeA {
    pub width: u32,
    pub height: u32,
}

impl Mthd for SetCtaRasterSizeA {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.width < (1 << 16));
        val |= self.width << 0;
            
        assert!(self.height < (1 << 16));
        val |= self.height << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRasterSizeB {
    pub depth: u32,
}

impl Mthd for SetCtaRasterSizeB {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.depth < (1 << 16));
        val |= self.depth << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheNoWfi {
    pub lines: InvalidateTextureHeaderCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCacheNoWfi {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemorySize {
    pub v: u32,
}

impl Mthd for SetShaderSharedMemorySize {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 18));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadCount {
    pub v: u32,
}

impl Mthd for SetCtaThreadCount {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaBarrierCount {
    pub v: u32,
}

impl Mthd for SetCtaBarrierCount {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct TestForCompute {
    pub v: u32,
}

impl Mthd for TestForCompute {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BeginGrid {
    pub v: u32,
}

impl Mthd for BeginGrid {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWorkDistribution {
    pub max_batch_size: u32,
    pub fixed_mode: bool,
    pub max_standby_ctas: u32,
}

impl Mthd for SetWorkDistribution {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.max_batch_size < (1 << 4));
        val |= self.max_batch_size << 13;
            
        assert!((self.fixed_mode as u32) < (1 << 1));
        val |= (self.fixed_mode as u32) << 4;
            
        assert!(self.max_standby_ctas < (1 << 8));
        val |= self.max_standby_ctas << 5;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaRegisterCount {
    pub v: u32,
}

impl Mthd for SetCtaRegisterCount {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGaToVaMappingModeV {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGaToVaMappingMode {
    pub v: SetGaToVaMappingModeV,
}

impl Mthd for SetGaToVaMappingMode {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadGaToVaMappingEntry {
    pub virtual_address_upper: u32,
    pub generic_address_upper: u32,
    pub read_enable: bool,
    pub write_enable: bool,
}

impl Mthd for LoadGaToVaMappingEntry {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.virtual_address_upper < (1 << 8));
        val |= self.virtual_address_upper << 0;
            
        assert!(self.generic_address_upper < (1 << 8));
        val |= self.generic_address_upper << 16;
            
        assert!((self.read_enable as u32) < (1 << 1));
        val |= (self.read_enable as u32) << 30;
            
        assert!((self.write_enable as u32) < (1 << 1));
        val |= (self.write_enable as u32) << 31;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL1ConfigurationDirectlyAddressableMemory {
    Size16Kb = 0x00000001,
    Size48Kb = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL1Configuration {
    pub directly_addressable_memory: SetL1ConfigurationDirectlyAddressableMemory,
}

impl Mthd for SetL1Configuration {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.directly_addressable_memory as u32) < (1 << 3));
        val |= (self.directly_addressable_memory as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableControl {
    pub conditional_load_constant_buffer: bool,
}

impl Mthd for SetRenderEnableControl {
    const ADDR: u16 = 0x030c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.conditional_load_constant_buffer as u32) < (1 << 1));
        val |= (self.conditional_load_constant_buffer as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitRefCount {
    pub ref_cnt: u32,
    pub flush_sys_mem: bool,
}

impl Mthd for WaitRefCount {
    const ADDR: u16 = 0x0360;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ref_cnt < (1 << 2));
        val |= self.ref_cnt << 8;
            
        assert!((self.flush_sys_mem as u32) < (1 << 1));
        val |= (self.flush_sys_mem as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLaunchId {
    pub ref_cnt: u32,
}

impl Mthd for SetLaunchId {
    const ADDR: u16 = 0x036c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.ref_cnt < (1 << 2));
        val |= self.ref_cnt << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadDimensionA {
    pub d0: u32,
    pub d1: u32,
}

impl Mthd for SetCtaThreadDimensionA {
    const ADDR: u16 = 0x03ac;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.d0 < (1 << 16));
        val |= self.d0 << 0;
            
        assert!(self.d1 < (1 << 16));
        val |= self.d1 << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaThreadDimensionB {
    pub d2: u32,
}

impl Mthd for SetCtaThreadDimensionB {
    const ADDR: u16 = 0x03b0;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.d2 < (1 << 16));
        val |= self.d2 << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCtaProgramStart {
    pub offset: u32,
}

impl Mthd for SetCtaProgramStart {
    const ADDR: u16 = 0x03b4;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x0500;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0504;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0508;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x050c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x0510;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0514;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0518;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x051c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0520;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0524;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0528;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x052c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0530;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0534;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0538;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x053c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0540;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0544;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0548;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x054c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0578;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x057c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxSmCount {
    pub v: u32,
}

impl Mthd for SetMaxSmCount {
    const ADDR: u16 = 0x0758;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 9));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindow {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindow {
    const ADDR: u16 = 0x077c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.base_address;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGridParam {
    pub v: u32,
}

impl Mthd for SetGridParam {
    const ADDR: u16 = 0x0780;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryB {
    pub address_lower: u32,
}

impl Mthd for SetShaderLocalMemoryB {
    const ADDR: u16 = 0x0794;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryC {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryC {
    const ADDR: u16 = 0x0798;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size_upper < (1 << 6));
        val |= self.size_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryD {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryD {
    const ADDR: u16 = 0x079c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.size_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryE {
    pub default_size_per_warp: u32,
}

impl Mthd for SetShaderLocalMemoryE {
    const ADDR: u16 = 0x07a0;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.default_size_per_warp < (1 << 26));
        val |= self.default_size_per_warp << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct EndGrid {
    pub v: u32,
}

impl Mthd for EndGrid {
    const ADDR: u16 = 0x0a04;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetLaunchSize {
    pub v: u32,
}

impl Mthd for SetLaunchSize {
    const ADDR: u16 = 0x0a08;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetApiVisibleCallLimitCta {
    _0 = 0x00000000,
    _1 = 0x00000001,
    _2 = 0x00000002,
    _4 = 0x00000003,
    _8 = 0x00000004,
    _16 = 0x00000005,
    _32 = 0x00000006,
    _64 = 0x00000007,
    _128 = 0x00000008,
    NoCheck = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetApiVisibleCallLimit {
    pub cta: SetApiVisibleCallLimitCta,
}

impl Mthd for SetApiVisibleCallLimit {
    const ADDR: u16 = 0x0d64;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.cta as u32) < (1 << 4));
        val |= (self.cta as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderCacheControl {
    pub icache_prefetch_enable: bool,
}

impl Mthd for SetShaderCacheControl {
    const ADDR: u16 = 0x0d94;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.icache_prefetch_enable as u32) < (1 << 1));
        val |= (self.icache_prefetch_enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmTimeoutInterval {
    pub counter_bit: u32,
}

impl Mthd for SetSmTimeoutInterval {
    const ADDR: u16 = 0x0de4;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.counter_bit < (1 << 6));
        val |= self.counter_bit << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x0f44;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x0f48;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x0f4c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x0f50;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetForceOneTextureUnit {
    pub enable: bool,
}

impl Mthd for SetForceOneTextureUnit {
    const ADDR: u16 = 0x1004;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetSpareNoop00 {
    const ADDR: u16 = 0x1040;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x1044;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x1048;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x104c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x1050;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop05 {
    pub v: u32,
}

impl Mthd for SetSpareNoop05 {
    const ADDR: u16 = 0x1054;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x1058;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x105c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x1060;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x1064;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x1068;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x106c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct UnbindAll {
    pub texture_headers: bool,
    pub texture_samplers: bool,
    pub constant_buffers: bool,
}

impl Mthd for UnbindAll {
    const ADDR: u16 = 0x10f4;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.texture_headers as u32) < (1 << 1));
        val |= (self.texture_headers as u32) << 0;
            
        assert!((self.texture_samplers as u32) < (1 << 1));
        val |= (self.texture_samplers as u32) << 4;
            
        assert!((self.constant_buffers as u32) < (1 << 1));
        val |= (self.constant_buffers as u32) << 8;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSamplerBindingV {
    Independently = 0x00000000,
    ViaHeaderBinding = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSamplerBinding {
    pub v: SetSamplerBindingV,
}

impl Mthd for SetSamplerBinding {
    const ADDR: u16 = 0x1234;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCacheNoWfi {
    pub lines: InvalidateTextureDataCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCacheNoWfi {
    const ADDR: u16 = 0x1288;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderSchedulingMode {
    OldestThreadFirst = 0x00000000,
    RoundRobin = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderScheduling {
    pub mode: SetShaderSchedulingMode,
}

impl Mthd for SetShaderScheduling {
    const ADDR: u16 = 0x12ac;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 1));
        val |= (self.mode as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCache {
    pub lines: InvalidateSamplerCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCache {
    const ADDR: u16 = 0x1330;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureHeaderCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCache {
    pub lines: InvalidateTextureHeaderCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureHeaderCache {
    const ADDR: u16 = 0x1334;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLevels {
    L1Only = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
    pub levels: InvalidateTextureDataCacheLevels,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;
            
        assert!((self.levels as u32) < (1 << 2));
        val |= (self.levels as u32) << 1;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalColorKey {
    pub enable: bool,
}

impl Mthd for SetGlobalColorKey {
    const ADDR: u16 = 0x1354;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateSamplerCacheNoWfiLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheNoWfi {
    pub lines: InvalidateSamplerCacheNoWfiLines,
    pub tag: u32,
}

impl Mthd for InvalidateSamplerCacheNoWfi {
    const ADDR: u16 = 0x1424;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;
            
        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PerfmonTransfer {
    pub v: u32,
}

impl Mthd for PerfmonTransfer {
    const ADDR: u16 = 0x1524;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderExceptions {
    pub enable: bool,
}

impl Mthd for SetShaderExceptions {
    const ADDR: u16 = 0x1528;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x1550;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x1554;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x1558;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexSamplerPoolB {
    const ADDR: u16 = 0x1560;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexSamplerPoolC {
    const ADDR: u16 = 0x1564;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 20));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolB {
    pub offset_lower: u32,
}

impl Mthd for SetTexHeaderPoolB {
    const ADDR: u16 = 0x1578;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolC {
    pub maximum_index: u32,
}

impl Mthd for SetTexHeaderPoolC {
    const ADDR: u16 = 0x157c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.maximum_index < (1 << 22));
        val |= self.maximum_index << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionA {
    pub address_upper: u32,
}

impl Mthd for SetProgramRegionA {
    const ADDR: u16 = 0x1608;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionB {
    pub address_lower: u32,
}

impl Mthd for SetProgramRegionB {
    const ADDR: u16 = 0x160c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCubemapInterFaceFilteringMode {
    UseWrap = 0x00000000,
    OverrideWrap = 0x00000001,
    AutoSpanSeam = 0x00000002,
    AutoCrossSeam = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCubemapInterFaceFiltering {
    pub mode: SetCubemapInterFaceFilteringMode,
}

impl Mthd for SetCubemapInterFaceFiltering {
    const ADDR: u16 = 0x1664;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlDefaultPartial {
    Zero = 0x00000000,
    Infinity = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderControl {
    pub default_partial: SetShaderControlDefaultPartial,
    pub zero_times_anything_is_zero: bool,
}

impl Mthd for SetShaderControl {
    const ADDR: u16 = 0x1690;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.default_partial as u32) < (1 << 1));
        val |= (self.default_partial as u32) << 0;
            
        assert!((self.zero_times_anything_is_zero as u32) < (1 << 1));
        val |= (self.zero_times_anything_is_zero as u32) << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindConstantBuffer {
    pub valid: bool,
    pub shader_slot: u32,
}

impl Mthd for BindConstantBuffer {
    const ADDR: u16 = 0x1694;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.shader_slot < (1 << 5));
        val |= self.shader_slot << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub uniform: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x1698;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;
            
        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;
            
        assert!((self.uniform as u32) < (1 << 1));
        val |= (self.uniform as u32) << 8;
            
        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCache {
    pub thru_l2: bool,
}

impl Mthd for InvalidateConstantBufferCache {
    const ADDR: u16 = 0x1930;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.thru_l2 as u32) < (1 << 1));
        val |= (self.thru_l2 as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x1944;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PipeNop {
    pub v: u32,
}

impl Mthd for PipeNop {
    const ADDR: u16 = 0x1a2c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare00 {
    pub v: u32,
}

impl Mthd for SetSpare00 {
    const ADDR: u16 = 0x1a30;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare01 {
    pub v: u32,
}

impl Mthd for SetSpare01 {
    const ADDR: u16 = 0x1a34;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare02 {
    pub v: u32,
}

impl Mthd for SetSpare02 {
    const ADDR: u16 = 0x1a38;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpare03 {
    pub v: u32,
}

impl Mthd for SetSpare03 {
    const ADDR: u16 = 0x1a3c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetReportSemaphoreA {
    const ADDR: u16 = 0x1b00;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetReportSemaphoreB {
    const ADDR: u16 = 0x1b04;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetReportSemaphoreC {
    const ADDR: u16 = 0x1b08;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub awaken_enable: bool,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub flush_disable: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;
            
        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;
            
        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;
            
        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorA {
    pub size: u32,
}

impl Mthd for SetConstantBufferSelectorA {
    const ADDR: u16 = 0x2380;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.size < (1 << 17));
        val |= self.size << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorB {
    pub address_upper: u32,
}

impl Mthd for SetConstantBufferSelectorB {
    const ADDR: u16 = 0x2384;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantBufferSelectorC {
    pub address_lower: u32,
}

impl Mthd for SetConstantBufferSelectorC {
    const ADDR: u16 = 0x2388;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBufferOffset {
    pub v: u32,
}

impl Mthd for LoadConstantBufferOffset {
    const ADDR: u16 = 0x238c;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadConstantBuffer {
    pub v: u32,
}

impl ArrayMthd for LoadConstantBuffer {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2390+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetSuLdStTargetA {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2700+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetSuLdStTargetB {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2704+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetC {
    pub width: u32,
}

impl ArrayMthd for SetSuLdStTargetC {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2708+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.width;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetDLayoutInMemory {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetD {
    pub height: u32,
    pub layout_in_memory: SetSuLdStTargetDLayoutInMemory,
}

impl ArrayMthd for SetSuLdStTargetD {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x270c+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.height < (1 << 17));
        val |= self.height << 0;
            
        assert!((self.layout_in_memory as u32) < (1 << 1));
        val |= (self.layout_in_memory as u32) << 20;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatType {
    Color = 0x00000000,
    Zeta = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatColor {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetFormatZeta {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetFormat {
    pub type_: SetSuLdStTargetFormatType,
    pub color: SetSuLdStTargetFormatColor,
    pub zeta: SetSuLdStTargetFormatZeta,
    pub suq_pixfmt: u32,
}

impl ArrayMthd for SetSuLdStTargetFormat {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2710+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.type_ as u32) < (1 << 1));
        val |= (self.type_ as u32) << 0;
            
        assert!((self.color as u32) < (1 << 8));
        val |= (self.color as u32) << 4;
            
        assert!((self.zeta as u32) < (1 << 5));
        val |= (self.zeta as u32) << 12;
            
        assert!(self.suq_pixfmt < (1 << 9));
        val |= self.suq_pixfmt << 17;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSuLdStTargetBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSuLdStTargetBlockSize {
    pub width: SetSuLdStTargetBlockSizeWidth,
    pub height: SetSuLdStTargetBlockSizeHeight,
}

impl ArrayMthd for SetSuLdStTargetBlockSize {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x2714+i*32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValue {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x335c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterEvent {
    pub event: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterEvent {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x337c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event < (1 << 8));
        val |= self.event << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x339c+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.event0 < (1 << 3));
        val |= self.event0 << 0;
            
        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 4;
            
        assert!(self.event1 < (1 << 3));
        val |= self.event1 << 8;
            
        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 12;
            
        assert!(self.event2 < (1 << 3));
        val |= self.event2 << 16;
            
        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 20;
            
        assert!(self.event3 < (1 << 3));
        val |= self.event3 << 24;
            
        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 28;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x33bc+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;
            
        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterTrapControl {
    pub mask: u32,
}

impl Mthd for SetShaderPerformanceCounterTrapControl {
    const ADDR: u16 = 0x33dc;
    const CLASS: u16 = 0x90c0;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.mask < (1 << 8));
        val |= self.mask << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x3800+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x90c0;

    fn addr(i: usize) -> u16 {
        
        (0x3804+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
