#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const FERMI_MEMORY_TO_MEMORY_FORMAT_A: u32 = 0x9039;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..8;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER: u32 = 0x0114;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM: u32 = 0x0118;
pub const LOAD_MME_INSTRUCTION_RAM_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER: u32 = 0x011c;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM: u32 = 0x0120;
pub const LOAD_MME_START_ADDRESS_RAM_V: Range<u32> = 0..32;
pub const SET_MME_SHADOW_RAM_CONTROL: u32 = 0x0124;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE: Range<u32> = 0..2;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK: u32 = 0x00000000;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER: u32 = 0x00000001;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH: u32 = 0x00000002;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const SET_SRC_BLOCK_SIZE: u32 = 0x0204;
pub const SET_SRC_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_SRC_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_SRC_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_SRC_WIDTH: u32 = 0x0208;
pub const SET_SRC_WIDTH_V: Range<u32> = 0..32;
pub const SET_SRC_HEIGHT: u32 = 0x020c;
pub const SET_SRC_HEIGHT_V: Range<u32> = 0..32;
pub const SET_SRC_DEPTH: u32 = 0x0210;
pub const SET_SRC_DEPTH_V: Range<u32> = 0..32;
pub const SET_SRC_LAYER: u32 = 0x0214;
pub const SET_SRC_LAYER_V: Range<u32> = 0..32;
pub const SET_DST_BLOCK_SIZE: u32 = 0x0220;
pub const SET_DST_BLOCK_SIZE_WIDTH: Range<u32> = 0..4;
pub const SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT: Range<u32> = 4..8;
pub const SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_BLOCK_SIZE_DEPTH: Range<u32> = 8..12;
pub const SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_WIDTH: u32 = 0x0224;
pub const SET_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_DST_HEIGHT: u32 = 0x0228;
pub const SET_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_DST_DEPTH: u32 = 0x022c;
pub const SET_DST_DEPTH_V: Range<u32> = 0..32;
pub const SET_DST_LAYER: u32 = 0x0230;
pub const SET_DST_LAYER_V: Range<u32> = 0..32;
pub const OFFSET_OUT_UPPER: u32 = 0x0238;
pub const OFFSET_OUT_UPPER_VALUE: Range<u32> = 0..8;
pub const OFFSET_OUT: u32 = 0x023c;
pub const OFFSET_OUT_VALUE: Range<u32> = 0..32;
pub const SET_SPARE_NOOP06: u32 = 0x0240;
pub const SET_SPARE_NOOP06_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP03: u32 = 0x0244;
pub const SET_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP07: u32 = 0x0248;
pub const SET_SPARE_NOOP07_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP05: u32 = 0x024c;
pub const SET_SPARE_NOOP05_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP14: u32 = 0x0250;
pub const SET_SPARE_NOOP14_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP04: u32 = 0x0254;
pub const SET_SPARE_NOOP04_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP10: u32 = 0x0258;
pub const SET_SPARE_NOOP10_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP02: u32 = 0x025c;
pub const SET_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP12: u32 = 0x0260;
pub const SET_SPARE_NOOP12_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP00: u32 = 0x0264;
pub const SET_SPARE_NOOP00_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP08: u32 = 0x0268;
pub const SET_SPARE_NOOP08_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP13: u32 = 0x026c;
pub const SET_SPARE_NOOP13_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP09: u32 = 0x0270;
pub const SET_SPARE_NOOP09_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP15: u32 = 0x0274;
pub const SET_SPARE_NOOP15_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP01: u32 = 0x0278;
pub const SET_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_FALCON00: u32 = 0x027c;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x0280;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x0284;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x0288;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x028c;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x0290;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x0294;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x0298;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x029c;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x02a0;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x02a4;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x02a8;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x02ac;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x02b0;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x02b4;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x02b8;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x02bc;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x02c0;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x02c4;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x02c8;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x02cc;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x02d0;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x02d4;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x02d8;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x02dc;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x02e0;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x02e4;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x02e8;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x02ec;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x02f0;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x02f4;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x02f8;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP11: u32 = 0x02fc;
pub const SET_SPARE_NOOP11_V: Range<u32> = 0..32;
pub const LAUNCH_DMA: u32 = 0x0300;
pub const LAUNCH_DMA_SRC_INLINE: Range<u32> = 0..1;
pub const LAUNCH_DMA_SRC_INLINE_FALSE: u32 = 0x00000000;
pub const LAUNCH_DMA_SRC_INLINE_TRUE: u32 = 0x00000001;
pub const LAUNCH_DMA_SRC_MEMORY_LAYOUT: Range<u32> = 4..5;
pub const LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT: Range<u32> = 8..9;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR: u32 = 0x00000000;
pub const LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE: Range<u32> = 12..14;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE: u32 = 0x00000000;
pub const LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY: u32 = 0x00000001;
pub const LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE: u32 = 0x00000002;
pub const LAUNCH_DMA_INTERRUPT_TYPE: Range<u32> = 16..18;
pub const LAUNCH_DMA_INTERRUPT_TYPE_NONE: u32 = 0x00000000;
pub const LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT: u32 = 0x00000001;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE: Range<u32> = 20..21;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS: u32 = 0x00000000;
pub const LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD: u32 = 0x00000001;
pub const LOAD_INLINE_DATA: u32 = 0x0304;
pub const LOAD_INLINE_DATA_V: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x0308;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
pub const OFFSET_IN_UPPER: u32 = 0x030c;
pub const OFFSET_IN_UPPER_VALUE: Range<u32> = 0..8;
pub const OFFSET_IN: u32 = 0x0310;
pub const OFFSET_IN_VALUE: Range<u32> = 0..32;
pub const PITCH_IN: u32 = 0x0314;
pub const PITCH_IN_VALUE: Range<u32> = 0..32;
pub const PITCH_OUT: u32 = 0x0318;
pub const PITCH_OUT_VALUE: Range<u32> = 0..32;
pub const LINE_LENGTH_IN: u32 = 0x031c;
pub const LINE_LENGTH_IN_VALUE: Range<u32> = 0..32;
pub const LINE_COUNT: u32 = 0x0320;
pub const LINE_COUNT_VALUE: Range<u32> = 0..32;
pub const SET_SEMAPHORE_A: u32 = 0x032c;
pub const SET_SEMAPHORE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_SEMAPHORE_B: u32 = 0x0330;
pub const SET_SEMAPHORE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_SEMAPHORE_C: u32 = 0x0334;
pub const SET_SEMAPHORE_C_PAYLOAD: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_A: u32 = 0x0338;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x033c;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x0340;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_SRC_ORIGIN_BYTES_X: u32 = 0x0344;
pub const SET_SRC_ORIGIN_BYTES_X_V: Range<u32> = 0..20;
pub const SET_SRC_ORIGIN_SAMPLES_Y: u32 = 0x0348;
pub const SET_SRC_ORIGIN_SAMPLES_Y_V: Range<u32> = 0..16;
pub const SET_DST_ORIGIN_BYTES_X: u32 = 0x034c;
pub const SET_DST_ORIGIN_BYTES_X_V: Range<u32> = 0..20;
pub const SET_DST_ORIGIN_SAMPLES_Y: u32 = 0x0350;
pub const SET_DST_ORIGIN_SAMPLES_Y_V: Range<u32> = 0..16;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_macro  (j: u32) -> u32 { 0x3800+j*8 } 
pub const CALL_MME_MACRO_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_data  (j: u32) -> u32 { 0x3804+j*8 } 
pub const CALL_MME_DATA_V: Range<u32> = 0..32;

// parsed class NV9039




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcBlockSize {
    pub width: SetSrcBlockSizeWidth,
    pub height: SetSrcBlockSizeHeight,
    pub depth: SetSrcBlockSizeDepth,
}

impl Mthd for SetSrcBlockSize {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcWidth {
    pub v: u32,
}

impl Mthd for SetSrcWidth {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcHeight {
    pub v: u32,
}

impl Mthd for SetSrcHeight {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcDepth {
    pub v: u32,
}

impl Mthd for SetSrcDepth {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcLayer {
    pub v: u32,
}

impl Mthd for SetSrcLayer {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;
            
        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop05 {
    pub v: u32,
}

impl Mthd for SetSpareNoop05 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetSpareNoop00 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x0280;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x0284;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x0288;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x0290;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x0294;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x0298;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x02a4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x02a8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x02ac;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x02b0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x02b4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x02d4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x02d8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x02e0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x02f4;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x02fc;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSrcMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub src_inline: bool,
    pub src_memory_layout: LaunchDmaSrcMemoryLayout,
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x0300;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.src_inline as u32) < (1 << 1));
        val |= (self.src_inline as u32) << 0;
            
        assert!((self.src_memory_layout as u32) < (1 << 1));
        val |= (self.src_memory_layout as u32) << 4;
            
        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 8;
            
        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 12;
            
        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 16;
            
        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 20;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x0304;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetInUpper {
    pub value: u32,
}

impl Mthd for OffsetInUpper {
    const ADDR: u16 = 0x030c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetIn {
    pub value: u32,
}

impl Mthd for OffsetIn {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchIn {
    pub value: u32,
}

impl Mthd for PitchIn {
    const ADDR: u16 = 0x0314;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0318;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x031c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0320;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetSemaphoreA {
    const ADDR: u16 = 0x032c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetSemaphoreB {
    const ADDR: u16 = 0x0330;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetSemaphoreC {
    const ADDR: u16 = 0x0334;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.payload;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x0338;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x033c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x0340;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOriginBytesX {
    pub v: u32,
}

impl Mthd for SetSrcOriginBytesX {
    const ADDR: u16 = 0x0344;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetSrcOriginSamplesY {
    const ADDR: u16 = 0x0348;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x034c;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x0350;
    const CLASS: u16 = 0x9039;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x9039;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x9039;

    fn addr(i: usize) -> u16 {
        
        (0x3800+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x9039;

    fn addr(i: usize) -> u16 {
        
        (0x3804+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
