#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]

use std::ops::Range;
use crate::Mthd;
use crate::ArrayMthd;

pub const FERMI_TWOD_A: u32 = 0x902D;
pub const SET_OBJECT: u32 = 0x0000;
pub const SET_OBJECT_CLASS_ID: Range<u32> = 0..16;
pub const SET_OBJECT_ENGINE_ID: Range<u32> = 16..21;
pub const NO_OPERATION: u32 = 0x0100;
pub const NO_OPERATION_V: Range<u32> = 0..32;
pub const SET_NOTIFY_A: u32 = 0x0104;
pub const SET_NOTIFY_A_ADDRESS_UPPER: Range<u32> = 0..25;
pub const SET_NOTIFY_B: u32 = 0x0108;
pub const SET_NOTIFY_B_ADDRESS_LOWER: Range<u32> = 0..32;
pub const NOTIFY: u32 = 0x010c;
pub const NOTIFY_TYPE: Range<u32> = 0..32;
pub const NOTIFY_TYPE_WRITE_ONLY: u32 = 0x00000000;
pub const NOTIFY_TYPE_WRITE_THEN_AWAKEN: u32 = 0x00000001;
pub const WAIT_FOR_IDLE: u32 = 0x0110;
pub const WAIT_FOR_IDLE_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER: u32 = 0x0114;
pub const LOAD_MME_INSTRUCTION_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_INSTRUCTION_RAM: u32 = 0x0118;
pub const LOAD_MME_INSTRUCTION_RAM_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER: u32 = 0x011c;
pub const LOAD_MME_START_ADDRESS_RAM_POINTER_V: Range<u32> = 0..32;
pub const LOAD_MME_START_ADDRESS_RAM: u32 = 0x0120;
pub const LOAD_MME_START_ADDRESS_RAM_V: Range<u32> = 0..32;
pub const SET_MME_SHADOW_RAM_CONTROL: u32 = 0x0124;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE: Range<u32> = 0..2;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK: u32 = 0x00000000;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER: u32 = 0x00000001;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH: u32 = 0x00000002;
pub const SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_A: u32 = 0x0130;
pub const SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_GLOBAL_RENDER_ENABLE_B: u32 = 0x0134;
pub const SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_GLOBAL_RENDER_ENABLE_C: u32 = 0x0138;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SEND_GO_IDLE: u32 = 0x013c;
pub const SEND_GO_IDLE_V: Range<u32> = 0..32;
pub const PM_TRIGGER: u32 = 0x0140;
pub const PM_TRIGGER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_HEADER: u32 = 0x0150;
pub const SET_INSTRUMENTATION_METHOD_HEADER_V: Range<u32> = 0..32;
pub const SET_INSTRUMENTATION_METHOD_DATA: u32 = 0x0154;
pub const SET_INSTRUMENTATION_METHOD_DATA_V: Range<u32> = 0..32;
pub const SET_MME_SWITCH_STATE: u32 = 0x01ec;
pub const SET_MME_SWITCH_STATE_VALID: Range<u32> = 0..1;
pub const SET_MME_SWITCH_STATE_VALID_FALSE: u32 = 0x00000000;
pub const SET_MME_SWITCH_STATE_VALID_TRUE: u32 = 0x00000001;
pub const SET_MME_SWITCH_STATE_SAVE_MACRO: Range<u32> = 4..12;
pub const SET_MME_SWITCH_STATE_RESTORE_MACRO: Range<u32> = 12..20;
pub const SET_DST_FORMAT: u32 = 0x0200;
pub const SET_DST_FORMAT_V: Range<u32> = 0..8;
pub const SET_DST_FORMAT_V_A8R8G8B8: u32 = 0x000000CF;
pub const SET_DST_FORMAT_V_A8RL8GL8BL8: u32 = 0x000000D0;
pub const SET_DST_FORMAT_V_A2R10G10B10: u32 = 0x000000DF;
pub const SET_DST_FORMAT_V_A8B8G8R8: u32 = 0x000000D5;
pub const SET_DST_FORMAT_V_A8BL8GL8RL8: u32 = 0x000000D6;
pub const SET_DST_FORMAT_V_A2B10G10R10: u32 = 0x000000D1;
pub const SET_DST_FORMAT_V_X8R8G8B8: u32 = 0x000000E6;
pub const SET_DST_FORMAT_V_X8RL8GL8BL8: u32 = 0x000000E7;
pub const SET_DST_FORMAT_V_X8B8G8R8: u32 = 0x000000F9;
pub const SET_DST_FORMAT_V_X8BL8GL8RL8: u32 = 0x000000FA;
pub const SET_DST_FORMAT_V_R5G6B5: u32 = 0x000000E8;
pub const SET_DST_FORMAT_V_A1R5G5B5: u32 = 0x000000E9;
pub const SET_DST_FORMAT_V_X1R5G5B5: u32 = 0x000000F8;
pub const SET_DST_FORMAT_V_Y8: u32 = 0x000000F3;
pub const SET_DST_FORMAT_V_Y16: u32 = 0x000000EE;
pub const SET_DST_FORMAT_V_Y32: u32 = 0x000000FF;
pub const SET_DST_FORMAT_V_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_DST_FORMAT_V_O1R5G5B5: u32 = 0x000000FC;
pub const SET_DST_FORMAT_V_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_DST_FORMAT_V_O8R8G8B8: u32 = 0x000000FE;
pub const SET_DST_FORMAT_V_Y1_8X8: u32 = 0x0000001C;
pub const SET_DST_FORMAT_V_RF16: u32 = 0x000000F2;
pub const SET_DST_FORMAT_V_RF32: u32 = 0x000000E5;
pub const SET_DST_FORMAT_V_RF32_GF32: u32 = 0x000000CB;
pub const SET_DST_FORMAT_V_RF16_GF16_BF16_AF16: u32 = 0x000000CA;
pub const SET_DST_FORMAT_V_RF16_GF16_BF16_X16: u32 = 0x000000CE;
pub const SET_DST_FORMAT_V_RF32_GF32_BF32_AF32: u32 = 0x000000C0;
pub const SET_DST_FORMAT_V_RF32_GF32_BF32_X32: u32 = 0x000000C3;
pub const SET_DST_FORMAT_V_R16_G16_B16_A16: u32 = 0x000000C6;
pub const SET_DST_FORMAT_V_RN16_GN16_BN16_AN16: u32 = 0x000000C7;
pub const SET_DST_FORMAT_V_BF10GF11RF11: u32 = 0x000000E0;
pub const SET_DST_FORMAT_V_AN8BN8GN8RN8: u32 = 0x000000D7;
pub const SET_DST_FORMAT_V_RF16_GF16: u32 = 0x000000DE;
pub const SET_DST_FORMAT_V_R16_G16: u32 = 0x000000DA;
pub const SET_DST_FORMAT_V_RN16_GN16: u32 = 0x000000DB;
pub const SET_DST_FORMAT_V_G8R8: u32 = 0x000000EA;
pub const SET_DST_FORMAT_V_GN8RN8: u32 = 0x000000EB;
pub const SET_DST_FORMAT_V_RN16: u32 = 0x000000EF;
pub const SET_DST_FORMAT_V_RN8: u32 = 0x000000F4;
pub const SET_DST_FORMAT_V_A8: u32 = 0x000000F7;
pub const SET_DST_MEMORY_LAYOUT: u32 = 0x0204;
pub const SET_DST_MEMORY_LAYOUT_V: Range<u32> = 0..1;
pub const SET_DST_MEMORY_LAYOUT_V_BLOCKLINEAR: u32 = 0x00000000;
pub const SET_DST_MEMORY_LAYOUT_V_PITCH: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE: u32 = 0x0208;
pub const SET_DST_BLOCK_SIZE_HEIGHT: Range<u32> = 4..7;
pub const SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_BLOCK_SIZE_DEPTH: Range<u32> = 8..11;
pub const SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_DST_DEPTH: u32 = 0x020c;
pub const SET_DST_DEPTH_V: Range<u32> = 0..32;
pub const SET_DST_LAYER: u32 = 0x0210;
pub const SET_DST_LAYER_V: Range<u32> = 0..32;
pub const SET_DST_PITCH: u32 = 0x0214;
pub const SET_DST_PITCH_V: Range<u32> = 0..32;
pub const SET_DST_WIDTH: u32 = 0x0218;
pub const SET_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_DST_HEIGHT: u32 = 0x021c;
pub const SET_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_DST_OFFSET_UPPER: u32 = 0x0220;
pub const SET_DST_OFFSET_UPPER_V: Range<u32> = 0..8;
pub const SET_DST_OFFSET_LOWER: u32 = 0x0224;
pub const SET_DST_OFFSET_LOWER_V: Range<u32> = 0..32;
pub const FLUSH_AND_INVALIDATE_ROP_MINI_CACHE: u32 = 0x0228;
pub const FLUSH_AND_INVALIDATE_ROP_MINI_CACHE_V: Range<u32> = 0..1;
pub const SET_SPARE_NOOP06: u32 = 0x022c;
pub const SET_SPARE_NOOP06_V: Range<u32> = 0..32;
pub const SET_SRC_FORMAT: u32 = 0x0230;
pub const SET_SRC_FORMAT_V: Range<u32> = 0..8;
pub const SET_SRC_FORMAT_V_A8R8G8B8: u32 = 0x000000CF;
pub const SET_SRC_FORMAT_V_A8RL8GL8BL8: u32 = 0x000000D0;
pub const SET_SRC_FORMAT_V_A2R10G10B10: u32 = 0x000000DF;
pub const SET_SRC_FORMAT_V_A8B8G8R8: u32 = 0x000000D5;
pub const SET_SRC_FORMAT_V_A8BL8GL8RL8: u32 = 0x000000D6;
pub const SET_SRC_FORMAT_V_A2B10G10R10: u32 = 0x000000D1;
pub const SET_SRC_FORMAT_V_X8R8G8B8: u32 = 0x000000E6;
pub const SET_SRC_FORMAT_V_X8RL8GL8BL8: u32 = 0x000000E7;
pub const SET_SRC_FORMAT_V_X8B8G8R8: u32 = 0x000000F9;
pub const SET_SRC_FORMAT_V_X8BL8GL8RL8: u32 = 0x000000FA;
pub const SET_SRC_FORMAT_V_R5G6B5: u32 = 0x000000E8;
pub const SET_SRC_FORMAT_V_A1R5G5B5: u32 = 0x000000E9;
pub const SET_SRC_FORMAT_V_X1R5G5B5: u32 = 0x000000F8;
pub const SET_SRC_FORMAT_V_Y8: u32 = 0x000000F3;
pub const SET_SRC_FORMAT_V_AY8: u32 = 0x0000001D;
pub const SET_SRC_FORMAT_V_Y16: u32 = 0x000000EE;
pub const SET_SRC_FORMAT_V_Y32: u32 = 0x000000FF;
pub const SET_SRC_FORMAT_V_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_SRC_FORMAT_V_O1R5G5B5: u32 = 0x000000FC;
pub const SET_SRC_FORMAT_V_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_SRC_FORMAT_V_O8R8G8B8: u32 = 0x000000FE;
pub const SET_SRC_FORMAT_V_Y1_8X8: u32 = 0x0000001C;
pub const SET_SRC_FORMAT_V_RF16: u32 = 0x000000F2;
pub const SET_SRC_FORMAT_V_RF32: u32 = 0x000000E5;
pub const SET_SRC_FORMAT_V_RF32_GF32: u32 = 0x000000CB;
pub const SET_SRC_FORMAT_V_RF16_GF16_BF16_AF16: u32 = 0x000000CA;
pub const SET_SRC_FORMAT_V_RF16_GF16_BF16_X16: u32 = 0x000000CE;
pub const SET_SRC_FORMAT_V_RF32_GF32_BF32_AF32: u32 = 0x000000C0;
pub const SET_SRC_FORMAT_V_RF32_GF32_BF32_X32: u32 = 0x000000C3;
pub const SET_SRC_FORMAT_V_R16_G16_B16_A16: u32 = 0x000000C6;
pub const SET_SRC_FORMAT_V_RN16_GN16_BN16_AN16: u32 = 0x000000C7;
pub const SET_SRC_FORMAT_V_BF10GF11RF11: u32 = 0x000000E0;
pub const SET_SRC_FORMAT_V_AN8BN8GN8RN8: u32 = 0x000000D7;
pub const SET_SRC_FORMAT_V_RF16_GF16: u32 = 0x000000DE;
pub const SET_SRC_FORMAT_V_R16_G16: u32 = 0x000000DA;
pub const SET_SRC_FORMAT_V_RN16_GN16: u32 = 0x000000DB;
pub const SET_SRC_FORMAT_V_G8R8: u32 = 0x000000EA;
pub const SET_SRC_FORMAT_V_GN8RN8: u32 = 0x000000EB;
pub const SET_SRC_FORMAT_V_RN16: u32 = 0x000000EF;
pub const SET_SRC_FORMAT_V_RN8: u32 = 0x000000F4;
pub const SET_SRC_FORMAT_V_A8: u32 = 0x000000F7;
pub const SET_SRC_MEMORY_LAYOUT: u32 = 0x0234;
pub const SET_SRC_MEMORY_LAYOUT_V: Range<u32> = 0..1;
pub const SET_SRC_MEMORY_LAYOUT_V_BLOCKLINEAR: u32 = 0x00000000;
pub const SET_SRC_MEMORY_LAYOUT_V_PITCH: u32 = 0x00000001;
pub const SET_SRC_BLOCK_SIZE: u32 = 0x0238;
pub const SET_SRC_BLOCK_SIZE_HEIGHT: Range<u32> = 4..7;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB: u32 = 0x00000000;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS: u32 = 0x00000001;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_SRC_BLOCK_SIZE_DEPTH: Range<u32> = 8..11;
pub const SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB: u32 = 0x00000000;
pub const SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS: u32 = 0x00000001;
pub const SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS: u32 = 0x00000002;
pub const SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS: u32 = 0x00000003;
pub const SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS: u32 = 0x00000004;
pub const SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS: u32 = 0x00000005;
pub const SET_SRC_DEPTH: u32 = 0x023c;
pub const SET_SRC_DEPTH_V: Range<u32> = 0..32;
pub const TWOD_INVALIDATE_TEXTURE_DATA_CACHE: u32 = 0x0240;
pub const TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V: Range<u32> = 0..2;
pub const TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_ONLY: u32 = 0x00000000;
pub const TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L2_ONLY: u32 = 0x00000001;
pub const TWOD_INVALIDATE_TEXTURE_DATA_CACHE_V_L1_AND_L2: u32 = 0x00000002;
pub const SET_SRC_PITCH: u32 = 0x0244;
pub const SET_SRC_PITCH_V: Range<u32> = 0..32;
pub const SET_SRC_WIDTH: u32 = 0x0248;
pub const SET_SRC_WIDTH_V: Range<u32> = 0..32;
pub const SET_SRC_HEIGHT: u32 = 0x024c;
pub const SET_SRC_HEIGHT_V: Range<u32> = 0..32;
pub const SET_SRC_OFFSET_UPPER: u32 = 0x0250;
pub const SET_SRC_OFFSET_UPPER_V: Range<u32> = 0..8;
pub const SET_SRC_OFFSET_LOWER: u32 = 0x0254;
pub const SET_SRC_OFFSET_LOWER_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION: u32 = 0x0258;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V: Range<u32> = 0..2;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_NO_PROMOTION: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_V: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_2_H: u32 = 0x00000002;
pub const SET_PIXELS_FROM_MEMORY_SECTOR_PROMOTION_V_PROMOTE_TO_4: u32 = 0x00000003;
pub const SET_SPARE_NOOP12: u32 = 0x025c;
pub const SET_SPARE_NOOP12_V: Range<u32> = 0..32;
pub const SET_NUM_PROCESSING_CLUSTERS: u32 = 0x0260;
pub const SET_NUM_PROCESSING_CLUSTERS_V: Range<u32> = 0..1;
pub const SET_NUM_PROCESSING_CLUSTERS_V_ALL: u32 = 0x00000000;
pub const SET_NUM_PROCESSING_CLUSTERS_V_ONE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_A: u32 = 0x0264;
pub const SET_RENDER_ENABLE_A_OFFSET_UPPER: Range<u32> = 0..8;
pub const SET_RENDER_ENABLE_B: u32 = 0x0268;
pub const SET_RENDER_ENABLE_B_OFFSET_LOWER: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_C: u32 = 0x026c;
pub const SET_RENDER_ENABLE_C_MODE: Range<u32> = 0..3;
pub const SET_RENDER_ENABLE_C_MODE_FALSE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_C_MODE_TRUE: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_C_MODE_CONDITIONAL: u32 = 0x00000002;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL: u32 = 0x00000003;
pub const SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL: u32 = 0x00000004;
pub const SET_SPARE_NOOP08: u32 = 0x0270;
pub const SET_SPARE_NOOP08_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP01: u32 = 0x0274;
pub const SET_SPARE_NOOP01_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP11: u32 = 0x0278;
pub const SET_SPARE_NOOP11_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP07: u32 = 0x027c;
pub const SET_SPARE_NOOP07_V: Range<u32> = 0..32;
pub const SET_CLIP_X0: u32 = 0x0280;
pub const SET_CLIP_X0_V: Range<u32> = 0..32;
pub const SET_CLIP_Y0: u32 = 0x0284;
pub const SET_CLIP_Y0_V: Range<u32> = 0..32;
pub const SET_CLIP_WIDTH: u32 = 0x0288;
pub const SET_CLIP_WIDTH_V: Range<u32> = 0..32;
pub const SET_CLIP_HEIGHT: u32 = 0x028c;
pub const SET_CLIP_HEIGHT_V: Range<u32> = 0..32;
pub const SET_CLIP_ENABLE: u32 = 0x0290;
pub const SET_CLIP_ENABLE_V: Range<u32> = 0..1;
pub const SET_CLIP_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_CLIP_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_COLOR_KEY_FORMAT: u32 = 0x0294;
pub const SET_COLOR_KEY_FORMAT_V: Range<u32> = 0..3;
pub const SET_COLOR_KEY_FORMAT_V_A16R5G6B5: u32 = 0x00000000;
pub const SET_COLOR_KEY_FORMAT_V_A1R5G5B5: u32 = 0x00000001;
pub const SET_COLOR_KEY_FORMAT_V_A8R8G8B8: u32 = 0x00000002;
pub const SET_COLOR_KEY_FORMAT_V_A2R10G10B10: u32 = 0x00000003;
pub const SET_COLOR_KEY_FORMAT_V_Y8: u32 = 0x00000004;
pub const SET_COLOR_KEY_FORMAT_V_Y16: u32 = 0x00000005;
pub const SET_COLOR_KEY_FORMAT_V_Y32: u32 = 0x00000006;
pub const SET_COLOR_KEY: u32 = 0x0298;
pub const SET_COLOR_KEY_V: Range<u32> = 0..32;
pub const SET_COLOR_KEY_ENABLE: u32 = 0x029c;
pub const SET_COLOR_KEY_ENABLE_V: Range<u32> = 0..1;
pub const SET_COLOR_KEY_ENABLE_V_FALSE: u32 = 0x00000000;
pub const SET_COLOR_KEY_ENABLE_V_TRUE: u32 = 0x00000001;
pub const SET_ROP: u32 = 0x02a0;
pub const SET_ROP_V: Range<u32> = 0..8;
pub const SET_BETA1: u32 = 0x02a4;
pub const SET_BETA1_V: Range<u32> = 0..32;
pub const SET_BETA4: u32 = 0x02a8;
pub const SET_BETA4_B: Range<u32> = 0..8;
pub const SET_BETA4_G: Range<u32> = 8..16;
pub const SET_BETA4_R: Range<u32> = 16..24;
pub const SET_BETA4_A: Range<u32> = 24..32;
pub const SET_OPERATION: u32 = 0x02ac;
pub const SET_OPERATION_V: Range<u32> = 0..3;
pub const SET_OPERATION_V_SRCCOPY_AND: u32 = 0x00000000;
pub const SET_OPERATION_V_ROP_AND: u32 = 0x00000001;
pub const SET_OPERATION_V_BLEND_AND: u32 = 0x00000002;
pub const SET_OPERATION_V_SRCCOPY: u32 = 0x00000003;
pub const SET_OPERATION_V_ROP: u32 = 0x00000004;
pub const SET_OPERATION_V_SRCCOPY_PREMULT: u32 = 0x00000005;
pub const SET_OPERATION_V_BLEND_PREMULT: u32 = 0x00000006;
pub const SET_PATTERN_OFFSET: u32 = 0x02b0;
pub const SET_PATTERN_OFFSET_X: Range<u32> = 0..6;
pub const SET_PATTERN_OFFSET_Y: Range<u32> = 8..14;
pub const SET_PATTERN_SELECT: u32 = 0x02b4;
pub const SET_PATTERN_SELECT_V: Range<u32> = 0..2;
pub const SET_PATTERN_SELECT_V_MONOCHROME_8x8: u32 = 0x00000000;
pub const SET_PATTERN_SELECT_V_MONOCHROME_64x1: u32 = 0x00000001;
pub const SET_PATTERN_SELECT_V_MONOCHROME_1x64: u32 = 0x00000002;
pub const SET_PATTERN_SELECT_V_COLOR: u32 = 0x00000003;
pub const SET_DST_COLOR_RENDER_TO_ZETA_SURFACE: u32 = 0x02b8;
pub const SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V: Range<u32> = 0..1;
pub const SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_FALSE: u32 = 0x00000000;
pub const SET_DST_COLOR_RENDER_TO_ZETA_SURFACE_V_TRUE: u32 = 0x00000001;
pub const SET_SPARE_NOOP04: u32 = 0x02bc;
pub const SET_SPARE_NOOP04_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP15: u32 = 0x02c0;
pub const SET_SPARE_NOOP15_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP13: u32 = 0x02c4;
pub const SET_SPARE_NOOP13_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP03: u32 = 0x02c8;
pub const SET_SPARE_NOOP03_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP14: u32 = 0x02cc;
pub const SET_SPARE_NOOP14_V: Range<u32> = 0..32;
pub const SET_SPARE_NOOP02: u32 = 0x02d0;
pub const SET_SPARE_NOOP02_V: Range<u32> = 0..32;
pub const SET_COMPRESSION: u32 = 0x02d4;
pub const SET_COMPRESSION_ENABLE: Range<u32> = 0..1;
pub const SET_COMPRESSION_ENABLE_FALSE: u32 = 0x00000000;
pub const SET_COMPRESSION_ENABLE_TRUE: u32 = 0x00000001;
pub const SET_SPARE_NOOP09: u32 = 0x02d8;
pub const SET_SPARE_NOOP09_V: Range<u32> = 0..32;
pub const SET_RENDER_ENABLE_OVERRIDE: u32 = 0x02dc;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE: Range<u32> = 0..2;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE: u32 = 0x00000000;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER: u32 = 0x00000001;
pub const SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER: u32 = 0x00000002;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION: u32 = 0x02e0;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL: Range<u32> = 0..2;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_HW_DECIDES: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_LEFT_TO_RIGHT: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_HORIZONTAL_RIGHT_TO_LEFT: u32 = 0x00000002;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL: Range<u32> = 4..6;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_HW_DECIDES: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_TOP_TO_BOTTOM: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_DIRECTION_VERTICAL_BOTTOM_TO_TOP: u32 = 0x00000002;
pub const SET_SPARE_NOOP10: u32 = 0x02e4;
pub const SET_SPARE_NOOP10_V: Range<u32> = 0..32;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT: u32 = 0x02e8;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V: Range<u32> = 0..3;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8R5G6B5: u32 = 0x00000000;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A1R5G5B5: u32 = 0x00000001;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8R8G8B8: u32 = 0x00000002;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8Y8: u32 = 0x00000003;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_A8X8Y16: u32 = 0x00000004;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_Y32: u32 = 0x00000005;
pub const SET_MONOCHROME_PATTERN_COLOR_FORMAT_V_BYTE_EXPAND: u32 = 0x00000006;
pub const SET_MONOCHROME_PATTERN_FORMAT: u32 = 0x02ec;
pub const SET_MONOCHROME_PATTERN_FORMAT_V: Range<u32> = 0..1;
pub const SET_MONOCHROME_PATTERN_FORMAT_V_CGA6_M1: u32 = 0x00000000;
pub const SET_MONOCHROME_PATTERN_FORMAT_V_LE_M1: u32 = 0x00000001;
pub const SET_MONOCHROME_PATTERN_COLOR0: u32 = 0x02f0;
pub const SET_MONOCHROME_PATTERN_COLOR0_V: Range<u32> = 0..32;
pub const SET_MONOCHROME_PATTERN_COLOR1: u32 = 0x02f4;
pub const SET_MONOCHROME_PATTERN_COLOR1_V: Range<u32> = 0..32;
pub const SET_MONOCHROME_PATTERN0: u32 = 0x02f8;
pub const SET_MONOCHROME_PATTERN0_V: Range<u32> = 0..32;
pub const SET_MONOCHROME_PATTERN1: u32 = 0x02fc;
pub const SET_MONOCHROME_PATTERN1_V: Range<u32> = 0..32;
#[inline]
pub fn color_pattern_x8r8g8b8  (i: u32) -> u32 { 0x0300+i*4 } 
pub const COLOR_PATTERN_X8R8G8B8_B0: Range<u32> = 0..8;
pub const COLOR_PATTERN_X8R8G8B8_G0: Range<u32> = 8..16;
pub const COLOR_PATTERN_X8R8G8B8_R0: Range<u32> = 16..24;
pub const COLOR_PATTERN_X8R8G8B8_IGNORE0: Range<u32> = 24..32;
#[inline]
pub fn color_pattern_r5g6b5  (i: u32) -> u32 { 0x0400+i*4 } 
pub const COLOR_PATTERN_R5G6B5_B0: Range<u32> = 0..5;
pub const COLOR_PATTERN_R5G6B5_G0: Range<u32> = 5..11;
pub const COLOR_PATTERN_R5G6B5_R0: Range<u32> = 11..16;
pub const COLOR_PATTERN_R5G6B5_B1: Range<u32> = 16..21;
pub const COLOR_PATTERN_R5G6B5_G1: Range<u32> = 21..27;
pub const COLOR_PATTERN_R5G6B5_R1: Range<u32> = 27..32;
#[inline]
pub fn color_pattern_x1r5g5b5  (i: u32) -> u32 { 0x0480+i*4 } 
pub const COLOR_PATTERN_X1R5G5B5_B0: Range<u32> = 0..5;
pub const COLOR_PATTERN_X1R5G5B5_G0: Range<u32> = 5..10;
pub const COLOR_PATTERN_X1R5G5B5_R0: Range<u32> = 10..15;
pub const COLOR_PATTERN_X1R5G5B5_IGNORE0: Range<u32> = 15..16;
pub const COLOR_PATTERN_X1R5G5B5_B1: Range<u32> = 16..21;
pub const COLOR_PATTERN_X1R5G5B5_G1: Range<u32> = 21..26;
pub const COLOR_PATTERN_X1R5G5B5_R1: Range<u32> = 26..31;
pub const COLOR_PATTERN_X1R5G5B5_IGNORE1: Range<u32> = 31..32;
#[inline]
pub fn color_pattern_y8  (i: u32) -> u32 { 0x0500+i*4 } 
pub const COLOR_PATTERN_Y8_Y0: Range<u32> = 0..8;
pub const COLOR_PATTERN_Y8_Y1: Range<u32> = 8..16;
pub const COLOR_PATTERN_Y8_Y2: Range<u32> = 16..24;
pub const COLOR_PATTERN_Y8_Y3: Range<u32> = 24..32;
pub const SET_RENDER_SOLID_PRIM_COLOR0: u32 = 0x0540;
pub const SET_RENDER_SOLID_PRIM_COLOR0_V: Range<u32> = 0..32;
pub const SET_RENDER_SOLID_PRIM_COLOR1: u32 = 0x0544;
pub const SET_RENDER_SOLID_PRIM_COLOR1_V: Range<u32> = 0..32;
pub const SET_RENDER_SOLID_PRIM_COLOR2: u32 = 0x0548;
pub const SET_RENDER_SOLID_PRIM_COLOR2_V: Range<u32> = 0..32;
pub const SET_RENDER_SOLID_PRIM_COLOR3: u32 = 0x054c;
pub const SET_RENDER_SOLID_PRIM_COLOR3_V: Range<u32> = 0..32;
pub const SET_MME_MEM_ADDRESS_A: u32 = 0x0550;
pub const SET_MME_MEM_ADDRESS_A_UPPER: Range<u32> = 0..25;
pub const SET_MME_MEM_ADDRESS_B: u32 = 0x0554;
pub const SET_MME_MEM_ADDRESS_B_LOWER: Range<u32> = 0..32;
pub const SET_MME_DATA_RAM_ADDRESS: u32 = 0x0558;
pub const SET_MME_DATA_RAM_ADDRESS_WORD: Range<u32> = 0..32;
pub const MME_DMA_READ: u32 = 0x055c;
pub const MME_DMA_READ_LENGTH: Range<u32> = 0..32;
pub const MME_DMA_READ_FIFOED: u32 = 0x0560;
pub const MME_DMA_READ_FIFOED_LENGTH: Range<u32> = 0..32;
pub const MME_DMA_WRITE: u32 = 0x0564;
pub const MME_DMA_WRITE_LENGTH: Range<u32> = 0..32;
pub const MME_DMA_REDUCTION: u32 = 0x0568;
pub const MME_DMA_REDUCTION_REDUCTION_OP: Range<u32> = 0..3;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD: u32 = 0x00000000;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN: u32 = 0x00000001;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX: u32 = 0x00000002;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_INC: u32 = 0x00000003;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC: u32 = 0x00000004;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_AND: u32 = 0x00000005;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_OR: u32 = 0x00000006;
pub const MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR: u32 = 0x00000007;
pub const MME_DMA_REDUCTION_REDUCTION_FORMAT: Range<u32> = 4..6;
pub const MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED: u32 = 0x00000000;
pub const MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED: u32 = 0x00000001;
pub const MME_DMA_REDUCTION_REDUCTION_SIZE: Range<u32> = 8..9;
pub const MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES: u32 = 0x00000000;
pub const MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES: u32 = 0x00000001;
pub const MME_DMA_SYSMEMBAR: u32 = 0x056c;
pub const MME_DMA_SYSMEMBAR_V: Range<u32> = 0..1;
pub const MME_DMA_SYNC: u32 = 0x0570;
pub const MME_DMA_SYNC_VALUE: Range<u32> = 0..32;
pub const SET_MME_DATA_FIFO_CONFIG: u32 = 0x0574;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE: Range<u32> = 0..3;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB: u32 = 0x00000000;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB: u32 = 0x00000001;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB: u32 = 0x00000002;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB: u32 = 0x00000003;
pub const SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB: u32 = 0x00000004;
pub const RENDER_SOLID_PRIM_MODE: u32 = 0x0580;
pub const RENDER_SOLID_PRIM_MODE_V: Range<u32> = 0..3;
pub const RENDER_SOLID_PRIM_MODE_V_POINTS: u32 = 0x00000000;
pub const RENDER_SOLID_PRIM_MODE_V_LINES: u32 = 0x00000001;
pub const RENDER_SOLID_PRIM_MODE_V_POLYLINE: u32 = 0x00000002;
pub const RENDER_SOLID_PRIM_MODE_V_TRIANGLES: u32 = 0x00000003;
pub const RENDER_SOLID_PRIM_MODE_V_RECTS: u32 = 0x00000004;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT: u32 = 0x0584;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V: Range<u32> = 0..8;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32_BF32_AF32: u32 = 0x000000C0;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF16_GF16_BF16_AF16: u32 = 0x000000CA;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_RF32_GF32: u32 = 0x000000CB;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8R8G8B8: u32 = 0x000000CF;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2R10G10B10: u32 = 0x000000DF;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A8B8G8R8: u32 = 0x000000D5;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A2B10G10R10: u32 = 0x000000D1;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8R8G8B8: u32 = 0x000000E6;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X8B8G8R8: u32 = 0x000000F9;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_R5G6B5: u32 = 0x000000E8;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_A1R5G5B5: u32 = 0x000000E9;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_X1R5G5B5: u32 = 0x000000F8;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y8: u32 = 0x000000F3;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y16: u32 = 0x000000EE;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Y32: u32 = 0x000000FF;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O1R5G5B5: u32 = 0x000000FC;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_RENDER_SOLID_PRIM_COLOR_FORMAT_V_O8R8G8B8: u32 = 0x000000FE;
pub const SET_RENDER_SOLID_PRIM_COLOR: u32 = 0x0588;
pub const SET_RENDER_SOLID_PRIM_COLOR_V: Range<u32> = 0..32;
pub const SET_RENDER_SOLID_LINE_TIE_BREAK_BITS: u32 = 0x058c;
pub const SET_RENDER_SOLID_LINE_TIE_BREAK_BITS_XMAJ__XINC__YINC: Range<u32> = 0..1;
pub const SET_RENDER_SOLID_LINE_TIE_BREAK_BITS_XMAJ__XDEC__YINC: Range<u32> = 4..5;
pub const SET_RENDER_SOLID_LINE_TIE_BREAK_BITS_YMAJ__XINC__YINC: Range<u32> = 8..9;
pub const SET_RENDER_SOLID_LINE_TIE_BREAK_BITS_YMAJ__XDEC__YINC: Range<u32> = 12..13;
pub const RENDER_SOLID_PRIM_POINT_X_Y: u32 = 0x05e0;
pub const RENDER_SOLID_PRIM_POINT_X_Y_X: Range<u32> = 0..16;
pub const RENDER_SOLID_PRIM_POINT_X_Y_Y: Range<u32> = 16..32;
#[inline]
pub fn render_solid_prim_point_set_x  (j: u32) -> u32 { 0x0600+j*8 } 
pub const RENDER_SOLID_PRIM_POINT_SET_X_V: Range<u32> = 0..32;
#[inline]
pub fn render_solid_prim_point_y  (j: u32) -> u32 { 0x0604+j*8 } 
pub const RENDER_SOLID_PRIM_POINT_Y_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DATA_TYPE: u32 = 0x0800;
pub const SET_PIXELS_FROM_CPU_DATA_TYPE_V: Range<u32> = 0..1;
pub const SET_PIXELS_FROM_CPU_DATA_TYPE_V_COLOR: u32 = 0x00000000;
pub const SET_PIXELS_FROM_CPU_DATA_TYPE_V_INDEX: u32 = 0x00000001;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT: u32 = 0x0804;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V: Range<u32> = 0..8;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8R8G8B8: u32 = 0x000000CF;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2R10G10B10: u32 = 0x000000DF;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A8B8G8R8: u32 = 0x000000D5;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A2B10G10R10: u32 = 0x000000D1;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8R8G8B8: u32 = 0x000000E6;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X8B8G8R8: u32 = 0x000000F9;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_R5G6B5: u32 = 0x000000E8;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_A1R5G5B5: u32 = 0x000000E9;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_X1R5G5B5: u32 = 0x000000F8;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y8: u32 = 0x000000F3;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y16: u32 = 0x000000EE;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Y32: u32 = 0x000000FF;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z1R5G5B5: u32 = 0x000000FB;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O1R5G5B5: u32 = 0x000000FC;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_Z8R8G8B8: u32 = 0x000000FD;
pub const SET_PIXELS_FROM_CPU_COLOR_FORMAT_V_O8R8G8B8: u32 = 0x000000FE;
pub const SET_PIXELS_FROM_CPU_INDEX_FORMAT: u32 = 0x0808;
pub const SET_PIXELS_FROM_CPU_INDEX_FORMAT_V: Range<u32> = 0..2;
pub const SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I1: u32 = 0x00000000;
pub const SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I4: u32 = 0x00000001;
pub const SET_PIXELS_FROM_CPU_INDEX_FORMAT_V_I8: u32 = 0x00000002;
pub const SET_PIXELS_FROM_CPU_MONO_FORMAT: u32 = 0x080c;
pub const SET_PIXELS_FROM_CPU_MONO_FORMAT_V: Range<u32> = 0..1;
pub const SET_PIXELS_FROM_CPU_MONO_FORMAT_V_CGA6_M1: u32 = 0x00000000;
pub const SET_PIXELS_FROM_CPU_MONO_FORMAT_V_LE_M1: u32 = 0x00000001;
pub const SET_PIXELS_FROM_CPU_WRAP: u32 = 0x0810;
pub const SET_PIXELS_FROM_CPU_WRAP_V: Range<u32> = 0..2;
pub const SET_PIXELS_FROM_CPU_WRAP_V_WRAP_PIXEL: u32 = 0x00000000;
pub const SET_PIXELS_FROM_CPU_WRAP_V_WRAP_BYTE: u32 = 0x00000001;
pub const SET_PIXELS_FROM_CPU_WRAP_V_WRAP_DWORD: u32 = 0x00000002;
pub const SET_PIXELS_FROM_CPU_COLOR0: u32 = 0x0814;
pub const SET_PIXELS_FROM_CPU_COLOR0_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_COLOR1: u32 = 0x0818;
pub const SET_PIXELS_FROM_CPU_COLOR1_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_MONO_OPACITY: u32 = 0x081c;
pub const SET_PIXELS_FROM_CPU_MONO_OPACITY_V: Range<u32> = 0..1;
pub const SET_PIXELS_FROM_CPU_MONO_OPACITY_V_TRANSPARENT: u32 = 0x00000000;
pub const SET_PIXELS_FROM_CPU_MONO_OPACITY_V_OPAQUE: u32 = 0x00000001;
pub const SET_PIXELS_FROM_CPU_SRC_WIDTH: u32 = 0x0838;
pub const SET_PIXELS_FROM_CPU_SRC_WIDTH_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_SRC_HEIGHT: u32 = 0x083c;
pub const SET_PIXELS_FROM_CPU_SRC_HEIGHT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DX_DU_FRAC: u32 = 0x0840;
pub const SET_PIXELS_FROM_CPU_DX_DU_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DX_DU_INT: u32 = 0x0844;
pub const SET_PIXELS_FROM_CPU_DX_DU_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DY_DV_FRAC: u32 = 0x0848;
pub const SET_PIXELS_FROM_CPU_DY_DV_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DY_DV_INT: u32 = 0x084c;
pub const SET_PIXELS_FROM_CPU_DY_DV_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DST_X0_FRAC: u32 = 0x0850;
pub const SET_PIXELS_FROM_CPU_DST_X0_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DST_X0_INT: u32 = 0x0854;
pub const SET_PIXELS_FROM_CPU_DST_X0_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DST_Y0_FRAC: u32 = 0x0858;
pub const SET_PIXELS_FROM_CPU_DST_Y0_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_CPU_DST_Y0_INT: u32 = 0x085c;
pub const SET_PIXELS_FROM_CPU_DST_Y0_INT_V: Range<u32> = 0..32;
pub const PIXELS_FROM_CPU_DATA: u32 = 0x0860;
pub const PIXELS_FROM_CPU_DATA_V: Range<u32> = 0..32;
pub const SET_BIG_ENDIAN_CONTROL: u32 = 0x0870;
pub const SET_BIG_ENDIAN_CONTROL_X32_SWAP_1: Range<u32> = 0..1;
pub const SET_BIG_ENDIAN_CONTROL_X32_SWAP_4: Range<u32> = 1..2;
pub const SET_BIG_ENDIAN_CONTROL_X32_SWAP_8: Range<u32> = 2..3;
pub const SET_BIG_ENDIAN_CONTROL_X32_SWAP_16: Range<u32> = 3..4;
pub const SET_BIG_ENDIAN_CONTROL_X16_SWAP_1: Range<u32> = 4..5;
pub const SET_BIG_ENDIAN_CONTROL_X16_SWAP_4: Range<u32> = 5..6;
pub const SET_BIG_ENDIAN_CONTROL_X16_SWAP_8: Range<u32> = 6..7;
pub const SET_BIG_ENDIAN_CONTROL_X16_SWAP_16: Range<u32> = 7..8;
pub const SET_BIG_ENDIAN_CONTROL_X8_SWAP_1: Range<u32> = 8..9;
pub const SET_BIG_ENDIAN_CONTROL_X8_SWAP_4: Range<u32> = 9..10;
pub const SET_BIG_ENDIAN_CONTROL_X8_SWAP_8: Range<u32> = 10..11;
pub const SET_BIG_ENDIAN_CONTROL_X8_SWAP_16: Range<u32> = 11..12;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_CGA6_SWAP_1: Range<u32> = 12..13;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_CGA6_SWAP_4: Range<u32> = 13..14;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_CGA6_SWAP_8: Range<u32> = 14..15;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_CGA6_SWAP_16: Range<u32> = 15..16;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_LE_SWAP_1: Range<u32> = 16..17;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_LE_SWAP_4: Range<u32> = 17..18;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_LE_SWAP_8: Range<u32> = 18..19;
pub const SET_BIG_ENDIAN_CONTROL_I1_X8_LE_SWAP_16: Range<u32> = 19..20;
pub const SET_BIG_ENDIAN_CONTROL_I4_SWAP_1: Range<u32> = 20..21;
pub const SET_BIG_ENDIAN_CONTROL_I4_SWAP_4: Range<u32> = 21..22;
pub const SET_BIG_ENDIAN_CONTROL_I4_SWAP_8: Range<u32> = 22..23;
pub const SET_BIG_ENDIAN_CONTROL_I4_SWAP_16: Range<u32> = 23..24;
pub const SET_BIG_ENDIAN_CONTROL_I8_SWAP_1: Range<u32> = 24..25;
pub const SET_BIG_ENDIAN_CONTROL_I8_SWAP_4: Range<u32> = 25..26;
pub const SET_BIG_ENDIAN_CONTROL_I8_SWAP_8: Range<u32> = 26..27;
pub const SET_BIG_ENDIAN_CONTROL_I8_SWAP_16: Range<u32> = 27..28;
pub const SET_BIG_ENDIAN_CONTROL_OVERRIDE: Range<u32> = 28..29;
pub const SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE: u32 = 0x0880;
pub const SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V: Range<u32> = 0..3;
pub const SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_AUTO: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_8X8: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_BLOCK_SHAPE_V_SHAPE_16X4: u32 = 0x00000002;
pub const SET_PIXELS_FROM_MEMORY_CORRAL_SIZE: u32 = 0x0884;
pub const SET_PIXELS_FROM_MEMORY_CORRAL_SIZE_V: Range<u32> = 0..10;
pub const SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP: u32 = 0x0888;
pub const SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V: Range<u32> = 0..1;
pub const SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_FALSE: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_SAFE_OVERLAP_V_TRUE: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE: u32 = 0x088c;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN: Range<u32> = 0..1;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CENTER: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_ORIGIN_CORNER: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER: Range<u32> = 4..5;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_POINT: u32 = 0x00000000;
pub const SET_PIXELS_FROM_MEMORY_SAMPLE_MODE_FILTER_BILINEAR: u32 = 0x00000001;
pub const SET_PIXELS_FROM_MEMORY_DST_X0: u32 = 0x08b0;
pub const SET_PIXELS_FROM_MEMORY_DST_X0_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DST_Y0: u32 = 0x08b4;
pub const SET_PIXELS_FROM_MEMORY_DST_Y0_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DST_WIDTH: u32 = 0x08b8;
pub const SET_PIXELS_FROM_MEMORY_DST_WIDTH_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DST_HEIGHT: u32 = 0x08bc;
pub const SET_PIXELS_FROM_MEMORY_DST_HEIGHT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DU_DX_FRAC: u32 = 0x08c0;
pub const SET_PIXELS_FROM_MEMORY_DU_DX_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DU_DX_INT: u32 = 0x08c4;
pub const SET_PIXELS_FROM_MEMORY_DU_DX_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DV_DY_FRAC: u32 = 0x08c8;
pub const SET_PIXELS_FROM_MEMORY_DV_DY_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_DV_DY_INT: u32 = 0x08cc;
pub const SET_PIXELS_FROM_MEMORY_DV_DY_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC: u32 = 0x08d0;
pub const SET_PIXELS_FROM_MEMORY_SRC_X0_FRAC_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_SRC_X0_INT: u32 = 0x08d4;
pub const SET_PIXELS_FROM_MEMORY_SRC_X0_INT_V: Range<u32> = 0..32;
pub const SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC: u32 = 0x08d8;
pub const SET_PIXELS_FROM_MEMORY_SRC_Y0_FRAC_V: Range<u32> = 0..32;
pub const PIXELS_FROM_MEMORY_SRC_Y0_INT: u32 = 0x08dc;
pub const PIXELS_FROM_MEMORY_SRC_Y0_INT_V: Range<u32> = 0..32;
pub const SET_FALCON00: u32 = 0x08e0;
pub const SET_FALCON00_V: Range<u32> = 0..32;
pub const SET_FALCON01: u32 = 0x08e4;
pub const SET_FALCON01_V: Range<u32> = 0..32;
pub const SET_FALCON02: u32 = 0x08e8;
pub const SET_FALCON02_V: Range<u32> = 0..32;
pub const SET_FALCON03: u32 = 0x08ec;
pub const SET_FALCON03_V: Range<u32> = 0..32;
pub const SET_FALCON04: u32 = 0x08f0;
pub const SET_FALCON04_V: Range<u32> = 0..32;
pub const SET_FALCON05: u32 = 0x08f4;
pub const SET_FALCON05_V: Range<u32> = 0..32;
pub const SET_FALCON06: u32 = 0x08f8;
pub const SET_FALCON06_V: Range<u32> = 0..32;
pub const SET_FALCON07: u32 = 0x08fc;
pub const SET_FALCON07_V: Range<u32> = 0..32;
pub const SET_FALCON08: u32 = 0x0900;
pub const SET_FALCON08_V: Range<u32> = 0..32;
pub const SET_FALCON09: u32 = 0x0904;
pub const SET_FALCON09_V: Range<u32> = 0..32;
pub const SET_FALCON10: u32 = 0x0908;
pub const SET_FALCON10_V: Range<u32> = 0..32;
pub const SET_FALCON11: u32 = 0x090c;
pub const SET_FALCON11_V: Range<u32> = 0..32;
pub const SET_FALCON12: u32 = 0x0910;
pub const SET_FALCON12_V: Range<u32> = 0..32;
pub const SET_FALCON13: u32 = 0x0914;
pub const SET_FALCON13_V: Range<u32> = 0..32;
pub const SET_FALCON14: u32 = 0x0918;
pub const SET_FALCON14_V: Range<u32> = 0..32;
pub const SET_FALCON15: u32 = 0x091c;
pub const SET_FALCON15_V: Range<u32> = 0..32;
pub const SET_FALCON16: u32 = 0x0920;
pub const SET_FALCON16_V: Range<u32> = 0..32;
pub const SET_FALCON17: u32 = 0x0924;
pub const SET_FALCON17_V: Range<u32> = 0..32;
pub const SET_FALCON18: u32 = 0x0928;
pub const SET_FALCON18_V: Range<u32> = 0..32;
pub const SET_FALCON19: u32 = 0x092c;
pub const SET_FALCON19_V: Range<u32> = 0..32;
pub const SET_FALCON20: u32 = 0x0930;
pub const SET_FALCON20_V: Range<u32> = 0..32;
pub const SET_FALCON21: u32 = 0x0934;
pub const SET_FALCON21_V: Range<u32> = 0..32;
pub const SET_FALCON22: u32 = 0x0938;
pub const SET_FALCON22_V: Range<u32> = 0..32;
pub const SET_FALCON23: u32 = 0x093c;
pub const SET_FALCON23_V: Range<u32> = 0..32;
pub const SET_FALCON24: u32 = 0x0940;
pub const SET_FALCON24_V: Range<u32> = 0..32;
pub const SET_FALCON25: u32 = 0x0944;
pub const SET_FALCON25_V: Range<u32> = 0..32;
pub const SET_FALCON26: u32 = 0x0948;
pub const SET_FALCON26_V: Range<u32> = 0..32;
pub const SET_FALCON27: u32 = 0x094c;
pub const SET_FALCON27_V: Range<u32> = 0..32;
pub const SET_FALCON28: u32 = 0x0950;
pub const SET_FALCON28_V: Range<u32> = 0..32;
pub const SET_FALCON29: u32 = 0x0954;
pub const SET_FALCON29_V: Range<u32> = 0..32;
pub const SET_FALCON30: u32 = 0x0958;
pub const SET_FALCON30_V: Range<u32> = 0..32;
pub const SET_FALCON31: u32 = 0x095c;
pub const SET_FALCON31_V: Range<u32> = 0..32;
pub const MME_DMA_WRITE_METHOD_BARRIER: u32 = 0x0dec;
pub const MME_DMA_WRITE_METHOD_BARRIER_V: Range<u32> = 0..1;
#[inline]
pub fn set_mme_shadow_scratch  (i: u32) -> u32 { 0x3400+i*4 } 
pub const SET_MME_SHADOW_SCRATCH_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_macro  (j: u32) -> u32 { 0x3800+j*8 } 
pub const CALL_MME_MACRO_V: Range<u32> = 0..32;
#[inline]
pub fn call_mme_data  (j: u32) -> u32 { 0x3804+j*8 } 
pub const CALL_MME_DATA_V: Range<u32> = 0..32;

// parsed class NV902D




#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetObject {
    pub class_id: u32,
    pub engine_id: u32,
}

impl Mthd for SetObject {
    const ADDR: u16 = 0x0000;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.class_id < (1 << 16));
        val |= self.class_id << 0;
            
        assert!(self.engine_id < (1 << 5));
        val |= self.engine_id << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoOperation {
    pub v: u32,
}

impl Mthd for NoOperation {
    const ADDR: u16 = 0x0100;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyA {
    pub address_upper: u32,
}

impl Mthd for SetNotifyA {
    const ADDR: u16 = 0x0104;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.address_upper < (1 << 25));
        val |= self.address_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNotifyB {
    pub address_lower: u32,
}

impl Mthd for SetNotifyB {
    const ADDR: u16 = 0x0108;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.address_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NotifyType {
    WriteOnly = 0x00000000,
    WriteThenAwaken = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Notify {
    pub type_: NotifyType,
}

impl Mthd for Notify {
    const ADDR: u16 = 0x010c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.type_ as u32;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdle {
    pub v: u32,
}

impl Mthd for WaitForIdle {
    const ADDR: u16 = 0x0110;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetGlobalRenderEnableA {
    const ADDR: u16 = 0x0130;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetGlobalRenderEnableB {
    const ADDR: u16 = 0x0134;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGlobalRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalRenderEnableC {
    pub mode: SetGlobalRenderEnableCMode,
}

impl Mthd for SetGlobalRenderEnableC {
    const ADDR: u16 = 0x0138;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendGoIdle {
    pub v: u32,
}

impl Mthd for SendGoIdle {
    const ADDR: u16 = 0x013c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTrigger {
    pub v: u32,
}

impl Mthd for PmTrigger {
    const ADDR: u16 = 0x0140;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodHeader {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodHeader {
    const ADDR: u16 = 0x0150;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstrumentationMethodData {
    pub v: u32,
}

impl Mthd for SetInstrumentationMethodData {
    const ADDR: u16 = 0x0154;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeSwitchState {
    pub valid: bool,
    pub save_macro: u32,
    pub restore_macro: u32,
}

impl Mthd for SetMmeSwitchState {
    const ADDR: u16 = 0x01ec;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;
            
        assert!(self.save_macro < (1 << 8));
        val |= self.save_macro << 4;
            
        assert!(self.restore_macro < (1 << 8));
        val |= self.restore_macro << 12;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstFormatV {
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    Y18X8 = 0x0000001c,
    Rf16 = 0x000000f2,
    Rf32 = 0x000000e5,
    Rf32Gf32 = 0x000000cb,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf16Gf16Bf16X16 = 0x000000ce,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf32Gf32Bf32X32 = 0x000000c3,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Bf10Gf11Rf11 = 0x000000e0,
    An8Bn8Gn8Rn8 = 0x000000d7,
    Rf16Gf16 = 0x000000de,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Rn16 = 0x000000ef,
    Rn8 = 0x000000f4,
    A8 = 0x000000f7,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstFormat {
    pub v: SetDstFormatV,
}

impl Mthd for SetDstFormat {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstMemoryLayoutV {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstMemoryLayout {
    pub v: SetDstMemoryLayoutV,
}

impl Mthd for SetDstMemoryLayout {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.height as u32) < (1 << 3));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 3));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstPitch {
    pub v: u32,
}

impl Mthd for SetDstPitch {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOffsetUpper {
    pub v: u32,
}

impl Mthd for SetDstOffsetUpper {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOffsetLower {
    pub v: u32,
}

impl Mthd for SetDstOffsetLower {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FlushAndInvalidateRopMiniCache {
    pub v: u32,
}

impl Mthd for FlushAndInvalidateRopMiniCache {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop06 {
    pub v: u32,
}

impl Mthd for SetSpareNoop06 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcFormatV {
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Ay8 = 0x0000001d,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    Y18X8 = 0x0000001c,
    Rf16 = 0x000000f2,
    Rf32 = 0x000000e5,
    Rf32Gf32 = 0x000000cb,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf16Gf16Bf16X16 = 0x000000ce,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf32Gf32Bf32X32 = 0x000000c3,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Bf10Gf11Rf11 = 0x000000e0,
    An8Bn8Gn8Rn8 = 0x000000d7,
    Rf16Gf16 = 0x000000de,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Rn16 = 0x000000ef,
    Rn8 = 0x000000f4,
    A8 = 0x000000f7,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcFormat {
    pub v: SetSrcFormatV,
}

impl Mthd for SetSrcFormat {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcMemoryLayoutV {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcMemoryLayout {
    pub v: SetSrcMemoryLayoutV,
}

impl Mthd for SetSrcMemoryLayout {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetSrcBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcBlockSize {
    pub height: SetSrcBlockSizeHeight,
    pub depth: SetSrcBlockSizeDepth,
}

impl Mthd for SetSrcBlockSize {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.height as u32) < (1 << 3));
        val |= (self.height as u32) << 4;
            
        assert!((self.depth as u32) < (1 << 3));
        val |= (self.depth as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcDepth {
    pub v: u32,
}

impl Mthd for SetSrcDepth {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum TwodInvalidateTextureDataCacheV {
    L1Only = 0x00000000,
    L2Only = 0x00000001,
    L1AndL2 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct TwodInvalidateTextureDataCache {
    pub v: TwodInvalidateTextureDataCacheV,
}

impl Mthd for TwodInvalidateTextureDataCache {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcPitch {
    pub v: u32,
}

impl Mthd for SetSrcPitch {
    const ADDR: u16 = 0x0244;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcWidth {
    pub v: u32,
}

impl Mthd for SetSrcWidth {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcHeight {
    pub v: u32,
}

impl Mthd for SetSrcHeight {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOffsetUpper {
    pub v: u32,
}

impl Mthd for SetSrcOffsetUpper {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSrcOffsetLower {
    pub v: u32,
}

impl Mthd for SetSrcOffsetLower {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySectorPromotionV {
    NoPromotion = 0x00000000,
    PromoteTo2V = 0x00000001,
    PromoteTo2H = 0x00000002,
    PromoteTo4 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySectorPromotion {
    pub v: SetPixelsFromMemorySectorPromotionV,
}

impl Mthd for SetPixelsFromMemorySectorPromotion {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop12 {
    pub v: u32,
}

impl Mthd for SetSpareNoop12 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetNumProcessingClustersV {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetNumProcessingClusters {
    pub v: SetNumProcessingClustersV,
}

impl Mthd for SetNumProcessingClusters {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableA {
    pub offset_upper: u32,
}

impl Mthd for SetRenderEnableA {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableB {
    pub offset_lower: u32,
}

impl Mthd for SetRenderEnableB {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.offset_lower;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableCMode {
    False = 0x00000000,
    True = 0x00000001,
    Conditional = 0x00000002,
    RenderIfEqual = 0x00000003,
    RenderIfNotEqual = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableC {
    pub mode: SetRenderEnableCMode,
}

impl Mthd for SetRenderEnableC {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 3));
        val |= (self.mode as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop08 {
    pub v: u32,
}

impl Mthd for SetSpareNoop08 {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetSpareNoop01 {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop11 {
    pub v: u32,
}

impl Mthd for SetSpareNoop11 {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop07 {
    pub v: u32,
}

impl Mthd for SetSpareNoop07 {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipX0 {
    pub v: u32,
}

impl Mthd for SetClipX0 {
    const ADDR: u16 = 0x0280;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipY0 {
    pub v: u32,
}

impl Mthd for SetClipY0 {
    const ADDR: u16 = 0x0284;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipWidth {
    pub v: u32,
}

impl Mthd for SetClipWidth {
    const ADDR: u16 = 0x0288;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipHeight {
    pub v: u32,
}

impl Mthd for SetClipHeight {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClipEnable {
    pub v: bool,
}

impl Mthd for SetClipEnable {
    const ADDR: u16 = 0x0290;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorKeyFormatV {
    A16R5G6B5 = 0x00000000,
    A1R5G5B5 = 0x00000001,
    A8R8G8B8 = 0x00000002,
    A2R10G10B10 = 0x00000003,
    Y8 = 0x00000004,
    Y16 = 0x00000005,
    Y32 = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKeyFormat {
    pub v: SetColorKeyFormatV,
}

impl Mthd for SetColorKeyFormat {
    const ADDR: u16 = 0x0294;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKey {
    pub v: u32,
}

impl Mthd for SetColorKey {
    const ADDR: u16 = 0x0298;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorKeyEnable {
    pub v: bool,
}

impl Mthd for SetColorKeyEnable {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRop {
    pub v: u32,
}

impl Mthd for SetRop {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBeta1 {
    pub v: u32,
}

impl Mthd for SetBeta1 {
    const ADDR: u16 = 0x02a4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBeta4 {
    pub b: u32,
    pub g: u32,
    pub r: u32,
    pub a: u32,
}

impl Mthd for SetBeta4 {
    const ADDR: u16 = 0x02a8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.b < (1 << 8));
        val |= self.b << 0;
            
        assert!(self.g < (1 << 8));
        val |= self.g << 8;
            
        assert!(self.r < (1 << 8));
        val |= self.r << 16;
            
        assert!(self.a < (1 << 8));
        val |= self.a << 24;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetOperationV {
    SrccopyAnd = 0x00000000,
    RopAnd = 0x00000001,
    BlendAnd = 0x00000002,
    Srccopy = 0x00000003,
    Rop = 0x00000004,
    SrccopyPremult = 0x00000005,
    BlendPremult = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetOperation {
    pub v: SetOperationV,
}

impl Mthd for SetOperation {
    const ADDR: u16 = 0x02ac;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatternOffset {
    pub x: u32,
    pub y: u32,
}

impl Mthd for SetPatternOffset {
    const ADDR: u16 = 0x02b0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.x < (1 << 6));
        val |= self.x << 0;
            
        assert!(self.y < (1 << 6));
        val |= self.y << 8;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPatternSelectV {
    Monochrome8X8 = 0x00000000,
    Monochrome64X1 = 0x00000001,
    Monochrome1X64 = 0x00000002,
    Color = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPatternSelect {
    pub v: SetPatternSelectV,
}

impl Mthd for SetPatternSelect {
    const ADDR: u16 = 0x02b4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstColorRenderToZetaSurface {
    pub v: bool,
}

impl Mthd for SetDstColorRenderToZetaSurface {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop04 {
    pub v: u32,
}

impl Mthd for SetSpareNoop04 {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop15 {
    pub v: u32,
}

impl Mthd for SetSpareNoop15 {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop13 {
    pub v: u32,
}

impl Mthd for SetSpareNoop13 {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetSpareNoop03 {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop14 {
    pub v: u32,
}

impl Mthd for SetSpareNoop14 {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetSpareNoop02 {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCompression {
    pub enable: bool,
}

impl Mthd for SetCompression {
    const ADDR: u16 = 0x02d4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop09 {
    pub v: u32,
}

impl Mthd for SetSpareNoop09 {
    const ADDR: u16 = 0x02d8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderEnableOverrideMode {
    UseRenderEnable = 0x00000000,
    AlwaysRender = 0x00000001,
    NeverRender = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderEnableOverride {
    pub mode: SetRenderEnableOverrideMode,
}

impl Mthd for SetRenderEnableOverride {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryDirectionHorizontal {
    HwDecides = 0x00000000,
    LeftToRight = 0x00000001,
    RightToLeft = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryDirectionVertical {
    HwDecides = 0x00000000,
    TopToBottom = 0x00000001,
    BottomToTop = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDirection {
    pub horizontal: SetPixelsFromMemoryDirectionHorizontal,
    pub vertical: SetPixelsFromMemoryDirectionVertical,
}

impl Mthd for SetPixelsFromMemoryDirection {
    const ADDR: u16 = 0x02e0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.horizontal as u32) < (1 << 2));
        val |= (self.horizontal as u32) << 0;
            
        assert!((self.vertical as u32) < (1 << 2));
        val |= (self.vertical as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareNoop10 {
    pub v: u32,
}

impl Mthd for SetSpareNoop10 {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMonochromePatternColorFormatV {
    A8X8R5G6B5 = 0x00000000,
    A1R5G5B5 = 0x00000001,
    A8R8G8B8 = 0x00000002,
    A8Y8 = 0x00000003,
    A8X8Y16 = 0x00000004,
    Y32 = 0x00000005,
    ByteExpand = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColorFormat {
    pub v: SetMonochromePatternColorFormatV,
}

impl Mthd for SetMonochromePatternColorFormat {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMonochromePatternFormatV {
    Cga6M1 = 0x00000000,
    LeM1 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternFormat {
    pub v: SetMonochromePatternFormatV,
}

impl Mthd for SetMonochromePatternFormat {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColor0 {
    pub v: u32,
}

impl Mthd for SetMonochromePatternColor0 {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePatternColor1 {
    pub v: u32,
}

impl Mthd for SetMonochromePatternColor1 {
    const ADDR: u16 = 0x02f4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePattern0 {
    pub v: u32,
}

impl Mthd for SetMonochromePattern0 {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMonochromePattern1 {
    pub v: u32,
}

impl Mthd for SetMonochromePattern1 {
    const ADDR: u16 = 0x02fc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternX8R8G8B8 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub ignore0: u32,
}

impl ArrayMthd for ColorPatternX8R8G8B8 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0300+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.b0 < (1 << 8));
        val |= self.b0 << 0;
            
        assert!(self.g0 < (1 << 8));
        val |= self.g0 << 8;
            
        assert!(self.r0 < (1 << 8));
        val |= self.r0 << 16;
            
        assert!(self.ignore0 < (1 << 8));
        val |= self.ignore0 << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternR5G6B5 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub b1: u32,
    pub g1: u32,
    pub r1: u32,
}

impl ArrayMthd for ColorPatternR5G6B5 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.b0 < (1 << 5));
        val |= self.b0 << 0;
            
        assert!(self.g0 < (1 << 6));
        val |= self.g0 << 5;
            
        assert!(self.r0 < (1 << 5));
        val |= self.r0 << 11;
            
        assert!(self.b1 < (1 << 5));
        val |= self.b1 << 16;
            
        assert!(self.g1 < (1 << 6));
        val |= self.g1 << 21;
            
        assert!(self.r1 < (1 << 5));
        val |= self.r1 << 27;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternX1R5G5B5 {
    pub b0: u32,
    pub g0: u32,
    pub r0: u32,
    pub ignore0: u32,
    pub b1: u32,
    pub g1: u32,
    pub r1: u32,
    pub ignore1: u32,
}

impl ArrayMthd for ColorPatternX1R5G5B5 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0480+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.b0 < (1 << 5));
        val |= self.b0 << 0;
            
        assert!(self.g0 < (1 << 5));
        val |= self.g0 << 5;
            
        assert!(self.r0 < (1 << 5));
        val |= self.r0 << 10;
            
        assert!(self.ignore0 < (1 << 1));
        val |= self.ignore0 << 15;
            
        assert!(self.b1 < (1 << 5));
        val |= self.b1 << 16;
            
        assert!(self.g1 < (1 << 5));
        val |= self.g1 << 21;
            
        assert!(self.r1 < (1 << 5));
        val |= self.r1 << 26;
            
        assert!(self.ignore1 < (1 << 1));
        val |= self.ignore1 << 31;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ColorPatternY8 {
    pub y0: u32,
    pub y1: u32,
    pub y2: u32,
    pub y3: u32,
}

impl ArrayMthd for ColorPatternY8 {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0500+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.y0 < (1 << 8));
        val |= self.y0 << 0;
            
        assert!(self.y1 < (1 << 8));
        val |= self.y1 << 8;
            
        assert!(self.y2 < (1 << 8));
        val |= self.y2 << 16;
            
        assert!(self.y3 < (1 << 8));
        val |= self.y3 << 24;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor0 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor0 {
    const ADDR: u16 = 0x0540;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor1 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor1 {
    const ADDR: u16 = 0x0544;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor2 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor2 {
    const ADDR: u16 = 0x0548;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor3 {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor3 {
    const ADDR: u16 = 0x054c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressA {
    pub upper: u32,
}

impl Mthd for SetMmeMemAddressA {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.upper < (1 << 25));
        val |= self.upper << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressB {
    pub lower: u32,
}

impl Mthd for SetMmeMemAddressB {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.lower;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataRamAddress {
    pub word: u32,
}

impl Mthd for SetMmeDataRamAddress {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.word;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaRead {
    pub length: u32,
}

impl Mthd for MmeDmaRead {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.length;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReadFifoed {
    pub length: u32,
}

impl Mthd for MmeDmaReadFifoed {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.length;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWrite {
    pub length: u32,
}

impl Mthd for MmeDmaWrite {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.length;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionSize {
    FourBytes = 0x00000000,
    EightBytes = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReduction {
    pub reduction_op: MmeDmaReductionReductionOp,
    pub reduction_format: MmeDmaReductionReductionFormat,
    pub reduction_size: MmeDmaReductionReductionSize,
}

impl Mthd for MmeDmaReduction {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 0;
            
        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 4;
            
        assert!((self.reduction_size as u32) < (1 << 1));
        val |= (self.reduction_size as u32) << 8;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSysmembar {
    pub v: u32,
}

impl Mthd for MmeDmaSysmembar {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSync {
    pub value: u32,
}

impl Mthd for MmeDmaSync {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.value;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeDataFifoConfigFifoSize {
    Size0Kb = 0x00000000,
    Size4Kb = 0x00000001,
    Size8Kb = 0x00000002,
    Size12Kb = 0x00000003,
    Size16Kb = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataFifoConfig {
    pub fifo_size: SetMmeDataFifoConfigFifoSize,
}

impl Mthd for SetMmeDataFifoConfig {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.fifo_size as u32) < (1 << 3));
        val |= (self.fifo_size as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum RenderSolidPrimModeV {
    Points = 0x00000000,
    Lines = 0x00000001,
    Polyline = 0x00000002,
    Triangles = 0x00000003,
    Rects = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimMode {
    pub v: RenderSolidPrimModeV,
}

impl Mthd for RenderSolidPrimMode {
    const ADDR: u16 = 0x0580;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetRenderSolidPrimColorFormatV {
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    A8R8G8B8 = 0x000000cf,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8B8G8R8 = 0x000000f9,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColorFormat {
    pub v: SetRenderSolidPrimColorFormatV,
}

impl Mthd for SetRenderSolidPrimColorFormat {
    const ADDR: u16 = 0x0584;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidPrimColor {
    pub v: u32,
}

impl Mthd for SetRenderSolidPrimColor {
    const ADDR: u16 = 0x0588;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRenderSolidLineTieBreakBits {
    pub xmaj__xinc__yinc: u32,
    pub xmaj__xdec__yinc: u32,
    pub ymaj__xinc__yinc: u32,
    pub ymaj__xdec__yinc: u32,
}

impl Mthd for SetRenderSolidLineTieBreakBits {
    const ADDR: u16 = 0x058c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.xmaj__xinc__yinc < (1 << 1));
        val |= self.xmaj__xinc__yinc << 0;
            
        assert!(self.xmaj__xdec__yinc < (1 << 1));
        val |= self.xmaj__xdec__yinc << 4;
            
        assert!(self.ymaj__xinc__yinc < (1 << 1));
        val |= self.ymaj__xinc__yinc << 8;
            
        assert!(self.ymaj__xdec__yinc < (1 << 1));
        val |= self.ymaj__xdec__yinc << 12;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointXY {
    pub x: u32,
    pub y: u32,
}

impl Mthd for RenderSolidPrimPointXY {
    const ADDR: u16 = 0x05e0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.x < (1 << 16));
        val |= self.x << 0;
            
        assert!(self.y < (1 << 16));
        val |= self.y << 16;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointSetX {
    pub v: u32,
}

impl ArrayMthd for RenderSolidPrimPointSetX {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0600+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct RenderSolidPrimPointY {
    pub v: u32,
}

impl ArrayMthd for RenderSolidPrimPointY {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x0604+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuDataTypeV {
    Color = 0x00000000,
    Index = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDataType {
    pub v: SetPixelsFromCpuDataTypeV,
}

impl Mthd for SetPixelsFromCpuDataType {
    const ADDR: u16 = 0x0800;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuColorFormatV {
    A8R8G8B8 = 0x000000cf,
    A2R10G10B10 = 0x000000df,
    A8B8G8R8 = 0x000000d5,
    A2B10G10R10 = 0x000000d1,
    X8R8G8B8 = 0x000000e6,
    X8B8G8R8 = 0x000000f9,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    X1R5G5B5 = 0x000000f8,
    Y8 = 0x000000f3,
    Y16 = 0x000000ee,
    Y32 = 0x000000ff,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColorFormat {
    pub v: SetPixelsFromCpuColorFormatV,
}

impl Mthd for SetPixelsFromCpuColorFormat {
    const ADDR: u16 = 0x0804;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuIndexFormatV {
    I1 = 0x00000000,
    I4 = 0x00000001,
    I8 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuIndexFormat {
    pub v: SetPixelsFromCpuIndexFormatV,
}

impl Mthd for SetPixelsFromCpuIndexFormat {
    const ADDR: u16 = 0x0808;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuMonoFormatV {
    Cga6M1 = 0x00000000,
    LeM1 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuMonoFormat {
    pub v: SetPixelsFromCpuMonoFormatV,
}

impl Mthd for SetPixelsFromCpuMonoFormat {
    const ADDR: u16 = 0x080c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuWrapV {
    WrapPixel = 0x00000000,
    WrapByte = 0x00000001,
    WrapDword = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuWrap {
    pub v: SetPixelsFromCpuWrapV,
}

impl Mthd for SetPixelsFromCpuWrap {
    const ADDR: u16 = 0x0810;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 2));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColor0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuColor0 {
    const ADDR: u16 = 0x0814;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuColor1 {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuColor1 {
    const ADDR: u16 = 0x0818;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromCpuMonoOpacityV {
    Transparent = 0x00000000,
    Opaque = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuMonoOpacity {
    pub v: SetPixelsFromCpuMonoOpacityV,
}

impl Mthd for SetPixelsFromCpuMonoOpacity {
    const ADDR: u16 = 0x081c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuSrcWidth {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuSrcWidth {
    const ADDR: u16 = 0x0838;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuSrcHeight {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuSrcHeight {
    const ADDR: u16 = 0x083c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDxDuFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDxDuFrac {
    const ADDR: u16 = 0x0840;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDxDuInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDxDuInt {
    const ADDR: u16 = 0x0844;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDyDvFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDyDvFrac {
    const ADDR: u16 = 0x0848;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDyDvInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDyDvInt {
    const ADDR: u16 = 0x084c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstX0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstX0Frac {
    const ADDR: u16 = 0x0850;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstX0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstX0Int {
    const ADDR: u16 = 0x0854;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstY0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstY0Frac {
    const ADDR: u16 = 0x0858;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromCpuDstY0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromCpuDstY0Int {
    const ADDR: u16 = 0x085c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelsFromCpuData {
    pub v: u32,
}

impl Mthd for PixelsFromCpuData {
    const ADDR: u16 = 0x0860;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBigEndianControl {
    pub x32_swap_1: u32,
    pub x32_swap_4: u32,
    pub x32_swap_8: u32,
    pub x32_swap_16: u32,
    pub x16_swap_1: u32,
    pub x16_swap_4: u32,
    pub x16_swap_8: u32,
    pub x16_swap_16: u32,
    pub x8_swap_1: u32,
    pub x8_swap_4: u32,
    pub x8_swap_8: u32,
    pub x8_swap_16: u32,
    pub i1_x8_cga6_swap_1: u32,
    pub i1_x8_cga6_swap_4: u32,
    pub i1_x8_cga6_swap_8: u32,
    pub i1_x8_cga6_swap_16: u32,
    pub i1_x8_le_swap_1: u32,
    pub i1_x8_le_swap_4: u32,
    pub i1_x8_le_swap_8: u32,
    pub i1_x8_le_swap_16: u32,
    pub i4_swap_1: u32,
    pub i4_swap_4: u32,
    pub i4_swap_8: u32,
    pub i4_swap_16: u32,
    pub i8_swap_1: u32,
    pub i8_swap_4: u32,
    pub i8_swap_8: u32,
    pub i8_swap_16: u32,
    pub override_: u32,
}

impl Mthd for SetBigEndianControl {
    const ADDR: u16 = 0x0870;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.x32_swap_1 < (1 << 1));
        val |= self.x32_swap_1 << 0;
            
        assert!(self.x32_swap_4 < (1 << 1));
        val |= self.x32_swap_4 << 1;
            
        assert!(self.x32_swap_8 < (1 << 1));
        val |= self.x32_swap_8 << 2;
            
        assert!(self.x32_swap_16 < (1 << 1));
        val |= self.x32_swap_16 << 3;
            
        assert!(self.x16_swap_1 < (1 << 1));
        val |= self.x16_swap_1 << 4;
            
        assert!(self.x16_swap_4 < (1 << 1));
        val |= self.x16_swap_4 << 5;
            
        assert!(self.x16_swap_8 < (1 << 1));
        val |= self.x16_swap_8 << 6;
            
        assert!(self.x16_swap_16 < (1 << 1));
        val |= self.x16_swap_16 << 7;
            
        assert!(self.x8_swap_1 < (1 << 1));
        val |= self.x8_swap_1 << 8;
            
        assert!(self.x8_swap_4 < (1 << 1));
        val |= self.x8_swap_4 << 9;
            
        assert!(self.x8_swap_8 < (1 << 1));
        val |= self.x8_swap_8 << 10;
            
        assert!(self.x8_swap_16 < (1 << 1));
        val |= self.x8_swap_16 << 11;
            
        assert!(self.i1_x8_cga6_swap_1 < (1 << 1));
        val |= self.i1_x8_cga6_swap_1 << 12;
            
        assert!(self.i1_x8_cga6_swap_4 < (1 << 1));
        val |= self.i1_x8_cga6_swap_4 << 13;
            
        assert!(self.i1_x8_cga6_swap_8 < (1 << 1));
        val |= self.i1_x8_cga6_swap_8 << 14;
            
        assert!(self.i1_x8_cga6_swap_16 < (1 << 1));
        val |= self.i1_x8_cga6_swap_16 << 15;
            
        assert!(self.i1_x8_le_swap_1 < (1 << 1));
        val |= self.i1_x8_le_swap_1 << 16;
            
        assert!(self.i1_x8_le_swap_4 < (1 << 1));
        val |= self.i1_x8_le_swap_4 << 17;
            
        assert!(self.i1_x8_le_swap_8 < (1 << 1));
        val |= self.i1_x8_le_swap_8 << 18;
            
        assert!(self.i1_x8_le_swap_16 < (1 << 1));
        val |= self.i1_x8_le_swap_16 << 19;
            
        assert!(self.i4_swap_1 < (1 << 1));
        val |= self.i4_swap_1 << 20;
            
        assert!(self.i4_swap_4 < (1 << 1));
        val |= self.i4_swap_4 << 21;
            
        assert!(self.i4_swap_8 < (1 << 1));
        val |= self.i4_swap_8 << 22;
            
        assert!(self.i4_swap_16 < (1 << 1));
        val |= self.i4_swap_16 << 23;
            
        assert!(self.i8_swap_1 < (1 << 1));
        val |= self.i8_swap_1 << 24;
            
        assert!(self.i8_swap_4 < (1 << 1));
        val |= self.i8_swap_4 << 25;
            
        assert!(self.i8_swap_8 < (1 << 1));
        val |= self.i8_swap_8 << 26;
            
        assert!(self.i8_swap_16 < (1 << 1));
        val |= self.i8_swap_16 << 27;
            
        assert!(self.override_ < (1 << 1));
        val |= self.override_ << 28;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemoryBlockShapeV {
    Auto = 0x00000000,
    Shape8X8 = 0x00000001,
    Shape16X4 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryBlockShape {
    pub v: SetPixelsFromMemoryBlockShapeV,
}

impl Mthd for SetPixelsFromMemoryBlockShape {
    const ADDR: u16 = 0x0880;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 3));
        val |= (self.v as u32) << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryCorralSize {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryCorralSize {
    const ADDR: u16 = 0x0884;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 10));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySafeOverlap {
    pub v: bool,
}

impl Mthd for SetPixelsFromMemorySafeOverlap {
    const ADDR: u16 = 0x0888;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}


#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySampleModeOrigin {
    Center = 0x00000000,
    Corner = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelsFromMemorySampleModeFilter {
    Point = 0x00000000,
    Bilinear = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySampleMode {
    pub origin: SetPixelsFromMemorySampleModeOrigin,
    pub filter: SetPixelsFromMemorySampleModeFilter,
}

impl Mthd for SetPixelsFromMemorySampleMode {
    const ADDR: u16 = 0x088c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!((self.origin as u32) < (1 << 1));
        val |= (self.origin as u32) << 0;
            
        assert!((self.filter as u32) < (1 << 1));
        val |= (self.filter as u32) << 4;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstX0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstX0 {
    const ADDR: u16 = 0x08b0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstY0 {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstY0 {
    const ADDR: u16 = 0x08b4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstWidth {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstWidth {
    const ADDR: u16 = 0x08b8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDstHeight {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDstHeight {
    const ADDR: u16 = 0x08bc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDuDxFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDuDxFrac {
    const ADDR: u16 = 0x08c0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDuDxInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDuDxInt {
    const ADDR: u16 = 0x08c4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDvDyFrac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDvDyFrac {
    const ADDR: u16 = 0x08c8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemoryDvDyInt {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemoryDvDyInt {
    const ADDR: u16 = 0x08cc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcX0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcX0Frac {
    const ADDR: u16 = 0x08d0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcX0Int {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcX0Int {
    const ADDR: u16 = 0x08d4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelsFromMemorySrcY0Frac {
    pub v: u32,
}

impl Mthd for SetPixelsFromMemorySrcY0Frac {
    const ADDR: u16 = 0x08d8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelsFromMemorySrcY0Int {
    pub v: u32,
}

impl Mthd for PixelsFromMemorySrcY0Int {
    const ADDR: u16 = 0x08dc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon00 {
    pub v: u32,
}

impl Mthd for SetFalcon00 {
    const ADDR: u16 = 0x08e0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon01 {
    pub v: u32,
}

impl Mthd for SetFalcon01 {
    const ADDR: u16 = 0x08e4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon02 {
    pub v: u32,
}

impl Mthd for SetFalcon02 {
    const ADDR: u16 = 0x08e8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon03 {
    pub v: u32,
}

impl Mthd for SetFalcon03 {
    const ADDR: u16 = 0x08ec;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon04 {
    pub v: u32,
}

impl Mthd for SetFalcon04 {
    const ADDR: u16 = 0x08f0;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon05 {
    pub v: u32,
}

impl Mthd for SetFalcon05 {
    const ADDR: u16 = 0x08f4;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon06 {
    pub v: u32,
}

impl Mthd for SetFalcon06 {
    const ADDR: u16 = 0x08f8;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon07 {
    pub v: u32,
}

impl Mthd for SetFalcon07 {
    const ADDR: u16 = 0x08fc;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon08 {
    pub v: u32,
}

impl Mthd for SetFalcon08 {
    const ADDR: u16 = 0x0900;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon09 {
    pub v: u32,
}

impl Mthd for SetFalcon09 {
    const ADDR: u16 = 0x0904;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon10 {
    pub v: u32,
}

impl Mthd for SetFalcon10 {
    const ADDR: u16 = 0x0908;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon11 {
    pub v: u32,
}

impl Mthd for SetFalcon11 {
    const ADDR: u16 = 0x090c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon12 {
    pub v: u32,
}

impl Mthd for SetFalcon12 {
    const ADDR: u16 = 0x0910;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon13 {
    pub v: u32,
}

impl Mthd for SetFalcon13 {
    const ADDR: u16 = 0x0914;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon14 {
    pub v: u32,
}

impl Mthd for SetFalcon14 {
    const ADDR: u16 = 0x0918;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon15 {
    pub v: u32,
}

impl Mthd for SetFalcon15 {
    const ADDR: u16 = 0x091c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon16 {
    pub v: u32,
}

impl Mthd for SetFalcon16 {
    const ADDR: u16 = 0x0920;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon17 {
    pub v: u32,
}

impl Mthd for SetFalcon17 {
    const ADDR: u16 = 0x0924;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon18 {
    pub v: u32,
}

impl Mthd for SetFalcon18 {
    const ADDR: u16 = 0x0928;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon19 {
    pub v: u32,
}

impl Mthd for SetFalcon19 {
    const ADDR: u16 = 0x092c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon20 {
    pub v: u32,
}

impl Mthd for SetFalcon20 {
    const ADDR: u16 = 0x0930;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon21 {
    pub v: u32,
}

impl Mthd for SetFalcon21 {
    const ADDR: u16 = 0x0934;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon22 {
    pub v: u32,
}

impl Mthd for SetFalcon22 {
    const ADDR: u16 = 0x0938;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon23 {
    pub v: u32,
}

impl Mthd for SetFalcon23 {
    const ADDR: u16 = 0x093c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon24 {
    pub v: u32,
}

impl Mthd for SetFalcon24 {
    const ADDR: u16 = 0x0940;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon25 {
    pub v: u32,
}

impl Mthd for SetFalcon25 {
    const ADDR: u16 = 0x0944;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon26 {
    pub v: u32,
}

impl Mthd for SetFalcon26 {
    const ADDR: u16 = 0x0948;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon27 {
    pub v: u32,
}

impl Mthd for SetFalcon27 {
    const ADDR: u16 = 0x094c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon28 {
    pub v: u32,
}

impl Mthd for SetFalcon28 {
    const ADDR: u16 = 0x0950;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon29 {
    pub v: u32,
}

impl Mthd for SetFalcon29 {
    const ADDR: u16 = 0x0954;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon30 {
    pub v: u32,
}

impl Mthd for SetFalcon30 {
    const ADDR: u16 = 0x0958;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFalcon31 {
    pub v: u32,
}

impl Mthd for SetFalcon31 {
    const ADDR: u16 = 0x095c;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWriteMethodBarrier {
    pub v: u32,
}

impl Mthd for MmeDmaWriteMethodBarrier {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0x902d;


    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowScratch {
    pub v: u32,
}

impl ArrayMthd for SetMmeShadowScratch {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x3400+i*4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x3800+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}



#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0x902d;

    fn addr(i: usize) -> u16 {
        
        (0x3804+i*8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;
            
        val |= self.v;

        val
    }
}
