#include "nak_private.h"
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 5
 * transforms:
 *    ('imin', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), 'a', 'b')
 *    ('imax', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), 'b', 'a')
 *    ('umin', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 'a', 'b')
 *    ('umax', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 'b', 'a')
 *    ('iadd', 'a@64', ('ineg', 'b@64')) => ('isub', 'a', 'b')
 */


static const nir_search_value_union nak_nir_lower_algebraic_late_values[] = {
   /* ('imin', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   /* replace0_1 -> 0 in the cache */
   /* replace0_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 3, 0, 1 },
      -1,
   } },

   /* ('imax', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), 'b', 'a') */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   /* replace1_0 -> 3 in the cache */
   /* replace1_1 -> 1 in the cache */
   /* replace1_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* ('umin', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 'a', 'b') */
   /* search2_0 -> 0 in the cache */
   /* search2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace2_0_0 -> 0 in the cache */
   /* replace2_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   /* replace2_1 -> 0 in the cache */
   /* replace2_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 8, 0, 1 },
      -1,
   } },

   /* ('umax', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 'b', 'a') */
   /* search3_0 -> 0 in the cache */
   /* search3_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* replace3_0_0 -> 0 in the cache */
   /* replace3_0_1 -> 1 in the cache */
   /* replace3_0 -> 8 in the cache */
   /* replace3_1 -> 1 in the cache */
   /* replace3_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_bcsel,
      -1, 0,
      { 8, 1, 0 },
      -1,
   } },

   /* ('iadd', 'a@64', ('ineg', 'b@64')) => ('isub', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_ineg,
      -1, 0,
      { 13 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_iadd,
      0, 1,
      { 12, 14 },
      -1,
   } },

   /* replace4_0 -> 12 in the cache */
   /* replace4_1 -> 13 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      nir_op_isub,
      -1, 0,
      { 12, 13 },
      -1,
   } },

};



static const struct transform nak_nir_lower_algebraic_late_transforms[] = {
   { ~0, ~0, ~0 }, /* Sentinel */

   { 2, 4, 1 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 5, 6, 1 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 7, 9, 1 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 10, 11, 1 },
   { ~0, ~0, ~0 }, /* Sentinel */

   { 15, 16, 0 },
   { ~0, ~0, ~0 }, /* Sentinel */

};

static const struct per_op_table nak_nir_lower_algebraic_late_pass_op_table[nir_num_search_ops] = {
   [nir_op_imin] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         2,
      },
   },
   [nir_op_imax] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         3,
      },
   },
   [nir_op_umin] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         4,
      },
   },
   [nir_op_umax] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         5,
      },
   },
   [nir_op_iadd] = {
      .filter = (const uint16_t []) {
         0,
         0,
         0,
         0,
         0,
         0,
         1,
         0,
      },
      
      .num_filtered_states = 2,
      .table = (const uint16_t []) {
      
         0,
         7,
         7,
         7,
      },
   },
   [nir_op_ineg] = {
      .filter = NULL,
      
      .num_filtered_states = 1,
      .table = (const uint16_t []) {
      
         6,
      },
   },
};

/* Mapping from state index to offset in transforms (0 being no transforms) */
static const uint16_t nak_nir_lower_algebraic_late_transform_offsets[] = {
   0,
   0,
   1,
   3,
   5,
   7,
   0,
   9,
};

static const nir_algebraic_table nak_nir_lower_algebraic_late_table = {
   .transforms = nak_nir_lower_algebraic_late_transforms,
   .transform_offsets = nak_nir_lower_algebraic_late_transform_offsets,
   .pass_op_table = nak_nir_lower_algebraic_late_pass_op_table,
   .values = nak_nir_lower_algebraic_late_values,
   .expression_cond = NULL,
   .variable_cond = NULL,
};

bool
nak_nir_lower_algebraic_late(
   nir_shader *shader
   , const struct nak_compiler * nak
) {
   bool progress = false;
   bool condition_flags[2];
   const nir_shader_compiler_options *options = shader->options;
   const shader_info *info = &shader->info;
   (void) options;
   (void) info;

   STATIC_ASSERT(17 == ARRAY_SIZE(nak_nir_lower_algebraic_late_values));
   condition_flags[0] = true;
   condition_flags[1] = nak->sm >= 70 && nak->sm < 75;

   nir_foreach_function_impl(impl, shader) {
     progress |= nir_algebraic_impl(impl, condition_flags, &nak_nir_lower_algebraic_late_table);
   }

   return progress;
}
