/* automatically generated by rust-bindgen 0.71.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize);
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte =
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize);
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if Self::raw_get_bit(this, i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            Self::raw_set_bit(this, index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
pub const PIPE_BUF: u32 = 4096;
pub const PIPE_ATOMIC: &[u8; 20] = b"GCC Sync Intrinsics\0";
pub const PIPE_MASK_R: u32 = 1;
pub const PIPE_MASK_G: u32 = 2;
pub const PIPE_MASK_B: u32 = 4;
pub const PIPE_MASK_A: u32 = 8;
pub const PIPE_MASK_RGBA: u32 = 15;
pub const PIPE_MASK_Z: u32 = 16;
pub const PIPE_MASK_S: u32 = 32;
pub const PIPE_MASK_ZS: u32 = 48;
pub const PIPE_MASK_RGBAZS: u32 = 63;
pub const NIR_DEBUG_CLONE: u32 = 1;
pub const NIR_DEBUG_SERIALIZE: u32 = 2;
pub const NIR_DEBUG_NOVALIDATE: u32 = 4;
pub const NIR_DEBUG_TGSI: u32 = 16;
pub const NIR_DEBUG_PRINT_VS: u32 = 32;
pub const NIR_DEBUG_PRINT_TCS: u32 = 64;
pub const NIR_DEBUG_PRINT_TES: u32 = 128;
pub const NIR_DEBUG_PRINT_GS: u32 = 256;
pub const NIR_DEBUG_PRINT_FS: u32 = 512;
pub const NIR_DEBUG_PRINT_CS: u32 = 1024;
pub const NIR_DEBUG_PRINT_TS: u32 = 2048;
pub const NIR_DEBUG_PRINT_MS: u32 = 4096;
pub const NIR_DEBUG_PRINT_RGS: u32 = 8192;
pub const NIR_DEBUG_PRINT_AHS: u32 = 16384;
pub const NIR_DEBUG_PRINT_CHS: u32 = 32768;
pub const NIR_DEBUG_PRINT_MHS: u32 = 65536;
pub const NIR_DEBUG_PRINT_IS: u32 = 131072;
pub const NIR_DEBUG_PRINT_CBS: u32 = 262144;
pub const NIR_DEBUG_PRINT_KS: u32 = 524288;
pub const NIR_DEBUG_PRINT_NO_INLINE_CONSTS: u32 = 1048576;
pub const NIR_DEBUG_PRINT_INTERNAL: u32 = 2097152;
pub const NIR_DEBUG_PRINT_PASS_FLAGS: u32 = 4194304;
pub const NIR_DEBUG_PRINT: u32 = 1048544;
pub const SHA1_BLOCK_LENGTH: u32 = 64;
pub const SHA1_DIGEST_LENGTH: u32 = 20;
pub const SHA1_DIGEST_STRING_LENGTH: u32 = 41;
pub const SHA1_DIGEST_LENGTH32: u32 = 5;
pub const PIPE_BLENDFACTOR_INVERT_BIT: u32 = 16;
pub const OS_TIMEOUT_INFINITE: i32 = -1;
pub const PIPE_FACE_NONE: u32 = 0;
pub const PIPE_FACE_FRONT: u32 = 1;
pub const PIPE_FACE_BACK: u32 = 2;
pub const PIPE_FACE_FRONT_AND_BACK: u32 = 3;
pub const PIPE_CLEAR_DEPTH: u32 = 1;
pub const PIPE_CLEAR_STENCIL: u32 = 2;
pub const PIPE_CLEAR_COLOR0: u32 = 4;
pub const PIPE_CLEAR_COLOR1: u32 = 8;
pub const PIPE_CLEAR_COLOR2: u32 = 16;
pub const PIPE_CLEAR_COLOR3: u32 = 32;
pub const PIPE_CLEAR_COLOR4: u32 = 64;
pub const PIPE_CLEAR_COLOR5: u32 = 128;
pub const PIPE_CLEAR_COLOR6: u32 = 256;
pub const PIPE_CLEAR_COLOR7: u32 = 512;
pub const PIPE_CLEAR_COLOR: u32 = 1020;
pub const PIPE_CLEAR_DEPTHSTENCIL: u32 = 3;
pub const PIPE_DUMP_DEVICE_STATUS_REGISTERS: u32 = 1;
pub const PIPE_CONTEXT_COMPUTE_ONLY: u32 = 1;
pub const PIPE_CONTEXT_DEBUG: u32 = 2;
pub const PIPE_CONTEXT_ROBUST_BUFFER_ACCESS: u32 = 4;
pub const PIPE_CONTEXT_PREFER_THREADED: u32 = 8;
pub const PIPE_CONTEXT_HIGH_PRIORITY: u32 = 16;
pub const PIPE_CONTEXT_LOW_PRIORITY: u32 = 32;
pub const PIPE_CONTEXT_LOSE_CONTEXT_ON_RESET: u32 = 64;
pub const PIPE_CONTEXT_PROTECTED: u32 = 128;
pub const PIPE_CONTEXT_NO_LOD_BIAS: u32 = 256;
pub const PIPE_CONTEXT_MEDIA_ONLY: u32 = 512;
pub const PIPE_CONTEXT_REALTIME_PRIORITY: u32 = 1024;
pub const PIPE_BARRIER_MAPPED_BUFFER: u32 = 1;
pub const PIPE_BARRIER_SHADER_BUFFER: u32 = 2;
pub const PIPE_BARRIER_QUERY_BUFFER: u32 = 4;
pub const PIPE_BARRIER_VERTEX_BUFFER: u32 = 8;
pub const PIPE_BARRIER_INDEX_BUFFER: u32 = 16;
pub const PIPE_BARRIER_CONSTANT_BUFFER: u32 = 32;
pub const PIPE_BARRIER_INDIRECT_BUFFER: u32 = 64;
pub const PIPE_BARRIER_TEXTURE: u32 = 128;
pub const PIPE_BARRIER_IMAGE: u32 = 256;
pub const PIPE_BARRIER_FRAMEBUFFER: u32 = 512;
pub const PIPE_BARRIER_STREAMOUT_BUFFER: u32 = 1024;
pub const PIPE_BARRIER_GLOBAL_BUFFER: u32 = 2048;
pub const PIPE_BARRIER_UPDATE_BUFFER: u32 = 4096;
pub const PIPE_BARRIER_UPDATE_TEXTURE: u32 = 8192;
pub const PIPE_BARRIER_ALL: u32 = 16383;
pub const PIPE_BARRIER_UPDATE: u32 = 12288;
pub const PIPE_TEXTURE_BARRIER_SAMPLER: u32 = 1;
pub const PIPE_TEXTURE_BARRIER_FRAMEBUFFER: u32 = 2;
pub const PIPE_BIND_DEPTH_STENCIL: u32 = 1;
pub const PIPE_BIND_RENDER_TARGET: u32 = 2;
pub const PIPE_BIND_BLENDABLE: u32 = 4;
pub const PIPE_BIND_SAMPLER_VIEW: u32 = 8;
pub const PIPE_BIND_VERTEX_BUFFER: u32 = 16;
pub const PIPE_BIND_INDEX_BUFFER: u32 = 32;
pub const PIPE_BIND_CONSTANT_BUFFER: u32 = 64;
pub const PIPE_BIND_DISPLAY_TARGET: u32 = 128;
pub const PIPE_BIND_VERTEX_STATE: u32 = 256;
pub const PIPE_BIND_STREAM_OUTPUT: u32 = 1024;
pub const PIPE_BIND_CURSOR: u32 = 2048;
pub const PIPE_BIND_CUSTOM: u32 = 4096;
pub const PIPE_BIND_GLOBAL: u32 = 8192;
pub const PIPE_BIND_SHADER_BUFFER: u32 = 16384;
pub const PIPE_BIND_SHADER_IMAGE: u32 = 32768;
pub const PIPE_BIND_COMPUTE_RESOURCE: u32 = 65536;
pub const PIPE_BIND_COMMAND_ARGS_BUFFER: u32 = 131072;
pub const PIPE_BIND_QUERY_BUFFER: u32 = 262144;
pub const PIPE_BIND_SCANOUT: u32 = 524288;
pub const PIPE_BIND_SHARED: u32 = 1048576;
pub const PIPE_BIND_LINEAR: u32 = 2097152;
pub const PIPE_BIND_PROTECTED: u32 = 4194304;
pub const PIPE_BIND_SAMPLER_REDUCTION_MINMAX: u32 = 8388608;
pub const PIPE_BIND_PRIME_BLIT_DST: u32 = 16777216;
pub const PIPE_BIND_USE_FRONT_RENDERING: u32 = 33554432;
pub const PIPE_BIND_CONST_BW: u32 = 67108864;
pub const PIPE_BIND_VIDEO_DECODE_DPB: u32 = 134217728;
pub const PIPE_BIND_VIDEO_ENCODE_DPB: u32 = 268435456;
pub const PIPE_RESOURCE_FLAG_MAP_PERSISTENT: u32 = 1;
pub const PIPE_RESOURCE_FLAG_MAP_COHERENT: u32 = 2;
pub const PIPE_RESOURCE_FLAG_TEXTURING_MORE_LIKELY: u32 = 4;
pub const PIPE_RESOURCE_FLAG_SPARSE: u32 = 8;
pub const PIPE_RESOURCE_FLAG_SINGLE_THREAD_USE: u32 = 16;
pub const PIPE_RESOURCE_FLAG_ENCRYPTED: u32 = 32;
pub const PIPE_RESOURCE_FLAG_DONT_OVER_ALLOCATE: u32 = 64;
pub const PIPE_RESOURCE_FLAG_DONT_MAP_DIRECTLY: u32 = 128;
pub const PIPE_RESOURCE_FLAG_UNMAPPABLE: u32 = 256;
pub const PIPE_RESOURCE_FLAG_DRV_PRIV: u32 = 512;
pub const PIPE_RESOURCE_FLAG_FRONTEND_PRIV: u32 = 16777216;
pub const PIPE_COMPRESSION_FIXED_RATE_NONE: u32 = 0;
pub const PIPE_COMPRESSION_FIXED_RATE_DEFAULT: u32 = 15;
pub const PIPE_HANDLE_USAGE_EXPLICIT_FLUSH: u32 = 1;
pub const PIPE_HANDLE_USAGE_FRAMEBUFFER_WRITE: u32 = 2;
pub const PIPE_HANDLE_USAGE_SHADER_WRITE: u32 = 4;
pub const PIPE_IMAGE_ACCESS_READ: u32 = 1;
pub const PIPE_IMAGE_ACCESS_WRITE: u32 = 2;
pub const PIPE_IMAGE_ACCESS_READ_WRITE: u32 = 3;
pub const PIPE_IMAGE_ACCESS_COHERENT: u32 = 4;
pub const PIPE_IMAGE_ACCESS_VOLATILE: u32 = 8;
pub const PIPE_IMAGE_ACCESS_TEX2D_FROM_BUFFER: u32 = 16;
pub const PIPE_IMAGE_ACCESS_DRIVER_INTERNAL: u32 = 32;
pub const PIPE_SHADER_SUBGROUP_FEATURE_BASIC: u32 = 1;
pub const PIPE_SHADER_SUBGROUP_FEATURE_VOTE: u32 = 2;
pub const PIPE_SHADER_SUBGROUP_FEATURE_ARITHMETIC: u32 = 4;
pub const PIPE_SHADER_SUBGROUP_FEATURE_BALLOT: u32 = 8;
pub const PIPE_SHADER_SUBGROUP_FEATURE_SHUFFLE: u32 = 16;
pub const PIPE_SHADER_SUBGROUP_FEATURE_SHUFFLE_RELATIVE: u32 = 32;
pub const PIPE_SHADER_SUBGROUP_FEATURE_CLUSTERED: u32 = 64;
pub const PIPE_SHADER_SUBGROUP_FEATURE_QUAD: u32 = 128;
pub const PIPE_SHADER_SUBGROUP_NUM_FEATURES: u32 = 8;
pub const PIPE_CONTEXT_PRIORITY_LOW: u32 = 1;
pub const PIPE_CONTEXT_PRIORITY_MEDIUM: u32 = 2;
pub const PIPE_CONTEXT_PRIORITY_HIGH: u32 = 4;
pub const PIPE_CONTEXT_PRIORITY_REALTIME: u32 = 8;
pub const PIPE_DRIVER_QUERY_FLAG_BATCH: u32 = 1;
pub const PIPE_DRIVER_QUERY_FLAG_DONT_LIST: u32 = 2;
pub const PIPE_ASTC_DECODE_FORMAT_FLOAT16: u32 = 0;
pub const PIPE_ASTC_DECODE_FORMAT_UNORM8: u32 = 1;
pub const PIPE_ASTC_DECODE_FORMAT_RGB9E5: u32 = 2;
pub const PIPE_UUID_SIZE: u32 = 16;
pub const PIPE_LUID_SIZE: u32 = 8;
pub const WINSYS_HANDLE_TYPE_SHARED: u32 = 0;
pub const WINSYS_HANDLE_TYPE_KMS: u32 = 1;
pub const WINSYS_HANDLE_TYPE_FD: u32 = 2;
pub const WINSYS_HANDLE_TYPE_WIN32_HANDLE: u32 = 2;
pub const WINSYS_HANDLE_TYPE_SHMID: u32 = 3;
pub const WINSYS_HANDLE_TYPE_D3D12_RES: u32 = 4;
pub const WINSYS_HANDLE_TYPE_WIN32_NAME: u32 = 5;
pub const WINSYS_HANDLE_TYPE_UNBACKED: u32 = 5;
pub const PIPE_MAX_ATTRIBS: u32 = 32;
pub const PIPE_MAX_CLIP_PLANES: u32 = 8;
pub const PIPE_MAX_COLOR_BUFS: u32 = 8;
pub const PIPE_MAX_CONSTANT_BUFFERS: u32 = 32;
pub const PIPE_MAX_SAMPLERS: u32 = 32;
pub const PIPE_MAX_SHADER_INPUTS: u32 = 80;
pub const PIPE_MAX_SHADER_OUTPUTS: u32 = 80;
pub const PIPE_MAX_SHADER_SAMPLER_VIEWS: u32 = 128;
pub const PIPE_MAX_SHADER_BUFFERS: u32 = 32;
pub const PIPE_MAX_SHADER_IMAGES: u32 = 64;
pub const PIPE_MAX_TEXTURE_LEVELS: u32 = 16;
pub const PIPE_MAX_SO_BUFFERS: u32 = 4;
pub const PIPE_MAX_SO_OUTPUTS: u32 = 128;
pub const PIPE_MAX_VIEWPORTS: u32 = 16;
pub const PIPE_MAX_CLIP_OR_CULL_DISTANCE_COUNT: u32 = 8;
pub const PIPE_MAX_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 = 2;
pub const PIPE_MAX_WINDOW_RECTANGLES: u32 = 8;
pub const PIPE_MAX_SAMPLE_LOCATION_GRID_SIZE: u32 = 4;
pub const PIPE_MAX_HW_ATOMIC_BUFFERS: u32 = 32;
pub const PIPE_MAX_VERTEX_STREAMS: u32 = 4;
pub type __gnuc_va_list = __builtin_va_list;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = __int64_t;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub _short_backupbuf: [::std::os::raw::c_char; 1usize],
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub _prevchain: *mut *mut _IO_FILE,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _IO_FILE"][::std::mem::size_of::<_IO_FILE>() - 148usize];
    ["Alignment of _IO_FILE"][::std::mem::align_of::<_IO_FILE>() - 4usize];
    ["Offset of field: _IO_FILE::_flags"][::std::mem::offset_of!(_IO_FILE, _flags) - 0usize];
    ["Offset of field: _IO_FILE::_IO_read_ptr"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_ptr) - 4usize];
    ["Offset of field: _IO_FILE::_IO_read_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_end) - 8usize];
    ["Offset of field: _IO_FILE::_IO_read_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_read_base) - 12usize];
    ["Offset of field: _IO_FILE::_IO_write_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_base) - 16usize];
    ["Offset of field: _IO_FILE::_IO_write_ptr"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_ptr) - 20usize];
    ["Offset of field: _IO_FILE::_IO_write_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_write_end) - 24usize];
    ["Offset of field: _IO_FILE::_IO_buf_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_buf_base) - 28usize];
    ["Offset of field: _IO_FILE::_IO_buf_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_buf_end) - 32usize];
    ["Offset of field: _IO_FILE::_IO_save_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_save_base) - 36usize];
    ["Offset of field: _IO_FILE::_IO_backup_base"]
        [::std::mem::offset_of!(_IO_FILE, _IO_backup_base) - 40usize];
    ["Offset of field: _IO_FILE::_IO_save_end"]
        [::std::mem::offset_of!(_IO_FILE, _IO_save_end) - 44usize];
    ["Offset of field: _IO_FILE::_markers"][::std::mem::offset_of!(_IO_FILE, _markers) - 48usize];
    ["Offset of field: _IO_FILE::_chain"][::std::mem::offset_of!(_IO_FILE, _chain) - 52usize];
    ["Offset of field: _IO_FILE::_fileno"][::std::mem::offset_of!(_IO_FILE, _fileno) - 56usize];
    ["Offset of field: _IO_FILE::_short_backupbuf"]
        [::std::mem::offset_of!(_IO_FILE, _short_backupbuf) - 63usize];
    ["Offset of field: _IO_FILE::_old_offset"]
        [::std::mem::offset_of!(_IO_FILE, _old_offset) - 64usize];
    ["Offset of field: _IO_FILE::_cur_column"]
        [::std::mem::offset_of!(_IO_FILE, _cur_column) - 68usize];
    ["Offset of field: _IO_FILE::_vtable_offset"]
        [::std::mem::offset_of!(_IO_FILE, _vtable_offset) - 70usize];
    ["Offset of field: _IO_FILE::_shortbuf"][::std::mem::offset_of!(_IO_FILE, _shortbuf) - 71usize];
    ["Offset of field: _IO_FILE::_lock"][::std::mem::offset_of!(_IO_FILE, _lock) - 72usize];
    ["Offset of field: _IO_FILE::_offset"][::std::mem::offset_of!(_IO_FILE, _offset) - 76usize];
    ["Offset of field: _IO_FILE::_codecvt"][::std::mem::offset_of!(_IO_FILE, _codecvt) - 84usize];
    ["Offset of field: _IO_FILE::_wide_data"]
        [::std::mem::offset_of!(_IO_FILE, _wide_data) - 88usize];
    ["Offset of field: _IO_FILE::_freeres_list"]
        [::std::mem::offset_of!(_IO_FILE, _freeres_list) - 92usize];
    ["Offset of field: _IO_FILE::_freeres_buf"]
        [::std::mem::offset_of!(_IO_FILE, _freeres_buf) - 96usize];
    ["Offset of field: _IO_FILE::_prevchain"]
        [::std::mem::offset_of!(_IO_FILE, _prevchain) - 100usize];
    ["Offset of field: _IO_FILE::_mode"][::std::mem::offset_of!(_IO_FILE, _mode) - 104usize];
    ["Offset of field: _IO_FILE::_unused2"][::std::mem::offset_of!(_IO_FILE, _unused2) - 108usize];
};
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl _IO_FILE {
    #[inline]
    pub fn _flags2(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set__flags2(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn _flags2_raw(this: *const Self) -> ::std::os::raw::c_int {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set__flags2_raw(this: *mut Self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(_flags2: ::std::os::raw::c_int) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let _flags2: u32 = unsafe { ::std::mem::transmute(_flags2) };
            _flags2 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type va_list = __gnuc_va_list;
unsafe extern "C" {
    pub fn stdout_ptr() -> *mut FILE;
}
unsafe extern "C" {
    pub fn stderr_ptr() -> *mut FILE;
}
unsafe extern "C" {
    pub fn mesa_version_string() -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "u_intN_max__extern"]
    pub fn u_intN_max(bit_size: ::std::os::raw::c_uint) -> i64;
}
unsafe extern "C" {
    #[link_name = "u_intN_min__extern"]
    pub fn u_intN_min(bit_size: ::std::os::raw::c_uint) -> i64;
}
unsafe extern "C" {
    #[link_name = "u_uintN_max__extern"]
    pub fn u_uintN_max(bit_size: ::std::os::raw::c_uint) -> u64;
}
pub type uint = ::std::os::raw::c_uint;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_debug_type {
    UTIL_DEBUG_TYPE_OUT_OF_MEMORY = 1,
    UTIL_DEBUG_TYPE_ERROR = 2,
    UTIL_DEBUG_TYPE_SHADER_INFO = 3,
    UTIL_DEBUG_TYPE_PERF_INFO = 4,
    UTIL_DEBUG_TYPE_INFO = 5,
    UTIL_DEBUG_TYPE_FALLBACK = 6,
    UTIL_DEBUG_TYPE_CONFORMANCE = 7,
}
#[doc = " Structure that contains a callback for debug messages from the driver back\n to the gallium frontend."]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_debug_callback {
    #[doc = " When set to \\c true, the callback may be called asynchronously from a\n driver-created thread."]
    pub async_: bool,
    #[doc = " Callback for the driver to report debug/performance/etc information back\n to the gallium frontend.\n\n \\param data       user-supplied data pointer\n \\param id         message type identifier, if pointed value is 0, then a\n                   new id is assigned\n \\param type       UTIL_DEBUG_TYPE_*\n \\param format     printf-style format string\n \\param args       args for format string"]
    pub debug_message: ::std::option::Option<
        unsafe extern "C" fn(
            data: *mut ::std::os::raw::c_void,
            id: *mut ::std::os::raw::c_uint,
            type_: util_debug_type,
            fmt: *const ::std::os::raw::c_char,
            args: va_list,
        ),
    >,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_debug_callback"][::std::mem::size_of::<util_debug_callback>() - 12usize];
    ["Alignment of util_debug_callback"][::std::mem::align_of::<util_debug_callback>() - 4usize];
    ["Offset of field: util_debug_callback::async_"]
        [::std::mem::offset_of!(util_debug_callback, async_) - 0usize];
    ["Offset of field: util_debug_callback::debug_message"]
        [::std::mem::offset_of!(util_debug_callback, debug_message) - 4usize];
    ["Offset of field: util_debug_callback::data"]
        [::std::mem::offset_of!(util_debug_callback, data) - 8usize];
};
impl Default for util_debug_callback {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl pipe_shader_type {
    pub const PIPE_SHADER_VERTEX: pipe_shader_type = pipe_shader_type::MESA_SHADER_VERTEX;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TESS_CTRL: pipe_shader_type = pipe_shader_type::MESA_SHADER_TESS_CTRL;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TESS_EVAL: pipe_shader_type = pipe_shader_type::MESA_SHADER_TESS_EVAL;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_GEOMETRY: pipe_shader_type = pipe_shader_type::MESA_SHADER_GEOMETRY;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_FRAGMENT: pipe_shader_type = pipe_shader_type::MESA_SHADER_FRAGMENT;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_COMPUTE: pipe_shader_type = pipe_shader_type::MESA_SHADER_COMPUTE;
}
impl pipe_shader_type {
    pub const MESA_SHADER_TASK: pipe_shader_type = pipe_shader_type::PIPE_SHADER_TYPES;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_TASK: pipe_shader_type = pipe_shader_type::PIPE_SHADER_TYPES;
}
impl pipe_shader_type {
    pub const PIPE_SHADER_MESH: pipe_shader_type = pipe_shader_type::MESA_SHADER_MESH;
}
impl pipe_shader_type {
    pub const MESA_SHADER_RAYGEN: pipe_shader_type = pipe_shader_type::PIPE_SHADER_MESH_TYPES;
}
#[repr(i32)]
#[doc = " Shader stages.\n\n The order must match how shaders are ordered in the pipeline.\n The GLSL linker assumes that if i<j, then the j-th shader is\n executed later than the i-th shader."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_shader_type {
    MESA_SHADER_NONE = -1,
    MESA_SHADER_VERTEX = 0,
    MESA_SHADER_TESS_CTRL = 1,
    MESA_SHADER_TESS_EVAL = 2,
    MESA_SHADER_GEOMETRY = 3,
    MESA_SHADER_FRAGMENT = 4,
    MESA_SHADER_COMPUTE = 5,
    PIPE_SHADER_TYPES = 6,
    MESA_SHADER_MESH = 7,
    PIPE_SHADER_MESH_TYPES = 8,
    MESA_SHADER_ANY_HIT = 9,
    MESA_SHADER_CLOSEST_HIT = 10,
    MESA_SHADER_MISS = 11,
    MESA_SHADER_INTERSECTION = 12,
    MESA_SHADER_CALLABLE = 13,
    MESA_SHADER_KERNEL = 14,
}
#[doc = " Shader stages.\n\n The order must match how shaders are ordered in the pipeline.\n The GLSL linker assumes that if i<j, then the j-th shader is\n executed later than the i-th shader."]
pub use self::pipe_shader_type as gl_shader_stage;
pub type gl_state_index16 = ::std::os::raw::c_short;
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_SHADING_RATE: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_FACE;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_COUNT: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_TESS_LEVEL_OUTER;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_PRIMITIVE_INDICES: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_TESS_LEVEL_INNER;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_TASK_COUNT: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_BOUNDING_BOX0;
}
impl gl_varying_slot {
    pub const VARYING_SLOT_CULL_PRIMITIVE: gl_varying_slot =
        gl_varying_slot::VARYING_SLOT_BOUNDING_BOX0;
}
#[repr(u32)]
#[doc = " Indexes for vertex shader outputs, geometry shader inputs/outputs, and\n fragment shader inputs.\n\n Note that some of these values are not available to all pipeline stages.\n\n When this enum is updated, the following code must be updated too:\n - vertResults (in prog_print.c's arb_output_attrib_string())\n - fragAttribs (in prog_print.c's arb_input_attrib_string())\n - _mesa_varying_slot_in_fs()\n - gl_varying_slot_name_for_stage()"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_varying_slot {
    VARYING_SLOT_POS = 0,
    VARYING_SLOT_COL0 = 1,
    VARYING_SLOT_COL1 = 2,
    VARYING_SLOT_FOGC = 3,
    VARYING_SLOT_TEX0 = 4,
    VARYING_SLOT_TEX1 = 5,
    VARYING_SLOT_TEX2 = 6,
    VARYING_SLOT_TEX3 = 7,
    VARYING_SLOT_TEX4 = 8,
    VARYING_SLOT_TEX5 = 9,
    VARYING_SLOT_TEX6 = 10,
    VARYING_SLOT_TEX7 = 11,
    VARYING_SLOT_PSIZ = 12,
    VARYING_SLOT_BFC0 = 13,
    VARYING_SLOT_BFC1 = 14,
    VARYING_SLOT_EDGE = 15,
    VARYING_SLOT_CLIP_VERTEX = 16,
    VARYING_SLOT_CLIP_DIST0 = 17,
    VARYING_SLOT_CLIP_DIST1 = 18,
    VARYING_SLOT_CULL_DIST0 = 19,
    VARYING_SLOT_CULL_DIST1 = 20,
    VARYING_SLOT_PRIMITIVE_ID = 21,
    VARYING_SLOT_LAYER = 22,
    VARYING_SLOT_VIEWPORT = 23,
    VARYING_SLOT_FACE = 24,
    VARYING_SLOT_PNTC = 25,
    VARYING_SLOT_TESS_LEVEL_OUTER = 26,
    VARYING_SLOT_TESS_LEVEL_INNER = 27,
    VARYING_SLOT_BOUNDING_BOX0 = 28,
    VARYING_SLOT_BOUNDING_BOX1 = 29,
    VARYING_SLOT_VIEW_INDEX = 30,
    VARYING_SLOT_VIEWPORT_MASK = 31,
    VARYING_SLOT_VAR0 = 32,
    VARYING_SLOT_VAR1 = 33,
    VARYING_SLOT_VAR2 = 34,
    VARYING_SLOT_VAR3 = 35,
    VARYING_SLOT_VAR4 = 36,
    VARYING_SLOT_VAR5 = 37,
    VARYING_SLOT_VAR6 = 38,
    VARYING_SLOT_VAR7 = 39,
    VARYING_SLOT_VAR8 = 40,
    VARYING_SLOT_VAR9 = 41,
    VARYING_SLOT_VAR10 = 42,
    VARYING_SLOT_VAR11 = 43,
    VARYING_SLOT_VAR12 = 44,
    VARYING_SLOT_VAR13 = 45,
    VARYING_SLOT_VAR14 = 46,
    VARYING_SLOT_VAR15 = 47,
    VARYING_SLOT_VAR16 = 48,
    VARYING_SLOT_VAR17 = 49,
    VARYING_SLOT_VAR18 = 50,
    VARYING_SLOT_VAR19 = 51,
    VARYING_SLOT_VAR20 = 52,
    VARYING_SLOT_VAR21 = 53,
    VARYING_SLOT_VAR22 = 54,
    VARYING_SLOT_VAR23 = 55,
    VARYING_SLOT_VAR24 = 56,
    VARYING_SLOT_VAR25 = 57,
    VARYING_SLOT_VAR26 = 58,
    VARYING_SLOT_VAR27 = 59,
    VARYING_SLOT_VAR28 = 60,
    VARYING_SLOT_VAR29 = 61,
    VARYING_SLOT_VAR30 = 62,
    VARYING_SLOT_VAR31 = 63,
    VARYING_SLOT_PATCH0 = 64,
    VARYING_SLOT_PATCH1 = 65,
    VARYING_SLOT_PATCH2 = 66,
    VARYING_SLOT_PATCH3 = 67,
    VARYING_SLOT_PATCH4 = 68,
    VARYING_SLOT_PATCH5 = 69,
    VARYING_SLOT_PATCH6 = 70,
    VARYING_SLOT_PATCH7 = 71,
    VARYING_SLOT_PATCH8 = 72,
    VARYING_SLOT_PATCH9 = 73,
    VARYING_SLOT_PATCH10 = 74,
    VARYING_SLOT_PATCH11 = 75,
    VARYING_SLOT_PATCH12 = 76,
    VARYING_SLOT_PATCH13 = 77,
    VARYING_SLOT_PATCH14 = 78,
    VARYING_SLOT_PATCH15 = 79,
    VARYING_SLOT_PATCH16 = 80,
    VARYING_SLOT_PATCH17 = 81,
    VARYING_SLOT_PATCH18 = 82,
    VARYING_SLOT_PATCH19 = 83,
    VARYING_SLOT_PATCH20 = 84,
    VARYING_SLOT_PATCH21 = 85,
    VARYING_SLOT_PATCH22 = 86,
    VARYING_SLOT_PATCH23 = 87,
    VARYING_SLOT_PATCH24 = 88,
    VARYING_SLOT_PATCH25 = 89,
    VARYING_SLOT_PATCH26 = 90,
    VARYING_SLOT_PATCH27 = 91,
    VARYING_SLOT_PATCH28 = 92,
    VARYING_SLOT_PATCH29 = 93,
    VARYING_SLOT_PATCH30 = 94,
    VARYING_SLOT_PATCH31 = 95,
    VARYING_SLOT_VAR0_16BIT = 96,
    VARYING_SLOT_VAR1_16BIT = 97,
    VARYING_SLOT_VAR2_16BIT = 98,
    VARYING_SLOT_VAR3_16BIT = 99,
    VARYING_SLOT_VAR4_16BIT = 100,
    VARYING_SLOT_VAR5_16BIT = 101,
    VARYING_SLOT_VAR6_16BIT = 102,
    VARYING_SLOT_VAR7_16BIT = 103,
    VARYING_SLOT_VAR8_16BIT = 104,
    VARYING_SLOT_VAR9_16BIT = 105,
    VARYING_SLOT_VAR10_16BIT = 106,
    VARYING_SLOT_VAR11_16BIT = 107,
    VARYING_SLOT_VAR12_16BIT = 108,
    VARYING_SLOT_VAR13_16BIT = 109,
    VARYING_SLOT_VAR14_16BIT = 110,
    VARYING_SLOT_VAR15_16BIT = 111,
    NUM_TOTAL_VARYING_SLOTS = 112,
}
#[repr(u32)]
#[doc = " If a NIR variable's mode is nir_var_system_value, it will be one of these\n values."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_system_value {
    #[doc = " From the GL_ARB_shader-ballot spec:\n\n    \"A sub-group is a collection of invocations which execute in lockstep.\n     The variable <gl_SubGroupSizeARB> is the maximum number of\n     invocations in a sub-group. The maximum <gl_SubGroupSizeARB>\n     supported in this extension is 64.\"\n\n The spec defines this as a uniform. However, it's highly unlikely that\n implementations actually treat it as a uniform (which is loaded from a\n constant buffer). Most likely, this is an implementation-wide constant,\n or perhaps something that depends on the shader stage."]
    SYSTEM_VALUE_SUBGROUP_SIZE = 0,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The variable <gl_SubGroupInvocationARB> holds the index of the\n     invocation within sub-group. This variable is in the range 0 to\n     <gl_SubGroupSizeARB>-1, where <gl_SubGroupSizeARB> is the total\n     number of invocations in a sub-group.\""]
    SYSTEM_VALUE_SUBGROUP_INVOCATION = 1,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_EQ_MASK = 2,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_GE_MASK = 3,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_GT_MASK = 4,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_LE_MASK = 5,
    #[doc = " From the GL_ARB_shader_ballot spec:\n\n    \"The <gl_SubGroup??MaskARB> variables provide a bitmask for all\n     invocations, with one bit per invocation starting with the least\n     significant bit, according to the following table,\n\n       variable               equation for bit values\n       --------------------   ------------------------------------\n       gl_SubGroupEqMaskARB   bit index == gl_SubGroupInvocationARB\n       gl_SubGroupGeMaskARB   bit index >= gl_SubGroupInvocationARB\n       gl_SubGroupGtMaskARB   bit index >  gl_SubGroupInvocationARB\n       gl_SubGroupLeMaskARB   bit index <= gl_SubGroupInvocationARB\n       gl_SubGroupLtMaskARB   bit index <  gl_SubGroupInvocationARB"]
    SYSTEM_VALUE_SUBGROUP_LT_MASK = 6,
    SYSTEM_VALUE_NUM_SUBGROUPS = 7,
    SYSTEM_VALUE_SUBGROUP_ID = 8,
    #[doc = " OpenGL-style vertex ID.\n\n Section 2.11.7 (Shader Execution), subsection Shader Inputs, of the\n OpenGL 3.3 core profile spec says:\n\n     \"gl_VertexID holds the integer index i implicitly passed by\n     DrawArrays or one of the other drawing commands defined in section\n     2.8.3.\"\n\n Section 2.8.3 (Drawing Commands) of the same spec says:\n\n     \"The commands....are equivalent to the commands with the same base\n     name (without the BaseVertex suffix), except that the ith element\n     transferred by the corresponding draw call will be taken from\n     element indices[i] + basevertex of each enabled array.\"\n\n Additionally, the overview in the GL_ARB_shader_draw_parameters spec\n says:\n\n     \"In unextended GL, vertex shaders have inputs named gl_VertexID and\n     gl_InstanceID, which contain, respectively the index of the vertex\n     and instance. The value of gl_VertexID is the implicitly passed\n     index of the vertex being processed, which includes the value of\n     baseVertex, for those commands that accept it.\"\n\n gl_VertexID gets basevertex added in.  This differs from DirectX where\n SV_VertexID does \\b not get basevertex added in.\n\n \\note\n If all system values are available, \\c SYSTEM_VALUE_VERTEX_ID will be\n equal to \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus\n \\c SYSTEM_VALUE_BASE_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_BASE_VERTEX"]
    SYSTEM_VALUE_VERTEX_ID = 9,
    #[doc = " Instanced ID as supplied to gl_InstanceID\n\n Values assigned to gl_InstanceID always begin with zero, regardless of\n the value of baseinstance.\n\n Section 11.1.3.9 (Shader Inputs) of the OpenGL 4.4 core profile spec\n says:\n\n     \"gl_InstanceID holds the integer instance number of the current\n     primitive in an instanced draw call (see section 10.5).\"\n\n Through a big chain of pseudocode, section 10.5 describes that\n baseinstance is not counted by gl_InstanceID.  In that section, notice\n\n     \"If an enabled vertex attribute array is instanced (it has a\n     non-zero divisor as specified by VertexAttribDivisor), the element\n     index that is transferred to the GL, for all vertices, is given by\n\n         floor(instance/divisor) + baseinstance\n\n     If an array corresponding to an attribute required by a vertex\n     shader is not enabled, then the corresponding element is taken from\n     the current attribute state (see section 10.2).\"\n\n Note that baseinstance is \\b not included in the value of instance."]
    SYSTEM_VALUE_INSTANCE_ID = 10,
    #[doc = " Vulkan InstanceIndex.\n\n InstanceIndex = gl_InstanceID + gl_BaseInstance"]
    SYSTEM_VALUE_INSTANCE_INDEX = 11,
    #[doc = " DirectX-style vertex ID.\n\n Unlike \\c SYSTEM_VALUE_VERTEX_ID, this system value does \\b not include\n the value of basevertex.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_BASE_VERTEX"]
    SYSTEM_VALUE_VERTEX_ID_ZERO_BASE = 12,
    #[doc = " Value of \\c basevertex passed to \\c glDrawElementsBaseVertex and similar\n functions.\n\n \\sa SYSTEM_VALUE_VERTEX_ID, SYSTEM_VALUE_VERTEX_ID_ZERO_BASE"]
    SYSTEM_VALUE_BASE_VERTEX = 13,
    #[doc = " Depending on the type of the draw call (indexed or non-indexed),\n is the value of \\c basevertex passed to \\c glDrawElementsBaseVertex and\n similar, or is the value of \\c first passed to \\c glDrawArrays and\n similar.\n\n \\note\n It can be used to calculate the \\c SYSTEM_VALUE_VERTEX_ID as\n \\c SYSTEM_VALUE_VERTEX_ID_ZERO_BASE plus \\c SYSTEM_VALUE_FIRST_VERTEX.\n\n \\sa SYSTEM_VALUE_VERTEX_ID_ZERO_BASE, SYSTEM_VALUE_VERTEX_ID"]
    SYSTEM_VALUE_FIRST_VERTEX = 14,
    #[doc = " If the Draw command used to start the rendering was an indexed draw\n or not (~0/0). Useful to calculate \\c SYSTEM_VALUE_BASE_VERTEX as\n \\c SYSTEM_VALUE_IS_INDEXED_DRAW & \\c SYSTEM_VALUE_FIRST_VERTEX."]
    SYSTEM_VALUE_IS_INDEXED_DRAW = 15,
    #[doc = " Value of \\c baseinstance passed to instanced draw entry points\n\n \\sa SYSTEM_VALUE_INSTANCE_ID"]
    SYSTEM_VALUE_BASE_INSTANCE = 16,
    #[doc = " From _ARB_shader_draw_parameters:\n\n   \"Additionally, this extension adds a further built-in variable,\n    gl_DrawID to the shading language. This variable contains the index\n    of the draw currently being processed by a Multi* variant of a\n    drawing command (such as MultiDrawElements or\n    MultiDrawArraysIndirect).\"\n\n If GL_ARB_multi_draw_indirect is not supported, this is always 0."]
    SYSTEM_VALUE_DRAW_ID = 17,
    #[doc = "< (Also in Tessellation Control shader)"]
    SYSTEM_VALUE_INVOCATION_ID = 18,
    SYSTEM_VALUE_FRAG_COORD = 19,
    SYSTEM_VALUE_PIXEL_COORD = 20,
    SYSTEM_VALUE_POINT_COORD = 21,
    #[doc = "< Coord along axis perpendicular to line"]
    SYSTEM_VALUE_LINE_COORD = 22,
    SYSTEM_VALUE_FRONT_FACE = 23,
    SYSTEM_VALUE_FRONT_FACE_FSIGN = 24,
    SYSTEM_VALUE_SAMPLE_ID = 25,
    SYSTEM_VALUE_SAMPLE_POS = 26,
    SYSTEM_VALUE_SAMPLE_POS_OR_CENTER = 27,
    SYSTEM_VALUE_SAMPLE_MASK_IN = 28,
    SYSTEM_VALUE_LAYER_ID = 29,
    SYSTEM_VALUE_HELPER_INVOCATION = 30,
    SYSTEM_VALUE_COLOR0 = 31,
    SYSTEM_VALUE_COLOR1 = 32,
    SYSTEM_VALUE_TESS_COORD = 33,
    #[doc = "< Tessellation vertices in input patch"]
    SYSTEM_VALUE_VERTICES_IN = 34,
    SYSTEM_VALUE_PRIMITIVE_ID = 35,
    #[doc = "< TES input"]
    SYSTEM_VALUE_TESS_LEVEL_OUTER = 36,
    #[doc = "< TES input"]
    SYSTEM_VALUE_TESS_LEVEL_INNER = 37,
    #[doc = "< TCS input for passthru TCS"]
    SYSTEM_VALUE_TESS_LEVEL_OUTER_DEFAULT = 38,
    #[doc = "< TCS input for passthru TCS"]
    SYSTEM_VALUE_TESS_LEVEL_INNER_DEFAULT = 39,
    SYSTEM_VALUE_LOCAL_INVOCATION_ID = 40,
    SYSTEM_VALUE_LOCAL_INVOCATION_INDEX = 41,
    SYSTEM_VALUE_GLOBAL_INVOCATION_ID = 42,
    SYSTEM_VALUE_BASE_GLOBAL_INVOCATION_ID = 43,
    SYSTEM_VALUE_GLOBAL_INVOCATION_INDEX = 44,
    SYSTEM_VALUE_WORKGROUP_ID = 45,
    SYSTEM_VALUE_BASE_WORKGROUP_ID = 46,
    SYSTEM_VALUE_WORKGROUP_INDEX = 47,
    SYSTEM_VALUE_NUM_WORKGROUPS = 48,
    SYSTEM_VALUE_WORKGROUP_SIZE = 49,
    SYSTEM_VALUE_GLOBAL_GROUP_SIZE = 50,
    SYSTEM_VALUE_WORK_DIM = 51,
    SYSTEM_VALUE_USER_DATA_AMD = 52,
    #[doc = " Required for VK_KHR_device_group"]
    SYSTEM_VALUE_DEVICE_INDEX = 53,
    #[doc = " Required for VK_KHX_multiview"]
    SYSTEM_VALUE_VIEW_INDEX = 54,
    #[doc = " Driver internal vertex-count, used (for example) for drivers to\n calculate stride for stream-out outputs.  Not externally visible."]
    SYSTEM_VALUE_VERTEX_CNT = 55,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_PIXEL = 56,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_SAMPLE = 57,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTROID = 58,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PERSP_CENTER_RHW = 59,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_PIXEL = 60,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_CENTROID = 61,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_SAMPLE = 62,
    #[doc = " Required for AMD_shader_explicit_vertex_parameter and also used for\n varying-fetch instructions.\n\n The _SIZE value is \"primitive size\", used to scale i/j in primitive\n space to pixel space."]
    SYSTEM_VALUE_BARYCENTRIC_PULL_MODEL = 63,
    SYSTEM_VALUE_BARYCENTRIC_PERSP_COORD = 64,
    SYSTEM_VALUE_BARYCENTRIC_LINEAR_COORD = 65,
    SYSTEM_VALUE_RAY_LAUNCH_ID = 66,
    SYSTEM_VALUE_RAY_LAUNCH_SIZE = 67,
    SYSTEM_VALUE_RAY_WORLD_ORIGIN = 68,
    SYSTEM_VALUE_RAY_WORLD_DIRECTION = 69,
    SYSTEM_VALUE_RAY_OBJECT_ORIGIN = 70,
    SYSTEM_VALUE_RAY_OBJECT_DIRECTION = 71,
    SYSTEM_VALUE_RAY_T_MIN = 72,
    SYSTEM_VALUE_RAY_T_MAX = 73,
    SYSTEM_VALUE_RAY_OBJECT_TO_WORLD = 74,
    SYSTEM_VALUE_RAY_WORLD_TO_OBJECT = 75,
    SYSTEM_VALUE_RAY_HIT_KIND = 76,
    SYSTEM_VALUE_RAY_FLAGS = 77,
    SYSTEM_VALUE_RAY_GEOMETRY_INDEX = 78,
    SYSTEM_VALUE_RAY_INSTANCE_CUSTOM_INDEX = 79,
    SYSTEM_VALUE_CULL_MASK = 80,
    SYSTEM_VALUE_RAY_TRIANGLE_VERTEX_POSITIONS = 81,
    SYSTEM_VALUE_MESH_VIEW_COUNT = 82,
    SYSTEM_VALUE_MESH_VIEW_INDICES = 83,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_GS_HEADER_IR3 = 84,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_TCS_HEADER_IR3 = 85,
    #[doc = " IR3 specific geometry shader and tesselation control shader system\n values that packs invocation id, thread id and vertex id.  Having this\n as a nir level system value lets us do the unpacking in nir."]
    SYSTEM_VALUE_REL_PATCH_ID_IR3 = 86,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_SHADING_RATE = 87,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FULLY_COVERED = 88,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_SIZE = 89,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_FRAG_INVOCATION_COUNT = 90,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SHADER_INDEX = 91,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_COALESCED_INPUT_COUNT = 92,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_WARPS_PER_SM_NV = 93,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SM_COUNT_NV = 94,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_WARP_ID_NV = 95,
    #[doc = " Fragment shading rate used for KHR_fragment_shading_rate (Vulkan)."]
    SYSTEM_VALUE_SM_ID_NV = 96,
    #[doc = "< Number of values"]
    SYSTEM_VALUE_MAX = 97,
}
#[repr(u32)]
#[doc = " The possible interpolation qualifiers that can be applied to a fragment\n shader input in GLSL.\n\n Note: INTERP_MODE_NONE must be 0 so that memsetting the\n ir_variable data structure to 0 causes the default behavior."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_interp_mode {
    INTERP_MODE_NONE = 0,
    INTERP_MODE_SMOOTH = 1,
    INTERP_MODE_FLAT = 2,
    INTERP_MODE_NOPERSPECTIVE = 3,
    INTERP_MODE_EXPLICIT = 4,
    #[doc = "< Number of interpolation qualifiers"]
    INTERP_MODE_COUNT = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_interface_packing {
    GLSL_INTERFACE_PACKING_STD140 = 0,
    GLSL_INTERFACE_PACKING_SHARED = 1,
    GLSL_INTERFACE_PACKING_PACKED = 2,
    GLSL_INTERFACE_PACKING_STD430 = 3,
}
unsafe extern "C" {
    pub fn glsl_interp_mode_name(qual: glsl_interp_mode) -> *const ::std::os::raw::c_char;
}
#[repr(u32)]
#[doc = " \\brief Layout qualifiers for gl_FragDepth.\n\n Extension AMD_conservative_depth allows gl_FragDepth to be redeclared with\n a layout qualifier.\n\n \\see enum ir_depth_layout"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_frag_depth_layout {
    #[doc = "< No layout is specified."]
    FRAG_DEPTH_LAYOUT_NONE = 0,
    FRAG_DEPTH_LAYOUT_ANY = 1,
    FRAG_DEPTH_LAYOUT_GREATER = 2,
    FRAG_DEPTH_LAYOUT_LESS = 3,
    FRAG_DEPTH_LAYOUT_UNCHANGED = 4,
}
#[repr(u32)]
#[doc = " \\brief Layout qualifiers for AMD_shader_early_and_late_fragment_tests."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_frag_stencil_layout {
    #[doc = "< No layout is specified."]
    FRAG_STENCIL_LAYOUT_NONE = 0,
    FRAG_STENCIL_LAYOUT_ANY = 1,
    FRAG_STENCIL_LAYOUT_GREATER = 2,
    FRAG_STENCIL_LAYOUT_LESS = 3,
    FRAG_STENCIL_LAYOUT_UNCHANGED = 4,
}
impl gl_access_qualifier {
    #[doc = " This means that the memory scope is the current device. It indicates\n that reads and writes are coherent with reads and writes from other\n shader invocations and other workgroups."]
    pub const ACCESS_COHERENT: gl_access_qualifier = gl_access_qualifier(1);
}
impl gl_access_qualifier {
    #[doc = " This means non-aliased. It indicates that the accessed address is not\n accessible through any other memory resource in the shader."]
    pub const ACCESS_RESTRICT: gl_access_qualifier = gl_access_qualifier(2);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_VOLATILE: gl_access_qualifier = gl_access_qualifier(4);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_NON_READABLE: gl_access_qualifier = gl_access_qualifier(8);
}
impl gl_access_qualifier {
    #[doc = " The access cannot be eliminated, duplicated, or combined with other\n accesses."]
    pub const ACCESS_NON_WRITEABLE: gl_access_qualifier = gl_access_qualifier(16);
}
impl gl_access_qualifier {
    #[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
    pub const ACCESS_NON_UNIFORM: gl_access_qualifier = gl_access_qualifier(32);
}
impl gl_access_qualifier {
    #[doc = " The access may use a non-uniform buffer or image index.\n\n This is not allowed in either OpenGL or OpenGL ES, or Vulkan unless\n VK_EXT_descriptor_indexing is supported and the appropriate capability is\n enabled.\n\n Some GL spec archaeology justifying this:\n\n Up through at least GLSL ES 3.20 and GLSL 4.50,  \"Opaque Types\" says \"When\n aggregated into arrays within a shader, opaque types can only be indexed\n with a dynamically uniform integral expression (see section 3.9.3) unless\n otherwise noted; otherwise, results are undefined.\"\n\n The original GL_AB_shader_image_load_store specification for desktop GL\n didn't have this restriction (\"Images may be aggregated into arrays within\n a shader (using square brackets [ ]) and can be indexed with general\n integer expressions.\")  At the same time,\n GL_ARB_shader_storage_buffer_objects *did* have the uniform restriction\n (\"A uniform or shader storage block array can only be indexed with a\n dynamically uniform integral expression, otherwise results are\n undefined\"), just like ARB_gpu_shader5 did when it first introduced a\n non-constant indexing of an opaque type with samplers.  So, we assume that\n this was an oversight in the original image_load_store spec, and was\n considered a correction in the merge to core."]
    pub const ACCESS_CAN_REORDER: gl_access_qualifier = gl_access_qualifier(64);
}
impl gl_access_qualifier {
    #[doc = " Hints that the accessed address is not likely to be accessed again\n in the near future. This reduces data retention in caches."]
    pub const ACCESS_NON_TEMPORAL: gl_access_qualifier = gl_access_qualifier(128);
}
impl gl_access_qualifier {
    #[doc = " Execute instruction also in helpers."]
    pub const ACCESS_INCLUDE_HELPERS: gl_access_qualifier = gl_access_qualifier(256);
}
impl gl_access_qualifier {
    #[doc = " Whether the address bits are swizzled by the hw. This practically means\n that loads can't be vectorized and must be exactly 32 bits on some chips.\n The swizzle amount is determined by the descriptor."]
    pub const ACCESS_IS_SWIZZLED_AMD: gl_access_qualifier = gl_access_qualifier(512);
}
impl gl_access_qualifier {
    #[doc = " Whether an AMD-specific buffer intrinsic uses a format conversion.\n\n If unset, the intrinsic will access raw memory without any conversion.\n\n If set, the memory opcode performs a format conversion according to\n the format determined by the descriptor (in a manner identical to image\n buffers and sampler buffers)."]
    pub const ACCESS_USES_FORMAT_AMD: gl_access_qualifier = gl_access_qualifier(1024);
}
impl gl_access_qualifier {
    #[doc = " Whether a multi sample image load intrinsic uses sample index extracted\n from fragment mask buffer."]
    pub const ACCESS_FMASK_LOWERED_AMD: gl_access_qualifier = gl_access_qualifier(2048);
}
impl gl_access_qualifier {
    #[doc = " Whether it is safe to speculatively execute this load. This allows\n hoisting loads out of conditional control flow (including out of software\n bounds checks). Setting this optimally depends on knowledge of the\n hardware. Speculation is safe if out-of-bounds access does not trigger\n undefined behaviour (even though the returned value of the speculated load\n is bogus). This is the case if there is hardware-level bounds checking, or\n if MMU faults are suppressed for the load."]
    pub const ACCESS_CAN_SPECULATE: gl_access_qualifier = gl_access_qualifier(4096);
}
impl gl_access_qualifier {
    #[doc = " Whether coherency with CP (command processor) or GE (geometry engine)\n is required."]
    pub const ACCESS_CP_GE_COHERENT_AMD: gl_access_qualifier = gl_access_qualifier(8192);
}
impl gl_access_qualifier {
    #[doc = " Whether coherency with CP (command processor) or GE (geometry engine)\n is required."]
    pub const ACCESS_IN_BOUNDS_AGX: gl_access_qualifier = gl_access_qualifier(16384);
}
impl gl_access_qualifier {
    #[doc = " Disallow vectorization.\n\n On some hw (AMD), sparse buffer loads return 0 for all components if\n a sparse load starts on a non-resident page, crosses the page boundary,\n and ends on a resident page. Sometimes we want it to return 0 only for\n the portion of the load that's non-resident, and load values for\n the portion that's resident. The workaround is to scalarize such loads\n and disallow vectorization. This is used by an internal copy_buffer\n shader where the API wants to copy all bytes that are resident."]
    pub const ACCESS_KEEP_SCALAR: gl_access_qualifier = gl_access_qualifier(32768);
}
impl gl_access_qualifier {
    #[doc = " Indicates that this load will use SMEM."]
    pub const ACCESS_SMEM_AMD: gl_access_qualifier = gl_access_qualifier(65536);
}
impl ::std::ops::BitOr<gl_access_qualifier> for gl_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        gl_access_qualifier(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for gl_access_qualifier {
    #[inline]
    fn bitor_assign(&mut self, rhs: gl_access_qualifier) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<gl_access_qualifier> for gl_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        gl_access_qualifier(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for gl_access_qualifier {
    #[inline]
    fn bitand_assign(&mut self, rhs: gl_access_qualifier) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[doc = " \\brief Memory access qualifiers"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct gl_access_qualifier(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_tess_spacing {
    TESS_SPACING_UNSPECIFIED = 0,
    TESS_SPACING_EQUAL = 1,
    TESS_SPACING_FRACTIONAL_ODD = 2,
    TESS_SPACING_FRACTIONAL_EVEN = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum tess_primitive_mode {
    TESS_PRIMITIVE_UNSPECIFIED = 0,
    TESS_PRIMITIVE_TRIANGLES = 1,
    TESS_PRIMITIVE_QUADS = 2,
    TESS_PRIMITIVE_ISOLINES = 3,
}
unsafe extern "C" {
    #[link_name = "mesa_count_tess_level_components__extern"]
    pub fn mesa_count_tess_level_components(
        mode: tess_primitive_mode,
        outer: *mut ::std::os::raw::c_uint,
        inner: *mut ::std::os::raw::c_uint,
    );
}
impl mesa_prim {
    pub const MESA_PRIM_MAX: mesa_prim = mesa_prim::MESA_PRIM_PATCHES;
}
#[repr(u8)]
#[doc = " Mesa primitive types for both GL and Vulkan:"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_prim {
    MESA_PRIM_POINTS = 0,
    MESA_PRIM_LINES = 1,
    MESA_PRIM_LINE_LOOP = 2,
    MESA_PRIM_LINE_STRIP = 3,
    MESA_PRIM_TRIANGLES = 4,
    MESA_PRIM_TRIANGLE_STRIP = 5,
    MESA_PRIM_TRIANGLE_FAN = 6,
    MESA_PRIM_QUADS = 7,
    MESA_PRIM_QUAD_STRIP = 8,
    MESA_PRIM_POLYGON = 9,
    MESA_PRIM_LINES_ADJACENCY = 10,
    MESA_PRIM_LINE_STRIP_ADJACENCY = 11,
    MESA_PRIM_TRIANGLES_ADJACENCY = 12,
    MESA_PRIM_TRIANGLE_STRIP_ADJACENCY = 13,
    MESA_PRIM_PATCHES = 14,
    MESA_PRIM_COUNT = 15,
    MESA_PRIM_UNKNOWN = 28,
}
unsafe extern "C" {
    #[doc = " Number of vertices per primitive as seen by a geometry or mesh shader."]
    #[link_name = "mesa_vertices_per_prim__extern"]
    pub fn mesa_vertices_per_prim(prim: mesa_prim) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Returns the number of decomposed primitives for the given\n vertex count.\n Parts of the pipline are invoked once for each triangle in\n triangle strip, triangle fans and triangles and once\n for each line in line strip, line loop, lines. Also\n statistics depend on knowing the exact number of decomposed\n primitives for a set of vertices."]
    #[link_name = "u_decomposed_prims_for_vertices__extern"]
    pub fn u_decomposed_prims_for_vertices(
        primitive: mesa_prim,
        vertices: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Decompose a primitive that is a loop, a strip, or a fan.  Return the\n original primitive if it is already decomposed."]
    #[link_name = "u_decomposed_prim__extern"]
    pub fn u_decomposed_prim(prim: mesa_prim) -> mesa_prim;
}
unsafe extern "C" {
    #[doc = " Reduce a primitive to one of MESA_PRIM_POINTS, MESA_PRIM_LINES, and\n MESA_PRIM_TRIANGLES."]
    #[link_name = "u_reduced_prim__extern"]
    pub fn u_reduced_prim(prim: mesa_prim) -> mesa_prim;
}
unsafe extern "C" {
    #[link_name = "mesa_prim_has_adjacency__extern"]
    pub fn mesa_prim_has_adjacency(prim: mesa_prim) -> bool;
}
#[repr(u32)]
#[doc = " A compare function enum for use in compiler lowering passes.  This is in\n the same order as GL's compare functions (shifted down by GL_NEVER), and is\n exactly the same as gallium's PIPE_FUNC_*."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum compare_func {
    COMPARE_FUNC_NEVER = 0,
    COMPARE_FUNC_LESS = 1,
    COMPARE_FUNC_EQUAL = 2,
    COMPARE_FUNC_LEQUAL = 3,
    COMPARE_FUNC_GREATER = 4,
    COMPARE_FUNC_NOTEQUAL = 5,
    COMPARE_FUNC_GEQUAL = 6,
    COMPARE_FUNC_ALWAYS = 7,
}
#[repr(u32)]
#[doc = " Arrangements for grouping invocations from NV_compute_shader_derivatives.\n\n   The extension provides new layout qualifiers that support two different\n   arrangements of compute shader invocations for the purpose of derivative\n   computation.  When specifying\n\n     layout(derivative_group_quadsNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation ID values follow the pattern:\n\n       +-----------------+------------------+\n       | (2x+0, 2y+0, z) |  (2x+1, 2y+0, z) |\n       +-----------------+------------------+\n       | (2x+0, 2y+1, z) |  (2x+1, 2y+1, z) |\n       +-----------------+------------------+\n\n   where Y increases from bottom to top.  When specifying\n\n     layout(derivative_group_linearNV) in;\n\n   compute shader invocations are grouped into 2x2x1 arrays whose four local\n   invocation index values follow the pattern:\n\n       +------+------+\n       | 4n+0 | 4n+1 |\n       +------+------+\n       | 4n+2 | 4n+3 |\n       +------+------+\n\n   If neither layout qualifier is specified, derivatives in compute shaders\n   return zero, which is consistent with the handling of built-in texture\n   functions like texture() in GLSL 4.50 compute shaders."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_derivative_group {
    DERIVATIVE_GROUP_NONE = 0,
    DERIVATIVE_GROUP_QUADS = 1,
    DERIVATIVE_GROUP_LINEAR = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum float_controls {
    FLOAT_CONTROLS_DEFAULT_FLOAT_CONTROL_MODE = 0,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP16 = 1,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP32 = 2,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE_FP64 = 4,
    FLOAT_CONTROLS_INF_PRESERVE_FP16 = 8,
    FLOAT_CONTROLS_INF_PRESERVE_FP32 = 16,
    FLOAT_CONTROLS_INF_PRESERVE_FP64 = 32,
    FLOAT_CONTROLS_NAN_PRESERVE_FP16 = 64,
    FLOAT_CONTROLS_NAN_PRESERVE_FP32 = 128,
    FLOAT_CONTROLS_NAN_PRESERVE_FP64 = 256,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP16 = 512,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP32 = 1024,
    FLOAT_CONTROLS_DENORM_PRESERVE_FP64 = 2048,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP16 = 4096,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP32 = 8192,
    FLOAT_CONTROLS_DENORM_FLUSH_TO_ZERO_FP64 = 16384,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP16 = 32768,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP32 = 65536,
    FLOAT_CONTROLS_ROUNDING_MODE_RTE_FP64 = 131072,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP16 = 262144,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP32 = 524288,
    FLOAT_CONTROLS_ROUNDING_MODE_RTZ_FP64 = 1048576,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP16 = 73,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP32 = 146,
    FLOAT_CONTROLS_SIGNED_ZERO_INF_NAN_PRESERVE_FP64 = 292,
    FLOAT_CONTROLS_SIGNED_ZERO_PRESERVE = 7,
    FLOAT_CONTROLS_INF_PRESERVE = 56,
    FLOAT_CONTROLS_NAN_PRESERVE = 448,
}
pub mod cl_sampler_addressing_mode {
    #[doc = " Enums to describe sampler properties used by OpenCL's inline constant samplers.\n These values match the meanings described in the SPIR-V spec."]
    pub type Type = ::std::os::raw::c_uint;
    pub const SAMPLER_ADDRESSING_MODE_NONE: Type = 0;
    pub const SAMPLER_ADDRESSING_MODE_CLAMP_TO_EDGE: Type = 1;
    pub const SAMPLER_ADDRESSING_MODE_CLAMP: Type = 2;
    pub const SAMPLER_ADDRESSING_MODE_REPEAT: Type = 3;
    pub const SAMPLER_ADDRESSING_MODE_REPEAT_MIRRORED: Type = 4;
}
pub mod cl_sampler_filter_mode {
    pub type Type = ::std::os::raw::c_uint;
    pub const SAMPLER_FILTER_MODE_NEAREST: Type = 0;
    pub const SAMPLER_FILTER_MODE_LINEAR: Type = 1;
}
#[repr(u8)]
#[doc = " An enum representing what kind of input gl_SubgroupSize is."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum gl_subgroup_size {
    #[doc = " Actual subgroup size, whatever that happens to be"]
    SUBGROUP_SIZE_VARYING = 0,
    #[doc = " Subgroup size must appear to be draw or dispatch-uniform\n\n This is the OpenGL behavior"]
    SUBGROUP_SIZE_UNIFORM = 1,
    #[doc = " Subgroup size must appear to be the API advertised constant\n\n This is the default Vulkan 1.1 behavior"]
    SUBGROUP_SIZE_API_CONSTANT = 2,
    #[doc = " Subgroup size must actually be the API advertised constant\n\n Not only must the subgroup size match the API advertised constant as\n with SUBGROUP_SIZE_API_CONSTANT but it must also be dispatched such that\n all the subgroups are full if there are enough invocations."]
    SUBGROUP_SIZE_FULL_SUBGROUPS = 3,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_4 = 4,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_8 = 8,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_16 = 16,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_32 = 32,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_64 = 64,
    #[doc = "< VK_EXT_subgroup_size_control"]
    SUBGROUP_SIZE_REQUIRE_128 = 128,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_scope {
    SCOPE_NONE = 0,
    SCOPE_INVOCATION = 1,
    SCOPE_SUBGROUP = 2,
    SCOPE_SHADER_CALL = 3,
    SCOPE_WORKGROUP = 4,
    SCOPE_QUEUE_FAMILY = 5,
    SCOPE_DEVICE = 6,
}
unsafe extern "C" {
    pub fn mesa_scope_name(scope: mesa_scope) -> *const ::std::os::raw::c_char;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_sampler_dim {
    GLSL_SAMPLER_DIM_1D = 0,
    GLSL_SAMPLER_DIM_2D = 1,
    GLSL_SAMPLER_DIM_3D = 2,
    GLSL_SAMPLER_DIM_CUBE = 3,
    GLSL_SAMPLER_DIM_RECT = 4,
    GLSL_SAMPLER_DIM_BUF = 5,
    GLSL_SAMPLER_DIM_EXTERNAL = 6,
    GLSL_SAMPLER_DIM_MS = 7,
    GLSL_SAMPLER_DIM_SUBPASS = 8,
    GLSL_SAMPLER_DIM_SUBPASS_MS = 9,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct blob {
    pub data: *mut u8,
    #[doc = " Number of bytes that have been allocated for \\c data."]
    pub allocated: usize,
    #[doc = " The number of bytes that have actual data written to them."]
    pub size: usize,
    #[doc = " True if \\c data a fixed allocation that we cannot resize\n\n \\see blob_init_fixed"]
    pub fixed_allocation: bool,
    #[doc = " True if we've ever failed to realloc or if we go past the end of a fixed\n allocation blob."]
    pub out_of_memory: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of blob"][::std::mem::size_of::<blob>() - 16usize];
    ["Alignment of blob"][::std::mem::align_of::<blob>() - 4usize];
    ["Offset of field: blob::data"][::std::mem::offset_of!(blob, data) - 0usize];
    ["Offset of field: blob::allocated"][::std::mem::offset_of!(blob, allocated) - 4usize];
    ["Offset of field: blob::size"][::std::mem::offset_of!(blob, size) - 8usize];
    ["Offset of field: blob::fixed_allocation"]
        [::std::mem::offset_of!(blob, fixed_allocation) - 12usize];
    ["Offset of field: blob::out_of_memory"][::std::mem::offset_of!(blob, out_of_memory) - 13usize];
};
impl Default for blob {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct blob_reader {
    pub data: *const u8,
    pub end: *const u8,
    pub current: *const u8,
    pub overrun: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of blob_reader"][::std::mem::size_of::<blob_reader>() - 16usize];
    ["Alignment of blob_reader"][::std::mem::align_of::<blob_reader>() - 4usize];
    ["Offset of field: blob_reader::data"][::std::mem::offset_of!(blob_reader, data) - 0usize];
    ["Offset of field: blob_reader::end"][::std::mem::offset_of!(blob_reader, end) - 4usize];
    ["Offset of field: blob_reader::current"]
        [::std::mem::offset_of!(blob_reader, current) - 8usize];
    ["Offset of field: blob_reader::overrun"]
        [::std::mem::offset_of!(blob_reader, overrun) - 12usize];
};
impl Default for blob_reader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Init a new, empty blob."]
    pub fn blob_init(blob: *mut blob);
}
unsafe extern "C" {
    #[doc = " Init a new, fixed-size blob.\n\n A fixed-size blob has a fixed block of data that will not be freed on\n blob_finish and will never be grown.  If we hit the end, we simply start\n returning false from the write functions.\n\n If a fixed-size blob has a NULL data pointer then the data is written but\n it otherwise operates normally.  This can be used to determine the size\n that will be required to write a given data structure."]
    pub fn blob_init_fixed(blob: *mut blob, data: *mut ::std::os::raw::c_void, size: usize);
}
unsafe extern "C" {
    #[doc = " Finish a blob and free its memory.\n\n If \\blob was initialized with blob_init_fixed, the data pointer is\n considered to be owned by the user and will not be freed."]
    #[link_name = "blob_finish__extern"]
    pub fn blob_finish(blob: *mut blob);
}
unsafe extern "C" {
    pub fn blob_finish_get_buffer(
        blob: *mut blob,
        buffer: *mut *mut ::std::os::raw::c_void,
        size: *mut usize,
    );
}
unsafe extern "C" {
    #[doc = " Aligns the blob to the given alignment.\n\n \\see blob_reader_align\n\n \\return True unless allocation fails"]
    pub fn blob_align(blob: *mut blob, alignment: usize) -> bool;
}
unsafe extern "C" {
    #[doc = " Add some unstructured, fixed-size data to a blob.\n\n \\return True unless allocation failed."]
    pub fn blob_write_bytes(
        blob: *mut blob,
        bytes: *const ::std::os::raw::c_void,
        to_write: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Reserve space in \\blob for a number of bytes.\n\n Space will be allocated within the blob for these byes, but the bytes will\n be left uninitialized. The caller is expected to use \\sa\n blob_overwrite_bytes to write to these bytes.\n\n \\return An offset to space allocated within \\blob to which \\to_write bytes\n can be written, (or -1 in case of any allocation error)."]
    pub fn blob_reserve_bytes(blob: *mut blob, to_write: usize) -> isize;
}
unsafe extern "C" {
    #[doc = " Similar to \\sa blob_reserve_bytes, but only reserves an uint32_t worth of\n space. Note that this must be used if later reading with \\sa\n blob_read_uint32, since it aligns the offset correctly."]
    pub fn blob_reserve_uint32(blob: *mut blob) -> isize;
}
unsafe extern "C" {
    #[doc = " Similar to \\sa blob_reserve_bytes, but only reserves an intptr_t worth of\n space. Note that this must be used if later reading with \\sa\n blob_read_intptr, since it aligns the offset correctly."]
    pub fn blob_reserve_intptr(blob: *mut blob) -> isize;
}
unsafe extern "C" {
    #[doc = " Overwrite some data previously written to the blob.\n\n Writes data to an existing portion of the blob at an offset of \\offset.\n This data range must have previously been written to the blob by one of the\n blob_write_* calls.\n\n For example usage, see blob_overwrite_uint32\n\n \\return True unless the requested offset or offset+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_bytes(
        blob: *mut blob,
        offset: usize,
        bytes: *const ::std::os::raw::c_void,
        to_write: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Add a uint8_t to a blob.\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint8(blob: *mut blob, value: u8) -> bool;
}
unsafe extern "C" {
    #[doc = " Overwrite a uint8_t previously written to the blob.\n\n Writes a uint8_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_uint8(blob: *mut blob, offset: usize, value: u8) -> bool;
}
unsafe extern "C" {
    #[doc = " Add a uint16_t to a blob.\n\n \\note This function will only write to a uint16_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint16(blob: *mut blob, value: u16) -> bool;
}
unsafe extern "C" {
    #[doc = " Add a uint32_t to a blob.\n\n \\note This function will only write to a uint32_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint32(blob: *mut blob, value: u32) -> bool;
}
unsafe extern "C" {
    #[doc = " Overwrite a uint32_t previously written to the blob.\n\n Writes a uint32_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n\n The expected usage is something like the following pattern:\n\n\tsize_t offset;\n\n\toffset = blob_reserve_uint32(blob);\n\t... various blob write calls, writing N items ...\n\tblob_overwrite_uint32 (blob, offset, N);\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_uint32(blob: *mut blob, offset: usize, value: u32) -> bool;
}
unsafe extern "C" {
    #[doc = " Add a uint64_t to a blob.\n\n \\note This function will only write to a uint64_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_uint64(blob: *mut blob, value: u64) -> bool;
}
unsafe extern "C" {
    #[doc = " Add an intptr_t to a blob.\n\n \\note This function will only write to an intptr_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be added to the\n blob if this write follows some unaligned write (such as\n blob_write_string).\n\n \\return True unless allocation failed."]
    pub fn blob_write_intptr(blob: *mut blob, value: isize) -> bool;
}
unsafe extern "C" {
    #[doc = " Overwrite an intptr_t previously written to the blob.\n\n Writes a intptr_t value to an existing portion of the blob at an offset of\n \\offset.  This data range must have previously been written to the blob by\n one of the blob_write_* calls.\n\n For example usage, see blob_overwrite_uint32\n\n \\return True unless the requested position or position+to_write lie outside\n the current blob's size."]
    pub fn blob_overwrite_intptr(blob: *mut blob, offset: usize, value: isize) -> bool;
}
unsafe extern "C" {
    #[doc = " Add a NULL-terminated string to a blob, (including the NULL terminator).\n\n \\return True unless allocation failed."]
    pub fn blob_write_string(blob: *mut blob, str_: *const ::std::os::raw::c_char) -> bool;
}
unsafe extern "C" {
    #[doc = " Start reading a blob, (initializing the contents of \\blob for reading).\n\n After this call, the caller can use the various blob_read_* functions to\n read elements from the data array.\n\n For all of the blob_read_* functions, if there is insufficient data\n remaining, the functions will do nothing, (perhaps returning default values\n such as 0). The caller can detect this by noting that the blob_reader's\n current value is unchanged before and after the call."]
    pub fn blob_reader_init(
        blob: *mut blob_reader,
        data: *const ::std::os::raw::c_void,
        size: usize,
    );
}
unsafe extern "C" {
    #[doc = " Align the current offset of the blob reader to the given alignment.\n\n This may be useful if you need the result of blob_read_bytes to have a\n particular alignment.  Note that this only aligns relative to blob->data\n and the alignment of the resulting pointer is only guaranteed if blob->data\n is also aligned to the requested alignment."]
    pub fn blob_reader_align(blob: *mut blob_reader, alignment: usize);
}
unsafe extern "C" {
    #[doc = " Read some unstructured, fixed-size data from the current location, (and\n update the current location to just past this data).\n\n \\note The memory returned belongs to the data underlying the blob reader. The\n caller must copy the data in order to use it after the lifetime of the data\n underlying the blob reader.\n\n \\return The bytes read (see note above about memory lifetime)."]
    pub fn blob_read_bytes(blob: *mut blob_reader, size: usize) -> *const ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Read some unstructured, fixed-size data from the current location, copying\n it to \\dest (and update the current location to just past this data)"]
    pub fn blob_copy_bytes(blob: *mut blob_reader, dest: *mut ::std::os::raw::c_void, size: usize);
}
unsafe extern "C" {
    #[doc = " Skip \\size bytes within the blob."]
    pub fn blob_skip_bytes(blob: *mut blob_reader, size: usize);
}
unsafe extern "C" {
    #[doc = " Read a uint8_t from the current location, (and update the current location\n to just past this uint8_t).\n\n \\return The uint8_t read"]
    pub fn blob_read_uint8(blob: *mut blob_reader) -> u8;
}
unsafe extern "C" {
    #[doc = " Read a uint16_t from the current location, (and update the current location\n to just past this uint16_t).\n\n \\note This function will only read from a uint16_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint16_t read"]
    pub fn blob_read_uint16(blob: *mut blob_reader) -> u16;
}
unsafe extern "C" {
    #[doc = " Read a uint32_t from the current location, (and update the current location\n to just past this uint32_t).\n\n \\note This function will only read from a uint32_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint32_t read"]
    pub fn blob_read_uint32(blob: *mut blob_reader) -> u32;
}
unsafe extern "C" {
    #[doc = " Read a uint64_t from the current location, (and update the current location\n to just past this uint64_t).\n\n \\note This function will only read from a uint64_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The uint64_t read"]
    pub fn blob_read_uint64(blob: *mut blob_reader) -> u64;
}
unsafe extern "C" {
    #[doc = " Read an intptr_t value from the current location, (and update the\n current location to just past this intptr_t).\n\n \\note This function will only read from an intptr_t-aligned offset from the\n beginning of the blob's data, so some padding bytes may be skipped.\n\n \\return The intptr_t read"]
    pub fn blob_read_intptr(blob: *mut blob_reader) -> isize;
}
unsafe extern "C" {
    #[doc = " Read a NULL-terminated string from the current location, (and update the\n current location to just past this string).\n\n \\note The memory returned belongs to the data underlying the blob reader. The\n caller must copy the string in order to use the string after the lifetime\n of the data underlying the blob reader.\n\n \\return The string read (see note above about memory lifetime). However, if\n there is no NULL byte remaining within the blob, this function returns\n NULL."]
    pub fn blob_read_string(blob: *mut blob_reader) -> *mut ::std::os::raw::c_char;
}
#[repr(u32)]
#[doc = " Formats for textures, surfaces and vertex data"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_format {
    PIPE_FORMAT_NONE = 0,
    #[doc = "< raw doubles (ARB_vertex_attrib_64bit)"]
    PIPE_FORMAT_R64_UINT = 1,
    PIPE_FORMAT_R64G64_UINT = 2,
    PIPE_FORMAT_R64G64B64_UINT = 3,
    PIPE_FORMAT_R64G64B64A64_UINT = 4,
    PIPE_FORMAT_R64_SINT = 5,
    PIPE_FORMAT_R64G64_SINT = 6,
    PIPE_FORMAT_R64G64B64_SINT = 7,
    PIPE_FORMAT_R64G64B64A64_SINT = 8,
    #[doc = "< doubles converted to float"]
    PIPE_FORMAT_R64_FLOAT = 9,
    PIPE_FORMAT_R64G64_FLOAT = 10,
    PIPE_FORMAT_R64G64B64_FLOAT = 11,
    PIPE_FORMAT_R64G64B64A64_FLOAT = 12,
    PIPE_FORMAT_R32_FLOAT = 13,
    PIPE_FORMAT_R32G32_FLOAT = 14,
    PIPE_FORMAT_R32G32B32_FLOAT = 15,
    PIPE_FORMAT_R32G32B32A32_FLOAT = 16,
    PIPE_FORMAT_R32_UNORM = 17,
    PIPE_FORMAT_R32G32_UNORM = 18,
    PIPE_FORMAT_R32G32B32_UNORM = 19,
    PIPE_FORMAT_R32G32B32A32_UNORM = 20,
    PIPE_FORMAT_R32_USCALED = 21,
    PIPE_FORMAT_R32G32_USCALED = 22,
    PIPE_FORMAT_R32G32B32_USCALED = 23,
    PIPE_FORMAT_R32G32B32A32_USCALED = 24,
    PIPE_FORMAT_R32_SNORM = 25,
    PIPE_FORMAT_R32G32_SNORM = 26,
    PIPE_FORMAT_R32G32B32_SNORM = 27,
    PIPE_FORMAT_R32G32B32A32_SNORM = 28,
    PIPE_FORMAT_R32_SSCALED = 29,
    PIPE_FORMAT_R32G32_SSCALED = 30,
    PIPE_FORMAT_R32G32B32_SSCALED = 31,
    PIPE_FORMAT_R32G32B32A32_SSCALED = 32,
    PIPE_FORMAT_R16_UNORM = 33,
    PIPE_FORMAT_R16G16_UNORM = 34,
    PIPE_FORMAT_R16G16B16_UNORM = 35,
    PIPE_FORMAT_R16G16B16A16_UNORM = 36,
    PIPE_FORMAT_R16_USCALED = 37,
    PIPE_FORMAT_R16G16_USCALED = 38,
    PIPE_FORMAT_R16G16B16_USCALED = 39,
    PIPE_FORMAT_R16G16B16A16_USCALED = 40,
    PIPE_FORMAT_R16_SNORM = 41,
    PIPE_FORMAT_R16G16_SNORM = 42,
    PIPE_FORMAT_R16G16B16_SNORM = 43,
    PIPE_FORMAT_R16G16B16A16_SNORM = 44,
    PIPE_FORMAT_R16_SSCALED = 45,
    PIPE_FORMAT_R16G16_SSCALED = 46,
    PIPE_FORMAT_R16G16B16_SSCALED = 47,
    PIPE_FORMAT_R16G16B16A16_SSCALED = 48,
    PIPE_FORMAT_R8_UNORM = 49,
    PIPE_FORMAT_R8G8_UNORM = 50,
    PIPE_FORMAT_R8G8B8_UNORM = 51,
    PIPE_FORMAT_B8G8R8_UNORM = 52,
    PIPE_FORMAT_R8G8B8A8_UNORM = 53,
    PIPE_FORMAT_B8G8R8A8_UNORM = 54,
    PIPE_FORMAT_R8_USCALED = 55,
    PIPE_FORMAT_R8G8_USCALED = 56,
    PIPE_FORMAT_R8G8B8_USCALED = 57,
    PIPE_FORMAT_B8G8R8_USCALED = 58,
    PIPE_FORMAT_R8G8B8A8_USCALED = 59,
    PIPE_FORMAT_B8G8R8A8_USCALED = 60,
    PIPE_FORMAT_A8B8G8R8_USCALED = 61,
    PIPE_FORMAT_R8_SNORM = 62,
    PIPE_FORMAT_R8G8_SNORM = 63,
    PIPE_FORMAT_R8G8B8_SNORM = 64,
    PIPE_FORMAT_B8G8R8_SNORM = 65,
    PIPE_FORMAT_R8G8B8A8_SNORM = 66,
    PIPE_FORMAT_B8G8R8A8_SNORM = 67,
    PIPE_FORMAT_R8_SSCALED = 68,
    PIPE_FORMAT_R8G8_SSCALED = 69,
    PIPE_FORMAT_R8G8B8_SSCALED = 70,
    PIPE_FORMAT_B8G8R8_SSCALED = 71,
    PIPE_FORMAT_R8G8B8A8_SSCALED = 72,
    PIPE_FORMAT_B8G8R8A8_SSCALED = 73,
    PIPE_FORMAT_A8B8G8R8_SSCALED = 74,
    PIPE_FORMAT_A8R8G8B8_UNORM = 75,
    PIPE_FORMAT_R32_FIXED = 76,
    PIPE_FORMAT_R32G32_FIXED = 77,
    PIPE_FORMAT_R32G32B32_FIXED = 78,
    PIPE_FORMAT_R32G32B32A32_FIXED = 79,
    PIPE_FORMAT_R16_FLOAT = 80,
    PIPE_FORMAT_R16G16_FLOAT = 81,
    PIPE_FORMAT_R16G16B16_FLOAT = 82,
    PIPE_FORMAT_R16G16B16A16_FLOAT = 83,
    PIPE_FORMAT_R8_UINT = 84,
    PIPE_FORMAT_R8G8_UINT = 85,
    PIPE_FORMAT_R8G8B8_UINT = 86,
    PIPE_FORMAT_B8G8R8_UINT = 87,
    PIPE_FORMAT_R8G8B8A8_UINT = 88,
    PIPE_FORMAT_B8G8R8A8_UINT = 89,
    PIPE_FORMAT_R8_SINT = 90,
    PIPE_FORMAT_R8G8_SINT = 91,
    PIPE_FORMAT_R8G8B8_SINT = 92,
    PIPE_FORMAT_B8G8R8_SINT = 93,
    PIPE_FORMAT_R8G8B8A8_SINT = 94,
    PIPE_FORMAT_B8G8R8A8_SINT = 95,
    PIPE_FORMAT_R16_UINT = 96,
    PIPE_FORMAT_R16G16_UINT = 97,
    PIPE_FORMAT_R16G16B16_UINT = 98,
    PIPE_FORMAT_R16G16B16A16_UINT = 99,
    PIPE_FORMAT_R16_SINT = 100,
    PIPE_FORMAT_R16G16_SINT = 101,
    PIPE_FORMAT_R16G16B16_SINT = 102,
    PIPE_FORMAT_R16G16B16A16_SINT = 103,
    PIPE_FORMAT_R32_UINT = 104,
    PIPE_FORMAT_R32G32_UINT = 105,
    PIPE_FORMAT_R32G32B32_UINT = 106,
    PIPE_FORMAT_R32G32B32A32_UINT = 107,
    PIPE_FORMAT_R32_SINT = 108,
    PIPE_FORMAT_R32G32_SINT = 109,
    PIPE_FORMAT_R32G32B32_SINT = 110,
    PIPE_FORMAT_R32G32B32A32_SINT = 111,
    PIPE_FORMAT_R10G10B10A2_UNORM = 112,
    PIPE_FORMAT_R10G10B10A2_SNORM = 113,
    PIPE_FORMAT_R10G10B10A2_USCALED = 114,
    PIPE_FORMAT_R10G10B10A2_SSCALED = 115,
    PIPE_FORMAT_B10G10R10A2_UNORM = 116,
    PIPE_FORMAT_B10G10R10A2_SNORM = 117,
    PIPE_FORMAT_B10G10R10A2_USCALED = 118,
    PIPE_FORMAT_B10G10R10A2_SSCALED = 119,
    PIPE_FORMAT_R11G11B10_FLOAT = 120,
    PIPE_FORMAT_R10G10B10A2_UINT = 121,
    PIPE_FORMAT_R10G10B10A2_SINT = 122,
    PIPE_FORMAT_B10G10R10A2_UINT = 123,
    PIPE_FORMAT_B10G10R10A2_SINT = 124,
    PIPE_FORMAT_B8G8R8X8_UNORM = 125,
    PIPE_FORMAT_X8B8G8R8_UNORM = 126,
    PIPE_FORMAT_X8R8G8B8_UNORM = 127,
    PIPE_FORMAT_B5G5R5A1_UNORM = 128,
    PIPE_FORMAT_R4G4B4A4_UNORM = 129,
    PIPE_FORMAT_B4G4R4A4_UNORM = 130,
    PIPE_FORMAT_R5G6B5_UNORM = 131,
    PIPE_FORMAT_B5G6R5_UNORM = 132,
    #[doc = "< ubyte luminance"]
    PIPE_FORMAT_L8_UNORM = 133,
    #[doc = "< ubyte alpha"]
    PIPE_FORMAT_A8_UNORM = 134,
    #[doc = "< ubyte intensity"]
    PIPE_FORMAT_I8_UNORM = 135,
    #[doc = "< ubyte alpha, luminance"]
    PIPE_FORMAT_L8A8_UNORM = 136,
    #[doc = "< ushort luminance"]
    PIPE_FORMAT_L16_UNORM = 137,
    PIPE_FORMAT_UYVY = 138,
    PIPE_FORMAT_VYUY = 139,
    PIPE_FORMAT_YUYV = 140,
    PIPE_FORMAT_YVYU = 141,
    PIPE_FORMAT_Z16_UNORM = 142,
    PIPE_FORMAT_Z16_UNORM_S8_UINT = 143,
    PIPE_FORMAT_Z32_UNORM = 144,
    PIPE_FORMAT_Z32_FLOAT = 145,
    PIPE_FORMAT_Z24_UNORM_S8_UINT = 146,
    PIPE_FORMAT_S8_UINT_Z24_UNORM = 147,
    PIPE_FORMAT_Z24X8_UNORM = 148,
    PIPE_FORMAT_X8Z24_UNORM = 149,
    #[doc = "< ubyte stencil"]
    PIPE_FORMAT_S8_UINT = 150,
    PIPE_FORMAT_L8_SRGB = 151,
    PIPE_FORMAT_R8_SRGB = 152,
    PIPE_FORMAT_L8A8_SRGB = 153,
    PIPE_FORMAT_R8G8_SRGB = 154,
    PIPE_FORMAT_R8G8B8_SRGB = 155,
    PIPE_FORMAT_B8G8R8_SRGB = 156,
    PIPE_FORMAT_A8B8G8R8_SRGB = 157,
    PIPE_FORMAT_X8B8G8R8_SRGB = 158,
    PIPE_FORMAT_B8G8R8A8_SRGB = 159,
    PIPE_FORMAT_B8G8R8X8_SRGB = 160,
    PIPE_FORMAT_A8R8G8B8_SRGB = 161,
    PIPE_FORMAT_X8R8G8B8_SRGB = 162,
    PIPE_FORMAT_R8G8B8A8_SRGB = 163,
    PIPE_FORMAT_DXT1_RGB = 164,
    PIPE_FORMAT_DXT1_RGBA = 165,
    PIPE_FORMAT_DXT3_RGBA = 166,
    PIPE_FORMAT_DXT5_RGBA = 167,
    PIPE_FORMAT_DXT1_SRGB = 168,
    PIPE_FORMAT_DXT1_SRGBA = 169,
    PIPE_FORMAT_DXT3_SRGBA = 170,
    PIPE_FORMAT_DXT5_SRGBA = 171,
    PIPE_FORMAT_RGTC1_UNORM = 172,
    PIPE_FORMAT_RGTC1_SNORM = 173,
    PIPE_FORMAT_RGTC2_UNORM = 174,
    PIPE_FORMAT_RGTC2_SNORM = 175,
    PIPE_FORMAT_R8G8_B8G8_UNORM = 176,
    PIPE_FORMAT_G8R8_G8B8_UNORM = 177,
    PIPE_FORMAT_X6G10_X6B10X6R10_420_UNORM = 178,
    PIPE_FORMAT_X4G12_X4B12X4R12_420_UNORM = 179,
    PIPE_FORMAT_X6R10_UNORM = 180,
    PIPE_FORMAT_X6R10X6G10_UNORM = 181,
    PIPE_FORMAT_X4R12_UNORM = 182,
    PIPE_FORMAT_X4R12X4G12_UNORM = 183,
    PIPE_FORMAT_R8SG8SB8UX8U_NORM = 184,
    PIPE_FORMAT_R5SG5SB6U_NORM = 185,
    PIPE_FORMAT_A8B8G8R8_UNORM = 186,
    PIPE_FORMAT_B5G5R5X1_UNORM = 187,
    PIPE_FORMAT_R9G9B9E5_FLOAT = 188,
    PIPE_FORMAT_Z32_FLOAT_S8X24_UINT = 189,
    PIPE_FORMAT_R1_UNORM = 190,
    PIPE_FORMAT_R10G10B10X2_USCALED = 191,
    PIPE_FORMAT_R10G10B10X2_SNORM = 192,
    PIPE_FORMAT_L4A4_UNORM = 193,
    PIPE_FORMAT_A2R10G10B10_UNORM = 194,
    PIPE_FORMAT_A2B10G10R10_UNORM = 195,
    PIPE_FORMAT_R10SG10SB10SA2U_NORM = 196,
    PIPE_FORMAT_R8G8Bx_SNORM = 197,
    PIPE_FORMAT_R8G8B8X8_UNORM = 198,
    PIPE_FORMAT_B4G4R4X4_UNORM = 199,
    PIPE_FORMAT_X24S8_UINT = 200,
    PIPE_FORMAT_S8X24_UINT = 201,
    PIPE_FORMAT_X32_S8X24_UINT = 202,
    PIPE_FORMAT_R3G3B2_UNORM = 203,
    PIPE_FORMAT_B2G3R3_UNORM = 204,
    PIPE_FORMAT_L16A16_UNORM = 205,
    PIPE_FORMAT_A16_UNORM = 206,
    PIPE_FORMAT_I16_UNORM = 207,
    PIPE_FORMAT_LATC1_UNORM = 208,
    PIPE_FORMAT_LATC1_SNORM = 209,
    PIPE_FORMAT_LATC2_UNORM = 210,
    PIPE_FORMAT_LATC2_SNORM = 211,
    PIPE_FORMAT_A8_SNORM = 212,
    PIPE_FORMAT_L8_SNORM = 213,
    PIPE_FORMAT_L8A8_SNORM = 214,
    PIPE_FORMAT_I8_SNORM = 215,
    PIPE_FORMAT_A16_SNORM = 216,
    PIPE_FORMAT_L16_SNORM = 217,
    PIPE_FORMAT_L16A16_SNORM = 218,
    PIPE_FORMAT_I16_SNORM = 219,
    PIPE_FORMAT_A16_FLOAT = 220,
    PIPE_FORMAT_L16_FLOAT = 221,
    PIPE_FORMAT_L16A16_FLOAT = 222,
    PIPE_FORMAT_I16_FLOAT = 223,
    PIPE_FORMAT_A32_FLOAT = 224,
    PIPE_FORMAT_L32_FLOAT = 225,
    PIPE_FORMAT_L32A32_FLOAT = 226,
    PIPE_FORMAT_I32_FLOAT = 227,
    PIPE_FORMAT_YV12 = 228,
    PIPE_FORMAT_YV16 = 229,
    #[doc = "< aka I420"]
    PIPE_FORMAT_IYUV = 230,
    PIPE_FORMAT_NV12 = 231,
    PIPE_FORMAT_NV21 = 232,
    PIPE_FORMAT_NV16 = 233,
    PIPE_FORMAT_NV15 = 234,
    PIPE_FORMAT_NV20 = 235,
    PIPE_FORMAT_Y8_400_UNORM = 236,
    PIPE_FORMAT_Y8_U8_V8_422_UNORM = 237,
    PIPE_FORMAT_Y8_U8_V8_444_UNORM = 238,
    PIPE_FORMAT_Y8_U8_V8_440_UNORM = 239,
    PIPE_FORMAT_Y16_U16_V16_420_UNORM = 240,
    PIPE_FORMAT_Y16_U16_V16_422_UNORM = 241,
    PIPE_FORMAT_Y16_U16V16_422_UNORM = 242,
    PIPE_FORMAT_Y16_U16_V16_444_UNORM = 243,
    PIPE_FORMAT_A4R4_UNORM = 244,
    PIPE_FORMAT_R4A4_UNORM = 245,
    PIPE_FORMAT_R8A8_UNORM = 246,
    PIPE_FORMAT_A8R8_UNORM = 247,
    PIPE_FORMAT_A8_UINT = 248,
    PIPE_FORMAT_I8_UINT = 249,
    PIPE_FORMAT_L8_UINT = 250,
    PIPE_FORMAT_L8A8_UINT = 251,
    PIPE_FORMAT_A8_SINT = 252,
    PIPE_FORMAT_I8_SINT = 253,
    PIPE_FORMAT_L8_SINT = 254,
    PIPE_FORMAT_L8A8_SINT = 255,
    PIPE_FORMAT_A16_UINT = 256,
    PIPE_FORMAT_I16_UINT = 257,
    PIPE_FORMAT_L16_UINT = 258,
    PIPE_FORMAT_L16A16_UINT = 259,
    PIPE_FORMAT_A16_SINT = 260,
    PIPE_FORMAT_I16_SINT = 261,
    PIPE_FORMAT_L16_SINT = 262,
    PIPE_FORMAT_L16A16_SINT = 263,
    PIPE_FORMAT_A32_UINT = 264,
    PIPE_FORMAT_I32_UINT = 265,
    PIPE_FORMAT_L32_UINT = 266,
    PIPE_FORMAT_L32A32_UINT = 267,
    PIPE_FORMAT_A32_SINT = 268,
    PIPE_FORMAT_I32_SINT = 269,
    PIPE_FORMAT_L32_SINT = 270,
    PIPE_FORMAT_L32A32_SINT = 271,
    PIPE_FORMAT_A8R8G8B8_UINT = 272,
    PIPE_FORMAT_A8B8G8R8_UINT = 273,
    PIPE_FORMAT_A2R10G10B10_UINT = 274,
    PIPE_FORMAT_A2B10G10R10_UINT = 275,
    PIPE_FORMAT_R5G6B5_UINT = 276,
    PIPE_FORMAT_B5G6R5_UINT = 277,
    PIPE_FORMAT_R5G5B5A1_UINT = 278,
    PIPE_FORMAT_B5G5R5A1_UINT = 279,
    PIPE_FORMAT_A1R5G5B5_UINT = 280,
    PIPE_FORMAT_A1B5G5R5_UINT = 281,
    PIPE_FORMAT_R4G4B4A4_UINT = 282,
    PIPE_FORMAT_B4G4R4A4_UINT = 283,
    PIPE_FORMAT_A4R4G4B4_UINT = 284,
    PIPE_FORMAT_A4B4G4R4_UINT = 285,
    PIPE_FORMAT_R3G3B2_UINT = 286,
    PIPE_FORMAT_B2G3R3_UINT = 287,
    PIPE_FORMAT_ETC1_RGB8 = 288,
    PIPE_FORMAT_R8G8_R8B8_UNORM = 289,
    PIPE_FORMAT_R8B8_R8G8_UNORM = 290,
    PIPE_FORMAT_G8R8_B8R8_UNORM = 291,
    PIPE_FORMAT_B8R8_G8R8_UNORM = 292,
    PIPE_FORMAT_G8B8_G8R8_UNORM = 293,
    PIPE_FORMAT_B8G8_R8G8_UNORM = 294,
    PIPE_FORMAT_R8G8B8X8_SNORM = 295,
    PIPE_FORMAT_R8G8B8X8_SRGB = 296,
    PIPE_FORMAT_R8G8B8X8_UINT = 297,
    PIPE_FORMAT_R8G8B8X8_SINT = 298,
    PIPE_FORMAT_B10G10R10X2_UNORM = 299,
    PIPE_FORMAT_R16G16B16X16_UNORM = 300,
    PIPE_FORMAT_R16G16B16X16_SNORM = 301,
    PIPE_FORMAT_R16G16B16X16_FLOAT = 302,
    PIPE_FORMAT_R16G16B16X16_UINT = 303,
    PIPE_FORMAT_R16G16B16X16_SINT = 304,
    PIPE_FORMAT_R32G32B32X32_FLOAT = 305,
    PIPE_FORMAT_R32G32B32X32_UINT = 306,
    PIPE_FORMAT_R32G32B32X32_SINT = 307,
    PIPE_FORMAT_R8A8_SNORM = 308,
    PIPE_FORMAT_R16A16_UNORM = 309,
    PIPE_FORMAT_R16A16_SNORM = 310,
    PIPE_FORMAT_R16A16_FLOAT = 311,
    PIPE_FORMAT_R32A32_FLOAT = 312,
    PIPE_FORMAT_R8A8_UINT = 313,
    PIPE_FORMAT_R8A8_SINT = 314,
    PIPE_FORMAT_R16A16_UINT = 315,
    PIPE_FORMAT_R16A16_SINT = 316,
    PIPE_FORMAT_R32A32_UINT = 317,
    PIPE_FORMAT_R32A32_SINT = 318,
    PIPE_FORMAT_B5G6R5_SRGB = 319,
    PIPE_FORMAT_BPTC_RGBA_UNORM = 320,
    PIPE_FORMAT_BPTC_SRGBA = 321,
    PIPE_FORMAT_BPTC_RGB_FLOAT = 322,
    PIPE_FORMAT_BPTC_RGB_UFLOAT = 323,
    PIPE_FORMAT_G8R8_UNORM = 324,
    PIPE_FORMAT_G8R8_SNORM = 325,
    PIPE_FORMAT_G16R16_UNORM = 326,
    PIPE_FORMAT_G16R16_SNORM = 327,
    PIPE_FORMAT_A8B8G8R8_SNORM = 328,
    PIPE_FORMAT_X8B8G8R8_SNORM = 329,
    PIPE_FORMAT_ETC2_RGB8 = 330,
    PIPE_FORMAT_ETC2_SRGB8 = 331,
    PIPE_FORMAT_ETC2_RGB8A1 = 332,
    PIPE_FORMAT_ETC2_SRGB8A1 = 333,
    PIPE_FORMAT_ETC2_RGBA8 = 334,
    PIPE_FORMAT_ETC2_SRGBA8 = 335,
    PIPE_FORMAT_ETC2_R11_UNORM = 336,
    PIPE_FORMAT_ETC2_R11_SNORM = 337,
    PIPE_FORMAT_ETC2_RG11_UNORM = 338,
    PIPE_FORMAT_ETC2_RG11_SNORM = 339,
    PIPE_FORMAT_ASTC_4x4 = 340,
    PIPE_FORMAT_ASTC_5x4 = 341,
    PIPE_FORMAT_ASTC_5x5 = 342,
    PIPE_FORMAT_ASTC_6x5 = 343,
    PIPE_FORMAT_ASTC_6x6 = 344,
    PIPE_FORMAT_ASTC_8x5 = 345,
    PIPE_FORMAT_ASTC_8x6 = 346,
    PIPE_FORMAT_ASTC_8x8 = 347,
    PIPE_FORMAT_ASTC_10x5 = 348,
    PIPE_FORMAT_ASTC_10x6 = 349,
    PIPE_FORMAT_ASTC_10x8 = 350,
    PIPE_FORMAT_ASTC_10x10 = 351,
    PIPE_FORMAT_ASTC_12x10 = 352,
    PIPE_FORMAT_ASTC_12x12 = 353,
    PIPE_FORMAT_ASTC_4x4_SRGB = 354,
    PIPE_FORMAT_ASTC_5x4_SRGB = 355,
    PIPE_FORMAT_ASTC_5x5_SRGB = 356,
    PIPE_FORMAT_ASTC_6x5_SRGB = 357,
    PIPE_FORMAT_ASTC_6x6_SRGB = 358,
    PIPE_FORMAT_ASTC_8x5_SRGB = 359,
    PIPE_FORMAT_ASTC_8x6_SRGB = 360,
    PIPE_FORMAT_ASTC_8x8_SRGB = 361,
    PIPE_FORMAT_ASTC_10x5_SRGB = 362,
    PIPE_FORMAT_ASTC_10x6_SRGB = 363,
    PIPE_FORMAT_ASTC_10x8_SRGB = 364,
    PIPE_FORMAT_ASTC_10x10_SRGB = 365,
    PIPE_FORMAT_ASTC_12x10_SRGB = 366,
    PIPE_FORMAT_ASTC_12x12_SRGB = 367,
    PIPE_FORMAT_ASTC_3x3x3 = 368,
    PIPE_FORMAT_ASTC_4x3x3 = 369,
    PIPE_FORMAT_ASTC_4x4x3 = 370,
    PIPE_FORMAT_ASTC_4x4x4 = 371,
    PIPE_FORMAT_ASTC_5x4x4 = 372,
    PIPE_FORMAT_ASTC_5x5x4 = 373,
    PIPE_FORMAT_ASTC_5x5x5 = 374,
    PIPE_FORMAT_ASTC_6x5x5 = 375,
    PIPE_FORMAT_ASTC_6x6x5 = 376,
    PIPE_FORMAT_ASTC_6x6x6 = 377,
    PIPE_FORMAT_ASTC_3x3x3_SRGB = 378,
    PIPE_FORMAT_ASTC_4x3x3_SRGB = 379,
    PIPE_FORMAT_ASTC_4x4x3_SRGB = 380,
    PIPE_FORMAT_ASTC_4x4x4_SRGB = 381,
    PIPE_FORMAT_ASTC_5x4x4_SRGB = 382,
    PIPE_FORMAT_ASTC_5x5x4_SRGB = 383,
    PIPE_FORMAT_ASTC_5x5x5_SRGB = 384,
    PIPE_FORMAT_ASTC_6x5x5_SRGB = 385,
    PIPE_FORMAT_ASTC_6x6x5_SRGB = 386,
    PIPE_FORMAT_ASTC_6x6x6_SRGB = 387,
    PIPE_FORMAT_FXT1_RGB = 388,
    PIPE_FORMAT_FXT1_RGBA = 389,
    PIPE_FORMAT_P010 = 390,
    PIPE_FORMAT_P012 = 391,
    PIPE_FORMAT_P016 = 392,
    PIPE_FORMAT_P030 = 393,
    PIPE_FORMAT_Y210 = 394,
    PIPE_FORMAT_Y212 = 395,
    PIPE_FORMAT_Y216 = 396,
    PIPE_FORMAT_Y410 = 397,
    PIPE_FORMAT_Y412 = 398,
    PIPE_FORMAT_Y416 = 399,
    PIPE_FORMAT_R10G10B10X2_UNORM = 400,
    PIPE_FORMAT_A1R5G5B5_UNORM = 401,
    PIPE_FORMAT_A1B5G5R5_UNORM = 402,
    PIPE_FORMAT_X1B5G5R5_UNORM = 403,
    PIPE_FORMAT_R5G5B5A1_UNORM = 404,
    PIPE_FORMAT_A4R4G4B4_UNORM = 405,
    PIPE_FORMAT_A4B4G4R4_UNORM = 406,
    PIPE_FORMAT_G8R8_SINT = 407,
    PIPE_FORMAT_A8B8G8R8_SINT = 408,
    PIPE_FORMAT_X8B8G8R8_SINT = 409,
    PIPE_FORMAT_ATC_RGB = 410,
    PIPE_FORMAT_ATC_RGBA_EXPLICIT = 411,
    PIPE_FORMAT_ATC_RGBA_INTERPOLATED = 412,
    PIPE_FORMAT_Z24_UNORM_S8_UINT_AS_R8G8B8A8 = 413,
    PIPE_FORMAT_AYUV = 414,
    PIPE_FORMAT_XYUV = 415,
    PIPE_FORMAT_R8_G8B8_420_UNORM = 416,
    PIPE_FORMAT_R8_B8G8_420_UNORM = 417,
    PIPE_FORMAT_G8_B8R8_420_UNORM = 418,
    PIPE_FORMAT_R10_G10B10_420_UNORM = 419,
    PIPE_FORMAT_R10_G10B10_422_UNORM = 420,
    PIPE_FORMAT_R8_G8_B8_420_UNORM = 421,
    PIPE_FORMAT_R8_B8_G8_420_UNORM = 422,
    PIPE_FORMAT_G8_B8_R8_420_UNORM = 423,
    PIPE_FORMAT_R8_G8B8_422_UNORM = 424,
    PIPE_FORMAT_R8_B8G8_422_UNORM = 425,
    PIPE_FORMAT_G8_B8R8_422_UNORM = 426,
    PIPE_FORMAT_R8_G8_B8_UNORM = 427,
    PIPE_FORMAT_Y8_UNORM = 428,
    PIPE_FORMAT_B8G8R8X8_SNORM = 429,
    PIPE_FORMAT_B8G8R8X8_UINT = 430,
    PIPE_FORMAT_B8G8R8X8_SINT = 431,
    PIPE_FORMAT_A8R8G8B8_SNORM = 432,
    PIPE_FORMAT_A8R8G8B8_SINT = 433,
    PIPE_FORMAT_X8R8G8B8_SNORM = 434,
    PIPE_FORMAT_X8R8G8B8_SINT = 435,
    PIPE_FORMAT_R5G5B5X1_UNORM = 436,
    PIPE_FORMAT_X1R5G5B5_UNORM = 437,
    PIPE_FORMAT_R4G4B4X4_UNORM = 438,
    PIPE_FORMAT_B10G10R10X2_SNORM = 439,
    PIPE_FORMAT_R5G6B5_SRGB = 440,
    PIPE_FORMAT_R10G10B10X2_SINT = 441,
    PIPE_FORMAT_B10G10R10X2_SINT = 442,
    PIPE_FORMAT_G16R16_SINT = 443,
    PIPE_FORMAT_COUNT = 444,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum pipe_video_chroma_format {
    PIPE_VIDEO_CHROMA_FORMAT_400 = 0,
    PIPE_VIDEO_CHROMA_FORMAT_420 = 1,
    PIPE_VIDEO_CHROMA_FORMAT_422 = 2,
    PIPE_VIDEO_CHROMA_FORMAT_444 = 3,
    PIPE_VIDEO_CHROMA_FORMAT_440 = 4,
    PIPE_VIDEO_CHROMA_FORMAT_NONE = 5,
}
unsafe extern "C" {
    #[link_name = "pipe_format_to_chroma_format__extern"]
    pub fn pipe_format_to_chroma_format(format: pipe_format) -> pipe_video_chroma_format;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pipe_color_union {
    pub f: [::std::os::raw::c_float; 4usize],
    pub i: [::std::os::raw::c_int; 4usize],
    pub ui: [::std::os::raw::c_uint; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of pipe_color_union"][::std::mem::size_of::<pipe_color_union>() - 16usize];
    ["Alignment of pipe_color_union"][::std::mem::align_of::<pipe_color_union>() - 4usize];
    ["Offset of field: pipe_color_union::f"][::std::mem::offset_of!(pipe_color_union, f) - 0usize];
    ["Offset of field: pipe_color_union::i"][::std::mem::offset_of!(pipe_color_union, i) - 0usize];
    ["Offset of field: pipe_color_union::ui"]
        [::std::mem::offset_of!(pipe_color_union, ui) - 0usize];
};
impl Default for pipe_color_union {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[doc = " Describe how to pack/unpack pixels into/from the prescribed format.\n\n XXX: This could be renamed to something like util_format_pack, or broke down\n in flags inside util_format_block that said exactly what we want."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_layout {
    #[doc = " Formats with util_format_block::width == util_format_block::height == 1\n that can be described as an ordinary data structure."]
    UTIL_FORMAT_LAYOUT_PLAIN = 0,
    #[doc = " Formats with sub-sampled channels.\n\n This is for formats like YVYU where there is less than one sample per\n pixel."]
    UTIL_FORMAT_LAYOUT_SUBSAMPLED = 1,
    #[doc = " S3 Texture Compression formats."]
    UTIL_FORMAT_LAYOUT_S3TC = 2,
    #[doc = " Red-Green Texture Compression formats."]
    UTIL_FORMAT_LAYOUT_RGTC = 3,
    #[doc = " Ericsson Texture Compression"]
    UTIL_FORMAT_LAYOUT_ETC = 4,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_BPTC = 5,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_ASTC = 6,
    #[doc = " BC6/7 Texture Compression"]
    UTIL_FORMAT_LAYOUT_ATC = 7,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_PLANAR2 = 8,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_PLANAR3 = 9,
    #[doc = " Formats with 2 or more planes."]
    UTIL_FORMAT_LAYOUT_FXT1 = 10,
    #[doc = " Everything else that doesn't fit in any of the above layouts."]
    UTIL_FORMAT_LAYOUT_OTHER = 11,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_block {
    #[doc = " Block width in pixels"]
    pub width: ::std::os::raw::c_uint,
    #[doc = " Block height in pixels"]
    pub height: ::std::os::raw::c_uint,
    #[doc = " Block depth in pixels"]
    pub depth: ::std::os::raw::c_uint,
    #[doc = " Block size in bits"]
    pub bits: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_block"][::std::mem::size_of::<util_format_block>() - 16usize];
    ["Alignment of util_format_block"][::std::mem::align_of::<util_format_block>() - 4usize];
    ["Offset of field: util_format_block::width"]
        [::std::mem::offset_of!(util_format_block, width) - 0usize];
    ["Offset of field: util_format_block::height"]
        [::std::mem::offset_of!(util_format_block, height) - 4usize];
    ["Offset of field: util_format_block::depth"]
        [::std::mem::offset_of!(util_format_block, depth) - 8usize];
    ["Offset of field: util_format_block::bits"]
        [::std::mem::offset_of!(util_format_block, bits) - 12usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_type {
    UTIL_FORMAT_TYPE_VOID = 0,
    UTIL_FORMAT_TYPE_UNSIGNED = 1,
    UTIL_FORMAT_TYPE_SIGNED = 2,
    UTIL_FORMAT_TYPE_FIXED = 3,
    UTIL_FORMAT_TYPE_FLOAT = 4,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum util_format_colorspace {
    UTIL_FORMAT_COLORSPACE_RGB = 0,
    UTIL_FORMAT_COLORSPACE_SRGB = 1,
    UTIL_FORMAT_COLORSPACE_YUV = 2,
    UTIL_FORMAT_COLORSPACE_ZS = 3,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_channel_description {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_channel_description"]
        [::std::mem::size_of::<util_format_channel_description>() - 4usize];
    ["Alignment of util_format_channel_description"]
        [::std::mem::align_of::<util_format_channel_description>() - 4usize];
};
impl util_format_channel_description {
    #[inline]
    pub fn type_(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_type(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn type__raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_type_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn normalized(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn normalized_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_normalized_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pure_integer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pure_integer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pure_integer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pure_integer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn size(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_size(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn size_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_size_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shift(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_shift(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shift_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                16u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_shift_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                16u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        type_: ::std::os::raw::c_uint,
        normalized: ::std::os::raw::c_uint,
        pure_integer: ::std::os::raw::c_uint,
        size: ::std::os::raw::c_uint,
        shift: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let type_: u32 = unsafe { ::std::mem::transmute(type_) };
            type_ as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let normalized: u32 = unsafe { ::std::mem::transmute(normalized) };
            normalized as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pure_integer: u32 = unsafe { ::std::mem::transmute(pure_integer) };
            pure_integer as u64
        });
        __bindgen_bitfield_unit.set(7usize, 9u8, {
            let size: u32 = unsafe { ::std::mem::transmute(size) };
            size as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let shift: u32 = unsafe { ::std::mem::transmute(shift) };
            shift as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct util_format_description {
    pub format: pipe_format,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Short name, striped of the prefix, lower case."]
    pub short_name: *const ::std::os::raw::c_char,
    #[doc = " Pixel block dimensions."]
    pub block: util_format_block,
    pub layout: util_format_layout,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Input channel description, in the order XYZW.\n\n Only valid for UTIL_FORMAT_LAYOUT_PLAIN formats.\n\n If each channel is accessed as an individual N-byte value, X is always\n at the lowest address in memory, Y is always next, and so on.  For all\n currently-defined formats, the N-byte value has native endianness.\n\n If instead a group of channels is accessed as a single N-byte value,\n the order of the channels within that value depends on endianness.\n For big-endian targets, X is the most significant subvalue,\n otherwise it is the least significant one.\n\n For example, if X is 8 bits and Y is 24 bits, the memory order is:\n\n                 0  1  2  3\n  little-endian: X  Yl Ym Yu    (l = lower, m = middle, u = upper)\n  big-endian:    X  Yu Ym Yl\n\n If X is 5 bits, Y is 5 bits, Z is 5 bits and W is 1 bit, the layout is:\n\n                        0        1\n                 msb  lsb msb  lsb\n  little-endian: YYYXXXXX WZZZZZYY\n  big-endian:    XXXXXYYY YYZZZZZW"]
    pub channel: [util_format_channel_description; 4usize],
    #[doc = " Output channel swizzle.\n\n The order is either:\n - RGBA\n - YUV(A)\n - ZS\n depending on the colorspace."]
    pub swizzle: [::std::os::raw::c_uchar; 4usize],
    #[doc = " Colorspace transformation."]
    pub colorspace: util_format_colorspace,
    pub anon_1: util_format_description__bindgen_ty_1,
}
#[doc = " For sRGB formats, equivalent linear format; for linear formats,\n equivalent sRGB format"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union util_format_description__bindgen_ty_1 {
    pub srgb_equivalent: pipe_format,
    pub linear_equivalent: pipe_format,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_description__bindgen_ty_1"]
        [::std::mem::size_of::<util_format_description__bindgen_ty_1>() - 4usize];
    ["Alignment of util_format_description__bindgen_ty_1"]
        [::std::mem::align_of::<util_format_description__bindgen_ty_1>() - 4usize];
    ["Offset of field: util_format_description__bindgen_ty_1::srgb_equivalent"]
        [::std::mem::offset_of!(util_format_description__bindgen_ty_1, srgb_equivalent) - 0usize];
    ["Offset of field: util_format_description__bindgen_ty_1::linear_equivalent"]
        [::std::mem::offset_of!(util_format_description__bindgen_ty_1, linear_equivalent) - 0usize];
};
impl Default for util_format_description__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_description"][::std::mem::size_of::<util_format_description>() - 64usize];
    ["Alignment of util_format_description"]
        [::std::mem::align_of::<util_format_description>() - 4usize];
    ["Offset of field: util_format_description::format"]
        [::std::mem::offset_of!(util_format_description, format) - 0usize];
    ["Offset of field: util_format_description::name"]
        [::std::mem::offset_of!(util_format_description, name) - 4usize];
    ["Offset of field: util_format_description::short_name"]
        [::std::mem::offset_of!(util_format_description, short_name) - 8usize];
    ["Offset of field: util_format_description::block"]
        [::std::mem::offset_of!(util_format_description, block) - 12usize];
    ["Offset of field: util_format_description::layout"]
        [::std::mem::offset_of!(util_format_description, layout) - 28usize];
    ["Offset of field: util_format_description::channel"]
        [::std::mem::offset_of!(util_format_description, channel) - 36usize];
    ["Offset of field: util_format_description::swizzle"]
        [::std::mem::offset_of!(util_format_description, swizzle) - 52usize];
    ["Offset of field: util_format_description::colorspace"]
        [::std::mem::offset_of!(util_format_description, colorspace) - 56usize];
};
impl Default for util_format_description {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl util_format_description {
    #[inline]
    pub fn nr_channels(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_nr_channels(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn nr_channels_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_nr_channels_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_bitmask(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bitmask(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_bitmask_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_bitmask_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_mixed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_mixed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_mixed_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_mixed_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_unorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_unorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_unorm_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_unorm_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_snorm(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_snorm(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_snorm_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_snorm_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nr_channels: ::std::os::raw::c_uint,
        is_array: ::std::os::raw::c_uint,
        is_bitmask: ::std::os::raw::c_uint,
        is_mixed: ::std::os::raw::c_uint,
        is_unorm: ::std::os::raw::c_uint,
        is_snorm: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let nr_channels: u32 = unsafe { ::std::mem::transmute(nr_channels) };
            nr_channels as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_array: u32 = unsafe { ::std::mem::transmute(is_array) };
            is_array as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bitmask: u32 = unsafe { ::std::mem::transmute(is_bitmask) };
            is_bitmask as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let is_mixed: u32 = unsafe { ::std::mem::transmute(is_mixed) };
            is_mixed as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let is_unorm: u32 = unsafe { ::std::mem::transmute(is_unorm) };
            is_unorm as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let is_snorm: u32 = unsafe { ::std::mem::transmute(is_snorm) };
            is_snorm as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_pack_description {
    #[doc = " Pack pixel blocks from R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for non-depth-stencil formats."]
    pub pack_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixel blocks from R32G32B32A32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for non-depth-stencil formats."]
    pub pack_rgba_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const ::std::os::raw::c_float,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from Z32_UNORM.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub pack_z_32unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from Z32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub pack_z_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const ::std::os::raw::c_float,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Pack pixels from S8_UINT.\n Note: strides are in bytes.\n\n Only defined for stencil formats."]
    pub pack_s_8uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    pub pack_rgba_uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    pub pack_rgba_sint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const i32,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_pack_description"]
        [::std::mem::size_of::<util_format_pack_description>() - 28usize];
    ["Alignment of util_format_pack_description"]
        [::std::mem::align_of::<util_format_pack_description>() - 4usize];
    ["Offset of field: util_format_pack_description::pack_rgba_8unorm"]
        [::std::mem::offset_of!(util_format_pack_description, pack_rgba_8unorm) - 0usize];
    ["Offset of field: util_format_pack_description::pack_rgba_float"]
        [::std::mem::offset_of!(util_format_pack_description, pack_rgba_float) - 4usize];
    ["Offset of field: util_format_pack_description::pack_z_32unorm"]
        [::std::mem::offset_of!(util_format_pack_description, pack_z_32unorm) - 8usize];
    ["Offset of field: util_format_pack_description::pack_z_float"]
        [::std::mem::offset_of!(util_format_pack_description, pack_z_float) - 12usize];
    ["Offset of field: util_format_pack_description::pack_s_8uint"]
        [::std::mem::offset_of!(util_format_pack_description, pack_s_8uint) - 16usize];
    ["Offset of field: util_format_pack_description::pack_rgba_uint"]
        [::std::mem::offset_of!(util_format_pack_description, pack_rgba_uint) - 20usize];
    ["Offset of field: util_format_pack_description::pack_rgba_sint"]
        [::std::mem::offset_of!(util_format_pack_description, pack_rgba_sint) - 24usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct util_format_unpack_description {
    #[doc = " Unpack pixel blocks to R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for non-block non-depth-stencil formats."]
    pub unpack_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(dst: *mut u8, src: *const u8, width: ::std::os::raw::c_uint),
    >,
    #[doc = " Unpack pixel blocks to R8G8B8A8_UNORM.\n Note: strides are in bytes.\n\n Only defined for block non-depth-stencil formats."]
    pub unpack_rgba_8unorm_rect: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Fetch a single pixel (i, j) from a block.\n\n XXX: Only defined for a very few select formats."]
    pub fetch_rgba_8unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            src: *const u8,
            i: ::std::os::raw::c_uint,
            j: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixel blocks to R32G32B32A32_UINT/_INT_FLOAT based on whether the\n type is pure uint, int, or other.\n\n Note: strides are in bytes.\n\n Only defined for non-block non-depth-stencil formats."]
    pub unpack_rgba: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_void,
            src: *const u8,
            width: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixel blocks to R32G32B32A32_UINT/_INT_FLOAT based on whether the\n type is pure uint, int, or other.\n\n Note: strides are in bytes.\n\n Only defined for block non-depth-stencil formats."]
    pub unpack_rgba_rect: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_void,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to Z32_UNORM.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub unpack_z_32unorm: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u32,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to Z32_FLOAT.\n Note: strides are in bytes.\n\n Only defined for depth formats."]
    pub unpack_z_float: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut ::std::os::raw::c_float,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
    #[doc = " Unpack pixels to S8_UINT.\n Note: strides are in bytes.\n\n Only defined for stencil formats."]
    pub unpack_s_8uint: ::std::option::Option<
        unsafe extern "C" fn(
            dst: *mut u8,
            dst_stride: ::std::os::raw::c_uint,
            src: *const u8,
            src_stride: ::std::os::raw::c_uint,
            width: ::std::os::raw::c_uint,
            height: ::std::os::raw::c_uint,
        ),
    >,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of util_format_unpack_description"]
        [::std::mem::size_of::<util_format_unpack_description>() - 32usize];
    ["Alignment of util_format_unpack_description"]
        [::std::mem::align_of::<util_format_unpack_description>() - 4usize];
    ["Offset of field: util_format_unpack_description::unpack_rgba_8unorm"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_rgba_8unorm) - 0usize];
    ["Offset of field: util_format_unpack_description::unpack_rgba_8unorm_rect"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_rgba_8unorm_rect) - 4usize];
    ["Offset of field: util_format_unpack_description::fetch_rgba_8unorm"]
        [::std::mem::offset_of!(util_format_unpack_description, fetch_rgba_8unorm) - 8usize];
    ["Offset of field: util_format_unpack_description::unpack_rgba"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_rgba) - 12usize];
    ["Offset of field: util_format_unpack_description::unpack_rgba_rect"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_rgba_rect) - 16usize];
    ["Offset of field: util_format_unpack_description::unpack_z_32unorm"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_z_32unorm) - 20usize];
    ["Offset of field: util_format_unpack_description::unpack_z_float"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_z_float) - 24usize];
    ["Offset of field: util_format_unpack_description::unpack_s_8uint"]
        [::std::mem::offset_of!(util_format_unpack_description, unpack_s_8uint) - 28usize];
};
pub type util_format_fetch_rgba_func_ptr = ::std::option::Option<
    unsafe extern "C" fn(
        dst: *mut ::std::os::raw::c_void,
        src: *const u8,
        i: ::std::os::raw::c_uint,
        j: ::std::os::raw::c_uint,
    ),
>;
unsafe extern "C" {
    pub fn util_format_description(format: pipe_format) -> *const util_format_description;
}
unsafe extern "C" {
    pub fn util_format_pack_description(format: pipe_format)
        -> *const util_format_pack_description;
}
unsafe extern "C" {
    pub fn util_format_unpack_description(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
unsafe extern "C" {
    pub fn util_format_unpack_description_generic(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
unsafe extern "C" {
    pub fn util_format_unpack_description_neon(
        format: pipe_format,
    ) -> *const util_format_unpack_description;
}
unsafe extern "C" {
    #[doc = " Returns a function to fetch a single pixel (i, j) from a block.\n\n Only defined for non-depth-stencil and non-integer formats."]
    pub fn util_format_fetch_rgba_func(format: pipe_format) -> util_format_fetch_rgba_func_ptr;
}
unsafe extern "C" {
    #[link_name = "util_format_name__extern"]
    pub fn util_format_name(format: pipe_format) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "util_format_short_name__extern"]
    pub fn util_format_short_name(format: pipe_format) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Whether this format is plain, see UTIL_FORMAT_LAYOUT_PLAIN for more info."]
    #[link_name = "util_format_is_plain__extern"]
    pub fn util_format_is_plain(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_compressed__extern"]
    pub fn util_format_is_compressed(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_s3tc__extern"]
    pub fn util_format_is_s3tc(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_etc__extern"]
    pub fn util_format_is_etc(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_srgb__extern"]
    pub fn util_format_is_srgb(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_has_depth__extern"]
    pub fn util_format_has_depth(desc: *const util_format_description) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_has_stencil__extern"]
    pub fn util_format_has_stencil(desc: *const util_format_description) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_depth_or_stencil__extern"]
    pub fn util_format_is_depth_or_stencil(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_depth_and_stencil__extern"]
    pub fn util_format_is_depth_and_stencil(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[doc = " For depth-stencil formats, return the equivalent depth-only format."]
    #[link_name = "util_format_get_depth_only__extern"]
    pub fn util_format_get_depth_only(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[link_name = "util_format_is_yuv__extern"]
    pub fn util_format_is_yuv(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[doc = " Return whether this is an RGBA, Z, S, or combined ZS format.\n Useful for initializing pipe_blit_info::mask."]
    #[link_name = "util_format_get_mask__extern"]
    pub fn util_format_get_mask(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Give the RGBA colormask of the channels that can be represented in this\n format.\n\n That is, the channels whose values are preserved."]
    #[link_name = "util_format_colormask__extern"]
    pub fn util_format_colormask(desc: *const util_format_description) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Checks if color mask covers every channel for the specified format\n\n @param desc       a format description to check colormask with\n @param colormask  a bit mask for channels, matches format of PIPE_MASK_RGBA"]
    #[link_name = "util_format_colormask_full__extern"]
    pub fn util_format_colormask_full(
        desc: *const util_format_description,
        colormask: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_float(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_has_alpha(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_has_alpha1(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_luminance(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_alpha(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_luminance_alpha(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_red_alpha(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_red_green(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_intensity(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_subsampled_422(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_pure_integer(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_pure_sint(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_pure_uint(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_snorm(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_unorm(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_snorm8(format: pipe_format) -> bool;
}
unsafe extern "C" {
    pub fn util_format_is_scaled(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[doc = " Whether this format is a rgab8 variant.\n\n That is, any format that matches the\n\n   PIPE_FORMAT_?8?8?8?8_UNORM"]
    #[link_name = "util_format_is_rgba8_variant__extern"]
    pub fn util_format_is_rgba8_variant(desc: *const util_format_description) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_is_rgbx_or_bgrx__extern"]
    pub fn util_format_is_rgbx_or_bgrx(format: pipe_format) -> bool;
}
unsafe extern "C" {
    #[doc = " Return total bits needed for the pixel format per block."]
    #[link_name = "util_format_get_blocksizebits__extern"]
    pub fn util_format_get_blocksizebits(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Return bytes per block (not pixel) for the given format."]
    #[link_name = "util_format_get_blocksize__extern"]
    pub fn util_format_get_blocksize(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_blockwidth__extern"]
    pub fn util_format_get_blockwidth(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_blockheight__extern"]
    pub fn util_format_get_blockheight(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_blockdepth__extern"]
    pub fn util_format_get_blockdepth(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_nblocksx__extern"]
    pub fn util_format_get_nblocksx(
        format: pipe_format,
        x: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_nblocksy__extern"]
    pub fn util_format_get_nblocksy(
        format: pipe_format,
        y: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_nblocksz__extern"]
    pub fn util_format_get_nblocksz(
        format: pipe_format,
        z: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_nblocks__extern"]
    pub fn util_format_get_nblocks(
        format: pipe_format,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "util_format_get_stride__extern"]
    pub fn util_format_get_stride(
        format: pipe_format,
        width: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_2d_size__extern"]
    pub fn util_format_get_2d_size(
        format: pipe_format,
        stride: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
    ) -> u64;
}
unsafe extern "C" {
    #[link_name = "util_format_get_component_bits__extern"]
    pub fn util_format_get_component_bits(
        format: pipe_format,
        colorspace: util_format_colorspace,
        component: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_component_shift__extern"]
    pub fn util_format_get_component_shift(
        format: pipe_format,
        colorspace: util_format_colorspace,
        component: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Given a linear RGB colorspace format, return the corresponding SRGB\n format, or PIPE_FORMAT_NONE if none."]
    #[link_name = "util_format_srgb__extern"]
    pub fn util_format_srgb(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[doc = " Given an sRGB format, return the corresponding linear colorspace format.\n For non sRGB formats, return the format unchanged."]
    #[link_name = "util_format_linear__extern"]
    pub fn util_format_linear(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[doc = " Given a depth-stencil format, return the corresponding stencil-only format.\n For stencil-only formats, return the format unchanged."]
    #[link_name = "util_format_stencil_only__extern"]
    pub fn util_format_stencil_only(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[link_name = "util_format_as_renderable__extern"]
    pub fn util_format_as_renderable(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[doc = " Converts PIPE_FORMAT_*I* to PIPE_FORMAT_*R*.\n This is identity for non-intensity formats."]
    #[link_name = "util_format_intensity_to_red__extern"]
    pub fn util_format_intensity_to_red(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[doc = " Converts PIPE_FORMAT_*L* to PIPE_FORMAT_*R*.\n This is identity for non-luminance formats."]
    #[link_name = "util_format_luminance_to_red__extern"]
    pub fn util_format_luminance_to_red(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[link_name = "util_format_get_num_planes__extern"]
    pub fn util_format_get_num_planes(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_plane_format__extern"]
    pub fn util_format_get_plane_format(
        format: pipe_format,
        plane: ::std::os::raw::c_uint,
    ) -> pipe_format;
}
unsafe extern "C" {
    #[link_name = "util_format_get_plane_width__extern"]
    pub fn util_format_get_plane_width(
        format: pipe_format,
        plane: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "util_format_get_plane_height__extern"]
    pub fn util_format_get_plane_height(
        format: pipe_format,
        plane: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Return the number of components stored.\n Formats with block size != 1x1 will always have 1 component (the block)."]
    #[link_name = "util_format_get_nr_components__extern"]
    pub fn util_format_get_nr_components(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Return the index of the first non-void channel\n -1 if no non-void channels"]
    #[link_name = "util_format_get_first_non_void_channel__extern"]
    pub fn util_format_get_first_non_void_channel(format: pipe_format) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Whether this format is any 8-bit UNORM variant. Looser than\n util_is_rgba8_variant (also includes alpha textures, for instance)."]
    #[link_name = "util_format_is_unorm8__extern"]
    pub fn util_format_is_unorm8(desc: *const util_format_description) -> bool;
}
unsafe extern "C" {
    #[link_name = "util_format_unpack_z_float__extern"]
    pub fn util_format_unpack_z_float(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_float,
        src: *const ::std::os::raw::c_void,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "util_format_unpack_z_32unorm__extern"]
    pub fn util_format_unpack_z_32unorm(
        format: pipe_format,
        dst: *mut u32,
        src: *const ::std::os::raw::c_void,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "util_format_unpack_s_8uint__extern"]
    pub fn util_format_unpack_s_8uint(
        format: pipe_format,
        dst: *mut u8,
        src: *const ::std::os::raw::c_void,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Unpacks a row of color data to 32-bit RGBA, either integers for pure\n integer formats (sign-extended for signed data), or 32-bit floats."]
    #[link_name = "util_format_unpack_rgba__extern"]
    pub fn util_format_unpack_rgba(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "util_format_pack_z_float__extern"]
    pub fn util_format_pack_z_float(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_float,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "util_format_pack_z_32unorm__extern"]
    pub fn util_format_pack_z_32unorm(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        src: *const u32,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "util_format_pack_s_8uint__extern"]
    pub fn util_format_pack_s_8uint(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        src: *const u8,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Packs a row of color data from 32-bit RGBA, either integers for pure\n integer formats, or 32-bit floats.  Values are clamped to the packed\n representation's range."]
    #[link_name = "util_format_pack_rgba__extern"]
    pub fn util_format_pack_rgba(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        src: *const ::std::os::raw::c_void,
        w: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_read_4(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_write_4(
        format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_read_4ub(
        format: pipe_format,
        dst: *mut u8,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_write_4ub(
        format: pipe_format,
        src: *const u8,
        src_stride: ::std::os::raw::c_uint,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        x: ::std::os::raw::c_uint,
        y: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_unpack_rgba_rect(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_unpack_rgba_8unorm_rect(
        format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        w: ::std::os::raw::c_uint,
        h: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn util_format_fits_8unorm(format_desc: *const util_format_description) -> bool;
}
unsafe extern "C" {
    pub fn util_format_translate(
        dst_format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        dst_x: ::std::os::raw::c_uint,
        dst_y: ::std::os::raw::c_uint,
        src_format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        src_x: ::std::os::raw::c_uint,
        src_y: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn util_format_translate_3d(
        dst_format: pipe_format,
        dst: *mut ::std::os::raw::c_void,
        dst_stride: ::std::os::raw::c_uint,
        dst_slice_stride: u64,
        dst_x: ::std::os::raw::c_uint,
        dst_y: ::std::os::raw::c_uint,
        dst_z: ::std::os::raw::c_uint,
        src_format: pipe_format,
        src: *const ::std::os::raw::c_void,
        src_stride: ::std::os::raw::c_uint,
        src_slice_stride: u64,
        src_x: ::std::os::raw::c_uint,
        src_y: ::std::os::raw::c_uint,
        src_z: ::std::os::raw::c_uint,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        depth: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn util_format_compose_swizzles(
        swz1: *const [::std::os::raw::c_uchar; 4usize],
        swz2: *const [::std::os::raw::c_uchar; 4usize],
        dst: *mut [::std::os::raw::c_uchar; 4usize],
    );
}
unsafe extern "C" {
    pub fn util_format_apply_color_swizzle(
        dst: *mut pipe_color_union,
        src: *const pipe_color_union,
        swz: *const [::std::os::raw::c_uchar; 4usize],
        is_integer: bool,
    );
}
unsafe extern "C" {
    pub fn pipe_swizzle_4f(
        dst: *mut ::std::os::raw::c_float,
        src: *const ::std::os::raw::c_float,
        swz: *const [::std::os::raw::c_uchar; 4usize],
    );
}
unsafe extern "C" {
    pub fn util_format_unswizzle_4f(
        dst: *mut ::std::os::raw::c_float,
        src: *const ::std::os::raw::c_float,
        swz: *const [::std::os::raw::c_uchar; 4usize],
    );
}
unsafe extern "C" {
    pub fn util_format_snorm_to_sint(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    #[doc = " If the format is RGB, return BGR. If the format is BGR, return RGB.\n This may fail by returning PIPE_FORMAT_NONE."]
    pub fn util_format_rgb_to_bgr(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    pub fn util_format_snorm_to_unorm(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    pub fn util_format_rgbx_to_rgba(format: pipe_format) -> pipe_format;
}
unsafe extern "C" {
    pub fn util_format_get_array(
        type_: util_format_type,
        bits: ::std::os::raw::c_uint,
        nr_components: ::std::os::raw::c_uint,
        normalized: bool,
        pure_integer: bool,
    ) -> pipe_format;
}
unsafe extern "C" {
    pub fn util_format_get_last_component(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn util_format_get_largest_non_void_channel(format: pipe_format) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn util_format_get_max_channel_size(format: pipe_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn util_format_get_tilesize(
        format: pipe_format,
        dimensions: u32,
        samples: u32,
        axis: u32,
    ) -> u32;
}
unsafe extern "C" {
    pub fn glsl_type_singleton_init_or_ref();
}
unsafe extern "C" {
    pub fn glsl_type_singleton_decref();
}
pub type glsl_type_size_align_func = ::std::option::Option<
    unsafe extern "C" fn(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ),
>;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_base_type {
    GLSL_TYPE_UINT = 0,
    GLSL_TYPE_INT = 1,
    GLSL_TYPE_FLOAT = 2,
    GLSL_TYPE_FLOAT16 = 3,
    GLSL_TYPE_DOUBLE = 4,
    GLSL_TYPE_UINT8 = 5,
    GLSL_TYPE_INT8 = 6,
    GLSL_TYPE_UINT16 = 7,
    GLSL_TYPE_INT16 = 8,
    GLSL_TYPE_UINT64 = 9,
    GLSL_TYPE_INT64 = 10,
    GLSL_TYPE_BOOL = 11,
    GLSL_TYPE_COOPERATIVE_MATRIX = 12,
    GLSL_TYPE_SAMPLER = 13,
    GLSL_TYPE_TEXTURE = 14,
    GLSL_TYPE_IMAGE = 15,
    GLSL_TYPE_ATOMIC_UINT = 16,
    GLSL_TYPE_STRUCT = 17,
    GLSL_TYPE_INTERFACE = 18,
    GLSL_TYPE_ARRAY = 19,
    GLSL_TYPE_VOID = 20,
    GLSL_TYPE_SUBROUTINE = 21,
    GLSL_TYPE_ERROR = 22,
}
unsafe extern "C" {
    #[link_name = "glsl_base_type_bit_size__extern"]
    pub fn glsl_base_type_bit_size(type_: glsl_base_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_base_type_is_16bit__extern"]
    pub fn glsl_base_type_is_16bit(type_: glsl_base_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_base_type_is_64bit__extern"]
    pub fn glsl_base_type_is_64bit(type_: glsl_base_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_base_type_is_integer__extern"]
    pub fn glsl_base_type_is_integer(type_: glsl_base_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_base_type_get_bit_size__extern"]
    pub fn glsl_base_type_get_bit_size(base_type: glsl_base_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_unsigned_base_type_of__extern"]
    pub fn glsl_unsigned_base_type_of(type_: glsl_base_type) -> glsl_base_type;
}
unsafe extern "C" {
    #[link_name = "glsl_signed_base_type_of__extern"]
    pub fn glsl_signed_base_type_of(type_: glsl_base_type) -> glsl_base_type;
}
unsafe extern "C" {
    pub fn glsl_get_sampler_dim_coordinate_components(
        dim: glsl_sampler_dim,
    ) -> ::std::os::raw::c_int;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum glsl_matrix_layout {
    #[doc = " The layout of the matrix is inherited from the object containing the\n matrix (the top level structure or the uniform block)."]
    GLSL_MATRIX_LAYOUT_INHERITED = 0,
    #[doc = " Explicit column-major layout\n\n If a uniform block doesn't have an explicit layout set, it will default\n to this layout."]
    GLSL_MATRIX_LAYOUT_COLUMN_MAJOR = 1,
    #[doc = " Row-major layout"]
    GLSL_MATRIX_LAYOUT_ROW_MAJOR = 2,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct glsl_cmat_description {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub rows: u8,
    pub cols: u8,
    pub use_: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_cmat_description"][::std::mem::size_of::<glsl_cmat_description>() - 4usize];
    ["Alignment of glsl_cmat_description"]
        [::std::mem::align_of::<glsl_cmat_description>() - 1usize];
    ["Offset of field: glsl_cmat_description::rows"]
        [::std::mem::offset_of!(glsl_cmat_description, rows) - 1usize];
    ["Offset of field: glsl_cmat_description::cols"]
        [::std::mem::offset_of!(glsl_cmat_description, cols) - 2usize];
    ["Offset of field: glsl_cmat_description::use_"]
        [::std::mem::offset_of!(glsl_cmat_description, use_) - 3usize];
};
impl glsl_cmat_description {
    #[inline]
    pub fn element_type(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 5u8) as u8) }
    }
    #[inline]
    pub fn set_element_type(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn element_type_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                5u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_element_type_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn scope(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_scope(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn scope_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                3u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_scope_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(element_type: u8, scope: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 5u8, {
            let element_type: u8 = unsafe { ::std::mem::transmute(element_type) };
            element_type as u64
        });
        __bindgen_bitfield_unit.set(5usize, 3u8, {
            let scope: u8 = unsafe { ::std::mem::transmute(scope) };
            scope as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn glsl_get_type_name(type_: *const glsl_type) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_type {
    pub gl_type: u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub cmat_desc: glsl_cmat_description,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = "< 1, 2, 3, or 4 vector elements."]
    pub vector_elements: u8,
    #[doc = "< 1, 2, 3, or 4 matrix columns."]
    pub matrix_columns: u8,
    #[doc = " For \\c GLSL_TYPE_ARRAY, this is the length of the array.  For\n \\c GLSL_TYPE_STRUCT or \\c GLSL_TYPE_INTERFACE, it is the number of\n elements in the structure and the number of values pointed to by\n \\c fields.structure (below)."]
    pub length: ::std::os::raw::c_uint,
    #[doc = " Identifier to the name of the data type\n\n Use glsl_get_type_name() to access the actual name."]
    pub name_id: usize,
    #[doc = " Explicit array, matrix, or vector stride.  This is used to communicate\n explicit array layouts from SPIR-V.  Should be 0 if the type has no\n explicit stride."]
    pub explicit_stride: ::std::os::raw::c_uint,
    #[doc = " Explicit alignment. This is used to communicate explicit alignment\n constraints. Should be 0 if the type has no explicit alignment\n constraint."]
    pub explicit_alignment: ::std::os::raw::c_uint,
    pub fields: glsl_type__bindgen_ty_1,
}
#[doc = " Subtype of composite data types."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_type__bindgen_ty_1 {
    #[doc = "< Type of array elements."]
    pub array: *const glsl_type,
    #[doc = "< List of struct fields."]
    pub structure: *const glsl_struct_field,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_type__bindgen_ty_1"][::std::mem::size_of::<glsl_type__bindgen_ty_1>() - 4usize];
    ["Alignment of glsl_type__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_type__bindgen_ty_1>() - 4usize];
    ["Offset of field: glsl_type__bindgen_ty_1::array"]
        [::std::mem::offset_of!(glsl_type__bindgen_ty_1, array) - 0usize];
    ["Offset of field: glsl_type__bindgen_ty_1::structure"]
        [::std::mem::offset_of!(glsl_type__bindgen_ty_1, structure) - 0usize];
};
impl Default for glsl_type__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_type"][::std::mem::size_of::<glsl_type>() - 36usize];
    ["Alignment of glsl_type"][::std::mem::align_of::<glsl_type>() - 4usize];
    ["Offset of field: glsl_type::gl_type"][::std::mem::offset_of!(glsl_type, gl_type) - 0usize];
    ["Offset of field: glsl_type::cmat_desc"]
        [::std::mem::offset_of!(glsl_type, cmat_desc) - 8usize];
    ["Offset of field: glsl_type::vector_elements"]
        [::std::mem::offset_of!(glsl_type, vector_elements) - 13usize];
    ["Offset of field: glsl_type::matrix_columns"]
        [::std::mem::offset_of!(glsl_type, matrix_columns) - 14usize];
    ["Offset of field: glsl_type::length"][::std::mem::offset_of!(glsl_type, length) - 16usize];
    ["Offset of field: glsl_type::name_id"][::std::mem::offset_of!(glsl_type, name_id) - 20usize];
    ["Offset of field: glsl_type::explicit_stride"]
        [::std::mem::offset_of!(glsl_type, explicit_stride) - 24usize];
    ["Offset of field: glsl_type::explicit_alignment"]
        [::std::mem::offset_of!(glsl_type, explicit_alignment) - 28usize];
    ["Offset of field: glsl_type::fields"][::std::mem::offset_of!(glsl_type, fields) - 32usize];
};
impl Default for glsl_type {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl glsl_type {
    #[inline]
    pub fn base_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_base_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn base_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_base_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampled_type(&self) -> glsl_base_type {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sampled_type(&mut self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampled_type_raw(this: *const Self) -> glsl_base_type {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampled_type_raw(this: *mut Self, val: glsl_base_type) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_dimensionality(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_dimensionality(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_dimensionality_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                4u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_dimensionality_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_shadow(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_shadow(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_shadow_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_shadow_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sampler_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sampler_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sampler_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sampler_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interface_packing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_interface_packing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interface_packing_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interface_packing_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interface_row_major(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interface_row_major(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interface_row_major_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interface_row_major_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        base_type: glsl_base_type,
        sampled_type: glsl_base_type,
        sampler_dimensionality: ::std::os::raw::c_uint,
        sampler_shadow: ::std::os::raw::c_uint,
        sampler_array: ::std::os::raw::c_uint,
        interface_packing: ::std::os::raw::c_uint,
        interface_row_major: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let base_type: u32 = unsafe { ::std::mem::transmute(base_type) };
            base_type as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let sampled_type: u32 = unsafe { ::std::mem::transmute(sampled_type) };
            sampled_type as u64
        });
        __bindgen_bitfield_unit.set(16usize, 4u8, {
            let sampler_dimensionality: u32 =
                unsafe { ::std::mem::transmute(sampler_dimensionality) };
            sampler_dimensionality as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let sampler_shadow: u32 = unsafe { ::std::mem::transmute(sampler_shadow) };
            sampler_shadow as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let sampler_array: u32 = unsafe { ::std::mem::transmute(sampler_array) };
            sampler_array as u64
        });
        __bindgen_bitfield_unit.set(22usize, 2u8, {
            let interface_packing: u32 = unsafe { ::std::mem::transmute(interface_packing) };
            interface_packing as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let interface_row_major: u32 = unsafe { ::std::mem::transmute(interface_row_major) };
            interface_row_major as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn packed(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_packed(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn packed_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_packed_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_builtin_name(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_builtin_name(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_builtin_name_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_has_builtin_name_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        packed: ::std::os::raw::c_uint,
        has_builtin_name: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let packed: u32 = unsafe { ::std::mem::transmute(packed) };
            packed as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_builtin_name: u32 = unsafe { ::std::mem::transmute(has_builtin_name) };
            has_builtin_name as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct glsl_struct_field {
    pub type_: *const glsl_type,
    pub name: *const ::std::os::raw::c_char,
    #[doc = " For interface blocks, gl_varying_slot corresponding to the input/output\n if this is a built-in input/output (i.e. a member of the built-in\n gl_PerVertex interface block); -1 otherwise.\n\n Ignored for structs."]
    pub location: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may explicitly assign the component used\n by a varying. Ignored for structs."]
    pub component: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may have an explicit byte offset\n specified; -1 otherwise. Also used for xfb_offset layout qualifier.\n\n Unless used for xfb_offset this field is ignored for structs."]
    pub offset: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback buffer;\n -1 otherwise."]
    pub xfb_buffer: ::std::os::raw::c_int,
    #[doc = " For interface blocks, members may define a transform feedback stride;\n -1 otherwise."]
    pub xfb_stride: ::std::os::raw::c_int,
    #[doc = " Layout format, applicable to image variables only."]
    pub image_format: pipe_format,
    pub anon_1: glsl_struct_field__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union glsl_struct_field__bindgen_ty_1 {
    pub anon_1: glsl_struct_field__bindgen_ty_1__bindgen_ty_1,
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Alignment of glsl_struct_field__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_struct_field__bindgen_ty_1__bindgen_ty_1>() - 4usize];
};
impl glsl_struct_field__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interpolation_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interpolation_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn centroid_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_centroid_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sample_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn matrix_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_matrix_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn patch_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_patch_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_read_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_read_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_write_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_write_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_write_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_write_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_coherent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_coherent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_coherent_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_coherent_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_volatile(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_volatile(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_volatile_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_volatile_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memory_restrict(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_memory_restrict(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memory_restrict_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memory_restrict_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_buffer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_buffer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn implicit_sized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_implicit_sized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        interpolation: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        memory_read_only: ::std::os::raw::c_uint,
        memory_write_only: ::std::os::raw::c_uint,
        memory_coherent: ::std::os::raw::c_uint,
        memory_volatile: ::std::os::raw::c_uint,
        memory_restrict: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(5usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let memory_read_only: u32 = unsafe { ::std::mem::transmute(memory_read_only) };
            memory_read_only as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let memory_write_only: u32 = unsafe { ::std::mem::transmute(memory_write_only) };
            memory_write_only as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let memory_coherent: u32 = unsafe { ::std::mem::transmute(memory_coherent) };
            memory_coherent as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let memory_volatile: u32 = unsafe { ::std::mem::transmute(memory_volatile) };
            memory_volatile as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let memory_restrict: u32 = unsafe { ::std::mem::transmute(memory_restrict) };
            memory_restrict as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field__bindgen_ty_1"]
        [::std::mem::size_of::<glsl_struct_field__bindgen_ty_1>() - 4usize];
    ["Alignment of glsl_struct_field__bindgen_ty_1"]
        [::std::mem::align_of::<glsl_struct_field__bindgen_ty_1>() - 4usize];
    ["Offset of field: glsl_struct_field__bindgen_ty_1::flags"]
        [::std::mem::offset_of!(glsl_struct_field__bindgen_ty_1, flags) - 0usize];
};
impl Default for glsl_struct_field__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of glsl_struct_field"][::std::mem::size_of::<glsl_struct_field>() - 36usize];
    ["Alignment of glsl_struct_field"][::std::mem::align_of::<glsl_struct_field>() - 4usize];
    ["Offset of field: glsl_struct_field::type_"]
        [::std::mem::offset_of!(glsl_struct_field, type_) - 0usize];
    ["Offset of field: glsl_struct_field::name"]
        [::std::mem::offset_of!(glsl_struct_field, name) - 4usize];
    ["Offset of field: glsl_struct_field::location"]
        [::std::mem::offset_of!(glsl_struct_field, location) - 8usize];
    ["Offset of field: glsl_struct_field::component"]
        [::std::mem::offset_of!(glsl_struct_field, component) - 12usize];
    ["Offset of field: glsl_struct_field::offset"]
        [::std::mem::offset_of!(glsl_struct_field, offset) - 16usize];
    ["Offset of field: glsl_struct_field::xfb_buffer"]
        [::std::mem::offset_of!(glsl_struct_field, xfb_buffer) - 20usize];
    ["Offset of field: glsl_struct_field::xfb_stride"]
        [::std::mem::offset_of!(glsl_struct_field, xfb_stride) - 24usize];
    ["Offset of field: glsl_struct_field::image_format"]
        [::std::mem::offset_of!(glsl_struct_field, image_format) - 28usize];
};
impl Default for glsl_struct_field {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "glsl_get_base_type__extern"]
    pub fn glsl_get_base_type(t: *const glsl_type) -> glsl_base_type;
}
unsafe extern "C" {
    #[link_name = "glsl_get_bit_size__extern"]
    pub fn glsl_get_bit_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_boolean__extern"]
    pub fn glsl_type_is_boolean(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_sampler__extern"]
    pub fn glsl_type_is_sampler(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_texture__extern"]
    pub fn glsl_type_is_texture(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_image__extern"]
    pub fn glsl_type_is_image(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_atomic_uint__extern"]
    pub fn glsl_type_is_atomic_uint(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_struct__extern"]
    pub fn glsl_type_is_struct(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_interface__extern"]
    pub fn glsl_type_is_interface(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_array__extern"]
    pub fn glsl_type_is_array(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_cmat__extern"]
    pub fn glsl_type_is_cmat(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_void__extern"]
    pub fn glsl_type_is_void(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_subroutine__extern"]
    pub fn glsl_type_is_subroutine(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_error__extern"]
    pub fn glsl_type_is_error(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_double__extern"]
    pub fn glsl_type_is_double(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_float__extern"]
    pub fn glsl_type_is_float(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_numeric__extern"]
    pub fn glsl_type_is_numeric(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer__extern"]
    pub fn glsl_type_is_integer(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_struct_or_ifc__extern"]
    pub fn glsl_type_is_struct_or_ifc(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_packed__extern"]
    pub fn glsl_type_is_packed(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_16bit__extern"]
    pub fn glsl_type_is_16bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_32bit__extern"]
    pub fn glsl_type_is_32bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_64bit__extern"]
    pub fn glsl_type_is_64bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_16__extern"]
    pub fn glsl_type_is_integer_16(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_32__extern"]
    pub fn glsl_type_is_integer_32(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_64__extern"]
    pub fn glsl_type_is_integer_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_32_64__extern"]
    pub fn glsl_type_is_integer_32_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_16_32__extern"]
    pub fn glsl_type_is_integer_16_32(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_integer_16_32_64__extern"]
    pub fn glsl_type_is_integer_16_32_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_float_16__extern"]
    pub fn glsl_type_is_float_16(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_float_16_32__extern"]
    pub fn glsl_type_is_float_16_32(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_float_16_32_64__extern"]
    pub fn glsl_type_is_float_16_32_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_int_16_32_64__extern"]
    pub fn glsl_type_is_int_16_32_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_uint_16_32_64__extern"]
    pub fn glsl_type_is_uint_16_32_64(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_int_16_32__extern"]
    pub fn glsl_type_is_int_16_32(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_uint_16_32__extern"]
    pub fn glsl_type_is_uint_16_32(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_unsized_array__extern"]
    pub fn glsl_type_is_unsized_array(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_array_of_arrays__extern"]
    pub fn glsl_type_is_array_of_arrays(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_type_is_bare_sampler__extern"]
    pub fn glsl_type_is_bare_sampler(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_vector(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_scalar(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_vector_or_scalar(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_matrix(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_array_or_matrix(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Query whether a 64-bit type takes two slots."]
    pub fn glsl_type_is_dual_slot(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_is_leaf(type_: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_matrix_type_is_row_major__extern"]
    pub fn glsl_matrix_type_is_row_major(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_sampler_type_is_shadow__extern"]
    pub fn glsl_sampler_type_is_shadow(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_sampler_type_is_array__extern"]
    pub fn glsl_sampler_type_is_array(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_struct_type_is_packed__extern"]
    pub fn glsl_struct_type_is_packed(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Gets the \"bare\" type without any decorations or layout information."]
    pub fn glsl_get_bare_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the basic scalar type which this type aggregates.\n\n If the type is a numeric or boolean scalar, vector, or matrix, or an\n array of any of those, this function gets the scalar type of the\n individual components.  For structs and arrays of structs, this function\n returns the struct type.  For samplers and arrays of samplers, this\n function returns the sampler type."]
    pub fn glsl_get_scalar_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " For numeric and boolean derived types returns the basic scalar type\n\n If the type is a numeric or boolean scalar, vector, or matrix type,\n this function gets the scalar type of the individual components.  For\n all other types, including arrays of numeric or boolean types, the\n error type is returned."]
    pub fn glsl_get_base_glsl_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_length(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_get_vector_elements__extern"]
    pub fn glsl_get_vector_elements(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Query the total number of scalars that make up a scalar, vector or matrix"]
    #[link_name = "glsl_get_components__extern"]
    pub fn glsl_get_components(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_get_matrix_columns__extern"]
    pub fn glsl_get_matrix_columns(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_wrap_in_arrays(
        t: *const glsl_type,
        arrays: *const glsl_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Query the number of elements in an array type\n\n \\return\n The number of elements in the array for array types or -1 for non-array\n types.  If the number of elements in the array has not yet been declared,\n zero is returned."]
    #[link_name = "glsl_array_size__extern"]
    pub fn glsl_array_size(t: *const glsl_type) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Return the total number of elements in an array including the elements\n in arrays of arrays."]
    pub fn glsl_get_aoa_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_array_element(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the type stripped of any arrays\n\n \\return\n Pointer to the type of elements of the first non-array type for array\n types, or pointer to itself for non-array types."]
    pub fn glsl_without_array(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_without_array_or_matrix(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_cmat_element(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_cmat_description(t: *const glsl_type) -> *const glsl_cmat_description;
}
unsafe extern "C" {
    #[doc = " Return the amount of atomic counter storage required for a type."]
    pub fn glsl_atomic_size(type_: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Type A contains type B if A is B or A is a composite type (struct,\n interface, array) that has an element that contains B."]
    pub fn glsl_type_contains_32bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_contains_64bit(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_type_contains_image(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_atomic(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_double(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_integer(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_opaque(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_sampler(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_array(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    pub fn glsl_contains_subroutine(t: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[link_name = "glsl_get_sampler_dim__extern"]
    pub fn glsl_get_sampler_dim(t: *const glsl_type) -> glsl_sampler_dim;
}
unsafe extern "C" {
    #[link_name = "glsl_get_sampler_result_type__extern"]
    pub fn glsl_get_sampler_result_type(t: *const glsl_type) -> glsl_base_type;
}
unsafe extern "C" {
    #[doc = " Return the number of coordinate components needed for this\n sampler or image type.\n\n This is based purely on the sampler's dimensionality.  For example, this\n returns 1 for sampler1D, and 3 for sampler2DArray.\n\n Note that this is often different than actual coordinate type used in\n a texturing built-in function, since those pack additional values (such\n as the shadow comparator or projector) into the coordinate type."]
    pub fn glsl_get_sampler_coordinate_components(t: *const glsl_type) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Compares whether this type matches another type without taking into\n account the precision in structures.\n\n This is applied recursively so that structures containing structure\n members can also ignore the precision."]
    pub fn glsl_type_compare_no_precision(a: *const glsl_type, b: *const glsl_type) -> bool;
}
unsafe extern "C" {
    #[doc = " Compare a record type against another record type.\n\n This is useful for matching record types declared on the same shader\n stage as well as across different shader stages.\n The option to not match name is needed for matching record types\n declared across different shader stages.\n The option to not match locations is to deal with places where the\n same struct is defined in a block which has a location set on it."]
    pub fn glsl_record_compare(
        a: *const glsl_type,
        b: *const glsl_type,
        match_name: bool,
        match_locations: bool,
        match_precision: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn glsl_get_struct_field(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_get_struct_field_data(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const glsl_struct_field;
}
unsafe extern "C" {
    #[doc = " Calculate offset between the base location of the struct in\n uniform storage and a struct member.\n For the initial call, length is the index of the member to find the\n offset for."]
    pub fn glsl_get_struct_location_offset(
        t: *const glsl_type,
        length: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Get the location of a field within a record type"]
    pub fn glsl_get_field_index(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Get the type of a structure field\n\n \\return\n Pointer to the type of the named field.  If the type is not a structure\n or the named field does not exist, \\c &glsl_type_builtin_error is returned."]
    pub fn glsl_get_field_type(
        t: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_get_struct_field_offset__extern"]
    pub fn glsl_get_struct_field_offset(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "glsl_get_struct_elem_name__extern"]
    pub fn glsl_get_struct_elem_name(
        t: *const glsl_type,
        index: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[link_name = "glsl_void_type__extern"]
    pub fn glsl_void_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_float_type__extern"]
    pub fn glsl_float_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_float16_t_type__extern"]
    pub fn glsl_float16_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_double_type__extern"]
    pub fn glsl_double_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_vec2_type__extern"]
    pub fn glsl_vec2_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_dvec2_type__extern"]
    pub fn glsl_dvec2_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uvec2_type__extern"]
    pub fn glsl_uvec2_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_ivec2_type__extern"]
    pub fn glsl_ivec2_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_bvec2_type__extern"]
    pub fn glsl_bvec2_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_vec4_type__extern"]
    pub fn glsl_vec4_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_dvec4_type__extern"]
    pub fn glsl_dvec4_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uvec4_type__extern"]
    pub fn glsl_uvec4_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_ivec4_type__extern"]
    pub fn glsl_ivec4_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_bvec4_type__extern"]
    pub fn glsl_bvec4_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_int_type__extern"]
    pub fn glsl_int_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uint_type__extern"]
    pub fn glsl_uint_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_int64_t_type__extern"]
    pub fn glsl_int64_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uint64_t_type__extern"]
    pub fn glsl_uint64_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_int16_t_type__extern"]
    pub fn glsl_int16_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uint16_t_type__extern"]
    pub fn glsl_uint16_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_int8_t_type__extern"]
    pub fn glsl_int8_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uint8_t_type__extern"]
    pub fn glsl_uint8_t_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_bool_type__extern"]
    pub fn glsl_bool_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_atomic_uint_type__extern"]
    pub fn glsl_atomic_uint_type() -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_floatN_t_type__extern"]
    pub fn glsl_floatN_t_type(bit_size: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_intN_t_type__extern"]
    pub fn glsl_intN_t_type(bit_size: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_uintN_t_type__extern"]
    pub fn glsl_uintN_t_type(bit_size: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_f16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_dvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_ivec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_uvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bvec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u64vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u16vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_i8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_u8vec_type(components: ::std::os::raw::c_uint) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_simple_explicit_type(
        base_type: ::std::os::raw::c_uint,
        rows: ::std::os::raw::c_uint,
        columns: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
        row_major: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_simple_type__extern"]
    pub fn glsl_simple_type(
        base_type: ::std::os::raw::c_uint,
        rows: ::std::os::raw::c_uint,
        columns: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_sampler_type(
        dim: glsl_sampler_dim,
        shadow: bool,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bare_sampler_type() -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_bare_shadow_sampler_type() -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_texture_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_image_type(
        dim: glsl_sampler_dim,
        array: bool,
        type_: glsl_base_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_array_type(
        element: *const glsl_type,
        array_size: ::std::os::raw::c_uint,
        explicit_stride: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_cmat_type(desc: *const glsl_cmat_description) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_struct_type_with_explicit_alignment(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        name: *const ::std::os::raw::c_char,
        packed: bool,
        explicit_alignment: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_struct_type__extern"]
    pub fn glsl_struct_type(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        name: *const ::std::os::raw::c_char,
        packed: bool,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_interface_type(
        fields: *const glsl_struct_field,
        num_fields: ::std::os::raw::c_uint,
        packing: glsl_interface_packing,
        row_major: bool,
        block_name: *const ::std::os::raw::c_char,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_subroutine_type(subroutine_name: *const ::std::os::raw::c_char)
        -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Query the full type of a matrix row\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the rows of the matrix is returned."]
    pub fn glsl_get_row_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Query the full type of a matrix column\n\n \\return\n If the type is not a matrix, \\c glsl_type::error_type is returned.\n Otherwise a type matching the columns of the matrix is returned."]
    pub fn glsl_get_column_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Returns an explicitly laid out type given a type and size/align func\n\n The size/align func is only called for scalar and vector types and the\n returned type is otherwise laid out in the natural way as follows:\n\n  - Arrays and matrices have a stride of align(elem_size, elem_align).\n\n  - Structure types have their elements in-order and as tightly packed as\n    possible following the alignment required by the size/align func.\n\n  - All composite types (structures, matrices, and arrays) have an\n    alignment equal to the highest alignment of any member of the composite.\n\n The types returned by this function are likely not suitable for most UBO\n or SSBO layout because they do not add the extra array and substructure\n alignment that is required by std140 and std430."]
    pub fn glsl_get_explicit_type_for_size_align(
        type_: *const glsl_type,
        type_info: glsl_type_size_align_func,
        size: *mut ::std::os::raw::c_uint,
        alignment: *mut ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_replace_vec3_with_vec4(type_: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the float16 version of this type."]
    pub fn glsl_float16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the int16 version of this type."]
    pub fn glsl_int16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets the uint16 version of this type."]
    pub fn glsl_uint16_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_to_16bit(old_type: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_scalar_type__extern"]
    pub fn glsl_scalar_type(base_type: glsl_base_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_vector_type__extern"]
    pub fn glsl_vector_type(
        base_type: glsl_base_type,
        components: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_matrix_type__extern"]
    pub fn glsl_matrix_type(
        base_type: glsl_base_type,
        rows: ::std::os::raw::c_uint,
        columns: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_explicit_matrix_type__extern"]
    pub fn glsl_explicit_matrix_type(
        mat: *const glsl_type,
        stride: ::std::os::raw::c_uint,
        row_major: bool,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_transposed_type__extern"]
    pub fn glsl_transposed_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_texture_type_to_sampler__extern"]
    pub fn glsl_texture_type_to_sampler(t: *const glsl_type, is_shadow: bool) -> *const glsl_type;
}
unsafe extern "C" {
    #[link_name = "glsl_sampler_type_to_texture__extern"]
    pub fn glsl_sampler_type_to_texture(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_replace_vector_type(
        t: *const glsl_type,
        components: ::std::os::raw::c_uint,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_channel_type(t: *const glsl_type) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Get the type resulting from a multiplication of \\p type_a * \\p type_b"]
    pub fn glsl_get_mul_type(
        type_a: *const glsl_type,
        type_b: *const glsl_type,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_type_get_sampler_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_get_texture_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_type_get_image_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n count_attribute_slots() (vertex inputs and varyings) but also for\n gallium's !pipe_caps.packed_uniforms case."]
    pub fn glsl_count_vec4_slots(
        t: *const glsl_type,
        is_gl_vertex_input: bool,
        is_bindless: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of vec4 slots required to hold this type.\n\n This is the underlying recursive type_size function for\n gallium's pipe_caps.packed_uniforms case."]
    pub fn glsl_count_dword_slots(t: *const glsl_type, is_bindless: bool)
        -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of components slots required to hold this type\n\n This is used to determine how many uniform or varying locations a type\n might occupy."]
    pub fn glsl_get_component_slots(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_component_slots_aligned(
        t: *const glsl_type,
        offset: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Used to count the number of varyings contained in the type ignoring\n innermost array elements."]
    pub fn glsl_varying_count(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of unique values from glGetUniformLocation for the\n elements of the type.\n\n This is used to allocate slots in the UniformRemapTable, the amount of\n locations may not match with actual used storage space by the driver."]
    pub fn glsl_type_uniform_locations(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate the number of attribute slots required to hold this type\n\n This implements the language rules of GLSL 1.50 for counting the number\n of slots used by a vertex attribute.  It also determines the number of\n varying slots the type will use up in the absence of varying packing\n (and thus, it can be used to measure the number of varying slots used by\n the varyings that are generated by lower_packed_varyings).\n\n For vertex shader attributes - doubles only take one slot.\n For inter-shader varyings - dvec3/dvec4 take two slots.\n\n Vulkan doesn’t make this distinction so the argument should always be\n false."]
    #[link_name = "glsl_count_attribute_slots__extern"]
    pub fn glsl_count_attribute_slots(
        t: *const glsl_type,
        is_gl_vertex_input: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in OpenCL memory"]
    pub fn glsl_get_cl_size(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in OpenCL memory."]
    pub fn glsl_get_cl_alignment(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn glsl_get_cl_type_size_align(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Get the type interface packing used internally. For shared and packing\n layouts this is implementation defined."]
    pub fn glsl_get_internal_ifc_packing(
        t: *const glsl_type,
        std430_supported: bool,
    ) -> glsl_interface_packing;
}
unsafe extern "C" {
    #[link_name = "glsl_get_ifc_packing__extern"]
    pub fn glsl_get_ifc_packing(t: *const glsl_type) -> glsl_interface_packing;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std140 uniform\n block."]
    pub fn glsl_get_std140_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in a std140 uniform block.\n\n Note that this is not GL_UNIFORM_SIZE (which is the number of\n elements in the array)"]
    pub fn glsl_get_std140_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Calculate array stride in bytes of this type in a std430 shader storage\n block."]
    pub fn glsl_get_std430_array_stride(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Alignment in bytes of the start of this type in a std430 shader\n storage block."]
    pub fn glsl_get_std430_base_alignment(
        t: *const glsl_type,
        row_major: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type in a std430 shader storage block.\n\n Note that this is not GL_BUFFER_SIZE"]
    pub fn glsl_get_std430_size(t: *const glsl_type, row_major: bool) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Size in bytes of this type based on its explicit data.\n\n When using SPIR-V shaders (ARB_gl_spirv), memory layouts are expressed\n through explicit offset, stride and matrix layout, so the size\n can/should be computed used those values.\n\n Note that the value returned by this method is only correct if such\n values are set, so only with SPIR-V shaders. Should not be used with\n GLSL shaders."]
    pub fn glsl_get_explicit_size(
        t: *const glsl_type,
        align_to_stride: bool,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_get_explicit_stride__extern"]
    pub fn glsl_get_explicit_stride(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "glsl_get_explicit_alignment__extern"]
    pub fn glsl_get_explicit_alignment(t: *const glsl_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Gets an explicitly laid out type with the std140 layout."]
    pub fn glsl_get_explicit_std140_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets an explicitly laid out type with the std430 layout."]
    pub fn glsl_get_explicit_std430_type(t: *const glsl_type, row_major: bool) -> *const glsl_type;
}
unsafe extern "C" {
    #[doc = " Gets an explicitly laid out interface type."]
    #[link_name = "glsl_get_explicit_interface_type__extern"]
    pub fn glsl_get_explicit_interface_type(
        t: *const glsl_type,
        supports_std430: bool,
    ) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn glsl_size_align_handle_array_and_structs(
        type_: *const glsl_type,
        size_align: glsl_type_size_align_func,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_natural_size_align_bytes(
        t: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_word_size_align_bytes(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn glsl_get_vec4_size_align_bytes(
        type_: *const glsl_type,
        size: *mut ::std::os::raw::c_uint,
        align: *mut ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Allocate a new ralloc context.\n\n While any ralloc'd pointer can be used as a context, sometimes it is useful\n to simply allocate a context with no associated memory.\n\n It is equivalent to:\n \\code\n ((type *) ralloc_size(ctx, 0)\n \\endcode"]
    pub fn ralloc_context(ctx: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Allocate memory chained off of the given context.\n\n This is the core allocation routine which is used by all others.  It\n simply allocates storage for \\p size bytes and returns the pointer,\n similar to \\c malloc."]
    pub fn ralloc_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Allocate zero-initialized memory chained off of the given context.\n\n This is similar to \\c calloc with a size of 1."]
    pub fn rzalloc_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Allocate memory for an array chained off the given context.\n\n Similar to \\c calloc, but does not initialize the memory to zero.\n\n More than a convenience function, this also checks for integer overflow when\n multiplying \\p size and \\p count.  This is necessary for security."]
    pub fn ralloc_array_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
        count: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Allocate a zero-initialized array chained off the given context.\n\n Similar to \\c calloc.\n\n More than a convenience function, this also checks for integer overflow when\n multiplying \\p size and \\p count.  This is necessary for security."]
    pub fn rzalloc_array_size(
        ctx: *const ::std::os::raw::c_void,
        size: usize,
        count: ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Free a piece of ralloc-managed memory.\n\n This will also free the memory of any children allocated this context."]
    pub fn ralloc_free(ptr: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    #[doc = " \"Steal\" memory from one context, changing it to another.\n\n This changes \\p ptr's context to \\p new_ctx.  This is quite useful if\n memory is allocated out of a temporary context."]
    pub fn ralloc_steal(new_ctx: *const ::std::os::raw::c_void, ptr: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    #[doc = " Reparent all children from one context to another.\n\n This effectively calls ralloc_steal(new_ctx, child) for all children of \\p old_ctx."]
    pub fn ralloc_adopt(
        new_ctx: *const ::std::os::raw::c_void,
        old_ctx: *mut ::std::os::raw::c_void,
    );
}
unsafe extern "C" {
    #[doc = " Return the given pointer's ralloc context."]
    pub fn ralloc_parent(ptr: *const ::std::os::raw::c_void) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Set a callback to occur just before an object is freed."]
    pub fn ralloc_set_destructor(
        ptr: *const ::std::os::raw::c_void,
        destructor: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    );
}
unsafe extern "C" {
    #[doc = " Duplicate memory, allocating the memory from the given context."]
    pub fn ralloc_memdup(
        ctx: *const ::std::os::raw::c_void,
        mem: *const ::std::os::raw::c_void,
        n: usize,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " \\defgroup array String Functions @{\n**\n* Duplicate a string, allocating the memory from the given context.\n*/"]
    pub fn ralloc_strdup(
        ctx: *const ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Duplicate a string, allocating the memory from the given context.\n\n Like \\c strndup, at most \\p n characters are copied.  If \\p str is longer\n than \\p n characters, \\p n are copied, and a termining \\c '\\0' byte is added."]
    pub fn ralloc_strndup(
        ctx: *const ::std::os::raw::c_void,
        str_: *const ::std::os::raw::c_char,
        n: usize,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends \\p str to \\p *dest, similar to \\c strcat, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated.\n\n \\return True unless allocation failed."]
    pub fn ralloc_strcat(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends at most \\p n bytes of \\p str to \\p *dest, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated; \\p str does not need to be null\n terminated if it is longer than \\p n.\n\n \\return True unless allocation failed."]
    pub fn ralloc_strncat(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        n: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Concatenate two strings, allocating the necessary space.\n\n This appends \\p n bytes of \\p str to \\p *dest, using ralloc_resize\n to expand \\p *dest to the appropriate size.  \\p dest will be updated to the\n new pointer unless allocation fails.\n\n The result will always be null-terminated.\n\n This function differs from ralloc_strcat() and ralloc_strncat() in that it\n does not do any strlen() calls which can become costly on large strings.\n\n \\return True unless allocation failed."]
    pub fn ralloc_str_append(
        dest: *mut *mut ::std::os::raw::c_char,
        str_: *const ::std::os::raw::c_char,
        existing_length: usize,
        str_size: usize,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Print to a string.\n\n This is analogous to \\c sprintf, but allocates enough space (using \\p ctx\n as the context) for the resulting string.\n\n \\return The newly allocated string."]
    pub fn ralloc_asprintf(
        ctx: *const ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Print to a string, given a va_list.\n\n This is analogous to \\c vsprintf, but allocates enough space (using \\p ctx\n as the context) for the resulting string.\n\n \\return The newly allocated string."]
    pub fn ralloc_vasprintf(
        ctx: *const ::std::os::raw::c_void,
        fmt: *const ::std::os::raw::c_char,
        args: va_list,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Rewrite the tail of an existing string, starting at a given index.\n\n Overwrites the contents of *str starting at \\p start with newly formatted\n text, including a new null-terminator.  Allocates more memory as necessary.\n\n This can be used to append formatted text when the length of the existing\n string is already known, saving a strlen() call.\n\n \\sa ralloc_asprintf_append\n\n \\param str   The string to be updated.\n \\param start The index to start appending new data at.\n \\param fmt   A printf-style formatting string\n\n \\p str will be updated to the new pointer unless allocation fails.\n \\p start will be increased by the length of the newly formatted text.\n\n \\return True unless allocation failed."]
    pub fn ralloc_asprintf_rewrite_tail(
        str_: *mut *mut ::std::os::raw::c_char,
        start: *mut usize,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Rewrite the tail of an existing string, starting at a given index.\n\n Overwrites the contents of *str starting at \\p start with newly formatted\n text, including a new null-terminator.  Allocates more memory as necessary.\n\n This can be used to append formatted text when the length of the existing\n string is already known, saving a strlen() call.\n\n \\sa ralloc_vasprintf_append\n\n \\param str   The string to be updated.\n \\param start The index to start appending new data at.\n \\param fmt   A printf-style formatting string\n \\param args  A va_list containing the data to be formatted\n\n \\p str will be updated to the new pointer unless allocation fails.\n \\p start will be increased by the length of the newly formatted text.\n\n \\return True unless allocation failed."]
    pub fn ralloc_vasprintf_rewrite_tail(
        str_: *mut *mut ::std::os::raw::c_char,
        start: *mut usize,
        fmt: *const ::std::os::raw::c_char,
        args: va_list,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Append formatted text to the supplied string.\n\n This is equivalent to\n \\code\n ralloc_asprintf_rewrite_tail(str, strlen(*str), fmt, ...)\n \\endcode\n\n \\sa ralloc_asprintf\n \\sa ralloc_asprintf_rewrite_tail\n \\sa ralloc_strcat\n\n \\p str will be updated to the new pointer unless allocation fails.\n\n \\return True unless allocation failed."]
    pub fn ralloc_asprintf_append(
        str_: *mut *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Append formatted text to the supplied string, given a va_list.\n\n This is equivalent to\n \\code\n ralloc_vasprintf_rewrite_tail(str, strlen(*str), fmt, args)\n \\endcode\n\n \\sa ralloc_vasprintf\n \\sa ralloc_vasprintf_rewrite_tail\n \\sa ralloc_strcat\n\n \\p str will be updated to the new pointer unless allocation fails.\n\n \\return True unless allocation failed."]
    pub fn ralloc_vasprintf_append(
        str_: *mut *mut ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        args: va_list,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gc_ctx {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct linear_ctx {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " Same as ralloc_steal, but steals the entire linear context."]
    pub fn ralloc_steal_linear_context(
        new_ralloc_ctx: *mut ::std::os::raw::c_void,
        ctx: *mut linear_ctx,
    );
}
unsafe extern "C" {
    #[doc = " Return the ralloc parent of the linear context."]
    pub fn ralloc_parent_of_linear_context(ctx: *mut linear_ctx) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    pub fn ralloc_print_info(
        f: *mut FILE,
        p: *const ::std::os::raw::c_void,
        flags: ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct exec_node {
    pub next: *mut exec_node,
    pub prev: *mut exec_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of exec_node"][::std::mem::size_of::<exec_node>() - 8usize];
    ["Alignment of exec_node"][::std::mem::align_of::<exec_node>() - 4usize];
    ["Offset of field: exec_node::next"][::std::mem::offset_of!(exec_node, next) - 0usize];
    ["Offset of field: exec_node::prev"][::std::mem::offset_of!(exec_node, prev) - 4usize];
};
impl Default for exec_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct exec_list {
    pub head_sentinel: exec_node,
    pub tail_sentinel: exec_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of exec_list"][::std::mem::size_of::<exec_list>() - 16usize];
    ["Alignment of exec_list"][::std::mem::align_of::<exec_list>() - 4usize];
    ["Offset of field: exec_list::head_sentinel"]
        [::std::mem::offset_of!(exec_list, head_sentinel) - 0usize];
    ["Offset of field: exec_list::tail_sentinel"]
        [::std::mem::offset_of!(exec_list, tail_sentinel) - 8usize];
};
impl Default for exec_list {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "u_bit_scan__extern"]
    pub fn u_bit_scan(mask: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "u_bit_scan64__extern"]
    pub fn u_bit_scan64(mask: *mut u64) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "u_bit_scan_consecutive_range__extern"]
    pub fn u_bit_scan_consecutive_range(
        mask: *mut ::std::os::raw::c_uint,
        start: *mut ::std::os::raw::c_int,
        count: *mut ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "u_bit_scan_consecutive_range64__extern"]
    pub fn u_bit_scan_consecutive_range64(
        mask: *mut u64,
        start: *mut ::std::os::raw::c_int,
        count: *mut ::std::os::raw::c_int,
    );
}
unsafe extern "C" {
    #[link_name = "u_bit_consecutive__extern"]
    pub fn u_bit_consecutive(
        start: ::std::os::raw::c_uint,
        count: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "u_bit_consecutive64__extern"]
    pub fn u_bit_consecutive64(start: ::std::os::raw::c_uint, count: ::std::os::raw::c_uint)
        -> u64;
}
pub type blake3_hash = [u8; 32usize];
#[repr(C)]
#[derive(Copy, Clone)]
pub struct shader_info {
    pub name: *const ::std::os::raw::c_char,
    pub label: *const ::std::os::raw::c_char,
    pub internal: bool,
    pub source_blake3: blake3_hash,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub num_textures: u8,
    pub num_ubos: u8,
    pub num_abos: u8,
    pub num_ssbos: u8,
    pub num_images: u8,
    pub inputs_read: u64,
    pub dual_slot_inputs: u64,
    pub outputs_written: u64,
    pub outputs_read: u64,
    pub system_values_read: [::std::os::raw::c_uint; 4usize],
    pub per_primitive_inputs: u64,
    pub per_primitive_outputs: u64,
    pub per_view_outputs: u64,
    pub view_mask: u32,
    pub inputs_read_16bit: u16,
    pub outputs_written_16bit: u16,
    pub outputs_read_16bit: u16,
    pub inputs_read_indirectly_16bit: u16,
    pub outputs_accessed_indirectly_16bit: u16,
    pub patch_inputs_read: u32,
    pub patch_outputs_written: u32,
    pub patch_outputs_read: u32,
    pub inputs_read_indirectly: u64,
    pub outputs_accessed_indirectly: u64,
    pub patch_inputs_read_indirectly: u64,
    pub patch_outputs_accessed_indirectly: u64,
    #[doc = " Bitfield of which textures are used"]
    pub textures_used: [::std::os::raw::c_uint; 4usize],
    #[doc = " Bitfield of which textures are used by texelFetch()"]
    pub textures_used_by_txf: [::std::os::raw::c_uint; 4usize],
    #[doc = " Bitfield of which samplers are used"]
    pub samplers_used: [::std::os::raw::c_uint; 1usize],
    #[doc = " Bitfield of which images are used"]
    pub images_used: [::std::os::raw::c_uint; 2usize],
    #[doc = " Bitfield of which images are buffers."]
    pub image_buffers: [::std::os::raw::c_uint; 2usize],
    #[doc = " Bitfield of which images are MSAA."]
    pub msaa_images: [::std::os::raw::c_uint; 2usize],
    pub float_controls_execution_mode: u32,
    #[doc = " Size of shared variables accessed by compute/task/mesh shaders."]
    pub shared_size: ::std::os::raw::c_uint,
    #[doc = " Size of task payload variables accessed by task/mesh shaders."]
    pub task_payload_size: ::std::os::raw::c_uint,
    #[doc = " Number of ray tracing queries in the shader (counts all elements of all\n variables)."]
    pub ray_queries: ::std::os::raw::c_uint,
    #[doc = " Local workgroup size used by compute/task/mesh shaders."]
    pub workgroup_size: [u16; 3usize],
    pub subgroup_size: gl_subgroup_size,
    pub num_subgroups: u8,
    #[doc = " Uses subgroup intrinsics which can communicate across a quad."]
    pub uses_wide_subgroup_intrinsics: bool,
    pub xfb_stride: [u8; 4usize],
    pub inlinable_uniform_dw_offsets: [u16; 4usize],
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub bit_sizes_float: u8,
    pub bit_sizes_int: u8,
    pub _bitfield_align_3: [u8; 0],
    pub _bitfield_3: __BindgenBitfieldUnit<[u8; 3usize]>,
    #[doc = " Set if this shader uses legacy (DX9 or ARB assembly) math rules.\n\n From the ARB_fragment_program specification:\n\n    \"The following rules apply to multiplication:\n\n      1. <x> * <y> == <y> * <x>, for all <x> and <y>.\n      2. +/-0.0 * <x> = +/-0.0, at least for all <x> that correspond to\n         *representable numbers (IEEE \"not a number\" and \"infinity\"\n         *encodings may be exceptions).\n      3. +1.0 * <x> = <x>, for all <x>.\"\"\n\n However, in effect this was due to DX9 semantics implying that 0*x=0 even\n for inf/nan if the hardware generated them instead of float_min/max.  So,\n you should not have an exception for inf/nan to rule 2 above.\n\n One implementation of this behavior would be to flush all generated NaNs\n to zero, at which point 0*Inf=Nan=0.  Most DX9/ARB-asm hardware did not\n generate NaNs, and the only way the GPU saw one was to possibly feed it\n in as a uniform."]
    pub use_legacy_math_rules: bool,
    pub _bitfield_align_4: [u8; 0],
    pub _bitfield_4: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub anon_1: shader_info__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union shader_info__bindgen_ty_1 {
    pub vs: shader_info__bindgen_ty_1__bindgen_ty_1,
    pub gs: shader_info__bindgen_ty_1__bindgen_ty_2,
    pub fs: shader_info__bindgen_ty_1__bindgen_ty_3,
    pub cs: shader_info__bindgen_ty_1__bindgen_ty_4,
    pub tess: shader_info__bindgen_ty_1__bindgen_ty_5,
    pub mesh: shader_info__bindgen_ty_1__bindgen_ty_6,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_1 {
    pub double_inputs: u64,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 12usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_1::double_inputs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_1, double_inputs) - 0usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_1 {
    #[inline]
    pub fn blit_sgprs_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_blit_sgprs_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn blit_sgprs_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_blit_sgprs_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn tes_agx(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_tes_agx(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn tes_agx_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_tes_agx_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn window_space_position(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_window_space_position(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn window_space_position_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_window_space_position_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_edge_flag(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_edge_flag(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_edge_flag_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_edge_flag_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        blit_sgprs_amd: u8,
        tes_agx: bool,
        window_space_position: bool,
        needs_edge_flag: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let blit_sgprs_amd: u8 = unsafe { ::std::mem::transmute(blit_sgprs_amd) };
            blit_sgprs_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let tes_agx: u8 = unsafe { ::std::mem::transmute(tes_agx) };
            tes_agx as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let window_space_position: u8 = unsafe { ::std::mem::transmute(window_space_position) };
            window_space_position as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_edge_flag: u8 = unsafe { ::std::mem::transmute(needs_edge_flag) };
            needs_edge_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[doc = " The output primitive type"]
    pub output_primitive: mesa_prim,
    #[doc = " The input primitive type"]
    pub input_primitive: mesa_prim,
    #[doc = " The maximum number of vertices the geometry shader might write."]
    pub vertices_out: u16,
    #[doc = " 1 .. MAX_GEOMETRY_SHADER_INVOCATIONS"]
    pub invocations: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 6usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_2"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_2>() - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::output_primitive"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_2,
        output_primitive
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::input_primitive"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, input_primitive) - 1usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::vertices_out"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, vertices_out) - 2usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_2::invocations"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_2, invocations) - 4usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn vertices_in(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u8) }
    }
    #[inline]
    pub fn set_vertices_in(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn vertices_in_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_vertices_in_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_end_primitive(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_end_primitive(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_end_primitive_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_end_primitive_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn active_stream_mask(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_active_stream_mask(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn active_stream_mask_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_active_stream_mask_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vertices_in: u8,
        uses_end_primitive: bool,
        active_stream_mask: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let vertices_in: u8 = unsafe { ::std::mem::transmute(vertices_in) };
            vertices_in as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let uses_end_primitive: u8 = unsafe { ::std::mem::transmute(uses_end_primitive) };
            uses_end_primitive as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let active_stream_mask: u8 = unsafe { ::std::mem::transmute(active_stream_mask) };
            active_stream_mask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub advanced_blend_modes: ::std::os::raw::c_uint,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 12usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_3"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_3>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_3::advanced_blend_modes"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_3,
        advanced_blend_modes
    ) - 4usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_3 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn uses_discard(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_discard(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_discard_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_discard_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_fbfetch_output(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_fbfetch_output(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_fbfetch_output_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_fbfetch_output_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fbfetch_coherent(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fbfetch_coherent(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fbfetch_coherent_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fbfetch_coherent_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color_is_dual_source(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color_is_dual_source(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color_is_dual_source_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color_is_dual_source_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn require_full_quads(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_require_full_quads(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn require_full_quads_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_require_full_quads_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn quad_derivatives_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_quad_derivatives_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn needs_quad_helper_invocations(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_needs_quad_helper_invocations(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn needs_quad_helper_invocations_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_needs_quad_helper_invocations_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_qualifier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_qualifier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_qualifier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_qualifier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_sample_shading(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_sample_shading(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_sample_shading_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_sample_shading_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn early_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn inner_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_inner_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn inner_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_inner_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn post_depth_coverage(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_post_depth_coverage(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn post_depth_coverage_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_post_depth_coverage_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_center_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_center_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn origin_upper_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_origin_upper_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn pixel_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_ordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_ordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_ordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_ordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample_interlock_unordered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_sample_interlock_unordered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_interlock_unordered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_sample_interlock_unordered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn untyped_color_outputs(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_untyped_color_outputs(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn untyped_color_outputs_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_untyped_color_outputs_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> gl_frag_depth_layout {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn depth_layout_raw(this: *const Self) -> gl_frag_depth_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_depth_layout_raw(this: *mut Self, val: gl_frag_depth_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color0_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color0_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color0_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color0_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color0_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color0_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_interp(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_color1_interp(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_interp_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_color1_interp_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_sample(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_sample(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_sample_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_sample_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn color1_centroid(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_color1_centroid(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn color1_centroid_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_color1_centroid_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        uses_discard: bool,
        uses_fbfetch_output: bool,
        fbfetch_coherent: bool,
        color_is_dual_source: bool,
        require_full_quads: bool,
        quad_derivatives: bool,
        needs_quad_helper_invocations: bool,
        uses_sample_qualifier: bool,
        uses_sample_shading: bool,
        early_fragment_tests: bool,
        inner_coverage: bool,
        post_depth_coverage: bool,
        pixel_center_integer: bool,
        origin_upper_left: bool,
        pixel_interlock_ordered: bool,
        pixel_interlock_unordered: bool,
        sample_interlock_ordered: bool,
        sample_interlock_unordered: bool,
        untyped_color_outputs: bool,
        depth_layout: gl_frag_depth_layout,
        color0_interp: ::std::os::raw::c_uint,
        color0_sample: bool,
        color0_centroid: bool,
        color1_interp: ::std::os::raw::c_uint,
        color1_sample: bool,
        color1_centroid: bool,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let uses_discard: u8 = unsafe { ::std::mem::transmute(uses_discard) };
            uses_discard as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let uses_fbfetch_output: u8 = unsafe { ::std::mem::transmute(uses_fbfetch_output) };
            uses_fbfetch_output as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fbfetch_coherent: u8 = unsafe { ::std::mem::transmute(fbfetch_coherent) };
            fbfetch_coherent as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let color_is_dual_source: u8 = unsafe { ::std::mem::transmute(color_is_dual_source) };
            color_is_dual_source as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let require_full_quads: u8 = unsafe { ::std::mem::transmute(require_full_quads) };
            require_full_quads as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let quad_derivatives: u8 = unsafe { ::std::mem::transmute(quad_derivatives) };
            quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let needs_quad_helper_invocations: u8 =
                unsafe { ::std::mem::transmute(needs_quad_helper_invocations) };
            needs_quad_helper_invocations as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let uses_sample_qualifier: u8 = unsafe { ::std::mem::transmute(uses_sample_qualifier) };
            uses_sample_qualifier as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_sample_shading: u8 = unsafe { ::std::mem::transmute(uses_sample_shading) };
            uses_sample_shading as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let early_fragment_tests: u8 = unsafe { ::std::mem::transmute(early_fragment_tests) };
            early_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let inner_coverage: u8 = unsafe { ::std::mem::transmute(inner_coverage) };
            inner_coverage as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let post_depth_coverage: u8 = unsafe { ::std::mem::transmute(post_depth_coverage) };
            post_depth_coverage as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let pixel_center_integer: u8 = unsafe { ::std::mem::transmute(pixel_center_integer) };
            pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let origin_upper_left: u8 = unsafe { ::std::mem::transmute(origin_upper_left) };
            origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let pixel_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_ordered) };
            pixel_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pixel_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(pixel_interlock_unordered) };
            pixel_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let sample_interlock_ordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_ordered) };
            sample_interlock_ordered as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let sample_interlock_unordered: u8 =
                unsafe { ::std::mem::transmute(sample_interlock_unordered) };
            sample_interlock_unordered as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let untyped_color_outputs: u8 = unsafe { ::std::mem::transmute(untyped_color_outputs) };
            untyped_color_outputs as u64
        });
        __bindgen_bitfield_unit.set(19usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(22usize, 3u8, {
            let color0_interp: u32 = unsafe { ::std::mem::transmute(color0_interp) };
            color0_interp as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let color0_sample: u8 = unsafe { ::std::mem::transmute(color0_sample) };
            color0_sample as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let color0_centroid: u8 = unsafe { ::std::mem::transmute(color0_centroid) };
            color0_centroid as u64
        });
        __bindgen_bitfield_unit.set(27usize, 3u8, {
            let color1_interp: u32 = unsafe { ::std::mem::transmute(color1_interp) };
            color1_interp as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let color1_sample: u8 = unsafe { ::std::mem::transmute(color1_sample) };
            color1_sample as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let color1_centroid: u8 = unsafe { ::std::mem::transmute(color1_centroid) };
            color1_centroid as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn early_and_late_fragment_tests(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_early_and_late_fragment_tests(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn early_and_late_fragment_tests_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_early_and_late_fragment_tests_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_front_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_front_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_front_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_front_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stencil_back_layout(&self) -> gl_frag_stencil_layout {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_stencil_back_layout(&mut self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stencil_back_layout_raw(this: *const Self) -> gl_frag_stencil_layout {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stencil_back_layout_raw(this: *mut Self, val: gl_frag_stencil_layout) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        early_and_late_fragment_tests: bool,
        stencil_front_layout: gl_frag_stencil_layout,
        stencil_back_layout: gl_frag_stencil_layout,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let early_and_late_fragment_tests: u8 =
                unsafe { ::std::mem::transmute(early_and_late_fragment_tests) };
            early_and_late_fragment_tests as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let stencil_front_layout: u32 = unsafe { ::std::mem::transmute(stencil_front_layout) };
            stencil_front_layout as u64
        });
        __bindgen_bitfield_unit.set(4usize, 3u8, {
            let stencil_back_layout: u32 = unsafe { ::std::mem::transmute(stencil_back_layout) };
            stencil_back_layout as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_4 {
    pub workgroup_size_hint: [u16; 3usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Number of bytes of shared imageblock memory per thread. Currently,\n this requires that the workgroup size is 32x32x1 and that\n shared_size = 0. These requirements could be lifted in the future.\n However, there is no current OpenGL/Vulkan API support for\n imageblocks. This is only used internally to accelerate blit/copy."]
    pub image_block_size_per_thread_agx: u8,
    #[doc = " pointer size is:\n   AddressingModelLogical:    0    (default)\n   AddressingModelPhysical32: 32\n   AddressingModelPhysical64: 64"]
    pub ptr_size: ::std::os::raw::c_uint,
    #[doc = " Index provided by VkPipelineShaderStageNodeCreateInfoAMDX or ShaderIndexAMDX"]
    pub shader_index: u32,
    #[doc = " Maximum size required by any output node payload array"]
    pub node_payloads_size: u32,
    #[doc = " Static workgroup count for overwriting the enqueued workgroup count. (0 if dynamic)"]
    pub workgroup_count: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_4"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_4>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_size_hint"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_size_hint
    ) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::image_block_size_per_thread_agx"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        image_block_size_per_thread_agx
    )
        - 7usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::ptr_size"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, ptr_size) - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::shader_index"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_4, shader_index) - 12usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::node_payloads_size"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        node_payloads_size
    ) - 16usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_4::workgroup_count"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_4,
        workgroup_count
    ) - 20usize];
};
impl shader_info__bindgen_ty_1__bindgen_ty_4 {
    #[inline]
    pub fn user_data_components_amd(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_user_data_components_amd(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn user_data_components_amd_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_user_data_components_amd_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_variable_shared_mem(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_variable_shared_mem(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_variable_shared_mem_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_variable_shared_mem_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_cooperative_matrix(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_cooperative_matrix(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_cooperative_matrix_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_cooperative_matrix_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        user_data_components_amd: u8,
        has_variable_shared_mem: bool,
        has_cooperative_matrix: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let user_data_components_amd: u8 =
                unsafe { ::std::mem::transmute(user_data_components_amd) };
            user_data_components_amd as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let has_variable_shared_mem: u8 =
                unsafe { ::std::mem::transmute(has_variable_shared_mem) };
            has_variable_shared_mem as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let has_cooperative_matrix: u8 =
                unsafe { ::std::mem::transmute(has_cooperative_matrix) };
            has_cooperative_matrix as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_5 {
    pub _primitive_mode: tess_primitive_mode,
    #[doc = " The number of vertices in the TCS output patch."]
    pub tcs_vertices_out: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub tcs_same_invocation_inputs_read: u64,
    pub tcs_cross_invocation_inputs_read: u64,
    pub tcs_cross_invocation_outputs_read: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_5"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_5>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::_primitive_mode"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_5, _primitive_mode) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_vertices_out
    ) - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_same_invocation_inputs_read"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_5,
        tcs_same_invocation_inputs_read
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_inputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_inputs_read) - 16usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_5::tcs_cross_invocation_outputs_read"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_5 , tcs_cross_invocation_outputs_read) - 24usize] ;
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_5 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info__bindgen_ty_1__bindgen_ty_5 {
    #[inline]
    pub fn spacing(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_spacing(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn spacing_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_spacing_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ccw(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_ccw(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ccw_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_ccw_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn point_mode(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_mode(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn point_mode_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_point_mode_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        spacing: ::std::os::raw::c_uint,
        ccw: bool,
        point_mode: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let spacing: u32 = unsafe { ::std::mem::transmute(spacing) };
            spacing as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let ccw: u8 = unsafe { ::std::mem::transmute(ccw) };
            ccw as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let point_mode: u8 = unsafe { ::std::mem::transmute(point_mode) };
            point_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct shader_info__bindgen_ty_1__bindgen_ty_6 {
    pub ms_cross_invocation_output_access: u64,
    pub ts_mesh_dispatch_dimensions: [u32; 3usize],
    pub max_vertices_out: u16,
    pub max_primitives_out: u16,
    pub primitive_type: mesa_prim,
    pub nv: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 28usize];
    ["Alignment of shader_info__bindgen_ty_1__bindgen_ty_6"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1__bindgen_ty_6>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ms_cross_invocation_output_access"] [:: std :: mem :: offset_of ! (shader_info__bindgen_ty_1__bindgen_ty_6 , ms_cross_invocation_output_access) - 0usize] ;
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::ts_mesh_dispatch_dimensions"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        ts_mesh_dispatch_dimensions
    )
        - 8usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_vertices_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_vertices_out
    ) - 20usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::max_primitives_out"][::std::mem::offset_of!(
        shader_info__bindgen_ty_1__bindgen_ty_6,
        max_primitives_out
    ) - 22usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::primitive_type"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, primitive_type) - 24usize];
    ["Offset of field: shader_info__bindgen_ty_1__bindgen_ty_6::nv"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1__bindgen_ty_6, nv) - 25usize];
};
impl Default for shader_info__bindgen_ty_1__bindgen_ty_6 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info__bindgen_ty_1"]
        [::std::mem::size_of::<shader_info__bindgen_ty_1>() - 32usize];
    ["Alignment of shader_info__bindgen_ty_1"]
        [::std::mem::align_of::<shader_info__bindgen_ty_1>() - 4usize];
    ["Offset of field: shader_info__bindgen_ty_1::vs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, vs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::gs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, gs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::fs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, fs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::cs"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, cs) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::tess"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, tess) - 0usize];
    ["Offset of field: shader_info__bindgen_ty_1::mesh"]
        [::std::mem::offset_of!(shader_info__bindgen_ty_1, mesh) - 0usize];
};
impl Default for shader_info__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of shader_info"][::std::mem::size_of::<shader_info>() - 320usize];
    ["Alignment of shader_info"][::std::mem::align_of::<shader_info>() - 4usize];
    ["Offset of field: shader_info::name"][::std::mem::offset_of!(shader_info, name) - 0usize];
    ["Offset of field: shader_info::label"][::std::mem::offset_of!(shader_info, label) - 4usize];
    ["Offset of field: shader_info::internal"]
        [::std::mem::offset_of!(shader_info, internal) - 8usize];
    ["Offset of field: shader_info::source_blake3"]
        [::std::mem::offset_of!(shader_info, source_blake3) - 9usize];
    ["Offset of field: shader_info::num_textures"]
        [::std::mem::offset_of!(shader_info, num_textures) - 43usize];
    ["Offset of field: shader_info::num_ubos"]
        [::std::mem::offset_of!(shader_info, num_ubos) - 44usize];
    ["Offset of field: shader_info::num_abos"]
        [::std::mem::offset_of!(shader_info, num_abos) - 45usize];
    ["Offset of field: shader_info::num_ssbos"]
        [::std::mem::offset_of!(shader_info, num_ssbos) - 46usize];
    ["Offset of field: shader_info::num_images"]
        [::std::mem::offset_of!(shader_info, num_images) - 47usize];
    ["Offset of field: shader_info::inputs_read"]
        [::std::mem::offset_of!(shader_info, inputs_read) - 48usize];
    ["Offset of field: shader_info::dual_slot_inputs"]
        [::std::mem::offset_of!(shader_info, dual_slot_inputs) - 56usize];
    ["Offset of field: shader_info::outputs_written"]
        [::std::mem::offset_of!(shader_info, outputs_written) - 64usize];
    ["Offset of field: shader_info::outputs_read"]
        [::std::mem::offset_of!(shader_info, outputs_read) - 72usize];
    ["Offset of field: shader_info::system_values_read"]
        [::std::mem::offset_of!(shader_info, system_values_read) - 80usize];
    ["Offset of field: shader_info::per_primitive_inputs"]
        [::std::mem::offset_of!(shader_info, per_primitive_inputs) - 96usize];
    ["Offset of field: shader_info::per_primitive_outputs"]
        [::std::mem::offset_of!(shader_info, per_primitive_outputs) - 104usize];
    ["Offset of field: shader_info::per_view_outputs"]
        [::std::mem::offset_of!(shader_info, per_view_outputs) - 112usize];
    ["Offset of field: shader_info::view_mask"]
        [::std::mem::offset_of!(shader_info, view_mask) - 120usize];
    ["Offset of field: shader_info::inputs_read_16bit"]
        [::std::mem::offset_of!(shader_info, inputs_read_16bit) - 124usize];
    ["Offset of field: shader_info::outputs_written_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_written_16bit) - 126usize];
    ["Offset of field: shader_info::outputs_read_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_read_16bit) - 128usize];
    ["Offset of field: shader_info::inputs_read_indirectly_16bit"]
        [::std::mem::offset_of!(shader_info, inputs_read_indirectly_16bit) - 130usize];
    ["Offset of field: shader_info::outputs_accessed_indirectly_16bit"]
        [::std::mem::offset_of!(shader_info, outputs_accessed_indirectly_16bit) - 132usize];
    ["Offset of field: shader_info::patch_inputs_read"]
        [::std::mem::offset_of!(shader_info, patch_inputs_read) - 136usize];
    ["Offset of field: shader_info::patch_outputs_written"]
        [::std::mem::offset_of!(shader_info, patch_outputs_written) - 140usize];
    ["Offset of field: shader_info::patch_outputs_read"]
        [::std::mem::offset_of!(shader_info, patch_outputs_read) - 144usize];
    ["Offset of field: shader_info::inputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, inputs_read_indirectly) - 148usize];
    ["Offset of field: shader_info::outputs_accessed_indirectly"]
        [::std::mem::offset_of!(shader_info, outputs_accessed_indirectly) - 156usize];
    ["Offset of field: shader_info::patch_inputs_read_indirectly"]
        [::std::mem::offset_of!(shader_info, patch_inputs_read_indirectly) - 164usize];
    ["Offset of field: shader_info::patch_outputs_accessed_indirectly"]
        [::std::mem::offset_of!(shader_info, patch_outputs_accessed_indirectly) - 172usize];
    ["Offset of field: shader_info::textures_used"]
        [::std::mem::offset_of!(shader_info, textures_used) - 180usize];
    ["Offset of field: shader_info::textures_used_by_txf"]
        [::std::mem::offset_of!(shader_info, textures_used_by_txf) - 196usize];
    ["Offset of field: shader_info::samplers_used"]
        [::std::mem::offset_of!(shader_info, samplers_used) - 212usize];
    ["Offset of field: shader_info::images_used"]
        [::std::mem::offset_of!(shader_info, images_used) - 216usize];
    ["Offset of field: shader_info::image_buffers"]
        [::std::mem::offset_of!(shader_info, image_buffers) - 224usize];
    ["Offset of field: shader_info::msaa_images"]
        [::std::mem::offset_of!(shader_info, msaa_images) - 232usize];
    ["Offset of field: shader_info::float_controls_execution_mode"]
        [::std::mem::offset_of!(shader_info, float_controls_execution_mode) - 240usize];
    ["Offset of field: shader_info::shared_size"]
        [::std::mem::offset_of!(shader_info, shared_size) - 244usize];
    ["Offset of field: shader_info::task_payload_size"]
        [::std::mem::offset_of!(shader_info, task_payload_size) - 248usize];
    ["Offset of field: shader_info::ray_queries"]
        [::std::mem::offset_of!(shader_info, ray_queries) - 252usize];
    ["Offset of field: shader_info::workgroup_size"]
        [::std::mem::offset_of!(shader_info, workgroup_size) - 256usize];
    ["Offset of field: shader_info::subgroup_size"]
        [::std::mem::offset_of!(shader_info, subgroup_size) - 262usize];
    ["Offset of field: shader_info::num_subgroups"]
        [::std::mem::offset_of!(shader_info, num_subgroups) - 263usize];
    ["Offset of field: shader_info::uses_wide_subgroup_intrinsics"]
        [::std::mem::offset_of!(shader_info, uses_wide_subgroup_intrinsics) - 264usize];
    ["Offset of field: shader_info::xfb_stride"]
        [::std::mem::offset_of!(shader_info, xfb_stride) - 265usize];
    ["Offset of field: shader_info::inlinable_uniform_dw_offsets"]
        [::std::mem::offset_of!(shader_info, inlinable_uniform_dw_offsets) - 270usize];
    ["Offset of field: shader_info::bit_sizes_float"]
        [::std::mem::offset_of!(shader_info, bit_sizes_float) - 280usize];
    ["Offset of field: shader_info::bit_sizes_int"]
        [::std::mem::offset_of!(shader_info, bit_sizes_int) - 281usize];
    ["Offset of field: shader_info::use_legacy_math_rules"]
        [::std::mem::offset_of!(shader_info, use_legacy_math_rules) - 285usize];
};
impl Default for shader_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl shader_info {
    #[inline]
    pub fn stage(&self) -> gl_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_stage(&mut self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stage_raw(this: *const Self) -> gl_shader_stage {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stage_raw(this: *mut Self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn next_stage(&self) -> gl_shader_stage {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_next_stage(&mut self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn next_stage_raw(this: *const Self) -> gl_shader_stage {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_next_stage_raw(this: *mut Self, val: gl_shader_stage) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        stage: gl_shader_stage,
        next_stage: gl_shader_stage,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let stage: u32 = unsafe { ::std::mem::transmute(stage) };
            stage as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let next_stage: u32 = unsafe { ::std::mem::transmute(next_stage) };
            next_stage as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn num_inlinable_uniforms(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_num_inlinable_uniforms(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_inlinable_uniforms_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_num_inlinable_uniforms_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn clip_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_clip_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn clip_distance_array_size_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_clip_distance_array_size_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn cull_distance_array_size(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(8usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_cull_distance_array_size(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(8usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn cull_distance_array_size_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                8usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_cull_distance_array_size_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                8usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_texture_gather(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_texture_gather(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_texture_gather_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_texture_gather_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_resource_info_query(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_resource_info_query(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_resource_info_query_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_resource_info_query_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn divergence_analysis_run(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_divergence_analysis_run(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_2.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn divergence_analysis_run_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_divergence_analysis_run_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        num_inlinable_uniforms: u8,
        clip_distance_array_size: u8,
        cull_distance_array_size: u8,
        uses_texture_gather: bool,
        uses_resource_info_query: bool,
        divergence_analysis_run: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let num_inlinable_uniforms: u8 =
                unsafe { ::std::mem::transmute(num_inlinable_uniforms) };
            num_inlinable_uniforms as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let clip_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(clip_distance_array_size) };
            clip_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(8usize, 4u8, {
            let cull_distance_array_size: u8 =
                unsafe { ::std::mem::transmute(cull_distance_array_size) };
            cull_distance_array_size as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let uses_texture_gather: u8 = unsafe { ::std::mem::transmute(uses_texture_gather) };
            uses_texture_gather as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uses_resource_info_query: u8 =
                unsafe { ::std::mem::transmute(uses_resource_info_query) };
            uses_resource_info_query as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let divergence_analysis_run: u8 =
                unsafe { ::std::mem::transmute(divergence_analysis_run) };
            divergence_analysis_run as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn first_ubo_is_default_ubo(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_first_ubo_is_default_ubo(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn first_ubo_is_default_ubo_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_first_ubo_is_default_ubo_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn separate_shader(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_separate_shader(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn separate_shader_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_separate_shader_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_transform_feedback_varyings(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_transform_feedback_varyings(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_transform_feedback_varyings_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_transform_feedback_varyings_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn flrp_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_flrp_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn flrp_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_flrp_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn io_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_io_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn io_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_io_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn var_copies_lowered(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_var_copies_lowered(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn var_copies_lowered_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_var_copies_lowered_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn writes_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_writes_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn writes_memory_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_writes_memory_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn layer_viewport_relative(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_layer_viewport_relative(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn layer_viewport_relative_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_layer_viewport_relative_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_control_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_control_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_control_barrier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_control_barrier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_memory_barrier(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_memory_barrier(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_memory_barrier_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_memory_barrier_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_bindless(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_bindless(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_bindless_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_bindless_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shared_memory_explicit_layout(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shared_memory_explicit_layout(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shared_memory_explicit_layout_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shared_memory_explicit_layout_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn zero_initialize_shared_memory(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_zero_initialize_shared_memory(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn zero_initialize_shared_memory_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_zero_initialize_shared_memory_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn workgroup_size_variable(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_workgroup_size_variable(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn workgroup_size_variable_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_workgroup_size_variable_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn uses_printf(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_uses_printf(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn uses_printf_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_uses_printf_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn maximally_reconverges(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_maximally_reconverges(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn maximally_reconverges_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_maximally_reconverges_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn use_aco_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_3.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_use_aco_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_3.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn use_aco_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_3),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_use_aco_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_3),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_3(
        first_ubo_is_default_ubo: bool,
        separate_shader: bool,
        has_transform_feedback_varyings: bool,
        flrp_lowered: bool,
        io_lowered: bool,
        var_copies_lowered: bool,
        writes_memory: bool,
        layer_viewport_relative: bool,
        uses_control_barrier: bool,
        uses_memory_barrier: bool,
        uses_bindless: bool,
        shared_memory_explicit_layout: bool,
        zero_initialize_shared_memory: bool,
        workgroup_size_variable: bool,
        uses_printf: bool,
        maximally_reconverges: bool,
        use_aco_amd: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_ubo_is_default_ubo: u8 =
                unsafe { ::std::mem::transmute(first_ubo_is_default_ubo) };
            first_ubo_is_default_ubo as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_shader: u8 = unsafe { ::std::mem::transmute(separate_shader) };
            separate_shader as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let has_transform_feedback_varyings: u8 =
                unsafe { ::std::mem::transmute(has_transform_feedback_varyings) };
            has_transform_feedback_varyings as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let flrp_lowered: u8 = unsafe { ::std::mem::transmute(flrp_lowered) };
            flrp_lowered as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let io_lowered: u8 = unsafe { ::std::mem::transmute(io_lowered) };
            io_lowered as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let var_copies_lowered: u8 = unsafe { ::std::mem::transmute(var_copies_lowered) };
            var_copies_lowered as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let writes_memory: u8 = unsafe { ::std::mem::transmute(writes_memory) };
            writes_memory as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let layer_viewport_relative: u8 =
                unsafe { ::std::mem::transmute(layer_viewport_relative) };
            layer_viewport_relative as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let uses_control_barrier: u8 = unsafe { ::std::mem::transmute(uses_control_barrier) };
            uses_control_barrier as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let uses_memory_barrier: u8 = unsafe { ::std::mem::transmute(uses_memory_barrier) };
            uses_memory_barrier as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let uses_bindless: u8 = unsafe { ::std::mem::transmute(uses_bindless) };
            uses_bindless as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let shared_memory_explicit_layout: u8 =
                unsafe { ::std::mem::transmute(shared_memory_explicit_layout) };
            shared_memory_explicit_layout as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let zero_initialize_shared_memory: u8 =
                unsafe { ::std::mem::transmute(zero_initialize_shared_memory) };
            zero_initialize_shared_memory as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let workgroup_size_variable: u8 =
                unsafe { ::std::mem::transmute(workgroup_size_variable) };
            workgroup_size_variable as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let uses_printf: u8 = unsafe { ::std::mem::transmute(uses_printf) };
            uses_printf as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let maximally_reconverges: u8 = unsafe { ::std::mem::transmute(maximally_reconverges) };
            maximally_reconverges as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let use_aco_amd: u8 = unsafe { ::std::mem::transmute(use_aco_amd) };
            use_aco_amd as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn derivative_group(&self) -> gl_derivative_group {
        unsafe { ::std::mem::transmute(self._bitfield_4.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_derivative_group(&mut self, val: gl_derivative_group) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_4.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn derivative_group_raw(this: *const Self) -> gl_derivative_group {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_4),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_derivative_group_raw(this: *mut Self, val: gl_derivative_group) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_4),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_4(
        derivative_group: gl_derivative_group,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let derivative_group: u32 = unsafe { ::std::mem::transmute(derivative_group) };
            derivative_group as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct hash_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
    pub data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_entry"][::std::mem::size_of::<hash_entry>() - 12usize];
    ["Alignment of hash_entry"][::std::mem::align_of::<hash_entry>() - 4usize];
    ["Offset of field: hash_entry::hash"][::std::mem::offset_of!(hash_entry, hash) - 0usize];
    ["Offset of field: hash_entry::key"][::std::mem::offset_of!(hash_entry, key) - 4usize];
    ["Offset of field: hash_entry::data"][::std::mem::offset_of!(hash_entry, data) - 8usize];
};
impl Default for hash_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct hash_table {
    pub table: *mut hash_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub deleted_key: *const ::std::os::raw::c_void,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hash_table"][::std::mem::size_of::<hash_table>() - 56usize];
    ["Alignment of hash_table"][::std::mem::align_of::<hash_table>() - 4usize];
    ["Offset of field: hash_table::table"][::std::mem::offset_of!(hash_table, table) - 0usize];
    ["Offset of field: hash_table::key_hash_function"]
        [::std::mem::offset_of!(hash_table, key_hash_function) - 4usize];
    ["Offset of field: hash_table::key_equals_function"]
        [::std::mem::offset_of!(hash_table, key_equals_function) - 8usize];
    ["Offset of field: hash_table::deleted_key"]
        [::std::mem::offset_of!(hash_table, deleted_key) - 12usize];
    ["Offset of field: hash_table::size"][::std::mem::offset_of!(hash_table, size) - 16usize];
    ["Offset of field: hash_table::rehash"][::std::mem::offset_of!(hash_table, rehash) - 20usize];
    ["Offset of field: hash_table::size_magic"]
        [::std::mem::offset_of!(hash_table, size_magic) - 24usize];
    ["Offset of field: hash_table::rehash_magic"]
        [::std::mem::offset_of!(hash_table, rehash_magic) - 32usize];
    ["Offset of field: hash_table::max_entries"]
        [::std::mem::offset_of!(hash_table, max_entries) - 40usize];
    ["Offset of field: hash_table::size_index"]
        [::std::mem::offset_of!(hash_table, size_index) - 44usize];
    ["Offset of field: hash_table::entries"][::std::mem::offset_of!(hash_table, entries) - 48usize];
    ["Offset of field: hash_table::deleted_entries"]
        [::std::mem::offset_of!(hash_table, deleted_entries) - 52usize];
};
impl Default for hash_table {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct list_head {
    pub prev: *mut list_head,
    pub next: *mut list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of list_head"][::std::mem::size_of::<list_head>() - 8usize];
    ["Alignment of list_head"][::std::mem::align_of::<list_head>() - 4usize];
    ["Offset of field: list_head::prev"][::std::mem::offset_of!(list_head, prev) - 0usize];
    ["Offset of field: list_head::next"][::std::mem::offset_of!(list_head, next) - 4usize];
};
impl Default for list_head {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum mesa_log_level {
    MESA_LOG_ERROR = 0,
    MESA_LOG_WARN = 1,
    MESA_LOG_INFO = 2,
    MESA_LOG_DEBUG = 3,
}
unsafe extern "C" {
    pub fn mesa_log_get_file() -> *mut FILE;
}
unsafe extern "C" {
    pub fn mesa_log(
        arg1: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
unsafe extern "C" {
    pub fn mesa_log_v(
        arg1: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        va: va_list,
    );
}
unsafe extern "C" {
    pub fn mesa_log_if_debug(level: mesa_log_level, outputString: *const ::std::os::raw::c_char);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct log_stream {
    pub msg: *mut ::std::os::raw::c_char,
    pub tag: *const ::std::os::raw::c_char,
    pub pos: usize,
    pub level: mesa_log_level,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of log_stream"][::std::mem::size_of::<log_stream>() - 16usize];
    ["Alignment of log_stream"][::std::mem::align_of::<log_stream>() - 4usize];
    ["Offset of field: log_stream::msg"][::std::mem::offset_of!(log_stream, msg) - 0usize];
    ["Offset of field: log_stream::tag"][::std::mem::offset_of!(log_stream, tag) - 4usize];
    ["Offset of field: log_stream::pos"][::std::mem::offset_of!(log_stream, pos) - 8usize];
    ["Offset of field: log_stream::level"][::std::mem::offset_of!(log_stream, level) - 12usize];
};
impl Default for log_stream {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn mesa_log_stream_destroy(stream: *mut log_stream);
}
unsafe extern "C" {
    pub fn mesa_log_stream_printf(
        stream: *mut log_stream,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct set_entry {
    pub hash: u32,
    pub key: *const ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_entry"][::std::mem::size_of::<set_entry>() - 8usize];
    ["Alignment of set_entry"][::std::mem::align_of::<set_entry>() - 4usize];
    ["Offset of field: set_entry::hash"][::std::mem::offset_of!(set_entry, hash) - 0usize];
    ["Offset of field: set_entry::key"][::std::mem::offset_of!(set_entry, key) - 4usize];
};
impl Default for set_entry {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct set {
    pub mem_ctx: *mut ::std::os::raw::c_void,
    pub table: *mut set_entry,
    pub key_hash_function:
        ::std::option::Option<unsafe extern "C" fn(key: *const ::std::os::raw::c_void) -> u32>,
    pub key_equals_function: ::std::option::Option<
        unsafe extern "C" fn(
            a: *const ::std::os::raw::c_void,
            b: *const ::std::os::raw::c_void,
        ) -> bool,
    >,
    pub size: u32,
    pub rehash: u32,
    pub size_magic: u64,
    pub rehash_magic: u64,
    pub max_entries: u32,
    pub size_index: u32,
    pub entries: u32,
    pub deleted_entries: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set"][::std::mem::size_of::<set>() - 56usize];
    ["Alignment of set"][::std::mem::align_of::<set>() - 4usize];
    ["Offset of field: set::mem_ctx"][::std::mem::offset_of!(set, mem_ctx) - 0usize];
    ["Offset of field: set::table"][::std::mem::offset_of!(set, table) - 4usize];
    ["Offset of field: set::key_hash_function"]
        [::std::mem::offset_of!(set, key_hash_function) - 8usize];
    ["Offset of field: set::key_equals_function"]
        [::std::mem::offset_of!(set, key_equals_function) - 12usize];
    ["Offset of field: set::size"][::std::mem::offset_of!(set, size) - 16usize];
    ["Offset of field: set::rehash"][::std::mem::offset_of!(set, rehash) - 20usize];
    ["Offset of field: set::size_magic"][::std::mem::offset_of!(set, size_magic) - 24usize];
    ["Offset of field: set::rehash_magic"][::std::mem::offset_of!(set, rehash_magic) - 32usize];
    ["Offset of field: set::max_entries"][::std::mem::offset_of!(set, max_entries) - 40usize];
    ["Offset of field: set::size_index"][::std::mem::offset_of!(set, size_index) - 44usize];
    ["Offset of field: set::entries"][::std::mem::offset_of!(set, entries) - 48usize];
    ["Offset of field: set::deleted_entries"]
        [::std::mem::offset_of!(set, deleted_entries) - 52usize];
};
impl Default for set {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "u_minify__extern"]
    pub fn u_minify(
        value: ::std::os::raw::c_uint,
        levels: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct simple_mtx_t {
    pub val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of simple_mtx_t"][::std::mem::size_of::<simple_mtx_t>() - 4usize];
    ["Alignment of simple_mtx_t"][::std::mem::align_of::<simple_mtx_t>() - 4usize];
    ["Offset of field: simple_mtx_t::val"][::std::mem::offset_of!(simple_mtx_t, val) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct u_printf_info {
    pub num_args: ::std::os::raw::c_uint,
    pub arg_sizes: *mut ::std::os::raw::c_uint,
    pub string_size: ::std::os::raw::c_uint,
    pub strings: *mut ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of u_printf_info"][::std::mem::size_of::<u_printf_info>() - 16usize];
    ["Alignment of u_printf_info"][::std::mem::align_of::<u_printf_info>() - 4usize];
    ["Offset of field: u_printf_info::num_args"]
        [::std::mem::offset_of!(u_printf_info, num_args) - 0usize];
    ["Offset of field: u_printf_info::arg_sizes"]
        [::std::mem::offset_of!(u_printf_info, arg_sizes) - 4usize];
    ["Offset of field: u_printf_info::string_size"]
        [::std::mem::offset_of!(u_printf_info, string_size) - 8usize];
    ["Offset of field: u_printf_info::strings"]
        [::std::mem::offset_of!(u_printf_info, strings) - 12usize];
};
impl Default for u_printf_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn u_printf_serialize_info(
        blob: *mut blob,
        info: *const u_printf_info,
        printf_info_count: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn u_printf_deserialize_info(
        mem_ctx: *mut ::std::os::raw::c_void,
        blob: *mut blob_reader,
        printf_info_count: *mut ::std::os::raw::c_uint,
    ) -> *mut u_printf_info;
}
unsafe extern "C" {
    pub fn u_printf_hash(info: *const u_printf_info) -> u32;
}
unsafe extern "C" {
    pub fn u_printf_singleton_init_or_ref();
}
unsafe extern "C" {
    pub fn u_printf_singleton_decref();
}
unsafe extern "C" {
    pub fn u_printf_singleton_add(info: *const u_printf_info, count: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn u_printf_singleton_add_serialized(data: *const ::std::os::raw::c_void, data_size: usize);
}
unsafe extern "C" {
    pub fn u_printf_singleton_search(hash: u32) -> *const u_printf_info;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct u_printf_ctx {
    pub lock: simple_mtx_t,
    pub bo: *mut ::std::os::raw::c_void,
    pub map: *mut u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of u_printf_ctx"][::std::mem::size_of::<u_printf_ctx>() - 12usize];
    ["Alignment of u_printf_ctx"][::std::mem::align_of::<u_printf_ctx>() - 4usize];
    ["Offset of field: u_printf_ctx::lock"][::std::mem::offset_of!(u_printf_ctx, lock) - 0usize];
    ["Offset of field: u_printf_ctx::bo"][::std::mem::offset_of!(u_printf_ctx, bo) - 4usize];
    ["Offset of field: u_printf_ctx::map"][::std::mem::offset_of!(u_printf_ctx, map) - 8usize];
};
impl Default for u_printf_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn u_printf_length(fmt: *const ::std::os::raw::c_char, untouched_args: va_list) -> usize;
}
unsafe extern "C" {
    pub fn u_printf(
        out: *mut FILE,
        buffer: *const ::std::os::raw::c_char,
        buffer_size: usize,
        arg1: *const u_printf_info,
        info_size: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn u_printf_ptr(
        out: *mut FILE,
        buffer: *const ::std::os::raw::c_char,
        buffer_size: usize,
        info: *mut *const u_printf_info,
        info_size: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "u_printf_init__extern"]
    pub fn u_printf_init(ctx: *mut u_printf_ctx, bo: *mut ::std::os::raw::c_void, map: *mut u32);
}
unsafe extern "C" {
    #[link_name = "u_printf_destroy__extern"]
    pub fn u_printf_destroy(ctx: *mut u_printf_ctx);
}
unsafe extern "C" {
    #[link_name = "u_printf_with_ctx__extern"]
    pub fn u_printf_with_ctx(out: *mut FILE, ctx: *mut u_printf_ctx);
}
unsafe extern "C" {
    #[link_name = "u_printf_check_abort__extern"]
    pub fn u_printf_check_abort(out: *mut FILE, ctx: *mut u_printf_ctx) -> bool;
}
#[repr(u8)]
#[doc = " NIR sized and unsized types\n\n The values in this enum are carefully chosen so that the sized type is\n just the unsized type OR the number of bits."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_alu_type {
    nir_type_invalid = 0,
    nir_type_int = 2,
    nir_type_uint = 4,
    nir_type_bool = 6,
    nir_type_float = 128,
    nir_type_bool1 = 7,
    nir_type_bool8 = 14,
    nir_type_bool16 = 22,
    nir_type_bool32 = 38,
    nir_type_int1 = 3,
    nir_type_int8 = 10,
    nir_type_int16 = 18,
    nir_type_int32 = 34,
    nir_type_int64 = 66,
    nir_type_uint1 = 5,
    nir_type_uint8 = 12,
    nir_type_uint16 = 20,
    nir_type_uint32 = 36,
    nir_type_uint64 = 68,
    nir_type_float16 = 144,
    nir_type_float32 = 160,
    nir_type_float64 = 192,
}
unsafe extern "C" {
    #[link_name = "nir_alu_type_get_type_size__extern"]
    pub fn nir_alu_type_get_type_size(type_: nir_alu_type) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_alu_type_get_base_type__extern"]
    pub fn nir_alu_type_get_base_type(type_: nir_alu_type) -> nir_alu_type;
}
impl nir_op {
    pub const nir_last_opcode: nir_op = nir_op::nir_op_vec8;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_op {
    nir_op_alignbyte_amd = 0,
    nir_op_amul = 1,
    nir_op_andg_ir3 = 2,
    nir_op_b16all_fequal16 = 3,
    nir_op_b16all_fequal2 = 4,
    nir_op_b16all_fequal3 = 5,
    nir_op_b16all_fequal4 = 6,
    nir_op_b16all_fequal5 = 7,
    nir_op_b16all_fequal8 = 8,
    nir_op_b16all_iequal16 = 9,
    nir_op_b16all_iequal2 = 10,
    nir_op_b16all_iequal3 = 11,
    nir_op_b16all_iequal4 = 12,
    nir_op_b16all_iequal5 = 13,
    nir_op_b16all_iequal8 = 14,
    nir_op_b16any_fnequal16 = 15,
    nir_op_b16any_fnequal2 = 16,
    nir_op_b16any_fnequal3 = 17,
    nir_op_b16any_fnequal4 = 18,
    nir_op_b16any_fnequal5 = 19,
    nir_op_b16any_fnequal8 = 20,
    nir_op_b16any_inequal16 = 21,
    nir_op_b16any_inequal2 = 22,
    nir_op_b16any_inequal3 = 23,
    nir_op_b16any_inequal4 = 24,
    nir_op_b16any_inequal5 = 25,
    nir_op_b16any_inequal8 = 26,
    nir_op_b16csel = 27,
    nir_op_b2b1 = 28,
    nir_op_b2b16 = 29,
    nir_op_b2b32 = 30,
    nir_op_b2b8 = 31,
    nir_op_b2f16 = 32,
    nir_op_b2f32 = 33,
    nir_op_b2f64 = 34,
    nir_op_b2i1 = 35,
    nir_op_b2i16 = 36,
    nir_op_b2i32 = 37,
    nir_op_b2i64 = 38,
    nir_op_b2i8 = 39,
    nir_op_b32all_fequal16 = 40,
    nir_op_b32all_fequal2 = 41,
    nir_op_b32all_fequal3 = 42,
    nir_op_b32all_fequal4 = 43,
    nir_op_b32all_fequal5 = 44,
    nir_op_b32all_fequal8 = 45,
    nir_op_b32all_iequal16 = 46,
    nir_op_b32all_iequal2 = 47,
    nir_op_b32all_iequal3 = 48,
    nir_op_b32all_iequal4 = 49,
    nir_op_b32all_iequal5 = 50,
    nir_op_b32all_iequal8 = 51,
    nir_op_b32any_fnequal16 = 52,
    nir_op_b32any_fnequal2 = 53,
    nir_op_b32any_fnequal3 = 54,
    nir_op_b32any_fnequal4 = 55,
    nir_op_b32any_fnequal5 = 56,
    nir_op_b32any_fnequal8 = 57,
    nir_op_b32any_inequal16 = 58,
    nir_op_b32any_inequal2 = 59,
    nir_op_b32any_inequal3 = 60,
    nir_op_b32any_inequal4 = 61,
    nir_op_b32any_inequal5 = 62,
    nir_op_b32any_inequal8 = 63,
    nir_op_b32csel = 64,
    nir_op_b32fcsel_mdg = 65,
    nir_op_b8all_fequal16 = 66,
    nir_op_b8all_fequal2 = 67,
    nir_op_b8all_fequal3 = 68,
    nir_op_b8all_fequal4 = 69,
    nir_op_b8all_fequal5 = 70,
    nir_op_b8all_fequal8 = 71,
    nir_op_b8all_iequal16 = 72,
    nir_op_b8all_iequal2 = 73,
    nir_op_b8all_iequal3 = 74,
    nir_op_b8all_iequal4 = 75,
    nir_op_b8all_iequal5 = 76,
    nir_op_b8all_iequal8 = 77,
    nir_op_b8any_fnequal16 = 78,
    nir_op_b8any_fnequal2 = 79,
    nir_op_b8any_fnequal3 = 80,
    nir_op_b8any_fnequal4 = 81,
    nir_op_b8any_fnequal5 = 82,
    nir_op_b8any_fnequal8 = 83,
    nir_op_b8any_inequal16 = 84,
    nir_op_b8any_inequal2 = 85,
    nir_op_b8any_inequal3 = 86,
    nir_op_b8any_inequal4 = 87,
    nir_op_b8any_inequal5 = 88,
    nir_op_b8any_inequal8 = 89,
    nir_op_b8csel = 90,
    nir_op_ball_fequal16 = 91,
    nir_op_ball_fequal2 = 92,
    nir_op_ball_fequal3 = 93,
    nir_op_ball_fequal4 = 94,
    nir_op_ball_fequal5 = 95,
    nir_op_ball_fequal8 = 96,
    nir_op_ball_iequal16 = 97,
    nir_op_ball_iequal2 = 98,
    nir_op_ball_iequal3 = 99,
    nir_op_ball_iequal4 = 100,
    nir_op_ball_iequal5 = 101,
    nir_op_ball_iequal8 = 102,
    nir_op_bany_fnequal16 = 103,
    nir_op_bany_fnequal2 = 104,
    nir_op_bany_fnequal3 = 105,
    nir_op_bany_fnequal4 = 106,
    nir_op_bany_fnequal5 = 107,
    nir_op_bany_fnequal8 = 108,
    nir_op_bany_inequal16 = 109,
    nir_op_bany_inequal2 = 110,
    nir_op_bany_inequal3 = 111,
    nir_op_bany_inequal4 = 112,
    nir_op_bany_inequal5 = 113,
    nir_op_bany_inequal8 = 114,
    nir_op_bcsel = 115,
    nir_op_bfi = 116,
    nir_op_bfm = 117,
    nir_op_bit_count = 118,
    nir_op_bitfield_insert = 119,
    nir_op_bitfield_reverse = 120,
    nir_op_bitfield_select = 121,
    nir_op_bitnz = 122,
    nir_op_bitnz16 = 123,
    nir_op_bitnz32 = 124,
    nir_op_bitnz8 = 125,
    nir_op_bitz = 126,
    nir_op_bitz16 = 127,
    nir_op_bitz32 = 128,
    nir_op_bitz8 = 129,
    nir_op_bounds_agx = 130,
    nir_op_cube_amd = 131,
    nir_op_extr_agx = 132,
    nir_op_extract_i16 = 133,
    nir_op_extract_i8 = 134,
    nir_op_extract_u16 = 135,
    nir_op_extract_u8 = 136,
    nir_op_f2f16 = 137,
    nir_op_f2f16_rtne = 138,
    nir_op_f2f16_rtz = 139,
    nir_op_f2f32 = 140,
    nir_op_f2f64 = 141,
    nir_op_f2fmp = 142,
    nir_op_f2i1 = 143,
    nir_op_f2i16 = 144,
    nir_op_f2i32 = 145,
    nir_op_f2i64 = 146,
    nir_op_f2i8 = 147,
    nir_op_f2imp = 148,
    nir_op_f2snorm_16_v3d = 149,
    nir_op_f2u1 = 150,
    nir_op_f2u16 = 151,
    nir_op_f2u32 = 152,
    nir_op_f2u64 = 153,
    nir_op_f2u8 = 154,
    nir_op_f2ump = 155,
    nir_op_f2unorm_16_v3d = 156,
    nir_op_fabs = 157,
    nir_op_fadd = 158,
    nir_op_fall_equal16 = 159,
    nir_op_fall_equal2 = 160,
    nir_op_fall_equal3 = 161,
    nir_op_fall_equal4 = 162,
    nir_op_fall_equal5 = 163,
    nir_op_fall_equal8 = 164,
    nir_op_fany_nequal16 = 165,
    nir_op_fany_nequal2 = 166,
    nir_op_fany_nequal3 = 167,
    nir_op_fany_nequal4 = 168,
    nir_op_fany_nequal5 = 169,
    nir_op_fany_nequal8 = 170,
    nir_op_fceil = 171,
    nir_op_fclamp_pos = 172,
    nir_op_fcos = 173,
    nir_op_fcos_amd = 174,
    nir_op_fcos_mdg = 175,
    nir_op_fcsel = 176,
    nir_op_fcsel_ge = 177,
    nir_op_fcsel_gt = 178,
    nir_op_fdiv = 179,
    nir_op_fdot16 = 180,
    nir_op_fdot16_replicated = 181,
    nir_op_fdot2 = 182,
    nir_op_fdot2_replicated = 183,
    nir_op_fdot3 = 184,
    nir_op_fdot3_replicated = 185,
    nir_op_fdot4 = 186,
    nir_op_fdot4_replicated = 187,
    nir_op_fdot5 = 188,
    nir_op_fdot5_replicated = 189,
    nir_op_fdot8 = 190,
    nir_op_fdot8_replicated = 191,
    nir_op_fdph = 192,
    nir_op_fdph_replicated = 193,
    nir_op_feq = 194,
    nir_op_feq16 = 195,
    nir_op_feq32 = 196,
    nir_op_feq8 = 197,
    nir_op_fequ = 198,
    nir_op_fequ16 = 199,
    nir_op_fequ32 = 200,
    nir_op_fequ8 = 201,
    nir_op_fexp2 = 202,
    nir_op_ffloor = 203,
    nir_op_ffma = 204,
    nir_op_ffmaz = 205,
    nir_op_ffract = 206,
    nir_op_fge = 207,
    nir_op_fge16 = 208,
    nir_op_fge32 = 209,
    nir_op_fge8 = 210,
    nir_op_fgeu = 211,
    nir_op_fgeu16 = 212,
    nir_op_fgeu32 = 213,
    nir_op_fgeu8 = 214,
    nir_op_find_lsb = 215,
    nir_op_fisfinite = 216,
    nir_op_fisfinite32 = 217,
    nir_op_fisnormal = 218,
    nir_op_flog2 = 219,
    nir_op_flrp = 220,
    nir_op_flt = 221,
    nir_op_flt16 = 222,
    nir_op_flt32 = 223,
    nir_op_flt8 = 224,
    nir_op_fltu = 225,
    nir_op_fltu16 = 226,
    nir_op_fltu32 = 227,
    nir_op_fltu8 = 228,
    nir_op_fmax = 229,
    nir_op_fmax_agx = 230,
    nir_op_fmin = 231,
    nir_op_fmin_agx = 232,
    nir_op_fmod = 233,
    nir_op_fmul = 234,
    nir_op_fmulz = 235,
    nir_op_fneg = 236,
    nir_op_fneo = 237,
    nir_op_fneo16 = 238,
    nir_op_fneo32 = 239,
    nir_op_fneo8 = 240,
    nir_op_fneu = 241,
    nir_op_fneu16 = 242,
    nir_op_fneu32 = 243,
    nir_op_fneu8 = 244,
    nir_op_ford = 245,
    nir_op_ford16 = 246,
    nir_op_ford32 = 247,
    nir_op_ford8 = 248,
    nir_op_fpow = 249,
    nir_op_fquantize2f16 = 250,
    nir_op_frcp = 251,
    nir_op_frem = 252,
    nir_op_frexp_exp = 253,
    nir_op_frexp_sig = 254,
    nir_op_fround_even = 255,
    nir_op_frsq = 256,
    nir_op_fsat = 257,
    nir_op_fsat_signed = 258,
    nir_op_fsign = 259,
    nir_op_fsin = 260,
    nir_op_fsin_agx = 261,
    nir_op_fsin_amd = 262,
    nir_op_fsin_mdg = 263,
    nir_op_fsqrt = 264,
    nir_op_fsub = 265,
    nir_op_fsum2 = 266,
    nir_op_fsum3 = 267,
    nir_op_fsum4 = 268,
    nir_op_ftrunc = 269,
    nir_op_funord = 270,
    nir_op_funord16 = 271,
    nir_op_funord32 = 272,
    nir_op_funord8 = 273,
    nir_op_i2f16 = 274,
    nir_op_i2f32 = 275,
    nir_op_i2f64 = 276,
    nir_op_i2fmp = 277,
    nir_op_i2i1 = 278,
    nir_op_i2i16 = 279,
    nir_op_i2i32 = 280,
    nir_op_i2i64 = 281,
    nir_op_i2i8 = 282,
    nir_op_i2imp = 283,
    nir_op_i32csel_ge = 284,
    nir_op_i32csel_gt = 285,
    nir_op_iabs = 286,
    nir_op_iadd = 287,
    nir_op_iadd3 = 288,
    nir_op_iadd_sat = 289,
    nir_op_iand = 290,
    nir_op_ibfe = 291,
    nir_op_ibitfield_extract = 292,
    nir_op_icsel_eqz = 293,
    nir_op_idiv = 294,
    nir_op_ieq = 295,
    nir_op_ieq16 = 296,
    nir_op_ieq32 = 297,
    nir_op_ieq8 = 298,
    nir_op_ifind_msb = 299,
    nir_op_ifind_msb_rev = 300,
    nir_op_ige = 301,
    nir_op_ige16 = 302,
    nir_op_ige32 = 303,
    nir_op_ige8 = 304,
    nir_op_ihadd = 305,
    nir_op_ilea_agx = 306,
    nir_op_ilt = 307,
    nir_op_ilt16 = 308,
    nir_op_ilt32 = 309,
    nir_op_ilt8 = 310,
    nir_op_imad = 311,
    nir_op_imad24_ir3 = 312,
    nir_op_imadsh_mix16 = 313,
    nir_op_imadshl_agx = 314,
    nir_op_imax = 315,
    nir_op_imin = 316,
    nir_op_imod = 317,
    nir_op_imsubshl_agx = 318,
    nir_op_imul = 319,
    nir_op_imul24 = 320,
    nir_op_imul24_relaxed = 321,
    nir_op_imul_2x32_64 = 322,
    nir_op_imul_32x16 = 323,
    nir_op_imul_high = 324,
    nir_op_ine = 325,
    nir_op_ine16 = 326,
    nir_op_ine32 = 327,
    nir_op_ine8 = 328,
    nir_op_ineg = 329,
    nir_op_inot = 330,
    nir_op_insert_u16 = 331,
    nir_op_insert_u8 = 332,
    nir_op_interleave_agx = 333,
    nir_op_ior = 334,
    nir_op_irem = 335,
    nir_op_irhadd = 336,
    nir_op_ishl = 337,
    nir_op_ishr = 338,
    nir_op_isign = 339,
    nir_op_isub = 340,
    nir_op_isub_sat = 341,
    nir_op_ixor = 342,
    nir_op_ldexp = 343,
    nir_op_mov = 344,
    nir_op_mqsad_4x8 = 345,
    nir_op_msad_4x8 = 346,
    nir_op_pack_2x16_to_snorm_2x8_v3d = 347,
    nir_op_pack_2x16_to_unorm_10_2_v3d = 348,
    nir_op_pack_2x16_to_unorm_2x10_v3d = 349,
    nir_op_pack_2x16_to_unorm_2x8_v3d = 350,
    nir_op_pack_2x32_to_2x16_v3d = 351,
    nir_op_pack_32_2x16 = 352,
    nir_op_pack_32_2x16_split = 353,
    nir_op_pack_32_4x8 = 354,
    nir_op_pack_32_4x8_split = 355,
    nir_op_pack_32_to_r11g11b10_v3d = 356,
    nir_op_pack_4x16_to_4x8_v3d = 357,
    nir_op_pack_64_2x32 = 358,
    nir_op_pack_64_2x32_split = 359,
    nir_op_pack_64_4x16 = 360,
    nir_op_pack_double_2x32_dxil = 361,
    nir_op_pack_half_2x16 = 362,
    nir_op_pack_half_2x16_rtz_split = 363,
    nir_op_pack_half_2x16_split = 364,
    nir_op_pack_sint_2x16 = 365,
    nir_op_pack_snorm_2x16 = 366,
    nir_op_pack_snorm_4x8 = 367,
    nir_op_pack_uint_2x16 = 368,
    nir_op_pack_uint_32_to_r10g10b10a2_v3d = 369,
    nir_op_pack_unorm_2x16 = 370,
    nir_op_pack_unorm_4x8 = 371,
    nir_op_pack_uvec2_to_uint = 372,
    nir_op_pack_uvec4_to_uint = 373,
    nir_op_prmt_nv = 374,
    nir_op_sdot_2x16_iadd = 375,
    nir_op_sdot_2x16_iadd_sat = 376,
    nir_op_sdot_4x8_iadd = 377,
    nir_op_sdot_4x8_iadd_sat = 378,
    nir_op_seq = 379,
    nir_op_sge = 380,
    nir_op_shfr = 381,
    nir_op_shlg_ir3 = 382,
    nir_op_shlm_ir3 = 383,
    nir_op_shrg_ir3 = 384,
    nir_op_shrm_ir3 = 385,
    nir_op_slt = 386,
    nir_op_sne = 387,
    nir_op_sudot_4x8_iadd = 388,
    nir_op_sudot_4x8_iadd_sat = 389,
    nir_op_u2f16 = 390,
    nir_op_u2f32 = 391,
    nir_op_u2f64 = 392,
    nir_op_u2fmp = 393,
    nir_op_u2u1 = 394,
    nir_op_u2u16 = 395,
    nir_op_u2u32 = 396,
    nir_op_u2u64 = 397,
    nir_op_u2u8 = 398,
    nir_op_uabs_isub = 399,
    nir_op_uabs_usub = 400,
    nir_op_uadd_carry = 401,
    nir_op_uadd_sat = 402,
    nir_op_ubfe = 403,
    nir_op_ubitfield_extract = 404,
    nir_op_uclz = 405,
    nir_op_udiv = 406,
    nir_op_udiv_aligned_4 = 407,
    nir_op_udot_2x16_uadd = 408,
    nir_op_udot_2x16_uadd_sat = 409,
    nir_op_udot_4x8_uadd = 410,
    nir_op_udot_4x8_uadd_sat = 411,
    nir_op_ufind_msb = 412,
    nir_op_ufind_msb_rev = 413,
    nir_op_uge = 414,
    nir_op_uge16 = 415,
    nir_op_uge32 = 416,
    nir_op_uge8 = 417,
    nir_op_uhadd = 418,
    nir_op_ulea_agx = 419,
    nir_op_ult = 420,
    nir_op_ult16 = 421,
    nir_op_ult32 = 422,
    nir_op_ult8 = 423,
    nir_op_umad24 = 424,
    nir_op_umad24_relaxed = 425,
    nir_op_umax = 426,
    nir_op_umax_4x8_vc4 = 427,
    nir_op_umin = 428,
    nir_op_umin_4x8_vc4 = 429,
    nir_op_umod = 430,
    nir_op_umul24 = 431,
    nir_op_umul24_relaxed = 432,
    nir_op_umul_2x32_64 = 433,
    nir_op_umul_32x16 = 434,
    nir_op_umul_high = 435,
    nir_op_umul_low = 436,
    nir_op_umul_unorm_4x8_vc4 = 437,
    nir_op_unpack_32_2x16 = 438,
    nir_op_unpack_32_2x16_split_x = 439,
    nir_op_unpack_32_2x16_split_y = 440,
    nir_op_unpack_32_4x8 = 441,
    nir_op_unpack_64_2x32 = 442,
    nir_op_unpack_64_2x32_split_x = 443,
    nir_op_unpack_64_2x32_split_y = 444,
    nir_op_unpack_64_4x16 = 445,
    nir_op_unpack_double_2x32_dxil = 446,
    nir_op_unpack_half_2x16 = 447,
    nir_op_unpack_half_2x16_split_x = 448,
    nir_op_unpack_half_2x16_split_y = 449,
    nir_op_unpack_snorm_2x16 = 450,
    nir_op_unpack_snorm_4x8 = 451,
    nir_op_unpack_unorm_2x16 = 452,
    nir_op_unpack_unorm_4x8 = 453,
    nir_op_urhadd = 454,
    nir_op_urol = 455,
    nir_op_uror = 456,
    nir_op_usadd_4x8_vc4 = 457,
    nir_op_ushr = 458,
    nir_op_ussub_4x8_vc4 = 459,
    nir_op_usub_borrow = 460,
    nir_op_usub_sat = 461,
    nir_op_vec16 = 462,
    nir_op_vec2 = 463,
    nir_op_vec3 = 464,
    nir_op_vec4 = 465,
    nir_op_vec5 = 466,
    nir_op_vec8 = 467,
    nir_num_opcodes = 468,
}
unsafe extern "C" {
    pub static mut nir_debug: u32;
}
pub type nir_component_mask_t = u16;
unsafe extern "C" {
    #[link_name = "nir_num_components_valid__extern"]
    pub fn nir_num_components_valid(num_components: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_round_up_components__extern"]
    pub fn nir_round_up_components(n: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_component_mask__extern"]
    pub fn nir_component_mask(num_components: ::std::os::raw::c_uint) -> nir_component_mask_t;
}
unsafe extern "C" {
    pub fn nir_process_debug_variable();
}
unsafe extern "C" {
    pub fn nir_component_mask_can_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_component_mask_reinterpret(
        mask: nir_component_mask_t,
        old_bit_size: ::std::os::raw::c_uint,
        new_bit_size: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_builder {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_xfb_info {
    _unused: [u8; 0],
}
#[doc = " Description of built-in state associated with a uniform\n\n :c:member:`nir_variable.state_slots`"]
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_state_slot {
    pub tokens: [gl_state_index16; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_state_slot"][::std::mem::size_of::<nir_state_slot>() - 8usize];
    ["Alignment of nir_state_slot"][::std::mem::align_of::<nir_state_slot>() - 2usize];
    ["Offset of field: nir_state_slot::tokens"]
        [::std::mem::offset_of!(nir_state_slot, tokens) - 0usize];
};
impl nir_variable_mode {
    pub const nir_var_system_value: nir_variable_mode = nir_variable_mode(1);
}
impl nir_variable_mode {
    pub const nir_var_uniform: nir_variable_mode = nir_variable_mode(2);
}
impl nir_variable_mode {
    pub const nir_var_shader_in: nir_variable_mode = nir_variable_mode(4);
}
impl nir_variable_mode {
    pub const nir_var_shader_out: nir_variable_mode = nir_variable_mode(8);
}
impl nir_variable_mode {
    pub const nir_var_image: nir_variable_mode = nir_variable_mode(16);
}
impl nir_variable_mode {
    #[doc = " Incoming call or ray payload data for ray-tracing shaders"]
    pub const nir_var_shader_call_data: nir_variable_mode = nir_variable_mode(32);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_ray_hit_attrib: nir_variable_mode = nir_variable_mode(64);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_ubo: nir_variable_mode = nir_variable_mode(128);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_push_const: nir_variable_mode = nir_variable_mode(256);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_ssbo: nir_variable_mode = nir_variable_mode(512);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_constant: nir_variable_mode = nir_variable_mode(1024);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_task_payload: nir_variable_mode = nir_variable_mode(2048);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_node_payload: nir_variable_mode = nir_variable_mode(4096);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_node_payload_in: nir_variable_mode = nir_variable_mode(8192);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_function_in: nir_variable_mode = nir_variable_mode(16384);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_function_out: nir_variable_mode = nir_variable_mode(32768);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_function_inout: nir_variable_mode = nir_variable_mode(65536);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_shader_temp: nir_variable_mode = nir_variable_mode(131072);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_function_temp: nir_variable_mode = nir_variable_mode(262144);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_shared: nir_variable_mode = nir_variable_mode(524288);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_global: nir_variable_mode = nir_variable_mode(1048576);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_mem_generic: nir_variable_mode = nir_variable_mode(1966080);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_read_only_modes: nir_variable_mode = nir_variable_mode(1159);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_vec_indexable_modes: nir_variable_mode = nir_variable_mode(1969033);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_num_variable_modes: nir_variable_mode = nir_variable_mode(21);
}
impl nir_variable_mode {
    #[doc = " Ray hit attributes"]
    pub const nir_var_all: nir_variable_mode = nir_variable_mode(2097151);
}
impl ::std::ops::BitOr<nir_variable_mode> for nir_variable_mode {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_variable_mode(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_variable_mode {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_variable_mode) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_variable_mode> for nir_variable_mode {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_variable_mode(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_variable_mode {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_variable_mode) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_mode(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[doc = " Rounding modes."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_rounding_mode {
    nir_rounding_mode_undef = 0,
    nir_rounding_mode_rtne = 1,
    nir_rounding_mode_ru = 2,
    nir_rounding_mode_rd = 3,
    nir_rounding_mode_rtz = 4,
}
#[repr(u32)]
#[doc = " Ray query values that can read from a RayQueryKHR object."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_ray_query_value {
    nir_ray_query_value_intersection_type = 0,
    nir_ray_query_value_intersection_t = 1,
    nir_ray_query_value_intersection_instance_custom_index = 2,
    nir_ray_query_value_intersection_instance_id = 3,
    nir_ray_query_value_intersection_instance_sbt_index = 4,
    nir_ray_query_value_intersection_geometry_index = 5,
    nir_ray_query_value_intersection_primitive_index = 6,
    nir_ray_query_value_intersection_barycentrics = 7,
    nir_ray_query_value_intersection_front_face = 8,
    nir_ray_query_value_intersection_object_ray_direction = 9,
    nir_ray_query_value_intersection_object_ray_origin = 10,
    nir_ray_query_value_intersection_object_to_world = 11,
    nir_ray_query_value_intersection_world_to_object = 12,
    nir_ray_query_value_intersection_candidate_aabb_opaque = 13,
    nir_ray_query_value_tmin = 14,
    nir_ray_query_value_flags = 15,
    nir_ray_query_value_world_ray_direction = 16,
    nir_ray_query_value_world_ray_origin = 17,
    nir_ray_query_value_intersection_triangle_vertex_positions = 18,
}
#[repr(u32)]
#[doc = " Intel resource flags"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_resource_data_intel {
    nir_resource_intel_bindless = 1,
    nir_resource_intel_pushable = 2,
    nir_resource_intel_sampler = 4,
    nir_resource_intel_non_uniform = 8,
    nir_resource_intel_sampler_embedded = 16,
}
#[repr(u32)]
#[doc = " Which components to interpret as signed in cmat_muladd.\n See 'Cooperative Matrix Operands' in SPV_KHR_cooperative_matrix."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_cmat_signed {
    NIR_CMAT_A_SIGNED = 1,
    NIR_CMAT_B_SIGNED = 2,
    NIR_CMAT_C_SIGNED = 4,
    NIR_CMAT_RESULT_SIGNED = 8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_const_value {
    pub b: bool,
    pub f32_: ::std::os::raw::c_float,
    pub f64_: ::std::os::raw::c_double,
    pub i8_: i8,
    pub u8_: u8,
    pub i16_: i16,
    pub u16_: u16,
    pub i32_: i32,
    pub u32_: u32,
    pub i64_: i64,
    pub u64_: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_const_value"][::std::mem::size_of::<nir_const_value>() - 8usize];
    ["Alignment of nir_const_value"][::std::mem::align_of::<nir_const_value>() - 4usize];
    ["Offset of field: nir_const_value::b"][::std::mem::offset_of!(nir_const_value, b) - 0usize];
    ["Offset of field: nir_const_value::f32_"]
        [::std::mem::offset_of!(nir_const_value, f32_) - 0usize];
    ["Offset of field: nir_const_value::f64_"]
        [::std::mem::offset_of!(nir_const_value, f64_) - 0usize];
    ["Offset of field: nir_const_value::i8_"]
        [::std::mem::offset_of!(nir_const_value, i8_) - 0usize];
    ["Offset of field: nir_const_value::u8_"]
        [::std::mem::offset_of!(nir_const_value, u8_) - 0usize];
    ["Offset of field: nir_const_value::i16_"]
        [::std::mem::offset_of!(nir_const_value, i16_) - 0usize];
    ["Offset of field: nir_const_value::u16_"]
        [::std::mem::offset_of!(nir_const_value, u16_) - 0usize];
    ["Offset of field: nir_const_value::i32_"]
        [::std::mem::offset_of!(nir_const_value, i32_) - 0usize];
    ["Offset of field: nir_const_value::u32_"]
        [::std::mem::offset_of!(nir_const_value, u32_) - 0usize];
    ["Offset of field: nir_const_value::i64_"]
        [::std::mem::offset_of!(nir_const_value, i64_) - 0usize];
    ["Offset of field: nir_const_value::u64_"]
        [::std::mem::offset_of!(nir_const_value, u64_) - 0usize];
};
impl Default for nir_const_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_const_value_for_raw_uint__extern"]
    pub fn nir_const_value_for_raw_uint(
        x: u64,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_for_int__extern"]
    pub fn nir_const_value_for_int(i: i64, bit_size: ::std::os::raw::c_uint) -> nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_for_uint__extern"]
    pub fn nir_const_value_for_uint(u: u64, bit_size: ::std::os::raw::c_uint) -> nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_for_bool__extern"]
    pub fn nir_const_value_for_bool(b: bool, bit_size: ::std::os::raw::c_uint) -> nir_const_value;
}
unsafe extern "C" {
    pub fn nir_const_value_for_float(
        b: ::std::os::raw::c_double,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_as_int__extern"]
    pub fn nir_const_value_as_int(value: nir_const_value, bit_size: ::std::os::raw::c_uint) -> i64;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_as_uint__extern"]
    pub fn nir_const_value_as_uint(value: nir_const_value, bit_size: ::std::os::raw::c_uint)
        -> u64;
}
unsafe extern "C" {
    #[link_name = "nir_const_value_as_bool__extern"]
    pub fn nir_const_value_as_bool(
        value: nir_const_value,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_const_value_as_float(
        value: nir_const_value,
        bit_size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_double;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_constant {
    #[doc = " Value of the constant.\n\n The field used to back the values supplied by the constant is determined\n by the type associated with the ``nir_variable``.  Constants may be\n scalars, vectors, or matrices."]
    pub values: [nir_const_value; 16usize],
    pub is_null_constant: bool,
    pub num_elements: ::std::os::raw::c_uint,
    pub elements: *mut *mut nir_constant,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_constant"][::std::mem::size_of::<nir_constant>() - 140usize];
    ["Alignment of nir_constant"][::std::mem::align_of::<nir_constant>() - 4usize];
    ["Offset of field: nir_constant::values"]
        [::std::mem::offset_of!(nir_constant, values) - 0usize];
    ["Offset of field: nir_constant::is_null_constant"]
        [::std::mem::offset_of!(nir_constant, is_null_constant) - 128usize];
    ["Offset of field: nir_constant::num_elements"]
        [::std::mem::offset_of!(nir_constant, num_elements) - 132usize];
    ["Offset of field: nir_constant::elements"]
        [::std::mem::offset_of!(nir_constant, elements) - 136usize];
};
impl Default for nir_constant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Either a uniform, global variable, shader input, or shader output. Based on\n ir_variable - it should be easy to translate between the two."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable {
    pub node: exec_node,
    #[doc = " Declared type of the variable"]
    pub type_: *const glsl_type,
    #[doc = " Declared name of the variable"]
    pub name: *mut ::std::os::raw::c_char,
    pub data: nir_variable_nir_variable_data,
    #[doc = " Identifier for this variable generated by nir_index_vars() that is unique\n among other variables in the same exec_list."]
    pub index: ::std::os::raw::c_uint,
    pub num_members: u16,
    #[doc = " For variables with non NULL interface_type, this points to an array of\n integers such that if the ith member of the interface block is an array,\n max_ifc_array_access[i] is the maximum array element of that member that\n has been accessed.  If the ith member of the interface block is not an\n array, max_ifc_array_access[i] is unused.\n\n For variables whose type is not an interface block, this pointer is\n NULL."]
    pub max_ifc_array_access: *mut ::std::os::raw::c_int,
    #[doc = " Built-in state that backs this uniform\n\n Once set at variable creation, ``state_slots`` must remain invariant.\n This is because, ideally, this array would be shared by all clones of\n this variable in the IR tree.  In other words, we'd really like for it\n to be a fly-weight.\n\n If the variable is not a uniform, ``num_state_slots`` will be zero and\n ``state_slots`` will be ``NULL``.\n\n Number of state slots used."]
    pub num_state_slots: u16,
    #[doc = " State descriptors."]
    pub state_slots: *mut nir_state_slot,
    #[doc = " Constant expression assigned in the initializer of the variable\n\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub constant_initializer: *mut nir_constant,
    #[doc = " Global variable assigned in the initializer of the variable\n This field should only be used temporarily by creators of NIR shaders\n and then nir_lower_variable_initializers can be used to get rid of them.\n Most of the rest of NIR ignores this field or asserts that it's NULL."]
    pub pointer_initializer: *mut nir_variable,
    #[doc = " For variables that are in an interface block or are an instance of an\n interface block, this is the ``GLSL_TYPE_INTERFACE`` type for that block.\n\n ``ir_variable.location``"]
    pub interface_type: *const glsl_type,
    #[doc = " Description of per-member data for per-member struct variables\n\n This is used for variables which are actually an amalgamation of\n multiple entities such as a struct of built-in values or a struct of\n inputs each with their own layout specifier.  This is only allowed on\n variables with a struct or array of array of struct type."]
    pub members: *mut nir_variable_nir_variable_data,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_variable_nir_variable_data {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " Highest element accessed with a constant array index\n\n Not used for non-array variables. -1 is never accessed."]
    pub max_array_access: ::std::os::raw::c_int,
    pub _bitfield_align_2: [u16; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 6usize]>,
    #[doc = " Output index for dual source blending or input attachment index. If\n it is not declared it is NIR_VARIABLE_NO_INDEX."]
    pub index: ::std::os::raw::c_uint,
    #[doc = " Initial binding point for a sampler or UBO.\n\n For array types, this represents the binding point for the first element."]
    pub binding: ::std::os::raw::c_uint,
    #[doc = " Storage location of the base of this variable\n\n The precise meaning of this field depends on the nature of the variable.\n\n   - Vertex shader input: one of the values from ``gl_vert_attrib``.\n   - Vertex shader output: one of the values from ``gl_varying_slot``.\n   - Geometry shader input: one of the values from ``gl_varying_slot``.\n   - Geometry shader output: one of the values from ``gl_varying_slot``.\n   - Fragment shader input: one of the values from ``gl_varying_slot``.\n   - Fragment shader output: one of the values from ``gl_frag_result``.\n   - Task shader output: one of the values from ``gl_varying_slot``.\n   - Mesh shader input: one of the values from ``gl_varying_slot``.\n   - Mesh shader output: one of the values from ``gl_varying_slot``.\n   - Uniforms: Per-stage uniform slot number for default uniform block.\n   - Uniforms: Index within the uniform block definition for UBO members.\n   - Non-UBO Uniforms: uniform slot number.\n   - Other: This field is not currently used.\n\n If the variable is a uniform, shader input, or shader output, and the\n slot has not been assigned, the value will be -1."]
    pub location: ::std::os::raw::c_int,
    #[doc = " Required alignment of this variable"]
    pub alignment: ::std::os::raw::c_uint,
    #[doc = " The actual location of the variable in the IR. Only valid for inputs,\n outputs, uniforms (including samplers and images), and for UBO and SSBO\n variables in GLSL."]
    pub driver_location: ::std::os::raw::c_uint,
    #[doc = " Location an atomic counter or transform feedback is stored at."]
    pub offset: ::std::os::raw::c_uint,
    pub anon_1: nir_variable_nir_variable_data__bindgen_ty_1,
    #[doc = " Name of the node this payload will be enqueued to."]
    pub node_name: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_variable_nir_variable_data__bindgen_ty_1 {
    pub image: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    pub sampler: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2,
    pub xfb: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    #[doc = " Image internal format if specified explicitly, otherwise PIPE_FORMAT_NONE."]
    pub format: pipe_format,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1"][::std::mem::size_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    >() - 4usize];
    ["Alignment of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1"][::std::mem::align_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
    >() - 4usize];
    ["Offset of field: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1::format"][::std::mem::offset_of!(
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1,
        format
    )
        - 0usize];
};
impl Default for nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2"][::std::mem::size_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2,
    >() - 4usize];
    ["Alignment of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2"][::std::mem::align_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2,
    >() - 4usize];
};
impl nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_2 {
    #[inline]
    pub fn is_inline_sampler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_inline_sampler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_inline_sampler_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_inline_sampler_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn addressing_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_addressing_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn addressing_mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_addressing_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn normalized_coordinates(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_normalized_coordinates(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn normalized_coordinates_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_normalized_coordinates_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn filter_mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_filter_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn filter_mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_filter_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_inline_sampler: ::std::os::raw::c_uint,
        addressing_mode: ::std::os::raw::c_uint,
        normalized_coordinates: ::std::os::raw::c_uint,
        filter_mode: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_inline_sampler: u32 = unsafe { ::std::mem::transmute(is_inline_sampler) };
            is_inline_sampler as u64
        });
        __bindgen_bitfield_unit.set(1usize, 3u8, {
            let addressing_mode: u32 = unsafe { ::std::mem::transmute(addressing_mode) };
            addressing_mode as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let normalized_coordinates: u32 =
                unsafe { ::std::mem::transmute(normalized_coordinates) };
            normalized_coordinates as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let filter_mode: u32 = unsafe { ::std::mem::transmute(filter_mode) };
            filter_mode as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Transform feedback stride."]
    pub stride: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3"][::std::mem::size_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
    >() - 4usize];
    ["Alignment of nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3"][::std::mem::align_of::<
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
    >() - 2usize];
    ["Offset of field: nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3::stride"][::std::mem::offset_of!(
        nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3,
        stride
    )
        - 2usize];
};
impl nir_variable_nir_variable_data__bindgen_ty_1__bindgen_ty_3 {
    #[inline]
    pub fn buffer(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_buffer(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn buffer_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_buffer_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(buffer: u16) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let buffer: u16 = unsafe { ::std::mem::transmute(buffer) };
            buffer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_nir_variable_data__bindgen_ty_1"]
        [::std::mem::size_of::<nir_variable_nir_variable_data__bindgen_ty_1>() - 4usize];
    ["Alignment of nir_variable_nir_variable_data__bindgen_ty_1"]
        [::std::mem::align_of::<nir_variable_nir_variable_data__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_variable_nir_variable_data__bindgen_ty_1::image"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data__bindgen_ty_1, image) - 0usize];
    ["Offset of field: nir_variable_nir_variable_data__bindgen_ty_1::sampler"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data__bindgen_ty_1, sampler) - 0usize];
    ["Offset of field: nir_variable_nir_variable_data__bindgen_ty_1::xfb"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data__bindgen_ty_1, xfb) - 0usize];
};
impl Default for nir_variable_nir_variable_data__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable_nir_variable_data"]
        [::std::mem::size_of::<nir_variable_nir_variable_data>() - 52usize];
    ["Alignment of nir_variable_nir_variable_data"]
        [::std::mem::align_of::<nir_variable_nir_variable_data>() - 4usize];
    ["Offset of field: nir_variable_nir_variable_data::max_array_access"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, max_array_access) - 8usize];
    ["Offset of field: nir_variable_nir_variable_data::index"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, index) - 20usize];
    ["Offset of field: nir_variable_nir_variable_data::binding"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, binding) - 24usize];
    ["Offset of field: nir_variable_nir_variable_data::location"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, location) - 28usize];
    ["Offset of field: nir_variable_nir_variable_data::alignment"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, alignment) - 32usize];
    ["Offset of field: nir_variable_nir_variable_data::driver_location"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, driver_location) - 36usize];
    ["Offset of field: nir_variable_nir_variable_data::offset"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, offset) - 40usize];
    ["Offset of field: nir_variable_nir_variable_data::node_name"]
        [::std::mem::offset_of!(nir_variable_nir_variable_data, node_name) - 48usize];
};
impl Default for nir_variable_nir_variable_data {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_variable_nir_variable_data {
    #[inline]
    pub fn mode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 21u8) as u32) }
    }
    #[inline]
    pub fn set_mode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 21u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mode_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                21u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mode_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                21u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn read_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn read_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_read_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn centroid(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_centroid(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn centroid_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_centroid_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sample(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sample_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sample_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn patch(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_patch(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn patch_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_patch_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn invariant_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_invariant_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_invariant_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_invariant_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ray_query(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ray_query(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ray_query_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_ray_query_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn assigned(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_assigned(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn assigned_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_assigned_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn cannot_coalesce(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cannot_coalesce(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn cannot_coalesce_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_cannot_coalesce_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn always_active_io(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_always_active_io(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn always_active_io_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                32usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_always_active_io_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                32usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interpolation(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(33usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_interpolation(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(33usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interpolation_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                33usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interpolation_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                33usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn location_frac(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(36usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_location_frac(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(36usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn location_frac_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                36usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_location_frac_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                36usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn compact(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(38usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_compact(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(38usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn compact_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                38usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_compact_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                38usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(39usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(39usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                39usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                39usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn bindless(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(40usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bindless(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(40usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn bindless_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                40usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_bindless_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                40usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_binding(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(41usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_binding(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(41usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_binding_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                41usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_binding_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                41usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_location(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(42usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_location(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(42usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_location_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                42usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_location_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                42usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn implicit_sized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(43usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_sized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(43usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn implicit_sized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                43usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_implicit_sized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                43usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mode: ::std::os::raw::c_uint,
        read_only: ::std::os::raw::c_uint,
        centroid: ::std::os::raw::c_uint,
        sample: ::std::os::raw::c_uint,
        patch: ::std::os::raw::c_uint,
        invariant: ::std::os::raw::c_uint,
        explicit_invariant: ::std::os::raw::c_uint,
        ray_query: ::std::os::raw::c_uint,
        precision: ::std::os::raw::c_uint,
        assigned: ::std::os::raw::c_uint,
        cannot_coalesce: ::std::os::raw::c_uint,
        always_active_io: ::std::os::raw::c_uint,
        interpolation: ::std::os::raw::c_uint,
        location_frac: ::std::os::raw::c_uint,
        compact: ::std::os::raw::c_uint,
        fb_fetch_output: ::std::os::raw::c_uint,
        bindless: ::std::os::raw::c_uint,
        explicit_binding: ::std::os::raw::c_uint,
        explicit_location: ::std::os::raw::c_uint,
        implicit_sized_array: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 21u8, {
            let mode: u32 = unsafe { ::std::mem::transmute(mode) };
            mode as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let read_only: u32 = unsafe { ::std::mem::transmute(read_only) };
            read_only as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let centroid: u32 = unsafe { ::std::mem::transmute(centroid) };
            centroid as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let sample: u32 = unsafe { ::std::mem::transmute(sample) };
            sample as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let patch: u32 = unsafe { ::std::mem::transmute(patch) };
            patch as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let invariant: u32 = unsafe { ::std::mem::transmute(invariant) };
            invariant as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let explicit_invariant: u32 = unsafe { ::std::mem::transmute(explicit_invariant) };
            explicit_invariant as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let ray_query: u32 = unsafe { ::std::mem::transmute(ray_query) };
            ray_query as u64
        });
        __bindgen_bitfield_unit.set(28usize, 2u8, {
            let precision: u32 = unsafe { ::std::mem::transmute(precision) };
            precision as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let assigned: u32 = unsafe { ::std::mem::transmute(assigned) };
            assigned as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let cannot_coalesce: u32 = unsafe { ::std::mem::transmute(cannot_coalesce) };
            cannot_coalesce as u64
        });
        __bindgen_bitfield_unit.set(32usize, 1u8, {
            let always_active_io: u32 = unsafe { ::std::mem::transmute(always_active_io) };
            always_active_io as u64
        });
        __bindgen_bitfield_unit.set(33usize, 3u8, {
            let interpolation: u32 = unsafe { ::std::mem::transmute(interpolation) };
            interpolation as u64
        });
        __bindgen_bitfield_unit.set(36usize, 2u8, {
            let location_frac: u32 = unsafe { ::std::mem::transmute(location_frac) };
            location_frac as u64
        });
        __bindgen_bitfield_unit.set(38usize, 1u8, {
            let compact: u32 = unsafe { ::std::mem::transmute(compact) };
            compact as u64
        });
        __bindgen_bitfield_unit.set(39usize, 1u8, {
            let fb_fetch_output: u32 = unsafe { ::std::mem::transmute(fb_fetch_output) };
            fb_fetch_output as u64
        });
        __bindgen_bitfield_unit.set(40usize, 1u8, {
            let bindless: u32 = unsafe { ::std::mem::transmute(bindless) };
            bindless as u64
        });
        __bindgen_bitfield_unit.set(41usize, 1u8, {
            let explicit_binding: u32 = unsafe { ::std::mem::transmute(explicit_binding) };
            explicit_binding as u64
        });
        __bindgen_bitfield_unit.set(42usize, 1u8, {
            let explicit_location: u32 = unsafe { ::std::mem::transmute(explicit_location) };
            explicit_location as u64
        });
        __bindgen_bitfield_unit.set(43usize, 1u8, {
            let implicit_sized_array: u32 = unsafe { ::std::mem::transmute(implicit_sized_array) };
            implicit_sized_array as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn has_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_has_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_initializer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_has_initializer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_implicit_initializer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_implicit_initializer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_implicit_initializer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_implicit_initializer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_xfb(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_xfb_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_xfb_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_xfb_only(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_xfb_only(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_xfb_only_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_xfb_only_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_buffer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_buffer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_buffer_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                4usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_buffer_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_xfb_stride(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_xfb_stride(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_xfb_stride_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                5usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_xfb_stride_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn explicit_offset(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_offset(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn explicit_offset_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                6usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_explicit_offset_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn matrix_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(7usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_matrix_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(7usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn matrix_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                7usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_matrix_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                7usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn from_named_ifc_block(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_named_ifc_block(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn from_named_ifc_block_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                9usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_from_named_ifc_block_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn from_ssbo_unsized_array(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_from_ssbo_unsized_array(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn from_ssbo_unsized_array_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                10usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_from_ssbo_unsized_array_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn must_be_shader_input(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_must_be_shader_input(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn must_be_shader_input_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                11usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_must_be_shader_input_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn used(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn used_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                12usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_used_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn how_declared(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(13usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_how_declared(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(13usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn how_declared_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                13usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_how_declared_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                13usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_view(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_view(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_view_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_view_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_primitive(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_primitive(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_primitive_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                16usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_primitive_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_vertex(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_vertex(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_vertex_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                17usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_vertex_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn depth_layout(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(18usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_depth_layout(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(18usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn depth_layout_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                18usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_depth_layout_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                18usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn stream(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(21usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_stream(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(21usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn stream_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                21usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_stream_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                21usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn access(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(32usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_access(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(32usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn access_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                32usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_access_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                32usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn descriptor_set(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_2.get(41usize, 5u8) as u32) }
    }
    #[inline]
    pub fn set_descriptor_set(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_2.set(41usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn descriptor_set_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 6usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_2),
                41usize,
                5u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_descriptor_set_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 6usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_2),
                41usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        has_initializer: ::std::os::raw::c_uint,
        is_implicit_initializer: ::std::os::raw::c_uint,
        is_xfb: ::std::os::raw::c_uint,
        is_xfb_only: ::std::os::raw::c_uint,
        explicit_xfb_buffer: ::std::os::raw::c_uint,
        explicit_xfb_stride: ::std::os::raw::c_uint,
        explicit_offset: ::std::os::raw::c_uint,
        matrix_layout: ::std::os::raw::c_uint,
        from_named_ifc_block: ::std::os::raw::c_uint,
        from_ssbo_unsized_array: ::std::os::raw::c_uint,
        must_be_shader_input: ::std::os::raw::c_uint,
        used: ::std::os::raw::c_uint,
        how_declared: ::std::os::raw::c_uint,
        per_view: ::std::os::raw::c_uint,
        per_primitive: ::std::os::raw::c_uint,
        per_vertex: ::std::os::raw::c_uint,
        depth_layout: ::std::os::raw::c_uint,
        stream: ::std::os::raw::c_uint,
        access: ::std::os::raw::c_uint,
        descriptor_set: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 6usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 6usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_initializer: u32 = unsafe { ::std::mem::transmute(has_initializer) };
            has_initializer as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_implicit_initializer: u32 =
                unsafe { ::std::mem::transmute(is_implicit_initializer) };
            is_implicit_initializer as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_xfb: u32 = unsafe { ::std::mem::transmute(is_xfb) };
            is_xfb as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_xfb_only: u32 = unsafe { ::std::mem::transmute(is_xfb_only) };
            is_xfb_only as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let explicit_xfb_buffer: u32 = unsafe { ::std::mem::transmute(explicit_xfb_buffer) };
            explicit_xfb_buffer as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let explicit_xfb_stride: u32 = unsafe { ::std::mem::transmute(explicit_xfb_stride) };
            explicit_xfb_stride as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let explicit_offset: u32 = unsafe { ::std::mem::transmute(explicit_offset) };
            explicit_offset as u64
        });
        __bindgen_bitfield_unit.set(7usize, 2u8, {
            let matrix_layout: u32 = unsafe { ::std::mem::transmute(matrix_layout) };
            matrix_layout as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let from_named_ifc_block: u32 = unsafe { ::std::mem::transmute(from_named_ifc_block) };
            from_named_ifc_block as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let from_ssbo_unsized_array: u32 =
                unsafe { ::std::mem::transmute(from_ssbo_unsized_array) };
            from_ssbo_unsized_array as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let must_be_shader_input: u32 = unsafe { ::std::mem::transmute(must_be_shader_input) };
            must_be_shader_input as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let used: u32 = unsafe { ::std::mem::transmute(used) };
            used as u64
        });
        __bindgen_bitfield_unit.set(13usize, 2u8, {
            let how_declared: u32 = unsafe { ::std::mem::transmute(how_declared) };
            how_declared as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let per_view: u32 = unsafe { ::std::mem::transmute(per_view) };
            per_view as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let per_primitive: u32 = unsafe { ::std::mem::transmute(per_primitive) };
            per_primitive as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let per_vertex: u32 = unsafe { ::std::mem::transmute(per_vertex) };
            per_vertex as u64
        });
        __bindgen_bitfield_unit.set(18usize, 3u8, {
            let depth_layout: u32 = unsafe { ::std::mem::transmute(depth_layout) };
            depth_layout as u64
        });
        __bindgen_bitfield_unit.set(21usize, 9u8, {
            let stream: u32 = unsafe { ::std::mem::transmute(stream) };
            stream as u64
        });
        __bindgen_bitfield_unit.set(32usize, 9u8, {
            let access: u32 = unsafe { ::std::mem::transmute(access) };
            access as u64
        });
        __bindgen_bitfield_unit.set(41usize, 5u8, {
            let descriptor_set: u32 = unsafe { ::std::mem::transmute(descriptor_set) };
            descriptor_set as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_variable"][::std::mem::size_of::<nir_variable>() - 104usize];
    ["Alignment of nir_variable"][::std::mem::align_of::<nir_variable>() - 4usize];
    ["Offset of field: nir_variable::node"][::std::mem::offset_of!(nir_variable, node) - 0usize];
    ["Offset of field: nir_variable::type_"][::std::mem::offset_of!(nir_variable, type_) - 8usize];
    ["Offset of field: nir_variable::name"][::std::mem::offset_of!(nir_variable, name) - 12usize];
    ["Offset of field: nir_variable::data"][::std::mem::offset_of!(nir_variable, data) - 16usize];
    ["Offset of field: nir_variable::index"][::std::mem::offset_of!(nir_variable, index) - 68usize];
    ["Offset of field: nir_variable::num_members"]
        [::std::mem::offset_of!(nir_variable, num_members) - 72usize];
    ["Offset of field: nir_variable::max_ifc_array_access"]
        [::std::mem::offset_of!(nir_variable, max_ifc_array_access) - 76usize];
    ["Offset of field: nir_variable::num_state_slots"]
        [::std::mem::offset_of!(nir_variable, num_state_slots) - 80usize];
    ["Offset of field: nir_variable::state_slots"]
        [::std::mem::offset_of!(nir_variable, state_slots) - 84usize];
    ["Offset of field: nir_variable::constant_initializer"]
        [::std::mem::offset_of!(nir_variable, constant_initializer) - 88usize];
    ["Offset of field: nir_variable::pointer_initializer"]
        [::std::mem::offset_of!(nir_variable, pointer_initializer) - 92usize];
    ["Offset of field: nir_variable::interface_type"]
        [::std::mem::offset_of!(nir_variable, interface_type) - 96usize];
    ["Offset of field: nir_variable::members"]
        [::std::mem::offset_of!(nir_variable, members) - 100usize];
};
impl Default for nir_variable {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_variable_is_global__extern"]
    pub fn nir_variable_is_global(var: *const nir_variable) -> bool;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_instr_type {
    nir_instr_type_alu = 0,
    nir_instr_type_deref = 1,
    nir_instr_type_call = 2,
    nir_instr_type_tex = 3,
    nir_instr_type_intrinsic = 4,
    nir_instr_type_load_const = 5,
    nir_instr_type_jump = 6,
    nir_instr_type_undef = 7,
    nir_instr_type_phi = 8,
    nir_instr_type_parallel_copy = 9,
    nir_instr_type_debug_info = 10,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_instr {
    pub node: exec_node,
    pub block: *mut nir_block,
    pub type_: nir_instr_type,
    pub pass_flags: u8,
    #[doc = " generic instruction index."]
    pub index: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_instr"][::std::mem::size_of::<nir_instr>() - 20usize];
    ["Alignment of nir_instr"][::std::mem::align_of::<nir_instr>() - 4usize];
    ["Offset of field: nir_instr::node"][::std::mem::offset_of!(nir_instr, node) - 0usize];
    ["Offset of field: nir_instr::block"][::std::mem::offset_of!(nir_instr, block) - 8usize];
    ["Offset of field: nir_instr::type_"][::std::mem::offset_of!(nir_instr, type_) - 12usize];
    ["Offset of field: nir_instr::pass_flags"]
        [::std::mem::offset_of!(nir_instr, pass_flags) - 13usize];
    ["Offset of field: nir_instr::index"][::std::mem::offset_of!(nir_instr, index) - 16usize];
};
impl Default for nir_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_instr_next__extern"]
    pub fn nir_instr_next(instr: *mut nir_instr) -> *mut nir_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_prev__extern"]
    pub fn nir_instr_prev(instr: *mut nir_instr) -> *mut nir_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_is_first__extern"]
    pub fn nir_instr_is_first(instr: *const nir_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_instr_is_last__extern"]
    pub fn nir_instr_is_last(instr: *const nir_instr) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_def {
    #[doc = " Instruction which produces this SSA value."]
    pub parent_instr: *mut nir_instr,
    #[doc = " set of nir_instrs where this register is used (read from)"]
    pub uses: list_head,
    #[doc = " generic SSA definition index."]
    pub index: ::std::os::raw::c_uint,
    pub num_components: u8,
    pub bit_size: u8,
    #[doc = " True if this SSA value may have different values in different SIMD\n invocations of the shader.  This is set by nir_divergence_analysis."]
    pub divergent: bool,
    #[doc = " True if this SSA value is loop invariant w.r.t. the innermost parent\n loop.  This is set by nir_divergence_analysis and used to determine\n the divergence of a nir_src."]
    pub loop_invariant: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_def"][::std::mem::size_of::<nir_def>() - 20usize];
    ["Alignment of nir_def"][::std::mem::align_of::<nir_def>() - 4usize];
    ["Offset of field: nir_def::parent_instr"]
        [::std::mem::offset_of!(nir_def, parent_instr) - 0usize];
    ["Offset of field: nir_def::uses"][::std::mem::offset_of!(nir_def, uses) - 4usize];
    ["Offset of field: nir_def::index"][::std::mem::offset_of!(nir_def, index) - 12usize];
    ["Offset of field: nir_def::num_components"]
        [::std::mem::offset_of!(nir_def, num_components) - 16usize];
    ["Offset of field: nir_def::bit_size"][::std::mem::offset_of!(nir_def, bit_size) - 17usize];
    ["Offset of field: nir_def::divergent"][::std::mem::offset_of!(nir_def, divergent) - 18usize];
    ["Offset of field: nir_def::loop_invariant"]
        [::std::mem::offset_of!(nir_def, loop_invariant) - 19usize];
};
impl Default for nir_def {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_src {
    pub _parent: usize,
    pub use_link: list_head,
    pub ssa: *mut nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_src"][::std::mem::size_of::<nir_src>() - 16usize];
    ["Alignment of nir_src"][::std::mem::align_of::<nir_src>() - 4usize];
    ["Offset of field: nir_src::_parent"][::std::mem::offset_of!(nir_src, _parent) - 0usize];
    ["Offset of field: nir_src::use_link"][::std::mem::offset_of!(nir_src, use_link) - 4usize];
    ["Offset of field: nir_src::ssa"][::std::mem::offset_of!(nir_src, ssa) - 12usize];
};
impl Default for nir_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_src_is_if__extern"]
    pub fn nir_src_is_if(src: *const nir_src) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_parent_instr__extern"]
    pub fn nir_src_parent_instr(src: *const nir_src) -> *mut nir_instr;
}
unsafe extern "C" {
    #[link_name = "nir_src_parent_if__extern"]
    pub fn nir_src_parent_if(src: *const nir_src) -> *mut nir_if;
}
unsafe extern "C" {
    #[link_name = "nir_src_set_parent_instr__extern"]
    pub fn nir_src_set_parent_instr(src: *mut nir_src, parent_instr: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_src_set_parent_if__extern"]
    pub fn nir_src_set_parent_if(src: *mut nir_src, parent_if: *mut nir_if);
}
unsafe extern "C" {
    #[link_name = "nir_src_init__extern"]
    pub fn nir_src_init() -> nir_src;
}
unsafe extern "C" {
    #[link_name = "nir_def_used_by_if__extern"]
    pub fn nir_def_used_by_if(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_def_only_used_by_if__extern"]
    pub fn nir_def_only_used_by_if(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_for_ssa__extern"]
    pub fn nir_src_for_ssa(def: *mut nir_def) -> nir_src;
}
unsafe extern "C" {
    #[link_name = "nir_src_bit_size__extern"]
    pub fn nir_src_bit_size(src: nir_src) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_src_num_components__extern"]
    pub fn nir_src_num_components(src: nir_src) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_src_is_const__extern"]
    pub fn nir_src_is_const(src: nir_src) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_is_undef__extern"]
    pub fn nir_src_is_undef(src: nir_src) -> bool;
}
unsafe extern "C" {
    pub fn nir_src_is_divergent(src: *mut nir_src) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_same_comp_swizzle__extern"]
    pub fn nir_is_same_comp_swizzle(swiz: *mut u8, nr_comp: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_sequential_comp_swizzle__extern"]
    pub fn nir_is_sequential_comp_swizzle(swiz: *mut u8, nr_comp: ::std::os::raw::c_uint) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_alu_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " For each input component, says which component of the register it is\n chosen from.\n\n Note that which elements of the swizzle are used and which are ignored\n are based on the write mask for most opcodes - for example, a statement\n like \"foo.xzw = bar.zyx\" would have a writemask of 1101b and a swizzle\n of {2, 1, x, 0} where x means \"don't care.\""]
    pub swizzle: [u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_alu_src"][::std::mem::size_of::<nir_alu_src>() - 32usize];
    ["Alignment of nir_alu_src"][::std::mem::align_of::<nir_alu_src>() - 4usize];
    ["Offset of field: nir_alu_src::src"][::std::mem::offset_of!(nir_alu_src, src) - 0usize];
    ["Offset of field: nir_alu_src::swizzle"]
        [::std::mem::offset_of!(nir_alu_src, swizzle) - 16usize];
};
impl Default for nir_alu_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_get_nir_type_for_glsl_base_type(base_type: glsl_base_type) -> nir_alu_type;
}
unsafe extern "C" {
    #[link_name = "nir_get_nir_type_for_glsl_type__extern"]
    pub fn nir_get_nir_type_for_glsl_type(type_: *const glsl_type) -> nir_alu_type;
}
unsafe extern "C" {
    pub fn nir_get_glsl_base_type_for_nir_type(base_type: nir_alu_type) -> glsl_base_type;
}
unsafe extern "C" {
    pub fn nir_type_conversion_op(
        src: nir_alu_type,
        dst: nir_alu_type,
        rnd: nir_rounding_mode,
    ) -> nir_op;
}
#[repr(u32)]
#[doc = " Atomic intrinsics perform different operations depending on the value of\n their atomic_op constant index. nir_atomic_op defines the operations."]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_atomic_op {
    nir_atomic_op_iadd = 0,
    nir_atomic_op_imin = 1,
    nir_atomic_op_umin = 2,
    nir_atomic_op_imax = 3,
    nir_atomic_op_umax = 4,
    nir_atomic_op_iand = 5,
    nir_atomic_op_ior = 6,
    nir_atomic_op_ixor = 7,
    nir_atomic_op_xchg = 8,
    nir_atomic_op_fadd = 9,
    nir_atomic_op_fmin = 10,
    nir_atomic_op_fmax = 11,
    nir_atomic_op_cmpxchg = 12,
    nir_atomic_op_fcmpxchg = 13,
    nir_atomic_op_inc_wrap = 14,
    nir_atomic_op_dec_wrap = 15,
    nir_atomic_op_ordered_add_gfx12_amd = 16,
}
unsafe extern "C" {
    #[link_name = "nir_atomic_op_type__extern"]
    pub fn nir_atomic_op_type(op: nir_atomic_op) -> nir_alu_type;
}
unsafe extern "C" {
    pub fn nir_atomic_op_to_alu(op: nir_atomic_op) -> nir_op;
}
unsafe extern "C" {
    #[doc = " Returns nir_op_vec<num_components> or nir_op_mov if num_components == 1\n\n This is subtly different from nir_op_is_vec() which returns false for\n nir_op_mov.  Returning nir_op_mov from nir_op_vec() when num_components == 1\n makes sense under the assumption that the num_components of the resulting\n nir_def will same as what is passed in here because a single-component mov\n is effectively a vec1.  However, if alu->def.num_components > 1, nir_op_mov\n has different semantics from nir_op_vec* so so code which detects \"is this\n a vec?\" typically needs to handle nir_op_mov separate from nir_op_vecN.\n\n In the unlikely case where you can handle nir_op_vecN and nir_op_mov\n together, use nir_op_is_vec_or_mov()."]
    pub fn nir_op_vec(num_components: ::std::os::raw::c_uint) -> nir_op;
}
unsafe extern "C" {
    #[doc = " Returns true if this op is one of nir_op_vec*\n\n Returns false for nir_op_mov.  See nir_op_vec() for more details."]
    pub fn nir_op_is_vec(op: nir_op) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_op_is_vec_or_mov__extern"]
    pub fn nir_op_is_vec_or_mov(op: nir_op) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_float_control_signed_zero_preserve__extern"]
    pub fn nir_is_float_control_signed_zero_preserve(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_float_control_inf_preserve__extern"]
    pub fn nir_is_float_control_inf_preserve(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_float_control_nan_preserve__extern"]
    pub fn nir_is_float_control_nan_preserve(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_float_control_signed_zero_inf_nan_preserve__extern"]
    pub fn nir_is_float_control_signed_zero_inf_nan_preserve(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_denorm_flush_to_zero__extern"]
    pub fn nir_is_denorm_flush_to_zero(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_denorm_preserve__extern"]
    pub fn nir_is_denorm_preserve(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_rounding_mode_rtne__extern"]
    pub fn nir_is_rounding_mode_rtne(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_rounding_mode_rtz__extern"]
    pub fn nir_is_rounding_mode_rtz(
        execution_mode: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_has_any_rounding_mode_rtz__extern"]
    pub fn nir_has_any_rounding_mode_rtz(execution_mode: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_has_any_rounding_mode_rtne__extern"]
    pub fn nir_has_any_rounding_mode_rtne(execution_mode: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_get_rounding_mode_from_float_controls__extern"]
    pub fn nir_get_rounding_mode_from_float_controls(
        execution_mode: ::std::os::raw::c_uint,
        type_: nir_alu_type,
    ) -> nir_rounding_mode;
}
unsafe extern "C" {
    #[link_name = "nir_has_any_rounding_mode_enabled__extern"]
    pub fn nir_has_any_rounding_mode_enabled(execution_mode: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_op_is_selection__extern"]
    pub fn nir_op_is_selection(op: nir_op) -> bool;
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_alu_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Opcode"]
    pub op: nir_op,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Sources\n\n The size of the array is given by :c:member:`nir_op_info.num_inputs`."]
    pub src: __IncompleteArrayField<nir_alu_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_alu_instr"][::std::mem::size_of::<nir_alu_instr>() - 48usize];
    ["Alignment of nir_alu_instr"][::std::mem::align_of::<nir_alu_instr>() - 4usize];
    ["Offset of field: nir_alu_instr::instr"]
        [::std::mem::offset_of!(nir_alu_instr, instr) - 0usize];
    ["Offset of field: nir_alu_instr::op"][::std::mem::offset_of!(nir_alu_instr, op) - 20usize];
    ["Offset of field: nir_alu_instr::def"][::std::mem::offset_of!(nir_alu_instr, def) - 28usize];
    ["Offset of field: nir_alu_instr::src"][::std::mem::offset_of!(nir_alu_instr, src) - 48usize];
};
impl Default for nir_alu_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_alu_instr {
    #[inline]
    pub fn exact(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_exact(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn exact_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_exact_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_signed_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_signed_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_signed_wrap_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_no_signed_wrap_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_unsigned_wrap(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_no_unsigned_wrap(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_unsigned_wrap_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_no_unsigned_wrap_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fp_fast_math(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 9u8) as u32) }
    }
    #[inline]
    pub fn set_fp_fast_math(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 9u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fp_fast_math_raw(this: *const Self) -> u32 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                9u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fp_fast_math_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                9u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        exact: bool,
        no_signed_wrap: bool,
        no_unsigned_wrap: bool,
        fp_fast_math: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let exact: u8 = unsafe { ::std::mem::transmute(exact) };
            exact as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let no_signed_wrap: u8 = unsafe { ::std::mem::transmute(no_signed_wrap) };
            no_signed_wrap as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_unsigned_wrap: u8 = unsafe { ::std::mem::transmute(no_unsigned_wrap) };
            no_unsigned_wrap as u64
        });
        __bindgen_bitfield_unit.set(3usize, 9u8, {
            let fp_fast_math: u32 = unsafe { ::std::mem::transmute(fp_fast_math) };
            fp_fast_math as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    #[link_name = "nir_alu_instr_is_signed_zero_preserve__extern"]
    pub fn nir_alu_instr_is_signed_zero_preserve(alu: *mut nir_alu_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_alu_instr_is_inf_preserve__extern"]
    pub fn nir_alu_instr_is_inf_preserve(alu: *mut nir_alu_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_alu_instr_is_nan_preserve__extern"]
    pub fn nir_alu_instr_is_nan_preserve(alu: *mut nir_alu_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_alu_instr_is_signed_zero_inf_nan_preserve__extern"]
    pub fn nir_alu_instr_is_signed_zero_inf_nan_preserve(alu: *mut nir_alu_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_src_copy(dest: *mut nir_alu_src, src: *const nir_alu_src);
}
unsafe extern "C" {
    pub fn nir_alu_instr_src_read_mask(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_component_mask_t;
}
unsafe extern "C" {
    #[doc = " Get the number of channels used for a source"]
    pub fn nir_ssa_alu_instr_src_components(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_alu_instr_channel_used__extern"]
    pub fn nir_alu_instr_channel_used(
        instr: *const nir_alu_instr,
        src: ::std::os::raw::c_uint,
        channel: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_instr_is_comparison(instr: *const nir_alu_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_const_value_negative_equal(
        c1: nir_const_value,
        c2: nir_const_value,
        full_type: nir_alu_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_negative_equal_typed(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
        base_type: nir_alu_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_srcs_negative_equal(
        alu1: *const nir_alu_instr,
        alu2: *const nir_alu_instr,
        src1: ::std::os::raw::c_uint,
        src2: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_alu_src_is_trivial_ssa(
        alu: *const nir_alu_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_deref_type {
    nir_deref_type_var = 0,
    nir_deref_type_array = 1,
    nir_deref_type_array_wildcard = 2,
    nir_deref_type_ptr_as_array = 3,
    nir_deref_type_struct = 4,
    nir_deref_type_cast = 5,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_deref_instr {
    pub instr: nir_instr,
    #[doc = " The type of this deref instruction"]
    pub deref_type: nir_deref_type,
    #[doc = " Bitmask what modes the underlying variable might be\n\n For OpenCL-style generic pointers, we may not know exactly what mode it\n is at any given point in time in the compile process.  This bitfield\n contains the set of modes which it MAY be.\n\n Generally, this field should not be accessed directly.  Use one of the\n nir_deref_mode_ helpers instead."]
    pub modes: nir_variable_mode,
    #[doc = " The dereferenced type of the resulting pointer value"]
    pub type_: *const glsl_type,
    pub anon_1: nir_deref_instr__bindgen_ty_1,
    pub anon_2: nir_deref_instr__bindgen_ty_2,
    #[doc = " Destination to store the resulting \"pointer\""]
    pub def: nir_def,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_1 {
    #[doc = " Variable being dereferenced if deref_type is a deref_var"]
    pub var: *mut nir_variable,
    #[doc = " Parent deref if deref_type is not deref_var"]
    pub parent: nir_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_1"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_1>() - 16usize];
    ["Alignment of nir_deref_instr__bindgen_ty_1"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_1::var"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_1, var) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_1::parent"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_1, parent) - 0usize];
};
impl Default for nir_deref_instr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[doc = " Additional deref parameters"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_deref_instr__bindgen_ty_2 {
    pub arr: nir_deref_instr__bindgen_ty_2__bindgen_ty_1,
    pub strct: nir_deref_instr__bindgen_ty_2__bindgen_ty_2,
    pub cast: nir_deref_instr__bindgen_ty_2__bindgen_ty_3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    pub index: nir_src,
    pub in_bounds: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>() - 20usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_1"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_1::index"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1, index) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_1::in_bounds"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_1, in_bounds) - 16usize];
};
impl Default for nir_deref_instr__bindgen_ty_2__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_2 {
    pub index: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>() - 4usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_2"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_2>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_2::index"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_2, index) - 0usize];
};
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_deref_instr__bindgen_ty_2__bindgen_ty_3 {
    pub ptr_stride: ::std::os::raw::c_uint,
    pub align_mul: ::std::os::raw::c_uint,
    pub align_offset: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2__bindgen_ty_3"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>() - 12usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2__bindgen_ty_3"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2__bindgen_ty_3>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::ptr_stride"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3, ptr_stride) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::align_mul"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2__bindgen_ty_3, align_mul) - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2__bindgen_ty_3::align_offset"][::std::mem::offset_of!(
        nir_deref_instr__bindgen_ty_2__bindgen_ty_3,
        align_offset
    ) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr__bindgen_ty_2"]
        [::std::mem::size_of::<nir_deref_instr__bindgen_ty_2>() - 20usize];
    ["Alignment of nir_deref_instr__bindgen_ty_2"]
        [::std::mem::align_of::<nir_deref_instr__bindgen_ty_2>() - 4usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::arr"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, arr) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::strct"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, strct) - 0usize];
    ["Offset of field: nir_deref_instr__bindgen_ty_2::cast"]
        [::std::mem::offset_of!(nir_deref_instr__bindgen_ty_2, cast) - 0usize];
};
impl Default for nir_deref_instr__bindgen_ty_2 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_deref_instr"][::std::mem::size_of::<nir_deref_instr>() - 88usize];
    ["Alignment of nir_deref_instr"][::std::mem::align_of::<nir_deref_instr>() - 4usize];
    ["Offset of field: nir_deref_instr::instr"]
        [::std::mem::offset_of!(nir_deref_instr, instr) - 0usize];
    ["Offset of field: nir_deref_instr::deref_type"]
        [::std::mem::offset_of!(nir_deref_instr, deref_type) - 20usize];
    ["Offset of field: nir_deref_instr::modes"]
        [::std::mem::offset_of!(nir_deref_instr, modes) - 24usize];
    ["Offset of field: nir_deref_instr::type_"]
        [::std::mem::offset_of!(nir_deref_instr, type_) - 28usize];
    ["Offset of field: nir_deref_instr::def"]
        [::std::mem::offset_of!(nir_deref_instr, def) - 68usize];
};
impl Default for nir_deref_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Returns true if the cast is trivial, i.e. the source and destination type is\n the same."]
    pub fn nir_deref_cast_is_trivial(cast: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if deref might have one of the given modes\n\n For multi-mode derefs, this returns true if any of the possible modes for\n the deref to have any of the specified modes.  This function returning true\n does NOT mean that the deref definitely has one of those modes.  It simply\n means that, with the best information we have at the time, it might."]
    #[link_name = "nir_deref_mode_may_be__extern"]
    pub fn nir_deref_mode_may_be(deref: *const nir_deref_instr, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if deref must have one of the given modes\n\n For multi-mode derefs, this returns true if NIR can prove that the given\n deref has one of the specified modes.  This function returning false does\n NOT mean that deref doesn't have one of the given mode.  It very well may\n have one of those modes, we just don't have enough information to prove\n that it does for sure."]
    #[link_name = "nir_deref_mode_must_be__extern"]
    pub fn nir_deref_mode_must_be(deref: *const nir_deref_instr, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if deref has the given mode\n\n This returns true if the deref has exactly the mode specified.  If the\n deref may have that mode but may also have a different mode (i.e. modes has\n multiple bits set), this will assert-fail.\n\n If you're confused about which nir_deref_mode_ helper to use, use this one\n or nir_deref_mode_is_one_of below."]
    #[link_name = "nir_deref_mode_is__extern"]
    pub fn nir_deref_mode_is(deref: *const nir_deref_instr, mode: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if deref has one of the given modes\n\n This returns true if the deref has exactly one possible mode and that mode\n is one of the modes specified.  If the deref may have one of those modes\n but may also have a different mode (i.e. modes has multiple bits set), this\n will assert-fail."]
    #[link_name = "nir_deref_mode_is_one_of__extern"]
    pub fn nir_deref_mode_is_one_of(
        deref: *const nir_deref_instr,
        modes: nir_variable_mode,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if deref's possible modes lie in the given set of modes\n\n This returns true if the deref's modes lie in the given set of modes.  If\n the deref's modes overlap with the specified modes but aren't entirely\n contained in the specified set of modes, this will assert-fail.  In\n particular, if this is used in a generic pointers scenario, the specified\n modes has to contain all or none of the possible generic pointer modes.\n\n This is intended mostly for mass-lowering of derefs which might have\n generic pointers."]
    #[link_name = "nir_deref_mode_is_in_set__extern"]
    pub fn nir_deref_mode_is_in_set(
        deref: *const nir_deref_instr,
        modes: nir_variable_mode,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_deref__extern"]
    pub fn nir_src_as_deref(src: nir_src) -> *mut nir_deref_instr;
}
unsafe extern "C" {
    #[link_name = "nir_deref_instr_parent__extern"]
    pub fn nir_deref_instr_parent(instr: *const nir_deref_instr) -> *mut nir_deref_instr;
}
unsafe extern "C" {
    #[link_name = "nir_deref_instr_get_variable__extern"]
    pub fn nir_deref_instr_get_variable(instr: *const nir_deref_instr) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_deref_instr_has_indirect(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_is_known_out_of_bounds(instr: *mut nir_deref_instr) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_deref_instr_has_complex_use_options {
    nir_deref_instr_has_complex_use_allow_memcpy_src = 1,
    nir_deref_instr_has_complex_use_allow_memcpy_dst = 2,
    nir_deref_instr_has_complex_use_allow_atomics = 4,
}
unsafe extern "C" {
    pub fn nir_deref_instr_has_complex_use(
        instr: *mut nir_deref_instr,
        opts: nir_deref_instr_has_complex_use_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_remove_if_unused(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_deref_instr_array_stride(instr: *mut nir_deref_instr) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug)]
pub struct nir_call_instr {
    pub instr: nir_instr,
    pub callee: *mut nir_function,
    pub indirect_callee: nir_src,
    pub num_params: ::std::os::raw::c_uint,
    pub params: __IncompleteArrayField<nir_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_call_instr"][::std::mem::size_of::<nir_call_instr>() - 44usize];
    ["Alignment of nir_call_instr"][::std::mem::align_of::<nir_call_instr>() - 4usize];
    ["Offset of field: nir_call_instr::instr"]
        [::std::mem::offset_of!(nir_call_instr, instr) - 0usize];
    ["Offset of field: nir_call_instr::callee"]
        [::std::mem::offset_of!(nir_call_instr, callee) - 20usize];
    ["Offset of field: nir_call_instr::indirect_callee"]
        [::std::mem::offset_of!(nir_call_instr, indirect_callee) - 24usize];
    ["Offset of field: nir_call_instr::num_params"]
        [::std::mem::offset_of!(nir_call_instr, num_params) - 40usize];
    ["Offset of field: nir_call_instr::params"]
        [::std::mem::offset_of!(nir_call_instr, params) - 44usize];
};
impl Default for nir_call_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_intrinsic_op {
    pub const nir_last_intrinsic: nir_intrinsic_op =
        nir_intrinsic_op::nir_intrinsic_xfb_counter_sub_gfx11_amd;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_intrinsic_op {
    nir_intrinsic_accept_ray_intersection = 0,
    nir_intrinsic_addr_mode_is = 1,
    nir_intrinsic_al2p_nv = 2,
    nir_intrinsic_ald_nv = 3,
    nir_intrinsic_as_uniform = 4,
    nir_intrinsic_ast_nv = 5,
    nir_intrinsic_atomic_add_gen_prim_count_amd = 6,
    nir_intrinsic_atomic_add_gs_emit_prim_count_amd = 7,
    nir_intrinsic_atomic_add_shader_invocation_count_amd = 8,
    nir_intrinsic_atomic_add_xfb_prim_count_amd = 9,
    nir_intrinsic_atomic_counter_add = 10,
    nir_intrinsic_atomic_counter_add_deref = 11,
    nir_intrinsic_atomic_counter_and = 12,
    nir_intrinsic_atomic_counter_and_deref = 13,
    nir_intrinsic_atomic_counter_comp_swap = 14,
    nir_intrinsic_atomic_counter_comp_swap_deref = 15,
    nir_intrinsic_atomic_counter_exchange = 16,
    nir_intrinsic_atomic_counter_exchange_deref = 17,
    nir_intrinsic_atomic_counter_inc = 18,
    nir_intrinsic_atomic_counter_inc_deref = 19,
    nir_intrinsic_atomic_counter_max = 20,
    nir_intrinsic_atomic_counter_max_deref = 21,
    nir_intrinsic_atomic_counter_min = 22,
    nir_intrinsic_atomic_counter_min_deref = 23,
    nir_intrinsic_atomic_counter_or = 24,
    nir_intrinsic_atomic_counter_or_deref = 25,
    nir_intrinsic_atomic_counter_post_dec = 26,
    nir_intrinsic_atomic_counter_post_dec_deref = 27,
    nir_intrinsic_atomic_counter_pre_dec = 28,
    nir_intrinsic_atomic_counter_pre_dec_deref = 29,
    nir_intrinsic_atomic_counter_read = 30,
    nir_intrinsic_atomic_counter_read_deref = 31,
    nir_intrinsic_atomic_counter_xor = 32,
    nir_intrinsic_atomic_counter_xor_deref = 33,
    nir_intrinsic_ballot = 34,
    nir_intrinsic_ballot_bit_count_exclusive = 35,
    nir_intrinsic_ballot_bit_count_inclusive = 36,
    nir_intrinsic_ballot_bit_count_reduce = 37,
    nir_intrinsic_ballot_bitfield_extract = 38,
    nir_intrinsic_ballot_find_lsb = 39,
    nir_intrinsic_ballot_find_msb = 40,
    nir_intrinsic_ballot_relaxed = 41,
    nir_intrinsic_bar_break_nv = 42,
    nir_intrinsic_bar_set_nv = 43,
    nir_intrinsic_bar_sync_nv = 44,
    nir_intrinsic_barrier = 45,
    nir_intrinsic_begin_invocation_interlock = 46,
    nir_intrinsic_bindless_image_atomic = 47,
    nir_intrinsic_bindless_image_atomic_swap = 48,
    nir_intrinsic_bindless_image_descriptor_amd = 49,
    nir_intrinsic_bindless_image_format = 50,
    nir_intrinsic_bindless_image_fragment_mask_load_amd = 51,
    nir_intrinsic_bindless_image_levels = 52,
    nir_intrinsic_bindless_image_load = 53,
    nir_intrinsic_bindless_image_load_raw_intel = 54,
    nir_intrinsic_bindless_image_order = 55,
    nir_intrinsic_bindless_image_samples = 56,
    nir_intrinsic_bindless_image_samples_identical = 57,
    nir_intrinsic_bindless_image_size = 58,
    nir_intrinsic_bindless_image_sparse_load = 59,
    nir_intrinsic_bindless_image_store = 60,
    nir_intrinsic_bindless_image_store_block_agx = 61,
    nir_intrinsic_bindless_image_store_raw_intel = 62,
    nir_intrinsic_bindless_image_texel_address = 63,
    nir_intrinsic_bindless_resource_ir3 = 64,
    nir_intrinsic_brcst_active_ir3 = 65,
    nir_intrinsic_btd_retire_intel = 66,
    nir_intrinsic_btd_spawn_intel = 67,
    nir_intrinsic_btd_stack_push_intel = 68,
    nir_intrinsic_bvh64_intersect_ray_amd = 69,
    nir_intrinsic_cmat_binary_op = 70,
    nir_intrinsic_cmat_bitcast = 71,
    nir_intrinsic_cmat_construct = 72,
    nir_intrinsic_cmat_copy = 73,
    nir_intrinsic_cmat_extract = 74,
    nir_intrinsic_cmat_insert = 75,
    nir_intrinsic_cmat_length = 76,
    nir_intrinsic_cmat_load = 77,
    nir_intrinsic_cmat_muladd = 78,
    nir_intrinsic_cmat_muladd_amd = 79,
    nir_intrinsic_cmat_scalar_op = 80,
    nir_intrinsic_cmat_store = 81,
    nir_intrinsic_cmat_unary_op = 82,
    nir_intrinsic_convert_alu_types = 83,
    nir_intrinsic_copy_deref = 84,
    nir_intrinsic_copy_fs_outputs_nv = 85,
    nir_intrinsic_copy_global_to_uniform_ir3 = 86,
    nir_intrinsic_copy_push_const_to_uniform_ir3 = 87,
    nir_intrinsic_copy_ubo_to_uniform_ir3 = 88,
    nir_intrinsic_ddx = 89,
    nir_intrinsic_ddx_coarse = 90,
    nir_intrinsic_ddx_fine = 91,
    nir_intrinsic_ddy = 92,
    nir_intrinsic_ddy_coarse = 93,
    nir_intrinsic_ddy_fine = 94,
    nir_intrinsic_debug_break = 95,
    nir_intrinsic_decl_reg = 96,
    nir_intrinsic_demote = 97,
    nir_intrinsic_demote_if = 98,
    nir_intrinsic_deref_atomic = 99,
    nir_intrinsic_deref_atomic_swap = 100,
    nir_intrinsic_deref_buffer_array_length = 101,
    nir_intrinsic_deref_implicit_array_length = 102,
    nir_intrinsic_deref_mode_is = 103,
    nir_intrinsic_deref_texture_src = 104,
    nir_intrinsic_discard_agx = 105,
    nir_intrinsic_doorbell_agx = 106,
    nir_intrinsic_dpas_intel = 107,
    nir_intrinsic_dpp16_shift_amd = 108,
    nir_intrinsic_elect = 109,
    nir_intrinsic_elect_any_ir3 = 110,
    nir_intrinsic_emit_vertex = 111,
    nir_intrinsic_emit_vertex_nv = 112,
    nir_intrinsic_emit_vertex_with_counter = 113,
    nir_intrinsic_end_invocation_interlock = 114,
    nir_intrinsic_end_primitive = 115,
    nir_intrinsic_end_primitive_nv = 116,
    nir_intrinsic_end_primitive_with_counter = 117,
    nir_intrinsic_enqueue_node_payloads = 118,
    nir_intrinsic_exclusive_scan = 119,
    nir_intrinsic_exclusive_scan_clusters_ir3 = 120,
    nir_intrinsic_execute_callable = 121,
    nir_intrinsic_execute_closest_hit_amd = 122,
    nir_intrinsic_execute_miss_amd = 123,
    nir_intrinsic_export_agx = 124,
    nir_intrinsic_export_amd = 125,
    nir_intrinsic_export_dual_src_blend_amd = 126,
    nir_intrinsic_export_row_amd = 127,
    nir_intrinsic_fence_helper_exit_agx = 128,
    nir_intrinsic_fence_mem_to_tex_agx = 129,
    nir_intrinsic_fence_pbe_to_tex_agx = 130,
    nir_intrinsic_fence_pbe_to_tex_pixel_agx = 131,
    nir_intrinsic_final_primitive_nv = 132,
    nir_intrinsic_finalize_incoming_node_payload = 133,
    nir_intrinsic_first_invocation = 134,
    nir_intrinsic_fs_out_nv = 135,
    nir_intrinsic_gds_atomic_add_amd = 136,
    nir_intrinsic_get_ssbo_size = 137,
    nir_intrinsic_get_ubo_size = 138,
    nir_intrinsic_global_atomic = 139,
    nir_intrinsic_global_atomic_2x32 = 140,
    nir_intrinsic_global_atomic_agx = 141,
    nir_intrinsic_global_atomic_amd = 142,
    nir_intrinsic_global_atomic_ir3 = 143,
    nir_intrinsic_global_atomic_swap = 144,
    nir_intrinsic_global_atomic_swap_2x32 = 145,
    nir_intrinsic_global_atomic_swap_agx = 146,
    nir_intrinsic_global_atomic_swap_amd = 147,
    nir_intrinsic_global_atomic_swap_ir3 = 148,
    nir_intrinsic_ignore_ray_intersection = 149,
    nir_intrinsic_image_atomic = 150,
    nir_intrinsic_image_atomic_swap = 151,
    nir_intrinsic_image_deref_atomic = 152,
    nir_intrinsic_image_deref_atomic_swap = 153,
    nir_intrinsic_image_deref_descriptor_amd = 154,
    nir_intrinsic_image_deref_format = 155,
    nir_intrinsic_image_deref_fragment_mask_load_amd = 156,
    nir_intrinsic_image_deref_levels = 157,
    nir_intrinsic_image_deref_load = 158,
    nir_intrinsic_image_deref_load_param_intel = 159,
    nir_intrinsic_image_deref_load_raw_intel = 160,
    nir_intrinsic_image_deref_order = 161,
    nir_intrinsic_image_deref_samples = 162,
    nir_intrinsic_image_deref_samples_identical = 163,
    nir_intrinsic_image_deref_size = 164,
    nir_intrinsic_image_deref_sparse_load = 165,
    nir_intrinsic_image_deref_store = 166,
    nir_intrinsic_image_deref_store_block_agx = 167,
    nir_intrinsic_image_deref_store_raw_intel = 168,
    nir_intrinsic_image_deref_texel_address = 169,
    nir_intrinsic_image_descriptor_amd = 170,
    nir_intrinsic_image_format = 171,
    nir_intrinsic_image_fragment_mask_load_amd = 172,
    nir_intrinsic_image_levels = 173,
    nir_intrinsic_image_load = 174,
    nir_intrinsic_image_load_raw_intel = 175,
    nir_intrinsic_image_order = 176,
    nir_intrinsic_image_samples = 177,
    nir_intrinsic_image_samples_identical = 178,
    nir_intrinsic_image_size = 179,
    nir_intrinsic_image_sparse_load = 180,
    nir_intrinsic_image_store = 181,
    nir_intrinsic_image_store_block_agx = 182,
    nir_intrinsic_image_store_raw_intel = 183,
    nir_intrinsic_image_texel_address = 184,
    nir_intrinsic_inclusive_scan = 185,
    nir_intrinsic_inclusive_scan_clusters_ir3 = 186,
    nir_intrinsic_initialize_node_payloads = 187,
    nir_intrinsic_interp_deref_at_centroid = 188,
    nir_intrinsic_interp_deref_at_offset = 189,
    nir_intrinsic_interp_deref_at_sample = 190,
    nir_intrinsic_interp_deref_at_vertex = 191,
    nir_intrinsic_inverse_ballot = 192,
    nir_intrinsic_ipa_nv = 193,
    nir_intrinsic_is_helper_invocation = 194,
    nir_intrinsic_is_sparse_resident_zink = 195,
    nir_intrinsic_is_sparse_texels_resident = 196,
    nir_intrinsic_is_subgroup_invocation_lt_amd = 197,
    nir_intrinsic_isberd_nv = 198,
    nir_intrinsic_lane_permute_16_amd = 199,
    nir_intrinsic_last_invocation = 200,
    nir_intrinsic_launch_mesh_workgroups = 201,
    nir_intrinsic_launch_mesh_workgroups_with_payload_deref = 202,
    nir_intrinsic_ldc_nv = 203,
    nir_intrinsic_ldcx_nv = 204,
    nir_intrinsic_ldtram_nv = 205,
    nir_intrinsic_load_aa_line_width = 206,
    nir_intrinsic_load_accel_struct_amd = 207,
    nir_intrinsic_load_active_samples_agx = 208,
    nir_intrinsic_load_active_subgroup_count_agx = 209,
    nir_intrinsic_load_active_subgroup_invocation_agx = 210,
    nir_intrinsic_load_agx = 211,
    nir_intrinsic_load_alpha_reference_amd = 212,
    nir_intrinsic_load_api_sample_mask_agx = 213,
    nir_intrinsic_load_attrib_clamp_agx = 214,
    nir_intrinsic_load_attribute_pan = 215,
    nir_intrinsic_load_back_face_agx = 216,
    nir_intrinsic_load_barycentric_at_offset = 217,
    nir_intrinsic_load_barycentric_at_offset_nv = 218,
    nir_intrinsic_load_barycentric_at_sample = 219,
    nir_intrinsic_load_barycentric_centroid = 220,
    nir_intrinsic_load_barycentric_coord_at_offset = 221,
    nir_intrinsic_load_barycentric_coord_at_sample = 222,
    nir_intrinsic_load_barycentric_coord_centroid = 223,
    nir_intrinsic_load_barycentric_coord_pixel = 224,
    nir_intrinsic_load_barycentric_coord_sample = 225,
    nir_intrinsic_load_barycentric_model = 226,
    nir_intrinsic_load_barycentric_optimize_amd = 227,
    nir_intrinsic_load_barycentric_pixel = 228,
    nir_intrinsic_load_barycentric_sample = 229,
    nir_intrinsic_load_base_global_invocation_id = 230,
    nir_intrinsic_load_base_instance = 231,
    nir_intrinsic_load_base_vertex = 232,
    nir_intrinsic_load_base_workgroup_id = 233,
    nir_intrinsic_load_blend_const_color_a_float = 234,
    nir_intrinsic_load_blend_const_color_aaaa8888_unorm = 235,
    nir_intrinsic_load_blend_const_color_b_float = 236,
    nir_intrinsic_load_blend_const_color_g_float = 237,
    nir_intrinsic_load_blend_const_color_r_float = 238,
    nir_intrinsic_load_blend_const_color_rgba = 239,
    nir_intrinsic_load_blend_const_color_rgba8888_unorm = 240,
    nir_intrinsic_load_btd_global_arg_addr_intel = 241,
    nir_intrinsic_load_btd_local_arg_addr_intel = 242,
    nir_intrinsic_load_btd_resume_sbt_addr_intel = 243,
    nir_intrinsic_load_btd_shader_type_intel = 244,
    nir_intrinsic_load_btd_stack_id_intel = 245,
    nir_intrinsic_load_buffer_amd = 246,
    nir_intrinsic_load_callable_sbt_addr_intel = 247,
    nir_intrinsic_load_callable_sbt_stride_intel = 248,
    nir_intrinsic_load_clamp_vertex_color_amd = 249,
    nir_intrinsic_load_clip_half_line_width_amd = 250,
    nir_intrinsic_load_clip_z_coeff_agx = 251,
    nir_intrinsic_load_coalesced_input_count = 252,
    nir_intrinsic_load_coefficients_agx = 253,
    nir_intrinsic_load_color0 = 254,
    nir_intrinsic_load_color1 = 255,
    nir_intrinsic_load_const_ir3 = 256,
    nir_intrinsic_load_constant = 257,
    nir_intrinsic_load_constant_agx = 258,
    nir_intrinsic_load_constant_base_ptr = 259,
    nir_intrinsic_load_converted_output_pan = 260,
    nir_intrinsic_load_core_id_agx = 261,
    nir_intrinsic_load_cull_any_enabled_amd = 262,
    nir_intrinsic_load_cull_back_face_enabled_amd = 263,
    nir_intrinsic_load_cull_ccw_amd = 264,
    nir_intrinsic_load_cull_front_face_enabled_amd = 265,
    nir_intrinsic_load_cull_line_viewport_xy_scale_and_offset_amd = 266,
    nir_intrinsic_load_cull_mask = 267,
    nir_intrinsic_load_cull_mask_and_flags_amd = 268,
    nir_intrinsic_load_cull_small_line_precision_amd = 269,
    nir_intrinsic_load_cull_small_lines_enabled_amd = 270,
    nir_intrinsic_load_cull_small_triangle_precision_amd = 271,
    nir_intrinsic_load_cull_small_triangles_enabled_amd = 272,
    nir_intrinsic_load_cull_triangle_viewport_xy_scale_and_offset_amd = 273,
    nir_intrinsic_load_debug_log_desc_amd = 274,
    nir_intrinsic_load_depth_never_agx = 275,
    nir_intrinsic_load_deref = 276,
    nir_intrinsic_load_deref_block_intel = 277,
    nir_intrinsic_load_draw_id = 278,
    nir_intrinsic_load_esgs_vertex_stride_amd = 279,
    nir_intrinsic_load_exported_agx = 280,
    nir_intrinsic_load_fb_layers_v3d = 281,
    nir_intrinsic_load_fbfetch_image_desc_amd = 282,
    nir_intrinsic_load_fbfetch_image_fmask_desc_amd = 283,
    nir_intrinsic_load_fep_w_v3d = 284,
    nir_intrinsic_load_first_vertex = 285,
    nir_intrinsic_load_fixed_point_size_agx = 286,
    nir_intrinsic_load_flat_mask = 287,
    nir_intrinsic_load_force_vrs_rates_amd = 288,
    nir_intrinsic_load_frag_coord = 289,
    nir_intrinsic_load_frag_coord_unscaled_ir3 = 290,
    nir_intrinsic_load_frag_coord_zw = 291,
    nir_intrinsic_load_frag_coord_zw_pan = 292,
    nir_intrinsic_load_frag_invocation_count = 293,
    nir_intrinsic_load_frag_offset_ir3 = 294,
    nir_intrinsic_load_frag_shading_rate = 295,
    nir_intrinsic_load_frag_size = 296,
    nir_intrinsic_load_frag_size_ir3 = 297,
    nir_intrinsic_load_from_texture_handle_agx = 298,
    nir_intrinsic_load_front_face = 299,
    nir_intrinsic_load_front_face_fsign = 300,
    nir_intrinsic_load_fs_input_interp_deltas = 301,
    nir_intrinsic_load_fully_covered = 302,
    nir_intrinsic_load_geometry_param_buffer_agx = 303,
    nir_intrinsic_load_global = 304,
    nir_intrinsic_load_global_2x32 = 305,
    nir_intrinsic_load_global_amd = 306,
    nir_intrinsic_load_global_base_ptr = 307,
    nir_intrinsic_load_global_block_intel = 308,
    nir_intrinsic_load_global_constant = 309,
    nir_intrinsic_load_global_constant_bounded = 310,
    nir_intrinsic_load_global_constant_offset = 311,
    nir_intrinsic_load_global_constant_uniform_block_intel = 312,
    nir_intrinsic_load_global_etna = 313,
    nir_intrinsic_load_global_invocation_id = 314,
    nir_intrinsic_load_global_invocation_index = 315,
    nir_intrinsic_load_global_ir3 = 316,
    nir_intrinsic_load_global_size = 317,
    nir_intrinsic_load_gs_header_ir3 = 318,
    nir_intrinsic_load_gs_vertex_offset_amd = 319,
    nir_intrinsic_load_gs_wave_id_amd = 320,
    nir_intrinsic_load_helper_arg_hi_agx = 321,
    nir_intrinsic_load_helper_arg_lo_agx = 322,
    nir_intrinsic_load_helper_invocation = 323,
    nir_intrinsic_load_helper_op_id_agx = 324,
    nir_intrinsic_load_hit_attrib_amd = 325,
    nir_intrinsic_load_hs_out_patch_data_offset_amd = 326,
    nir_intrinsic_load_hs_patch_stride_ir3 = 327,
    nir_intrinsic_load_initial_edgeflags_amd = 328,
    nir_intrinsic_load_inline_data_intel = 329,
    nir_intrinsic_load_input = 330,
    nir_intrinsic_load_input_assembly_buffer_agx = 331,
    nir_intrinsic_load_input_topology_agx = 332,
    nir_intrinsic_load_input_vertex = 333,
    nir_intrinsic_load_instance_id = 334,
    nir_intrinsic_load_interpolated_input = 335,
    nir_intrinsic_load_intersection_opaque_amd = 336,
    nir_intrinsic_load_invocation_id = 337,
    nir_intrinsic_load_is_first_fan_agx = 338,
    nir_intrinsic_load_is_indexed_draw = 339,
    nir_intrinsic_load_kernel_input = 340,
    nir_intrinsic_load_layer_id = 341,
    nir_intrinsic_load_lds_ngg_gs_out_vertex_base_amd = 342,
    nir_intrinsic_load_lds_ngg_scratch_base_amd = 343,
    nir_intrinsic_load_leaf_opaque_intel = 344,
    nir_intrinsic_load_leaf_procedural_intel = 345,
    nir_intrinsic_load_line_coord = 346,
    nir_intrinsic_load_line_width = 347,
    nir_intrinsic_load_local_invocation_id = 348,
    nir_intrinsic_load_local_invocation_index = 349,
    nir_intrinsic_load_local_pixel_agx = 350,
    nir_intrinsic_load_local_shared_r600 = 351,
    nir_intrinsic_load_lshs_vertex_stride_amd = 352,
    nir_intrinsic_load_merged_wave_info_amd = 353,
    nir_intrinsic_load_mesh_view_count = 354,
    nir_intrinsic_load_mesh_view_indices = 355,
    nir_intrinsic_load_multisampled_pan = 356,
    nir_intrinsic_load_noperspective_varyings_pan = 357,
    nir_intrinsic_load_num_subgroups = 358,
    nir_intrinsic_load_num_vertices = 359,
    nir_intrinsic_load_num_vertices_per_primitive_amd = 360,
    nir_intrinsic_load_num_workgroups = 361,
    nir_intrinsic_load_ordered_id_amd = 362,
    nir_intrinsic_load_output = 363,
    nir_intrinsic_load_packed_passthrough_primitive_amd = 364,
    nir_intrinsic_load_param = 365,
    nir_intrinsic_load_patch_vertices_in = 366,
    nir_intrinsic_load_per_primitive_input = 367,
    nir_intrinsic_load_per_primitive_output = 368,
    nir_intrinsic_load_per_vertex_input = 369,
    nir_intrinsic_load_per_vertex_output = 370,
    nir_intrinsic_load_per_view_output = 371,
    nir_intrinsic_load_persp_center_rhw_ir3 = 372,
    nir_intrinsic_load_pipeline_stat_query_enabled_amd = 373,
    nir_intrinsic_load_pixel_coord = 374,
    nir_intrinsic_load_point_coord = 375,
    nir_intrinsic_load_point_coord_maybe_flipped = 376,
    nir_intrinsic_load_poly_line_smooth_enabled = 377,
    nir_intrinsic_load_polygon_stipple_agx = 378,
    nir_intrinsic_load_polygon_stipple_buffer_amd = 379,
    nir_intrinsic_load_preamble = 380,
    nir_intrinsic_load_prim_gen_query_enabled_amd = 381,
    nir_intrinsic_load_prim_xfb_query_enabled_amd = 382,
    nir_intrinsic_load_primitive_id = 383,
    nir_intrinsic_load_primitive_location_ir3 = 384,
    nir_intrinsic_load_printf_base_identifier = 385,
    nir_intrinsic_load_printf_buffer_address = 386,
    nir_intrinsic_load_printf_buffer_size = 387,
    nir_intrinsic_load_provoking_last = 388,
    nir_intrinsic_load_provoking_vtx_amd = 389,
    nir_intrinsic_load_provoking_vtx_in_prim_amd = 390,
    nir_intrinsic_load_push_constant = 391,
    nir_intrinsic_load_push_constant_zink = 392,
    nir_intrinsic_load_rasterization_primitive_amd = 393,
    nir_intrinsic_load_rasterization_samples_amd = 394,
    nir_intrinsic_load_raw_output_pan = 395,
    nir_intrinsic_load_raw_vertex_id_pan = 396,
    nir_intrinsic_load_raw_vertex_offset_pan = 397,
    nir_intrinsic_load_ray_base_mem_addr_intel = 398,
    nir_intrinsic_load_ray_flags = 399,
    nir_intrinsic_load_ray_geometry_index = 400,
    nir_intrinsic_load_ray_hit_kind = 401,
    nir_intrinsic_load_ray_hit_sbt_addr_intel = 402,
    nir_intrinsic_load_ray_hit_sbt_stride_intel = 403,
    nir_intrinsic_load_ray_hw_stack_size_intel = 404,
    nir_intrinsic_load_ray_instance_custom_index = 405,
    nir_intrinsic_load_ray_launch_id = 406,
    nir_intrinsic_load_ray_launch_size = 407,
    nir_intrinsic_load_ray_miss_sbt_addr_intel = 408,
    nir_intrinsic_load_ray_miss_sbt_stride_intel = 409,
    nir_intrinsic_load_ray_num_dss_rt_stacks_intel = 410,
    nir_intrinsic_load_ray_object_direction = 411,
    nir_intrinsic_load_ray_object_origin = 412,
    nir_intrinsic_load_ray_object_to_world = 413,
    nir_intrinsic_load_ray_query_global_intel = 414,
    nir_intrinsic_load_ray_sw_stack_size_intel = 415,
    nir_intrinsic_load_ray_t_max = 416,
    nir_intrinsic_load_ray_t_min = 417,
    nir_intrinsic_load_ray_tracing_stack_base_lvp = 418,
    nir_intrinsic_load_ray_triangle_vertex_positions = 419,
    nir_intrinsic_load_ray_world_direction = 420,
    nir_intrinsic_load_ray_world_origin = 421,
    nir_intrinsic_load_ray_world_to_object = 422,
    nir_intrinsic_load_reg = 423,
    nir_intrinsic_load_reg_indirect = 424,
    nir_intrinsic_load_rel_patch_id_ir3 = 425,
    nir_intrinsic_load_reloc_const_intel = 426,
    nir_intrinsic_load_resume_shader_address_amd = 427,
    nir_intrinsic_load_ring_attr_amd = 428,
    nir_intrinsic_load_ring_attr_offset_amd = 429,
    nir_intrinsic_load_ring_es2gs_offset_amd = 430,
    nir_intrinsic_load_ring_esgs_amd = 431,
    nir_intrinsic_load_ring_gs2vs_offset_amd = 432,
    nir_intrinsic_load_ring_gsvs_amd = 433,
    nir_intrinsic_load_ring_mesh_scratch_amd = 434,
    nir_intrinsic_load_ring_mesh_scratch_offset_amd = 435,
    nir_intrinsic_load_ring_task_draw_amd = 436,
    nir_intrinsic_load_ring_task_payload_amd = 437,
    nir_intrinsic_load_ring_tess_factors_amd = 438,
    nir_intrinsic_load_ring_tess_factors_offset_amd = 439,
    nir_intrinsic_load_ring_tess_offchip_amd = 440,
    nir_intrinsic_load_ring_tess_offchip_offset_amd = 441,
    nir_intrinsic_load_rt_arg_scratch_offset_amd = 442,
    nir_intrinsic_load_rt_conversion_pan = 443,
    nir_intrinsic_load_sample_id = 444,
    nir_intrinsic_load_sample_id_no_per_sample = 445,
    nir_intrinsic_load_sample_mask = 446,
    nir_intrinsic_load_sample_mask_in = 447,
    nir_intrinsic_load_sample_pos = 448,
    nir_intrinsic_load_sample_pos_from_id = 449,
    nir_intrinsic_load_sample_pos_or_center = 450,
    nir_intrinsic_load_sample_positions_agx = 451,
    nir_intrinsic_load_sample_positions_amd = 452,
    nir_intrinsic_load_sample_positions_pan = 453,
    nir_intrinsic_load_sampler_handle_agx = 454,
    nir_intrinsic_load_sampler_lod_parameters_pan = 455,
    nir_intrinsic_load_samples_log2_agx = 456,
    nir_intrinsic_load_sbt_base_amd = 457,
    nir_intrinsic_load_sbt_offset_amd = 458,
    nir_intrinsic_load_sbt_stride_amd = 459,
    nir_intrinsic_load_scalar_arg_amd = 460,
    nir_intrinsic_load_scratch = 461,
    nir_intrinsic_load_scratch_base_ptr = 462,
    nir_intrinsic_load_shader_call_data_offset_lvp = 463,
    nir_intrinsic_load_shader_index = 464,
    nir_intrinsic_load_shader_part_tests_zs_agx = 465,
    nir_intrinsic_load_shader_record_ptr = 466,
    nir_intrinsic_load_shared = 467,
    nir_intrinsic_load_shared2_amd = 468,
    nir_intrinsic_load_shared_base_ptr = 469,
    nir_intrinsic_load_shared_block_intel = 470,
    nir_intrinsic_load_shared_ir3 = 471,
    nir_intrinsic_load_shared_uniform_block_intel = 472,
    nir_intrinsic_load_simd_width_intel = 473,
    nir_intrinsic_load_sm_count_nv = 474,
    nir_intrinsic_load_sm_id_nv = 475,
    nir_intrinsic_load_smem_amd = 476,
    nir_intrinsic_load_ssbo = 477,
    nir_intrinsic_load_ssbo_address = 478,
    nir_intrinsic_load_ssbo_block_intel = 479,
    nir_intrinsic_load_ssbo_ir3 = 480,
    nir_intrinsic_load_ssbo_uniform_block_intel = 481,
    nir_intrinsic_load_stack = 482,
    nir_intrinsic_load_stat_query_address_agx = 483,
    nir_intrinsic_load_streamout_buffer_amd = 484,
    nir_intrinsic_load_streamout_config_amd = 485,
    nir_intrinsic_load_streamout_offset_amd = 486,
    nir_intrinsic_load_streamout_write_index_amd = 487,
    nir_intrinsic_load_subgroup_eq_mask = 488,
    nir_intrinsic_load_subgroup_ge_mask = 489,
    nir_intrinsic_load_subgroup_gt_mask = 490,
    nir_intrinsic_load_subgroup_id = 491,
    nir_intrinsic_load_subgroup_id_shift_ir3 = 492,
    nir_intrinsic_load_subgroup_invocation = 493,
    nir_intrinsic_load_subgroup_le_mask = 494,
    nir_intrinsic_load_subgroup_lt_mask = 495,
    nir_intrinsic_load_subgroup_size = 496,
    nir_intrinsic_load_sysval_agx = 497,
    nir_intrinsic_load_sysval_nv = 498,
    nir_intrinsic_load_task_payload = 499,
    nir_intrinsic_load_task_ring_entry_amd = 500,
    nir_intrinsic_load_tcs_header_ir3 = 501,
    nir_intrinsic_load_tcs_in_param_base_r600 = 502,
    nir_intrinsic_load_tcs_num_patches_amd = 503,
    nir_intrinsic_load_tcs_out_param_base_r600 = 504,
    nir_intrinsic_load_tcs_primitive_mode_amd = 505,
    nir_intrinsic_load_tcs_rel_patch_id_r600 = 506,
    nir_intrinsic_load_tcs_tess_factor_base_r600 = 507,
    nir_intrinsic_load_tcs_tess_levels_to_tes_amd = 508,
    nir_intrinsic_load_tess_coord = 509,
    nir_intrinsic_load_tess_coord_xy = 510,
    nir_intrinsic_load_tess_factor_base_ir3 = 511,
    nir_intrinsic_load_tess_level_inner = 512,
    nir_intrinsic_load_tess_level_inner_default = 513,
    nir_intrinsic_load_tess_level_outer = 514,
    nir_intrinsic_load_tess_level_outer_default = 515,
    nir_intrinsic_load_tess_param_base_ir3 = 516,
    nir_intrinsic_load_tess_param_buffer_agx = 517,
    nir_intrinsic_load_tess_rel_patch_id_amd = 518,
    nir_intrinsic_load_tex_sprite_mask_agx = 519,
    nir_intrinsic_load_texture_handle_agx = 520,
    nir_intrinsic_load_texture_scale = 521,
    nir_intrinsic_load_texture_size_etna = 522,
    nir_intrinsic_load_tlb_color_brcm = 523,
    nir_intrinsic_load_topology_id_intel = 524,
    nir_intrinsic_load_typed_buffer_amd = 525,
    nir_intrinsic_load_uav_ir3 = 526,
    nir_intrinsic_load_ubo = 527,
    nir_intrinsic_load_ubo_uniform_block_intel = 528,
    nir_intrinsic_load_ubo_vec4 = 529,
    nir_intrinsic_load_uniform = 530,
    nir_intrinsic_load_user_clip_plane = 531,
    nir_intrinsic_load_user_data_amd = 532,
    nir_intrinsic_load_uvs_index_agx = 533,
    nir_intrinsic_load_vbo_base_agx = 534,
    nir_intrinsic_load_vector_arg_amd = 535,
    nir_intrinsic_load_vertex_id = 536,
    nir_intrinsic_load_vertex_id_zero_base = 537,
    nir_intrinsic_load_view_index = 538,
    nir_intrinsic_load_viewport_offset = 539,
    nir_intrinsic_load_viewport_scale = 540,
    nir_intrinsic_load_viewport_x_offset = 541,
    nir_intrinsic_load_viewport_x_scale = 542,
    nir_intrinsic_load_viewport_y_offset = 543,
    nir_intrinsic_load_viewport_y_scale = 544,
    nir_intrinsic_load_viewport_z_offset = 545,
    nir_intrinsic_load_viewport_z_scale = 546,
    nir_intrinsic_load_vs_output_buffer_agx = 547,
    nir_intrinsic_load_vs_outputs_agx = 548,
    nir_intrinsic_load_vs_primitive_stride_ir3 = 549,
    nir_intrinsic_load_vs_vertex_stride_ir3 = 550,
    nir_intrinsic_load_vulkan_descriptor = 551,
    nir_intrinsic_load_warp_id_nv = 552,
    nir_intrinsic_load_warps_per_sm_nv = 553,
    nir_intrinsic_load_work_dim = 554,
    nir_intrinsic_load_workgroup_id = 555,
    nir_intrinsic_load_workgroup_index = 556,
    nir_intrinsic_load_workgroup_num_input_primitives_amd = 557,
    nir_intrinsic_load_workgroup_num_input_vertices_amd = 558,
    nir_intrinsic_load_workgroup_size = 559,
    nir_intrinsic_load_xfb_address = 560,
    nir_intrinsic_load_xfb_index_buffer = 561,
    nir_intrinsic_load_xfb_size = 562,
    nir_intrinsic_load_xfb_state_address_gfx12_amd = 563,
    nir_intrinsic_masked_swizzle_amd = 564,
    nir_intrinsic_mbcnt_amd = 565,
    nir_intrinsic_memcpy_deref = 566,
    nir_intrinsic_nop = 567,
    nir_intrinsic_nop_amd = 568,
    nir_intrinsic_optimization_barrier_sgpr_amd = 569,
    nir_intrinsic_optimization_barrier_vgpr_amd = 570,
    nir_intrinsic_ordered_add_loop_gfx12_amd = 571,
    nir_intrinsic_ordered_xfb_counter_add_gfx11_amd = 572,
    nir_intrinsic_overwrite_tes_arguments_amd = 573,
    nir_intrinsic_overwrite_vs_arguments_amd = 574,
    nir_intrinsic_pin_cx_handle_nv = 575,
    nir_intrinsic_preamble_end_ir3 = 576,
    nir_intrinsic_preamble_start_ir3 = 577,
    nir_intrinsic_prefetch_sam_ir3 = 578,
    nir_intrinsic_prefetch_tex_ir3 = 579,
    nir_intrinsic_prefetch_ubo_ir3 = 580,
    nir_intrinsic_printf = 581,
    nir_intrinsic_printf_abort = 582,
    nir_intrinsic_quad_ballot_agx = 583,
    nir_intrinsic_quad_broadcast = 584,
    nir_intrinsic_quad_swap_diagonal = 585,
    nir_intrinsic_quad_swap_horizontal = 586,
    nir_intrinsic_quad_swap_vertical = 587,
    nir_intrinsic_quad_swizzle_amd = 588,
    nir_intrinsic_quad_vote_all = 589,
    nir_intrinsic_quad_vote_any = 590,
    nir_intrinsic_ray_intersection_ir3 = 591,
    nir_intrinsic_read_first_invocation = 592,
    nir_intrinsic_read_getlast_ir3 = 593,
    nir_intrinsic_read_invocation = 594,
    nir_intrinsic_read_invocation_cond_ir3 = 595,
    nir_intrinsic_reduce = 596,
    nir_intrinsic_reduce_clusters_ir3 = 597,
    nir_intrinsic_report_ray_intersection = 598,
    nir_intrinsic_resource_intel = 599,
    nir_intrinsic_rotate = 600,
    nir_intrinsic_rq_confirm_intersection = 601,
    nir_intrinsic_rq_generate_intersection = 602,
    nir_intrinsic_rq_initialize = 603,
    nir_intrinsic_rq_load = 604,
    nir_intrinsic_rq_proceed = 605,
    nir_intrinsic_rq_terminate = 606,
    nir_intrinsic_rt_execute_callable = 607,
    nir_intrinsic_rt_resume = 608,
    nir_intrinsic_rt_return_amd = 609,
    nir_intrinsic_rt_trace_ray = 610,
    nir_intrinsic_sample_mask_agx = 611,
    nir_intrinsic_sendmsg_amd = 612,
    nir_intrinsic_set_vertex_and_primitive_count = 613,
    nir_intrinsic_shader_clock = 614,
    nir_intrinsic_shared_append_amd = 615,
    nir_intrinsic_shared_atomic = 616,
    nir_intrinsic_shared_atomic_swap = 617,
    nir_intrinsic_shared_consume_amd = 618,
    nir_intrinsic_shuffle = 619,
    nir_intrinsic_shuffle_down = 620,
    nir_intrinsic_shuffle_down_uniform_ir3 = 621,
    nir_intrinsic_shuffle_up = 622,
    nir_intrinsic_shuffle_up_uniform_ir3 = 623,
    nir_intrinsic_shuffle_xor = 624,
    nir_intrinsic_shuffle_xor_uniform_ir3 = 625,
    nir_intrinsic_sleep_amd = 626,
    nir_intrinsic_sparse_residency_code_and = 627,
    nir_intrinsic_ssa_bar_nv = 628,
    nir_intrinsic_ssbo_atomic = 629,
    nir_intrinsic_ssbo_atomic_ir3 = 630,
    nir_intrinsic_ssbo_atomic_swap = 631,
    nir_intrinsic_ssbo_atomic_swap_ir3 = 632,
    nir_intrinsic_stack_map_agx = 633,
    nir_intrinsic_stack_unmap_agx = 634,
    nir_intrinsic_store_agx = 635,
    nir_intrinsic_store_buffer_amd = 636,
    nir_intrinsic_store_combined_output_pan = 637,
    nir_intrinsic_store_const_ir3 = 638,
    nir_intrinsic_store_deref = 639,
    nir_intrinsic_store_deref_block_intel = 640,
    nir_intrinsic_store_global = 641,
    nir_intrinsic_store_global_2x32 = 642,
    nir_intrinsic_store_global_amd = 643,
    nir_intrinsic_store_global_block_intel = 644,
    nir_intrinsic_store_global_etna = 645,
    nir_intrinsic_store_global_ir3 = 646,
    nir_intrinsic_store_hit_attrib_amd = 647,
    nir_intrinsic_store_local_pixel_agx = 648,
    nir_intrinsic_store_local_shared_r600 = 649,
    nir_intrinsic_store_output = 650,
    nir_intrinsic_store_per_primitive_output = 651,
    nir_intrinsic_store_per_vertex_output = 652,
    nir_intrinsic_store_per_view_output = 653,
    nir_intrinsic_store_preamble = 654,
    nir_intrinsic_store_raw_output_pan = 655,
    nir_intrinsic_store_reg = 656,
    nir_intrinsic_store_reg_indirect = 657,
    nir_intrinsic_store_scalar_arg_amd = 658,
    nir_intrinsic_store_scratch = 659,
    nir_intrinsic_store_shared = 660,
    nir_intrinsic_store_shared2_amd = 661,
    nir_intrinsic_store_shared_block_intel = 662,
    nir_intrinsic_store_shared_ir3 = 663,
    nir_intrinsic_store_ssbo = 664,
    nir_intrinsic_store_ssbo_block_intel = 665,
    nir_intrinsic_store_ssbo_ir3 = 666,
    nir_intrinsic_store_stack = 667,
    nir_intrinsic_store_task_payload = 668,
    nir_intrinsic_store_tf_r600 = 669,
    nir_intrinsic_store_tlb_sample_color_v3d = 670,
    nir_intrinsic_store_uvs_agx = 671,
    nir_intrinsic_store_vector_arg_amd = 672,
    nir_intrinsic_store_zs_agx = 673,
    nir_intrinsic_strict_wqm_coord_amd = 674,
    nir_intrinsic_task_payload_atomic = 675,
    nir_intrinsic_task_payload_atomic_swap = 676,
    nir_intrinsic_terminate = 677,
    nir_intrinsic_terminate_if = 678,
    nir_intrinsic_terminate_ray = 679,
    nir_intrinsic_trace_ray = 680,
    nir_intrinsic_trace_ray_intel = 681,
    nir_intrinsic_unit_test_amd = 682,
    nir_intrinsic_unit_test_divergent_amd = 683,
    nir_intrinsic_unit_test_uniform_amd = 684,
    nir_intrinsic_unpin_cx_handle_nv = 685,
    nir_intrinsic_use = 686,
    nir_intrinsic_vote_all = 687,
    nir_intrinsic_vote_any = 688,
    nir_intrinsic_vote_feq = 689,
    nir_intrinsic_vote_ieq = 690,
    nir_intrinsic_vulkan_resource_index = 691,
    nir_intrinsic_vulkan_resource_reindex = 692,
    nir_intrinsic_write_invocation_amd = 693,
    nir_intrinsic_xfb_counter_sub_gfx11_amd = 694,
    nir_num_intrinsics = 695,
}
#[doc = " Represents an intrinsic\n\n An intrinsic is an instruction type for handling things that are\n more-or-less regular operations but don't just consume and produce SSA\n values like ALU operations do.  Intrinsics are not for things that have\n special semantic meaning such as phi nodes and parallel copies.\n Examples of intrinsics include variable load/store operations, system\n value loads, and the like.  Even though texturing more-or-less falls\n under this category, texturing is its own instruction type because\n trying to represent texturing with intrinsics would lead to a\n combinatorial explosion of intrinsic opcodes.\n\n By having a single instruction type for handling a lot of different\n cases, optimization passes can look for intrinsics and, for the most\n part, completely ignore them.  Each intrinsic type also has a few\n possible flags that govern whether or not they can be reordered or\n eliminated.  That way passes like dead code elimination can still work\n on intrisics without understanding the meaning of each.\n\n Each intrinsic has some number of constant indices, some number of\n variables, and some number of sources.  What these sources, variables,\n and indices mean depends on the intrinsic and is documented with the\n intrinsic declaration in nir_intrinsics.h.  Intrinsics and texture\n instructions are the only types of instruction that can operate on\n variables."]
#[repr(C)]
#[derive(Debug)]
pub struct nir_intrinsic_instr {
    pub instr: nir_instr,
    pub intrinsic: nir_intrinsic_op,
    pub def: nir_def,
    #[doc = " number of components if this is a vectorized intrinsic\n\n Similarly to ALU operations, some intrinsics are vectorized.\n An intrinsic is vectorized if nir_intrinsic_infos.dest_components == 0.\n For vectorized intrinsics, the num_components field specifies the\n number of destination components and the number of source components\n for all sources with nir_intrinsic_infos.src_components[i] == 0."]
    pub num_components: u8,
    pub const_index: [::std::os::raw::c_int; 8usize],
    pub name: *const ::std::os::raw::c_char,
    pub src: __IncompleteArrayField<nir_src>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_intrinsic_instr"][::std::mem::size_of::<nir_intrinsic_instr>() - 84usize];
    ["Alignment of nir_intrinsic_instr"][::std::mem::align_of::<nir_intrinsic_instr>() - 4usize];
    ["Offset of field: nir_intrinsic_instr::instr"]
        [::std::mem::offset_of!(nir_intrinsic_instr, instr) - 0usize];
    ["Offset of field: nir_intrinsic_instr::intrinsic"]
        [::std::mem::offset_of!(nir_intrinsic_instr, intrinsic) - 20usize];
    ["Offset of field: nir_intrinsic_instr::def"]
        [::std::mem::offset_of!(nir_intrinsic_instr, def) - 24usize];
    ["Offset of field: nir_intrinsic_instr::num_components"]
        [::std::mem::offset_of!(nir_intrinsic_instr, num_components) - 44usize];
    ["Offset of field: nir_intrinsic_instr::const_index"]
        [::std::mem::offset_of!(nir_intrinsic_instr, const_index) - 48usize];
    ["Offset of field: nir_intrinsic_instr::name"]
        [::std::mem::offset_of!(nir_intrinsic_instr, name) - 80usize];
    ["Offset of field: nir_intrinsic_instr::src"]
        [::std::mem::offset_of!(nir_intrinsic_instr, src) - 84usize];
};
impl Default for nir_intrinsic_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_get_var__extern"]
    pub fn nir_intrinsic_get_var(
        intrin: *const nir_intrinsic_instr,
        i: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_memory_semantics {
    NIR_MEMORY_ACQUIRE = 1,
    NIR_MEMORY_RELEASE = 2,
    NIR_MEMORY_ACQ_REL = 3,
    NIR_MEMORY_MAKE_AVAILABLE = 4,
    NIR_MEMORY_MAKE_VISIBLE = 8,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_io_semantics {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_semantics"][::std::mem::size_of::<nir_io_semantics>() - 4usize];
    ["Alignment of nir_io_semantics"][::std::mem::align_of::<nir_io_semantics>() - 4usize];
};
impl nir_io_semantics {
    #[inline]
    pub fn location(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_location(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn location_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                7u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_location_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn num_slots(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 6u8) as u32) }
    }
    #[inline]
    pub fn set_num_slots(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_slots_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                6u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_num_slots_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                6u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn dual_source_blend_index(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dual_source_blend_index(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn dual_source_blend_index_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_dual_source_blend_index_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fb_fetch_output_coherent(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fb_fetch_output_coherent(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fb_fetch_output_coherent_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_fb_fetch_output_coherent_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn gs_streams(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gs_streams(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gs_streams_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gs_streams_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn medium_precision(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_medium_precision(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn medium_precision_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_medium_precision_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn per_view(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_per_view(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn per_view_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_per_view_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn high_16bits(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_16bits(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn high_16bits_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                26usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_high_16bits_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                26usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn invariant(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_invariant(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn invariant_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                27usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_invariant_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                27usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn high_dvec2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_dvec2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn high_dvec2_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                28usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_high_dvec2_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                28usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_varying(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_varying(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_varying_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                29usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_no_varying_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                29usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn no_sysval_output(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_sysval_output(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn no_sysval_output_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                30usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_no_sysval_output_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                30usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn interp_explicit_strict(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_interp_explicit_strict(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn interp_explicit_strict_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_interp_explicit_strict_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        location: ::std::os::raw::c_uint,
        num_slots: ::std::os::raw::c_uint,
        dual_source_blend_index: ::std::os::raw::c_uint,
        fb_fetch_output: ::std::os::raw::c_uint,
        fb_fetch_output_coherent: ::std::os::raw::c_uint,
        gs_streams: ::std::os::raw::c_uint,
        medium_precision: ::std::os::raw::c_uint,
        per_view: ::std::os::raw::c_uint,
        high_16bits: ::std::os::raw::c_uint,
        invariant: ::std::os::raw::c_uint,
        high_dvec2: ::std::os::raw::c_uint,
        no_varying: ::std::os::raw::c_uint,
        no_sysval_output: ::std::os::raw::c_uint,
        interp_explicit_strict: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let location: u32 = unsafe { ::std::mem::transmute(location) };
            location as u64
        });
        __bindgen_bitfield_unit.set(7usize, 6u8, {
            let num_slots: u32 = unsafe { ::std::mem::transmute(num_slots) };
            num_slots as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let dual_source_blend_index: u32 =
                unsafe { ::std::mem::transmute(dual_source_blend_index) };
            dual_source_blend_index as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let fb_fetch_output: u32 = unsafe { ::std::mem::transmute(fb_fetch_output) };
            fb_fetch_output as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let fb_fetch_output_coherent: u32 =
                unsafe { ::std::mem::transmute(fb_fetch_output_coherent) };
            fb_fetch_output_coherent as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let gs_streams: u32 = unsafe { ::std::mem::transmute(gs_streams) };
            gs_streams as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let medium_precision: u32 = unsafe { ::std::mem::transmute(medium_precision) };
            medium_precision as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let per_view: u32 = unsafe { ::std::mem::transmute(per_view) };
            per_view as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let high_16bits: u32 = unsafe { ::std::mem::transmute(high_16bits) };
            high_16bits as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let invariant: u32 = unsafe { ::std::mem::transmute(invariant) };
            invariant as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let high_dvec2: u32 = unsafe { ::std::mem::transmute(high_dvec2) };
            high_dvec2 as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let no_varying: u32 = unsafe { ::std::mem::transmute(no_varying) };
            no_varying as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let no_sysval_output: u32 = unsafe { ::std::mem::transmute(no_sysval_output) };
            no_sysval_output as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let interp_explicit_strict: u32 =
                unsafe { ::std::mem::transmute(interp_explicit_strict) };
            interp_explicit_strict as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_io_xfb {
    pub out: [nir_io_xfb__bindgen_ty_1; 2usize],
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_io_xfb__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub offset: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_xfb__bindgen_ty_1"]
        [::std::mem::size_of::<nir_io_xfb__bindgen_ty_1>() - 2usize];
    ["Alignment of nir_io_xfb__bindgen_ty_1"]
        [::std::mem::align_of::<nir_io_xfb__bindgen_ty_1>() - 1usize];
    ["Offset of field: nir_io_xfb__bindgen_ty_1::offset"]
        [::std::mem::offset_of!(nir_io_xfb__bindgen_ty_1, offset) - 1usize];
};
impl nir_io_xfb__bindgen_ty_1 {
    #[inline]
    pub fn num_components(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_num_components(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn num_components_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_num_components_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn buffer(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_buffer(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn buffer_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                4u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_buffer_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                4u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(num_components: u8, buffer: u8) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let num_components: u8 = unsafe { ::std::mem::transmute(num_components) };
            num_components as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let buffer: u8 = unsafe { ::std::mem::transmute(buffer) };
            buffer as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_io_xfb"][::std::mem::size_of::<nir_io_xfb>() - 4usize];
    ["Alignment of nir_io_xfb"][::std::mem::align_of::<nir_io_xfb>() - 1usize];
    ["Offset of field: nir_io_xfb::out"][::std::mem::offset_of!(nir_io_xfb, out) - 0usize];
};
unsafe extern "C" {
    pub fn nir_instr_xfb_write_mask(instr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_intrinsic_src_components(
        intr: *const nir_intrinsic_instr,
        srcn: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_intrinsic_dest_components(intr: *mut nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_src_type(
        intrin: *const nir_intrinsic_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_dest_type(intrin: *const nir_intrinsic_instr) -> nir_alu_type;
}
unsafe extern "C" {
    #[doc = " Helper to copy const_index[] from src to dst, without assuming they\n match in order."]
    pub fn nir_intrinsic_copy_const_indices(
        dst: *mut nir_intrinsic_instr,
        src: *mut nir_intrinsic_instr,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_base__extern"]
    pub fn nir_intrinsic_base(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_base__extern"]
    pub fn nir_intrinsic_set_base(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_int);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_base__extern"]
    pub fn nir_intrinsic_has_base(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_write_mask__extern"]
    pub fn nir_intrinsic_write_mask(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_write_mask__extern"]
    pub fn nir_intrinsic_set_write_mask(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_write_mask__extern"]
    pub fn nir_intrinsic_has_write_mask(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_stream_id__extern"]
    pub fn nir_intrinsic_stream_id(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_stream_id__extern"]
    pub fn nir_intrinsic_set_stream_id(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_stream_id__extern"]
    pub fn nir_intrinsic_has_stream_id(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_ucp_id__extern"]
    pub fn nir_intrinsic_ucp_id(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_ucp_id__extern"]
    pub fn nir_intrinsic_set_ucp_id(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_ucp_id__extern"]
    pub fn nir_intrinsic_has_ucp_id(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_range_base__extern"]
    pub fn nir_intrinsic_range_base(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_range_base__extern"]
    pub fn nir_intrinsic_set_range_base(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_range_base__extern"]
    pub fn nir_intrinsic_has_range_base(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_range__extern"]
    pub fn nir_intrinsic_range(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_range__extern"]
    pub fn nir_intrinsic_set_range(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_range__extern"]
    pub fn nir_intrinsic_has_range(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_desc_set__extern"]
    pub fn nir_intrinsic_desc_set(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_desc_set__extern"]
    pub fn nir_intrinsic_set_desc_set(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_desc_set__extern"]
    pub fn nir_intrinsic_has_desc_set(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_binding__extern"]
    pub fn nir_intrinsic_binding(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_binding__extern"]
    pub fn nir_intrinsic_set_binding(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_binding__extern"]
    pub fn nir_intrinsic_has_binding(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_component__extern"]
    pub fn nir_intrinsic_component(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_component__extern"]
    pub fn nir_intrinsic_set_component(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_component__extern"]
    pub fn nir_intrinsic_has_component(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_column__extern"]
    pub fn nir_intrinsic_column(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_column__extern"]
    pub fn nir_intrinsic_set_column(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_column__extern"]
    pub fn nir_intrinsic_has_column(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_interp_mode__extern"]
    pub fn nir_intrinsic_interp_mode(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_interp_mode__extern"]
    pub fn nir_intrinsic_set_interp_mode(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_interp_mode__extern"]
    pub fn nir_intrinsic_has_interp_mode(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_reduction_op__extern"]
    pub fn nir_intrinsic_reduction_op(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_reduction_op__extern"]
    pub fn nir_intrinsic_set_reduction_op(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_reduction_op__extern"]
    pub fn nir_intrinsic_has_reduction_op(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_cluster_size__extern"]
    pub fn nir_intrinsic_cluster_size(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_cluster_size__extern"]
    pub fn nir_intrinsic_set_cluster_size(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_cluster_size__extern"]
    pub fn nir_intrinsic_has_cluster_size(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_param_idx__extern"]
    pub fn nir_intrinsic_param_idx(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_param_idx__extern"]
    pub fn nir_intrinsic_set_param_idx(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_param_idx__extern"]
    pub fn nir_intrinsic_has_param_idx(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_image_dim__extern"]
    pub fn nir_intrinsic_image_dim(instr: *const nir_intrinsic_instr) -> glsl_sampler_dim;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_image_dim__extern"]
    pub fn nir_intrinsic_set_image_dim(instr: *mut nir_intrinsic_instr, val: glsl_sampler_dim);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_image_dim__extern"]
    pub fn nir_intrinsic_has_image_dim(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_image_array__extern"]
    pub fn nir_intrinsic_image_array(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_image_array__extern"]
    pub fn nir_intrinsic_set_image_array(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_image_array__extern"]
    pub fn nir_intrinsic_has_image_array(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_format__extern"]
    pub fn nir_intrinsic_format(instr: *const nir_intrinsic_instr) -> pipe_format;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_format__extern"]
    pub fn nir_intrinsic_set_format(instr: *mut nir_intrinsic_instr, val: pipe_format);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_format__extern"]
    pub fn nir_intrinsic_has_format(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_access__extern"]
    pub fn nir_intrinsic_access(instr: *const nir_intrinsic_instr) -> gl_access_qualifier;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_access__extern"]
    pub fn nir_intrinsic_set_access(instr: *mut nir_intrinsic_instr, val: gl_access_qualifier);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_access__extern"]
    pub fn nir_intrinsic_has_access(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_call_idx__extern"]
    pub fn nir_intrinsic_call_idx(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_call_idx__extern"]
    pub fn nir_intrinsic_set_call_idx(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_call_idx__extern"]
    pub fn nir_intrinsic_has_call_idx(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_stack_size__extern"]
    pub fn nir_intrinsic_stack_size(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_stack_size__extern"]
    pub fn nir_intrinsic_set_stack_size(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_stack_size__extern"]
    pub fn nir_intrinsic_has_stack_size(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_align_mul__extern"]
    pub fn nir_intrinsic_align_mul(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_align_mul__extern"]
    pub fn nir_intrinsic_set_align_mul(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_align_mul__extern"]
    pub fn nir_intrinsic_has_align_mul(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_align_offset__extern"]
    pub fn nir_intrinsic_align_offset(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_align_offset__extern"]
    pub fn nir_intrinsic_set_align_offset(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_align_offset__extern"]
    pub fn nir_intrinsic_has_align_offset(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_desc_type__extern"]
    pub fn nir_intrinsic_desc_type(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_desc_type__extern"]
    pub fn nir_intrinsic_set_desc_type(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_desc_type__extern"]
    pub fn nir_intrinsic_has_desc_type(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_src_type__extern"]
    pub fn nir_intrinsic_src_type(instr: *const nir_intrinsic_instr) -> nir_alu_type;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_src_type__extern"]
    pub fn nir_intrinsic_set_src_type(instr: *mut nir_intrinsic_instr, val: nir_alu_type);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_src_type__extern"]
    pub fn nir_intrinsic_has_src_type(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_dest_type__extern"]
    pub fn nir_intrinsic_dest_type(instr: *const nir_intrinsic_instr) -> nir_alu_type;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_dest_type__extern"]
    pub fn nir_intrinsic_set_dest_type(instr: *mut nir_intrinsic_instr, val: nir_alu_type);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_dest_type__extern"]
    pub fn nir_intrinsic_has_dest_type(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_swizzle_mask__extern"]
    pub fn nir_intrinsic_swizzle_mask(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_swizzle_mask__extern"]
    pub fn nir_intrinsic_set_swizzle_mask(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_swizzle_mask__extern"]
    pub fn nir_intrinsic_has_swizzle_mask(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_fetch_inactive__extern"]
    pub fn nir_intrinsic_fetch_inactive(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_fetch_inactive__extern"]
    pub fn nir_intrinsic_set_fetch_inactive(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_fetch_inactive__extern"]
    pub fn nir_intrinsic_has_fetch_inactive(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_offset0__extern"]
    pub fn nir_intrinsic_offset0(instr: *const nir_intrinsic_instr) -> u8;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_offset0__extern"]
    pub fn nir_intrinsic_set_offset0(instr: *mut nir_intrinsic_instr, val: u8);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_offset0__extern"]
    pub fn nir_intrinsic_has_offset0(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_offset1__extern"]
    pub fn nir_intrinsic_offset1(instr: *const nir_intrinsic_instr) -> u8;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_offset1__extern"]
    pub fn nir_intrinsic_set_offset1(instr: *mut nir_intrinsic_instr, val: u8);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_offset1__extern"]
    pub fn nir_intrinsic_has_offset1(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_st64__extern"]
    pub fn nir_intrinsic_st64(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_st64__extern"]
    pub fn nir_intrinsic_set_st64(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_st64__extern"]
    pub fn nir_intrinsic_has_st64(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_arg_upper_bound_u32_amd__extern"]
    pub fn nir_intrinsic_arg_upper_bound_u32_amd(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_arg_upper_bound_u32_amd__extern"]
    pub fn nir_intrinsic_set_arg_upper_bound_u32_amd(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_arg_upper_bound_u32_amd__extern"]
    pub fn nir_intrinsic_has_arg_upper_bound_u32_amd(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_dst_access__extern"]
    pub fn nir_intrinsic_dst_access(instr: *const nir_intrinsic_instr) -> gl_access_qualifier;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_dst_access__extern"]
    pub fn nir_intrinsic_set_dst_access(instr: *mut nir_intrinsic_instr, val: gl_access_qualifier);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_dst_access__extern"]
    pub fn nir_intrinsic_has_dst_access(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_src_access__extern"]
    pub fn nir_intrinsic_src_access(instr: *const nir_intrinsic_instr) -> gl_access_qualifier;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_src_access__extern"]
    pub fn nir_intrinsic_set_src_access(instr: *mut nir_intrinsic_instr, val: gl_access_qualifier);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_src_access__extern"]
    pub fn nir_intrinsic_has_src_access(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_driver_location__extern"]
    pub fn nir_intrinsic_driver_location(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_driver_location__extern"]
    pub fn nir_intrinsic_set_driver_location(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_driver_location__extern"]
    pub fn nir_intrinsic_has_driver_location(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_memory_semantics__extern"]
    pub fn nir_intrinsic_memory_semantics(
        instr: *const nir_intrinsic_instr,
    ) -> nir_memory_semantics;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_memory_semantics__extern"]
    pub fn nir_intrinsic_set_memory_semantics(
        instr: *mut nir_intrinsic_instr,
        val: nir_memory_semantics,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_memory_semantics__extern"]
    pub fn nir_intrinsic_has_memory_semantics(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_memory_modes__extern"]
    pub fn nir_intrinsic_memory_modes(instr: *const nir_intrinsic_instr) -> nir_variable_mode;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_memory_modes__extern"]
    pub fn nir_intrinsic_set_memory_modes(instr: *mut nir_intrinsic_instr, val: nir_variable_mode);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_memory_modes__extern"]
    pub fn nir_intrinsic_has_memory_modes(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_memory_scope__extern"]
    pub fn nir_intrinsic_memory_scope(instr: *const nir_intrinsic_instr) -> mesa_scope;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_memory_scope__extern"]
    pub fn nir_intrinsic_set_memory_scope(instr: *mut nir_intrinsic_instr, val: mesa_scope);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_memory_scope__extern"]
    pub fn nir_intrinsic_has_memory_scope(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_execution_scope__extern"]
    pub fn nir_intrinsic_execution_scope(instr: *const nir_intrinsic_instr) -> mesa_scope;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_execution_scope__extern"]
    pub fn nir_intrinsic_set_execution_scope(instr: *mut nir_intrinsic_instr, val: mesa_scope);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_execution_scope__extern"]
    pub fn nir_intrinsic_has_execution_scope(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_io_semantics__extern"]
    pub fn nir_intrinsic_io_semantics(instr: *const nir_intrinsic_instr) -> nir_io_semantics;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_io_semantics__extern"]
    pub fn nir_intrinsic_set_io_semantics(instr: *mut nir_intrinsic_instr, val: nir_io_semantics);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_io_semantics__extern"]
    pub fn nir_intrinsic_has_io_semantics(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_io_xfb__extern"]
    pub fn nir_intrinsic_io_xfb(instr: *const nir_intrinsic_instr) -> nir_io_xfb;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_io_xfb__extern"]
    pub fn nir_intrinsic_set_io_xfb(instr: *mut nir_intrinsic_instr, val: nir_io_xfb);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_io_xfb__extern"]
    pub fn nir_intrinsic_has_io_xfb(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_io_xfb2__extern"]
    pub fn nir_intrinsic_io_xfb2(instr: *const nir_intrinsic_instr) -> nir_io_xfb;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_io_xfb2__extern"]
    pub fn nir_intrinsic_set_io_xfb2(instr: *mut nir_intrinsic_instr, val: nir_io_xfb);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_io_xfb2__extern"]
    pub fn nir_intrinsic_has_io_xfb2(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_ray_query_value__extern"]
    pub fn nir_intrinsic_ray_query_value(instr: *const nir_intrinsic_instr) -> nir_ray_query_value;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_ray_query_value__extern"]
    pub fn nir_intrinsic_set_ray_query_value(
        instr: *mut nir_intrinsic_instr,
        val: nir_ray_query_value,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_ray_query_value__extern"]
    pub fn nir_intrinsic_has_ray_query_value(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_committed__extern"]
    pub fn nir_intrinsic_committed(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_committed__extern"]
    pub fn nir_intrinsic_set_committed(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_committed__extern"]
    pub fn nir_intrinsic_has_committed(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_rounding_mode__extern"]
    pub fn nir_intrinsic_rounding_mode(instr: *const nir_intrinsic_instr) -> nir_rounding_mode;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_rounding_mode__extern"]
    pub fn nir_intrinsic_set_rounding_mode(instr: *mut nir_intrinsic_instr, val: nir_rounding_mode);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_rounding_mode__extern"]
    pub fn nir_intrinsic_has_rounding_mode(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_saturate__extern"]
    pub fn nir_intrinsic_saturate(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_saturate__extern"]
    pub fn nir_intrinsic_set_saturate(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_saturate__extern"]
    pub fn nir_intrinsic_has_saturate(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_synchronous__extern"]
    pub fn nir_intrinsic_synchronous(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_synchronous__extern"]
    pub fn nir_intrinsic_set_synchronous(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_synchronous__extern"]
    pub fn nir_intrinsic_has_synchronous(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_value_id__extern"]
    pub fn nir_intrinsic_value_id(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_value_id__extern"]
    pub fn nir_intrinsic_set_value_id(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_value_id__extern"]
    pub fn nir_intrinsic_has_value_id(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_sign_extend__extern"]
    pub fn nir_intrinsic_sign_extend(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_sign_extend__extern"]
    pub fn nir_intrinsic_set_sign_extend(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_sign_extend__extern"]
    pub fn nir_intrinsic_has_sign_extend(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_flags__extern"]
    pub fn nir_intrinsic_flags(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_flags__extern"]
    pub fn nir_intrinsic_set_flags(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_flags__extern"]
    pub fn nir_intrinsic_has_flags(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_atomic_op__extern"]
    pub fn nir_intrinsic_atomic_op(instr: *const nir_intrinsic_instr) -> nir_atomic_op;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_atomic_op__extern"]
    pub fn nir_intrinsic_set_atomic_op(instr: *mut nir_intrinsic_instr, val: nir_atomic_op);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_atomic_op__extern"]
    pub fn nir_intrinsic_has_atomic_op(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_resource_block_intel__extern"]
    pub fn nir_intrinsic_resource_block_intel(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_resource_block_intel__extern"]
    pub fn nir_intrinsic_set_resource_block_intel(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_resource_block_intel__extern"]
    pub fn nir_intrinsic_has_resource_block_intel(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_resource_access_intel__extern"]
    pub fn nir_intrinsic_resource_access_intel(
        instr: *const nir_intrinsic_instr,
    ) -> nir_resource_data_intel;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_resource_access_intel__extern"]
    pub fn nir_intrinsic_set_resource_access_intel(
        instr: *mut nir_intrinsic_instr,
        val: nir_resource_data_intel,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_resource_access_intel__extern"]
    pub fn nir_intrinsic_has_resource_access_intel(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_num_components__extern"]
    pub fn nir_intrinsic_num_components(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_num_components__extern"]
    pub fn nir_intrinsic_set_num_components(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_num_components__extern"]
    pub fn nir_intrinsic_has_num_components(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_num_array_elems__extern"]
    pub fn nir_intrinsic_num_array_elems(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_num_array_elems__extern"]
    pub fn nir_intrinsic_set_num_array_elems(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_num_array_elems__extern"]
    pub fn nir_intrinsic_has_num_array_elems(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_bit_size__extern"]
    pub fn nir_intrinsic_bit_size(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_bit_size__extern"]
    pub fn nir_intrinsic_set_bit_size(instr: *mut nir_intrinsic_instr, val: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_bit_size__extern"]
    pub fn nir_intrinsic_has_bit_size(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_divergent__extern"]
    pub fn nir_intrinsic_divergent(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_divergent__extern"]
    pub fn nir_intrinsic_set_divergent(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_divergent__extern"]
    pub fn nir_intrinsic_has_divergent(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_legacy_fabs__extern"]
    pub fn nir_intrinsic_legacy_fabs(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_legacy_fabs__extern"]
    pub fn nir_intrinsic_set_legacy_fabs(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_legacy_fabs__extern"]
    pub fn nir_intrinsic_has_legacy_fabs(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_legacy_fneg__extern"]
    pub fn nir_intrinsic_legacy_fneg(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_legacy_fneg__extern"]
    pub fn nir_intrinsic_set_legacy_fneg(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_legacy_fneg__extern"]
    pub fn nir_intrinsic_has_legacy_fneg(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_legacy_fsat__extern"]
    pub fn nir_intrinsic_legacy_fsat(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_legacy_fsat__extern"]
    pub fn nir_intrinsic_set_legacy_fsat(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_legacy_fsat__extern"]
    pub fn nir_intrinsic_has_legacy_fsat(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_cmat_desc__extern"]
    pub fn nir_intrinsic_cmat_desc(instr: *const nir_intrinsic_instr) -> glsl_cmat_description;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_cmat_desc__extern"]
    pub fn nir_intrinsic_set_cmat_desc(instr: *mut nir_intrinsic_instr, val: glsl_cmat_description);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_cmat_desc__extern"]
    pub fn nir_intrinsic_has_cmat_desc(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_matrix_layout__extern"]
    pub fn nir_intrinsic_matrix_layout(instr: *const nir_intrinsic_instr) -> glsl_matrix_layout;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_matrix_layout__extern"]
    pub fn nir_intrinsic_set_matrix_layout(
        instr: *mut nir_intrinsic_instr,
        val: glsl_matrix_layout,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_matrix_layout__extern"]
    pub fn nir_intrinsic_has_matrix_layout(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_cmat_signed_mask__extern"]
    pub fn nir_intrinsic_cmat_signed_mask(instr: *const nir_intrinsic_instr) -> nir_cmat_signed;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_cmat_signed_mask__extern"]
    pub fn nir_intrinsic_set_cmat_signed_mask(
        instr: *mut nir_intrinsic_instr,
        val: nir_cmat_signed,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_cmat_signed_mask__extern"]
    pub fn nir_intrinsic_has_cmat_signed_mask(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_alu_op__extern"]
    pub fn nir_intrinsic_alu_op(instr: *const nir_intrinsic_instr) -> nir_op;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_alu_op__extern"]
    pub fn nir_intrinsic_set_alu_op(instr: *mut nir_intrinsic_instr, val: nir_op);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_alu_op__extern"]
    pub fn nir_intrinsic_has_alu_op(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_systolic_depth__extern"]
    pub fn nir_intrinsic_systolic_depth(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_systolic_depth__extern"]
    pub fn nir_intrinsic_set_systolic_depth(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_systolic_depth__extern"]
    pub fn nir_intrinsic_has_systolic_depth(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_repeat_count__extern"]
    pub fn nir_intrinsic_repeat_count(instr: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_repeat_count__extern"]
    pub fn nir_intrinsic_set_repeat_count(
        instr: *mut nir_intrinsic_instr,
        val: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_repeat_count__extern"]
    pub fn nir_intrinsic_has_repeat_count(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_explicit_coord__extern"]
    pub fn nir_intrinsic_explicit_coord(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_explicit_coord__extern"]
    pub fn nir_intrinsic_set_explicit_coord(instr: *mut nir_intrinsic_instr, val: bool);
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_explicit_coord__extern"]
    pub fn nir_intrinsic_has_explicit_coord(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_set_align__extern"]
    pub fn nir_intrinsic_set_align(
        intrin: *mut nir_intrinsic_instr,
        align_mul: ::std::os::raw::c_uint,
        align_offset: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[doc = " Returns a simple alignment for an align_mul/offset pair\n\n This helper converts from the full mul+offset alignment scheme used by\n most NIR intrinsics to a simple alignment.  The returned value is the\n largest power of two which divides both align_mul and align_offset.\n For any offset X which satisfies the complex alignment described by\n align_mul/offset, X % align == 0."]
    #[link_name = "nir_combined_align__extern"]
    pub fn nir_combined_align(align_mul: u32, align_offset: u32) -> u32;
}
unsafe extern "C" {
    #[doc = " Returns a simple alignment for a load/store intrinsic offset\n\n Instead of the full mul+offset alignment scheme provided by the ALIGN_MUL\n and ALIGN_OFFSET parameters, this helper takes both into account and\n provides a single simple alignment parameter.  The offset X is guaranteed\n to satisfy X % align == 0."]
    #[link_name = "nir_intrinsic_align__extern"]
    pub fn nir_intrinsic_align(intrin: *const nir_intrinsic_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_has_align__extern"]
    pub fn nir_intrinsic_has_align(intrin: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_image_intrinsic_coord_components(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_rewrite_image_intrinsic(
        instr: *mut nir_intrinsic_instr,
        handle: *mut nir_def,
        bindless: bool,
    );
}
unsafe extern "C" {
    pub fn nir_intrinsic_can_reorder(instr: *mut nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_intrinsic_writes_external_memory(instr: *const nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_intrinsic_is_ray_query__extern"]
    pub fn nir_intrinsic_is_ray_query(intrinsic: nir_intrinsic_op) -> bool;
}
#[repr(u32)]
#[doc = " Texture instruction source type"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_tex_src_type {
    #[doc = " Texture coordinate\n\n Must have :c:member:`nir_tex_instr.coord_components` components."]
    nir_tex_src_coord = 0,
    #[doc = " Projector\n\n The texture coordinate (except for the array component, if any) is\n divided by this value before LOD computation and sampling.\n\n Must be a float scalar."]
    nir_tex_src_projector = 1,
    #[doc = " Shadow comparator\n\n For shadow sampling, the fetched texel values are compared against the\n shadow comparator using the compare op specified by the sampler object\n and converted to 1.0 if the comparison succeeds and 0.0 if it fails.\n Interpolation happens after this conversion so the actual result may be\n anywhere in the range [0.0, 1.0].\n\n Only valid if :c:member:`nir_tex_instr.is_shadow` and must be a float\n scalar."]
    nir_tex_src_comparator = 2,
    #[doc = " Coordinate offset\n\n An integer value that is added to the texel address before sampling.\n This is only allowed with operations that take an explicit LOD as it is\n applied in integer texel space after LOD selection and not normalized\n coordinate space."]
    nir_tex_src_offset = 3,
    #[doc = " LOD bias\n\n This value is added to the computed LOD before mip-mapping."]
    nir_tex_src_bias = 4,
    #[doc = " Explicit LOD"]
    nir_tex_src_lod = 5,
    #[doc = " Min LOD\n\n The computed LOD is clamped to be at least as large as min_lod before\n mip-mapping."]
    nir_tex_src_min_lod = 6,
    #[doc = " MSAA sample index"]
    nir_tex_src_ms_index = 7,
    #[doc = " Intel-specific MSAA compression data"]
    nir_tex_src_ms_mcs_intel = 8,
    #[doc = " Explicit horizontal (X-major) coordinate derivative"]
    nir_tex_src_ddx = 9,
    #[doc = " Explicit vertical (Y-major) coordinate derivative"]
    nir_tex_src_ddy = 10,
    #[doc = " Texture variable dereference"]
    nir_tex_src_texture_deref = 11,
    #[doc = " Sampler variable dereference"]
    nir_tex_src_sampler_deref = 12,
    #[doc = " Texture index offset\n\n This is added to :c:member:`nir_tex_instr.texture_index`.  Unless\n :c:member:`nir_tex_instr.texture_non_uniform` is set, this is guaranteed\n to be dynamically uniform."]
    nir_tex_src_texture_offset = 13,
    #[doc = " Dynamically uniform sampler index offset\n\n This is added to :c:member:`nir_tex_instr.sampler_index`.  Unless\n :c:member:`nir_tex_instr.sampler_non_uniform` is set, this is guaranteed to be\n dynamically uniform.  This should not be present until GLSL ES 3.20, GLSL\n 4.00, or ARB_gpu_shader5, because in ES 3.10 and GL 3.30 samplers said\n \"When aggregated into arrays within a shader, samplers can only be indexed\n with a constant integral expression.\""]
    nir_tex_src_sampler_offset = 14,
    #[doc = " Bindless texture handle\n\n This is, unfortunately, a bit overloaded at the moment.  There are\n generally two types of bindless handles:\n\n  1. For GL_ARB_bindless bindless handles. These are part of the\n     GL/Gallium-level API and are always a 64-bit integer.\n\n  2. HW-specific handles.  GL_ARB_bindless handles may be lowered to\n     these.  Also, these are used by many Vulkan drivers to implement\n     descriptor sets, especially for UPDATE_AFTER_BIND descriptors.\n     The details of hardware handles (bit size, format, etc.) is\n     HW-specific.\n\n Because of this overloading and the resulting ambiguity, we currently\n don't validate anything for these."]
    nir_tex_src_texture_handle = 15,
    #[doc = " Bindless sampler handle\n\n See nir_tex_src_texture_handle,"]
    nir_tex_src_sampler_handle = 16,
    #[doc = " Tex src intrinsic\n\n This is an intrinsic used before function inlining i.e. before we know\n if a bindless value has been given as function param for use as a tex\n src."]
    nir_tex_src_sampler_deref_intrinsic = 17,
    #[doc = " Tex src intrinsic\n\n This is an intrinsic used before function inlining i.e. before we know\n if a bindless value has been given as function param for use as a tex\n src."]
    nir_tex_src_texture_deref_intrinsic = 18,
    #[doc = " Plane index for multi-plane YCbCr textures"]
    nir_tex_src_plane = 19,
    #[doc = " Backend-specific vec4 tex src argument.\n\n Can be used to have NIR optimization (copy propagation, lower_vec_to_regs)\n apply to the packing of the tex srcs.  This lowering must only happen\n after nir_lower_tex().\n\n The nir_tex_instr_src_type() of this argument is float, so no lowering\n will happen if nir_lower_int_to_float is used."]
    nir_tex_src_backend1 = 20,
    #[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
    nir_tex_src_backend2 = 21,
    #[doc = " Second backend-specific vec4 tex src argument, see nir_tex_src_backend1."]
    nir_num_tex_src_types = 22,
}
#[doc = " A texture instruction source"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_src {
    #[doc = " Base source"]
    pub src: nir_src,
    #[doc = " Type of this source"]
    pub src_type: nir_tex_src_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_src"][::std::mem::size_of::<nir_tex_src>() - 20usize];
    ["Alignment of nir_tex_src"][::std::mem::align_of::<nir_tex_src>() - 4usize];
    ["Offset of field: nir_tex_src::src"][::std::mem::offset_of!(nir_tex_src, src) - 0usize];
    ["Offset of field: nir_tex_src::src_type"]
        [::std::mem::offset_of!(nir_tex_src, src_type) - 16usize];
};
impl Default for nir_tex_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[doc = " Texture instruction opcode"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_texop {
    #[doc = " Regular texture look-up"]
    nir_texop_tex = 0,
    #[doc = " Texture look-up with LOD bias"]
    nir_texop_txb = 1,
    #[doc = " Texture look-up with explicit LOD"]
    nir_texop_txl = 2,
    #[doc = " Texture look-up with partial derivatives"]
    nir_texop_txd = 3,
    #[doc = " Texel fetch with explicit LOD"]
    nir_texop_txf = 4,
    #[doc = " Multisample texture fetch"]
    nir_texop_txf_ms = 5,
    #[doc = " Multisample texture fetch from framebuffer"]
    nir_texop_txf_ms_fb = 6,
    #[doc = " Multisample compression value fetch"]
    nir_texop_txf_ms_mcs_intel = 7,
    #[doc = " Texture size"]
    nir_texop_txs = 8,
    #[doc = " Texture lod query"]
    nir_texop_lod = 9,
    #[doc = " Texture gather"]
    nir_texop_tg4 = 10,
    #[doc = " Texture levels query"]
    nir_texop_query_levels = 11,
    #[doc = " Texture samples query"]
    nir_texop_texture_samples = 12,
    #[doc = " Query whether all samples are definitely identical."]
    nir_texop_samples_identical = 13,
    #[doc = " Regular texture look-up, eligible for pre-dispatch"]
    nir_texop_tex_prefetch = 14,
    #[doc = " Multisample fragment color texture fetch"]
    nir_texop_fragment_fetch_amd = 15,
    #[doc = " Multisample fragment mask texture fetch"]
    nir_texop_fragment_mask_fetch_amd = 16,
    #[doc = " Returns a buffer or image descriptor."]
    nir_texop_descriptor_amd = 17,
    #[doc = " Returns a sampler descriptor."]
    nir_texop_sampler_descriptor_amd = 18,
    #[doc = " Returns the sampler's LOD bias"]
    nir_texop_lod_bias_agx = 19,
    #[doc = " Returns a bool indicating that the sampler uses a custom border colour"]
    nir_texop_has_custom_border_color_agx = 20,
    #[doc = " Returns the sampler's custom border colour (if has_custom_border_agx)"]
    nir_texop_custom_border_color_agx = 21,
    #[doc = " Maps to TXQ.DIMENSION"]
    nir_texop_hdr_dim_nv = 22,
    #[doc = " Maps to TXQ.TEXTURE_TYPE"]
    nir_texop_tex_type_nv = 23,
}
#[doc = " Represents a texture instruction"]
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_instr {
    #[doc = " Base instruction"]
    pub instr: nir_instr,
    #[doc = " Dimensionality of the texture operation\n\n This will typically match the dimensionality of the texture deref type\n if a nir_tex_src_texture_deref is present.  However, it may not if\n texture lowering has occurred."]
    pub sampler_dim: glsl_sampler_dim,
    #[doc = " ALU type of the destination\n\n This is the canonical sampled type for this texture operation and may\n not exactly match the sampled type of the deref type when a\n nir_tex_src_texture_deref is present.  For OpenCL, the sampled type of\n the texture deref will be GLSL_TYPE_VOID and this is allowed to be\n anything.  With SPIR-V, the signedness of integer types is allowed to\n differ.  For all APIs, the bit size may differ if the driver has done\n any sort of mediump or similar lowering since texture types always have\n 32-bit sampled types."]
    pub dest_type: nir_alu_type,
    #[doc = " Texture opcode"]
    pub op: nir_texop,
    #[doc = " Destination"]
    pub def: nir_def,
    #[doc = " Array of sources\n\n This array has :c:member:`nir_tex_instr.num_srcs` elements"]
    pub src: *mut nir_tex_src,
    #[doc = " Number of sources"]
    pub num_srcs: ::std::os::raw::c_uint,
    #[doc = " Number of components in the coordinate, if any"]
    pub coord_components: ::std::os::raw::c_uint,
    #[doc = " True if the texture instruction acts on an array texture"]
    pub is_array: bool,
    #[doc = " True if the texture instruction performs a shadow comparison\n\n If this is true, the texture instruction must have a\n nir_tex_src_comparator."]
    pub is_shadow: bool,
    #[doc = " If is_shadow is true, whether this is the old-style shadow that outputs\n 4 components or the new-style shadow that outputs 1 component."]
    pub is_new_style_shadow: bool,
    #[doc = " True if this texture instruction should return a sparse residency code.\n The code is in the last component of the result."]
    pub is_sparse: bool,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    #[doc = " Gather offsets"]
    pub tg4_offsets: [[i8; 2usize]; 4usize],
    #[doc = " True if the texture index or handle is not dynamically uniform"]
    pub texture_non_uniform: bool,
    #[doc = " True if the sampler index or handle is not dynamically uniform.\n\n This may be set when VK_EXT_descriptor_indexing is supported and the\n appropriate capability is enabled.\n\n This should always be false in GLSL (GLSL ES 3.20 says \"When aggregated\n into arrays within a shader, opaque types can only be indexed with a\n dynamically uniform integral expression\", and GLSL 4.60 says \"When\n aggregated into arrays within a shader, [texture, sampler, and\n samplerShadow] types can only be indexed with a dynamically uniform\n expression, or texture lookup will result in undefined values.\")."]
    pub sampler_non_uniform: bool,
    #[doc = " The texture index\n\n If this texture instruction has a nir_tex_src_texture_offset source,\n then the texture index is given by texture_index + texture_offset."]
    pub texture_index: ::std::os::raw::c_uint,
    #[doc = " The sampler index\n\n The following operations do not require a sampler and, as such, this\n field should be ignored:\n\n    - nir_texop_txf\n    - nir_texop_txf_ms\n    - nir_texop_txs\n    - nir_texop_query_levels\n    - nir_texop_texture_samples\n    - nir_texop_samples_identical\n\n If this texture instruction has a nir_tex_src_sampler_offset source,\n then the sampler index is given by sampler_index + sampler_offset."]
    pub sampler_index: ::std::os::raw::c_uint,
    pub backend_flags: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_instr"][::std::mem::size_of::<nir_tex_instr>() - 92usize];
    ["Alignment of nir_tex_instr"][::std::mem::align_of::<nir_tex_instr>() - 4usize];
    ["Offset of field: nir_tex_instr::instr"]
        [::std::mem::offset_of!(nir_tex_instr, instr) - 0usize];
    ["Offset of field: nir_tex_instr::sampler_dim"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_dim) - 20usize];
    ["Offset of field: nir_tex_instr::dest_type"]
        [::std::mem::offset_of!(nir_tex_instr, dest_type) - 24usize];
    ["Offset of field: nir_tex_instr::op"][::std::mem::offset_of!(nir_tex_instr, op) - 28usize];
    ["Offset of field: nir_tex_instr::def"][::std::mem::offset_of!(nir_tex_instr, def) - 32usize];
    ["Offset of field: nir_tex_instr::src"][::std::mem::offset_of!(nir_tex_instr, src) - 52usize];
    ["Offset of field: nir_tex_instr::num_srcs"]
        [::std::mem::offset_of!(nir_tex_instr, num_srcs) - 56usize];
    ["Offset of field: nir_tex_instr::coord_components"]
        [::std::mem::offset_of!(nir_tex_instr, coord_components) - 60usize];
    ["Offset of field: nir_tex_instr::is_array"]
        [::std::mem::offset_of!(nir_tex_instr, is_array) - 64usize];
    ["Offset of field: nir_tex_instr::is_shadow"]
        [::std::mem::offset_of!(nir_tex_instr, is_shadow) - 65usize];
    ["Offset of field: nir_tex_instr::is_new_style_shadow"]
        [::std::mem::offset_of!(nir_tex_instr, is_new_style_shadow) - 66usize];
    ["Offset of field: nir_tex_instr::is_sparse"]
        [::std::mem::offset_of!(nir_tex_instr, is_sparse) - 67usize];
    ["Offset of field: nir_tex_instr::tg4_offsets"]
        [::std::mem::offset_of!(nir_tex_instr, tg4_offsets) - 69usize];
    ["Offset of field: nir_tex_instr::texture_non_uniform"]
        [::std::mem::offset_of!(nir_tex_instr, texture_non_uniform) - 77usize];
    ["Offset of field: nir_tex_instr::sampler_non_uniform"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_non_uniform) - 78usize];
    ["Offset of field: nir_tex_instr::texture_index"]
        [::std::mem::offset_of!(nir_tex_instr, texture_index) - 80usize];
    ["Offset of field: nir_tex_instr::sampler_index"]
        [::std::mem::offset_of!(nir_tex_instr, sampler_index) - 84usize];
    ["Offset of field: nir_tex_instr::backend_flags"]
        [::std::mem::offset_of!(nir_tex_instr, backend_flags) - 88usize];
};
impl Default for nir_tex_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_tex_instr {
    #[inline]
    pub fn component(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_component(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn component_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_component_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn array_is_lowered_cube(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_array_is_lowered_cube(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn array_is_lowered_cube_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_array_is_lowered_cube_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn is_gather_implicit_lod(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_gather_implicit_lod(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn is_gather_implicit_lod_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_is_gather_implicit_lod_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        component: ::std::os::raw::c_uint,
        array_is_lowered_cube: ::std::os::raw::c_uint,
        is_gather_implicit_lod: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let component: u32 = unsafe { ::std::mem::transmute(component) };
            component as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let array_is_lowered_cube: u32 =
                unsafe { ::std::mem::transmute(array_is_lowered_cube) };
            array_is_lowered_cube as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_gather_implicit_lod: u32 =
                unsafe { ::std::mem::transmute(is_gather_implicit_lod) };
            is_gather_implicit_lod as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    #[doc = " Returns true if the texture operation requires a sampler as a general rule\n\n Note that the specific hw/driver backend could require to a sampler\n object/configuration packet in any case, for some other reason.\n\n See also :c:member:`nir_tex_instr.sampler_index`."]
    pub fn nir_tex_instr_need_sampler(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns the number of components returned by this nir_tex_instr\n\n Useful for code building texture instructions when you don't want to think\n about how many components a particular texture op returns.  This does not\n include the sparse residency code."]
    pub fn nir_tex_instr_result_size(instr: *const nir_tex_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Returns the destination size of this nir_tex_instr including the sparse\n residency code, if any."]
    #[link_name = "nir_tex_instr_dest_size__extern"]
    pub fn nir_tex_instr_dest_size(instr: *const nir_tex_instr) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Returns true if this texture operation queries something about the texture\n rather than actually sampling it."]
    pub fn nir_tex_instr_is_query(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns true if this texture instruction does implicit derivatives\n\n This is important as there are extra control-flow rules around derivatives\n and texture instructions which perform them implicitly."]
    pub fn nir_tex_instr_has_implicit_derivative(instr: *const nir_tex_instr) -> bool;
}
unsafe extern "C" {
    #[doc = " Returns the ALU type of the given texture instruction source"]
    pub fn nir_tex_instr_src_type(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> nir_alu_type;
}
unsafe extern "C" {
    #[doc = " Returns the number of components required by the given texture instruction\n source"]
    pub fn nir_tex_instr_src_size(
        instr: *const nir_tex_instr,
        src: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[doc = " Returns the index of the texture instruction source with the given\n nir_tex_src_type or -1 if no such source exists."]
    #[link_name = "nir_tex_instr_src_index__extern"]
    pub fn nir_tex_instr_src_index(
        instr: *const nir_tex_instr,
        type_: nir_tex_src_type,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " Adds a source to a texture instruction"]
    pub fn nir_tex_instr_add_src(
        tex: *mut nir_tex_instr,
        src_type: nir_tex_src_type,
        src: *mut nir_def,
    );
}
unsafe extern "C" {
    #[doc = " Removes a source from a texture instruction"]
    pub fn nir_tex_instr_remove_src(tex: *mut nir_tex_instr, src_idx: ::std::os::raw::c_uint);
}
unsafe extern "C" {
    pub fn nir_tex_instr_has_explicit_tg4_offsets(tex: *mut nir_tex_instr) -> bool;
}
#[repr(C)]
pub struct nir_load_const_instr {
    pub instr: nir_instr,
    pub def: nir_def,
    pub value: __IncompleteArrayField<nir_const_value>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_load_const_instr"][::std::mem::size_of::<nir_load_const_instr>() - 40usize];
    ["Alignment of nir_load_const_instr"][::std::mem::align_of::<nir_load_const_instr>() - 4usize];
    ["Offset of field: nir_load_const_instr::instr"]
        [::std::mem::offset_of!(nir_load_const_instr, instr) - 0usize];
    ["Offset of field: nir_load_const_instr::def"]
        [::std::mem::offset_of!(nir_load_const_instr, def) - 20usize];
    ["Offset of field: nir_load_const_instr::value"]
        [::std::mem::offset_of!(nir_load_const_instr, value) - 40usize];
};
impl Default for nir_load_const_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_jump_type {
    #[doc = " Return from a function\n\n This instruction is a classic function return.  It jumps to\n nir_function_impl::end_block.  No return value is provided in this\n instruction.  Instead, the function is expected to write any return\n data to a deref passed in from the caller."]
    nir_jump_return = 0,
    #[doc = " Immediately exit the current shader\n\n This instruction is roughly the equivalent of C's \"exit()\" in that it\n immediately terminates the current shader invocation.  From a CFG\n perspective, it looks like a jump to nir_function_impl::end_block but\n it actually jumps to the end block of the shader entrypoint.  A halt\n instruction in the shader entrypoint itself is semantically identical\n to a return.\n\n For shaders with built-in I/O, any outputs written prior to a halt\n instruction remain written and any outputs not written prior to the\n halt have undefined values.  It does NOT cause an implicit discard of\n written results.  If one wants discard results in a fragment shader,\n for instance, a discard or demote intrinsic is required."]
    nir_jump_halt = 1,
    #[doc = " Break out of the inner-most loop\n\n This has the same semantics as C's \"break\" statement."]
    nir_jump_break = 2,
    #[doc = " Jump back to the top of the inner-most loop\n\n This has the same semantics as C's \"continue\" statement assuming that a\n NIR loop is implemented as \"while (1) { body }\"."]
    nir_jump_continue = 3,
    #[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
    nir_jump_goto = 4,
    #[doc = " Jumps for unstructured CFG.\n\n As within an unstructured CFG we can't rely on block ordering we need to\n place explicit jumps at the end of every block."]
    nir_jump_goto_if = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_jump_instr {
    pub instr: nir_instr,
    pub type_: nir_jump_type,
    pub condition: nir_src,
    pub target: *mut nir_block,
    pub else_target: *mut nir_block,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_jump_instr"][::std::mem::size_of::<nir_jump_instr>() - 48usize];
    ["Alignment of nir_jump_instr"][::std::mem::align_of::<nir_jump_instr>() - 4usize];
    ["Offset of field: nir_jump_instr::instr"]
        [::std::mem::offset_of!(nir_jump_instr, instr) - 0usize];
    ["Offset of field: nir_jump_instr::type_"]
        [::std::mem::offset_of!(nir_jump_instr, type_) - 20usize];
    ["Offset of field: nir_jump_instr::condition"]
        [::std::mem::offset_of!(nir_jump_instr, condition) - 24usize];
    ["Offset of field: nir_jump_instr::target"]
        [::std::mem::offset_of!(nir_jump_instr, target) - 40usize];
    ["Offset of field: nir_jump_instr::else_target"]
        [::std::mem::offset_of!(nir_jump_instr, else_target) - 44usize];
};
impl Default for nir_jump_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_undef_instr {
    pub instr: nir_instr,
    pub def: nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_undef_instr"][::std::mem::size_of::<nir_undef_instr>() - 40usize];
    ["Alignment of nir_undef_instr"][::std::mem::align_of::<nir_undef_instr>() - 4usize];
    ["Offset of field: nir_undef_instr::instr"]
        [::std::mem::offset_of!(nir_undef_instr, instr) - 0usize];
    ["Offset of field: nir_undef_instr::def"]
        [::std::mem::offset_of!(nir_undef_instr, def) - 20usize];
};
impl Default for nir_undef_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_phi_src {
    pub node: exec_node,
    pub pred: *mut nir_block,
    pub src: nir_src,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_phi_src"][::std::mem::size_of::<nir_phi_src>() - 28usize];
    ["Alignment of nir_phi_src"][::std::mem::align_of::<nir_phi_src>() - 4usize];
    ["Offset of field: nir_phi_src::node"][::std::mem::offset_of!(nir_phi_src, node) - 0usize];
    ["Offset of field: nir_phi_src::pred"][::std::mem::offset_of!(nir_phi_src, pred) - 8usize];
    ["Offset of field: nir_phi_src::src"][::std::mem::offset_of!(nir_phi_src, src) - 12usize];
};
impl Default for nir_phi_src {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_phi_instr {
    pub instr: nir_instr,
    #[doc = " list of nir_phi_src"]
    pub srcs: exec_list,
    pub def: nir_def,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_phi_instr"][::std::mem::size_of::<nir_phi_instr>() - 56usize];
    ["Alignment of nir_phi_instr"][::std::mem::align_of::<nir_phi_instr>() - 4usize];
    ["Offset of field: nir_phi_instr::instr"]
        [::std::mem::offset_of!(nir_phi_instr, instr) - 0usize];
    ["Offset of field: nir_phi_instr::srcs"][::std::mem::offset_of!(nir_phi_instr, srcs) - 20usize];
    ["Offset of field: nir_phi_instr::def"][::std::mem::offset_of!(nir_phi_instr, def) - 36usize];
};
impl Default for nir_phi_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_phi_get_src_from_block__extern"]
    pub fn nir_phi_get_src_from_block(
        phi: *mut nir_phi_instr,
        block: *mut nir_block,
    ) -> *mut nir_phi_src;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_parallel_copy_instr {
    pub instr: nir_instr,
    pub entries: exec_list,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parallel_copy_instr"][::std::mem::size_of::<nir_parallel_copy_instr>() - 36usize];
    ["Alignment of nir_parallel_copy_instr"]
        [::std::mem::align_of::<nir_parallel_copy_instr>() - 4usize];
    ["Offset of field: nir_parallel_copy_instr::instr"]
        [::std::mem::offset_of!(nir_parallel_copy_instr, instr) - 0usize];
    ["Offset of field: nir_parallel_copy_instr::entries"]
        [::std::mem::offset_of!(nir_parallel_copy_instr, entries) - 20usize];
};
impl Default for nir_parallel_copy_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_debug_info_type {
    nir_debug_info_src_loc = 0,
    nir_debug_info_string = 1,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_debug_info_source {
    nir_debug_info_spirv = 0,
    nir_debug_info_nir = 1,
}
#[repr(C)]
pub struct nir_debug_info_instr {
    pub instr: nir_instr,
    pub type_: nir_debug_info_type,
    pub anon_1: nir_debug_info_instr__bindgen_ty_1,
    pub def: nir_def,
    pub string: __IncompleteArrayField<::std::os::raw::c_char>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_debug_info_instr__bindgen_ty_1 {
    pub src_loc: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1,
    pub string_length: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1 {
    pub filename: nir_src,
    pub line: u32,
    pub column: u32,
    pub spirv_offset: u32,
    pub source: nir_debug_info_source,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::size_of::<nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1>() - 32usize];
    ["Alignment of nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1"]
        [::std::mem::align_of::<nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1::filename"][::std::mem::offset_of!(
        nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1,
        filename
    ) - 0usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1::line"]
        [::std::mem::offset_of!(nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1, line) - 16usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1::column"][::std::mem::offset_of!(
        nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1,
        column
    ) - 20usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1::spirv_offset"][::std::mem::offset_of!(
        nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1,
        spirv_offset
    )
        - 24usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1::source"][::std::mem::offset_of!(
        nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1,
        source
    ) - 28usize];
};
impl Default for nir_debug_info_instr__bindgen_ty_1__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_debug_info_instr__bindgen_ty_1"]
        [::std::mem::size_of::<nir_debug_info_instr__bindgen_ty_1>() - 32usize];
    ["Alignment of nir_debug_info_instr__bindgen_ty_1"]
        [::std::mem::align_of::<nir_debug_info_instr__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1::src_loc"]
        [::std::mem::offset_of!(nir_debug_info_instr__bindgen_ty_1, src_loc) - 0usize];
    ["Offset of field: nir_debug_info_instr__bindgen_ty_1::string_length"]
        [::std::mem::offset_of!(nir_debug_info_instr__bindgen_ty_1, string_length) - 0usize];
};
impl Default for nir_debug_info_instr__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_debug_info_instr"][::std::mem::size_of::<nir_debug_info_instr>() - 76usize];
    ["Alignment of nir_debug_info_instr"][::std::mem::align_of::<nir_debug_info_instr>() - 4usize];
    ["Offset of field: nir_debug_info_instr::instr"]
        [::std::mem::offset_of!(nir_debug_info_instr, instr) - 0usize];
    ["Offset of field: nir_debug_info_instr::type_"]
        [::std::mem::offset_of!(nir_debug_info_instr, type_) - 20usize];
    ["Offset of field: nir_debug_info_instr::def"]
        [::std::mem::offset_of!(nir_debug_info_instr, def) - 56usize];
    ["Offset of field: nir_debug_info_instr::string"]
        [::std::mem::offset_of!(nir_debug_info_instr, string) - 76usize];
};
impl Default for nir_debug_info_instr {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_alu__extern"]
    pub fn nir_instr_as_alu(parent: *const nir_instr) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_deref__extern"]
    pub fn nir_instr_as_deref(parent: *const nir_instr) -> *mut nir_deref_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_call__extern"]
    pub fn nir_instr_as_call(parent: *const nir_instr) -> *mut nir_call_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_jump__extern"]
    pub fn nir_instr_as_jump(parent: *const nir_instr) -> *mut nir_jump_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_tex__extern"]
    pub fn nir_instr_as_tex(parent: *const nir_instr) -> *mut nir_tex_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_intrinsic__extern"]
    pub fn nir_instr_as_intrinsic(parent: *const nir_instr) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_load_const__extern"]
    pub fn nir_instr_as_load_const(parent: *const nir_instr) -> *mut nir_load_const_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_undef__extern"]
    pub fn nir_instr_as_undef(parent: *const nir_instr) -> *mut nir_undef_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_phi__extern"]
    pub fn nir_instr_as_phi(parent: *const nir_instr) -> *mut nir_phi_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_parallel_copy__extern"]
    pub fn nir_instr_as_parallel_copy(parent: *const nir_instr) -> *mut nir_parallel_copy_instr;
}
unsafe extern "C" {
    #[link_name = "nir_instr_as_debug_info__extern"]
    pub fn nir_instr_as_debug_info(parent: *const nir_instr) -> *mut nir_debug_info_instr;
}
unsafe extern "C" {
    #[link_name = "nir_src_comp_as_int__extern"]
    pub fn nir_src_comp_as_int(src: nir_src, comp: ::std::os::raw::c_uint) -> i64;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_int__extern"]
    pub fn nir_src_as_int(src: nir_src) -> i64;
}
unsafe extern "C" {
    #[link_name = "nir_src_comp_as_uint__extern"]
    pub fn nir_src_comp_as_uint(src: nir_src, comp: ::std::os::raw::c_uint) -> u64;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_uint__extern"]
    pub fn nir_src_as_uint(src: nir_src) -> u64;
}
unsafe extern "C" {
    #[link_name = "nir_src_comp_as_bool__extern"]
    pub fn nir_src_comp_as_bool(src: nir_src, comp: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_bool__extern"]
    pub fn nir_src_as_bool(src: nir_src) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_src_comp_as_float__extern"]
    pub fn nir_src_comp_as_float(
        src: nir_src,
        comp: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_double;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_float__extern"]
    pub fn nir_src_as_float(src: nir_src) -> ::std::os::raw::c_double;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_scalar {
    pub def: *mut nir_def,
    pub comp: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_scalar"][::std::mem::size_of::<nir_scalar>() - 8usize];
    ["Alignment of nir_scalar"][::std::mem::align_of::<nir_scalar>() - 4usize];
    ["Offset of field: nir_scalar::def"][::std::mem::offset_of!(nir_scalar, def) - 0usize];
    ["Offset of field: nir_scalar::comp"][::std::mem::offset_of!(nir_scalar, comp) - 4usize];
};
impl Default for nir_scalar {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_scalar_is_const__extern"]
    pub fn nir_scalar_is_const(s: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_is_undef__extern"]
    pub fn nir_scalar_is_undef(s: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_as_const_value__extern"]
    pub fn nir_scalar_as_const_value(s: nir_scalar) -> nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_as_int__extern"]
    pub fn nir_scalar_as_int(s: nir_scalar) -> i64;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_as_uint__extern"]
    pub fn nir_scalar_as_uint(s: nir_scalar) -> u64;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_as_bool__extern"]
    pub fn nir_scalar_as_bool(s: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_as_float__extern"]
    pub fn nir_scalar_as_float(s: nir_scalar) -> ::std::os::raw::c_double;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_is_alu__extern"]
    pub fn nir_scalar_is_alu(s: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_alu_op__extern"]
    pub fn nir_scalar_alu_op(s: nir_scalar) -> nir_op;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_is_intrinsic__extern"]
    pub fn nir_scalar_is_intrinsic(s: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_intrinsic_op__extern"]
    pub fn nir_scalar_intrinsic_op(s: nir_scalar) -> nir_intrinsic_op;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_chase_alu_src__extern"]
    pub fn nir_scalar_chase_alu_src(
        s: nir_scalar,
        alu_src_idx: ::std::os::raw::c_uint,
    ) -> nir_scalar;
}
unsafe extern "C" {
    pub fn nir_scalar_chase_movs(s: nir_scalar) -> nir_scalar;
}
unsafe extern "C" {
    #[link_name = "nir_get_scalar__extern"]
    pub fn nir_get_scalar(def: *mut nir_def, channel: ::std::os::raw::c_uint) -> nir_scalar;
}
unsafe extern "C" {
    #[doc = " Returns a nir_scalar where we've followed the bit-exact mov/vec use chain to the original definition"]
    #[link_name = "nir_scalar_resolved__extern"]
    pub fn nir_scalar_resolved(def: *mut nir_def, channel: ::std::os::raw::c_uint) -> nir_scalar;
}
unsafe extern "C" {
    #[link_name = "nir_scalar_equal__extern"]
    pub fn nir_scalar_equal(s1: nir_scalar, s2: nir_scalar) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_alu_src_as_uint__extern"]
    pub fn nir_alu_src_as_uint(src: nir_alu_src) -> u64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_binding {
    pub success: bool,
    pub var: *mut nir_variable,
    pub desc_set: ::std::os::raw::c_uint,
    pub binding: ::std::os::raw::c_uint,
    pub num_indices: ::std::os::raw::c_uint,
    pub indices: [nir_src; 4usize],
    pub read_first_invocation: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_binding"][::std::mem::size_of::<nir_binding>() - 88usize];
    ["Alignment of nir_binding"][::std::mem::align_of::<nir_binding>() - 4usize];
    ["Offset of field: nir_binding::success"]
        [::std::mem::offset_of!(nir_binding, success) - 0usize];
    ["Offset of field: nir_binding::var"][::std::mem::offset_of!(nir_binding, var) - 4usize];
    ["Offset of field: nir_binding::desc_set"]
        [::std::mem::offset_of!(nir_binding, desc_set) - 8usize];
    ["Offset of field: nir_binding::binding"]
        [::std::mem::offset_of!(nir_binding, binding) - 12usize];
    ["Offset of field: nir_binding::num_indices"]
        [::std::mem::offset_of!(nir_binding, num_indices) - 16usize];
    ["Offset of field: nir_binding::indices"]
        [::std::mem::offset_of!(nir_binding, indices) - 20usize];
    ["Offset of field: nir_binding::read_first_invocation"]
        [::std::mem::offset_of!(nir_binding, read_first_invocation) - 84usize];
};
impl Default for nir_binding {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_chase_binding(rsrc: nir_src) -> nir_binding;
}
unsafe extern "C" {
    pub fn nir_get_binding_variable(
        shader: *mut nir_shader,
        binding: nir_binding,
    ) -> *mut nir_variable;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_cf_node_type {
    nir_cf_node_block = 0,
    nir_cf_node_if = 1,
    nir_cf_node_loop = 2,
    nir_cf_node_function = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_cf_node {
    pub node: exec_node,
    pub type_: nir_cf_node_type,
    pub parent: *mut nir_cf_node,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cf_node"][::std::mem::size_of::<nir_cf_node>() - 16usize];
    ["Alignment of nir_cf_node"][::std::mem::align_of::<nir_cf_node>() - 4usize];
    ["Offset of field: nir_cf_node::node"][::std::mem::offset_of!(nir_cf_node, node) - 0usize];
    ["Offset of field: nir_cf_node::type_"][::std::mem::offset_of!(nir_cf_node, type_) - 8usize];
    ["Offset of field: nir_cf_node::parent"][::std::mem::offset_of!(nir_cf_node, parent) - 12usize];
};
impl Default for nir_cf_node {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_block {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_instr"]
    pub instr_list: exec_list,
    #[doc = " generic block index; generated by nir_index_blocks"]
    pub index: ::std::os::raw::c_uint,
    pub divergent: bool,
    pub successors: [*mut nir_block; 2usize],
    pub predecessors: *mut set,
    pub imm_dom: *mut nir_block,
    pub num_dom_children: ::std::os::raw::c_uint,
    pub dom_children: *mut *mut nir_block,
    pub dom_frontier: *mut set,
    pub dom_pre_index: u32,
    pub dom_post_index: u32,
    #[doc = " Value just before the first nir_instr->index in the block, but after\n end_ip that of any predecessor block."]
    pub start_ip: u32,
    #[doc = " Value just after the last nir_instr->index in the block, but before the\n start_ip of any successor block."]
    pub end_ip: u32,
    pub live_in: *mut ::std::os::raw::c_uint,
    pub live_out: *mut ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_block"][::std::mem::size_of::<nir_block>() - 92usize];
    ["Alignment of nir_block"][::std::mem::align_of::<nir_block>() - 4usize];
    ["Offset of field: nir_block::cf_node"][::std::mem::offset_of!(nir_block, cf_node) - 0usize];
    ["Offset of field: nir_block::instr_list"]
        [::std::mem::offset_of!(nir_block, instr_list) - 16usize];
    ["Offset of field: nir_block::index"][::std::mem::offset_of!(nir_block, index) - 32usize];
    ["Offset of field: nir_block::divergent"]
        [::std::mem::offset_of!(nir_block, divergent) - 36usize];
    ["Offset of field: nir_block::successors"]
        [::std::mem::offset_of!(nir_block, successors) - 40usize];
    ["Offset of field: nir_block::predecessors"]
        [::std::mem::offset_of!(nir_block, predecessors) - 48usize];
    ["Offset of field: nir_block::imm_dom"][::std::mem::offset_of!(nir_block, imm_dom) - 52usize];
    ["Offset of field: nir_block::num_dom_children"]
        [::std::mem::offset_of!(nir_block, num_dom_children) - 56usize];
    ["Offset of field: nir_block::dom_children"]
        [::std::mem::offset_of!(nir_block, dom_children) - 60usize];
    ["Offset of field: nir_block::dom_frontier"]
        [::std::mem::offset_of!(nir_block, dom_frontier) - 64usize];
    ["Offset of field: nir_block::dom_pre_index"]
        [::std::mem::offset_of!(nir_block, dom_pre_index) - 68usize];
    ["Offset of field: nir_block::dom_post_index"]
        [::std::mem::offset_of!(nir_block, dom_post_index) - 72usize];
    ["Offset of field: nir_block::start_ip"][::std::mem::offset_of!(nir_block, start_ip) - 76usize];
    ["Offset of field: nir_block::end_ip"][::std::mem::offset_of!(nir_block, end_ip) - 80usize];
    ["Offset of field: nir_block::live_in"][::std::mem::offset_of!(nir_block, live_in) - 84usize];
    ["Offset of field: nir_block::live_out"][::std::mem::offset_of!(nir_block, live_out) - 88usize];
};
impl Default for nir_block {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_block_is_reachable__extern"]
    pub fn nir_block_is_reachable(b: *mut nir_block) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_block_first_instr__extern"]
    pub fn nir_block_first_instr(block: *mut nir_block) -> *mut nir_instr;
}
unsafe extern "C" {
    #[link_name = "nir_block_last_instr__extern"]
    pub fn nir_block_last_instr(block: *mut nir_block) -> *mut nir_instr;
}
unsafe extern "C" {
    #[link_name = "nir_block_ends_in_jump__extern"]
    pub fn nir_block_ends_in_jump(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_block_ends_in_return_or_halt__extern"]
    pub fn nir_block_ends_in_return_or_halt(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_block_ends_in_break__extern"]
    pub fn nir_block_ends_in_break(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_block_contains_work(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_first_phi_in_block__extern"]
    pub fn nir_first_phi_in_block(block: *mut nir_block) -> *mut nir_phi_instr;
}
unsafe extern "C" {
    #[link_name = "nir_next_phi__extern"]
    pub fn nir_next_phi(phi: *mut nir_phi_instr) -> *mut nir_phi_instr;
}
unsafe extern "C" {
    #[link_name = "nir_block_last_phi_instr__extern"]
    pub fn nir_block_last_phi_instr(block: *mut nir_block) -> *mut nir_phi_instr;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_selection_control {
    nir_selection_control_none = 0,
    #[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to remove control flow."]
    nir_selection_control_flatten = 1,
    #[doc = " Defined by SPIR-V spec 3.22 \"Selection Control\".\n The application prefers to keep control flow."]
    nir_selection_control_dont_flatten = 2,
    #[doc = " May be applied by the compiler stack when it knows\n that a branch is divergent, and:\n - either both the if and else are always taken\n - the if or else is empty and the other is always taken"]
    nir_selection_control_divergent_always_taken = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_if {
    pub cf_node: nir_cf_node,
    pub condition: nir_src,
    pub control: nir_selection_control,
    #[doc = " list of nir_cf_node"]
    pub then_list: exec_list,
    #[doc = " list of nir_cf_node"]
    pub else_list: exec_list,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_if"][::std::mem::size_of::<nir_if>() - 68usize];
    ["Alignment of nir_if"][::std::mem::align_of::<nir_if>() - 4usize];
    ["Offset of field: nir_if::cf_node"][::std::mem::offset_of!(nir_if, cf_node) - 0usize];
    ["Offset of field: nir_if::condition"][::std::mem::offset_of!(nir_if, condition) - 16usize];
    ["Offset of field: nir_if::control"][::std::mem::offset_of!(nir_if, control) - 32usize];
    ["Offset of field: nir_if::then_list"][::std::mem::offset_of!(nir_if, then_list) - 36usize];
    ["Offset of field: nir_if::else_list"][::std::mem::offset_of!(nir_if, else_list) - 52usize];
};
impl Default for nir_if {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop_terminator {
    pub nif: *mut nir_if,
    #[doc = " Condition instruction that contains the induction variable"]
    pub conditional_instr: *mut nir_instr,
    #[doc = " Block within ::nif that has the break instruction."]
    pub break_block: *mut nir_block,
    #[doc = " Last block for the then- or else-path that does not contain the break."]
    pub continue_from_block: *mut nir_block,
    #[doc = " True when ::break_block is in the else-path of ::nif."]
    pub continue_from_then: bool,
    pub induction_rhs: bool,
    pub exact_trip_count_unknown: bool,
    pub loop_terminator_link: list_head,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop_terminator"][::std::mem::size_of::<nir_loop_terminator>() - 28usize];
    ["Alignment of nir_loop_terminator"][::std::mem::align_of::<nir_loop_terminator>() - 4usize];
    ["Offset of field: nir_loop_terminator::nif"]
        [::std::mem::offset_of!(nir_loop_terminator, nif) - 0usize];
    ["Offset of field: nir_loop_terminator::conditional_instr"]
        [::std::mem::offset_of!(nir_loop_terminator, conditional_instr) - 4usize];
    ["Offset of field: nir_loop_terminator::break_block"]
        [::std::mem::offset_of!(nir_loop_terminator, break_block) - 8usize];
    ["Offset of field: nir_loop_terminator::continue_from_block"]
        [::std::mem::offset_of!(nir_loop_terminator, continue_from_block) - 12usize];
    ["Offset of field: nir_loop_terminator::continue_from_then"]
        [::std::mem::offset_of!(nir_loop_terminator, continue_from_then) - 16usize];
    ["Offset of field: nir_loop_terminator::induction_rhs"]
        [::std::mem::offset_of!(nir_loop_terminator, induction_rhs) - 17usize];
    ["Offset of field: nir_loop_terminator::exact_trip_count_unknown"]
        [::std::mem::offset_of!(nir_loop_terminator, exact_trip_count_unknown) - 18usize];
    ["Offset of field: nir_loop_terminator::loop_terminator_link"]
        [::std::mem::offset_of!(nir_loop_terminator, loop_terminator_link) - 20usize];
};
impl Default for nir_loop_terminator {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop_info {
    pub instr_cost: ::std::os::raw::c_uint,
    pub has_soft_fp64: bool,
    pub guessed_trip_count: ::std::os::raw::c_uint,
    pub max_trip_count: ::std::os::raw::c_uint,
    pub exact_trip_count_known: bool,
    pub force_unroll: bool,
    pub complex_loop: bool,
    pub limiting_terminator: *mut nir_loop_terminator,
    pub loop_terminator_list: list_head,
    pub induction_vars: *mut hash_table,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop_info"][::std::mem::size_of::<nir_loop_info>() - 36usize];
    ["Alignment of nir_loop_info"][::std::mem::align_of::<nir_loop_info>() - 4usize];
    ["Offset of field: nir_loop_info::instr_cost"]
        [::std::mem::offset_of!(nir_loop_info, instr_cost) - 0usize];
    ["Offset of field: nir_loop_info::has_soft_fp64"]
        [::std::mem::offset_of!(nir_loop_info, has_soft_fp64) - 4usize];
    ["Offset of field: nir_loop_info::guessed_trip_count"]
        [::std::mem::offset_of!(nir_loop_info, guessed_trip_count) - 8usize];
    ["Offset of field: nir_loop_info::max_trip_count"]
        [::std::mem::offset_of!(nir_loop_info, max_trip_count) - 12usize];
    ["Offset of field: nir_loop_info::exact_trip_count_known"]
        [::std::mem::offset_of!(nir_loop_info, exact_trip_count_known) - 16usize];
    ["Offset of field: nir_loop_info::force_unroll"]
        [::std::mem::offset_of!(nir_loop_info, force_unroll) - 17usize];
    ["Offset of field: nir_loop_info::complex_loop"]
        [::std::mem::offset_of!(nir_loop_info, complex_loop) - 18usize];
    ["Offset of field: nir_loop_info::limiting_terminator"]
        [::std::mem::offset_of!(nir_loop_info, limiting_terminator) - 20usize];
    ["Offset of field: nir_loop_info::loop_terminator_list"]
        [::std::mem::offset_of!(nir_loop_info, loop_terminator_list) - 24usize];
    ["Offset of field: nir_loop_info::induction_vars"]
        [::std::mem::offset_of!(nir_loop_info, induction_vars) - 32usize];
};
impl Default for nir_loop_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_loop_control {
    nir_loop_control_none = 0,
    nir_loop_control_unroll = 1,
    nir_loop_control_dont_unroll = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_loop {
    pub cf_node: nir_cf_node,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    #[doc = " (optional) list of nir_cf_node"]
    pub continue_list: exec_list,
    pub info: *mut nir_loop_info,
    pub control: nir_loop_control,
    pub partially_unrolled: bool,
    #[doc = " Whether some loop-active invocations might take a different control-flow path:\n divergent_continue indicates that a continue statement might be taken by\n only some of the loop-active invocations. A subsequent break is always\n considered divergent."]
    pub divergent_continue: bool,
    pub divergent_break: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_loop"][::std::mem::size_of::<nir_loop>() - 60usize];
    ["Alignment of nir_loop"][::std::mem::align_of::<nir_loop>() - 4usize];
    ["Offset of field: nir_loop::cf_node"][::std::mem::offset_of!(nir_loop, cf_node) - 0usize];
    ["Offset of field: nir_loop::body"][::std::mem::offset_of!(nir_loop, body) - 16usize];
    ["Offset of field: nir_loop::continue_list"]
        [::std::mem::offset_of!(nir_loop, continue_list) - 32usize];
    ["Offset of field: nir_loop::info"][::std::mem::offset_of!(nir_loop, info) - 48usize];
    ["Offset of field: nir_loop::control"][::std::mem::offset_of!(nir_loop, control) - 52usize];
    ["Offset of field: nir_loop::partially_unrolled"]
        [::std::mem::offset_of!(nir_loop, partially_unrolled) - 56usize];
    ["Offset of field: nir_loop::divergent_continue"]
        [::std::mem::offset_of!(nir_loop, divergent_continue) - 57usize];
    ["Offset of field: nir_loop::divergent_break"]
        [::std::mem::offset_of!(nir_loop, divergent_break) - 58usize];
};
impl Default for nir_loop {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_loop_is_divergent__extern"]
    pub fn nir_loop_is_divergent(loop_: *mut nir_loop) -> bool;
}
#[repr(i32)]
#[doc = " Various bits of metadata that can may be created or required by\n optimization and analysis passes"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_metadata {
    nir_metadata_none = 0,
    #[doc = " Indicates that nir_block::index values are valid.\n\n The start block has index 0 and they increase through a natural walk of\n the CFG.  nir_function_impl::num_blocks is the number of blocks and\n every block index is in the range [0, nir_function_impl::num_blocks].\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
    nir_metadata_block_index = 1,
    #[doc = " Indicates that block dominance information is valid\n\n This includes:\n\n   - nir_block::num_dom_children\n   - nir_block::dom_children\n   - nir_block::dom_frontier\n   - nir_block::dom_pre_index\n   - nir_block::dom_post_index\n\n A pass can preserve this metadata type if it doesn't touch the CFG."]
    nir_metadata_dominance = 2,
    #[doc = " Indicates that SSA def data-flow liveness information is valid\n\n This includes:\n\n   - nir_block::live_in\n   - nir_block::live_out\n\n A pass can preserve this metadata type if it never adds or removes any\n SSA defs or uses of SSA defs (most passes shouldn't preserve this\n metadata type)."]
    nir_metadata_live_defs = 4,
    #[doc = " A dummy metadata value to track when a pass forgot to call\n nir_metadata_preserve.\n\n A pass should always clear this value even if it doesn't make any\n progress to indicate that it thought about preserving metadata."]
    nir_metadata_not_properly_reset = 8,
    #[doc = " Indicates that loop analysis information is valid.\n\n This includes everything pointed to by nir_loop::info.\n\n A pass can preserve this metadata type if it is guaranteed to not affect\n any loop metadata.  However, since loop metadata includes things like\n loop counts which depend on arithmetic in the loop, this is very hard to\n determine.  Most passes shouldn't preserve this metadata type."]
    nir_metadata_loop_analysis = 16,
    #[doc = " Indicates that nir_instr::index values are valid.\n\n The start instruction has index 0 and they increase through a natural\n walk of instructions in blocks in the CFG.  The indices my have holes\n after passes such as DCE.\n\n A pass can preserve this metadata type if it never adds or moves any\n instructions (most passes shouldn't preserve this metadata type), but\n can preserve it if it only removes instructions."]
    nir_metadata_instr_index = 32,
    #[doc = " All control flow metadata\n\n This includes all metadata preserved by a pass that preserves control flow\n but modifies instructions. For example, a pass using\n nir_shader_instructions_pass will typically preserve this if it does not\n insert control flow.\n\n This is the most common metadata set to preserve, so it has its own alias."]
    nir_metadata_control_flow = 3,
    #[doc = " All metadata\n\n This includes all nir_metadata flags except not_properly_reset.  Passes\n which do not change the shader in any way should call\n\n    nir_metadata_preserve(impl, nir_metadata_all);"]
    nir_metadata_all = -9,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_function_impl {
    pub cf_node: nir_cf_node,
    #[doc = " pointer to the function of which this is an implementation"]
    pub function: *mut nir_function,
    #[doc = " For entrypoints, a pointer to a nir_function_impl which runs before\n it, once per draw or dispatch, communicating via store_preamble and\n load_preamble intrinsics. If NULL then there is no preamble."]
    pub preamble: *mut nir_function,
    #[doc = " list of nir_cf_node"]
    pub body: exec_list,
    pub end_block: *mut nir_block,
    #[doc = " list for all local variables in the function"]
    pub locals: exec_list,
    #[doc = " next available SSA value index"]
    pub ssa_alloc: ::std::os::raw::c_uint,
    pub num_blocks: ::std::os::raw::c_uint,
    #[doc = " True if this nir_function_impl uses structured control-flow\n\n Structured nir_function_impls have different validation rules."]
    pub structured: bool,
    pub valid_metadata: nir_metadata,
    pub loop_analysis_indirect_mask: nir_variable_mode,
    pub loop_analysis_force_unroll_sampler_indirect: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_function_impl"][::std::mem::size_of::<nir_function_impl>() - 84usize];
    ["Alignment of nir_function_impl"][::std::mem::align_of::<nir_function_impl>() - 4usize];
    ["Offset of field: nir_function_impl::cf_node"]
        [::std::mem::offset_of!(nir_function_impl, cf_node) - 0usize];
    ["Offset of field: nir_function_impl::function"]
        [::std::mem::offset_of!(nir_function_impl, function) - 16usize];
    ["Offset of field: nir_function_impl::preamble"]
        [::std::mem::offset_of!(nir_function_impl, preamble) - 20usize];
    ["Offset of field: nir_function_impl::body"]
        [::std::mem::offset_of!(nir_function_impl, body) - 24usize];
    ["Offset of field: nir_function_impl::end_block"]
        [::std::mem::offset_of!(nir_function_impl, end_block) - 40usize];
    ["Offset of field: nir_function_impl::locals"]
        [::std::mem::offset_of!(nir_function_impl, locals) - 44usize];
    ["Offset of field: nir_function_impl::ssa_alloc"]
        [::std::mem::offset_of!(nir_function_impl, ssa_alloc) - 60usize];
    ["Offset of field: nir_function_impl::num_blocks"]
        [::std::mem::offset_of!(nir_function_impl, num_blocks) - 64usize];
    ["Offset of field: nir_function_impl::structured"]
        [::std::mem::offset_of!(nir_function_impl, structured) - 68usize];
    ["Offset of field: nir_function_impl::valid_metadata"]
        [::std::mem::offset_of!(nir_function_impl, valid_metadata) - 72usize];
    ["Offset of field: nir_function_impl::loop_analysis_indirect_mask"]
        [::std::mem::offset_of!(nir_function_impl, loop_analysis_indirect_mask) - 76usize];
    ["Offset of field: nir_function_impl::loop_analysis_force_unroll_sampler_indirect"][::std::mem::offset_of!(
        nir_function_impl,
        loop_analysis_force_unroll_sampler_indirect
    )
        - 80usize];
};
impl Default for nir_function_impl {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_start_block__extern"]
    pub fn nir_start_block(impl_: *mut nir_function_impl) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_impl_last_block__extern"]
    pub fn nir_impl_last_block(impl_: *mut nir_function_impl) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_next__extern"]
    pub fn nir_cf_node_next(node: *mut nir_cf_node) -> *mut nir_cf_node;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_prev__extern"]
    pub fn nir_cf_node_prev(node: *mut nir_cf_node) -> *mut nir_cf_node;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_is_first__extern"]
    pub fn nir_cf_node_is_first(node: *const nir_cf_node) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_is_last__extern"]
    pub fn nir_cf_node_is_last(node: *const nir_cf_node) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_as_block__extern"]
    pub fn nir_cf_node_as_block(parent: *const nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_as_if__extern"]
    pub fn nir_cf_node_as_if(parent: *const nir_cf_node) -> *mut nir_if;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_as_loop__extern"]
    pub fn nir_cf_node_as_loop(parent: *const nir_cf_node) -> *mut nir_loop;
}
unsafe extern "C" {
    #[link_name = "nir_cf_node_as_function__extern"]
    pub fn nir_cf_node_as_function(parent: *const nir_cf_node) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[link_name = "nir_if_first_then_block__extern"]
    pub fn nir_if_first_then_block(if_stmt: *mut nir_if) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_if_last_then_block__extern"]
    pub fn nir_if_last_then_block(if_stmt: *mut nir_if) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_if_first_else_block__extern"]
    pub fn nir_if_first_else_block(if_stmt: *mut nir_if) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_if_last_else_block__extern"]
    pub fn nir_if_last_else_block(if_stmt: *mut nir_if) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_loop_first_block__extern"]
    pub fn nir_loop_first_block(loop_: *mut nir_loop) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_loop_last_block__extern"]
    pub fn nir_loop_last_block(loop_: *mut nir_loop) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_loop_has_continue_construct__extern"]
    pub fn nir_loop_has_continue_construct(loop_: *const nir_loop) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_loop_first_continue_block__extern"]
    pub fn nir_loop_first_continue_block(loop_: *mut nir_loop) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_loop_last_continue_block__extern"]
    pub fn nir_loop_last_continue_block(loop_: *mut nir_loop) -> *mut nir_block;
}
unsafe extern "C" {
    #[doc = " Return the target block of a nir_jump_continue statement"]
    #[link_name = "nir_loop_continue_target__extern"]
    pub fn nir_loop_continue_target(loop_: *mut nir_loop) -> *mut nir_block;
}
unsafe extern "C" {
    #[doc = " Return true if this list of cf_nodes contains a single empty block."]
    #[link_name = "nir_cf_list_is_empty_block__extern"]
    pub fn nir_cf_list_is_empty_block(cf_list: *mut exec_list) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_parameter {
    pub num_components: u8,
    pub bit_size: u8,
    pub is_return: bool,
    pub implicit_conversion_prohibited: bool,
    pub is_uniform: bool,
    pub mode: nir_variable_mode,
    pub driver_attributes: u32,
    pub type_: *const glsl_type,
    pub name: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_parameter"][::std::mem::size_of::<nir_parameter>() - 24usize];
    ["Alignment of nir_parameter"][::std::mem::align_of::<nir_parameter>() - 4usize];
    ["Offset of field: nir_parameter::num_components"]
        [::std::mem::offset_of!(nir_parameter, num_components) - 0usize];
    ["Offset of field: nir_parameter::bit_size"]
        [::std::mem::offset_of!(nir_parameter, bit_size) - 1usize];
    ["Offset of field: nir_parameter::is_return"]
        [::std::mem::offset_of!(nir_parameter, is_return) - 2usize];
    ["Offset of field: nir_parameter::implicit_conversion_prohibited"]
        [::std::mem::offset_of!(nir_parameter, implicit_conversion_prohibited) - 3usize];
    ["Offset of field: nir_parameter::is_uniform"]
        [::std::mem::offset_of!(nir_parameter, is_uniform) - 4usize];
    ["Offset of field: nir_parameter::mode"][::std::mem::offset_of!(nir_parameter, mode) - 8usize];
    ["Offset of field: nir_parameter::driver_attributes"]
        [::std::mem::offset_of!(nir_parameter, driver_attributes) - 12usize];
    ["Offset of field: nir_parameter::type_"]
        [::std::mem::offset_of!(nir_parameter, type_) - 16usize];
    ["Offset of field: nir_parameter::name"][::std::mem::offset_of!(nir_parameter, name) - 20usize];
};
impl Default for nir_parameter {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_function {
    pub node: exec_node,
    pub name: *const ::std::os::raw::c_char,
    pub shader: *mut nir_shader,
    pub num_params: ::std::os::raw::c_uint,
    pub params: *mut nir_parameter,
    #[doc = " The implementation of this function.\n\n If the function is only declared and not implemented, this is NULL.\n\n Unless setting to NULL or NIR_SERIALIZE_FUNC_HAS_IMPL, set with\n nir_function_set_impl to maintain IR invariants."]
    pub impl_: *mut nir_function_impl,
    pub driver_attributes: u32,
    pub is_entrypoint: bool,
    pub is_exported: bool,
    pub is_preamble: bool,
    pub should_inline: bool,
    pub dont_inline: bool,
    pub workgroup_size: [::std::os::raw::c_uint; 3usize],
    #[doc = " Is this function a subroutine type declaration\n e.g. subroutine void type1(float arg1);"]
    pub is_subroutine: bool,
    pub is_tmp_globals_wrapper: bool,
    #[doc = " Is this function associated to a subroutine type\n e.g. subroutine (type1, type2) function_name { function_body };\n would have num_subroutine_types 2,\n and pointers to the type1 and type2 types."]
    pub num_subroutine_types: ::std::os::raw::c_int,
    pub subroutine_types: *mut *const glsl_type,
    pub subroutine_index: ::std::os::raw::c_int,
    pub pass_flags: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_function"][::std::mem::size_of::<nir_function>() - 72usize];
    ["Alignment of nir_function"][::std::mem::align_of::<nir_function>() - 4usize];
    ["Offset of field: nir_function::node"][::std::mem::offset_of!(nir_function, node) - 0usize];
    ["Offset of field: nir_function::name"][::std::mem::offset_of!(nir_function, name) - 8usize];
    ["Offset of field: nir_function::shader"]
        [::std::mem::offset_of!(nir_function, shader) - 12usize];
    ["Offset of field: nir_function::num_params"]
        [::std::mem::offset_of!(nir_function, num_params) - 16usize];
    ["Offset of field: nir_function::params"]
        [::std::mem::offset_of!(nir_function, params) - 20usize];
    ["Offset of field: nir_function::impl_"][::std::mem::offset_of!(nir_function, impl_) - 24usize];
    ["Offset of field: nir_function::driver_attributes"]
        [::std::mem::offset_of!(nir_function, driver_attributes) - 28usize];
    ["Offset of field: nir_function::is_entrypoint"]
        [::std::mem::offset_of!(nir_function, is_entrypoint) - 32usize];
    ["Offset of field: nir_function::is_exported"]
        [::std::mem::offset_of!(nir_function, is_exported) - 33usize];
    ["Offset of field: nir_function::is_preamble"]
        [::std::mem::offset_of!(nir_function, is_preamble) - 34usize];
    ["Offset of field: nir_function::should_inline"]
        [::std::mem::offset_of!(nir_function, should_inline) - 35usize];
    ["Offset of field: nir_function::dont_inline"]
        [::std::mem::offset_of!(nir_function, dont_inline) - 36usize];
    ["Offset of field: nir_function::workgroup_size"]
        [::std::mem::offset_of!(nir_function, workgroup_size) - 40usize];
    ["Offset of field: nir_function::is_subroutine"]
        [::std::mem::offset_of!(nir_function, is_subroutine) - 52usize];
    ["Offset of field: nir_function::is_tmp_globals_wrapper"]
        [::std::mem::offset_of!(nir_function, is_tmp_globals_wrapper) - 53usize];
    ["Offset of field: nir_function::num_subroutine_types"]
        [::std::mem::offset_of!(nir_function, num_subroutine_types) - 56usize];
    ["Offset of field: nir_function::subroutine_types"]
        [::std::mem::offset_of!(nir_function, subroutine_types) - 60usize];
    ["Offset of field: nir_function::subroutine_index"]
        [::std::mem::offset_of!(nir_function, subroutine_index) - 64usize];
    ["Offset of field: nir_function::pass_flags"]
        [::std::mem::offset_of!(nir_function, pass_flags) - 68usize];
};
impl Default for nir_function {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_lower_int64_options {
    pub const nir_lower_imul64: nir_lower_int64_options = nir_lower_int64_options(1);
}
impl nir_lower_int64_options {
    pub const nir_lower_isign64: nir_lower_int64_options = nir_lower_int64_options(2);
}
impl nir_lower_int64_options {
    #[doc = " Lower all int64 modulus and division opcodes"]
    pub const nir_lower_divmod64: nir_lower_int64_options = nir_lower_int64_options(4);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_imul_high64: nir_lower_int64_options = nir_lower_int64_options(8);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_bcsel64: nir_lower_int64_options = nir_lower_int64_options(16);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_icmp64: nir_lower_int64_options = nir_lower_int64_options(32);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iadd64: nir_lower_int64_options = nir_lower_int64_options(64);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iabs64: nir_lower_int64_options = nir_lower_int64_options(128);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_ineg64: nir_lower_int64_options = nir_lower_int64_options(256);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_logic64: nir_lower_int64_options = nir_lower_int64_options(512);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_minmax64: nir_lower_int64_options = nir_lower_int64_options(1024);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_shift64: nir_lower_int64_options = nir_lower_int64_options(2048);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_imul_2x32_64: nir_lower_int64_options = nir_lower_int64_options(4096);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_extract64: nir_lower_int64_options = nir_lower_int64_options(8192);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_ufind_msb64: nir_lower_int64_options = nir_lower_int64_options(16384);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_bit_count64: nir_lower_int64_options = nir_lower_int64_options(32768);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_subgroup_shuffle64: nir_lower_int64_options =
        nir_lower_int64_options(65536);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_scan_reduce_bitwise64: nir_lower_int64_options =
        nir_lower_int64_options(131072);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_scan_reduce_iadd64: nir_lower_int64_options =
        nir_lower_int64_options(262144);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_vote_ieq64: nir_lower_int64_options = nir_lower_int64_options(524288);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_usub_sat64: nir_lower_int64_options = nir_lower_int64_options(1048576);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iadd_sat64: nir_lower_int64_options = nir_lower_int64_options(2097152);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_find_lsb64: nir_lower_int64_options = nir_lower_int64_options(4194304);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_conv64: nir_lower_int64_options = nir_lower_int64_options(8388608);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_uadd_sat64: nir_lower_int64_options = nir_lower_int64_options(16777216);
}
impl nir_lower_int64_options {
    #[doc = " Lower all 64-bit umul_high and imul_high opcodes"]
    pub const nir_lower_iadd3_64: nir_lower_int64_options = nir_lower_int64_options(33554432);
}
impl ::std::ops::BitOr<nir_lower_int64_options> for nir_lower_int64_options {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_lower_int64_options(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_lower_int64_options {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_lower_int64_options) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_lower_int64_options> for nir_lower_int64_options {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_lower_int64_options(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_lower_int64_options {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_lower_int64_options) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_int64_options(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_doubles_options {
    nir_lower_drcp = 1,
    nir_lower_dsqrt = 2,
    nir_lower_drsq = 4,
    nir_lower_dtrunc = 8,
    nir_lower_dfloor = 16,
    nir_lower_dceil = 32,
    nir_lower_dfract = 64,
    nir_lower_dround_even = 128,
    nir_lower_dmod = 256,
    nir_lower_dsub = 512,
    nir_lower_ddiv = 1024,
    nir_lower_dsign = 2048,
    nir_lower_dminmax = 4096,
    nir_lower_dsat = 8192,
    nir_lower_fp64_full_software = 16384,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_divergence_options {
    nir_divergence_single_prim_per_subgroup = 1,
    nir_divergence_single_patch_per_tcs_subgroup = 2,
    nir_divergence_single_patch_per_tes_subgroup = 4,
    nir_divergence_view_index_uniform = 8,
    nir_divergence_single_frag_shading_rate_per_subgroup = 16,
    nir_divergence_multiple_workgroup_per_compute_subgroup = 32,
    nir_divergence_shader_record_ptr_uniform = 64,
    nir_divergence_uniform_load_tears = 128,
    nir_divergence_ignore_undef_if_phi_srcs = 256,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_io_options {
    #[doc = " Whether a fragment shader can interpolate the same input multiple times\n with different modes (smooth, noperspective) and locations (pixel,\n centroid, sample, at_offset, at_sample), excluding the flat mode.\n\n This matches AMD GPU flexibility and limitations and is a superset of\n the GL4 requirement that each input can be interpolated at its specified\n location, and then also as centroid, at_offset, and at_sample."]
    nir_io_has_flexible_input_interpolation_except_flat = 1,
    #[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
    nir_io_dont_use_pos_for_non_fs_varyings = 2,
    #[doc = " nir_opt_varyings compacts (relocates) components of varyings by\n rewriting their locations completely, effectively moving components of\n varyings between slots. This option forces nir_opt_varyings to make\n VARYING_SLOT_POS unused by moving its contents to VARn if the consumer\n is not FS. If this option is not set and POS is unused, it moves\n components of VARn to POS until it's fully used."]
    nir_io_16bit_input_output_support = 4,
    #[doc = " Implement mediump inputs and outputs as normal 32-bit IO.\n Causes the mediump flag to be not set for IO semantics, essentially\n destroying any mediump-related IO information in the shader."]
    nir_io_mediump_is_32bit = 8,
    #[doc = " Whether nir_opt_vectorize_io should ignore FS inputs."]
    nir_io_prefer_scalar_fs_inputs = 16,
    #[doc = " Whether interpolated fragment shader vec4 slots can use load_input for\n a subset of its components to skip interpolation for those components.\n The result of such load_input is a value from a random (not necessarily\n provoking) vertex. If a value from the provoking vertex is required,\n the vec4 slot should have no load_interpolated_input instructions.\n\n This exposes the AMD capability that allows packing flat inputs with\n interpolated inputs in a limited number of cases. Normally, flat\n components must be in a separate vec4 slot to get the value from\n the provoking vertex. If the compiler can prove that all per-vertex\n values are equal (convergent, i.e. the provoking vertex doesn't matter),\n it can put such flat components into any interpolated vec4 slot.\n\n It should also be set if the hw can mix flat and interpolated components\n in the same vec4 slot.\n\n This causes nir_opt_varyings to skip interpolation for all varyings\n that are convergent, and enables better compaction and inter-shader code\n motion for convergent varyings."]
    nir_io_mix_convergent_flat_with_interpolated = 32,
    #[doc = " Whether src_type and dest_type of IO intrinsics are irrelevant and\n should be ignored by nir_opt_vectorize_io. All drivers that always treat\n load_input and store_output as untyped and load_interpolated_input as\n float##bit_size should set this."]
    nir_io_vectorizer_ignores_types = 64,
    #[doc = " Whether nir_opt_varyings should never promote convergent FS inputs\n to flat."]
    nir_io_always_interpolate_convergent_fs_inputs = 128,
    #[doc = " Whether the first assigned color channel component should be equal to\n the first unused VARn component.\n\n For example, if the first unused VARn channel is VAR0.z, color channels\n are assigned in this order:\n       COL0.z, COL0.w, COL0.x, COL0.y, COL1.z, COL1.w, COL1.x, COL1.y\n\n This allows certain drivers to merge outputs if each output sets\n different components, for example 2 outputs writing VAR0.xy and COL0.z\n will only use 1 HW output."]
    nir_io_compaction_rotates_color_channels = 256,
    #[doc = " Lower load_deref/store_deref to load_input/store_output/etc. intrinsics.\n This is only affects GLSL compilation and Gallium."]
    nir_io_has_intrinsics = 65536,
    #[doc = " Don't run nir_opt_varyings and nir_opt_vectorize_io.\n\n This option is deprecated and is a hack. DO NOT USE.\n Use MESA_GLSL_DISABLE_IO_OPT=1 instead."]
    nir_io_dont_optimize = 131072,
    #[doc = " Whether clip and cull distance arrays should be separate. If this is not\n set, cull distances will be moved into VARYING_SLOT_CLIP_DISTn after clip\n distances, and shader_info::clip_distance_array_size will be the index\n of the first cull distance. nir_lower_clip_cull_distance_arrays does\n that."]
    nir_io_separate_clip_cull_distance_arrays = 262144,
}
#[doc = " An instruction filtering callback\n\n Returns true if the instruction should be processed and false otherwise."]
pub type nir_instr_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> bool,
>;
pub type nir_intrin_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_intrinsic_instr,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " A vectorization width callback\n\n Returns the maximum vectorization width per instruction.\n 0, if the instruction must not be modified.\n\n The vectorization width must be a power of 2."]
pub type nir_vectorize_cb = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const nir_instr, arg2: *const ::std::os::raw::c_void) -> u8,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_shader_compiler_options {
    pub lower_fdiv: bool,
    pub lower_ffma16: bool,
    pub lower_ffma32: bool,
    pub lower_ffma64: bool,
    pub fuse_ffma16: bool,
    pub fuse_ffma32: bool,
    pub fuse_ffma64: bool,
    pub lower_flrp16: bool,
    pub lower_flrp32: bool,
    #[doc = " Lowers flrp when it does not support doubles"]
    pub lower_flrp64: bool,
    pub lower_fpow: bool,
    pub lower_fsat: bool,
    pub lower_fsqrt: bool,
    pub lower_sincos: bool,
    pub lower_fmod: bool,
    #[doc = " Lowers ibitfield_extract/ubitfield_extract."]
    pub lower_bitfield_extract: bool,
    #[doc = " Lowers bitfield_insert."]
    pub lower_bitfield_insert: bool,
    #[doc = " Lowers bitfield_reverse to shifts."]
    pub lower_bitfield_reverse: bool,
    #[doc = " Lowers bit_count to shifts."]
    pub lower_bit_count: bool,
    #[doc = " Lowers ifind_msb."]
    pub lower_ifind_msb: bool,
    #[doc = " Lowers ufind_msb."]
    pub lower_ufind_msb: bool,
    #[doc = " Lowers find_lsb to ufind_msb and logic ops"]
    pub lower_find_lsb: bool,
    pub lower_uadd_carry: bool,
    pub lower_usub_borrow: bool,
    #[doc = " Lowers imul_high/umul_high to 16-bit multiplies and carry operations."]
    pub lower_mul_high: bool,
    #[doc = " lowers fneg to fmul(x, -1.0). Driver must call nir_opt_algebraic_late()"]
    pub lower_fneg: bool,
    #[doc = " lowers ineg to isub. Driver must call nir_opt_algebraic_late()."]
    pub lower_ineg: bool,
    #[doc = " lowers fisnormal to alu ops."]
    pub lower_fisnormal: bool,
    pub lower_scmp: bool,
    pub lower_vector_cmp: bool,
    #[doc = " enable rules to avoid bit ops"]
    pub lower_bitops: bool,
    #[doc = " enables rules to lower isign to imin+imax"]
    pub lower_isign: bool,
    #[doc = " enables rules to lower fsign to fsub and flt"]
    pub lower_fsign: bool,
    #[doc = " enables rules to lower iabs to ineg+imax"]
    pub lower_iabs: bool,
    #[doc = " enable rules that avoid generating umax from signed integer ops"]
    pub lower_umax: bool,
    #[doc = " enable rules that avoid generating umin from signed integer ops"]
    pub lower_umin: bool,
    pub lower_fminmax_signed_zero: bool,
    pub lower_fdph: bool,
    #[doc = " lower fdot to fmul and fsum/fadd."]
    pub lower_fdot: bool,
    pub fdot_replicates: bool,
    #[doc = " lowers ffloor to fsub+ffract:"]
    pub lower_ffloor: bool,
    #[doc = " lowers ffract to fsub+ffloor:"]
    pub lower_ffract: bool,
    #[doc = " lowers fceil to fneg+ffloor+fneg:"]
    pub lower_fceil: bool,
    pub lower_ftrunc: bool,
    #[doc = " Lowers fround_even to ffract+feq+csel.\n\n Not correct in that it doesn't correctly handle the \"_even\" part of the\n rounding, but good enough for DX9 array indexing handling on DX9-class\n hardware."]
    pub lower_fround_even: bool,
    pub lower_ldexp: bool,
    pub lower_pack_half_2x16: bool,
    pub lower_pack_unorm_2x16: bool,
    pub lower_pack_snorm_2x16: bool,
    pub lower_pack_unorm_4x8: bool,
    pub lower_pack_snorm_4x8: bool,
    pub lower_pack_64_2x32: bool,
    pub lower_pack_64_4x16: bool,
    pub lower_pack_32_2x16: bool,
    pub lower_pack_64_2x32_split: bool,
    pub lower_pack_32_2x16_split: bool,
    pub lower_unpack_half_2x16: bool,
    pub lower_unpack_unorm_2x16: bool,
    pub lower_unpack_snorm_2x16: bool,
    pub lower_unpack_unorm_4x8: bool,
    pub lower_unpack_snorm_4x8: bool,
    pub lower_unpack_64_2x32_split: bool,
    pub lower_unpack_32_2x16_split: bool,
    pub lower_pack_split: bool,
    pub lower_extract_byte: bool,
    pub lower_extract_word: bool,
    pub lower_insert_byte: bool,
    pub lower_insert_word: bool,
    pub lower_all_io_to_temps: bool,
    pub vertex_id_zero_based: bool,
    #[doc = " If enabled, gl_BaseVertex will be lowered as:\n is_indexed_draw (~0/0) & firstvertex"]
    pub lower_base_vertex: bool,
    #[doc = " If enabled, gl_HelperInvocation will be lowered as:\n\n   !((1 << sample_id) & sample_mask_in))\n\n This depends on some possibly hw implementation details, which may\n not be true for all hw.  In particular that the FS is only executed\n for covered samples or for helper invocations.  So, do not blindly\n enable this option.\n\n Note: See also issue #22 in ARB_shader_image_load_store"]
    pub lower_helper_invocation: bool,
    #[doc = " Convert gl_SampleMaskIn to gl_HelperInvocation as follows:\n\n   gl_SampleMaskIn == 0 ---> gl_HelperInvocation\n   gl_SampleMaskIn != 0 ---> !gl_HelperInvocation"]
    pub optimize_sample_mask_in: bool,
    #[doc = " Optimize load_front_face ? a : -a to load_front_face_fsign * a"]
    pub optimize_load_front_face_fsign: bool,
    #[doc = " Optimize boolean reductions of quad broadcasts. This should only be enabled if\n nir_intrinsic_reduce supports INCLUDE_HELPERS."]
    pub optimize_quad_vote_to_reduce: bool,
    pub lower_cs_local_index_to_id: bool,
    pub lower_cs_local_id_to_index: bool,
    pub has_cs_global_id: bool,
    pub lower_device_index_to_zero: bool,
    pub lower_wpos_pntc: bool,
    #[doc = " Set if nir_op_[iu]hadd and nir_op_[iu]rhadd instructions should be\n lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions.\n\n :c:member:`lower_hadd64`"]
    pub lower_hadd: bool,
    #[doc = " Set if only 64-bit nir_op_[iu]hadd and nir_op_[iu]rhadd instructions\n should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to only 64-bit\n versions of these instructions.\n\n :c:member:`lower_hadd`"]
    pub lower_hadd64: bool,
    #[doc = " Set if nir_op_uadd_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_uadd_sat: bool,
    #[doc = " Set if nir_op_usub_sat should be lowered to simple arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_usub_sat: bool,
    #[doc = " Set if nir_op_iadd_sat and nir_op_isub_sat should be lowered to simple\n arithmetic.\n\n If this flag is set, the lowering will be applied to all bit-sizes of\n these instructions."]
    pub lower_iadd_sat: bool,
    #[doc = " Set if imul_32x16 and umul_32x16 should be lowered to simple\n arithmetic."]
    pub lower_mul_32x16: bool,
    pub vectorize_tess_levels: bool,
    pub lower_to_scalar: bool,
    pub lower_to_scalar_filter: nir_instr_filter_cb,
    #[doc = " Disables potentially harmful algebraic transformations for architectures\n with SIMD-within-a-register semantics.\n\n Note, to actually vectorize 16bit instructions, use nir_opt_vectorize()\n with a suitable callback function."]
    pub vectorize_vec2_16bit: bool,
    #[doc = " Should the linker unify inputs_read/outputs_written between adjacent\n shader stages which are linked into a single program?"]
    pub unify_interfaces: bool,
    #[doc = " Whether nir_lower_io() will lower interpolateAt functions to\n load_interpolated_input intrinsics.\n\n Unlike nir_lower_io_use_interpolated_input_intrinsics this will only\n lower these functions and leave input load intrinsics untouched."]
    pub lower_interpolate_at: bool,
    pub lower_mul_2x32_64: bool,
    pub has_rotate8: bool,
    pub has_rotate16: bool,
    pub has_rotate32: bool,
    #[doc = " Backend supports shfr"]
    pub has_shfr32: bool,
    #[doc = " Backend supports ternary addition"]
    pub has_iadd3: bool,
    #[doc = " Backend supports amul and would like them generated whenever\n possible. This is stronger than has_imul24 for amul, but does not imply\n support for imul24."]
    pub has_amul: bool,
    #[doc = " Backend supports imul24, and would like to use it (when possible)\n for address/offset calculation.  If true, driver should call\n nir_lower_amul().  (If not set, amul will automatically be lowered\n to imul.)"]
    pub has_imul24: bool,
    #[doc = " Backend supports umul24, if not set  umul24 will automatically be lowered\n to imul with masked inputs"]
    pub has_umul24: bool,
    #[doc = " Backend supports 32-bit imad"]
    pub has_imad32: bool,
    #[doc = " Backend supports umad24, if not set  umad24 will automatically be lowered\n to imul with masked inputs and iadd"]
    pub has_umad24: bool,
    pub has_fused_comp_and_csel: bool,
    pub has_icsel_eqz64: bool,
    pub has_icsel_eqz32: bool,
    pub has_icsel_eqz16: bool,
    pub has_fneo_fcmpu: bool,
    pub has_ford_funord: bool,
    #[doc = " Backend supports fsub, if not set fsub will automatically be lowered to\n fadd(x, fneg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_fsub: bool,
    #[doc = " Backend supports isub, if not set isub will automatically be lowered to\n iadd(x, ineg(y)). If true, driver should call nir_opt_algebraic_late()."]
    pub has_isub: bool,
    #[doc = " Backend supports pack_32_4x8 or pack_32_4x8_split."]
    pub has_pack_32_4x8: bool,
    #[doc = " Backend supports nir_load_texture_scale and prefers it over txs for nir\n lowerings."]
    pub has_texture_scaling: bool,
    #[doc = " Backend supports sdot_4x8_iadd."]
    pub has_sdot_4x8: bool,
    #[doc = " Backend supports udot_4x8_uadd."]
    pub has_udot_4x8: bool,
    #[doc = " Backend supports sudot_4x8_iadd."]
    pub has_sudot_4x8: bool,
    #[doc = " Backend supports sdot_4x8_iadd_sat."]
    pub has_sdot_4x8_sat: bool,
    #[doc = " Backend supports udot_4x8_uadd_sat."]
    pub has_udot_4x8_sat: bool,
    #[doc = " Backend supports sudot_4x8_iadd_sat."]
    pub has_sudot_4x8_sat: bool,
    #[doc = " Backend supports sdot_2x16 and udot_2x16 opcodes."]
    pub has_dot_2x16: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false)"]
    pub has_fmulz: bool,
    #[doc = " Backend supports fmulz (and ffmaz if lower_ffma32=false) but only if\n FLOAT_CONTROLS_DENORM_PRESERVE_FP32 is not set"]
    pub has_fmulz_no_denorms: bool,
    #[doc = " Backend supports 32bit ufind_msb_rev and ifind_msb_rev."]
    pub has_find_msb_rev: bool,
    #[doc = " Backend supports pack_half_2x16_rtz_split."]
    pub has_pack_half_2x16_rtz: bool,
    #[doc = " Backend supports bitz/bitnz."]
    pub has_bit_test: bool,
    #[doc = " Backend supports ubfe/ibfe."]
    pub has_bfe: bool,
    #[doc = " Backend supports bfm."]
    pub has_bfm: bool,
    #[doc = " Backend supports bfi."]
    pub has_bfi: bool,
    #[doc = " Backend supports bitfield_select."]
    pub has_bitfield_select: bool,
    #[doc = " Backend supports uclz."]
    pub has_uclz: bool,
    #[doc = " Backend support msad_u4x8."]
    pub has_msad: bool,
    #[doc = " Is this the Intel vec4 backend?\n\n Used to inhibit algebraic optimizations that are known to be harmful on\n the Intel vec4 backend.  This is generally applicable to any\n optimization that might cause more immediate values to be used in\n 3-source (e.g., ffma and flrp) instructions."]
    pub intel_vec4: bool,
    #[doc = " For most Intel GPUs, all ternary operations such as FMA and BFE cannot\n have immediates, so two to three instructions may eventually be needed."]
    pub avoid_ternary_with_two_constants: bool,
    #[doc = " Whether 8-bit ALU is supported."]
    pub support_8bit_alu: bool,
    #[doc = " Whether 16-bit ALU is supported."]
    pub support_16bit_alu: bool,
    pub max_unroll_iterations: ::std::os::raw::c_uint,
    pub max_unroll_iterations_aggressive: ::std::os::raw::c_uint,
    pub max_unroll_iterations_fp64: ::std::os::raw::c_uint,
    pub lower_uniforms_to_ubo: bool,
    pub force_indirect_unrolling_sampler: bool,
    pub no_integers: bool,
    #[doc = " Specifies which type of indirectly accessed variables should force\n loop unrolling."]
    pub force_indirect_unrolling: nir_variable_mode,
    pub driver_functions: bool,
    #[doc = " If true, the driver will call nir_lower_int64 itself and the frontend\n should not do so. This may enable better optimization around address\n modes."]
    pub late_lower_int64: bool,
    pub lower_int64_options: nir_lower_int64_options,
    pub lower_doubles_options: nir_lower_doubles_options,
    pub divergence_analysis_options: nir_divergence_options,
    #[doc = " The masks of shader stages that support indirect indexing with\n load_input and store_output intrinsics. It's used by\n nir_lower_io_passes."]
    pub support_indirect_inputs: u8,
    pub support_indirect_outputs: u8,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the image index."]
    pub lower_image_offset_to_range_base: bool,
    #[doc = " store the variable offset into the instrinsic range_base instead\n  of adding it to the atomic source"]
    pub lower_atomic_offset_to_range_base: bool,
    #[doc = " Don't convert medium-precision casts (e.g. f2fmp) into concrete\n  type casts (e.g. f2f16)."]
    pub preserve_mediump: bool,
    #[doc = " lowers fquantize2f16 to alu ops."]
    pub lower_fquantize2f16: bool,
    #[doc = " Lower f2f16 to f2f16_rtz when execution mode is not rtne."]
    pub force_f2f16_rtz: bool,
    #[doc = " Lower VARYING_SLOT_LAYER in FS to SYSTEM_VALUE_LAYER_ID."]
    pub lower_layer_fs_input_to_sysval: bool,
    #[doc = " clip/cull distance and tess level arrays use compact semantics"]
    pub compact_arrays: bool,
    #[doc = " Whether discard gets emitted as nir_intrinsic_demote.\n Otherwise, nir_intrinsic_terminate is being used."]
    pub discard_is_demote: bool,
    #[doc = " Whether the new-style derivative intrinsics are supported. If false,\n legacy ALU derivative ops will be emitted. This transitional option will\n be removed once all drivers are converted to derivative intrinsics."]
    pub has_ddx_intrinsics: bool,
    #[doc = " Whether derivative intrinsics must be scalarized."]
    pub scalarize_ddx: bool,
    #[doc = " Assign a range of driver locations to per-view outputs, with unique\n slots for each view. If unset, per-view outputs will be treated\n similarly to other arrayed IO, and only slots for one view will be\n assigned. Regardless of this setting, per-view outputs are only assigned\n slots for one value in var->data.location."]
    pub per_view_unique_driver_locations: bool,
    #[doc = " Emit nir_intrinsic_store_per_view_output with compacted view indices\n rather than absolute view indices. When using compacted indices, the Nth\n index refers to the Nth enabled view, not the Nth absolute view. For\n example, with view mask 0b1010, compacted index 0 is absolute index 1,\n and compacted index 1 is absolute index 3. Note that compacted view\n indices do not correspond directly to gl_ViewIndex.\n\n If compact_view_index is unset, per-view indices must be constant before\n nir_lower_io. This can be guaranteed by calling nir_lower_io_temporaries\n first."]
    pub compact_view_index: bool,
    #[doc = " Options determining lowering and behavior of inputs and outputs."]
    pub io_options: nir_io_options,
    #[doc = " Bit mask of nir_lower_packing_op to skip lowering some nir ops in\n nir_lower_packing()."]
    pub skip_lower_packing_ops: ::std::os::raw::c_uint,
    #[doc = " Driver callback where drivers can define how to lower mediump.\n  Used by nir_lower_io_passes."]
    pub lower_mediump_io: ::std::option::Option<unsafe extern "C" fn(nir: *mut nir_shader)>,
    #[doc = " Return the maximum cost of an expression that's written to a shader\n output that can be moved into the next shader to remove that output.\n\n Currently only uniform expressions are moved. A uniform expression is\n any ALU expression sourcing only constants, uniforms, and UBO loads.\n\n Set to NULL or return 0 if you only want to propagate constants from\n outputs to inputs.\n\n Drivers can set the maximum cost based on the types of consecutive\n shaders or shader SHA1s.\n\n Drivers should also set \"varying_estimate_instr_cost\"."]
    pub varying_expression_max_cost: ::std::option::Option<
        unsafe extern "C" fn(
            consumer: *mut nir_shader,
            producer: *mut nir_shader,
        ) -> ::std::os::raw::c_uint,
    >,
    #[doc = " Return the cost of an instruction that could be moved into the next\n shader. If the cost of all instructions in an expression is <=\n varying_expression_max_cost(), the instruction is moved.\n\n When this callback isn't set, nir_opt_varyings uses its own version."]
    pub varying_estimate_instr_cost: ::std::option::Option<
        unsafe extern "C" fn(instr: *mut nir_instr) -> ::std::os::raw::c_uint,
    >,
    #[doc = " When the varying_expression_max_cost callback isn't set, this specifies\n the maximum cost of a uniform expression that is allowed to be moved\n from output stores into the next shader stage to eliminate those output\n stores and corresponding inputs.\n\n 0 only allows propagating constants written to output stores to\n the next shader.\n\n At least 2 is required for moving a uniform stored in an output into\n the next shader according to default_varying_estimate_instr_cost."]
    pub max_varying_expression_cost: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_shader_compiler_options"]
        [::std::mem::size_of::<nir_shader_compiler_options>() - 216usize];
    ["Alignment of nir_shader_compiler_options"]
        [::std::mem::align_of::<nir_shader_compiler_options>() - 4usize];
    ["Offset of field: nir_shader_compiler_options::lower_fdiv"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fdiv) - 0usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma16) - 1usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma32) - 2usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffma64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffma64) - 3usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma16) - 4usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma32) - 5usize];
    ["Offset of field: nir_shader_compiler_options::fuse_ffma64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fuse_ffma64) - 6usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp16) - 7usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp32) - 8usize];
    ["Offset of field: nir_shader_compiler_options::lower_flrp64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_flrp64) - 9usize];
    ["Offset of field: nir_shader_compiler_options::lower_fpow"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fpow) - 10usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsat) - 11usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsqrt"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsqrt) - 12usize];
    ["Offset of field: nir_shader_compiler_options::lower_sincos"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_sincos) - 13usize];
    ["Offset of field: nir_shader_compiler_options::lower_fmod"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fmod) - 14usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_extract"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_extract) - 15usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_insert"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_insert) - 16usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitfield_reverse"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitfield_reverse) - 17usize];
    ["Offset of field: nir_shader_compiler_options::lower_bit_count"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bit_count) - 18usize];
    ["Offset of field: nir_shader_compiler_options::lower_ifind_msb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ifind_msb) - 19usize];
    ["Offset of field: nir_shader_compiler_options::lower_ufind_msb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ufind_msb) - 20usize];
    ["Offset of field: nir_shader_compiler_options::lower_find_lsb"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_find_lsb) - 21usize];
    ["Offset of field: nir_shader_compiler_options::lower_uadd_carry"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uadd_carry) - 22usize];
    ["Offset of field: nir_shader_compiler_options::lower_usub_borrow"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_usub_borrow) - 23usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_high"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_high) - 24usize];
    ["Offset of field: nir_shader_compiler_options::lower_fneg"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fneg) - 25usize];
    ["Offset of field: nir_shader_compiler_options::lower_ineg"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ineg) - 26usize];
    ["Offset of field: nir_shader_compiler_options::lower_fisnormal"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fisnormal) - 27usize];
    ["Offset of field: nir_shader_compiler_options::lower_scmp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_scmp) - 28usize];
    ["Offset of field: nir_shader_compiler_options::lower_vector_cmp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_vector_cmp) - 29usize];
    ["Offset of field: nir_shader_compiler_options::lower_bitops"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_bitops) - 30usize];
    ["Offset of field: nir_shader_compiler_options::lower_isign"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_isign) - 31usize];
    ["Offset of field: nir_shader_compiler_options::lower_fsign"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fsign) - 32usize];
    ["Offset of field: nir_shader_compiler_options::lower_iabs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_iabs) - 33usize];
    ["Offset of field: nir_shader_compiler_options::lower_umax"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_umax) - 34usize];
    ["Offset of field: nir_shader_compiler_options::lower_umin"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_umin) - 35usize];
    ["Offset of field: nir_shader_compiler_options::lower_fminmax_signed_zero"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fminmax_signed_zero) - 36usize];
    ["Offset of field: nir_shader_compiler_options::lower_fdph"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fdph) - 37usize];
    ["Offset of field: nir_shader_compiler_options::lower_fdot"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fdot) - 38usize];
    ["Offset of field: nir_shader_compiler_options::fdot_replicates"]
        [::std::mem::offset_of!(nir_shader_compiler_options, fdot_replicates) - 39usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffloor"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffloor) - 40usize];
    ["Offset of field: nir_shader_compiler_options::lower_ffract"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ffract) - 41usize];
    ["Offset of field: nir_shader_compiler_options::lower_fceil"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fceil) - 42usize];
    ["Offset of field: nir_shader_compiler_options::lower_ftrunc"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ftrunc) - 43usize];
    ["Offset of field: nir_shader_compiler_options::lower_fround_even"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fround_even) - 44usize];
    ["Offset of field: nir_shader_compiler_options::lower_ldexp"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_ldexp) - 45usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_half_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_half_2x16) - 46usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_unorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_unorm_2x16) - 47usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_snorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_snorm_2x16) - 48usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_unorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_unorm_4x8) - 49usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_snorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_snorm_4x8) - 50usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_2x32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_2x32) - 51usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_4x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_4x16) - 52usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_32_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_32_2x16) - 53usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_64_2x32_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_64_2x32_split) - 54usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_32_2x16_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_32_2x16_split) - 55usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_half_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_half_2x16) - 56usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_unorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_unorm_2x16) - 57usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_snorm_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_snorm_2x16) - 58usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_unorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_unorm_4x8) - 59usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_snorm_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_snorm_4x8) - 60usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_64_2x32_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_64_2x32_split) - 61usize];
    ["Offset of field: nir_shader_compiler_options::lower_unpack_32_2x16_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_unpack_32_2x16_split) - 62usize];
    ["Offset of field: nir_shader_compiler_options::lower_pack_split"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_pack_split) - 63usize];
    ["Offset of field: nir_shader_compiler_options::lower_extract_byte"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_extract_byte) - 64usize];
    ["Offset of field: nir_shader_compiler_options::lower_extract_word"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_extract_word) - 65usize];
    ["Offset of field: nir_shader_compiler_options::lower_insert_byte"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_insert_byte) - 66usize];
    ["Offset of field: nir_shader_compiler_options::lower_insert_word"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_insert_word) - 67usize];
    ["Offset of field: nir_shader_compiler_options::lower_all_io_to_temps"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_all_io_to_temps) - 68usize];
    ["Offset of field: nir_shader_compiler_options::vertex_id_zero_based"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vertex_id_zero_based) - 69usize];
    ["Offset of field: nir_shader_compiler_options::lower_base_vertex"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_base_vertex) - 70usize];
    ["Offset of field: nir_shader_compiler_options::lower_helper_invocation"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_helper_invocation) - 71usize];
    ["Offset of field: nir_shader_compiler_options::optimize_sample_mask_in"]
        [::std::mem::offset_of!(nir_shader_compiler_options, optimize_sample_mask_in) - 72usize];
    ["Offset of field: nir_shader_compiler_options::optimize_load_front_face_fsign"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        optimize_load_front_face_fsign
    ) - 73usize];
    ["Offset of field: nir_shader_compiler_options::optimize_quad_vote_to_reduce"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        optimize_quad_vote_to_reduce
    ) - 74usize];
    ["Offset of field: nir_shader_compiler_options::lower_cs_local_index_to_id"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_cs_local_index_to_id) - 75usize];
    ["Offset of field: nir_shader_compiler_options::lower_cs_local_id_to_index"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_cs_local_id_to_index) - 76usize];
    ["Offset of field: nir_shader_compiler_options::has_cs_global_id"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_cs_global_id) - 77usize];
    ["Offset of field: nir_shader_compiler_options::lower_device_index_to_zero"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_device_index_to_zero) - 78usize];
    ["Offset of field: nir_shader_compiler_options::lower_wpos_pntc"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_wpos_pntc) - 79usize];
    ["Offset of field: nir_shader_compiler_options::lower_hadd"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_hadd) - 80usize];
    ["Offset of field: nir_shader_compiler_options::lower_hadd64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_hadd64) - 81usize];
    ["Offset of field: nir_shader_compiler_options::lower_uadd_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uadd_sat) - 82usize];
    ["Offset of field: nir_shader_compiler_options::lower_usub_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_usub_sat) - 83usize];
    ["Offset of field: nir_shader_compiler_options::lower_iadd_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_iadd_sat) - 84usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_32x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_32x16) - 85usize];
    ["Offset of field: nir_shader_compiler_options::vectorize_tess_levels"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vectorize_tess_levels) - 86usize];
    ["Offset of field: nir_shader_compiler_options::lower_to_scalar"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_to_scalar) - 87usize];
    ["Offset of field: nir_shader_compiler_options::lower_to_scalar_filter"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_to_scalar_filter) - 88usize];
    ["Offset of field: nir_shader_compiler_options::vectorize_vec2_16bit"]
        [::std::mem::offset_of!(nir_shader_compiler_options, vectorize_vec2_16bit) - 92usize];
    ["Offset of field: nir_shader_compiler_options::unify_interfaces"]
        [::std::mem::offset_of!(nir_shader_compiler_options, unify_interfaces) - 93usize];
    ["Offset of field: nir_shader_compiler_options::lower_interpolate_at"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_interpolate_at) - 94usize];
    ["Offset of field: nir_shader_compiler_options::lower_mul_2x32_64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mul_2x32_64) - 95usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate8) - 96usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate16) - 97usize];
    ["Offset of field: nir_shader_compiler_options::has_rotate32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_rotate32) - 98usize];
    ["Offset of field: nir_shader_compiler_options::has_shfr32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_shfr32) - 99usize];
    ["Offset of field: nir_shader_compiler_options::has_iadd3"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_iadd3) - 100usize];
    ["Offset of field: nir_shader_compiler_options::has_amul"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_amul) - 101usize];
    ["Offset of field: nir_shader_compiler_options::has_imul24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_imul24) - 102usize];
    ["Offset of field: nir_shader_compiler_options::has_umul24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_umul24) - 103usize];
    ["Offset of field: nir_shader_compiler_options::has_imad32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_imad32) - 104usize];
    ["Offset of field: nir_shader_compiler_options::has_umad24"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_umad24) - 105usize];
    ["Offset of field: nir_shader_compiler_options::has_fused_comp_and_csel"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fused_comp_and_csel) - 106usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz64) - 107usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz32"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz32) - 108usize];
    ["Offset of field: nir_shader_compiler_options::has_icsel_eqz16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_icsel_eqz16) - 109usize];
    ["Offset of field: nir_shader_compiler_options::has_fneo_fcmpu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fneo_fcmpu) - 110usize];
    ["Offset of field: nir_shader_compiler_options::has_ford_funord"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_ford_funord) - 111usize];
    ["Offset of field: nir_shader_compiler_options::has_fsub"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fsub) - 112usize];
    ["Offset of field: nir_shader_compiler_options::has_isub"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_isub) - 113usize];
    ["Offset of field: nir_shader_compiler_options::has_pack_32_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_pack_32_4x8) - 114usize];
    ["Offset of field: nir_shader_compiler_options::has_texture_scaling"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_texture_scaling) - 115usize];
    ["Offset of field: nir_shader_compiler_options::has_sdot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sdot_4x8) - 116usize];
    ["Offset of field: nir_shader_compiler_options::has_udot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_udot_4x8) - 117usize];
    ["Offset of field: nir_shader_compiler_options::has_sudot_4x8"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sudot_4x8) - 118usize];
    ["Offset of field: nir_shader_compiler_options::has_sdot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sdot_4x8_sat) - 119usize];
    ["Offset of field: nir_shader_compiler_options::has_udot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_udot_4x8_sat) - 120usize];
    ["Offset of field: nir_shader_compiler_options::has_sudot_4x8_sat"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_sudot_4x8_sat) - 121usize];
    ["Offset of field: nir_shader_compiler_options::has_dot_2x16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_dot_2x16) - 122usize];
    ["Offset of field: nir_shader_compiler_options::has_fmulz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fmulz) - 123usize];
    ["Offset of field: nir_shader_compiler_options::has_fmulz_no_denorms"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_fmulz_no_denorms) - 124usize];
    ["Offset of field: nir_shader_compiler_options::has_find_msb_rev"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_find_msb_rev) - 125usize];
    ["Offset of field: nir_shader_compiler_options::has_pack_half_2x16_rtz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_pack_half_2x16_rtz) - 126usize];
    ["Offset of field: nir_shader_compiler_options::has_bit_test"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bit_test) - 127usize];
    ["Offset of field: nir_shader_compiler_options::has_bfe"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfe) - 128usize];
    ["Offset of field: nir_shader_compiler_options::has_bfm"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfm) - 129usize];
    ["Offset of field: nir_shader_compiler_options::has_bfi"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bfi) - 130usize];
    ["Offset of field: nir_shader_compiler_options::has_bitfield_select"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_bitfield_select) - 131usize];
    ["Offset of field: nir_shader_compiler_options::has_uclz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_uclz) - 132usize];
    ["Offset of field: nir_shader_compiler_options::has_msad"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_msad) - 133usize];
    ["Offset of field: nir_shader_compiler_options::intel_vec4"]
        [::std::mem::offset_of!(nir_shader_compiler_options, intel_vec4) - 134usize];
    ["Offset of field: nir_shader_compiler_options::avoid_ternary_with_two_constants"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        avoid_ternary_with_two_constants
    )
        - 135usize];
    ["Offset of field: nir_shader_compiler_options::support_8bit_alu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_8bit_alu) - 136usize];
    ["Offset of field: nir_shader_compiler_options::support_16bit_alu"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_16bit_alu) - 137usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations"]
        [::std::mem::offset_of!(nir_shader_compiler_options, max_unroll_iterations) - 140usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations_aggressive"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_unroll_iterations_aggressive
    )
        - 144usize];
    ["Offset of field: nir_shader_compiler_options::max_unroll_iterations_fp64"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_unroll_iterations_fp64
    ) - 148usize];
    ["Offset of field: nir_shader_compiler_options::lower_uniforms_to_ubo"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_uniforms_to_ubo) - 152usize];
    ["Offset of field: nir_shader_compiler_options::force_indirect_unrolling_sampler"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        force_indirect_unrolling_sampler
    )
        - 153usize];
    ["Offset of field: nir_shader_compiler_options::no_integers"]
        [::std::mem::offset_of!(nir_shader_compiler_options, no_integers) - 154usize];
    ["Offset of field: nir_shader_compiler_options::force_indirect_unrolling"]
        [::std::mem::offset_of!(nir_shader_compiler_options, force_indirect_unrolling) - 156usize];
    ["Offset of field: nir_shader_compiler_options::driver_functions"]
        [::std::mem::offset_of!(nir_shader_compiler_options, driver_functions) - 160usize];
    ["Offset of field: nir_shader_compiler_options::late_lower_int64"]
        [::std::mem::offset_of!(nir_shader_compiler_options, late_lower_int64) - 161usize];
    ["Offset of field: nir_shader_compiler_options::lower_int64_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_int64_options) - 164usize];
    ["Offset of field: nir_shader_compiler_options::lower_doubles_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_doubles_options) - 168usize];
    ["Offset of field: nir_shader_compiler_options::divergence_analysis_options"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        divergence_analysis_options
    ) - 172usize];
    ["Offset of field: nir_shader_compiler_options::support_indirect_inputs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_indirect_inputs) - 176usize];
    ["Offset of field: nir_shader_compiler_options::support_indirect_outputs"]
        [::std::mem::offset_of!(nir_shader_compiler_options, support_indirect_outputs) - 177usize];
    ["Offset of field: nir_shader_compiler_options::lower_image_offset_to_range_base"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_image_offset_to_range_base
    )
        - 178usize];
    ["Offset of field: nir_shader_compiler_options::lower_atomic_offset_to_range_base"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_atomic_offset_to_range_base
    )
        - 179usize];
    ["Offset of field: nir_shader_compiler_options::preserve_mediump"]
        [::std::mem::offset_of!(nir_shader_compiler_options, preserve_mediump) - 180usize];
    ["Offset of field: nir_shader_compiler_options::lower_fquantize2f16"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_fquantize2f16) - 181usize];
    ["Offset of field: nir_shader_compiler_options::force_f2f16_rtz"]
        [::std::mem::offset_of!(nir_shader_compiler_options, force_f2f16_rtz) - 182usize];
    ["Offset of field: nir_shader_compiler_options::lower_layer_fs_input_to_sysval"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        lower_layer_fs_input_to_sysval
    ) - 183usize];
    ["Offset of field: nir_shader_compiler_options::compact_arrays"]
        [::std::mem::offset_of!(nir_shader_compiler_options, compact_arrays) - 184usize];
    ["Offset of field: nir_shader_compiler_options::discard_is_demote"]
        [::std::mem::offset_of!(nir_shader_compiler_options, discard_is_demote) - 185usize];
    ["Offset of field: nir_shader_compiler_options::has_ddx_intrinsics"]
        [::std::mem::offset_of!(nir_shader_compiler_options, has_ddx_intrinsics) - 186usize];
    ["Offset of field: nir_shader_compiler_options::scalarize_ddx"]
        [::std::mem::offset_of!(nir_shader_compiler_options, scalarize_ddx) - 187usize];
    ["Offset of field: nir_shader_compiler_options::per_view_unique_driver_locations"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        per_view_unique_driver_locations
    )
        - 188usize];
    ["Offset of field: nir_shader_compiler_options::compact_view_index"]
        [::std::mem::offset_of!(nir_shader_compiler_options, compact_view_index) - 189usize];
    ["Offset of field: nir_shader_compiler_options::io_options"]
        [::std::mem::offset_of!(nir_shader_compiler_options, io_options) - 192usize];
    ["Offset of field: nir_shader_compiler_options::skip_lower_packing_ops"]
        [::std::mem::offset_of!(nir_shader_compiler_options, skip_lower_packing_ops) - 196usize];
    ["Offset of field: nir_shader_compiler_options::lower_mediump_io"]
        [::std::mem::offset_of!(nir_shader_compiler_options, lower_mediump_io) - 200usize];
    ["Offset of field: nir_shader_compiler_options::varying_expression_max_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        varying_expression_max_cost
    ) - 204usize];
    ["Offset of field: nir_shader_compiler_options::varying_estimate_instr_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        varying_estimate_instr_cost
    ) - 208usize];
    ["Offset of field: nir_shader_compiler_options::max_varying_expression_cost"][::std::mem::offset_of!(
        nir_shader_compiler_options,
        max_varying_expression_cost
    ) - 212usize];
};
impl Default for nir_shader_compiler_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_shader {
    pub gctx: *mut gc_ctx,
    #[doc = " list of uniforms (nir_variable)"]
    pub variables: exec_list,
    #[doc = " Set of driver-specific options for the shader.\n\n The memory for the options is expected to be kept in a single static\n copy by the driver."]
    pub options: *const nir_shader_compiler_options,
    #[doc = " Various bits of compile-time information about a given shader"]
    pub info: shader_info,
    #[doc = " list of nir_function"]
    pub functions: exec_list,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_inputs: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_uniforms: ::std::os::raw::c_uint,
    #[doc = " The size of the variable space for load_input_*, load_uniform_*, etc.\n intrinsics.  This is in back-end specific units which is likely one of\n bytes, dwords, or vec4s depending on context and back-end."]
    pub num_outputs: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required implicitly bound global memory"]
    pub global_mem_size: ::std::os::raw::c_uint,
    #[doc = " Size in bytes of required scratch space"]
    pub scratch_size: ::std::os::raw::c_uint,
    #[doc = " Constant data associated with this shader.\n\n Constant data is loaded through load_constant intrinsics (as compared to\n the NIR load_const instructions which have the constant value inlined\n into them).  This is usually generated by nir_opt_large_constants (so\n shaders don't have to load_const into a temporary array when they want\n to indirect on a const array)."]
    pub constant_data: *mut ::std::os::raw::c_void,
    #[doc = " Size of the constant data associated with the shader, in bytes"]
    pub constant_data_size: ::std::os::raw::c_uint,
    pub xfb_info: *mut nir_xfb_info,
    pub printf_info_count: ::std::os::raw::c_uint,
    pub printf_info: *mut u_printf_info,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_shader"][::std::mem::size_of::<nir_shader>() - 400usize];
    ["Alignment of nir_shader"][::std::mem::align_of::<nir_shader>() - 4usize];
    ["Offset of field: nir_shader::gctx"][::std::mem::offset_of!(nir_shader, gctx) - 0usize];
    ["Offset of field: nir_shader::variables"]
        [::std::mem::offset_of!(nir_shader, variables) - 4usize];
    ["Offset of field: nir_shader::options"][::std::mem::offset_of!(nir_shader, options) - 20usize];
    ["Offset of field: nir_shader::info"][::std::mem::offset_of!(nir_shader, info) - 24usize];
    ["Offset of field: nir_shader::functions"]
        [::std::mem::offset_of!(nir_shader, functions) - 344usize];
    ["Offset of field: nir_shader::num_inputs"]
        [::std::mem::offset_of!(nir_shader, num_inputs) - 360usize];
    ["Offset of field: nir_shader::num_uniforms"]
        [::std::mem::offset_of!(nir_shader, num_uniforms) - 364usize];
    ["Offset of field: nir_shader::num_outputs"]
        [::std::mem::offset_of!(nir_shader, num_outputs) - 368usize];
    ["Offset of field: nir_shader::global_mem_size"]
        [::std::mem::offset_of!(nir_shader, global_mem_size) - 372usize];
    ["Offset of field: nir_shader::scratch_size"]
        [::std::mem::offset_of!(nir_shader, scratch_size) - 376usize];
    ["Offset of field: nir_shader::constant_data"]
        [::std::mem::offset_of!(nir_shader, constant_data) - 380usize];
    ["Offset of field: nir_shader::constant_data_size"]
        [::std::mem::offset_of!(nir_shader, constant_data_size) - 384usize];
    ["Offset of field: nir_shader::xfb_info"]
        [::std::mem::offset_of!(nir_shader, xfb_info) - 388usize];
    ["Offset of field: nir_shader::printf_info_count"]
        [::std::mem::offset_of!(nir_shader, printf_info_count) - 392usize];
    ["Offset of field: nir_shader::printf_info"]
        [::std::mem::offset_of!(nir_shader, printf_info) - 396usize];
};
impl Default for nir_shader {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_foreach_function_with_impl_first__extern"]
    pub fn nir_foreach_function_with_impl_first(shader: *const nir_shader) -> *mut nir_function;
}
unsafe extern "C" {
    #[link_name = "nir_foreach_function_with_impl_next__extern"]
    pub fn nir_foreach_function_with_impl_next(
        it: *mut *mut nir_function,
    ) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[link_name = "nir_shader_get_entrypoint__extern"]
    pub fn nir_shader_get_entrypoint(shader: *const nir_shader) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[link_name = "nir_shader_get_function_for_name__extern"]
    pub fn nir_shader_get_function_for_name(
        shader: *const nir_shader,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_function;
}
unsafe extern "C" {
    pub fn nir_remove_non_entrypoints(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_remove_non_exported(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_remove_entrypoints(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_fixup_is_exported(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_create(
        mem_ctx: *mut ::std::os::raw::c_void,
        stage: gl_shader_stage,
        options: *const nir_shader_compiler_options,
        si: *mut shader_info,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    #[doc = " Adds a variable to the appropriate list in nir_shader"]
    pub fn nir_shader_add_variable(shader: *mut nir_shader, var: *mut nir_variable);
}
unsafe extern "C" {
    #[link_name = "nir_function_impl_add_variable__extern"]
    pub fn nir_function_impl_add_variable(impl_: *mut nir_function_impl, var: *mut nir_variable);
}
unsafe extern "C" {
    #[doc = " creates a variable, sets a few defaults, and adds it to the list"]
    pub fn nir_variable_create(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    #[doc = " creates a local variable and adds it to the list"]
    pub fn nir_local_variable_create(
        impl_: *mut nir_function_impl,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    #[doc = " Creates a uniform builtin state variable."]
    pub fn nir_state_variable_create(
        shader: *mut nir_shader,
        type_: *const glsl_type,
        name: *const ::std::os::raw::c_char,
        tokens: *const [gl_state_index16; 4usize],
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_get_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_create_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_int,
        type_: *const glsl_type,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_variable_with_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_variable_with_driver_location(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        location: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_state_variable(
        s: *mut nir_shader,
        tokens: *mut [gl_state_index16; 4usize],
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_find_sampler_variable_with_tex_index(
        shader: *mut nir_shader,
        texture_index: ::std::os::raw::c_uint,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_sort_variables_with_modes(
        shader: *mut nir_shader,
        compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const nir_variable,
                arg2: *const nir_variable,
            ) -> ::std::os::raw::c_int,
        >,
        modes: nir_variable_mode,
    );
}
unsafe extern "C" {
    #[doc = " creates a function and adds it to the shader's list of functions"]
    pub fn nir_function_create(
        shader: *mut nir_shader,
        name: *const ::std::os::raw::c_char,
    ) -> *mut nir_function;
}
unsafe extern "C" {
    #[link_name = "nir_function_set_impl__extern"]
    pub fn nir_function_set_impl(func: *mut nir_function, impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_function_impl_create(func: *mut nir_function) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[doc = " creates a function_impl that isn't tied to any particular function"]
    pub fn nir_function_impl_create_bare(shader: *mut nir_shader) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_block_create(shader: *mut nir_shader) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_if_create(shader: *mut nir_shader) -> *mut nir_if;
}
unsafe extern "C" {
    pub fn nir_loop_create(shader: *mut nir_shader) -> *mut nir_loop;
}
unsafe extern "C" {
    pub fn nir_cf_node_get_function(node: *mut nir_cf_node) -> *mut nir_function_impl;
}
unsafe extern "C" {
    #[doc = " requests that the given pieces of metadata be generated"]
    pub fn nir_metadata_require(impl_: *mut nir_function_impl, required: nir_metadata, ...);
}
unsafe extern "C" {
    #[doc = " dirties all but the preserved metadata"]
    pub fn nir_metadata_preserve(impl_: *mut nir_function_impl, preserved: nir_metadata);
}
unsafe extern "C" {
    #[doc = " Preserves all metadata for the given shader"]
    pub fn nir_shader_preserve_all_metadata(shader: *mut nir_shader);
}
unsafe extern "C" {
    #[doc = " creates an instruction with default swizzle/writemask/etc. with NULL registers"]
    pub fn nir_alu_instr_create(shader: *mut nir_shader, op: nir_op) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    pub fn nir_deref_instr_create(
        shader: *mut nir_shader,
        deref_type: nir_deref_type,
    ) -> *mut nir_deref_instr;
}
unsafe extern "C" {
    pub fn nir_jump_instr_create(
        shader: *mut nir_shader,
        type_: nir_jump_type,
    ) -> *mut nir_jump_instr;
}
unsafe extern "C" {
    pub fn nir_load_const_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_load_const_instr;
}
unsafe extern "C" {
    pub fn nir_intrinsic_instr_create(
        shader: *mut nir_shader,
        op: nir_intrinsic_op,
    ) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    pub fn nir_call_instr_create(
        shader: *mut nir_shader,
        callee: *mut nir_function,
    ) -> *mut nir_call_instr;
}
unsafe extern "C" {
    #[doc = " Creates a NIR texture instruction"]
    pub fn nir_tex_instr_create(
        shader: *mut nir_shader,
        num_srcs: ::std::os::raw::c_uint,
    ) -> *mut nir_tex_instr;
}
unsafe extern "C" {
    pub fn nir_phi_instr_create(shader: *mut nir_shader) -> *mut nir_phi_instr;
}
unsafe extern "C" {
    pub fn nir_phi_instr_add_src(
        instr: *mut nir_phi_instr,
        pred: *mut nir_block,
        src: *mut nir_def,
    ) -> *mut nir_phi_src;
}
unsafe extern "C" {
    pub fn nir_parallel_copy_instr_create(shader: *mut nir_shader) -> *mut nir_parallel_copy_instr;
}
unsafe extern "C" {
    pub fn nir_debug_info_instr_create(
        shader: *mut nir_shader,
        type_: nir_debug_info_type,
        string_length: u32,
    ) -> *mut nir_debug_info_instr;
}
unsafe extern "C" {
    pub fn nir_undef_instr_create(
        shader: *mut nir_shader,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    ) -> *mut nir_undef_instr;
}
unsafe extern "C" {
    pub fn nir_alu_binop_identity(
        binop: nir_op,
        bit_size: ::std::os::raw::c_uint,
    ) -> nir_const_value;
}
#[repr(u32)]
#[doc = " NIR Cursors and Instruction Insertion API\n @{\n\n A tiny struct representing a point to insert/extract instructions or\n control flow nodes.  Helps reduce the combinatorial explosion of possible\n points to insert/extract.\n\n \\sa nir_control_flow.h"]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_cursor_option {
    nir_cursor_before_block = 0,
    nir_cursor_after_block = 1,
    nir_cursor_before_instr = 2,
    nir_cursor_after_instr = 3,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_cursor {
    pub option: nir_cursor_option,
    pub anon_1: nir_cursor__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union nir_cursor__bindgen_ty_1 {
    pub block: *mut nir_block,
    pub instr: *mut nir_instr,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cursor__bindgen_ty_1"]
        [::std::mem::size_of::<nir_cursor__bindgen_ty_1>() - 4usize];
    ["Alignment of nir_cursor__bindgen_ty_1"]
        [::std::mem::align_of::<nir_cursor__bindgen_ty_1>() - 4usize];
    ["Offset of field: nir_cursor__bindgen_ty_1::block"]
        [::std::mem::offset_of!(nir_cursor__bindgen_ty_1, block) - 0usize];
    ["Offset of field: nir_cursor__bindgen_ty_1::instr"]
        [::std::mem::offset_of!(nir_cursor__bindgen_ty_1, instr) - 0usize];
};
impl Default for nir_cursor__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_cursor"][::std::mem::size_of::<nir_cursor>() - 8usize];
    ["Alignment of nir_cursor"][::std::mem::align_of::<nir_cursor>() - 4usize];
    ["Offset of field: nir_cursor::option"][::std::mem::offset_of!(nir_cursor, option) - 0usize];
};
impl Default for nir_cursor {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "nir_cursor_current_block__extern"]
    pub fn nir_cursor_current_block(cursor: nir_cursor) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cursors_equal(a: nir_cursor, b: nir_cursor) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_before_block__extern"]
    pub fn nir_before_block(block: *mut nir_block) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_block__extern"]
    pub fn nir_after_block(block: *mut nir_block) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_instr__extern"]
    pub fn nir_before_instr(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_instr__extern"]
    pub fn nir_after_instr(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_block_after_phis__extern"]
    pub fn nir_before_block_after_phis(block: *mut nir_block) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_block_before_jump__extern"]
    pub fn nir_after_block_before_jump(block: *mut nir_block) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_src__extern"]
    pub fn nir_before_src(src: *mut nir_src) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_cf_node__extern"]
    pub fn nir_before_cf_node(node: *mut nir_cf_node) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_cf_node__extern"]
    pub fn nir_after_cf_node(node: *mut nir_cf_node) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_phis__extern"]
    pub fn nir_after_phis(block: *mut nir_block) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_instr_and_phis__extern"]
    pub fn nir_after_instr_and_phis(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_cf_node_and_phis__extern"]
    pub fn nir_after_cf_node_and_phis(node: *mut nir_cf_node) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_cf_list__extern"]
    pub fn nir_before_cf_list(cf_list: *mut exec_list) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_cf_list__extern"]
    pub fn nir_after_cf_list(cf_list: *mut exec_list) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_before_impl__extern"]
    pub fn nir_before_impl(impl_: *mut nir_function_impl) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_after_impl__extern"]
    pub fn nir_after_impl(impl_: *mut nir_function_impl) -> nir_cursor;
}
unsafe extern "C" {
    #[doc = " Insert a NIR instruction at the given cursor.\n\n Note: This does not update the cursor."]
    pub fn nir_instr_insert(cursor: nir_cursor, instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_move(cursor: nir_cursor, instr: *mut nir_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_before__extern"]
    pub fn nir_instr_insert_before(instr: *mut nir_instr, before: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_after__extern"]
    pub fn nir_instr_insert_after(instr: *mut nir_instr, after: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_before_block__extern"]
    pub fn nir_instr_insert_before_block(block: *mut nir_block, before: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_after_block__extern"]
    pub fn nir_instr_insert_after_block(block: *mut nir_block, after: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_before_cf__extern"]
    pub fn nir_instr_insert_before_cf(node: *mut nir_cf_node, before: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_after_cf__extern"]
    pub fn nir_instr_insert_after_cf(node: *mut nir_cf_node, after: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_before_cf_list__extern"]
    pub fn nir_instr_insert_before_cf_list(list: *mut exec_list, before: *mut nir_instr);
}
unsafe extern "C" {
    #[link_name = "nir_instr_insert_after_cf_list__extern"]
    pub fn nir_instr_insert_after_cf_list(list: *mut exec_list, after: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_remove_v(instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_free(instr: *mut nir_instr);
}
unsafe extern "C" {
    pub fn nir_instr_free_list(list: *mut exec_list);
}
unsafe extern "C" {
    #[link_name = "nir_instr_remove__extern"]
    pub fn nir_instr_remove(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    pub fn nir_instr_free_and_dce(instr: *mut nir_instr) -> nir_cursor;
}
unsafe extern "C" {
    #[doc = " @}"]
    pub fn nir_instr_def(instr: *mut nir_instr) -> *mut nir_def;
}
pub type nir_foreach_def_cb = ::std::option::Option<
    unsafe extern "C" fn(def: *mut nir_def, state: *mut ::std::os::raw::c_void) -> bool,
>;
pub type nir_foreach_src_cb = ::std::option::Option<
    unsafe extern "C" fn(src: *mut nir_src, state: *mut ::std::os::raw::c_void) -> bool,
>;
unsafe extern "C" {
    #[link_name = "nir_foreach_src__extern"]
    pub fn nir_foreach_src(
        instr: *mut nir_instr,
        cb: nir_foreach_src_cb,
        state: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_foreach_phi_src_leaving_block(
        instr: *mut nir_block,
        cb: nir_foreach_src_cb,
        state: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_src_as_const_value(src: nir_src) -> *mut nir_const_value;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_alu_instr__extern"]
    pub fn nir_src_as_alu_instr(src: nir_src) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_intrinsic__extern"]
    pub fn nir_src_as_intrinsic(src: nir_src) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    #[link_name = "nir_src_as_debug_info__extern"]
    pub fn nir_src_as_debug_info(src: nir_src) -> *mut nir_debug_info_instr;
}
unsafe extern "C" {
    pub fn nir_src_as_string(src: nir_src) -> *const ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_src_is_always_uniform(src: nir_src) -> bool;
}
unsafe extern "C" {
    pub fn nir_srcs_equal(src1: nir_src, src2: nir_src) -> bool;
}
unsafe extern "C" {
    pub fn nir_instrs_equal(instr1: *const nir_instr, instr2: *const nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_src_get_block(src: *mut nir_src) -> *mut nir_block;
}
unsafe extern "C" {
    #[link_name = "nir_src_rewrite__extern"]
    pub fn nir_src_rewrite(src: *mut nir_src, new_ssa: *mut nir_def);
}
unsafe extern "C" {
    #[doc = " Initialize a nir_src\n\n This is almost never the helper you want to use.  This helper assumes that\n the source is uninitialized garbage and blasts over it without doing any\n tear-down the existing source, including removing it from uses lists.\n Using this helper on a source that currently exists in any uses list will\n result in linked list corruption.  It also assumes that the instruction is\n currently live in the IR and adds the source to the uses list for the given\n nir_def as part of setup.\n\n This is pretty much only useful for adding sources to extant instructions\n or manipulating parallel copy instructions as part of out-of-SSA.\n\n When in doubt, use nir_src_rewrite() instead."]
    pub fn nir_instr_init_src(instr: *mut nir_instr, src: *mut nir_src, def: *mut nir_def);
}
unsafe extern "C" {
    #[doc = " Clear a nir_src\n\n This helper clears a nir_src by removing it from any uses lists and\n resetting its contents to NIR_SRC_INIT.  This is typically used as a\n precursor to removing the source from the instruction by adjusting a\n num_srcs parameter somewhere or overwriting it with nir_instr_move_src()."]
    pub fn nir_instr_clear_src(instr: *mut nir_instr, src: *mut nir_src);
}
unsafe extern "C" {
    pub fn nir_instr_move_src(dest_instr: *mut nir_instr, dest: *mut nir_src, src: *mut nir_src);
}
unsafe extern "C" {
    #[doc = " Returns true if first comes before second in a block."]
    pub fn nir_instr_is_before(first: *mut nir_instr, second: *mut nir_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_init(
        instr: *mut nir_instr,
        def: *mut nir_def,
        num_components: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_def_init_for_type__extern"]
    pub fn nir_def_init_for_type(instr: *mut nir_instr, def: *mut nir_def, type_: *const glsl_type);
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses(def: *mut nir_def, new_ssa: *mut nir_def);
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses_src(def: *mut nir_def, new_src: nir_src);
}
unsafe extern "C" {
    pub fn nir_def_rewrite_uses_after(
        def: *mut nir_def,
        new_ssa: *mut nir_def,
        after_me: *mut nir_instr,
    );
}
unsafe extern "C" {
    #[link_name = "nir_def_replace__extern"]
    pub fn nir_def_replace(def: *mut nir_def, new_ssa: *mut nir_def);
}
unsafe extern "C" {
    pub fn nir_src_components_read(src: *const nir_src) -> nir_component_mask_t;
}
unsafe extern "C" {
    pub fn nir_def_components_read(def: *const nir_def) -> nir_component_mask_t;
}
unsafe extern "C" {
    pub fn nir_def_all_uses_are_fsat(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_all_uses_ignore_sign_bit(def: *const nir_def) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_def_first_component_read__extern"]
    pub fn nir_def_first_component_read(def: *mut nir_def) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "nir_def_last_component_read__extern"]
    pub fn nir_def_last_component_read(def: *mut nir_def) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[link_name = "nir_def_is_unused__extern"]
    pub fn nir_def_is_unused(ssa: *mut nir_def) -> bool;
}
unsafe extern "C" {
    #[doc = " Sorts unstructured blocks\n\n NIR requires that unstructured blocks be sorted in reverse post\n depth-first-search order.  This is the standard ordering used in the\n compiler literature which guarantees dominance.  In particular, reverse\n post-DFS order guarantees that dominators occur in the list before the\n blocks they dominate.\n\n NOTE: This function also implicitly deletes any unreachable blocks."]
    pub fn nir_sort_unstructured_blocks(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    #[doc = " Returns the next block\n\n For structured control-flow, this follows the same order as\n nir_block_cf_tree_next().  For unstructured control-flow the blocks are in\n reverse post-DFS order.  (See nir_sort_unstructured_blocks() above.)"]
    pub fn nir_block_unstructured_next(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_unstructured_start_block(impl_: *mut nir_function_impl) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_cf_tree_next(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_cf_tree_prev(block: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_first(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_last(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_next(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_cf_node_cf_tree_prev(node: *mut nir_cf_node) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_get_following_if(block: *mut nir_block) -> *mut nir_if;
}
unsafe extern "C" {
    pub fn nir_block_get_following_loop(block: *mut nir_block) -> *mut nir_loop;
}
unsafe extern "C" {
    pub fn nir_block_get_predecessors_sorted(
        block: *const nir_block,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_index_ssa_defs(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_index_instrs(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_index_blocks(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_shader_clear_pass_flags(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_index_vars(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_function_impl_index_vars(impl_: *mut nir_function_impl) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_print_shader(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_print_shader_annotated(
        shader: *mut nir_shader,
        fp: *mut FILE,
        errors: *mut hash_table,
    );
}
unsafe extern "C" {
    pub fn nir_print_instr(instr: *const nir_instr, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_print_deref(deref: *const nir_deref_instr, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_log_shader_annotated_tagged(
        level: mesa_log_level,
        tag: *const ::std::os::raw::c_char,
        shader: *mut nir_shader,
        annotations: *mut hash_table,
    );
}
unsafe extern "C" {
    pub fn nir_shader_as_str(
        nir: *mut nir_shader,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_shader_as_str_annotated(
        nir: *mut nir_shader,
        annotations: *mut hash_table,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    pub fn nir_instr_as_str(
        instr: *const nir_instr,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Adds debug information to the shader. The line numbers point to\n the corresponding lines in the printed NIR, starting first_line;"]
    pub fn nir_shader_gather_debug_info(
        shader: *mut nir_shader,
        filename: *const ::std::os::raw::c_char,
        first_line: u32,
    ) -> *mut ::std::os::raw::c_char;
}
unsafe extern "C" {
    #[doc = " Shallow clone of a single instruction."]
    pub fn nir_instr_clone(s: *mut nir_shader, orig: *const nir_instr) -> *mut nir_instr;
}
unsafe extern "C" {
    #[doc = " Clone a single instruction, including a remap table to rewrite sources."]
    pub fn nir_instr_clone_deep(
        s: *mut nir_shader,
        orig: *const nir_instr,
        remap_table: *mut hash_table,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    #[doc = " Shallow clone of a single ALU instruction."]
    pub fn nir_alu_instr_clone(
        s: *mut nir_shader,
        orig: *const nir_alu_instr,
    ) -> *mut nir_alu_instr;
}
unsafe extern "C" {
    pub fn nir_shader_clone(
        mem_ctx: *mut ::std::os::raw::c_void,
        s: *const nir_shader,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_function_clone(ns: *mut nir_shader, fxn: *const nir_function) -> *mut nir_function;
}
unsafe extern "C" {
    pub fn nir_function_impl_clone(
        shader: *mut nir_shader,
        fi: *const nir_function_impl,
    ) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_function_impl_clone_remap_globals(
        shader: *mut nir_shader,
        fi: *const nir_function_impl,
        remap_table: *mut hash_table,
    ) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_constant_clone(c: *const nir_constant, var: *mut nir_variable) -> *mut nir_constant;
}
unsafe extern "C" {
    pub fn nir_variable_clone(c: *const nir_variable, shader: *mut nir_shader)
        -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_shader_replace(dest: *mut nir_shader, src: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_serialize_deserialize(s: *mut nir_shader);
}
unsafe extern "C" {
    #[link_name = "nir_validate_shader__extern"]
    pub fn nir_validate_shader(shader: *mut nir_shader, when: *const ::std::os::raw::c_char);
}
unsafe extern "C" {
    #[link_name = "nir_validate_ssa_dominance__extern"]
    pub fn nir_validate_ssa_dominance(shader: *mut nir_shader, when: *const ::std::os::raw::c_char);
}
unsafe extern "C" {
    #[link_name = "nir_metadata_set_validation_flag__extern"]
    pub fn nir_metadata_set_validation_flag(shader: *mut nir_shader);
}
unsafe extern "C" {
    #[link_name = "nir_metadata_check_validation_flag__extern"]
    pub fn nir_metadata_check_validation_flag(shader: *mut nir_shader);
}
unsafe extern "C" {
    #[link_name = "should_skip_nir__extern"]
    pub fn should_skip_nir(pass_name: *const ::std::os::raw::c_char) -> bool;
}
unsafe extern "C" {
    #[link_name = "should_print_nir__extern"]
    pub fn should_print_nir(shader: *mut nir_shader) -> bool;
}
#[doc = " An instruction filtering callback with writemask\n\n Returns true if the instruction should be processed with the associated\n writemask and false otherwise."]
pub type nir_instr_writemask_filter_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        writemask: ::std::os::raw::c_uint,
        arg2: *const ::std::os::raw::c_void,
    ) -> bool,
>;
#[doc = " A simple instruction lowering callback\n\n Many instruction lowering passes can be written as a simple function which\n takes an instruction as its input and returns a sequence of instructions\n that implement the consumed instruction.  This function type represents\n such a lowering function.  When called, a function with this prototype\n should either return NULL indicating that no lowering needs to be done or\n emit a sequence of instructions using the provided builder (whose cursor\n will already be placed after the instruction to be lowered) and return the\n resulting nir_def."]
pub type nir_lower_instr_cb = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut nir_builder,
        arg2: *mut nir_instr,
        arg3: *mut ::std::os::raw::c_void,
    ) -> *mut nir_def,
>;
unsafe extern "C" {
    #[doc = " Iterate over all the instructions in a nir_function_impl and lower them\n  using the provided callbacks\n\n This function implements the guts of a standard lowering pass for you.  It\n iterates over all of the instructions in a nir_function_impl and calls the\n filter callback on each one.  If the filter callback returns true, it then\n calls the lowering call back on the instruction.  (Splitting it this way\n allows us to avoid some save/restore work for instructions we know won't be\n lowered.)  If the instruction is dead after the lowering is complete, it\n will be removed.  If new instructions are added, the lowering callback will\n also be called on them in case multiple lowerings are required.\n\n If the callback indicates that the original instruction is replaced (either\n through a new SSA def or NIR_LOWER_INSTR_PROGRESS_REPLACE), then the\n instruction is removed along with any now-dead SSA defs it used.\n\n The metadata for the nir_function_impl will also be updated.  If any blocks\n are added (they cannot be removed), dominance and block indices will be\n invalidated."]
    pub fn nir_function_impl_lower_instructions(
        impl_: *mut nir_function_impl,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_lower_instructions(
        shader: *mut nir_shader,
        filter: nir_instr_filter_cb,
        lower: nir_lower_instr_cb,
        cb_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_calc_dominance_impl(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_calc_dominance(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_dominance_lca(b1: *mut nir_block, b2: *mut nir_block) -> *mut nir_block;
}
unsafe extern "C" {
    pub fn nir_block_dominates(parent: *mut nir_block, child: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_block_is_unreachable(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_dump_dom_tree_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_tree(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_frontier_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_dom_frontier(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_cfg_impl(impl_: *mut nir_function_impl, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_dump_cfg(shader: *mut nir_shader, fp: *mut FILE);
}
unsafe extern "C" {
    pub fn nir_gs_count_vertices_and_primitives(
        shader: *const nir_shader,
        out_vtxcnt: *mut ::std::os::raw::c_int,
        out_prmcnt: *mut ::std::os::raw::c_int,
        out_decomposed_prmcnt: *mut ::std::os::raw::c_int,
        num_streams: ::std::os::raw::c_uint,
    );
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_load_grouping {
    nir_group_all = 0,
    nir_group_same_resource_only = 1,
}
unsafe extern "C" {
    pub fn nir_group_loads(
        shader: *mut nir_shader,
        grouping: nir_load_grouping,
        max_distance: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn nir_shrink_vec_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_array_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_var_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_per_member_structs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_struct_vars(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_returns_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_returns(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_inline_function_impl(
        b: *mut nir_builder,
        impl_: *const nir_function_impl,
        params: *mut *mut nir_def,
        shader_var_remap: *mut hash_table,
    );
}
unsafe extern "C" {
    pub fn nir_inline_functions(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_cleanup_functions(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_link_shader_functions(
        shader: *mut nir_shader,
        link_shader: *const nir_shader,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_calls_to_builtins(s: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_find_inlinable_uniforms(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_inline_uniforms(
        shader: *mut nir_shader,
        num_uniforms: ::std::os::raw::c_uint,
        uniform_values: *const u32,
        uniform_dw_offsets: *const u16,
    );
}
unsafe extern "C" {
    pub fn nir_collect_src_uniforms(
        src: *const nir_src,
        component: ::std::os::raw::c_int,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_add_inlinable_uniforms(
        cond: *const nir_src,
        info: *mut nir_loop_info,
        uni_offsets: *mut u32,
        num_offsets: *mut u8,
        max_num_bo: ::std::os::raw::c_uint,
        max_offset: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn nir_propagate_invariant(shader: *mut nir_shader, invariant_prim: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_var_copy_instr(copy: *mut nir_intrinsic_instr, shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_lower_deref_copy_instr(b: *mut nir_builder, copy: *mut nir_intrinsic_instr);
}
unsafe extern "C" {
    pub fn nir_lower_var_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_memcpy(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_memcpy(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_fixup_deref_modes(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_fixup_deref_types(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_lower_global_vars_to_local(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_constant_to_temp(shader: *mut nir_shader);
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_array_deref_of_vec_options {
    nir_lower_direct_array_deref_of_vec_load = 1,
    nir_lower_indirect_array_deref_of_vec_load = 2,
    nir_lower_direct_array_deref_of_vec_store = 4,
    nir_lower_indirect_array_deref_of_vec_store = 8,
}
unsafe extern "C" {
    pub fn nir_lower_array_deref_of_vec(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        filter: ::std::option::Option<unsafe extern "C" fn(arg1: *mut nir_variable) -> bool>,
        options: nir_lower_array_deref_of_vec_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_indirect_derefs(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        max_lower_array_len: u32,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_indirect_var_derefs(shader: *mut nir_shader, vars: *const set) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_locals_to_regs(shader: *mut nir_shader, bool_bitsize: u8) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_to_temporaries(
        shader: *mut nir_shader,
        entrypoint: *mut nir_function_impl,
        outputs: bool,
        inputs: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_scratch(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        size_threshold: ::std::os::raw::c_int,
        variable_size_align: glsl_type_size_align_func,
        scratch_layout_size_align: glsl_type_size_align_func,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_scratch_to_var(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_halfz(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_shader_gather_info(shader: *mut nir_shader, entrypoint: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_gather_types(
        impl_: *mut nir_function_impl,
        float_types: *mut ::std::os::raw::c_uint,
        int_types: *mut ::std::os::raw::c_uint,
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tcs_info {
    pub all_invocations_define_tess_levels: bool,
    pub all_tess_levels_are_effectively_zero: bool,
    pub all_tess_levels_are_effectively_one: bool,
    pub always_executes_barrier: bool,
    pub discards_patches: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tcs_info"][::std::mem::size_of::<nir_tcs_info>() - 5usize];
    ["Alignment of nir_tcs_info"][::std::mem::align_of::<nir_tcs_info>() - 1usize];
    ["Offset of field: nir_tcs_info::all_invocations_define_tess_levels"]
        [::std::mem::offset_of!(nir_tcs_info, all_invocations_define_tess_levels) - 0usize];
    ["Offset of field: nir_tcs_info::all_tess_levels_are_effectively_zero"]
        [::std::mem::offset_of!(nir_tcs_info, all_tess_levels_are_effectively_zero) - 1usize];
    ["Offset of field: nir_tcs_info::all_tess_levels_are_effectively_one"]
        [::std::mem::offset_of!(nir_tcs_info, all_tess_levels_are_effectively_one) - 2usize];
    ["Offset of field: nir_tcs_info::always_executes_barrier"]
        [::std::mem::offset_of!(nir_tcs_info, always_executes_barrier) - 3usize];
    ["Offset of field: nir_tcs_info::discards_patches"]
        [::std::mem::offset_of!(nir_tcs_info, discards_patches) - 4usize];
};
unsafe extern "C" {
    pub fn nir_gather_tcs_info(
        nir: *const nir_shader,
        info: *mut nir_tcs_info,
        prim: tess_primitive_mode,
        spacing: gl_tess_spacing,
    );
}
unsafe extern "C" {
    pub fn nir_assign_var_locations(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        size: *mut ::std::os::raw::c_uint,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
    );
}
unsafe extern "C" {
    pub fn nir_remove_unused_varyings(producer: *mut nir_shader, consumer: *mut nir_shader)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_unused_io_vars(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        used_by_other_stage: *mut u64,
        used_by_other_stage_patches: *mut u64,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_compact_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        default_to_smooth_interp: bool,
    );
}
unsafe extern "C" {
    pub fn nir_link_xfb_varyings(producer: *mut nir_shader, consumer: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_link_opt_varyings(producer: *mut nir_shader, consumer: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_link_varying_precision(producer: *mut nir_shader, consumer: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_clone_uniform_variable(
        nir: *mut nir_shader,
        uniform: *mut nir_variable,
        spirv: bool,
    ) -> *mut nir_variable;
}
unsafe extern "C" {
    pub fn nir_clone_deref_instr(
        b: *mut nir_builder,
        var: *mut nir_variable,
        deref: *mut nir_deref_instr,
    ) -> *mut nir_deref_instr;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_opt_varyings_progress {
    nir_progress_producer = 1,
    nir_progress_consumer = 2,
}
unsafe extern "C" {
    pub fn nir_opt_varyings(
        producer: *mut nir_shader,
        consumer: *mut nir_shader,
        spirv: bool,
        max_uniform_components: ::std::os::raw::c_uint,
        max_ubos_per_stage: ::std::os::raw::c_uint,
    ) -> nir_opt_varyings_progress;
}
unsafe extern "C" {
    pub fn nir_slot_is_sysval_output(slot: gl_varying_slot, next_shader: gl_shader_stage) -> bool;
}
unsafe extern "C" {
    pub fn nir_slot_is_varying(slot: gl_varying_slot, next_shader: gl_shader_stage) -> bool;
}
unsafe extern "C" {
    pub fn nir_slot_is_sysval_output_and_varying(
        slot: gl_varying_slot,
        next_shader: gl_shader_stage,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_varying(intr: *mut nir_intrinsic_instr, next_shader: gl_shader_stage)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_sysval_output(
        intr: *mut nir_intrinsic_instr,
        next_shader: gl_shader_stage,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_amul(
        shader: *mut nir_shader,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_ubo_vec4(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_sort_variables_by_location(shader: *mut nir_shader, mode: nir_variable_mode);
}
unsafe extern "C" {
    pub fn nir_assign_io_var_locations(
        shader: *mut nir_shader,
        mode: nir_variable_mode,
        size: *mut ::std::os::raw::c_uint,
        stage: gl_shader_stage,
    );
}
unsafe extern "C" {
    pub fn nir_opt_clip_cull_const(shader: *mut nir_shader) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_io_options {
    nir_lower_io_lower_64bit_to_32 = 1,
    nir_lower_io_lower_64bit_float_to_32 = 2,
    nir_lower_io_lower_64bit_to_32_new = 4,
    #[doc = " Should nir_lower_io() create load_interpolated_input intrinsics?\n\n If not, it generates regular load_input intrinsics and interpolation\n information must be inferred from the list of input nir_variables."]
    nir_lower_io_use_interpolated_input_intrinsics = 8,
}
unsafe extern "C" {
    pub fn nir_lower_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_size: ::std::option::Option<
            unsafe extern "C" fn(arg1: *const glsl_type, arg2: bool) -> ::std::os::raw::c_int,
        >,
        arg1: nir_lower_io_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_io_add_const_offset_to_base(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_color_inputs(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_passes(nir: *mut nir_shader, renumber_vs_inputs: bool);
}
unsafe extern "C" {
    pub fn nir_io_add_intrinsic_xfb_info(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_explicit_types(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        type_info: glsl_type_size_align_func,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_gather_explicit_io_initializers(
        shader: *mut nir_shader,
        dst: *mut ::std::os::raw::c_void,
        dst_size: usize,
        mode: nir_variable_mode,
    );
}
unsafe extern "C" {
    pub fn nir_lower_vec3_to_vec4(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_address_format {
    #[doc = " An address format which is a simple 32-bit global GPU address."]
    nir_address_format_32bit_global = 0,
    #[doc = " An address format which is a simple 64-bit global GPU address."]
    nir_address_format_64bit_global = 1,
    #[doc = " An address format which is a 64-bit global GPU address encoded as a\n 2x32-bit vector."]
    nir_address_format_2x32bit_global = 2,
    #[doc = " An address format which is a 64-bit global base address and a 32-bit\n offset.\n\n This is identical to 64bit_bounded_global except that bounds checking\n is not applied when lowering to global access.  Even though the size is\n never used for an actual bounds check, it needs to be valid so we can\n lower deref_buffer_array_length properly."]
    nir_address_format_64bit_global_32bit_offset = 3,
    #[doc = " An address format which is a bounds-checked 64-bit global GPU address.\n\n The address is comprised as a 32-bit vec4 where .xy are a uint64_t base\n address stored with the low bits in .x and high bits in .y, .z is a\n size, and .w is an offset.  When the final I/O operation is lowered, .w\n is checked against .z and the operation is predicated on the result."]
    nir_address_format_64bit_bounded_global = 4,
    #[doc = " An address format which is comprised of a vec2 where the first\n component is a buffer index and the second is an offset."]
    nir_address_format_32bit_index_offset = 5,
    #[doc = " An address format which is a 64-bit value, where the high 32 bits\n are a buffer index, and the low 32 bits are an offset."]
    nir_address_format_32bit_index_offset_pack64 = 6,
    #[doc = " An address format which is comprised of a vec3 where the first two\n components specify the buffer and the third is an offset."]
    nir_address_format_vec2_index_32bit_offset = 7,
    #[doc = " An address format which represents generic pointers with a 62-bit\n pointer and a 2-bit enum in the top two bits.  The top two bits have\n the following meanings:\n\n  - 0x0: Global memory\n  - 0x1: Shared memory\n  - 0x2: Scratch memory\n  - 0x3: Global memory\n\n The redundancy between 0x0 and 0x3 is because of Intel sign-extension of\n addresses.  Valid global memory addresses may naturally have either 0 or\n ~0 as their high bits.\n\n Shared and scratch pointers are represented as 32-bit offsets with the\n top 32 bits only being used for the enum.  This allows us to avoid\n 64-bit address calculations in a bunch of cases."]
    nir_address_format_62bit_generic = 8,
    #[doc = " An address format which is a simple 32-bit offset."]
    nir_address_format_32bit_offset = 9,
    #[doc = " An address format which is a simple 32-bit offset cast to 64-bit."]
    nir_address_format_32bit_offset_as_64bit = 10,
    #[doc = " An address format representing a purely logical addressing model.  In\n this model, all deref chains must be complete from the dereference\n operation to the variable.  Cast derefs are not allowed.  These\n addresses will be 32-bit scalars but the format is immaterial because\n you can always chase the chain."]
    nir_address_format_logical = 11,
}
unsafe extern "C" {
    pub fn nir_address_format_bit_size(addr_format: nir_address_format) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_address_format_num_components(
        addr_format: nir_address_format,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_address_format_to_glsl_type__extern"]
    pub fn nir_address_format_to_glsl_type(addr_format: nir_address_format) -> *const glsl_type;
}
unsafe extern "C" {
    pub fn nir_address_format_null_value(addr_format: nir_address_format)
        -> *const nir_const_value;
}
unsafe extern "C" {
    pub fn nir_build_addr_iadd(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: *mut nir_def,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_iadd_imm(
        b: *mut nir_builder,
        addr: *mut nir_def,
        addr_format: nir_address_format,
        modes: nir_variable_mode,
        offset: i64,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_ieq(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_build_addr_isub(
        b: *mut nir_builder,
        addr0: *mut nir_def,
        addr1: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_explicit_io_address_from_deref(
        b: *mut nir_builder,
        deref: *mut nir_deref_instr,
        base_addr: *mut nir_def,
        addr_format: nir_address_format,
    ) -> *mut nir_def;
}
unsafe extern "C" {
    pub fn nir_get_explicit_deref_align(
        deref: *mut nir_deref_instr,
        default_to_type_align: bool,
        align_mul: *mut u32,
        align_offset: *mut u32,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_explicit_io_instr(
        b: *mut nir_builder,
        io_instr: *mut nir_intrinsic_instr,
        addr: *mut nir_def,
        addr_format: nir_address_format,
    );
}
unsafe extern "C" {
    pub fn nir_lower_explicit_io(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        arg1: nir_address_format,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_mem_access_shift_method {
    nir_mem_access_shift_method_scalar = 0,
    nir_mem_access_shift_method_shift64 = 1,
    nir_mem_access_shift_method_bytealign_amd = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_mem_access_size_align {
    pub num_components: u8,
    pub bit_size: u8,
    pub align: u16,
    pub shift: nir_mem_access_shift_method,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_mem_access_size_align"]
        [::std::mem::size_of::<nir_mem_access_size_align>() - 8usize];
    ["Alignment of nir_mem_access_size_align"]
        [::std::mem::align_of::<nir_mem_access_size_align>() - 4usize];
    ["Offset of field: nir_mem_access_size_align::num_components"]
        [::std::mem::offset_of!(nir_mem_access_size_align, num_components) - 0usize];
    ["Offset of field: nir_mem_access_size_align::bit_size"]
        [::std::mem::offset_of!(nir_mem_access_size_align, bit_size) - 1usize];
    ["Offset of field: nir_mem_access_size_align::align"]
        [::std::mem::offset_of!(nir_mem_access_size_align, align) - 2usize];
    ["Offset of field: nir_mem_access_size_align::shift"]
        [::std::mem::offset_of!(nir_mem_access_size_align, shift) - 4usize];
};
impl Default for nir_mem_access_size_align {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_lower_mem_access_bit_sizes_cb = ::std::option::Option<
    unsafe extern "C" fn(
        intrin: nir_intrinsic_op,
        bytes: u8,
        bit_size: u8,
        align_mul: u32,
        align_offset: u32,
        offset_is_const: bool,
        arg1: gl_access_qualifier,
        cb_data: *const ::std::os::raw::c_void,
    ) -> nir_mem_access_size_align,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_mem_access_bit_sizes_options {
    pub callback: nir_lower_mem_access_bit_sizes_cb,
    pub modes: nir_variable_mode,
    pub may_lower_unaligned_stores_to_atomics: bool,
    pub cb_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_mem_access_bit_sizes_options"]
        [::std::mem::size_of::<nir_lower_mem_access_bit_sizes_options>() - 16usize];
    ["Alignment of nir_lower_mem_access_bit_sizes_options"]
        [::std::mem::align_of::<nir_lower_mem_access_bit_sizes_options>() - 4usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::callback"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, callback) - 0usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::modes"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, modes) - 4usize];
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::may_lower_unaligned_stores_to_atomics"] [:: std :: mem :: offset_of ! (nir_lower_mem_access_bit_sizes_options , may_lower_unaligned_stores_to_atomics) - 8usize] ;
    ["Offset of field: nir_lower_mem_access_bit_sizes_options::cb_data"]
        [::std::mem::offset_of!(nir_lower_mem_access_bit_sizes_options, cb_data) - 12usize];
};
impl Default for nir_lower_mem_access_bit_sizes_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_lower_mem_access_bit_sizes(
        shader: *mut nir_shader,
        options: *const nir_lower_mem_access_bit_sizes_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_robust_access(
        s: *mut nir_shader,
        filter: nir_intrin_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
pub type nir_should_vectorize_mem_func = ::std::option::Option<
    unsafe extern "C" fn(
        align_mul: ::std::os::raw::c_uint,
        align_offset: ::std::os::raw::c_uint,
        bit_size: ::std::os::raw::c_uint,
        num_components: ::std::os::raw::c_uint,
        hole_size: i64,
        low: *mut nir_intrinsic_instr,
        high: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_load_store_vectorize_options {
    pub callback: nir_should_vectorize_mem_func,
    pub modes: nir_variable_mode,
    pub robust_modes: nir_variable_mode,
    pub cb_data: *mut ::std::os::raw::c_void,
    pub has_shared2_amd: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_load_store_vectorize_options"]
        [::std::mem::size_of::<nir_load_store_vectorize_options>() - 20usize];
    ["Alignment of nir_load_store_vectorize_options"]
        [::std::mem::align_of::<nir_load_store_vectorize_options>() - 4usize];
    ["Offset of field: nir_load_store_vectorize_options::callback"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, callback) - 0usize];
    ["Offset of field: nir_load_store_vectorize_options::modes"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, modes) - 4usize];
    ["Offset of field: nir_load_store_vectorize_options::robust_modes"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, robust_modes) - 8usize];
    ["Offset of field: nir_load_store_vectorize_options::cb_data"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, cb_data) - 12usize];
    ["Offset of field: nir_load_store_vectorize_options::has_shared2_amd"]
        [::std::mem::offset_of!(nir_load_store_vectorize_options, has_shared2_amd) - 16usize];
};
impl Default for nir_load_store_vectorize_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_load_store_vectorize(
        shader: *mut nir_shader,
        options: *const nir_load_store_vectorize_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_load_store_update_alignments(shader: *mut nir_shader) -> bool;
}
pub type nir_lower_shader_calls_should_remat_func = ::std::option::Option<
    unsafe extern "C" fn(instr: *mut nir_instr, data: *mut ::std::os::raw::c_void) -> bool,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_shader_calls_options {
    pub address_format: nir_address_format,
    pub stack_alignment: ::std::os::raw::c_uint,
    pub localized_loads: bool,
    pub vectorizer_callback: nir_should_vectorize_mem_func,
    pub vectorizer_data: *mut ::std::os::raw::c_void,
    pub should_remat_callback: nir_lower_shader_calls_should_remat_func,
    pub should_remat_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_shader_calls_options"]
        [::std::mem::size_of::<nir_lower_shader_calls_options>() - 28usize];
    ["Alignment of nir_lower_shader_calls_options"]
        [::std::mem::align_of::<nir_lower_shader_calls_options>() - 4usize];
    ["Offset of field: nir_lower_shader_calls_options::address_format"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, address_format) - 0usize];
    ["Offset of field: nir_lower_shader_calls_options::stack_alignment"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, stack_alignment) - 4usize];
    ["Offset of field: nir_lower_shader_calls_options::localized_loads"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, localized_loads) - 8usize];
    ["Offset of field: nir_lower_shader_calls_options::vectorizer_callback"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, vectorizer_callback) - 12usize];
    ["Offset of field: nir_lower_shader_calls_options::vectorizer_data"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, vectorizer_data) - 16usize];
    ["Offset of field: nir_lower_shader_calls_options::should_remat_callback"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, should_remat_callback) - 20usize];
    ["Offset of field: nir_lower_shader_calls_options::should_remat_data"]
        [::std::mem::offset_of!(nir_lower_shader_calls_options, should_remat_data) - 24usize];
};
impl Default for nir_lower_shader_calls_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_lower_shader_calls(
        shader: *mut nir_shader,
        options: *const nir_lower_shader_calls_options,
        resume_shaders_out: *mut *mut *mut nir_shader,
        num_resume_shaders_out: *mut u32,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_get_io_offset_src_number(instr: *const nir_intrinsic_instr)
        -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nir_get_io_arrayed_index_src_number(
        instr: *const nir_intrinsic_instr,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn nir_get_io_offset_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_get_io_arrayed_index_src(instr: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_get_shader_call_payload_src(call: *mut nir_intrinsic_instr) -> *mut nir_src;
}
unsafe extern "C" {
    pub fn nir_is_arrayed_io(var: *const nir_variable, stage: gl_shader_stage) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_reg_intrinsics_to_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vars_to_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_dead_derefs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_dead_derefs_impl(impl_: *mut nir_function_impl) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_remove_dead_variables_options {
    pub can_remove_var: ::std::option::Option<
        unsafe extern "C" fn(var: *mut nir_variable, data: *mut ::std::os::raw::c_void) -> bool,
    >,
    pub can_remove_var_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_remove_dead_variables_options"]
        [::std::mem::size_of::<nir_remove_dead_variables_options>() - 8usize];
    ["Alignment of nir_remove_dead_variables_options"]
        [::std::mem::align_of::<nir_remove_dead_variables_options>() - 4usize];
    ["Offset of field: nir_remove_dead_variables_options::can_remove_var"]
        [::std::mem::offset_of!(nir_remove_dead_variables_options, can_remove_var) - 0usize];
    ["Offset of field: nir_remove_dead_variables_options::can_remove_var_data"]
        [::std::mem::offset_of!(nir_remove_dead_variables_options, can_remove_var_data) - 4usize];
};
impl Default for nir_remove_dead_variables_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_remove_dead_variables(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
        options: *const nir_remove_dead_variables_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_variable_initializers(
        shader: *mut nir_shader,
        modes: nir_variable_mode,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_zero_initialize_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_clear_shared_memory(
        shader: *mut nir_shader,
        shared_size: ::std::os::raw::c_uint,
        chunk_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_move_vec_src_uses_to_dest(shader: *mut nir_shader, skip_const_srcs: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_move_output_stores_to_end(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_vec_to_regs(
        shader: *mut nir_shader,
        cb: nir_instr_writemask_filter_cb,
        _data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alpha_test(
        shader: *mut nir_shader,
        func: compare_func,
        alpha_to_one: bool,
        alpha_ref_state_tokens: *const gl_state_index16,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_flrp(
        shader: *mut nir_shader,
        lowering_mask: ::std::os::raw::c_uint,
        always_precise: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_scale_fdiv(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_to_scalar(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_width(
        shader: *mut nir_shader,
        cb: nir_vectorize_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_vec8_16_srcs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_bitsize(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_float(shader: *mut nir_shader, has_fcsel_ne: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_bool_to_int32(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_simplify_convert_alu_types(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_const_arrays_to_uniforms(
        shader: *mut nir_shader,
        max_uniform_components: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_convert_alu_types(
        shader: *mut nir_shader,
        should_lower: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut nir_intrinsic_instr) -> bool,
        >,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_constant_convert_alu_types(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_alu_conversion_to_intrinsic(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int_to_float(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_load_const_to_scalar(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_read_invocation_to_scalar(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_phis_to_scalar(shader: *mut nir_shader, lower_all: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_arrays_to_elements(producer: *mut nir_shader, consumer: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_lower_io_arrays_to_elements_no_indirects(
        shader: *mut nir_shader,
        outputs_only: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_to_scalar(
        shader: *mut nir_shader,
        mask: nir_variable_mode,
        filter: nir_instr_filter_cb,
        filter_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_to_scalar_early(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_io_to_vector(shader: *mut nir_shader, mask: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_vectorize_tess_levels(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_tcs_impl(
        options: *const nir_shader_compiler_options,
        locations: *mut ::std::os::raw::c_uint,
        num_locations: ::std::os::raw::c_uint,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_tcs(
        options: *const nir_shader_compiler_options,
        vs: *const nir_shader,
        patch_vertices: u8,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_create_passthrough_gs(
        options: *const nir_shader_compiler_options,
        prev_stage: *const nir_shader,
        primitive_type: mesa_prim,
        output_primitive_type: mesa_prim,
        emulate_edgeflags: bool,
        force_line_strip_out: bool,
        passthrough_prim_id: bool,
    ) -> *mut nir_shader;
}
unsafe extern "C" {
    pub fn nir_lower_fragcolor(shader: *mut nir_shader, max_cbufs: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_fragcoord_wtrans(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_frag_coord_to_pixel_coord(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_frag_coord_to_pixel_coord(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_viewport_transform(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_uniforms_to_ubo(
        shader: *mut nir_shader,
        dword_packed: bool,
        load_vec4: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_is_helper_invocation(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_single_sampled(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_atomics(shader: *mut nir_shader, filter: nir_instr_filter_cb) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_subgroups_options {
    pub filter: nir_instr_filter_cb,
    pub filter_data: *const ::std::os::raw::c_void,
    pub subgroup_size: u8,
    pub ballot_bit_size: u8,
    pub ballot_components: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_subgroups_options"]
        [::std::mem::size_of::<nir_lower_subgroups_options>() - 16usize];
    ["Alignment of nir_lower_subgroups_options"]
        [::std::mem::align_of::<nir_lower_subgroups_options>() - 4usize];
    ["Offset of field: nir_lower_subgroups_options::filter"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, filter) - 0usize];
    ["Offset of field: nir_lower_subgroups_options::filter_data"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, filter_data) - 4usize];
    ["Offset of field: nir_lower_subgroups_options::subgroup_size"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, subgroup_size) - 8usize];
    ["Offset of field: nir_lower_subgroups_options::ballot_bit_size"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, ballot_bit_size) - 9usize];
    ["Offset of field: nir_lower_subgroups_options::ballot_components"]
        [::std::mem::offset_of!(nir_lower_subgroups_options, ballot_components) - 10usize];
};
impl Default for nir_lower_subgroups_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl nir_lower_subgroups_options {
    #[inline]
    pub fn lower_to_scalar(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_to_scalar(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_to_scalar_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_to_scalar_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_trivial(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_trivial(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_trivial_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_trivial_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_eq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_eq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_eq_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_eq_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_vote_bool_eq(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_vote_bool_eq(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_vote_bool_eq_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_vote_bool_eq_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_first_invocation_to_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_first_invocation_to_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_first_invocation_to_ballot_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_first_invocation_to_ballot_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_read_first_invocation(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_first_invocation(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_read_first_invocation_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_read_first_invocation_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_subgroup_masks(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_subgroup_masks(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_subgroup_masks_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_subgroup_masks_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_relative_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_relative_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_relative_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_relative_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle_to_32bit(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_32bit(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_to_32bit_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_to_32bit_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle_to_swizzle_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle_to_swizzle_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_to_swizzle_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_to_swizzle_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                11usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                11usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_broadcast_dynamic_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                12usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_broadcast_dynamic_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                12usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_broadcast_dynamic_to_const(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_broadcast_dynamic_to_const(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_broadcast_dynamic_to_const_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                13usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_broadcast_dynamic_to_const_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                13usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_quad_vote(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_quad_vote(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_quad_vote_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                14usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_quad_vote_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                14usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_elect(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_elect(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_elect_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_elect_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_read_invocation_to_cond(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_read_invocation_to_cond(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_read_invocation_to_cond_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                16usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_read_invocation_to_cond_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                16usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_rotate_to_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_rotate_to_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_rotate_to_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                17usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_rotate_to_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                17usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_rotate_clustered_to_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_rotate_clustered_to_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_rotate_clustered_to_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                18usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_rotate_clustered_to_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                18usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_ballot_bit_count_to_mbcnt_amd(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_ballot_bit_count_to_mbcnt_amd(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_ballot_bit_count_to_mbcnt_amd_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                19usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_ballot_bit_count_to_mbcnt_amd_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                19usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_inverse_ballot(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_inverse_ballot(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_inverse_ballot_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                20usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_inverse_ballot_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                20usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_reduce(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_reduce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_reduce_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                21usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_reduce_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                21usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_boolean_reduce(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_reduce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_boolean_reduce_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                22usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_boolean_reduce_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                22usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_boolean_shuffle(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_boolean_shuffle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_boolean_shuffle_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 3usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                23usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_boolean_shuffle_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 3usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                23usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        lower_to_scalar: bool,
        lower_vote_trivial: bool,
        lower_vote_eq: bool,
        lower_vote_bool_eq: bool,
        lower_first_invocation_to_ballot: bool,
        lower_read_first_invocation: bool,
        lower_subgroup_masks: bool,
        lower_relative_shuffle: bool,
        lower_shuffle_to_32bit: bool,
        lower_shuffle_to_swizzle_amd: bool,
        lower_shuffle: bool,
        lower_quad: bool,
        lower_quad_broadcast_dynamic: bool,
        lower_quad_broadcast_dynamic_to_const: bool,
        lower_quad_vote: bool,
        lower_elect: bool,
        lower_read_invocation_to_cond: bool,
        lower_rotate_to_shuffle: bool,
        lower_rotate_clustered_to_shuffle: bool,
        lower_ballot_bit_count_to_mbcnt_amd: bool,
        lower_inverse_ballot: bool,
        lower_reduce: bool,
        lower_boolean_reduce: bool,
        lower_boolean_shuffle: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let lower_to_scalar: u8 = unsafe { ::std::mem::transmute(lower_to_scalar) };
            lower_to_scalar as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let lower_vote_trivial: u8 = unsafe { ::std::mem::transmute(lower_vote_trivial) };
            lower_vote_trivial as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let lower_vote_eq: u8 = unsafe { ::std::mem::transmute(lower_vote_eq) };
            lower_vote_eq as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let lower_vote_bool_eq: u8 = unsafe { ::std::mem::transmute(lower_vote_bool_eq) };
            lower_vote_bool_eq as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_first_invocation_to_ballot: u8 =
                unsafe { ::std::mem::transmute(lower_first_invocation_to_ballot) };
            lower_first_invocation_to_ballot as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_read_first_invocation: u8 =
                unsafe { ::std::mem::transmute(lower_read_first_invocation) };
            lower_read_first_invocation as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let lower_subgroup_masks: u8 = unsafe { ::std::mem::transmute(lower_subgroup_masks) };
            lower_subgroup_masks as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let lower_relative_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_relative_shuffle) };
            lower_relative_shuffle as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let lower_shuffle_to_32bit: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_32bit) };
            lower_shuffle_to_32bit as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let lower_shuffle_to_swizzle_amd: u8 =
                unsafe { ::std::mem::transmute(lower_shuffle_to_swizzle_amd) };
            lower_shuffle_to_swizzle_amd as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let lower_shuffle: u8 = unsafe { ::std::mem::transmute(lower_shuffle) };
            lower_shuffle as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let lower_quad: u8 = unsafe { ::std::mem::transmute(lower_quad) };
            lower_quad as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let lower_quad_broadcast_dynamic: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic) };
            lower_quad_broadcast_dynamic as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let lower_quad_broadcast_dynamic_to_const: u8 =
                unsafe { ::std::mem::transmute(lower_quad_broadcast_dynamic_to_const) };
            lower_quad_broadcast_dynamic_to_const as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let lower_quad_vote: u8 = unsafe { ::std::mem::transmute(lower_quad_vote) };
            lower_quad_vote as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let lower_elect: u8 = unsafe { ::std::mem::transmute(lower_elect) };
            lower_elect as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let lower_read_invocation_to_cond: u8 =
                unsafe { ::std::mem::transmute(lower_read_invocation_to_cond) };
            lower_read_invocation_to_cond as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let lower_rotate_to_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_rotate_to_shuffle) };
            lower_rotate_to_shuffle as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let lower_rotate_clustered_to_shuffle: u8 =
                unsafe { ::std::mem::transmute(lower_rotate_clustered_to_shuffle) };
            lower_rotate_clustered_to_shuffle as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let lower_ballot_bit_count_to_mbcnt_amd: u8 =
                unsafe { ::std::mem::transmute(lower_ballot_bit_count_to_mbcnt_amd) };
            lower_ballot_bit_count_to_mbcnt_amd as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lower_inverse_ballot: u8 = unsafe { ::std::mem::transmute(lower_inverse_ballot) };
            lower_inverse_ballot as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let lower_reduce: u8 = unsafe { ::std::mem::transmute(lower_reduce) };
            lower_reduce as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let lower_boolean_reduce: u8 = unsafe { ::std::mem::transmute(lower_boolean_reduce) };
            lower_boolean_reduce as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let lower_boolean_shuffle: u8 = unsafe { ::std::mem::transmute(lower_boolean_shuffle) };
            lower_boolean_shuffle as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_subgroups(
        shader: *mut nir_shader,
        options: *const nir_lower_subgroups_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_system_values(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_build_lowered_load_helper_invocation(b: *mut nir_builder) -> *mut nir_def;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_compute_system_values_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub num_workgroups: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_compute_system_values_options"]
        [::std::mem::size_of::<nir_lower_compute_system_values_options>() - 16usize];
    ["Alignment of nir_lower_compute_system_values_options"]
        [::std::mem::align_of::<nir_lower_compute_system_values_options>() - 4usize];
    ["Offset of field: nir_lower_compute_system_values_options::num_workgroups"]
        [::std::mem::offset_of!(nir_lower_compute_system_values_options, num_workgroups) - 4usize];
};
impl nir_lower_compute_system_values_options {
    #[inline]
    pub fn has_base_global_invocation_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_global_invocation_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_base_global_invocation_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_base_global_invocation_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_base_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_base_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_base_workgroup_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_base_workgroup_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_global_size(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_has_global_size(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_global_size_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_has_global_size_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shuffle_local_ids_for_quad_derivatives(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shuffle_local_ids_for_quad_derivatives(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shuffle_local_ids_for_quad_derivatives_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shuffle_local_ids_for_quad_derivatives_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_local_invocation_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_local_invocation_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_local_invocation_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_local_invocation_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_cs_local_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_cs_local_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_cs_local_id_to_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_cs_local_id_to_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn lower_workgroup_id_to_index(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_lower_workgroup_id_to_index(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn lower_workgroup_id_to_index_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_lower_workgroup_id_to_index_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn global_id_is_32bit(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_global_id_is_32bit(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn global_id_is_32bit_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_global_id_is_32bit_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn shortcut_1d_workgroup_id(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_shortcut_1d_workgroup_id(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn shortcut_1d_workgroup_id_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_shortcut_1d_workgroup_id_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        has_base_global_invocation_id: bool,
        has_base_workgroup_id: bool,
        has_global_size: bool,
        shuffle_local_ids_for_quad_derivatives: bool,
        lower_local_invocation_index: bool,
        lower_cs_local_id_to_index: bool,
        lower_workgroup_id_to_index: bool,
        global_id_is_32bit: bool,
        shortcut_1d_workgroup_id: bool,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let has_base_global_invocation_id: u8 =
                unsafe { ::std::mem::transmute(has_base_global_invocation_id) };
            has_base_global_invocation_id as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let has_base_workgroup_id: u8 = unsafe { ::std::mem::transmute(has_base_workgroup_id) };
            has_base_workgroup_id as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let has_global_size: u8 = unsafe { ::std::mem::transmute(has_global_size) };
            has_global_size as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let shuffle_local_ids_for_quad_derivatives: u8 =
                unsafe { ::std::mem::transmute(shuffle_local_ids_for_quad_derivatives) };
            shuffle_local_ids_for_quad_derivatives as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let lower_local_invocation_index: u8 =
                unsafe { ::std::mem::transmute(lower_local_invocation_index) };
            lower_local_invocation_index as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let lower_cs_local_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_cs_local_id_to_index) };
            lower_cs_local_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let lower_workgroup_id_to_index: u8 =
                unsafe { ::std::mem::transmute(lower_workgroup_id_to_index) };
            lower_workgroup_id_to_index as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let global_id_is_32bit: u8 = unsafe { ::std::mem::transmute(global_id_is_32bit) };
            global_id_is_32bit as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let shortcut_1d_workgroup_id: u8 =
                unsafe { ::std::mem::transmute(shortcut_1d_workgroup_id) };
            shortcut_1d_workgroup_id as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_compute_system_values(
        shader: *mut nir_shader,
        options: *const nir_lower_compute_system_values_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_sysvals_to_varyings_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_sysvals_to_varyings_options"]
        [::std::mem::size_of::<nir_lower_sysvals_to_varyings_options>() - 1usize];
    ["Alignment of nir_lower_sysvals_to_varyings_options"]
        [::std::mem::align_of::<nir_lower_sysvals_to_varyings_options>() - 1usize];
};
impl nir_lower_sysvals_to_varyings_options {
    #[inline]
    pub fn frag_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_frag_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn frag_coord_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_frag_coord_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn front_face(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_front_face(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn front_face_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_front_face_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn point_coord(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_point_coord(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn point_coord_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_point_coord_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        frag_coord: bool,
        front_face: bool,
        point_coord: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let frag_coord: u8 = unsafe { ::std::mem::transmute(frag_coord) };
            frag_coord as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let front_face: u8 = unsafe { ::std::mem::transmute(front_face) };
            front_face as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let point_coord: u8 = unsafe { ::std::mem::transmute(point_coord) };
            point_coord as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_sysvals_to_varyings(
        shader: *mut nir_shader,
        options: *const nir_lower_sysvals_to_varyings_options,
    ) -> bool;
}
#[repr(u8)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_tex_packing {
    #[doc = " No packing"]
    nir_lower_tex_packing_none = 0,
    #[doc = " The sampler returns up to 2 32-bit words of half floats or 16-bit signed\n or unsigned ints based on the sampler type"]
    nir_lower_tex_packing_16 = 1,
    #[doc = " The sampler returns 1 32-bit word of 4x8 unorm"]
    nir_lower_tex_packing_8 = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialOrd, PartialEq)]
pub struct nir_lower_tex_options {
    #[doc = " bitmask of (1 << GLSL_SAMPLER_DIM_x) to control for which\n sampler types a texture projector is lowered."]
    pub lower_txp: ::std::os::raw::c_uint,
    #[doc = " If true, lower texture projector for any array sampler dims"]
    pub lower_txp_array: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all texelfetch instructions."]
    pub lower_txf_offset: bool,
    #[doc = " If true, lower away nir_tex_src_offset for all rect textures."]
    pub lower_rect_offset: bool,
    #[doc = " If not NULL, this filter will return true for tex instructions that\n should lower away nir_tex_src_offset."]
    pub lower_offset_filter: nir_instr_filter_cb,
    #[doc = " If true, lower rect textures to 2D, using txs to fetch the\n texture dimensions and dividing the texture coords by the\n texture dims to normalize."]
    pub lower_rect: bool,
    #[doc = " If true, lower 1D textures to 2D. This requires the GL/VK driver to map 1D\n textures to 2D textures with height=1.\n\n lower_1d_shadow does this lowering for shadow textures only."]
    pub lower_1d: bool,
    pub lower_1d_shadow: bool,
    #[doc = " If true, convert yuv to rgb."]
    pub lower_y_uv_external: ::std::os::raw::c_uint,
    pub lower_y_vu_external: ::std::os::raw::c_uint,
    pub lower_y_u_v_external: ::std::os::raw::c_uint,
    pub lower_yx_xuxv_external: ::std::os::raw::c_uint,
    pub lower_yx_xvxu_external: ::std::os::raw::c_uint,
    pub lower_xy_uxvx_external: ::std::os::raw::c_uint,
    pub lower_xy_vxux_external: ::std::os::raw::c_uint,
    pub lower_ayuv_external: ::std::os::raw::c_uint,
    pub lower_xyuv_external: ::std::os::raw::c_uint,
    pub lower_yuv_external: ::std::os::raw::c_uint,
    pub lower_yu_yv_external: ::std::os::raw::c_uint,
    pub lower_yv_yu_external: ::std::os::raw::c_uint,
    pub lower_y41x_external: ::std::os::raw::c_uint,
    pub bt709_external: ::std::os::raw::c_uint,
    pub bt2020_external: ::std::os::raw::c_uint,
    pub yuv_full_range_external: ::std::os::raw::c_uint,
    #[doc = " To emulate certain texture wrap modes, this can be used\n to saturate the specified tex coord to [0.0, 1.0].  The\n bits are according to sampler #, ie. if, for example:\n\n   (conf->saturate_s & (1 << n))\n\n is true, then the s coord for sampler n is saturated.\n\n Note that clamping must happen *after* projector lowering\n so any projected texture sample instruction with a clamped\n coordinate gets automatically lowered, regardless of the\n 'lower_txp' setting."]
    pub saturate_s: ::std::os::raw::c_uint,
    pub saturate_t: ::std::os::raw::c_uint,
    pub saturate_r: ::std::os::raw::c_uint,
    pub swizzle_result: ::std::os::raw::c_uint,
    pub swizzles: [[u8; 4usize]; 32usize],
    pub scale_factors: [::std::os::raw::c_float; 32usize],
    #[doc = " Bitmap of textures that need srgb to linear conversion.  If\n (lower_srgb & (1 << texture_index)) then the rgb (xyz) components\n of the texture are lowered to linear."]
    pub lower_srgb: ::std::os::raw::c_uint,
    #[doc = " If true, lower nir_texop_txd on cube maps with nir_texop_txl."]
    pub lower_txd_cube_map: bool,
    #[doc = " If true, lower nir_texop_txd on 3D surfaces with nir_texop_txl."]
    pub lower_txd_3d: bool,
    #[doc = " If true, lower nir_texop_txd any array surfaces with nir_texop_txl."]
    pub lower_txd_array: bool,
    #[doc = " If true, lower nir_texop_txd on shadow samplers (except cube maps)\n with nir_texop_txl. Notice that cube map shadow samplers are lowered\n with lower_txd_cube_map."]
    pub lower_txd_shadow: bool,
    #[doc = " If true, lower nir_texop_txd on all samplers to a nir_texop_txl.\n Implies lower_txd_cube_map and lower_txd_shadow."]
    pub lower_txd: bool,
    #[doc = " If true, lower nir_texop_txd  when it uses min_lod."]
    pub lower_txd_clamp: bool,
    #[doc = " If true, lower nir_texop_txb that try to use shadow compare and min_lod\n at the same time to a nir_texop_lod, some math, and nir_texop_tex."]
    pub lower_txb_shadow_clamp: bool,
    #[doc = " If true, lower nir_texop_txd on shadow samplers when it uses min_lod\n with nir_texop_txl.  This includes cube maps."]
    pub lower_txd_shadow_clamp: bool,
    #[doc = " If true, lower nir_texop_txd on when it uses both offset and min_lod\n with nir_texop_txl.  This includes cube maps."]
    pub lower_txd_offset_clamp: bool,
    #[doc = " If true, lower nir_texop_txd with min_lod to a nir_texop_txl if the\n sampler is bindless."]
    pub lower_txd_clamp_bindless_sampler: bool,
    #[doc = " If true, lower nir_texop_txd with min_lod to a nir_texop_txl if the\n sampler index is not statically determinable to be less than 16."]
    pub lower_txd_clamp_if_sampler_index_not_lt_16: bool,
    #[doc = " If true, lower nir_texop_txs with a non-0-lod into nir_texop_txs with\n 0-lod followed by a nir_ishr."]
    pub lower_txs_lod: bool,
    #[doc = " If true, lower nir_texop_txs for cube arrays to a nir_texop_txs with a\n 2D array type followed by a nir_idiv by 6."]
    pub lower_txs_cube_array: bool,
    #[doc = " If true, apply a .bagr swizzle on tg4 results to handle Broadcom's\n mixed-up tg4 locations."]
    pub lower_tg4_broadcom_swizzle: bool,
    #[doc = " If true, lowers tg4 with 4 constant offsets to 4 tg4 calls"]
    pub lower_tg4_offsets: bool,
    #[doc = " Lower txf_ms to fragment_mask_fetch and fragment_fetch and samples_identical to\n fragment_mask_fetch."]
    pub lower_to_fragment_fetch_amd: bool,
    #[doc = " To lower packed sampler return formats. This will be called for all\n tex instructions."]
    pub lower_tex_packing_cb: ::std::option::Option<
        unsafe extern "C" fn(
            tex: *const nir_tex_instr,
            data: *const ::std::os::raw::c_void,
        ) -> nir_lower_tex_packing,
    >,
    pub lower_tex_packing_data: *const ::std::os::raw::c_void,
    #[doc = " If true, lower nir_texop_lod to return -FLT_MAX if the sum of the\n absolute values of derivatives is 0 for all coordinates."]
    pub lower_lod_zero_width: bool,
    pub lower_invalid_implicit_lod: bool,
    pub lower_index_to_offset: bool,
    #[doc = " Payload data to be sent to callback / filter functions."]
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_tex_options"][::std::mem::size_of::<nir_lower_tex_options>() - 388usize];
    ["Alignment of nir_lower_tex_options"]
        [::std::mem::align_of::<nir_lower_tex_options>() - 4usize];
    ["Offset of field: nir_lower_tex_options::lower_txp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txp) - 0usize];
    ["Offset of field: nir_lower_tex_options::lower_txp_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txp_array) - 4usize];
    ["Offset of field: nir_lower_tex_options::lower_txf_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txf_offset) - 5usize];
    ["Offset of field: nir_lower_tex_options::lower_rect_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_rect_offset) - 6usize];
    ["Offset of field: nir_lower_tex_options::lower_offset_filter"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_offset_filter) - 8usize];
    ["Offset of field: nir_lower_tex_options::lower_rect"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_rect) - 12usize];
    ["Offset of field: nir_lower_tex_options::lower_1d"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_1d) - 13usize];
    ["Offset of field: nir_lower_tex_options::lower_1d_shadow"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_1d_shadow) - 14usize];
    ["Offset of field: nir_lower_tex_options::lower_y_uv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_uv_external) - 16usize];
    ["Offset of field: nir_lower_tex_options::lower_y_vu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_vu_external) - 20usize];
    ["Offset of field: nir_lower_tex_options::lower_y_u_v_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y_u_v_external) - 24usize];
    ["Offset of field: nir_lower_tex_options::lower_yx_xuxv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yx_xuxv_external) - 28usize];
    ["Offset of field: nir_lower_tex_options::lower_yx_xvxu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yx_xvxu_external) - 32usize];
    ["Offset of field: nir_lower_tex_options::lower_xy_uxvx_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xy_uxvx_external) - 36usize];
    ["Offset of field: nir_lower_tex_options::lower_xy_vxux_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xy_vxux_external) - 40usize];
    ["Offset of field: nir_lower_tex_options::lower_ayuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_ayuv_external) - 44usize];
    ["Offset of field: nir_lower_tex_options::lower_xyuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_xyuv_external) - 48usize];
    ["Offset of field: nir_lower_tex_options::lower_yuv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yuv_external) - 52usize];
    ["Offset of field: nir_lower_tex_options::lower_yu_yv_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yu_yv_external) - 56usize];
    ["Offset of field: nir_lower_tex_options::lower_yv_yu_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_yv_yu_external) - 60usize];
    ["Offset of field: nir_lower_tex_options::lower_y41x_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_y41x_external) - 64usize];
    ["Offset of field: nir_lower_tex_options::bt709_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, bt709_external) - 68usize];
    ["Offset of field: nir_lower_tex_options::bt2020_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, bt2020_external) - 72usize];
    ["Offset of field: nir_lower_tex_options::yuv_full_range_external"]
        [::std::mem::offset_of!(nir_lower_tex_options, yuv_full_range_external) - 76usize];
    ["Offset of field: nir_lower_tex_options::saturate_s"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_s) - 80usize];
    ["Offset of field: nir_lower_tex_options::saturate_t"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_t) - 84usize];
    ["Offset of field: nir_lower_tex_options::saturate_r"]
        [::std::mem::offset_of!(nir_lower_tex_options, saturate_r) - 88usize];
    ["Offset of field: nir_lower_tex_options::swizzle_result"]
        [::std::mem::offset_of!(nir_lower_tex_options, swizzle_result) - 92usize];
    ["Offset of field: nir_lower_tex_options::swizzles"]
        [::std::mem::offset_of!(nir_lower_tex_options, swizzles) - 96usize];
    ["Offset of field: nir_lower_tex_options::scale_factors"]
        [::std::mem::offset_of!(nir_lower_tex_options, scale_factors) - 224usize];
    ["Offset of field: nir_lower_tex_options::lower_srgb"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_srgb) - 352usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_cube_map"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_cube_map) - 356usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_3d"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_3d) - 357usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_array) - 358usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_shadow"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_shadow) - 359usize];
    ["Offset of field: nir_lower_tex_options::lower_txd"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd) - 360usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_clamp) - 361usize];
    ["Offset of field: nir_lower_tex_options::lower_txb_shadow_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txb_shadow_clamp) - 362usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_shadow_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_shadow_clamp) - 363usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_offset_clamp"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txd_offset_clamp) - 364usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_clamp_bindless_sampler"][::std::mem::offset_of!(
        nir_lower_tex_options,
        lower_txd_clamp_bindless_sampler
    ) - 365usize];
    ["Offset of field: nir_lower_tex_options::lower_txd_clamp_if_sampler_index_not_lt_16"][::std::mem::offset_of!(
        nir_lower_tex_options,
        lower_txd_clamp_if_sampler_index_not_lt_16
    )
        - 366usize];
    ["Offset of field: nir_lower_tex_options::lower_txs_lod"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txs_lod) - 367usize];
    ["Offset of field: nir_lower_tex_options::lower_txs_cube_array"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_txs_cube_array) - 368usize];
    ["Offset of field: nir_lower_tex_options::lower_tg4_broadcom_swizzle"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tg4_broadcom_swizzle) - 369usize];
    ["Offset of field: nir_lower_tex_options::lower_tg4_offsets"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tg4_offsets) - 370usize];
    ["Offset of field: nir_lower_tex_options::lower_to_fragment_fetch_amd"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_to_fragment_fetch_amd) - 371usize];
    ["Offset of field: nir_lower_tex_options::lower_tex_packing_cb"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tex_packing_cb) - 372usize];
    ["Offset of field: nir_lower_tex_options::lower_tex_packing_data"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_tex_packing_data) - 376usize];
    ["Offset of field: nir_lower_tex_options::lower_lod_zero_width"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_lod_zero_width) - 380usize];
    ["Offset of field: nir_lower_tex_options::lower_invalid_implicit_lod"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_invalid_implicit_lod) - 381usize];
    ["Offset of field: nir_lower_tex_options::lower_index_to_offset"]
        [::std::mem::offset_of!(nir_lower_tex_options, lower_index_to_offset) - 382usize];
    ["Offset of field: nir_lower_tex_options::callback_data"]
        [::std::mem::offset_of!(nir_lower_tex_options, callback_data) - 384usize];
};
impl Default for nir_lower_tex_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[doc = " Lowers complex texture instructions to simpler ones"]
    pub fn nir_lower_tex(shader: *mut nir_shader, options: *const nir_lower_tex_options) -> bool;
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_tex_shadow_swizzle {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_tex_shadow_swizzle"]
        [::std::mem::size_of::<nir_lower_tex_shadow_swizzle>() - 4usize];
    ["Alignment of nir_lower_tex_shadow_swizzle"]
        [::std::mem::align_of::<nir_lower_tex_shadow_swizzle>() - 4usize];
};
impl nir_lower_tex_shadow_swizzle {
    #[inline]
    pub fn swizzle_r(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_r(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_r_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_r_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_g(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_g(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_g_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_g_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_b(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_b(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_b_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_b_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn swizzle_a(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_swizzle_a(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn swizzle_a_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                3u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_swizzle_a_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                3u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        swizzle_r: ::std::os::raw::c_uint,
        swizzle_g: ::std::os::raw::c_uint,
        swizzle_b: ::std::os::raw::c_uint,
        swizzle_a: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let swizzle_r: u32 = unsafe { ::std::mem::transmute(swizzle_r) };
            swizzle_r as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let swizzle_g: u32 = unsafe { ::std::mem::transmute(swizzle_g) };
            swizzle_g as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let swizzle_b: u32 = unsafe { ::std::mem::transmute(swizzle_b) };
            swizzle_b as u64
        });
        __bindgen_bitfield_unit.set(9usize, 3u8, {
            let swizzle_a: u32 = unsafe { ::std::mem::transmute(swizzle_a) };
            swizzle_a as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_tex_shadow(
        s: *mut nir_shader,
        n_states: ::std::os::raw::c_uint,
        compare_func: *mut compare_func,
        tex_swizzles: *mut nir_lower_tex_shadow_swizzle,
        is_fixed_point_format: bool,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_image_options {
    #[doc = " If true, lower cube size operations."]
    pub lower_cube_size: bool,
    #[doc = " Lower multi sample image load and samples_identical to use fragment_mask_load."]
    pub lower_to_fragment_mask_load_amd: bool,
    #[doc = " Lower image_samples to a constant in case the driver doesn't support multisampled\n images."]
    pub lower_image_samples_to_one: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_image_options"][::std::mem::size_of::<nir_lower_image_options>() - 3usize];
    ["Alignment of nir_lower_image_options"]
        [::std::mem::align_of::<nir_lower_image_options>() - 1usize];
    ["Offset of field: nir_lower_image_options::lower_cube_size"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_cube_size) - 0usize];
    ["Offset of field: nir_lower_image_options::lower_to_fragment_mask_load_amd"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_to_fragment_mask_load_amd) - 1usize];
    ["Offset of field: nir_lower_image_options::lower_image_samples_to_one"]
        [::std::mem::offset_of!(nir_lower_image_options, lower_image_samples_to_one) - 2usize];
};
unsafe extern "C" {
    pub fn nir_lower_image(nir: *mut nir_shader, options: *const nir_lower_image_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_image_atomics_to_global(s: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_readonly_images_to_tex(shader: *mut nir_shader, per_variable: bool) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_non_uniform_access_type {
    nir_lower_non_uniform_ubo_access = 1,
    nir_lower_non_uniform_ssbo_access = 2,
    nir_lower_non_uniform_texture_access = 4,
    nir_lower_non_uniform_image_access = 8,
    nir_lower_non_uniform_get_ssbo_size = 16,
    nir_lower_non_uniform_access_type_count = 5,
}
pub type nir_lower_non_uniform_access_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_src,
        arg2: *mut ::std::os::raw::c_void,
    ) -> nir_component_mask_t,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_non_uniform_access_options {
    pub types: nir_lower_non_uniform_access_type,
    pub callback: nir_lower_non_uniform_access_callback,
    pub callback_data: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_non_uniform_access_options"]
        [::std::mem::size_of::<nir_lower_non_uniform_access_options>() - 12usize];
    ["Alignment of nir_lower_non_uniform_access_options"]
        [::std::mem::align_of::<nir_lower_non_uniform_access_options>() - 4usize];
    ["Offset of field: nir_lower_non_uniform_access_options::types"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, types) - 0usize];
    ["Offset of field: nir_lower_non_uniform_access_options::callback"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, callback) - 4usize];
    ["Offset of field: nir_lower_non_uniform_access_options::callback_data"]
        [::std::mem::offset_of!(nir_lower_non_uniform_access_options, callback_data) - 8usize];
};
impl Default for nir_lower_non_uniform_access_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_has_non_uniform_access(
        shader: *mut nir_shader,
        types: nir_lower_non_uniform_access_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_non_uniform_access(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_non_uniform_access(
        shader: *mut nir_shader,
        options: *const nir_lower_non_uniform_access_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_idiv_options {
    pub allow_fp16: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_idiv_options"][::std::mem::size_of::<nir_lower_idiv_options>() - 1usize];
    ["Alignment of nir_lower_idiv_options"]
        [::std::mem::align_of::<nir_lower_idiv_options>() - 1usize];
    ["Offset of field: nir_lower_idiv_options::allow_fp16"]
        [::std::mem::offset_of!(nir_lower_idiv_options, allow_fp16) - 0usize];
};
unsafe extern "C" {
    pub fn nir_lower_idiv(shader: *mut nir_shader, options: *const nir_lower_idiv_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_input_attachment_options {
    pub use_fragcoord_sysval: bool,
    pub use_layer_id_sysval: bool,
    pub use_view_id_for_layer: bool,
    pub unscaled_depth_stencil_ir3: bool,
    pub unscaled_input_attachment_ir3: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_input_attachment_options"]
        [::std::mem::size_of::<nir_input_attachment_options>() - 8usize];
    ["Alignment of nir_input_attachment_options"]
        [::std::mem::align_of::<nir_input_attachment_options>() - 4usize];
    ["Offset of field: nir_input_attachment_options::use_fragcoord_sysval"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_fragcoord_sysval) - 0usize];
    ["Offset of field: nir_input_attachment_options::use_layer_id_sysval"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_layer_id_sysval) - 1usize];
    ["Offset of field: nir_input_attachment_options::use_view_id_for_layer"]
        [::std::mem::offset_of!(nir_input_attachment_options, use_view_id_for_layer) - 2usize];
    ["Offset of field: nir_input_attachment_options::unscaled_depth_stencil_ir3"]
        [::std::mem::offset_of!(nir_input_attachment_options, unscaled_depth_stencil_ir3) - 3usize];
    ["Offset of field: nir_input_attachment_options::unscaled_input_attachment_ir3"][::std::mem::offset_of!(
        nir_input_attachment_options,
        unscaled_input_attachment_ir3
    ) - 4usize];
};
unsafe extern "C" {
    pub fn nir_lower_input_attachments(
        shader: *mut nir_shader,
        options: *const nir_input_attachment_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_vs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_vars: bool,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_gs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_fs(
        shader: *mut nir_shader,
        ucp_enables: ::std::os::raw::c_uint,
        use_clipdist_array: bool,
        use_load_interp: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_cull_distance_to_vec4s(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_cull_distance_arrays(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clip_disable(
        shader: *mut nir_shader,
        clip_plane_enable: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_point_size_mov(
        shader: *mut nir_shader,
        pointsize_state_tokens: *const gl_state_index16,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_frexp(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_two_sided_color(shader: *mut nir_shader, face_sysval: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_clamp_color_outputs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_flatshade(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_passthrough_edgeflags(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_patch_vertices(
        nir: *mut nir_shader,
        static_count: ::std::os::raw::c_uint,
        uniform_state_tokens: *const gl_state_index16,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_wpos_ytransform_options {
    pub state_tokens: [gl_state_index16; 4usize],
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_wpos_ytransform_options"]
        [::std::mem::size_of::<nir_lower_wpos_ytransform_options>() - 10usize];
    ["Alignment of nir_lower_wpos_ytransform_options"]
        [::std::mem::align_of::<nir_lower_wpos_ytransform_options>() - 2usize];
    ["Offset of field: nir_lower_wpos_ytransform_options::state_tokens"]
        [::std::mem::offset_of!(nir_lower_wpos_ytransform_options, state_tokens) - 0usize];
};
impl nir_lower_wpos_ytransform_options {
    #[inline]
    pub fn fs_coord_origin_upper_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_upper_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_origin_upper_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_origin_upper_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_origin_lower_left(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_origin_lower_left(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_origin_lower_left_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_origin_lower_left_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_pixel_center_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_pixel_center_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fs_coord_pixel_center_half_integer(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_fs_coord_pixel_center_half_integer(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fs_coord_pixel_center_half_integer_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_fs_coord_pixel_center_half_integer_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fs_coord_origin_upper_left: bool,
        fs_coord_origin_lower_left: bool,
        fs_coord_pixel_center_integer: bool,
        fs_coord_pixel_center_half_integer: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fs_coord_origin_upper_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_upper_left) };
            fs_coord_origin_upper_left as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fs_coord_origin_lower_left: u8 =
                unsafe { ::std::mem::transmute(fs_coord_origin_lower_left) };
            fs_coord_origin_lower_left as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fs_coord_pixel_center_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_integer) };
            fs_coord_pixel_center_integer as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fs_coord_pixel_center_half_integer: u8 =
                unsafe { ::std::mem::transmute(fs_coord_pixel_center_half_integer) };
            fs_coord_pixel_center_half_integer as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_wpos_ytransform(
        shader: *mut nir_shader,
        options: *const nir_lower_wpos_ytransform_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_wpos_center(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_pntc_ytransform(
        shader: *mut nir_shader,
        clipplane_state_tokens: *const [[gl_state_index16; 4usize]; 0usize],
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_wrmasks(
        shader: *mut nir_shader,
        cb: nir_instr_filter_cb,
        data: *const ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_fb_read(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_drawpixels_options {
    pub texcoord_state_tokens: [gl_state_index16; 4usize],
    pub scale_state_tokens: [gl_state_index16; 4usize],
    pub bias_state_tokens: [gl_state_index16; 4usize],
    pub drawpix_sampler: ::std::os::raw::c_uint,
    pub pixelmap_sampler: ::std::os::raw::c_uint,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_drawpixels_options"]
        [::std::mem::size_of::<nir_lower_drawpixels_options>() - 36usize];
    ["Alignment of nir_lower_drawpixels_options"]
        [::std::mem::align_of::<nir_lower_drawpixels_options>() - 4usize];
    ["Offset of field: nir_lower_drawpixels_options::texcoord_state_tokens"]
        [::std::mem::offset_of!(nir_lower_drawpixels_options, texcoord_state_tokens) - 0usize];
    ["Offset of field: nir_lower_drawpixels_options::scale_state_tokens"]
        [::std::mem::offset_of!(nir_lower_drawpixels_options, scale_state_tokens) - 8usize];
    ["Offset of field: nir_lower_drawpixels_options::bias_state_tokens"]
        [::std::mem::offset_of!(nir_lower_drawpixels_options, bias_state_tokens) - 16usize];
    ["Offset of field: nir_lower_drawpixels_options::drawpix_sampler"]
        [::std::mem::offset_of!(nir_lower_drawpixels_options, drawpix_sampler) - 24usize];
    ["Offset of field: nir_lower_drawpixels_options::pixelmap_sampler"]
        [::std::mem::offset_of!(nir_lower_drawpixels_options, pixelmap_sampler) - 28usize];
};
impl nir_lower_drawpixels_options {
    #[inline]
    pub fn pixel_maps(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_pixel_maps(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pixel_maps_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_pixel_maps_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn scale_and_bias(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_scale_and_bias(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn scale_and_bias_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_scale_and_bias_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pixel_maps: bool,
        scale_and_bias: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pixel_maps: u8 = unsafe { ::std::mem::transmute(pixel_maps) };
            pixel_maps as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let scale_and_bias: u8 = unsafe { ::std::mem::transmute(scale_and_bias) };
            scale_and_bias as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_drawpixels(
        shader: *mut nir_shader,
        options: *const nir_lower_drawpixels_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_bitmap_options {
    pub sampler: ::std::os::raw::c_uint,
    pub swizzle_xxxx: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_bitmap_options"]
        [::std::mem::size_of::<nir_lower_bitmap_options>() - 8usize];
    ["Alignment of nir_lower_bitmap_options"]
        [::std::mem::align_of::<nir_lower_bitmap_options>() - 4usize];
    ["Offset of field: nir_lower_bitmap_options::sampler"]
        [::std::mem::offset_of!(nir_lower_bitmap_options, sampler) - 0usize];
    ["Offset of field: nir_lower_bitmap_options::swizzle_xxxx"]
        [::std::mem::offset_of!(nir_lower_bitmap_options, swizzle_xxxx) - 4usize];
};
unsafe extern "C" {
    pub fn nir_lower_bitmap(
        shader: *mut nir_shader,
        options: *const nir_lower_bitmap_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_atomics_to_ssbo(
        shader: *mut nir_shader,
        offset_align_state: ::std::os::raw::c_uint,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_gs_intrinsics_flags {
    nir_lower_gs_intrinsics_per_stream = 1,
    nir_lower_gs_intrinsics_count_primitives = 2,
    nir_lower_gs_intrinsics_count_vertices_per_primitive = 4,
    nir_lower_gs_intrinsics_overwrite_incomplete = 8,
    nir_lower_gs_intrinsics_always_end_primitive = 16,
    nir_lower_gs_intrinsics_count_decomposed_primitives = 32,
}
unsafe extern "C" {
    pub fn nir_lower_gs_intrinsics(
        shader: *mut nir_shader,
        options: nir_lower_gs_intrinsics_flags,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_tess_coord_z(shader: *mut nir_shader, triangles: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_task_shader_options {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub payload_offset_in_bytes: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_task_shader_options"]
        [::std::mem::size_of::<nir_lower_task_shader_options>() - 8usize];
    ["Alignment of nir_lower_task_shader_options"]
        [::std::mem::align_of::<nir_lower_task_shader_options>() - 4usize];
    ["Offset of field: nir_lower_task_shader_options::payload_offset_in_bytes"]
        [::std::mem::offset_of!(nir_lower_task_shader_options, payload_offset_in_bytes) - 4usize];
};
impl nir_lower_task_shader_options {
    #[inline]
    pub fn payload_to_shared_for_atomics(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_atomics(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn payload_to_shared_for_atomics_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_payload_to_shared_for_atomics_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn payload_to_shared_for_small_types(&self) -> bool {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_payload_to_shared_for_small_types(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn payload_to_shared_for_small_types_raw(this: *const Self) -> bool {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_payload_to_shared_for_small_types_raw(this: *mut Self, val: bool) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        payload_to_shared_for_atomics: bool,
        payload_to_shared_for_small_types: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let payload_to_shared_for_atomics: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_atomics) };
            payload_to_shared_for_atomics as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let payload_to_shared_for_small_types: u8 =
                unsafe { ::std::mem::transmute(payload_to_shared_for_small_types) };
            payload_to_shared_for_small_types as u64
        });
        __bindgen_bitfield_unit
    }
}
unsafe extern "C" {
    pub fn nir_lower_task_shader(
        shader: *mut nir_shader,
        options: nir_lower_task_shader_options,
    ) -> bool;
}
pub type nir_lower_bit_size_callback = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const nir_instr,
        arg2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
unsafe extern "C" {
    pub fn nir_lower_bit_size(
        shader: *mut nir_shader,
        callback: nir_lower_bit_size_callback,
        callback_data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_64bit_phis(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_split_64bit_vec3_and_vec4(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int64_op_to_options_mask(opcode: nir_op) -> nir_lower_int64_options;
}
unsafe extern "C" {
    pub fn nir_lower_int64(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_int64_float_conversions(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_doubles_op_to_options_mask(opcode: nir_op) -> nir_lower_doubles_options;
}
unsafe extern "C" {
    pub fn nir_lower_doubles(
        shader: *mut nir_shader,
        softfp64: *const nir_shader,
        options: nir_lower_doubles_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_pack(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_recompute_io_bases(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_mediump_vars(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_mediump_io(
        nir: *mut nir_shader,
        modes: nir_variable_mode,
        varying_mask: u64,
        use_16bit_slots: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_force_mediump_io(
        nir: *mut nir_shader,
        modes: nir_variable_mode,
        types: nir_alu_type,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_unpack_16bit_varying_slots(nir: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_tex_srcs_options {
    pub sampler_dims: ::std::os::raw::c_uint,
    pub src_types: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_tex_srcs_options"]
        [::std::mem::size_of::<nir_opt_tex_srcs_options>() - 8usize];
    ["Alignment of nir_opt_tex_srcs_options"]
        [::std::mem::align_of::<nir_opt_tex_srcs_options>() - 4usize];
    ["Offset of field: nir_opt_tex_srcs_options::sampler_dims"]
        [::std::mem::offset_of!(nir_opt_tex_srcs_options, sampler_dims) - 0usize];
    ["Offset of field: nir_opt_tex_srcs_options::src_types"]
        [::std::mem::offset_of!(nir_opt_tex_srcs_options, src_types) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_16bit_tex_image_options {
    pub rounding_mode: nir_rounding_mode,
    pub opt_tex_dest_types: nir_alu_type,
    pub opt_image_dest_types: nir_alu_type,
    pub integer_dest_saturates: bool,
    pub opt_image_store_data: bool,
    pub opt_image_srcs: bool,
    pub opt_srcs_options_count: ::std::os::raw::c_uint,
    pub opt_srcs_options: *mut nir_opt_tex_srcs_options,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_16bit_tex_image_options"]
        [::std::mem::size_of::<nir_opt_16bit_tex_image_options>() - 20usize];
    ["Alignment of nir_opt_16bit_tex_image_options"]
        [::std::mem::align_of::<nir_opt_16bit_tex_image_options>() - 4usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::rounding_mode"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, rounding_mode) - 0usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_tex_dest_types"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_tex_dest_types) - 4usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_dest_types"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_dest_types) - 5usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::integer_dest_saturates"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, integer_dest_saturates) - 6usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_store_data"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_store_data) - 7usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_image_srcs"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_image_srcs) - 8usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_srcs_options_count"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_srcs_options_count) - 12usize];
    ["Offset of field: nir_opt_16bit_tex_image_options::opt_srcs_options"]
        [::std::mem::offset_of!(nir_opt_16bit_tex_image_options, opt_srcs_options) - 16usize];
};
impl Default for nir_opt_16bit_tex_image_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_16bit_tex_image(
        nir: *mut nir_shader,
        options: *mut nir_opt_16bit_tex_image_options,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_tex_src_type_constraint {
    pub legalize_type: bool,
    pub bit_size: u8,
    pub match_src: nir_tex_src_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_tex_src_type_constraint"]
        [::std::mem::size_of::<nir_tex_src_type_constraint>() - 8usize];
    ["Alignment of nir_tex_src_type_constraint"]
        [::std::mem::align_of::<nir_tex_src_type_constraint>() - 4usize];
    ["Offset of field: nir_tex_src_type_constraint::legalize_type"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, legalize_type) - 0usize];
    ["Offset of field: nir_tex_src_type_constraint::bit_size"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, bit_size) - 1usize];
    ["Offset of field: nir_tex_src_type_constraint::match_src"]
        [::std::mem::offset_of!(nir_tex_src_type_constraint, match_src) - 4usize];
};
impl Default for nir_tex_src_type_constraint {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type nir_tex_src_type_constraints = [nir_tex_src_type_constraint; 22usize];
unsafe extern "C" {
    pub fn nir_legalize_16bit_sampler_srcs(
        nir: *mut nir_shader,
        constraints: *mut nir_tex_src_type_constraints,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_point_size(
        shader: *mut nir_shader,
        min: ::std::os::raw::c_float,
        max: ::std::os::raw::c_float,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_texcoord_replace(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
        yinvert: bool,
    );
}
unsafe extern "C" {
    pub fn nir_lower_texcoord_replace_late(
        s: *mut nir_shader,
        coord_replace: ::std::os::raw::c_uint,
        point_coord_is_sysval: bool,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_interpolation_options {
    nir_lower_interpolation_at_sample = 2,
    nir_lower_interpolation_at_offset = 4,
    nir_lower_interpolation_centroid = 8,
    nir_lower_interpolation_pixel = 16,
    nir_lower_interpolation_sample = 32,
}
unsafe extern "C" {
    pub fn nir_lower_interpolation(
        shader: *mut nir_shader,
        options: nir_lower_interpolation_options,
    ) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_discard_if_options {
    nir_lower_discard_if_to_cf = 1,
    nir_lower_demote_if_to_cf = 2,
    nir_lower_terminate_if_to_cf = 4,
}
unsafe extern "C" {
    pub fn nir_lower_discard_if(
        shader: *mut nir_shader,
        options: nir_lower_discard_if_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_terminate_to_demote(nir: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_memory_model(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_goto_ifs(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_continue_constructs(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_multiview_options {
    pub view_mask: u32,
    #[doc = " Bitfield of output locations that may be converted to a per-view array.\n\n If a variable exists in an allowed location, it will be converted to an\n array even if its value does not depend on the view index."]
    pub allowed_per_view_outputs: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_multiview_options"]
        [::std::mem::size_of::<nir_lower_multiview_options>() - 12usize];
    ["Alignment of nir_lower_multiview_options"]
        [::std::mem::align_of::<nir_lower_multiview_options>() - 4usize];
    ["Offset of field: nir_lower_multiview_options::view_mask"]
        [::std::mem::offset_of!(nir_lower_multiview_options, view_mask) - 0usize];
    ["Offset of field: nir_lower_multiview_options::allowed_per_view_outputs"]
        [::std::mem::offset_of!(nir_lower_multiview_options, allowed_per_view_outputs) - 4usize];
};
unsafe extern "C" {
    pub fn nir_shader_uses_view_index(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_can_lower_multiview(
        shader: *mut nir_shader,
        options: nir_lower_multiview_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_multiview(
        shader: *mut nir_shader,
        options: nir_lower_multiview_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_view_index_to_device_index(shader: *mut nir_shader) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_lower_fp16_cast_options {
    nir_lower_fp16_rtz = 1,
    nir_lower_fp16_rtne = 2,
    nir_lower_fp16_ru = 4,
    nir_lower_fp16_rd = 8,
    nir_lower_fp16_all = 15,
    nir_lower_fp16_split_fp64 = 16,
}
unsafe extern "C" {
    pub fn nir_lower_fp16_casts(
        shader: *mut nir_shader,
        options: nir_lower_fp16_cast_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_normalize_cubemap_coords(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_supports_implicit_lod(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_live_defs_impl(impl_: *mut nir_function_impl);
}
unsafe extern "C" {
    pub fn nir_get_live_defs(
        cursor: nir_cursor,
        mem_ctx: *mut ::std::os::raw::c_void,
    ) -> *const ::std::os::raw::c_uint;
}
unsafe extern "C" {
    pub fn nir_loop_analyze_impl(
        impl_: *mut nir_function_impl,
        indirect_mask: nir_variable_mode,
        force_unroll_sampler_indirect: bool,
    );
}
unsafe extern "C" {
    pub fn nir_defs_interfere(a: *mut nir_def, b: *mut nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_repair_ssa_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_repair_ssa(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_convert_loop_to_lcssa(loop_: *mut nir_loop);
}
unsafe extern "C" {
    pub fn nir_convert_to_lcssa(
        shader: *mut nir_shader,
        skip_invariants: bool,
        skip_bool_invariants: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_divergence_analysis_impl(
        impl_: *mut nir_function_impl,
        options: nir_divergence_options,
    );
}
unsafe extern "C" {
    pub fn nir_divergence_analysis(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_vertex_divergence_analysis(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_has_divergent_loop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_rewrite_uses_to_load_reg(b: *mut nir_builder, old: *mut nir_def, reg: *mut nir_def);
}
unsafe extern "C" {
    pub fn nir_convert_from_ssa(
        shader: *mut nir_shader,
        phi_webs_only: bool,
        consider_divergence: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_phis_to_regs_block(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_ssa_defs_to_regs_block(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_rematerialize_deref_in_use_blocks(instr: *mut nir_deref_instr) -> bool;
}
unsafe extern "C" {
    pub fn nir_rematerialize_derefs_in_use_blocks_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_samplers(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_cl_images(
        shader: *mut nir_shader,
        lower_image_derefs: bool,
        lower_sampler_derefs: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_dedup_inline_samplers(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_ssbo_options {
    pub native_loads: bool,
    pub native_offset: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_ssbo_options"][::std::mem::size_of::<nir_lower_ssbo_options>() - 2usize];
    ["Alignment of nir_lower_ssbo_options"]
        [::std::mem::align_of::<nir_lower_ssbo_options>() - 1usize];
    ["Offset of field: nir_lower_ssbo_options::native_loads"]
        [::std::mem::offset_of!(nir_lower_ssbo_options, native_loads) - 0usize];
    ["Offset of field: nir_lower_ssbo_options::native_offset"]
        [::std::mem::offset_of!(nir_lower_ssbo_options, native_offset) - 1usize];
};
unsafe extern "C" {
    pub fn nir_lower_ssbo(shader: *mut nir_shader, opts: *const nir_lower_ssbo_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_helper_writes(shader: *mut nir_shader, lower_plain_stores: bool) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_lower_printf_options {
    pub max_buffer_size: ::std::os::raw::c_uint,
    pub ptr_bit_size: ::std::os::raw::c_uint,
    pub use_printf_base_identifier: bool,
    pub hash_format_strings: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_lower_printf_options"]
        [::std::mem::size_of::<nir_lower_printf_options>() - 12usize];
    ["Alignment of nir_lower_printf_options"]
        [::std::mem::align_of::<nir_lower_printf_options>() - 4usize];
    ["Offset of field: nir_lower_printf_options::max_buffer_size"]
        [::std::mem::offset_of!(nir_lower_printf_options, max_buffer_size) - 0usize];
    ["Offset of field: nir_lower_printf_options::ptr_bit_size"]
        [::std::mem::offset_of!(nir_lower_printf_options, ptr_bit_size) - 4usize];
    ["Offset of field: nir_lower_printf_options::use_printf_base_identifier"]
        [::std::mem::offset_of!(nir_lower_printf_options, use_printf_base_identifier) - 8usize];
    ["Offset of field: nir_lower_printf_options::hash_format_strings"]
        [::std::mem::offset_of!(nir_lower_printf_options, hash_format_strings) - 9usize];
};
unsafe extern "C" {
    pub fn nir_lower_printf(nir: *mut nir_shader, options: *const nir_lower_printf_options)
        -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_printf_buffer(nir: *mut nir_shader, address: u64, size: u32) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_comparison_pre_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_comparison_pre(shader: *mut nir_shader) -> bool;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_access_options {
    pub is_vulkan: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_access_options"][::std::mem::size_of::<nir_opt_access_options>() - 1usize];
    ["Alignment of nir_opt_access_options"]
        [::std::mem::align_of::<nir_opt_access_options>() - 1usize];
    ["Offset of field: nir_opt_access_options::is_vulkan"]
        [::std::mem::offset_of!(nir_opt_access_options, is_vulkan) - 0usize];
};
unsafe extern "C" {
    pub fn nir_opt_access(shader: *mut nir_shader, options: *const nir_opt_access_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_before_ffma(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_before_lower_int64(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_late(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_algebraic_distribute_src_mods(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_constant_folding(shader: *mut nir_shader) -> bool;
}
pub type nir_combine_barrier_cb = ::std::option::Option<
    unsafe extern "C" fn(
        a: *mut nir_intrinsic_instr,
        b: *mut nir_intrinsic_instr,
        data: *mut ::std::os::raw::c_void,
    ) -> bool,
>;
unsafe extern "C" {
    pub fn nir_opt_combine_barriers(
        shader: *mut nir_shader,
        combine_cb: nir_combine_barrier_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_barrier_modes(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_minimize_call_live_states(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_combine_stores(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_copy_prop_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_copy_prop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_copy_prop_vars(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_cse(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dce(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dead_cf(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_dead_write_vars(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_deref_impl(impl_: *mut nir_function_impl) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_deref(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_find_array_copies(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_def_is_frag_coord_z(def: *mut nir_def) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_fragdepth(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_gcm(shader: *mut nir_shader, value_number: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_generate_bfi(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_idiv_const(
        shader: *mut nir_shader,
        min_bit_size: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_mqsad(shader: *mut nir_shader) -> bool;
}
impl nir_opt_if_options {
    pub const nir_opt_if_optimize_phi_true_false: nir_opt_if_options = nir_opt_if_options(1);
}
impl nir_opt_if_options {
    pub const nir_opt_if_avoid_64bit_phis: nir_opt_if_options = nir_opt_if_options(2);
}
impl ::std::ops::BitOr<nir_opt_if_options> for nir_opt_if_options {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        nir_opt_if_options(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for nir_opt_if_options {
    #[inline]
    fn bitor_assign(&mut self, rhs: nir_opt_if_options) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<nir_opt_if_options> for nir_opt_if_options {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        nir_opt_if_options(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for nir_opt_if_options {
    #[inline]
    fn bitand_assign(&mut self, rhs: nir_opt_if_options) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_if_options(pub ::std::os::raw::c_uint);
unsafe extern "C" {
    pub fn nir_opt_if(shader: *mut nir_shader, options: nir_opt_if_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_intrinsics(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_large_constants(
        shader: *mut nir_shader,
        size_align: glsl_type_size_align_func,
        threshold: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_licm(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_loop(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_loop_unroll(shader: *mut nir_shader) -> bool;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_move_options {
    nir_move_const_undef = 1,
    nir_move_load_ubo = 2,
    nir_move_load_input = 4,
    nir_move_comparisons = 8,
    nir_move_copies = 16,
    nir_move_load_ssbo = 32,
    nir_move_load_uniform = 64,
    nir_move_alu = 128,
}
unsafe extern "C" {
    pub fn nir_can_move_instr(instr: *mut nir_instr, options: nir_move_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_sink(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_move(shader: *mut nir_shader, options: nir_move_options) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_offsets_options {
    #[doc = " nir_load_uniform max base offset"]
    pub uniform_max: u32,
    #[doc = " nir_load_ubo_vec4 max base offset"]
    pub ubo_vec4_max: u32,
    #[doc = " nir_var_mem_shared max base offset"]
    pub shared_max: u32,
    #[doc = " nir_var_mem_shared atomic max base offset"]
    pub shared_atomic_max: u32,
    #[doc = " nir_load/store_buffer_amd max base offset"]
    pub buffer_max: u32,
    #[doc = " Callback to get the max base offset for instructions for which the\n corresponding value above is zero."]
    pub max_offset_cb: ::std::option::Option<
        unsafe extern "C" fn(
            intr: *mut nir_intrinsic_instr,
            data: *const ::std::os::raw::c_void,
        ) -> u32,
    >,
    #[doc = " Data to pass to max_offset_cb."]
    pub max_offset_data: *const ::std::os::raw::c_void,
    #[doc = " Allow the offset calculation to wrap. If false, constant additions that\n might wrap will not be folded into the offset."]
    pub allow_offset_wrap: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_offsets_options"][::std::mem::size_of::<nir_opt_offsets_options>() - 32usize];
    ["Alignment of nir_opt_offsets_options"]
        [::std::mem::align_of::<nir_opt_offsets_options>() - 4usize];
    ["Offset of field: nir_opt_offsets_options::uniform_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, uniform_max) - 0usize];
    ["Offset of field: nir_opt_offsets_options::ubo_vec4_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, ubo_vec4_max) - 4usize];
    ["Offset of field: nir_opt_offsets_options::shared_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, shared_max) - 8usize];
    ["Offset of field: nir_opt_offsets_options::shared_atomic_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, shared_atomic_max) - 12usize];
    ["Offset of field: nir_opt_offsets_options::buffer_max"]
        [::std::mem::offset_of!(nir_opt_offsets_options, buffer_max) - 16usize];
    ["Offset of field: nir_opt_offsets_options::max_offset_cb"]
        [::std::mem::offset_of!(nir_opt_offsets_options, max_offset_cb) - 20usize];
    ["Offset of field: nir_opt_offsets_options::max_offset_data"]
        [::std::mem::offset_of!(nir_opt_offsets_options, max_offset_data) - 24usize];
    ["Offset of field: nir_opt_offsets_options::allow_offset_wrap"]
        [::std::mem::offset_of!(nir_opt_offsets_options, allow_offset_wrap) - 28usize];
};
impl Default for nir_opt_offsets_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_offsets(
        shader: *mut nir_shader,
        options: *const nir_opt_offsets_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_peephole_select(
        shader: *mut nir_shader,
        limit: ::std::os::raw::c_uint,
        indirect_load_ok: bool,
        expensive_alu_ok: bool,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_reassociate_bfi(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_rematerialize_compares(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_remove_phis(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_single_src_phis_block(block: *mut nir_block) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_phi_precision(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_shrink_stores(shader: *mut nir_shader, shrink_image_store: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_shrink_vectors(shader: *mut nir_shader, shrink_start: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_undef(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_undef_to_zero(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_uniform_atomics(shader: *mut nir_shader, fs_atomics_predicated: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_uniform_subgroup(
        shader: *mut nir_shader,
        arg1: *const nir_lower_subgroups_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_vectorize(
        shader: *mut nir_shader,
        filter: nir_vectorize_cb,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_vectorize_io(shader: *mut nir_shader, modes: nir_variable_mode) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_conditional_discard(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_move_discards_to_top(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_ray_queries(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_opt_ray_query_ranges(shader: *mut nir_shader) -> bool;
}
unsafe extern "C" {
    pub fn nir_sweep(shader: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_intrinsic_from_system_value(val: gl_system_value) -> nir_intrinsic_op;
}
unsafe extern "C" {
    pub fn nir_system_value_from_intrinsic(intrin: nir_intrinsic_op) -> gl_system_value;
}
unsafe extern "C" {
    #[link_name = "nir_variable_is_in_ubo__extern"]
    pub fn nir_variable_is_in_ubo(var: *const nir_variable) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_variable_is_in_ssbo__extern"]
    pub fn nir_variable_is_in_ssbo(var: *const nir_variable) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_variable_is_in_block__extern"]
    pub fn nir_variable_is_in_block(var: *const nir_variable) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_variable_count_slots__extern"]
    pub fn nir_variable_count_slots(
        var: *const nir_variable,
        type_: *const glsl_type,
    ) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_deref_count_slots__extern"]
    pub fn nir_deref_count_slots(
        deref: *mut nir_deref_instr,
        var: *mut nir_variable,
    ) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_unsigned_upper_bound_config {
    pub min_subgroup_size: ::std::os::raw::c_uint,
    pub max_subgroup_size: ::std::os::raw::c_uint,
    pub max_workgroup_invocations: ::std::os::raw::c_uint,
    pub max_workgroup_count: [::std::os::raw::c_uint; 3usize],
    pub max_workgroup_size: [::std::os::raw::c_uint; 3usize],
    pub vertex_attrib_max: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_unsigned_upper_bound_config"]
        [::std::mem::size_of::<nir_unsigned_upper_bound_config>() - 164usize];
    ["Alignment of nir_unsigned_upper_bound_config"]
        [::std::mem::align_of::<nir_unsigned_upper_bound_config>() - 4usize];
    ["Offset of field: nir_unsigned_upper_bound_config::min_subgroup_size"]
        [::std::mem::offset_of!(nir_unsigned_upper_bound_config, min_subgroup_size) - 0usize];
    ["Offset of field: nir_unsigned_upper_bound_config::max_subgroup_size"]
        [::std::mem::offset_of!(nir_unsigned_upper_bound_config, max_subgroup_size) - 4usize];
    ["Offset of field: nir_unsigned_upper_bound_config::max_workgroup_invocations"][::std::mem::offset_of!(
        nir_unsigned_upper_bound_config,
        max_workgroup_invocations
    ) - 8usize];
    ["Offset of field: nir_unsigned_upper_bound_config::max_workgroup_count"]
        [::std::mem::offset_of!(nir_unsigned_upper_bound_config, max_workgroup_count) - 12usize];
    ["Offset of field: nir_unsigned_upper_bound_config::max_workgroup_size"]
        [::std::mem::offset_of!(nir_unsigned_upper_bound_config, max_workgroup_size) - 24usize];
    ["Offset of field: nir_unsigned_upper_bound_config::vertex_attrib_max"]
        [::std::mem::offset_of!(nir_unsigned_upper_bound_config, vertex_attrib_max) - 36usize];
};
unsafe extern "C" {
    pub fn nir_unsigned_upper_bound(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        scalar: nir_scalar,
        config: *const nir_unsigned_upper_bound_config,
    ) -> u32;
}
unsafe extern "C" {
    pub fn nir_addition_might_overflow(
        shader: *mut nir_shader,
        range_ht: *mut hash_table,
        ssa: nir_scalar,
        const_val: ::std::os::raw::c_uint,
        config: *const nir_unsigned_upper_bound_config,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct nir_opt_preamble_options {
    pub drawid_uniform: bool,
    pub subgroup_size_uniform: bool,
    pub load_workgroup_size_allowed: bool,
    pub def_size: ::std::option::Option<
        unsafe extern "C" fn(
            def: *mut nir_def,
            size: *mut ::std::os::raw::c_uint,
            align: *mut ::std::os::raw::c_uint,
        ),
    >,
    pub preamble_storage_size: ::std::os::raw::c_uint,
    pub instr_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(
            instr: *mut nir_instr,
            data: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_float,
    >,
    pub rewrite_cost_cb: ::std::option::Option<
        unsafe extern "C" fn(
            def: *mut nir_def,
            data: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_float,
    >,
    pub avoid_instr_cb: nir_instr_filter_cb,
    pub cb_data: *const ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_opt_preamble_options"]
        [::std::mem::size_of::<nir_opt_preamble_options>() - 28usize];
    ["Alignment of nir_opt_preamble_options"]
        [::std::mem::align_of::<nir_opt_preamble_options>() - 4usize];
    ["Offset of field: nir_opt_preamble_options::drawid_uniform"]
        [::std::mem::offset_of!(nir_opt_preamble_options, drawid_uniform) - 0usize];
    ["Offset of field: nir_opt_preamble_options::subgroup_size_uniform"]
        [::std::mem::offset_of!(nir_opt_preamble_options, subgroup_size_uniform) - 1usize];
    ["Offset of field: nir_opt_preamble_options::load_workgroup_size_allowed"]
        [::std::mem::offset_of!(nir_opt_preamble_options, load_workgroup_size_allowed) - 2usize];
    ["Offset of field: nir_opt_preamble_options::def_size"]
        [::std::mem::offset_of!(nir_opt_preamble_options, def_size) - 4usize];
    ["Offset of field: nir_opt_preamble_options::preamble_storage_size"]
        [::std::mem::offset_of!(nir_opt_preamble_options, preamble_storage_size) - 8usize];
    ["Offset of field: nir_opt_preamble_options::instr_cost_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, instr_cost_cb) - 12usize];
    ["Offset of field: nir_opt_preamble_options::rewrite_cost_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, rewrite_cost_cb) - 16usize];
    ["Offset of field: nir_opt_preamble_options::avoid_instr_cb"]
        [::std::mem::offset_of!(nir_opt_preamble_options, avoid_instr_cb) - 20usize];
    ["Offset of field: nir_opt_preamble_options::cb_data"]
        [::std::mem::offset_of!(nir_opt_preamble_options, cb_data) - 24usize];
};
impl Default for nir_opt_preamble_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn nir_opt_preamble(
        shader: *mut nir_shader,
        options: *const nir_opt_preamble_options,
        size: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_shader_get_preamble(shader: *mut nir_shader) -> *mut nir_function_impl;
}
unsafe extern "C" {
    pub fn nir_lower_point_smooth(shader: *mut nir_shader, set_barycentrics: bool) -> bool;
}
unsafe extern "C" {
    pub fn nir_lower_poly_line_smooth(
        shader: *mut nir_shader,
        num_smooth_aa_sample: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_mod_analysis(
        val: nir_scalar,
        val_type: nir_alu_type,
        div: ::std::os::raw::c_uint,
        mod_: *mut ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_remove_tex_shadow(
        shader: *mut nir_shader,
        textures_bitmask: ::std::os::raw::c_uint,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_trivialize_registers(s: *mut nir_shader);
}
unsafe extern "C" {
    pub fn nir_static_workgroup_size(s: *const nir_shader) -> ::std::os::raw::c_uint;
}
unsafe extern "C" {
    #[link_name = "nir_reg_get_decl__extern"]
    pub fn nir_reg_get_decl(reg: *mut nir_def) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    #[link_name = "nir_next_decl_reg__extern"]
    pub fn nir_next_decl_reg(
        prev: *mut nir_intrinsic_instr,
        impl_: *mut nir_function_impl,
    ) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    #[link_name = "nir_after_reg_decls__extern"]
    pub fn nir_after_reg_decls(impl_: *mut nir_function_impl) -> nir_cursor;
}
unsafe extern "C" {
    #[link_name = "nir_is_load_reg__extern"]
    pub fn nir_is_load_reg(intr: *mut nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_is_store_reg__extern"]
    pub fn nir_is_store_reg(intr: *mut nir_intrinsic_instr) -> bool;
}
unsafe extern "C" {
    #[link_name = "nir_load_reg_for_def__extern"]
    pub fn nir_load_reg_for_def(def: *const nir_def) -> *mut nir_intrinsic_instr;
}
unsafe extern "C" {
    #[link_name = "nir_store_reg_for_def__extern"]
    pub fn nir_store_reg_for_def(def: *const nir_def) -> *mut nir_intrinsic_instr;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct nir_use_dominance_state {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn nir_calc_use_dominance_impl(
        impl_: *mut nir_function_impl,
        post_dominance: bool,
    ) -> *mut nir_use_dominance_state;
}
unsafe extern "C" {
    pub fn nir_get_immediate_use_dominator(
        state: *mut nir_use_dominance_state,
        instr: *mut nir_instr,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    pub fn nir_use_dominance_lca(
        state: *mut nir_use_dominance_state,
        i1: *mut nir_instr,
        i2: *mut nir_instr,
    ) -> *mut nir_instr;
}
unsafe extern "C" {
    pub fn nir_instr_dominates_use(
        state: *mut nir_use_dominance_state,
        parent: *mut nir_instr,
        child: *mut nir_instr,
    ) -> bool;
}
unsafe extern "C" {
    pub fn nir_print_use_dominators(
        state: *mut nir_use_dominance_state,
        instructions: *mut *mut nir_instr,
        num_instructions: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    #[link_name = "nir_foreach_def__extern"]
    pub fn nir_foreach_def(
        instr: *mut nir_instr,
        cb: nir_foreach_def_cb,
        state: *mut ::std::os::raw::c_void,
    ) -> bool;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct disk_cache {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn nir_can_find_libclc(ptr_bit_size: ::std::os::raw::c_uint) -> bool;
}
unsafe extern "C" {
    pub fn nir_load_libclc_shader(
        ptr_bit_size: ::std::os::raw::c_uint,
        disk_cache: *mut disk_cache,
        spirv_options: *const spirv_to_nir_options,
        nir_options: *const nir_shader_compiler_options,
        optimize: bool,
    ) -> *mut nir_shader;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_named_value {
    pub name: *const ::std::os::raw::c_char,
    pub value: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_named_value"][::std::mem::size_of::<clc_named_value>() - 8usize];
    ["Alignment of clc_named_value"][::std::mem::align_of::<clc_named_value>() - 4usize];
    ["Offset of field: clc_named_value::name"]
        [::std::mem::offset_of!(clc_named_value, name) - 0usize];
    ["Offset of field: clc_named_value::value"]
        [::std::mem::offset_of!(clc_named_value, value) - 4usize];
};
impl Default for clc_named_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum clc_spirv_version {
    CLC_SPIRV_VERSION_MAX = 0,
    CLC_SPIRV_VERSION_1_0 = 1,
    CLC_SPIRV_VERSION_1_1 = 2,
    CLC_SPIRV_VERSION_1_2 = 3,
    CLC_SPIRV_VERSION_1_3 = 4,
    CLC_SPIRV_VERSION_1_4 = 5,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_optional_features {
    pub fp16: bool,
    pub fp64: bool,
    pub int64: bool,
    pub images: bool,
    pub images_depth: bool,
    pub images_gl_depth: bool,
    pub images_gl_msaa: bool,
    pub images_mipmap: bool,
    pub images_mipmap_writes: bool,
    pub images_read_write: bool,
    pub images_write_3d: bool,
    pub integer_dot_product: bool,
    pub intel_subgroups: bool,
    pub subgroups: bool,
    pub subgroups_ifp: bool,
    pub subgroups_shuffle: bool,
    pub subgroups_shuffle_relative: bool,
    pub subgroups_ballot: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_optional_features"][::std::mem::size_of::<clc_optional_features>() - 18usize];
    ["Alignment of clc_optional_features"]
        [::std::mem::align_of::<clc_optional_features>() - 1usize];
    ["Offset of field: clc_optional_features::fp16"]
        [::std::mem::offset_of!(clc_optional_features, fp16) - 0usize];
    ["Offset of field: clc_optional_features::fp64"]
        [::std::mem::offset_of!(clc_optional_features, fp64) - 1usize];
    ["Offset of field: clc_optional_features::int64"]
        [::std::mem::offset_of!(clc_optional_features, int64) - 2usize];
    ["Offset of field: clc_optional_features::images"]
        [::std::mem::offset_of!(clc_optional_features, images) - 3usize];
    ["Offset of field: clc_optional_features::images_depth"]
        [::std::mem::offset_of!(clc_optional_features, images_depth) - 4usize];
    ["Offset of field: clc_optional_features::images_gl_depth"]
        [::std::mem::offset_of!(clc_optional_features, images_gl_depth) - 5usize];
    ["Offset of field: clc_optional_features::images_gl_msaa"]
        [::std::mem::offset_of!(clc_optional_features, images_gl_msaa) - 6usize];
    ["Offset of field: clc_optional_features::images_mipmap"]
        [::std::mem::offset_of!(clc_optional_features, images_mipmap) - 7usize];
    ["Offset of field: clc_optional_features::images_mipmap_writes"]
        [::std::mem::offset_of!(clc_optional_features, images_mipmap_writes) - 8usize];
    ["Offset of field: clc_optional_features::images_read_write"]
        [::std::mem::offset_of!(clc_optional_features, images_read_write) - 9usize];
    ["Offset of field: clc_optional_features::images_write_3d"]
        [::std::mem::offset_of!(clc_optional_features, images_write_3d) - 10usize];
    ["Offset of field: clc_optional_features::integer_dot_product"]
        [::std::mem::offset_of!(clc_optional_features, integer_dot_product) - 11usize];
    ["Offset of field: clc_optional_features::intel_subgroups"]
        [::std::mem::offset_of!(clc_optional_features, intel_subgroups) - 12usize];
    ["Offset of field: clc_optional_features::subgroups"]
        [::std::mem::offset_of!(clc_optional_features, subgroups) - 13usize];
    ["Offset of field: clc_optional_features::subgroups_ifp"]
        [::std::mem::offset_of!(clc_optional_features, subgroups_ifp) - 14usize];
    ["Offset of field: clc_optional_features::subgroups_shuffle"]
        [::std::mem::offset_of!(clc_optional_features, subgroups_shuffle) - 15usize];
    ["Offset of field: clc_optional_features::subgroups_shuffle_relative"]
        [::std::mem::offset_of!(clc_optional_features, subgroups_shuffle_relative) - 16usize];
    ["Offset of field: clc_optional_features::subgroups_ballot"]
        [::std::mem::offset_of!(clc_optional_features, subgroups_ballot) - 17usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_compile_args {
    pub headers: *const clc_named_value,
    pub num_headers: ::std::os::raw::c_uint,
    pub source: clc_named_value,
    pub args: *const *const ::std::os::raw::c_char,
    pub num_args: ::std::os::raw::c_uint,
    pub spirv_version: clc_spirv_version,
    pub features: clc_optional_features,
    pub use_llvm_spirv_target: bool,
    pub allowed_spirv_extensions: *const *const ::std::os::raw::c_char,
    pub address_bits: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_compile_args"][::std::mem::size_of::<clc_compile_args>() - 56usize];
    ["Alignment of clc_compile_args"][::std::mem::align_of::<clc_compile_args>() - 4usize];
    ["Offset of field: clc_compile_args::headers"]
        [::std::mem::offset_of!(clc_compile_args, headers) - 0usize];
    ["Offset of field: clc_compile_args::num_headers"]
        [::std::mem::offset_of!(clc_compile_args, num_headers) - 4usize];
    ["Offset of field: clc_compile_args::source"]
        [::std::mem::offset_of!(clc_compile_args, source) - 8usize];
    ["Offset of field: clc_compile_args::args"]
        [::std::mem::offset_of!(clc_compile_args, args) - 16usize];
    ["Offset of field: clc_compile_args::num_args"]
        [::std::mem::offset_of!(clc_compile_args, num_args) - 20usize];
    ["Offset of field: clc_compile_args::spirv_version"]
        [::std::mem::offset_of!(clc_compile_args, spirv_version) - 24usize];
    ["Offset of field: clc_compile_args::features"]
        [::std::mem::offset_of!(clc_compile_args, features) - 28usize];
    ["Offset of field: clc_compile_args::use_llvm_spirv_target"]
        [::std::mem::offset_of!(clc_compile_args, use_llvm_spirv_target) - 46usize];
    ["Offset of field: clc_compile_args::allowed_spirv_extensions"]
        [::std::mem::offset_of!(clc_compile_args, allowed_spirv_extensions) - 48usize];
    ["Offset of field: clc_compile_args::address_bits"]
        [::std::mem::offset_of!(clc_compile_args, address_bits) - 52usize];
};
impl Default for clc_compile_args {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_validator_options {
    pub limit_max_function_arg: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_validator_options"][::std::mem::size_of::<clc_validator_options>() - 4usize];
    ["Alignment of clc_validator_options"]
        [::std::mem::align_of::<clc_validator_options>() - 4usize];
    ["Offset of field: clc_validator_options::limit_max_function_arg"]
        [::std::mem::offset_of!(clc_validator_options, limit_max_function_arg) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_binary {
    pub data: *mut ::std::os::raw::c_void,
    pub size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_binary"][::std::mem::size_of::<clc_binary>() - 8usize];
    ["Alignment of clc_binary"][::std::mem::align_of::<clc_binary>() - 4usize];
    ["Offset of field: clc_binary::data"][::std::mem::offset_of!(clc_binary, data) - 0usize];
    ["Offset of field: clc_binary::size"][::std::mem::offset_of!(clc_binary, size) - 4usize];
};
impl Default for clc_binary {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_linker_args {
    pub in_objs: *const *const clc_binary,
    pub num_in_objs: ::std::os::raw::c_uint,
    pub create_library: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_linker_args"][::std::mem::size_of::<clc_linker_args>() - 12usize];
    ["Alignment of clc_linker_args"][::std::mem::align_of::<clc_linker_args>() - 4usize];
    ["Offset of field: clc_linker_args::in_objs"]
        [::std::mem::offset_of!(clc_linker_args, in_objs) - 0usize];
    ["Offset of field: clc_linker_args::num_in_objs"]
        [::std::mem::offset_of!(clc_linker_args, num_in_objs) - 4usize];
    ["Offset of field: clc_linker_args::create_library"]
        [::std::mem::offset_of!(clc_linker_args, create_library) - 8usize];
};
impl Default for clc_linker_args {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type clc_msg_callback = ::std::option::Option<
    unsafe extern "C" fn(priv_: *mut ::std::os::raw::c_void, msg: *const ::std::os::raw::c_char),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_logger {
    pub priv_: *mut ::std::os::raw::c_void,
    pub error: clc_msg_callback,
    pub warning: clc_msg_callback,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_logger"][::std::mem::size_of::<clc_logger>() - 12usize];
    ["Alignment of clc_logger"][::std::mem::align_of::<clc_logger>() - 4usize];
    ["Offset of field: clc_logger::priv_"][::std::mem::offset_of!(clc_logger, priv_) - 0usize];
    ["Offset of field: clc_logger::error"][::std::mem::offset_of!(clc_logger, error) - 4usize];
    ["Offset of field: clc_logger::warning"][::std::mem::offset_of!(clc_logger, warning) - 8usize];
};
impl Default for clc_logger {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl clc_kernel_arg_type_qualifier {
    pub const CLC_KERNEL_ARG_TYPE_CONST: clc_kernel_arg_type_qualifier =
        clc_kernel_arg_type_qualifier(1);
}
impl clc_kernel_arg_type_qualifier {
    pub const CLC_KERNEL_ARG_TYPE_RESTRICT: clc_kernel_arg_type_qualifier =
        clc_kernel_arg_type_qualifier(2);
}
impl clc_kernel_arg_type_qualifier {
    pub const CLC_KERNEL_ARG_TYPE_VOLATILE: clc_kernel_arg_type_qualifier =
        clc_kernel_arg_type_qualifier(4);
}
impl ::std::ops::BitOr<clc_kernel_arg_type_qualifier> for clc_kernel_arg_type_qualifier {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        clc_kernel_arg_type_qualifier(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for clc_kernel_arg_type_qualifier {
    #[inline]
    fn bitor_assign(&mut self, rhs: clc_kernel_arg_type_qualifier) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<clc_kernel_arg_type_qualifier> for clc_kernel_arg_type_qualifier {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        clc_kernel_arg_type_qualifier(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for clc_kernel_arg_type_qualifier {
    #[inline]
    fn bitand_assign(&mut self, rhs: clc_kernel_arg_type_qualifier) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_kernel_arg_type_qualifier(pub ::std::os::raw::c_uint);
impl clc_kernel_arg_access_qualifier {
    pub const CLC_KERNEL_ARG_ACCESS_READ: clc_kernel_arg_access_qualifier =
        clc_kernel_arg_access_qualifier(1);
}
impl clc_kernel_arg_access_qualifier {
    pub const CLC_KERNEL_ARG_ACCESS_WRITE: clc_kernel_arg_access_qualifier =
        clc_kernel_arg_access_qualifier(2);
}
impl ::std::ops::BitOr<clc_kernel_arg_access_qualifier> for clc_kernel_arg_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        clc_kernel_arg_access_qualifier(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for clc_kernel_arg_access_qualifier {
    #[inline]
    fn bitor_assign(&mut self, rhs: clc_kernel_arg_access_qualifier) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<clc_kernel_arg_access_qualifier> for clc_kernel_arg_access_qualifier {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        clc_kernel_arg_access_qualifier(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for clc_kernel_arg_access_qualifier {
    #[inline]
    fn bitand_assign(&mut self, rhs: clc_kernel_arg_access_qualifier) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_kernel_arg_access_qualifier(pub ::std::os::raw::c_uint);
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum clc_kernel_arg_address_qualifier {
    CLC_KERNEL_ARG_ADDRESS_PRIVATE = 0,
    CLC_KERNEL_ARG_ADDRESS_CONSTANT = 1,
    CLC_KERNEL_ARG_ADDRESS_LOCAL = 2,
    CLC_KERNEL_ARG_ADDRESS_GLOBAL = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_kernel_arg {
    pub name: *const ::std::os::raw::c_char,
    pub type_name: *const ::std::os::raw::c_char,
    pub type_qualifier: ::std::os::raw::c_uint,
    pub access_qualifier: ::std::os::raw::c_uint,
    pub address_qualifier: clc_kernel_arg_address_qualifier,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_kernel_arg"][::std::mem::size_of::<clc_kernel_arg>() - 20usize];
    ["Alignment of clc_kernel_arg"][::std::mem::align_of::<clc_kernel_arg>() - 4usize];
    ["Offset of field: clc_kernel_arg::name"]
        [::std::mem::offset_of!(clc_kernel_arg, name) - 0usize];
    ["Offset of field: clc_kernel_arg::type_name"]
        [::std::mem::offset_of!(clc_kernel_arg, type_name) - 4usize];
    ["Offset of field: clc_kernel_arg::type_qualifier"]
        [::std::mem::offset_of!(clc_kernel_arg, type_qualifier) - 8usize];
    ["Offset of field: clc_kernel_arg::access_qualifier"]
        [::std::mem::offset_of!(clc_kernel_arg, access_qualifier) - 12usize];
    ["Offset of field: clc_kernel_arg::address_qualifier"]
        [::std::mem::offset_of!(clc_kernel_arg, address_qualifier) - 16usize];
};
impl Default for clc_kernel_arg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum clc_vec_hint_type {
    CLC_VEC_HINT_TYPE_CHAR = 0,
    CLC_VEC_HINT_TYPE_SHORT = 1,
    CLC_VEC_HINT_TYPE_INT = 2,
    CLC_VEC_HINT_TYPE_LONG = 3,
    CLC_VEC_HINT_TYPE_HALF = 4,
    CLC_VEC_HINT_TYPE_FLOAT = 5,
    CLC_VEC_HINT_TYPE_DOUBLE = 6,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_kernel_info {
    pub name: *const ::std::os::raw::c_char,
    pub num_args: usize,
    pub args: *const clc_kernel_arg,
    pub vec_hint_size: ::std::os::raw::c_uint,
    pub vec_hint_type: clc_vec_hint_type,
    pub local_size: [::std::os::raw::c_uint; 3usize],
    pub local_size_hint: [::std::os::raw::c_uint; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_kernel_info"][::std::mem::size_of::<clc_kernel_info>() - 44usize];
    ["Alignment of clc_kernel_info"][::std::mem::align_of::<clc_kernel_info>() - 4usize];
    ["Offset of field: clc_kernel_info::name"]
        [::std::mem::offset_of!(clc_kernel_info, name) - 0usize];
    ["Offset of field: clc_kernel_info::num_args"]
        [::std::mem::offset_of!(clc_kernel_info, num_args) - 4usize];
    ["Offset of field: clc_kernel_info::args"]
        [::std::mem::offset_of!(clc_kernel_info, args) - 8usize];
    ["Offset of field: clc_kernel_info::vec_hint_size"]
        [::std::mem::offset_of!(clc_kernel_info, vec_hint_size) - 12usize];
    ["Offset of field: clc_kernel_info::vec_hint_type"]
        [::std::mem::offset_of!(clc_kernel_info, vec_hint_type) - 16usize];
    ["Offset of field: clc_kernel_info::local_size"]
        [::std::mem::offset_of!(clc_kernel_info, local_size) - 20usize];
    ["Offset of field: clc_kernel_info::local_size_hint"]
        [::std::mem::offset_of!(clc_kernel_info, local_size_hint) - 32usize];
};
impl Default for clc_kernel_info {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum clc_spec_constant_type {
    CLC_SPEC_CONSTANT_UNKNOWN = 0,
    CLC_SPEC_CONSTANT_BOOL = 1,
    CLC_SPEC_CONSTANT_FLOAT = 2,
    CLC_SPEC_CONSTANT_DOUBLE = 3,
    CLC_SPEC_CONSTANT_INT8 = 4,
    CLC_SPEC_CONSTANT_UINT8 = 5,
    CLC_SPEC_CONSTANT_INT16 = 6,
    CLC_SPEC_CONSTANT_UINT16 = 7,
    CLC_SPEC_CONSTANT_INT32 = 8,
    CLC_SPEC_CONSTANT_UINT32 = 9,
    CLC_SPEC_CONSTANT_INT64 = 10,
    CLC_SPEC_CONSTANT_UINT64 = 11,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_parsed_spec_constant {
    pub id: u32,
    pub type_: clc_spec_constant_type,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_parsed_spec_constant"]
        [::std::mem::size_of::<clc_parsed_spec_constant>() - 8usize];
    ["Alignment of clc_parsed_spec_constant"]
        [::std::mem::align_of::<clc_parsed_spec_constant>() - 4usize];
    ["Offset of field: clc_parsed_spec_constant::id"]
        [::std::mem::offset_of!(clc_parsed_spec_constant, id) - 0usize];
    ["Offset of field: clc_parsed_spec_constant::type_"]
        [::std::mem::offset_of!(clc_parsed_spec_constant, type_) - 4usize];
};
impl Default for clc_parsed_spec_constant {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_parsed_spirv {
    pub kernels: *const clc_kernel_info,
    pub num_kernels: ::std::os::raw::c_uint,
    pub spec_constants: *const clc_parsed_spec_constant,
    pub num_spec_constants: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_parsed_spirv"][::std::mem::size_of::<clc_parsed_spirv>() - 16usize];
    ["Alignment of clc_parsed_spirv"][::std::mem::align_of::<clc_parsed_spirv>() - 4usize];
    ["Offset of field: clc_parsed_spirv::kernels"]
        [::std::mem::offset_of!(clc_parsed_spirv, kernels) - 0usize];
    ["Offset of field: clc_parsed_spirv::num_kernels"]
        [::std::mem::offset_of!(clc_parsed_spirv, num_kernels) - 4usize];
    ["Offset of field: clc_parsed_spirv::spec_constants"]
        [::std::mem::offset_of!(clc_parsed_spirv, spec_constants) - 8usize];
    ["Offset of field: clc_parsed_spirv::num_spec_constants"]
        [::std::mem::offset_of!(clc_parsed_spirv, num_spec_constants) - 12usize];
};
impl Default for clc_parsed_spirv {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct clc_libclc {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_libclc_options {
    pub optimize: ::std::os::raw::c_uint,
    pub nir_options: *const nir_shader_compiler_options,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_libclc_options"][::std::mem::size_of::<clc_libclc_options>() - 8usize];
    ["Alignment of clc_libclc_options"][::std::mem::align_of::<clc_libclc_options>() - 4usize];
    ["Offset of field: clc_libclc_options::optimize"]
        [::std::mem::offset_of!(clc_libclc_options, optimize) - 0usize];
    ["Offset of field: clc_libclc_options::nir_options"]
        [::std::mem::offset_of!(clc_libclc_options, nir_options) - 4usize];
};
impl Default for clc_libclc_options {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn clc_libclc_new(
        logger: *const clc_logger,
        options: *const clc_libclc_options,
    ) -> *mut clc_libclc;
}
unsafe extern "C" {
    pub fn clc_free_libclc(lib: *mut clc_libclc);
}
unsafe extern "C" {
    pub fn clc_libclc_get_clc_shader(lib: *mut clc_libclc) -> *const nir_shader;
}
unsafe extern "C" {
    pub fn clc_libclc_serialize(
        lib: *mut clc_libclc,
        serialized: *mut *mut ::std::os::raw::c_void,
        size: *mut usize,
    );
}
unsafe extern "C" {
    pub fn clc_libclc_free_serialized(serialized: *mut ::std::os::raw::c_void);
}
unsafe extern "C" {
    pub fn clc_libclc_deserialize(
        serialized: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut clc_libclc;
}
unsafe extern "C" {
    pub fn clc_compile_c_to_spir(
        args: *const clc_compile_args,
        logger: *const clc_logger,
        out_spir: *mut clc_binary,
        dependencies: *mut set,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_free_spir(spir: *mut clc_binary);
}
unsafe extern "C" {
    pub fn clc_compile_spir_to_spirv(
        in_spir: *const clc_binary,
        logger: *const clc_logger,
        out_spirv: *mut clc_binary,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_free_spirv(spirv: *mut clc_binary);
}
unsafe extern "C" {
    pub fn clc_compile_c_to_spirv(
        args: *const clc_compile_args,
        logger: *const clc_logger,
        out_spirv: *mut clc_binary,
        dependencies: *mut set,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_link_spirv(
        args: *const clc_linker_args,
        logger: *const clc_logger,
        out_spirv: *mut clc_binary,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_parse_spirv(
        in_spirv: *const clc_binary,
        logger: *const clc_logger,
        out_data: *mut clc_parsed_spirv,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_free_parsed_spirv(data: *mut clc_parsed_spirv);
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union clc_spirv_const_value {
    pub b: bool,
    pub f32_: ::std::os::raw::c_float,
    pub f64_: ::std::os::raw::c_double,
    pub i8_: i8,
    pub u8_: u8,
    pub i16_: i16,
    pub u16_: u16,
    pub i32_: i32,
    pub u32_: u32,
    pub i64_: i64,
    pub u64_: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_spirv_const_value"][::std::mem::size_of::<clc_spirv_const_value>() - 8usize];
    ["Alignment of clc_spirv_const_value"]
        [::std::mem::align_of::<clc_spirv_const_value>() - 4usize];
    ["Offset of field: clc_spirv_const_value::b"]
        [::std::mem::offset_of!(clc_spirv_const_value, b) - 0usize];
    ["Offset of field: clc_spirv_const_value::f32_"]
        [::std::mem::offset_of!(clc_spirv_const_value, f32_) - 0usize];
    ["Offset of field: clc_spirv_const_value::f64_"]
        [::std::mem::offset_of!(clc_spirv_const_value, f64_) - 0usize];
    ["Offset of field: clc_spirv_const_value::i8_"]
        [::std::mem::offset_of!(clc_spirv_const_value, i8_) - 0usize];
    ["Offset of field: clc_spirv_const_value::u8_"]
        [::std::mem::offset_of!(clc_spirv_const_value, u8_) - 0usize];
    ["Offset of field: clc_spirv_const_value::i16_"]
        [::std::mem::offset_of!(clc_spirv_const_value, i16_) - 0usize];
    ["Offset of field: clc_spirv_const_value::u16_"]
        [::std::mem::offset_of!(clc_spirv_const_value, u16_) - 0usize];
    ["Offset of field: clc_spirv_const_value::i32_"]
        [::std::mem::offset_of!(clc_spirv_const_value, i32_) - 0usize];
    ["Offset of field: clc_spirv_const_value::u32_"]
        [::std::mem::offset_of!(clc_spirv_const_value, u32_) - 0usize];
    ["Offset of field: clc_spirv_const_value::i64_"]
        [::std::mem::offset_of!(clc_spirv_const_value, i64_) - 0usize];
    ["Offset of field: clc_spirv_const_value::u64_"]
        [::std::mem::offset_of!(clc_spirv_const_value, u64_) - 0usize];
};
impl Default for clc_spirv_const_value {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct clc_spirv_specialization {
    pub id: u32,
    pub value: clc_spirv_const_value,
    pub defined_on_module: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_spirv_specialization"]
        [::std::mem::size_of::<clc_spirv_specialization>() - 16usize];
    ["Alignment of clc_spirv_specialization"]
        [::std::mem::align_of::<clc_spirv_specialization>() - 4usize];
    ["Offset of field: clc_spirv_specialization::id"]
        [::std::mem::offset_of!(clc_spirv_specialization, id) - 0usize];
    ["Offset of field: clc_spirv_specialization::value"]
        [::std::mem::offset_of!(clc_spirv_specialization, value) - 4usize];
    ["Offset of field: clc_spirv_specialization::defined_on_module"]
        [::std::mem::offset_of!(clc_spirv_specialization, defined_on_module) - 12usize];
};
impl Default for clc_spirv_specialization {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct clc_spirv_specialization_consts {
    pub specializations: *const clc_spirv_specialization,
    pub num_specializations: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of clc_spirv_specialization_consts"]
        [::std::mem::size_of::<clc_spirv_specialization_consts>() - 8usize];
    ["Alignment of clc_spirv_specialization_consts"]
        [::std::mem::align_of::<clc_spirv_specialization_consts>() - 4usize];
    ["Offset of field: clc_spirv_specialization_consts::specializations"]
        [::std::mem::offset_of!(clc_spirv_specialization_consts, specializations) - 0usize];
    ["Offset of field: clc_spirv_specialization_consts::num_specializations"]
        [::std::mem::offset_of!(clc_spirv_specialization_consts, num_specializations) - 4usize];
};
impl Default for clc_spirv_specialization_consts {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    pub fn clc_specialize_spirv(
        in_spirv: *const clc_binary,
        parsed_data: *const clc_parsed_spirv,
        consts: *const clc_spirv_specialization_consts,
        out_spirv: *mut clc_binary,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_debug_flags() -> u64;
}
unsafe extern "C" {
    pub fn clc_initialize_llvm();
}
unsafe extern "C" {
    pub fn clc_spirv_get_kernels_info(
        spvbin: *const clc_binary,
        kernels: *mut *const clc_kernel_info,
        num_kernels: *mut ::std::os::raw::c_uint,
        spec_constants: *mut *const clc_parsed_spec_constant,
        num_spec_constants: *mut ::std::os::raw::c_uint,
        logger: *const clc_logger,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_free_kernels_info(
        kernels: *const clc_kernel_info,
        num_kernels: ::std::os::raw::c_uint,
    );
}
unsafe extern "C" {
    pub fn clc_c_to_spir(
        args: *const clc_compile_args,
        logger: *const clc_logger,
        out_spir: *mut clc_binary,
        dependencies: *mut set,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clc_spir_to_spirv(
        in_spir: *const clc_binary,
        logger: *const clc_logger,
        out_spirv: *mut clc_binary,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clc_c_to_spirv(
        args: *const clc_compile_args,
        logger: *const clc_logger,
        out_spirvl: *mut clc_binary,
        dependencies: *mut set,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clc_link_spirv_binaries(
        args: *const clc_linker_args,
        logger: *const clc_logger,
        out_spirv: *mut clc_binary,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clc_validate_spirv(
        spirv: *const clc_binary,
        logger: *const clc_logger,
        options: *const clc_validator_options,
    ) -> bool;
}
unsafe extern "C" {
    pub fn clc_spirv_specialize(
        in_spirv: *const clc_binary,
        parsed_data: *const clc_parsed_spirv,
        consts: *const clc_spirv_specialization_consts,
        out_spirv: *mut clc_binary,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn clc_dump_spirv(spvbin: *const clc_binary, f: *mut FILE);
}
unsafe extern "C" {
    pub fn clc_free_spir_binary(spir: *mut clc_binary);
}
unsafe extern "C" {
    pub fn clc_free_spirv_binary(spvbin: *mut clc_binary);
}
unsafe extern "C" {
    pub fn nir_serialize(blob: *mut blob, nir: *const nir_shader, strip: bool);
}
unsafe extern "C" {
    pub fn nir_deserialize(
        mem_ctx: *mut ::std::os::raw::c_void,
        options: *const nir_shader_compiler_options,
        blob: *mut blob_reader,
    ) -> *mut nir_shader;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct _SHA1_CTX {
    pub state: [u32; 5usize],
    pub count: u64,
    pub buffer: [u8; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _SHA1_CTX"][::std::mem::size_of::<_SHA1_CTX>() - 92usize];
    ["Alignment of _SHA1_CTX"][::std::mem::align_of::<_SHA1_CTX>() - 4usize];
    ["Offset of field: _SHA1_CTX::state"][::std::mem::offset_of!(_SHA1_CTX, state) - 0usize];
    ["Offset of field: _SHA1_CTX::count"][::std::mem::offset_of!(_SHA1_CTX, count) - 20usize];
    ["Offset of field: _SHA1_CTX::buffer"][::std::mem::offset_of!(_SHA1_CTX, buffer) - 28usize];
};
impl Default for _SHA1_CTX {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type SHA1_CTX = _SHA1_CTX;
unsafe extern "C" {
    pub fn SHA1Init(arg1: *mut SHA1_CTX);
}
unsafe extern "C" {
    pub fn SHA1Update(arg1: *mut SHA1_CTX, arg2: *const u8, arg3: usize);
}
unsafe extern "C" {
    pub fn SHA1Final(arg1: *mut [u8; 20usize], arg2: *mut SHA1_CTX);
}
pub type cache_key = [u8; 20usize];
pub type disk_cache_put_cb = ::std::option::Option<
    unsafe extern "C" fn(
        key: *const ::std::os::raw::c_void,
        keySize: ::std::os::raw::c_long,
        value: *const ::std::os::raw::c_void,
        valueSize: ::std::os::raw::c_long,
    ),
>;
pub type disk_cache_get_cb = ::std::option::Option<
    unsafe extern "C" fn(
        key: *const ::std::os::raw::c_void,
        keySize: ::std::os::raw::c_long,
        value: *mut ::std::os::raw::c_void,
        valueSize: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_long,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct cache_item_metadata {
    #[doc = " The cache item type. This could be used to identify a GLSL cache item,\n a certain type of IR (tgsi, nir, etc), or signal that it is the final\n binary form of the shader."]
    pub type_: u32,
    #[doc = " GLSL cache item metadata"]
    pub keys: *mut cache_key,
    pub num_keys: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of cache_item_metadata"][::std::mem::size_of::<cache_item_metadata>() - 12usize];
    ["Alignment of cache_item_metadata"][::std::mem::align_of::<cache_item_metadata>() - 4usize];
    ["Offset of field: cache_item_metadata::type_"]
        [::std::mem::offset_of!(cache_item_metadata, type_) - 0usize];
    ["Offset of field: cache_item_metadata::keys"]
        [::std::mem::offset_of!(cache_item_metadata, keys) - 4usize];
    ["Offset of field: cache_item_metadata::num_keys"]
        [::std::mem::offset_of!(cache_item_metadata, num_keys) - 8usize];
};
impl Default for cache_item_metadata {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
unsafe extern "C" {
    #[link_name = "disk_cache_get_function_timestamp__extern"]
    pub fn disk_cache_get_function_timestamp(
        ptr: *mut ::std::os::raw::c_void,
        timestamp: *mut u32,
    ) -> bool;
}
unsafe extern "C" {
    #[link_name = "disk_cache_get_function_identifier__extern"]
    pub fn disk_cache_get_function_identifier(
        ptr: *mut ::std::os::raw::c_void,
        ctx: *mut _SHA1_CTX,
    ) -> bool;
}
unsafe extern "C" {
    #[doc = " Create a new cache object.\n\n This function creates the handle necessary for all subsequent cache_*\n functions.\n\n This cache provides two distinct operations:\n\n   o Storage and retrieval of arbitrary objects by cryptographic\n     name (or \"key\").  This is provided via disk_cache_put() and\n     disk_cache_get().\n\n   o The ability to store a key alone and check later whether the\n     key was previously stored. This is provided via disk_cache_put_key()\n     and disk_cache_has_key().\n\n The put_key()/has_key() operations are conceptually identical to\n put()/get() with no data, but are provided separately to allow for\n a more efficient implementation.\n\n In all cases, the keys are sequences of 20 bytes. It is anticipated\n that callers will compute appropriate SHA-1 signatures for keys,\n (though nothing in this implementation directly relies on how the\n names are computed). See mesa-sha1.h and _mesa_sha1_compute for\n assistance in computing SHA-1 signatures."]
    pub fn disk_cache_create(
        gpu_name: *const ::std::os::raw::c_char,
        timestamp: *const ::std::os::raw::c_char,
        driver_flags: u64,
    ) -> *mut disk_cache;
}
unsafe extern "C" {
    pub fn disk_cache_create_custom(
        gpu_name: *const ::std::os::raw::c_char,
        driver_id: *const ::std::os::raw::c_char,
        driver_flags: u64,
        cache_dir_name: *const ::std::os::raw::c_char,
        max_size: u32,
    ) -> *mut disk_cache;
}
unsafe extern "C" {
    #[doc = " Destroy a cache object, (freeing all associated resources)."]
    pub fn disk_cache_destroy(cache: *mut disk_cache);
}
unsafe extern "C" {
    pub fn disk_cache_wait_for_idle(cache: *mut disk_cache);
}
unsafe extern "C" {
    #[doc = " Remove the item in the cache under the name \\key."]
    pub fn disk_cache_remove(cache: *mut disk_cache, key: *const cache_key);
}
unsafe extern "C" {
    #[doc = " Store an item in the cache under the name \\key.\n\n The item can be retrieved later with disk_cache_get(), (unless the item has\n been evicted in the interim).\n\n Any call to disk_cache_put() may cause an existing, random item to be\n evicted from the cache."]
    pub fn disk_cache_put(
        cache: *mut disk_cache,
        key: *const cache_key,
        data: *const ::std::os::raw::c_void,
        size: usize,
        cache_item_metadata: *mut cache_item_metadata,
    );
}
unsafe extern "C" {
    #[doc = " Store an item in the cache under the name \\key without copying the data param.\n\n The item can be retrieved later with disk_cache_get(), (unless the item has\n been evicted in the interim).\n\n Any call to disk_cache_put() may cause an existing, random item to be\n evicted from the cache.\n\n @p data will be freed"]
    pub fn disk_cache_put_nocopy(
        cache: *mut disk_cache,
        key: *const cache_key,
        data: *mut ::std::os::raw::c_void,
        size: usize,
        cache_item_metadata: *mut cache_item_metadata,
    );
}
unsafe extern "C" {
    #[doc = " Retrieve an item previously stored in the cache with the name <key>.\n\n The item must have been previously stored with a call to disk_cache_put().\n\n If \\size is non-NULL, then, on successful return, it will be set to the\n size of the object.\n\n \\return A pointer to the stored object if found. NULL if the object\n is not found, or if any error occurs, (memory allocation failure,\n filesystem error, etc.). The returned data is malloc'ed so the\n caller should call free() it when finished."]
    pub fn disk_cache_get(
        cache: *mut disk_cache,
        key: *const cache_key,
        size: *mut usize,
    ) -> *mut ::std::os::raw::c_void;
}
unsafe extern "C" {
    #[doc = " Store the name \\key within the cache, (without any associated data).\n\n Later this key can be checked with disk_cache_has_key(), (unless the key\n has been evicted in the interim).\n\n Any call to disk_cache_put_key() may cause an existing, random key to be\n evicted from the cache."]
    pub fn disk_cache_put_key(cache: *mut disk_cache, key: *const cache_key);
}
unsafe extern "C" {
    #[doc = " Test whether the name \\key was previously recorded in the cache.\n\n Return value: True if disk_cache_put_key() was previously called with\n \\key, (and the key was not evicted in the interim).\n\n Note: disk_cache_has_key() will only return true for keys passed to\n disk_cache_put_key(). Specifically, a call to disk_cache_put() will not cause\n disk_cache_has_key() to return true for the same key."]
    pub fn disk_cache_has_key(cache: *mut disk_cache, key: *const cache_key) -> bool;
}
unsafe extern "C" {
    #[doc = " Compute the name \\key from \\data of given \\size."]
    pub fn disk_cache_compute_key(
        cache: *mut disk_cache,
        data: *const ::std::os::raw::c_void,
        size: usize,
        key: *mut cache_key,
    );
}
unsafe extern "C" {
    pub fn disk_cache_set_callbacks(
        cache: *mut disk_cache,
        put: disk_cache_put_cb,
        get: disk_cache_get_cb,
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct nir_spirv_specialization {
    pub id: u32,
    pub value: nir_const_value,
    pub defined_on_module: bool,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of nir_spirv_specialization"]
        [::std::mem::size_of::<nir_spirv_specialization>() - 16usize];
    ["Alignment of nir_spirv_specialization"]
        [::std::mem::align_of::<nir_spirv_specialization>() - 4usize];
    ["Offset of field: nir_spirv_specialization::id"]
        [::std::mem::offset_of!(nir_spirv_specialization, id) - 0usize];
    ["Offset of field: nir_spirv_specialization::value"]
        [::std::mem::offset_of!(nir_spirv_specialization, value) - 4usize];
    ["Offset of field: nir_spirv_specialization::defined_on_module"]
        [::std::mem::offset_of!(nir_spirv_specialization, defined_on_module) - 12usize];
};
impl Default for nir_spirv_specialization {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(i32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_spirv_debug_level {
    NIR_SPIRV_DEBUG_LEVEL_INVALID = -1,
    NIR_SPIRV_DEBUG_LEVEL_INFO = 0,
    NIR_SPIRV_DEBUG_LEVEL_WARNING = 1,
    NIR_SPIRV_DEBUG_LEVEL_ERROR = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub enum nir_spirv_execution_environment {
    NIR_SPIRV_VULKAN = 0,
    NIR_SPIRV_OPENCL = 1,
    NIR_SPIRV_OPENGL = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialOrd, Ord, PartialEq, Eq)]
pub struct spirv_to_nir_options {
    pub environment: nir_spirv_execution_environment,
    pub view_index_is_input: bool,
    pub create_library: bool,
    pub float_controls_execution_mode: u32,
    pub subgroup_size: gl_subgroup_size,
    pub mediump_16bit_alu: bool,
    pub mediump_16bit_derivatives: bool,
    pub amd_gcn_shader: bool,
    pub amd_shader_ballot: bool,
    pub amd_trinary_minmax: bool,
    pub amd_shader_explicit_vertex_parameter: bool,
    pub printf: bool,
    pub debug_info: bool,
    pub capabilities: *const spirv_capabilities,
    pub ubo_addr_f