use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc6c0::mthd as clc6c0;

// parsed class NVC7C0

pub use clc6c0::SetObject;

pub use clc6c0::NoOperation;

pub use clc6c0::SetNotifyA;

pub use clc6c0::SetNotifyB;

pub use clc6c0::Notify;
pub use clc6c0::NotifyType;

pub use clc6c0::WaitForIdle;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRamPointer {
    const ADDR: u16 = 0x0114;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeInstructionRam {
    pub v: u32,
}

impl Mthd for LoadMmeInstructionRam {
    const ADDR: u16 = 0x0118;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRamPointer {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRamPointer {
    const ADDR: u16 = 0x011c;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadMmeStartAddressRam {
    pub v: u32,
}

impl Mthd for LoadMmeStartAddressRam {
    const ADDR: u16 = 0x0120;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeShadowRamControlMode {
    MethodTrack = 0x00000000,
    MethodTrackWithFilter = 0x00000001,
    MethodPassthrough = 0x00000002,
    MethodReplay = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeShadowRamControl {
    pub mode: SetMmeShadowRamControlMode,
}

impl Mthd for SetMmeShadowRamControl {
    const ADDR: u16 = 0x0124;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

pub use clc6c0::SetGlobalRenderEnableA;

pub use clc6c0::SetGlobalRenderEnableB;

pub use clc6c0::SetGlobalRenderEnableC;
pub use clc6c0::SetGlobalRenderEnableCMode;

pub use clc6c0::SendGoIdle;

pub use clc6c0::PmTrigger;

pub use clc6c0::PmTriggerWfi;

pub use clc6c0::FeAtomicSequenceBegin;

pub use clc6c0::FeAtomicSequenceEnd;

pub use clc6c0::SetInstrumentationMethodHeader;

pub use clc6c0::SetInstrumentationMethodData;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphorePayloadLower {
    pub payload_lower: u32,
}

impl Mthd for SetReportSemaphorePayloadLower {
    const ADDR: u16 = 0x0158;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphorePayloadUpper {
    pub payload_upper: u32,
}

impl Mthd for SetReportSemaphorePayloadUpper {
    const ADDR: u16 = 0x015c;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload_upper;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreAddressLower {
    pub lower: u32,
}

impl Mthd for SetReportSemaphoreAddressLower {
    const ADDR: u16 = 0x0160;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreAddressUpper {
    pub upper: u32,
}

impl Mthd for SetReportSemaphoreAddressUpper {
    const ADDR: u16 = 0x0164;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteStructureSize {
    SemaphoreFourWords = 0x00000000,
    SemaphoreOneWord = 0x00000001,
    SemaphoreTwoWords = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteTrapType {
    TrapNone = 0x00000000,
    TrapUnconditional = 0x00000001,
    TrapConditional = 0x00000002,
    TrapConditionalExt = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReportSemaphoreExecute {
    pub operation: ReportSemaphoreExecuteOperation,
    pub awaken_enable: bool,
    pub structure_size: ReportSemaphoreExecuteStructureSize,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: ReportSemaphoreExecuteReductionOp,
    pub reduction_format: ReportSemaphoreExecuteReductionFormat,
    pub payload_size64: bool,
    pub trap_type: ReportSemaphoreExecuteTrapType,
}

impl Mthd for ReportSemaphoreExecute {
    const ADDR: u16 = 0x0168;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 2;

        assert!((self.structure_size as u32) < (1 << 2));
        val |= (self.structure_size as u32) << 3;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 5;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 6;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 7;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 10;

        assert!((self.payload_size64 as u32) < (1 << 1));
        val |= (self.payload_size64 as u32) << 12;

        assert!((self.trap_type as u32) < (1 << 2));
        val |= (self.trap_type as u32) << 13;

        val
    }
}

pub use clc6c0::LineLengthIn;

pub use clc6c0::LineCount;

pub use clc6c0::OffsetOutUpper;

pub use clc6c0::OffsetOut;

pub use clc6c0::PitchOut;

pub use clc6c0::SetDstBlockSize;
pub use clc6c0::SetDstBlockSizeDepth;
pub use clc6c0::SetDstBlockSizeHeight;
pub use clc6c0::SetDstBlockSizeWidth;

pub use clc6c0::SetDstWidth;

pub use clc6c0::SetDstHeight;

pub use clc6c0::SetDstDepth;

pub use clc6c0::SetDstLayer;

pub use clc6c0::SetDstOriginBytesX;

pub use clc6c0::SetDstOriginSamplesY;

pub use clc6c0::LaunchDma;
pub use clc6c0::LaunchDmaCompletionType;
pub use clc6c0::LaunchDmaDstMemoryLayout;
pub use clc6c0::LaunchDmaInterruptType;
pub use clc6c0::LaunchDmaReductionFormat;
pub use clc6c0::LaunchDmaReductionOp;
pub use clc6c0::LaunchDmaSemaphoreStructSize;

pub use clc6c0::LoadInlineData;

pub use clc6c0::SetI2MSemaphoreA;

pub use clc6c0::SetI2MSemaphoreB;

pub use clc6c0::SetI2MSemaphoreC;

pub use clc6c0::SetSmScgControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeSwitchState {
    pub valid: bool,
    pub save_macro: u32,
    pub restore_macro: u32,
}

impl Mthd for SetMmeSwitchState {
    const ADDR: u16 = 0x01ec;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.save_macro < (1 << 8));
        val |= self.save_macro << 4;

        assert!(self.restore_macro < (1 << 8));
        val |= self.restore_macro << 12;

        val
    }
}

pub use clc6c0::SetI2MSpareNoop00;

pub use clc6c0::SetI2MSpareNoop01;

pub use clc6c0::SetI2MSpareNoop02;

pub use clc6c0::SetI2MSpareNoop03;

pub use clc6c0::SetValidSpanOverflowAreaA;

pub use clc6c0::SetValidSpanOverflowAreaB;

pub use clc6c0::SetValidSpanOverflowAreaC;

pub use clc6c0::PerfmonTransfer;

pub use clc6c0::SetQmdVirtualizationBaseA;

pub use clc6c0::SetQmdVirtualizationBaseB;

pub use clc6c0::InvalidateShaderCaches;

pub use clc6c0::SetReservedSwMethod00;

pub use clc6c0::SetReservedSwMethod01;

pub use clc6c0::SetReservedSwMethod02;

pub use clc6c0::SetReservedSwMethod03;

pub use clc6c0::SetReservedSwMethod04;

pub use clc6c0::SetReservedSwMethod05;

pub use clc6c0::SetReservedSwMethod06;

pub use clc6c0::SetReservedSwMethod07;

pub use clc6c0::InvalidateTextureHeaderCacheNoWfi;
pub use clc6c0::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc6c0::SetCwdRefCounter;

pub use clc6c0::SetReservedSwMethod08;

pub use clc6c0::SetReservedSwMethod09;

pub use clc6c0::SetReservedSwMethod10;

pub use clc6c0::SetReservedSwMethod11;

pub use clc6c0::SetReservedSwMethod12;

pub use clc6c0::SetReservedSwMethod13;

pub use clc6c0::SetReservedSwMethod14;

pub use clc6c0::SetReservedSwMethod15;

pub use clc6c0::SetScgControl;

pub use clc6c0::SetComputeClassVersion;

pub use clc6c0::CheckComputeClassVersion;

pub use clc6c0::SetQmdVersion;

pub use clc6c0::CheckQmdVersion;

pub use clc6c0::InvalidateSkedCaches;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationControl {
    pub constant_buffer_mask: u32,
    pub i2m_addr_enable: bool,
    pub i2m_constant_buffer_enable: bool,
    pub i2m_dependent_enable: bool,
    pub iq2m_addr_enable: bool,
    pub iq2m_constant_buffer_enable: bool,
    pub iq2m_dependent_enable: bool,
    pub send_pcas_enable: bool,
}

impl Mthd for SetQmdVirtualizationControl {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.constant_buffer_mask < (1 << 8));
        val |= self.constant_buffer_mask << 0;

        assert!((self.i2m_addr_enable as u32) < (1 << 1));
        val |= (self.i2m_addr_enable as u32) << 8;

        assert!((self.i2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.i2m_constant_buffer_enable as u32) << 12;

        assert!((self.i2m_dependent_enable as u32) < (1 << 1));
        val |= (self.i2m_dependent_enable as u32) << 9;

        assert!((self.iq2m_addr_enable as u32) < (1 << 1));
        val |= (self.iq2m_addr_enable as u32) << 16;

        assert!((self.iq2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.iq2m_constant_buffer_enable as u32) << 20;

        assert!((self.iq2m_dependent_enable as u32) < (1 << 1));
        val |= (self.iq2m_dependent_enable as u32) << 10;

        assert!((self.send_pcas_enable as u32) < (1 << 1));
        val |= (self.send_pcas_enable as u32) << 24;

        val
    }
}

pub use clc6c0::SetShaderSharedMemoryWindowA;

pub use clc6c0::SetShaderSharedMemoryWindowB;

pub use clc6c0::ScgHysteresisControl;

pub use clc6c0::SetCwdSlotCount;

pub use clc6c0::SendPcasA;

pub use clc6c0::SendPcasB;

pub use clc6c0::SendSignalingPcasB;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SendSignalingPcas2BPcasAction {
    Nop = 0x00000000,
    Invalidate = 0x00000001,
    Schedule = 0x00000002,
    InvalidateCopySchedule = 0x00000003,
    IncrementPut = 0x00000006,
    DecrementDependence = 0x00000007,
    Prefetch = 0x00000008,
    PrefetchSchedule = 0x00000009,
    InvalidatePrefetchCopySchedule = 0x0000000a,
    InvalidatePrefetchCopyForceRequireScheduling = 0x0000000b,
    IncrementDependence = 0x0000000c,
    IncrementCwdRefCounter = 0x0000000d,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendSignalingPcas2B {
    pub pcas_action: SendSignalingPcas2BPcasAction,
    pub select: u32,
    pub offset_minus_one: u32,
}

impl Mthd for SendSignalingPcas2B {
    const ADDR: u16 = 0x02c0;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.pcas_action as u32) < (1 << 4));
        val |= (self.pcas_action as u32) << 0;

        assert!(self.select < (1 << 6));
        val |= self.select << 8;

        assert!(self.offset_minus_one < (1 << 10));
        val |= self.offset_minus_one << 14;

        val
    }
}

pub use clc6c0::SetSkedCacheControl;

pub use clc6c0::SetShaderLocalMemoryNonThrottledA;

pub use clc6c0::SetShaderLocalMemoryNonThrottledB;

pub use clc6c0::SetShaderLocalMemoryNonThrottledC;

pub use clc6c0::SetSpaVersion;

pub use clc6c0::SetInlineQmdAddressA;

pub use clc6c0::SetInlineQmdAddressB;

pub use clc6c0::LoadInlineQmdData;

pub use clc6c0::SetFalcon00;

pub use clc6c0::SetFalcon01;

pub use clc6c0::SetFalcon02;

pub use clc6c0::SetFalcon03;

pub use clc6c0::SetFalcon04;

pub use clc6c0::SetFalcon05;

pub use clc6c0::SetFalcon06;

pub use clc6c0::SetFalcon07;

pub use clc6c0::SetFalcon08;

pub use clc6c0::SetFalcon09;

pub use clc6c0::SetFalcon10;

pub use clc6c0::SetFalcon11;

pub use clc6c0::SetFalcon12;

pub use clc6c0::SetFalcon13;

pub use clc6c0::SetFalcon14;

pub use clc6c0::SetFalcon15;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressA {
    pub upper: u32,
}

impl Mthd for SetMmeMemAddressA {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 17));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressB {
    pub lower: u32,
}

impl Mthd for SetMmeMemAddressB {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataRamAddress {
    pub word: u32,
}

impl Mthd for SetMmeDataRamAddress {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.word;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaRead {
    pub length: u32,
}

impl Mthd for MmeDmaRead {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReadFifoed {
    pub length: u32,
}

impl Mthd for MmeDmaReadFifoed {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWrite {
    pub length: u32,
}

impl Mthd for MmeDmaWrite {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionSize {
    FourBytes = 0x00000000,
    EightBytes = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReduction {
    pub reduction_op: MmeDmaReductionReductionOp,
    pub reduction_format: MmeDmaReductionReductionFormat,
    pub reduction_size: MmeDmaReductionReductionSize,
}

impl Mthd for MmeDmaReduction {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 0;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 4;

        assert!((self.reduction_size as u32) < (1 << 1));
        val |= (self.reduction_size as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSysmembar {
    pub v: u32,
}

impl Mthd for MmeDmaSysmembar {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSync {
    pub value: u32,
}

impl Mthd for MmeDmaSync {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeDataFifoConfigFifoSize {
    Size0Kb = 0x00000000,
    Size4Kb = 0x00000001,
    Size8Kb = 0x00000002,
    Size12Kb = 0x00000003,
    Size16Kb = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataFifoConfig {
    pub fifo_size: SetMmeDataFifoConfigFifoSize,
}

impl Mthd for SetMmeDataFifoConfig {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.fifo_size as u32) < (1 << 3));
        val |= (self.fifo_size as u32) << 0;

        val
    }
}

pub use clc6c0::SetShaderLocalMemoryA;

pub use clc6c0::SetShaderLocalMemoryB;

pub use clc6c0::SetShaderLocalMemoryWindowA;

pub use clc6c0::SetShaderLocalMemoryWindowB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ThrottleSm {
    pub multiply_add: bool,
}

impl Mthd for ThrottleSm {
    const ADDR: u16 = 0x07fc;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.multiply_add as u32) < (1 << 1));
        val |= (self.multiply_add as u32) << 0;

        val
    }
}

pub use clc6c0::SetShaderCacheControl;

pub use clc6c0::SetScgComputeSchedulingParameters;

pub use clc6c0::SetSmTimeoutInterval;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWriteMethodBarrier {
    pub v: u32,
}

impl Mthd for MmeDmaWriteMethodBarrier {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0xc7c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc6c0::InvalidateTextureDataCacheNoWfi;
pub use clc6c0::InvalidateTextureDataCacheNoWfiLines;

pub use clc6c0::ActivatePerfSettingsForComputeContext;

pub use clc6c0::InvalidateSamplerCache;
pub use clc6c0::InvalidateSamplerCacheLines;

pub use clc6c0::InvalidateTextureHeaderCache;
pub use clc6c0::InvalidateTextureHeaderCacheLines;

pub use clc6c0::InvalidateTextureDataCache;
pub use clc6c0::InvalidateTextureDataCacheLines;

pub use clc6c0::InvalidateSamplerCacheNoWfi;
pub use clc6c0::InvalidateSamplerCacheNoWfiLines;

pub use clc6c0::SetShaderExceptions;

pub use clc6c0::SetRenderEnableA;

pub use clc6c0::SetRenderEnableB;

pub use clc6c0::SetRenderEnableC;
pub use clc6c0::SetRenderEnableCMode;

pub use clc6c0::SetTexSamplerPoolA;

pub use clc6c0::SetTexSamplerPoolB;

pub use clc6c0::SetTexSamplerPoolC;

pub use clc6c0::SetTexHeaderPoolA;

pub use clc6c0::SetTexHeaderPoolB;

pub use clc6c0::SetTexHeaderPoolC;

pub use clc6c0::InvalidateShaderCachesNoWfi;

pub use clc6c0::SetRenderEnableOverride;
pub use clc6c0::SetRenderEnableOverrideMode;

pub use clc6c0::PipeNop;

pub use clc6c0::SetSpare00;

pub use clc6c0::SetSpare01;

pub use clc6c0::SetSpare02;

pub use clc6c0::SetSpare03;

pub use clc6c0::SetReportSemaphoreA;

pub use clc6c0::SetReportSemaphoreB;

pub use clc6c0::SetReportSemaphoreC;

pub use clc6c0::SetReportSemaphoreD;
pub use clc6c0::SetReportSemaphoreDOperation;
pub use clc6c0::SetReportSemaphoreDReductionFormat;
pub use clc6c0::SetReportSemaphoreDReductionOp;
pub use clc6c0::SetReportSemaphoreDStructureSize;

pub use clc6c0::SetTrapHandlerA;

pub use clc6c0::SetTrapHandlerB;

pub use clc6c0::SetBindlessTexture;

pub use clc6c0::SetShaderPerformanceSnapshotCounterValue;

pub use clc6c0::SetShaderPerformanceSnapshotCounterValueUpper;

pub use clc6c0::EnableShaderPerformanceSnapshotCounter;

pub use clc6c0::DisableShaderPerformanceSnapshotCounter;

pub use clc6c0::SetShaderPerformanceCounterValueUpper;

pub use clc6c0::SetShaderPerformanceCounterValue;

pub use clc6c0::SetShaderPerformanceCounterEvent;

pub use clc6c0::SetShaderPerformanceCounterControlA;

pub use clc6c0::SetShaderPerformanceCounterControlB;

pub use clc6c0::SetShaderPerformanceCounterTrapControl;

pub use clc6c0::StartShaderPerformanceCounter;

pub use clc6c0::StopShaderPerformanceCounter;

pub use clc6c0::SetShaderPerformanceCounterSctlFilter;

pub use clc6c0::SetShaderPerformanceCounterCoreMioFilter;

pub use clc6c0::SetMmeShadowScratch;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeMacro {
    pub v: u32,
}

impl ArrayMthd for CallMmeMacro {
    const CLASS: u16 = 0xc7c0;

    fn addr(i: usize) -> u16 {
        (0x3800 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CallMmeData {
    pub v: u32,
}

impl ArrayMthd for CallMmeData {
    const CLASS: u16 = 0xc7c0;

    fn addr(i: usize) -> u16 {
        (0x3804 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}
