use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc697::mthd as clc697;

// parsed class NVC797

pub use clc697::SetObject;

pub use clc697::NoOperation;

pub use clc697::SetNotifyA;

pub use clc697::SetNotifyB;

pub use clc697::Notify;
pub use clc697::NotifyType;

pub use clc697::WaitForIdle;

pub use clc697::LoadMmeInstructionRamPointer;

pub use clc697::LoadMmeInstructionRam;

pub use clc697::LoadMmeStartAddressRamPointer;

pub use clc697::LoadMmeStartAddressRam;

pub use clc697::SetMmeShadowRamControl;
pub use clc697::SetMmeShadowRamControlMode;

pub use clc697::PeerSemaphoreReleaseOffsetUpper;

pub use clc697::PeerSemaphoreReleaseOffset;

pub use clc697::SetGlobalRenderEnableA;

pub use clc697::SetGlobalRenderEnableB;

pub use clc697::SetGlobalRenderEnableC;
pub use clc697::SetGlobalRenderEnableCMode;

pub use clc697::SendGoIdle;

pub use clc697::PmTrigger;

pub use clc697::PmTriggerWfi;

pub use clc697::FeAtomicSequenceBegin;

pub use clc697::FeAtomicSequenceEnd;

pub use clc697::SetInstrumentationMethodHeader;

pub use clc697::SetInstrumentationMethodData;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphorePayloadLower {
    pub payload_lower: u32,
}

impl Mthd for SetReportSemaphorePayloadLower {
    const ADDR: u16 = 0x0158;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphorePayloadUpper {
    pub payload_upper: u32,
}

impl Mthd for SetReportSemaphorePayloadUpper {
    const ADDR: u16 = 0x015c;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload_upper;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreAddressLower {
    pub lower: u32,
}

impl Mthd for SetReportSemaphoreAddressLower {
    const ADDR: u16 = 0x0160;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreAddressUpper {
    pub upper: u32,
}

impl Mthd for SetReportSemaphoreAddressUpper {
    const ADDR: u16 = 0x0164;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecutePipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    ScgClocks = 0x00000008,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    TiledZpassPixelCnt64 = 0x00000017,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
    Timestamp = 0x00000014,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteStructureSize {
    SemaphoreFourWords = 0x00000000,
    SemaphoreOneWord = 0x00000001,
    SemaphoreTwoWords = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ReportSemaphoreExecuteTrapType {
    TrapNone = 0x00000000,
    TrapUnconditional = 0x00000001,
    TrapConditional = 0x00000002,
    TrapConditionalExt = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ReportSemaphoreExecute {
    pub operation: ReportSemaphoreExecuteOperation,
    pub pipeline_location: ReportSemaphoreExecutePipelineLocation,
    pub awaken_enable: bool,
    pub report: ReportSemaphoreExecuteReport,
    pub structure_size: ReportSemaphoreExecuteStructureSize,
    pub sub_report: u32,
    pub flush_disable: bool,
    pub rop_flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: ReportSemaphoreExecuteReductionOp,
    pub reduction_format: ReportSemaphoreExecuteReductionFormat,
    pub payload_size64: bool,
    pub trap_type: ReportSemaphoreExecuteTrapType,
}

impl Mthd for ReportSemaphoreExecute {
    const ADDR: u16 = 0x0168;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 2;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 6;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 7;

        assert!((self.structure_size as u32) < (1 << 2));
        val |= (self.structure_size as u32) << 13;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 15;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 19;

        assert!((self.rop_flush_disable as u32) < (1 << 1));
        val |= (self.rop_flush_disable as u32) << 18;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 20;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 21;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 24;

        assert!((self.payload_size64 as u32) < (1 << 1));
        val |= (self.payload_size64 as u32) << 27;

        assert!((self.trap_type as u32) < (1 << 2));
        val |= (self.trap_type as u32) << 28;

        val
    }
}

pub use clc697::LineLengthIn;

pub use clc697::LineCount;

pub use clc697::OffsetOutUpper;

pub use clc697::OffsetOut;

pub use clc697::PitchOut;

pub use clc697::SetDstBlockSize;
pub use clc697::SetDstBlockSizeDepth;
pub use clc697::SetDstBlockSizeHeight;
pub use clc697::SetDstBlockSizeWidth;

pub use clc697::SetDstWidth;

pub use clc697::SetDstHeight;

pub use clc697::SetDstDepth;

pub use clc697::SetDstLayer;

pub use clc697::SetDstOriginBytesX;

pub use clc697::SetDstOriginSamplesY;

pub use clc697::LaunchDma;
pub use clc697::LaunchDmaCompletionType;
pub use clc697::LaunchDmaDstMemoryLayout;
pub use clc697::LaunchDmaInterruptType;
pub use clc697::LaunchDmaReductionFormat;
pub use clc697::LaunchDmaReductionOp;
pub use clc697::LaunchDmaSemaphoreStructSize;

pub use clc697::LoadInlineData;

pub use clc697::SetI2MSemaphoreA;

pub use clc697::SetI2MSemaphoreB;

pub use clc697::SetI2MSemaphoreC;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeSwitchState {
    pub valid: bool,
    pub save_macro: u32,
    pub restore_macro: u32,
}

impl Mthd for SetMmeSwitchState {
    const ADDR: u16 = 0x01ec;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.valid as u32) < (1 << 1));
        val |= (self.valid as u32) << 0;

        assert!(self.save_macro < (1 << 8));
        val |= self.save_macro << 4;

        assert!(self.restore_macro < (1 << 8));
        val |= self.restore_macro << 12;

        val
    }
}

pub use clc697::SetI2MSpareNoop00;

pub use clc697::SetI2MSpareNoop01;

pub use clc697::SetI2MSpareNoop02;

pub use clc697::SetI2MSpareNoop03;

pub use clc697::RunDsNow;

pub use clc697::SetOpportunisticEarlyZHysteresis;
pub use clc697::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use clc697::SetGsMode;
pub use clc697::SetGsModeType;

pub use clc697::SetAliasedLineWidthEnable;

pub use clc697::SetApiMandatedEarlyZ;

pub use clc697::SetGsDmFifo;

pub use clc697::SetL2CacheControlForRopPrefetchReadRequests;
pub use clc697::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clc697::InvalidateShaderCaches;

pub use clc697::SetInstanceCount;

pub use clc697::SetPositionWScaledOffsetEnable;

pub use clc697::SetMultiView;

pub use clc697::SetGoIdleTimeout;

pub use clc697::SetConservativeRasterControl;
pub use clc697::SetConservativeRasterControlExtraPrimBloat;
pub use clc697::SetConservativeRasterControlLineAndPointSnapMode;
pub use clc697::SetConservativeRasterControlTriangleSnapMode;
pub use clc697::SetConservativeRasterControlUncertaintyRegionSize;

pub use clc697::SetMmeVersion;

pub use clc697::SetIndexBufferSizeA;

pub use clc697::SetIndexBufferSizeB;

pub use clc697::SetRootTableVisibility;

pub use clc697::SetDrawControlA;
pub use clc697::SetDrawControlAInstanceId;
pub use clc697::SetDrawControlAPrimitiveId;
pub use clc697::SetDrawControlASplitMode;
pub use clc697::SetDrawControlATopology;

pub use clc697::SetDrawControlB;

pub use clc697::DrawIndexBufferBeginEndA;

pub use clc697::DrawIndexBufferBeginEndB;

pub use clc697::DrawVertexArrayBeginEndA;

pub use clc697::DrawVertexArrayBeginEndB;

pub use clc697::InvalidateRasterCacheNoWfi;

pub use clc697::SetVariablePixelRateSampleOrder;

pub use clc697::SetColorRenderToZetaSurface;

pub use clc697::SetZcullVisiblePrimOptimization;

pub use clc697::IncrementSyncPoint;
pub use clc697::IncrementSyncPointCondition;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingTableSelectSource {
    FromViewportIndex = 0x00000000,
    FromVprsTableIndex = 0x00000001,
    FromConstant = 0x00000002,
    Reserved = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateShadingTableSelect {
    pub source: SetVariablePixelRateShadingTableSelectSource,
    pub source_constant_value: u32,
}

impl Mthd for SetVariablePixelRateShadingTableSelect {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.source as u32) < (1 << 2));
        val |= (self.source as u32) << 0;

        assert!(self.source_constant_value < (1 << 4));
        val |= self.source_constant_value << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRootTablePrefetch {
    pub stage_enables: u32,
}

impl Mthd for SetRootTablePrefetch {
    const ADDR: u16 = 0x02d0;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.stage_enables < (1 << 6));
        val |= self.stage_enables << 0;

        val
    }
}

pub use clc697::FlushAndInvalidateRopMiniCache;

pub use clc697::SetSurfaceClipIdBlockSize;
pub use clc697::SetSurfaceClipIdBlockSizeDepth;
pub use clc697::SetSurfaceClipIdBlockSizeHeight;
pub use clc697::SetSurfaceClipIdBlockSizeWidth;

pub use clc697::SetAlphaCircularBufferSize;

pub use clc697::DecompressSurface;

pub use clc697::SetZcullRopBypass;

pub use clc697::SetZcullSubregion;

pub use clc697::SetRasterBoundingBox;
pub use clc697::SetRasterBoundingBoxMode;

pub use clc697::PeerSemaphoreRelease;

pub use clc697::SetIteratedBlendOptimization;
pub use clc697::SetIteratedBlendOptimizationNoop;

pub use clc697::SetZcullSubregionAllocation;
pub use clc697::SetZcullSubregionAllocationFormat;

pub use clc697::AssignZcullSubregions;
pub use clc697::AssignZcullSubregionsAlgorithm;

pub use clc697::SetPsOutputSampleMaskUsage;
pub use clc697::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clc697::DrawZeroIndex;

pub use clc697::SetL1Configuration;
pub use clc697::SetL1ConfigurationDirectlyAddressableMemory;

pub use clc697::SetRenderEnableControl;

pub use clc697::SetSpaVersion;

pub use clc697::SetTimesliceBatchLimit;

pub use clc697::SetSnapGridLine;
pub use clc697::SetSnapGridLineLocationsPerPixel;
pub use clc697::SetSnapGridLineRoundingMode;

pub use clc697::SetSnapGridNonLine;
pub use clc697::SetSnapGridNonLineLocationsPerPixel;
pub use clc697::SetSnapGridNonLineRoundingMode;

pub use clc697::SetTessellationParameters;
pub use clc697::SetTessellationParametersDomainType;
pub use clc697::SetTessellationParametersOutputPrimitives;
pub use clc697::SetTessellationParametersSpacing;

pub use clc697::SetTessellationLodU0OrDensity;

pub use clc697::SetTessellationLodV0OrDetail;

pub use clc697::SetTessellationLodU1OrW0;

pub use clc697::SetTessellationLodV1;

pub use clc697::SetTgLodInteriorU;

pub use clc697::SetTgLodInteriorV;

pub use clc697::ReservedTg07;

pub use clc697::ReservedTg08;

pub use clc697::ReservedTg09;

pub use clc697::ReservedTg10;

pub use clc697::ReservedTg11;

pub use clc697::ReservedTg12;

pub use clc697::ReservedTg13;

pub use clc697::ReservedTg14;

pub use clc697::ReservedTg15;

pub use clc697::SetSubtilingPerfKnobA;

pub use clc697::SetSubtilingPerfKnobB;

pub use clc697::SetSubtilingPerfKnobC;

pub use clc697::SetZcullSubregionToReport;

pub use clc697::SetZcullSubregionReportType;
pub use clc697::SetZcullSubregionReportTypeType;

pub use clc697::SetBalancedPrimitiveWorkload;

pub use clc697::SetMaxPatchesPerBatch;

pub use clc697::SetRasterEnable;

pub use clc697::SetStreamOutBufferEnable;

pub use clc697::SetStreamOutBufferAddressA;

pub use clc697::SetStreamOutBufferAddressB;

pub use clc697::SetStreamOutBufferSize;

pub use clc697::SetStreamOutBufferLoadWritePointer;

pub use clc697::SetPositionWScaledOffsetScaleA;

pub use clc697::SetPositionWScaledOffsetScaleB;

pub use clc697::SetPositionWScaledOffsetReservedA;

pub use clc697::SetPositionWScaledOffsetReservedB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZRopSliceMap {
    pub virtual_address_mask: u32,
}

impl Mthd for SetZRopSliceMap {
    const ADDR: u16 = 0x0500;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.virtual_address_mask;

        val
    }
}

pub use clc697::SetRootTableSelector;

pub use clc697::LoadRootTable;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressA {
    pub upper: u32,
}

impl Mthd for SetMmeMemAddressA {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 17));
        val |= self.upper << 0;

        val
    }
}

pub use clc697::SetMmeMemAddressB;

pub use clc697::SetMmeDataRamAddress;

pub use clc697::MmeDmaRead;

pub use clc697::MmeDmaReadFifoed;

pub use clc697::MmeDmaWrite;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionFormat {
    Unsigned = 0x00000000,
    Signed = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionSize {
    FourBytes = 0x00000000,
    EightBytes = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReduction {
    pub reduction_op: MmeDmaReductionReductionOp,
    pub reduction_format: MmeDmaReductionReductionFormat,
    pub reduction_size: MmeDmaReductionReductionSize,
}

impl Mthd for MmeDmaReduction {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 0;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 4;

        assert!((self.reduction_size as u32) < (1 << 1));
        val |= (self.reduction_size as u32) << 8;

        val
    }
}

pub use clc697::MmeDmaSysmembar;

pub use clc697::MmeDmaSync;

pub use clc697::SetMmeDataFifoConfig;
pub use clc697::SetMmeDataFifoConfigFifoSize;

pub use clc697::SetVertexStreamSizeA;

pub use clc697::SetVertexStreamSizeB;

pub use clc697::SetStreamOutControlStream;

pub use clc697::SetStreamOutControlComponentCount;

pub use clc697::SetStreamOutControlStride;

pub use clc697::SetRasterInput;

pub use clc697::SetStreamOutput;

pub use clc697::SetDaPrimitiveRestartTopologyChange;

pub use clc697::SetHybridAntiAliasControl;
pub use clc697::SetHybridAntiAliasControlCentroid;

pub use clc697::SetShaderLocalMemoryWindow;

pub use clc697::SetShaderLocalMemoryA;

pub use clc697::SetShaderLocalMemoryB;

pub use clc697::SetShaderLocalMemoryC;

pub use clc697::SetShaderLocalMemoryD;

pub use clc697::SetShaderLocalMemoryE;

pub use clc697::SetColorZeroBandwidthClear;

pub use clc697::SetZZeroBandwidthClear;

pub use clc697::SetStencilZeroBandwidthClear;

pub use clc697::SetZcullRegionSizeA;

pub use clc697::SetZcullRegionSizeB;

pub use clc697::SetZcullRegionSizeC;

pub use clc697::SetZcullRegionPixelOffsetC;

pub use clc697::SetCullBeforeFetch;

pub use clc697::SetZcullRegionLocation;

pub use clc697::SetZcullRegionAliquots;

pub use clc697::SetZcullStorageA;

pub use clc697::SetZcullStorageB;

pub use clc697::SetZcullStorageC;

pub use clc697::SetZcullStorageD;

pub use clc697::SetZtReadOnly;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ThrottleSm {
    pub multiply_add: bool,
}

impl Mthd for ThrottleSm {
    const ADDR: u16 = 0x07fc;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.multiply_add as u32) < (1 << 1));
        val |= (self.multiply_add as u32) << 0;

        val
    }
}

pub use clc697::SetColorTargetA;

pub use clc697::SetColorTargetB;

pub use clc697::SetColorTargetWidth;

pub use clc697::SetColorTargetHeight;

pub use clc697::SetColorTargetFormat;
pub use clc697::SetColorTargetFormatV;

pub use clc697::SetColorTargetMemory;
pub use clc697::SetColorTargetMemoryBlockDepth;
pub use clc697::SetColorTargetMemoryBlockHeight;
pub use clc697::SetColorTargetMemoryBlockWidth;
pub use clc697::SetColorTargetMemoryLayout;
pub use clc697::SetColorTargetMemoryThirdDimensionControl;

pub use clc697::SetColorTargetThirdDimension;

pub use clc697::SetColorTargetArrayPitch;

pub use clc697::SetColorTargetLayer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetCRopSliceMap {
    pub virtual_address_mask: u32,
}

impl ArrayMthd for SetColorTargetCRopSliceMap {
    const CLASS: u16 = 0xc797;

    fn addr(i: usize) -> u16 {
        (0x0824 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.virtual_address_mask;

        val
    }
}

pub use clc697::SetViewportScaleX;

pub use clc697::SetViewportScaleY;

pub use clc697::SetViewportScaleZ;

pub use clc697::SetViewportOffsetX;

pub use clc697::SetViewportOffsetY;

pub use clc697::SetViewportOffsetZ;

pub use clc697::SetViewportCoordinateSwizzle;
pub use clc697::SetViewportCoordinateSwizzleW;
pub use clc697::SetViewportCoordinateSwizzleX;
pub use clc697::SetViewportCoordinateSwizzleY;
pub use clc697::SetViewportCoordinateSwizzleZ;

pub use clc697::SetViewportIncreaseSnapGridPrecision;

pub use clc697::SetViewportClipHorizontal;

pub use clc697::SetViewportClipVertical;

pub use clc697::SetViewportClipMinZ;

pub use clc697::SetViewportClipMaxZ;

pub use clc697::SetWindowClipHorizontal;

pub use clc697::SetWindowClipVertical;

pub use clc697::SetClipIdExtentX;

pub use clc697::SetClipIdExtentY;

pub use clc697::SetMaxStreamOutputGsInstancesPerTask;

pub use clc697::SetApiVisibleCallLimit;
pub use clc697::SetApiVisibleCallLimitV;

pub use clc697::SetStatisticsCounter;

pub use clc697::SetClearRectHorizontal;

pub use clc697::SetClearRectVertical;

pub use clc697::SetVertexArrayStart;

pub use clc697::DrawVertexArray;

pub use clc697::SetViewportZClip;
pub use clc697::SetViewportZClipRange;

pub use clc697::SetColorClearValue;

pub use clc697::SetZClearValue;

pub use clc697::SetShaderCacheControl;

pub use clc697::ForceTransitionToBeta;

pub use clc697::SetReduceColorThresholdsEnable;

pub use clc697::SetStencilClearValue;

pub use clc697::InvalidateShaderCachesNoWfi;

pub use clc697::SetZcullSerialization;
pub use clc697::SetZcullSerializationApplied;

pub use clc697::SetFrontPolygonMode;
pub use clc697::SetFrontPolygonModeV;

pub use clc697::SetBackPolygonMode;
pub use clc697::SetBackPolygonModeV;

pub use clc697::SetPolySmooth;

pub use clc697::SetZcullDirFormat;
pub use clc697::SetZcullDirFormatZdir;
pub use clc697::SetZcullDirFormatZformat;

pub use clc697::SetPolyOffsetPoint;

pub use clc697::SetPolyOffsetLine;

pub use clc697::SetPolyOffsetFill;

pub use clc697::SetPatch;

pub use clc697::SetIteratedBlend;

pub use clc697::SetIteratedBlendPass;

pub use clc697::SetZcullCriterion;
pub use clc697::SetZcullCriterionSfunc;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum PixelShaderBarrierBarrierLocation {
    BlockBeforePs = 0x00000000,
    BlockBeforePsAndZtest = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelShaderBarrier {
    pub sysmembar_enable: bool,
    pub barrier_location: PixelShaderBarrierBarrierLocation,
}

impl Mthd for PixelShaderBarrier {
    const ADDR: u16 = 0x0de0;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.sysmembar_enable as u32) < (1 << 1));
        val |= (self.sysmembar_enable as u32) << 0;

        assert!((self.barrier_location as u32) < (1 << 1));
        val |= (self.barrier_location as u32) << 1;

        val
    }
}

pub use clc697::SetSmTimeoutInterval;

pub use clc697::SetDaPrimitiveRestartVertexArray;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWriteMethodBarrier {
    pub v: u32,
}

impl Mthd for MmeDmaWriteMethodBarrier {
    const ADDR: u16 = 0x0dec;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc697::LoadIteratedBlendInstructionPointer;

pub use clc697::LoadIteratedBlendInstruction;
pub use clc697::LoadIteratedBlendInstructionConstantInputSelect;
pub use clc697::LoadIteratedBlendInstructionOperandASelect;
pub use clc697::LoadIteratedBlendInstructionOperandBSelect;
pub use clc697::LoadIteratedBlendInstructionOperandCSelect;
pub use clc697::LoadIteratedBlendInstructionOperandDSelect;
pub use clc697::LoadIteratedBlendInstructionOperation;
pub use clc697::LoadIteratedBlendInstructionOutputSwizzle;
pub use clc697::LoadIteratedBlendInstructionOutputWriteMask;
pub use clc697::LoadIteratedBlendInstructionPassOutput;
pub use clc697::LoadIteratedBlendInstructionTestCc;

pub use clc697::SetWindowOffsetX;

pub use clc697::SetWindowOffsetY;

pub use clc697::SetScissorEnable;

pub use clc697::SetScissorHorizontal;

pub use clc697::SetScissorVertical;

pub use clc697::SetVpcPerfKnob;

pub use clc697::PmLocalTrigger;

pub use clc697::SetPostZPsImask;

pub use clc697::SetMultiViewRenderTargetArrayIndexOffset;

pub use clc697::SetSpareMultiViewRenderTargetArrayIndexOffset;

pub use clc697::SetConstantColorRendering;

pub use clc697::SetConstantColorRenderingRed;

pub use clc697::SetConstantColorRenderingGreen;

pub use clc697::SetConstantColorRenderingBlue;

pub use clc697::SetConstantColorRenderingAlpha;

pub use clc697::SetBackStencilFuncRef;

pub use clc697::SetBackStencilMask;

pub use clc697::SetBackStencilFuncMask;

pub use clc697::SetVertexStreamSubstituteA;

pub use clc697::SetVertexStreamSubstituteB;

pub use clc697::SetLineModePolygonClip;
pub use clc697::SetLineModePolygonClipGeneratedEdge;

pub use clc697::SetSingleCtWriteControl;

pub use clc697::SetVtgWarpWatermarks;

pub use clc697::SetDepthBoundsMin;

pub use clc697::SetDepthBoundsMax;

pub use clc697::SetSampleMask;

pub use clc697::SetColorTargetSampleMask;

pub use clc697::SetCtMrtEnable;

pub use clc697::SetNonmultisampledZ;
pub use clc697::SetNonmultisampledZV;

pub use clc697::SetTir;
pub use clc697::SetTirMode;

pub use clc697::SetAntiAliasRaster;
pub use clc697::SetAntiAliasRasterSamples;

pub use clc697::SetSampleMaskX0Y0;

pub use clc697::SetSampleMaskX1Y0;

pub use clc697::SetSampleMaskX0Y1;

pub use clc697::SetSampleMaskX1Y1;

pub use clc697::SetSurfaceClipIdMemoryA;

pub use clc697::SetSurfaceClipIdMemoryB;

pub use clc697::SetTirModulation;
pub use clc697::SetTirModulationComponentSelect;

pub use clc697::SetTirModulationFunction;
pub use clc697::SetTirModulationFunctionSelect;

pub use clc697::SetBlendOptControl;

pub use clc697::SetZtA;

pub use clc697::SetZtB;

pub use clc697::SetZtFormat;
pub use clc697::SetZtFormatV;

pub use clc697::SetZtBlockSize;
pub use clc697::SetZtBlockSizeDepth;
pub use clc697::SetZtBlockSizeHeight;
pub use clc697::SetZtBlockSizeWidth;

pub use clc697::SetZtArrayPitch;

pub use clc697::SetSurfaceClipHorizontal;

pub use clc697::SetSurfaceClipVertical;

pub use clc697::SetL2CacheControlForVafRequests;
pub use clc697::SetL2CacheControlForVafRequestsPolicy;

pub use clc697::SetViewportMulticast;
pub use clc697::SetViewportMulticastOrder;

pub use clc697::SetTessellationCutHeight;

pub use clc697::SetMaxGsInstancesPerTask;

pub use clc697::SetMaxGsOutputVerticesPerTask;

pub use clc697::SetReservedSwMethod00;

pub use clc697::SetGsOutputCbStorageMultiplier;

pub use clc697::SetBetaCbStorageConstraint;

pub use clc697::SetTiOutputCbStorageMultiplier;

pub use clc697::SetAlphaCbStorageConstraint;

pub use clc697::SetReservedSwMethod01;

pub use clc697::SetReservedSwMethod02;

pub use clc697::SetTirModulationCoefficientTable;

pub use clc697::SetSpareNoop01;

pub use clc697::SetSpareNoop02;

pub use clc697::SetSpareNoop03;

pub use clc697::SetSpareNoop04;

pub use clc697::SetSpareNoop05;

pub use clc697::SetSpareNoop06;

pub use clc697::SetSpareNoop07;

pub use clc697::SetSpareNoop08;

pub use clc697::SetSpareNoop09;

pub use clc697::SetSpareNoop10;

pub use clc697::SetSpareNoop11;

pub use clc697::SetSpareNoop12;

pub use clc697::SetSpareNoop13;

pub use clc697::SetSpareNoop14;

pub use clc697::SetSpareNoop15;

pub use clc697::SetReservedSwMethod03;

pub use clc697::SetReservedSwMethod04;

pub use clc697::SetReservedSwMethod05;

pub use clc697::SetReservedSwMethod06;

pub use clc697::SetReservedSwMethod07;

pub use clc697::SetReservedSwMethod08;

pub use clc697::SetReservedSwMethod09;

pub use clc697::SetReduceColorThresholdsUnorm8;

pub use clc697::SetReservedSwMethod10;

pub use clc697::SetReservedSwMethod11;

pub use clc697::SetReservedSwMethod12;

pub use clc697::SetReservedSwMethod13;

pub use clc697::SetReduceColorThresholdsUnorm10;

pub use clc697::SetReduceColorThresholdsUnorm16;

pub use clc697::SetReduceColorThresholdsFp11;

pub use clc697::SetReduceColorThresholdsFp16;

pub use clc697::SetReduceColorThresholdsSrgb8;

pub use clc697::UnbindAll;

pub use clc697::SetClearSurfaceControl;

pub use clc697::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clc697::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clc697::SetReservedSwMethod14;

pub use clc697::SetReservedSwMethod15;

pub use clc697::NoOperationDataHi;

pub use clc697::SetDepthBiasControl;

pub use clc697::PmTriggerEnd;

pub use clc697::SetVertexIdBase;

pub use clc697::SetStencilCompression;

pub use clc697::SetDaOutputAttributeSkipMaskA;

pub use clc697::SetDaOutputAttributeSkipMaskB;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlZPassPixelCountUseRasterSamples {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlAlphaToCoverageUseRasterSamples {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlReduceCoverage {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlReductionMode {
    AffinityMap = 0x00000000,
    Truncation = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTirControl {
    pub z_pass_pixel_count_use_raster_samples: SetTirControlZPassPixelCountUseRasterSamples,
    pub alpha_to_coverage_use_raster_samples: SetTirControlAlphaToCoverageUseRasterSamples,
    pub reduce_coverage: SetTirControlReduceCoverage,
    pub reduction_mode: SetTirControlReductionMode,
}

impl Mthd for SetTirControl {
    const ADDR: u16 = 0x1130;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_pass_pixel_count_use_raster_samples as u32) < (1 << 1));
        val |= (self.z_pass_pixel_count_use_raster_samples as u32) << 0;

        assert!((self.alpha_to_coverage_use_raster_samples as u32) < (1 << 1));
        val |= (self.alpha_to_coverage_use_raster_samples as u32) << 4;

        assert!((self.reduce_coverage as u32) < (1 << 1));
        val |= (self.reduce_coverage as u32) << 1;

        assert!((self.reduction_mode as u32) < (1 << 1));
        val |= (self.reduction_mode as u32) << 2;

        val
    }
}

pub use clc697::SetMutableMethodControl;

pub use clc697::SetPostPsInitialCoverage;

pub use clc697::SetFillViaTriangle;
pub use clc697::SetFillViaTriangleMode;

pub use clc697::SetBlendPerFormatEnable;

pub use clc697::FlushPendingWrites;

pub use clc697::SetConservativeRaster;

pub use clc697::SetMeshControl;

pub use clc697::SetMeshShaderA;
pub use clc697::SetMeshShaderAOutputTopology;

pub use clc697::SetMeshShaderB;

pub use clc697::SetMeshInitShader;

pub use clc697::SetVertexAttributeA;
pub use clc697::SetVertexAttributeAComponentBitWidths;
pub use clc697::SetVertexAttributeANumericalType;
pub use clc697::SetVertexAttributeASource;

pub use clc697::SetVertexAttributeB;
pub use clc697::SetVertexAttributeBComponentBitWidths;
pub use clc697::SetVertexAttributeBNumericalType;
pub use clc697::SetVertexAttributeBSource;

pub use clc697::SetAntiAliasSamplePositions;

pub use clc697::SetOffsetRenderTargetIndex;

pub use clc697::ForceHeavyweightMethodSync;

pub use clc697::SetCoverageToColor;

pub use clc697::DecompressZetaSurface;

pub use clc697::SetScreenStateMask;

pub use clc697::SetZtSparse;
pub use clc697::SetZtSparseUnmappedCompare;

pub use clc697::DrawVertexArrayBeginEndInstanceFirst;
pub use clc697::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clc697::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clc697::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clc697::SetCtSelect;

pub use clc697::SetCompressionThreshold;
pub use clc697::SetCompressionThresholdSamples;

pub use clc697::SetPixelShaderInterlockControl;
pub use clc697::SetPixelShaderInterlockControlTileCoalescerFragmentOrder;
pub use clc697::SetPixelShaderInterlockControlTileCoalescerMode;
pub use clc697::SetPixelShaderInterlockControlTileCoalescerTileSize;

pub use clc697::SetZtSizeA;

pub use clc697::SetZtSizeB;

pub use clc697::SetZtSizeC;
pub use clc697::SetZtSizeCControl;

pub use clc697::SetSamplerBinding;
pub use clc697::SetSamplerBindingV;

pub use clc697::DrawAuto;

pub use clc697::SetPostVtgShaderAttributeSkipMask;

pub use clc697::SetPixelShaderTicketDispenserValue;

pub use clc697::SetBackEndCopyA;

pub use clc697::SetBackEndCopyB;

pub use clc697::SetBackEndCopyC;

pub use clc697::SetBackEndCopyD;

pub use clc697::SetBackEndCopyE;

pub use clc697::SetCircularBufferSize;

pub use clc697::SetVtgRegisterWatermarks;

pub use clc697::InvalidateTextureDataCacheNoWfi;
pub use clc697::InvalidateTextureDataCacheNoWfiLines;

pub use clc697::SetL2CacheControlForRopInterlockedReadRequests;
pub use clc697::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clc697::SetDaPrimitiveRestartIndexTopologyChange;

pub use clc697::SetShadingRateIndexSurfaceAddressA;

pub use clc697::SetShadingRateIndexSurfaceAddressB;

pub use clc697::SetShadingRateIndexSurfaceSizeA;

pub use clc697::SetShadingRateIndexSurfaceSizeB;

pub use clc697::SetShadingRateIndexSurfaceLayer;

pub use clc697::SetShadingRateIndexSurfaceArrayPitch;

pub use clc697::SetShadingRateIndexSurfaceBlockSize;
pub use clc697::SetShadingRateIndexSurfaceBlockSizeDepth;
pub use clc697::SetShadingRateIndexSurfaceBlockSizeHeight;
pub use clc697::SetShadingRateIndexSurfaceBlockSizeWidth;

pub use clc697::SetShadingRateIndexSurfaceAllocatedSize;

pub use clc697::ClearZcullRegion;

pub use clc697::SetDepthTest;

pub use clc697::SetFillMode;
pub use clc697::SetFillModeV;

pub use clc697::SetShadeMode;
pub use clc697::SetShadeModeV;

pub use clc697::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clc697::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clc697::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clc697::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clc697::SetAlphaToCoverageDitherControl;
pub use clc697::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clc697::SetBlendStatePerTarget;

pub use clc697::SetDepthWrite;

pub use clc697::SetAlphaTest;

pub use clc697::SetInlineIndex4X8Align;

pub use clc697::DrawInlineIndex4X8;

pub use clc697::D3DSetCullMode;
pub use clc697::D3DSetCullModeV;

pub use clc697::SetDepthFunc;
pub use clc697::SetDepthFuncV;

pub use clc697::SetAlphaRef;

pub use clc697::SetAlphaFunc;
pub use clc697::SetAlphaFuncV;

pub use clc697::SetDrawAutoStride;

pub use clc697::SetBlendConstRed;

pub use clc697::SetBlendConstGreen;

pub use clc697::SetBlendConstBlue;

pub use clc697::SetBlendConstAlpha;

pub use clc697::InvalidateSamplerCache;
pub use clc697::InvalidateSamplerCacheLines;

pub use clc697::InvalidateTextureHeaderCache;
pub use clc697::InvalidateTextureHeaderCacheLines;

pub use clc697::InvalidateTextureDataCache;
pub use clc697::InvalidateTextureDataCacheLines;

pub use clc697::SetBlendSeparateForAlpha;

pub use clc697::SetBlendColorOp;
pub use clc697::SetBlendColorOpV;

pub use clc697::SetBlendColorSourceCoeff;
pub use clc697::SetBlendColorSourceCoeffV;

pub use clc697::SetBlendColorDestCoeff;
pub use clc697::SetBlendColorDestCoeffV;

pub use clc697::SetBlendAlphaOp;
pub use clc697::SetBlendAlphaOpV;

pub use clc697::SetBlendAlphaSourceCoeff;
pub use clc697::SetBlendAlphaSourceCoeffV;

pub use clc697::SetGlobalColorKey;

pub use clc697::SetBlendAlphaDestCoeff;
pub use clc697::SetBlendAlphaDestCoeffV;

pub use clc697::SetSingleRopControl;

pub use clc697::SetBlend;

pub use clc697::SetStencilTest;

pub use clc697::SetStencilOpFail;
pub use clc697::SetStencilOpFailV;

pub use clc697::SetStencilOpZfail;
pub use clc697::SetStencilOpZfailV;

pub use clc697::SetStencilOpZpass;
pub use clc697::SetStencilOpZpassV;

pub use clc697::SetStencilFunc;
pub use clc697::SetStencilFuncV;

pub use clc697::SetStencilFuncRef;

pub use clc697::SetStencilFuncMask;

pub use clc697::SetStencilMask;

pub use clc697::SetDrawAutoStart;

pub use clc697::SetPsSaturate;
pub use clc697::SetPsSaturateClampRange0;
pub use clc697::SetPsSaturateClampRange1;
pub use clc697::SetPsSaturateClampRange2;
pub use clc697::SetPsSaturateClampRange3;
pub use clc697::SetPsSaturateClampRange4;
pub use clc697::SetPsSaturateClampRange5;
pub use clc697::SetPsSaturateClampRange6;
pub use clc697::SetPsSaturateClampRange7;

pub use clc697::SetWindowOrigin;
pub use clc697::SetWindowOriginMode;

pub use clc697::SetLineWidthFloat;

pub use clc697::SetAliasedLineWidthFloat;

pub use clc697::SetLineMultisampleOverride;

pub use clc697::InvalidateSamplerCacheNoWfi;
pub use clc697::InvalidateSamplerCacheNoWfiLines;

pub use clc697::InvalidateTextureHeaderCacheNoWfi;
pub use clc697::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc697::SetGlobalBaseVertexIndex;

pub use clc697::SetGlobalBaseInstanceIndex;

pub use clc697::SetPsWarpWatermarks;

pub use clc697::SetPsRegisterWatermarks;

pub use clc697::StoreZcull;

pub use clc697::SetIteratedBlendConstantRed;

pub use clc697::SetIteratedBlendConstantGreen;

pub use clc697::SetIteratedBlendConstantBlue;

pub use clc697::LoadZcull;

pub use clc697::SetSurfaceClipIdHeight;

pub use clc697::SetClipIdClearRectHorizontal;

pub use clc697::SetClipIdClearRectVertical;

pub use clc697::SetUserClipEnable;

pub use clc697::SetZpassPixelCount;

pub use clc697::SetPointSize;

pub use clc697::SetZcullStats;

pub use clc697::SetPointSprite;

pub use clc697::SetShaderExceptions;

pub use clc697::ClearReportValue;
pub use clc697::ClearReportValueType;

pub use clc697::SetAntiAliasEnable;

pub use clc697::SetZtSelect;

pub use clc697::SetAntiAliasAlphaControl;
pub use clc697::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clc697::SetAntiAliasAlphaControlAlphaToOne;

pub use clc697::SetRenderEnableA;

pub use clc697::SetRenderEnableB;

pub use clc697::SetRenderEnableC;
pub use clc697::SetRenderEnableCMode;

pub use clc697::SetTexSamplerPoolA;

pub use clc697::SetTexSamplerPoolB;

pub use clc697::SetTexSamplerPoolC;

pub use clc697::SetSlopeScaleDepthBias;

pub use clc697::SetAntiAliasedLine;

pub use clc697::SetTexHeaderPoolA;

pub use clc697::SetTexHeaderPoolB;

pub use clc697::SetTexHeaderPoolC;

pub use clc697::SetActiveZcullRegion;

pub use clc697::SetTwoSidedStencilTest;

pub use clc697::SetBackStencilOpFail;
pub use clc697::SetBackStencilOpFailV;

pub use clc697::SetBackStencilOpZfail;
pub use clc697::SetBackStencilOpZfailV;

pub use clc697::SetBackStencilOpZpass;
pub use clc697::SetBackStencilOpZpassV;

pub use clc697::SetBackStencilFunc;
pub use clc697::SetBackStencilFuncV;

pub use clc697::SetSrgbWrite;

pub use clc697::SetDepthBias;

pub use clc697::SetZcullRegionFormat;
pub use clc697::SetZcullRegionFormatType;

pub use clc697::SetRtLayer;
pub use clc697::SetRtLayerControl;

pub use clc697::SetAntiAlias;
pub use clc697::SetAntiAliasSamples;

pub use clc697::SetEdgeFlag;

pub use clc697::DrawInlineIndex;

pub use clc697::SetInlineIndex2X16Align;

pub use clc697::DrawInlineIndex2X16;

pub use clc697::SetVertexGlobalBaseOffsetA;

pub use clc697::SetVertexGlobalBaseOffsetB;

pub use clc697::SetZcullRegionPixelOffsetA;

pub use clc697::SetZcullRegionPixelOffsetB;

pub use clc697::SetPointSpriteSelect;
pub use clc697::SetPointSpriteSelectOrigin;
pub use clc697::SetPointSpriteSelectRmode;
pub use clc697::SetPointSpriteSelectTexture0;
pub use clc697::SetPointSpriteSelectTexture1;
pub use clc697::SetPointSpriteSelectTexture2;
pub use clc697::SetPointSpriteSelectTexture3;
pub use clc697::SetPointSpriteSelectTexture4;
pub use clc697::SetPointSpriteSelectTexture5;
pub use clc697::SetPointSpriteSelectTexture6;
pub use clc697::SetPointSpriteSelectTexture7;
pub use clc697::SetPointSpriteSelectTexture8;
pub use clc697::SetPointSpriteSelectTexture9;

pub use clc697::SetAttributeDefault;
pub use clc697::SetAttributeDefaultColorFrontDiffuse;
pub use clc697::SetAttributeDefaultColorFrontSpecular;
pub use clc697::SetAttributeDefaultDx9Color0;
pub use clc697::SetAttributeDefaultDx9Color1ToColor15;
pub use clc697::SetAttributeDefaultFixedFncTexture;
pub use clc697::SetAttributeDefaultGenericVector;

pub use clc697::End;

pub use clc697::Begin;
pub use clc697::BeginInstanceId;
pub use clc697::BeginOp;
pub use clc697::BeginPrimitiveId;
pub use clc697::BeginSplitMode;

pub use clc697::SetVertexIdCopy;

pub use clc697::AddToPrimitiveId;

pub use clc697::LoadPrimitiveId;

pub use clc697::SetShaderBasedCull;

pub use clc697::SetClassVersion;

pub use clc697::SetDaPrimitiveRestart;

pub use clc697::SetDaPrimitiveRestartIndex;

pub use clc697::SetDaOutput;

pub use clc697::SetAntiAliasedPoint;

pub use clc697::SetPointCenterMode;
pub use clc697::SetPointCenterModeV;

pub use clc697::SetLineSmoothParameters;
pub use clc697::SetLineSmoothParametersFalloff;

pub use clc697::SetLineStipple;

pub use clc697::SetLineSmoothEdgeTable;

pub use clc697::SetLineStippleParameters;

pub use clc697::SetProvokingVertex;
pub use clc697::SetProvokingVertexV;

pub use clc697::SetTwoSidedLight;

pub use clc697::SetPolygonStipple;

pub use clc697::SetShaderControl;
pub use clc697::SetShaderControlDefaultPartial;
pub use clc697::SetShaderControlFp32F2INanBehavior;
pub use clc697::SetShaderControlFp32NanBehavior;

pub use clc697::CheckClassVersion;

pub use clc697::SetSphVersion;

pub use clc697::CheckSphVersion;

pub use clc697::SetAlphaToCoverageOverride;
pub use clc697::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clc697::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use clc697::SetScgGraphicsPriority;

pub use clc697::SetScgGraphicsSchedulingParameters;

pub use clc697::SetPolygonStipplePattern;

pub use clc697::SetAamVersion;

pub use clc697::CheckAamVersion;

pub use clc697::SetZtLayer;

pub use clc697::SetIndexBufferA;

pub use clc697::SetIndexBufferB;

pub use clc697::SetIndexBufferE;
pub use clc697::SetIndexBufferEIndexSize;

pub use clc697::SetIndexBufferF;

pub use clc697::DrawIndexBuffer;

pub use clc697::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clc697::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clc697::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clc697::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clc697::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clc697::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clc697::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clc697::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clc697::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clc697::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clc697::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clc697::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clc697::SetDepthBiasClamp;

pub use clc697::SetVertexStreamInstanceA;

pub use clc697::SetVertexStreamInstanceB;

pub use clc697::SetAttributePointSize;

pub use clc697::OglSetCull;

pub use clc697::OglSetFrontFace;
pub use clc697::OglSetFrontFaceV;

pub use clc697::OglSetCullFace;
pub use clc697::OglSetCullFaceV;

pub use clc697::SetViewportPixel;
pub use clc697::SetViewportPixelCenter;

pub use clc697::SetViewportScaleOffset;

pub use clc697::SetViewportClipControl;
pub use clc697::SetViewportClipControlGeometryClip;
pub use clc697::SetViewportClipControlGeometryGuardband;
pub use clc697::SetViewportClipControlGeometryGuardbandZ;
pub use clc697::SetViewportClipControlLinePointCullGuardband;
pub use clc697::SetViewportClipControlPixelMaxZ;
pub use clc697::SetViewportClipControlPixelMinZ;
pub use clc697::SetViewportClipControlZClipRange;

pub use clc697::SetUserClipOp;
pub use clc697::SetUserClipOpPlane0;
pub use clc697::SetUserClipOpPlane1;
pub use clc697::SetUserClipOpPlane2;
pub use clc697::SetUserClipOpPlane3;
pub use clc697::SetUserClipOpPlane4;
pub use clc697::SetUserClipOpPlane5;
pub use clc697::SetUserClipOpPlane6;
pub use clc697::SetUserClipOpPlane7;

pub use clc697::SetRenderEnableOverride;
pub use clc697::SetRenderEnableOverrideMode;

pub use clc697::SetPrimitiveTopologyControl;
pub use clc697::SetPrimitiveTopologyControlOverride;

pub use clc697::SetWindowClipEnable;

pub use clc697::SetWindowClipType;
pub use clc697::SetWindowClipTypeV;

pub use clc697::InvalidateZcull;
pub use clc697::InvalidateZcullV;

pub use clc697::SetZcull;

pub use clc697::SetZcullBounds;

pub use clc697::SetPrimitiveTopology;
pub use clc697::SetPrimitiveTopologyV;

pub use clc697::ZcullSync;

pub use clc697::SetClipIdTest;

pub use clc697::SetSurfaceClipIdWidth;

pub use clc697::SetClipId;

pub use clc697::SetDepthBoundsTest;

pub use clc697::SetBlendFloatOption;

pub use clc697::SetLogicOp;

pub use clc697::SetLogicOpFunc;
pub use clc697::SetLogicOpFuncV;

pub use clc697::SetZCompression;

pub use clc697::ClearSurface;

pub use clc697::ClearClipIdSurface;

pub use clc697::SetColorCompression;

pub use clc697::SetCtWrite;

pub use clc697::PipeNop;

pub use clc697::SetSpare00;

pub use clc697::SetSpare01;

pub use clc697::SetSpare02;

pub use clc697::SetSpare03;

pub use clc697::SetReportSemaphoreA;

pub use clc697::SetReportSemaphoreB;

pub use clc697::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    ScgClocks = 0x00000008,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    TiledZpassPixelCnt64 = 0x00000017,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
    Timestamp = 0x00000014,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
    pub conditional_trap: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xc797;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;

        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;

        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;

        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        assert!((self.conditional_trap as u32) < (1 << 1));
        val |= (self.conditional_trap as u32) << 19;

        val
    }
}

pub use clc697::SetVertexStreamAFormat;

pub use clc697::SetVertexStreamALocationA;

pub use clc697::SetVertexStreamALocationB;

pub use clc697::SetVertexStreamAFrequency;

pub use clc697::SetVertexStreamBFormat;

pub use clc697::SetVertexStreamBLocationA;

pub use clc697::SetVertexStreamBLocationB;

pub use clc697::SetVertexStreamBFrequency;

pub use clc697::SetBlendPerTargetSeparateForAlpha;

pub use clc697::SetBlendPerTargetColorOp;
pub use clc697::SetBlendPerTargetColorOpV;

pub use clc697::SetBlendPerTargetColorSourceCoeff;
pub use clc697::SetBlendPerTargetColorSourceCoeffV;

pub use clc697::SetBlendPerTargetColorDestCoeff;
pub use clc697::SetBlendPerTargetColorDestCoeffV;

pub use clc697::SetBlendPerTargetAlphaOp;
pub use clc697::SetBlendPerTargetAlphaOpV;

pub use clc697::SetBlendPerTargetAlphaSourceCoeff;
pub use clc697::SetBlendPerTargetAlphaSourceCoeffV;

pub use clc697::SetBlendPerTargetAlphaDestCoeff;
pub use clc697::SetBlendPerTargetAlphaDestCoeffV;

pub use clc697::SetPipelineShader;
pub use clc697::SetPipelineShaderType;

pub use clc697::SetPipelineReservedB;

pub use clc697::SetPipelineReservedA;

pub use clc697::SetPipelineRegisterCount;

pub use clc697::SetPipelineBinding;

pub use clc697::SetPipelineProgramAddressA;

pub use clc697::SetPipelineProgramAddressB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineProgramPrefetch {
    pub size_in_blocks: u32,
}

impl ArrayMthd for SetPipelineProgramPrefetch {
    const CLASS: u16 = 0xc797;

    fn addr(i: usize) -> u16 {
        (0x201c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_in_blocks < (1 << 7));
        val |= self.size_in_blocks << 0;

        val
    }
}

pub use clc697::SetPipelineReservedE;

pub use clc697::SetFalcon00;

pub use clc697::SetFalcon01;

pub use clc697::SetFalcon02;

pub use clc697::SetFalcon03;

pub use clc697::SetFalcon04;

pub use clc697::SetFalcon05;

pub use clc697::SetFalcon06;

pub use clc697::SetFalcon07;

pub use clc697::SetFalcon08;

pub use clc697::SetFalcon09;

pub use clc697::SetFalcon10;

pub use clc697::SetFalcon11;

pub use clc697::SetFalcon12;

pub use clc697::SetFalcon13;

pub use clc697::SetFalcon14;

pub use clc697::SetFalcon15;

pub use clc697::SetFalcon16;

pub use clc697::SetFalcon17;

pub use clc697::SetFalcon18;

pub use clc697::SetFalcon19;

pub use clc697::SetFalcon20;

pub use clc697::SetFalcon21;

pub use clc697::SetFalcon22;

pub use clc697::SetFalcon23;

pub use clc697::SetFalcon24;

pub use clc697::SetFalcon25;

pub use clc697::SetFalcon26;

pub use clc697::SetFalcon27;

pub use clc697::SetFalcon28;

pub use clc697::SetFalcon29;

pub use clc697::SetFalcon30;

pub use clc697::SetFalcon31;

pub use clc697::SetConstantBufferSelectorA;

pub use clc697::SetConstantBufferSelectorB;

pub use clc697::SetConstantBufferSelectorC;

pub use clc697::LoadConstantBufferOffset;

pub use clc697::LoadConstantBuffer;

pub use clc697::BindGroupReservedA;

pub use clc697::BindGroupReservedB;

pub use clc697::BindGroupReservedC;

pub use clc697::BindGroupReservedD;

pub use clc697::BindGroupConstantBuffer;

pub use clc697::SetTrapHandlerA;

pub use clc697::SetTrapHandlerB;

pub use clc697::SetColorClamp;

pub use clc697::SetVariablePixelRateShadingControl;

pub use clc697::SetVariablePixelRateShadingIndexToRateA;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex0;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex1;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex2;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex3;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex4;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex5;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex6;
pub use clc697::SetVariablePixelRateShadingIndexToRateARateIndex7;

pub use clc697::SetVariablePixelRateShadingIndexToRateB;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex10;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex11;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex12;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex13;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex14;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex15;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex8;
pub use clc697::SetVariablePixelRateShadingIndexToRateBRateIndex9;

pub use clc697::SetVariablePixelRateShadingReservedA;

pub use clc697::SetShaderPerformanceSnapshotCounterValue;

pub use clc697::SetShaderPerformanceSnapshotCounterValueUpper;

pub use clc697::EnableShaderPerformanceSnapshotCounter;

pub use clc697::DisableShaderPerformanceSnapshotCounter;

pub use clc697::SetShaderPerformanceCounterValueUpper;

pub use clc697::SetShaderPerformanceCounterValue;

pub use clc697::SetShaderPerformanceCounterEvent;

pub use clc697::SetShaderPerformanceCounterControlA;

pub use clc697::SetShaderPerformanceCounterControlB;

pub use clc697::SetShaderPerformanceCounterTrapControl;

pub use clc697::StartShaderPerformanceCounter;

pub use clc697::StopShaderPerformanceCounter;

pub use clc697::SetShaderPerformanceCounterSctlFilter;

pub use clc697::SetShaderPerformanceCounterCoreMioFilter;

pub use clc697::SetMmeShadowScratch;

pub use clc697::CallMmeMacro;

pub use clc697::CallMmeData;
