use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc597::mthd as clc597;

// parsed class NVC697

pub use clc597::SetObject;

pub use clc597::NoOperation;

pub use clc597::SetNotifyA;

pub use clc597::SetNotifyB;

pub use clc597::Notify;
pub use clc597::NotifyType;

pub use clc597::WaitForIdle;

pub use clc597::LoadMmeInstructionRamPointer;

pub use clc597::LoadMmeInstructionRam;

pub use clc597::LoadMmeStartAddressRamPointer;

pub use clc597::LoadMmeStartAddressRam;

pub use clc597::SetMmeShadowRamControl;
pub use clc597::SetMmeShadowRamControlMode;

pub use clc597::PeerSemaphoreReleaseOffsetUpper;

pub use clc597::PeerSemaphoreReleaseOffset;

pub use clc597::SetGlobalRenderEnableA;

pub use clc597::SetGlobalRenderEnableB;

pub use clc597::SetGlobalRenderEnableC;
pub use clc597::SetGlobalRenderEnableCMode;

pub use clc597::SendGoIdle;

pub use clc597::PmTrigger;

pub use clc597::PmTriggerWfi;

pub use clc597::FeAtomicSequenceBegin;

pub use clc597::FeAtomicSequenceEnd;

pub use clc597::SetInstrumentationMethodHeader;

pub use clc597::SetInstrumentationMethodData;

pub use clc597::LineLengthIn;

pub use clc597::LineCount;

pub use clc597::OffsetOutUpper;

pub use clc597::OffsetOut;

pub use clc597::PitchOut;

pub use clc597::SetDstBlockSize;
pub use clc597::SetDstBlockSizeDepth;
pub use clc597::SetDstBlockSizeHeight;
pub use clc597::SetDstBlockSizeWidth;

pub use clc597::SetDstWidth;

pub use clc597::SetDstHeight;

pub use clc597::SetDstDepth;

pub use clc597::SetDstLayer;

pub use clc597::SetDstOriginBytesX;

pub use clc597::SetDstOriginSamplesY;

pub use clc597::LaunchDma;
pub use clc597::LaunchDmaCompletionType;
pub use clc597::LaunchDmaDstMemoryLayout;
pub use clc597::LaunchDmaInterruptType;
pub use clc597::LaunchDmaReductionFormat;
pub use clc597::LaunchDmaReductionOp;
pub use clc597::LaunchDmaSemaphoreStructSize;

pub use clc597::LoadInlineData;

pub use clc597::SetI2MSemaphoreA;

pub use clc597::SetI2MSemaphoreB;

pub use clc597::SetI2MSemaphoreC;

pub use clc597::SetI2MSpareNoop00;

pub use clc597::SetI2MSpareNoop01;

pub use clc597::SetI2MSpareNoop02;

pub use clc597::SetI2MSpareNoop03;

pub use clc597::RunDsNow;

pub use clc597::SetOpportunisticEarlyZHysteresis;
pub use clc597::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use clc597::SetGsMode;
pub use clc597::SetGsModeType;

pub use clc597::SetAliasedLineWidthEnable;

pub use clc597::SetApiMandatedEarlyZ;

pub use clc597::SetGsDmFifo;

pub use clc597::SetL2CacheControlForRopPrefetchReadRequests;
pub use clc597::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clc597::InvalidateShaderCaches;

pub use clc597::SetInstanceCount;

pub use clc597::SetPositionWScaledOffsetEnable;

pub use clc597::SetMultiView;

pub use clc597::SetGoIdleTimeout;

pub use clc597::SetConservativeRasterControl;
pub use clc597::SetConservativeRasterControlExtraPrimBloat;
pub use clc597::SetConservativeRasterControlLineAndPointSnapMode;
pub use clc597::SetConservativeRasterControlTriangleSnapMode;
pub use clc597::SetConservativeRasterControlUncertaintyRegionSize;

pub use clc597::SetMmeVersion;

pub use clc597::SetIndexBufferSizeA;

pub use clc597::SetIndexBufferSizeB;

pub use clc597::SetRootTableVisibility;

pub use clc597::SetDrawControlA;
pub use clc597::SetDrawControlAInstanceId;
pub use clc597::SetDrawControlAPrimitiveId;
pub use clc597::SetDrawControlASplitMode;
pub use clc597::SetDrawControlATopology;

pub use clc597::SetDrawControlB;

pub use clc597::DrawIndexBufferBeginEndA;

pub use clc597::DrawIndexBufferBeginEndB;

pub use clc597::DrawVertexArrayBeginEndA;

pub use clc597::DrawVertexArrayBeginEndB;

pub use clc597::InvalidateRasterCacheNoWfi;

pub use clc597::SetVariablePixelRateSampleOrder;

pub use clc597::SetColorRenderToZetaSurface;

pub use clc597::SetZcullVisiblePrimOptimization;

pub use clc597::IncrementSyncPoint;
pub use clc597::IncrementSyncPointCondition;

pub use clc597::FlushAndInvalidateRopMiniCache;

pub use clc597::SetSurfaceClipIdBlockSize;
pub use clc597::SetSurfaceClipIdBlockSizeDepth;
pub use clc597::SetSurfaceClipIdBlockSizeHeight;
pub use clc597::SetSurfaceClipIdBlockSizeWidth;

pub use clc597::SetAlphaCircularBufferSize;

pub use clc597::DecompressSurface;

pub use clc597::SetZcullRopBypass;

pub use clc597::SetZcullSubregion;

pub use clc597::SetRasterBoundingBox;
pub use clc597::SetRasterBoundingBoxMode;

pub use clc597::PeerSemaphoreRelease;

pub use clc597::SetIteratedBlendOptimization;
pub use clc597::SetIteratedBlendOptimizationNoop;

pub use clc597::SetZcullSubregionAllocation;
pub use clc597::SetZcullSubregionAllocationFormat;

pub use clc597::AssignZcullSubregions;
pub use clc597::AssignZcullSubregionsAlgorithm;

pub use clc597::SetPsOutputSampleMaskUsage;
pub use clc597::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clc597::DrawZeroIndex;

pub use clc597::SetL1Configuration;
pub use clc597::SetL1ConfigurationDirectlyAddressableMemory;

pub use clc597::SetRenderEnableControl;

pub use clc597::SetSpaVersion;

pub use clc597::SetTimesliceBatchLimit;

pub use clc597::SetSnapGridLine;
pub use clc597::SetSnapGridLineLocationsPerPixel;
pub use clc597::SetSnapGridLineRoundingMode;

pub use clc597::SetSnapGridNonLine;
pub use clc597::SetSnapGridNonLineLocationsPerPixel;
pub use clc597::SetSnapGridNonLineRoundingMode;

pub use clc597::SetTessellationParameters;
pub use clc597::SetTessellationParametersDomainType;
pub use clc597::SetTessellationParametersOutputPrimitives;
pub use clc597::SetTessellationParametersSpacing;

pub use clc597::SetTessellationLodU0OrDensity;

pub use clc597::SetTessellationLodV0OrDetail;

pub use clc597::SetTessellationLodU1OrW0;

pub use clc597::SetTessellationLodV1;

pub use clc597::SetTgLodInteriorU;

pub use clc597::SetTgLodInteriorV;

pub use clc597::ReservedTg07;

pub use clc597::ReservedTg08;

pub use clc597::ReservedTg09;

pub use clc597::ReservedTg10;

pub use clc597::ReservedTg11;

pub use clc597::ReservedTg12;

pub use clc597::ReservedTg13;

pub use clc597::ReservedTg14;

pub use clc597::ReservedTg15;

pub use clc597::SetSubtilingPerfKnobA;

pub use clc597::SetSubtilingPerfKnobB;

pub use clc597::SetSubtilingPerfKnobC;

pub use clc597::SetZcullSubregionToReport;

pub use clc597::SetZcullSubregionReportType;
pub use clc597::SetZcullSubregionReportTypeType;

pub use clc597::SetBalancedPrimitiveWorkload;

pub use clc597::SetMaxPatchesPerBatch;

pub use clc597::SetRasterEnable;

pub use clc597::SetStreamOutBufferEnable;

pub use clc597::SetStreamOutBufferAddressA;

pub use clc597::SetStreamOutBufferAddressB;

pub use clc597::SetStreamOutBufferSize;

pub use clc597::SetStreamOutBufferLoadWritePointer;

pub use clc597::SetPositionWScaledOffsetScaleA;

pub use clc597::SetPositionWScaledOffsetScaleB;

pub use clc597::SetPositionWScaledOffsetReservedA;

pub use clc597::SetPositionWScaledOffsetReservedB;

pub use clc597::SetRootTableSelector;

pub use clc597::LoadRootTable;

pub use clc597::SetMmeMemAddressA;

pub use clc597::SetMmeMemAddressB;

pub use clc597::SetMmeDataRamAddress;

pub use clc597::MmeDmaRead;

pub use clc597::MmeDmaReadFifoed;

pub use clc597::MmeDmaWrite;

pub use clc597::MmeDmaReduction;
pub use clc597::MmeDmaReductionReductionFormat;
pub use clc597::MmeDmaReductionReductionOp;
pub use clc597::MmeDmaReductionReductionSize;

pub use clc597::MmeDmaSysmembar;

pub use clc597::MmeDmaSync;

pub use clc597::SetMmeDataFifoConfig;
pub use clc597::SetMmeDataFifoConfigFifoSize;

pub use clc597::SetVertexStreamSizeA;

pub use clc597::SetVertexStreamSizeB;

pub use clc597::SetStreamOutControlStream;

pub use clc597::SetStreamOutControlComponentCount;

pub use clc597::SetStreamOutControlStride;

pub use clc597::SetRasterInput;

pub use clc597::SetStreamOutput;

pub use clc597::SetDaPrimitiveRestartTopologyChange;

pub use clc597::SetHybridAntiAliasControl;
pub use clc597::SetHybridAntiAliasControlCentroid;

pub use clc597::SetShaderLocalMemoryWindow;

pub use clc597::SetShaderLocalMemoryA;

pub use clc597::SetShaderLocalMemoryB;

pub use clc597::SetShaderLocalMemoryC;

pub use clc597::SetShaderLocalMemoryD;

pub use clc597::SetShaderLocalMemoryE;

pub use clc597::SetColorZeroBandwidthClear;

pub use clc597::SetZZeroBandwidthClear;

pub use clc597::SetStencilZeroBandwidthClear;

pub use clc597::SetZcullRegionSizeA;

pub use clc597::SetZcullRegionSizeB;

pub use clc597::SetZcullRegionSizeC;

pub use clc597::SetZcullRegionPixelOffsetC;

pub use clc597::SetCullBeforeFetch;

pub use clc597::SetZcullRegionLocation;

pub use clc597::SetZcullRegionAliquots;

pub use clc597::SetZcullStorageA;

pub use clc597::SetZcullStorageB;

pub use clc597::SetZcullStorageC;

pub use clc597::SetZcullStorageD;

pub use clc597::SetZtReadOnly;

pub use clc597::SetColorTargetA;

pub use clc597::SetColorTargetB;

pub use clc597::SetColorTargetWidth;

pub use clc597::SetColorTargetHeight;

pub use clc597::SetColorTargetFormat;
pub use clc597::SetColorTargetFormatV;

pub use clc597::SetColorTargetMemory;
pub use clc597::SetColorTargetMemoryBlockDepth;
pub use clc597::SetColorTargetMemoryBlockHeight;
pub use clc597::SetColorTargetMemoryBlockWidth;
pub use clc597::SetColorTargetMemoryLayout;
pub use clc597::SetColorTargetMemoryThirdDimensionControl;

pub use clc597::SetColorTargetThirdDimension;

pub use clc597::SetColorTargetArrayPitch;

pub use clc597::SetColorTargetLayer;

pub use clc597::SetColorTargetReservedA;

pub use clc597::SetViewportScaleX;

pub use clc597::SetViewportScaleY;

pub use clc597::SetViewportScaleZ;

pub use clc597::SetViewportOffsetX;

pub use clc597::SetViewportOffsetY;

pub use clc597::SetViewportOffsetZ;

pub use clc597::SetViewportCoordinateSwizzle;
pub use clc597::SetViewportCoordinateSwizzleW;
pub use clc597::SetViewportCoordinateSwizzleX;
pub use clc597::SetViewportCoordinateSwizzleY;
pub use clc597::SetViewportCoordinateSwizzleZ;

pub use clc597::SetViewportIncreaseSnapGridPrecision;

pub use clc597::SetViewportClipHorizontal;

pub use clc597::SetViewportClipVertical;

pub use clc597::SetViewportClipMinZ;

pub use clc597::SetViewportClipMaxZ;

pub use clc597::SetWindowClipHorizontal;

pub use clc597::SetWindowClipVertical;

pub use clc597::SetClipIdExtentX;

pub use clc597::SetClipIdExtentY;

pub use clc597::SetMaxStreamOutputGsInstancesPerTask;

pub use clc597::SetApiVisibleCallLimit;
pub use clc597::SetApiVisibleCallLimitV;

pub use clc597::SetStatisticsCounter;

pub use clc597::SetClearRectHorizontal;

pub use clc597::SetClearRectVertical;

pub use clc597::SetVertexArrayStart;

pub use clc597::DrawVertexArray;

pub use clc597::SetViewportZClip;
pub use clc597::SetViewportZClipRange;

pub use clc597::SetColorClearValue;

pub use clc597::SetZClearValue;

pub use clc597::SetShaderCacheControl;

pub use clc597::ForceTransitionToBeta;

pub use clc597::SetReduceColorThresholdsEnable;

pub use clc597::SetStencilClearValue;

pub use clc597::InvalidateShaderCachesNoWfi;

pub use clc597::SetZcullSerialization;
pub use clc597::SetZcullSerializationApplied;

pub use clc597::SetFrontPolygonMode;
pub use clc597::SetFrontPolygonModeV;

pub use clc597::SetBackPolygonMode;
pub use clc597::SetBackPolygonModeV;

pub use clc597::SetPolySmooth;

pub use clc597::SetZcullDirFormat;
pub use clc597::SetZcullDirFormatZdir;
pub use clc597::SetZcullDirFormatZformat;

pub use clc597::SetPolyOffsetPoint;

pub use clc597::SetPolyOffsetLine;

pub use clc597::SetPolyOffsetFill;

pub use clc597::SetPatch;

pub use clc597::SetIteratedBlend;

pub use clc597::SetIteratedBlendPass;

pub use clc597::SetZcullCriterion;
pub use clc597::SetZcullCriterionSfunc;

pub use clc597::PixelShaderBarrier;

pub use clc597::SetSmTimeoutInterval;

pub use clc597::SetDaPrimitiveRestartVertexArray;

pub use clc597::LoadIteratedBlendInstructionPointer;

pub use clc597::LoadIteratedBlendInstruction;
pub use clc597::LoadIteratedBlendInstructionConstantInputSelect;
pub use clc597::LoadIteratedBlendInstructionOperandASelect;
pub use clc597::LoadIteratedBlendInstructionOperandBSelect;
pub use clc597::LoadIteratedBlendInstructionOperandCSelect;
pub use clc597::LoadIteratedBlendInstructionOperandDSelect;
pub use clc597::LoadIteratedBlendInstructionOperation;
pub use clc597::LoadIteratedBlendInstructionOutputSwizzle;
pub use clc597::LoadIteratedBlendInstructionOutputWriteMask;
pub use clc597::LoadIteratedBlendInstructionPassOutput;
pub use clc597::LoadIteratedBlendInstructionTestCc;

pub use clc597::SetWindowOffsetX;

pub use clc597::SetWindowOffsetY;

pub use clc597::SetScissorEnable;

pub use clc597::SetScissorHorizontal;

pub use clc597::SetScissorVertical;

pub use clc597::SetVpcPerfKnob;

pub use clc597::PmLocalTrigger;

pub use clc597::SetPostZPsImask;

pub use clc597::SetMultiViewRenderTargetArrayIndexOffset;

pub use clc597::SetSpareMultiViewRenderTargetArrayIndexOffset;

pub use clc597::SetConstantColorRendering;

pub use clc597::SetConstantColorRenderingRed;

pub use clc597::SetConstantColorRenderingGreen;

pub use clc597::SetConstantColorRenderingBlue;

pub use clc597::SetConstantColorRenderingAlpha;

pub use clc597::SetBackStencilFuncRef;

pub use clc597::SetBackStencilMask;

pub use clc597::SetBackStencilFuncMask;

pub use clc597::SetVertexStreamSubstituteA;

pub use clc597::SetVertexStreamSubstituteB;

pub use clc597::SetLineModePolygonClip;
pub use clc597::SetLineModePolygonClipGeneratedEdge;

pub use clc597::SetSingleCtWriteControl;

pub use clc597::SetVtgWarpWatermarks;

pub use clc597::SetDepthBoundsMin;

pub use clc597::SetDepthBoundsMax;

pub use clc597::SetSampleMask;

pub use clc597::SetColorTargetSampleMask;

pub use clc597::SetCtMrtEnable;

pub use clc597::SetNonmultisampledZ;
pub use clc597::SetNonmultisampledZV;

pub use clc597::SetTir;
pub use clc597::SetTirMode;

pub use clc597::SetAntiAliasRaster;
pub use clc597::SetAntiAliasRasterSamples;

pub use clc597::SetSampleMaskX0Y0;

pub use clc597::SetSampleMaskX1Y0;

pub use clc597::SetSampleMaskX0Y1;

pub use clc597::SetSampleMaskX1Y1;

pub use clc597::SetSurfaceClipIdMemoryA;

pub use clc597::SetSurfaceClipIdMemoryB;

pub use clc597::SetTirModulation;
pub use clc597::SetTirModulationComponentSelect;

pub use clc597::SetTirModulationFunction;
pub use clc597::SetTirModulationFunctionSelect;

pub use clc597::SetBlendOptControl;

pub use clc597::SetZtA;

pub use clc597::SetZtB;

pub use clc597::SetZtFormat;
pub use clc597::SetZtFormatV;

pub use clc597::SetZtBlockSize;
pub use clc597::SetZtBlockSizeDepth;
pub use clc597::SetZtBlockSizeHeight;
pub use clc597::SetZtBlockSizeWidth;

pub use clc597::SetZtArrayPitch;

pub use clc597::SetSurfaceClipHorizontal;

pub use clc597::SetSurfaceClipVertical;

pub use clc597::SetL2CacheControlForVafRequests;
pub use clc597::SetL2CacheControlForVafRequestsPolicy;

pub use clc597::SetViewportMulticast;
pub use clc597::SetViewportMulticastOrder;

pub use clc597::SetTessellationCutHeight;

pub use clc597::SetMaxGsInstancesPerTask;

pub use clc597::SetMaxGsOutputVerticesPerTask;

pub use clc597::SetReservedSwMethod00;

pub use clc597::SetGsOutputCbStorageMultiplier;

pub use clc597::SetBetaCbStorageConstraint;

pub use clc597::SetTiOutputCbStorageMultiplier;

pub use clc597::SetAlphaCbStorageConstraint;

pub use clc597::SetReservedSwMethod01;

pub use clc597::SetReservedSwMethod02;

pub use clc597::SetTirModulationCoefficientTable;

pub use clc597::SetSpareNoop01;

pub use clc597::SetSpareNoop02;

pub use clc597::SetSpareNoop03;

pub use clc597::SetSpareNoop04;

pub use clc597::SetSpareNoop05;

pub use clc597::SetSpareNoop06;

pub use clc597::SetSpareNoop07;

pub use clc597::SetSpareNoop08;

pub use clc597::SetSpareNoop09;

pub use clc597::SetSpareNoop10;

pub use clc597::SetSpareNoop11;

pub use clc597::SetSpareNoop12;

pub use clc597::SetSpareNoop13;

pub use clc597::SetSpareNoop14;

pub use clc597::SetSpareNoop15;

pub use clc597::SetReservedSwMethod03;

pub use clc597::SetReservedSwMethod04;

pub use clc597::SetReservedSwMethod05;

pub use clc597::SetReservedSwMethod06;

pub use clc597::SetReservedSwMethod07;

pub use clc597::SetReservedSwMethod08;

pub use clc597::SetReservedSwMethod09;

pub use clc597::SetReduceColorThresholdsUnorm8;

pub use clc597::SetReservedSwMethod10;

pub use clc597::SetReservedSwMethod11;

pub use clc597::SetReservedSwMethod12;

pub use clc597::SetReservedSwMethod13;

pub use clc597::SetReduceColorThresholdsUnorm10;

pub use clc597::SetReduceColorThresholdsUnorm16;

pub use clc597::SetReduceColorThresholdsFp11;

pub use clc597::SetReduceColorThresholdsFp16;

pub use clc597::SetReduceColorThresholdsSrgb8;

pub use clc597::UnbindAll;

pub use clc597::SetClearSurfaceControl;

pub use clc597::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clc597::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clc597::SetReservedSwMethod14;

pub use clc597::SetReservedSwMethod15;

pub use clc597::NoOperationDataHi;

pub use clc597::SetDepthBiasControl;

pub use clc597::PmTriggerEnd;

pub use clc597::SetVertexIdBase;

pub use clc597::SetStencilCompression;

pub use clc597::SetDaOutputAttributeSkipMaskA;

pub use clc597::SetDaOutputAttributeSkipMaskB;

pub use clc597::SetTirControl;
pub use clc597::SetTirControlAlphaToCoverageUseRasterSamples;
pub use clc597::SetTirControlReduceCoverage;
pub use clc597::SetTirControlZPassPixelCountUseRasterSamples;

pub use clc597::SetMutableMethodControl;

pub use clc597::SetPostPsInitialCoverage;

pub use clc597::SetFillViaTriangle;
pub use clc597::SetFillViaTriangleMode;

pub use clc597::SetBlendPerFormatEnable;

pub use clc597::FlushPendingWrites;

pub use clc597::SetConservativeRaster;

pub use clc597::SetMeshControl;

pub use clc597::SetMeshShaderA;
pub use clc597::SetMeshShaderAOutputTopology;

pub use clc597::SetMeshShaderB;

pub use clc597::SetMeshInitShader;

pub use clc597::SetVertexAttributeA;
pub use clc597::SetVertexAttributeAComponentBitWidths;
pub use clc597::SetVertexAttributeANumericalType;
pub use clc597::SetVertexAttributeASource;

pub use clc597::SetVertexAttributeB;
pub use clc597::SetVertexAttributeBComponentBitWidths;
pub use clc597::SetVertexAttributeBNumericalType;
pub use clc597::SetVertexAttributeBSource;

pub use clc597::SetAntiAliasSamplePositions;

pub use clc597::SetOffsetRenderTargetIndex;

pub use clc597::ForceHeavyweightMethodSync;

pub use clc597::SetCoverageToColor;

pub use clc597::DecompressZetaSurface;

pub use clc597::SetScreenStateMask;

pub use clc597::SetZtSparse;
pub use clc597::SetZtSparseUnmappedCompare;

pub use clc597::DrawVertexArrayBeginEndInstanceFirst;
pub use clc597::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clc597::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clc597::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clc597::SetCtSelect;

pub use clc597::SetCompressionThreshold;
pub use clc597::SetCompressionThresholdSamples;

pub use clc597::SetPixelShaderInterlockControl;
pub use clc597::SetPixelShaderInterlockControlTileCoalescerFragmentOrder;
pub use clc597::SetPixelShaderInterlockControlTileCoalescerMode;
pub use clc597::SetPixelShaderInterlockControlTileCoalescerTileSize;

pub use clc597::SetZtSizeA;

pub use clc597::SetZtSizeB;

pub use clc597::SetZtSizeC;
pub use clc597::SetZtSizeCControl;

pub use clc597::SetSamplerBinding;
pub use clc597::SetSamplerBindingV;

pub use clc597::DrawAuto;

pub use clc597::SetPostVtgShaderAttributeSkipMask;

pub use clc597::SetPixelShaderTicketDispenserValue;

pub use clc597::SetBackEndCopyA;

pub use clc597::SetBackEndCopyB;

pub use clc597::SetBackEndCopyC;

pub use clc597::SetBackEndCopyD;

pub use clc597::SetBackEndCopyE;

pub use clc597::SetCircularBufferSize;

pub use clc597::SetVtgRegisterWatermarks;

pub use clc597::InvalidateTextureDataCacheNoWfi;
pub use clc597::InvalidateTextureDataCacheNoWfiLines;

pub use clc597::SetL2CacheControlForRopInterlockedReadRequests;
pub use clc597::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clc597::SetDaPrimitiveRestartIndexTopologyChange;

pub use clc597::SetShadingRateIndexSurfaceAddressA;

pub use clc597::SetShadingRateIndexSurfaceAddressB;

pub use clc597::SetShadingRateIndexSurfaceSizeA;

pub use clc597::SetShadingRateIndexSurfaceSizeB;

pub use clc597::SetShadingRateIndexSurfaceLayer;

pub use clc597::SetShadingRateIndexSurfaceArrayPitch;

pub use clc597::SetShadingRateIndexSurfaceBlockSize;
pub use clc597::SetShadingRateIndexSurfaceBlockSizeDepth;
pub use clc597::SetShadingRateIndexSurfaceBlockSizeHeight;
pub use clc597::SetShadingRateIndexSurfaceBlockSizeWidth;

pub use clc597::SetShadingRateIndexSurfaceAllocatedSize;

pub use clc597::ClearZcullRegion;

pub use clc597::SetDepthTest;

pub use clc597::SetFillMode;
pub use clc597::SetFillModeV;

pub use clc597::SetShadeMode;
pub use clc597::SetShadeModeV;

pub use clc597::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clc597::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clc597::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clc597::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clc597::SetAlphaToCoverageDitherControl;
pub use clc597::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clc597::SetBlendStatePerTarget;

pub use clc597::SetDepthWrite;

pub use clc597::SetAlphaTest;

pub use clc597::SetInlineIndex4X8Align;

pub use clc597::DrawInlineIndex4X8;

pub use clc597::D3DSetCullMode;
pub use clc597::D3DSetCullModeV;

pub use clc597::SetDepthFunc;
pub use clc597::SetDepthFuncV;

pub use clc597::SetAlphaRef;

pub use clc597::SetAlphaFunc;
pub use clc597::SetAlphaFuncV;

pub use clc597::SetDrawAutoStride;

pub use clc597::SetBlendConstRed;

pub use clc597::SetBlendConstGreen;

pub use clc597::SetBlendConstBlue;

pub use clc597::SetBlendConstAlpha;

pub use clc597::InvalidateSamplerCache;
pub use clc597::InvalidateSamplerCacheLines;

pub use clc597::InvalidateTextureHeaderCache;
pub use clc597::InvalidateTextureHeaderCacheLines;

pub use clc597::InvalidateTextureDataCache;
pub use clc597::InvalidateTextureDataCacheLines;

pub use clc597::SetBlendSeparateForAlpha;

pub use clc597::SetBlendColorOp;
pub use clc597::SetBlendColorOpV;

pub use clc597::SetBlendColorSourceCoeff;
pub use clc597::SetBlendColorSourceCoeffV;

pub use clc597::SetBlendColorDestCoeff;
pub use clc597::SetBlendColorDestCoeffV;

pub use clc597::SetBlendAlphaOp;
pub use clc597::SetBlendAlphaOpV;

pub use clc597::SetBlendAlphaSourceCoeff;
pub use clc597::SetBlendAlphaSourceCoeffV;

pub use clc597::SetGlobalColorKey;

pub use clc597::SetBlendAlphaDestCoeff;
pub use clc597::SetBlendAlphaDestCoeffV;

pub use clc597::SetSingleRopControl;

pub use clc597::SetBlend;

pub use clc597::SetStencilTest;

pub use clc597::SetStencilOpFail;
pub use clc597::SetStencilOpFailV;

pub use clc597::SetStencilOpZfail;
pub use clc597::SetStencilOpZfailV;

pub use clc597::SetStencilOpZpass;
pub use clc597::SetStencilOpZpassV;

pub use clc597::SetStencilFunc;
pub use clc597::SetStencilFuncV;

pub use clc597::SetStencilFuncRef;

pub use clc597::SetStencilFuncMask;

pub use clc597::SetStencilMask;

pub use clc597::SetDrawAutoStart;

pub use clc597::SetPsSaturate;
pub use clc597::SetPsSaturateClampRange0;
pub use clc597::SetPsSaturateClampRange1;
pub use clc597::SetPsSaturateClampRange2;
pub use clc597::SetPsSaturateClampRange3;
pub use clc597::SetPsSaturateClampRange4;
pub use clc597::SetPsSaturateClampRange5;
pub use clc597::SetPsSaturateClampRange6;
pub use clc597::SetPsSaturateClampRange7;

pub use clc597::SetWindowOrigin;
pub use clc597::SetWindowOriginMode;

pub use clc597::SetLineWidthFloat;

pub use clc597::SetAliasedLineWidthFloat;

pub use clc597::SetLineMultisampleOverride;

pub use clc597::InvalidateSamplerCacheNoWfi;
pub use clc597::InvalidateSamplerCacheNoWfiLines;

pub use clc597::InvalidateTextureHeaderCacheNoWfi;
pub use clc597::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc597::SetGlobalBaseVertexIndex;

pub use clc597::SetGlobalBaseInstanceIndex;

pub use clc597::SetPsWarpWatermarks;

pub use clc597::SetPsRegisterWatermarks;

pub use clc597::StoreZcull;

pub use clc597::SetIteratedBlendConstantRed;

pub use clc597::SetIteratedBlendConstantGreen;

pub use clc597::SetIteratedBlendConstantBlue;

pub use clc597::LoadZcull;

pub use clc597::SetSurfaceClipIdHeight;

pub use clc597::SetClipIdClearRectHorizontal;

pub use clc597::SetClipIdClearRectVertical;

pub use clc597::SetUserClipEnable;

pub use clc597::SetZpassPixelCount;

pub use clc597::SetPointSize;

pub use clc597::SetZcullStats;

pub use clc597::SetPointSprite;

pub use clc597::SetShaderExceptions;

pub use clc597::ClearReportValue;
pub use clc597::ClearReportValueType;

pub use clc597::SetAntiAliasEnable;

pub use clc597::SetZtSelect;

pub use clc597::SetAntiAliasAlphaControl;
pub use clc597::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clc597::SetAntiAliasAlphaControlAlphaToOne;

pub use clc597::SetRenderEnableA;

pub use clc597::SetRenderEnableB;

pub use clc597::SetRenderEnableC;
pub use clc597::SetRenderEnableCMode;

pub use clc597::SetTexSamplerPoolA;

pub use clc597::SetTexSamplerPoolB;

pub use clc597::SetTexSamplerPoolC;

pub use clc597::SetSlopeScaleDepthBias;

pub use clc597::SetAntiAliasedLine;

pub use clc597::SetTexHeaderPoolA;

pub use clc597::SetTexHeaderPoolB;

pub use clc597::SetTexHeaderPoolC;

pub use clc597::SetActiveZcullRegion;

pub use clc597::SetTwoSidedStencilTest;

pub use clc597::SetBackStencilOpFail;
pub use clc597::SetBackStencilOpFailV;

pub use clc597::SetBackStencilOpZfail;
pub use clc597::SetBackStencilOpZfailV;

pub use clc597::SetBackStencilOpZpass;
pub use clc597::SetBackStencilOpZpassV;

pub use clc597::SetBackStencilFunc;
pub use clc597::SetBackStencilFuncV;

pub use clc597::SetSrgbWrite;

pub use clc597::SetDepthBias;

pub use clc597::SetZcullRegionFormat;
pub use clc597::SetZcullRegionFormatType;

pub use clc597::SetRtLayer;
pub use clc597::SetRtLayerControl;

pub use clc597::SetAntiAlias;
pub use clc597::SetAntiAliasSamples;

pub use clc597::SetEdgeFlag;

pub use clc597::DrawInlineIndex;

pub use clc597::SetInlineIndex2X16Align;

pub use clc597::DrawInlineIndex2X16;

pub use clc597::SetVertexGlobalBaseOffsetA;

pub use clc597::SetVertexGlobalBaseOffsetB;

pub use clc597::SetZcullRegionPixelOffsetA;

pub use clc597::SetZcullRegionPixelOffsetB;

pub use clc597::SetPointSpriteSelect;
pub use clc597::SetPointSpriteSelectOrigin;
pub use clc597::SetPointSpriteSelectRmode;
pub use clc597::SetPointSpriteSelectTexture0;
pub use clc597::SetPointSpriteSelectTexture1;
pub use clc597::SetPointSpriteSelectTexture2;
pub use clc597::SetPointSpriteSelectTexture3;
pub use clc597::SetPointSpriteSelectTexture4;
pub use clc597::SetPointSpriteSelectTexture5;
pub use clc597::SetPointSpriteSelectTexture6;
pub use clc597::SetPointSpriteSelectTexture7;
pub use clc597::SetPointSpriteSelectTexture8;
pub use clc597::SetPointSpriteSelectTexture9;

pub use clc597::SetAttributeDefault;
pub use clc597::SetAttributeDefaultColorFrontDiffuse;
pub use clc597::SetAttributeDefaultColorFrontSpecular;
pub use clc597::SetAttributeDefaultDx9Color0;
pub use clc597::SetAttributeDefaultDx9Color1ToColor15;
pub use clc597::SetAttributeDefaultFixedFncTexture;
pub use clc597::SetAttributeDefaultGenericVector;

pub use clc597::End;

pub use clc597::Begin;
pub use clc597::BeginInstanceId;
pub use clc597::BeginOp;
pub use clc597::BeginPrimitiveId;
pub use clc597::BeginSplitMode;

pub use clc597::SetVertexIdCopy;

pub use clc597::AddToPrimitiveId;

pub use clc597::LoadPrimitiveId;

pub use clc597::SetShaderBasedCull;

pub use clc597::SetClassVersion;

pub use clc597::SetDaPrimitiveRestart;

pub use clc597::SetDaPrimitiveRestartIndex;

pub use clc597::SetDaOutput;

pub use clc597::SetAntiAliasedPoint;

pub use clc597::SetPointCenterMode;
pub use clc597::SetPointCenterModeV;

pub use clc597::SetLineSmoothParameters;
pub use clc597::SetLineSmoothParametersFalloff;

pub use clc597::SetLineStipple;

pub use clc597::SetLineSmoothEdgeTable;

pub use clc597::SetLineStippleParameters;

pub use clc597::SetProvokingVertex;
pub use clc597::SetProvokingVertexV;

pub use clc597::SetTwoSidedLight;

pub use clc597::SetPolygonStipple;

pub use clc597::SetShaderControl;
pub use clc597::SetShaderControlDefaultPartial;
pub use clc597::SetShaderControlFp32F2INanBehavior;
pub use clc597::SetShaderControlFp32NanBehavior;

pub use clc597::CheckClassVersion;

pub use clc597::SetSphVersion;

pub use clc597::CheckSphVersion;

pub use clc597::SetAlphaToCoverageOverride;
pub use clc597::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clc597::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use clc597::SetScgGraphicsPriority;

pub use clc597::SetScgGraphicsSchedulingParameters;

pub use clc597::SetPolygonStipplePattern;

pub use clc597::SetAamVersion;

pub use clc597::CheckAamVersion;

pub use clc597::SetZtLayer;

pub use clc597::SetIndexBufferA;

pub use clc597::SetIndexBufferB;

pub use clc597::SetIndexBufferE;
pub use clc597::SetIndexBufferEIndexSize;

pub use clc597::SetIndexBufferF;

pub use clc597::DrawIndexBuffer;

pub use clc597::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clc597::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clc597::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clc597::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clc597::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clc597::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clc597::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clc597::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clc597::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clc597::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clc597::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clc597::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clc597::SetDepthBiasClamp;

pub use clc597::SetVertexStreamInstanceA;

pub use clc597::SetVertexStreamInstanceB;

pub use clc597::SetAttributePointSize;

pub use clc597::OglSetCull;

pub use clc597::OglSetFrontFace;
pub use clc597::OglSetFrontFaceV;

pub use clc597::OglSetCullFace;
pub use clc597::OglSetCullFaceV;

pub use clc597::SetViewportPixel;
pub use clc597::SetViewportPixelCenter;

pub use clc597::SetViewportScaleOffset;

pub use clc597::SetViewportClipControl;
pub use clc597::SetViewportClipControlGeometryClip;
pub use clc597::SetViewportClipControlGeometryGuardband;
pub use clc597::SetViewportClipControlGeometryGuardbandZ;
pub use clc597::SetViewportClipControlLinePointCullGuardband;
pub use clc597::SetViewportClipControlPixelMaxZ;
pub use clc597::SetViewportClipControlPixelMinZ;
pub use clc597::SetViewportClipControlZClipRange;

pub use clc597::SetUserClipOp;
pub use clc597::SetUserClipOpPlane0;
pub use clc597::SetUserClipOpPlane1;
pub use clc597::SetUserClipOpPlane2;
pub use clc597::SetUserClipOpPlane3;
pub use clc597::SetUserClipOpPlane4;
pub use clc597::SetUserClipOpPlane5;
pub use clc597::SetUserClipOpPlane6;
pub use clc597::SetUserClipOpPlane7;

pub use clc597::SetRenderEnableOverride;
pub use clc597::SetRenderEnableOverrideMode;

pub use clc597::SetPrimitiveTopologyControl;
pub use clc597::SetPrimitiveTopologyControlOverride;

pub use clc597::SetWindowClipEnable;

pub use clc597::SetWindowClipType;
pub use clc597::SetWindowClipTypeV;

pub use clc597::InvalidateZcull;
pub use clc597::InvalidateZcullV;

pub use clc597::SetZcull;

pub use clc597::SetZcullBounds;

pub use clc597::SetPrimitiveTopology;
pub use clc597::SetPrimitiveTopologyV;

pub use clc597::ZcullSync;

pub use clc597::SetClipIdTest;

pub use clc597::SetSurfaceClipIdWidth;

pub use clc597::SetClipId;

pub use clc597::SetDepthBoundsTest;

pub use clc597::SetBlendFloatOption;

pub use clc597::SetLogicOp;

pub use clc597::SetLogicOpFunc;
pub use clc597::SetLogicOpFuncV;

pub use clc597::SetZCompression;

pub use clc597::ClearSurface;

pub use clc597::ClearClipIdSurface;

pub use clc597::SetColorCompression;

pub use clc597::SetCtWrite;

pub use clc597::PipeNop;

pub use clc597::SetSpare00;

pub use clc597::SetSpare01;

pub use clc597::SetSpare02;

pub use clc597::SetSpare03;

pub use clc597::SetReportSemaphoreA;

pub use clc597::SetReportSemaphoreB;

pub use clc597::SetReportSemaphoreC;

pub use clc597::SetReportSemaphoreD;
pub use clc597::SetReportSemaphoreDAcquire;
pub use clc597::SetReportSemaphoreDComparison;
pub use clc597::SetReportSemaphoreDOperation;
pub use clc597::SetReportSemaphoreDPipelineLocation;
pub use clc597::SetReportSemaphoreDReductionFormat;
pub use clc597::SetReportSemaphoreDReductionOp;
pub use clc597::SetReportSemaphoreDRelease;
pub use clc597::SetReportSemaphoreDReport;
pub use clc597::SetReportSemaphoreDStructureSize;

pub use clc597::SetVertexStreamAFormat;

pub use clc597::SetVertexStreamALocationA;

pub use clc597::SetVertexStreamALocationB;

pub use clc597::SetVertexStreamAFrequency;

pub use clc597::SetVertexStreamBFormat;

pub use clc597::SetVertexStreamBLocationA;

pub use clc597::SetVertexStreamBLocationB;

pub use clc597::SetVertexStreamBFrequency;

pub use clc597::SetBlendPerTargetSeparateForAlpha;

pub use clc597::SetBlendPerTargetColorOp;
pub use clc597::SetBlendPerTargetColorOpV;

pub use clc597::SetBlendPerTargetColorSourceCoeff;
pub use clc597::SetBlendPerTargetColorSourceCoeffV;

pub use clc597::SetBlendPerTargetColorDestCoeff;
pub use clc597::SetBlendPerTargetColorDestCoeffV;

pub use clc597::SetBlendPerTargetAlphaOp;
pub use clc597::SetBlendPerTargetAlphaOpV;

pub use clc597::SetBlendPerTargetAlphaSourceCoeff;
pub use clc597::SetBlendPerTargetAlphaSourceCoeffV;

pub use clc597::SetBlendPerTargetAlphaDestCoeff;
pub use clc597::SetBlendPerTargetAlphaDestCoeffV;

pub use clc597::SetPipelineShader;
pub use clc597::SetPipelineShaderType;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineReservedB {
    pub v: u32,
}

impl ArrayMthd for SetPipelineReservedB {
    const CLASS: u16 = 0xc697;

    fn addr(i: usize) -> u16 {
        (0x2004 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc597::SetPipelineReservedA;

pub use clc597::SetPipelineRegisterCount;

pub use clc597::SetPipelineBinding;

pub use clc597::SetPipelineProgramAddressA;

pub use clc597::SetPipelineProgramAddressB;

pub use clc597::SetPipelineReservedD;

pub use clc597::SetPipelineReservedE;

pub use clc597::SetFalcon00;

pub use clc597::SetFalcon01;

pub use clc597::SetFalcon02;

pub use clc597::SetFalcon03;

pub use clc597::SetFalcon04;

pub use clc597::SetFalcon05;

pub use clc597::SetFalcon06;

pub use clc597::SetFalcon07;

pub use clc597::SetFalcon08;

pub use clc597::SetFalcon09;

pub use clc597::SetFalcon10;

pub use clc597::SetFalcon11;

pub use clc597::SetFalcon12;

pub use clc597::SetFalcon13;

pub use clc597::SetFalcon14;

pub use clc597::SetFalcon15;

pub use clc597::SetFalcon16;

pub use clc597::SetFalcon17;

pub use clc597::SetFalcon18;

pub use clc597::SetFalcon19;

pub use clc597::SetFalcon20;

pub use clc597::SetFalcon21;

pub use clc597::SetFalcon22;

pub use clc597::SetFalcon23;

pub use clc597::SetFalcon24;

pub use clc597::SetFalcon25;

pub use clc597::SetFalcon26;

pub use clc597::SetFalcon27;

pub use clc597::SetFalcon28;

pub use clc597::SetFalcon29;

pub use clc597::SetFalcon30;

pub use clc597::SetFalcon31;

pub use clc597::SetConstantBufferSelectorA;

pub use clc597::SetConstantBufferSelectorB;

pub use clc597::SetConstantBufferSelectorC;

pub use clc597::LoadConstantBufferOffset;

pub use clc597::LoadConstantBuffer;

pub use clc597::BindGroupReservedA;

pub use clc597::BindGroupReservedB;

pub use clc597::BindGroupReservedC;

pub use clc597::BindGroupReservedD;

pub use clc597::BindGroupConstantBuffer;

pub use clc597::SetTrapHandlerA;

pub use clc597::SetTrapHandlerB;

pub use clc597::SetColorClamp;

pub use clc597::SetVariablePixelRateShadingControl;

pub use clc597::SetVariablePixelRateShadingIndexToRateA;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex0;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex1;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex2;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex3;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex4;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex5;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex6;
pub use clc597::SetVariablePixelRateShadingIndexToRateARateIndex7;

pub use clc597::SetVariablePixelRateShadingIndexToRateB;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex10;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex11;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex12;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex13;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex14;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex15;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex8;
pub use clc597::SetVariablePixelRateShadingIndexToRateBRateIndex9;

pub use clc597::SetVariablePixelRateShadingReservedA;

pub use clc597::SetShaderPerformanceSnapshotCounterValue;

pub use clc597::SetShaderPerformanceSnapshotCounterValueUpper;

pub use clc597::EnableShaderPerformanceSnapshotCounter;

pub use clc597::DisableShaderPerformanceSnapshotCounter;

pub use clc597::SetShaderPerformanceCounterValueUpper;

pub use clc597::SetShaderPerformanceCounterValue;

pub use clc597::SetShaderPerformanceCounterEvent;

pub use clc597::SetShaderPerformanceCounterControlA;

pub use clc597::SetShaderPerformanceCounterControlB;

pub use clc597::SetShaderPerformanceCounterTrapControl;

pub use clc597::StartShaderPerformanceCounter;

pub use clc597::StopShaderPerformanceCounter;

pub use clc597::SetShaderPerformanceCounterSctlFilter;

pub use clc597::SetShaderPerformanceCounterCoreMioFilter;

pub use clc597::SetMmeShadowScratch;

pub use clc597::CallMmeMacro;

pub use clc597::CallMmeData;
