use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc3c0::mthd as clc3c0;

// parsed class NVC5C0

pub use clc3c0::SetObject;

pub use clc3c0::NoOperation;

pub use clc3c0::SetNotifyA;

pub use clc3c0::SetNotifyB;

pub use clc3c0::Notify;
pub use clc3c0::NotifyType;

pub use clc3c0::WaitForIdle;

pub use clc3c0::SetGlobalRenderEnableA;

pub use clc3c0::SetGlobalRenderEnableB;

pub use clc3c0::SetGlobalRenderEnableC;
pub use clc3c0::SetGlobalRenderEnableCMode;

pub use clc3c0::SendGoIdle;

pub use clc3c0::PmTrigger;

pub use clc3c0::PmTriggerWfi;

pub use clc3c0::FeAtomicSequenceBegin;

pub use clc3c0::FeAtomicSequenceEnd;

pub use clc3c0::SetInstrumentationMethodHeader;

pub use clc3c0::SetInstrumentationMethodData;

pub use clc3c0::LineLengthIn;

pub use clc3c0::LineCount;

pub use clc3c0::OffsetOutUpper;

pub use clc3c0::OffsetOut;

pub use clc3c0::PitchOut;

pub use clc3c0::SetDstBlockSize;
pub use clc3c0::SetDstBlockSizeDepth;
pub use clc3c0::SetDstBlockSizeHeight;
pub use clc3c0::SetDstBlockSizeWidth;

pub use clc3c0::SetDstWidth;

pub use clc3c0::SetDstHeight;

pub use clc3c0::SetDstDepth;

pub use clc3c0::SetDstLayer;

pub use clc3c0::SetDstOriginBytesX;

pub use clc3c0::SetDstOriginSamplesY;

pub use clc3c0::LaunchDma;
pub use clc3c0::LaunchDmaCompletionType;
pub use clc3c0::LaunchDmaDstMemoryLayout;
pub use clc3c0::LaunchDmaInterruptType;
pub use clc3c0::LaunchDmaReductionFormat;
pub use clc3c0::LaunchDmaReductionOp;
pub use clc3c0::LaunchDmaSemaphoreStructSize;

pub use clc3c0::LoadInlineData;

pub use clc3c0::SetI2MSemaphoreA;

pub use clc3c0::SetI2MSemaphoreB;

pub use clc3c0::SetI2MSemaphoreC;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmScgControl {
    pub compute_in_graphics: bool,
}

impl Mthd for SetSmScgControl {
    const ADDR: u16 = 0x01e8;
    const CLASS: u16 = 0xc5c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.compute_in_graphics as u32) < (1 << 1));
        val |= (self.compute_in_graphics as u32) << 0;

        val
    }
}

pub use clc3c0::SetI2MSpareNoop00;

pub use clc3c0::SetI2MSpareNoop01;

pub use clc3c0::SetI2MSpareNoop02;

pub use clc3c0::SetI2MSpareNoop03;

pub use clc3c0::SetValidSpanOverflowAreaA;

pub use clc3c0::SetValidSpanOverflowAreaB;

pub use clc3c0::SetValidSpanOverflowAreaC;

pub use clc3c0::PerfmonTransfer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationBaseA {
    pub address_upper: u32,
}

impl Mthd for SetQmdVirtualizationBaseA {
    const ADDR: u16 = 0x0214;
    const CLASS: u16 = 0xc5c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationBaseB {
    pub address_lower: u32,
}

impl Mthd for SetQmdVirtualizationBaseB {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xc5c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

pub use clc3c0::InvalidateShaderCaches;

pub use clc3c0::SetReservedSwMethod00;

pub use clc3c0::SetReservedSwMethod01;

pub use clc3c0::SetReservedSwMethod02;

pub use clc3c0::SetReservedSwMethod03;

pub use clc3c0::SetReservedSwMethod04;

pub use clc3c0::SetReservedSwMethod05;

pub use clc3c0::SetReservedSwMethod06;

pub use clc3c0::SetReservedSwMethod07;

pub use clc3c0::InvalidateTextureHeaderCacheNoWfi;
pub use clc3c0::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc3c0::SetCwdRefCounter;

pub use clc3c0::SetReservedSwMethod08;

pub use clc3c0::SetReservedSwMethod09;

pub use clc3c0::SetReservedSwMethod10;

pub use clc3c0::SetReservedSwMethod11;

pub use clc3c0::SetReservedSwMethod12;

pub use clc3c0::SetReservedSwMethod13;

pub use clc3c0::SetReservedSwMethod14;

pub use clc3c0::SetReservedSwMethod15;

pub use clc3c0::SetScgControl;

pub use clc3c0::SetComputeClassVersion;

pub use clc3c0::CheckComputeClassVersion;

pub use clc3c0::SetQmdVersion;

pub use clc3c0::CheckQmdVersion;

pub use clc3c0::InvalidateSkedCaches;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVirtualizationControl {
    pub constant_buffer_mask: u32,
    pub i2m_addr_enable: bool,
    pub i2m_constant_buffer_enable: bool,
    pub iq2m_addr_enable: bool,
    pub iq2m_constant_buffer_enable: bool,
    pub send_pcas_enable: bool,
}

impl Mthd for SetQmdVirtualizationControl {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0xc5c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.constant_buffer_mask < (1 << 8));
        val |= self.constant_buffer_mask << 0;

        assert!((self.i2m_addr_enable as u32) < (1 << 1));
        val |= (self.i2m_addr_enable as u32) << 8;

        assert!((self.i2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.i2m_constant_buffer_enable as u32) << 12;

        assert!((self.iq2m_addr_enable as u32) < (1 << 1));
        val |= (self.iq2m_addr_enable as u32) << 16;

        assert!((self.iq2m_constant_buffer_enable as u32) < (1 << 1));
        val |= (self.iq2m_constant_buffer_enable as u32) << 20;

        assert!((self.send_pcas_enable as u32) < (1 << 1));
        val |= (self.send_pcas_enable as u32) << 24;

        val
    }
}

pub use clc3c0::SetShaderSharedMemoryWindowA;

pub use clc3c0::SetShaderSharedMemoryWindowB;

pub use clc3c0::ScgHysteresisControl;

pub use clc3c0::SetCwdSlotCount;

pub use clc3c0::SendPcasA;

pub use clc3c0::SendPcasB;

pub use clc3c0::SendSignalingPcasB;

pub use clc3c0::SetSkedCacheControl;

pub use clc3c0::SetShaderLocalMemoryNonThrottledA;

pub use clc3c0::SetShaderLocalMemoryNonThrottledB;

pub use clc3c0::SetShaderLocalMemoryNonThrottledC;

pub use clc3c0::SetSpaVersion;

pub use clc3c0::SetInlineQmdAddressA;

pub use clc3c0::SetInlineQmdAddressB;

pub use clc3c0::LoadInlineQmdData;

pub use clc3c0::SetFalcon00;

pub use clc3c0::SetFalcon01;

pub use clc3c0::SetFalcon02;

pub use clc3c0::SetFalcon03;

pub use clc3c0::SetFalcon04;

pub use clc3c0::SetFalcon05;

pub use clc3c0::SetFalcon06;

pub use clc3c0::SetFalcon07;

pub use clc3c0::SetFalcon08;

pub use clc3c0::SetFalcon09;

pub use clc3c0::SetFalcon10;

pub use clc3c0::SetFalcon11;

pub use clc3c0::SetFalcon12;

pub use clc3c0::SetFalcon13;

pub use clc3c0::SetFalcon14;

pub use clc3c0::SetFalcon15;

pub use clc3c0::SetFalcon16;

pub use clc3c0::SetFalcon17;

pub use clc3c0::SetFalcon18;

pub use clc3c0::SetFalcon19;

pub use clc3c0::SetFalcon20;

pub use clc3c0::SetFalcon21;

pub use clc3c0::SetFalcon22;

pub use clc3c0::SetFalcon23;

pub use clc3c0::SetFalcon24;

pub use clc3c0::SetFalcon25;

pub use clc3c0::SetFalcon26;

pub use clc3c0::SetFalcon27;

pub use clc3c0::SetFalcon28;

pub use clc3c0::SetFalcon29;

pub use clc3c0::SetFalcon30;

pub use clc3c0::SetFalcon31;

pub use clc3c0::SetShaderLocalMemoryA;

pub use clc3c0::SetShaderLocalMemoryB;

pub use clc3c0::SetShaderLocalMemoryWindowA;

pub use clc3c0::SetShaderLocalMemoryWindowB;

pub use clc3c0::SetShaderCacheControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgComputeSchedulingParameters {
    pub v: u32,
}

impl ArrayMthd for SetScgComputeSchedulingParameters {
    const CLASS: u16 = 0xc5c0;

    fn addr(i: usize) -> u16 {
        (0x0da0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc3c0::SetSmTimeoutInterval;

pub use clc3c0::InvalidateTextureDataCacheNoWfi;
pub use clc3c0::InvalidateTextureDataCacheNoWfiLines;

pub use clc3c0::ActivatePerfSettingsForComputeContext;

pub use clc3c0::InvalidateSamplerCache;
pub use clc3c0::InvalidateSamplerCacheLines;

pub use clc3c0::InvalidateTextureHeaderCache;
pub use clc3c0::InvalidateTextureHeaderCacheLines;

pub use clc3c0::InvalidateTextureDataCache;
pub use clc3c0::InvalidateTextureDataCacheLines;

pub use clc3c0::InvalidateSamplerCacheNoWfi;
pub use clc3c0::InvalidateSamplerCacheNoWfiLines;

pub use clc3c0::SetShaderExceptions;

pub use clc3c0::SetRenderEnableA;

pub use clc3c0::SetRenderEnableB;

pub use clc3c0::SetRenderEnableC;
pub use clc3c0::SetRenderEnableCMode;

pub use clc3c0::SetTexSamplerPoolA;

pub use clc3c0::SetTexSamplerPoolB;

pub use clc3c0::SetTexSamplerPoolC;

pub use clc3c0::SetTexHeaderPoolA;

pub use clc3c0::SetTexHeaderPoolB;

pub use clc3c0::SetTexHeaderPoolC;

pub use clc3c0::InvalidateShaderCachesNoWfi;

pub use clc3c0::SetRenderEnableOverride;
pub use clc3c0::SetRenderEnableOverrideMode;

pub use clc3c0::PipeNop;

pub use clc3c0::SetSpare00;

pub use clc3c0::SetSpare01;

pub use clc3c0::SetSpare02;

pub use clc3c0::SetSpare03;

pub use clc3c0::SetReportSemaphoreA;

pub use clc3c0::SetReportSemaphoreB;

pub use clc3c0::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub awaken_enable: bool,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
    pub conditional_trap: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xc5c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        assert!((self.conditional_trap as u32) < (1 << 1));
        val |= (self.conditional_trap as u32) << 19;

        val
    }
}

pub use clc3c0::SetTrapHandlerA;

pub use clc3c0::SetTrapHandlerB;

pub use clc3c0::SetBindlessTexture;

pub use clc3c0::SetShaderPerformanceSnapshotCounterValue;

pub use clc3c0::SetShaderPerformanceSnapshotCounterValueUpper;

pub use clc3c0::EnableShaderPerformanceSnapshotCounter;

pub use clc3c0::DisableShaderPerformanceSnapshotCounter;

pub use clc3c0::SetShaderPerformanceCounterValueUpper;

pub use clc3c0::SetShaderPerformanceCounterValue;

pub use clc3c0::SetShaderPerformanceCounterEvent;

pub use clc3c0::SetShaderPerformanceCounterControlA;

pub use clc3c0::SetShaderPerformanceCounterControlB;

pub use clc3c0::SetShaderPerformanceCounterTrapControl;

pub use clc3c0::StartShaderPerformanceCounter;

pub use clc3c0::StopShaderPerformanceCounter;

pub use clc3c0::SetShaderPerformanceCounterSctlFilter;

pub use clc3c0::SetShaderPerformanceCounterCoreMioFilter;

pub use clc3c0::SetMmeShadowScratch;
