use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc397::mthd as clc397;

// parsed class NVC597

pub use clc397::SetObject;

pub use clc397::NoOperation;

pub use clc397::SetNotifyA;

pub use clc397::SetNotifyB;

pub use clc397::Notify;
pub use clc397::NotifyType;

pub use clc397::WaitForIdle;

pub use clc397::LoadMmeInstructionRamPointer;

pub use clc397::LoadMmeInstructionRam;

pub use clc397::LoadMmeStartAddressRamPointer;

pub use clc397::LoadMmeStartAddressRam;

pub use clc397::SetMmeShadowRamControl;
pub use clc397::SetMmeShadowRamControlMode;

pub use clc397::PeerSemaphoreReleaseOffsetUpper;

pub use clc397::PeerSemaphoreReleaseOffset;

pub use clc397::SetGlobalRenderEnableA;

pub use clc397::SetGlobalRenderEnableB;

pub use clc397::SetGlobalRenderEnableC;
pub use clc397::SetGlobalRenderEnableCMode;

pub use clc397::SendGoIdle;

pub use clc397::PmTrigger;

pub use clc397::PmTriggerWfi;

pub use clc397::FeAtomicSequenceBegin;

pub use clc397::FeAtomicSequenceEnd;

pub use clc397::SetInstrumentationMethodHeader;

pub use clc397::SetInstrumentationMethodData;

pub use clc397::LineLengthIn;

pub use clc397::LineCount;

pub use clc397::OffsetOutUpper;

pub use clc397::OffsetOut;

pub use clc397::PitchOut;

pub use clc397::SetDstBlockSize;
pub use clc397::SetDstBlockSizeDepth;
pub use clc397::SetDstBlockSizeHeight;
pub use clc397::SetDstBlockSizeWidth;

pub use clc397::SetDstWidth;

pub use clc397::SetDstHeight;

pub use clc397::SetDstDepth;

pub use clc397::SetDstLayer;

pub use clc397::SetDstOriginBytesX;

pub use clc397::SetDstOriginSamplesY;

pub use clc397::LaunchDma;
pub use clc397::LaunchDmaCompletionType;
pub use clc397::LaunchDmaDstMemoryLayout;
pub use clc397::LaunchDmaInterruptType;
pub use clc397::LaunchDmaReductionFormat;
pub use clc397::LaunchDmaReductionOp;
pub use clc397::LaunchDmaSemaphoreStructSize;

pub use clc397::LoadInlineData;

pub use clc397::SetI2MSemaphoreA;

pub use clc397::SetI2MSemaphoreB;

pub use clc397::SetI2MSemaphoreC;

pub use clc397::SetI2MSpareNoop00;

pub use clc397::SetI2MSpareNoop01;

pub use clc397::SetI2MSpareNoop02;

pub use clc397::SetI2MSpareNoop03;

pub use clc397::RunDsNow;

pub use clc397::SetOpportunisticEarlyZHysteresis;
pub use clc397::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use clc397::SetGsMode;
pub use clc397::SetGsModeType;

pub use clc397::SetAliasedLineWidthEnable;

pub use clc397::SetApiMandatedEarlyZ;

pub use clc397::SetGsDmFifo;

pub use clc397::SetL2CacheControlForRopPrefetchReadRequests;
pub use clc397::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clc397::InvalidateShaderCaches;

pub use clc397::SetInstanceCount;

pub use clc397::SetPositionWScaledOffsetEnable;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMultiView {
    pub view_count: u32,
    pub render_target_index_offset: u32,
    pub independent_viewport_mask_enable: bool,
    pub second_x_only: bool,
}

impl Mthd for SetMultiView {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.view_count < (1 << 4));
        val |= self.view_count << 0;

        assert!(self.render_target_index_offset < (1 << 11));
        val |= self.render_target_index_offset << 4;

        assert!((self.independent_viewport_mask_enable as u32) < (1 << 1));
        val |= (self.independent_viewport_mask_enable as u32) << 16;

        assert!((self.second_x_only as u32) < (1 << 1));
        val |= (self.second_x_only as u32) << 15;

        val
    }
}

pub use clc397::SetGoIdleTimeout;

pub use clc397::SetConservativeRasterControl;
pub use clc397::SetConservativeRasterControlExtraPrimBloat;
pub use clc397::SetConservativeRasterControlLineAndPointSnapMode;
pub use clc397::SetConservativeRasterControlTriangleSnapMode;
pub use clc397::SetConservativeRasterControlUncertaintyRegionSize;

pub use clc397::SetMmeVersion;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferSizeA {
    pub upper: u32,
}

impl Mthd for SetIndexBufferSizeA {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIndexBufferSizeB {
    pub lower: u32,
}

impl Mthd for SetIndexBufferSizeB {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRootTableVisibility {
    pub binding_group0_enable: u32,
    pub binding_group1_enable: u32,
    pub binding_group2_enable: u32,
    pub binding_group3_enable: u32,
    pub binding_group4_enable: u32,
}

impl ArrayMthd for SetRootTableVisibility {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0240 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.binding_group0_enable < (1 << 2));
        val |= self.binding_group0_enable << 0;

        assert!(self.binding_group1_enable < (1 << 2));
        val |= self.binding_group1_enable << 4;

        assert!(self.binding_group2_enable < (1 << 2));
        val |= self.binding_group2_enable << 8;

        assert!(self.binding_group3_enable < (1 << 2));
        val |= self.binding_group3_enable << 12;

        assert!(self.binding_group4_enable < (1 << 2));
        val |= self.binding_group4_enable << 16;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDrawControlATopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDrawControlAPrimitiveId {
    First = 0x00000000,
    Unchanged = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDrawControlAInstanceId {
    First = 0x00000000,
    Subsequent = 0x00000001,
    Unchanged = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDrawControlASplitMode {
    NormalBeginNormalEnd = 0x00000000,
    NormalBeginOpenEnd = 0x00000001,
    OpenBeginOpenEnd = 0x00000002,
    OpenBeginNormalEnd = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawControlA {
    pub topology: SetDrawControlATopology,
    pub primitive_id: SetDrawControlAPrimitiveId,
    pub instance_id: SetDrawControlAInstanceId,
    pub split_mode: SetDrawControlASplitMode,
    pub instance_iterate_enable: bool,
    pub ignore_global_base_vertex_index: bool,
    pub ignore_global_base_instance_index: bool,
}

impl Mthd for SetDrawControlA {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.topology as u32) < (1 << 4));
        val |= (self.topology as u32) << 0;

        assert!((self.primitive_id as u32) < (1 << 1));
        val |= (self.primitive_id as u32) << 4;

        assert!((self.instance_id as u32) < (1 << 2));
        val |= (self.instance_id as u32) << 5;

        assert!((self.split_mode as u32) < (1 << 2));
        val |= (self.split_mode as u32) << 7;

        assert!((self.instance_iterate_enable as u32) < (1 << 1));
        val |= (self.instance_iterate_enable as u32) << 9;

        assert!((self.ignore_global_base_vertex_index as u32) < (1 << 1));
        val |= (self.ignore_global_base_vertex_index as u32) << 10;

        assert!((self.ignore_global_base_instance_index as u32) < (1 << 1));
        val |= (self.ignore_global_base_instance_index as u32) << 11;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDrawControlB {
    pub instance_count: u32,
}

impl Mthd for SetDrawControlB {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.instance_count;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBufferBeginEndA {
    pub first: u32,
}

impl Mthd for DrawIndexBufferBeginEndA {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.first;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawIndexBufferBeginEndB {
    pub count: u32,
}

impl Mthd for DrawIndexBufferBeginEndB {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.count;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndA {
    pub start: u32,
}

impl Mthd for DrawVertexArrayBeginEndA {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.start;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DrawVertexArrayBeginEndB {
    pub count: u32,
}

impl Mthd for DrawVertexArrayBeginEndB {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.count;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateRasterCacheNoWfi {
    pub v: u32,
}

impl Mthd for InvalidateRasterCacheNoWfi {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateSampleOrder {
    pub v: u32,
}

impl ArrayMthd for SetVariablePixelRateSampleOrder {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0280 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorRenderToZetaSurface {
    pub v: bool,
}

impl Mthd for SetColorRenderToZetaSurface {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullVisiblePrimOptimization {
    pub v: bool,
}

impl Mthd for SetZcullVisiblePrimOptimization {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

pub use clc397::IncrementSyncPoint;
pub use clc397::IncrementSyncPointCondition;

pub use clc397::FlushAndInvalidateRopMiniCache;

pub use clc397::SetSurfaceClipIdBlockSize;
pub use clc397::SetSurfaceClipIdBlockSizeDepth;
pub use clc397::SetSurfaceClipIdBlockSizeHeight;
pub use clc397::SetSurfaceClipIdBlockSizeWidth;

pub use clc397::SetAlphaCircularBufferSize;

pub use clc397::DecompressSurface;

pub use clc397::SetZcullRopBypass;

pub use clc397::SetZcullSubregion;

pub use clc397::SetRasterBoundingBox;
pub use clc397::SetRasterBoundingBoxMode;

pub use clc397::PeerSemaphoreRelease;

pub use clc397::SetIteratedBlendOptimization;
pub use clc397::SetIteratedBlendOptimizationNoop;

pub use clc397::SetZcullSubregionAllocation;
pub use clc397::SetZcullSubregionAllocationFormat;

pub use clc397::AssignZcullSubregions;
pub use clc397::AssignZcullSubregionsAlgorithm;

pub use clc397::SetPsOutputSampleMaskUsage;
pub use clc397::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clc397::DrawZeroIndex;

pub use clc397::SetL1Configuration;
pub use clc397::SetL1ConfigurationDirectlyAddressableMemory;

pub use clc397::SetRenderEnableControl;

pub use clc397::SetSpaVersion;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTimesliceBatchLimit {
    pub batch_limit: u32,
}

impl Mthd for SetTimesliceBatchLimit {
    const ADDR: u16 = 0x0314;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.batch_limit < (1 << 16));
        val |= self.batch_limit << 0;

        val
    }
}

pub use clc397::SetSnapGridLine;
pub use clc397::SetSnapGridLineLocationsPerPixel;
pub use clc397::SetSnapGridLineRoundingMode;

pub use clc397::SetSnapGridNonLine;
pub use clc397::SetSnapGridNonLineLocationsPerPixel;
pub use clc397::SetSnapGridNonLineRoundingMode;

pub use clc397::SetTessellationParameters;
pub use clc397::SetTessellationParametersDomainType;
pub use clc397::SetTessellationParametersOutputPrimitives;
pub use clc397::SetTessellationParametersSpacing;

pub use clc397::SetTessellationLodU0OrDensity;

pub use clc397::SetTessellationLodV0OrDetail;

pub use clc397::SetTessellationLodU1OrW0;

pub use clc397::SetTessellationLodV1;

pub use clc397::SetTgLodInteriorU;

pub use clc397::SetTgLodInteriorV;

pub use clc397::ReservedTg07;

pub use clc397::ReservedTg08;

pub use clc397::ReservedTg09;

pub use clc397::ReservedTg10;

pub use clc397::ReservedTg11;

pub use clc397::ReservedTg12;

pub use clc397::ReservedTg13;

pub use clc397::ReservedTg14;

pub use clc397::ReservedTg15;

pub use clc397::SetSubtilingPerfKnobA;

pub use clc397::SetSubtilingPerfKnobB;

pub use clc397::SetSubtilingPerfKnobC;

pub use clc397::SetZcullSubregionToReport;

pub use clc397::SetZcullSubregionReportType;
pub use clc397::SetZcullSubregionReportTypeType;

pub use clc397::SetBalancedPrimitiveWorkload;

pub use clc397::SetMaxPatchesPerBatch;

pub use clc397::SetRasterEnable;

pub use clc397::SetStreamOutBufferEnable;

pub use clc397::SetStreamOutBufferAddressA;

pub use clc397::SetStreamOutBufferAddressB;

pub use clc397::SetStreamOutBufferSize;

pub use clc397::SetStreamOutBufferLoadWritePointer;

pub use clc397::SetPositionWScaledOffsetScaleA;

pub use clc397::SetPositionWScaledOffsetScaleB;

pub use clc397::SetPositionWScaledOffsetReservedA;

pub use clc397::SetPositionWScaledOffsetReservedB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetRootTableSelector {
    pub root_table: u32,
    pub offset: u32,
}

impl Mthd for SetRootTableSelector {
    const ADDR: u16 = 0x0504;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.root_table < (1 << 3));
        val |= self.root_table << 0;

        assert!(self.offset < (1 << 8));
        val |= self.offset << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadRootTable {
    pub v: u32,
}

impl Mthd for LoadRootTable {
    const ADDR: u16 = 0x0508;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressA {
    pub upper: u32,
}

impl Mthd for SetMmeMemAddressA {
    const ADDR: u16 = 0x0550;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeMemAddressB {
    pub lower: u32,
}

impl Mthd for SetMmeMemAddressB {
    const ADDR: u16 = 0x0554;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataRamAddress {
    pub word: u32,
}

impl Mthd for SetMmeDataRamAddress {
    const ADDR: u16 = 0x0558;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.word;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaRead {
    pub length: u32,
}

impl Mthd for MmeDmaRead {
    const ADDR: u16 = 0x055c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReadFifoed {
    pub length: u32,
}

impl Mthd for MmeDmaReadFifoed {
    const ADDR: u16 = 0x0560;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaWrite {
    pub length: u32,
}

impl Mthd for MmeDmaWrite {
    const ADDR: u16 = 0x0564;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.length;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MmeDmaReductionReductionSize {
    FourBytes = 0x00000000,
    EightBytes = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaReduction {
    pub reduction_op: MmeDmaReductionReductionOp,
    pub reduction_format: MmeDmaReductionReductionFormat,
    pub reduction_size: MmeDmaReductionReductionSize,
}

impl Mthd for MmeDmaReduction {
    const ADDR: u16 = 0x0568;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 0;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 4;

        assert!((self.reduction_size as u32) < (1 << 1));
        val |= (self.reduction_size as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSysmembar {
    pub v: u32,
}

impl Mthd for MmeDmaSysmembar {
    const ADDR: u16 = 0x056c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct MmeDmaSync {
    pub value: u32,
}

impl Mthd for MmeDmaSync {
    const ADDR: u16 = 0x0570;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMmeDataFifoConfigFifoSize {
    Size0Kb = 0x00000000,
    Size4Kb = 0x00000001,
    Size8Kb = 0x00000002,
    Size12Kb = 0x00000003,
    Size16Kb = 0x00000004,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeDataFifoConfig {
    pub fifo_size: SetMmeDataFifoConfigFifoSize,
}

impl Mthd for SetMmeDataFifoConfig {
    const ADDR: u16 = 0x0574;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.fifo_size as u32) < (1 << 3));
        val |= (self.fifo_size as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSizeA {
    pub upper: u32,
}

impl ArrayMthd for SetVertexStreamSizeA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0600 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVertexStreamSizeB {
    pub lower: u32,
}

impl ArrayMthd for SetVertexStreamSizeB {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0604 + i * 8).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

pub use clc397::SetStreamOutControlStream;

pub use clc397::SetStreamOutControlComponentCount;

pub use clc397::SetStreamOutControlStride;

pub use clc397::SetRasterInput;

pub use clc397::SetStreamOutput;

pub use clc397::SetDaPrimitiveRestartTopologyChange;

pub use clc397::SetHybridAntiAliasControl;
pub use clc397::SetHybridAntiAliasControlCentroid;

pub use clc397::SetShaderLocalMemoryWindow;

pub use clc397::SetShaderLocalMemoryA;

pub use clc397::SetShaderLocalMemoryB;

pub use clc397::SetShaderLocalMemoryC;

pub use clc397::SetShaderLocalMemoryD;

pub use clc397::SetShaderLocalMemoryE;

pub use clc397::SetColorZeroBandwidthClear;

pub use clc397::SetZZeroBandwidthClear;

pub use clc397::SetStencilZeroBandwidthClear;

pub use clc397::SetZcullRegionSizeA;

pub use clc397::SetZcullRegionSizeB;

pub use clc397::SetZcullRegionSizeC;

pub use clc397::SetZcullRegionPixelOffsetC;

pub use clc397::SetCullBeforeFetch;

pub use clc397::SetZcullRegionLocation;

pub use clc397::SetZcullRegionAliquots;

pub use clc397::SetZcullStorageA;

pub use clc397::SetZcullStorageB;

pub use clc397::SetZcullStorageC;

pub use clc397::SetZcullStorageD;

pub use clc397::SetZtReadOnly;

pub use clc397::SetColorTargetA;

pub use clc397::SetColorTargetB;

pub use clc397::SetColorTargetWidth;

pub use clc397::SetColorTargetHeight;

pub use clc397::SetColorTargetFormat;
pub use clc397::SetColorTargetFormatV;

pub use clc397::SetColorTargetMemory;
pub use clc397::SetColorTargetMemoryBlockDepth;
pub use clc397::SetColorTargetMemoryBlockHeight;
pub use clc397::SetColorTargetMemoryBlockWidth;
pub use clc397::SetColorTargetMemoryLayout;
pub use clc397::SetColorTargetMemoryThirdDimensionControl;

pub use clc397::SetColorTargetThirdDimension;

pub use clc397::SetColorTargetArrayPitch;

pub use clc397::SetColorTargetLayer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetReservedA {
    pub v: u32,
}

impl ArrayMthd for SetColorTargetReservedA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0824 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc397::SetViewportScaleX;

pub use clc397::SetViewportScaleY;

pub use clc397::SetViewportScaleZ;

pub use clc397::SetViewportOffsetX;

pub use clc397::SetViewportOffsetY;

pub use clc397::SetViewportOffsetZ;

pub use clc397::SetViewportCoordinateSwizzle;
pub use clc397::SetViewportCoordinateSwizzleW;
pub use clc397::SetViewportCoordinateSwizzleX;
pub use clc397::SetViewportCoordinateSwizzleY;
pub use clc397::SetViewportCoordinateSwizzleZ;

pub use clc397::SetViewportIncreaseSnapGridPrecision;

pub use clc397::SetViewportClipHorizontal;

pub use clc397::SetViewportClipVertical;

pub use clc397::SetViewportClipMinZ;

pub use clc397::SetViewportClipMaxZ;

pub use clc397::SetWindowClipHorizontal;

pub use clc397::SetWindowClipVertical;

pub use clc397::SetClipIdExtentX;

pub use clc397::SetClipIdExtentY;

pub use clc397::SetMaxStreamOutputGsInstancesPerTask;

pub use clc397::SetApiVisibleCallLimit;
pub use clc397::SetApiVisibleCallLimitV;

pub use clc397::SetStatisticsCounter;

pub use clc397::SetClearRectHorizontal;

pub use clc397::SetClearRectVertical;

pub use clc397::SetVertexArrayStart;

pub use clc397::DrawVertexArray;

pub use clc397::SetViewportZClip;
pub use clc397::SetViewportZClipRange;

pub use clc397::SetColorClearValue;

pub use clc397::SetZClearValue;

pub use clc397::SetShaderCacheControl;

pub use clc397::ForceTransitionToBeta;

pub use clc397::SetReduceColorThresholdsEnable;

pub use clc397::SetStencilClearValue;

pub use clc397::InvalidateShaderCachesNoWfi;

pub use clc397::SetZcullSerialization;
pub use clc397::SetZcullSerializationApplied;

pub use clc397::SetFrontPolygonMode;
pub use clc397::SetFrontPolygonModeV;

pub use clc397::SetBackPolygonMode;
pub use clc397::SetBackPolygonModeV;

pub use clc397::SetPolySmooth;

pub use clc397::SetZcullDirFormat;
pub use clc397::SetZcullDirFormatZdir;
pub use clc397::SetZcullDirFormatZformat;

pub use clc397::SetPolyOffsetPoint;

pub use clc397::SetPolyOffsetLine;

pub use clc397::SetPolyOffsetFill;

pub use clc397::SetPatch;

pub use clc397::SetIteratedBlend;

pub use clc397::SetIteratedBlendPass;

pub use clc397::SetZcullCriterion;
pub use clc397::SetZcullCriterionSfunc;

pub use clc397::PixelShaderBarrier;

pub use clc397::SetSmTimeoutInterval;

pub use clc397::SetDaPrimitiveRestartVertexArray;

pub use clc397::LoadIteratedBlendInstructionPointer;

pub use clc397::LoadIteratedBlendInstruction;
pub use clc397::LoadIteratedBlendInstructionConstantInputSelect;
pub use clc397::LoadIteratedBlendInstructionOperandASelect;
pub use clc397::LoadIteratedBlendInstructionOperandBSelect;
pub use clc397::LoadIteratedBlendInstructionOperandCSelect;
pub use clc397::LoadIteratedBlendInstructionOperandDSelect;
pub use clc397::LoadIteratedBlendInstructionOperation;
pub use clc397::LoadIteratedBlendInstructionOutputSwizzle;
pub use clc397::LoadIteratedBlendInstructionOutputWriteMask;
pub use clc397::LoadIteratedBlendInstructionPassOutput;
pub use clc397::LoadIteratedBlendInstructionTestCc;

pub use clc397::SetWindowOffsetX;

pub use clc397::SetWindowOffsetY;

pub use clc397::SetScissorEnable;

pub use clc397::SetScissorHorizontal;

pub use clc397::SetScissorVertical;

pub use clc397::SetVpcPerfKnob;

pub use clc397::PmLocalTrigger;

pub use clc397::SetPostZPsImask;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMultiViewRenderTargetArrayIndexOffset {
    pub v: u32,
}

impl ArrayMthd for SetMultiViewRenderTargetArrayIndexOffset {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0f20 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 11));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpareMultiViewRenderTargetArrayIndexOffset {
    pub v: u32,
}

impl ArrayMthd for SetSpareMultiViewRenderTargetArrayIndexOffset {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x0f30 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc397::SetConstantColorRendering;

pub use clc397::SetConstantColorRenderingRed;

pub use clc397::SetConstantColorRenderingGreen;

pub use clc397::SetConstantColorRenderingBlue;

pub use clc397::SetConstantColorRenderingAlpha;

pub use clc397::SetBackStencilFuncRef;

pub use clc397::SetBackStencilMask;

pub use clc397::SetBackStencilFuncMask;

pub use clc397::SetVertexStreamSubstituteA;

pub use clc397::SetVertexStreamSubstituteB;

pub use clc397::SetLineModePolygonClip;
pub use clc397::SetLineModePolygonClipGeneratedEdge;

pub use clc397::SetSingleCtWriteControl;

pub use clc397::SetVtgWarpWatermarks;

pub use clc397::SetDepthBoundsMin;

pub use clc397::SetDepthBoundsMax;

pub use clc397::SetSampleMask;

pub use clc397::SetColorTargetSampleMask;

pub use clc397::SetCtMrtEnable;

pub use clc397::SetNonmultisampledZ;
pub use clc397::SetNonmultisampledZV;

pub use clc397::SetTir;
pub use clc397::SetTirMode;

pub use clc397::SetAntiAliasRaster;
pub use clc397::SetAntiAliasRasterSamples;

pub use clc397::SetSampleMaskX0Y0;

pub use clc397::SetSampleMaskX1Y0;

pub use clc397::SetSampleMaskX0Y1;

pub use clc397::SetSampleMaskX1Y1;

pub use clc397::SetSurfaceClipIdMemoryA;

pub use clc397::SetSurfaceClipIdMemoryB;

pub use clc397::SetTirModulation;
pub use clc397::SetTirModulationComponentSelect;

pub use clc397::SetTirModulationFunction;
pub use clc397::SetTirModulationFunctionSelect;

pub use clc397::SetBlendOptControl;

pub use clc397::SetZtA;

pub use clc397::SetZtB;

pub use clc397::SetZtFormat;
pub use clc397::SetZtFormatV;

pub use clc397::SetZtBlockSize;
pub use clc397::SetZtBlockSizeDepth;
pub use clc397::SetZtBlockSizeHeight;
pub use clc397::SetZtBlockSizeWidth;

pub use clc397::SetZtArrayPitch;

pub use clc397::SetSurfaceClipHorizontal;

pub use clc397::SetSurfaceClipVertical;

pub use clc397::SetL2CacheControlForVafRequests;
pub use clc397::SetL2CacheControlForVafRequestsPolicy;

pub use clc397::SetViewportMulticast;
pub use clc397::SetViewportMulticastOrder;

pub use clc397::SetTessellationCutHeight;

pub use clc397::SetMaxGsInstancesPerTask;

pub use clc397::SetMaxGsOutputVerticesPerTask;

pub use clc397::SetReservedSwMethod00;

pub use clc397::SetGsOutputCbStorageMultiplier;

pub use clc397::SetBetaCbStorageConstraint;

pub use clc397::SetTiOutputCbStorageMultiplier;

pub use clc397::SetAlphaCbStorageConstraint;

pub use clc397::SetReservedSwMethod01;

pub use clc397::SetReservedSwMethod02;

pub use clc397::SetTirModulationCoefficientTable;

pub use clc397::SetSpareNoop01;

pub use clc397::SetSpareNoop02;

pub use clc397::SetSpareNoop03;

pub use clc397::SetSpareNoop04;

pub use clc397::SetSpareNoop05;

pub use clc397::SetSpareNoop06;

pub use clc397::SetSpareNoop07;

pub use clc397::SetSpareNoop08;

pub use clc397::SetSpareNoop09;

pub use clc397::SetSpareNoop10;

pub use clc397::SetSpareNoop11;

pub use clc397::SetSpareNoop12;

pub use clc397::SetSpareNoop13;

pub use clc397::SetSpareNoop14;

pub use clc397::SetSpareNoop15;

pub use clc397::SetReservedSwMethod03;

pub use clc397::SetReservedSwMethod04;

pub use clc397::SetReservedSwMethod05;

pub use clc397::SetReservedSwMethod06;

pub use clc397::SetReservedSwMethod07;

pub use clc397::SetReservedSwMethod08;

pub use clc397::SetReservedSwMethod09;

pub use clc397::SetReduceColorThresholdsUnorm8;

pub use clc397::SetReservedSwMethod10;

pub use clc397::SetReservedSwMethod11;

pub use clc397::SetReservedSwMethod12;

pub use clc397::SetReservedSwMethod13;

pub use clc397::SetReduceColorThresholdsUnorm10;

pub use clc397::SetReduceColorThresholdsUnorm16;

pub use clc397::SetReduceColorThresholdsFp11;

pub use clc397::SetReduceColorThresholdsFp16;

pub use clc397::SetReduceColorThresholdsSrgb8;

pub use clc397::UnbindAll;

pub use clc397::SetClearSurfaceControl;

pub use clc397::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clc397::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clc397::SetReservedSwMethod14;

pub use clc397::SetReservedSwMethod15;

pub use clc397::NoOperationDataHi;

pub use clc397::SetDepthBiasControl;

pub use clc397::PmTriggerEnd;

pub use clc397::SetVertexIdBase;

pub use clc397::SetStencilCompression;

pub use clc397::SetDaOutputAttributeSkipMaskA;

pub use clc397::SetDaOutputAttributeSkipMaskB;

pub use clc397::SetTirControl;
pub use clc397::SetTirControlAlphaToCoverageUseRasterSamples;
pub use clc397::SetTirControlReduceCoverage;
pub use clc397::SetTirControlZPassPixelCountUseRasterSamples;

pub use clc397::SetMutableMethodControl;

pub use clc397::SetPostPsInitialCoverage;

pub use clc397::SetFillViaTriangle;
pub use clc397::SetFillViaTriangleMode;

pub use clc397::SetBlendPerFormatEnable;

pub use clc397::FlushPendingWrites;

pub use clc397::SetConservativeRaster;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMeshControl {
    pub enable: bool,
}

impl Mthd for SetMeshControl {
    const ADDR: u16 = 0x114c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetMeshShaderAOutputTopology {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMeshShaderA {
    pub output_topology: SetMeshShaderAOutputTopology,
    pub max_vertex: u32,
    pub max_primitive: u32,
}

impl Mthd for SetMeshShaderA {
    const ADDR: u16 = 0x1150;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.output_topology as u32) < (1 << 4));
        val |= (self.output_topology as u32) << 0;

        assert!(self.max_vertex < (1 << 9));
        val |= self.max_vertex << 4;

        assert!(self.max_primitive < (1 << 10));
        val |= self.max_primitive << 13;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMeshShaderB {
    pub shared_mem_lines: u32,
    pub thread_count: u32,
}

impl Mthd for SetMeshShaderB {
    const ADDR: u16 = 0x1154;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.shared_mem_lines < (1 << 9));
        val |= self.shared_mem_lines << 8;

        assert!(self.thread_count < (1 << 6));
        val |= self.thread_count << 20;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMeshInitShader {
    pub thread_count: u32,
    pub local_buffer_lines: u32,
    pub output_to_m_s_lines: u32,
}

impl Mthd for SetMeshInitShader {
    const ADDR: u16 = 0x1158;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.thread_count < (1 << 6));
        val |= self.thread_count << 0;

        assert!(self.local_buffer_lines < (1 << 9));
        val |= self.local_buffer_lines << 12;

        assert!(self.output_to_m_s_lines < (1 << 9));
        val |= self.output_to_m_s_lines << 22;

        val
    }
}

pub use clc397::SetVertexAttributeA;
pub use clc397::SetVertexAttributeAComponentBitWidths;
pub use clc397::SetVertexAttributeANumericalType;
pub use clc397::SetVertexAttributeASource;

pub use clc397::SetVertexAttributeB;
pub use clc397::SetVertexAttributeBComponentBitWidths;
pub use clc397::SetVertexAttributeBNumericalType;
pub use clc397::SetVertexAttributeBSource;

pub use clc397::SetAntiAliasSamplePositions;

pub use clc397::SetOffsetRenderTargetIndex;

pub use clc397::ForceHeavyweightMethodSync;

pub use clc397::SetCoverageToColor;

pub use clc397::DecompressZetaSurface;

pub use clc397::SetScreenStateMask;

pub use clc397::SetZtSparse;
pub use clc397::SetZtSparseUnmappedCompare;

pub use clc397::DrawVertexArrayBeginEndInstanceFirst;
pub use clc397::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clc397::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clc397::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clc397::SetCtSelect;

pub use clc397::SetCompressionThreshold;
pub use clc397::SetCompressionThresholdSamples;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerMode {
    NoConflictDetect = 0x00000000,
    ConflictDetectSample = 0x00000001,
    ConflictDetectPixel = 0x00000002,
    ConflictDetectVprs = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerTileSize {
    TcTileSize16X16 = 0x00000000,
    TcTileSize8X8 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerFragmentOrder {
    TcFragmentOrdered = 0x00000000,
    TcFragmentUnordered = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelShaderInterlockControl {
    pub tile_coalescer_mode: SetPixelShaderInterlockControlTileCoalescerMode,
    pub tile_coalescer_tile_size: SetPixelShaderInterlockControlTileCoalescerTileSize,
    pub tile_coalescer_fragment_order: SetPixelShaderInterlockControlTileCoalescerFragmentOrder,
}

impl Mthd for SetPixelShaderInterlockControl {
    const ADDR: u16 = 0x1224;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.tile_coalescer_mode as u32) < (1 << 2));
        val |= (self.tile_coalescer_mode as u32) << 0;

        assert!((self.tile_coalescer_tile_size as u32) < (1 << 1));
        val |= (self.tile_coalescer_tile_size as u32) << 2;

        assert!((self.tile_coalescer_fragment_order as u32) < (1 << 1));
        val |= (self.tile_coalescer_fragment_order as u32) << 3;

        val
    }
}

pub use clc397::SetZtSizeA;

pub use clc397::SetZtSizeB;

pub use clc397::SetZtSizeC;
pub use clc397::SetZtSizeCControl;

pub use clc397::SetSamplerBinding;
pub use clc397::SetSamplerBindingV;

pub use clc397::DrawAuto;

pub use clc397::SetPostVtgShaderAttributeSkipMask;

pub use clc397::SetPixelShaderTicketDispenserValue;

pub use clc397::SetBackEndCopyA;

pub use clc397::SetBackEndCopyB;

pub use clc397::SetBackEndCopyC;

pub use clc397::SetBackEndCopyD;

pub use clc397::SetBackEndCopyE;

pub use clc397::SetCircularBufferSize;

pub use clc397::SetVtgRegisterWatermarks;

pub use clc397::InvalidateTextureDataCacheNoWfi;
pub use clc397::InvalidateTextureDataCacheNoWfiLines;

pub use clc397::SetL2CacheControlForRopInterlockedReadRequests;
pub use clc397::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clc397::SetDaPrimitiveRestartIndexTopologyChange;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceAddressA {
    pub offset_upper: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceAddressA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12a8 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceAddressB {
    pub offset_lower: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceAddressB {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12ac + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceSizeA {
    pub width: u32,
    pub height: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceSizeA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12b0 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 12));
        val |= self.width << 0;

        assert!(self.height < (1 << 12));
        val |= self.height << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceSizeB {
    pub array_size: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceSizeB {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12b4 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.array_size < (1 << 12));
        val |= self.array_size << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceLayer {
    pub offset: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceLayer {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12b8 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset < (1 << 12));
        val |= self.offset << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceArrayPitch {
    pub v: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceArrayPitch {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12bc + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 29));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShadingRateIndexSurfaceBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShadingRateIndexSurfaceBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShadingRateIndexSurfaceBlockSizeDepth {
    OneGob = 0x00000000,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceBlockSize {
    pub width: SetShadingRateIndexSurfaceBlockSizeWidth,
    pub height: SetShadingRateIndexSurfaceBlockSizeHeight,
    pub depth: SetShadingRateIndexSurfaceBlockSizeDepth,
}

impl ArrayMthd for SetShadingRateIndexSurfaceBlockSize {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12c0 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShadingRateIndexSurfaceAllocatedSize {
    pub width: u32,
}

impl ArrayMthd for SetShadingRateIndexSurfaceAllocatedSize {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x12c4 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.width < (1 << 12));
        val |= self.width << 0;

        val
    }
}

pub use clc397::ClearZcullRegion;

pub use clc397::SetDepthTest;

pub use clc397::SetFillMode;
pub use clc397::SetFillModeV;

pub use clc397::SetShadeMode;
pub use clc397::SetShadeModeV;

pub use clc397::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clc397::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clc397::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clc397::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clc397::SetAlphaToCoverageDitherControl;
pub use clc397::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clc397::SetBlendStatePerTarget;

pub use clc397::SetDepthWrite;

pub use clc397::SetAlphaTest;

pub use clc397::SetInlineIndex4X8Align;

pub use clc397::DrawInlineIndex4X8;

pub use clc397::D3DSetCullMode;
pub use clc397::D3DSetCullModeV;

pub use clc397::SetDepthFunc;
pub use clc397::SetDepthFuncV;

pub use clc397::SetAlphaRef;

pub use clc397::SetAlphaFunc;
pub use clc397::SetAlphaFuncV;

pub use clc397::SetDrawAutoStride;

pub use clc397::SetBlendConstRed;

pub use clc397::SetBlendConstGreen;

pub use clc397::SetBlendConstBlue;

pub use clc397::SetBlendConstAlpha;

pub use clc397::InvalidateSamplerCache;
pub use clc397::InvalidateSamplerCacheLines;

pub use clc397::InvalidateTextureHeaderCache;
pub use clc397::InvalidateTextureHeaderCacheLines;

pub use clc397::InvalidateTextureDataCache;
pub use clc397::InvalidateTextureDataCacheLines;

pub use clc397::SetBlendSeparateForAlpha;

pub use clc397::SetBlendColorOp;
pub use clc397::SetBlendColorOpV;

pub use clc397::SetBlendColorSourceCoeff;
pub use clc397::SetBlendColorSourceCoeffV;

pub use clc397::SetBlendColorDestCoeff;
pub use clc397::SetBlendColorDestCoeffV;

pub use clc397::SetBlendAlphaOp;
pub use clc397::SetBlendAlphaOpV;

pub use clc397::SetBlendAlphaSourceCoeff;
pub use clc397::SetBlendAlphaSourceCoeffV;

pub use clc397::SetGlobalColorKey;

pub use clc397::SetBlendAlphaDestCoeff;
pub use clc397::SetBlendAlphaDestCoeffV;

pub use clc397::SetSingleRopControl;

pub use clc397::SetBlend;

pub use clc397::SetStencilTest;

pub use clc397::SetStencilOpFail;
pub use clc397::SetStencilOpFailV;

pub use clc397::SetStencilOpZfail;
pub use clc397::SetStencilOpZfailV;

pub use clc397::SetStencilOpZpass;
pub use clc397::SetStencilOpZpassV;

pub use clc397::SetStencilFunc;
pub use clc397::SetStencilFuncV;

pub use clc397::SetStencilFuncRef;

pub use clc397::SetStencilFuncMask;

pub use clc397::SetStencilMask;

pub use clc397::SetDrawAutoStart;

pub use clc397::SetPsSaturate;
pub use clc397::SetPsSaturateClampRange0;
pub use clc397::SetPsSaturateClampRange1;
pub use clc397::SetPsSaturateClampRange2;
pub use clc397::SetPsSaturateClampRange3;
pub use clc397::SetPsSaturateClampRange4;
pub use clc397::SetPsSaturateClampRange5;
pub use clc397::SetPsSaturateClampRange6;
pub use clc397::SetPsSaturateClampRange7;

pub use clc397::SetWindowOrigin;
pub use clc397::SetWindowOriginMode;

pub use clc397::SetLineWidthFloat;

pub use clc397::SetAliasedLineWidthFloat;

pub use clc397::SetLineMultisampleOverride;

pub use clc397::InvalidateSamplerCacheNoWfi;
pub use clc397::InvalidateSamplerCacheNoWfiLines;

pub use clc397::InvalidateTextureHeaderCacheNoWfi;
pub use clc397::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc397::SetGlobalBaseVertexIndex;

pub use clc397::SetGlobalBaseInstanceIndex;

pub use clc397::SetPsWarpWatermarks;

pub use clc397::SetPsRegisterWatermarks;

pub use clc397::StoreZcull;

pub use clc397::SetIteratedBlendConstantRed;

pub use clc397::SetIteratedBlendConstantGreen;

pub use clc397::SetIteratedBlendConstantBlue;

pub use clc397::LoadZcull;

pub use clc397::SetSurfaceClipIdHeight;

pub use clc397::SetClipIdClearRectHorizontal;

pub use clc397::SetClipIdClearRectVertical;

pub use clc397::SetUserClipEnable;

pub use clc397::SetZpassPixelCount;

pub use clc397::SetPointSize;

pub use clc397::SetZcullStats;

pub use clc397::SetPointSprite;

pub use clc397::SetShaderExceptions;

pub use clc397::ClearReportValue;
pub use clc397::ClearReportValueType;

pub use clc397::SetAntiAliasEnable;

pub use clc397::SetZtSelect;

pub use clc397::SetAntiAliasAlphaControl;
pub use clc397::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clc397::SetAntiAliasAlphaControlAlphaToOne;

pub use clc397::SetRenderEnableA;

pub use clc397::SetRenderEnableB;

pub use clc397::SetRenderEnableC;
pub use clc397::SetRenderEnableCMode;

pub use clc397::SetTexSamplerPoolA;

pub use clc397::SetTexSamplerPoolB;

pub use clc397::SetTexSamplerPoolC;

pub use clc397::SetSlopeScaleDepthBias;

pub use clc397::SetAntiAliasedLine;

pub use clc397::SetTexHeaderPoolA;

pub use clc397::SetTexHeaderPoolB;

pub use clc397::SetTexHeaderPoolC;

pub use clc397::SetActiveZcullRegion;

pub use clc397::SetTwoSidedStencilTest;

pub use clc397::SetBackStencilOpFail;
pub use clc397::SetBackStencilOpFailV;

pub use clc397::SetBackStencilOpZfail;
pub use clc397::SetBackStencilOpZfailV;

pub use clc397::SetBackStencilOpZpass;
pub use clc397::SetBackStencilOpZpassV;

pub use clc397::SetBackStencilFunc;
pub use clc397::SetBackStencilFuncV;

pub use clc397::SetSrgbWrite;

pub use clc397::SetDepthBias;

pub use clc397::SetZcullRegionFormat;
pub use clc397::SetZcullRegionFormatType;

pub use clc397::SetRtLayer;
pub use clc397::SetRtLayerControl;

pub use clc397::SetAntiAlias;
pub use clc397::SetAntiAliasSamples;

pub use clc397::SetEdgeFlag;

pub use clc397::DrawInlineIndex;

pub use clc397::SetInlineIndex2X16Align;

pub use clc397::DrawInlineIndex2X16;

pub use clc397::SetVertexGlobalBaseOffsetA;

pub use clc397::SetVertexGlobalBaseOffsetB;

pub use clc397::SetZcullRegionPixelOffsetA;

pub use clc397::SetZcullRegionPixelOffsetB;

pub use clc397::SetPointSpriteSelect;
pub use clc397::SetPointSpriteSelectOrigin;
pub use clc397::SetPointSpriteSelectRmode;
pub use clc397::SetPointSpriteSelectTexture0;
pub use clc397::SetPointSpriteSelectTexture1;
pub use clc397::SetPointSpriteSelectTexture2;
pub use clc397::SetPointSpriteSelectTexture3;
pub use clc397::SetPointSpriteSelectTexture4;
pub use clc397::SetPointSpriteSelectTexture5;
pub use clc397::SetPointSpriteSelectTexture6;
pub use clc397::SetPointSpriteSelectTexture7;
pub use clc397::SetPointSpriteSelectTexture8;
pub use clc397::SetPointSpriteSelectTexture9;

pub use clc397::SetAttributeDefault;
pub use clc397::SetAttributeDefaultColorFrontDiffuse;
pub use clc397::SetAttributeDefaultColorFrontSpecular;
pub use clc397::SetAttributeDefaultDx9Color0;
pub use clc397::SetAttributeDefaultDx9Color1ToColor15;
pub use clc397::SetAttributeDefaultFixedFncTexture;
pub use clc397::SetAttributeDefaultGenericVector;

pub use clc397::End;

pub use clc397::Begin;
pub use clc397::BeginInstanceId;
pub use clc397::BeginOp;
pub use clc397::BeginPrimitiveId;
pub use clc397::BeginSplitMode;

pub use clc397::SetVertexIdCopy;

pub use clc397::AddToPrimitiveId;

pub use clc397::LoadPrimitiveId;

pub use clc397::SetShaderBasedCull;

pub use clc397::SetClassVersion;

pub use clc397::SetDaPrimitiveRestart;

pub use clc397::SetDaPrimitiveRestartIndex;

pub use clc397::SetDaOutput;

pub use clc397::SetAntiAliasedPoint;

pub use clc397::SetPointCenterMode;
pub use clc397::SetPointCenterModeV;

pub use clc397::SetLineSmoothParameters;
pub use clc397::SetLineSmoothParametersFalloff;

pub use clc397::SetLineStipple;

pub use clc397::SetLineSmoothEdgeTable;

pub use clc397::SetLineStippleParameters;

pub use clc397::SetProvokingVertex;
pub use clc397::SetProvokingVertexV;

pub use clc397::SetTwoSidedLight;

pub use clc397::SetPolygonStipple;

pub use clc397::SetShaderControl;
pub use clc397::SetShaderControlDefaultPartial;
pub use clc397::SetShaderControlFp32F2INanBehavior;
pub use clc397::SetShaderControlFp32NanBehavior;

pub use clc397::CheckClassVersion;

pub use clc397::SetSphVersion;

pub use clc397::CheckSphVersion;

pub use clc397::SetAlphaToCoverageOverride;
pub use clc397::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clc397::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgGraphicsPriority {
    pub priority: u32,
}

impl Mthd for SetScgGraphicsPriority {
    const ADDR: u16 = 0x16bc;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.priority < (1 << 6));
        val |= self.priority << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgGraphicsSchedulingParameters {
    pub v: u32,
}

impl ArrayMthd for SetScgGraphicsSchedulingParameters {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x16c0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc397::SetPolygonStipplePattern;

pub use clc397::SetAamVersion;

pub use clc397::CheckAamVersion;

pub use clc397::SetZtLayer;

pub use clc397::SetIndexBufferA;

pub use clc397::SetIndexBufferB;

pub use clc397::SetIndexBufferE;
pub use clc397::SetIndexBufferEIndexSize;

pub use clc397::SetIndexBufferF;

pub use clc397::DrawIndexBuffer;

pub use clc397::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clc397::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clc397::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clc397::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clc397::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clc397::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clc397::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clc397::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clc397::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clc397::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clc397::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clc397::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clc397::SetDepthBiasClamp;

pub use clc397::SetVertexStreamInstanceA;

pub use clc397::SetVertexStreamInstanceB;

pub use clc397::SetAttributePointSize;

pub use clc397::OglSetCull;

pub use clc397::OglSetFrontFace;
pub use clc397::OglSetFrontFaceV;

pub use clc397::OglSetCullFace;
pub use clc397::OglSetCullFaceV;

pub use clc397::SetViewportPixel;
pub use clc397::SetViewportPixelCenter;

pub use clc397::SetViewportScaleOffset;

pub use clc397::SetViewportClipControl;
pub use clc397::SetViewportClipControlGeometryClip;
pub use clc397::SetViewportClipControlGeometryGuardband;
pub use clc397::SetViewportClipControlGeometryGuardbandZ;
pub use clc397::SetViewportClipControlLinePointCullGuardband;
pub use clc397::SetViewportClipControlPixelMaxZ;
pub use clc397::SetViewportClipControlPixelMinZ;
pub use clc397::SetViewportClipControlZClipRange;

pub use clc397::SetUserClipOp;
pub use clc397::SetUserClipOpPlane0;
pub use clc397::SetUserClipOpPlane1;
pub use clc397::SetUserClipOpPlane2;
pub use clc397::SetUserClipOpPlane3;
pub use clc397::SetUserClipOpPlane4;
pub use clc397::SetUserClipOpPlane5;
pub use clc397::SetUserClipOpPlane6;
pub use clc397::SetUserClipOpPlane7;

pub use clc397::SetRenderEnableOverride;
pub use clc397::SetRenderEnableOverrideMode;

pub use clc397::SetPrimitiveTopologyControl;
pub use clc397::SetPrimitiveTopologyControlOverride;

pub use clc397::SetWindowClipEnable;

pub use clc397::SetWindowClipType;
pub use clc397::SetWindowClipTypeV;

pub use clc397::InvalidateZcull;
pub use clc397::InvalidateZcullV;

pub use clc397::SetZcull;

pub use clc397::SetZcullBounds;

pub use clc397::SetPrimitiveTopology;
pub use clc397::SetPrimitiveTopologyV;

pub use clc397::ZcullSync;

pub use clc397::SetClipIdTest;

pub use clc397::SetSurfaceClipIdWidth;

pub use clc397::SetClipId;

pub use clc397::SetDepthBoundsTest;

pub use clc397::SetBlendFloatOption;

pub use clc397::SetLogicOp;

pub use clc397::SetLogicOpFunc;
pub use clc397::SetLogicOpFuncV;

pub use clc397::SetZCompression;

pub use clc397::ClearSurface;

pub use clc397::ClearClipIdSurface;

pub use clc397::SetColorCompression;

pub use clc397::SetCtWrite;

pub use clc397::PipeNop;

pub use clc397::SetSpare00;

pub use clc397::SetSpare01;

pub use clc397::SetSpare02;

pub use clc397::SetSpare03;

pub use clc397::SetReportSemaphoreA;

pub use clc397::SetReportSemaphoreB;

pub use clc397::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    ScgClocks = 0x00000008,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    TiledZpassPixelCnt64 = 0x00000017,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
    pub conditional_trap: bool,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xc597;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;

        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;

        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;

        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        assert!((self.conditional_trap as u32) < (1 << 1));
        val |= (self.conditional_trap as u32) << 19;

        val
    }
}

pub use clc397::SetVertexStreamAFormat;

pub use clc397::SetVertexStreamALocationA;

pub use clc397::SetVertexStreamALocationB;

pub use clc397::SetVertexStreamAFrequency;

pub use clc397::SetVertexStreamBFormat;

pub use clc397::SetVertexStreamBLocationA;

pub use clc397::SetVertexStreamBLocationB;

pub use clc397::SetVertexStreamBFrequency;

pub use clc397::SetBlendPerTargetSeparateForAlpha;

pub use clc397::SetBlendPerTargetColorOp;
pub use clc397::SetBlendPerTargetColorOpV;

pub use clc397::SetBlendPerTargetColorSourceCoeff;
pub use clc397::SetBlendPerTargetColorSourceCoeffV;

pub use clc397::SetBlendPerTargetColorDestCoeff;
pub use clc397::SetBlendPerTargetColorDestCoeffV;

pub use clc397::SetBlendPerTargetAlphaOp;
pub use clc397::SetBlendPerTargetAlphaOpV;

pub use clc397::SetBlendPerTargetAlphaSourceCoeff;
pub use clc397::SetBlendPerTargetAlphaSourceCoeffV;

pub use clc397::SetBlendPerTargetAlphaDestCoeff;
pub use clc397::SetBlendPerTargetAlphaDestCoeffV;

pub use clc397::SetPipelineShader;
pub use clc397::SetPipelineShaderType;

pub use clc397::SetPipelineReservedA;

pub use clc397::SetPipelineRegisterCount;

pub use clc397::SetPipelineBinding;

pub use clc397::SetPipelineProgramAddressA;

pub use clc397::SetPipelineProgramAddressB;

pub use clc397::SetPipelineReservedD;

pub use clc397::SetPipelineReservedE;

pub use clc397::SetFalcon00;

pub use clc397::SetFalcon01;

pub use clc397::SetFalcon02;

pub use clc397::SetFalcon03;

pub use clc397::SetFalcon04;

pub use clc397::SetFalcon05;

pub use clc397::SetFalcon06;

pub use clc397::SetFalcon07;

pub use clc397::SetFalcon08;

pub use clc397::SetFalcon09;

pub use clc397::SetFalcon10;

pub use clc397::SetFalcon11;

pub use clc397::SetFalcon12;

pub use clc397::SetFalcon13;

pub use clc397::SetFalcon14;

pub use clc397::SetFalcon15;

pub use clc397::SetFalcon16;

pub use clc397::SetFalcon17;

pub use clc397::SetFalcon18;

pub use clc397::SetFalcon19;

pub use clc397::SetFalcon20;

pub use clc397::SetFalcon21;

pub use clc397::SetFalcon22;

pub use clc397::SetFalcon23;

pub use clc397::SetFalcon24;

pub use clc397::SetFalcon25;

pub use clc397::SetFalcon26;

pub use clc397::SetFalcon27;

pub use clc397::SetFalcon28;

pub use clc397::SetFalcon29;

pub use clc397::SetFalcon30;

pub use clc397::SetFalcon31;

pub use clc397::SetConstantBufferSelectorA;

pub use clc397::SetConstantBufferSelectorB;

pub use clc397::SetConstantBufferSelectorC;

pub use clc397::LoadConstantBufferOffset;

pub use clc397::LoadConstantBuffer;

pub use clc397::BindGroupReservedA;

pub use clc397::BindGroupReservedB;

pub use clc397::BindGroupReservedC;

pub use clc397::BindGroupReservedD;

pub use clc397::BindGroupConstantBuffer;

pub use clc397::SetTrapHandlerA;

pub use clc397::SetTrapHandlerB;

pub use clc397::SetColorClamp;

pub use clc397::SetBindlessTexture;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateShadingControl {
    pub enable: bool,
}

impl ArrayMthd for SetVariablePixelRateShadingControl {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x2a00 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex0 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex1 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex2 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex3 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex4 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex5 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex6 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateARateIndex7 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateShadingIndexToRateA {
    pub rate_index0: SetVariablePixelRateShadingIndexToRateARateIndex0,
    pub rate_index1: SetVariablePixelRateShadingIndexToRateARateIndex1,
    pub rate_index2: SetVariablePixelRateShadingIndexToRateARateIndex2,
    pub rate_index3: SetVariablePixelRateShadingIndexToRateARateIndex3,
    pub rate_index4: SetVariablePixelRateShadingIndexToRateARateIndex4,
    pub rate_index5: SetVariablePixelRateShadingIndexToRateARateIndex5,
    pub rate_index6: SetVariablePixelRateShadingIndexToRateARateIndex6,
    pub rate_index7: SetVariablePixelRateShadingIndexToRateARateIndex7,
}

impl ArrayMthd for SetVariablePixelRateShadingIndexToRateA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x2a04 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.rate_index0 as u32) < (1 << 4));
        val |= (self.rate_index0 as u32) << 0;

        assert!((self.rate_index1 as u32) < (1 << 4));
        val |= (self.rate_index1 as u32) << 4;

        assert!((self.rate_index2 as u32) < (1 << 4));
        val |= (self.rate_index2 as u32) << 8;

        assert!((self.rate_index3 as u32) < (1 << 4));
        val |= (self.rate_index3 as u32) << 12;

        assert!((self.rate_index4 as u32) < (1 << 4));
        val |= (self.rate_index4 as u32) << 16;

        assert!((self.rate_index5 as u32) < (1 << 4));
        val |= (self.rate_index5 as u32) << 20;

        assert!((self.rate_index6 as u32) < (1 << 4));
        val |= (self.rate_index6 as u32) << 24;

        assert!((self.rate_index7 as u32) < (1 << 4));
        val |= (self.rate_index7 as u32) << 28;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex8 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex9 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex10 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex11 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex12 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex13 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex14 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetVariablePixelRateShadingIndexToRateBRateIndex15 {
    PsX0CullRasterPixels = 0x00000000,
    PsX16PerRasterPixel = 0x00000001,
    PsX8PerRasterPixel = 0x00000002,
    PsX4PerRasterPixel = 0x00000003,
    PsX2PerRasterPixel = 0x00000004,
    PsX1PerRasterPixel = 0x00000005,
    PsX1Per2X1RasterPixels = 0x00000006,
    PsX1Per1X2RasterPixels = 0x00000007,
    PsX1Per2X2RasterPixels = 0x00000008,
    PsX1Per4X2RasterPixels = 0x00000009,
    PsX1Per2X4RasterPixels = 0x0000000a,
    PsX1Per4X4RasterPixels = 0x0000000b,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateShadingIndexToRateB {
    pub rate_index8: SetVariablePixelRateShadingIndexToRateBRateIndex8,
    pub rate_index9: SetVariablePixelRateShadingIndexToRateBRateIndex9,
    pub rate_index10: SetVariablePixelRateShadingIndexToRateBRateIndex10,
    pub rate_index11: SetVariablePixelRateShadingIndexToRateBRateIndex11,
    pub rate_index12: SetVariablePixelRateShadingIndexToRateBRateIndex12,
    pub rate_index13: SetVariablePixelRateShadingIndexToRateBRateIndex13,
    pub rate_index14: SetVariablePixelRateShadingIndexToRateBRateIndex14,
    pub rate_index15: SetVariablePixelRateShadingIndexToRateBRateIndex15,
}

impl ArrayMthd for SetVariablePixelRateShadingIndexToRateB {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x2a08 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.rate_index8 as u32) < (1 << 4));
        val |= (self.rate_index8 as u32) << 0;

        assert!((self.rate_index9 as u32) < (1 << 4));
        val |= (self.rate_index9 as u32) << 4;

        assert!((self.rate_index10 as u32) < (1 << 4));
        val |= (self.rate_index10 as u32) << 8;

        assert!((self.rate_index11 as u32) < (1 << 4));
        val |= (self.rate_index11 as u32) << 12;

        assert!((self.rate_index12 as u32) < (1 << 4));
        val |= (self.rate_index12 as u32) << 16;

        assert!((self.rate_index13 as u32) < (1 << 4));
        val |= (self.rate_index13 as u32) << 20;

        assert!((self.rate_index14 as u32) < (1 << 4));
        val |= (self.rate_index14 as u32) << 24;

        assert!((self.rate_index15 as u32) < (1 << 4));
        val |= (self.rate_index15 as u32) << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVariablePixelRateShadingReservedA {
    pub v: u32,
}

impl ArrayMthd for SetVariablePixelRateShadingReservedA {
    const CLASS: u16 = 0xc597;

    fn addr(i: usize) -> u16 {
        (0x2a0c + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc397::SetShaderPerformanceSnapshotCounterValue;

pub use clc397::SetShaderPerformanceSnapshotCounterValueUpper;

pub use clc397::EnableShaderPerformanceSnapshotCounter;

pub use clc397::DisableShaderPerformanceSnapshotCounter;

pub use clc397::SetShaderPerformanceCounterValueUpper;

pub use clc397::SetShaderPerformanceCounterValue;

pub use clc397::SetShaderPerformanceCounterEvent;

pub use clc397::SetShaderPerformanceCounterControlA;

pub use clc397::SetShaderPerformanceCounterControlB;

pub use clc397::SetShaderPerformanceCounterTrapControl;

pub use clc397::StartShaderPerformanceCounter;

pub use clc397::StopShaderPerformanceCounter;

pub use clc397::SetShaderPerformanceCounterSctlFilter;

pub use clc397::SetShaderPerformanceCounterCoreMioFilter;

pub use clc397::SetMmeShadowScratch;

pub use clc397::CallMmeMacro;

pub use clc397::CallMmeData;
