use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc0c0::mthd as clc0c0;

// parsed class NVC3C0

pub use clc0c0::SetObject;

pub use clc0c0::NoOperation;

pub use clc0c0::SetNotifyA;

pub use clc0c0::SetNotifyB;

pub use clc0c0::Notify;
pub use clc0c0::NotifyType;

pub use clc0c0::WaitForIdle;

pub use clc0c0::SetGlobalRenderEnableA;

pub use clc0c0::SetGlobalRenderEnableB;

pub use clc0c0::SetGlobalRenderEnableC;
pub use clc0c0::SetGlobalRenderEnableCMode;

pub use clc0c0::SendGoIdle;

pub use clc0c0::PmTrigger;

pub use clc0c0::PmTriggerWfi;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceBegin {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceBegin {
    const ADDR: u16 = 0x0148;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceEnd {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceEnd {
    const ADDR: u16 = 0x014c;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc0c0::SetInstrumentationMethodHeader;

pub use clc0c0::SetInstrumentationMethodData;

pub use clc0c0::LineLengthIn;

pub use clc0c0::LineCount;

pub use clc0c0::OffsetOutUpper;

pub use clc0c0::OffsetOut;

pub use clc0c0::PitchOut;

pub use clc0c0::SetDstBlockSize;
pub use clc0c0::SetDstBlockSizeDepth;
pub use clc0c0::SetDstBlockSizeHeight;
pub use clc0c0::SetDstBlockSizeWidth;

pub use clc0c0::SetDstWidth;

pub use clc0c0::SetDstHeight;

pub use clc0c0::SetDstDepth;

pub use clc0c0::SetDstLayer;

pub use clc0c0::SetDstOriginBytesX;

pub use clc0c0::SetDstOriginSamplesY;

pub use clc0c0::LaunchDma;
pub use clc0c0::LaunchDmaCompletionType;
pub use clc0c0::LaunchDmaDstMemoryLayout;
pub use clc0c0::LaunchDmaInterruptType;
pub use clc0c0::LaunchDmaReductionFormat;
pub use clc0c0::LaunchDmaReductionOp;
pub use clc0c0::LaunchDmaSemaphoreStructSize;

pub use clc0c0::LoadInlineData;

pub use clc0c0::SetI2MSemaphoreA;

pub use clc0c0::SetI2MSemaphoreB;

pub use clc0c0::SetI2MSemaphoreC;

pub use clc0c0::SetI2MSpareNoop00;

pub use clc0c0::SetI2MSpareNoop01;

pub use clc0c0::SetI2MSpareNoop02;

pub use clc0c0::SetI2MSpareNoop03;

pub use clc0c0::SetValidSpanOverflowAreaA;

pub use clc0c0::SetValidSpanOverflowAreaB;

pub use clc0c0::SetValidSpanOverflowAreaC;

pub use clc0c0::PerfmonTransfer;

pub use clc0c0::InvalidateShaderCaches;

pub use clc0c0::SetReservedSwMethod00;

pub use clc0c0::SetReservedSwMethod01;

pub use clc0c0::SetReservedSwMethod02;

pub use clc0c0::SetReservedSwMethod03;

pub use clc0c0::SetReservedSwMethod04;

pub use clc0c0::SetReservedSwMethod05;

pub use clc0c0::SetReservedSwMethod06;

pub use clc0c0::SetReservedSwMethod07;

pub use clc0c0::InvalidateTextureHeaderCacheNoWfi;
pub use clc0c0::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc0c0::SetCwdRefCounter;

pub use clc0c0::SetReservedSwMethod08;

pub use clc0c0::SetReservedSwMethod09;

pub use clc0c0::SetReservedSwMethod10;

pub use clc0c0::SetReservedSwMethod11;

pub use clc0c0::SetReservedSwMethod12;

pub use clc0c0::SetReservedSwMethod13;

pub use clc0c0::SetReservedSwMethod14;

pub use clc0c0::SetReservedSwMethod15;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgControl {
    pub compute1_max_sm_count: u32,
    pub compute1_min_sm_count: u32,
    pub disable_compute1_limit_in_all_compute: bool,
}

impl Mthd for SetScgControl {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.compute1_max_sm_count < (1 << 9));
        val |= self.compute1_max_sm_count << 0;

        assert!(self.compute1_min_sm_count < (1 << 9));
        val |= self.compute1_min_sm_count << 12;

        assert!((self.disable_compute1_limit_in_all_compute as u32) < (1 << 1));
        val |= (self.disable_compute1_limit_in_all_compute as u32) << 24;

        val
    }
}

pub use clc0c0::SetComputeClassVersion;

pub use clc0c0::CheckComputeClassVersion;

pub use clc0c0::SetQmdVersion;

pub use clc0c0::CheckQmdVersion;

pub use clc0c0::InvalidateSkedCaches;

pub use clc0c0::SetShaderSharedMemoryWindowA;

pub use clc0c0::SetShaderSharedMemoryWindowB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ScgHysteresisControl {
    pub use_timeout_once: bool,
    pub use_null_timeout_once: bool,
}

impl Mthd for ScgHysteresisControl {
    const ADDR: u16 = 0x02a8;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.use_timeout_once as u32) < (1 << 1));
        val |= (self.use_timeout_once as u32) << 0;

        assert!((self.use_null_timeout_once as u32) < (1 << 1));
        val |= (self.use_null_timeout_once as u32) << 1;

        val
    }
}

pub use clc0c0::SetCwdSlotCount;

pub use clc0c0::SendPcasA;

pub use clc0c0::SendPcasB;

pub use clc0c0::SendSignalingPcasB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSkedCacheControl {
    pub ignore_veid: bool,
}

impl Mthd for SetSkedCacheControl {
    const ADDR: u16 = 0x02cc;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.ignore_veid as u32) < (1 << 1));
        val |= (self.ignore_veid as u32) << 0;

        val
    }
}

pub use clc0c0::SetShaderLocalMemoryNonThrottledA;

pub use clc0c0::SetShaderLocalMemoryNonThrottledB;

pub use clc0c0::SetShaderLocalMemoryNonThrottledC;

pub use clc0c0::SetSpaVersion;

pub use clc0c0::SetInlineQmdAddressA;

pub use clc0c0::SetInlineQmdAddressB;

pub use clc0c0::LoadInlineQmdData;

pub use clc0c0::SetFalcon00;

pub use clc0c0::SetFalcon01;

pub use clc0c0::SetFalcon02;

pub use clc0c0::SetFalcon03;

pub use clc0c0::SetFalcon04;

pub use clc0c0::SetFalcon05;

pub use clc0c0::SetFalcon06;

pub use clc0c0::SetFalcon07;

pub use clc0c0::SetFalcon08;

pub use clc0c0::SetFalcon09;

pub use clc0c0::SetFalcon10;

pub use clc0c0::SetFalcon11;

pub use clc0c0::SetFalcon12;

pub use clc0c0::SetFalcon13;

pub use clc0c0::SetFalcon14;

pub use clc0c0::SetFalcon15;

pub use clc0c0::SetFalcon16;

pub use clc0c0::SetFalcon17;

pub use clc0c0::SetFalcon18;

pub use clc0c0::SetFalcon19;

pub use clc0c0::SetFalcon20;

pub use clc0c0::SetFalcon21;

pub use clc0c0::SetFalcon22;

pub use clc0c0::SetFalcon23;

pub use clc0c0::SetFalcon24;

pub use clc0c0::SetFalcon25;

pub use clc0c0::SetFalcon26;

pub use clc0c0::SetFalcon27;

pub use clc0c0::SetFalcon28;

pub use clc0c0::SetFalcon29;

pub use clc0c0::SetFalcon30;

pub use clc0c0::SetFalcon31;

pub use clc0c0::SetShaderLocalMemoryA;

pub use clc0c0::SetShaderLocalMemoryB;

pub use clc0c0::SetShaderLocalMemoryWindowA;

pub use clc0c0::SetShaderLocalMemoryWindowB;

pub use clc0c0::SetShaderCacheControl;

pub use clc0c0::SetSmTimeoutInterval;

pub use clc0c0::InvalidateSamplerCacheAll;

pub use clc0c0::InvalidateTextureHeaderCacheAll;

pub use clc0c0::InvalidateTextureDataCacheNoWfi;
pub use clc0c0::InvalidateTextureDataCacheNoWfiLines;

pub use clc0c0::ActivatePerfSettingsForComputeContext;

pub use clc0c0::InvalidateSamplerCache;
pub use clc0c0::InvalidateSamplerCacheLines;

pub use clc0c0::InvalidateTextureHeaderCache;
pub use clc0c0::InvalidateTextureHeaderCacheLines;

pub use clc0c0::InvalidateTextureDataCache;
pub use clc0c0::InvalidateTextureDataCacheLines;

pub use clc0c0::InvalidateSamplerCacheNoWfi;
pub use clc0c0::InvalidateSamplerCacheNoWfiLines;

pub use clc0c0::SetShaderExceptions;

pub use clc0c0::SetRenderEnableA;

pub use clc0c0::SetRenderEnableB;

pub use clc0c0::SetRenderEnableC;
pub use clc0c0::SetRenderEnableCMode;

pub use clc0c0::SetTexSamplerPoolA;

pub use clc0c0::SetTexSamplerPoolB;

pub use clc0c0::SetTexSamplerPoolC;

pub use clc0c0::SetTexHeaderPoolA;

pub use clc0c0::SetTexHeaderPoolB;

pub use clc0c0::SetTexHeaderPoolC;

pub use clc0c0::InvalidateShaderCachesNoWfi;

pub use clc0c0::SetRenderEnableOverride;
pub use clc0c0::SetRenderEnableOverrideMode;

pub use clc0c0::PipeNop;

pub use clc0c0::SetSpare00;

pub use clc0c0::SetSpare01;

pub use clc0c0::SetSpare02;

pub use clc0c0::SetSpare03;

pub use clc0c0::SetReportSemaphoreA;

pub use clc0c0::SetReportSemaphoreB;

pub use clc0c0::SetReportSemaphoreC;

pub use clc0c0::SetReportSemaphoreD;
pub use clc0c0::SetReportSemaphoreDOperation;
pub use clc0c0::SetReportSemaphoreDReductionFormat;
pub use clc0c0::SetReportSemaphoreDReductionOp;
pub use clc0c0::SetReportSemaphoreDStructureSize;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerA {
    pub address_upper: u32,
}

impl Mthd for SetTrapHandlerA {
    const ADDR: u16 = 0x25f8;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerB {
    pub address_lower: u32,
}

impl Mthd for SetTrapHandlerB {
    const ADDR: u16 = 0x25fc;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

pub use clc0c0::SetBindlessTexture;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValue {
    const CLASS: u16 = 0xc3c0;

    fn addr(i: usize) -> u16 {
        (0x32f4 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValueUpper {
    const CLASS: u16 = 0xc3c0;

    fn addr(i: usize) -> u16 {
        (0x3314 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct EnableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for EnableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3334;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DisableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for DisableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3338;
    const CLASS: u16 = 0xc3c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc0c0::SetShaderPerformanceCounterValueUpper;

pub use clc0c0::SetShaderPerformanceCounterValue;

pub use clc0c0::SetShaderPerformanceCounterEvent;

pub use clc0c0::SetShaderPerformanceCounterControlA;

pub use clc0c0::SetShaderPerformanceCounterControlB;

pub use clc0c0::SetShaderPerformanceCounterTrapControl;

pub use clc0c0::StartShaderPerformanceCounter;

pub use clc0c0::StopShaderPerformanceCounter;

pub use clc0c0::SetShaderPerformanceCounterSctlFilter;

pub use clc0c0::SetShaderPerformanceCounterCoreMioFilter;

pub use clc0c0::SetMmeShadowScratch;
