use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc197::mthd as clc197;

// parsed class NVC397

pub use clc197::SetObject;

pub use clc197::NoOperation;

pub use clc197::SetNotifyA;

pub use clc197::SetNotifyB;

pub use clc197::Notify;
pub use clc197::NotifyType;

pub use clc197::WaitForIdle;

pub use clc197::LoadMmeInstructionRamPointer;

pub use clc197::LoadMmeInstructionRam;

pub use clc197::LoadMmeStartAddressRamPointer;

pub use clc197::LoadMmeStartAddressRam;

pub use clc197::SetMmeShadowRamControl;
pub use clc197::SetMmeShadowRamControlMode;

pub use clc197::PeerSemaphoreReleaseOffsetUpper;

pub use clc197::PeerSemaphoreReleaseOffset;

pub use clc197::SetGlobalRenderEnableA;

pub use clc197::SetGlobalRenderEnableB;

pub use clc197::SetGlobalRenderEnableC;
pub use clc197::SetGlobalRenderEnableCMode;

pub use clc197::SendGoIdle;

pub use clc197::PmTrigger;

pub use clc197::PmTriggerWfi;

pub use clc197::FeAtomicSequenceBegin;

pub use clc197::FeAtomicSequenceEnd;

pub use clc197::SetInstrumentationMethodHeader;

pub use clc197::SetInstrumentationMethodData;

pub use clc197::LineLengthIn;

pub use clc197::LineCount;

pub use clc197::OffsetOutUpper;

pub use clc197::OffsetOut;

pub use clc197::PitchOut;

pub use clc197::SetDstBlockSize;
pub use clc197::SetDstBlockSizeDepth;
pub use clc197::SetDstBlockSizeHeight;
pub use clc197::SetDstBlockSizeWidth;

pub use clc197::SetDstWidth;

pub use clc197::SetDstHeight;

pub use clc197::SetDstDepth;

pub use clc197::SetDstLayer;

pub use clc197::SetDstOriginBytesX;

pub use clc197::SetDstOriginSamplesY;

pub use clc197::LaunchDma;
pub use clc197::LaunchDmaCompletionType;
pub use clc197::LaunchDmaDstMemoryLayout;
pub use clc197::LaunchDmaInterruptType;
pub use clc197::LaunchDmaReductionFormat;
pub use clc197::LaunchDmaReductionOp;
pub use clc197::LaunchDmaSemaphoreStructSize;

pub use clc197::LoadInlineData;

pub use clc197::SetI2MSemaphoreA;

pub use clc197::SetI2MSemaphoreB;

pub use clc197::SetI2MSemaphoreC;

pub use clc197::SetI2MSpareNoop00;

pub use clc197::SetI2MSpareNoop01;

pub use clc197::SetI2MSpareNoop02;

pub use clc197::SetI2MSpareNoop03;

pub use clc197::RunDsNow;

pub use clc197::SetOpportunisticEarlyZHysteresis;
pub use clc197::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use clc197::SetGsMode;
pub use clc197::SetGsModeType;

pub use clc197::SetAliasedLineWidthEnable;

pub use clc197::SetApiMandatedEarlyZ;

pub use clc197::SetGsDmFifo;

pub use clc197::SetL2CacheControlForRopPrefetchReadRequests;
pub use clc197::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clc197::InvalidateShaderCaches;

pub use clc197::SetInstanceCount;

pub use clc197::SetPositionWScaledOffsetEnable;

pub use clc197::SetMultiView;

pub use clc197::SetGoIdleTimeout;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetConservativeRasterControlExtraPrimBloat {
    Bloat0 = 0x00000000,
    Bloat25 = 0x00000001,
    Bloat50 = 0x00000002,
    Bloat75 = 0x00000003,
    BloatPri = 0x00000004,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetConservativeRasterControlTriangleSnapMode {
    ModePostSnap = 0x00000000,
    ModePreSnap = 0x00000001,
    ModePri = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetConservativeRasterControlLineAndPointSnapMode {
    ModePostSnap = 0x00000000,
    ModePreSnap = 0x00000001,
    ModePri = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetConservativeRasterControlUncertaintyRegionSize {
    Size64 = 0x00000000,
    Size128 = 0x00000001,
    Size256 = 0x00000002,
    Size512 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConservativeRasterControl {
    pub extra_prim_bloat: SetConservativeRasterControlExtraPrimBloat,
    pub copy_inner_to_outer: bool,
    pub triangle_snap_mode: SetConservativeRasterControlTriangleSnapMode,
    pub line_and_point_snap_mode: SetConservativeRasterControlLineAndPointSnapMode,
    pub uncertainty_region_size: SetConservativeRasterControlUncertaintyRegionSize,
}

impl Mthd for SetConservativeRasterControl {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.extra_prim_bloat as u32) < (1 << 4));
        val |= (self.extra_prim_bloat as u32) << 0;

        assert!((self.copy_inner_to_outer as u32) < (1 << 1));
        val |= (self.copy_inner_to_outer as u32) << 4;

        assert!((self.triangle_snap_mode as u32) < (1 << 3));
        val |= (self.triangle_snap_mode as u32) << 8;

        assert!((self.line_and_point_snap_mode as u32) < (1 << 3));
        val |= (self.line_and_point_snap_mode as u32) << 12;

        assert!((self.uncertainty_region_size as u32) < (1 << 4));
        val |= (self.uncertainty_region_size as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMmeVersion {
    pub major: u32,
}

impl Mthd for SetMmeVersion {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.major < (1 << 8));
        val |= self.major << 0;

        val
    }
}

pub use clc197::IncrementSyncPoint;
pub use clc197::IncrementSyncPointCondition;

pub use clc197::FlushAndInvalidateRopMiniCache;

pub use clc197::SetSurfaceClipIdBlockSize;
pub use clc197::SetSurfaceClipIdBlockSizeDepth;
pub use clc197::SetSurfaceClipIdBlockSizeHeight;
pub use clc197::SetSurfaceClipIdBlockSizeWidth;

pub use clc197::SetAlphaCircularBufferSize;

pub use clc197::DecompressSurface;

pub use clc197::SetZcullRopBypass;

pub use clc197::SetZcullSubregion;

pub use clc197::SetRasterBoundingBox;
pub use clc197::SetRasterBoundingBoxMode;

pub use clc197::PeerSemaphoreRelease;

pub use clc197::SetIteratedBlendOptimization;
pub use clc197::SetIteratedBlendOptimizationNoop;

pub use clc197::SetZcullSubregionAllocation;
pub use clc197::SetZcullSubregionAllocationFormat;

pub use clc197::AssignZcullSubregions;
pub use clc197::AssignZcullSubregionsAlgorithm;

pub use clc197::SetPsOutputSampleMaskUsage;
pub use clc197::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clc197::DrawZeroIndex;

pub use clc197::SetL1Configuration;
pub use clc197::SetL1ConfigurationDirectlyAddressableMemory;

pub use clc197::SetRenderEnableControl;

pub use clc197::SetSpaVersion;

pub use clc197::SetSnapGridLine;
pub use clc197::SetSnapGridLineLocationsPerPixel;
pub use clc197::SetSnapGridLineRoundingMode;

pub use clc197::SetSnapGridNonLine;
pub use clc197::SetSnapGridNonLineLocationsPerPixel;
pub use clc197::SetSnapGridNonLineRoundingMode;

pub use clc197::SetTessellationParameters;
pub use clc197::SetTessellationParametersDomainType;
pub use clc197::SetTessellationParametersOutputPrimitives;
pub use clc197::SetTessellationParametersSpacing;

pub use clc197::SetTessellationLodU0OrDensity;

pub use clc197::SetTessellationLodV0OrDetail;

pub use clc197::SetTessellationLodU1OrW0;

pub use clc197::SetTessellationLodV1;

pub use clc197::SetTgLodInteriorU;

pub use clc197::SetTgLodInteriorV;

pub use clc197::ReservedTg07;

pub use clc197::ReservedTg08;

pub use clc197::ReservedTg09;

pub use clc197::ReservedTg10;

pub use clc197::ReservedTg11;

pub use clc197::ReservedTg12;

pub use clc197::ReservedTg13;

pub use clc197::ReservedTg14;

pub use clc197::ReservedTg15;

pub use clc197::SetSubtilingPerfKnobA;

pub use clc197::SetSubtilingPerfKnobB;

pub use clc197::SetSubtilingPerfKnobC;

pub use clc197::SetZcullSubregionToReport;

pub use clc197::SetZcullSubregionReportType;
pub use clc197::SetZcullSubregionReportTypeType;

pub use clc197::SetBalancedPrimitiveWorkload;

pub use clc197::SetMaxPatchesPerBatch;

pub use clc197::SetRasterEnable;

pub use clc197::SetStreamOutBufferEnable;

pub use clc197::SetStreamOutBufferAddressA;

pub use clc197::SetStreamOutBufferAddressB;

pub use clc197::SetStreamOutBufferSize;

pub use clc197::SetStreamOutBufferLoadWritePointer;

pub use clc197::SetPositionWScaledOffsetScaleA;

pub use clc197::SetPositionWScaledOffsetScaleB;

pub use clc197::SetPositionWScaledOffsetReservedA;

pub use clc197::SetPositionWScaledOffsetReservedB;

pub use clc197::SetStreamOutControlStream;

pub use clc197::SetStreamOutControlComponentCount;

pub use clc197::SetStreamOutControlStride;

pub use clc197::SetRasterInput;

pub use clc197::SetStreamOutput;

pub use clc197::SetDaPrimitiveRestartTopologyChange;

pub use clc197::SetHybridAntiAliasControl;
pub use clc197::SetHybridAntiAliasControlCentroid;

pub use clc197::SetShaderLocalMemoryWindow;

pub use clc197::SetShaderLocalMemoryA;

pub use clc197::SetShaderLocalMemoryB;

pub use clc197::SetShaderLocalMemoryC;

pub use clc197::SetShaderLocalMemoryD;

pub use clc197::SetShaderLocalMemoryE;

pub use clc197::SetColorZeroBandwidthClear;

pub use clc197::SetZZeroBandwidthClear;

pub use clc197::SetStencilZeroBandwidthClear;

pub use clc197::SetZcullRegionSizeA;

pub use clc197::SetZcullRegionSizeB;

pub use clc197::SetZcullRegionSizeC;

pub use clc197::SetZcullRegionPixelOffsetC;

pub use clc197::SetCullBeforeFetch;

pub use clc197::SetZcullRegionLocation;

pub use clc197::SetZcullRegionAliquots;

pub use clc197::SetZcullStorageA;

pub use clc197::SetZcullStorageB;

pub use clc197::SetZcullStorageC;

pub use clc197::SetZcullStorageD;

pub use clc197::SetZtReadOnly;

pub use clc197::SetColorTargetA;

pub use clc197::SetColorTargetB;

pub use clc197::SetColorTargetWidth;

pub use clc197::SetColorTargetHeight;

pub use clc197::SetColorTargetFormat;
pub use clc197::SetColorTargetFormatV;

pub use clc197::SetColorTargetMemory;
pub use clc197::SetColorTargetMemoryBlockDepth;
pub use clc197::SetColorTargetMemoryBlockHeight;
pub use clc197::SetColorTargetMemoryBlockWidth;
pub use clc197::SetColorTargetMemoryLayout;
pub use clc197::SetColorTargetMemoryThirdDimensionControl;

pub use clc197::SetColorTargetThirdDimension;

pub use clc197::SetColorTargetArrayPitch;

pub use clc197::SetColorTargetLayer;

pub use clc197::SetViewportScaleX;

pub use clc197::SetViewportScaleY;

pub use clc197::SetViewportScaleZ;

pub use clc197::SetViewportOffsetX;

pub use clc197::SetViewportOffsetY;

pub use clc197::SetViewportOffsetZ;

pub use clc197::SetViewportCoordinateSwizzle;
pub use clc197::SetViewportCoordinateSwizzleW;
pub use clc197::SetViewportCoordinateSwizzleX;
pub use clc197::SetViewportCoordinateSwizzleY;
pub use clc197::SetViewportCoordinateSwizzleZ;

pub use clc197::SetViewportIncreaseSnapGridPrecision;

pub use clc197::SetViewportClipHorizontal;

pub use clc197::SetViewportClipVertical;

pub use clc197::SetViewportClipMinZ;

pub use clc197::SetViewportClipMaxZ;

pub use clc197::SetWindowClipHorizontal;

pub use clc197::SetWindowClipVertical;

pub use clc197::SetClipIdExtentX;

pub use clc197::SetClipIdExtentY;

pub use clc197::SetMaxStreamOutputGsInstancesPerTask;

pub use clc197::SetApiVisibleCallLimit;
pub use clc197::SetApiVisibleCallLimitV;

pub use clc197::SetStatisticsCounter;

pub use clc197::SetClearRectHorizontal;

pub use clc197::SetClearRectVertical;

pub use clc197::SetVertexArrayStart;

pub use clc197::DrawVertexArray;

pub use clc197::SetViewportZClip;
pub use clc197::SetViewportZClipRange;

pub use clc197::SetColorClearValue;

pub use clc197::SetZClearValue;

pub use clc197::SetShaderCacheControl;

pub use clc197::ForceTransitionToBeta;

pub use clc197::SetReduceColorThresholdsEnable;

pub use clc197::SetStencilClearValue;

pub use clc197::InvalidateShaderCachesNoWfi;

pub use clc197::SetZcullSerialization;
pub use clc197::SetZcullSerializationApplied;

pub use clc197::SetFrontPolygonMode;
pub use clc197::SetFrontPolygonModeV;

pub use clc197::SetBackPolygonMode;
pub use clc197::SetBackPolygonModeV;

pub use clc197::SetPolySmooth;

pub use clc197::SetZcullDirFormat;
pub use clc197::SetZcullDirFormatZdir;
pub use clc197::SetZcullDirFormatZformat;

pub use clc197::SetPolyOffsetPoint;

pub use clc197::SetPolyOffsetLine;

pub use clc197::SetPolyOffsetFill;

pub use clc197::SetPatch;

pub use clc197::SetIteratedBlend;

pub use clc197::SetIteratedBlendPass;

pub use clc197::SetZcullCriterion;
pub use clc197::SetZcullCriterionSfunc;

pub use clc197::PixelShaderBarrier;

pub use clc197::SetSmTimeoutInterval;

pub use clc197::SetDaPrimitiveRestartVertexArray;

pub use clc197::LoadIteratedBlendInstructionPointer;

pub use clc197::LoadIteratedBlendInstruction;
pub use clc197::LoadIteratedBlendInstructionConstantInputSelect;
pub use clc197::LoadIteratedBlendInstructionOperandASelect;
pub use clc197::LoadIteratedBlendInstructionOperandBSelect;
pub use clc197::LoadIteratedBlendInstructionOperandCSelect;
pub use clc197::LoadIteratedBlendInstructionOperandDSelect;
pub use clc197::LoadIteratedBlendInstructionOperation;
pub use clc197::LoadIteratedBlendInstructionOutputSwizzle;
pub use clc197::LoadIteratedBlendInstructionOutputWriteMask;
pub use clc197::LoadIteratedBlendInstructionPassOutput;
pub use clc197::LoadIteratedBlendInstructionTestCc;

pub use clc197::SetWindowOffsetX;

pub use clc197::SetWindowOffsetY;

pub use clc197::SetScissorEnable;

pub use clc197::SetScissorHorizontal;

pub use clc197::SetScissorVertical;

pub use clc197::SetVpcPerfKnob;

pub use clc197::PmLocalTrigger;

pub use clc197::SetPostZPsImask;

pub use clc197::SetConstantColorRendering;

pub use clc197::SetConstantColorRenderingRed;

pub use clc197::SetConstantColorRenderingGreen;

pub use clc197::SetConstantColorRenderingBlue;

pub use clc197::SetConstantColorRenderingAlpha;

pub use clc197::SetBackStencilFuncRef;

pub use clc197::SetBackStencilMask;

pub use clc197::SetBackStencilFuncMask;

pub use clc197::SetVertexStreamSubstituteA;

pub use clc197::SetVertexStreamSubstituteB;

pub use clc197::SetLineModePolygonClip;
pub use clc197::SetLineModePolygonClipGeneratedEdge;

pub use clc197::SetSingleCtWriteControl;

pub use clc197::SetVtgWarpWatermarks;

pub use clc197::SetDepthBoundsMin;

pub use clc197::SetDepthBoundsMax;

pub use clc197::SetSampleMask;

pub use clc197::SetColorTargetSampleMask;

pub use clc197::SetCtMrtEnable;

pub use clc197::SetNonmultisampledZ;
pub use clc197::SetNonmultisampledZV;

pub use clc197::SetTir;
pub use clc197::SetTirMode;

pub use clc197::SetAntiAliasRaster;
pub use clc197::SetAntiAliasRasterSamples;

pub use clc197::SetSampleMaskX0Y0;

pub use clc197::SetSampleMaskX1Y0;

pub use clc197::SetSampleMaskX0Y1;

pub use clc197::SetSampleMaskX1Y1;

pub use clc197::SetSurfaceClipIdMemoryA;

pub use clc197::SetSurfaceClipIdMemoryB;

pub use clc197::SetTirModulation;
pub use clc197::SetTirModulationComponentSelect;

pub use clc197::SetTirModulationFunction;
pub use clc197::SetTirModulationFunctionSelect;

pub use clc197::SetBlendOptControl;

pub use clc197::SetZtA;

pub use clc197::SetZtB;

pub use clc197::SetZtFormat;
pub use clc197::SetZtFormatV;

pub use clc197::SetZtBlockSize;
pub use clc197::SetZtBlockSizeDepth;
pub use clc197::SetZtBlockSizeHeight;
pub use clc197::SetZtBlockSizeWidth;

pub use clc197::SetZtArrayPitch;

pub use clc197::SetSurfaceClipHorizontal;

pub use clc197::SetSurfaceClipVertical;

pub use clc197::SetL2CacheControlForVafRequests;
pub use clc197::SetL2CacheControlForVafRequestsPolicy;

pub use clc197::SetViewportMulticast;
pub use clc197::SetViewportMulticastOrder;

pub use clc197::SetTessellationCutHeight;

pub use clc197::SetMaxGsInstancesPerTask;

pub use clc197::SetMaxGsOutputVerticesPerTask;

pub use clc197::SetReservedSwMethod00;

pub use clc197::SetGsOutputCbStorageMultiplier;

pub use clc197::SetBetaCbStorageConstraint;

pub use clc197::SetTiOutputCbStorageMultiplier;

pub use clc197::SetAlphaCbStorageConstraint;

pub use clc197::SetReservedSwMethod01;

pub use clc197::SetReservedSwMethod02;

pub use clc197::SetTirModulationCoefficientTable;

pub use clc197::SetSpareNoop01;

pub use clc197::SetSpareNoop02;

pub use clc197::SetSpareNoop03;

pub use clc197::SetSpareNoop04;

pub use clc197::SetSpareNoop05;

pub use clc197::SetSpareNoop06;

pub use clc197::SetSpareNoop07;

pub use clc197::SetSpareNoop08;

pub use clc197::SetSpareNoop09;

pub use clc197::SetSpareNoop10;

pub use clc197::SetSpareNoop11;

pub use clc197::SetSpareNoop12;

pub use clc197::SetSpareNoop13;

pub use clc197::SetSpareNoop14;

pub use clc197::SetSpareNoop15;

pub use clc197::SetReservedSwMethod03;

pub use clc197::SetReservedSwMethod04;

pub use clc197::SetReservedSwMethod05;

pub use clc197::SetReservedSwMethod06;

pub use clc197::SetReservedSwMethod07;

pub use clc197::SetReservedSwMethod08;

pub use clc197::SetReservedSwMethod09;

pub use clc197::SetReduceColorThresholdsUnorm8;

pub use clc197::SetReservedSwMethod10;

pub use clc197::SetReservedSwMethod11;

pub use clc197::SetReservedSwMethod12;

pub use clc197::SetReservedSwMethod13;

pub use clc197::SetReduceColorThresholdsUnorm10;

pub use clc197::SetReduceColorThresholdsUnorm16;

pub use clc197::SetReduceColorThresholdsFp11;

pub use clc197::SetReduceColorThresholdsFp16;

pub use clc197::SetReduceColorThresholdsSrgb8;

pub use clc197::UnbindAll;

pub use clc197::SetClearSurfaceControl;

pub use clc197::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clc197::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clc197::SetReservedSwMethod14;

pub use clc197::SetReservedSwMethod15;

pub use clc197::NoOperationDataHi;

pub use clc197::SetDepthBiasControl;

pub use clc197::PmTriggerEnd;

pub use clc197::SetVertexIdBase;

pub use clc197::SetStencilCompression;

pub use clc197::SetDaOutputAttributeSkipMaskA;

pub use clc197::SetDaOutputAttributeSkipMaskB;

pub use clc197::SetTirControl;
pub use clc197::SetTirControlAlphaToCoverageUseRasterSamples;
pub use clc197::SetTirControlReduceCoverage;
pub use clc197::SetTirControlZPassPixelCountUseRasterSamples;

pub use clc197::SetMutableMethodControl;

pub use clc197::SetPostPsInitialCoverage;

pub use clc197::SetFillViaTriangle;
pub use clc197::SetFillViaTriangleMode;

pub use clc197::SetBlendPerFormatEnable;

pub use clc197::FlushPendingWrites;

pub use clc197::SetConservativeRaster;

pub use clc197::SetVertexAttributeA;
pub use clc197::SetVertexAttributeAComponentBitWidths;
pub use clc197::SetVertexAttributeANumericalType;
pub use clc197::SetVertexAttributeASource;

pub use clc197::SetVertexAttributeB;
pub use clc197::SetVertexAttributeBComponentBitWidths;
pub use clc197::SetVertexAttributeBNumericalType;
pub use clc197::SetVertexAttributeBSource;

pub use clc197::SetAntiAliasSamplePositions;

pub use clc197::SetOffsetRenderTargetIndex;

pub use clc197::ForceHeavyweightMethodSync;

pub use clc197::SetCoverageToColor;

pub use clc197::DecompressZetaSurface;

pub use clc197::SetScreenStateMask;

pub use clc197::SetZtSparse;
pub use clc197::SetZtSparseUnmappedCompare;

pub use clc197::InvalidateSamplerCacheAll;

pub use clc197::InvalidateTextureHeaderCacheAll;

pub use clc197::DrawVertexArrayBeginEndInstanceFirst;
pub use clc197::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clc197::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clc197::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clc197::SetCtSelect;

pub use clc197::SetCompressionThreshold;
pub use clc197::SetCompressionThresholdSamples;

pub use clc197::SetPixelShaderInterlockControl;
pub use clc197::SetPixelShaderInterlockControlTileCoalescerFragmentOrder;
pub use clc197::SetPixelShaderInterlockControlTileCoalescerMode;
pub use clc197::SetPixelShaderInterlockControlTileCoalescerTileSize;

pub use clc197::SetZtSizeA;

pub use clc197::SetZtSizeB;

pub use clc197::SetZtSizeC;
pub use clc197::SetZtSizeCControl;

pub use clc197::SetSamplerBinding;
pub use clc197::SetSamplerBindingV;

pub use clc197::DrawAuto;

pub use clc197::SetPostVtgShaderAttributeSkipMask;

pub use clc197::SetPixelShaderTicketDispenserValue;

pub use clc197::SetBackEndCopyA;

pub use clc197::SetBackEndCopyB;

pub use clc197::SetBackEndCopyC;

pub use clc197::SetBackEndCopyD;

pub use clc197::SetBackEndCopyE;

pub use clc197::SetCircularBufferSize;

pub use clc197::SetVtgRegisterWatermarks;

pub use clc197::InvalidateTextureDataCacheNoWfi;
pub use clc197::InvalidateTextureDataCacheNoWfiLines;

pub use clc197::SetL2CacheControlForRopInterlockedReadRequests;
pub use clc197::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clc197::SetDaPrimitiveRestartIndexTopologyChange;

pub use clc197::ClearZcullRegion;

pub use clc197::SetDepthTest;

pub use clc197::SetFillMode;
pub use clc197::SetFillModeV;

pub use clc197::SetShadeMode;
pub use clc197::SetShadeModeV;

pub use clc197::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clc197::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clc197::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clc197::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clc197::SetAlphaToCoverageDitherControl;
pub use clc197::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clc197::SetBlendStatePerTarget;

pub use clc197::SetDepthWrite;

pub use clc197::SetAlphaTest;

pub use clc197::SetInlineIndex4X8Align;

pub use clc197::DrawInlineIndex4X8;

pub use clc197::D3DSetCullMode;
pub use clc197::D3DSetCullModeV;

pub use clc197::SetDepthFunc;
pub use clc197::SetDepthFuncV;

pub use clc197::SetAlphaRef;

pub use clc197::SetAlphaFunc;
pub use clc197::SetAlphaFuncV;

pub use clc197::SetDrawAutoStride;

pub use clc197::SetBlendConstRed;

pub use clc197::SetBlendConstGreen;

pub use clc197::SetBlendConstBlue;

pub use clc197::SetBlendConstAlpha;

pub use clc197::InvalidateSamplerCache;
pub use clc197::InvalidateSamplerCacheLines;

pub use clc197::InvalidateTextureHeaderCache;
pub use clc197::InvalidateTextureHeaderCacheLines;

pub use clc197::InvalidateTextureDataCache;
pub use clc197::InvalidateTextureDataCacheLines;

pub use clc197::SetBlendSeparateForAlpha;

pub use clc197::SetBlendColorOp;
pub use clc197::SetBlendColorOpV;

pub use clc197::SetBlendColorSourceCoeff;
pub use clc197::SetBlendColorSourceCoeffV;

pub use clc197::SetBlendColorDestCoeff;
pub use clc197::SetBlendColorDestCoeffV;

pub use clc197::SetBlendAlphaOp;
pub use clc197::SetBlendAlphaOpV;

pub use clc197::SetBlendAlphaSourceCoeff;
pub use clc197::SetBlendAlphaSourceCoeffV;

pub use clc197::SetGlobalColorKey;

pub use clc197::SetBlendAlphaDestCoeff;
pub use clc197::SetBlendAlphaDestCoeffV;

pub use clc197::SetSingleRopControl;

pub use clc197::SetBlend;

pub use clc197::SetStencilTest;

pub use clc197::SetStencilOpFail;
pub use clc197::SetStencilOpFailV;

pub use clc197::SetStencilOpZfail;
pub use clc197::SetStencilOpZfailV;

pub use clc197::SetStencilOpZpass;
pub use clc197::SetStencilOpZpassV;

pub use clc197::SetStencilFunc;
pub use clc197::SetStencilFuncV;

pub use clc197::SetStencilFuncRef;

pub use clc197::SetStencilFuncMask;

pub use clc197::SetStencilMask;

pub use clc197::SetDrawAutoStart;

pub use clc197::SetPsSaturate;
pub use clc197::SetPsSaturateClampRange0;
pub use clc197::SetPsSaturateClampRange1;
pub use clc197::SetPsSaturateClampRange2;
pub use clc197::SetPsSaturateClampRange3;
pub use clc197::SetPsSaturateClampRange4;
pub use clc197::SetPsSaturateClampRange5;
pub use clc197::SetPsSaturateClampRange6;
pub use clc197::SetPsSaturateClampRange7;

pub use clc197::SetWindowOrigin;
pub use clc197::SetWindowOriginMode;

pub use clc197::SetLineWidthFloat;

pub use clc197::SetAliasedLineWidthFloat;

pub use clc197::SetLineMultisampleOverride;

pub use clc197::InvalidateSamplerCacheNoWfi;
pub use clc197::InvalidateSamplerCacheNoWfiLines;

pub use clc197::InvalidateTextureHeaderCacheNoWfi;
pub use clc197::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc197::SetGlobalBaseVertexIndex;

pub use clc197::SetGlobalBaseInstanceIndex;

pub use clc197::SetPsWarpWatermarks;

pub use clc197::SetPsRegisterWatermarks;

pub use clc197::StoreZcull;

pub use clc197::SetIteratedBlendConstantRed;

pub use clc197::SetIteratedBlendConstantGreen;

pub use clc197::SetIteratedBlendConstantBlue;

pub use clc197::LoadZcull;

pub use clc197::SetSurfaceClipIdHeight;

pub use clc197::SetClipIdClearRectHorizontal;

pub use clc197::SetClipIdClearRectVertical;

pub use clc197::SetUserClipEnable;

pub use clc197::SetZpassPixelCount;

pub use clc197::SetPointSize;

pub use clc197::SetZcullStats;

pub use clc197::SetPointSprite;

pub use clc197::SetShaderExceptions;

pub use clc197::ClearReportValue;
pub use clc197::ClearReportValueType;

pub use clc197::SetAntiAliasEnable;

pub use clc197::SetZtSelect;

pub use clc197::SetAntiAliasAlphaControl;
pub use clc197::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clc197::SetAntiAliasAlphaControlAlphaToOne;

pub use clc197::SetRenderEnableA;

pub use clc197::SetRenderEnableB;

pub use clc197::SetRenderEnableC;
pub use clc197::SetRenderEnableCMode;

pub use clc197::SetTexSamplerPoolA;

pub use clc197::SetTexSamplerPoolB;

pub use clc197::SetTexSamplerPoolC;

pub use clc197::SetSlopeScaleDepthBias;

pub use clc197::SetAntiAliasedLine;

pub use clc197::SetTexHeaderPoolA;

pub use clc197::SetTexHeaderPoolB;

pub use clc197::SetTexHeaderPoolC;

pub use clc197::SetActiveZcullRegion;

pub use clc197::SetTwoSidedStencilTest;

pub use clc197::SetBackStencilOpFail;
pub use clc197::SetBackStencilOpFailV;

pub use clc197::SetBackStencilOpZfail;
pub use clc197::SetBackStencilOpZfailV;

pub use clc197::SetBackStencilOpZpass;
pub use clc197::SetBackStencilOpZpassV;

pub use clc197::SetBackStencilFunc;
pub use clc197::SetBackStencilFuncV;

pub use clc197::SetSrgbWrite;

pub use clc197::SetDepthBias;

pub use clc197::SetZcullRegionFormat;
pub use clc197::SetZcullRegionFormatType;

pub use clc197::SetRtLayer;
pub use clc197::SetRtLayerControl;

pub use clc197::SetAntiAlias;
pub use clc197::SetAntiAliasSamples;

pub use clc197::SetEdgeFlag;

pub use clc197::DrawInlineIndex;

pub use clc197::SetInlineIndex2X16Align;

pub use clc197::DrawInlineIndex2X16;

pub use clc197::SetVertexGlobalBaseOffsetA;

pub use clc197::SetVertexGlobalBaseOffsetB;

pub use clc197::SetZcullRegionPixelOffsetA;

pub use clc197::SetZcullRegionPixelOffsetB;

pub use clc197::SetPointSpriteSelect;
pub use clc197::SetPointSpriteSelectOrigin;
pub use clc197::SetPointSpriteSelectRmode;
pub use clc197::SetPointSpriteSelectTexture0;
pub use clc197::SetPointSpriteSelectTexture1;
pub use clc197::SetPointSpriteSelectTexture2;
pub use clc197::SetPointSpriteSelectTexture3;
pub use clc197::SetPointSpriteSelectTexture4;
pub use clc197::SetPointSpriteSelectTexture5;
pub use clc197::SetPointSpriteSelectTexture6;
pub use clc197::SetPointSpriteSelectTexture7;
pub use clc197::SetPointSpriteSelectTexture8;
pub use clc197::SetPointSpriteSelectTexture9;

pub use clc197::SetAttributeDefault;
pub use clc197::SetAttributeDefaultColorFrontDiffuse;
pub use clc197::SetAttributeDefaultColorFrontSpecular;
pub use clc197::SetAttributeDefaultDx9Color0;
pub use clc197::SetAttributeDefaultDx9Color1ToColor15;
pub use clc197::SetAttributeDefaultFixedFncTexture;
pub use clc197::SetAttributeDefaultGenericVector;

pub use clc197::End;

pub use clc197::Begin;
pub use clc197::BeginInstanceId;
pub use clc197::BeginOp;
pub use clc197::BeginPrimitiveId;
pub use clc197::BeginSplitMode;

pub use clc197::SetVertexIdCopy;

pub use clc197::AddToPrimitiveId;

pub use clc197::LoadPrimitiveId;

pub use clc197::SetShaderBasedCull;

pub use clc197::SetClassVersion;

pub use clc197::SetDaPrimitiveRestart;

pub use clc197::SetDaPrimitiveRestartIndex;

pub use clc197::SetDaOutput;

pub use clc197::SetAntiAliasedPoint;

pub use clc197::SetPointCenterMode;
pub use clc197::SetPointCenterModeV;

pub use clc197::SetLineSmoothParameters;
pub use clc197::SetLineSmoothParametersFalloff;

pub use clc197::SetLineStipple;

pub use clc197::SetLineSmoothEdgeTable;

pub use clc197::SetLineStippleParameters;

pub use clc197::SetProvokingVertex;
pub use clc197::SetProvokingVertexV;

pub use clc197::SetTwoSidedLight;

pub use clc197::SetPolygonStipple;

pub use clc197::SetShaderControl;
pub use clc197::SetShaderControlDefaultPartial;
pub use clc197::SetShaderControlFp32F2INanBehavior;
pub use clc197::SetShaderControlFp32NanBehavior;

pub use clc197::CheckClassVersion;

pub use clc197::SetSphVersion;

pub use clc197::CheckSphVersion;

pub use clc197::SetAlphaToCoverageOverride;
pub use clc197::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clc197::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use clc197::SetPolygonStipplePattern;

pub use clc197::SetAamVersion;

pub use clc197::CheckAamVersion;

pub use clc197::SetZtLayer;

pub use clc197::SetIndexBufferA;

pub use clc197::SetIndexBufferB;

pub use clc197::SetIndexBufferC;

pub use clc197::SetIndexBufferD;

pub use clc197::SetIndexBufferE;
pub use clc197::SetIndexBufferEIndexSize;

pub use clc197::SetIndexBufferF;

pub use clc197::DrawIndexBuffer;

pub use clc197::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clc197::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clc197::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clc197::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clc197::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clc197::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clc197::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clc197::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clc197::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clc197::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clc197::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clc197::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clc197::SetDepthBiasClamp;

pub use clc197::SetVertexStreamInstanceA;

pub use clc197::SetVertexStreamInstanceB;

pub use clc197::SetAttributePointSize;

pub use clc197::OglSetCull;

pub use clc197::OglSetFrontFace;
pub use clc197::OglSetFrontFaceV;

pub use clc197::OglSetCullFace;
pub use clc197::OglSetCullFaceV;

pub use clc197::SetViewportPixel;
pub use clc197::SetViewportPixelCenter;

pub use clc197::SetViewportScaleOffset;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlZClipRange {
    UseFieldMinZZeroMaxZOne = 0x00000000,
    MinZMaxZ = 0x00000001,
    ZeroOne = 0x00000002,
    MinusInfPlusInf = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMinZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMaxZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlLinePointCullGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryClip {
    WzeroClip = 0x00000000,
    Passthru = 0x00000001,
    FrustumXyClip = 0x00000002,
    FrustumXyzClip = 0x00000003,
    WzeroClipNoZCull = 0x00000004,
    FrustumZClip = 0x00000005,
    WzeroTriFillOrClip = 0x00000006,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardbandZ {
    SameAsXyGuardband = 0x00000000,
    Scale256 = 0x00000001,
    Scale1 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipControl {
    pub min_z_zero_max_z_one: bool,
    pub z_clip_range: SetViewportClipControlZClipRange,
    pub pixel_min_z: SetViewportClipControlPixelMinZ,
    pub pixel_max_z: SetViewportClipControlPixelMaxZ,
    pub geometry_guardband: SetViewportClipControlGeometryGuardband,
    pub line_point_cull_guardband: SetViewportClipControlLinePointCullGuardband,
    pub geometry_clip: SetViewportClipControlGeometryClip,
    pub geometry_guardband_z: SetViewportClipControlGeometryGuardbandZ,
}

impl Mthd for SetViewportClipControl {
    const ADDR: u16 = 0x193c;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.min_z_zero_max_z_one as u32) < (1 << 1));
        val |= (self.min_z_zero_max_z_one as u32) << 0;

        assert!((self.z_clip_range as u32) < (1 << 2));
        val |= (self.z_clip_range as u32) << 16;

        assert!((self.pixel_min_z as u32) < (1 << 1));
        val |= (self.pixel_min_z as u32) << 3;

        assert!((self.pixel_max_z as u32) < (1 << 1));
        val |= (self.pixel_max_z as u32) << 4;

        assert!((self.geometry_guardband as u32) < (1 << 1));
        val |= (self.geometry_guardband as u32) << 7;

        assert!((self.line_point_cull_guardband as u32) < (1 << 1));
        val |= (self.line_point_cull_guardband as u32) << 10;

        assert!((self.geometry_clip as u32) < (1 << 3));
        val |= (self.geometry_clip as u32) << 11;

        assert!((self.geometry_guardband_z as u32) < (1 << 2));
        val |= (self.geometry_guardband_z as u32) << 1;

        val
    }
}

pub use clc197::SetUserClipOp;
pub use clc197::SetUserClipOpPlane0;
pub use clc197::SetUserClipOpPlane1;
pub use clc197::SetUserClipOpPlane2;
pub use clc197::SetUserClipOpPlane3;
pub use clc197::SetUserClipOpPlane4;
pub use clc197::SetUserClipOpPlane5;
pub use clc197::SetUserClipOpPlane6;
pub use clc197::SetUserClipOpPlane7;

pub use clc197::SetRenderEnableOverride;
pub use clc197::SetRenderEnableOverrideMode;

pub use clc197::SetPrimitiveTopologyControl;
pub use clc197::SetPrimitiveTopologyControlOverride;

pub use clc197::SetWindowClipEnable;

pub use clc197::SetWindowClipType;
pub use clc197::SetWindowClipTypeV;

pub use clc197::InvalidateZcull;
pub use clc197::InvalidateZcullV;

pub use clc197::SetZcull;

pub use clc197::SetZcullBounds;

pub use clc197::SetPrimitiveTopology;
pub use clc197::SetPrimitiveTopologyV;

pub use clc197::ZcullSync;

pub use clc197::SetClipIdTest;

pub use clc197::SetSurfaceClipIdWidth;

pub use clc197::SetClipId;

pub use clc197::SetDepthBoundsTest;

pub use clc197::SetBlendFloatOption;

pub use clc197::SetLogicOp;

pub use clc197::SetLogicOpFunc;
pub use clc197::SetLogicOpFuncV;

pub use clc197::SetZCompression;

pub use clc197::ClearSurface;

pub use clc197::ClearClipIdSurface;

pub use clc197::SetColorCompression;

pub use clc197::SetCtWrite;

pub use clc197::PipeNop;

pub use clc197::SetSpare00;

pub use clc197::SetSpare01;

pub use clc197::SetSpare02;

pub use clc197::SetSpare03;

pub use clc197::SetReportSemaphoreA;

pub use clc197::SetReportSemaphoreB;

pub use clc197::SetReportSemaphoreC;

pub use clc197::SetReportSemaphoreD;
pub use clc197::SetReportSemaphoreDAcquire;
pub use clc197::SetReportSemaphoreDComparison;
pub use clc197::SetReportSemaphoreDOperation;
pub use clc197::SetReportSemaphoreDPipelineLocation;
pub use clc197::SetReportSemaphoreDReductionFormat;
pub use clc197::SetReportSemaphoreDReductionOp;
pub use clc197::SetReportSemaphoreDRelease;
pub use clc197::SetReportSemaphoreDReport;
pub use clc197::SetReportSemaphoreDStructureSize;

pub use clc197::SetVertexStreamAFormat;

pub use clc197::SetVertexStreamALocationA;

pub use clc197::SetVertexStreamALocationB;

pub use clc197::SetVertexStreamAFrequency;

pub use clc197::SetVertexStreamBFormat;

pub use clc197::SetVertexStreamBLocationA;

pub use clc197::SetVertexStreamBLocationB;

pub use clc197::SetVertexStreamBFrequency;

pub use clc197::SetBlendPerTargetSeparateForAlpha;

pub use clc197::SetBlendPerTargetColorOp;
pub use clc197::SetBlendPerTargetColorOpV;

pub use clc197::SetBlendPerTargetColorSourceCoeff;
pub use clc197::SetBlendPerTargetColorSourceCoeffV;

pub use clc197::SetBlendPerTargetColorDestCoeff;
pub use clc197::SetBlendPerTargetColorDestCoeffV;

pub use clc197::SetBlendPerTargetAlphaOp;
pub use clc197::SetBlendPerTargetAlphaOpV;

pub use clc197::SetBlendPerTargetAlphaSourceCoeff;
pub use clc197::SetBlendPerTargetAlphaSourceCoeffV;

pub use clc197::SetBlendPerTargetAlphaDestCoeff;
pub use clc197::SetBlendPerTargetAlphaDestCoeffV;

pub use clc197::SetVertexStreamLimitAA;

pub use clc197::SetVertexStreamLimitAB;

pub use clc197::SetVertexStreamLimitBA;

pub use clc197::SetVertexStreamLimitBB;

pub use clc197::SetPipelineShader;
pub use clc197::SetPipelineShaderType;

pub use clc197::SetPipelineReservedA;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineRegisterCount {
    pub v: u32,
}

impl ArrayMthd for SetPipelineRegisterCount {
    const CLASS: u16 = 0xc397;

    fn addr(i: usize) -> u16 {
        (0x200c + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 9));
        val |= self.v << 0;

        val
    }
}

pub use clc197::SetPipelineBinding;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineProgramAddressA {
    pub upper: u32,
}

impl ArrayMthd for SetPipelineProgramAddressA {
    const CLASS: u16 = 0xc397;

    fn addr(i: usize) -> u16 {
        (0x2014 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.upper < (1 << 8));
        val |= self.upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPipelineProgramAddressB {
    pub lower: u32,
}

impl ArrayMthd for SetPipelineProgramAddressB {
    const CLASS: u16 = 0xc397;

    fn addr(i: usize) -> u16 {
        (0x2018 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.lower;

        val
    }
}

pub use clc197::SetPipelineReservedD;

pub use clc197::SetPipelineReservedE;

pub use clc197::SetFalcon00;

pub use clc197::SetFalcon01;

pub use clc197::SetFalcon02;

pub use clc197::SetFalcon03;

pub use clc197::SetFalcon04;

pub use clc197::SetFalcon05;

pub use clc197::SetFalcon06;

pub use clc197::SetFalcon07;

pub use clc197::SetFalcon08;

pub use clc197::SetFalcon09;

pub use clc197::SetFalcon10;

pub use clc197::SetFalcon11;

pub use clc197::SetFalcon12;

pub use clc197::SetFalcon13;

pub use clc197::SetFalcon14;

pub use clc197::SetFalcon15;

pub use clc197::SetFalcon16;

pub use clc197::SetFalcon17;

pub use clc197::SetFalcon18;

pub use clc197::SetFalcon19;

pub use clc197::SetFalcon20;

pub use clc197::SetFalcon21;

pub use clc197::SetFalcon22;

pub use clc197::SetFalcon23;

pub use clc197::SetFalcon24;

pub use clc197::SetFalcon25;

pub use clc197::SetFalcon26;

pub use clc197::SetFalcon27;

pub use clc197::SetFalcon28;

pub use clc197::SetFalcon29;

pub use clc197::SetFalcon30;

pub use clc197::SetFalcon31;

pub use clc197::SetConstantBufferSelectorA;

pub use clc197::SetConstantBufferSelectorB;

pub use clc197::SetConstantBufferSelectorC;

pub use clc197::LoadConstantBufferOffset;

pub use clc197::LoadConstantBuffer;

pub use clc197::BindGroupReservedA;

pub use clc197::BindGroupReservedB;

pub use clc197::BindGroupReservedC;

pub use clc197::BindGroupReservedD;

pub use clc197::BindGroupConstantBuffer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerA {
    pub address_upper: u32,
}

impl Mthd for SetTrapHandlerA {
    const ADDR: u16 = 0x25f8;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandlerB {
    pub address_lower: u32,
}

impl Mthd for SetTrapHandlerB {
    const ADDR: u16 = 0x25fc;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

pub use clc197::SetColorClamp;

pub use clc197::SetBindlessTexture;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValue {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValue {
    const CLASS: u16 = 0xc397;

    fn addr(i: usize) -> u16 {
        (0x32f4 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceSnapshotCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceSnapshotCounterValueUpper {
    const CLASS: u16 = 0xc397;

    fn addr(i: usize) -> u16 {
        (0x3314 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct EnableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for EnableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3334;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DisableShaderPerformanceSnapshotCounter {
    pub v: u32,
}

impl Mthd for DisableShaderPerformanceSnapshotCounter {
    const ADDR: u16 = 0x3338;
    const CLASS: u16 = 0xc397;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clc197::SetShaderPerformanceCounterValueUpper;

pub use clc197::SetShaderPerformanceCounterValue;

pub use clc197::SetShaderPerformanceCounterEvent;

pub use clc197::SetShaderPerformanceCounterControlA;

pub use clc197::SetShaderPerformanceCounterControlB;

pub use clc197::SetShaderPerformanceCounterTrapControl;

pub use clc197::StartShaderPerformanceCounter;

pub use clc197::StopShaderPerformanceCounter;

pub use clc197::SetShaderPerformanceCounterSctlFilter;

pub use clc197::SetShaderPerformanceCounterCoreMioFilter;

pub use clc197::SetMmeShadowScratch;

pub use clc197::CallMmeMacro;

pub use clc197::CallMmeData;
