use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clc097::mthd as clc097;

// parsed class NVC197

pub use clc097::SetObject;

pub use clc097::NoOperation;

pub use clc097::SetNotifyA;

pub use clc097::SetNotifyB;

pub use clc097::Notify;
pub use clc097::NotifyType;

pub use clc097::WaitForIdle;

pub use clc097::LoadMmeInstructionRamPointer;

pub use clc097::LoadMmeInstructionRam;

pub use clc097::LoadMmeStartAddressRamPointer;

pub use clc097::LoadMmeStartAddressRam;

pub use clc097::SetMmeShadowRamControl;
pub use clc097::SetMmeShadowRamControlMode;

pub use clc097::PeerSemaphoreReleaseOffsetUpper;

pub use clc097::PeerSemaphoreReleaseOffset;

pub use clc097::SetGlobalRenderEnableA;

pub use clc097::SetGlobalRenderEnableB;

pub use clc097::SetGlobalRenderEnableC;
pub use clc097::SetGlobalRenderEnableCMode;

pub use clc097::SendGoIdle;

pub use clc097::PmTrigger;

pub use clc097::PmTriggerWfi;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceBegin {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceBegin {
    const ADDR: u16 = 0x0148;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FeAtomicSequenceEnd {
    pub v: u32,
}

impl Mthd for FeAtomicSequenceEnd {
    const ADDR: u16 = 0x014c;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc097::SetInstrumentationMethodHeader;

pub use clc097::SetInstrumentationMethodData;

pub use clc097::LineLengthIn;

pub use clc097::LineCount;

pub use clc097::OffsetOutUpper;

pub use clc097::OffsetOut;

pub use clc097::PitchOut;

pub use clc097::SetDstBlockSize;
pub use clc097::SetDstBlockSizeDepth;
pub use clc097::SetDstBlockSizeHeight;
pub use clc097::SetDstBlockSizeWidth;

pub use clc097::SetDstWidth;

pub use clc097::SetDstHeight;

pub use clc097::SetDstDepth;

pub use clc097::SetDstLayer;

pub use clc097::SetDstOriginBytesX;

pub use clc097::SetDstOriginSamplesY;

pub use clc097::LaunchDma;
pub use clc097::LaunchDmaCompletionType;
pub use clc097::LaunchDmaDstMemoryLayout;
pub use clc097::LaunchDmaInterruptType;
pub use clc097::LaunchDmaReductionFormat;
pub use clc097::LaunchDmaReductionOp;
pub use clc097::LaunchDmaSemaphoreStructSize;

pub use clc097::LoadInlineData;

pub use clc097::SetI2MSemaphoreA;

pub use clc097::SetI2MSemaphoreB;

pub use clc097::SetI2MSemaphoreC;

pub use clc097::SetI2MSpareNoop00;

pub use clc097::SetI2MSpareNoop01;

pub use clc097::SetI2MSpareNoop02;

pub use clc097::SetI2MSpareNoop03;

pub use clc097::RunDsNow;

pub use clc097::SetOpportunisticEarlyZHysteresis;
pub use clc097::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGsModeType {
    Any = 0x00000000,
    FastGs = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGsMode {
    pub type_: SetGsModeType,
}

impl Mthd for SetGsMode {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 1));
        val |= (self.type_ as u32) << 0;

        val
    }
}

pub use clc097::SetAliasedLineWidthEnable;

pub use clc097::SetApiMandatedEarlyZ;

pub use clc097::SetGsDmFifo;

pub use clc097::SetL2CacheControlForRopPrefetchReadRequests;
pub use clc097::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clc097::InvalidateShaderCaches;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInstanceCount {
    pub v: u32,
}

impl Mthd for SetInstanceCount {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPositionWScaledOffsetEnable {
    pub enable: bool,
}

impl Mthd for SetPositionWScaledOffsetEnable {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMultiView {
    pub view_count: u32,
    pub render_target_index_offset: u32,
    pub independent_viewport_mask_enable: bool,
}

impl Mthd for SetMultiView {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.view_count < (1 << 4));
        val |= self.view_count << 0;

        assert!(self.render_target_index_offset < (1 << 11));
        val |= self.render_target_index_offset << 4;

        assert!((self.independent_viewport_mask_enable as u32) < (1 << 1));
        val |= (self.independent_viewport_mask_enable as u32) << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGoIdleTimeout {
    pub v: u32,
}

impl Mthd for SetGoIdleTimeout {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc097::IncrementSyncPoint;
pub use clc097::IncrementSyncPointCondition;

pub use clc097::SetPrimCircularBufferThrottle;

pub use clc097::FlushAndInvalidateRopMiniCache;

pub use clc097::SetSurfaceClipIdBlockSize;
pub use clc097::SetSurfaceClipIdBlockSizeDepth;
pub use clc097::SetSurfaceClipIdBlockSizeHeight;
pub use clc097::SetSurfaceClipIdBlockSizeWidth;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetAlphaCircularBufferSize {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 14));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

pub use clc097::DecompressSurface;

pub use clc097::SetZcullRopBypass;

pub use clc097::SetZcullSubregion;

pub use clc097::SetRasterBoundingBox;
pub use clc097::SetRasterBoundingBoxMode;

pub use clc097::PeerSemaphoreRelease;

pub use clc097::SetIteratedBlendOptimization;
pub use clc097::SetIteratedBlendOptimizationNoop;

pub use clc097::SetZcullSubregionAllocation;
pub use clc097::SetZcullSubregionAllocationFormat;

pub use clc097::AssignZcullSubregions;
pub use clc097::AssignZcullSubregionsAlgorithm;

pub use clc097::SetPsOutputSampleMaskUsage;
pub use clc097::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clc097::DrawZeroIndex;

pub use clc097::SetL1Configuration;
pub use clc097::SetL1ConfigurationDirectlyAddressableMemory;

pub use clc097::SetRenderEnableControl;

pub use clc097::SetSpaVersion;

pub use clc097::SetIeeeCleanUpdate;

pub use clc097::SetSnapGridLine;
pub use clc097::SetSnapGridLineLocationsPerPixel;
pub use clc097::SetSnapGridLineRoundingMode;

pub use clc097::SetSnapGridNonLine;
pub use clc097::SetSnapGridNonLineLocationsPerPixel;
pub use clc097::SetSnapGridNonLineRoundingMode;

pub use clc097::SetTessellationParameters;
pub use clc097::SetTessellationParametersDomainType;
pub use clc097::SetTessellationParametersOutputPrimitives;
pub use clc097::SetTessellationParametersSpacing;

pub use clc097::SetTessellationLodU0OrDensity;

pub use clc097::SetTessellationLodV0OrDetail;

pub use clc097::SetTessellationLodU1OrW0;

pub use clc097::SetTessellationLodV1;

pub use clc097::SetTgLodInteriorU;

pub use clc097::SetTgLodInteriorV;

pub use clc097::ReservedTg07;

pub use clc097::ReservedTg08;

pub use clc097::ReservedTg09;

pub use clc097::ReservedTg10;

pub use clc097::ReservedTg11;

pub use clc097::ReservedTg12;

pub use clc097::ReservedTg13;

pub use clc097::ReservedTg14;

pub use clc097::ReservedTg15;

pub use clc097::SetSubtilingPerfKnobA;

pub use clc097::SetSubtilingPerfKnobB;

pub use clc097::SetSubtilingPerfKnobC;

pub use clc097::SetZcullSubregionToReport;

pub use clc097::SetZcullSubregionReportType;
pub use clc097::SetZcullSubregionReportTypeType;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBalancedPrimitiveWorkload {
    pub in_unpartitioned_mode: bool,
    pub in_timesliced_mode: bool,
    pub by_pes_in_unpartitioned_mode: bool,
    pub by_pes_in_timesliced_mode: bool,
}

impl Mthd for SetBalancedPrimitiveWorkload {
    const ADDR: u16 = 0x0374;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.in_unpartitioned_mode as u32) < (1 << 1));
        val |= (self.in_unpartitioned_mode as u32) << 0;

        assert!((self.in_timesliced_mode as u32) < (1 << 1));
        val |= (self.in_timesliced_mode as u32) << 4;

        assert!((self.by_pes_in_unpartitioned_mode as u32) < (1 << 1));
        val |= (self.by_pes_in_unpartitioned_mode as u32) << 8;

        assert!((self.by_pes_in_timesliced_mode as u32) < (1 << 1));
        val |= (self.by_pes_in_timesliced_mode as u32) << 9;

        val
    }
}

pub use clc097::SetMaxPatchesPerBatch;

pub use clc097::SetRasterEnable;

pub use clc097::SetStreamOutBufferEnable;

pub use clc097::SetStreamOutBufferAddressA;

pub use clc097::SetStreamOutBufferAddressB;

pub use clc097::SetStreamOutBufferSize;

pub use clc097::SetStreamOutBufferLoadWritePointer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPositionWScaledOffsetScaleA {
    pub v: u32,
}

impl ArrayMthd for SetPositionWScaledOffsetScaleA {
    const CLASS: u16 = 0xc197;

    fn addr(i: usize) -> u16 {
        (0x0400 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPositionWScaledOffsetScaleB {
    pub v: u32,
}

impl ArrayMthd for SetPositionWScaledOffsetScaleB {
    const CLASS: u16 = 0xc197;

    fn addr(i: usize) -> u16 {
        (0x0404 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPositionWScaledOffsetReservedA {
    pub v: u32,
}

impl ArrayMthd for SetPositionWScaledOffsetReservedA {
    const CLASS: u16 = 0xc197;

    fn addr(i: usize) -> u16 {
        (0x0408 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPositionWScaledOffsetReservedB {
    pub v: u32,
}

impl ArrayMthd for SetPositionWScaledOffsetReservedB {
    const CLASS: u16 = 0xc197;

    fn addr(i: usize) -> u16 {
        (0x040c + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use clc097::SetStreamOutControlStream;

pub use clc097::SetStreamOutControlComponentCount;

pub use clc097::SetStreamOutControlStride;

pub use clc097::SetRasterInput;

pub use clc097::SetStreamOutput;

pub use clc097::SetDaPrimitiveRestartTopologyChange;

pub use clc097::SetAlphaFraction;

pub use clc097::SetHybridAntiAliasControl;
pub use clc097::SetHybridAntiAliasControlCentroid;

pub use clc097::SetShaderLocalMemoryWindow;

pub use clc097::SetShaderLocalMemoryA;

pub use clc097::SetShaderLocalMemoryB;

pub use clc097::SetShaderLocalMemoryC;

pub use clc097::SetShaderLocalMemoryD;

pub use clc097::SetShaderLocalMemoryE;

pub use clc097::SetColorZeroBandwidthClear;

pub use clc097::SetZZeroBandwidthClear;

pub use clc097::SetIsbeSaveRestoreProgram;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilZeroBandwidthClear {
    pub slot_disable_mask: u32,
}

impl Mthd for SetStencilZeroBandwidthClear {
    const ADDR: u16 = 0x07b0;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.slot_disable_mask < (1 << 15));
        val |= self.slot_disable_mask << 0;

        val
    }
}

pub use clc097::SetZcullRegionSizeA;

pub use clc097::SetZcullRegionSizeB;

pub use clc097::SetZcullRegionSizeC;

pub use clc097::SetZcullRegionPixelOffsetC;

pub use clc097::SetCullBeforeFetch;

pub use clc097::SetZcullRegionLocation;

pub use clc097::SetZcullRegionAliquots;

pub use clc097::SetZcullStorageA;

pub use clc097::SetZcullStorageB;

pub use clc097::SetZcullStorageC;

pub use clc097::SetZcullStorageD;

pub use clc097::SetZtReadOnly;

pub use clc097::SetColorTargetA;

pub use clc097::SetColorTargetB;

pub use clc097::SetColorTargetWidth;

pub use clc097::SetColorTargetHeight;

pub use clc097::SetColorTargetFormat;
pub use clc097::SetColorTargetFormatV;

pub use clc097::SetColorTargetMemory;
pub use clc097::SetColorTargetMemoryBlockDepth;
pub use clc097::SetColorTargetMemoryBlockHeight;
pub use clc097::SetColorTargetMemoryBlockWidth;
pub use clc097::SetColorTargetMemoryLayout;
pub use clc097::SetColorTargetMemoryThirdDimensionControl;

pub use clc097::SetColorTargetThirdDimension;

pub use clc097::SetColorTargetArrayPitch;

pub use clc097::SetColorTargetLayer;

pub use clc097::SetColorTargetMark;

pub use clc097::SetViewportScaleX;

pub use clc097::SetViewportScaleY;

pub use clc097::SetViewportScaleZ;

pub use clc097::SetViewportOffsetX;

pub use clc097::SetViewportOffsetY;

pub use clc097::SetViewportOffsetZ;

pub use clc097::SetViewportCoordinateSwizzle;
pub use clc097::SetViewportCoordinateSwizzleW;
pub use clc097::SetViewportCoordinateSwizzleX;
pub use clc097::SetViewportCoordinateSwizzleY;
pub use clc097::SetViewportCoordinateSwizzleZ;

pub use clc097::SetViewportIncreaseSnapGridPrecision;

pub use clc097::SetViewportClipHorizontal;

pub use clc097::SetViewportClipVertical;

pub use clc097::SetViewportClipMinZ;

pub use clc097::SetViewportClipMaxZ;

pub use clc097::SetWindowClipHorizontal;

pub use clc097::SetWindowClipVertical;

pub use clc097::SetClipIdExtentX;

pub use clc097::SetClipIdExtentY;

pub use clc097::SetMaxStreamOutputGsInstancesPerTask;

pub use clc097::SetApiVisibleCallLimit;
pub use clc097::SetApiVisibleCallLimitV;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStatisticsCounter {
    pub da_vertices_generated_enable: bool,
    pub da_primitives_generated_enable: bool,
    pub vs_invocations_enable: bool,
    pub gs_invocations_enable: bool,
    pub gs_primitives_generated_enable: bool,
    pub streaming_primitives_succeeded_enable: bool,
    pub streaming_primitives_needed_enable: bool,
    pub clipper_invocations_enable: bool,
    pub clipper_primitives_generated_enable: bool,
    pub ps_invocations_enable: bool,
    pub ti_invocations_enable: bool,
    pub ts_invocations_enable: bool,
    pub ts_primitives_generated_enable: bool,
    pub total_streaming_primitives_needed_succeeded_enable: bool,
    pub vtg_primitives_out_enable: bool,
    pub alpha_beta_clocks_enable: bool,
    pub scg_clocks_enable: bool,
}

impl Mthd for SetStatisticsCounter {
    const ADDR: u16 = 0x0d68;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.da_vertices_generated_enable as u32) < (1 << 1));
        val |= (self.da_vertices_generated_enable as u32) << 0;

        assert!((self.da_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.da_primitives_generated_enable as u32) << 1;

        assert!((self.vs_invocations_enable as u32) < (1 << 1));
        val |= (self.vs_invocations_enable as u32) << 2;

        assert!((self.gs_invocations_enable as u32) < (1 << 1));
        val |= (self.gs_invocations_enable as u32) << 3;

        assert!((self.gs_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.gs_primitives_generated_enable as u32) << 4;

        assert!((self.streaming_primitives_succeeded_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_succeeded_enable as u32) << 5;

        assert!((self.streaming_primitives_needed_enable as u32) < (1 << 1));
        val |= (self.streaming_primitives_needed_enable as u32) << 6;

        assert!((self.clipper_invocations_enable as u32) < (1 << 1));
        val |= (self.clipper_invocations_enable as u32) << 7;

        assert!((self.clipper_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.clipper_primitives_generated_enable as u32) << 8;

        assert!((self.ps_invocations_enable as u32) < (1 << 1));
        val |= (self.ps_invocations_enable as u32) << 9;

        assert!((self.ti_invocations_enable as u32) < (1 << 1));
        val |= (self.ti_invocations_enable as u32) << 11;

        assert!((self.ts_invocations_enable as u32) < (1 << 1));
        val |= (self.ts_invocations_enable as u32) << 12;

        assert!((self.ts_primitives_generated_enable as u32) < (1 << 1));
        val |= (self.ts_primitives_generated_enable as u32) << 13;

        assert!((self.total_streaming_primitives_needed_succeeded_enable as u32) < (1 << 1));
        val |= (self.total_streaming_primitives_needed_succeeded_enable as u32) << 14;

        assert!((self.vtg_primitives_out_enable as u32) < (1 << 1));
        val |= (self.vtg_primitives_out_enable as u32) << 10;

        assert!((self.alpha_beta_clocks_enable as u32) < (1 << 1));
        val |= (self.alpha_beta_clocks_enable as u32) << 15;

        assert!((self.scg_clocks_enable as u32) < (1 << 1));
        val |= (self.scg_clocks_enable as u32) << 16;

        val
    }
}

pub use clc097::SetClearRectHorizontal;

pub use clc097::SetClearRectVertical;

pub use clc097::SetVertexArrayStart;

pub use clc097::DrawVertexArray;

pub use clc097::SetViewportZClip;
pub use clc097::SetViewportZClipRange;

pub use clc097::SetColorClearValue;

pub use clc097::SetZClearValue;

pub use clc097::SetShaderCacheControl;

pub use clc097::ForceTransitionToBeta;

pub use clc097::SetReduceColorThresholdsEnable;

pub use clc097::SetStencilClearValue;

pub use clc097::InvalidateShaderCachesNoWfi;

pub use clc097::SetZcullSerialization;
pub use clc097::SetZcullSerializationApplied;

pub use clc097::SetFrontPolygonMode;
pub use clc097::SetFrontPolygonModeV;

pub use clc097::SetBackPolygonMode;
pub use clc097::SetBackPolygonModeV;

pub use clc097::SetPolySmooth;

pub use clc097::SetZtMark;

pub use clc097::SetZcullDirFormat;
pub use clc097::SetZcullDirFormatZdir;
pub use clc097::SetZcullDirFormatZformat;

pub use clc097::SetPolyOffsetPoint;

pub use clc097::SetPolyOffsetLine;

pub use clc097::SetPolyOffsetFill;

pub use clc097::SetPatch;

pub use clc097::SetIteratedBlend;

pub use clc097::SetIteratedBlendPass;

pub use clc097::SetZcullCriterion;
pub use clc097::SetZcullCriterionSfunc;

pub use clc097::PixelShaderBarrier;

pub use clc097::SetSmTimeoutInterval;

pub use clc097::SetDaPrimitiveRestartVertexArray;

pub use clc097::LoadIteratedBlendInstructionPointer;

pub use clc097::LoadIteratedBlendInstruction;
pub use clc097::LoadIteratedBlendInstructionConstantInputSelect;
pub use clc097::LoadIteratedBlendInstructionOperandASelect;
pub use clc097::LoadIteratedBlendInstructionOperandBSelect;
pub use clc097::LoadIteratedBlendInstructionOperandCSelect;
pub use clc097::LoadIteratedBlendInstructionOperandDSelect;
pub use clc097::LoadIteratedBlendInstructionOperation;
pub use clc097::LoadIteratedBlendInstructionOutputSwizzle;
pub use clc097::LoadIteratedBlendInstructionOutputWriteMask;
pub use clc097::LoadIteratedBlendInstructionPassOutput;
pub use clc097::LoadIteratedBlendInstructionTestCc;

pub use clc097::SetWindowOffsetX;

pub use clc097::SetWindowOffsetY;

pub use clc097::SetScissorEnable;

pub use clc097::SetScissorHorizontal;

pub use clc097::SetScissorVertical;

pub use clc097::SetSelectMaxwellTextureHeaders;

pub use clc097::SetVpcPerfKnob;

pub use clc097::PmLocalTrigger;

pub use clc097::SetPostZPsImask;

pub use clc097::SetConstantColorRendering;

pub use clc097::SetConstantColorRenderingRed;

pub use clc097::SetConstantColorRenderingGreen;

pub use clc097::SetConstantColorRenderingBlue;

pub use clc097::SetConstantColorRenderingAlpha;

pub use clc097::SetBackStencilFuncRef;

pub use clc097::SetBackStencilMask;

pub use clc097::SetBackStencilFuncMask;

pub use clc097::SetVertexStreamSubstituteA;

pub use clc097::SetVertexStreamSubstituteB;

pub use clc097::SetLineModePolygonClip;
pub use clc097::SetLineModePolygonClipGeneratedEdge;

pub use clc097::SetSingleCtWriteControl;

pub use clc097::SetVtgWarpWatermarks;

pub use clc097::SetDepthBoundsMin;

pub use clc097::SetDepthBoundsMax;

pub use clc097::SetSampleMask;

pub use clc097::SetColorTargetSampleMask;

pub use clc097::SetCtMrtEnable;

pub use clc097::SetNonmultisampledZ;
pub use clc097::SetNonmultisampledZV;

pub use clc097::SetTir;
pub use clc097::SetTirMode;

pub use clc097::SetAntiAliasRaster;
pub use clc097::SetAntiAliasRasterSamples;

pub use clc097::SetSampleMaskX0Y0;

pub use clc097::SetSampleMaskX1Y0;

pub use clc097::SetSampleMaskX0Y1;

pub use clc097::SetSampleMaskX1Y1;

pub use clc097::SetSurfaceClipIdMemoryA;

pub use clc097::SetSurfaceClipIdMemoryB;

pub use clc097::SetTirModulation;
pub use clc097::SetTirModulationComponentSelect;

pub use clc097::SetTirModulationFunction;
pub use clc097::SetTirModulationFunctionSelect;

pub use clc097::SetBlendOptControl;

pub use clc097::SetZtA;

pub use clc097::SetZtB;

pub use clc097::SetZtFormat;
pub use clc097::SetZtFormatV;

pub use clc097::SetZtBlockSize;
pub use clc097::SetZtBlockSizeDepth;
pub use clc097::SetZtBlockSizeHeight;
pub use clc097::SetZtBlockSizeWidth;

pub use clc097::SetZtArrayPitch;

pub use clc097::SetSurfaceClipHorizontal;

pub use clc097::SetSurfaceClipVertical;

pub use clc097::SetTiledCacheBundleControl;

pub use clc097::SetL2CacheControlForVafRequests;
pub use clc097::SetL2CacheControlForVafRequestsPolicy;

pub use clc097::SetViewportMulticast;
pub use clc097::SetViewportMulticastOrder;

pub use clc097::SetTessellationCutHeight;

pub use clc097::SetMaxGsInstancesPerTask;

pub use clc097::SetMaxGsOutputVerticesPerTask;

pub use clc097::SetReservedSwMethod00;

pub use clc097::SetGsOutputCbStorageMultiplier;

pub use clc097::SetBetaCbStorageConstraint;

pub use clc097::SetTiOutputCbStorageMultiplier;

pub use clc097::SetAlphaCbStorageConstraint;

pub use clc097::SetReservedSwMethod01;

pub use clc097::SetReservedSwMethod02;

pub use clc097::SetTirModulationCoefficientTable;

pub use clc097::SetSpareNoop01;

pub use clc097::SetSpareNoop02;

pub use clc097::SetSpareNoop03;

pub use clc097::SetSpareNoop04;

pub use clc097::SetSpareNoop05;

pub use clc097::SetSpareNoop06;

pub use clc097::SetSpareNoop07;

pub use clc097::SetSpareNoop08;

pub use clc097::SetSpareNoop09;

pub use clc097::SetSpareNoop10;

pub use clc097::SetSpareNoop11;

pub use clc097::SetSpareNoop12;

pub use clc097::SetSpareNoop13;

pub use clc097::SetSpareNoop14;

pub use clc097::SetSpareNoop15;

pub use clc097::SetReservedSwMethod03;

pub use clc097::SetReservedSwMethod04;

pub use clc097::SetReservedSwMethod05;

pub use clc097::SetReservedSwMethod06;

pub use clc097::SetReservedSwMethod07;

pub use clc097::SetReservedSwMethod08;

pub use clc097::SetReservedSwMethod09;

pub use clc097::SetReduceColorThresholdsUnorm8;

pub use clc097::SetReservedSwMethod10;

pub use clc097::SetReservedSwMethod11;

pub use clc097::SetReservedSwMethod12;

pub use clc097::SetReservedSwMethod13;

pub use clc097::SetReduceColorThresholdsUnorm10;

pub use clc097::SetReduceColorThresholdsUnorm16;

pub use clc097::SetReduceColorThresholdsFp11;

pub use clc097::SetReduceColorThresholdsFp16;

pub use clc097::SetReduceColorThresholdsSrgb8;

pub use clc097::UnbindAll;

pub use clc097::SetClearSurfaceControl;

pub use clc097::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clc097::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clc097::SetReservedSwMethod14;

pub use clc097::SetReservedSwMethod15;

pub use clc097::NoOperationDataHi;

pub use clc097::SetDepthBiasControl;

pub use clc097::PmTriggerEnd;

pub use clc097::SetVertexIdBase;

pub use clc097::SetStencilCompression;

pub use clc097::SetDaOutputAttributeSkipMaskA;

pub use clc097::SetDaOutputAttributeSkipMaskB;

pub use clc097::SetTirControl;
pub use clc097::SetTirControlAlphaToCoverageUseRasterSamples;
pub use clc097::SetTirControlReduceCoverage;
pub use clc097::SetTirControlZPassPixelCountUseRasterSamples;

pub use clc097::SetMutableMethodControl;

pub use clc097::SetPostPsInitialCoverage;

pub use clc097::SetFillViaTriangle;
pub use clc097::SetFillViaTriangleMode;

pub use clc097::SetBlendPerFormatEnable;

pub use clc097::FlushPendingWrites;

pub use clc097::SetConservativeRaster;

pub use clc097::SetVertexAttributeA;
pub use clc097::SetVertexAttributeAComponentBitWidths;
pub use clc097::SetVertexAttributeANumericalType;
pub use clc097::SetVertexAttributeASource;

pub use clc097::SetVertexAttributeB;
pub use clc097::SetVertexAttributeBComponentBitWidths;
pub use clc097::SetVertexAttributeBNumericalType;
pub use clc097::SetVertexAttributeBSource;

pub use clc097::SetAntiAliasSamplePositions;

pub use clc097::SetOffsetRenderTargetIndex;

pub use clc097::ForceHeavyweightMethodSync;

pub use clc097::SetCoverageToColor;

pub use clc097::DecompressZetaSurface;

pub use clc097::SetScreenStateMask;

pub use clc097::SetZtSparse;
pub use clc097::SetZtSparseUnmappedCompare;

pub use clc097::InvalidateSamplerCacheAll;

pub use clc097::InvalidateTextureHeaderCacheAll;

pub use clc097::DrawVertexArrayBeginEndInstanceFirst;
pub use clc097::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clc097::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clc097::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clc097::SetCtSelect;

pub use clc097::SetCompressionThreshold;
pub use clc097::SetCompressionThresholdSamples;

pub use clc097::SetPixelShaderInterlockControl;
pub use clc097::SetPixelShaderInterlockControlTileCoalescerFragmentOrder;
pub use clc097::SetPixelShaderInterlockControlTileCoalescerMode;
pub use clc097::SetPixelShaderInterlockControlTileCoalescerTileSize;

pub use clc097::SetZtSizeA;

pub use clc097::SetZtSizeB;

pub use clc097::SetZtSizeC;
pub use clc097::SetZtSizeCControl;

pub use clc097::SetSamplerBinding;
pub use clc097::SetSamplerBindingV;

pub use clc097::DrawAuto;

pub use clc097::SetPostVtgShaderAttributeSkipMask;

pub use clc097::SetPixelShaderTicketDispenserValue;

pub use clc097::SetBackEndCopyA;

pub use clc097::SetBackEndCopyB;

pub use clc097::SetBackEndCopyC;

pub use clc097::SetBackEndCopyD;

pub use clc097::SetBackEndCopyE;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetCircularBufferSize {
    const ADDR: u16 = 0x1280;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 20));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

pub use clc097::SetVtgRegisterWatermarks;

pub use clc097::InvalidateTextureDataCacheNoWfi;
pub use clc097::InvalidateTextureDataCacheNoWfiLines;

pub use clc097::SetL2CacheControlForRopInterlockedReadRequests;
pub use clc097::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clc097::SetDaPrimitiveRestartIndexTopologyChange;

pub use clc097::ClearZcullRegion;

pub use clc097::SetDepthTest;

pub use clc097::SetFillMode;
pub use clc097::SetFillModeV;

pub use clc097::SetShadeMode;
pub use clc097::SetShadeModeV;

pub use clc097::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clc097::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clc097::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clc097::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clc097::SetAlphaToCoverageDitherControl;
pub use clc097::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clc097::SetBlendStatePerTarget;

pub use clc097::SetDepthWrite;

pub use clc097::SetAlphaTest;

pub use clc097::SetInlineIndex4X8Align;

pub use clc097::DrawInlineIndex4X8;

pub use clc097::D3DSetCullMode;
pub use clc097::D3DSetCullModeV;

pub use clc097::SetDepthFunc;
pub use clc097::SetDepthFuncV;

pub use clc097::SetAlphaRef;

pub use clc097::SetAlphaFunc;
pub use clc097::SetAlphaFuncV;

pub use clc097::SetDrawAutoStride;

pub use clc097::SetBlendConstRed;

pub use clc097::SetBlendConstGreen;

pub use clc097::SetBlendConstBlue;

pub use clc097::SetBlendConstAlpha;

pub use clc097::InvalidateSamplerCache;
pub use clc097::InvalidateSamplerCacheLines;

pub use clc097::InvalidateTextureHeaderCache;
pub use clc097::InvalidateTextureHeaderCacheLines;

pub use clc097::InvalidateTextureDataCache;
pub use clc097::InvalidateTextureDataCacheLines;

pub use clc097::SetBlendSeparateForAlpha;

pub use clc097::SetBlendColorOp;
pub use clc097::SetBlendColorOpV;

pub use clc097::SetBlendColorSourceCoeff;
pub use clc097::SetBlendColorSourceCoeffV;

pub use clc097::SetBlendColorDestCoeff;
pub use clc097::SetBlendColorDestCoeffV;

pub use clc097::SetBlendAlphaOp;
pub use clc097::SetBlendAlphaOpV;

pub use clc097::SetBlendAlphaSourceCoeff;
pub use clc097::SetBlendAlphaSourceCoeffV;

pub use clc097::SetGlobalColorKey;

pub use clc097::SetBlendAlphaDestCoeff;
pub use clc097::SetBlendAlphaDestCoeffV;

pub use clc097::SetSingleRopControl;

pub use clc097::SetBlend;

pub use clc097::SetStencilTest;

pub use clc097::SetStencilOpFail;
pub use clc097::SetStencilOpFailV;

pub use clc097::SetStencilOpZfail;
pub use clc097::SetStencilOpZfailV;

pub use clc097::SetStencilOpZpass;
pub use clc097::SetStencilOpZpassV;

pub use clc097::SetStencilFunc;
pub use clc097::SetStencilFuncV;

pub use clc097::SetStencilFuncRef;

pub use clc097::SetStencilFuncMask;

pub use clc097::SetStencilMask;

pub use clc097::SetDrawAutoStart;

pub use clc097::SetPsSaturate;
pub use clc097::SetPsSaturateClampRange0;
pub use clc097::SetPsSaturateClampRange1;
pub use clc097::SetPsSaturateClampRange2;
pub use clc097::SetPsSaturateClampRange3;
pub use clc097::SetPsSaturateClampRange4;
pub use clc097::SetPsSaturateClampRange5;
pub use clc097::SetPsSaturateClampRange6;
pub use clc097::SetPsSaturateClampRange7;

pub use clc097::SetWindowOrigin;
pub use clc097::SetWindowOriginMode;

pub use clc097::SetLineWidthFloat;

pub use clc097::SetAliasedLineWidthFloat;

pub use clc097::SetLineMultisampleOverride;

pub use clc097::SetAlphaHysteresis;

pub use clc097::InvalidateSamplerCacheNoWfi;
pub use clc097::InvalidateSamplerCacheNoWfiLines;

pub use clc097::InvalidateTextureHeaderCacheNoWfi;
pub use clc097::InvalidateTextureHeaderCacheNoWfiLines;

pub use clc097::SetGlobalBaseVertexIndex;

pub use clc097::SetGlobalBaseInstanceIndex;

pub use clc097::SetPsWarpWatermarks;

pub use clc097::SetPsRegisterWatermarks;

pub use clc097::StoreZcull;

pub use clc097::SetIteratedBlendConstantRed;

pub use clc097::SetIteratedBlendConstantGreen;

pub use clc097::SetIteratedBlendConstantBlue;

pub use clc097::LoadZcull;

pub use clc097::SetSurfaceClipIdHeight;

pub use clc097::SetClipIdClearRectHorizontal;

pub use clc097::SetClipIdClearRectVertical;

pub use clc097::SetUserClipEnable;

pub use clc097::SetZpassPixelCount;

pub use clc097::SetPointSize;

pub use clc097::SetZcullStats;

pub use clc097::SetPointSprite;

pub use clc097::SetShaderExceptions;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ClearReportValueType {
    DaVerticesGenerated = 0x00000012,
    DaPrimitivesGenerated = 0x00000013,
    VsInvocations = 0x00000015,
    TiInvocations = 0x00000016,
    TsInvocations = 0x00000017,
    TsPrimitivesGenerated = 0x00000018,
    GsInvocations = 0x0000001a,
    GsPrimitivesGenerated = 0x0000001b,
    VtgPrimitivesOut = 0x0000001f,
    StreamingPrimitivesSucceeded = 0x00000010,
    StreamingPrimitivesNeeded = 0x00000011,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x00000003,
    ClipperInvocations = 0x0000001c,
    ClipperPrimitivesGenerated = 0x0000001d,
    ZcullStats = 0x00000002,
    PsInvocations = 0x0000001e,
    ZpassPixelCnt = 0x00000001,
    AlphaBetaClocks = 0x00000004,
    ScgClocks = 0x00000009,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ClearReportValue {
    pub type_: ClearReportValueType,
}

impl Mthd for ClearReportValue {
    const ADDR: u16 = 0x1530;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 5));
        val |= (self.type_ as u32) << 0;

        val
    }
}

pub use clc097::SetAntiAliasEnable;

pub use clc097::SetZtSelect;

pub use clc097::SetAntiAliasAlphaControl;
pub use clc097::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clc097::SetAntiAliasAlphaControlAlphaToOne;

pub use clc097::SetRenderEnableA;

pub use clc097::SetRenderEnableB;

pub use clc097::SetRenderEnableC;
pub use clc097::SetRenderEnableCMode;

pub use clc097::SetTexSamplerPoolA;

pub use clc097::SetTexSamplerPoolB;

pub use clc097::SetTexSamplerPoolC;

pub use clc097::SetSlopeScaleDepthBias;

pub use clc097::SetAntiAliasedLine;

pub use clc097::SetTexHeaderPoolA;

pub use clc097::SetTexHeaderPoolB;

pub use clc097::SetTexHeaderPoolC;

pub use clc097::SetActiveZcullRegion;

pub use clc097::SetTwoSidedStencilTest;

pub use clc097::SetBackStencilOpFail;
pub use clc097::SetBackStencilOpFailV;

pub use clc097::SetBackStencilOpZfail;
pub use clc097::SetBackStencilOpZfailV;

pub use clc097::SetBackStencilOpZpass;
pub use clc097::SetBackStencilOpZpassV;

pub use clc097::SetBackStencilFunc;
pub use clc097::SetBackStencilFuncV;

pub use clc097::SetSrgbWrite;

pub use clc097::SetDepthBias;

pub use clc097::SetZcullRegionFormat;
pub use clc097::SetZcullRegionFormatType;

pub use clc097::SetRtLayer;
pub use clc097::SetRtLayerControl;

pub use clc097::SetAntiAlias;
pub use clc097::SetAntiAliasSamples;

pub use clc097::SetEdgeFlag;

pub use clc097::DrawInlineIndex;

pub use clc097::SetInlineIndex2X16Align;

pub use clc097::DrawInlineIndex2X16;

pub use clc097::SetVertexGlobalBaseOffsetA;

pub use clc097::SetVertexGlobalBaseOffsetB;

pub use clc097::SetZcullRegionPixelOffsetA;

pub use clc097::SetZcullRegionPixelOffsetB;

pub use clc097::SetPointSpriteSelect;
pub use clc097::SetPointSpriteSelectOrigin;
pub use clc097::SetPointSpriteSelectRmode;
pub use clc097::SetPointSpriteSelectTexture0;
pub use clc097::SetPointSpriteSelectTexture1;
pub use clc097::SetPointSpriteSelectTexture2;
pub use clc097::SetPointSpriteSelectTexture3;
pub use clc097::SetPointSpriteSelectTexture4;
pub use clc097::SetPointSpriteSelectTexture5;
pub use clc097::SetPointSpriteSelectTexture6;
pub use clc097::SetPointSpriteSelectTexture7;
pub use clc097::SetPointSpriteSelectTexture8;
pub use clc097::SetPointSpriteSelectTexture9;

pub use clc097::SetProgramRegionA;

pub use clc097::SetProgramRegionB;

pub use clc097::SetAttributeDefault;
pub use clc097::SetAttributeDefaultColorFrontDiffuse;
pub use clc097::SetAttributeDefaultColorFrontSpecular;
pub use clc097::SetAttributeDefaultDx9Color0;
pub use clc097::SetAttributeDefaultDx9Color1ToColor15;
pub use clc097::SetAttributeDefaultFixedFncTexture;
pub use clc097::SetAttributeDefaultGenericVector;

pub use clc097::End;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginOp {
    Points = 0x00000000,
    Lines = 0x00000001,
    LineLoop = 0x00000002,
    LineStrip = 0x00000003,
    Triangles = 0x00000004,
    TriangleStrip = 0x00000005,
    TriangleFan = 0x00000006,
    Quads = 0x00000007,
    QuadStrip = 0x00000008,
    Polygon = 0x00000009,
    LinelistAdjcy = 0x0000000a,
    LinestripAdjcy = 0x0000000b,
    TrianglelistAdjcy = 0x0000000c,
    TrianglestripAdjcy = 0x0000000d,
    Patch = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginPrimitiveId {
    First = 0x00000000,
    Unchanged = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginInstanceId {
    First = 0x00000000,
    Subsequent = 0x00000001,
    Unchanged = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum BeginSplitMode {
    NormalBeginNormalEnd = 0x00000000,
    NormalBeginOpenEnd = 0x00000001,
    OpenBeginOpenEnd = 0x00000002,
    OpenBeginNormalEnd = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct Begin {
    pub op: BeginOp,
    pub primitive_id: BeginPrimitiveId,
    pub instance_id: BeginInstanceId,
    pub split_mode: BeginSplitMode,
    pub instance_iterate_enable: bool,
}

impl Mthd for Begin {
    const ADDR: u16 = 0x1618;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.op as u32) < (1 << 16));
        val |= (self.op as u32) << 0;

        assert!((self.primitive_id as u32) < (1 << 1));
        val |= (self.primitive_id as u32) << 24;

        assert!((self.instance_id as u32) < (1 << 2));
        val |= (self.instance_id as u32) << 26;

        assert!((self.split_mode as u32) < (1 << 2));
        val |= (self.split_mode as u32) << 29;

        assert!((self.instance_iterate_enable as u32) < (1 << 1));
        val |= (self.instance_iterate_enable as u32) << 31;

        val
    }
}

pub use clc097::SetVertexIdCopy;

pub use clc097::AddToPrimitiveId;

pub use clc097::LoadPrimitiveId;

pub use clc097::SetShaderBasedCull;

pub use clc097::SetClassVersion;

pub use clc097::SetDaPrimitiveRestart;

pub use clc097::SetDaPrimitiveRestartIndex;

pub use clc097::SetDaOutput;

pub use clc097::SetAntiAliasedPoint;

pub use clc097::SetPointCenterMode;
pub use clc097::SetPointCenterModeV;

pub use clc097::SetLineSmoothParameters;
pub use clc097::SetLineSmoothParametersFalloff;

pub use clc097::SetLineStipple;

pub use clc097::SetLineSmoothEdgeTable;

pub use clc097::SetLineStippleParameters;

pub use clc097::SetProvokingVertex;
pub use clc097::SetProvokingVertexV;

pub use clc097::SetTwoSidedLight;

pub use clc097::SetPolygonStipple;

pub use clc097::SetShaderControl;
pub use clc097::SetShaderControlDefaultPartial;
pub use clc097::SetShaderControlFp32F2INanBehavior;
pub use clc097::SetShaderControlFp32NanBehavior;

pub use clc097::CheckClassVersion;

pub use clc097::SetSphVersion;

pub use clc097::CheckSphVersion;

pub use clc097::SetAlphaToCoverageOverride;
pub use clc097::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clc097::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use clc097::SetPolygonStipplePattern;

pub use clc097::SetAamVersion;

pub use clc097::CheckAamVersion;

pub use clc097::SetZtLayer;

pub use clc097::SetIndexBufferA;

pub use clc097::SetIndexBufferB;

pub use clc097::SetIndexBufferC;

pub use clc097::SetIndexBufferD;

pub use clc097::SetIndexBufferE;
pub use clc097::SetIndexBufferEIndexSize;

pub use clc097::SetIndexBufferF;

pub use clc097::DrawIndexBuffer;

pub use clc097::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clc097::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clc097::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clc097::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clc097::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clc097::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clc097::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clc097::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clc097::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clc097::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clc097::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clc097::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clc097::SetDepthBiasClamp;

pub use clc097::SetVertexStreamInstanceA;

pub use clc097::SetVertexStreamInstanceB;

pub use clc097::SetAttributePointSize;

pub use clc097::OglSetCull;

pub use clc097::OglSetFrontFace;
pub use clc097::OglSetFrontFaceV;

pub use clc097::OglSetCullFace;
pub use clc097::OglSetCullFaceV;

pub use clc097::SetViewportPixel;
pub use clc097::SetViewportPixelCenter;

pub use clc097::SetViewportScaleOffset;

pub use clc097::SetViewportClipControl;
pub use clc097::SetViewportClipControlGeometryClip;
pub use clc097::SetViewportClipControlGeometryGuardband;
pub use clc097::SetViewportClipControlGeometryGuardbandZ;
pub use clc097::SetViewportClipControlLinePointCullGuardband;
pub use clc097::SetViewportClipControlPixelMaxZ;
pub use clc097::SetViewportClipControlPixelMinZ;

pub use clc097::SetUserClipOp;
pub use clc097::SetUserClipOpPlane0;
pub use clc097::SetUserClipOpPlane1;
pub use clc097::SetUserClipOpPlane2;
pub use clc097::SetUserClipOpPlane3;
pub use clc097::SetUserClipOpPlane4;
pub use clc097::SetUserClipOpPlane5;
pub use clc097::SetUserClipOpPlane6;
pub use clc097::SetUserClipOpPlane7;

pub use clc097::SetRenderEnableOverride;
pub use clc097::SetRenderEnableOverrideMode;

pub use clc097::SetPrimitiveTopologyControl;
pub use clc097::SetPrimitiveTopologyControlOverride;

pub use clc097::SetWindowClipEnable;

pub use clc097::SetWindowClipType;
pub use clc097::SetWindowClipTypeV;

pub use clc097::InvalidateZcull;
pub use clc097::InvalidateZcullV;

pub use clc097::SetZcull;

pub use clc097::SetZcullBounds;

pub use clc097::SetPrimitiveTopology;
pub use clc097::SetPrimitiveTopologyV;

pub use clc097::ZcullSync;

pub use clc097::SetClipIdTest;

pub use clc097::SetSurfaceClipIdWidth;

pub use clc097::SetClipId;

pub use clc097::SetDepthBoundsTest;

pub use clc097::SetBlendFloatOption;

pub use clc097::SetLogicOp;

pub use clc097::SetLogicOpFunc;
pub use clc097::SetLogicOpFuncV;

pub use clc097::SetZCompression;

pub use clc097::ClearSurface;

pub use clc097::ClearClipIdSurface;

pub use clc097::SetColorCompression;

pub use clc097::SetCtWrite;

pub use clc097::PipeNop;

pub use clc097::SetSpare00;

pub use clc097::SetSpare01;

pub use clc097::SetSpare02;

pub use clc097::SetSpare03;

pub use clc097::SetReportSemaphoreA;

pub use clc097::SetReportSemaphoreB;

pub use clc097::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    ScgClocks = 0x00000008,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    TiledZpassPixelCnt64 = 0x00000017,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xc197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;

        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;

        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;

        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        val
    }
}

pub use clc097::SetVertexStreamAFormat;

pub use clc097::SetVertexStreamALocationA;

pub use clc097::SetVertexStreamALocationB;

pub use clc097::SetVertexStreamAFrequency;

pub use clc097::SetVertexStreamBFormat;

pub use clc097::SetVertexStreamBLocationA;

pub use clc097::SetVertexStreamBLocationB;

pub use clc097::SetVertexStreamBFrequency;

pub use clc097::SetBlendPerTargetSeparateForAlpha;

pub use clc097::SetBlendPerTargetColorOp;
pub use clc097::SetBlendPerTargetColorOpV;

pub use clc097::SetBlendPerTargetColorSourceCoeff;
pub use clc097::SetBlendPerTargetColorSourceCoeffV;

pub use clc097::SetBlendPerTargetColorDestCoeff;
pub use clc097::SetBlendPerTargetColorDestCoeffV;

pub use clc097::SetBlendPerTargetAlphaOp;
pub use clc097::SetBlendPerTargetAlphaOpV;

pub use clc097::SetBlendPerTargetAlphaSourceCoeff;
pub use clc097::SetBlendPerTargetAlphaSourceCoeffV;

pub use clc097::SetBlendPerTargetAlphaDestCoeff;
pub use clc097::SetBlendPerTargetAlphaDestCoeffV;

pub use clc097::SetVertexStreamLimitAA;

pub use clc097::SetVertexStreamLimitAB;

pub use clc097::SetVertexStreamLimitBA;

pub use clc097::SetVertexStreamLimitBB;

pub use clc097::SetPipelineShader;
pub use clc097::SetPipelineShaderType;

pub use clc097::SetPipelineProgram;

pub use clc097::SetPipelineReservedA;

pub use clc097::SetPipelineRegisterCount;

pub use clc097::SetPipelineBinding;

pub use clc097::SetPipelineReservedB;

pub use clc097::SetPipelineReservedC;

pub use clc097::SetPipelineReservedD;

pub use clc097::SetPipelineReservedE;

pub use clc097::SetFalcon00;

pub use clc097::SetFalcon01;

pub use clc097::SetFalcon02;

pub use clc097::SetFalcon03;

pub use clc097::SetFalcon04;

pub use clc097::SetFalcon05;

pub use clc097::SetFalcon06;

pub use clc097::SetFalcon07;

pub use clc097::SetFalcon08;

pub use clc097::SetFalcon09;

pub use clc097::SetFalcon10;

pub use clc097::SetFalcon11;

pub use clc097::SetFalcon12;

pub use clc097::SetFalcon13;

pub use clc097::SetFalcon14;

pub use clc097::SetFalcon15;

pub use clc097::SetFalcon16;

pub use clc097::SetFalcon17;

pub use clc097::SetFalcon18;

pub use clc097::SetFalcon19;

pub use clc097::SetFalcon20;

pub use clc097::SetFalcon21;

pub use clc097::SetFalcon22;

pub use clc097::SetFalcon23;

pub use clc097::SetFalcon24;

pub use clc097::SetFalcon25;

pub use clc097::SetFalcon26;

pub use clc097::SetFalcon27;

pub use clc097::SetFalcon28;

pub use clc097::SetFalcon29;

pub use clc097::SetFalcon30;

pub use clc097::SetFalcon31;

pub use clc097::SetConstantBufferSelectorA;

pub use clc097::SetConstantBufferSelectorB;

pub use clc097::SetConstantBufferSelectorC;

pub use clc097::LoadConstantBufferOffset;

pub use clc097::LoadConstantBuffer;

pub use clc097::BindGroupReservedA;

pub use clc097::BindGroupReservedB;

pub use clc097::BindGroupReservedC;

pub use clc097::BindGroupReservedD;

pub use clc097::BindGroupConstantBuffer;

pub use clc097::SetColorClamp;

pub use clc097::SetBindlessTexture;

pub use clc097::SetTrapHandler;

pub use clc097::SetShaderPerformanceCounterValueUpper;

pub use clc097::SetShaderPerformanceCounterValue;

pub use clc097::SetShaderPerformanceCounterEvent;

pub use clc097::SetShaderPerformanceCounterControlA;

pub use clc097::SetShaderPerformanceCounterControlB;

pub use clc097::SetShaderPerformanceCounterTrapControl;

pub use clc097::StartShaderPerformanceCounter;

pub use clc097::StopShaderPerformanceCounter;

pub use clc097::SetShaderPerformanceCounterSctlFilter;

pub use clc097::SetShaderPerformanceCounterCoreMioFilter;

pub use clc097::SetMmeShadowScratch;

pub use clc097::CallMmeMacro;

pub use clc097::CallMmeData;
