use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::cla0c0::mthd as cla0c0;

// parsed class NVC0C0

pub use cla0c0::SetObject;

pub use cla0c0::NoOperation;

pub use cla0c0::SetNotifyA;

pub use cla0c0::SetNotifyB;

pub use cla0c0::Notify;
pub use cla0c0::NotifyType;

pub use cla0c0::WaitForIdle;

pub use cla0c0::SetGlobalRenderEnableA;

pub use cla0c0::SetGlobalRenderEnableB;

pub use cla0c0::SetGlobalRenderEnableC;
pub use cla0c0::SetGlobalRenderEnableCMode;

pub use cla0c0::SendGoIdle;

pub use cla0c0::PmTrigger;

pub use cla0c0::PmTriggerWfi;

pub use cla0c0::SetInstrumentationMethodHeader;

pub use cla0c0::SetInstrumentationMethodData;

pub use cla0c0::LineLengthIn;

pub use cla0c0::LineCount;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.value < (1 << 17));
        val |= self.value << 0;

        val
    }
}

pub use cla0c0::OffsetOut;

pub use cla0c0::PitchOut;

pub use cla0c0::SetDstBlockSize;
pub use cla0c0::SetDstBlockSizeDepth;
pub use cla0c0::SetDstBlockSizeHeight;
pub use cla0c0::SetDstBlockSizeWidth;

pub use cla0c0::SetDstWidth;

pub use cla0c0::SetDstHeight;

pub use cla0c0::SetDstDepth;

pub use cla0c0::SetDstLayer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 21));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 17));
        val |= self.v << 0;

        val
    }
}

pub use cla0c0::LaunchDma;
pub use cla0c0::LaunchDmaCompletionType;
pub use cla0c0::LaunchDmaDstMemoryLayout;
pub use cla0c0::LaunchDmaInterruptType;
pub use cla0c0::LaunchDmaReductionFormat;
pub use cla0c0::LaunchDmaReductionOp;
pub use cla0c0::LaunchDmaSemaphoreStructSize;

pub use cla0c0::LoadInlineData;

pub use cla0c0::SetI2MSemaphoreA;

pub use cla0c0::SetI2MSemaphoreB;

pub use cla0c0::SetI2MSemaphoreC;

pub use cla0c0::SetI2MSpareNoop00;

pub use cla0c0::SetI2MSpareNoop01;

pub use cla0c0::SetI2MSpareNoop02;

pub use cla0c0::SetI2MSpareNoop03;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaA {
    pub address_upper: u32,
}

impl Mthd for SetValidSpanOverflowAreaA {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaB {
    pub address_lower: u32,
}

impl Mthd for SetValidSpanOverflowAreaB {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaC {
    pub size: u32,
}

impl Mthd for SetValidSpanOverflowAreaC {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCoalesceWaitingPeriodUnit {
    pub clocks: u32,
}

impl Mthd for SetCoalesceWaitingPeriodUnit {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.clocks;

        val
    }
}

pub use cla0c0::PerfmonTransfer;

pub use cla0c0::SetShaderSharedMemoryWindow;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSelectMaxwellTextureHeaders {
    pub v: bool,
}

impl Mthd for SetSelectMaxwellTextureHeaders {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

pub use cla0c0::InvalidateShaderCaches;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod00 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod00 {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod01 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod01 {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod02 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod02 {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod03 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod03 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod04 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod04 {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod05 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod05 {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod06 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod06 {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod07 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod07 {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla0c0::SetCwdControl;
pub use cla0c0::SetCwdControlSmSelection;

pub use cla0c0::InvalidateTextureHeaderCacheNoWfi;
pub use cla0c0::InvalidateTextureHeaderCacheNoWfiLines;

pub use cla0c0::SetCwdRefCounter;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod08 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod08 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod09 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod09 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod10 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod10 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod11 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod11 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod12 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod12 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod13 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod13 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod14 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod14 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod15 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod15 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetGwcScgTypeScgType {
    GraphicsCompute0 = 0x00000000,
    Compute1 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGwcScgType {
    pub scg_type: SetGwcScgTypeScgType,
}

impl Mthd for SetGwcScgType {
    const ADDR: u16 = 0x026c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.scg_type as u32) < (1 << 1));
        val |= (self.scg_type as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgControl {
    pub compute1_max_sm_count: u32,
}

impl Mthd for SetScgControl {
    const ADDR: u16 = 0x0270;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.compute1_max_sm_count < (1 << 9));
        val |= self.compute1_max_sm_count << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCacheA {
    pub address_upper: u32,
}

impl Mthd for InvalidateConstantBufferCacheA {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}

pub use cla0c0::InvalidateConstantBufferCacheB;

pub use cla0c0::InvalidateConstantBufferCacheC;

pub use cla0c0::SetComputeClassVersion;

pub use cla0c0::CheckComputeClassVersion;

pub use cla0c0::SetQmdVersion;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetWfiConfig {
    pub enable_scg_type_wfi: bool,
}

impl Mthd for SetWfiConfig {
    const ADDR: u16 = 0x028c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable_scg_type_wfi as u32) < (1 << 1));
        val |= (self.enable_scg_type_wfi as u32) << 0;

        val
    }
}

pub use cla0c0::CheckQmdVersion;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct WaitForIdleScgType {
    pub v: u32,
}

impl Mthd for WaitForIdleScgType {
    const ADDR: u16 = 0x0294;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSkedCaches {
    pub v: u32,
}

impl Mthd for InvalidateSkedCaches {
    const ADDR: u16 = 0x0298;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetScgRenderEnableControl {
    pub compute1_uses_render_enable: bool,
}

impl Mthd for SetScgRenderEnableControl {
    const ADDR: u16 = 0x029c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.compute1_uses_render_enable as u32) < (1 << 1));
        val |= (self.compute1_uses_render_enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindowA {
    pub base_address_upper: u32,
}

impl Mthd for SetShaderSharedMemoryWindowA {
    const ADDR: u16 = 0x02a0;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.base_address_upper < (1 << 17));
        val |= self.base_address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderSharedMemoryWindowB {
    pub base_address: u32,
}

impl Mthd for SetShaderSharedMemoryWindowB {
    const ADDR: u16 = 0x02a4;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.base_address;

        val
    }
}

pub use cla0c0::SetCwdSlotCount;

pub use cla0c0::SendPcasA;

pub use cla0c0::SendPcasB;

pub use cla0c0::SendSignalingPcasB;

pub use cla0c0::SetShaderLocalMemoryNonThrottledA;

pub use cla0c0::SetShaderLocalMemoryNonThrottledB;

pub use cla0c0::SetShaderLocalMemoryNonThrottledC;

pub use cla0c0::SetShaderLocalMemoryThrottledA;

pub use cla0c0::SetShaderLocalMemoryThrottledB;

pub use cla0c0::SetShaderLocalMemoryThrottledC;

pub use cla0c0::SetSpaVersion;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineQmdAddressA {
    pub qmd_address_shifted8_upper: u32,
}

impl Mthd for SetInlineQmdAddressA {
    const ADDR: u16 = 0x0318;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.qmd_address_shifted8_upper;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetInlineQmdAddressB {
    pub qmd_address_shifted8_lower: u32,
}

impl Mthd for SetInlineQmdAddressB {
    const ADDR: u16 = 0x031c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.qmd_address_shifted8_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineQmdData {
    pub v: u32,
}

impl ArrayMthd for LoadInlineQmdData {
    const CLASS: u16 = 0xc0c0;

    fn addr(i: usize) -> u16 {
        (0x0320 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla0c0::SetFalcon00;

pub use cla0c0::SetFalcon01;

pub use cla0c0::SetFalcon02;

pub use cla0c0::SetFalcon03;

pub use cla0c0::SetFalcon04;

pub use cla0c0::SetFalcon05;

pub use cla0c0::SetFalcon06;

pub use cla0c0::SetFalcon07;

pub use cla0c0::SetFalcon08;

pub use cla0c0::SetFalcon09;

pub use cla0c0::SetFalcon10;

pub use cla0c0::SetFalcon11;

pub use cla0c0::SetFalcon12;

pub use cla0c0::SetFalcon13;

pub use cla0c0::SetFalcon14;

pub use cla0c0::SetFalcon15;

pub use cla0c0::SetFalcon16;

pub use cla0c0::SetFalcon17;

pub use cla0c0::SetFalcon18;

pub use cla0c0::SetFalcon19;

pub use cla0c0::SetFalcon20;

pub use cla0c0::SetFalcon21;

pub use cla0c0::SetFalcon22;

pub use cla0c0::SetFalcon23;

pub use cla0c0::SetFalcon24;

pub use cla0c0::SetFalcon25;

pub use cla0c0::SetFalcon26;

pub use cla0c0::SetFalcon27;

pub use cla0c0::SetFalcon28;

pub use cla0c0::SetFalcon29;

pub use cla0c0::SetFalcon30;

pub use cla0c0::SetFalcon31;

pub use cla0c0::SetShaderLocalMemoryWindow;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryA {
    pub address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryA {
    const ADDR: u16 = 0x0790;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}

pub use cla0c0::SetShaderLocalMemoryB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindowA {
    pub base_address_upper: u32,
}

impl Mthd for SetShaderLocalMemoryWindowA {
    const ADDR: u16 = 0x07b0;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.base_address_upper < (1 << 17));
        val |= self.base_address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryWindowB {
    pub base_address: u32,
}

impl Mthd for SetShaderLocalMemoryWindowB {
    const ADDR: u16 = 0x07b4;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.base_address;

        val
    }
}

pub use cla0c0::SetShaderCacheControl;

pub use cla0c0::SetSmTimeoutInterval;

pub use cla0c0::SetSpareNoop12;

pub use cla0c0::SetSpareNoop13;

pub use cla0c0::SetSpareNoop14;

pub use cla0c0::SetSpareNoop15;

pub use cla0c0::SetSpareNoop00;

pub use cla0c0::SetSpareNoop01;

pub use cla0c0::SetSpareNoop02;

pub use cla0c0::SetSpareNoop03;

pub use cla0c0::SetSpareNoop04;

pub use cla0c0::SetSpareNoop05;

pub use cla0c0::SetSpareNoop06;

pub use cla0c0::SetSpareNoop07;

pub use cla0c0::SetSpareNoop08;

pub use cla0c0::SetSpareNoop09;

pub use cla0c0::SetSpareNoop10;

pub use cla0c0::SetSpareNoop11;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheAll {
    pub v: u32,
}

impl Mthd for InvalidateSamplerCacheAll {
    const ADDR: u16 = 0x120c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheAll {
    pub v: u32,
}

impl Mthd for InvalidateTextureHeaderCacheAll {
    const ADDR: u16 = 0x1210;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use cla0c0::InvalidateTextureDataCacheNoWfi;
pub use cla0c0::InvalidateTextureDataCacheNoWfiLines;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ActivatePerfSettingsForComputeContext {
    pub all: bool,
}

impl Mthd for ActivatePerfSettingsForComputeContext {
    const ADDR: u16 = 0x12a8;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.all as u32) < (1 << 1));
        val |= (self.all as u32) << 0;

        val
    }
}

pub use cla0c0::InvalidateSamplerCache;
pub use cla0c0::InvalidateSamplerCacheLines;

pub use cla0c0::InvalidateTextureHeaderCache;
pub use cla0c0::InvalidateTextureHeaderCacheLines;

pub use cla0c0::InvalidateTextureDataCache;
pub use cla0c0::InvalidateTextureDataCacheLines;

pub use cla0c0::InvalidateSamplerCacheNoWfi;
pub use cla0c0::InvalidateSamplerCacheNoWfiLines;

pub use cla0c0::SetShaderExceptions;

pub use cla0c0::SetRenderEnableA;

pub use cla0c0::SetRenderEnableB;

pub use cla0c0::SetRenderEnableC;
pub use cla0c0::SetRenderEnableCMode;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexSamplerPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexSamplerPoolA {
    const ADDR: u16 = 0x155c;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 17));
        val |= self.offset_upper << 0;

        val
    }
}

pub use cla0c0::SetTexSamplerPoolB;

pub use cla0c0::SetTexSamplerPoolC;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTexHeaderPoolA {
    pub offset_upper: u32,
}

impl Mthd for SetTexHeaderPoolA {
    const ADDR: u16 = 0x1574;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 17));
        val |= self.offset_upper << 0;

        val
    }
}

pub use cla0c0::SetTexHeaderPoolB;

pub use cla0c0::SetTexHeaderPoolC;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetProgramRegionA {
    pub address_upper: u32,
}

impl Mthd for SetProgramRegionA {
    const ADDR: u16 = 0x1608;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 17));
        val |= self.address_upper << 0;

        val
    }
}

pub use cla0c0::SetProgramRegionB;

pub use cla0c0::InvalidateShaderCachesNoWfi;

pub use cla0c0::SetRenderEnableOverride;
pub use cla0c0::SetRenderEnableOverrideMode;

pub use cla0c0::PipeNop;

pub use cla0c0::SetSpare00;

pub use cla0c0::SetSpare01;

pub use cla0c0::SetSpare02;

pub use cla0c0::SetSpare03;

pub use cla0c0::SetReportSemaphoreA;

pub use cla0c0::SetReportSemaphoreB;

pub use cla0c0::SetReportSemaphoreC;

pub use cla0c0::SetReportSemaphoreD;
pub use cla0c0::SetReportSemaphoreDOperation;
pub use cla0c0::SetReportSemaphoreDReductionFormat;
pub use cla0c0::SetReportSemaphoreDReductionOp;
pub use cla0c0::SetReportSemaphoreDStructureSize;

pub use cla0c0::SetBindlessTexture;

pub use cla0c0::SetTrapHandler;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValueUpper {
    const CLASS: u16 = 0xc0c0;

    fn addr(i: usize) -> u16 {
        (0x333c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla0c0::SetShaderPerformanceCounterValue;

pub use cla0c0::SetShaderPerformanceCounterEvent;

pub use cla0c0::SetShaderPerformanceCounterControlA;

pub use cla0c0::SetShaderPerformanceCounterControlB;

pub use cla0c0::SetShaderPerformanceCounterTrapControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StartShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StartShaderPerformanceCounter {
    const ADDR: u16 = 0x33e0;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StopShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StopShaderPerformanceCounter {
    const ADDR: u16 = 0x33e4;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterSctlFilter {
    pub v: u32,
}

impl Mthd for SetShaderPerformanceCounterSctlFilter {
    const ADDR: u16 = 0x33e8;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterCoreMioFilter {
    pub v: u32,
}

impl Mthd for SetShaderPerformanceCounterCoreMioFilter {
    const ADDR: u16 = 0x33ec;
    const CLASS: u16 = 0xc0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla0c0::SetMmeShadowScratch;
