use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::clb097::mthd as clb097;

// parsed class NVB197

pub use clb097::SetObject;

pub use clb097::NoOperation;

pub use clb097::SetNotifyA;

pub use clb097::SetNotifyB;

pub use clb097::Notify;
pub use clb097::NotifyType;

pub use clb097::WaitForIdle;

pub use clb097::LoadMmeInstructionRamPointer;

pub use clb097::LoadMmeInstructionRam;

pub use clb097::LoadMmeStartAddressRamPointer;

pub use clb097::LoadMmeStartAddressRam;

pub use clb097::SetMmeShadowRamControl;
pub use clb097::SetMmeShadowRamControlMode;

pub use clb097::PeerSemaphoreReleaseOffsetUpper;

pub use clb097::PeerSemaphoreReleaseOffset;

pub use clb097::SetGlobalRenderEnableA;

pub use clb097::SetGlobalRenderEnableB;

pub use clb097::SetGlobalRenderEnableC;
pub use clb097::SetGlobalRenderEnableCMode;

pub use clb097::SendGoIdle;

pub use clb097::PmTrigger;

pub use clb097::PmTriggerWfi;

pub use clb097::SetInstrumentationMethodHeader;

pub use clb097::SetInstrumentationMethodData;

pub use clb097::LineLengthIn;

pub use clb097::LineCount;

pub use clb097::OffsetOutUpper;

pub use clb097::OffsetOut;

pub use clb097::PitchOut;

pub use clb097::SetDstBlockSize;
pub use clb097::SetDstBlockSizeDepth;
pub use clb097::SetDstBlockSizeHeight;
pub use clb097::SetDstBlockSizeWidth;

pub use clb097::SetDstWidth;

pub use clb097::SetDstHeight;

pub use clb097::SetDstDepth;

pub use clb097::SetDstLayer;

pub use clb097::SetDstOriginBytesX;

pub use clb097::SetDstOriginSamplesY;

pub use clb097::LaunchDma;
pub use clb097::LaunchDmaCompletionType;
pub use clb097::LaunchDmaDstMemoryLayout;
pub use clb097::LaunchDmaInterruptType;
pub use clb097::LaunchDmaReductionFormat;
pub use clb097::LaunchDmaReductionOp;
pub use clb097::LaunchDmaSemaphoreStructSize;

pub use clb097::LoadInlineData;

pub use clb097::SetI2MSemaphoreA;

pub use clb097::SetI2MSemaphoreB;

pub use clb097::SetI2MSemaphoreC;

pub use clb097::SetI2MSpareNoop00;

pub use clb097::SetI2MSpareNoop01;

pub use clb097::SetI2MSpareNoop02;

pub use clb097::SetI2MSpareNoop03;

pub use clb097::RunDsNow;

pub use clb097::SetOpportunisticEarlyZHysteresis;
pub use clb097::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use clb097::SetAliasedLineWidthEnable;

pub use clb097::SetApiMandatedEarlyZ;

pub use clb097::SetGsDmFifo;

pub use clb097::SetL2CacheControlForRopPrefetchReadRequests;
pub use clb097::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use clb097::InvalidateShaderCaches;

pub use clb097::IncrementSyncPoint;
pub use clb097::IncrementSyncPointCondition;

pub use clb097::SetPrimCircularBufferThrottle;

pub use clb097::FlushAndInvalidateRopMiniCache;

pub use clb097::SetSurfaceClipIdBlockSize;
pub use clb097::SetSurfaceClipIdBlockSizeDepth;
pub use clb097::SetSurfaceClipIdBlockSizeHeight;
pub use clb097::SetSurfaceClipIdBlockSizeWidth;

pub use clb097::SetAlphaCircularBufferSize;

pub use clb097::DecompressSurface;

pub use clb097::SetZcullRopBypass;

pub use clb097::SetZcullSubregion;

pub use clb097::SetRasterBoundingBox;
pub use clb097::SetRasterBoundingBoxMode;

pub use clb097::PeerSemaphoreRelease;

pub use clb097::SetIteratedBlendOptimization;
pub use clb097::SetIteratedBlendOptimizationNoop;

pub use clb097::SetZcullSubregionAllocation;
pub use clb097::SetZcullSubregionAllocationFormat;

pub use clb097::AssignZcullSubregions;
pub use clb097::AssignZcullSubregionsAlgorithm;

pub use clb097::SetPsOutputSampleMaskUsage;
pub use clb097::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use clb097::DrawZeroIndex;

pub use clb097::SetL1Configuration;
pub use clb097::SetL1ConfigurationDirectlyAddressableMemory;

pub use clb097::SetRenderEnableControl;

pub use clb097::SetSpaVersion;

pub use clb097::SetIeeeCleanUpdate;

pub use clb097::SetSnapGridLine;
pub use clb097::SetSnapGridLineLocationsPerPixel;
pub use clb097::SetSnapGridLineRoundingMode;

pub use clb097::SetSnapGridNonLine;
pub use clb097::SetSnapGridNonLineLocationsPerPixel;
pub use clb097::SetSnapGridNonLineRoundingMode;

pub use clb097::SetTessellationParameters;
pub use clb097::SetTessellationParametersDomainType;
pub use clb097::SetTessellationParametersOutputPrimitives;
pub use clb097::SetTessellationParametersSpacing;

pub use clb097::SetTessellationLodU0OrDensity;

pub use clb097::SetTessellationLodV0OrDetail;

pub use clb097::SetTessellationLodU1OrW0;

pub use clb097::SetTessellationLodV1;

pub use clb097::SetTgLodInteriorU;

pub use clb097::SetTgLodInteriorV;

pub use clb097::ReservedTg07;

pub use clb097::ReservedTg08;

pub use clb097::ReservedTg09;

pub use clb097::ReservedTg10;

pub use clb097::ReservedTg11;

pub use clb097::ReservedTg12;

pub use clb097::ReservedTg13;

pub use clb097::ReservedTg14;

pub use clb097::ReservedTg15;

pub use clb097::SetSubtilingPerfKnobA;

pub use clb097::SetSubtilingPerfKnobB;

pub use clb097::SetSubtilingPerfKnobC;

pub use clb097::SetZcullSubregionToReport;

pub use clb097::SetZcullSubregionReportType;
pub use clb097::SetZcullSubregionReportTypeType;

pub use clb097::SetBalancedPrimitiveWorkload;

pub use clb097::SetMaxPatchesPerBatch;

pub use clb097::SetRasterEnable;

pub use clb097::SetStreamOutBufferEnable;

pub use clb097::SetStreamOutBufferAddressA;

pub use clb097::SetStreamOutBufferAddressB;

pub use clb097::SetStreamOutBufferSize;

pub use clb097::SetStreamOutBufferLoadWritePointer;

pub use clb097::SetStreamOutControlStream;

pub use clb097::SetStreamOutControlComponentCount;

pub use clb097::SetStreamOutControlStride;

pub use clb097::SetRasterInput;

pub use clb097::SetStreamOutput;

pub use clb097::SetDaPrimitiveRestartTopologyChange;

pub use clb097::SetAlphaFraction;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetHybridAntiAliasControlCentroid {
    PerFragment = 0x00000000,
    PerPass = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetHybridAntiAliasControl {
    pub passes: u32,
    pub centroid: SetHybridAntiAliasControlCentroid,
    pub passes_extended: u32,
}

impl Mthd for SetHybridAntiAliasControl {
    const ADDR: u16 = 0x0754;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.passes < (1 << 4));
        val |= self.passes << 0;

        assert!((self.centroid as u32) < (1 << 1));
        val |= (self.centroid as u32) << 4;

        assert!(self.passes_extended < (1 << 1));
        val |= self.passes_extended << 5;

        val
    }
}

pub use clb097::SetShaderLocalMemoryWindow;

pub use clb097::SetShaderLocalMemoryA;

pub use clb097::SetShaderLocalMemoryB;

pub use clb097::SetShaderLocalMemoryC;

pub use clb097::SetShaderLocalMemoryD;

pub use clb097::SetShaderLocalMemoryE;

pub use clb097::SetColorZeroBandwidthClear;

pub use clb097::SetZZeroBandwidthClear;

pub use clb097::SetIsbeSaveRestoreProgram;

pub use clb097::SetZcullRegionSizeA;

pub use clb097::SetZcullRegionSizeB;

pub use clb097::SetZcullRegionSizeC;

pub use clb097::SetZcullRegionPixelOffsetC;

pub use clb097::SetCullBeforeFetch;

pub use clb097::SetZcullRegionLocation;

pub use clb097::SetZcullRegionAliquots;

pub use clb097::SetZcullStorageA;

pub use clb097::SetZcullStorageB;

pub use clb097::SetZcullStorageC;

pub use clb097::SetZcullStorageD;

pub use clb097::SetZtReadOnly;

pub use clb097::SetColorTargetA;

pub use clb097::SetColorTargetB;

pub use clb097::SetColorTargetWidth;

pub use clb097::SetColorTargetHeight;

pub use clb097::SetColorTargetFormat;
pub use clb097::SetColorTargetFormatV;

pub use clb097::SetColorTargetMemory;
pub use clb097::SetColorTargetMemoryBlockDepth;
pub use clb097::SetColorTargetMemoryBlockHeight;
pub use clb097::SetColorTargetMemoryBlockWidth;
pub use clb097::SetColorTargetMemoryLayout;
pub use clb097::SetColorTargetMemoryThirdDimensionControl;

pub use clb097::SetColorTargetThirdDimension;

pub use clb097::SetColorTargetArrayPitch;

pub use clb097::SetColorTargetLayer;

pub use clb097::SetColorTargetMark;

pub use clb097::SetViewportScaleX;

pub use clb097::SetViewportScaleY;

pub use clb097::SetViewportScaleZ;

pub use clb097::SetViewportOffsetX;

pub use clb097::SetViewportOffsetY;

pub use clb097::SetViewportOffsetZ;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportCoordinateSwizzleX {
    PosX = 0x00000000,
    NegX = 0x00000001,
    PosY = 0x00000002,
    NegY = 0x00000003,
    PosZ = 0x00000004,
    NegZ = 0x00000005,
    PosW = 0x00000006,
    NegW = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportCoordinateSwizzleY {
    PosX = 0x00000000,
    NegX = 0x00000001,
    PosY = 0x00000002,
    NegY = 0x00000003,
    PosZ = 0x00000004,
    NegZ = 0x00000005,
    PosW = 0x00000006,
    NegW = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportCoordinateSwizzleZ {
    PosX = 0x00000000,
    NegX = 0x00000001,
    PosY = 0x00000002,
    NegY = 0x00000003,
    PosZ = 0x00000004,
    NegZ = 0x00000005,
    PosW = 0x00000006,
    NegW = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportCoordinateSwizzleW {
    PosX = 0x00000000,
    NegX = 0x00000001,
    PosY = 0x00000002,
    NegY = 0x00000003,
    PosZ = 0x00000004,
    NegZ = 0x00000005,
    PosW = 0x00000006,
    NegW = 0x00000007,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportCoordinateSwizzle {
    pub x: SetViewportCoordinateSwizzleX,
    pub y: SetViewportCoordinateSwizzleY,
    pub z: SetViewportCoordinateSwizzleZ,
    pub w: SetViewportCoordinateSwizzleW,
}

impl ArrayMthd for SetViewportCoordinateSwizzle {
    const CLASS: u16 = 0xb197;

    fn addr(i: usize) -> u16 {
        (0x0a18 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.x as u32) < (1 << 3));
        val |= (self.x as u32) << 0;

        assert!((self.y as u32) < (1 << 3));
        val |= (self.y as u32) << 4;

        assert!((self.z as u32) < (1 << 3));
        val |= (self.z as u32) << 8;

        assert!((self.w as u32) < (1 << 3));
        val |= (self.w as u32) << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportIncreaseSnapGridPrecision {
    pub x_bits: u32,
    pub y_bits: u32,
}

impl ArrayMthd for SetViewportIncreaseSnapGridPrecision {
    const CLASS: u16 = 0xb197;

    fn addr(i: usize) -> u16 {
        (0x0a1c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x_bits < (1 << 5));
        val |= self.x_bits << 0;

        assert!(self.y_bits < (1 << 5));
        val |= self.y_bits << 8;

        val
    }
}

pub use clb097::SetViewportClipHorizontal;

pub use clb097::SetViewportClipVertical;

pub use clb097::SetViewportClipMinZ;

pub use clb097::SetViewportClipMaxZ;

pub use clb097::SetWindowClipHorizontal;

pub use clb097::SetWindowClipVertical;

pub use clb097::SetClipIdExtentX;

pub use clb097::SetClipIdExtentY;

pub use clb097::SetMaxStreamOutputGsInstancesPerTask;

pub use clb097::SetApiVisibleCallLimit;
pub use clb097::SetApiVisibleCallLimitV;

pub use clb097::SetStatisticsCounter;

pub use clb097::SetClearRectHorizontal;

pub use clb097::SetClearRectVertical;

pub use clb097::SetVertexArrayStart;

pub use clb097::DrawVertexArray;

pub use clb097::SetViewportZClip;
pub use clb097::SetViewportZClipRange;

pub use clb097::SetColorClearValue;

pub use clb097::SetZClearValue;

pub use clb097::SetShaderCacheControl;

pub use clb097::ForceTransitionToBeta;

pub use clb097::SetReduceColorThresholdsEnable;

pub use clb097::SetStencilClearValue;

pub use clb097::InvalidateShaderCachesNoWfi;

pub use clb097::SetZcullSerialization;
pub use clb097::SetZcullSerializationApplied;

pub use clb097::SetFrontPolygonMode;
pub use clb097::SetFrontPolygonModeV;

pub use clb097::SetBackPolygonMode;
pub use clb097::SetBackPolygonModeV;

pub use clb097::SetPolySmooth;

pub use clb097::SetZtMark;

pub use clb097::SetZcullDirFormat;
pub use clb097::SetZcullDirFormatZdir;
pub use clb097::SetZcullDirFormatZformat;

pub use clb097::SetPolyOffsetPoint;

pub use clb097::SetPolyOffsetLine;

pub use clb097::SetPolyOffsetFill;

pub use clb097::SetPatch;

pub use clb097::SetIteratedBlend;

pub use clb097::SetIteratedBlendPass;

pub use clb097::SetZcullCriterion;
pub use clb097::SetZcullCriterionSfunc;

pub use clb097::PixelShaderBarrier;

pub use clb097::SetSmTimeoutInterval;

pub use clb097::SetDaPrimitiveRestartVertexArray;

pub use clb097::LoadIteratedBlendInstructionPointer;

pub use clb097::LoadIteratedBlendInstruction;
pub use clb097::LoadIteratedBlendInstructionConstantInputSelect;
pub use clb097::LoadIteratedBlendInstructionOperandASelect;
pub use clb097::LoadIteratedBlendInstructionOperandBSelect;
pub use clb097::LoadIteratedBlendInstructionOperandCSelect;
pub use clb097::LoadIteratedBlendInstructionOperandDSelect;
pub use clb097::LoadIteratedBlendInstructionOperation;
pub use clb097::LoadIteratedBlendInstructionOutputSwizzle;
pub use clb097::LoadIteratedBlendInstructionOutputWriteMask;
pub use clb097::LoadIteratedBlendInstructionPassOutput;
pub use clb097::LoadIteratedBlendInstructionTestCc;

pub use clb097::SetWindowOffsetX;

pub use clb097::SetWindowOffsetY;

pub use clb097::SetScissorEnable;

pub use clb097::SetScissorHorizontal;

pub use clb097::SetScissorVertical;

pub use clb097::SetSelectMaxwellTextureHeaders;

pub use clb097::SetVpcPerfKnob;

pub use clb097::PmLocalTrigger;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPostZPsImask {
    pub enable: bool,
}

impl Mthd for SetPostZPsImask {
    const ADDR: u16 = 0x0f1c;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

pub use clb097::SetConstantColorRendering;

pub use clb097::SetConstantColorRenderingRed;

pub use clb097::SetConstantColorRenderingGreen;

pub use clb097::SetConstantColorRenderingBlue;

pub use clb097::SetConstantColorRenderingAlpha;

pub use clb097::SetBackStencilFuncRef;

pub use clb097::SetBackStencilMask;

pub use clb097::SetBackStencilFuncMask;

pub use clb097::SetVertexStreamSubstituteA;

pub use clb097::SetVertexStreamSubstituteB;

pub use clb097::SetLineModePolygonClip;
pub use clb097::SetLineModePolygonClipGeneratedEdge;

pub use clb097::SetSingleCtWriteControl;

pub use clb097::SetVtgWarpWatermarks;

pub use clb097::SetDepthBoundsMin;

pub use clb097::SetDepthBoundsMax;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSampleMask {
    pub raster_out_enable: bool,
    pub color_target_enable: bool,
}

impl Mthd for SetSampleMask {
    const ADDR: u16 = 0x0fa4;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.raster_out_enable as u32) < (1 << 1));
        val |= (self.raster_out_enable as u32) << 0;

        assert!((self.color_target_enable as u32) < (1 << 1));
        val |= (self.color_target_enable as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetSampleMask {
    pub v: u32,
}

impl Mthd for SetColorTargetSampleMask {
    const ADDR: u16 = 0x0fa8;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

pub use clb097::SetCtMrtEnable;

pub use clb097::SetNonmultisampledZ;
pub use clb097::SetNonmultisampledZV;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirMode {
    Disabled = 0x00000000,
    RasterNTargetM = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTir {
    pub mode: SetTirMode,
}

impl Mthd for SetTir {
    const ADDR: u16 = 0x0fb4;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetAntiAliasRasterSamples {
    Mode1X1 = 0x00000000,
    Mode2X2 = 0x00000002,
    Mode4X2D3D = 0x00000004,
    Mode2X1D3D = 0x00000005,
    Mode4X4 = 0x00000006,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasRaster {
    pub samples: SetAntiAliasRasterSamples,
}

impl Mthd for SetAntiAliasRaster {
    const ADDR: u16 = 0x0fb8;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.samples as u32) < (1 << 3));
        val |= (self.samples as u32) << 0;

        val
    }
}

pub use clb097::SetSampleMaskX0Y0;

pub use clb097::SetSampleMaskX1Y0;

pub use clb097::SetSampleMaskX0Y1;

pub use clb097::SetSampleMaskX1Y1;

pub use clb097::SetSurfaceClipIdMemoryA;

pub use clb097::SetSurfaceClipIdMemoryB;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirModulationComponentSelect {
    NoModulation = 0x00000000,
    ModulateRgb = 0x00000001,
    ModulateAlphaOnly = 0x00000002,
    ModulateRgba = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTirModulation {
    pub component_select: SetTirModulationComponentSelect,
}

impl Mthd for SetTirModulation {
    const ADDR: u16 = 0x0fd4;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.component_select as u32) < (1 << 2));
        val |= (self.component_select as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirModulationFunctionSelect {
    Linear = 0x00000000,
    Table = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTirModulationFunction {
    pub select: SetTirModulationFunctionSelect,
}

impl Mthd for SetTirModulationFunction {
    const ADDR: u16 = 0x0fd8;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.select as u32) < (1 << 1));
        val |= (self.select as u32) << 0;

        val
    }
}

pub use clb097::SetBlendOptControl;

pub use clb097::SetZtA;

pub use clb097::SetZtB;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtFormatV {
    Z16 = 0x00000013,
    Z24S8 = 0x00000014,
    X8Z24 = 0x00000015,
    S8Z24 = 0x00000016,
    S8 = 0x00000017,
    V8Z24 = 0x00000018,
    Zf32 = 0x0000000a,
    Zf32X24S8 = 0x00000019,
    X8Z24X16V8S8 = 0x0000001d,
    Zf32X16V8X8 = 0x0000001e,
    Zf32X16V8S8 = 0x0000001f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtFormat {
    pub v: SetZtFormatV,
}

impl Mthd for SetZtFormat {
    const ADDR: u16 = 0x0fe8;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 5));
        val |= (self.v as u32) << 0;

        val
    }
}

pub use clb097::SetZtBlockSize;
pub use clb097::SetZtBlockSizeDepth;
pub use clb097::SetZtBlockSizeHeight;
pub use clb097::SetZtBlockSizeWidth;

pub use clb097::SetZtArrayPitch;

pub use clb097::SetSurfaceClipHorizontal;

pub use clb097::SetSurfaceClipVertical;

pub use clb097::SetTiledCacheBundleControl;

pub use clb097::SetL2CacheControlForVafRequests;
pub use clb097::SetL2CacheControlForVafRequestsPolicy;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportMulticastOrder {
    ViewportOrder = 0x00000000,
    PrimitiveOrder = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportMulticast {
    pub order: SetViewportMulticastOrder,
}

impl Mthd for SetViewportMulticast {
    const ADDR: u16 = 0x1004;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.order as u32) < (1 << 1));
        val |= (self.order as u32) << 0;

        val
    }
}

pub use clb097::SetTessellationCutHeight;

pub use clb097::SetMaxGsInstancesPerTask;

pub use clb097::SetMaxGsOutputVerticesPerTask;

pub use clb097::SetReservedSwMethod00;

pub use clb097::SetGsOutputCbStorageMultiplier;

pub use clb097::SetBetaCbStorageConstraint;

pub use clb097::SetTiOutputCbStorageMultiplier;

pub use clb097::SetAlphaCbStorageConstraint;

pub use clb097::SetReservedSwMethod01;

pub use clb097::SetReservedSwMethod02;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTirModulationCoefficientTable {
    pub v0: u32,
    pub v1: u32,
    pub v2: u32,
    pub v3: u32,
}

impl ArrayMthd for SetTirModulationCoefficientTable {
    const CLASS: u16 = 0xb197;

    fn addr(i: usize) -> u16 {
        (0x1030 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v0 < (1 << 8));
        val |= self.v0 << 0;

        assert!(self.v1 < (1 << 8));
        val |= self.v1 << 8;

        assert!(self.v2 < (1 << 8));
        val |= self.v2 << 16;

        assert!(self.v3 < (1 << 8));
        val |= self.v3 << 24;

        val
    }
}

pub use clb097::SetSpareNoop01;

pub use clb097::SetSpareNoop02;

pub use clb097::SetSpareNoop03;

pub use clb097::SetSpareNoop04;

pub use clb097::SetSpareNoop05;

pub use clb097::SetSpareNoop06;

pub use clb097::SetSpareNoop07;

pub use clb097::SetSpareNoop08;

pub use clb097::SetSpareNoop09;

pub use clb097::SetSpareNoop10;

pub use clb097::SetSpareNoop11;

pub use clb097::SetSpareNoop12;

pub use clb097::SetSpareNoop13;

pub use clb097::SetSpareNoop14;

pub use clb097::SetSpareNoop15;

pub use clb097::SetReservedSwMethod03;

pub use clb097::SetReservedSwMethod04;

pub use clb097::SetReservedSwMethod05;

pub use clb097::SetReservedSwMethod06;

pub use clb097::SetReservedSwMethod07;

pub use clb097::SetReservedSwMethod08;

pub use clb097::SetReservedSwMethod09;

pub use clb097::SetReduceColorThresholdsUnorm8;

pub use clb097::SetReservedSwMethod10;

pub use clb097::SetReservedSwMethod11;

pub use clb097::SetReservedSwMethod12;

pub use clb097::SetReservedSwMethod13;

pub use clb097::SetReduceColorThresholdsUnorm10;

pub use clb097::SetReduceColorThresholdsUnorm16;

pub use clb097::SetReduceColorThresholdsFp11;

pub use clb097::SetReduceColorThresholdsFp16;

pub use clb097::SetReduceColorThresholdsSrgb8;

pub use clb097::UnbindAll;

pub use clb097::SetClearSurfaceControl;

pub use clb097::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use clb097::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use clb097::SetReservedSwMethod14;

pub use clb097::SetReservedSwMethod15;

pub use clb097::NoOperationDataHi;

pub use clb097::SetDepthBiasControl;

pub use clb097::PmTriggerEnd;

pub use clb097::SetVertexIdBase;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetStencilCompression {
    pub enable: bool,
}

impl Mthd for SetStencilCompression {
    const ADDR: u16 = 0x111c;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

pub use clb097::SetDaOutputAttributeSkipMaskA;

pub use clb097::SetDaOutputAttributeSkipMaskB;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlZPassPixelCountUseRasterSamples {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlAlphaToCoverageUseRasterSamples {
    Disable = 0x00000000,
    Enable = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTirControlReduceCoverage {
    Disable = 0x00000000,
    Enable = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTirControl {
    pub z_pass_pixel_count_use_raster_samples: SetTirControlZPassPixelCountUseRasterSamples,
    pub alpha_to_coverage_use_raster_samples: SetTirControlAlphaToCoverageUseRasterSamples,
    pub reduce_coverage: SetTirControlReduceCoverage,
}

impl Mthd for SetTirControl {
    const ADDR: u16 = 0x1130;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_pass_pixel_count_use_raster_samples as u32) < (1 << 1));
        val |= (self.z_pass_pixel_count_use_raster_samples as u32) << 0;

        assert!((self.alpha_to_coverage_use_raster_samples as u32) < (1 << 1));
        val |= (self.alpha_to_coverage_use_raster_samples as u32) << 4;

        assert!((self.reduce_coverage as u32) < (1 << 1));
        val |= (self.reduce_coverage as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMutableMethodControl {
    pub treat_mutable_as_heavyweight: bool,
}

impl Mthd for SetMutableMethodControl {
    const ADDR: u16 = 0x1134;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.treat_mutable_as_heavyweight as u32) < (1 << 1));
        val |= (self.treat_mutable_as_heavyweight as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPostPsInitialCoverage {
    pub use_pre_ps_coverage: bool,
}

impl Mthd for SetPostPsInitialCoverage {
    const ADDR: u16 = 0x1138;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.use_pre_ps_coverage as u32) < (1 << 1));
        val |= (self.use_pre_ps_coverage as u32) << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetFillViaTriangleMode {
    Disabled = 0x00000000,
    FillAll = 0x00000001,
    FillBbox = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetFillViaTriangle {
    pub mode: SetFillViaTriangleMode,
}

impl Mthd for SetFillViaTriangle {
    const ADDR: u16 = 0x113c;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.mode as u32) < (1 << 2));
        val |= (self.mode as u32) << 0;

        val
    }
}

pub use clb097::SetBlendPerFormatEnable;

pub use clb097::FlushPendingWrites;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConservativeRaster {
    pub enable: bool,
}

impl Mthd for SetConservativeRaster {
    const ADDR: u16 = 0x1148;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

pub use clb097::SetVertexAttributeA;
pub use clb097::SetVertexAttributeAComponentBitWidths;
pub use clb097::SetVertexAttributeANumericalType;
pub use clb097::SetVertexAttributeASource;

pub use clb097::SetVertexAttributeB;
pub use clb097::SetVertexAttributeBComponentBitWidths;
pub use clb097::SetVertexAttributeBNumericalType;
pub use clb097::SetVertexAttributeBSource;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAntiAliasSamplePositions {
    pub x0: u32,
    pub y0: u32,
    pub x1: u32,
    pub y1: u32,
    pub x2: u32,
    pub y2: u32,
    pub x3: u32,
    pub y3: u32,
}

impl ArrayMthd for SetAntiAliasSamplePositions {
    const CLASS: u16 = 0xb197;

    fn addr(i: usize) -> u16 {
        (0x11e0 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.x0 < (1 << 4));
        val |= self.x0 << 0;

        assert!(self.y0 < (1 << 4));
        val |= self.y0 << 4;

        assert!(self.x1 < (1 << 4));
        val |= self.x1 << 8;

        assert!(self.y1 < (1 << 4));
        val |= self.y1 << 12;

        assert!(self.x2 < (1 << 4));
        val |= self.x2 << 16;

        assert!(self.y2 < (1 << 4));
        val |= self.y2 << 20;

        assert!(self.x3 < (1 << 4));
        val |= self.x3 << 24;

        assert!(self.y3 < (1 << 4));
        val |= self.y3 << 28;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetOffsetRenderTargetIndex {
    pub by_viewport_index: bool,
}

impl Mthd for SetOffsetRenderTargetIndex {
    const ADDR: u16 = 0x11f0;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.by_viewport_index as u32) < (1 << 1));
        val |= (self.by_viewport_index as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ForceHeavyweightMethodSync {
    pub v: u32,
}

impl Mthd for ForceHeavyweightMethodSync {
    const ADDR: u16 = 0x11f4;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCoverageToColor {
    pub enable: bool,
    pub ct_select: u32,
}

impl Mthd for SetCoverageToColor {
    const ADDR: u16 = 0x11f8;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.ct_select < (1 << 3));
        val |= self.ct_select << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DecompressZetaSurface {
    pub z_enable: bool,
    pub stencil_enable: bool,
}

impl Mthd for DecompressZetaSurface {
    const ADDR: u16 = 0x11fc;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.z_enable as u32) < (1 << 1));
        val |= (self.z_enable as u32) << 0;

        assert!((self.stencil_enable as u32) < (1 << 1));
        val |= (self.stencil_enable as u32) << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZtSparseUnmappedCompare {
    ZtSparseUnmapped0 = 0x00000000,
    ZtSparseFailAlways = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZtSparse {
    pub enable: bool,
    pub unmapped_compare: SetZtSparseUnmappedCompare,
}

impl Mthd for SetZtSparse {
    const ADDR: u16 = 0x1208;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.unmapped_compare as u32) < (1 << 1));
        val |= (self.unmapped_compare as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateSamplerCacheAll {
    pub v: u32,
}

impl Mthd for InvalidateSamplerCacheAll {
    const ADDR: u16 = 0x120c;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureHeaderCacheAll {
    pub v: u32,
}

impl Mthd for InvalidateTextureHeaderCacheAll {
    const ADDR: u16 = 0x1210;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use clb097::DrawVertexArrayBeginEndInstanceFirst;
pub use clb097::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use clb097::DrawVertexArrayBeginEndInstanceSubsequent;
pub use clb097::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use clb097::SetCtSelect;

pub use clb097::SetCompressionThreshold;
pub use clb097::SetCompressionThresholdSamples;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerMode {
    NoConflictDetect = 0x00000000,
    ConflictDetectSample = 0x00000001,
    ConflictDetectPixel = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerTileSize {
    TcTileSize16X16 = 0x00000000,
    TcTileSize8X8 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPixelShaderInterlockControlTileCoalescerFragmentOrder {
    TcFragmentOrdered = 0x00000000,
    TcFragmentUnordered = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelShaderInterlockControl {
    pub tile_coalescer_mode: SetPixelShaderInterlockControlTileCoalescerMode,
    pub tile_coalescer_tile_size: SetPixelShaderInterlockControlTileCoalescerTileSize,
    pub tile_coalescer_fragment_order: SetPixelShaderInterlockControlTileCoalescerFragmentOrder,
}

impl Mthd for SetPixelShaderInterlockControl {
    const ADDR: u16 = 0x1224;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.tile_coalescer_mode as u32) < (1 << 2));
        val |= (self.tile_coalescer_mode as u32) << 0;

        assert!((self.tile_coalescer_tile_size as u32) < (1 << 1));
        val |= (self.tile_coalescer_tile_size as u32) << 2;

        assert!((self.tile_coalescer_fragment_order as u32) < (1 << 1));
        val |= (self.tile_coalescer_fragment_order as u32) << 3;

        val
    }
}

pub use clb097::SetZtSizeA;

pub use clb097::SetZtSizeB;

pub use clb097::SetZtSizeC;
pub use clb097::SetZtSizeCControl;

pub use clb097::SetSamplerBinding;
pub use clb097::SetSamplerBindingV;

pub use clb097::DrawAuto;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPostVtgShaderAttributeSkipMask {
    pub v: u32,
}

impl ArrayMthd for SetPostVtgShaderAttributeSkipMask {
    const CLASS: u16 = 0xb197;

    fn addr(i: usize) -> u16 {
        (0x1240 + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPixelShaderTicketDispenserValue {
    pub ticket_dispenser_index: u32,
    pub ticket_dispenser_value: u32,
}

impl Mthd for SetPixelShaderTicketDispenserValue {
    const ADDR: u16 = 0x1260;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.ticket_dispenser_index < (1 << 8));
        val |= self.ticket_dispenser_index << 0;

        assert!(self.ticket_dispenser_value < (1 << 16));
        val |= self.ticket_dispenser_value << 8;

        val
    }
}

pub use clb097::SetCircularBufferSize;

pub use clb097::SetVtgRegisterWatermarks;

pub use clb097::InvalidateTextureDataCacheNoWfi;
pub use clb097::InvalidateTextureDataCacheNoWfiLines;

pub use clb097::SetL2CacheControlForRopInterlockedReadRequests;
pub use clb097::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use clb097::SetDaPrimitiveRestartIndexTopologyChange;

pub use clb097::ClearZcullRegion;

pub use clb097::SetDepthTest;

pub use clb097::SetFillMode;
pub use clb097::SetFillModeV;

pub use clb097::SetShadeMode;
pub use clb097::SetShadeModeV;

pub use clb097::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use clb097::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use clb097::SetL2CacheControlForRopInterlockedWriteRequests;
pub use clb097::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use clb097::SetAlphaToCoverageDitherControl;
pub use clb097::SetAlphaToCoverageDitherControlDitherFootprint;

pub use clb097::SetBlendStatePerTarget;

pub use clb097::SetDepthWrite;

pub use clb097::SetAlphaTest;

pub use clb097::SetInlineIndex4X8Align;

pub use clb097::DrawInlineIndex4X8;

pub use clb097::D3DSetCullMode;
pub use clb097::D3DSetCullModeV;

pub use clb097::SetDepthFunc;
pub use clb097::SetDepthFuncV;

pub use clb097::SetAlphaRef;

pub use clb097::SetAlphaFunc;
pub use clb097::SetAlphaFuncV;

pub use clb097::SetDrawAutoStride;

pub use clb097::SetBlendConstRed;

pub use clb097::SetBlendConstGreen;

pub use clb097::SetBlendConstBlue;

pub use clb097::SetBlendConstAlpha;

pub use clb097::InvalidateSamplerCache;
pub use clb097::InvalidateSamplerCacheLines;

pub use clb097::InvalidateTextureHeaderCache;
pub use clb097::InvalidateTextureHeaderCacheLines;

pub use clb097::InvalidateTextureDataCache;
pub use clb097::InvalidateTextureDataCacheLines;

pub use clb097::SetBlendSeparateForAlpha;

pub use clb097::SetBlendColorOp;
pub use clb097::SetBlendColorOpV;

pub use clb097::SetBlendColorSourceCoeff;
pub use clb097::SetBlendColorSourceCoeffV;

pub use clb097::SetBlendColorDestCoeff;
pub use clb097::SetBlendColorDestCoeffV;

pub use clb097::SetBlendAlphaOp;
pub use clb097::SetBlendAlphaOpV;

pub use clb097::SetBlendAlphaSourceCoeff;
pub use clb097::SetBlendAlphaSourceCoeffV;

pub use clb097::SetGlobalColorKey;

pub use clb097::SetBlendAlphaDestCoeff;
pub use clb097::SetBlendAlphaDestCoeffV;

pub use clb097::SetSingleRopControl;

pub use clb097::SetBlend;

pub use clb097::SetStencilTest;

pub use clb097::SetStencilOpFail;
pub use clb097::SetStencilOpFailV;

pub use clb097::SetStencilOpZfail;
pub use clb097::SetStencilOpZfailV;

pub use clb097::SetStencilOpZpass;
pub use clb097::SetStencilOpZpassV;

pub use clb097::SetStencilFunc;
pub use clb097::SetStencilFuncV;

pub use clb097::SetStencilFuncRef;

pub use clb097::SetStencilFuncMask;

pub use clb097::SetStencilMask;

pub use clb097::SetDrawAutoStart;

pub use clb097::SetPsSaturate;
pub use clb097::SetPsSaturateClampRange0;
pub use clb097::SetPsSaturateClampRange1;
pub use clb097::SetPsSaturateClampRange2;
pub use clb097::SetPsSaturateClampRange3;
pub use clb097::SetPsSaturateClampRange4;
pub use clb097::SetPsSaturateClampRange5;
pub use clb097::SetPsSaturateClampRange6;
pub use clb097::SetPsSaturateClampRange7;

pub use clb097::SetWindowOrigin;
pub use clb097::SetWindowOriginMode;

pub use clb097::SetLineWidthFloat;

pub use clb097::SetAliasedLineWidthFloat;

pub use clb097::SetLineMultisampleOverride;

pub use clb097::SetAlphaHysteresis;

pub use clb097::InvalidateSamplerCacheNoWfi;
pub use clb097::InvalidateSamplerCacheNoWfiLines;

pub use clb097::InvalidateTextureHeaderCacheNoWfi;
pub use clb097::InvalidateTextureHeaderCacheNoWfiLines;

pub use clb097::SetGlobalBaseVertexIndex;

pub use clb097::SetGlobalBaseInstanceIndex;

pub use clb097::SetPsWarpWatermarks;

pub use clb097::SetPsRegisterWatermarks;

pub use clb097::StoreZcull;

pub use clb097::SetIteratedBlendConstantRed;

pub use clb097::SetIteratedBlendConstantGreen;

pub use clb097::SetIteratedBlendConstantBlue;

pub use clb097::LoadZcull;

pub use clb097::SetSurfaceClipIdHeight;

pub use clb097::SetClipIdClearRectHorizontal;

pub use clb097::SetClipIdClearRectVertical;

pub use clb097::SetUserClipEnable;

pub use clb097::SetZpassPixelCount;

pub use clb097::SetPointSize;

pub use clb097::SetZcullStats;

pub use clb097::SetPointSprite;

pub use clb097::SetShaderExceptions;

pub use clb097::ClearReportValue;
pub use clb097::ClearReportValueType;

pub use clb097::SetAntiAliasEnable;

pub use clb097::SetZtSelect;

pub use clb097::SetAntiAliasAlphaControl;
pub use clb097::SetAntiAliasAlphaControlAlphaToCoverage;
pub use clb097::SetAntiAliasAlphaControlAlphaToOne;

pub use clb097::SetRenderEnableA;

pub use clb097::SetRenderEnableB;

pub use clb097::SetRenderEnableC;
pub use clb097::SetRenderEnableCMode;

pub use clb097::SetTexSamplerPoolA;

pub use clb097::SetTexSamplerPoolB;

pub use clb097::SetTexSamplerPoolC;

pub use clb097::SetSlopeScaleDepthBias;

pub use clb097::SetAntiAliasedLine;

pub use clb097::SetTexHeaderPoolA;

pub use clb097::SetTexHeaderPoolB;

pub use clb097::SetTexHeaderPoolC;

pub use clb097::SetActiveZcullRegion;

pub use clb097::SetTwoSidedStencilTest;

pub use clb097::SetBackStencilOpFail;
pub use clb097::SetBackStencilOpFailV;

pub use clb097::SetBackStencilOpZfail;
pub use clb097::SetBackStencilOpZfailV;

pub use clb097::SetBackStencilOpZpass;
pub use clb097::SetBackStencilOpZpassV;

pub use clb097::SetBackStencilFunc;
pub use clb097::SetBackStencilFuncV;

pub use clb097::SetSrgbWrite;

pub use clb097::SetDepthBias;

pub use clb097::SetZcullRegionFormat;
pub use clb097::SetZcullRegionFormatType;

pub use clb097::SetRtLayer;
pub use clb097::SetRtLayerControl;

pub use clb097::SetAntiAlias;
pub use clb097::SetAntiAliasSamples;

pub use clb097::SetEdgeFlag;

pub use clb097::DrawInlineIndex;

pub use clb097::SetInlineIndex2X16Align;

pub use clb097::DrawInlineIndex2X16;

pub use clb097::SetVertexGlobalBaseOffsetA;

pub use clb097::SetVertexGlobalBaseOffsetB;

pub use clb097::SetZcullRegionPixelOffsetA;

pub use clb097::SetZcullRegionPixelOffsetB;

pub use clb097::SetPointSpriteSelect;
pub use clb097::SetPointSpriteSelectOrigin;
pub use clb097::SetPointSpriteSelectRmode;
pub use clb097::SetPointSpriteSelectTexture0;
pub use clb097::SetPointSpriteSelectTexture1;
pub use clb097::SetPointSpriteSelectTexture2;
pub use clb097::SetPointSpriteSelectTexture3;
pub use clb097::SetPointSpriteSelectTexture4;
pub use clb097::SetPointSpriteSelectTexture5;
pub use clb097::SetPointSpriteSelectTexture6;
pub use clb097::SetPointSpriteSelectTexture7;
pub use clb097::SetPointSpriteSelectTexture8;
pub use clb097::SetPointSpriteSelectTexture9;

pub use clb097::SetProgramRegionA;

pub use clb097::SetProgramRegionB;

pub use clb097::SetAttributeDefault;
pub use clb097::SetAttributeDefaultColorFrontDiffuse;
pub use clb097::SetAttributeDefaultColorFrontSpecular;
pub use clb097::SetAttributeDefaultDx9Color0;
pub use clb097::SetAttributeDefaultDx9Color1ToColor15;
pub use clb097::SetAttributeDefaultFixedFncTexture;
pub use clb097::SetAttributeDefaultGenericVector;

pub use clb097::End;

pub use clb097::Begin;
pub use clb097::BeginInstanceId;
pub use clb097::BeginOp;
pub use clb097::BeginPrimitiveId;
pub use clb097::BeginSplitMode;

pub use clb097::SetVertexIdCopy;

pub use clb097::AddToPrimitiveId;

pub use clb097::LoadPrimitiveId;

pub use clb097::SetShaderBasedCull;

pub use clb097::SetClassVersion;

pub use clb097::SetDaPrimitiveRestart;

pub use clb097::SetDaPrimitiveRestartIndex;

pub use clb097::SetDaOutput;

pub use clb097::SetAntiAliasedPoint;

pub use clb097::SetPointCenterMode;
pub use clb097::SetPointCenterModeV;

pub use clb097::SetLineSmoothParameters;
pub use clb097::SetLineSmoothParametersFalloff;

pub use clb097::SetLineStipple;

pub use clb097::SetLineSmoothEdgeTable;

pub use clb097::SetLineStippleParameters;

pub use clb097::SetProvokingVertex;
pub use clb097::SetProvokingVertexV;

pub use clb097::SetTwoSidedLight;

pub use clb097::SetPolygonStipple;

pub use clb097::SetShaderControl;
pub use clb097::SetShaderControlDefaultPartial;
pub use clb097::SetShaderControlFp32F2INanBehavior;
pub use clb097::SetShaderControlFp32NanBehavior;

pub use clb097::CheckClassVersion;

pub use clb097::SetSphVersion;

pub use clb097::CheckSphVersion;

pub use clb097::SetAlphaToCoverageOverride;
pub use clb097::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use clb097::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use clb097::SetPolygonStipplePattern;

pub use clb097::SetAamVersion;

pub use clb097::CheckAamVersion;

pub use clb097::SetZtLayer;

pub use clb097::SetIndexBufferA;

pub use clb097::SetIndexBufferB;

pub use clb097::SetIndexBufferC;

pub use clb097::SetIndexBufferD;

pub use clb097::SetIndexBufferE;
pub use clb097::SetIndexBufferEIndexSize;

pub use clb097::SetIndexBufferF;

pub use clb097::DrawIndexBuffer;

pub use clb097::DrawIndexBuffer32BeginEndInstanceFirst;
pub use clb097::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use clb097::DrawIndexBuffer16BeginEndInstanceFirst;
pub use clb097::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use clb097::DrawIndexBuffer8BeginEndInstanceFirst;
pub use clb097::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use clb097::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use clb097::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use clb097::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use clb097::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use clb097::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use clb097::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use clb097::SetDepthBiasClamp;

pub use clb097::SetVertexStreamInstanceA;

pub use clb097::SetVertexStreamInstanceB;

pub use clb097::SetAttributePointSize;

pub use clb097::OglSetCull;

pub use clb097::OglSetFrontFace;
pub use clb097::OglSetFrontFaceV;

pub use clb097::OglSetCullFace;
pub use clb097::OglSetCullFaceV;

pub use clb097::SetViewportPixel;
pub use clb097::SetViewportPixelCenter;

pub use clb097::SetViewportScaleOffset;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMinZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlPixelMaxZ {
    Clip = 0x00000000,
    Clamp = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlLinePointCullGuardband {
    Scale256 = 0x00000000,
    Scale1 = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryClip {
    WzeroClip = 0x00000000,
    Passthru = 0x00000001,
    FrustumXyClip = 0x00000002,
    FrustumXyzClip = 0x00000003,
    WzeroClipNoZCull = 0x00000004,
    FrustumZClip = 0x00000005,
    WzeroTriFillOrClip = 0x00000006,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetViewportClipControlGeometryGuardbandZ {
    SameAsXyGuardband = 0x00000000,
    Scale256 = 0x00000001,
    Scale1 = 0x00000002,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetViewportClipControl {
    pub min_z_zero_max_z_one: bool,
    pub pixel_min_z: SetViewportClipControlPixelMinZ,
    pub pixel_max_z: SetViewportClipControlPixelMaxZ,
    pub geometry_guardband: SetViewportClipControlGeometryGuardband,
    pub line_point_cull_guardband: SetViewportClipControlLinePointCullGuardband,
    pub geometry_clip: SetViewportClipControlGeometryClip,
    pub geometry_guardband_z: SetViewportClipControlGeometryGuardbandZ,
}

impl Mthd for SetViewportClipControl {
    const ADDR: u16 = 0x193c;
    const CLASS: u16 = 0xb197;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.min_z_zero_max_z_one as u32) < (1 << 1));
        val |= (self.min_z_zero_max_z_one as u32) << 0;

        assert!((self.pixel_min_z as u32) < (1 << 1));
        val |= (self.pixel_min_z as u32) << 3;

        assert!((self.pixel_max_z as u32) < (1 << 1));
        val |= (self.pixel_max_z as u32) << 4;

        assert!((self.geometry_guardband as u32) < (1 << 1));
        val |= (self.geometry_guardband as u32) << 7;

        assert!((self.line_point_cull_guardband as u32) < (1 << 1));
        val |= (self.line_point_cull_guardband as u32) << 10;

        assert!((self.geometry_clip as u32) < (1 << 3));
        val |= (self.geometry_clip as u32) << 11;

        assert!((self.geometry_guardband_z as u32) < (1 << 2));
        val |= (self.geometry_guardband_z as u32) << 1;

        val
    }
}

pub use clb097::SetUserClipOp;
pub use clb097::SetUserClipOpPlane0;
pub use clb097::SetUserClipOpPlane1;
pub use clb097::SetUserClipOpPlane2;
pub use clb097::SetUserClipOpPlane3;
pub use clb097::SetUserClipOpPlane4;
pub use clb097::SetUserClipOpPlane5;
pub use clb097::SetUserClipOpPlane6;
pub use clb097::SetUserClipOpPlane7;

pub use clb097::SetRenderEnableOverride;
pub use clb097::SetRenderEnableOverrideMode;

pub use clb097::SetPrimitiveTopologyControl;
pub use clb097::SetPrimitiveTopologyControlOverride;

pub use clb097::SetWindowClipEnable;

pub use clb097::SetWindowClipType;
pub use clb097::SetWindowClipTypeV;

pub use clb097::InvalidateZcull;
pub use clb097::InvalidateZcullV;

pub use clb097::SetZcull;

pub use clb097::SetZcullBounds;

pub use clb097::SetPrimitiveTopology;
pub use clb097::SetPrimitiveTopologyV;

pub use clb097::ZcullSync;

pub use clb097::SetClipIdTest;

pub use clb097::SetSurfaceClipIdWidth;

pub use clb097::SetClipId;

pub use clb097::SetDepthBoundsTest;

pub use clb097::SetBlendFloatOption;

pub use clb097::SetLogicOp;

pub use clb097::SetLogicOpFunc;
pub use clb097::SetLogicOpFuncV;

pub use clb097::SetZCompression;

pub use clb097::ClearSurface;

pub use clb097::ClearClipIdSurface;

pub use clb097::SetColorCompression;

pub use clb097::SetCtWrite;

pub use clb097::PipeNop;

pub use clb097::SetSpare00;

pub use clb097::SetSpare01;

pub use clb097::SetSpare02;

pub use clb097::SetSpare03;

pub use clb097::SetReportSemaphoreA;

pub use clb097::SetReportSemaphoreB;

pub use clb097::SetReportSemaphoreC;

pub use clb097::SetReportSemaphoreD;
pub use clb097::SetReportSemaphoreDAcquire;
pub use clb097::SetReportSemaphoreDComparison;
pub use clb097::SetReportSemaphoreDOperation;
pub use clb097::SetReportSemaphoreDPipelineLocation;
pub use clb097::SetReportSemaphoreDReductionFormat;
pub use clb097::SetReportSemaphoreDReductionOp;
pub use clb097::SetReportSemaphoreDRelease;
pub use clb097::SetReportSemaphoreDReport;
pub use clb097::SetReportSemaphoreDStructureSize;

pub use clb097::SetVertexStreamAFormat;

pub use clb097::SetVertexStreamALocationA;

pub use clb097::SetVertexStreamALocationB;

pub use clb097::SetVertexStreamAFrequency;

pub use clb097::SetVertexStreamBFormat;

pub use clb097::SetVertexStreamBLocationA;

pub use clb097::SetVertexStreamBLocationB;

pub use clb097::SetVertexStreamBFrequency;

pub use clb097::SetBlendPerTargetSeparateForAlpha;

pub use clb097::SetBlendPerTargetColorOp;
pub use clb097::SetBlendPerTargetColorOpV;

pub use clb097::SetBlendPerTargetColorSourceCoeff;
pub use clb097::SetBlendPerTargetColorSourceCoeffV;

pub use clb097::SetBlendPerTargetColorDestCoeff;
pub use clb097::SetBlendPerTargetColorDestCoeffV;

pub use clb097::SetBlendPerTargetAlphaOp;
pub use clb097::SetBlendPerTargetAlphaOpV;

pub use clb097::SetBlendPerTargetAlphaSourceCoeff;
pub use clb097::SetBlendPerTargetAlphaSourceCoeffV;

pub use clb097::SetBlendPerTargetAlphaDestCoeff;
pub use clb097::SetBlendPerTargetAlphaDestCoeffV;

pub use clb097::SetVertexStreamLimitAA;

pub use clb097::SetVertexStreamLimitAB;

pub use clb097::SetVertexStreamLimitBA;

pub use clb097::SetVertexStreamLimitBB;

pub use clb097::SetPipelineShader;
pub use clb097::SetPipelineShaderType;

pub use clb097::SetPipelineProgram;

pub use clb097::SetPipelineReservedA;

pub use clb097::SetPipelineRegisterCount;

pub use clb097::SetPipelineBinding;

pub use clb097::SetPipelineReservedB;

pub use clb097::SetPipelineReservedC;

pub use clb097::SetPipelineReservedD;

pub use clb097::SetPipelineReservedE;

pub use clb097::SetFalcon00;

pub use clb097::SetFalcon01;

pub use clb097::SetFalcon02;

pub use clb097::SetFalcon03;

pub use clb097::SetFalcon04;

pub use clb097::SetFalcon05;

pub use clb097::SetFalcon06;

pub use clb097::SetFalcon07;

pub use clb097::SetFalcon08;

pub use clb097::SetFalcon09;

pub use clb097::SetFalcon10;

pub use clb097::SetFalcon11;

pub use clb097::SetFalcon12;

pub use clb097::SetFalcon13;

pub use clb097::SetFalcon14;

pub use clb097::SetFalcon15;

pub use clb097::SetFalcon16;

pub use clb097::SetFalcon17;

pub use clb097::SetFalcon18;

pub use clb097::SetFalcon19;

pub use clb097::SetFalcon20;

pub use clb097::SetFalcon21;

pub use clb097::SetFalcon22;

pub use clb097::SetFalcon23;

pub use clb097::SetFalcon24;

pub use clb097::SetFalcon25;

pub use clb097::SetFalcon26;

pub use clb097::SetFalcon27;

pub use clb097::SetFalcon28;

pub use clb097::SetFalcon29;

pub use clb097::SetFalcon30;

pub use clb097::SetFalcon31;

pub use clb097::SetConstantBufferSelectorA;

pub use clb097::SetConstantBufferSelectorB;

pub use clb097::SetConstantBufferSelectorC;

pub use clb097::LoadConstantBufferOffset;

pub use clb097::LoadConstantBuffer;

pub use clb097::BindGroupReservedA;

pub use clb097::BindGroupReservedB;

pub use clb097::BindGroupReservedC;

pub use clb097::BindGroupReservedD;

pub use clb097::BindGroupConstantBuffer;

pub use clb097::SetColorClamp;

pub use clb097::SetBindlessTexture;

pub use clb097::SetTrapHandler;

pub use clb097::SetShaderPerformanceCounterValueUpper;

pub use clb097::SetShaderPerformanceCounterValue;

pub use clb097::SetShaderPerformanceCounterEvent;

pub use clb097::SetShaderPerformanceCounterControlA;

pub use clb097::SetShaderPerformanceCounterControlB;

pub use clb097::SetShaderPerformanceCounterTrapControl;

pub use clb097::StartShaderPerformanceCounter;

pub use clb097::StopShaderPerformanceCounter;

pub use clb097::SetMmeShadowScratch;

pub use clb097::CallMmeMacro;

pub use clb097::CallMmeData;
