use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::cl90c0::mthd as cl90c0;

// parsed class NVB0C0

pub use cl90c0::SetObject;

pub use cl90c0::NoOperation;

pub use cl90c0::SetNotifyA;

pub use cl90c0::SetNotifyB;

pub use cl90c0::Notify;
pub use cl90c0::NotifyType;

pub use cl90c0::WaitForIdle;

pub use cl90c0::SetGlobalRenderEnableA;

pub use cl90c0::SetGlobalRenderEnableB;

pub use cl90c0::SetGlobalRenderEnableC;
pub use cl90c0::SetGlobalRenderEnableCMode;

pub use cl90c0::SendGoIdle;

pub use cl90c0::PmTrigger;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cl90c0::SetInstrumentationMethodHeader;

pub use cl90c0::SetInstrumentationMethodData;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;

        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;

        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;

        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;

        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaA {
    pub address_upper: u32,
}

impl Mthd for SetValidSpanOverflowAreaA {
    const ADDR: u16 = 0x0200;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaB {
    pub address_lower: u32,
}

impl Mthd for SetValidSpanOverflowAreaB {
    const ADDR: u16 = 0x0204;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetValidSpanOverflowAreaC {
    pub size: u32,
}

impl Mthd for SetValidSpanOverflowAreaC {
    const ADDR: u16 = 0x0208;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCoalesceWaitingPeriodUnit {
    pub clocks: u32,
}

impl Mthd for SetCoalesceWaitingPeriodUnit {
    const ADDR: u16 = 0x020c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.clocks;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PerfmonTransfer {
    pub v: u32,
}

impl Mthd for PerfmonTransfer {
    const ADDR: u16 = 0x0210;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cl90c0::SetShaderSharedMemoryWindow;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSelectMaxwellTextureHeaders {
    pub v: bool,
}

impl Mthd for SetSelectMaxwellTextureHeaders {
    const ADDR: u16 = 0x0218;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;

        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod00 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod00 {
    const ADDR: u16 = 0x0220;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod01 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod01 {
    const ADDR: u16 = 0x0224;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod02 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod02 {
    const ADDR: u16 = 0x0228;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod03 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod03 {
    const ADDR: u16 = 0x022c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod04 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod04 {
    const ADDR: u16 = 0x0230;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod05 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod05 {
    const ADDR: u16 = 0x0234;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod06 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod06 {
    const ADDR: u16 = 0x0238;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod07 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod07 {
    const ADDR: u16 = 0x023c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetCwdControlSmSelection {
    LoadBalanced = 0x00000000,
    RoundRobin = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCwdControl {
    pub sm_selection: SetCwdControlSmSelection,
}

impl Mthd for SetCwdControl {
    const ADDR: u16 = 0x0240;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.sm_selection as u32) < (1 << 1));
        val |= (self.sm_selection as u32) << 0;

        val
    }
}

pub use cl90c0::InvalidateTextureHeaderCacheNoWfi;
pub use cl90c0::InvalidateTextureHeaderCacheNoWfiLines;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCwdRefCounter {
    pub select: u32,
    pub value: u32,
}

impl Mthd for SetCwdRefCounter {
    const ADDR: u16 = 0x0248;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.select < (1 << 6));
        val |= self.select << 0;

        assert!(self.value < (1 << 16));
        val |= self.value << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod08 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod08 {
    const ADDR: u16 = 0x024c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod09 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod09 {
    const ADDR: u16 = 0x0250;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod10 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod10 {
    const ADDR: u16 = 0x0254;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod11 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod11 {
    const ADDR: u16 = 0x0258;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod12 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod12 {
    const ADDR: u16 = 0x025c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod13 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod13 {
    const ADDR: u16 = 0x0260;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod14 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod14 {
    const ADDR: u16 = 0x0264;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod15 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod15 {
    const ADDR: u16 = 0x0268;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCacheA {
    pub address_upper: u32,
}

impl Mthd for InvalidateConstantBufferCacheA {
    const ADDR: u16 = 0x0274;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.address_upper < (1 << 8));
        val |= self.address_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCacheB {
    pub address_lower: u32,
}

impl Mthd for InvalidateConstantBufferCacheB {
    const ADDR: u16 = 0x0278;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.address_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateConstantBufferCacheC {
    pub byte_count: u32,
    pub thru_l2: bool,
}

impl Mthd for InvalidateConstantBufferCacheC {
    const ADDR: u16 = 0x027c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.byte_count < (1 << 17));
        val |= self.byte_count << 0;

        assert!((self.thru_l2 as u32) < (1 << 1));
        val |= (self.thru_l2 as u32) << 31;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetComputeClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetComputeClassVersion {
    const ADDR: u16 = 0x0280;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckComputeClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckComputeClassVersion {
    const ADDR: u16 = 0x0284;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetQmdVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetQmdVersion {
    const ADDR: u16 = 0x0288;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckQmdVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckQmdVersion {
    const ADDR: u16 = 0x0290;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCwdSlotCount {
    pub v: u32,
}

impl Mthd for SetCwdSlotCount {
    const ADDR: u16 = 0x02b0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendPcasA {
    pub qmd_address_shifted8: u32,
}

impl Mthd for SendPcasA {
    const ADDR: u16 = 0x02b4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.qmd_address_shifted8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendPcasB {
    pub from: u32,
    pub delta: u32,
}

impl Mthd for SendPcasB {
    const ADDR: u16 = 0x02b8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.from < (1 << 24));
        val |= self.from << 0;

        assert!(self.delta < (1 << 8));
        val |= self.delta << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SendSignalingPcasB {
    pub invalidate: bool,
    pub schedule: bool,
}

impl Mthd for SendSignalingPcasB {
    const ADDR: u16 = 0x02bc;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.invalidate as u32) < (1 << 1));
        val |= (self.invalidate as u32) << 0;

        assert!((self.schedule as u32) < (1 << 1));
        val |= (self.schedule as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledA {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledA {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_upper < (1 << 8));
        val |= self.size_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledB {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledB {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryNonThrottledC {
    pub max_sm_count: u32,
}

impl Mthd for SetShaderLocalMemoryNonThrottledC {
    const ADDR: u16 = 0x02ec;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.max_sm_count < (1 << 9));
        val |= self.max_sm_count << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryThrottledA {
    pub size_upper: u32,
}

impl Mthd for SetShaderLocalMemoryThrottledA {
    const ADDR: u16 = 0x02f0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.size_upper < (1 << 8));
        val |= self.size_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryThrottledB {
    pub size_lower: u32,
}

impl Mthd for SetShaderLocalMemoryThrottledB {
    const ADDR: u16 = 0x02f4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.size_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderLocalMemoryThrottledC {
    pub max_sm_count: u32,
}

impl Mthd for SetShaderLocalMemoryThrottledC {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.max_sm_count < (1 << 9));
        val |= self.max_sm_count << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpaVersion {
    pub minor: u32,
    pub major: u32,
}

impl Mthd for SetSpaVersion {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.minor < (1 << 8));
        val |= self.minor << 0;

        assert!(self.major < (1 << 8));
        val |= self.major << 8;

        val
    }
}

pub use cl90c0::SetFalcon00;

pub use cl90c0::SetFalcon01;

pub use cl90c0::SetFalcon02;

pub use cl90c0::SetFalcon03;

pub use cl90c0::SetFalcon04;

pub use cl90c0::SetFalcon05;

pub use cl90c0::SetFalcon06;

pub use cl90c0::SetFalcon07;

pub use cl90c0::SetFalcon08;

pub use cl90c0::SetFalcon09;

pub use cl90c0::SetFalcon10;

pub use cl90c0::SetFalcon11;

pub use cl90c0::SetFalcon12;

pub use cl90c0::SetFalcon13;

pub use cl90c0::SetFalcon14;

pub use cl90c0::SetFalcon15;

pub use cl90c0::SetFalcon16;

pub use cl90c0::SetFalcon17;

pub use cl90c0::SetFalcon18;

pub use cl90c0::SetFalcon19;

pub use cl90c0::SetFalcon20;

pub use cl90c0::SetFalcon21;

pub use cl90c0::SetFalcon22;

pub use cl90c0::SetFalcon23;

pub use cl90c0::SetFalcon24;

pub use cl90c0::SetFalcon25;

pub use cl90c0::SetFalcon26;

pub use cl90c0::SetFalcon27;

pub use cl90c0::SetFalcon28;

pub use cl90c0::SetFalcon29;

pub use cl90c0::SetFalcon30;

pub use cl90c0::SetFalcon31;

pub use cl90c0::SetShaderLocalMemoryWindow;

pub use cl90c0::SetShaderLocalMemoryA;

pub use cl90c0::SetShaderLocalMemoryB;

pub use cl90c0::SetShaderCacheControl;

pub use cl90c0::SetSmTimeoutInterval;

pub use cl90c0::SetSpareNoop12;

pub use cl90c0::SetSpareNoop13;

pub use cl90c0::SetSpareNoop14;

pub use cl90c0::SetSpareNoop15;

pub use cl90c0::SetSpareNoop00;

pub use cl90c0::SetSpareNoop01;

pub use cl90c0::SetSpareNoop02;

pub use cl90c0::SetSpareNoop03;

pub use cl90c0::SetSpareNoop04;

pub use cl90c0::SetSpareNoop05;

pub use cl90c0::SetSpareNoop06;

pub use cl90c0::SetSpareNoop07;

pub use cl90c0::SetSpareNoop08;

pub use cl90c0::SetSpareNoop09;

pub use cl90c0::SetSpareNoop10;

pub use cl90c0::SetSpareNoop11;

pub use cl90c0::InvalidateTextureDataCacheNoWfi;
pub use cl90c0::InvalidateTextureDataCacheNoWfiLines;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ActivatePerfSettingsForComputeContext {
    pub all: bool,
}

impl Mthd for ActivatePerfSettingsForComputeContext {
    const ADDR: u16 = 0x12a8;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.all as u32) < (1 << 1));
        val |= (self.all as u32) << 0;

        val
    }
}

pub use cl90c0::InvalidateSamplerCache;
pub use cl90c0::InvalidateSamplerCacheLines;

pub use cl90c0::InvalidateTextureHeaderCache;
pub use cl90c0::InvalidateTextureHeaderCacheLines;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

pub use cl90c0::InvalidateSamplerCacheNoWfi;
pub use cl90c0::InvalidateSamplerCacheNoWfiLines;

pub use cl90c0::SetShaderExceptions;

pub use cl90c0::SetRenderEnableA;

pub use cl90c0::SetRenderEnableB;

pub use cl90c0::SetRenderEnableC;
pub use cl90c0::SetRenderEnableCMode;

pub use cl90c0::SetTexSamplerPoolA;

pub use cl90c0::SetTexSamplerPoolB;

pub use cl90c0::SetTexSamplerPoolC;

pub use cl90c0::SetTexHeaderPoolA;

pub use cl90c0::SetTexHeaderPoolB;

pub use cl90c0::SetTexHeaderPoolC;

pub use cl90c0::SetProgramRegionA;

pub use cl90c0::SetProgramRegionB;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x1698;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}

pub use cl90c0::SetRenderEnableOverride;
pub use cl90c0::SetRenderEnableOverrideMode;

pub use cl90c0::PipeNop;

pub use cl90c0::SetSpare00;

pub use cl90c0::SetSpare01;

pub use cl90c0::SetSpare02;

pub use cl90c0::SetSpare03;

pub use cl90c0::SetReportSemaphoreA;

pub use cl90c0::SetReportSemaphoreB;

pub use cl90c0::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub awaken_enable: bool,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindlessTexture {
    pub constant_buffer_slot_select: u32,
}

impl Mthd for SetBindlessTexture {
    const ADDR: u16 = 0x2608;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.constant_buffer_slot_select < (1 << 3));
        val |= self.constant_buffer_slot_select << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandler {
    pub offset: u32,
}

impl Mthd for SetTrapHandler {
    const ADDR: u16 = 0x260c;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValueUpper {
    const CLASS: u16 = 0xb0c0;

    fn addr(i: usize) -> u16 {
        (0x333c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cl90c0::SetShaderPerformanceCounterValue;

pub use cl90c0::SetShaderPerformanceCounterEvent;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
    pub event4: u32,
    pub bit_select4: u32,
    pub event5: u32,
    pub bit_select5: u32,
    pub spare: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0xb0c0;

    fn addr(i: usize) -> u16 {
        (0x339c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event0 < (1 << 2));
        val |= self.event0 << 0;

        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 2;

        assert!(self.event1 < (1 << 2));
        val |= self.event1 << 5;

        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 7;

        assert!(self.event2 < (1 << 2));
        val |= self.event2 << 10;

        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 12;

        assert!(self.event3 < (1 << 2));
        val |= self.event3 << 15;

        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 17;

        assert!(self.event4 < (1 << 2));
        val |= self.event4 << 20;

        assert!(self.bit_select4 < (1 << 3));
        val |= self.bit_select4 << 22;

        assert!(self.event5 < (1 << 2));
        val |= self.event5 << 25;

        assert!(self.bit_select5 < (1 << 3));
        val |= self.bit_select5 << 27;

        assert!(self.spare < (1 << 2));
        val |= self.spare << 30;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub mode: u32,
    pub windowed: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0xb0c0;

    fn addr(i: usize) -> u16 {
        (0x33bc + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;

        assert!(self.mode < (1 << 2));
        val |= self.mode << 1;

        assert!(self.windowed < (1 << 1));
        val |= self.windowed << 3;

        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}

pub use cl90c0::SetShaderPerformanceCounterTrapControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StartShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StartShaderPerformanceCounter {
    const ADDR: u16 = 0x33e0;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StopShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StopShaderPerformanceCounter {
    const ADDR: u16 = 0x33e4;
    const CLASS: u16 = 0xb0c0;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

pub use cl90c0::SetMmeShadowScratch;
