use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::cla297::mthd as cla297;

// parsed class NVB097

pub use cla297::SetObject;

pub use cla297::NoOperation;

pub use cla297::SetNotifyA;

pub use cla297::SetNotifyB;

pub use cla297::Notify;
pub use cla297::NotifyType;

pub use cla297::WaitForIdle;

pub use cla297::LoadMmeInstructionRamPointer;

pub use cla297::LoadMmeInstructionRam;

pub use cla297::LoadMmeStartAddressRamPointer;

pub use cla297::LoadMmeStartAddressRam;

pub use cla297::SetMmeShadowRamControl;
pub use cla297::SetMmeShadowRamControlMode;

pub use cla297::PeerSemaphoreReleaseOffsetUpper;

pub use cla297::PeerSemaphoreReleaseOffset;

pub use cla297::SetGlobalRenderEnableA;

pub use cla297::SetGlobalRenderEnableB;

pub use cla297::SetGlobalRenderEnableC;
pub use cla297::SetGlobalRenderEnableCMode;

pub use cla297::SendGoIdle;

pub use cla297::PmTrigger;

pub use cla297::PmTriggerWfi;

pub use cla297::SetInstrumentationMethodHeader;

pub use cla297::SetInstrumentationMethodData;

pub use cla297::LineLengthIn;

pub use cla297::LineCount;

pub use cla297::OffsetOutUpper;

pub use cla297::OffsetOut;

pub use cla297::PitchOut;

pub use cla297::SetDstBlockSize;
pub use cla297::SetDstBlockSizeDepth;
pub use cla297::SetDstBlockSizeHeight;
pub use cla297::SetDstBlockSizeWidth;

pub use cla297::SetDstWidth;

pub use cla297::SetDstHeight;

pub use cla297::SetDstDepth;

pub use cla297::SetDstLayer;

pub use cla297::SetDstOriginBytesX;

pub use cla297::SetDstOriginSamplesY;

pub use cla297::LaunchDma;
pub use cla297::LaunchDmaCompletionType;
pub use cla297::LaunchDmaDstMemoryLayout;
pub use cla297::LaunchDmaInterruptType;
pub use cla297::LaunchDmaReductionFormat;
pub use cla297::LaunchDmaReductionOp;
pub use cla297::LaunchDmaSemaphoreStructSize;

pub use cla297::LoadInlineData;

pub use cla297::SetI2MSemaphoreA;

pub use cla297::SetI2MSemaphoreB;

pub use cla297::SetI2MSemaphoreC;

pub use cla297::SetI2MSpareNoop00;

pub use cla297::SetI2MSpareNoop01;

pub use cla297::SetI2MSpareNoop02;

pub use cla297::SetI2MSpareNoop03;

pub use cla297::RunDsNow;

pub use cla297::SetOpportunisticEarlyZHysteresis;
pub use cla297::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use cla297::SetAliasedLineWidthEnable;

pub use cla297::SetApiMandatedEarlyZ;

pub use cla297::SetGsDmFifo;

pub use cla297::SetL2CacheControlForRopPrefetchReadRequests;
pub use cla297::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use cla297::InvalidateShaderCaches;

pub use cla297::IncrementSyncPoint;
pub use cla297::IncrementSyncPointCondition;

pub use cla297::SetPrimCircularBufferThrottle;

pub use cla297::FlushAndInvalidateRopMiniCache;

pub use cla297::SetSurfaceClipIdBlockSize;
pub use cla297::SetSurfaceClipIdBlockSizeDepth;
pub use cla297::SetSurfaceClipIdBlockSizeHeight;
pub use cla297::SetSurfaceClipIdBlockSizeWidth;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetAlphaCircularBufferSize {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 14));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

pub use cla297::DecompressSurface;

pub use cla297::SetZcullRopBypass;

pub use cla297::SetZcullSubregion;

pub use cla297::SetRasterBoundingBox;
pub use cla297::SetRasterBoundingBoxMode;

pub use cla297::PeerSemaphoreRelease;

pub use cla297::SetIteratedBlendOptimization;
pub use cla297::SetIteratedBlendOptimizationNoop;

pub use cla297::SetZcullSubregionAllocation;
pub use cla297::SetZcullSubregionAllocationFormat;

pub use cla297::AssignZcullSubregions;
pub use cla297::AssignZcullSubregionsAlgorithm;

pub use cla297::SetPsOutputSampleMaskUsage;
pub use cla297::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use cla297::DrawZeroIndex;

pub use cla297::SetL1Configuration;
pub use cla297::SetL1ConfigurationDirectlyAddressableMemory;

pub use cla297::SetRenderEnableControl;

pub use cla297::SetSpaVersion;

pub use cla297::SetIeeeCleanUpdate;

pub use cla297::SetSnapGridLine;
pub use cla297::SetSnapGridLineLocationsPerPixel;
pub use cla297::SetSnapGridLineRoundingMode;

pub use cla297::SetSnapGridNonLine;
pub use cla297::SetSnapGridNonLineLocationsPerPixel;
pub use cla297::SetSnapGridNonLineRoundingMode;

pub use cla297::SetTessellationParameters;
pub use cla297::SetTessellationParametersDomainType;
pub use cla297::SetTessellationParametersOutputPrimitives;
pub use cla297::SetTessellationParametersSpacing;

pub use cla297::SetTessellationLodU0OrDensity;

pub use cla297::SetTessellationLodV0OrDetail;

pub use cla297::SetTessellationLodU1OrW0;

pub use cla297::SetTessellationLodV1;

pub use cla297::SetTgLodInteriorU;

pub use cla297::SetTgLodInteriorV;

pub use cla297::ReservedTg07;

pub use cla297::ReservedTg08;

pub use cla297::ReservedTg09;

pub use cla297::ReservedTg10;

pub use cla297::ReservedTg11;

pub use cla297::ReservedTg12;

pub use cla297::ReservedTg13;

pub use cla297::ReservedTg14;

pub use cla297::ReservedTg15;

pub use cla297::SetSubtilingPerfKnobA;

pub use cla297::SetSubtilingPerfKnobB;

pub use cla297::SetSubtilingPerfKnobC;

pub use cla297::SetZcullSubregionToReport;

pub use cla297::SetZcullSubregionReportType;
pub use cla297::SetZcullSubregionReportTypeType;

pub use cla297::SetBalancedPrimitiveWorkload;

pub use cla297::SetMaxPatchesPerBatch;

pub use cla297::SetRasterEnable;

pub use cla297::SetStreamOutBufferEnable;

pub use cla297::SetStreamOutBufferAddressA;

pub use cla297::SetStreamOutBufferAddressB;

pub use cla297::SetStreamOutBufferSize;

pub use cla297::SetStreamOutBufferLoadWritePointer;

pub use cla297::SetStreamOutControlStream;

pub use cla297::SetStreamOutControlComponentCount;

pub use cla297::SetStreamOutControlStride;

pub use cla297::SetRasterInput;

pub use cla297::SetStreamOutput;

pub use cla297::SetDaPrimitiveRestartTopologyChange;

pub use cla297::SetAlphaFraction;

pub use cla297::SetHybridAntiAliasControl;
pub use cla297::SetHybridAntiAliasControlCentroid;

pub use cla297::SetShaderLocalMemoryWindow;

pub use cla297::SetShaderLocalMemoryA;

pub use cla297::SetShaderLocalMemoryB;

pub use cla297::SetShaderLocalMemoryC;

pub use cla297::SetShaderLocalMemoryD;

pub use cla297::SetShaderLocalMemoryE;

pub use cla297::SetColorZeroBandwidthClear;

pub use cla297::SetZZeroBandwidthClear;

pub use cla297::SetIsbeSaveRestoreProgram;

pub use cla297::SetZcullRegionSizeA;

pub use cla297::SetZcullRegionSizeB;

pub use cla297::SetZcullRegionSizeC;

pub use cla297::SetZcullRegionPixelOffsetC;

pub use cla297::SetCullBeforeFetch;

pub use cla297::SetZcullRegionLocation;

pub use cla297::SetZcullRegionAliquots;

pub use cla297::SetZcullStorageA;

pub use cla297::SetZcullStorageB;

pub use cla297::SetZcullStorageC;

pub use cla297::SetZcullStorageD;

pub use cla297::SetZtReadOnly;

pub use cla297::SetColorTargetA;

pub use cla297::SetColorTargetB;

pub use cla297::SetColorTargetWidth;

pub use cla297::SetColorTargetHeight;

pub use cla297::SetColorTargetFormat;
pub use cla297::SetColorTargetFormatV;

pub use cla297::SetColorTargetMemory;
pub use cla297::SetColorTargetMemoryBlockDepth;
pub use cla297::SetColorTargetMemoryBlockHeight;
pub use cla297::SetColorTargetMemoryBlockWidth;
pub use cla297::SetColorTargetMemoryLayout;
pub use cla297::SetColorTargetMemoryThirdDimensionControl;

pub use cla297::SetColorTargetThirdDimension;

pub use cla297::SetColorTargetArrayPitch;

pub use cla297::SetColorTargetLayer;

pub use cla297::SetColorTargetMark;

pub use cla297::SetViewportScaleX;

pub use cla297::SetViewportScaleY;

pub use cla297::SetViewportScaleZ;

pub use cla297::SetViewportOffsetX;

pub use cla297::SetViewportOffsetY;

pub use cla297::SetViewportOffsetZ;

pub use cla297::SetViewportClipHorizontal;

pub use cla297::SetViewportClipVertical;

pub use cla297::SetViewportClipMinZ;

pub use cla297::SetViewportClipMaxZ;

pub use cla297::SetWindowClipHorizontal;

pub use cla297::SetWindowClipVertical;

pub use cla297::SetClipIdExtentX;

pub use cla297::SetClipIdExtentY;

pub use cla297::SetMaxStreamOutputGsInstancesPerTask;

pub use cla297::SetApiVisibleCallLimit;
pub use cla297::SetApiVisibleCallLimitV;

pub use cla297::SetStatisticsCounter;

pub use cla297::SetClearRectHorizontal;

pub use cla297::SetClearRectVertical;

pub use cla297::SetVertexArrayStart;

pub use cla297::DrawVertexArray;

pub use cla297::SetViewportZClip;
pub use cla297::SetViewportZClipRange;

pub use cla297::SetColorClearValue;

pub use cla297::SetZClearValue;

pub use cla297::SetShaderCacheControl;

pub use cla297::ForceTransitionToBeta;

pub use cla297::SetReduceColorThresholdsEnable;

pub use cla297::SetStencilClearValue;

pub use cla297::InvalidateShaderCachesNoWfi;

pub use cla297::SetZcullSerialization;
pub use cla297::SetZcullSerializationApplied;

pub use cla297::SetFrontPolygonMode;
pub use cla297::SetFrontPolygonModeV;

pub use cla297::SetBackPolygonMode;
pub use cla297::SetBackPolygonModeV;

pub use cla297::SetPolySmooth;

pub use cla297::SetZtMark;

pub use cla297::SetZcullDirFormat;
pub use cla297::SetZcullDirFormatZdir;
pub use cla297::SetZcullDirFormatZformat;

pub use cla297::SetPolyOffsetPoint;

pub use cla297::SetPolyOffsetLine;

pub use cla297::SetPolyOffsetFill;

pub use cla297::SetPatch;

pub use cla297::SetIteratedBlend;

pub use cla297::SetIteratedBlendPass;

pub use cla297::SetZcullCriterion;
pub use cla297::SetZcullCriterionSfunc;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PixelShaderBarrier {
    pub sysmembar_enable: bool,
}

impl Mthd for PixelShaderBarrier {
    const ADDR: u16 = 0x0de0;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.sysmembar_enable as u32) < (1 << 1));
        val |= (self.sysmembar_enable as u32) << 0;

        val
    }
}

pub use cla297::SetSmTimeoutInterval;

pub use cla297::SetDaPrimitiveRestartVertexArray;

pub use cla297::LoadIteratedBlendInstructionPointer;

pub use cla297::LoadIteratedBlendInstruction;
pub use cla297::LoadIteratedBlendInstructionConstantInputSelect;
pub use cla297::LoadIteratedBlendInstructionOperandASelect;
pub use cla297::LoadIteratedBlendInstructionOperandBSelect;
pub use cla297::LoadIteratedBlendInstructionOperandCSelect;
pub use cla297::LoadIteratedBlendInstructionOperandDSelect;
pub use cla297::LoadIteratedBlendInstructionOperation;
pub use cla297::LoadIteratedBlendInstructionOutputSwizzle;
pub use cla297::LoadIteratedBlendInstructionOutputWriteMask;
pub use cla297::LoadIteratedBlendInstructionPassOutput;
pub use cla297::LoadIteratedBlendInstructionTestCc;

pub use cla297::SetWindowOffsetX;

pub use cla297::SetWindowOffsetY;

pub use cla297::SetScissorEnable;

pub use cla297::SetScissorHorizontal;

pub use cla297::SetScissorVertical;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSelectMaxwellTextureHeaders {
    pub v: bool,
}

impl Mthd for SetSelectMaxwellTextureHeaders {
    const ADDR: u16 = 0x0f10;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 1));
        val |= (self.v as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetVpcPerfKnob {
    pub culled_small_lines: u32,
    pub culled_small_triangles: u32,
    pub nonculled_lines_and_points: u32,
    pub nonculled_triangles: u32,
}

impl Mthd for SetVpcPerfKnob {
    const ADDR: u16 = 0x0f14;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.culled_small_lines < (1 << 8));
        val |= self.culled_small_lines << 0;

        assert!(self.culled_small_triangles < (1 << 8));
        val |= self.culled_small_triangles << 8;

        assert!(self.nonculled_lines_and_points < (1 << 8));
        val |= self.nonculled_lines_and_points << 16;

        assert!(self.nonculled_triangles < (1 << 8));
        val |= self.nonculled_triangles << 24;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmLocalTrigger {
    pub bookmark: u32,
}

impl Mthd for PmLocalTrigger {
    const ADDR: u16 = 0x0f18;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.bookmark < (1 << 16));
        val |= self.bookmark << 0;

        val
    }
}

pub use cla297::SetConstantColorRendering;

pub use cla297::SetConstantColorRenderingRed;

pub use cla297::SetConstantColorRenderingGreen;

pub use cla297::SetConstantColorRenderingBlue;

pub use cla297::SetConstantColorRenderingAlpha;

pub use cla297::SetBackStencilFuncRef;

pub use cla297::SetBackStencilMask;

pub use cla297::SetBackStencilFuncMask;

pub use cla297::SetVertexStreamSubstituteA;

pub use cla297::SetVertexStreamSubstituteB;

pub use cla297::SetLineModePolygonClip;
pub use cla297::SetLineModePolygonClipGeneratedEdge;

pub use cla297::SetSingleCtWriteControl;

pub use cla297::SetVtgWarpWatermarks;

pub use cla297::SetDepthBoundsMin;

pub use cla297::SetDepthBoundsMax;

pub use cla297::SetCtMrtEnable;

pub use cla297::SetNonmultisampledZ;
pub use cla297::SetNonmultisampledZV;

pub use cla297::SetSampleMaskX0Y0;

pub use cla297::SetSampleMaskX1Y0;

pub use cla297::SetSampleMaskX0Y1;

pub use cla297::SetSampleMaskX1Y1;

pub use cla297::SetSurfaceClipIdMemoryA;

pub use cla297::SetSurfaceClipIdMemoryB;

pub use cla297::SetBlendOptControl;

pub use cla297::SetZtA;

pub use cla297::SetZtB;

pub use cla297::SetZtFormat;
pub use cla297::SetZtFormatV;

pub use cla297::SetZtBlockSize;
pub use cla297::SetZtBlockSizeDepth;
pub use cla297::SetZtBlockSizeHeight;
pub use cla297::SetZtBlockSizeWidth;

pub use cla297::SetZtArrayPitch;

pub use cla297::SetSurfaceClipHorizontal;

pub use cla297::SetSurfaceClipVertical;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTiledCacheBundleControl {
    pub treat_heavyweight_as_lightweight: bool,
}

impl Mthd for SetTiledCacheBundleControl {
    const ADDR: u16 = 0x0ffc;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.treat_heavyweight_as_lightweight as u32) < (1 << 1));
        val |= (self.treat_heavyweight_as_lightweight as u32) << 0;

        val
    }
}

pub use cla297::SetL2CacheControlForVafRequests;
pub use cla297::SetL2CacheControlForVafRequestsPolicy;

pub use cla297::SetTessellationCutHeight;

pub use cla297::SetMaxGsInstancesPerTask;

pub use cla297::SetMaxGsOutputVerticesPerTask;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod00 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod00 {
    const ADDR: u16 = 0x1014;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::SetGsOutputCbStorageMultiplier;

pub use cla297::SetBetaCbStorageConstraint;

pub use cla297::SetTiOutputCbStorageMultiplier;

pub use cla297::SetAlphaCbStorageConstraint;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod01 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod01 {
    const ADDR: u16 = 0x1028;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod02 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod02 {
    const ADDR: u16 = 0x102c;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::SetSpareNoop01;

pub use cla297::SetSpareNoop02;

pub use cla297::SetSpareNoop03;

pub use cla297::SetSpareNoop04;

pub use cla297::SetSpareNoop05;

pub use cla297::SetSpareNoop06;

pub use cla297::SetSpareNoop07;

pub use cla297::SetSpareNoop08;

pub use cla297::SetSpareNoop09;

pub use cla297::SetSpareNoop10;

pub use cla297::SetSpareNoop11;

pub use cla297::SetSpareNoop12;

pub use cla297::SetSpareNoop13;

pub use cla297::SetSpareNoop14;

pub use cla297::SetSpareNoop15;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod03 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod03 {
    const ADDR: u16 = 0x10b0;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod04 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod04 {
    const ADDR: u16 = 0x10b4;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod05 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod05 {
    const ADDR: u16 = 0x10b8;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod06 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod06 {
    const ADDR: u16 = 0x10bc;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod07 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod07 {
    const ADDR: u16 = 0x10c0;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod08 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod08 {
    const ADDR: u16 = 0x10c4;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod09 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod09 {
    const ADDR: u16 = 0x10c8;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::SetReduceColorThresholdsUnorm8;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod10 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod10 {
    const ADDR: u16 = 0x10d0;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod11 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod11 {
    const ADDR: u16 = 0x10d4;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod12 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod12 {
    const ADDR: u16 = 0x10d8;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod13 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod13 {
    const ADDR: u16 = 0x10dc;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::SetReduceColorThresholdsUnorm10;

pub use cla297::SetReduceColorThresholdsUnorm16;

pub use cla297::SetReduceColorThresholdsFp11;

pub use cla297::SetReduceColorThresholdsFp16;

pub use cla297::SetReduceColorThresholdsSrgb8;

pub use cla297::UnbindAll;

pub use cla297::SetClearSurfaceControl;

pub use cla297::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use cla297::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod14 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod14 {
    const ADDR: u16 = 0x1100;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReservedSwMethod15 {
    pub v: u32,
}

impl Mthd for SetReservedSwMethod15 {
    const ADDR: u16 = 0x1104;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::NoOperationDataHi;

pub use cla297::SetDepthBiasControl;

pub use cla297::PmTriggerEnd;

pub use cla297::SetVertexIdBase;

pub use cla297::SetDaOutputAttributeSkipMaskA;

pub use cla297::SetDaOutputAttributeSkipMaskB;

pub use cla297::SetBlendPerFormatEnable;

pub use cla297::FlushPendingWrites;

pub use cla297::SetVertexAttributeA;
pub use cla297::SetVertexAttributeAComponentBitWidths;
pub use cla297::SetVertexAttributeANumericalType;
pub use cla297::SetVertexAttributeASource;

pub use cla297::SetVertexAttributeB;
pub use cla297::SetVertexAttributeBComponentBitWidths;
pub use cla297::SetVertexAttributeBNumericalType;
pub use cla297::SetVertexAttributeBSource;

pub use cla297::DrawVertexArrayBeginEndInstanceFirst;
pub use cla297::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use cla297::DrawVertexArrayBeginEndInstanceSubsequent;
pub use cla297::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use cla297::SetCtSelect;

pub use cla297::SetCompressionThreshold;
pub use cla297::SetCompressionThresholdSamples;

pub use cla297::SetZtSizeA;

pub use cla297::SetZtSizeB;

pub use cla297::SetZtSizeC;
pub use cla297::SetZtSizeCControl;

pub use cla297::SetSamplerBinding;
pub use cla297::SetSamplerBindingV;

pub use cla297::DrawAuto;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetCircularBufferSize {
    const ADDR: u16 = 0x1280;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 14));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

pub use cla297::SetVtgRegisterWatermarks;

pub use cla297::InvalidateTextureDataCacheNoWfi;
pub use cla297::InvalidateTextureDataCacheNoWfiLines;

pub use cla297::SetL2CacheControlForRopInterlockedReadRequests;
pub use cla297::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use cla297::SetDaPrimitiveRestartIndexTopologyChange;

pub use cla297::ClearZcullRegion;

pub use cla297::SetDepthTest;

pub use cla297::SetFillMode;
pub use cla297::SetFillModeV;

pub use cla297::SetShadeMode;
pub use cla297::SetShadeModeV;

pub use cla297::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use cla297::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use cla297::SetL2CacheControlForRopInterlockedWriteRequests;
pub use cla297::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use cla297::SetAlphaToCoverageDitherControl;
pub use cla297::SetAlphaToCoverageDitherControlDitherFootprint;

pub use cla297::SetBlendStatePerTarget;

pub use cla297::SetDepthWrite;

pub use cla297::SetAlphaTest;

pub use cla297::SetInlineIndex4X8Align;

pub use cla297::DrawInlineIndex4X8;

pub use cla297::D3DSetCullMode;
pub use cla297::D3DSetCullModeV;

pub use cla297::SetDepthFunc;
pub use cla297::SetDepthFuncV;

pub use cla297::SetAlphaRef;

pub use cla297::SetAlphaFunc;
pub use cla297::SetAlphaFuncV;

pub use cla297::SetDrawAutoStride;

pub use cla297::SetBlendConstRed;

pub use cla297::SetBlendConstGreen;

pub use cla297::SetBlendConstBlue;

pub use cla297::SetBlendConstAlpha;

pub use cla297::InvalidateSamplerCache;
pub use cla297::InvalidateSamplerCacheLines;

pub use cla297::InvalidateTextureHeaderCache;
pub use cla297::InvalidateTextureHeaderCacheLines;

pub use cla297::InvalidateTextureDataCache;
pub use cla297::InvalidateTextureDataCacheLines;

pub use cla297::SetBlendSeparateForAlpha;

pub use cla297::SetBlendColorOp;
pub use cla297::SetBlendColorOpV;

pub use cla297::SetBlendColorSourceCoeff;
pub use cla297::SetBlendColorSourceCoeffV;

pub use cla297::SetBlendColorDestCoeff;
pub use cla297::SetBlendColorDestCoeffV;

pub use cla297::SetBlendAlphaOp;
pub use cla297::SetBlendAlphaOpV;

pub use cla297::SetBlendAlphaSourceCoeff;
pub use cla297::SetBlendAlphaSourceCoeffV;

pub use cla297::SetGlobalColorKey;

pub use cla297::SetBlendAlphaDestCoeff;
pub use cla297::SetBlendAlphaDestCoeffV;

pub use cla297::SetSingleRopControl;

pub use cla297::SetBlend;

pub use cla297::SetStencilTest;

pub use cla297::SetStencilOpFail;
pub use cla297::SetStencilOpFailV;

pub use cla297::SetStencilOpZfail;
pub use cla297::SetStencilOpZfailV;

pub use cla297::SetStencilOpZpass;
pub use cla297::SetStencilOpZpassV;

pub use cla297::SetStencilFunc;
pub use cla297::SetStencilFuncV;

pub use cla297::SetStencilFuncRef;

pub use cla297::SetStencilFuncMask;

pub use cla297::SetStencilMask;

pub use cla297::SetDrawAutoStart;

pub use cla297::SetPsSaturate;
pub use cla297::SetPsSaturateClampRange0;
pub use cla297::SetPsSaturateClampRange1;
pub use cla297::SetPsSaturateClampRange2;
pub use cla297::SetPsSaturateClampRange3;
pub use cla297::SetPsSaturateClampRange4;
pub use cla297::SetPsSaturateClampRange5;
pub use cla297::SetPsSaturateClampRange6;
pub use cla297::SetPsSaturateClampRange7;

pub use cla297::SetWindowOrigin;
pub use cla297::SetWindowOriginMode;

pub use cla297::SetLineWidthFloat;

pub use cla297::SetAliasedLineWidthFloat;

pub use cla297::SetLineMultisampleOverride;

pub use cla297::SetAlphaHysteresis;

pub use cla297::InvalidateSamplerCacheNoWfi;
pub use cla297::InvalidateSamplerCacheNoWfiLines;

pub use cla297::InvalidateTextureHeaderCacheNoWfi;
pub use cla297::InvalidateTextureHeaderCacheNoWfiLines;

pub use cla297::SetGlobalBaseVertexIndex;

pub use cla297::SetGlobalBaseInstanceIndex;

pub use cla297::SetPsWarpWatermarks;

pub use cla297::SetPsRegisterWatermarks;

pub use cla297::StoreZcull;

pub use cla297::SetIteratedBlendConstantRed;

pub use cla297::SetIteratedBlendConstantGreen;

pub use cla297::SetIteratedBlendConstantBlue;

pub use cla297::LoadZcull;

pub use cla297::SetSurfaceClipIdHeight;

pub use cla297::SetClipIdClearRectHorizontal;

pub use cla297::SetClipIdClearRectVertical;

pub use cla297::SetUserClipEnable;

pub use cla297::SetZpassPixelCount;

pub use cla297::SetPointSize;

pub use cla297::SetZcullStats;

pub use cla297::SetPointSprite;

pub use cla297::SetShaderExceptions;

pub use cla297::ClearReportValue;
pub use cla297::ClearReportValueType;

pub use cla297::SetAntiAliasEnable;

pub use cla297::SetZtSelect;

pub use cla297::SetAntiAliasAlphaControl;
pub use cla297::SetAntiAliasAlphaControlAlphaToCoverage;
pub use cla297::SetAntiAliasAlphaControlAlphaToOne;

pub use cla297::SetRenderEnableA;

pub use cla297::SetRenderEnableB;

pub use cla297::SetRenderEnableC;
pub use cla297::SetRenderEnableCMode;

pub use cla297::SetTexSamplerPoolA;

pub use cla297::SetTexSamplerPoolB;

pub use cla297::SetTexSamplerPoolC;

pub use cla297::SetSlopeScaleDepthBias;

pub use cla297::SetAntiAliasedLine;

pub use cla297::SetTexHeaderPoolA;

pub use cla297::SetTexHeaderPoolB;

pub use cla297::SetTexHeaderPoolC;

pub use cla297::SetActiveZcullRegion;

pub use cla297::SetTwoSidedStencilTest;

pub use cla297::SetBackStencilOpFail;
pub use cla297::SetBackStencilOpFailV;

pub use cla297::SetBackStencilOpZfail;
pub use cla297::SetBackStencilOpZfailV;

pub use cla297::SetBackStencilOpZpass;
pub use cla297::SetBackStencilOpZpassV;

pub use cla297::SetBackStencilFunc;
pub use cla297::SetBackStencilFuncV;

pub use cla297::SetSrgbWrite;

pub use cla297::SetDepthBias;

pub use cla297::SetZcullRegionFormat;
pub use cla297::SetZcullRegionFormatType;

pub use cla297::SetRtLayer;
pub use cla297::SetRtLayerControl;

pub use cla297::SetAntiAlias;
pub use cla297::SetAntiAliasSamples;

pub use cla297::SetEdgeFlag;

pub use cla297::DrawInlineIndex;

pub use cla297::SetInlineIndex2X16Align;

pub use cla297::DrawInlineIndex2X16;

pub use cla297::SetVertexGlobalBaseOffsetA;

pub use cla297::SetVertexGlobalBaseOffsetB;

pub use cla297::SetZcullRegionPixelOffsetA;

pub use cla297::SetZcullRegionPixelOffsetB;

pub use cla297::SetPointSpriteSelect;
pub use cla297::SetPointSpriteSelectOrigin;
pub use cla297::SetPointSpriteSelectRmode;
pub use cla297::SetPointSpriteSelectTexture0;
pub use cla297::SetPointSpriteSelectTexture1;
pub use cla297::SetPointSpriteSelectTexture2;
pub use cla297::SetPointSpriteSelectTexture3;
pub use cla297::SetPointSpriteSelectTexture4;
pub use cla297::SetPointSpriteSelectTexture5;
pub use cla297::SetPointSpriteSelectTexture6;
pub use cla297::SetPointSpriteSelectTexture7;
pub use cla297::SetPointSpriteSelectTexture8;
pub use cla297::SetPointSpriteSelectTexture9;

pub use cla297::SetProgramRegionA;

pub use cla297::SetProgramRegionB;

pub use cla297::SetAttributeDefault;
pub use cla297::SetAttributeDefaultColorFrontDiffuse;
pub use cla297::SetAttributeDefaultColorFrontSpecular;
pub use cla297::SetAttributeDefaultDx9Color0;
pub use cla297::SetAttributeDefaultDx9Color1ToColor15;
pub use cla297::SetAttributeDefaultFixedFncTexture;
pub use cla297::SetAttributeDefaultGenericVector;

pub use cla297::End;

pub use cla297::Begin;
pub use cla297::BeginInstanceId;
pub use cla297::BeginOp;
pub use cla297::BeginPrimitiveId;
pub use cla297::BeginSplitMode;

pub use cla297::SetVertexIdCopy;

pub use cla297::AddToPrimitiveId;

pub use cla297::LoadPrimitiveId;

pub use cla297::SetShaderBasedCull;

pub use cla297::SetClassVersion;

pub use cla297::SetDaPrimitiveRestart;

pub use cla297::SetDaPrimitiveRestartIndex;

pub use cla297::SetDaOutput;

pub use cla297::SetAntiAliasedPoint;

pub use cla297::SetPointCenterMode;
pub use cla297::SetPointCenterModeV;

pub use cla297::SetLineSmoothParameters;
pub use cla297::SetLineSmoothParametersFalloff;

pub use cla297::SetLineStipple;

pub use cla297::SetLineSmoothEdgeTable;

pub use cla297::SetLineStippleParameters;

pub use cla297::SetProvokingVertex;
pub use cla297::SetProvokingVertexV;

pub use cla297::SetTwoSidedLight;

pub use cla297::SetPolygonStipple;

pub use cla297::SetShaderControl;
pub use cla297::SetShaderControlDefaultPartial;
pub use cla297::SetShaderControlFp32F2INanBehavior;
pub use cla297::SetShaderControlFp32NanBehavior;

pub use cla297::CheckClassVersion;

pub use cla297::SetSphVersion;

pub use cla297::CheckSphVersion;

pub use cla297::SetAlphaToCoverageOverride;
pub use cla297::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use cla297::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use cla297::SetPolygonStipplePattern;

pub use cla297::SetAamVersion;

pub use cla297::CheckAamVersion;

pub use cla297::SetZtLayer;

pub use cla297::SetIndexBufferA;

pub use cla297::SetIndexBufferB;

pub use cla297::SetIndexBufferC;

pub use cla297::SetIndexBufferD;

pub use cla297::SetIndexBufferE;
pub use cla297::SetIndexBufferEIndexSize;

pub use cla297::SetIndexBufferF;

pub use cla297::DrawIndexBuffer;

pub use cla297::DrawIndexBuffer32BeginEndInstanceFirst;
pub use cla297::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use cla297::DrawIndexBuffer16BeginEndInstanceFirst;
pub use cla297::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use cla297::DrawIndexBuffer8BeginEndInstanceFirst;
pub use cla297::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use cla297::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use cla297::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use cla297::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use cla297::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use cla297::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use cla297::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use cla297::SetDepthBiasClamp;

pub use cla297::SetVertexStreamInstanceA;

pub use cla297::SetVertexStreamInstanceB;

pub use cla297::SetAttributePointSize;

pub use cla297::OglSetCull;

pub use cla297::OglSetFrontFace;
pub use cla297::OglSetFrontFaceV;

pub use cla297::OglSetCullFace;
pub use cla297::OglSetCullFaceV;

pub use cla297::SetViewportPixel;
pub use cla297::SetViewportPixelCenter;

pub use cla297::SetViewportScaleOffset;

pub use cla297::SetViewportClipControl;
pub use cla297::SetViewportClipControlGeometryClip;
pub use cla297::SetViewportClipControlGeometryGuardband;
pub use cla297::SetViewportClipControlGeometryGuardbandZ;
pub use cla297::SetViewportClipControlLinePointCullGuardband;
pub use cla297::SetViewportClipControlPixelMaxZ;
pub use cla297::SetViewportClipControlPixelMinZ;

pub use cla297::SetUserClipOp;
pub use cla297::SetUserClipOpPlane0;
pub use cla297::SetUserClipOpPlane1;
pub use cla297::SetUserClipOpPlane2;
pub use cla297::SetUserClipOpPlane3;
pub use cla297::SetUserClipOpPlane4;
pub use cla297::SetUserClipOpPlane5;
pub use cla297::SetUserClipOpPlane6;
pub use cla297::SetUserClipOpPlane7;

pub use cla297::SetRenderEnableOverride;
pub use cla297::SetRenderEnableOverrideMode;

pub use cla297::SetPrimitiveTopologyControl;
pub use cla297::SetPrimitiveTopologyControlOverride;

pub use cla297::SetWindowClipEnable;

pub use cla297::SetWindowClipType;
pub use cla297::SetWindowClipTypeV;

pub use cla297::InvalidateZcull;
pub use cla297::InvalidateZcullV;

pub use cla297::SetZcull;

pub use cla297::SetZcullBounds;

pub use cla297::SetPrimitiveTopology;
pub use cla297::SetPrimitiveTopologyV;

pub use cla297::ZcullSync;

pub use cla297::SetClipIdTest;

pub use cla297::SetSurfaceClipIdWidth;

pub use cla297::SetClipId;

pub use cla297::SetDepthBoundsTest;

pub use cla297::SetBlendFloatOption;

pub use cla297::SetLogicOp;

pub use cla297::SetLogicOpFunc;
pub use cla297::SetLogicOpFuncV;

pub use cla297::SetZCompression;

pub use cla297::ClearSurface;

pub use cla297::ClearClipIdSurface;

pub use cla297::SetColorCompression;

pub use cla297::SetCtWrite;

pub use cla297::PipeNop;

pub use cla297::SetSpare00;

pub use cla297::SetSpare01;

pub use cla297::SetSpare02;

pub use cla297::SetSpare03;

pub use cla297::SetReportSemaphoreA;

pub use cla297::SetReportSemaphoreB;

pub use cla297::SetReportSemaphoreC;

pub use cla297::SetReportSemaphoreD;
pub use cla297::SetReportSemaphoreDAcquire;
pub use cla297::SetReportSemaphoreDComparison;
pub use cla297::SetReportSemaphoreDOperation;
pub use cla297::SetReportSemaphoreDPipelineLocation;
pub use cla297::SetReportSemaphoreDReductionFormat;
pub use cla297::SetReportSemaphoreDReductionOp;
pub use cla297::SetReportSemaphoreDRelease;
pub use cla297::SetReportSemaphoreDReport;
pub use cla297::SetReportSemaphoreDStructureSize;

pub use cla297::SetVertexStreamAFormat;

pub use cla297::SetVertexStreamALocationA;

pub use cla297::SetVertexStreamALocationB;

pub use cla297::SetVertexStreamAFrequency;

pub use cla297::SetVertexStreamBFormat;

pub use cla297::SetVertexStreamBLocationA;

pub use cla297::SetVertexStreamBLocationB;

pub use cla297::SetVertexStreamBFrequency;

pub use cla297::SetBlendPerTargetSeparateForAlpha;

pub use cla297::SetBlendPerTargetColorOp;
pub use cla297::SetBlendPerTargetColorOpV;

pub use cla297::SetBlendPerTargetColorSourceCoeff;
pub use cla297::SetBlendPerTargetColorSourceCoeffV;

pub use cla297::SetBlendPerTargetColorDestCoeff;
pub use cla297::SetBlendPerTargetColorDestCoeffV;

pub use cla297::SetBlendPerTargetAlphaOp;
pub use cla297::SetBlendPerTargetAlphaOpV;

pub use cla297::SetBlendPerTargetAlphaSourceCoeff;
pub use cla297::SetBlendPerTargetAlphaSourceCoeffV;

pub use cla297::SetBlendPerTargetAlphaDestCoeff;
pub use cla297::SetBlendPerTargetAlphaDestCoeffV;

pub use cla297::SetVertexStreamLimitAA;

pub use cla297::SetVertexStreamLimitAB;

pub use cla297::SetVertexStreamLimitBA;

pub use cla297::SetVertexStreamLimitBB;

pub use cla297::SetPipelineShader;
pub use cla297::SetPipelineShaderType;

pub use cla297::SetPipelineProgram;

pub use cla297::SetPipelineReservedA;

pub use cla297::SetPipelineRegisterCount;

pub use cla297::SetPipelineBinding;

pub use cla297::SetPipelineReservedB;

pub use cla297::SetPipelineReservedC;

pub use cla297::SetPipelineReservedD;

pub use cla297::SetPipelineReservedE;

pub use cla297::SetFalcon00;

pub use cla297::SetFalcon01;

pub use cla297::SetFalcon02;

pub use cla297::SetFalcon03;

pub use cla297::SetFalcon04;

pub use cla297::SetFalcon05;

pub use cla297::SetFalcon06;

pub use cla297::SetFalcon07;

pub use cla297::SetFalcon08;

pub use cla297::SetFalcon09;

pub use cla297::SetFalcon10;

pub use cla297::SetFalcon11;

pub use cla297::SetFalcon12;

pub use cla297::SetFalcon13;

pub use cla297::SetFalcon14;

pub use cla297::SetFalcon15;

pub use cla297::SetFalcon16;

pub use cla297::SetFalcon17;

pub use cla297::SetFalcon18;

pub use cla297::SetFalcon19;

pub use cla297::SetFalcon20;

pub use cla297::SetFalcon21;

pub use cla297::SetFalcon22;

pub use cla297::SetFalcon23;

pub use cla297::SetFalcon24;

pub use cla297::SetFalcon25;

pub use cla297::SetFalcon26;

pub use cla297::SetFalcon27;

pub use cla297::SetFalcon28;

pub use cla297::SetFalcon29;

pub use cla297::SetFalcon30;

pub use cla297::SetFalcon31;

pub use cla297::SetConstantBufferSelectorA;

pub use cla297::SetConstantBufferSelectorB;

pub use cla297::SetConstantBufferSelectorC;

pub use cla297::LoadConstantBufferOffset;

pub use cla297::LoadConstantBuffer;

pub use cla297::BindGroupReservedA;

pub use cla297::BindGroupReservedB;

pub use cla297::BindGroupReservedC;

pub use cla297::BindGroupReservedD;

pub use cla297::BindGroupConstantBuffer;

pub use cla297::SetColorClamp;

pub use cla297::SetBindlessTexture;

pub use cla297::SetTrapHandler;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterValueUpper {
    pub v: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterValueUpper {
    const CLASS: u16 = 0xb097;

    fn addr(i: usize) -> u16 {
        (0x333c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla297::SetShaderPerformanceCounterValue;

pub use cla297::SetShaderPerformanceCounterEvent;

pub use cla297::SetShaderPerformanceCounterControlA;

pub use cla297::SetShaderPerformanceCounterControlB;

pub use cla297::SetShaderPerformanceCounterTrapControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StartShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StartShaderPerformanceCounter {
    const ADDR: u16 = 0x33e0;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct StopShaderPerformanceCounter {
    pub counter_mask: u32,
}

impl Mthd for StopShaderPerformanceCounter {
    const ADDR: u16 = 0x33e4;
    const CLASS: u16 = 0xb097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.counter_mask < (1 << 8));
        val |= self.counter_mask << 0;

        val
    }
}

pub use cla297::SetMmeShadowScratch;

pub use cla297::CallMmeMacro;

pub use cla297::CallMmeData;
