use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::cla097::mthd as cla097;

// parsed class NVA297

pub use cla097::SetObject;

pub use cla097::NoOperation;

pub use cla097::SetNotifyA;

pub use cla097::SetNotifyB;

pub use cla097::Notify;
pub use cla097::NotifyType;

pub use cla097::WaitForIdle;

pub use cla097::LoadMmeInstructionRamPointer;

pub use cla097::LoadMmeInstructionRam;

pub use cla097::LoadMmeStartAddressRamPointer;

pub use cla097::LoadMmeStartAddressRam;

pub use cla097::SetMmeShadowRamControl;
pub use cla097::SetMmeShadowRamControlMode;

pub use cla097::PeerSemaphoreReleaseOffsetUpper;

pub use cla097::PeerSemaphoreReleaseOffset;

pub use cla097::SetGlobalRenderEnableA;

pub use cla097::SetGlobalRenderEnableB;

pub use cla097::SetGlobalRenderEnableC;
pub use cla097::SetGlobalRenderEnableCMode;

pub use cla097::SendGoIdle;

pub use cla097::PmTrigger;

pub use cla097::PmTriggerWfi;

pub use cla097::SetInstrumentationMethodHeader;

pub use cla097::SetInstrumentationMethodData;

pub use cla097::LineLengthIn;

pub use cla097::LineCount;

pub use cla097::OffsetOutUpper;

pub use cla097::OffsetOut;

pub use cla097::PitchOut;

pub use cla097::SetDstBlockSize;
pub use cla097::SetDstBlockSizeDepth;
pub use cla097::SetDstBlockSizeHeight;
pub use cla097::SetDstBlockSizeWidth;

pub use cla097::SetDstWidth;

pub use cla097::SetDstHeight;

pub use cla097::SetDstDepth;

pub use cla097::SetDstLayer;

pub use cla097::SetDstOriginBytesX;

pub use cla097::SetDstOriginSamplesY;

pub use cla097::LaunchDma;
pub use cla097::LaunchDmaCompletionType;
pub use cla097::LaunchDmaDstMemoryLayout;
pub use cla097::LaunchDmaInterruptType;
pub use cla097::LaunchDmaReductionFormat;
pub use cla097::LaunchDmaReductionOp;
pub use cla097::LaunchDmaSemaphoreStructSize;

pub use cla097::LoadInlineData;

pub use cla097::SetI2MSemaphoreA;

pub use cla097::SetI2MSemaphoreB;

pub use cla097::SetI2MSemaphoreC;

pub use cla097::SetI2MSpareNoop00;

pub use cla097::SetI2MSpareNoop01;

pub use cla097::SetI2MSpareNoop02;

pub use cla097::SetI2MSpareNoop03;

pub use cla097::RunDsNow;

pub use cla097::SetOpportunisticEarlyZHysteresis;
pub use cla097::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use cla097::SetRasterPipeSyncControl;

pub use cla097::SetAliasedLineWidthEnable;

pub use cla097::SetApiMandatedEarlyZ;

pub use cla097::SetGsDmFifo;

pub use cla097::SetL2CacheControlForRopPrefetchReadRequests;
pub use cla097::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

pub use cla097::InvalidateShaderCaches;

pub use cla097::SetVabVertex3F;

pub use cla097::SetVabVertex4F;

pub use cla097::SetVabNormal3F;

pub use cla097::SetVabColor3F;

pub use cla097::SetVabColor4F;

pub use cla097::SetVabColor4Ub;

pub use cla097::SetVabTexCoord1F;

pub use cla097::SetVabTexCoord2F;

pub use cla097::SetVabTexCoord3F;

pub use cla097::SetVabTexCoord4F;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetGlobalLoadViaTexture {
    pub enable: bool,
    pub header_index: u32,
}

impl Mthd for SetGlobalLoadViaTexture {
    const ADDR: u16 = 0x02c4;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.header_index < (1 << 20));
        val |= self.header_index << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum IncrementSyncPointCondition {
    StreamOutWritesDone = 0x00000000,
    RopWritesDone = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct IncrementSyncPoint {
    pub index: u32,
    pub clean_l2: bool,
    pub condition: IncrementSyncPointCondition,
}

impl Mthd for IncrementSyncPoint {
    const ADDR: u16 = 0x02c8;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.index < (1 << 12));
        val |= self.index << 0;

        assert!((self.clean_l2 as u32) < (1 << 1));
        val |= (self.clean_l2 as u32) << 16;

        assert!((self.condition as u32) < (1 << 1));
        val |= (self.condition as u32) << 20;

        val
    }
}

pub use cla097::SetTaskCircularBufferThrottle;

pub use cla097::SetPrimCircularBufferThrottle;

pub use cla097::FlushAndInvalidateRopMiniCache;

pub use cla097::SetSurfaceClipIdBlockSize;
pub use cla097::SetSurfaceClipIdBlockSizeDepth;
pub use cla097::SetSurfaceClipIdBlockSizeHeight;
pub use cla097::SetSurfaceClipIdBlockSizeWidth;

pub use cla097::SetAlphaCircularBufferSize;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct DecompressSurface {
    pub mrt_select: u32,
    pub rt_array_index: u32,
}

impl Mthd for DecompressSurface {
    const ADDR: u16 = 0x02e0;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.mrt_select < (1 << 3));
        val |= self.mrt_select << 0;

        assert!(self.rt_array_index < (1 << 16));
        val |= self.rt_array_index << 4;

        val
    }
}

pub use cla097::SetZcullRopBypass;

pub use cla097::SetZcullSubregion;

pub use cla097::SetRasterBoundingBox;
pub use cla097::SetRasterBoundingBoxMode;

pub use cla097::PeerSemaphoreRelease;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetIteratedBlendOptimizationNoop {
    Never = 0x00000000,
    SourceRgba0000 = 0x00000001,
    SourceAlpha0 = 0x00000002,
    SourceRgba0001 = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlendOptimization {
    pub noop: SetIteratedBlendOptimizationNoop,
}

impl Mthd for SetIteratedBlendOptimization {
    const ADDR: u16 = 0x02f4;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.noop as u32) < (1 << 2));
        val |= (self.noop as u32) << 0;

        val
    }
}

pub use cla097::SetZcullSubregionAllocation;
pub use cla097::SetZcullSubregionAllocationFormat;

pub use cla097::AssignZcullSubregions;
pub use cla097::AssignZcullSubregionsAlgorithm;

pub use cla097::SetPsOutputSampleMaskUsage;
pub use cla097::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use cla097::DrawZeroIndex;

pub use cla097::SetL1Configuration;
pub use cla097::SetL1ConfigurationDirectlyAddressableMemory;

pub use cla097::SetRenderEnableControl;

pub use cla097::SetSpaVersion;

pub use cla097::SetIeeeCleanUpdate;

pub use cla097::SetSnapGridLine;
pub use cla097::SetSnapGridLineLocationsPerPixel;
pub use cla097::SetSnapGridLineRoundingMode;

pub use cla097::SetSnapGridNonLine;
pub use cla097::SetSnapGridNonLineLocationsPerPixel;
pub use cla097::SetSnapGridNonLineRoundingMode;

pub use cla097::SetTessellationParameters;
pub use cla097::SetTessellationParametersDomainType;
pub use cla097::SetTessellationParametersOutputPrimitives;
pub use cla097::SetTessellationParametersSpacing;

pub use cla097::SetTessellationLodU0OrDensity;

pub use cla097::SetTessellationLodV0OrDetail;

pub use cla097::SetTessellationLodU1OrW0;

pub use cla097::SetTessellationLodV1;

pub use cla097::SetTgLodInteriorU;

pub use cla097::SetTgLodInteriorV;

pub use cla097::ReservedTg07;

pub use cla097::ReservedTg08;

pub use cla097::ReservedTg09;

pub use cla097::ReservedTg10;

pub use cla097::ReservedTg11;

pub use cla097::ReservedTg12;

pub use cla097::ReservedTg13;

pub use cla097::ReservedTg14;

pub use cla097::ReservedTg15;

pub use cla097::SetSubtilingPerfKnobA;

pub use cla097::SetSubtilingPerfKnobB;

pub use cla097::SetSubtilingPerfKnobC;

pub use cla097::SetZcullSubregionToReport;

pub use cla097::SetZcullSubregionReportType;
pub use cla097::SetZcullSubregionReportTypeType;

pub use cla097::SetBalancedPrimitiveWorkload;

pub use cla097::SetMaxPatchesPerBatch;

pub use cla097::SetRasterEnable;

pub use cla097::SetStreamOutBufferEnable;

pub use cla097::SetStreamOutBufferAddressA;

pub use cla097::SetStreamOutBufferAddressB;

pub use cla097::SetStreamOutBufferSize;

pub use cla097::SetStreamOutBufferLoadWritePointer;

pub use cla097::SetVabDataTypeless;

pub use cla097::SetStreamOutControlStream;

pub use cla097::SetStreamOutControlComponentCount;

pub use cla097::SetStreamOutControlStride;

pub use cla097::SetRasterInput;

pub use cla097::SetStreamOutput;

pub use cla097::SetDaPrimitiveRestartTopologyChange;

pub use cla097::SetAlphaFraction;

pub use cla097::SetHybridAntiAliasControl;
pub use cla097::SetHybridAntiAliasControlCentroid;

pub use cla097::SetMaxTiWarpsPerBatch;

pub use cla097::SetShaderLocalMemoryWindow;

pub use cla097::SetShaderLocalMemoryA;

pub use cla097::SetShaderLocalMemoryB;

pub use cla097::SetShaderLocalMemoryC;

pub use cla097::SetShaderLocalMemoryD;

pub use cla097::SetShaderLocalMemoryE;

pub use cla097::SetColorZeroBandwidthClear;

pub use cla097::SetZZeroBandwidthClear;

pub use cla097::SetIsbeSaveRestoreProgram;

pub use cla097::SetVabVertex2F;

pub use cla097::SetZcullRegionSizeA;

pub use cla097::SetZcullRegionSizeB;

pub use cla097::SetZcullRegionSizeC;

pub use cla097::SetZcullRegionPixelOffsetC;

pub use cla097::SetCullBeforeFetch;

pub use cla097::SetZcullRegionLocation;

pub use cla097::SetZcullRegionAliquots;

pub use cla097::SetZcullStorageA;

pub use cla097::SetZcullStorageB;

pub use cla097::SetZcullStorageC;

pub use cla097::SetZcullStorageD;

pub use cla097::SetZtReadOnly;

pub use cla097::SetTextureInstructionOperand;
pub use cla097::SetTextureInstructionOperandOrdering;

pub use cla097::SetColorTargetA;

pub use cla097::SetColorTargetB;

pub use cla097::SetColorTargetWidth;

pub use cla097::SetColorTargetHeight;

pub use cla097::SetColorTargetFormat;
pub use cla097::SetColorTargetFormatV;

pub use cla097::SetColorTargetMemory;
pub use cla097::SetColorTargetMemoryBlockDepth;
pub use cla097::SetColorTargetMemoryBlockHeight;
pub use cla097::SetColorTargetMemoryBlockWidth;
pub use cla097::SetColorTargetMemoryLayout;
pub use cla097::SetColorTargetMemoryThirdDimensionControl;

pub use cla097::SetColorTargetThirdDimension;

pub use cla097::SetColorTargetArrayPitch;

pub use cla097::SetColorTargetLayer;

pub use cla097::SetColorTargetMark;

pub use cla097::SetViewportScaleX;

pub use cla097::SetViewportScaleY;

pub use cla097::SetViewportScaleZ;

pub use cla097::SetViewportOffsetX;

pub use cla097::SetViewportOffsetY;

pub use cla097::SetViewportOffsetZ;

pub use cla097::SetViewportClipHorizontal;

pub use cla097::SetViewportClipVertical;

pub use cla097::SetViewportClipMinZ;

pub use cla097::SetViewportClipMaxZ;

pub use cla097::SetWindowClipHorizontal;

pub use cla097::SetWindowClipVertical;

pub use cla097::SetClipIdExtentX;

pub use cla097::SetClipIdExtentY;

pub use cla097::SetMaxStreamOutputGsInstancesPerTask;

pub use cla097::SetApiVisibleCallLimit;
pub use cla097::SetApiVisibleCallLimitV;

pub use cla097::SetStatisticsCounter;

pub use cla097::SetClearRectHorizontal;

pub use cla097::SetClearRectVertical;

pub use cla097::SetVertexArrayStart;

pub use cla097::DrawVertexArray;

pub use cla097::SetViewportZClip;
pub use cla097::SetViewportZClipRange;

pub use cla097::SetColorClearValue;

pub use cla097::SetZClearValue;

pub use cla097::SetShaderCacheControl;

pub use cla097::ForceTransitionToBeta;

pub use cla097::SetReduceColorThresholdsEnable;

pub use cla097::SetStencilClearValue;

pub use cla097::InvalidateShaderCachesNoWfi;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullSerializationApplied {
    Always = 0x00000000,
    LateZ = 0x00000001,
    OutOfGamutZ = 0x00000002,
    LateZOrOutOfGamutZ = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSerialization {
    pub enable: bool,
    pub applied: SetZcullSerializationApplied,
}

impl Mthd for SetZcullSerialization {
    const ADDR: u16 = 0x0da8;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.applied as u32) < (1 << 2));
        val |= (self.applied as u32) << 4;

        val
    }
}

pub use cla097::SetFrontPolygonMode;
pub use cla097::SetFrontPolygonModeV;

pub use cla097::SetBackPolygonMode;
pub use cla097::SetBackPolygonModeV;

pub use cla097::SetPolySmooth;

pub use cla097::SetZtMark;

pub use cla097::SetZcullDirFormat;
pub use cla097::SetZcullDirFormatZdir;
pub use cla097::SetZcullDirFormatZformat;

pub use cla097::SetPolyOffsetPoint;

pub use cla097::SetPolyOffsetLine;

pub use cla097::SetPolyOffsetFill;

pub use cla097::SetPatch;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlend {
    pub enable: bool,
    pub alpha_enable: bool,
}

impl Mthd for SetIteratedBlend {
    const ADDR: u16 = 0x0dd0;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.alpha_enable as u32) < (1 << 1));
        val |= (self.alpha_enable as u32) << 1;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlendPass {
    pub count: u32,
}

impl Mthd for SetIteratedBlendPass {
    const ADDR: u16 = 0x0dd4;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.count < (1 << 8));
        val |= self.count << 0;

        val
    }
}

pub use cla097::SetZcullCriterion;
pub use cla097::SetZcullCriterionSfunc;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSmQuadrantSelectionControl {
    pub max_pixel_warps: u32,
}

impl Mthd for SetSmQuadrantSelectionControl {
    const ADDR: u16 = 0x0ddc;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.max_pixel_warps < (1 << 8));
        val |= self.max_pixel_warps << 0;

        val
    }
}

pub use cla097::SetSmTimeoutInterval;

pub use cla097::SetDaPrimitiveRestartVertexArray;

pub use cla097::SetDrawInlineVertexVabUpdate;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadIteratedBlendInstructionPointer {
    pub v: u32,
}

impl Mthd for LoadIteratedBlendInstructionPointer {
    const ADDR: u16 = 0x0df0;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 8));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionTestCc {
    False = 0x00000000,
    True = 0x00000001,
    Eq = 0x00000002,
    Ne = 0x00000003,
    Lt = 0x00000004,
    Le = 0x00000005,
    Gt = 0x00000006,
    Ge = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOperation {
    AddProducts = 0x00000000,
    SubProducts = 0x00000001,
    Min = 0x00000002,
    Max = 0x00000003,
    Rcp = 0x00000004,
    Add = 0x00000005,
    Subtract = 0x00000006,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionConstantInputSelect {
    Constant0 = 0x00000000,
    Constant1 = 0x00000001,
    Constant2 = 0x00000002,
    Constant3 = 0x00000003,
    Constant4 = 0x00000004,
    Constant5 = 0x00000005,
    Constant6 = 0x00000006,
    Constant7 = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOperandASelect {
    SrcRgb = 0x00000000,
    DestRgb = 0x00000001,
    SrcAaa = 0x00000002,
    DestAaa = 0x00000003,
    Temp0Rgb = 0x00000004,
    Temp1Rgb = 0x00000005,
    Temp2Rgb = 0x00000006,
    PbrRgb = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOperandBSelect {
    Zero = 0x00000000,
    One = 0x00000001,
    SrcRgb = 0x00000002,
    SrcAaa = 0x00000003,
    OneMinusSrcAaa = 0x00000004,
    DestRgb = 0x00000005,
    DestAaa = 0x00000006,
    OneMinusDestAaa = 0x00000007,
    Temp0Rgb = 0x00000009,
    Temp1Rgb = 0x0000000a,
    Temp2Rgb = 0x0000000b,
    PbrRgb = 0x0000000c,
    ConstantRgb = 0x0000000d,
    ZeroATimesB = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOperandCSelect {
    SrcRgb = 0x00000000,
    DestRgb = 0x00000001,
    SrcAaa = 0x00000002,
    DestAaa = 0x00000003,
    Temp0Rgb = 0x00000004,
    Temp1Rgb = 0x00000005,
    Temp2Rgb = 0x00000006,
    PbrRgb = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOperandDSelect {
    Zero = 0x00000000,
    One = 0x00000001,
    SrcRgb = 0x00000002,
    SrcAaa = 0x00000003,
    OneMinusSrcAaa = 0x00000004,
    DestRgb = 0x00000005,
    DestAaa = 0x00000006,
    OneMinusDestAaa = 0x00000007,
    Temp0Rgb = 0x00000009,
    Temp1Rgb = 0x0000000a,
    Temp2Rgb = 0x0000000b,
    PbrRgb = 0x0000000c,
    ConstantRgb = 0x0000000d,
    ZeroCTimesD = 0x0000000e,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOutputSwizzle {
    Rgb = 0x00000000,
    Gbr = 0x00000001,
    Rrr = 0x00000002,
    Ggg = 0x00000003,
    Bbb = 0x00000004,
    RToA = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionOutputWriteMask {
    Rgb = 0x00000000,
    ROnly = 0x00000001,
    GOnly = 0x00000002,
    BOnly = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LoadIteratedBlendInstructionPassOutput {
    Temp0 = 0x00000000,
    Temp1 = 0x00000001,
    Temp2 = 0x00000002,
    None = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadIteratedBlendInstruction {
    pub test_cc: LoadIteratedBlendInstructionTestCc,
    pub operation: LoadIteratedBlendInstructionOperation,
    pub constant_input_select: LoadIteratedBlendInstructionConstantInputSelect,
    pub operand_a_select: LoadIteratedBlendInstructionOperandASelect,
    pub operand_b_select: LoadIteratedBlendInstructionOperandBSelect,
    pub operand_c_select: LoadIteratedBlendInstructionOperandCSelect,
    pub operand_d_select: LoadIteratedBlendInstructionOperandDSelect,
    pub output_swizzle: LoadIteratedBlendInstructionOutputSwizzle,
    pub output_write_mask: LoadIteratedBlendInstructionOutputWriteMask,
    pub pass_output: LoadIteratedBlendInstructionPassOutput,
    pub set_cc: bool,
}

impl Mthd for LoadIteratedBlendInstruction {
    const ADDR: u16 = 0x0df4;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.test_cc as u32) < (1 << 3));
        val |= (self.test_cc as u32) << 0;

        assert!((self.operation as u32) < (1 << 3));
        val |= (self.operation as u32) << 3;

        assert!((self.constant_input_select as u32) < (1 << 3));
        val |= (self.constant_input_select as u32) << 6;

        assert!((self.operand_a_select as u32) < (1 << 3));
        val |= (self.operand_a_select as u32) << 9;

        assert!((self.operand_b_select as u32) < (1 << 4));
        val |= (self.operand_b_select as u32) << 12;

        assert!((self.operand_c_select as u32) < (1 << 3));
        val |= (self.operand_c_select as u32) << 16;

        assert!((self.operand_d_select as u32) < (1 << 4));
        val |= (self.operand_d_select as u32) << 19;

        assert!((self.output_swizzle as u32) < (1 << 3));
        val |= (self.output_swizzle as u32) << 23;

        assert!((self.output_write_mask as u32) < (1 << 2));
        val |= (self.output_write_mask as u32) << 26;

        assert!((self.pass_output as u32) < (1 << 2));
        val |= (self.pass_output as u32) << 28;

        assert!((self.set_cc as u32) < (1 << 1));
        val |= (self.set_cc as u32) << 31;

        val
    }
}

pub use cla097::SetWindowOffsetX;

pub use cla097::SetWindowOffsetY;

pub use cla097::SetScissorEnable;

pub use cla097::SetScissorHorizontal;

pub use cla097::SetScissorVertical;

pub use cla097::SetVabNormal3S;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantColorRendering {
    pub enable: bool,
}

impl Mthd for SetConstantColorRendering {
    const ADDR: u16 = 0x0f40;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantColorRenderingRed {
    pub v: u32,
}

impl Mthd for SetConstantColorRenderingRed {
    const ADDR: u16 = 0x0f44;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantColorRenderingGreen {
    pub v: u32,
}

impl Mthd for SetConstantColorRenderingGreen {
    const ADDR: u16 = 0x0f48;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantColorRenderingBlue {
    pub v: u32,
}

impl Mthd for SetConstantColorRenderingBlue {
    const ADDR: u16 = 0x0f4c;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetConstantColorRenderingAlpha {
    pub v: u32,
}

impl Mthd for SetConstantColorRenderingAlpha {
    const ADDR: u16 = 0x0f50;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cla097::SetBackStencilFuncRef;

pub use cla097::SetBackStencilMask;

pub use cla097::SetBackStencilFuncMask;

pub use cla097::SetVertexStreamSubstituteA;

pub use cla097::SetVertexStreamSubstituteB;

pub use cla097::SetLineModePolygonClip;
pub use cla097::SetLineModePolygonClipGeneratedEdge;

pub use cla097::SetSingleCtWriteControl;

pub use cla097::SetVtgWarpWatermarks;

pub use cla097::SetDepthBoundsMin;

pub use cla097::SetDepthBoundsMax;

pub use cla097::SetCtMrtEnable;

pub use cla097::SetNonmultisampledZ;
pub use cla097::SetNonmultisampledZV;

pub use cla097::SetSampleMaskX0Y0;

pub use cla097::SetSampleMaskX1Y0;

pub use cla097::SetSampleMaskX0Y1;

pub use cla097::SetSampleMaskX1Y1;

pub use cla097::SetSurfaceClipIdMemoryA;

pub use cla097::SetSurfaceClipIdMemoryB;

pub use cla097::SetBlendOptControl;

pub use cla097::SetZtA;

pub use cla097::SetZtB;

pub use cla097::SetZtFormat;
pub use cla097::SetZtFormatV;

pub use cla097::SetZtBlockSize;
pub use cla097::SetZtBlockSizeDepth;
pub use cla097::SetZtBlockSizeHeight;
pub use cla097::SetZtBlockSizeWidth;

pub use cla097::SetZtArrayPitch;

pub use cla097::SetSurfaceClipHorizontal;

pub use cla097::SetSurfaceClipVertical;

pub use cla097::SetL2CacheControlForVafRequests;
pub use cla097::SetL2CacheControlForVafRequestsPolicy;

pub use cla097::SetTessellationCutHeight;

pub use cla097::SetMaxGsInstancesPerTask;

pub use cla097::SetMaxGsOutputVerticesPerTask;

pub use cla097::SetGsOutputCbStorageMultiplier;

pub use cla097::SetBetaCbStorageConstraint;

pub use cla097::SetTiOutputCbStorageMultiplier;

pub use cla097::SetAlphaCbStorageConstraint;

pub use cla097::SetSpareNoop01;

pub use cla097::SetSpareNoop02;

pub use cla097::SetSpareNoop03;

pub use cla097::SetSpareNoop04;

pub use cla097::SetSpareNoop05;

pub use cla097::SetSpareNoop06;

pub use cla097::SetSpareNoop07;

pub use cla097::SetSpareNoop08;

pub use cla097::SetSpareNoop09;

pub use cla097::SetSpareNoop10;

pub use cla097::SetSpareNoop11;

pub use cla097::SetSpareNoop12;

pub use cla097::SetSpareNoop13;

pub use cla097::SetSpareNoop14;

pub use cla097::SetSpareNoop15;

pub use cla097::SetReduceColorThresholdsUnorm8;

pub use cla097::SetReduceColorThresholdsUnorm10;

pub use cla097::SetReduceColorThresholdsUnorm16;

pub use cla097::SetReduceColorThresholdsFp11;

pub use cla097::SetReduceColorThresholdsFp16;

pub use cla097::SetReduceColorThresholdsSrgb8;

pub use cla097::UnbindAll;

pub use cla097::SetClearSurfaceControl;

pub use cla097::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use cla097::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use cla097::NoOperationDataHi;

pub use cla097::SetDepthBiasControl;

pub use cla097::PmTriggerEnd;

pub use cla097::SetVertexIdBase;

pub use cla097::SetDaOutputAttributeSkipMaskA;

pub use cla097::SetDaOutputAttributeSkipMaskB;

pub use cla097::SetBlendPerFormatEnable;

pub use cla097::FlushPendingWrites;

pub use cla097::SetVabDataControl;
pub use cla097::SetVabDataControlFormat;

pub use cla097::SetVabData;

pub use cla097::SetVertexAttributeA;
pub use cla097::SetVertexAttributeAComponentBitWidths;
pub use cla097::SetVertexAttributeANumericalType;
pub use cla097::SetVertexAttributeASource;

pub use cla097::SetVertexAttributeB;
pub use cla097::SetVertexAttributeBComponentBitWidths;
pub use cla097::SetVertexAttributeBNumericalType;
pub use cla097::SetVertexAttributeBSource;

pub use cla097::DrawVertexArrayBeginEndInstanceFirst;
pub use cla097::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use cla097::DrawVertexArrayBeginEndInstanceSubsequent;
pub use cla097::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use cla097::SetCtSelect;

pub use cla097::SetCompressionThreshold;
pub use cla097::SetCompressionThresholdSamples;

pub use cla097::SetZtSizeA;

pub use cla097::SetZtSizeB;

pub use cla097::SetZtSizeC;
pub use cla097::SetZtSizeCControl;

pub use cla097::SetSamplerBinding;
pub use cla097::SetSamplerBindingV;

pub use cla097::DrawAuto;

pub use cla097::SetCircularBufferSize;

pub use cla097::SetVtgRegisterWatermarks;

pub use cla097::InvalidateTextureDataCacheNoWfi;
pub use cla097::InvalidateTextureDataCacheNoWfiLines;

pub use cla097::SetL2CacheControlForRopInterlockedReadRequests;
pub use cla097::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use cla097::SetDaPrimitiveRestartIndexTopologyChange;

pub use cla097::SetShaderScheduling;
pub use cla097::SetShaderSchedulingMode;

pub use cla097::ClearZcullRegion;

pub use cla097::SetDepthTest;

pub use cla097::SetFillMode;
pub use cla097::SetFillModeV;

pub use cla097::SetShadeMode;
pub use cla097::SetShadeModeV;

pub use cla097::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use cla097::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use cla097::SetL2CacheControlForRopInterlockedWriteRequests;
pub use cla097::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use cla097::SetAlphaToCoverageDitherControl;
pub use cla097::SetAlphaToCoverageDitherControlDitherFootprint;

pub use cla097::SetBlendStatePerTarget;

pub use cla097::SetDepthWrite;

pub use cla097::SetAlphaTest;

pub use cla097::SetInlineIndex4X8Align;

pub use cla097::DrawInlineIndex4X8;

pub use cla097::D3DSetCullMode;
pub use cla097::D3DSetCullModeV;

pub use cla097::SetDepthFunc;
pub use cla097::SetDepthFuncV;

pub use cla097::SetAlphaRef;

pub use cla097::SetAlphaFunc;
pub use cla097::SetAlphaFuncV;

pub use cla097::SetDrawAutoStride;

pub use cla097::SetBlendConstRed;

pub use cla097::SetBlendConstGreen;

pub use cla097::SetBlendConstBlue;

pub use cla097::SetBlendConstAlpha;

pub use cla097::InvalidateSamplerCache;
pub use cla097::InvalidateSamplerCacheLines;

pub use cla097::InvalidateTextureHeaderCache;
pub use cla097::InvalidateTextureHeaderCacheLines;

pub use cla097::InvalidateTextureDataCache;
pub use cla097::InvalidateTextureDataCacheLines;

pub use cla097::SetBlendSeparateForAlpha;

pub use cla097::SetBlendColorOp;
pub use cla097::SetBlendColorOpV;

pub use cla097::SetBlendColorSourceCoeff;
pub use cla097::SetBlendColorSourceCoeffV;

pub use cla097::SetBlendColorDestCoeff;
pub use cla097::SetBlendColorDestCoeffV;

pub use cla097::SetBlendAlphaOp;
pub use cla097::SetBlendAlphaOpV;

pub use cla097::SetBlendAlphaSourceCoeff;
pub use cla097::SetBlendAlphaSourceCoeffV;

pub use cla097::SetGlobalColorKey;

pub use cla097::SetBlendAlphaDestCoeff;
pub use cla097::SetBlendAlphaDestCoeffV;

pub use cla097::SetSingleRopControl;

pub use cla097::SetBlend;

pub use cla097::SetStencilTest;

pub use cla097::SetStencilOpFail;
pub use cla097::SetStencilOpFailV;

pub use cla097::SetStencilOpZfail;
pub use cla097::SetStencilOpZfailV;

pub use cla097::SetStencilOpZpass;
pub use cla097::SetStencilOpZpassV;

pub use cla097::SetStencilFunc;
pub use cla097::SetStencilFuncV;

pub use cla097::SetStencilFuncRef;

pub use cla097::SetStencilFuncMask;

pub use cla097::SetStencilMask;

pub use cla097::SetDrawAutoStart;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange0 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange1 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange2 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange3 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange4 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange5 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange6 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetPsSaturateClampRange7 {
    ZeroToPlusOne = 0x00000000,
    MinusOneToPlusOne = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetPsSaturate {
    pub output0: bool,
    pub clamp_range0: SetPsSaturateClampRange0,
    pub output1: bool,
    pub clamp_range1: SetPsSaturateClampRange1,
    pub output2: bool,
    pub clamp_range2: SetPsSaturateClampRange2,
    pub output3: bool,
    pub clamp_range3: SetPsSaturateClampRange3,
    pub output4: bool,
    pub clamp_range4: SetPsSaturateClampRange4,
    pub output5: bool,
    pub clamp_range5: SetPsSaturateClampRange5,
    pub output6: bool,
    pub clamp_range6: SetPsSaturateClampRange6,
    pub output7: bool,
    pub clamp_range7: SetPsSaturateClampRange7,
}

impl Mthd for SetPsSaturate {
    const ADDR: u16 = 0x13a8;
    const CLASS: u16 = 0xa297;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.output0 as u32) < (1 << 1));
        val |= (self.output0 as u32) << 0;

        assert!((self.clamp_range0 as u32) < (1 << 1));
        val |= (self.clamp_range0 as u32) << 1;

        assert!((self.output1 as u32) < (1 << 1));
        val |= (self.output1 as u32) << 4;

        assert!((self.clamp_range1 as u32) < (1 << 1));
        val |= (self.clamp_range1 as u32) << 5;

        assert!((self.output2 as u32) < (1 << 1));
        val |= (self.output2 as u32) << 8;

        assert!((self.clamp_range2 as u32) < (1 << 1));
        val |= (self.clamp_range2 as u32) << 9;

        assert!((self.output3 as u32) < (1 << 1));
        val |= (self.output3 as u32) << 12;

        assert!((self.clamp_range3 as u32) < (1 << 1));
        val |= (self.clamp_range3 as u32) << 13;

        assert!((self.output4 as u32) < (1 << 1));
        val |= (self.output4 as u32) << 16;

        assert!((self.clamp_range4 as u32) < (1 << 1));
        val |= (self.clamp_range4 as u32) << 17;

        assert!((self.output5 as u32) < (1 << 1));
        val |= (self.output5 as u32) << 20;

        assert!((self.clamp_range5 as u32) < (1 << 1));
        val |= (self.clamp_range5 as u32) << 21;

        assert!((self.output6 as u32) < (1 << 1));
        val |= (self.output6 as u32) << 24;

        assert!((self.clamp_range6 as u32) < (1 << 1));
        val |= (self.clamp_range6 as u32) << 25;

        assert!((self.output7 as u32) < (1 << 1));
        val |= (self.output7 as u32) << 28;

        assert!((self.clamp_range7 as u32) < (1 << 1));
        val |= (self.clamp_range7 as u32) << 29;

        val
    }
}

pub use cla097::SetWindowOrigin;
pub use cla097::SetWindowOriginMode;

pub use cla097::SetLineWidthFloat;

pub use cla097::SetAliasedLineWidthFloat;

pub use cla097::SetLineMultisampleOverride;

pub use cla097::SetAlphaHysteresis;

pub use cla097::InvalidateSamplerCacheNoWfi;
pub use cla097::InvalidateSamplerCacheNoWfiLines;

pub use cla097::InvalidateTextureHeaderCacheNoWfi;
pub use cla097::InvalidateTextureHeaderCacheNoWfiLines;

pub use cla097::InvalidateDaDmaCache;

pub use cla097::SetGlobalBaseVertexIndex;

pub use cla097::SetGlobalBaseInstanceIndex;

pub use cla097::SetPsWarpWatermarks;

pub use cla097::SetPsRegisterWatermarks;

pub use cla097::StoreZcull;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlendConstantRed {
    pub v: u32,
}

impl ArrayMthd for SetIteratedBlendConstantRed {
    const CLASS: u16 = 0xa297;

    fn addr(i: usize) -> u16 {
        (0x1480 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlendConstantGreen {
    pub v: u32,
}

impl ArrayMthd for SetIteratedBlendConstantGreen {
    const CLASS: u16 = 0xa297;

    fn addr(i: usize) -> u16 {
        (0x1484 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIteratedBlendConstantBlue {
    pub v: u32,
}

impl ArrayMthd for SetIteratedBlendConstantBlue {
    const CLASS: u16 = 0xa297;

    fn addr(i: usize) -> u16 {
        (0x1488 + i * 16).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

pub use cla097::LoadZcull;

pub use cla097::SetSurfaceClipIdHeight;

pub use cla097::SetClipIdClearRectHorizontal;

pub use cla097::SetClipIdClearRectVertical;

pub use cla097::SetUserClipEnable;

pub use cla097::SetZpassPixelCount;

pub use cla097::SetPointSize;

pub use cla097::SetZcullStats;

pub use cla097::SetPointSprite;

pub use cla097::SetShaderExceptions;

pub use cla097::ClearReportValue;
pub use cla097::ClearReportValueType;

pub use cla097::SetAntiAliasEnable;

pub use cla097::SetZtSelect;

pub use cla097::SetAntiAliasAlphaControl;
pub use cla097::SetAntiAliasAlphaControlAlphaToCoverage;
pub use cla097::SetAntiAliasAlphaControlAlphaToOne;

pub use cla097::SetRenderEnableA;

pub use cla097::SetRenderEnableB;

pub use cla097::SetRenderEnableC;
pub use cla097::SetRenderEnableCMode;

pub use cla097::SetTexSamplerPoolA;

pub use cla097::SetTexSamplerPoolB;

pub use cla097::SetTexSamplerPoolC;

pub use cla097::SetSlopeScaleDepthBias;

pub use cla097::SetAntiAliasedLine;

pub use cla097::SetTexHeaderPoolA;

pub use cla097::SetTexHeaderPoolB;

pub use cla097::SetTexHeaderPoolC;

pub use cla097::SetActiveZcullRegion;

pub use cla097::SetTwoSidedStencilTest;

pub use cla097::SetBackStencilOpFail;
pub use cla097::SetBackStencilOpFailV;

pub use cla097::SetBackStencilOpZfail;
pub use cla097::SetBackStencilOpZfailV;

pub use cla097::SetBackStencilOpZpass;
pub use cla097::SetBackStencilOpZpassV;

pub use cla097::SetBackStencilFunc;
pub use cla097::SetBackStencilFuncV;

pub use cla097::SetSrgbWrite;

pub use cla097::SetDepthBias;

pub use cla097::SetZcullRegionFormat;
pub use cla097::SetZcullRegionFormatType;

pub use cla097::SetRtLayer;
pub use cla097::SetRtLayerControl;

pub use cla097::SetAntiAlias;
pub use cla097::SetAntiAliasSamples;

pub use cla097::SetEdgeFlag;

pub use cla097::DrawInlineIndex;

pub use cla097::SetInlineIndex2X16Align;

pub use cla097::DrawInlineIndex2X16;

pub use cla097::SetVertexGlobalBaseOffsetA;

pub use cla097::SetVertexGlobalBaseOffsetB;

pub use cla097::SetZcullRegionPixelOffsetA;

pub use cla097::SetZcullRegionPixelOffsetB;

pub use cla097::SetPointSpriteSelect;
pub use cla097::SetPointSpriteSelectOrigin;
pub use cla097::SetPointSpriteSelectRmode;
pub use cla097::SetPointSpriteSelectTexture0;
pub use cla097::SetPointSpriteSelectTexture1;
pub use cla097::SetPointSpriteSelectTexture2;
pub use cla097::SetPointSpriteSelectTexture3;
pub use cla097::SetPointSpriteSelectTexture4;
pub use cla097::SetPointSpriteSelectTexture5;
pub use cla097::SetPointSpriteSelectTexture6;
pub use cla097::SetPointSpriteSelectTexture7;
pub use cla097::SetPointSpriteSelectTexture8;
pub use cla097::SetPointSpriteSelectTexture9;

pub use cla097::SetProgramRegionA;

pub use cla097::SetProgramRegionB;

pub use cla097::SetAttributeDefault;
pub use cla097::SetAttributeDefaultColorFrontDiffuse;
pub use cla097::SetAttributeDefaultColorFrontSpecular;
pub use cla097::SetAttributeDefaultDx9Color0;
pub use cla097::SetAttributeDefaultDx9Color1ToColor15;
pub use cla097::SetAttributeDefaultFixedFncTexture;
pub use cla097::SetAttributeDefaultGenericVector;

pub use cla097::End;

pub use cla097::Begin;
pub use cla097::BeginInstanceId;
pub use cla097::BeginOp;
pub use cla097::BeginPrimitiveId;
pub use cla097::BeginSplitMode;

pub use cla097::SetVertexIdCopy;

pub use cla097::AddToPrimitiveId;

pub use cla097::LoadPrimitiveId;

pub use cla097::SetShaderBasedCull;

pub use cla097::SetClassVersion;

pub use cla097::SetVabPage;
pub use cla097::SetVabPageReadSelect;

pub use cla097::DrawInlineVertex;

pub use cla097::SetDaPrimitiveRestart;

pub use cla097::SetDaPrimitiveRestartIndex;

pub use cla097::SetDaOutput;

pub use cla097::SetAntiAliasedPoint;

pub use cla097::SetPointCenterMode;
pub use cla097::SetPointCenterModeV;

pub use cla097::SetLineSmoothParameters;
pub use cla097::SetLineSmoothParametersFalloff;

pub use cla097::SetLineStipple;

pub use cla097::SetLineSmoothEdgeTable;

pub use cla097::SetLineStippleParameters;

pub use cla097::SetProvokingVertex;
pub use cla097::SetProvokingVertexV;

pub use cla097::SetTwoSidedLight;

pub use cla097::SetPolygonStipple;

pub use cla097::SetShaderControl;
pub use cla097::SetShaderControlDefaultPartial;
pub use cla097::SetShaderControlFp32F2INanBehavior;
pub use cla097::SetShaderControlFp32NanBehavior;

pub use cla097::LaunchVertex;

pub use cla097::CheckClassVersion;

pub use cla097::SetSphVersion;

pub use cla097::CheckSphVersion;

pub use cla097::SetAlphaToCoverageOverride;
pub use cla097::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use cla097::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use cla097::SetPolygonStipplePattern;

pub use cla097::SetAamVersion;

pub use cla097::CheckAamVersion;

pub use cla097::SetZtLayer;

pub use cla097::SetVabMemoryAreaA;

pub use cla097::SetVabMemoryAreaB;

pub use cla097::SetVabMemoryAreaC;
pub use cla097::SetVabMemoryAreaCSize;

pub use cla097::SetIndexBufferA;

pub use cla097::SetIndexBufferB;

pub use cla097::SetIndexBufferC;

pub use cla097::SetIndexBufferD;

pub use cla097::SetIndexBufferE;
pub use cla097::SetIndexBufferEIndexSize;

pub use cla097::SetIndexBufferF;

pub use cla097::DrawIndexBuffer;

pub use cla097::DrawIndexBuffer32BeginEndInstanceFirst;
pub use cla097::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use cla097::DrawIndexBuffer16BeginEndInstanceFirst;
pub use cla097::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use cla097::DrawIndexBuffer8BeginEndInstanceFirst;
pub use cla097::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use cla097::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use cla097::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use cla097::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use cla097::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use cla097::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use cla097::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use cla097::SetDepthBiasClamp;

pub use cla097::SetVertexStreamInstanceA;

pub use cla097::SetVertexStreamInstanceB;

pub use cla097::SetAttributePointSize;

pub use cla097::OglSetCull;

pub use cla097::OglSetFrontFace;
pub use cla097::OglSetFrontFaceV;

pub use cla097::OglSetCullFace;
pub use cla097::OglSetCullFaceV;

pub use cla097::SetViewportPixel;
pub use cla097::SetViewportPixelCenter;

pub use cla097::SetViewportScaleOffset;

pub use cla097::InvalidateConstantBufferCache;

pub use cla097::SetViewportClipControl;
pub use cla097::SetViewportClipControlGeometryClip;
pub use cla097::SetViewportClipControlGeometryGuardband;
pub use cla097::SetViewportClipControlGeometryGuardbandZ;
pub use cla097::SetViewportClipControlLinePointCullGuardband;
pub use cla097::SetViewportClipControlPixelMaxZ;
pub use cla097::SetViewportClipControlPixelMinZ;

pub use cla097::SetUserClipOp;
pub use cla097::SetUserClipOpPlane0;
pub use cla097::SetUserClipOpPlane1;
pub use cla097::SetUserClipOpPlane2;
pub use cla097::SetUserClipOpPlane3;
pub use cla097::SetUserClipOpPlane4;
pub use cla097::SetUserClipOpPlane5;
pub use cla097::SetUserClipOpPlane6;
pub use cla097::SetUserClipOpPlane7;

pub use cla097::SetRenderEnableOverride;
pub use cla097::SetRenderEnableOverrideMode;

pub use cla097::SetPrimitiveTopologyControl;
pub use cla097::SetPrimitiveTopologyControlOverride;

pub use cla097::SetWindowClipEnable;

pub use cla097::SetWindowClipType;
pub use cla097::SetWindowClipTypeV;

pub use cla097::InvalidateZcull;
pub use cla097::InvalidateZcullV;

pub use cla097::SetZcull;

pub use cla097::SetZcullBounds;

pub use cla097::SetPrimitiveTopology;
pub use cla097::SetPrimitiveTopologyV;

pub use cla097::ZcullSync;

pub use cla097::SetClipIdTest;

pub use cla097::SetSurfaceClipIdWidth;

pub use cla097::SetClipId;

pub use cla097::SetDepthBoundsTest;

pub use cla097::SetBlendFloatOption;

pub use cla097::SetLogicOp;

pub use cla097::SetLogicOpFunc;
pub use cla097::SetLogicOpFuncV;

pub use cla097::SetZCompression;

pub use cla097::ClearSurface;

pub use cla097::ClearClipIdSurface;

pub use cla097::SetColorCompression;

pub use cla097::SetCtWrite;

pub use cla097::PipeNop;

pub use cla097::SetSpare00;

pub use cla097::SetSpare01;

pub use cla097::SetSpare02;

pub use cla097::SetSpare03;

pub use cla097::SetReportSemaphoreA;

pub use cla097::SetReportSemaphoreB;

pub use cla097::SetReportSemaphoreC;

pub use cla097::SetReportSemaphoreD;
pub use cla097::SetReportSemaphoreDAcquire;
pub use cla097::SetReportSemaphoreDComparison;
pub use cla097::SetReportSemaphoreDOperation;
pub use cla097::SetReportSemaphoreDPipelineLocation;
pub use cla097::SetReportSemaphoreDReductionFormat;
pub use cla097::SetReportSemaphoreDReductionOp;
pub use cla097::SetReportSemaphoreDRelease;
pub use cla097::SetReportSemaphoreDReport;
pub use cla097::SetReportSemaphoreDStructureSize;

pub use cla097::SetVertexStreamAFormat;

pub use cla097::SetVertexStreamALocationA;

pub use cla097::SetVertexStreamALocationB;

pub use cla097::SetVertexStreamAFrequency;

pub use cla097::SetVertexStreamBFormat;

pub use cla097::SetVertexStreamBLocationA;

pub use cla097::SetVertexStreamBLocationB;

pub use cla097::SetVertexStreamBFrequency;

pub use cla097::SetBlendPerTargetSeparateForAlpha;

pub use cla097::SetBlendPerTargetColorOp;
pub use cla097::SetBlendPerTargetColorOpV;

pub use cla097::SetBlendPerTargetColorSourceCoeff;
pub use cla097::SetBlendPerTargetColorSourceCoeffV;

pub use cla097::SetBlendPerTargetColorDestCoeff;
pub use cla097::SetBlendPerTargetColorDestCoeffV;

pub use cla097::SetBlendPerTargetAlphaOp;
pub use cla097::SetBlendPerTargetAlphaOpV;

pub use cla097::SetBlendPerTargetAlphaSourceCoeff;
pub use cla097::SetBlendPerTargetAlphaSourceCoeffV;

pub use cla097::SetBlendPerTargetAlphaDestCoeff;
pub use cla097::SetBlendPerTargetAlphaDestCoeffV;

pub use cla097::SetVertexStreamLimitAA;

pub use cla097::SetVertexStreamLimitAB;

pub use cla097::SetVertexStreamLimitBA;

pub use cla097::SetVertexStreamLimitBB;

pub use cla097::SetPipelineShader;
pub use cla097::SetPipelineShaderType;

pub use cla097::SetPipelineProgram;

pub use cla097::SetPipelineReservedA;

pub use cla097::SetPipelineRegisterCount;

pub use cla097::SetPipelineBinding;

pub use cla097::SetPipelineReservedB;

pub use cla097::SetPipelineReservedC;

pub use cla097::SetPipelineReservedD;

pub use cla097::SetPipelineReservedE;

pub use cla097::SetFalcon00;

pub use cla097::SetFalcon01;

pub use cla097::SetFalcon02;

pub use cla097::SetFalcon03;

pub use cla097::SetFalcon04;

pub use cla097::SetFalcon05;

pub use cla097::SetFalcon06;

pub use cla097::SetFalcon07;

pub use cla097::SetFalcon08;

pub use cla097::SetFalcon09;

pub use cla097::SetFalcon10;

pub use cla097::SetFalcon11;

pub use cla097::SetFalcon12;

pub use cla097::SetFalcon13;

pub use cla097::SetFalcon14;

pub use cla097::SetFalcon15;

pub use cla097::SetFalcon16;

pub use cla097::SetFalcon17;

pub use cla097::SetFalcon18;

pub use cla097::SetFalcon19;

pub use cla097::SetFalcon20;

pub use cla097::SetFalcon21;

pub use cla097::SetFalcon22;

pub use cla097::SetFalcon23;

pub use cla097::SetFalcon24;

pub use cla097::SetFalcon25;

pub use cla097::SetFalcon26;

pub use cla097::SetFalcon27;

pub use cla097::SetFalcon28;

pub use cla097::SetFalcon29;

pub use cla097::SetFalcon30;

pub use cla097::SetFalcon31;

pub use cla097::SetConstantBufferSelectorA;

pub use cla097::SetConstantBufferSelectorB;

pub use cla097::SetConstantBufferSelectorC;

pub use cla097::LoadConstantBufferOffset;

pub use cla097::LoadConstantBuffer;

pub use cla097::BindGroupReservedA;

pub use cla097::BindGroupReservedB;

pub use cla097::BindGroupReservedC;

pub use cla097::BindGroupReservedD;

pub use cla097::BindGroupConstantBuffer;

pub use cla097::SetColorClamp;

pub use cla097::NoopXXXSetValve;
pub use cla097::NoopXXXSetValveHigherPriority;

pub use cla097::SetBindlessTexture;

pub use cla097::SetTrapHandler;

pub use cla097::SetShaderPerformanceCounterValue;

pub use cla097::SetShaderPerformanceCounterEvent;

pub use cla097::SetShaderPerformanceCounterControlA;

pub use cla097::SetShaderPerformanceCounterControlB;

pub use cla097::SetShaderPerformanceCounterTrapControl;

pub use cla097::SetMmeShadowScratch;

pub use cla097::CallMmeMacro;

pub use cla097::CallMmeData;
