use crate::ArrayMthd;
use crate::Mthd;

use crate::classes::cl9097::mthd as cl9097;

// parsed class NVA097

pub use cl9097::SetObject;

pub use cl9097::NoOperation;

pub use cl9097::SetNotifyA;

pub use cl9097::SetNotifyB;

pub use cl9097::Notify;
pub use cl9097::NotifyType;

pub use cl9097::WaitForIdle;

pub use cl9097::LoadMmeInstructionRamPointer;

pub use cl9097::LoadMmeInstructionRam;

pub use cl9097::LoadMmeStartAddressRamPointer;

pub use cl9097::LoadMmeStartAddressRam;

pub use cl9097::SetMmeShadowRamControl;
pub use cl9097::SetMmeShadowRamControlMode;

pub use cl9097::PeerSemaphoreReleaseOffsetUpper;

pub use cl9097::PeerSemaphoreReleaseOffset;

pub use cl9097::SetGlobalRenderEnableA;

pub use cl9097::SetGlobalRenderEnableB;

pub use cl9097::SetGlobalRenderEnableC;
pub use cl9097::SetGlobalRenderEnableCMode;

pub use cl9097::SendGoIdle;

pub use cl9097::PmTrigger;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PmTriggerWfi {
    pub v: u32,
}

impl Mthd for PmTriggerWfi {
    const ADDR: u16 = 0x0144;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cl9097::SetInstrumentationMethodHeader;

pub use cl9097::SetInstrumentationMethodData;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineLengthIn {
    pub value: u32,
}

impl Mthd for LineLengthIn {
    const ADDR: u16 = 0x0180;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LineCount {
    pub value: u32,
}

impl Mthd for LineCount {
    const ADDR: u16 = 0x0184;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOutUpper {
    pub value: u32,
}

impl Mthd for OffsetOutUpper {
    const ADDR: u16 = 0x0188;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.value < (1 << 8));
        val |= self.value << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct OffsetOut {
    pub value: u32,
}

impl Mthd for OffsetOut {
    const ADDR: u16 = 0x018c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct PitchOut {
    pub value: u32,
}

impl Mthd for PitchOut {
    const ADDR: u16 = 0x0190;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.value;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeWidth {
    OneGob = 0x00000000,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeHeight {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetDstBlockSizeDepth {
    OneGob = 0x00000000,
    TwoGobs = 0x00000001,
    FourGobs = 0x00000002,
    EightGobs = 0x00000003,
    SixteenGobs = 0x00000004,
    ThirtytwoGobs = 0x00000005,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstBlockSize {
    pub width: SetDstBlockSizeWidth,
    pub height: SetDstBlockSizeHeight,
    pub depth: SetDstBlockSizeDepth,
}

impl Mthd for SetDstBlockSize {
    const ADDR: u16 = 0x0194;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.width as u32) < (1 << 4));
        val |= (self.width as u32) << 0;

        assert!((self.height as u32) < (1 << 4));
        val |= (self.height as u32) << 4;

        assert!((self.depth as u32) < (1 << 4));
        val |= (self.depth as u32) << 8;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstWidth {
    pub v: u32,
}

impl Mthd for SetDstWidth {
    const ADDR: u16 = 0x0198;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstHeight {
    pub v: u32,
}

impl Mthd for SetDstHeight {
    const ADDR: u16 = 0x019c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstDepth {
    pub v: u32,
}

impl Mthd for SetDstDepth {
    const ADDR: u16 = 0x01a0;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstLayer {
    pub v: u32,
}

impl Mthd for SetDstLayer {
    const ADDR: u16 = 0x01a4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginBytesX {
    pub v: u32,
}

impl Mthd for SetDstOriginBytesX {
    const ADDR: u16 = 0x01a8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 20));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetDstOriginSamplesY {
    pub v: u32,
}

impl Mthd for SetDstOriginSamplesY {
    const ADDR: u16 = 0x01ac;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 16));
        val |= self.v << 0;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaDstMemoryLayout {
    Blocklinear = 0x00000000,
    Pitch = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaCompletionType {
    FlushDisable = 0x00000000,
    FlushOnly = 0x00000001,
    ReleaseSemaphore = 0x00000002,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaInterruptType {
    None = 0x00000000,
    Interrupt = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaSemaphoreStructSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum LaunchDmaReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LaunchDma {
    pub dst_memory_layout: LaunchDmaDstMemoryLayout,
    pub completion_type: LaunchDmaCompletionType,
    pub interrupt_type: LaunchDmaInterruptType,
    pub semaphore_struct_size: LaunchDmaSemaphoreStructSize,
    pub reduction_enable: bool,
    pub reduction_op: LaunchDmaReductionOp,
    pub reduction_format: LaunchDmaReductionFormat,
    pub sysmembar_disable: bool,
}

impl Mthd for LaunchDma {
    const ADDR: u16 = 0x01b0;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.dst_memory_layout as u32) < (1 << 1));
        val |= (self.dst_memory_layout as u32) << 0;

        assert!((self.completion_type as u32) < (1 << 2));
        val |= (self.completion_type as u32) << 4;

        assert!((self.interrupt_type as u32) < (1 << 2));
        val |= (self.interrupt_type as u32) << 8;

        assert!((self.semaphore_struct_size as u32) < (1 << 1));
        val |= (self.semaphore_struct_size as u32) << 12;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 1;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 13;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 2;

        assert!((self.sysmembar_disable as u32) < (1 << 1));
        val |= (self.sysmembar_disable as u32) << 6;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct LoadInlineData {
    pub v: u32,
}

impl Mthd for LoadInlineData {
    const ADDR: u16 = 0x01b4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreA {
    pub offset_upper: u32,
}

impl Mthd for SetI2MSemaphoreA {
    const ADDR: u16 = 0x01dc;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.offset_upper < (1 << 8));
        val |= self.offset_upper << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreB {
    pub offset_lower: u32,
}

impl Mthd for SetI2MSemaphoreB {
    const ADDR: u16 = 0x01e0;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset_lower;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSemaphoreC {
    pub payload: u32,
}

impl Mthd for SetI2MSemaphoreC {
    const ADDR: u16 = 0x01e4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.payload;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop00 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop00 {
    const ADDR: u16 = 0x01f0;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop01 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop01 {
    const ADDR: u16 = 0x01f4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop02 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop02 {
    const ADDR: u16 = 0x01f8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetI2MSpareNoop03 {
    pub v: u32,
}

impl Mthd for SetI2MSpareNoop03 {
    const ADDR: u16 = 0x01fc;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.v;

        val
    }
}

pub use cl9097::RunDsNow;

pub use cl9097::SetOpportunisticEarlyZHysteresis;
pub use cl9097::SetOpportunisticEarlyZHysteresisAccumulatedPrimAreaThreshold;

pub use cl9097::SetRasterPipeSyncControl;

pub use cl9097::SetAliasedLineWidthEnable;

pub use cl9097::SetApiMandatedEarlyZ;

pub use cl9097::SetGsDmFifo;

pub use cl9097::SetL2CacheControlForRopPrefetchReadRequests;
pub use cl9097::SetL2CacheControlForRopPrefetchReadRequestsPolicy;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCaches {
    pub instruction: bool,
    pub data: bool,
    pub constant: bool,
    pub locks: bool,
    pub flush_data: bool,
}

impl Mthd for InvalidateShaderCaches {
    const ADDR: u16 = 0x021c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.data as u32) < (1 << 1));
        val |= (self.data as u32) << 4;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        assert!((self.locks as u32) < (1 << 1));
        val |= (self.locks as u32) << 1;

        assert!((self.flush_data as u32) < (1 << 1));
        val |= (self.flush_data as u32) << 2;

        val
    }
}

pub use cl9097::SetVabVertex3F;

pub use cl9097::SetVabVertex4F;

pub use cl9097::SetVabNormal3F;

pub use cl9097::SetVabColor3F;

pub use cl9097::SetVabColor4F;

pub use cl9097::SetVabColor4Ub;

pub use cl9097::SetVabTexCoord1F;

pub use cl9097::SetVabTexCoord2F;

pub use cl9097::SetVabTexCoord3F;

pub use cl9097::SetVabTexCoord4F;

pub use cl9097::SetTaskCircularBufferThrottle;

pub use cl9097::SetPrimCircularBufferThrottle;

pub use cl9097::FlushAndInvalidateRopMiniCache;

pub use cl9097::SetSurfaceClipIdBlockSize;
pub use cl9097::SetSurfaceClipIdBlockSizeDepth;
pub use cl9097::SetSurfaceClipIdBlockSizeHeight;
pub use cl9097::SetSurfaceClipIdBlockSizeWidth;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetAlphaCircularBufferSize {
    pub cache_lines_per_sm: u32,
}

impl Mthd for SetAlphaCircularBufferSize {
    const ADDR: u16 = 0x02dc;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.cache_lines_per_sm < (1 << 10));
        val |= self.cache_lines_per_sm << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRopBypass {
    pub enable: bool,
    pub no_stall: bool,
    pub cull_everything: bool,
    pub threshold: u32,
}

impl Mthd for SetZcullRopBypass {
    const ADDR: u16 = 0x02e4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.no_stall as u32) < (1 << 1));
        val |= (self.no_stall as u32) << 4;

        assert!((self.cull_everything as u32) < (1 << 1));
        val |= (self.cull_everything as u32) << 8;

        assert!(self.threshold < (1 << 4));
        val |= self.threshold << 12;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregion {
    pub enable: bool,
    pub normalized_aliquots: u32,
}

impl Mthd for SetZcullSubregion {
    const ADDR: u16 = 0x02e8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.normalized_aliquots < (1 << 24));
        val |= self.normalized_aliquots << 4;

        val
    }
}

pub use cl9097::SetRasterBoundingBox;
pub use cl9097::SetRasterBoundingBoxMode;

pub use cl9097::PeerSemaphoreRelease;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullSubregionAllocationFormat {
    Z16X16X24X4 = 0x00000000,
    Zs16X164X4 = 0x00000001,
    Z16X164X2 = 0x00000002,
    Z16X162X4 = 0x00000003,
    Z16X84X4 = 0x00000004,
    Z8X84X2 = 0x00000005,
    Z8X82X4 = 0x00000006,
    Z16X164X8 = 0x00000007,
    Z4X82X2 = 0x00000008,
    Zs16X84X2 = 0x00000009,
    Zs16X82X4 = 0x0000000a,
    Zs8X82X2 = 0x0000000b,
    Z4X81X1 = 0x0000000c,
    None = 0x0000000f,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionAllocation {
    pub subregion_id: u32,
    pub aliquots: u32,
    pub format: SetZcullSubregionAllocationFormat,
}

impl Mthd for SetZcullSubregionAllocation {
    const ADDR: u16 = 0x02f8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.subregion_id < (1 << 8));
        val |= self.subregion_id << 0;

        assert!(self.aliquots < (1 << 16));
        val |= self.aliquots << 8;

        assert!((self.format as u32) < (1 << 4));
        val |= (self.format as u32) << 24;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum AssignZcullSubregionsAlgorithm {
    Static = 0x00000000,
    Adaptive = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct AssignZcullSubregions {
    pub algorithm: AssignZcullSubregionsAlgorithm,
}

impl Mthd for AssignZcullSubregions {
    const ADDR: u16 = 0x02fc;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.algorithm as u32) < (1 << 2));
        val |= (self.algorithm as u32) << 0;

        val
    }
}

pub use cl9097::SetPsOutputSampleMaskUsage;
pub use cl9097::SetPsOutputSampleMaskUsageQualifyByAntiAliasEnable;

pub use cl9097::DrawZeroIndex;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetL1ConfigurationDirectlyAddressableMemory {
    Size16Kb = 0x00000001,
    Size48Kb = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetL1Configuration {
    pub directly_addressable_memory: SetL1ConfigurationDirectlyAddressableMemory,
}

impl Mthd for SetL1Configuration {
    const ADDR: u16 = 0x0308;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.directly_addressable_memory as u32) < (1 << 3));
        val |= (self.directly_addressable_memory as u32) << 0;

        val
    }
}

pub use cl9097::SetRenderEnableControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetSpaVersion {
    pub minor: u32,
    pub major: u32,
}

impl Mthd for SetSpaVersion {
    const ADDR: u16 = 0x0310;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.minor < (1 << 8));
        val |= self.minor << 0;

        assert!(self.major < (1 << 8));
        val |= self.major << 8;

        val
    }
}

pub use cl9097::SetIeeeCleanUpdate;

pub use cl9097::SetSnapGridLine;
pub use cl9097::SetSnapGridLineLocationsPerPixel;
pub use cl9097::SetSnapGridLineRoundingMode;

pub use cl9097::SetSnapGridNonLine;
pub use cl9097::SetSnapGridNonLineLocationsPerPixel;
pub use cl9097::SetSnapGridNonLineRoundingMode;

pub use cl9097::SetTessellationParameters;
pub use cl9097::SetTessellationParametersDomainType;
pub use cl9097::SetTessellationParametersOutputPrimitives;
pub use cl9097::SetTessellationParametersSpacing;

pub use cl9097::SetTessellationLodU0OrDensity;

pub use cl9097::SetTessellationLodV0OrDetail;

pub use cl9097::SetTessellationLodU1OrW0;

pub use cl9097::SetTessellationLodV1;

pub use cl9097::SetTgLodInteriorU;

pub use cl9097::SetTgLodInteriorV;

pub use cl9097::ReservedTg07;

pub use cl9097::ReservedTg08;

pub use cl9097::ReservedTg09;

pub use cl9097::ReservedTg10;

pub use cl9097::ReservedTg11;

pub use cl9097::ReservedTg12;

pub use cl9097::ReservedTg13;

pub use cl9097::ReservedTg14;

pub use cl9097::ReservedTg15;

pub use cl9097::SetSubtilingPerfKnobA;

pub use cl9097::SetSubtilingPerfKnobB;

pub use cl9097::SetSubtilingPerfKnobC;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionToReport {
    pub enable: bool,
    pub subregion_id: u32,
}

impl Mthd for SetZcullSubregionToReport {
    const ADDR: u16 = 0x036c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!(self.subregion_id < (1 << 8));
        val |= self.subregion_id << 4;

        val
    }
}

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullSubregionReportTypeType {
    DepthTest = 0x00000000,
    DepthTestNoAccept = 0x00000001,
    DepthTestLateZ = 0x00000002,
    StencilTest = 0x00000003,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullSubregionReportType {
    pub enable: bool,
    pub type_: SetZcullSubregionReportTypeType,
}

impl Mthd for SetZcullSubregionReportType {
    const ADDR: u16 = 0x0370;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.enable as u32) < (1 << 1));
        val |= (self.enable as u32) << 0;

        assert!((self.type_ as u32) < (1 << 3));
        val |= (self.type_ as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBalancedPrimitiveWorkload {
    pub in_unpartitioned_mode: bool,
    pub in_timesliced_mode: bool,
}

impl Mthd for SetBalancedPrimitiveWorkload {
    const ADDR: u16 = 0x0374;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.in_unpartitioned_mode as u32) < (1 << 1));
        val |= (self.in_unpartitioned_mode as u32) << 0;

        assert!((self.in_timesliced_mode as u32) < (1 << 1));
        val |= (self.in_timesliced_mode as u32) << 4;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetMaxPatchesPerBatch {
    pub v: u32,
}

impl Mthd for SetMaxPatchesPerBatch {
    const ADDR: u16 = 0x0378;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 6));
        val |= self.v << 0;

        val
    }
}

pub use cl9097::SetRasterEnable;

pub use cl9097::SetStreamOutBufferEnable;

pub use cl9097::SetStreamOutBufferAddressA;

pub use cl9097::SetStreamOutBufferAddressB;

pub use cl9097::SetStreamOutBufferSize;

pub use cl9097::SetStreamOutBufferLoadWritePointer;

pub use cl9097::SetVabDataTypeless;

pub use cl9097::SetStreamOutControlStream;

pub use cl9097::SetStreamOutControlComponentCount;

pub use cl9097::SetStreamOutControlStride;

pub use cl9097::SetRasterInput;

pub use cl9097::SetStreamOutput;

pub use cl9097::SetDaPrimitiveRestartTopologyChange;

pub use cl9097::SetAlphaFraction;

pub use cl9097::SetHybridAntiAliasControl;
pub use cl9097::SetHybridAntiAliasControlCentroid;

pub use cl9097::SetMaxTiWarpsPerBatch;

pub use cl9097::SetShaderLocalMemoryWindow;

pub use cl9097::SetShaderLocalMemoryA;

pub use cl9097::SetShaderLocalMemoryB;

pub use cl9097::SetShaderLocalMemoryC;

pub use cl9097::SetShaderLocalMemoryD;

pub use cl9097::SetShaderLocalMemoryE;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorZeroBandwidthClear {
    pub slot_disable_mask: u32,
}

impl Mthd for SetColorZeroBandwidthClear {
    const ADDR: u16 = 0x07a4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.slot_disable_mask < (1 << 15));
        val |= self.slot_disable_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZZeroBandwidthClear {
    pub slot_disable_mask: u32,
}

impl Mthd for SetZZeroBandwidthClear {
    const ADDR: u16 = 0x07a8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.slot_disable_mask < (1 << 15));
        val |= self.slot_disable_mask << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetIsbeSaveRestoreProgram {
    pub offset: u32,
}

impl Mthd for SetIsbeSaveRestoreProgram {
    const ADDR: u16 = 0x07ac;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset;

        val
    }
}

pub use cl9097::SetVabVertex2F;

pub use cl9097::SetZcullRegionSizeA;

pub use cl9097::SetZcullRegionSizeB;

pub use cl9097::SetZcullRegionSizeC;

pub use cl9097::SetZcullRegionPixelOffsetC;

pub use cl9097::SetCullBeforeFetch;

pub use cl9097::SetZcullRegionLocation;

pub use cl9097::SetZcullRegionAliquots;

pub use cl9097::SetZcullStorageA;

pub use cl9097::SetZcullStorageB;

pub use cl9097::SetZcullStorageC;

pub use cl9097::SetZcullStorageD;

pub use cl9097::SetZtReadOnly;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetTextureInstructionOperandOrdering {
    FermiOrder = 0x00000000,
    KeplerOrder = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTextureInstructionOperand {
    pub ordering: SetTextureInstructionOperandOrdering,
}

impl Mthd for SetTextureInstructionOperand {
    const ADDR: u16 = 0x07fc;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.ordering as u32) < (1 << 1));
        val |= (self.ordering as u32) << 0;

        val
    }
}

pub use cl9097::SetColorTargetA;

pub use cl9097::SetColorTargetB;

pub use cl9097::SetColorTargetWidth;

pub use cl9097::SetColorTargetHeight;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetColorTargetFormatV {
    Disabled = 0x00000000,
    Rf32Gf32Bf32Af32 = 0x000000c0,
    Rs32Gs32Bs32As32 = 0x000000c1,
    Ru32Gu32Bu32Au32 = 0x000000c2,
    Rf32Gf32Bf32X32 = 0x000000c3,
    Rs32Gs32Bs32X32 = 0x000000c4,
    Ru32Gu32Bu32X32 = 0x000000c5,
    R16G16B16A16 = 0x000000c6,
    Rn16Gn16Bn16An16 = 0x000000c7,
    Rs16Gs16Bs16As16 = 0x000000c8,
    Ru16Gu16Bu16Au16 = 0x000000c9,
    Rf16Gf16Bf16Af16 = 0x000000ca,
    Rf32Gf32 = 0x000000cb,
    Rs32Gs32 = 0x000000cc,
    Ru32Gu32 = 0x000000cd,
    Rf16Gf16Bf16X16 = 0x000000ce,
    A8R8G8B8 = 0x000000cf,
    A8Rl8Gl8Bl8 = 0x000000d0,
    A2B10G10R10 = 0x000000d1,
    Au2Bu10Gu10Ru10 = 0x000000d2,
    A8B8G8R8 = 0x000000d5,
    A8Bl8Gl8Rl8 = 0x000000d6,
    An8Bn8Gn8Rn8 = 0x000000d7,
    As8Bs8Gs8Rs8 = 0x000000d8,
    Au8Bu8Gu8Ru8 = 0x000000d9,
    R16G16 = 0x000000da,
    Rn16Gn16 = 0x000000db,
    Rs16Gs16 = 0x000000dc,
    Ru16Gu16 = 0x000000dd,
    Rf16Gf16 = 0x000000de,
    A2R10G10B10 = 0x000000df,
    Bf10Gf11Rf11 = 0x000000e0,
    Rs32 = 0x000000e3,
    Ru32 = 0x000000e4,
    Rf32 = 0x000000e5,
    X8R8G8B8 = 0x000000e6,
    X8Rl8Gl8Bl8 = 0x000000e7,
    R5G6B5 = 0x000000e8,
    A1R5G5B5 = 0x000000e9,
    G8R8 = 0x000000ea,
    Gn8Rn8 = 0x000000eb,
    Gs8Rs8 = 0x000000ec,
    Gu8Ru8 = 0x000000ed,
    R16 = 0x000000ee,
    Rn16 = 0x000000ef,
    Rs16 = 0x000000f0,
    Ru16 = 0x000000f1,
    Rf16 = 0x000000f2,
    R8 = 0x000000f3,
    Rn8 = 0x000000f4,
    Rs8 = 0x000000f5,
    Ru8 = 0x000000f6,
    A8 = 0x000000f7,
    X1R5G5B5 = 0x000000f8,
    X8B8G8R8 = 0x000000f9,
    X8Bl8Gl8Rl8 = 0x000000fa,
    Z1R5G5B5 = 0x000000fb,
    O1R5G5B5 = 0x000000fc,
    Z8R8G8B8 = 0x000000fd,
    O8R8G8B8 = 0x000000fe,
    R32 = 0x000000ff,
    A16 = 0x00000040,
    Af16 = 0x00000041,
    Af32 = 0x00000042,
    A8R8 = 0x00000043,
    R16A16 = 0x00000044,
    Rf16Af16 = 0x00000045,
    Rf32Af32 = 0x00000046,
    B8G8R8A8 = 0x00000047,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetColorTargetFormat {
    pub v: SetColorTargetFormatV,
}

impl ArrayMthd for SetColorTargetFormat {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x0810 + i * 64).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.v as u32) < (1 << 8));
        val |= (self.v as u32) << 0;

        val
    }
}

pub use cl9097::SetColorTargetMemory;
pub use cl9097::SetColorTargetMemoryBlockDepth;
pub use cl9097::SetColorTargetMemoryBlockHeight;
pub use cl9097::SetColorTargetMemoryBlockWidth;
pub use cl9097::SetColorTargetMemoryLayout;
pub use cl9097::SetColorTargetMemoryThirdDimensionControl;

pub use cl9097::SetColorTargetThirdDimension;

pub use cl9097::SetColorTargetArrayPitch;

pub use cl9097::SetColorTargetLayer;

pub use cl9097::SetColorTargetMark;

pub use cl9097::SetViewportScaleX;

pub use cl9097::SetViewportScaleY;

pub use cl9097::SetViewportScaleZ;

pub use cl9097::SetViewportOffsetX;

pub use cl9097::SetViewportOffsetY;

pub use cl9097::SetViewportOffsetZ;

pub use cl9097::SetViewportClipHorizontal;

pub use cl9097::SetViewportClipVertical;

pub use cl9097::SetViewportClipMinZ;

pub use cl9097::SetViewportClipMaxZ;

pub use cl9097::SetWindowClipHorizontal;

pub use cl9097::SetWindowClipVertical;

pub use cl9097::SetClipIdExtentX;

pub use cl9097::SetClipIdExtentY;

pub use cl9097::SetMaxStreamOutputGsInstancesPerTask;

pub use cl9097::SetApiVisibleCallLimit;
pub use cl9097::SetApiVisibleCallLimitV;

pub use cl9097::SetStatisticsCounter;

pub use cl9097::SetClearRectHorizontal;

pub use cl9097::SetClearRectVertical;

pub use cl9097::SetVertexArrayStart;

pub use cl9097::DrawVertexArray;

pub use cl9097::SetViewportZClip;
pub use cl9097::SetViewportZClipRange;

pub use cl9097::SetColorClearValue;

pub use cl9097::SetZClearValue;

pub use cl9097::SetShaderCacheControl;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct ForceTransitionToBeta {
    pub v: u32,
}

impl Mthd for ForceTransitionToBeta {
    const ADDR: u16 = 0x0d98;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use cl9097::SetReduceColorThresholdsEnable;

pub use cl9097::SetStencilClearValue;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateShaderCachesNoWfi {
    pub instruction: bool,
    pub global_data: bool,
    pub constant: bool,
}

impl Mthd for InvalidateShaderCachesNoWfi {
    const ADDR: u16 = 0x0da4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.instruction as u32) < (1 << 1));
        val |= (self.instruction as u32) << 0;

        assert!((self.global_data as u32) < (1 << 1));
        val |= (self.global_data as u32) << 4;

        assert!((self.constant as u32) < (1 << 1));
        val |= (self.constant as u32) << 12;

        val
    }
}

pub use cl9097::SetFrontPolygonMode;
pub use cl9097::SetFrontPolygonModeV;

pub use cl9097::SetBackPolygonMode;
pub use cl9097::SetBackPolygonModeV;

pub use cl9097::SetPolySmooth;

pub use cl9097::SetZtMark;

pub use cl9097::SetZcullDirFormat;
pub use cl9097::SetZcullDirFormatZdir;
pub use cl9097::SetZcullDirFormatZformat;

pub use cl9097::SetPolyOffsetPoint;

pub use cl9097::SetPolyOffsetLine;

pub use cl9097::SetPolyOffsetFill;

pub use cl9097::SetPatch;

pub use cl9097::SetZcullCriterion;
pub use cl9097::SetZcullCriterionSfunc;

pub use cl9097::SetSmTimeoutInterval;

pub use cl9097::SetDaPrimitiveRestartVertexArray;

pub use cl9097::SetDrawInlineVertexVabUpdate;

pub use cl9097::SetWindowOffsetX;

pub use cl9097::SetWindowOffsetY;

pub use cl9097::SetScissorEnable;

pub use cl9097::SetScissorHorizontal;

pub use cl9097::SetScissorVertical;

pub use cl9097::SetVabNormal3S;

pub use cl9097::SetBackStencilFuncRef;

pub use cl9097::SetBackStencilMask;

pub use cl9097::SetBackStencilFuncMask;

pub use cl9097::SetVertexStreamSubstituteA;

pub use cl9097::SetVertexStreamSubstituteB;

pub use cl9097::SetLineModePolygonClip;
pub use cl9097::SetLineModePolygonClipGeneratedEdge;

pub use cl9097::SetSingleCtWriteControl;

pub use cl9097::SetVtgWarpWatermarks;

pub use cl9097::SetDepthBoundsMin;

pub use cl9097::SetDepthBoundsMax;

pub use cl9097::SetCtMrtEnable;

pub use cl9097::SetNonmultisampledZ;
pub use cl9097::SetNonmultisampledZV;

pub use cl9097::SetSampleMaskX0Y0;

pub use cl9097::SetSampleMaskX1Y0;

pub use cl9097::SetSampleMaskX0Y1;

pub use cl9097::SetSampleMaskX1Y1;

pub use cl9097::SetSurfaceClipIdMemoryA;

pub use cl9097::SetSurfaceClipIdMemoryB;

pub use cl9097::SetBlendOptControl;

pub use cl9097::SetZtA;

pub use cl9097::SetZtB;

pub use cl9097::SetZtFormat;
pub use cl9097::SetZtFormatV;

pub use cl9097::SetZtBlockSize;
pub use cl9097::SetZtBlockSizeDepth;
pub use cl9097::SetZtBlockSizeHeight;
pub use cl9097::SetZtBlockSizeWidth;

pub use cl9097::SetZtArrayPitch;

pub use cl9097::SetSurfaceClipHorizontal;

pub use cl9097::SetSurfaceClipVertical;

pub use cl9097::SetL2CacheControlForVafRequests;
pub use cl9097::SetL2CacheControlForVafRequestsPolicy;

pub use cl9097::SetTessellationCutHeight;

pub use cl9097::SetMaxGsInstancesPerTask;

pub use cl9097::SetMaxGsOutputVerticesPerTask;

pub use cl9097::SetGsOutputCbStorageMultiplier;

pub use cl9097::SetBetaCbStorageConstraint;

pub use cl9097::SetTiOutputCbStorageMultiplier;

pub use cl9097::SetAlphaCbStorageConstraint;

pub use cl9097::SetSpareNoop00;

pub use cl9097::SetSpareNoop01;

pub use cl9097::SetSpareNoop02;

pub use cl9097::SetSpareNoop03;

pub use cl9097::SetSpareNoop04;

pub use cl9097::SetSpareNoop05;

pub use cl9097::SetSpareNoop06;

pub use cl9097::SetSpareNoop07;

pub use cl9097::SetSpareNoop08;

pub use cl9097::SetSpareNoop09;

pub use cl9097::SetSpareNoop10;

pub use cl9097::SetSpareNoop11;

pub use cl9097::SetSpareNoop12;

pub use cl9097::SetSpareNoop13;

pub use cl9097::SetSpareNoop14;

pub use cl9097::SetSpareNoop15;

pub use cl9097::SetReduceColorThresholdsUnorm8;

pub use cl9097::SetReduceColorThresholdsUnorm10;

pub use cl9097::SetReduceColorThresholdsUnorm16;

pub use cl9097::SetReduceColorThresholdsFp11;

pub use cl9097::SetReduceColorThresholdsFp16;

pub use cl9097::SetReduceColorThresholdsSrgb8;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct UnbindAll {
    pub constant_buffers: bool,
}

impl Mthd for UnbindAll {
    const ADDR: u16 = 0x10f4;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.constant_buffers as u32) < (1 << 1));
        val |= (self.constant_buffers as u32) << 8;

        val
    }
}

pub use cl9097::SetClearSurfaceControl;

pub use cl9097::SetL2CacheControlForRopNoninterlockedReadRequests;
pub use cl9097::SetL2CacheControlForRopNoninterlockedReadRequestsPolicy;

pub use cl9097::NoOperationDataHi;

pub use cl9097::SetDepthBiasControl;

pub use cl9097::PmTriggerEnd;

pub use cl9097::SetVertexIdBase;

pub use cl9097::SetDaOutputAttributeSkipMaskA;

pub use cl9097::SetDaOutputAttributeSkipMaskB;

pub use cl9097::SetBlendPerFormatEnable;

pub use cl9097::FlushPendingWrites;

pub use cl9097::SetVabDataControl;
pub use cl9097::SetVabDataControlFormat;

pub use cl9097::SetVabData;

pub use cl9097::SetVertexAttributeA;
pub use cl9097::SetVertexAttributeAComponentBitWidths;
pub use cl9097::SetVertexAttributeANumericalType;
pub use cl9097::SetVertexAttributeASource;

pub use cl9097::SetVertexAttributeB;
pub use cl9097::SetVertexAttributeBComponentBitWidths;
pub use cl9097::SetVertexAttributeBNumericalType;
pub use cl9097::SetVertexAttributeBSource;

pub use cl9097::DrawVertexArrayBeginEndInstanceFirst;
pub use cl9097::DrawVertexArrayBeginEndInstanceFirstTopology;

pub use cl9097::DrawVertexArrayBeginEndInstanceSubsequent;
pub use cl9097::DrawVertexArrayBeginEndInstanceSubsequentTopology;

pub use cl9097::SetCtSelect;

pub use cl9097::SetCompressionThreshold;
pub use cl9097::SetCompressionThresholdSamples;

pub use cl9097::SetZtSizeA;

pub use cl9097::SetZtSizeB;

pub use cl9097::SetZtSizeC;
pub use cl9097::SetZtSizeCControl;

pub use cl9097::SetSamplerBinding;
pub use cl9097::SetSamplerBindingV;

pub use cl9097::DrawAuto;

pub use cl9097::SetCircularBufferSize;

pub use cl9097::SetVtgRegisterWatermarks;

pub use cl9097::InvalidateTextureDataCacheNoWfi;
pub use cl9097::InvalidateTextureDataCacheNoWfiLines;

pub use cl9097::SetL2CacheControlForRopInterlockedReadRequests;
pub use cl9097::SetL2CacheControlForRopInterlockedReadRequestsPolicy;

pub use cl9097::SetDaPrimitiveRestartIndexTopologyChange;

pub use cl9097::SetShaderScheduling;
pub use cl9097::SetShaderSchedulingMode;

pub use cl9097::ClearZcullRegion;

pub use cl9097::SetDepthTest;

pub use cl9097::SetFillMode;
pub use cl9097::SetFillModeV;

pub use cl9097::SetShadeMode;
pub use cl9097::SetShadeModeV;

pub use cl9097::SetL2CacheControlForRopNoninterlockedWriteRequests;
pub use cl9097::SetL2CacheControlForRopNoninterlockedWriteRequestsPolicy;

pub use cl9097::SetL2CacheControlForRopInterlockedWriteRequests;
pub use cl9097::SetL2CacheControlForRopInterlockedWriteRequestsPolicy;

pub use cl9097::SetAlphaToCoverageDitherControl;
pub use cl9097::SetAlphaToCoverageDitherControlDitherFootprint;

pub use cl9097::SetBlendStatePerTarget;

pub use cl9097::SetDepthWrite;

pub use cl9097::SetAlphaTest;

pub use cl9097::SetInlineIndex4X8Align;

pub use cl9097::DrawInlineIndex4X8;

pub use cl9097::D3DSetCullMode;
pub use cl9097::D3DSetCullModeV;

pub use cl9097::SetDepthFunc;
pub use cl9097::SetDepthFuncV;

pub use cl9097::SetAlphaRef;

pub use cl9097::SetAlphaFunc;
pub use cl9097::SetAlphaFuncV;

pub use cl9097::SetDrawAutoStride;

pub use cl9097::SetBlendConstRed;

pub use cl9097::SetBlendConstGreen;

pub use cl9097::SetBlendConstBlue;

pub use cl9097::SetBlendConstAlpha;

pub use cl9097::InvalidateSamplerCache;
pub use cl9097::InvalidateSamplerCacheLines;

pub use cl9097::InvalidateTextureHeaderCache;
pub use cl9097::InvalidateTextureHeaderCacheLines;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum InvalidateTextureDataCacheLines {
    All = 0x00000000,
    One = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct InvalidateTextureDataCache {
    pub lines: InvalidateTextureDataCacheLines,
    pub tag: u32,
}

impl Mthd for InvalidateTextureDataCache {
    const ADDR: u16 = 0x1338;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.lines as u32) < (1 << 1));
        val |= (self.lines as u32) << 0;

        assert!(self.tag < (1 << 22));
        val |= self.tag << 4;

        val
    }
}

pub use cl9097::SetBlendSeparateForAlpha;

pub use cl9097::SetBlendColorOp;
pub use cl9097::SetBlendColorOpV;

pub use cl9097::SetBlendColorSourceCoeff;
pub use cl9097::SetBlendColorSourceCoeffV;

pub use cl9097::SetBlendColorDestCoeff;
pub use cl9097::SetBlendColorDestCoeffV;

pub use cl9097::SetBlendAlphaOp;
pub use cl9097::SetBlendAlphaOpV;

pub use cl9097::SetBlendAlphaSourceCoeff;
pub use cl9097::SetBlendAlphaSourceCoeffV;

pub use cl9097::SetGlobalColorKey;

pub use cl9097::SetBlendAlphaDestCoeff;
pub use cl9097::SetBlendAlphaDestCoeffV;

pub use cl9097::SetSingleRopControl;

pub use cl9097::SetBlend;

pub use cl9097::SetStencilTest;

pub use cl9097::SetStencilOpFail;
pub use cl9097::SetStencilOpFailV;

pub use cl9097::SetStencilOpZfail;
pub use cl9097::SetStencilOpZfailV;

pub use cl9097::SetStencilOpZpass;
pub use cl9097::SetStencilOpZpassV;

pub use cl9097::SetStencilFunc;
pub use cl9097::SetStencilFuncV;

pub use cl9097::SetStencilFuncRef;

pub use cl9097::SetStencilFuncMask;

pub use cl9097::SetStencilMask;

pub use cl9097::SetDrawAutoStart;

pub use cl9097::SetPsSaturate;

pub use cl9097::SetWindowOrigin;
pub use cl9097::SetWindowOriginMode;

pub use cl9097::SetLineWidthFloat;

pub use cl9097::SetAliasedLineWidthFloat;

pub use cl9097::SetLineMultisampleOverride;

pub use cl9097::SetAlphaHysteresis;

pub use cl9097::InvalidateSamplerCacheNoWfi;
pub use cl9097::InvalidateSamplerCacheNoWfiLines;

pub use cl9097::InvalidateTextureHeaderCacheNoWfi;
pub use cl9097::InvalidateTextureHeaderCacheNoWfiLines;

pub use cl9097::InvalidateDaDmaCache;

pub use cl9097::SetGlobalBaseVertexIndex;

pub use cl9097::SetGlobalBaseInstanceIndex;

pub use cl9097::SetPsWarpWatermarks;

pub use cl9097::SetPsRegisterWatermarks;

pub use cl9097::StoreZcull;

pub use cl9097::LoadZcull;

pub use cl9097::SetSurfaceClipIdHeight;

pub use cl9097::SetClipIdClearRectHorizontal;

pub use cl9097::SetClipIdClearRectVertical;

pub use cl9097::SetUserClipEnable;

pub use cl9097::SetZpassPixelCount;

pub use cl9097::SetPointSize;

pub use cl9097::SetZcullStats;

pub use cl9097::SetPointSprite;

pub use cl9097::SetShaderExceptions;

pub use cl9097::ClearReportValue;
pub use cl9097::ClearReportValueType;

pub use cl9097::SetAntiAliasEnable;

pub use cl9097::SetZtSelect;

pub use cl9097::SetAntiAliasAlphaControl;
pub use cl9097::SetAntiAliasAlphaControlAlphaToCoverage;
pub use cl9097::SetAntiAliasAlphaControlAlphaToOne;

pub use cl9097::SetRenderEnableA;

pub use cl9097::SetRenderEnableB;

pub use cl9097::SetRenderEnableC;
pub use cl9097::SetRenderEnableCMode;

pub use cl9097::SetTexSamplerPoolA;

pub use cl9097::SetTexSamplerPoolB;

pub use cl9097::SetTexSamplerPoolC;

pub use cl9097::SetSlopeScaleDepthBias;

pub use cl9097::SetAntiAliasedLine;

pub use cl9097::SetTexHeaderPoolA;

pub use cl9097::SetTexHeaderPoolB;

pub use cl9097::SetTexHeaderPoolC;

pub use cl9097::SetActiveZcullRegion;

pub use cl9097::SetTwoSidedStencilTest;

pub use cl9097::SetBackStencilOpFail;
pub use cl9097::SetBackStencilOpFailV;

pub use cl9097::SetBackStencilOpZfail;
pub use cl9097::SetBackStencilOpZfailV;

pub use cl9097::SetBackStencilOpZpass;
pub use cl9097::SetBackStencilOpZpassV;

pub use cl9097::SetBackStencilFunc;
pub use cl9097::SetBackStencilFuncV;

pub use cl9097::SetSrgbWrite;

pub use cl9097::SetDepthBias;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetZcullRegionFormatType {
    Z4X4 = 0x00000000,
    Zs4X4 = 0x00000001,
    Z4X2 = 0x00000002,
    Z2X4 = 0x00000003,
    Z16X84X4 = 0x00000004,
    Z8X84X2 = 0x00000005,
    Z8X82X4 = 0x00000006,
    Z16X164X8 = 0x00000007,
    Z4X82X2 = 0x00000008,
    Zs16X84X2 = 0x00000009,
    Zs16X82X4 = 0x0000000a,
    Zs8X82X2 = 0x0000000b,
    Z4X81X1 = 0x0000000c,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetZcullRegionFormat {
    pub type_: SetZcullRegionFormatType,
}

impl Mthd for SetZcullRegionFormat {
    const ADDR: u16 = 0x15c8;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.type_ as u32) < (1 << 4));
        val |= (self.type_ as u32) << 0;

        val
    }
}

pub use cl9097::SetRtLayer;
pub use cl9097::SetRtLayerControl;

pub use cl9097::SetAntiAlias;
pub use cl9097::SetAntiAliasSamples;

pub use cl9097::SetEdgeFlag;

pub use cl9097::DrawInlineIndex;

pub use cl9097::SetInlineIndex2X16Align;

pub use cl9097::DrawInlineIndex2X16;

pub use cl9097::SetVertexGlobalBaseOffsetA;

pub use cl9097::SetVertexGlobalBaseOffsetB;

pub use cl9097::SetZcullRegionPixelOffsetA;

pub use cl9097::SetZcullRegionPixelOffsetB;

pub use cl9097::SetPointSpriteSelect;
pub use cl9097::SetPointSpriteSelectOrigin;
pub use cl9097::SetPointSpriteSelectRmode;
pub use cl9097::SetPointSpriteSelectTexture0;
pub use cl9097::SetPointSpriteSelectTexture1;
pub use cl9097::SetPointSpriteSelectTexture2;
pub use cl9097::SetPointSpriteSelectTexture3;
pub use cl9097::SetPointSpriteSelectTexture4;
pub use cl9097::SetPointSpriteSelectTexture5;
pub use cl9097::SetPointSpriteSelectTexture6;
pub use cl9097::SetPointSpriteSelectTexture7;
pub use cl9097::SetPointSpriteSelectTexture8;
pub use cl9097::SetPointSpriteSelectTexture9;

pub use cl9097::SetProgramRegionA;

pub use cl9097::SetProgramRegionB;

pub use cl9097::SetAttributeDefault;
pub use cl9097::SetAttributeDefaultColorFrontDiffuse;
pub use cl9097::SetAttributeDefaultColorFrontSpecular;
pub use cl9097::SetAttributeDefaultDx9Color0;
pub use cl9097::SetAttributeDefaultDx9Color1ToColor15;
pub use cl9097::SetAttributeDefaultFixedFncTexture;
pub use cl9097::SetAttributeDefaultGenericVector;

pub use cl9097::End;

pub use cl9097::Begin;
pub use cl9097::BeginInstanceId;
pub use cl9097::BeginOp;
pub use cl9097::BeginPrimitiveId;
pub use cl9097::BeginSplitMode;

pub use cl9097::SetVertexIdCopy;

pub use cl9097::AddToPrimitiveId;

pub use cl9097::LoadPrimitiveId;

pub use cl9097::SetShaderBasedCull;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for SetClassVersion {
    const ADDR: u16 = 0x1638;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

pub use cl9097::SetVabPage;
pub use cl9097::SetVabPageReadSelect;

pub use cl9097::DrawInlineVertex;

pub use cl9097::SetDaPrimitiveRestart;

pub use cl9097::SetDaPrimitiveRestartIndex;

pub use cl9097::SetDaOutput;

pub use cl9097::SetAntiAliasedPoint;

pub use cl9097::SetPointCenterMode;
pub use cl9097::SetPointCenterModeV;

pub use cl9097::SetLineSmoothParameters;
pub use cl9097::SetLineSmoothParametersFalloff;

pub use cl9097::SetLineStipple;

pub use cl9097::SetLineSmoothEdgeTable;

pub use cl9097::SetLineStippleParameters;

pub use cl9097::SetProvokingVertex;
pub use cl9097::SetProvokingVertexV;

pub use cl9097::SetTwoSidedLight;

pub use cl9097::SetPolygonStipple;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlDefaultPartial {
    Zero = 0x00000000,
    Infinity = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlFp32NanBehavior {
    Legacy = 0x00000000,
    Fp64Compatible = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetShaderControlFp32F2INanBehavior {
    PassZero = 0x00000000,
    PassIndefinite = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderControl {
    pub default_partial: SetShaderControlDefaultPartial,
    pub fp32_nan_behavior: SetShaderControlFp32NanBehavior,
    pub fp32_f2i_nan_behavior: SetShaderControlFp32F2INanBehavior,
}

impl Mthd for SetShaderControl {
    const ADDR: u16 = 0x1690;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.default_partial as u32) < (1 << 1));
        val |= (self.default_partial as u32) << 0;

        assert!((self.fp32_nan_behavior as u32) < (1 << 1));
        val |= (self.fp32_nan_behavior as u32) << 1;

        assert!((self.fp32_f2i_nan_behavior as u32) < (1 << 1));
        val |= (self.fp32_f2i_nan_behavior as u32) << 2;

        val
    }
}

pub use cl9097::LaunchVertex;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct CheckClassVersion {
    pub current: u32,
    pub oldest_supported: u32,
}

impl Mthd for CheckClassVersion {
    const ADDR: u16 = 0x16a0;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.current < (1 << 16));
        val |= self.current << 0;

        assert!(self.oldest_supported < (1 << 16));
        val |= self.oldest_supported << 16;

        val
    }
}

pub use cl9097::SetSphVersion;

pub use cl9097::CheckSphVersion;

pub use cl9097::SetAlphaToCoverageOverride;
pub use cl9097::SetAlphaToCoverageOverrideQualifyByAntiAliasEnable;
pub use cl9097::SetAlphaToCoverageOverrideQualifyByPsSampleMaskOutput;

pub use cl9097::SetPolygonStipplePattern;

pub use cl9097::SetAamVersion;

pub use cl9097::CheckAamVersion;

pub use cl9097::SetZtLayer;

pub use cl9097::SetVabMemoryAreaA;

pub use cl9097::SetVabMemoryAreaB;

pub use cl9097::SetVabMemoryAreaC;
pub use cl9097::SetVabMemoryAreaCSize;

pub use cl9097::SetIndexBufferA;

pub use cl9097::SetIndexBufferB;

pub use cl9097::SetIndexBufferC;

pub use cl9097::SetIndexBufferD;

pub use cl9097::SetIndexBufferE;
pub use cl9097::SetIndexBufferEIndexSize;

pub use cl9097::SetIndexBufferF;

pub use cl9097::DrawIndexBuffer;

pub use cl9097::DrawIndexBuffer32BeginEndInstanceFirst;
pub use cl9097::DrawIndexBuffer32BeginEndInstanceFirstTopology;

pub use cl9097::DrawIndexBuffer16BeginEndInstanceFirst;
pub use cl9097::DrawIndexBuffer16BeginEndInstanceFirstTopology;

pub use cl9097::DrawIndexBuffer8BeginEndInstanceFirst;
pub use cl9097::DrawIndexBuffer8BeginEndInstanceFirstTopology;

pub use cl9097::DrawIndexBuffer32BeginEndInstanceSubsequent;
pub use cl9097::DrawIndexBuffer32BeginEndInstanceSubsequentTopology;

pub use cl9097::DrawIndexBuffer16BeginEndInstanceSubsequent;
pub use cl9097::DrawIndexBuffer16BeginEndInstanceSubsequentTopology;

pub use cl9097::DrawIndexBuffer8BeginEndInstanceSubsequent;
pub use cl9097::DrawIndexBuffer8BeginEndInstanceSubsequentTopology;

pub use cl9097::SetDepthBiasClamp;

pub use cl9097::SetVertexStreamInstanceA;

pub use cl9097::SetVertexStreamInstanceB;

pub use cl9097::SetAttributePointSize;

pub use cl9097::OglSetCull;

pub use cl9097::OglSetFrontFace;
pub use cl9097::OglSetFrontFaceV;

pub use cl9097::OglSetCullFace;
pub use cl9097::OglSetCullFaceV;

pub use cl9097::SetViewportPixel;
pub use cl9097::SetViewportPixelCenter;

pub use cl9097::SetViewportScaleOffset;

pub use cl9097::InvalidateConstantBufferCache;

pub use cl9097::SetViewportClipControl;
pub use cl9097::SetViewportClipControlGeometryClip;
pub use cl9097::SetViewportClipControlGeometryGuardband;
pub use cl9097::SetViewportClipControlGeometryGuardbandZ;
pub use cl9097::SetViewportClipControlLinePointCullGuardband;
pub use cl9097::SetViewportClipControlPixelMaxZ;
pub use cl9097::SetViewportClipControlPixelMinZ;

pub use cl9097::SetUserClipOp;
pub use cl9097::SetUserClipOpPlane0;
pub use cl9097::SetUserClipOpPlane1;
pub use cl9097::SetUserClipOpPlane2;
pub use cl9097::SetUserClipOpPlane3;
pub use cl9097::SetUserClipOpPlane4;
pub use cl9097::SetUserClipOpPlane5;
pub use cl9097::SetUserClipOpPlane6;
pub use cl9097::SetUserClipOpPlane7;

pub use cl9097::SetRenderEnableOverride;
pub use cl9097::SetRenderEnableOverrideMode;

pub use cl9097::SetPrimitiveTopologyControl;
pub use cl9097::SetPrimitiveTopologyControlOverride;

pub use cl9097::SetWindowClipEnable;

pub use cl9097::SetWindowClipType;
pub use cl9097::SetWindowClipTypeV;

pub use cl9097::InvalidateZcull;
pub use cl9097::InvalidateZcullV;

pub use cl9097::SetZcull;

pub use cl9097::SetZcullBounds;

pub use cl9097::SetPrimitiveTopology;
pub use cl9097::SetPrimitiveTopologyV;

pub use cl9097::ZcullSync;

pub use cl9097::SetClipIdTest;

pub use cl9097::SetSurfaceClipIdWidth;

pub use cl9097::SetClipId;

pub use cl9097::SetDepthBoundsTest;

pub use cl9097::SetBlendFloatOption;

pub use cl9097::SetLogicOp;

pub use cl9097::SetLogicOpFunc;
pub use cl9097::SetLogicOpFuncV;

pub use cl9097::SetZCompression;

pub use cl9097::ClearSurface;

pub use cl9097::ClearClipIdSurface;

pub use cl9097::SetColorCompression;

pub use cl9097::SetCtWrite;

pub use cl9097::PipeNop;

pub use cl9097::SetSpare00;

pub use cl9097::SetSpare01;

pub use cl9097::SetSpare02;

pub use cl9097::SetSpare03;

pub use cl9097::SetReportSemaphoreA;

pub use cl9097::SetReportSemaphoreB;

pub use cl9097::SetReportSemaphoreC;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDOperation {
    Release = 0x00000000,
    Acquire = 0x00000001,
    ReportOnly = 0x00000002,
    Trap = 0x00000003,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDRelease {
    AfterAllPreceedingReadsComplete = 0x00000000,
    AfterAllPreceedingWritesComplete = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDAcquire {
    BeforeAnyFollowingWritesStart = 0x00000000,
    BeforeAnyFollowingReadsStart = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDPipelineLocation {
    None = 0x00000000,
    DataAssembler = 0x00000001,
    VertexShader = 0x00000002,
    TesselationInitShader = 0x00000008,
    TesselationShader = 0x00000009,
    GeometryShader = 0x00000006,
    StreamingOutput = 0x00000005,
    Vpc = 0x00000004,
    Zcull = 0x00000007,
    PixelShader = 0x0000000a,
    DepthTest = 0x0000000c,
    All = 0x0000000f,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDComparison {
    Eq = 0x00000000,
    Ge = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReport {
    None = 0x00000000,
    DaVerticesGenerated = 0x00000001,
    DaPrimitivesGenerated = 0x00000003,
    VsInvocations = 0x00000005,
    TiInvocations = 0x0000001b,
    TsInvocations = 0x0000001d,
    TsPrimitivesGenerated = 0x0000001f,
    GsInvocations = 0x00000007,
    GsPrimitivesGenerated = 0x00000009,
    AlphaBetaClocks = 0x00000004,
    VtgPrimitivesOut = 0x00000012,
    TotalStreamingPrimitivesNeededMinusSucceeded = 0x0000001e,
    StreamingPrimitivesSucceeded = 0x0000000b,
    StreamingPrimitivesNeeded = 0x0000000d,
    StreamingPrimitivesNeededMinusSucceeded = 0x00000006,
    StreamingByteCount = 0x0000001a,
    ClipperInvocations = 0x0000000f,
    ClipperPrimitivesGenerated = 0x00000011,
    ZcullStats0 = 0x0000000a,
    ZcullStats1 = 0x0000000c,
    ZcullStats2 = 0x0000000e,
    ZcullStats3 = 0x00000010,
    PsInvocations = 0x00000013,
    ZpassPixelCnt = 0x00000002,
    ZpassPixelCnt64 = 0x00000015,
    IeeeCleanColorTarget = 0x00000018,
    IeeeCleanZetaTarget = 0x00000019,
    BoundingRectangle = 0x0000001c,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDStructureSize {
    FourWords = 0x00000000,
    OneWord = 0x00000001,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionOp {
    RedAdd = 0x00000000,
    RedMin = 0x00000001,
    RedMax = 0x00000002,
    RedInc = 0x00000003,
    RedDec = 0x00000004,
    RedAnd = 0x00000005,
    RedOr = 0x00000006,
    RedXor = 0x00000007,
}
#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SetReportSemaphoreDReductionFormat {
    Unsigned32 = 0x00000000,
    Signed32 = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetReportSemaphoreD {
    pub operation: SetReportSemaphoreDOperation,
    pub release: SetReportSemaphoreDRelease,
    pub acquire: SetReportSemaphoreDAcquire,
    pub pipeline_location: SetReportSemaphoreDPipelineLocation,
    pub comparison: SetReportSemaphoreDComparison,
    pub awaken_enable: bool,
    pub report: SetReportSemaphoreDReport,
    pub structure_size: SetReportSemaphoreDStructureSize,
    pub sub_report: u32,
    pub report_dword_number: u32,
    pub flush_disable: bool,
    pub reduction_enable: bool,
    pub reduction_op: SetReportSemaphoreDReductionOp,
    pub reduction_format: SetReportSemaphoreDReductionFormat,
}

impl Mthd for SetReportSemaphoreD {
    const ADDR: u16 = 0x1b0c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.operation as u32) < (1 << 2));
        val |= (self.operation as u32) << 0;

        assert!((self.release as u32) < (1 << 1));
        val |= (self.release as u32) << 4;

        assert!((self.acquire as u32) < (1 << 1));
        val |= (self.acquire as u32) << 8;

        assert!((self.pipeline_location as u32) < (1 << 4));
        val |= (self.pipeline_location as u32) << 12;

        assert!((self.comparison as u32) < (1 << 1));
        val |= (self.comparison as u32) << 16;

        assert!((self.awaken_enable as u32) < (1 << 1));
        val |= (self.awaken_enable as u32) << 20;

        assert!((self.report as u32) < (1 << 5));
        val |= (self.report as u32) << 23;

        assert!((self.structure_size as u32) < (1 << 1));
        val |= (self.structure_size as u32) << 28;

        assert!(self.sub_report < (1 << 3));
        val |= self.sub_report << 5;

        assert!(self.report_dword_number < (1 << 1));
        val |= self.report_dword_number << 21;

        assert!((self.flush_disable as u32) < (1 << 1));
        val |= (self.flush_disable as u32) << 2;

        assert!((self.reduction_enable as u32) < (1 << 1));
        val |= (self.reduction_enable as u32) << 3;

        assert!((self.reduction_op as u32) < (1 << 3));
        val |= (self.reduction_op as u32) << 9;

        assert!((self.reduction_format as u32) < (1 << 2));
        val |= (self.reduction_format as u32) << 17;

        val
    }
}

pub use cl9097::SetVertexStreamAFormat;

pub use cl9097::SetVertexStreamALocationA;

pub use cl9097::SetVertexStreamALocationB;

pub use cl9097::SetVertexStreamAFrequency;

pub use cl9097::SetVertexStreamBFormat;

pub use cl9097::SetVertexStreamBLocationA;

pub use cl9097::SetVertexStreamBLocationB;

pub use cl9097::SetVertexStreamBFrequency;

pub use cl9097::SetBlendPerTargetSeparateForAlpha;

pub use cl9097::SetBlendPerTargetColorOp;
pub use cl9097::SetBlendPerTargetColorOpV;

pub use cl9097::SetBlendPerTargetColorSourceCoeff;
pub use cl9097::SetBlendPerTargetColorSourceCoeffV;

pub use cl9097::SetBlendPerTargetColorDestCoeff;
pub use cl9097::SetBlendPerTargetColorDestCoeffV;

pub use cl9097::SetBlendPerTargetAlphaOp;
pub use cl9097::SetBlendPerTargetAlphaOpV;

pub use cl9097::SetBlendPerTargetAlphaSourceCoeff;
pub use cl9097::SetBlendPerTargetAlphaSourceCoeffV;

pub use cl9097::SetBlendPerTargetAlphaDestCoeff;
pub use cl9097::SetBlendPerTargetAlphaDestCoeffV;

pub use cl9097::SetVertexStreamLimitAA;

pub use cl9097::SetVertexStreamLimitAB;

pub use cl9097::SetVertexStreamLimitBA;

pub use cl9097::SetVertexStreamLimitBB;

pub use cl9097::SetPipelineShader;
pub use cl9097::SetPipelineShaderType;

pub use cl9097::SetPipelineProgram;

pub use cl9097::SetPipelineReservedA;

pub use cl9097::SetPipelineRegisterCount;

pub use cl9097::SetPipelineBinding;

pub use cl9097::SetPipelineReservedB;

pub use cl9097::SetPipelineReservedC;

pub use cl9097::SetPipelineReservedD;

pub use cl9097::SetPipelineReservedE;

pub use cl9097::SetFalcon00;

pub use cl9097::SetFalcon01;

pub use cl9097::SetFalcon02;

pub use cl9097::SetFalcon03;

pub use cl9097::SetFalcon04;

pub use cl9097::SetFalcon05;

pub use cl9097::SetFalcon06;

pub use cl9097::SetFalcon07;

pub use cl9097::SetFalcon08;

pub use cl9097::SetFalcon09;

pub use cl9097::SetFalcon10;

pub use cl9097::SetFalcon11;

pub use cl9097::SetFalcon12;

pub use cl9097::SetFalcon13;

pub use cl9097::SetFalcon14;

pub use cl9097::SetFalcon15;

pub use cl9097::SetFalcon16;

pub use cl9097::SetFalcon17;

pub use cl9097::SetFalcon18;

pub use cl9097::SetFalcon19;

pub use cl9097::SetFalcon20;

pub use cl9097::SetFalcon21;

pub use cl9097::SetFalcon22;

pub use cl9097::SetFalcon23;

pub use cl9097::SetFalcon24;

pub use cl9097::SetFalcon25;

pub use cl9097::SetFalcon26;

pub use cl9097::SetFalcon27;

pub use cl9097::SetFalcon28;

pub use cl9097::SetFalcon29;

pub use cl9097::SetFalcon30;

pub use cl9097::SetFalcon31;

pub use cl9097::SetConstantBufferSelectorA;

pub use cl9097::SetConstantBufferSelectorB;

pub use cl9097::SetConstantBufferSelectorC;

pub use cl9097::LoadConstantBufferOffset;

pub use cl9097::LoadConstantBuffer;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedA {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x2400 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedB {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x2404 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedC {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedC {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x2408 + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct BindGroupReservedD {
    pub v: u32,
}

impl ArrayMthd for BindGroupReservedD {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x240c + i * 32).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.v < (1 << 1));
        val |= self.v << 0;

        val
    }
}

pub use cl9097::BindGroupConstantBuffer;

pub use cl9097::SetColorClamp;

#[repr(u16)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum NoopXXXSetValveHigherPriority {
    Compute = 0x00000000,
    Graphics = 0x00000001,
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct NoopXXXSetValve {
    pub higher_priority: NoopXXXSetValveHigherPriority,
}

impl Mthd for NoopXXXSetValve {
    const ADDR: u16 = 0x2604;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!((self.higher_priority as u32) < (1 << 1));
        val |= (self.higher_priority as u32) << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetBindlessTexture {
    pub constant_buffer_slot_select: u32,
}

impl Mthd for SetBindlessTexture {
    const ADDR: u16 = 0x2608;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.constant_buffer_slot_select < (1 << 5));
        val |= self.constant_buffer_slot_select << 0;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetTrapHandler {
    pub offset: u32,
}

impl Mthd for SetTrapHandler {
    const ADDR: u16 = 0x260c;
    const CLASS: u16 = 0xa097;

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        val |= self.offset;

        val
    }
}

pub use cl9097::SetShaderPerformanceCounterValue;

pub use cl9097::SetShaderPerformanceCounterEvent;

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlA {
    pub event0: u32,
    pub bit_select0: u32,
    pub event1: u32,
    pub bit_select1: u32,
    pub event2: u32,
    pub bit_select2: u32,
    pub event3: u32,
    pub bit_select3: u32,
    pub event4: u32,
    pub bit_select4: u32,
    pub event5: u32,
    pub bit_select5: u32,
    pub spare: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlA {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x339c + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.event0 < (1 << 2));
        val |= self.event0 << 0;

        assert!(self.bit_select0 < (1 << 3));
        val |= self.bit_select0 << 2;

        assert!(self.event1 < (1 << 2));
        val |= self.event1 << 5;

        assert!(self.bit_select1 < (1 << 3));
        val |= self.bit_select1 << 7;

        assert!(self.event2 < (1 << 2));
        val |= self.event2 << 10;

        assert!(self.bit_select2 < (1 << 3));
        val |= self.bit_select2 << 12;

        assert!(self.event3 < (1 << 2));
        val |= self.event3 << 15;

        assert!(self.bit_select3 < (1 << 3));
        val |= self.bit_select3 << 17;

        assert!(self.event4 < (1 << 2));
        val |= self.event4 << 20;

        assert!(self.bit_select4 < (1 << 3));
        val |= self.bit_select4 << 22;

        assert!(self.event5 < (1 << 2));
        val |= self.event5 << 25;

        assert!(self.bit_select5 < (1 << 3));
        val |= self.bit_select5 << 27;

        assert!(self.spare < (1 << 2));
        val |= self.spare << 30;

        val
    }
}

#[derive(Copy, Clone, Debug, PartialEq)]
pub struct SetShaderPerformanceCounterControlB {
    pub edge: u32,
    pub mode: u32,
    pub windowed: u32,
    pub func: u32,
}

impl ArrayMthd for SetShaderPerformanceCounterControlB {
    const CLASS: u16 = 0xa097;

    fn addr(i: usize) -> u16 {
        (0x33bc + i * 4).try_into().unwrap()
    }

    #[inline]
    fn to_bits(self) -> u32 {
        let mut val = 0;

        assert!(self.edge < (1 << 1));
        val |= self.edge << 0;

        assert!(self.mode < (1 << 2));
        val |= self.mode << 1;

        assert!(self.windowed < (1 << 1));
        val |= self.windowed << 3;

        assert!(self.func < (1 << 16));
        val |= self.func << 4;

        val
    }
}

pub use cl9097::SetShaderPerformanceCounterTrapControl;

pub use cl9097::SetMmeShadowScratch;

pub use cl9097::CallMmeMacro;

pub use cl9097::CallMmeData;
